/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "mplay_appcontrol_fi_typesConst.h"
#include <cstddef>

/**
 * Types mplay_appcontrol_fi_types
 */

using namespace ::asf::stream::json;

namespace mplay_appcontrol_fi_types {

bool T_e8_AccessoryPowerMode_Parse (const char *str, size_t length, T_e8_AccessoryPowerMode &value)
{
    static stringEntry entries[] = {
        {19,"E8DIPO_APM_RESERVED", 0U},
        {25,"E8DIPO_APM_LOW_POWER_MODE", 1U},
        {39,"E8DIPO_APM_INTERMITTENT_HIGH_POWER_MODE", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_AccessoryPowerMode_Name (T_e8_AccessoryPowerMode value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_APM_RESERVED",
        "e8DIPO_APM_LOW_POWER_MODE",
        "e8DIPO_APM_INTERMITTENT_HIGH_POWER_MODE",
    };

    if (T_e8_AccessoryPowerMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AccessoryPowerMode_IsValid (T_e8_AccessoryPowerMode value)
{
    switch (value) {
    case T_e8_AccessoryPowerMode__e8DIPO_APM_INTERMITTENT_HIGH_POWER_MODE:
    case T_e8_AccessoryPowerMode__e8DIPO_APM_LOW_POWER_MODE:
    case T_e8_AccessoryPowerMode__e8DIPO_APM_RESERVED:
        return true;
    default:
        return false;
    }
}

bool T_e8_BatteryChargingState_Parse (const char *str, size_t length, T_e8_BatteryChargingState &value)
{
    static stringEntry entries[] = {
        {18,"E8DIPO_BCS_CHARGED", 2U},
        {19,"E8DIPO_BCS_CHARGING", 1U},
        {19,"E8DIPO_BCS_DISABLED", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_BatteryChargingState_Name (T_e8_BatteryChargingState value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_BCS_DISABLED",
        "e8DIPO_BCS_CHARGING",
        "e8DIPO_BCS_CHARGED",
    };

    if (T_e8_BatteryChargingState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_BatteryChargingState_IsValid (T_e8_BatteryChargingState value)
{
    switch (value) {
    case T_e8_BatteryChargingState__e8DIPO_BCS_CHARGED:
    case T_e8_BatteryChargingState__e8DIPO_BCS_CHARGING:
    case T_e8_BatteryChargingState__e8DIPO_BCS_DISABLED:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPODeviceType_Parse (const char *str, size_t length, T_e8_DiPODeviceType &value)
{
    static stringEntry entries[] = {
        {8,"E8DTY_SD", 3U},
        {9,"E8DTY_MTP", 6U},
        {9,"E8DTY_USB", 1U},
        {10,"E8DTY_IPOD", 2U},
        {11,"E8DTY_CDROM", 7U},
        {11,"E8DTY_FLASH", 8U},
        {12,"E8DTY_IPHONE", 5U},
        {13,"E8DTY_UNKNOWN", 0U},
        {15,"E8DTY_BLUETOOTH", 4U},
        {17,"E8DTY_UNSUPPORTED", 9U},
    };

    return lookupInStringEntryTable (str, length, entries, 10, (unsigned int&) value);
}

const char* T_e8_DiPODeviceType_Name (T_e8_DiPODeviceType value)
{
    static const char* enumerationLiterals[] = {
        "e8DTY_UNKNOWN",
        "e8DTY_USB",
        "e8DTY_IPOD",
        "e8DTY_SD",
        "e8DTY_BLUETOOTH",
        "e8DTY_IPHONE",
        "e8DTY_MTP",
        "e8DTY_CDROM",
        "e8DTY_FLASH",
        "e8DTY_UNSUPPORTED",
    };

    if (T_e8_DiPODeviceType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPODeviceType_IsValid (T_e8_DiPODeviceType value)
{
    switch (value) {
    case T_e8_DiPODeviceType__e8DTY_UNKNOWN:
    case T_e8_DiPODeviceType__e8DTY_USB:
    case T_e8_DiPODeviceType__e8DTY_IPOD:
    case T_e8_DiPODeviceType__e8DTY_SD:
    case T_e8_DiPODeviceType__e8DTY_BLUETOOTH:
    case T_e8_DiPODeviceType__e8DTY_IPHONE:
    case T_e8_DiPODeviceType__e8DTY_MTP:
    case T_e8_DiPODeviceType__e8DTY_CDROM:
    case T_e8_DiPODeviceType__e8DTY_FLASH:
    case T_e8_DiPODeviceType__e8DTY_UNSUPPORTED:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPOConnectionType_Parse (const char *str, size_t length, T_e8_DiPOConnectionType &value)
{
    static stringEntry entries[] = {
        {9,"E8DCT_USB", 1U},
        {10,"E8DCT_WIFI", 5U},
        {11,"E8DCT_CDROM", 3U},
        {11,"E8DCT_FLASH", 4U},
        {13,"E8DCT_UNKNOWN", 0U},
        {15,"E8DCT_BLUETOOTH", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_DiPOConnectionType_Name (T_e8_DiPOConnectionType value)
{
    static const char* enumerationLiterals[] = {
        "e8DCT_UNKNOWN",
        "e8DCT_USB",
        "e8DCT_BLUETOOTH",
        "e8DCT_CDROM",
        "e8DCT_FLASH",
        "e8DCT_WIFI",
    };

    if (T_e8_DiPOConnectionType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPOConnectionType_IsValid (T_e8_DiPOConnectionType value)
{
    switch (value) {
    case T_e8_DiPOConnectionType__e8DCT_UNKNOWN:
    case T_e8_DiPOConnectionType__e8DCT_USB:
    case T_e8_DiPOConnectionType__e8DCT_BLUETOOTH:
    case T_e8_DiPOConnectionType__e8DCT_CDROM:
    case T_e8_DiPOConnectionType__e8DCT_FLASH:
    case T_e8_DiPOConnectionType__e8DCT_WIFI:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPOConnectionState_Parse (const char *str, size_t length, T_e8_DiPOConnectionState &value)
{
    static stringEntry entries[] = {
        {12,"E8CS_ON_HOLD", 7U},
        {13,"E8CS_ATTACHED", 1U},
        {13,"E8CS_OVERTEMP", 6U},
        {14,"E8CS_CONNECTED", 0U},
        {14,"E8CS_UNDEFINED", 8U},
        {16,"E8CS_UNSUPPORTED", 5U},
        {17,"E8CS_DISCONNECTED", 2U},
        {17,"E8CS_UNDERVOLTAGE", 4U},
        {19,"E8CS_HW_MALFUNCTION", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 9, (unsigned int&) value);
}

const char* T_e8_DiPOConnectionState_Name (T_e8_DiPOConnectionState value)
{
    static const char* enumerationLiterals[] = {
        "e8CS_CONNECTED",
        "e8CS_ATTACHED",
        "e8CS_DISCONNECTED",
        "e8CS_HW_MALFUNCTION",
        "e8CS_UNDERVOLTAGE",
        "e8CS_UNSUPPORTED",
        "e8CS_OVERTEMP",
        "e8CS_ON_HOLD",
        "e8CS_UNDEFINED",
    };

    if (T_e8_DiPOConnectionState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPOConnectionState_IsValid (T_e8_DiPOConnectionState value)
{
    switch (value) {
    case T_e8_DiPOConnectionState__e8CS_CONNECTED:
    case T_e8_DiPOConnectionState__e8CS_ATTACHED:
    case T_e8_DiPOConnectionState__e8CS_DISCONNECTED:
    case T_e8_DiPOConnectionState__e8CS_HW_MALFUNCTION:
    case T_e8_DiPOConnectionState__e8CS_UNDERVOLTAGE:
    case T_e8_DiPOConnectionState__e8CS_UNSUPPORTED:
    case T_e8_DiPOConnectionState__e8CS_OVERTEMP:
    case T_e8_DiPOConnectionState__e8CS_ON_HOLD:
    case T_e8_DiPOConnectionState__e8CS_UNDEFINED:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPOCaps_Parse (const char *str, size_t length, T_e8_DiPOCaps &value)
{
    static stringEntry entries[] = {
        {15,"E8DIPO_CAP_NONE", 0U},
        {17,"E8DIPO_CAP_IAP2BT", 9U},
        {18,"E8DIPO_CAP_CARLIFE", 10U},
        {18,"E8DIPO_CAP_CARPLAY", 1U},
        {23,"E8DIPO_CAP_CARPLAY_WIFI", 8U},
        {27,"E8DIPO_CAP_CARPLAY_FEASIBLE", 5U},
        {27,"E8DIPO_CAP_NATIVE_TRANSPORT", 2U},
        {28,"E8DIPO_CAP_HOSTMODE_FEASIBLE", 4U},
        {32,"E8DIPO_CAP_CARPLAY_WIFI_FEASIBLE", 6U},
        {35,"E8DIPO_CAP_CARPLAY_NATIVE_TRANSPORT", 3U},
        {36,"E8DIPO_CAP_CARPLAY_WIFI_NOT_FEASIBLE", 7U},
    };

    return lookupInStringEntryTable (str, length, entries, 11, (unsigned int&) value);
}

const char* T_e8_DiPOCaps_Name (T_e8_DiPOCaps value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_CAP_NONE",
        "e8DIPO_CAP_CARPLAY",
        "e8DIPO_CAP_NATIVE_TRANSPORT",
        "e8DIPO_CAP_CARPLAY_NATIVE_TRANSPORT",
        "e8DIPO_CAP_HOSTMODE_FEASIBLE",
        "e8DIPO_CAP_CARPLAY_FEASIBLE",
        "e8DIPO_CAP_CARPLAY_WIFI_FEASIBLE",
        "e8DIPO_CAP_CARPLAY_WIFI_NOT_FEASIBLE",
        "e8DIPO_CAP_CARPLAY_WIFI",
        "e8DIPO_CAP_IAP2BT",
        "e8DIPO_CAP_CARLIFE",
    };

    if (T_e8_DiPOCaps_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPOCaps_IsValid (T_e8_DiPOCaps value)
{
    switch (value) {
    case T_e8_DiPOCaps__e8DIPO_CAP_NONE:
    case T_e8_DiPOCaps__e8DIPO_CAP_CARPLAY:
    case T_e8_DiPOCaps__e8DIPO_CAP_NATIVE_TRANSPORT:
    case T_e8_DiPOCaps__e8DIPO_CAP_CARPLAY_NATIVE_TRANSPORT:
    case T_e8_DiPOCaps__e8DIPO_CAP_HOSTMODE_FEASIBLE:
    case T_e8_DiPOCaps__e8DIPO_CAP_CARPLAY_FEASIBLE:
    case T_e8_DiPOCaps__e8DIPO_CAP_CARPLAY_WIFI_FEASIBLE:
    case T_e8_DiPOCaps__e8DIPO_CAP_CARPLAY_WIFI_NOT_FEASIBLE:
    case T_e8_DiPOCaps__e8DIPO_CAP_CARPLAY_WIFI:
    case T_e8_DiPOCaps__e8DIPO_CAP_IAP2BT:
    case T_e8_DiPOCaps__e8DIPO_CAP_CARLIFE:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPODeviceStatus_Parse (const char *str, size_t length, T_e8_DiPODeviceStatus &value)
{
    static stringEntry entries[] = {
        {7,"E8DS_OK", 2U},
        {9,"E8DS_NONE", 0U},
        {16,"E8DS_UNSUPPORTED", 3U},
        {17,"E8DS_INITIALIZING", 1U},
        {24,"E8DS_COMMUNICATION_ERROR", 6U},
        {26,"E8DS_UNSUPPORTED_PARTITION", 5U},
        {27,"E8DS_UNSUPPORTED_FILESYSTEM", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 7, (unsigned int&) value);
}

const char* T_e8_DiPODeviceStatus_Name (T_e8_DiPODeviceStatus value)
{
    static const char* enumerationLiterals[] = {
        "e8DS_NONE",
        "e8DS_INITIALIZING",
        "e8DS_OK",
        "e8DS_UNSUPPORTED",
        "e8DS_UNSUPPORTED_FILESYSTEM",
        "e8DS_UNSUPPORTED_PARTITION",
        "e8DS_COMMUNICATION_ERROR",
    };

    if (T_e8_DiPODeviceStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPODeviceStatus_IsValid (T_e8_DiPODeviceStatus value)
{
    switch (value) {
    case T_e8_DiPODeviceStatus__e8DS_NONE:
    case T_e8_DiPODeviceStatus__e8DS_INITIALIZING:
    case T_e8_DiPODeviceStatus__e8DS_OK:
    case T_e8_DiPODeviceStatus__e8DS_UNSUPPORTED:
    case T_e8_DiPODeviceStatus__e8DS_UNSUPPORTED_FILESYSTEM:
    case T_e8_DiPODeviceStatus__e8DS_UNSUPPORTED_PARTITION:
    case T_e8_DiPODeviceStatus__e8DS_COMMUNICATION_ERROR:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPOPlaypackAction_Parse (const char *str, size_t length, T_e8_DiPOPlaypackAction &value)
{
    static stringEntry entries[] = {
        {15,"E8DIPO_PBA_NEXT", 4U},
        {15,"E8DIPO_PBA_PLAY", 0U},
        {15,"E8DIPO_PBA_PREV", 3U},
        {15,"E8DIPO_PBA_STOP", 2U},
        {16,"E8DIPO_PBA_PAUSE", 1U},
        {20,"E8DIPO_PBA_FFWD_STOP", 8U},
        {20,"E8DIPO_PBA_FREV_STOP", 6U},
        {21,"E8DIPO_PBA_FFWD_START", 7U},
        {21,"E8DIPO_PBA_FREV_START", 5U},
    };

    return lookupInStringEntryTable (str, length, entries, 9, (unsigned int&) value);
}

const char* T_e8_DiPOPlaypackAction_Name (T_e8_DiPOPlaypackAction value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_PBA_PLAY",
        "e8DIPO_PBA_PAUSE",
        "e8DIPO_PBA_STOP",
        "e8DIPO_PBA_PREV",
        "e8DIPO_PBA_NEXT",
        "e8DIPO_PBA_FREV_START",
        "e8DIPO_PBA_FREV_STOP",
        "e8DIPO_PBA_FFWD_START",
        "e8DIPO_PBA_FFWD_STOP",
    };

    if (T_e8_DiPOPlaypackAction_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPOPlaypackAction_IsValid (T_e8_DiPOPlaypackAction value)
{
    switch (value) {
    case T_e8_DiPOPlaypackAction__e8DIPO_PBA_PLAY:
    case T_e8_DiPOPlaypackAction__e8DIPO_PBA_PAUSE:
    case T_e8_DiPOPlaypackAction__e8DIPO_PBA_STOP:
    case T_e8_DiPOPlaypackAction__e8DIPO_PBA_PREV:
    case T_e8_DiPOPlaypackAction__e8DIPO_PBA_NEXT:
    case T_e8_DiPOPlaypackAction__e8DIPO_PBA_FREV_START:
    case T_e8_DiPOPlaypackAction__e8DIPO_PBA_FREV_STOP:
    case T_e8_DiPOPlaypackAction__e8DIPO_PBA_FFWD_START:
    case T_e8_DiPOPlaypackAction__e8DIPO_PBA_FFWD_STOP:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPOPlaybackStatus_Parse (const char *str, size_t length, T_e8_DiPOPlaybackStatus &value)
{
    static stringEntry entries[] = {
        {17,"E8DIPO_PBS_PAUSED", 2U},
        {18,"E8DIPO_PBS_PLAYING", 1U},
        {18,"E8DIPO_PBS_STOPPED", 0U},
        {22,"E8DIPO_PBS_SEEKFORWARD", 3U},
        {23,"E8DIPO_PBS_SEEKBACKWARD", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_DiPOPlaybackStatus_Name (T_e8_DiPOPlaybackStatus value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_PBS_STOPPED",
        "e8DIPO_PBS_PLAYING",
        "e8DIPO_PBS_PAUSED",
        "e8DIPO_PBS_SEEKFORWARD",
        "e8DIPO_PBS_SEEKBACKWARD",
    };

    if (T_e8_DiPOPlaybackStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPOPlaybackStatus_IsValid (T_e8_DiPOPlaybackStatus value)
{
    switch (value) {
    case T_e8_DiPOPlaybackStatus__e8DIPO_PBS_STOPPED:
    case T_e8_DiPOPlaybackStatus__e8DIPO_PBS_PLAYING:
    case T_e8_DiPOPlaybackStatus__e8DIPO_PBS_PAUSED:
    case T_e8_DiPOPlaybackStatus__e8DIPO_PBS_SEEKFORWARD:
    case T_e8_DiPOPlaybackStatus__e8DIPO_PBS_SEEKBACKWARD:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPOPlaybackShuffleMode_Parse (const char *str, size_t length, T_e8_DiPOPlaybackShuffleMode &value)
{
    static stringEntry entries[] = {
        {15,"E8DIPO_PBSM_OFF", 0U},
        {17,"E8DIPO_PBSM_SONGS", 1U},
        {18,"E8DIPO_PBSM_ALBUMS", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_DiPOPlaybackShuffleMode_Name (T_e8_DiPOPlaybackShuffleMode value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_PBSM_OFF",
        "e8DIPO_PBSM_SONGS",
        "e8DIPO_PBSM_ALBUMS",
    };

    if (T_e8_DiPOPlaybackShuffleMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPOPlaybackShuffleMode_IsValid (T_e8_DiPOPlaybackShuffleMode value)
{
    switch (value) {
    case T_e8_DiPOPlaybackShuffleMode__e8DIPO_PBSM_OFF:
    case T_e8_DiPOPlaybackShuffleMode__e8DIPO_PBSM_SONGS:
    case T_e8_DiPOPlaybackShuffleMode__e8DIPO_PBSM_ALBUMS:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPOPlaybackRepeatMode_Parse (const char *str, size_t length, T_e8_DiPOPlaybackRepeatMode &value)
{
    static stringEntry entries[] = {
        {15,"E8DIPO_PBRM_ALL", 2U},
        {15,"E8DIPO_PBRM_OFF", 0U},
        {15,"E8DIPO_PBRM_ONE", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_DiPOPlaybackRepeatMode_Name (T_e8_DiPOPlaybackRepeatMode value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_PBRM_OFF",
        "e8DIPO_PBRM_ONE",
        "e8DIPO_PBRM_ALL",
    };

    if (T_e8_DiPOPlaybackRepeatMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPOPlaybackRepeatMode_IsValid (T_e8_DiPOPlaybackRepeatMode value)
{
    switch (value) {
    case T_e8_DiPOPlaybackRepeatMode__e8DIPO_PBRM_OFF:
    case T_e8_DiPOPlaybackRepeatMode__e8DIPO_PBRM_ONE:
    case T_e8_DiPOPlaybackRepeatMode__e8DIPO_PBRM_ALL:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPOResponse_Parse (const char *str, size_t length, T_e8_DiPOResponse &value)
{
    static stringEntry entries[] = {
        {9,"E8DIPO_OK", 0U},
        {20,"E8DIPO_ERROR_UNKNOWN", 1U},
        {25,"E8DIPO_ERROR_NOTSUPPORTED", 3U},
        {26,"E8DIPO_ERROR_INVALIDHANLDE", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_DiPOResponse_Name (T_e8_DiPOResponse value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_OK",
        "e8DIPO_ERROR_UNKNOWN",
        "e8DIPO_ERROR_INVALIDHANLDE",
        "e8DIPO_ERROR_NOTSUPPORTED",
    };

    if (T_e8_DiPOResponse_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPOResponse_IsValid (T_e8_DiPOResponse value)
{
    switch (value) {
    case T_e8_DiPOResponse__e8DIPO_OK:
    case T_e8_DiPOResponse__e8DIPO_ERROR_UNKNOWN:
    case T_e8_DiPOResponse__e8DIPO_ERROR_INVALIDHANLDE:
    case T_e8_DiPOResponse__e8DIPO_ERROR_NOTSUPPORTED:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPORoleStatus_Parse (const char *str, size_t length, T_e8_DiPORoleStatus &value)
{
    static stringEntry entries[] = {
        {15,"E8DIPO_HOSTMODE", 1U},
        {17,"E8DIPO_CLIENTMODE", 0U},
        {19,"E8DIPO_CARPLAY_MODE", 2U},
        {28,"E8DIPO_NATIVE_TRANSPORT_MODE", 3U},
        {36,"E8DIPO_CARLIFE_NATIVE_TRANSPORT_MODE", 5U},
        {36,"E8DIPO_CARPLAY_NATIVE_TRANSPORT_MODE", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_DiPORoleStatus_Name (T_e8_DiPORoleStatus value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_CLIENTMODE",
        "e8DIPO_HOSTMODE",
        "e8DIPO_CARPLAY_MODE",
        "e8DIPO_NATIVE_TRANSPORT_MODE",
        "e8DIPO_CARPLAY_NATIVE_TRANSPORT_MODE",
        "e8DIPO_CARLIFE_NATIVE_TRANSPORT_MODE",
    };

    if (T_e8_DiPORoleStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPORoleStatus_IsValid (T_e8_DiPORoleStatus value)
{
    switch (value) {
    case T_e8_DiPORoleStatus__e8DIPO_CLIENTMODE:
    case T_e8_DiPORoleStatus__e8DIPO_HOSTMODE:
    case T_e8_DiPORoleStatus__e8DIPO_CARPLAY_MODE:
    case T_e8_DiPORoleStatus__e8DIPO_NATIVE_TRANSPORT_MODE:
    case T_e8_DiPORoleStatus__e8DIPO_CARPLAY_NATIVE_TRANSPORT_MODE:
    case T_e8_DiPORoleStatus__e8DIPO_CARLIFE_NATIVE_TRANSPORT_MODE:
        return true;
    default:
        return false;
    }
}

bool T_e8_AudioError_Parse (const char *str, size_t length, T_e8_AudioError &value)
{
    static stringEntry entries[] = {
        {10,"E8NO_ERROR", 0U},
        {15,"E8UNKNOWN_ERROR", 1U},
        {16,"E8ALLOCATE_ERROR", 3U},
        {18,"E8ACTIVATION_ERROR", 2U},
        {18,"E8DEALLOCATE_ERROR", 6U},
        {20,"E8DEACTIVATION_ERROR", 5U},
        {20,"E8SOURCEACT_ON_ERROR", 4U},
        {21,"E8SOURCEACT_OFF_ERROR", 7U},
    };

    return lookupInStringEntryTable (str, length, entries, 8, (unsigned int&) value);
}

const char* T_e8_AudioError_Name (T_e8_AudioError value)
{
    static const char* enumerationLiterals[] = {
        "e8NO_ERROR",
        "e8UNKNOWN_ERROR",
        "e8ACTIVATION_ERROR",
        "e8ALLOCATE_ERROR",
        "e8SOURCEACT_ON_ERROR",
        "e8DEACTIVATION_ERROR",
        "e8DEALLOCATE_ERROR",
        "e8SOURCEACT_OFF_ERROR",
    };

    if (T_e8_AudioError_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AudioError_IsValid (T_e8_AudioError value)
{
    switch (value) {
    case T_e8_AudioError__e8NO_ERROR:
    case T_e8_AudioError__e8UNKNOWN_ERROR:
    case T_e8_AudioError__e8ACTIVATION_ERROR:
    case T_e8_AudioError__e8ALLOCATE_ERROR:
    case T_e8_AudioError__e8SOURCEACT_ON_ERROR:
    case T_e8_AudioError__e8DEACTIVATION_ERROR:
    case T_e8_AudioError__e8DEALLOCATE_ERROR:
    case T_e8_AudioError__e8SOURCEACT_OFF_ERROR:
        return true;
    default:
        return false;
    }
}

bool T_e8_AppLaunchOption_Parse (const char *str, size_t length, T_e8_AppLaunchOption &value)
{
    static stringEntry entries[] = {
        {24,"E8LAUNCH_WITH_USER_ALERT", 0U},
        {27,"E8LAUNCH_WITHOUT_USER_ALERT", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_AppLaunchOption_Name (T_e8_AppLaunchOption value)
{
    static const char* enumerationLiterals[] = {
        "e8LAUNCH_WITH_USER_ALERT",
        "e8LAUNCH_WITHOUT_USER_ALERT",
    };

    if (T_e8_AppLaunchOption_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AppLaunchOption_IsValid (T_e8_AppLaunchOption value)
{
    switch (value) {
    case T_e8_AppLaunchOption__e8LAUNCH_WITH_USER_ALERT:
    case T_e8_AppLaunchOption__e8LAUNCH_WITHOUT_USER_ALERT:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPOCallStateUpdateStatus_Parse (const char *str, size_t length, T_e8_DiPOCallStateUpdateStatus &value)
{
    static stringEntry entries[] = {
        {16,"E8DIPO_CSUS_HELD", 5U},
        {18,"E8DIPO_CSUS_ACTIVE", 4U},
        {19,"E8DIPO_CSUS_RINGING", 2U},
        {19,"E8DIPO_CSUS_SENDING", 1U},
        {22,"E8DIPO_CSUS_CONNECTING", 3U},
        {24,"E8DIPO_CSUS_DISCONNECTED", 0U},
        {25,"E8DIPO_CSUS_DISCONNECTING", 6U},
    };

    return lookupInStringEntryTable (str, length, entries, 7, (unsigned int&) value);
}

const char* T_e8_DiPOCallStateUpdateStatus_Name (T_e8_DiPOCallStateUpdateStatus value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_CSUS_DISCONNECTED",
        "e8DIPO_CSUS_SENDING",
        "e8DIPO_CSUS_RINGING",
        "e8DIPO_CSUS_CONNECTING",
        "e8DIPO_CSUS_ACTIVE",
        "e8DIPO_CSUS_HELD",
        "e8DIPO_CSUS_DISCONNECTING",
    };

    if (T_e8_DiPOCallStateUpdateStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPOCallStateUpdateStatus_IsValid (T_e8_DiPOCallStateUpdateStatus value)
{
    switch (value) {
    case T_e8_DiPOCallStateUpdateStatus__e8DIPO_CSUS_DISCONNECTED:
    case T_e8_DiPOCallStateUpdateStatus__e8DIPO_CSUS_SENDING:
    case T_e8_DiPOCallStateUpdateStatus__e8DIPO_CSUS_RINGING:
    case T_e8_DiPOCallStateUpdateStatus__e8DIPO_CSUS_CONNECTING:
    case T_e8_DiPOCallStateUpdateStatus__e8DIPO_CSUS_ACTIVE:
    case T_e8_DiPOCallStateUpdateStatus__e8DIPO_CSUS_HELD:
    case T_e8_DiPOCallStateUpdateStatus__e8DIPO_CSUS_DISCONNECTING:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPOCallStateUpdateDirection_Parse (const char *str, size_t length, T_e8_DiPOCallStateUpdateDirection &value)
{
    static stringEntry entries[] = {
        {19,"E8DIPO_CSUD_UNKNOWN", 0U},
        {20,"E8DIPO_CSUD_INCOMING", 1U},
        {20,"E8DIPO_CSUD_OUTGOING", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_DiPOCallStateUpdateDirection_Name (T_e8_DiPOCallStateUpdateDirection value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_CSUD_UNKNOWN",
        "e8DIPO_CSUD_INCOMING",
        "e8DIPO_CSUD_OUTGOING",
    };

    if (T_e8_DiPOCallStateUpdateDirection_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPOCallStateUpdateDirection_IsValid (T_e8_DiPOCallStateUpdateDirection value)
{
    switch (value) {
    case T_e8_DiPOCallStateUpdateDirection__e8DIPO_CSUD_UNKNOWN:
    case T_e8_DiPOCallStateUpdateDirection__e8DIPO_CSUD_INCOMING:
    case T_e8_DiPOCallStateUpdateDirection__e8DIPO_CSUD_OUTGOING:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPOCallStateUpdateService_Parse (const char *str, size_t length, T_e8_DiPOCallStateUpdateService &value)
{
    static stringEntry entries[] = {
        {19,"E8DIPO_CSEV_UNKNOWN", 0U},
        {21,"E8DIPO_CSEV_TELEPHONY", 1U},
        {25,"E8DIPO_CSEV_FACETIMEAUDIO", 2U},
        {25,"E8DIPO_CSEV_FACETIMEVIDEO", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_DiPOCallStateUpdateService_Name (T_e8_DiPOCallStateUpdateService value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_CSEV_UNKNOWN",
        "e8DIPO_CSEV_TELEPHONY",
        "e8DIPO_CSEV_FACETIMEAUDIO",
        "e8DIPO_CSEV_FACETIMEVIDEO",
    };

    if (T_e8_DiPOCallStateUpdateService_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPOCallStateUpdateService_IsValid (T_e8_DiPOCallStateUpdateService value)
{
    switch (value) {
    case T_e8_DiPOCallStateUpdateService__e8DIPO_CSEV_UNKNOWN:
    case T_e8_DiPOCallStateUpdateService__e8DIPO_CSEV_TELEPHONY:
    case T_e8_DiPOCallStateUpdateService__e8DIPO_CSEV_FACETIMEAUDIO:
    case T_e8_DiPOCallStateUpdateService__e8DIPO_CSEV_FACETIMEVIDEO:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPOCallStateUpdateDisconnectReason_Parse (const char *str, size_t length, T_e8_DiPOCallStateUpdateDisconnectReason &value)
{
    static stringEntry entries[] = {
        {17,"E8DIPO_CSDR_ENDED", 0U},
        {18,"E8DIPO_CSDR_FAILED", 2U},
        {20,"E8DIPO_CSDR_DECLINED", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_DiPOCallStateUpdateDisconnectReason_Name (T_e8_DiPOCallStateUpdateDisconnectReason value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_CSDR_ENDED",
        "e8DIPO_CSDR_DECLINED",
        "e8DIPO_CSDR_FAILED",
    };

    if (T_e8_DiPOCallStateUpdateDisconnectReason_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPOCallStateUpdateDisconnectReason_IsValid (T_e8_DiPOCallStateUpdateDisconnectReason value)
{
    switch (value) {
    case T_e8_DiPOCallStateUpdateDisconnectReason__e8DIPO_CSDR_ENDED:
    case T_e8_DiPOCallStateUpdateDisconnectReason__e8DIPO_CSDR_DECLINED:
    case T_e8_DiPOCallStateUpdateDisconnectReason__e8DIPO_CSDR_FAILED:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPOCommunicationsUpdateSignalStrength_Parse (const char *str, size_t length, T_e8_DiPOCommunicationsUpdateSignalStrength &value)
{
    static stringEntry entries[] = {
        {16,"E8DIPO_CUSS_1BAR", 1U},
        {17,"E8DIPO_CUSS_0BARS", 0U},
        {17,"E8DIPO_CUSS_2BARS", 2U},
        {17,"E8DIPO_CUSS_3BARS", 3U},
        {17,"E8DIPO_CUSS_4BARS", 4U},
        {17,"E8DIPO_CUSS_5BARS", 5U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_DiPOCommunicationsUpdateSignalStrength_Name (T_e8_DiPOCommunicationsUpdateSignalStrength value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_CUSS_0BARS",
        "e8DIPO_CUSS_1BAR",
        "e8DIPO_CUSS_2BARS",
        "e8DIPO_CUSS_3BARS",
        "e8DIPO_CUSS_4BARS",
        "e8DIPO_CUSS_5BARS",
    };

    if (T_e8_DiPOCommunicationsUpdateSignalStrength_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPOCommunicationsUpdateSignalStrength_IsValid (T_e8_DiPOCommunicationsUpdateSignalStrength value)
{
    switch (value) {
    case T_e8_DiPOCommunicationsUpdateSignalStrength__e8DIPO_CUSS_0BARS:
    case T_e8_DiPOCommunicationsUpdateSignalStrength__e8DIPO_CUSS_1BAR:
    case T_e8_DiPOCommunicationsUpdateSignalStrength__e8DIPO_CUSS_2BARS:
    case T_e8_DiPOCommunicationsUpdateSignalStrength__e8DIPO_CUSS_3BARS:
    case T_e8_DiPOCommunicationsUpdateSignalStrength__e8DIPO_CUSS_4BARS:
    case T_e8_DiPOCommunicationsUpdateSignalStrength__e8DIPO_CUSS_5BARS:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPOCommunicationsUpdateRegistrationStatus_Parse (const char *str, size_t length, T_e8_DiPOCommunicationsUpdateRegistrationStatus &value)
{
    static stringEntry entries[] = {
        {18,"E8DIPO_CURS_DENIED", 3U},
        {19,"E8DIPO_CURS_UNKNONW", 0U},
        {21,"E8DIPO_CURS_SEARCHING", 2U},
        {25,"E8DIPO_CURS_NOTREGISTERED", 1U},
        {26,"E8DIPO_CURS_REGISTEREDHOME", 4U},
        {29,"E8DIPO_CURS_EMERGENCYCALLONLY", 6U},
        {29,"E8DIPO_CURS_REGISTEREDROAMING", 5U},
    };

    return lookupInStringEntryTable (str, length, entries, 7, (unsigned int&) value);
}

const char* T_e8_DiPOCommunicationsUpdateRegistrationStatus_Name (T_e8_DiPOCommunicationsUpdateRegistrationStatus value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_CURS_UNKNONW",
        "e8DIPO_CURS_NOTREGISTERED",
        "e8DIPO_CURS_SEARCHING",
        "e8DIPO_CURS_DENIED",
        "e8DIPO_CURS_REGISTEREDHOME",
        "e8DIPO_CURS_REGISTEREDROAMING",
        "e8DIPO_CURS_EMERGENCYCALLONLY",
    };

    if (T_e8_DiPOCommunicationsUpdateRegistrationStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPOCommunicationsUpdateRegistrationStatus_IsValid (T_e8_DiPOCommunicationsUpdateRegistrationStatus value)
{
    switch (value) {
    case T_e8_DiPOCommunicationsUpdateRegistrationStatus__e8DIPO_CURS_UNKNONW:
    case T_e8_DiPOCommunicationsUpdateRegistrationStatus__e8DIPO_CURS_NOTREGISTERED:
    case T_e8_DiPOCommunicationsUpdateRegistrationStatus__e8DIPO_CURS_SEARCHING:
    case T_e8_DiPOCommunicationsUpdateRegistrationStatus__e8DIPO_CURS_DENIED:
    case T_e8_DiPOCommunicationsUpdateRegistrationStatus__e8DIPO_CURS_REGISTEREDHOME:
    case T_e8_DiPOCommunicationsUpdateRegistrationStatus__e8DIPO_CURS_REGISTEREDROAMING:
    case T_e8_DiPOCommunicationsUpdateRegistrationStatus__e8DIPO_CURS_EMERGENCYCALLONLY:
        return true;
    default:
        return false;
    }
}

bool T_e8_RouteGuidanceState_Parse (const char *str, size_t length, T_e8_RouteGuidanceState &value)
{
    static stringEntry entries[] = {
        {35,"E8DIPO_ROUTE_GUIDANCE_STATE_ARRIVED", 2U},
        {35,"E8DIPO_ROUTE_GUIDANCE_STATE_LOADING", 3U},
        {36,"E8DIPO_ROUTE_GUIDANCE_STATE_LOCATING", 4U},
        {37,"E8DIPO_ROUTE_GUIDANCE_STATE_REROUTING", 5U},
        {37,"E8DIPO_ROUTE_GUIDANCE_STATE_ROUTE_SET", 1U},
        {40,"E8DIPO_ROUTE_GUIDANCE_STATE_NO_ROUTE_SET", 0U},
        {42,"E8DIPO_ROUTE_GUIDANCE_STATE_PROCEEDTOROUTE", 6U},
    };

    return lookupInStringEntryTable (str, length, entries, 7, (unsigned int&) value);
}

const char* T_e8_RouteGuidanceState_Name (T_e8_RouteGuidanceState value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_ROUTE_GUIDANCE_STATE_NO_ROUTE_SET",
        "e8DIPO_ROUTE_GUIDANCE_STATE_ROUTE_SET",
        "e8DIPO_ROUTE_GUIDANCE_STATE_ARRIVED",
        "e8DIPO_ROUTE_GUIDANCE_STATE_LOADING",
        "e8DIPO_ROUTE_GUIDANCE_STATE_LOCATING",
        "e8DIPO_ROUTE_GUIDANCE_STATE_REROUTING",
        "e8DIPO_ROUTE_GUIDANCE_STATE_PROCEEDTOROUTE",
    };

    if (T_e8_RouteGuidanceState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_RouteGuidanceState_IsValid (T_e8_RouteGuidanceState value)
{
    switch (value) {
    case T_e8_RouteGuidanceState__e8DIPO_ROUTE_GUIDANCE_STATE_NO_ROUTE_SET:
    case T_e8_RouteGuidanceState__e8DIPO_ROUTE_GUIDANCE_STATE_ROUTE_SET:
    case T_e8_RouteGuidanceState__e8DIPO_ROUTE_GUIDANCE_STATE_ARRIVED:
    case T_e8_RouteGuidanceState__e8DIPO_ROUTE_GUIDANCE_STATE_LOADING:
    case T_e8_RouteGuidanceState__e8DIPO_ROUTE_GUIDANCE_STATE_LOCATING:
    case T_e8_RouteGuidanceState__e8DIPO_ROUTE_GUIDANCE_STATE_REROUTING:
    case T_e8_RouteGuidanceState__e8DIPO_ROUTE_GUIDANCE_STATE_PROCEEDTOROUTE:
        return true;
    default:
        return false;
    }
}

bool T_e8_ManeuverState_Parse (const char *str, size_t length, T_e8_ManeuverState &value)
{
    static stringEntry entries[] = {
        {29,"E8DIPO_MANEUVER_STATE_EXECUTE", 3U},
        {29,"E8DIPO_MANEUVER_STATE_INITIAL", 1U},
        {29,"E8DIPO_MANEUVER_STATE_PREPARE", 2U},
        {30,"E8DIPO_MANEUVER_STATE_CONTINUE", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_ManeuverState_Name (T_e8_ManeuverState value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_MANEUVER_STATE_CONTINUE",
        "e8DIPO_MANEUVER_STATE_INITIAL",
        "e8DIPO_MANEUVER_STATE_PREPARE",
        "e8DIPO_MANEUVER_STATE_EXECUTE",
    };

    if (T_e8_ManeuverState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_ManeuverState_IsValid (T_e8_ManeuverState value)
{
    switch (value) {
    case T_e8_ManeuverState__e8DIPO_MANEUVER_STATE_CONTINUE:
    case T_e8_ManeuverState__e8DIPO_MANEUVER_STATE_INITIAL:
    case T_e8_ManeuverState__e8DIPO_MANEUVER_STATE_PREPARE:
    case T_e8_ManeuverState__e8DIPO_MANEUVER_STATE_EXECUTE:
        return true;
    default:
        return false;
    }
}

bool T_e8_DistanceDisplayUnits_Parse (const char *str, size_t length, T_e8_DistanceDisplayUnits &value)
{
    static stringEntry entries[] = {
        {30,"E8DIPO_DISTANCE_DISPLAY_UNIT_M", 2U},
        {31,"E8DIPO_DISTANCE_DISPLAY_UNIT_FT", 4U},
        {31,"E8DIPO_DISTANCE_DISPLAY_UNIT_KM", 0U},
        {34,"E8DIPO_DISTANCE_DISPLAY_UNIT_MILES", 1U},
        {34,"E8DIPO_DISTANCE_DISPLAY_UNIT_YARDS", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_DistanceDisplayUnits_Name (T_e8_DistanceDisplayUnits value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_DISTANCE_DISPLAY_UNIT_KM",
        "e8DIPO_DISTANCE_DISPLAY_UNIT_MILES",
        "e8DIPO_DISTANCE_DISPLAY_UNIT_M",
        "e8DIPO_DISTANCE_DISPLAY_UNIT_YARDS",
        "e8DIPO_DISTANCE_DISPLAY_UNIT_FT",
    };

    if (T_e8_DistanceDisplayUnits_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DistanceDisplayUnits_IsValid (T_e8_DistanceDisplayUnits value)
{
    switch (value) {
    case T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_KM:
    case T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_MILES:
    case T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_M:
    case T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_YARDS:
    case T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_FT:
        return true;
    default:
        return false;
    }
}

bool T_e8_ManeuverType_Parse (const char *str, size_t length, T_e8_ManeuverType &value)
{
    static stringEntry entries[] = {
        {28,"E8DIPO_MANEUVER_TYPE_NO_TURN", 0U},
        {28,"E8DIPO_MANEUVER_TYPE_ON_RAMP", 9U},
        {29,"E8DIPO_MANEUVER_TYPE_CONTINUE", 5U},
        {29,"E8DIPO_MANEUVER_TYPE_OFF_RAMP", 8U},
        {30,"E8DIPO_MANEUVER_TYPE_KEEP_LEFT", 13U},
        {30,"E8DIPO_MANEUVER_TYPE_LEFT_TURN", 1U},
        {31,"E8DIPO_MANEUVER_TYPE_EXIT_FERRY", 16U},
        {31,"E8DIPO_MANEUVER_TYPE_KEEP_RIGHT", 14U},
        {31,"E8DIPO_MANEUVER_TYPE_RIGHT_TURN", 2U},
        {32,"E8DIPO_MANEUVER_TYPE_ENTER_FERRY", 15U},
        {32,"E8DIPO_MANEUVER_TYPE_MAKE_U_TURN", 4U},
        {35,"E8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY", 51U},
        {35,"E8DIPO_MANEUVER_TYPE_STRAIGHT_AHEAD", 3U},
        {36,"E8DIPO_MANEUVER_TYPE_EXIT_ROUNDABOUT", 7U},
        {36,"E8DIPO_MANEUVER_TYPE_SHARP_LEFT_TURN", 47U},
        {37,"E8DIPO_MANEUVER_TYPE_ENTER_ROUNDABOUT", 6U},
        {37,"E8DIPO_MANEUVER_TYPE_SHARP_RIGHT_TURN", 48U},
        {37,"E8DIPO_MANEUVER_TYPE_SLIGHT_LEFT_TURN", 49U},
        {38,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_1", 28U},
        {38,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_2", 29U},
        {38,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_3", 30U},
        {38,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_4", 31U},
        {38,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_5", 32U},
        {38,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_6", 33U},
        {38,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_7", 34U},
        {38,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_8", 35U},
        {38,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_9", 36U},
        {38,"E8DIPO_MANEUVER_TYPE_SLIGHT_RIGHT_TURN", 50U},
        {39,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_10", 37U},
        {39,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_11", 38U},
        {39,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_12", 39U},
        {39,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_13", 40U},
        {39,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_14", 41U},
        {39,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_15", 42U},
        {39,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_16", 43U},
        {39,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_17", 44U},
        {39,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_18", 45U},
        {39,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_19", 46U},
        {40,"E8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY_LEFT", 52U},
        {41,"E8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY_RIGHT", 53U},
        {42,"E8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION", 12U},
        {42,"E8DIPO_MANEUVER_TYPE_END_OF_ROAD_TURN_LEFT", 20U},
        {42,"E8DIPO_MANEUVER_TYPE_HIGHWAY_OFF_RAMP_LEFT", 22U},
        {43,"E8DIPO_MANEUVER_TYPE_END_OF_ROAD_TURN_RIGHT", 21U},
        {43,"E8DIPO_MANEUVER_TYPE_HIGHWAY_OFF_RAMP_RIGHT", 23U},
        {45,"E8DIPO_MANEUVER_TYPE_ARRIVE_END_OF_DIRECTIONS", 27U},
        {45,"E8DIPO_MANEUVER_TYPE_ARRIVE_END_OF_NAVIGATION", 10U},
        {46,"E8DIPO_MANEUVER_TYPE_CHANGE_TO_DIFFERENT_FERRY", 17U},
        {46,"E8DIPO_MANEUVER_TYPE_MAKE_U_TURN_WHEN_POSSIBLE", 26U},
        {47,"E8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION_LEFT", 24U},
        {48,"E8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION_RIGHT", 25U},
        {50,"E8DIPO_MANEUVER_TYPE_USE_ROUNDABOUT_TO_MAKE_U_TURN", 19U},
        {53,"E8DIPO_MANEUVER_TYPE_MAKE_U_TURN_AND_PROCEED_TO_ROUTE", 18U},
        {54,"E8DIPO_MANEUVER_TYPE_PROCEED_TO_THE_BEGINNING_OF_ROUTE", 11U},
    };

    return lookupInStringEntryTable (str, length, entries, 54, (unsigned int&) value);
}

const char* T_e8_ManeuverType_Name (T_e8_ManeuverType value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_MANEUVER_TYPE_NO_TURN",
        "e8DIPO_MANEUVER_TYPE_LEFT_TURN",
        "e8DIPO_MANEUVER_TYPE_RIGHT_TURN",
        "e8DIPO_MANEUVER_TYPE_STRAIGHT_AHEAD",
        "e8DIPO_MANEUVER_TYPE_MAKE_U_TURN",
        "e8DIPO_MANEUVER_TYPE_CONTINUE",
        "e8DIPO_MANEUVER_TYPE_ENTER_ROUNDABOUT",
        "e8DIPO_MANEUVER_TYPE_EXIT_ROUNDABOUT",
        "e8DIPO_MANEUVER_TYPE_OFF_RAMP",
        "e8DIPO_MANEUVER_TYPE_ON_RAMP",
        "e8DIPO_MANEUVER_TYPE_ARRIVE_END_OF_NAVIGATION",
        "e8DIPO_MANEUVER_TYPE_PROCEED_TO_THE_BEGINNING_OF_ROUTE",
        "e8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION",
        "e8DIPO_MANEUVER_TYPE_KEEP_LEFT",
        "e8DIPO_MANEUVER_TYPE_KEEP_RIGHT",
        "e8DIPO_MANEUVER_TYPE_ENTER_FERRY",
        "e8DIPO_MANEUVER_TYPE_EXIT_FERRY",
        "e8DIPO_MANEUVER_TYPE_CHANGE_TO_DIFFERENT_FERRY",
        "e8DIPO_MANEUVER_TYPE_MAKE_U_TURN_AND_PROCEED_TO_ROUTE",
        "e8DIPO_MANEUVER_TYPE_USE_ROUNDABOUT_TO_MAKE_U_TURN",
        "e8DIPO_MANEUVER_TYPE_END_OF_ROAD_TURN_LEFT",
        "e8DIPO_MANEUVER_TYPE_END_OF_ROAD_TURN_RIGHT",
        "e8DIPO_MANEUVER_TYPE_HIGHWAY_OFF_RAMP_LEFT",
        "e8DIPO_MANEUVER_TYPE_HIGHWAY_OFF_RAMP_RIGHT",
        "e8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION_LEFT",
        "e8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION_RIGHT",
        "e8DIPO_MANEUVER_TYPE_MAKE_U_TURN_WHEN_POSSIBLE",
        "e8DIPO_MANEUVER_TYPE_ARRIVE_END_OF_DIRECTIONS",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_1",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_2",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_3",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_4",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_5",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_6",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_7",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_8",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_9",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_10",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_11",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_12",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_13",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_14",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_15",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_16",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_17",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_18",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_19",
        "e8DIPO_MANEUVER_TYPE_SHARP_LEFT_TURN",
        "e8DIPO_MANEUVER_TYPE_SHARP_RIGHT_TURN",
        "e8DIPO_MANEUVER_TYPE_SLIGHT_LEFT_TURN",
        "e8DIPO_MANEUVER_TYPE_SLIGHT_RIGHT_TURN",
        "e8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY",
        "e8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY_LEFT",
        "e8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY_RIGHT",
    };

    if (T_e8_ManeuverType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_ManeuverType_IsValid (T_e8_ManeuverType value)
{
    switch (value) {
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_NO_TURN:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_LEFT_TURN:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_RIGHT_TURN:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_STRAIGHT_AHEAD:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_MAKE_U_TURN:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_CONTINUE:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ENTER_ROUNDABOUT:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_EXIT_ROUNDABOUT:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_OFF_RAMP:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ON_RAMP:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ARRIVE_END_OF_NAVIGATION:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_PROCEED_TO_THE_BEGINNING_OF_ROUTE:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_KEEP_LEFT:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_KEEP_RIGHT:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ENTER_FERRY:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_EXIT_FERRY:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_CHANGE_TO_DIFFERENT_FERRY:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_MAKE_U_TURN_AND_PROCEED_TO_ROUTE:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_USE_ROUNDABOUT_TO_MAKE_U_TURN:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_END_OF_ROAD_TURN_LEFT:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_END_OF_ROAD_TURN_RIGHT:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_HIGHWAY_OFF_RAMP_LEFT:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_HIGHWAY_OFF_RAMP_RIGHT:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION_LEFT:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION_RIGHT:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_MAKE_U_TURN_WHEN_POSSIBLE:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ARRIVE_END_OF_DIRECTIONS:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_1:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_2:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_3:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_4:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_5:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_6:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_7:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_8:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_9:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_10:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_11:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_12:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_13:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_14:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_15:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_16:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_17:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_18:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_19:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_SHARP_LEFT_TURN:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_SHARP_RIGHT_TURN:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_SLIGHT_LEFT_TURN:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_SLIGHT_RIGHT_TURN:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY_LEFT:
    case T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY_RIGHT:
        return true;
    default:
        return false;
    }
}

bool T_e8_DrivingSide_Parse (const char *str, size_t length, T_e8_DrivingSide &value)
{
    static stringEntry entries[] = {
        {24,"E8DIPO_DRIVING_SIDE_LEFT", 1U},
        {25,"E8DIPO_DRIVING_SIDE_RIGHT", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_DrivingSide_Name (T_e8_DrivingSide value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_DRIVING_SIDE_RIGHT",
        "e8DIPO_DRIVING_SIDE_LEFT",
    };

    if (T_e8_DrivingSide_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DrivingSide_IsValid (T_e8_DrivingSide value)
{
    switch (value) {
    case T_e8_DrivingSide__e8DIPO_DRIVING_SIDE_RIGHT:
    case T_e8_DrivingSide__e8DIPO_DRIVING_SIDE_LEFT:
        return true;
    default:
        return false;
    }
}

bool T_e8_JunctionType_Parse (const char *str, size_t length, T_e8_JunctionType &value)
{
    static stringEntry entries[] = {
        {31,"E8DIPO_JUNCTION_TYPE_ROUNDABOUT", 1U},
        {40,"E8DIPO_JUNCTION_TYPE_SINGLE_INTERSECTION", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_JunctionType_Name (T_e8_JunctionType value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_JUNCTION_TYPE_SINGLE_INTERSECTION",
        "e8DIPO_JUNCTION_TYPE_ROUNDABOUT",
    };

    if (T_e8_JunctionType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_JunctionType_IsValid (T_e8_JunctionType value)
{
    switch (value) {
    case T_e8_JunctionType__e8DIPO_JUNCTION_TYPE_SINGLE_INTERSECTION:
    case T_e8_JunctionType__e8DIPO_JUNCTION_TYPE_ROUNDABOUT:
        return true;
    default:
        return false;
    }
}

bool T_e_InitiateCallType_Parse (const char *str, size_t length, T_e_InitiateCallType &value)
{
    static stringEntry entries[] = {
        {7,"EREDIAL", 2U},
        {11,"EVOICE_MAIL", 1U},
        {12,"EDESTINATION", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e_InitiateCallType_Name (T_e_InitiateCallType value)
{
    static const char* enumerationLiterals[] = {
        "eDESTINATION",
        "eVOICE_MAIL",
        "eREDIAL",
    };

    if (T_e_InitiateCallType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e_InitiateCallType_IsValid (T_e_InitiateCallType value)
{
    switch (value) {
    case T_e_InitiateCallType__eDESTINATION:
    case T_e_InitiateCallType__eVOICE_MAIL:
    case T_e_InitiateCallType__eREDIAL:
        return true;
    default:
        return false;
    }
}

bool T_e_InitiateCallService_Parse (const char *str, size_t length, T_e_InitiateCallService &value)
{
    static stringEntry entries[] = {
        {10,"ETELEPHONY", 1U},
        {16,"EFACE_TIME_AUDIO", 2U},
        {16,"EFACE_TIME_VIDEO", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e_InitiateCallService_Name (T_e_InitiateCallService value)
{
    static const char* enumerationLiterals[] = {
        "eTELEPHONY",
        "eFACE_TIME_AUDIO",
        "eFACE_TIME_VIDEO",
    };

    if (T_e_InitiateCallService_IsValid(value))
        return enumerationLiterals[value - 1U];
    else
        return NULL;
}

bool T_e_InitiateCallService_IsValid (T_e_InitiateCallService value)
{
    switch (value) {
    case T_e_InitiateCallService__eTELEPHONY:
    case T_e_InitiateCallService__eFACE_TIME_AUDIO:
    case T_e_InitiateCallService__eFACE_TIME_VIDEO:
        return true;
    default:
        return false;
    }
}

bool T_e_AcceptAction_Parse (const char *str, size_t length, T_e_AcceptAction &value)
{
    static stringEntry entries[] = {
        {15,"EEND_AND_ACCEPT", 1U},
        {26,"EACCEPT_OR_HOLD_AND_ACCEPT", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e_AcceptAction_Name (T_e_AcceptAction value)
{
    static const char* enumerationLiterals[] = {
        "eACCEPT_OR_HOLD_AND_ACCEPT",
        "eEND_AND_ACCEPT",
    };

    if (T_e_AcceptAction_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e_AcceptAction_IsValid (T_e_AcceptAction value)
{
    switch (value) {
    case T_e_AcceptAction__eACCEPT_OR_HOLD_AND_ACCEPT:
    case T_e_AcceptAction__eEND_AND_ACCEPT:
        return true;
    default:
        return false;
    }
}

bool T_e_EndAction_Parse (const char *str, size_t length, T_e_EndAction &value)
{
    static stringEntry entries[] = {
        {8,"EEND_ALL", 1U},
        {15,"EEND_OR_DECLINE", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e_EndAction_Name (T_e_EndAction value)
{
    static const char* enumerationLiterals[] = {
        "eEND_OR_DECLINE",
        "eEND_ALL",
    };

    if (T_e_EndAction_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e_EndAction_IsValid (T_e_EndAction value)
{
    switch (value) {
    case T_e_EndAction__eEND_OR_DECLINE:
    case T_e_EndAction__eEND_ALL:
        return true;
    default:
        return false;
    }
}

bool T_e_SendDTMFTone_Parse (const char *str, size_t length, T_e_SendDTMFTone &value)
{
    static stringEntry entries[] = {
        {4,"STAR", 10U},
        {5,"POUND", 11U},
        {8,"NUMBER_0", 0U},
        {8,"NUMBER_1", 1U},
        {8,"NUMBER_2", 2U},
        {8,"NUMBER_3", 3U},
        {8,"NUMBER_4", 4U},
        {8,"NUMBER_5", 5U},
        {8,"NUMBER_6", 6U},
        {8,"NUMBER_7", 7U},
        {8,"NUMBER_8", 8U},
        {8,"NUMBER_9", 9U},
    };

    return lookupInStringEntryTable (str, length, entries, 12, (unsigned int&) value);
}

const char* T_e_SendDTMFTone_Name (T_e_SendDTMFTone value)
{
    static const char* enumerationLiterals[] = {
        "NUMBER_0",
        "NUMBER_1",
        "NUMBER_2",
        "NUMBER_3",
        "NUMBER_4",
        "NUMBER_5",
        "NUMBER_6",
        "NUMBER_7",
        "NUMBER_8",
        "NUMBER_9",
        "STAR",
        "POUND",
    };

    if (T_e_SendDTMFTone_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e_SendDTMFTone_IsValid (T_e_SendDTMFTone value)
{
    switch (value) {
    case T_e_SendDTMFTone__NUMBER_0:
    case T_e_SendDTMFTone__NUMBER_1:
    case T_e_SendDTMFTone__NUMBER_2:
    case T_e_SendDTMFTone__NUMBER_3:
    case T_e_SendDTMFTone__NUMBER_4:
    case T_e_SendDTMFTone__NUMBER_5:
    case T_e_SendDTMFTone__NUMBER_6:
    case T_e_SendDTMFTone__NUMBER_7:
    case T_e_SendDTMFTone__NUMBER_8:
    case T_e_SendDTMFTone__NUMBER_9:
    case T_e_SendDTMFTone__STAR:
    case T_e_SendDTMFTone__POUND:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPOCommunicationError_Parse (const char *str, size_t length, T_e8_DiPOCommunicationError &value)
{
    static stringEntry entries[] = {
        {15,"E8IPOD_NO_ERROR", 0U},
        {17,"E8IPOD_COMM_ERROR", 1U},
        {23,"E8IPOD_ROLESWITCH_ERROR", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_DiPOCommunicationError_Name (T_e8_DiPOCommunicationError value)
{
    static const char* enumerationLiterals[] = {
        "e8IPOD_NO_ERROR",
        "e8IPOD_COMM_ERROR",
        "e8IPOD_ROLESWITCH_ERROR",
    };

    if (T_e8_DiPOCommunicationError_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPOCommunicationError_IsValid (T_e8_DiPOCommunicationError value)
{
    switch (value) {
    case T_e8_DiPOCommunicationError__e8IPOD_NO_ERROR:
    case T_e8_DiPOCommunicationError__e8IPOD_COMM_ERROR:
    case T_e8_DiPOCommunicationError__e8IPOD_ROLESWITCH_ERROR:
        return true;
    default:
        return false;
    }
}

} // namespace mplay_appcontrol_fi_types
