/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "mplay_appcontrol_fi_types.h"
#include "mplay_appcontrol_fi_typesCca.h"
#include "mplay_appcontrol_fi_typesConst.h"
#include <string>
#include <vector>


void serializeCca(const ::mplay_appcontrol_fi_types::T_DiPODeviceInfoItem& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8DeviceTag();
    out << in.getSDeviceName();
    out << (uint8) in.getE8DeviceType();
    out << in.getSDeviceSerialNumber();
    out << (uint8) in.getBDeviceConnected();
    out << (uint8) in.getBDeviceActiveSource();
    out << (uint8) in.getBDiPOCapable();
    out << (uint8) in.getBDiPOActive();
    out << in.getSDiPOVersion();
    out << (uint8) in.getE8ConnectionType();
    out << (uint8) in.getE8ConnectionState();
    out << in.getSMountPoint();
    out << in.getSAccessoryName();
    out << (uint8) in.getE8DiPOCaps();
    out << (uint8) in.getE8DeviceState();
    out << in.getSDeviceUUID();
    out << in.getSDeviceBTMacAddress();
    out << in.getSDeviceUSBSerialNumber();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::mplay_appcontrol_fi_types::T_DiPODeviceInfoItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o0;
    in >> o0;
    out.setU8DeviceTag(o0);
    ::std::string o1;
    in >> o1;
    out.setSDeviceName(o1);
    uint8 o2;
    in >> o2;
    out.setE8DeviceType((::mplay_appcontrol_fi_types::T_e8_DiPODeviceType)o2);
    ::std::string o3;
    in >> o3;
    out.setSDeviceSerialNumber(o3);
    bool o4;
    in >> o4;
    out.setBDeviceConnected(o4);
    bool o5;
    in >> o5;
    out.setBDeviceActiveSource(o5);
    bool o6;
    in >> o6;
    out.setBDiPOCapable(o6);
    bool o7;
    in >> o7;
    out.setBDiPOActive(o7);
    ::std::string o8;
    in >> o8;
    out.setSDiPOVersion(o8);
    uint8 o9;
    in >> o9;
    out.setE8ConnectionType((::mplay_appcontrol_fi_types::T_e8_DiPOConnectionType)o9);
    uint8 o10;
    in >> o10;
    out.setE8ConnectionState((::mplay_appcontrol_fi_types::T_e8_DiPOConnectionState)o10);
    ::std::string o11;
    in >> o11;
    out.setSMountPoint(o11);
    ::std::string o12;
    in >> o12;
    out.setSAccessoryName(o12);
    uint8 o13;
    in >> o13;
    out.setE8DiPOCaps((::mplay_appcontrol_fi_types::T_e8_DiPOCaps)o13);
    uint8 o14;
    in >> o14;
    out.setE8DeviceState((::mplay_appcontrol_fi_types::T_e8_DiPODeviceStatus)o14);
    ::std::string o15;
    in >> o15;
    out.setSDeviceUUID(o15);
    ::std::string o16;
    in >> o16;
    out.setSDeviceBTMacAddress(o16);
    ::std::string o17;
    in >> o17;
    out.setSDeviceUSBSerialNumber(o17);
}

void serializeCca(const ::mplay_appcontrol_fi_types::T_b8_DiPOLocationInfoType& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getGPGGA()) {
        bitmask |= (1 << 0);
    }
    if (in.getGPRMC()) {
        bitmask |= (1 << 1);
    }
    if (in.getGPGSV()) {
        bitmask |= (1 << 2);
    }
    if (in.getGPHDT()) {
        bitmask |= (1 << 3);
    }
    if (in.getPASCD()) {
        bitmask |= (1 << 4);
    }
    if (in.getPAGCD()) {
        bitmask |= (1 << 5);
    }
    if (in.getPAACD()) {
        bitmask |= (1 << 6);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::mplay_appcontrol_fi_types::T_b8_DiPOLocationInfoType& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o18;
    in >> o18;
    uint8 bitmask(o18);

    if (bitmask & (1 << 0)) {
        out.setGPGGA (true);
    }
    if (bitmask & (1 << 1)) {
        out.setGPRMC (true);
    }
    if (bitmask & (1 << 2)) {
        out.setGPGSV (true);
    }
    if (bitmask & (1 << 3)) {
        out.setGPHDT (true);
    }
    if (bitmask & (1 << 4)) {
        out.setPASCD (true);
    }
    if (bitmask & (1 << 5)) {
        out.setPAGCD (true);
    }
    if (bitmask & (1 << 6)) {
        out.setPAACD (true);
    }
}

void serializeCca(const ::mplay_appcontrol_fi_types::T_b8_DiPOGPRMCDataStatusValues& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getGPRMCDataStatusValueA()) {
        bitmask |= (1 << 0);
    }
    if (in.getGPRMCDataStatusValueV()) {
        bitmask |= (1 << 1);
    }
    if (in.getGPRMCDataStatusValueX()) {
        bitmask |= (1 << 2);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::mplay_appcontrol_fi_types::T_b8_DiPOGPRMCDataStatusValues& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o19;
    in >> o19;
    uint8 bitmask(o19);

    if (bitmask & (1 << 0)) {
        out.setGPRMCDataStatusValueA (true);
    }
    if (bitmask & (1 << 1)) {
        out.setGPRMCDataStatusValueV (true);
    }
    if (bitmask & (1 << 2)) {
        out.setGPRMCDataStatusValueX (true);
    }
}

void serializeCca(const ::mplay_appcontrol_fi_types::T_b32_BTProfileType& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 bitmask = 0;
    if (in.getHandsFree()) {
        bitmask |= (1 << 0);
    }
    if (in.getPhoneBookAccess()) {
        bitmask |= (1 << 1);
    }
    if (in.getAudioVideoRemoteControl()) {
        bitmask |= (1 << 3);
    }
    if (in.getAdvancedAudioDistribution()) {
        bitmask |= (1 << 4);
    }
    if (in.getHumanInterfaceDevice()) {
        bitmask |= (1 << 5);
    }
    if (in.getIAP2Link()) {
        bitmask |= (1 << 7);
    }
    if (in.getPersonalAreaNetworkAccessPoint()) {
        bitmask |= (1 << 8);
    }
    if (in.getMessageAccess()) {
        bitmask |= (1 << 9);
    }
    if (in.getPersonalAreaNetworkClient()) {
        bitmask |= (1 << 12);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::mplay_appcontrol_fi_types::T_b32_BTProfileType& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o20;
    in >> o20;
    uint32 bitmask(o20);

    if (bitmask & (1 << 0)) {
        out.setHandsFree (true);
    }
    if (bitmask & (1 << 1)) {
        out.setPhoneBookAccess (true);
    }
    if (bitmask & (1 << 3)) {
        out.setAudioVideoRemoteControl (true);
    }
    if (bitmask & (1 << 4)) {
        out.setAdvancedAudioDistribution (true);
    }
    if (bitmask & (1 << 5)) {
        out.setHumanInterfaceDevice (true);
    }
    if (bitmask & (1 << 7)) {
        out.setIAP2Link (true);
    }
    if (bitmask & (1 << 8)) {
        out.setPersonalAreaNetworkAccessPoint (true);
    }
    if (bitmask & (1 << 9)) {
        out.setMessageAccess (true);
    }
    if (bitmask & (1 << 12)) {
        out.setPersonalAreaNetworkClient (true);
    }
}

void serializeCca(const ::mplay_appcontrol_fi_types::T_BTProfileItem& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8DeviceId();
    serializeCca(in.getB32BTProfile(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::mplay_appcontrol_fi_types::T_BTProfileItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o21;
    in >> o21;
    out.setU8DeviceId(o21);
    deserializeCca(in, out.getB32BTProfileMutable(), majorVersion);
}

void serializeCca(const ::mplay_appcontrol_fi_types::T_DiPOCallStateItem& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSRemoteID();
    out << in.getSDisplayName();
    out << (uint8) in.getEStatus();
    out << (uint8) in.getEDirection();
    out << in.getSCallUUID();
    out << in.getSAddressBookID();
    out << in.getSLabel();
    out << (uint8) in.getEService();
    out << (uint8) in.getBIsConferenced();
    out << in.getU8ConferenceGroup();
    out << (uint8) in.getEDisconnectReason();
    out << in.getU64StartTimestamp();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::mplay_appcontrol_fi_types::T_DiPOCallStateItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o22;
    in >> o22;
    out.setSRemoteID(o22);
    ::std::string o23;
    in >> o23;
    out.setSDisplayName(o23);
    uint8 o24;
    in >> o24;
    out.setEStatus((::mplay_appcontrol_fi_types::T_e8_DiPOCallStateUpdateStatus)o24);
    uint8 o25;
    in >> o25;
    out.setEDirection((::mplay_appcontrol_fi_types::T_e8_DiPOCallStateUpdateDirection)o25);
    ::std::string o26;
    in >> o26;
    out.setSCallUUID(o26);
    ::std::string o27;
    in >> o27;
    out.setSAddressBookID(o27);
    ::std::string o28;
    in >> o28;
    out.setSLabel(o28);
    uint8 o29;
    in >> o29;
    out.setEService((::mplay_appcontrol_fi_types::T_e8_DiPOCallStateUpdateService)o29);
    bool o30;
    in >> o30;
    out.setBIsConferenced(o30);
    uint8 o31;
    in >> o31;
    out.setU8ConferenceGroup(o31);
    uint8 o32;
    in >> o32;
    out.setEDisconnectReason((::mplay_appcontrol_fi_types::T_e8_DiPOCallStateUpdateDisconnectReason)o32);
    uint64 o33;
    in >> o33;
    out.setU64StartTimestamp(o33);
}

void serializeCca(const ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponentItem& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getIdentifier();
    out << in.getName();
    out << in.getMaxCurrentRoadNameLength();
    out << in.getMaxDestinationNameLength();
    out << in.getMaxAfterManeuverRoadNameLength();
    out << in.getMaxManeuverDescriptionLength();
    out << in.getMaxGuidanceManeuverCapacity();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponentItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o34;
    in >> o34;
    out.setIdentifier(o34);
    ::std::string o35;
    in >> o35;
    out.setName(o35);
    uint16 o36;
    in >> o36;
    out.setMaxCurrentRoadNameLength(o36);
    uint16 o37;
    in >> o37;
    out.setMaxDestinationNameLength(o37);
    uint16 o38;
    in >> o38;
    out.setMaxAfterManeuverRoadNameLength(o38);
    uint16 o39;
    in >> o39;
    out.setMaxManeuverDescriptionLength(o39);
    uint16 o40;
    in >> o40;
    out.setMaxGuidanceManeuverCapacity(o40);
}

void serializeCca(const ::mplay_appcontrol_fi_types::T_RouteGuidanceUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBRouteGuidanceDisplayComponentIDsAvailable();
    {
        uint32 o41 = static_cast<uint32>(in.getRouteGuidanceDisplayComponentIDs().size());
        out << o41;
        ::std::vector< uint16 >::const_iterator o42;
        for (o42 = in.getRouteGuidanceDisplayComponentIDs().begin(); o42 != in.getRouteGuidanceDisplayComponentIDs().end(); ++o42) {
            out << (*o42);
        }
    }
    out << (uint8) in.getBRouteGuidanceStateAvailable();
    out << (uint8) in.getE8RouteGuidanceState();
    out << (uint8) in.getBManeuverStateAvailable();
    out << (uint8) in.getE8ManeuverState();
    out << (uint8) in.getBCurrentRoadNameAvailable();
    out << in.getCurrentRoadName();
    out << (uint8) in.getBDestinationNameAvailable();
    out << in.getDestinationName();
    out << (uint8) in.getBEstimatedTimeOfArrivalAvailable();
    out << in.getEstimatedTimeOfArrival();
    out << (uint8) in.getBTimeRemainingToDestinationAvailable();
    out << in.getTimeRemainingToDestination();
    out << (uint8) in.getBDistanceRemainingAvailable();
    out << in.getDistanceRemaining();
    out << (uint8) in.getBDistanceRemainingDisplayStrAvailable();
    out << in.getDistanceRemainingDisplayStr();
    out << (uint8) in.getBDistanceRemainingDisplayUnitsAvailable();
    out << (uint8) in.getE8DistanceRemainingDisplayUnits();
    out << (uint8) in.getBDistanceToNextManeuverAvailable();
    out << in.getDistanceToNextManeuver();
    out << (uint8) in.getBDistanceToNextManeuverDisplayStrAvailable();
    out << in.getDistanceToNextManeuverDisplayStr();
    out << (uint8) in.getBDistanceToNextManeuverDisplayUnitsAvailable();
    out << (uint8) in.getE8DistanceToNextManeuverDisplayUnits();
    out << (uint8) in.getBRouteGuidanceManeuverCurrentListAvailable();
    {
        uint32 o43 = static_cast<uint32>(in.getRouteGuidanceManeuverCurrentList().size());
        out << o43;
        ::std::vector< uint16 >::const_iterator o44;
        for (o44 = in.getRouteGuidanceManeuverCurrentList().begin(); o44 != in.getRouteGuidanceManeuverCurrentList().end(); ++o44) {
            out << (*o44);
        }
    }
    out << (uint8) in.getBRouteGuidanceManeuverCountAvailable();
    out << in.getRouteGuidanceManeuverCount();
    out << (uint8) in.getBRouteGuidanceVisibleInAppAvailable();
    out << (uint8) in.getRouteGuidanceVisibleInApp();
    out << (uint8) in.getBSourceNameAvailable();
    out << in.getSourceName();
    out << (uint8) in.getBSourceSupportsRouteGuidanceAvailable();
    out << (uint8) in.getSourceSupportsRouteGuidance();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::mplay_appcontrol_fi_types::T_RouteGuidanceUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o45;
    in >> o45;
    out.setBRouteGuidanceDisplayComponentIDsAvailable(o45);
    {
        uint32 o46;
        in >> o46;
        out.getRouteGuidanceDisplayComponentIDsMutable().clear ();
        out.getRouteGuidanceDisplayComponentIDsMutable().reserve (o46);
        for (uint32 o47 = 0; o47 < o46; o47++) {
            uint16 o48;
            in >> o48;
            out.getRouteGuidanceDisplayComponentIDsMutable().push_back(o48);
        }
    }
    bool o49;
    in >> o49;
    out.setBRouteGuidanceStateAvailable(o49);
    uint8 o50;
    in >> o50;
    out.setE8RouteGuidanceState((::mplay_appcontrol_fi_types::T_e8_RouteGuidanceState)o50);
    bool o51;
    in >> o51;
    out.setBManeuverStateAvailable(o51);
    uint8 o52;
    in >> o52;
    out.setE8ManeuverState((::mplay_appcontrol_fi_types::T_e8_ManeuverState)o52);
    bool o53;
    in >> o53;
    out.setBCurrentRoadNameAvailable(o53);
    ::std::string o54;
    in >> o54;
    out.setCurrentRoadName(o54);
    bool o55;
    in >> o55;
    out.setBDestinationNameAvailable(o55);
    ::std::string o56;
    in >> o56;
    out.setDestinationName(o56);
    bool o57;
    in >> o57;
    out.setBEstimatedTimeOfArrivalAvailable(o57);
    uint64 o58;
    in >> o58;
    out.setEstimatedTimeOfArrival(o58);
    bool o59;
    in >> o59;
    out.setBTimeRemainingToDestinationAvailable(o59);
    uint64 o60;
    in >> o60;
    out.setTimeRemainingToDestination(o60);
    bool o61;
    in >> o61;
    out.setBDistanceRemainingAvailable(o61);
    uint32 o62;
    in >> o62;
    out.setDistanceRemaining(o62);
    bool o63;
    in >> o63;
    out.setBDistanceRemainingDisplayStrAvailable(o63);
    ::std::string o64;
    in >> o64;
    out.setDistanceRemainingDisplayStr(o64);
    bool o65;
    in >> o65;
    out.setBDistanceRemainingDisplayUnitsAvailable(o65);
    uint8 o66;
    in >> o66;
    out.setE8DistanceRemainingDisplayUnits((::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits)o66);
    bool o67;
    in >> o67;
    out.setBDistanceToNextManeuverAvailable(o67);
    uint32 o68;
    in >> o68;
    out.setDistanceToNextManeuver(o68);
    bool o69;
    in >> o69;
    out.setBDistanceToNextManeuverDisplayStrAvailable(o69);
    ::std::string o70;
    in >> o70;
    out.setDistanceToNextManeuverDisplayStr(o70);
    bool o71;
    in >> o71;
    out.setBDistanceToNextManeuverDisplayUnitsAvailable(o71);
    uint8 o72;
    in >> o72;
    out.setE8DistanceToNextManeuverDisplayUnits((::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits)o72);
    bool o73;
    in >> o73;
    out.setBRouteGuidanceManeuverCurrentListAvailable(o73);
    {
        uint32 o74;
        in >> o74;
        out.getRouteGuidanceManeuverCurrentListMutable().clear ();
        out.getRouteGuidanceManeuverCurrentListMutable().reserve (o74);
        for (uint32 o75 = 0; o75 < o74; o75++) {
            uint16 o76;
            in >> o76;
            out.getRouteGuidanceManeuverCurrentListMutable().push_back(o76);
        }
    }
    bool o77;
    in >> o77;
    out.setBRouteGuidanceManeuverCountAvailable(o77);
    uint16 o78;
    in >> o78;
    out.setRouteGuidanceManeuverCount(o78);
    bool o79;
    in >> o79;
    out.setBRouteGuidanceVisibleInAppAvailable(o79);
    bool o80;
    in >> o80;
    out.setRouteGuidanceVisibleInApp(o80);
    bool o81;
    in >> o81;
    out.setBSourceNameAvailable(o81);
    ::std::string o82;
    in >> o82;
    out.setSourceName(o82);
    bool o83;
    in >> o83;
    out.setBSourceSupportsRouteGuidanceAvailable(o83);
    bool o84;
    in >> o84;
    out.setSourceSupportsRouteGuidance(o84);
}

void serializeCca(const ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBRouteGuidanceDisplayComponentIDsAvailable();
    {
        uint32 o85 = static_cast<uint32>(in.getRouteGuidanceDisplayComponentIDs().size());
        out << o85;
        ::std::vector< uint16 >::const_iterator o86;
        for (o86 = in.getRouteGuidanceDisplayComponentIDs().begin(); o86 != in.getRouteGuidanceDisplayComponentIDs().end(); ++o86) {
            out << (*o86);
        }
    }
    out << (uint8) in.getBIndexAvailable();
    out << in.getIndex();
    out << (uint8) in.getBManeuverDescriptionAvailable();
    out << in.getManeuverDescription();
    out << (uint8) in.getBManeuverTypeAvailable();
    out << (uint8) in.getE8ManeuverType();
    out << (uint8) in.getBAfterManeuverRoadNameAvailable();
    out << in.getAfterManeuverRoadName();
    out << (uint8) in.getBDistanceBetweenManeuverAvailable();
    out << in.getDistanceBetweenManeuver();
    out << (uint8) in.getBDistanceBetweenManeuverDisplayStrAvailable();
    out << in.getDistanceBetweenManeuverDisplayStr();
    out << (uint8) in.getBDistanceBetweenManeuverDisplayUnitsAvailable();
    out << (uint8) in.getE8DistanceBetweenManeuverDisplayUnits();
    out << (uint8) in.getBDrivingSideAvailable();
    out << (uint8) in.getE8DrivingSide();
    out << (uint8) in.getBJunctionTypeAvailable();
    out << (uint8) in.getE8JunctionType();
    out << (uint8) in.getBJunctionElementAngleAvailable();
    {
        uint32 o87 = static_cast<uint32>(in.getJunctionElementAngle().size());
        out << o87;
        ::std::vector< int16 >::const_iterator o88;
        for (o88 = in.getJunctionElementAngle().begin(); o88 != in.getJunctionElementAngle().end(); ++o88) {
            out << (*o88);
        }
    }
    out << (uint8) in.getBJunctionElementExitAngleAvailable();
    out << in.getJunctionElementExitAngle();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o89;
    in >> o89;
    out.setBRouteGuidanceDisplayComponentIDsAvailable(o89);
    {
        uint32 o90;
        in >> o90;
        out.getRouteGuidanceDisplayComponentIDsMutable().clear ();
        out.getRouteGuidanceDisplayComponentIDsMutable().reserve (o90);
        for (uint32 o91 = 0; o91 < o90; o91++) {
            uint16 o92;
            in >> o92;
            out.getRouteGuidanceDisplayComponentIDsMutable().push_back(o92);
        }
    }
    bool o93;
    in >> o93;
    out.setBIndexAvailable(o93);
    uint16 o94;
    in >> o94;
    out.setIndex(o94);
    bool o95;
    in >> o95;
    out.setBManeuverDescriptionAvailable(o95);
    ::std::string o96;
    in >> o96;
    out.setManeuverDescription(o96);
    bool o97;
    in >> o97;
    out.setBManeuverTypeAvailable(o97);
    uint8 o98;
    in >> o98;
    out.setE8ManeuverType((::mplay_appcontrol_fi_types::T_e8_ManeuverType)o98);
    bool o99;
    in >> o99;
    out.setBAfterManeuverRoadNameAvailable(o99);
    ::std::string o100;
    in >> o100;
    out.setAfterManeuverRoadName(o100);
    bool o101;
    in >> o101;
    out.setBDistanceBetweenManeuverAvailable(o101);
    uint32 o102;
    in >> o102;
    out.setDistanceBetweenManeuver(o102);
    bool o103;
    in >> o103;
    out.setBDistanceBetweenManeuverDisplayStrAvailable(o103);
    ::std::string o104;
    in >> o104;
    out.setDistanceBetweenManeuverDisplayStr(o104);
    bool o105;
    in >> o105;
    out.setBDistanceBetweenManeuverDisplayUnitsAvailable(o105);
    uint8 o106;
    in >> o106;
    out.setE8DistanceBetweenManeuverDisplayUnits((::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits)o106);
    bool o107;
    in >> o107;
    out.setBDrivingSideAvailable(o107);
    uint8 o108;
    in >> o108;
    out.setE8DrivingSide((::mplay_appcontrol_fi_types::T_e8_DrivingSide)o108);
    bool o109;
    in >> o109;
    out.setBJunctionTypeAvailable(o109);
    uint8 o110;
    in >> o110;
    out.setE8JunctionType((::mplay_appcontrol_fi_types::T_e8_JunctionType)o110);
    bool o111;
    in >> o111;
    out.setBJunctionElementAngleAvailable(o111);
    {
        uint32 o112;
        in >> o112;
        out.getJunctionElementAngleMutable().clear ();
        out.getJunctionElementAngleMutable().reserve (o112);
        for (uint32 o113 = 0; o113 < o112; o113++) {
            int16 o114;
            in >> o114;
            out.getJunctionElementAngleMutable().push_back(o114);
        }
    }
    bool o115;
    in >> o115;
    out.setBJunctionElementExitAngleAvailable(o115);
    int16 o116;
    in >> o116;
    out.setJunctionElementExitAngle(o116);
}

void serializeCca(const ::mplay_appcontrol_fi_types::T_CallControlsConfiguration& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getInitiateCall()) {
        bitmask |= (1 << 0);
    }
    if (in.getAcceptCall()) {
        bitmask |= (1 << 1);
    }
    if (in.getEndCall()) {
        bitmask |= (1 << 2);
    }
    if (in.getSwapCalls()) {
        bitmask |= (1 << 3);
    }
    if (in.getMergeCalls()) {
        bitmask |= (1 << 4);
    }
    if (in.getHoldStatusUpdate()) {
        bitmask |= (1 << 5);
    }
    if (in.getMuteStatusUpdate()) {
        bitmask |= (1 << 6);
    }
    if (in.getSendDTMF()) {
        bitmask |= (1 << 7);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::mplay_appcontrol_fi_types::T_CallControlsConfiguration& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o117;
    in >> o117;
    uint8 bitmask(o117);

    if (bitmask & (1 << 0)) {
        out.setInitiateCall (true);
    }
    if (bitmask & (1 << 1)) {
        out.setAcceptCall (true);
    }
    if (bitmask & (1 << 2)) {
        out.setEndCall (true);
    }
    if (bitmask & (1 << 3)) {
        out.setSwapCalls (true);
    }
    if (bitmask & (1 << 4)) {
        out.setMergeCalls (true);
    }
    if (bitmask & (1 << 5)) {
        out.setHoldStatusUpdate (true);
    }
    if (bitmask & (1 << 6)) {
        out.setMuteStatusUpdate (true);
    }
    if (bitmask & (1 << 7)) {
        out.setSendDTMF (true);
    }
}

void serializeCca(const ::mplay_appcontrol_fi_types::T_AppInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSAppName();
    out << in.getSProtocol();
    out << in.getSBundleID();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::mplay_appcontrol_fi_types::T_AppInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o118;
    in >> o118;
    out.setSAppName(o118);
    ::std::string o119;
    in >> o119;
    out.setSProtocol(o119);
    ::std::string o120;
    in >> o120;
    out.setSBundleID(o120);
}

void serializeCca(const ::mplay_appcontrol_fi_types::T_DeviceTimeUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU64SecondsSinceReferenceDate();
    out << in.getS16TimeZoneOffsetMinutes();
    out << in.getS8DaylightSavingsOffsetMinutes();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::mplay_appcontrol_fi_types::T_DeviceTimeUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint64 o121;
    in >> o121;
    out.setU64SecondsSinceReferenceDate(o121);
    int16 o122;
    in >> o122;
    out.setS16TimeZoneOffsetMinutes(o122);
    int8 o123;
    in >> o123;
    out.setS8DaylightSavingsOffsetMinutes(o123);
}

