#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MPLAY_APPCONTROL_FI_TYPES_H
#define MPLAY_APPCONTROL_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "mplay_appcontrol_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types mplay_appcontrol_fi_types
 */

namespace mplay_appcontrol_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_DiPODeviceInfoItem;

class T_b8_DiPOLocationInfoType;

class T_b8_DiPOGPRMCDataStatusValues;

class T_b32_BTProfileType;

class T_BTProfileItem;

class T_DiPOCallStateItem;

class T_RouteGuidanceDisplayComponentItem;

class T_RouteGuidanceUpdate;

class T_RouteGuidanceManeuverUpdate;

class T_CallControlsConfiguration;

class T_AppInfo;

class T_DeviceTimeUpdate;

// type definitions
/**
 * If the meaning of "T_DiPODeviceInfo" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_DiPODeviceInfoItem > T_DiPODeviceInfo;

/**
 * If the meaning of "T_DiPOImageData" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_DiPOImageData;

/**
 * If the meaning of "T_BTProfileInfo" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_BTProfileItem > T_BTProfileInfo;

/**
 * If the meaning of "T_DiPOCallStateUpdate" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_DiPOCallStateItem > T_DiPOCallStateUpdate;

/**
 * If the meaning of "T_RouteGuidanceDisplayComponentIDs" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint16 > T_RouteGuidanceDisplayComponentIDs;

/**
 * If the meaning of "T_RouteGuidanceManeuverCurrentList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint16 > T_RouteGuidanceManeuverCurrentList;

/**
 * If the meaning of "T_JunctionElementAngles" isn't clear, then there should be a description here.
 */
typedef ::std::vector< int16 > T_JunctionElementAngles;

/**
 * If the meaning of "T_RouteGuidanceDisplayComponents" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_RouteGuidanceDisplayComponentItem > T_RouteGuidanceDisplayComponents;


/**
 * DeviceTag, DeviceName, DeviceType, DeviceSerialNumber, DeviceConnected, DeviceActiveSource,
 */
class T_DiPODeviceInfoItem {
public:

    /**
     * Default constructor
     */
    inline  T_DiPODeviceInfoItem ();

    /**
     * Copy constructor
     */
    inline  T_DiPODeviceInfoItem (const T_DiPODeviceInfoItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_DiPODeviceInfoItem (uint8 u8DeviceTag_, const ::std::string& sDeviceName_, T_e8_DiPODeviceType e8DeviceType_, const ::std::string& sDeviceSerialNumber_, bool bDeviceConnected_, bool bDeviceActiveSource_, bool bDiPOCapable_, bool bDiPOActive_, const ::std::string& sDiPOVersion_, T_e8_DiPOConnectionType e8ConnectionType_, T_e8_DiPOConnectionState e8ConnectionState_, const ::std::string& sMountPoint_, const ::std::string& sAccessoryName_, T_e8_DiPOCaps e8DiPOCaps_, T_e8_DiPODeviceStatus e8DeviceState_, const ::std::string& sDeviceUUID_, const ::std::string& sDeviceBTMacAddress_, const ::std::string& sDeviceUSBSerialNumber_);

    /**
     * Destructor
     */
    inline  ~T_DiPODeviceInfoItem();

    /**
     * Assignment operator
     */
    inline T_DiPODeviceInfoItem& operator = (const T_DiPODeviceInfoItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DiPODeviceInfoItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DiPODeviceInfoItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DiPODeviceInfoItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DiPODeviceInfoItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 0;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "sDeviceName"

    static const int kSDeviceName = 1;

    /**
     * Clears the field "sDeviceName".
     *
     * The field will be set to its default value. The hasSDeviceName()
     * method will return false.
     */
    inline void clearSDeviceName();

    /**
     * Checks whether the field "sDeviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceName()). Otherwise it will return false.
     */
    inline bool hasSDeviceName () const;

    /**
     * Returns the value of the member "sDeviceName".
     *
     * Name of the device (friendly name)
     *
     * @return The value of the field "sDeviceName"
     */
    inline const ::std::string& getSDeviceName () const;

    /**
     * Retrieves the value of the field "sDeviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceName".
     */
    inline ::std::string& getSDeviceNameMutable ();

    /**
     * Sets the value of the member "sDeviceName".
     *
     * Name of the device (friendly name)
     *
     * @param sDeviceName The value which will be set
     */
    inline void setSDeviceName (const ::std::string& sDeviceName_);

    /**
     * Sets the value of the member "sDeviceName".
     *
     * Name of the device (friendly name)
     *
     * @param sDeviceName The value which will be set
     */
    inline void setSDeviceName (const char* sDeviceName_);

    /**
     * Sets the value of the member "sDeviceName".
     *
     * Name of the device (friendly name)
     *
     * @param sDeviceName The value which will be set
     */
    inline void setSDeviceName (const char* value, size_t size);

    // API of field "e8DeviceType"

    static const int kE8DeviceType = 2;

    /**
     * Clears the field "e8DeviceType".
     *
     * The field will be set to its default value. The hasE8DeviceType()
     * method will return false.
     */
    inline void clearE8DeviceType();

    /**
     * Checks whether the field "e8DeviceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DeviceType()). Otherwise it will return false.
     */
    inline bool hasE8DeviceType () const;

    /**
     * Returns the value of the member "e8DeviceType".
     *
     * Type of device on which the media object is stored.
     *
     * @return The value of the field "e8DeviceType"
     */
    inline T_e8_DiPODeviceType getE8DeviceType () const;

    /**
     * Sets the value of the member "e8DeviceType".
     *
     * Type of device on which the media object is stored.
     *
     * @param e8DeviceType The value which will be set
     */
    inline void setE8DeviceType (T_e8_DiPODeviceType e8DeviceType_);

    // API of field "sDeviceSerialNumber"

    static const int kSDeviceSerialNumber = 3;

    /**
     * Clears the field "sDeviceSerialNumber".
     *
     * The field will be set to its default value. The hasSDeviceSerialNumber()
     * method will return false.
     */
    inline void clearSDeviceSerialNumber();

    /**
     * Checks whether the field "sDeviceSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceSerialNumber()). Otherwise it will return false.
     */
    inline bool hasSDeviceSerialNumber () const;

    /**
     * Returns the value of the member "sDeviceSerialNumber".
     *
     * The serial number (or other device-specific unique identifer) of the device
     *
     * @return The value of the field "sDeviceSerialNumber"
     */
    inline const ::std::string& getSDeviceSerialNumber () const;

    /**
     * Retrieves the value of the field "sDeviceSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceSerialNumber".
     */
    inline ::std::string& getSDeviceSerialNumberMutable ();

    /**
     * Sets the value of the member "sDeviceSerialNumber".
     *
     * The serial number (or other device-specific unique identifer) of the device
     *
     * @param sDeviceSerialNumber The value which will be set
     */
    inline void setSDeviceSerialNumber (const ::std::string& sDeviceSerialNumber_);

    /**
     * Sets the value of the member "sDeviceSerialNumber".
     *
     * The serial number (or other device-specific unique identifer) of the device
     *
     * @param sDeviceSerialNumber The value which will be set
     */
    inline void setSDeviceSerialNumber (const char* sDeviceSerialNumber_);

    /**
     * Sets the value of the member "sDeviceSerialNumber".
     *
     * The serial number (or other device-specific unique identifer) of the device
     *
     * @param sDeviceSerialNumber The value which will be set
     */
    inline void setSDeviceSerialNumber (const char* value, size_t size);

    // API of field "bDeviceConnected"

    static const int kBDeviceConnected = 4;

    /**
     * Clears the field "bDeviceConnected".
     *
     * The field will be set to its default value. The hasBDeviceConnected()
     * method will return false.
     */
    inline void clearBDeviceConnected();

    /**
     * Checks whether the field "bDeviceConnected" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDeviceConnected()). Otherwise it will return false.
     */
    inline bool hasBDeviceConnected () const;

    /**
     * Returns the value of the member "bDeviceConnected".
     *
     * Indicates whether a device is currently connected to the vehicle. The value is "True" if the device is connected and "False" if the device is not connected.
     *
     * @return The value of the field "bDeviceConnected"
     */
    inline bool getBDeviceConnected () const;

    /**
     * Sets the value of the member "bDeviceConnected".
     *
     * Indicates whether a device is currently connected to the vehicle. The value is "True" if the device is connected and "False" if the device is not connected.
     *
     * @param bDeviceConnected The value which will be set
     */
    inline void setBDeviceConnected (bool bDeviceConnected_);

    // API of field "bDeviceActiveSource"

    static const int kBDeviceActiveSource = 5;

    /**
     * Clears the field "bDeviceActiveSource".
     *
     * The field will be set to its default value. The hasBDeviceActiveSource()
     * method will return false.
     */
    inline void clearBDeviceActiveSource();

    /**
     * Checks whether the field "bDeviceActiveSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDeviceActiveSource()). Otherwise it will return false.
     */
    inline bool hasBDeviceActiveSource () const;

    /**
     * Returns the value of the member "bDeviceActiveSource".
     *
     * Identifies whether a connected device is the active media source.  The value is "True" if the device is the active media source and the value is "False" if the device is not the active media source.
     *
     * @return The value of the field "bDeviceActiveSource"
     */
    inline bool getBDeviceActiveSource () const;

    /**
     * Sets the value of the member "bDeviceActiveSource".
     *
     * Identifies whether a connected device is the active media source.  The value is "True" if the device is the active media source and the value is "False" if the device is not the active media source.
     *
     * @param bDeviceActiveSource The value which will be set
     */
    inline void setBDeviceActiveSource (bool bDeviceActiveSource_);

    // API of field "bDiPOCapable"

    static const int kBDiPOCapable = 6;

    /**
     * Clears the field "bDiPOCapable".
     *
     * The field will be set to its default value. The hasBDiPOCapable()
     * method will return false.
     */
    inline void clearBDiPOCapable();

    /**
     * Checks whether the field "bDiPOCapable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDiPOCapable()). Otherwise it will return false.
     */
    inline bool hasBDiPOCapable () const;

    /**
     * Returns the value of the member "bDiPOCapable".
     *
     * Deprecated! Use e8DiPOCaps instead.
     * Identifies whether a connected device has the capability to perform DiPO.
     * The value is "True" if the device is capable and ready prepared for running a DiPO session.
     * That includes a role switch, already performed by mediaplayer as triggered by method DiPORoleSwitchRequest.
     * If the value is "False" if the device is not capable.
     *
     * @return The value of the field "bDiPOCapable"
     */
    inline bool getBDiPOCapable () const;

    /**
     * Sets the value of the member "bDiPOCapable".
     *
     * Deprecated! Use e8DiPOCaps instead.
     * Identifies whether a connected device has the capability to perform DiPO.
     * The value is "True" if the device is capable and ready prepared for running a DiPO session.
     * That includes a role switch, already performed by mediaplayer as triggered by method DiPORoleSwitchRequest.
     * If the value is "False" if the device is not capable.
     *
     * @param bDiPOCapable The value which will be set
     */
    inline void setBDiPOCapable (bool bDiPOCapable_);

    // API of field "bDiPOActive"

    static const int kBDiPOActive = 7;

    /**
     * Clears the field "bDiPOActive".
     *
     * The field will be set to its default value. The hasBDiPOActive()
     * method will return false.
     */
    inline void clearBDiPOActive();

    /**
     * Checks whether the field "bDiPOActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDiPOActive()). Otherwise it will return false.
     */
    inline bool hasBDiPOActive () const;

    /**
     * Returns the value of the member "bDiPOActive".
     *
     * Deprecated!
     * Identifies whether a connected device is running a DiPO session.
     * This field is set once the method DiPOActiveDevice has been called to inform mediaplayer about DiPO session status.
     * The value is "True" if session is active and the value is "False" if session is not active.
     *
     * @return The value of the field "bDiPOActive"
     */
    inline bool getBDiPOActive () const;

    /**
     * Sets the value of the member "bDiPOActive".
     *
     * Deprecated!
     * Identifies whether a connected device is running a DiPO session.
     * This field is set once the method DiPOActiveDevice has been called to inform mediaplayer about DiPO session status.
     * The value is "True" if session is active and the value is "False" if session is not active.
     *
     * @param bDiPOActive The value which will be set
     */
    inline void setBDiPOActive (bool bDiPOActive_);

    // API of field "sDiPOVersion"

    static const int kSDiPOVersion = 8;

    /**
     * Clears the field "sDiPOVersion".
     *
     * The field will be set to its default value. The hasSDiPOVersion()
     * method will return false.
     */
    inline void clearSDiPOVersion();

    /**
     * Checks whether the field "sDiPOVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDiPOVersion()). Otherwise it will return false.
     */
    inline bool hasSDiPOVersion () const;

    /**
     * Returns the value of the member "sDiPOVersion".
     *
     * Deprecated!
     * DiPO version assigned by apple. If bDiPOCapable is false then this string is empty.
     *
     * @return The value of the field "sDiPOVersion"
     */
    inline const ::std::string& getSDiPOVersion () const;

    /**
     * Retrieves the value of the field "sDiPOVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDiPOVersion".
     */
    inline ::std::string& getSDiPOVersionMutable ();

    /**
     * Sets the value of the member "sDiPOVersion".
     *
     * Deprecated!
     * DiPO version assigned by apple. If bDiPOCapable is false then this string is empty.
     *
     * @param sDiPOVersion The value which will be set
     */
    inline void setSDiPOVersion (const ::std::string& sDiPOVersion_);

    /**
     * Sets the value of the member "sDiPOVersion".
     *
     * Deprecated!
     * DiPO version assigned by apple. If bDiPOCapable is false then this string is empty.
     *
     * @param sDiPOVersion The value which will be set
     */
    inline void setSDiPOVersion (const char* sDiPOVersion_);

    /**
     * Sets the value of the member "sDiPOVersion".
     *
     * Deprecated!
     * DiPO version assigned by apple. If bDiPOCapable is false then this string is empty.
     *
     * @param sDiPOVersion The value which will be set
     */
    inline void setSDiPOVersion (const char* value, size_t size);

    // API of field "e8ConnectionType"

    static const int kE8ConnectionType = 9;

    /**
     * Clears the field "e8ConnectionType".
     *
     * The field will be set to its default value. The hasE8ConnectionType()
     * method will return false.
     */
    inline void clearE8ConnectionType();

    /**
     * Checks whether the field "e8ConnectionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ConnectionType()). Otherwise it will return false.
     */
    inline bool hasE8ConnectionType () const;

    /**
     * Returns the value of the member "e8ConnectionType".
     *
     * Type of the connection.
     *
     * @return The value of the field "e8ConnectionType"
     */
    inline T_e8_DiPOConnectionType getE8ConnectionType () const;

    /**
     * Sets the value of the member "e8ConnectionType".
     *
     * Type of the connection.
     *
     * @param e8ConnectionType The value which will be set
     */
    inline void setE8ConnectionType (T_e8_DiPOConnectionType e8ConnectionType_);

    // API of field "e8ConnectionState"

    static const int kE8ConnectionState = 10;

    /**
     * Clears the field "e8ConnectionState".
     *
     * The field will be set to its default value. The hasE8ConnectionState()
     * method will return false.
     */
    inline void clearE8ConnectionState();

    /**
     * Checks whether the field "e8ConnectionState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ConnectionState()). Otherwise it will return false.
     */
    inline bool hasE8ConnectionState () const;

    /**
     * Returns the value of the member "e8ConnectionState".
     *
     * Connection state.
     *
     * @return The value of the field "e8ConnectionState"
     */
    inline T_e8_DiPOConnectionState getE8ConnectionState () const;

    /**
     * Sets the value of the member "e8ConnectionState".
     *
     * Connection state.
     *
     * @param e8ConnectionState The value which will be set
     */
    inline void setE8ConnectionState (T_e8_DiPOConnectionState e8ConnectionState_);

    // API of field "sMountPoint"

    static const int kSMountPoint = 11;

    /**
     * Clears the field "sMountPoint".
     *
     * The field will be set to its default value. The hasSMountPoint()
     * method will return false.
     */
    inline void clearSMountPoint();

    /**
     * Checks whether the field "sMountPoint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMountPoint()). Otherwise it will return false.
     */
    inline bool hasSMountPoint () const;

    /**
     * Returns the value of the member "sMountPoint".
     *
     * The path where the device has been mounted in the system
     *
     * @return The value of the field "sMountPoint"
     */
    inline const ::std::string& getSMountPoint () const;

    /**
     * Retrieves the value of the field "sMountPoint" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sMountPoint".
     */
    inline ::std::string& getSMountPointMutable ();

    /**
     * Sets the value of the member "sMountPoint".
     *
     * The path where the device has been mounted in the system
     *
     * @param sMountPoint The value which will be set
     */
    inline void setSMountPoint (const ::std::string& sMountPoint_);

    /**
     * Sets the value of the member "sMountPoint".
     *
     * The path where the device has been mounted in the system
     *
     * @param sMountPoint The value which will be set
     */
    inline void setSMountPoint (const char* sMountPoint_);

    /**
     * Sets the value of the member "sMountPoint".
     *
     * The path where the device has been mounted in the system
     *
     * @param sMountPoint The value which will be set
     */
    inline void setSMountPoint (const char* value, size_t size);

    // API of field "sAccessoryName"

    static const int kSAccessoryName = 12;

    /**
     * Clears the field "sAccessoryName".
     *
     * The field will be set to its default value. The hasSAccessoryName()
     * method will return false.
     */
    inline void clearSAccessoryName();

    /**
     * Checks whether the field "sAccessoryName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAccessoryName()). Otherwise it will return false.
     */
    inline bool hasSAccessoryName () const;

    /**
     * Returns the value of the member "sAccessoryName".
     *
     * Additional name information e.g. alsa device name
     *
     * @return The value of the field "sAccessoryName"
     */
    inline const ::std::string& getSAccessoryName () const;

    /**
     * Retrieves the value of the field "sAccessoryName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAccessoryName".
     */
    inline ::std::string& getSAccessoryNameMutable ();

    /**
     * Sets the value of the member "sAccessoryName".
     *
     * Additional name information e.g. alsa device name
     *
     * @param sAccessoryName The value which will be set
     */
    inline void setSAccessoryName (const ::std::string& sAccessoryName_);

    /**
     * Sets the value of the member "sAccessoryName".
     *
     * Additional name information e.g. alsa device name
     *
     * @param sAccessoryName The value which will be set
     */
    inline void setSAccessoryName (const char* sAccessoryName_);

    /**
     * Sets the value of the member "sAccessoryName".
     *
     * Additional name information e.g. alsa device name
     *
     * @param sAccessoryName The value which will be set
     */
    inline void setSAccessoryName (const char* value, size_t size);

    // API of field "e8DiPOCaps"

    static const int kE8DiPOCaps = 13;

    /**
     * Clears the field "e8DiPOCaps".
     *
     * The field will be set to its default value. The hasE8DiPOCaps()
     * method will return false.
     */
    inline void clearE8DiPOCaps();

    /**
     * Checks whether the field "e8DiPOCaps" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DiPOCaps()). Otherwise it will return false.
     */
    inline bool hasE8DiPOCaps () const;

    /**
     * Returns the value of the member "e8DiPOCaps".
     *
     * Capabilities for DiPO connection.
     *
     * @return The value of the field "e8DiPOCaps"
     */
    inline T_e8_DiPOCaps getE8DiPOCaps () const;

    /**
     * Sets the value of the member "e8DiPOCaps".
     *
     * Capabilities for DiPO connection.
     *
     * @param e8DiPOCaps The value which will be set
     */
    inline void setE8DiPOCaps (T_e8_DiPOCaps e8DiPOCaps_);

    // API of field "e8DeviceState"

    static const int kE8DeviceState = 14;

    /**
     * Clears the field "e8DeviceState".
     *
     * The field will be set to its default value. The hasE8DeviceState()
     * method will return false.
     */
    inline void clearE8DeviceState();

    /**
     * Checks whether the field "e8DeviceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DeviceState()). Otherwise it will return false.
     */
    inline bool hasE8DeviceState () const;

    /**
     * Returns the value of the member "e8DeviceState".
     *
     * State of the device.
     *
     * @return The value of the field "e8DeviceState"
     */
    inline T_e8_DiPODeviceStatus getE8DeviceState () const;

    /**
     * Sets the value of the member "e8DeviceState".
     *
     * State of the device.
     *
     * @param e8DeviceState The value which will be set
     */
    inline void setE8DeviceState (T_e8_DiPODeviceStatus e8DeviceState_);

    // API of field "sDeviceUUID"

    static const int kSDeviceUUID = 15;

    /**
     * Clears the field "sDeviceUUID".
     *
     * The field will be set to its default value. The hasSDeviceUUID()
     * method will return false.
     */
    inline void clearSDeviceUUID();

    /**
     * Checks whether the field "sDeviceUUID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceUUID()). Otherwise it will return false.
     */
    inline bool hasSDeviceUUID () const;

    /**
     * Returns the value of the member "sDeviceUUID".
     *
     * DeviceUUID of Apple device
     *
     * @return The value of the field "sDeviceUUID"
     */
    inline const ::std::string& getSDeviceUUID () const;

    /**
     * Retrieves the value of the field "sDeviceUUID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceUUID".
     */
    inline ::std::string& getSDeviceUUIDMutable ();

    /**
     * Sets the value of the member "sDeviceUUID".
     *
     * DeviceUUID of Apple device
     *
     * @param sDeviceUUID The value which will be set
     */
    inline void setSDeviceUUID (const ::std::string& sDeviceUUID_);

    /**
     * Sets the value of the member "sDeviceUUID".
     *
     * DeviceUUID of Apple device
     *
     * @param sDeviceUUID The value which will be set
     */
    inline void setSDeviceUUID (const char* sDeviceUUID_);

    /**
     * Sets the value of the member "sDeviceUUID".
     *
     * DeviceUUID of Apple device
     *
     * @param sDeviceUUID The value which will be set
     */
    inline void setSDeviceUUID (const char* value, size_t size);

    // API of field "sDeviceBTMacAddress"

    static const int kSDeviceBTMacAddress = 16;

    /**
     * Clears the field "sDeviceBTMacAddress".
     *
     * The field will be set to its default value. The hasSDeviceBTMacAddress()
     * method will return false.
     */
    inline void clearSDeviceBTMacAddress();

    /**
     * Checks whether the field "sDeviceBTMacAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceBTMacAddress()). Otherwise it will return false.
     */
    inline bool hasSDeviceBTMacAddress () const;

    /**
     * Returns the value of the member "sDeviceBTMacAddress".
     *
     * BT Mac Address of the Apple device
     *
     * @return The value of the field "sDeviceBTMacAddress"
     */
    inline const ::std::string& getSDeviceBTMacAddress () const;

    /**
     * Retrieves the value of the field "sDeviceBTMacAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceBTMacAddress".
     */
    inline ::std::string& getSDeviceBTMacAddressMutable ();

    /**
     * Sets the value of the member "sDeviceBTMacAddress".
     *
     * BT Mac Address of the Apple device
     *
     * @param sDeviceBTMacAddress The value which will be set
     */
    inline void setSDeviceBTMacAddress (const ::std::string& sDeviceBTMacAddress_);

    /**
     * Sets the value of the member "sDeviceBTMacAddress".
     *
     * BT Mac Address of the Apple device
     *
     * @param sDeviceBTMacAddress The value which will be set
     */
    inline void setSDeviceBTMacAddress (const char* sDeviceBTMacAddress_);

    /**
     * Sets the value of the member "sDeviceBTMacAddress".
     *
     * BT Mac Address of the Apple device
     *
     * @param sDeviceBTMacAddress The value which will be set
     */
    inline void setSDeviceBTMacAddress (const char* value, size_t size);

    // API of field "sDeviceUSBSerialNumber"

    static const int kSDeviceUSBSerialNumber = 17;

    /**
     * Clears the field "sDeviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasSDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearSDeviceUSBSerialNumber();

    /**
     * Checks whether the field "sDeviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasSDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device
     *
     * @return The value of the field "sDeviceUSBSerialNumber"
     */
    inline const ::std::string& getSDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "sDeviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceUSBSerialNumber".
     */
    inline ::std::string& getSDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* value, size_t size);

    static const T_DiPODeviceInfoItem &getDefaultInstance();

private:

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_sDeviceName ();

    inline void clear_has_sDeviceName ();

    inline void set_has_e8DeviceType ();

    inline void clear_has_e8DeviceType ();

    inline void set_has_sDeviceSerialNumber ();

    inline void clear_has_sDeviceSerialNumber ();

    inline void set_has_bDeviceConnected ();

    inline void clear_has_bDeviceConnected ();

    inline void set_has_bDeviceActiveSource ();

    inline void clear_has_bDeviceActiveSource ();

    inline void set_has_bDiPOCapable ();

    inline void clear_has_bDiPOCapable ();

    inline void set_has_bDiPOActive ();

    inline void clear_has_bDiPOActive ();

    inline void set_has_sDiPOVersion ();

    inline void clear_has_sDiPOVersion ();

    inline void set_has_e8ConnectionType ();

    inline void clear_has_e8ConnectionType ();

    inline void set_has_e8ConnectionState ();

    inline void clear_has_e8ConnectionState ();

    inline void set_has_sMountPoint ();

    inline void clear_has_sMountPoint ();

    inline void set_has_sAccessoryName ();

    inline void clear_has_sAccessoryName ();

    inline void set_has_e8DiPOCaps ();

    inline void clear_has_e8DiPOCaps ();

    inline void set_has_e8DeviceState ();

    inline void clear_has_e8DeviceState ();

    inline void set_has_sDeviceUUID ();

    inline void clear_has_sDeviceUUID ();

    inline void set_has_sDeviceBTMacAddress ();

    inline void clear_has_sDeviceBTMacAddress ();

    inline void set_has_sDeviceUSBSerialNumber ();

    inline void clear_has_sDeviceUSBSerialNumber ();

    uint32 _has_bits_[ (18 + 31) / 32];

    uint8 _u8DeviceTag;

    ::std::string _sDeviceName;

    T_e8_DiPODeviceType _e8DeviceType;

    ::std::string _sDeviceSerialNumber;

    bool _bDeviceConnected;

    bool _bDeviceActiveSource;

    bool _bDiPOCapable;

    bool _bDiPOActive;

    ::std::string _sDiPOVersion;

    T_e8_DiPOConnectionType _e8ConnectionType;

    T_e8_DiPOConnectionState _e8ConnectionState;

    ::std::string _sMountPoint;

    ::std::string _sAccessoryName;

    T_e8_DiPOCaps _e8DiPOCaps;

    T_e8_DiPODeviceStatus _e8DeviceState;

    ::std::string _sDeviceUUID;

    ::std::string _sDeviceBTMacAddress;

    ::std::string _sDeviceUSBSerialNumber;

};

/**
 * Bitfield with the location information types
 */
class T_b8_DiPOLocationInfoType {
public:

    /**
     * Default constructor
     */
    inline  T_b8_DiPOLocationInfoType ();

    /**
     * Copy constructor
     */
    inline  T_b8_DiPOLocationInfoType (const T_b8_DiPOLocationInfoType &c);

    /**
     * Field constructor
     */
    inline  T_b8_DiPOLocationInfoType (bool GPGGA, bool GPRMC, bool GPGSV, bool GPHDT, bool PASCD, bool PAGCD, bool PAACD);

    /**
     * Assignment operator
     */
    inline T_b8_DiPOLocationInfoType& operator = (const T_b8_DiPOLocationInfoType& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_DiPOLocationInfoType& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_DiPOLocationInfoType& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_DiPOLocationInfoType& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_DiPOLocationInfoType& rhs) const;

    /**
     * Sets the value of the member "GPGGA".
     *
     * If the meaning of "GPGGA" isn't clear, then there should be a description here.
     *
     * @param GPGGA The value which will be set
     */
    inline void setGPGGA (bool GPGGA);

    /**
     * Returns the value of the member "GPGGA".
     *
     * If the meaning of "GPGGA" isn't clear, then there should be a description here.
     *
     * @return The value of the field "GPGGA"
     */
    inline bool getGPGGA () const;

    /**
     * Sets the value of the member "GPRMC".
     *
     * If the meaning of "GPRMC" isn't clear, then there should be a description here.
     *
     * @param GPRMC The value which will be set
     */
    inline void setGPRMC (bool GPRMC);

    /**
     * Returns the value of the member "GPRMC".
     *
     * If the meaning of "GPRMC" isn't clear, then there should be a description here.
     *
     * @return The value of the field "GPRMC"
     */
    inline bool getGPRMC () const;

    /**
     * Sets the value of the member "GPGSV".
     *
     * If the meaning of "GPGSV" isn't clear, then there should be a description here.
     *
     * @param GPGSV The value which will be set
     */
    inline void setGPGSV (bool GPGSV);

    /**
     * Returns the value of the member "GPGSV".
     *
     * If the meaning of "GPGSV" isn't clear, then there should be a description here.
     *
     * @return The value of the field "GPGSV"
     */
    inline bool getGPGSV () const;

    /**
     * Sets the value of the member "GPHDT".
     *
     * If the meaning of "GPHDT" isn't clear, then there should be a description here.
     *
     * @param GPHDT The value which will be set
     */
    inline void setGPHDT (bool GPHDT);

    /**
     * Returns the value of the member "GPHDT".
     *
     * If the meaning of "GPHDT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "GPHDT"
     */
    inline bool getGPHDT () const;

    /**
     * Sets the value of the member "PASCD".
     *
     * If the meaning of "PASCD" isn't clear, then there should be a description here.
     *
     * @param PASCD The value which will be set
     */
    inline void setPASCD (bool PASCD);

    /**
     * Returns the value of the member "PASCD".
     *
     * If the meaning of "PASCD" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PASCD"
     */
    inline bool getPASCD () const;

    /**
     * Sets the value of the member "PAGCD".
     *
     * If the meaning of "PAGCD" isn't clear, then there should be a description here.
     *
     * @param PAGCD The value which will be set
     */
    inline void setPAGCD (bool PAGCD);

    /**
     * Returns the value of the member "PAGCD".
     *
     * If the meaning of "PAGCD" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PAGCD"
     */
    inline bool getPAGCD () const;

    /**
     * Sets the value of the member "PAACD".
     *
     * If the meaning of "PAACD" isn't clear, then there should be a description here.
     *
     * @param PAACD The value which will be set
     */
    inline void setPAACD (bool PAACD);

    /**
     * Returns the value of the member "PAACD".
     *
     * If the meaning of "PAACD" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PAACD"
     */
    inline bool getPAACD () const;

    static const T_b8_DiPOLocationInfoType &getDefaultInstance();

private:

    bool _GPGGA:1;

    bool _GPRMC:1;

    bool _GPGSV:1;

    bool _GPHDT:1;

    bool _PASCD:1;

    bool _PAGCD:1;

    bool _PAACD:1;

};

/**
 * Bitfield with the GPRMC Data Status Values
 */
class T_b8_DiPOGPRMCDataStatusValues {
public:

    /**
     * Default constructor
     */
    inline  T_b8_DiPOGPRMCDataStatusValues ();

    /**
     * Copy constructor
     */
    inline  T_b8_DiPOGPRMCDataStatusValues (const T_b8_DiPOGPRMCDataStatusValues &c);

    /**
     * Field constructor
     */
    inline  T_b8_DiPOGPRMCDataStatusValues (bool GPRMCDataStatusValueA, bool GPRMCDataStatusValueV, bool GPRMCDataStatusValueX);

    /**
     * Assignment operator
     */
    inline T_b8_DiPOGPRMCDataStatusValues& operator = (const T_b8_DiPOGPRMCDataStatusValues& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_DiPOGPRMCDataStatusValues& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_DiPOGPRMCDataStatusValues& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_DiPOGPRMCDataStatusValues& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_DiPOGPRMCDataStatusValues& rhs) const;

    /**
     * Sets the value of the member "GPRMCDataStatusValueA".
     *
     * If the meaning of "GPRMCDataStatusValueA" isn't clear, then there should be a description here.
     *
     * @param GPRMCDataStatusValueA The value which will be set
     */
    inline void setGPRMCDataStatusValueA (bool GPRMCDataStatusValueA);

    /**
     * Returns the value of the member "GPRMCDataStatusValueA".
     *
     * If the meaning of "GPRMCDataStatusValueA" isn't clear, then there should be a description here.
     *
     * @return The value of the field "GPRMCDataStatusValueA"
     */
    inline bool getGPRMCDataStatusValueA () const;

    /**
     * Sets the value of the member "GPRMCDataStatusValueV".
     *
     * If the meaning of "GPRMCDataStatusValueV" isn't clear, then there should be a description here.
     *
     * @param GPRMCDataStatusValueV The value which will be set
     */
    inline void setGPRMCDataStatusValueV (bool GPRMCDataStatusValueV);

    /**
     * Returns the value of the member "GPRMCDataStatusValueV".
     *
     * If the meaning of "GPRMCDataStatusValueV" isn't clear, then there should be a description here.
     *
     * @return The value of the field "GPRMCDataStatusValueV"
     */
    inline bool getGPRMCDataStatusValueV () const;

    /**
     * Sets the value of the member "GPRMCDataStatusValueX".
     *
     * If the meaning of "GPRMCDataStatusValueX" isn't clear, then there should be a description here.
     *
     * @param GPRMCDataStatusValueX The value which will be set
     */
    inline void setGPRMCDataStatusValueX (bool GPRMCDataStatusValueX);

    /**
     * Returns the value of the member "GPRMCDataStatusValueX".
     *
     * If the meaning of "GPRMCDataStatusValueX" isn't clear, then there should be a description here.
     *
     * @return The value of the field "GPRMCDataStatusValueX"
     */
    inline bool getGPRMCDataStatusValueX () const;

    static const T_b8_DiPOGPRMCDataStatusValues &getDefaultInstance();

private:

    bool _GPRMCDataStatusValueA:1;

    bool _GPRMCDataStatusValueV:1;

    bool _GPRMCDataStatusValueX:1;

};

/**
 * Bitfield of BT profiles
 */
class T_b32_BTProfileType {
public:

    /**
     * Default constructor
     */
    inline  T_b32_BTProfileType ();

    /**
     * Copy constructor
     */
    inline  T_b32_BTProfileType (const T_b32_BTProfileType &c);

    /**
     * Field constructor
     */
    inline  T_b32_BTProfileType (bool HandsFree, bool PhoneBookAccess, bool AudioVideoRemoteControl, bool AdvancedAudioDistribution, bool HumanInterfaceDevice, bool iAP2Link, bool PersonalAreaNetworkAccessPoint, bool MessageAccess, bool PersonalAreaNetworkClient);

    /**
     * Assignment operator
     */
    inline T_b32_BTProfileType& operator = (const T_b32_BTProfileType& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b32_BTProfileType& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b32_BTProfileType& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b32_BTProfileType& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b32_BTProfileType& rhs) const;

    /**
     * Sets the value of the member "HandsFree".
     *
     * If the meaning of "HandsFree" isn't clear, then there should be a description here.
     *
     * @param HandsFree The value which will be set
     */
    inline void setHandsFree (bool HandsFree);

    /**
     * Returns the value of the member "HandsFree".
     *
     * If the meaning of "HandsFree" isn't clear, then there should be a description here.
     *
     * @return The value of the field "HandsFree"
     */
    inline bool getHandsFree () const;

    /**
     * Sets the value of the member "PhoneBookAccess".
     *
     * If the meaning of "PhoneBookAccess" isn't clear, then there should be a description here.
     *
     * @param PhoneBookAccess The value which will be set
     */
    inline void setPhoneBookAccess (bool PhoneBookAccess);

    /**
     * Returns the value of the member "PhoneBookAccess".
     *
     * If the meaning of "PhoneBookAccess" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PhoneBookAccess"
     */
    inline bool getPhoneBookAccess () const;

    /**
     * Sets the value of the member "AudioVideoRemoteControl".
     *
     * If the meaning of "AudioVideoRemoteControl" isn't clear, then there should be a description here.
     *
     * @param AudioVideoRemoteControl The value which will be set
     */
    inline void setAudioVideoRemoteControl (bool AudioVideoRemoteControl);

    /**
     * Returns the value of the member "AudioVideoRemoteControl".
     *
     * If the meaning of "AudioVideoRemoteControl" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudioVideoRemoteControl"
     */
    inline bool getAudioVideoRemoteControl () const;

    /**
     * Sets the value of the member "AdvancedAudioDistribution".
     *
     * If the meaning of "AdvancedAudioDistribution" isn't clear, then there should be a description here.
     *
     * @param AdvancedAudioDistribution The value which will be set
     */
    inline void setAdvancedAudioDistribution (bool AdvancedAudioDistribution);

    /**
     * Returns the value of the member "AdvancedAudioDistribution".
     *
     * If the meaning of "AdvancedAudioDistribution" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AdvancedAudioDistribution"
     */
    inline bool getAdvancedAudioDistribution () const;

    /**
     * Sets the value of the member "HumanInterfaceDevice".
     *
     * If the meaning of "HumanInterfaceDevice" isn't clear, then there should be a description here.
     *
     * @param HumanInterfaceDevice The value which will be set
     */
    inline void setHumanInterfaceDevice (bool HumanInterfaceDevice);

    /**
     * Returns the value of the member "HumanInterfaceDevice".
     *
     * If the meaning of "HumanInterfaceDevice" isn't clear, then there should be a description here.
     *
     * @return The value of the field "HumanInterfaceDevice"
     */
    inline bool getHumanInterfaceDevice () const;

    /**
     * Sets the value of the member "iAP2Link".
     *
     * If the meaning of "iAP2Link" isn't clear, then there should be a description here.
     *
     * @param iAP2Link The value which will be set
     */
    inline void setIAP2Link (bool iAP2Link);

    /**
     * Returns the value of the member "iAP2Link".
     *
     * If the meaning of "iAP2Link" isn't clear, then there should be a description here.
     *
     * @return The value of the field "iAP2Link"
     */
    inline bool getIAP2Link () const;

    /**
     * Sets the value of the member "PersonalAreaNetworkAccessPoint".
     *
     * If the meaning of "PersonalAreaNetworkAccessPoint" isn't clear, then there should be a description here.
     *
     * @param PersonalAreaNetworkAccessPoint The value which will be set
     */
    inline void setPersonalAreaNetworkAccessPoint (bool PersonalAreaNetworkAccessPoint);

    /**
     * Returns the value of the member "PersonalAreaNetworkAccessPoint".
     *
     * If the meaning of "PersonalAreaNetworkAccessPoint" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PersonalAreaNetworkAccessPoint"
     */
    inline bool getPersonalAreaNetworkAccessPoint () const;

    /**
     * Sets the value of the member "MessageAccess".
     *
     * If the meaning of "MessageAccess" isn't clear, then there should be a description here.
     *
     * @param MessageAccess The value which will be set
     */
    inline void setMessageAccess (bool MessageAccess);

    /**
     * Returns the value of the member "MessageAccess".
     *
     * If the meaning of "MessageAccess" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MessageAccess"
     */
    inline bool getMessageAccess () const;

    /**
     * Sets the value of the member "PersonalAreaNetworkClient".
     *
     * If the meaning of "PersonalAreaNetworkClient" isn't clear, then there should be a description here.
     *
     * @param PersonalAreaNetworkClient The value which will be set
     */
    inline void setPersonalAreaNetworkClient (bool PersonalAreaNetworkClient);

    /**
     * Returns the value of the member "PersonalAreaNetworkClient".
     *
     * If the meaning of "PersonalAreaNetworkClient" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PersonalAreaNetworkClient"
     */
    inline bool getPersonalAreaNetworkClient () const;

    static const T_b32_BTProfileType &getDefaultInstance();

private:

    bool _HandsFree:1;

    bool _PhoneBookAccess:1;

    bool _AudioVideoRemoteControl:1;

    bool _AdvancedAudioDistribution:1;

    bool _HumanInterfaceDevice:1;

    bool _iAP2Link:1;

    bool _PersonalAreaNetworkAccessPoint:1;

    bool _MessageAccess:1;

    bool _PersonalAreaNetworkClient:1;

};

/**
 * BT profile information
 */
class T_BTProfileItem {
public:

    /**
     * Default constructor
     */
    inline  T_BTProfileItem ();

    /**
     * Copy constructor
     */
    inline  T_BTProfileItem (const T_BTProfileItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTProfileItem (uint8 u8DeviceId_, const T_b32_BTProfileType& b32BTProfile_);

    /**
     * Destructor
     */
    inline  ~T_BTProfileItem();

    /**
     * Assignment operator
     */
    inline T_BTProfileItem& operator = (const T_BTProfileItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTProfileItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTProfileItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTProfileItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTProfileItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceId"

    static const int kU8DeviceId = 0;

    /**
     * Clears the field "u8DeviceId".
     *
     * The field will be set to its default value. The hasU8DeviceId()
     * method will return false.
     */
    inline void clearU8DeviceId();

    /**
     * Checks whether the field "u8DeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceId()). Otherwise it will return false.
     */
    inline bool hasU8DeviceId () const;

    /**
     * Returns the value of the member "u8DeviceId".
     *
     * Unique device identifier
     *
     * @return The value of the field "u8DeviceId"
     */
    inline uint8 getU8DeviceId () const;

    /**
     * Sets the value of the member "u8DeviceId".
     *
     * Unique device identifier
     *
     * @param u8DeviceId The value which will be set
     */
    inline void setU8DeviceId (uint8 u8DeviceId_);

    // API of field "b32BTProfile"

    static const int kB32BTProfile = 1;

    /**
     * Clears the field "b32BTProfile".
     *
     * The field will be set to its default value. The hasB32BTProfile()
     * method will return false.
     */
    inline void clearB32BTProfile();

    /**
     * Checks whether the field "b32BTProfile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB32BTProfile()). Otherwise it will return false.
     */
    inline bool hasB32BTProfile () const;

    /**
     * Returns the value of the member "b32BTProfile".
     *
     * Bitfield of BT profile
     *
     * @return The value of the field "b32BTProfile"
     */
    inline const T_b32_BTProfileType& getB32BTProfile () const;

    /**
     * Retrieves the value of the field "b32BTProfile" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b32BTProfile".
     */
    inline T_b32_BTProfileType& getB32BTProfileMutable ();

    /**
     * Sets the value of the member "b32BTProfile".
     *
     * Bitfield of BT profile
     *
     * @param b32BTProfile The value which will be set
     */
    inline void setB32BTProfile (const T_b32_BTProfileType& b32BTProfile_);

    static const T_BTProfileItem &getDefaultInstance();

private:

    inline void set_has_u8DeviceId ();

    inline void clear_has_u8DeviceId ();

    inline void set_has_b32BTProfile ();

    inline void clear_has_b32BTProfile ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceId;

    T_b32_BTProfileType _b32BTProfile;

};

/**
 * CallStateUpdate parameters according iAP2 Spec.
 */
class T_DiPOCallStateItem {
public:

    /**
     * Default constructor
     */
    inline  T_DiPOCallStateItem ();

    /**
     * Copy constructor
     */
    inline  T_DiPOCallStateItem (const T_DiPOCallStateItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_DiPOCallStateItem (const ::std::string& sRemoteID_, const ::std::string& sDisplayName_, T_e8_DiPOCallStateUpdateStatus eStatus_, T_e8_DiPOCallStateUpdateDirection eDirection_, const ::std::string& sCallUUID_, const ::std::string& sAddressBookID_, const ::std::string& sLabel_, T_e8_DiPOCallStateUpdateService eService_, bool bIsConferenced_, uint8 u8ConferenceGroup_, T_e8_DiPOCallStateUpdateDisconnectReason eDisconnectReason_, uint64 u64StartTimestamp_);

    /**
     * Destructor
     */
    inline  ~T_DiPOCallStateItem();

    /**
     * Assignment operator
     */
    inline T_DiPOCallStateItem& operator = (const T_DiPOCallStateItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DiPOCallStateItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DiPOCallStateItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DiPOCallStateItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DiPOCallStateItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sRemoteID"

    static const int kSRemoteID = 0;

    /**
     * Clears the field "sRemoteID".
     *
     * The field will be set to its default value. The hasSRemoteID()
     * method will return false.
     */
    inline void clearSRemoteID();

    /**
     * Checks whether the field "sRemoteID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSRemoteID()). Otherwise it will return false.
     */
    inline bool hasSRemoteID () const;

    /**
     * Returns the value of the member "sRemoteID".
     *
     * Remote phone number or email
     *
     * @return The value of the field "sRemoteID"
     */
    inline const ::std::string& getSRemoteID () const;

    /**
     * Retrieves the value of the field "sRemoteID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sRemoteID".
     */
    inline ::std::string& getSRemoteIDMutable ();

    /**
     * Sets the value of the member "sRemoteID".
     *
     * Remote phone number or email
     *
     * @param sRemoteID The value which will be set
     */
    inline void setSRemoteID (const ::std::string& sRemoteID_);

    /**
     * Sets the value of the member "sRemoteID".
     *
     * Remote phone number or email
     *
     * @param sRemoteID The value which will be set
     */
    inline void setSRemoteID (const char* sRemoteID_);

    /**
     * Sets the value of the member "sRemoteID".
     *
     * Remote phone number or email
     *
     * @param sRemoteID The value which will be set
     */
    inline void setSRemoteID (const char* value, size_t size);

    // API of field "sDisplayName"

    static const int kSDisplayName = 1;

    /**
     * Clears the field "sDisplayName".
     *
     * The field will be set to its default value. The hasSDisplayName()
     * method will return false.
     */
    inline void clearSDisplayName();

    /**
     * Checks whether the field "sDisplayName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDisplayName()). Otherwise it will return false.
     */
    inline bool hasSDisplayName () const;

    /**
     * Returns the value of the member "sDisplayName".
     *
     * Caller display name on phone
     *
     * @return The value of the field "sDisplayName"
     */
    inline const ::std::string& getSDisplayName () const;

    /**
     * Retrieves the value of the field "sDisplayName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDisplayName".
     */
    inline ::std::string& getSDisplayNameMutable ();

    /**
     * Sets the value of the member "sDisplayName".
     *
     * Caller display name on phone
     *
     * @param sDisplayName The value which will be set
     */
    inline void setSDisplayName (const ::std::string& sDisplayName_);

    /**
     * Sets the value of the member "sDisplayName".
     *
     * Caller display name on phone
     *
     * @param sDisplayName The value which will be set
     */
    inline void setSDisplayName (const char* sDisplayName_);

    /**
     * Sets the value of the member "sDisplayName".
     *
     * Caller display name on phone
     *
     * @param sDisplayName The value which will be set
     */
    inline void setSDisplayName (const char* value, size_t size);

    // API of field "eStatus"

    static const int kEStatus = 2;

    /**
     * Clears the field "eStatus".
     *
     * The field will be set to its default value. The hasEStatus()
     * method will return false.
     */
    inline void clearEStatus();

    /**
     * Checks whether the field "eStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEStatus()). Otherwise it will return false.
     */
    inline bool hasEStatus () const;

    /**
     * Returns the value of the member "eStatus".
     *
     * Call status
     *
     * @return The value of the field "eStatus"
     */
    inline T_e8_DiPOCallStateUpdateStatus getEStatus () const;

    /**
     * Sets the value of the member "eStatus".
     *
     * Call status
     *
     * @param eStatus The value which will be set
     */
    inline void setEStatus (T_e8_DiPOCallStateUpdateStatus eStatus_);

    // API of field "eDirection"

    static const int kEDirection = 3;

    /**
     * Clears the field "eDirection".
     *
     * The field will be set to its default value. The hasEDirection()
     * method will return false.
     */
    inline void clearEDirection();

    /**
     * Checks whether the field "eDirection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEDirection()). Otherwise it will return false.
     */
    inline bool hasEDirection () const;

    /**
     * Returns the value of the member "eDirection".
     *
     * Call direction
     *
     * @return The value of the field "eDirection"
     */
    inline T_e8_DiPOCallStateUpdateDirection getEDirection () const;

    /**
     * Sets the value of the member "eDirection".
     *
     * Call direction
     *
     * @param eDirection The value which will be set
     */
    inline void setEDirection (T_e8_DiPOCallStateUpdateDirection eDirection_);

    // API of field "sCallUUID"

    static const int kSCallUUID = 4;

    /**
     * Clears the field "sCallUUID".
     *
     * The field will be set to its default value. The hasSCallUUID()
     * method will return false.
     */
    inline void clearSCallUUID();

    /**
     * Checks whether the field "sCallUUID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCallUUID()). Otherwise it will return false.
     */
    inline bool hasSCallUUID () const;

    /**
     * Returns the value of the member "sCallUUID".
     *
     *
     *
     * @return The value of the field "sCallUUID"
     */
    inline const ::std::string& getSCallUUID () const;

    /**
     * Retrieves the value of the field "sCallUUID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCallUUID".
     */
    inline ::std::string& getSCallUUIDMutable ();

    /**
     * Sets the value of the member "sCallUUID".
     *
     *
     *
     * @param sCallUUID The value which will be set
     */
    inline void setSCallUUID (const ::std::string& sCallUUID_);

    /**
     * Sets the value of the member "sCallUUID".
     *
     *
     *
     * @param sCallUUID The value which will be set
     */
    inline void setSCallUUID (const char* sCallUUID_);

    /**
     * Sets the value of the member "sCallUUID".
     *
     *
     *
     * @param sCallUUID The value which will be set
     */
    inline void setSCallUUID (const char* value, size_t size);

    // API of field "sAddressBookID"

    static const int kSAddressBookID = 5;

    /**
     * Clears the field "sAddressBookID".
     *
     * The field will be set to its default value. The hasSAddressBookID()
     * method will return false.
     */
    inline void clearSAddressBookID();

    /**
     * Checks whether the field "sAddressBookID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAddressBookID()). Otherwise it will return false.
     */
    inline bool hasSAddressBookID () const;

    /**
     * Returns the value of the member "sAddressBookID".
     *
     *
     *
     * @return The value of the field "sAddressBookID"
     */
    inline const ::std::string& getSAddressBookID () const;

    /**
     * Retrieves the value of the field "sAddressBookID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAddressBookID".
     */
    inline ::std::string& getSAddressBookIDMutable ();

    /**
     * Sets the value of the member "sAddressBookID".
     *
     *
     *
     * @param sAddressBookID The value which will be set
     */
    inline void setSAddressBookID (const ::std::string& sAddressBookID_);

    /**
     * Sets the value of the member "sAddressBookID".
     *
     *
     *
     * @param sAddressBookID The value which will be set
     */
    inline void setSAddressBookID (const char* sAddressBookID_);

    /**
     * Sets the value of the member "sAddressBookID".
     *
     *
     *
     * @param sAddressBookID The value which will be set
     */
    inline void setSAddressBookID (const char* value, size_t size);

    // API of field "sLabel"

    static const int kSLabel = 6;

    /**
     * Clears the field "sLabel".
     *
     * The field will be set to its default value. The hasSLabel()
     * method will return false.
     */
    inline void clearSLabel();

    /**
     * Checks whether the field "sLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLabel()). Otherwise it will return false.
     */
    inline bool hasSLabel () const;

    /**
     * Returns the value of the member "sLabel".
     *
     * Caller label (wok, home, mobile)
     *
     * @return The value of the field "sLabel"
     */
    inline const ::std::string& getSLabel () const;

    /**
     * Retrieves the value of the field "sLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLabel".
     */
    inline ::std::string& getSLabelMutable ();

    /**
     * Sets the value of the member "sLabel".
     *
     * Caller label (wok, home, mobile)
     *
     * @param sLabel The value which will be set
     */
    inline void setSLabel (const ::std::string& sLabel_);

    /**
     * Sets the value of the member "sLabel".
     *
     * Caller label (wok, home, mobile)
     *
     * @param sLabel The value which will be set
     */
    inline void setSLabel (const char* sLabel_);

    /**
     * Sets the value of the member "sLabel".
     *
     * Caller label (wok, home, mobile)
     *
     * @param sLabel The value which will be set
     */
    inline void setSLabel (const char* value, size_t size);

    // API of field "eService"

    static const int kEService = 7;

    /**
     * Clears the field "eService".
     *
     * The field will be set to its default value. The hasEService()
     * method will return false.
     */
    inline void clearEService();

    /**
     * Checks whether the field "eService" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEService()). Otherwise it will return false.
     */
    inline bool hasEService () const;

    /**
     * Returns the value of the member "eService".
     *
     * Call service
     *
     * @return The value of the field "eService"
     */
    inline T_e8_DiPOCallStateUpdateService getEService () const;

    /**
     * Sets the value of the member "eService".
     *
     * Call service
     *
     * @param eService The value which will be set
     */
    inline void setEService (T_e8_DiPOCallStateUpdateService eService_);

    // API of field "bIsConferenced"

    static const int kBIsConferenced = 8;

    /**
     * Clears the field "bIsConferenced".
     *
     * The field will be set to its default value. The hasBIsConferenced()
     * method will return false.
     */
    inline void clearBIsConferenced();

    /**
     * Checks whether the field "bIsConferenced" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsConferenced()). Otherwise it will return false.
     */
    inline bool hasBIsConferenced () const;

    /**
     * Returns the value of the member "bIsConferenced".
     *
     * Whether this call is part of a conference or not
     *
     * @return The value of the field "bIsConferenced"
     */
    inline bool getBIsConferenced () const;

    /**
     * Sets the value of the member "bIsConferenced".
     *
     * Whether this call is part of a conference or not
     *
     * @param bIsConferenced The value which will be set
     */
    inline void setBIsConferenced (bool bIsConferenced_);

    // API of field "u8ConferenceGroup"

    static const int kU8ConferenceGroup = 9;

    /**
     * Clears the field "u8ConferenceGroup".
     *
     * The field will be set to its default value. The hasU8ConferenceGroup()
     * method will return false.
     */
    inline void clearU8ConferenceGroup();

    /**
     * Checks whether the field "u8ConferenceGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ConferenceGroup()). Otherwise it will return false.
     */
    inline bool hasU8ConferenceGroup () const;

    /**
     * Returns the value of the member "u8ConferenceGroup".
     *
     * Conference group number
     *
     * @return The value of the field "u8ConferenceGroup"
     */
    inline uint8 getU8ConferenceGroup () const;

    /**
     * Sets the value of the member "u8ConferenceGroup".
     *
     * Conference group number
     *
     * @param u8ConferenceGroup The value which will be set
     */
    inline void setU8ConferenceGroup (uint8 u8ConferenceGroup_);

    // API of field "eDisconnectReason"

    static const int kEDisconnectReason = 10;

    /**
     * Clears the field "eDisconnectReason".
     *
     * The field will be set to its default value. The hasEDisconnectReason()
     * method will return false.
     */
    inline void clearEDisconnectReason();

    /**
     * Checks whether the field "eDisconnectReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEDisconnectReason()). Otherwise it will return false.
     */
    inline bool hasEDisconnectReason () const;

    /**
     * Returns the value of the member "eDisconnectReason".
     *
     * Call disconnect reason
     *
     * @return The value of the field "eDisconnectReason"
     */
    inline T_e8_DiPOCallStateUpdateDisconnectReason getEDisconnectReason () const;

    /**
     * Sets the value of the member "eDisconnectReason".
     *
     * Call disconnect reason
     *
     * @param eDisconnectReason The value which will be set
     */
    inline void setEDisconnectReason (T_e8_DiPOCallStateUpdateDisconnectReason eDisconnectReason_);

    // API of field "u64StartTimestamp"

    static const int kU64StartTimestamp = 11;

    /**
     * Clears the field "u64StartTimestamp".
     *
     * The field will be set to its default value. The hasU64StartTimestamp()
     * method will return false.
     */
    inline void clearU64StartTimestamp();

    /**
     * Checks whether the field "u64StartTimestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU64StartTimestamp()). Otherwise it will return false.
     */
    inline bool hasU64StartTimestamp () const;

    /**
     * Returns the value of the member "u64StartTimestamp".
     *
     * Start Timestamp of call in seconds since reference date (Jan 1, 1970, GMT)
     *
     * @return The value of the field "u64StartTimestamp"
     */
    inline uint64 getU64StartTimestamp () const;

    /**
     * Sets the value of the member "u64StartTimestamp".
     *
     * Start Timestamp of call in seconds since reference date (Jan 1, 1970, GMT)
     *
     * @param u64StartTimestamp The value which will be set
     */
    inline void setU64StartTimestamp (uint64 u64StartTimestamp_);

    static const T_DiPOCallStateItem &getDefaultInstance();

private:

    inline void set_has_sRemoteID ();

    inline void clear_has_sRemoteID ();

    inline void set_has_sDisplayName ();

    inline void clear_has_sDisplayName ();

    inline void set_has_eStatus ();

    inline void clear_has_eStatus ();

    inline void set_has_eDirection ();

    inline void clear_has_eDirection ();

    inline void set_has_sCallUUID ();

    inline void clear_has_sCallUUID ();

    inline void set_has_sAddressBookID ();

    inline void clear_has_sAddressBookID ();

    inline void set_has_sLabel ();

    inline void clear_has_sLabel ();

    inline void set_has_eService ();

    inline void clear_has_eService ();

    inline void set_has_bIsConferenced ();

    inline void clear_has_bIsConferenced ();

    inline void set_has_u8ConferenceGroup ();

    inline void clear_has_u8ConferenceGroup ();

    inline void set_has_eDisconnectReason ();

    inline void clear_has_eDisconnectReason ();

    inline void set_has_u64StartTimestamp ();

    inline void clear_has_u64StartTimestamp ();

    uint32 _has_bits_[ (12 + 31) / 32];

    ::std::string _sRemoteID;

    ::std::string _sDisplayName;

    T_e8_DiPOCallStateUpdateStatus _eStatus;

    T_e8_DiPOCallStateUpdateDirection _eDirection;

    ::std::string _sCallUUID;

    ::std::string _sAddressBookID;

    ::std::string _sLabel;

    T_e8_DiPOCallStateUpdateService _eService;

    bool _bIsConferenced;

    uint8 _u8ConferenceGroup;

    T_e8_DiPOCallStateUpdateDisconnectReason _eDisconnectReason;

    uint64 _u64StartTimestamp;

};

/**
 * RouteGuidanceDiplayComponent item
 */
class T_RouteGuidanceDisplayComponentItem {
public:

    /**
     * Default constructor
     */
    inline  T_RouteGuidanceDisplayComponentItem ();

    /**
     * Copy constructor
     */
    inline  T_RouteGuidanceDisplayComponentItem (const T_RouteGuidanceDisplayComponentItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_RouteGuidanceDisplayComponentItem (uint16 Identifier_, const ::std::string& Name_, uint16 MaxCurrentRoadNameLength_, uint16 MaxDestinationNameLength_, uint16 MaxAfterManeuverRoadNameLength_, uint16 MaxManeuverDescriptionLength_, uint16 MaxGuidanceManeuverCapacity_);

    /**
     * Destructor
     */
    inline  ~T_RouteGuidanceDisplayComponentItem();

    /**
     * Assignment operator
     */
    inline T_RouteGuidanceDisplayComponentItem& operator = (const T_RouteGuidanceDisplayComponentItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_RouteGuidanceDisplayComponentItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_RouteGuidanceDisplayComponentItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_RouteGuidanceDisplayComponentItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_RouteGuidanceDisplayComponentItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Identifier"

    static const int kIdentifier = 0;

    /**
     * Clears the field "Identifier".
     *
     * The field will be set to its default value. The hasIdentifier()
     * method will return false.
     */
    inline void clearIdentifier();

    /**
     * Checks whether the field "Identifier" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIdentifier()). Otherwise it will return false.
     */
    inline bool hasIdentifier () const;

    /**
     * Returns the value of the member "Identifier".
     *
     * Unique Display component Identifier
     *
     * @return The value of the field "Identifier"
     */
    inline uint16 getIdentifier () const;

    /**
     * Sets the value of the member "Identifier".
     *
     * Unique Display component Identifier
     *
     * @param Identifier The value which will be set
     */
    inline void setIdentifier (uint16 Identifier_);

    // API of field "Name"

    static const int kName = 1;

    /**
     * Clears the field "Name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "Name".
     *
     * Display component Name
     *
     * @return The value of the field "Name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "Name".
     *
     * Display component Name
     *
     * @param Name The value which will be set
     */
    inline void setName (const ::std::string& Name_);

    /**
     * Sets the value of the member "Name".
     *
     * Display component Name
     *
     * @param Name The value which will be set
     */
    inline void setName (const char* Name_);

    /**
     * Sets the value of the member "Name".
     *
     * Display component Name
     *
     * @param Name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "MaxCurrentRoadNameLength"

    static const int kMaxCurrentRoadNameLength = 2;

    /**
     * Clears the field "MaxCurrentRoadNameLength".
     *
     * The field will be set to its default value. The hasMaxCurrentRoadNameLength()
     * method will return false.
     */
    inline void clearMaxCurrentRoadNameLength();

    /**
     * Checks whether the field "MaxCurrentRoadNameLength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxCurrentRoadNameLength()). Otherwise it will return false.
     */
    inline bool hasMaxCurrentRoadNameLength () const;

    /**
     * Returns the value of the member "MaxCurrentRoadNameLength".
     *
     * How many of the widest character in the font used to display
     * CurrentRoadName can be shown to the user. Must be included if
     * CurrentRoadName information is displayed to the user.
     *
     * @return The value of the field "MaxCurrentRoadNameLength"
     */
    inline uint16 getMaxCurrentRoadNameLength () const;

    /**
     * Sets the value of the member "MaxCurrentRoadNameLength".
     *
     * How many of the widest character in the font used to display
     * CurrentRoadName can be shown to the user. Must be included if
     * CurrentRoadName information is displayed to the user.
     *
     * @param MaxCurrentRoadNameLength The value which will be set
     */
    inline void setMaxCurrentRoadNameLength (uint16 MaxCurrentRoadNameLength_);

    // API of field "MaxDestinationNameLength"

    static const int kMaxDestinationNameLength = 3;

    /**
     * Clears the field "MaxDestinationNameLength".
     *
     * The field will be set to its default value. The hasMaxDestinationNameLength()
     * method will return false.
     */
    inline void clearMaxDestinationNameLength();

    /**
     * Checks whether the field "MaxDestinationNameLength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxDestinationNameLength()). Otherwise it will return false.
     */
    inline bool hasMaxDestinationNameLength () const;

    /**
     * Returns the value of the member "MaxDestinationNameLength".
     *
     * How many of the widest character in the font used to display
     * DestinationName can be shown to the user. Must be included if
     * DestinationName information is displayed to the user.
     *
     * @return The value of the field "MaxDestinationNameLength"
     */
    inline uint16 getMaxDestinationNameLength () const;

    /**
     * Sets the value of the member "MaxDestinationNameLength".
     *
     * How many of the widest character in the font used to display
     * DestinationName can be shown to the user. Must be included if
     * DestinationName information is displayed to the user.
     *
     * @param MaxDestinationNameLength The value which will be set
     */
    inline void setMaxDestinationNameLength (uint16 MaxDestinationNameLength_);

    // API of field "MaxAfterManeuverRoadNameLength"

    static const int kMaxAfterManeuverRoadNameLength = 4;

    /**
     * Clears the field "MaxAfterManeuverRoadNameLength".
     *
     * The field will be set to its default value. The hasMaxAfterManeuverRoadNameLength()
     * method will return false.
     */
    inline void clearMaxAfterManeuverRoadNameLength();

    /**
     * Checks whether the field "MaxAfterManeuverRoadNameLength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxAfterManeuverRoadNameLength()). Otherwise it will return false.
     */
    inline bool hasMaxAfterManeuverRoadNameLength () const;

    /**
     * Returns the value of the member "MaxAfterManeuverRoadNameLength".
     *
     * How many of the widest character in the font used to display
     * AfterManeuverRoadName can be shown to the user. Must be included if
     * AfterManeuverRoadName information is displayed to the user.
     *
     * @return The value of the field "MaxAfterManeuverRoadNameLength"
     */
    inline uint16 getMaxAfterManeuverRoadNameLength () const;

    /**
     * Sets the value of the member "MaxAfterManeuverRoadNameLength".
     *
     * How many of the widest character in the font used to display
     * AfterManeuverRoadName can be shown to the user. Must be included if
     * AfterManeuverRoadName information is displayed to the user.
     *
     * @param MaxAfterManeuverRoadNameLength The value which will be set
     */
    inline void setMaxAfterManeuverRoadNameLength (uint16 MaxAfterManeuverRoadNameLength_);

    // API of field "MaxManeuverDescriptionLength"

    static const int kMaxManeuverDescriptionLength = 5;

    /**
     * Clears the field "MaxManeuverDescriptionLength".
     *
     * The field will be set to its default value. The hasMaxManeuverDescriptionLength()
     * method will return false.
     */
    inline void clearMaxManeuverDescriptionLength();

    /**
     * Checks whether the field "MaxManeuverDescriptionLength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxManeuverDescriptionLength()). Otherwise it will return false.
     */
    inline bool hasMaxManeuverDescriptionLength () const;

    /**
     * Returns the value of the member "MaxManeuverDescriptionLength".
     *
     * How many of the widest character in the font used to display
     * ManeuverDescription can be shown to the user. Must be included if
     * ManeuverDescription information is displayed to the user.
     *
     * @return The value of the field "MaxManeuverDescriptionLength"
     */
    inline uint16 getMaxManeuverDescriptionLength () const;

    /**
     * Sets the value of the member "MaxManeuverDescriptionLength".
     *
     * How many of the widest character in the font used to display
     * ManeuverDescription can be shown to the user. Must be included if
     * ManeuverDescription information is displayed to the user.
     *
     * @param MaxManeuverDescriptionLength The value which will be set
     */
    inline void setMaxManeuverDescriptionLength (uint16 MaxManeuverDescriptionLength_);

    // API of field "MaxGuidanceManeuverCapacity"

    static const int kMaxGuidanceManeuverCapacity = 6;

    /**
     * Clears the field "MaxGuidanceManeuverCapacity".
     *
     * The field will be set to its default value. The hasMaxGuidanceManeuverCapacity()
     * method will return false.
     */
    inline void clearMaxGuidanceManeuverCapacity();

    /**
     * Checks whether the field "MaxGuidanceManeuverCapacity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxGuidanceManeuverCapacity()). Otherwise it will return false.
     */
    inline bool hasMaxGuidanceManeuverCapacity () const;

    /**
     * Returns the value of the member "MaxGuidanceManeuverCapacity".
     *
     * Number of Maneuvers the accessory can handle (ie. store and/or display) at once
     *
     * @return The value of the field "MaxGuidanceManeuverCapacity"
     */
    inline uint16 getMaxGuidanceManeuverCapacity () const;

    /**
     * Sets the value of the member "MaxGuidanceManeuverCapacity".
     *
     * Number of Maneuvers the accessory can handle (ie. store and/or display) at once
     *
     * @param MaxGuidanceManeuverCapacity The value which will be set
     */
    inline void setMaxGuidanceManeuverCapacity (uint16 MaxGuidanceManeuverCapacity_);

    static const T_RouteGuidanceDisplayComponentItem &getDefaultInstance();

private:

    inline void set_has_Identifier ();

    inline void clear_has_Identifier ();

    inline void set_has_Name ();

    inline void clear_has_Name ();

    inline void set_has_MaxCurrentRoadNameLength ();

    inline void clear_has_MaxCurrentRoadNameLength ();

    inline void set_has_MaxDestinationNameLength ();

    inline void clear_has_MaxDestinationNameLength ();

    inline void set_has_MaxAfterManeuverRoadNameLength ();

    inline void clear_has_MaxAfterManeuverRoadNameLength ();

    inline void set_has_MaxManeuverDescriptionLength ();

    inline void clear_has_MaxManeuverDescriptionLength ();

    inline void set_has_MaxGuidanceManeuverCapacity ();

    inline void clear_has_MaxGuidanceManeuverCapacity ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint16 _Identifier;

    ::std::string _Name;

    uint16 _MaxCurrentRoadNameLength;

    uint16 _MaxDestinationNameLength;

    uint16 _MaxAfterManeuverRoadNameLength;

    uint16 _MaxManeuverDescriptionLength;

    uint16 _MaxGuidanceManeuverCapacity;

};

/**
 * RouteGuidanceUpdate message
 */
class T_RouteGuidanceUpdate {
public:

    /**
     * Default constructor
     */
    inline  T_RouteGuidanceUpdate ();

    /**
     * Copy constructor
     */
    inline  T_RouteGuidanceUpdate (const T_RouteGuidanceUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  T_RouteGuidanceUpdate (bool bRouteGuidanceDisplayComponentIDsAvailable_, const T_RouteGuidanceDisplayComponentIDs& RouteGuidanceDisplayComponentIDs_, bool bRouteGuidanceStateAvailable_, T_e8_RouteGuidanceState e8RouteGuidanceState_, bool bManeuverStateAvailable_, T_e8_ManeuverState e8ManeuverState_, bool bCurrentRoadNameAvailable_, const ::std::string& CurrentRoadName_, bool bDestinationNameAvailable_, const ::std::string& DestinationName_, bool bEstimatedTimeOfArrivalAvailable_, uint64 EstimatedTimeOfArrival_, bool bTimeRemainingToDestinationAvailable_, uint64 TimeRemainingToDestination_, bool bDistanceRemainingAvailable_, uint32 DistanceRemaining_, bool bDistanceRemainingDisplayStrAvailable_, const ::std::string& DistanceRemainingDisplayStr_, bool bDistanceRemainingDisplayUnitsAvailable_, T_e8_DistanceDisplayUnits e8DistanceRemainingDisplayUnits_, bool bDistanceToNextManeuverAvailable_, uint32 DistanceToNextManeuver_, bool bDistanceToNextManeuverDisplayStrAvailable_, const ::std::string& DistanceToNextManeuverDisplayStr_, bool bDistanceToNextManeuverDisplayUnitsAvailable_, T_e8_DistanceDisplayUnits e8DistanceToNextManeuverDisplayUnits_, bool bRouteGuidanceManeuverCurrentListAvailable_, const T_RouteGuidanceManeuverCurrentList& RouteGuidanceManeuverCurrentList_, bool bRouteGuidanceManeuverCountAvailable_, uint16 RouteGuidanceManeuverCount_, bool bRouteGuidanceVisibleInAppAvailable_, bool RouteGuidanceVisibleInApp_, bool bSourceNameAvailable_, const ::std::string& SourceName_, bool bSourceSupportsRouteGuidanceAvailable_, bool SourceSupportsRouteGuidance_);

    /**
     * Destructor
     */
    inline  ~T_RouteGuidanceUpdate();

    /**
     * Assignment operator
     */
    inline T_RouteGuidanceUpdate& operator = (const T_RouteGuidanceUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_RouteGuidanceUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_RouteGuidanceUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_RouteGuidanceUpdate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_RouteGuidanceUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bRouteGuidanceDisplayComponentIDsAvailable"

    static const int kBRouteGuidanceDisplayComponentIDsAvailable = 0;

    /**
     * Clears the field "bRouteGuidanceDisplayComponentIDsAvailable".
     *
     * The field will be set to its default value. The hasBRouteGuidanceDisplayComponentIDsAvailable()
     * method will return false.
     */
    inline void clearBRouteGuidanceDisplayComponentIDsAvailable();

    /**
     * Checks whether the field "bRouteGuidanceDisplayComponentIDsAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRouteGuidanceDisplayComponentIDsAvailable()). Otherwise it will return false.
     */
    inline bool hasBRouteGuidanceDisplayComponentIDsAvailable () const;

    /**
     * Returns the value of the member "bRouteGuidanceDisplayComponentIDsAvailable".
     *
     * Availability of RouteGuidanceDisplayComponentIDs parameter
     *
     * @return The value of the field "bRouteGuidanceDisplayComponentIDsAvailable"
     */
    inline bool getBRouteGuidanceDisplayComponentIDsAvailable () const;

    /**
     * Sets the value of the member "bRouteGuidanceDisplayComponentIDsAvailable".
     *
     * Availability of RouteGuidanceDisplayComponentIDs parameter
     *
     * @param bRouteGuidanceDisplayComponentIDsAvailable The value which will be set
     */
    inline void setBRouteGuidanceDisplayComponentIDsAvailable (bool bRouteGuidanceDisplayComponentIDsAvailable_);

    // API of field "RouteGuidanceDisplayComponentIDs"

    static const int kRouteGuidanceDisplayComponentIDs = 1;

    /**
     * Clears the field "RouteGuidanceDisplayComponentIDs".
     *
     * The field will be set to its default value. The hasRouteGuidanceDisplayComponentIDs()
     * method will return false.
     */
    inline void clearRouteGuidanceDisplayComponentIDs();

    /**
     * Checks whether the field "RouteGuidanceDisplayComponentIDs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteGuidanceDisplayComponentIDs()). Otherwise it will return false.
     */
    inline bool hasRouteGuidanceDisplayComponentIDs () const;

    /**
     * Returns the value of the member "RouteGuidanceDisplayComponentIDs".
     *
     * If size is 0, it means the update applies to all components. If more than one are specified, update is applied to all specified components.
     *
     * @return The value of the field "RouteGuidanceDisplayComponentIDs"
     */
    inline const T_RouteGuidanceDisplayComponentIDs& getRouteGuidanceDisplayComponentIDs () const;

    /**
     * Retrieves the value of the field "RouteGuidanceDisplayComponentIDs" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RouteGuidanceDisplayComponentIDs".
     */
    inline T_RouteGuidanceDisplayComponentIDs& getRouteGuidanceDisplayComponentIDsMutable ();

    /**
     * Sets the value of the member "RouteGuidanceDisplayComponentIDs".
     *
     * If size is 0, it means the update applies to all components. If more than one are specified, update is applied to all specified components.
     *
     * @param RouteGuidanceDisplayComponentIDs The value which will be set
     */
    inline void setRouteGuidanceDisplayComponentIDs (const T_RouteGuidanceDisplayComponentIDs& RouteGuidanceDisplayComponentIDs_);

    // API of field "bRouteGuidanceStateAvailable"

    static const int kBRouteGuidanceStateAvailable = 2;

    /**
     * Clears the field "bRouteGuidanceStateAvailable".
     *
     * The field will be set to its default value. The hasBRouteGuidanceStateAvailable()
     * method will return false.
     */
    inline void clearBRouteGuidanceStateAvailable();

    /**
     * Checks whether the field "bRouteGuidanceStateAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRouteGuidanceStateAvailable()). Otherwise it will return false.
     */
    inline bool hasBRouteGuidanceStateAvailable () const;

    /**
     * Returns the value of the member "bRouteGuidanceStateAvailable".
     *
     * Availability of RouteGuidanceState parameter
     *
     * @return The value of the field "bRouteGuidanceStateAvailable"
     */
    inline bool getBRouteGuidanceStateAvailable () const;

    /**
     * Sets the value of the member "bRouteGuidanceStateAvailable".
     *
     * Availability of RouteGuidanceState parameter
     *
     * @param bRouteGuidanceStateAvailable The value which will be set
     */
    inline void setBRouteGuidanceStateAvailable (bool bRouteGuidanceStateAvailable_);

    // API of field "e8RouteGuidanceState"

    static const int kE8RouteGuidanceState = 3;

    /**
     * Clears the field "e8RouteGuidanceState".
     *
     * The field will be set to its default value. The hasE8RouteGuidanceState()
     * method will return false.
     */
    inline void clearE8RouteGuidanceState();

    /**
     * Checks whether the field "e8RouteGuidanceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8RouteGuidanceState()). Otherwise it will return false.
     */
    inline bool hasE8RouteGuidanceState () const;

    /**
     * Returns the value of the member "e8RouteGuidanceState".
     *
     * Indicates current RouteGuidance state which is one of the route guidance state enum.
     *
     * @return The value of the field "e8RouteGuidanceState"
     */
    inline T_e8_RouteGuidanceState getE8RouteGuidanceState () const;

    /**
     * Sets the value of the member "e8RouteGuidanceState".
     *
     * Indicates current RouteGuidance state which is one of the route guidance state enum.
     *
     * @param e8RouteGuidanceState The value which will be set
     */
    inline void setE8RouteGuidanceState (T_e8_RouteGuidanceState e8RouteGuidanceState_);

    // API of field "bManeuverStateAvailable"

    static const int kBManeuverStateAvailable = 4;

    /**
     * Clears the field "bManeuverStateAvailable".
     *
     * The field will be set to its default value. The hasBManeuverStateAvailable()
     * method will return false.
     */
    inline void clearBManeuverStateAvailable();

    /**
     * Checks whether the field "bManeuverStateAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBManeuverStateAvailable()). Otherwise it will return false.
     */
    inline bool hasBManeuverStateAvailable () const;

    /**
     * Returns the value of the member "bManeuverStateAvailable".
     *
     * Availability of ManeuverState parameter
     *
     * @return The value of the field "bManeuverStateAvailable"
     */
    inline bool getBManeuverStateAvailable () const;

    /**
     * Sets the value of the member "bManeuverStateAvailable".
     *
     * Availability of ManeuverState parameter
     *
     * @param bManeuverStateAvailable The value which will be set
     */
    inline void setBManeuverStateAvailable (bool bManeuverStateAvailable_);

    // API of field "e8ManeuverState"

    static const int kE8ManeuverState = 5;

    /**
     * Clears the field "e8ManeuverState".
     *
     * The field will be set to its default value. The hasE8ManeuverState()
     * method will return false.
     */
    inline void clearE8ManeuverState();

    /**
     * Checks whether the field "e8ManeuverState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ManeuverState()). Otherwise it will return false.
     */
    inline bool hasE8ManeuverState () const;

    /**
     * Returns the value of the member "e8ManeuverState".
     *
     * ManeuverState enum.
     *
     * @return The value of the field "e8ManeuverState"
     */
    inline T_e8_ManeuverState getE8ManeuverState () const;

    /**
     * Sets the value of the member "e8ManeuverState".
     *
     * ManeuverState enum.
     *
     * @param e8ManeuverState The value which will be set
     */
    inline void setE8ManeuverState (T_e8_ManeuverState e8ManeuverState_);

    // API of field "bCurrentRoadNameAvailable"

    static const int kBCurrentRoadNameAvailable = 6;

    /**
     * Clears the field "bCurrentRoadNameAvailable".
     *
     * The field will be set to its default value. The hasBCurrentRoadNameAvailable()
     * method will return false.
     */
    inline void clearBCurrentRoadNameAvailable();

    /**
     * Checks whether the field "bCurrentRoadNameAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBCurrentRoadNameAvailable()). Otherwise it will return false.
     */
    inline bool hasBCurrentRoadNameAvailable () const;

    /**
     * Returns the value of the member "bCurrentRoadNameAvailable".
     *
     * Availability of CurrentRoadName parameter
     *
     * @return The value of the field "bCurrentRoadNameAvailable"
     */
    inline bool getBCurrentRoadNameAvailable () const;

    /**
     * Sets the value of the member "bCurrentRoadNameAvailable".
     *
     * Availability of CurrentRoadName parameter
     *
     * @param bCurrentRoadNameAvailable The value which will be set
     */
    inline void setBCurrentRoadNameAvailable (bool bCurrentRoadNameAvailable_);

    // API of field "CurrentRoadName"

    static const int kCurrentRoadName = 7;

    /**
     * Clears the field "CurrentRoadName".
     *
     * The field will be set to its default value. The hasCurrentRoadName()
     * method will return false.
     */
    inline void clearCurrentRoadName();

    /**
     * Checks whether the field "CurrentRoadName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentRoadName()). Otherwise it will return false.
     */
    inline bool hasCurrentRoadName () const;

    /**
     * Returns the value of the member "CurrentRoadName".
     *
     * The name of the current road.
     *
     * @return The value of the field "CurrentRoadName"
     */
    inline const ::std::string& getCurrentRoadName () const;

    /**
     * Retrieves the value of the field "CurrentRoadName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CurrentRoadName".
     */
    inline ::std::string& getCurrentRoadNameMutable ();

    /**
     * Sets the value of the member "CurrentRoadName".
     *
     * The name of the current road.
     *
     * @param CurrentRoadName The value which will be set
     */
    inline void setCurrentRoadName (const ::std::string& CurrentRoadName_);

    /**
     * Sets the value of the member "CurrentRoadName".
     *
     * The name of the current road.
     *
     * @param CurrentRoadName The value which will be set
     */
    inline void setCurrentRoadName (const char* CurrentRoadName_);

    /**
     * Sets the value of the member "CurrentRoadName".
     *
     * The name of the current road.
     *
     * @param CurrentRoadName The value which will be set
     */
    inline void setCurrentRoadName (const char* value, size_t size);

    // API of field "bDestinationNameAvailable"

    static const int kBDestinationNameAvailable = 8;

    /**
     * Clears the field "bDestinationNameAvailable".
     *
     * The field will be set to its default value. The hasBDestinationNameAvailable()
     * method will return false.
     */
    inline void clearBDestinationNameAvailable();

    /**
     * Checks whether the field "bDestinationNameAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDestinationNameAvailable()). Otherwise it will return false.
     */
    inline bool hasBDestinationNameAvailable () const;

    /**
     * Returns the value of the member "bDestinationNameAvailable".
     *
     * Availability of DestinationName parameter
     *
     * @return The value of the field "bDestinationNameAvailable"
     */
    inline bool getBDestinationNameAvailable () const;

    /**
     * Sets the value of the member "bDestinationNameAvailable".
     *
     * Availability of DestinationName parameter
     *
     * @param bDestinationNameAvailable The value which will be set
     */
    inline void setBDestinationNameAvailable (bool bDestinationNameAvailable_);

    // API of field "DestinationName"

    static const int kDestinationName = 9;

    /**
     * Clears the field "DestinationName".
     *
     * The field will be set to its default value. The hasDestinationName()
     * method will return false.
     */
    inline void clearDestinationName();

    /**
     * Checks whether the field "DestinationName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestinationName()). Otherwise it will return false.
     */
    inline bool hasDestinationName () const;

    /**
     * Returns the value of the member "DestinationName".
     *
     * The name of the Destination.
     *
     * @return The value of the field "DestinationName"
     */
    inline const ::std::string& getDestinationName () const;

    /**
     * Retrieves the value of the field "DestinationName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestinationName".
     */
    inline ::std::string& getDestinationNameMutable ();

    /**
     * Sets the value of the member "DestinationName".
     *
     * The name of the Destination.
     *
     * @param DestinationName The value which will be set
     */
    inline void setDestinationName (const ::std::string& DestinationName_);

    /**
     * Sets the value of the member "DestinationName".
     *
     * The name of the Destination.
     *
     * @param DestinationName The value which will be set
     */
    inline void setDestinationName (const char* DestinationName_);

    /**
     * Sets the value of the member "DestinationName".
     *
     * The name of the Destination.
     *
     * @param DestinationName The value which will be set
     */
    inline void setDestinationName (const char* value, size_t size);

    // API of field "bEstimatedTimeOfArrivalAvailable"

    static const int kBEstimatedTimeOfArrivalAvailable = 10;

    /**
     * Clears the field "bEstimatedTimeOfArrivalAvailable".
     *
     * The field will be set to its default value. The hasBEstimatedTimeOfArrivalAvailable()
     * method will return false.
     */
    inline void clearBEstimatedTimeOfArrivalAvailable();

    /**
     * Checks whether the field "bEstimatedTimeOfArrivalAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEstimatedTimeOfArrivalAvailable()). Otherwise it will return false.
     */
    inline bool hasBEstimatedTimeOfArrivalAvailable () const;

    /**
     * Returns the value of the member "bEstimatedTimeOfArrivalAvailable".
     *
     * Availability of EstimatedTimeOfArrival parameter
     *
     * @return The value of the field "bEstimatedTimeOfArrivalAvailable"
     */
    inline bool getBEstimatedTimeOfArrivalAvailable () const;

    /**
     * Sets the value of the member "bEstimatedTimeOfArrivalAvailable".
     *
     * Availability of EstimatedTimeOfArrival parameter
     *
     * @param bEstimatedTimeOfArrivalAvailable The value which will be set
     */
    inline void setBEstimatedTimeOfArrivalAvailable (bool bEstimatedTimeOfArrivalAvailable_);

    // API of field "EstimatedTimeOfArrival"

    static const int kEstimatedTimeOfArrival = 11;

    /**
     * Clears the field "EstimatedTimeOfArrival".
     *
     * The field will be set to its default value. The hasEstimatedTimeOfArrival()
     * method will return false.
     */
    inline void clearEstimatedTimeOfArrival();

    /**
     * Checks whether the field "EstimatedTimeOfArrival" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEstimatedTimeOfArrival()). Otherwise it will return false.
     */
    inline bool hasEstimatedTimeOfArrival () const;

    /**
     * Returns the value of the member "EstimatedTimeOfArrival".
     *
     * Number of seconds from reference date (Jan 1, 1970 GMT).Similar to DeviceTimeUpdate, Accessory should use DeviceTimeUpdate and use the TimeZoneOfisetMinutes and DaylightSavingsOffsetMinutes information to apply the adjustment necessary for local time
     *
     * @return The value of the field "EstimatedTimeOfArrival"
     */
    inline uint64 getEstimatedTimeOfArrival () const;

    /**
     * Sets the value of the member "EstimatedTimeOfArrival".
     *
     * Number of seconds from reference date (Jan 1, 1970 GMT).Similar to DeviceTimeUpdate, Accessory should use DeviceTimeUpdate and use the TimeZoneOfisetMinutes and DaylightSavingsOffsetMinutes information to apply the adjustment necessary for local time
     *
     * @param EstimatedTimeOfArrival The value which will be set
     */
    inline void setEstimatedTimeOfArrival (uint64 EstimatedTimeOfArrival_);

    // API of field "bTimeRemainingToDestinationAvailable"

    static const int kBTimeRemainingToDestinationAvailable = 12;

    /**
     * Clears the field "bTimeRemainingToDestinationAvailable".
     *
     * The field will be set to its default value. The hasBTimeRemainingToDestinationAvailable()
     * method will return false.
     */
    inline void clearBTimeRemainingToDestinationAvailable();

    /**
     * Checks whether the field "bTimeRemainingToDestinationAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTimeRemainingToDestinationAvailable()). Otherwise it will return false.
     */
    inline bool hasBTimeRemainingToDestinationAvailable () const;

    /**
     * Returns the value of the member "bTimeRemainingToDestinationAvailable".
     *
     * Availability of TimeRemainingToDestination parameter
     *
     * @return The value of the field "bTimeRemainingToDestinationAvailable"
     */
    inline bool getBTimeRemainingToDestinationAvailable () const;

    /**
     * Sets the value of the member "bTimeRemainingToDestinationAvailable".
     *
     * Availability of TimeRemainingToDestination parameter
     *
     * @param bTimeRemainingToDestinationAvailable The value which will be set
     */
    inline void setBTimeRemainingToDestinationAvailable (bool bTimeRemainingToDestinationAvailable_);

    // API of field "TimeRemainingToDestination"

    static const int kTimeRemainingToDestination = 13;

    /**
     * Clears the field "TimeRemainingToDestination".
     *
     * The field will be set to its default value. The hasTimeRemainingToDestination()
     * method will return false.
     */
    inline void clearTimeRemainingToDestination();

    /**
     * Checks whether the field "TimeRemainingToDestination" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimeRemainingToDestination()). Otherwise it will return false.
     */
    inline bool hasTimeRemainingToDestination () const;

    /**
     * Returns the value of the member "TimeRemainingToDestination".
     *
     * Number of seconds to Destination.
     *
     * @return The value of the field "TimeRemainingToDestination"
     */
    inline uint64 getTimeRemainingToDestination () const;

    /**
     * Sets the value of the member "TimeRemainingToDestination".
     *
     * Number of seconds to Destination.
     *
     * @param TimeRemainingToDestination The value which will be set
     */
    inline void setTimeRemainingToDestination (uint64 TimeRemainingToDestination_);

    // API of field "bDistanceRemainingAvailable"

    static const int kBDistanceRemainingAvailable = 14;

    /**
     * Clears the field "bDistanceRemainingAvailable".
     *
     * The field will be set to its default value. The hasBDistanceRemainingAvailable()
     * method will return false.
     */
    inline void clearBDistanceRemainingAvailable();

    /**
     * Checks whether the field "bDistanceRemainingAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDistanceRemainingAvailable()). Otherwise it will return false.
     */
    inline bool hasBDistanceRemainingAvailable () const;

    /**
     * Returns the value of the member "bDistanceRemainingAvailable".
     *
     * Availability of DistanceRemaining parameter
     *
     * @return The value of the field "bDistanceRemainingAvailable"
     */
    inline bool getBDistanceRemainingAvailable () const;

    /**
     * Sets the value of the member "bDistanceRemainingAvailable".
     *
     * Availability of DistanceRemaining parameter
     *
     * @param bDistanceRemainingAvailable The value which will be set
     */
    inline void setBDistanceRemainingAvailable (bool bDistanceRemainingAvailable_);

    // API of field "DistanceRemaining"

    static const int kDistanceRemaining = 15;

    /**
     * Clears the field "DistanceRemaining".
     *
     * The field will be set to its default value. The hasDistanceRemaining()
     * method will return false.
     */
    inline void clearDistanceRemaining();

    /**
     * Checks whether the field "DistanceRemaining" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceRemaining()). Otherwise it will return false.
     */
    inline bool hasDistanceRemaining () const;

    /**
     * Returns the value of the member "DistanceRemaining".
     *
     * Meters to end of trip. This value must not be displayed to the user in text. It is only to be used for generating graphics, e.g. countdown bars.
     *
     * @return The value of the field "DistanceRemaining"
     */
    inline uint32 getDistanceRemaining () const;

    /**
     * Sets the value of the member "DistanceRemaining".
     *
     * Meters to end of trip. This value must not be displayed to the user in text. It is only to be used for generating graphics, e.g. countdown bars.
     *
     * @param DistanceRemaining The value which will be set
     */
    inline void setDistanceRemaining (uint32 DistanceRemaining_);

    // API of field "bDistanceRemainingDisplayStrAvailable"

    static const int kBDistanceRemainingDisplayStrAvailable = 16;

    /**
     * Clears the field "bDistanceRemainingDisplayStrAvailable".
     *
     * The field will be set to its default value. The hasBDistanceRemainingDisplayStrAvailable()
     * method will return false.
     */
    inline void clearBDistanceRemainingDisplayStrAvailable();

    /**
     * Checks whether the field "bDistanceRemainingDisplayStrAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDistanceRemainingDisplayStrAvailable()). Otherwise it will return false.
     */
    inline bool hasBDistanceRemainingDisplayStrAvailable () const;

    /**
     * Returns the value of the member "bDistanceRemainingDisplayStrAvailable".
     *
     * Availability of DistanceRemainingDisplayStr parameter
     *
     * @return The value of the field "bDistanceRemainingDisplayStrAvailable"
     */
    inline bool getBDistanceRemainingDisplayStrAvailable () const;

    /**
     * Sets the value of the member "bDistanceRemainingDisplayStrAvailable".
     *
     * Availability of DistanceRemainingDisplayStr parameter
     *
     * @param bDistanceRemainingDisplayStrAvailable The value which will be set
     */
    inline void setBDistanceRemainingDisplayStrAvailable (bool bDistanceRemainingDisplayStrAvailable_);

    // API of field "DistanceRemainingDisplayStr"

    static const int kDistanceRemainingDisplayStr = 17;

    /**
     * Clears the field "DistanceRemainingDisplayStr".
     *
     * The field will be set to its default value. The hasDistanceRemainingDisplayStr()
     * method will return false.
     */
    inline void clearDistanceRemainingDisplayStr();

    /**
     * Checks whether the field "DistanceRemainingDisplayStr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceRemainingDisplayStr()). Otherwise it will return false.
     */
    inline bool hasDistanceRemainingDisplayStr () const;

    /**
     * Returns the value of the member "DistanceRemainingDisplayStr".
     *
     * Display string representation of DistanceRemaining in DistanceRemainingDisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @return The value of the field "DistanceRemainingDisplayStr"
     */
    inline const ::std::string& getDistanceRemainingDisplayStr () const;

    /**
     * Retrieves the value of the field "DistanceRemainingDisplayStr" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DistanceRemainingDisplayStr".
     */
    inline ::std::string& getDistanceRemainingDisplayStrMutable ();

    /**
     * Sets the value of the member "DistanceRemainingDisplayStr".
     *
     * Display string representation of DistanceRemaining in DistanceRemainingDisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @param DistanceRemainingDisplayStr The value which will be set
     */
    inline void setDistanceRemainingDisplayStr (const ::std::string& DistanceRemainingDisplayStr_);

    /**
     * Sets the value of the member "DistanceRemainingDisplayStr".
     *
     * Display string representation of DistanceRemaining in DistanceRemainingDisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @param DistanceRemainingDisplayStr The value which will be set
     */
    inline void setDistanceRemainingDisplayStr (const char* DistanceRemainingDisplayStr_);

    /**
     * Sets the value of the member "DistanceRemainingDisplayStr".
     *
     * Display string representation of DistanceRemaining in DistanceRemainingDisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @param DistanceRemainingDisplayStr The value which will be set
     */
    inline void setDistanceRemainingDisplayStr (const char* value, size_t size);

    // API of field "bDistanceRemainingDisplayUnitsAvailable"

    static const int kBDistanceRemainingDisplayUnitsAvailable = 18;

    /**
     * Clears the field "bDistanceRemainingDisplayUnitsAvailable".
     *
     * The field will be set to its default value. The hasBDistanceRemainingDisplayUnitsAvailable()
     * method will return false.
     */
    inline void clearBDistanceRemainingDisplayUnitsAvailable();

    /**
     * Checks whether the field "bDistanceRemainingDisplayUnitsAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDistanceRemainingDisplayUnitsAvailable()). Otherwise it will return false.
     */
    inline bool hasBDistanceRemainingDisplayUnitsAvailable () const;

    /**
     * Returns the value of the member "bDistanceRemainingDisplayUnitsAvailable".
     *
     * Availability of DistanceRemainingDisplayUnits parameter
     *
     * @return The value of the field "bDistanceRemainingDisplayUnitsAvailable"
     */
    inline bool getBDistanceRemainingDisplayUnitsAvailable () const;

    /**
     * Sets the value of the member "bDistanceRemainingDisplayUnitsAvailable".
     *
     * Availability of DistanceRemainingDisplayUnits parameter
     *
     * @param bDistanceRemainingDisplayUnitsAvailable The value which will be set
     */
    inline void setBDistanceRemainingDisplayUnitsAvailable (bool bDistanceRemainingDisplayUnitsAvailable_);

    // API of field "e8DistanceRemainingDisplayUnits"

    static const int kE8DistanceRemainingDisplayUnits = 19;

    /**
     * Clears the field "e8DistanceRemainingDisplayUnits".
     *
     * The field will be set to its default value. The hasE8DistanceRemainingDisplayUnits()
     * method will return false.
     */
    inline void clearE8DistanceRemainingDisplayUnits();

    /**
     * Checks whether the field "e8DistanceRemainingDisplayUnits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DistanceRemainingDisplayUnits()). Otherwise it will return false.
     */
    inline bool hasE8DistanceRemainingDisplayUnits () const;

    /**
     * Returns the value of the member "e8DistanceRemainingDisplayUnits".
     *
     * Units that must accompany DistanceRemainingDisplaystr when displayed to the user.
     *
     * @return The value of the field "e8DistanceRemainingDisplayUnits"
     */
    inline T_e8_DistanceDisplayUnits getE8DistanceRemainingDisplayUnits () const;

    /**
     * Sets the value of the member "e8DistanceRemainingDisplayUnits".
     *
     * Units that must accompany DistanceRemainingDisplaystr when displayed to the user.
     *
     * @param e8DistanceRemainingDisplayUnits The value which will be set
     */
    inline void setE8DistanceRemainingDisplayUnits (T_e8_DistanceDisplayUnits e8DistanceRemainingDisplayUnits_);

    // API of field "bDistanceToNextManeuverAvailable"

    static const int kBDistanceToNextManeuverAvailable = 20;

    /**
     * Clears the field "bDistanceToNextManeuverAvailable".
     *
     * The field will be set to its default value. The hasBDistanceToNextManeuverAvailable()
     * method will return false.
     */
    inline void clearBDistanceToNextManeuverAvailable();

    /**
     * Checks whether the field "bDistanceToNextManeuverAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDistanceToNextManeuverAvailable()). Otherwise it will return false.
     */
    inline bool hasBDistanceToNextManeuverAvailable () const;

    /**
     * Returns the value of the member "bDistanceToNextManeuverAvailable".
     *
     * Availability of DistanceToNextManeuver parameter
     *
     * @return The value of the field "bDistanceToNextManeuverAvailable"
     */
    inline bool getBDistanceToNextManeuverAvailable () const;

    /**
     * Sets the value of the member "bDistanceToNextManeuverAvailable".
     *
     * Availability of DistanceToNextManeuver parameter
     *
     * @param bDistanceToNextManeuverAvailable The value which will be set
     */
    inline void setBDistanceToNextManeuverAvailable (bool bDistanceToNextManeuverAvailable_);

    // API of field "DistanceToNextManeuver"

    static const int kDistanceToNextManeuver = 21;

    /**
     * Clears the field "DistanceToNextManeuver".
     *
     * The field will be set to its default value. The hasDistanceToNextManeuver()
     * method will return false.
     */
    inline void clearDistanceToNextManeuver();

    /**
     * Checks whether the field "DistanceToNextManeuver" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceToNextManeuver()). Otherwise it will return false.
     */
    inline bool hasDistanceToNextManeuver () const;

    /**
     * Returns the value of the member "DistanceToNextManeuver".
     *
     * Meters to next me euver. This value must not be displayed to the user in text. It is only to be used for generating graphics,e.g. countdown bars.
     *
     * @return The value of the field "DistanceToNextManeuver"
     */
    inline uint32 getDistanceToNextManeuver () const;

    /**
     * Sets the value of the member "DistanceToNextManeuver".
     *
     * Meters to next me euver. This value must not be displayed to the user in text. It is only to be used for generating graphics,e.g. countdown bars.
     *
     * @param DistanceToNextManeuver The value which will be set
     */
    inline void setDistanceToNextManeuver (uint32 DistanceToNextManeuver_);

    // API of field "bDistanceToNextManeuverDisplayStrAvailable"

    static const int kBDistanceToNextManeuverDisplayStrAvailable = 22;

    /**
     * Clears the field "bDistanceToNextManeuverDisplayStrAvailable".
     *
     * The field will be set to its default value. The hasBDistanceToNextManeuverDisplayStrAvailable()
     * method will return false.
     */
    inline void clearBDistanceToNextManeuverDisplayStrAvailable();

    /**
     * Checks whether the field "bDistanceToNextManeuverDisplayStrAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDistanceToNextManeuverDisplayStrAvailable()). Otherwise it will return false.
     */
    inline bool hasBDistanceToNextManeuverDisplayStrAvailable () const;

    /**
     * Returns the value of the member "bDistanceToNextManeuverDisplayStrAvailable".
     *
     * Availability of DistanceToNextManeuverDisplayStr parameter
     *
     * @return The value of the field "bDistanceToNextManeuverDisplayStrAvailable"
     */
    inline bool getBDistanceToNextManeuverDisplayStrAvailable () const;

    /**
     * Sets the value of the member "bDistanceToNextManeuverDisplayStrAvailable".
     *
     * Availability of DistanceToNextManeuverDisplayStr parameter
     *
     * @param bDistanceToNextManeuverDisplayStrAvailable The value which will be set
     */
    inline void setBDistanceToNextManeuverDisplayStrAvailable (bool bDistanceToNextManeuverDisplayStrAvailable_);

    // API of field "DistanceToNextManeuverDisplayStr"

    static const int kDistanceToNextManeuverDisplayStr = 23;

    /**
     * Clears the field "DistanceToNextManeuverDisplayStr".
     *
     * The field will be set to its default value. The hasDistanceToNextManeuverDisplayStr()
     * method will return false.
     */
    inline void clearDistanceToNextManeuverDisplayStr();

    /**
     * Checks whether the field "DistanceToNextManeuverDisplayStr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceToNextManeuverDisplayStr()). Otherwise it will return false.
     */
    inline bool hasDistanceToNextManeuverDisplayStr () const;

    /**
     * Returns the value of the member "DistanceToNextManeuverDisplayStr".
     *
     * Display string representation of DistanceToNextManeuver in DistanceToNextManeuverDispIayUnits units. Does not contain the units string. Must be displayed Without unit conversion to the user.
     *
     * @return The value of the field "DistanceToNextManeuverDisplayStr"
     */
    inline const ::std::string& getDistanceToNextManeuverDisplayStr () const;

    /**
     * Retrieves the value of the field "DistanceToNextManeuverDisplayStr" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DistanceToNextManeuverDisplayStr".
     */
    inline ::std::string& getDistanceToNextManeuverDisplayStrMutable ();

    /**
     * Sets the value of the member "DistanceToNextManeuverDisplayStr".
     *
     * Display string representation of DistanceToNextManeuver in DistanceToNextManeuverDispIayUnits units. Does not contain the units string. Must be displayed Without unit conversion to the user.
     *
     * @param DistanceToNextManeuverDisplayStr The value which will be set
     */
    inline void setDistanceToNextManeuverDisplayStr (const ::std::string& DistanceToNextManeuverDisplayStr_);

    /**
     * Sets the value of the member "DistanceToNextManeuverDisplayStr".
     *
     * Display string representation of DistanceToNextManeuver in DistanceToNextManeuverDispIayUnits units. Does not contain the units string. Must be displayed Without unit conversion to the user.
     *
     * @param DistanceToNextManeuverDisplayStr The value which will be set
     */
    inline void setDistanceToNextManeuverDisplayStr (const char* DistanceToNextManeuverDisplayStr_);

    /**
     * Sets the value of the member "DistanceToNextManeuverDisplayStr".
     *
     * Display string representation of DistanceToNextManeuver in DistanceToNextManeuverDispIayUnits units. Does not contain the units string. Must be displayed Without unit conversion to the user.
     *
     * @param DistanceToNextManeuverDisplayStr The value which will be set
     */
    inline void setDistanceToNextManeuverDisplayStr (const char* value, size_t size);

    // API of field "bDistanceToNextManeuverDisplayUnitsAvailable"

    static const int kBDistanceToNextManeuverDisplayUnitsAvailable = 24;

    /**
     * Clears the field "bDistanceToNextManeuverDisplayUnitsAvailable".
     *
     * The field will be set to its default value. The hasBDistanceToNextManeuverDisplayUnitsAvailable()
     * method will return false.
     */
    inline void clearBDistanceToNextManeuverDisplayUnitsAvailable();

    /**
     * Checks whether the field "bDistanceToNextManeuverDisplayUnitsAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDistanceToNextManeuverDisplayUnitsAvailable()). Otherwise it will return false.
     */
    inline bool hasBDistanceToNextManeuverDisplayUnitsAvailable () const;

    /**
     * Returns the value of the member "bDistanceToNextManeuverDisplayUnitsAvailable".
     *
     * Availability of DistanceToNextManeuverDisplayUnits parameter
     *
     * @return The value of the field "bDistanceToNextManeuverDisplayUnitsAvailable"
     */
    inline bool getBDistanceToNextManeuverDisplayUnitsAvailable () const;

    /**
     * Sets the value of the member "bDistanceToNextManeuverDisplayUnitsAvailable".
     *
     * Availability of DistanceToNextManeuverDisplayUnits parameter
     *
     * @param bDistanceToNextManeuverDisplayUnitsAvailable The value which will be set
     */
    inline void setBDistanceToNextManeuverDisplayUnitsAvailable (bool bDistanceToNextManeuverDisplayUnitsAvailable_);

    // API of field "e8DistanceToNextManeuverDisplayUnits"

    static const int kE8DistanceToNextManeuverDisplayUnits = 25;

    /**
     * Clears the field "e8DistanceToNextManeuverDisplayUnits".
     *
     * The field will be set to its default value. The hasE8DistanceToNextManeuverDisplayUnits()
     * method will return false.
     */
    inline void clearE8DistanceToNextManeuverDisplayUnits();

    /**
     * Checks whether the field "e8DistanceToNextManeuverDisplayUnits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DistanceToNextManeuverDisplayUnits()). Otherwise it will return false.
     */
    inline bool hasE8DistanceToNextManeuverDisplayUnits () const;

    /**
     * Returns the value of the member "e8DistanceToNextManeuverDisplayUnits".
     *
     * Units that must accompany DistanceToNextManeuverDisplayStr when displayed to the user.
     *
     * @return The value of the field "e8DistanceToNextManeuverDisplayUnits"
     */
    inline T_e8_DistanceDisplayUnits getE8DistanceToNextManeuverDisplayUnits () const;

    /**
     * Sets the value of the member "e8DistanceToNextManeuverDisplayUnits".
     *
     * Units that must accompany DistanceToNextManeuverDisplayStr when displayed to the user.
     *
     * @param e8DistanceToNextManeuverDisplayUnits The value which will be set
     */
    inline void setE8DistanceToNextManeuverDisplayUnits (T_e8_DistanceDisplayUnits e8DistanceToNextManeuverDisplayUnits_);

    // API of field "bRouteGuidanceManeuverCurrentListAvailable"

    static const int kBRouteGuidanceManeuverCurrentListAvailable = 26;

    /**
     * Clears the field "bRouteGuidanceManeuverCurrentListAvailable".
     *
     * The field will be set to its default value. The hasBRouteGuidanceManeuverCurrentListAvailable()
     * method will return false.
     */
    inline void clearBRouteGuidanceManeuverCurrentListAvailable();

    /**
     * Checks whether the field "bRouteGuidanceManeuverCurrentListAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRouteGuidanceManeuverCurrentListAvailable()). Otherwise it will return false.
     */
    inline bool hasBRouteGuidanceManeuverCurrentListAvailable () const;

    /**
     * Returns the value of the member "bRouteGuidanceManeuverCurrentListAvailable".
     *
     * Availability of RouteGuidanceManeuverCurrentList parameter
     *
     * @return The value of the field "bRouteGuidanceManeuverCurrentListAvailable"
     */
    inline bool getBRouteGuidanceManeuverCurrentListAvailable () const;

    /**
     * Sets the value of the member "bRouteGuidanceManeuverCurrentListAvailable".
     *
     * Availability of RouteGuidanceManeuverCurrentList parameter
     *
     * @param bRouteGuidanceManeuverCurrentListAvailable The value which will be set
     */
    inline void setBRouteGuidanceManeuverCurrentListAvailable (bool bRouteGuidanceManeuverCurrentListAvailable_);

    // API of field "RouteGuidanceManeuverCurrentList"

    static const int kRouteGuidanceManeuverCurrentList = 27;

    /**
     * Clears the field "RouteGuidanceManeuverCurrentList".
     *
     * The field will be set to its default value. The hasRouteGuidanceManeuverCurrentList()
     * method will return false.
     */
    inline void clearRouteGuidanceManeuverCurrentList();

    /**
     * Checks whether the field "RouteGuidanceManeuverCurrentList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteGuidanceManeuverCurrentList()). Otherwise it will return false.
     */
    inline bool hasRouteGuidanceManeuverCurrentList () const;

    /**
     * Returns the value of the member "RouteGuidanceManeuverCurrentList".
     *
     * Indices of next upcoming maneuvers in the RouteGuidance maneuver list. Multiple manuvers that occur very close together
     * can be grouped into an ordered list of indices with this parameter. Normally there would only be one entry for the current
     * upcoming maneuver. If more than one item is present in RouteGuidanceManeuverCurrent-List the maneuvers should be
     * executed in quick succession and can be displayed next to one another on the display.
     *
     * @return The value of the field "RouteGuidanceManeuverCurrentList"
     */
    inline const T_RouteGuidanceManeuverCurrentList& getRouteGuidanceManeuverCurrentList () const;

    /**
     * Retrieves the value of the field "RouteGuidanceManeuverCurrentList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RouteGuidanceManeuverCurrentList".
     */
    inline T_RouteGuidanceManeuverCurrentList& getRouteGuidanceManeuverCurrentListMutable ();

    /**
     * Sets the value of the member "RouteGuidanceManeuverCurrentList".
     *
     * Indices of next upcoming maneuvers in the RouteGuidance maneuver list. Multiple manuvers that occur very close together
     * can be grouped into an ordered list of indices with this parameter. Normally there would only be one entry for the current
     * upcoming maneuver. If more than one item is present in RouteGuidanceManeuverCurrent-List the maneuvers should be
     * executed in quick succession and can be displayed next to one another on the display.
     *
     * @param RouteGuidanceManeuverCurrentList The value which will be set
     */
    inline void setRouteGuidanceManeuverCurrentList (const T_RouteGuidanceManeuverCurrentList& RouteGuidanceManeuverCurrentList_);

    // API of field "bRouteGuidanceManeuverCountAvailable"

    static const int kBRouteGuidanceManeuverCountAvailable = 28;

    /**
     * Clears the field "bRouteGuidanceManeuverCountAvailable".
     *
     * The field will be set to its default value. The hasBRouteGuidanceManeuverCountAvailable()
     * method will return false.
     */
    inline void clearBRouteGuidanceManeuverCountAvailable();

    /**
     * Checks whether the field "bRouteGuidanceManeuverCountAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRouteGuidanceManeuverCountAvailable()). Otherwise it will return false.
     */
    inline bool hasBRouteGuidanceManeuverCountAvailable () const;

    /**
     * Returns the value of the member "bRouteGuidanceManeuverCountAvailable".
     *
     * Availability of RouteGuidanceManeuverCount parameter
     *
     * @return The value of the field "bRouteGuidanceManeuverCountAvailable"
     */
    inline bool getBRouteGuidanceManeuverCountAvailable () const;

    /**
     * Sets the value of the member "bRouteGuidanceManeuverCountAvailable".
     *
     * Availability of RouteGuidanceManeuverCount parameter
     *
     * @param bRouteGuidanceManeuverCountAvailable The value which will be set
     */
    inline void setBRouteGuidanceManeuverCountAvailable (bool bRouteGuidanceManeuverCountAvailable_);

    // API of field "RouteGuidanceManeuverCount"

    static const int kRouteGuidanceManeuverCount = 29;

    /**
     * Clears the field "RouteGuidanceManeuverCount".
     *
     * The field will be set to its default value. The hasRouteGuidanceManeuverCount()
     * method will return false.
     */
    inline void clearRouteGuidanceManeuverCount();

    /**
     * Checks whether the field "RouteGuidanceManeuverCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteGuidanceManeuverCount()). Otherwise it will return false.
     */
    inline bool hasRouteGuidanceManeuverCount () const;

    /**
     * Returns the value of the member "RouteGuidanceManeuverCount".
     *
     * Total number of maneuvers in the RouteGuidance maneuver list.
     *
     * @return The value of the field "RouteGuidanceManeuverCount"
     */
    inline uint16 getRouteGuidanceManeuverCount () const;

    /**
     * Sets the value of the member "RouteGuidanceManeuverCount".
     *
     * Total number of maneuvers in the RouteGuidance maneuver list.
     *
     * @param RouteGuidanceManeuverCount The value which will be set
     */
    inline void setRouteGuidanceManeuverCount (uint16 RouteGuidanceManeuverCount_);

    // API of field "bRouteGuidanceVisibleInAppAvailable"

    static const int kBRouteGuidanceVisibleInAppAvailable = 30;

    /**
     * Clears the field "bRouteGuidanceVisibleInAppAvailable".
     *
     * The field will be set to its default value. The hasBRouteGuidanceVisibleInAppAvailable()
     * method will return false.
     */
    inline void clearBRouteGuidanceVisibleInAppAvailable();

    /**
     * Checks whether the field "bRouteGuidanceVisibleInAppAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRouteGuidanceVisibleInAppAvailable()). Otherwise it will return false.
     */
    inline bool hasBRouteGuidanceVisibleInAppAvailable () const;

    /**
     * Returns the value of the member "bRouteGuidanceVisibleInAppAvailable".
     *
     * Availability of RouteGuidanceVisibleInApp parameter
     *
     * @return The value of the field "bRouteGuidanceVisibleInAppAvailable"
     */
    inline bool getBRouteGuidanceVisibleInAppAvailable () const;

    /**
     * Sets the value of the member "bRouteGuidanceVisibleInAppAvailable".
     *
     * Availability of RouteGuidanceVisibleInApp parameter
     *
     * @param bRouteGuidanceVisibleInAppAvailable The value which will be set
     */
    inline void setBRouteGuidanceVisibleInAppAvailable (bool bRouteGuidanceVisibleInAppAvailable_);

    // API of field "RouteGuidanceVisibleInApp"

    static const int kRouteGuidanceVisibleInApp = 31;

    /**
     * Clears the field "RouteGuidanceVisibleInApp".
     *
     * The field will be set to its default value. The hasRouteGuidanceVisibleInApp()
     * method will return false.
     */
    inline void clearRouteGuidanceVisibleInApp();

    /**
     * Checks whether the field "RouteGuidanceVisibleInApp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteGuidanceVisibleInApp()). Otherwise it will return false.
     */
    inline bool hasRouteGuidanceVisibleInApp () const;

    /**
     * Returns the value of the member "RouteGuidanceVisibleInApp".
     *
     * Whether Route guidance is visible in the navigation app.
     *
     * @return The value of the field "RouteGuidanceVisibleInApp"
     */
    inline bool getRouteGuidanceVisibleInApp () const;

    /**
     * Sets the value of the member "RouteGuidanceVisibleInApp".
     *
     * Whether Route guidance is visible in the navigation app.
     *
     * @param RouteGuidanceVisibleInApp The value which will be set
     */
    inline void setRouteGuidanceVisibleInApp (bool RouteGuidanceVisibleInApp_);

    // API of field "bSourceNameAvailable"

    static const int kBSourceNameAvailable = 32;

    /**
     * Clears the field "bSourceNameAvailable".
     *
     * The field will be set to its default value. The hasBSourceNameAvailable()
     * method will return false.
     */
    inline void clearBSourceNameAvailable();

    /**
     * Checks whether the field "bSourceNameAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSourceNameAvailable()). Otherwise it will return false.
     */
    inline bool hasBSourceNameAvailable () const;

    /**
     * Returns the value of the member "bSourceNameAvailable".
     *
     * Availability of SourceName parameter
     *
     * @return The value of the field "bSourceNameAvailable"
     */
    inline bool getBSourceNameAvailable () const;

    /**
     * Sets the value of the member "bSourceNameAvailable".
     *
     * Availability of SourceName parameter
     *
     * @param bSourceNameAvailable The value which will be set
     */
    inline void setBSourceNameAvailable (bool bSourceNameAvailable_);

    // API of field "SourceName"

    static const int kSourceName = 33;

    /**
     * Clears the field "SourceName".
     *
     * The field will be set to its default value. The hasSourceName()
     * method will return false.
     */
    inline void clearSourceName();

    /**
     * Checks whether the field "SourceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceName()). Otherwise it will return false.
     */
    inline bool hasSourceName () const;

    /**
     * Returns the value of the member "SourceName".
     *
     * Name of application providing turn-by-turn information
     * in Carplay, for display purposes only. Do not use for basing
     * any behaviour change decisions.
     *
     * @return The value of the field "SourceName"
     */
    inline const ::std::string& getSourceName () const;

    /**
     * Retrieves the value of the field "SourceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SourceName".
     */
    inline ::std::string& getSourceNameMutable ();

    /**
     * Sets the value of the member "SourceName".
     *
     * Name of application providing turn-by-turn information
     * in Carplay, for display purposes only. Do not use for basing
     * any behaviour change decisions.
     *
     * @param SourceName The value which will be set
     */
    inline void setSourceName (const ::std::string& SourceName_);

    /**
     * Sets the value of the member "SourceName".
     *
     * Name of application providing turn-by-turn information
     * in Carplay, for display purposes only. Do not use for basing
     * any behaviour change decisions.
     *
     * @param SourceName The value which will be set
     */
    inline void setSourceName (const char* SourceName_);

    /**
     * Sets the value of the member "SourceName".
     *
     * Name of application providing turn-by-turn information
     * in Carplay, for display purposes only. Do not use for basing
     * any behaviour change decisions.
     *
     * @param SourceName The value which will be set
     */
    inline void setSourceName (const char* value, size_t size);

    // API of field "bSourceSupportsRouteGuidanceAvailable"

    static const int kBSourceSupportsRouteGuidanceAvailable = 34;

    /**
     * Clears the field "bSourceSupportsRouteGuidanceAvailable".
     *
     * The field will be set to its default value. The hasBSourceSupportsRouteGuidanceAvailable()
     * method will return false.
     */
    inline void clearBSourceSupportsRouteGuidanceAvailable();

    /**
     * Checks whether the field "bSourceSupportsRouteGuidanceAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSourceSupportsRouteGuidanceAvailable()). Otherwise it will return false.
     */
    inline bool hasBSourceSupportsRouteGuidanceAvailable () const;

    /**
     * Returns the value of the member "bSourceSupportsRouteGuidanceAvailable".
     *
     * Availability of SourceName parameter
     *
     * @return The value of the field "bSourceSupportsRouteGuidanceAvailable"
     */
    inline bool getBSourceSupportsRouteGuidanceAvailable () const;

    /**
     * Sets the value of the member "bSourceSupportsRouteGuidanceAvailable".
     *
     * Availability of SourceName parameter
     *
     * @param bSourceSupportsRouteGuidanceAvailable The value which will be set
     */
    inline void setBSourceSupportsRouteGuidanceAvailable (bool bSourceSupportsRouteGuidanceAvailable_);

    // API of field "SourceSupportsRouteGuidance"

    static const int kSourceSupportsRouteGuidance = 35;

    /**
     * Clears the field "SourceSupportsRouteGuidance".
     *
     * The field will be set to its default value. The hasSourceSupportsRouteGuidance()
     * method will return false.
     */
    inline void clearSourceSupportsRouteGuidance();

    /**
     * Checks whether the field "SourceSupportsRouteGuidance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceSupportsRouteGuidance()). Otherwise it will return false.
     */
    inline bool hasSourceSupportsRouteGuidance () const;

    /**
     * Returns the value of the member "SourceSupportsRouteGuidance".
     *
     * Whether application providing turn-by-turn information
     * in Carplay can populate RouteGuidanceManeuverInformation or
     * parameters 0-15 in RouteGuidance.
     *
     * @return The value of the field "SourceSupportsRouteGuidance"
     */
    inline bool getSourceSupportsRouteGuidance () const;

    /**
     * Sets the value of the member "SourceSupportsRouteGuidance".
     *
     * Whether application providing turn-by-turn information
     * in Carplay can populate RouteGuidanceManeuverInformation or
     * parameters 0-15 in RouteGuidance.
     *
     * @param SourceSupportsRouteGuidance The value which will be set
     */
    inline void setSourceSupportsRouteGuidance (bool SourceSupportsRouteGuidance_);

    static const T_RouteGuidanceUpdate &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_bRouteGuidanceDisplayComponentIDsAvailable ();

    inline void clear_has_bRouteGuidanceDisplayComponentIDsAvailable ();

    inline void set_has_RouteGuidanceDisplayComponentIDs ();

    inline void clear_has_RouteGuidanceDisplayComponentIDs ();

    inline void set_has_bRouteGuidanceStateAvailable ();

    inline void clear_has_bRouteGuidanceStateAvailable ();

    inline void set_has_e8RouteGuidanceState ();

    inline void clear_has_e8RouteGuidanceState ();

    inline void set_has_bManeuverStateAvailable ();

    inline void clear_has_bManeuverStateAvailable ();

    inline void set_has_e8ManeuverState ();

    inline void clear_has_e8ManeuverState ();

    inline void set_has_bCurrentRoadNameAvailable ();

    inline void clear_has_bCurrentRoadNameAvailable ();

    inline void set_has_CurrentRoadName ();

    inline void clear_has_CurrentRoadName ();

    inline void set_has_bDestinationNameAvailable ();

    inline void clear_has_bDestinationNameAvailable ();

    inline void set_has_DestinationName ();

    inline void clear_has_DestinationName ();

    inline void set_has_bEstimatedTimeOfArrivalAvailable ();

    inline void clear_has_bEstimatedTimeOfArrivalAvailable ();

    inline void set_has_EstimatedTimeOfArrival ();

    inline void clear_has_EstimatedTimeOfArrival ();

    inline void set_has_bTimeRemainingToDestinationAvailable ();

    inline void clear_has_bTimeRemainingToDestinationAvailable ();

    inline void set_has_TimeRemainingToDestination ();

    inline void clear_has_TimeRemainingToDestination ();

    inline void set_has_bDistanceRemainingAvailable ();

    inline void clear_has_bDistanceRemainingAvailable ();

    inline void set_has_DistanceRemaining ();

    inline void clear_has_DistanceRemaining ();

    inline void set_has_bDistanceRemainingDisplayStrAvailable ();

    inline void clear_has_bDistanceRemainingDisplayStrAvailable ();

    inline void set_has_DistanceRemainingDisplayStr ();

    inline void clear_has_DistanceRemainingDisplayStr ();

    inline void set_has_bDistanceRemainingDisplayUnitsAvailable ();

    inline void clear_has_bDistanceRemainingDisplayUnitsAvailable ();

    inline void set_has_e8DistanceRemainingDisplayUnits ();

    inline void clear_has_e8DistanceRemainingDisplayUnits ();

    inline void set_has_bDistanceToNextManeuverAvailable ();

    inline void clear_has_bDistanceToNextManeuverAvailable ();

    inline void set_has_DistanceToNextManeuver ();

    inline void clear_has_DistanceToNextManeuver ();

    inline void set_has_bDistanceToNextManeuverDisplayStrAvailable ();

    inline void clear_has_bDistanceToNextManeuverDisplayStrAvailable ();

    inline void set_has_DistanceToNextManeuverDisplayStr ();

    inline void clear_has_DistanceToNextManeuverDisplayStr ();

    inline void set_has_bDistanceToNextManeuverDisplayUnitsAvailable ();

    inline void clear_has_bDistanceToNextManeuverDisplayUnitsAvailable ();

    inline void set_has_e8DistanceToNextManeuverDisplayUnits ();

    inline void clear_has_e8DistanceToNextManeuverDisplayUnits ();

    inline void set_has_bRouteGuidanceManeuverCurrentListAvailable ();

    inline void clear_has_bRouteGuidanceManeuverCurrentListAvailable ();

    inline void set_has_RouteGuidanceManeuverCurrentList ();

    inline void clear_has_RouteGuidanceManeuverCurrentList ();

    inline void set_has_bRouteGuidanceManeuverCountAvailable ();

    inline void clear_has_bRouteGuidanceManeuverCountAvailable ();

    inline void set_has_RouteGuidanceManeuverCount ();

    inline void clear_has_RouteGuidanceManeuverCount ();

    inline void set_has_bRouteGuidanceVisibleInAppAvailable ();

    inline void clear_has_bRouteGuidanceVisibleInAppAvailable ();

    inline void set_has_RouteGuidanceVisibleInApp ();

    inline void clear_has_RouteGuidanceVisibleInApp ();

    inline void set_has_bSourceNameAvailable ();

    inline void clear_has_bSourceNameAvailable ();

    inline void set_has_SourceName ();

    inline void clear_has_SourceName ();

    inline void set_has_bSourceSupportsRouteGuidanceAvailable ();

    inline void clear_has_bSourceSupportsRouteGuidanceAvailable ();

    inline void set_has_SourceSupportsRouteGuidance ();

    inline void clear_has_SourceSupportsRouteGuidance ();

    uint32 _has_bits_[ (36 + 31) / 32];

    bool _bRouteGuidanceDisplayComponentIDsAvailable;

    T_RouteGuidanceDisplayComponentIDs _RouteGuidanceDisplayComponentIDs;

    bool _bRouteGuidanceStateAvailable;

    T_e8_RouteGuidanceState _e8RouteGuidanceState;

    bool _bManeuverStateAvailable;

    T_e8_ManeuverState _e8ManeuverState;

    bool _bCurrentRoadNameAvailable;

    ::std::string _CurrentRoadName;

    bool _bDestinationNameAvailable;

    ::std::string _DestinationName;

    bool _bEstimatedTimeOfArrivalAvailable;

    uint64 _EstimatedTimeOfArrival;

    bool _bTimeRemainingToDestinationAvailable;

    uint64 _TimeRemainingToDestination;

    bool _bDistanceRemainingAvailable;

    uint32 _DistanceRemaining;

    bool _bDistanceRemainingDisplayStrAvailable;

    ::std::string _DistanceRemainingDisplayStr;

    bool _bDistanceRemainingDisplayUnitsAvailable;

    T_e8_DistanceDisplayUnits _e8DistanceRemainingDisplayUnits;

    bool _bDistanceToNextManeuverAvailable;

    uint32 _DistanceToNextManeuver;

    bool _bDistanceToNextManeuverDisplayStrAvailable;

    ::std::string _DistanceToNextManeuverDisplayStr;

    bool _bDistanceToNextManeuverDisplayUnitsAvailable;

    T_e8_DistanceDisplayUnits _e8DistanceToNextManeuverDisplayUnits;

    bool _bRouteGuidanceManeuverCurrentListAvailable;

    T_RouteGuidanceManeuverCurrentList _RouteGuidanceManeuverCurrentList;

    bool _bRouteGuidanceManeuverCountAvailable;

    uint16 _RouteGuidanceManeuverCount;

    bool _bRouteGuidanceVisibleInAppAvailable;

    bool _RouteGuidanceVisibleInApp;

    bool _bSourceNameAvailable;

    ::std::string _SourceName;

    bool _bSourceSupportsRouteGuidanceAvailable;

    bool _SourceSupportsRouteGuidance;

};

/**
 * If the meaning of "T_RouteGuidanceManeuverUpdate" isn't clear, then there should be a description here.
 */
class T_RouteGuidanceManeuverUpdate {
public:

    /**
     * Default constructor
     */
    inline  T_RouteGuidanceManeuverUpdate ();

    /**
     * Copy constructor
     */
    inline  T_RouteGuidanceManeuverUpdate (const T_RouteGuidanceManeuverUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  T_RouteGuidanceManeuverUpdate (bool bRouteGuidanceDisplayComponentIDsAvailable_, const T_RouteGuidanceDisplayComponentIDs& RouteGuidanceDisplayComponentIDs_, bool bIndexAvailable_, uint16 Index_, bool bManeuverDescriptionAvailable_, const ::std::string& ManeuverDescription_, bool bManeuverTypeAvailable_, T_e8_ManeuverType e8ManeuverType_, bool bAfterManeuverRoadNameAvailable_, const ::std::string& AfterManeuverRoadName_, bool bDistanceBetweenManeuverAvailable_, uint32 DistanceBetweenManeuver_, bool bDistanceBetweenManeuverDisplayStrAvailable_, const ::std::string& DistanceBetweenManeuverDisplayStr_, bool bDistanceBetweenManeuverDisplayUnitsAvailable_, T_e8_DistanceDisplayUnits e8DistanceBetweenManeuverDisplayUnits_, bool bDrivingSideAvailable_, T_e8_DrivingSide e8DrivingSide_, bool bJunctionTypeAvailable_, T_e8_JunctionType e8JunctionType_, bool bJunctionElementAngleAvailable_, const T_JunctionElementAngles& JunctionElementAngle_, bool bJunctionElementExitAngleAvailable_, int16 JunctionElementExitAngle_);

    /**
     * Destructor
     */
    inline  ~T_RouteGuidanceManeuverUpdate();

    /**
     * Assignment operator
     */
    inline T_RouteGuidanceManeuverUpdate& operator = (const T_RouteGuidanceManeuverUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_RouteGuidanceManeuverUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_RouteGuidanceManeuverUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_RouteGuidanceManeuverUpdate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_RouteGuidanceManeuverUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bRouteGuidanceDisplayComponentIDsAvailable"

    static const int kBRouteGuidanceDisplayComponentIDsAvailable = 0;

    /**
     * Clears the field "bRouteGuidanceDisplayComponentIDsAvailable".
     *
     * The field will be set to its default value. The hasBRouteGuidanceDisplayComponentIDsAvailable()
     * method will return false.
     */
    inline void clearBRouteGuidanceDisplayComponentIDsAvailable();

    /**
     * Checks whether the field "bRouteGuidanceDisplayComponentIDsAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRouteGuidanceDisplayComponentIDsAvailable()). Otherwise it will return false.
     */
    inline bool hasBRouteGuidanceDisplayComponentIDsAvailable () const;

    /**
     * Returns the value of the member "bRouteGuidanceDisplayComponentIDsAvailable".
     *
     * Availability of RouteGuidanceDisplayComponentIDs parameter
     *
     * @return The value of the field "bRouteGuidanceDisplayComponentIDsAvailable"
     */
    inline bool getBRouteGuidanceDisplayComponentIDsAvailable () const;

    /**
     * Sets the value of the member "bRouteGuidanceDisplayComponentIDsAvailable".
     *
     * Availability of RouteGuidanceDisplayComponentIDs parameter
     *
     * @param bRouteGuidanceDisplayComponentIDsAvailable The value which will be set
     */
    inline void setBRouteGuidanceDisplayComponentIDsAvailable (bool bRouteGuidanceDisplayComponentIDsAvailable_);

    // API of field "RouteGuidanceDisplayComponentIDs"

    static const int kRouteGuidanceDisplayComponentIDs = 1;

    /**
     * Clears the field "RouteGuidanceDisplayComponentIDs".
     *
     * The field will be set to its default value. The hasRouteGuidanceDisplayComponentIDs()
     * method will return false.
     */
    inline void clearRouteGuidanceDisplayComponentIDs();

    /**
     * Checks whether the field "RouteGuidanceDisplayComponentIDs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteGuidanceDisplayComponentIDs()). Otherwise it will return false.
     */
    inline bool hasRouteGuidanceDisplayComponentIDs () const;

    /**
     * Returns the value of the member "RouteGuidanceDisplayComponentIDs".
     *
     * If size is 0, it means the update applies to all components. If more than one are specified, update is applied to all specified components.
     *
     * @return The value of the field "RouteGuidanceDisplayComponentIDs"
     */
    inline const T_RouteGuidanceDisplayComponentIDs& getRouteGuidanceDisplayComponentIDs () const;

    /**
     * Retrieves the value of the field "RouteGuidanceDisplayComponentIDs" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RouteGuidanceDisplayComponentIDs".
     */
    inline T_RouteGuidanceDisplayComponentIDs& getRouteGuidanceDisplayComponentIDsMutable ();

    /**
     * Sets the value of the member "RouteGuidanceDisplayComponentIDs".
     *
     * If size is 0, it means the update applies to all components. If more than one are specified, update is applied to all specified components.
     *
     * @param RouteGuidanceDisplayComponentIDs The value which will be set
     */
    inline void setRouteGuidanceDisplayComponentIDs (const T_RouteGuidanceDisplayComponentIDs& RouteGuidanceDisplayComponentIDs_);

    // API of field "bIndexAvailable"

    static const int kBIndexAvailable = 2;

    /**
     * Clears the field "bIndexAvailable".
     *
     * The field will be set to its default value. The hasBIndexAvailable()
     * method will return false.
     */
    inline void clearBIndexAvailable();

    /**
     * Checks whether the field "bIndexAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIndexAvailable()). Otherwise it will return false.
     */
    inline bool hasBIndexAvailable () const;

    /**
     * Returns the value of the member "bIndexAvailable".
     *
     * Availability of Index parameter
     *
     * @return The value of the field "bIndexAvailable"
     */
    inline bool getBIndexAvailable () const;

    /**
     * Sets the value of the member "bIndexAvailable".
     *
     * Availability of Index parameter
     *
     * @param bIndexAvailable The value which will be set
     */
    inline void setBIndexAvailable (bool bIndexAvailable_);

    // API of field "Index"

    static const int kIndex = 3;

    /**
     * Clears the field "Index".
     *
     * The field will be set to its default value. The hasIndex()
     * method will return false.
     */
    inline void clearIndex();

    /**
     * Checks whether the field "Index" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIndex()). Otherwise it will return false.
     */
    inline bool hasIndex () const;

    /**
     * Returns the value of the member "Index".
     *
     * Specifies which item in the list is being updated.
     *
     * @return The value of the field "Index"
     */
    inline uint16 getIndex () const;

    /**
     * Sets the value of the member "Index".
     *
     * Specifies which item in the list is being updated.
     *
     * @param Index The value which will be set
     */
    inline void setIndex (uint16 Index_);

    // API of field "bManeuverDescriptionAvailable"

    static const int kBManeuverDescriptionAvailable = 4;

    /**
     * Clears the field "bManeuverDescriptionAvailable".
     *
     * The field will be set to its default value. The hasBManeuverDescriptionAvailable()
     * method will return false.
     */
    inline void clearBManeuverDescriptionAvailable();

    /**
     * Checks whether the field "bManeuverDescriptionAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBManeuverDescriptionAvailable()). Otherwise it will return false.
     */
    inline bool hasBManeuverDescriptionAvailable () const;

    /**
     * Returns the value of the member "bManeuverDescriptionAvailable".
     *
     * Availability of ManeuverDescription parameter
     *
     * @return The value of the field "bManeuverDescriptionAvailable"
     */
    inline bool getBManeuverDescriptionAvailable () const;

    /**
     * Sets the value of the member "bManeuverDescriptionAvailable".
     *
     * Availability of ManeuverDescription parameter
     *
     * @param bManeuverDescriptionAvailable The value which will be set
     */
    inline void setBManeuverDescriptionAvailable (bool bManeuverDescriptionAvailable_);

    // API of field "ManeuverDescription"

    static const int kManeuverDescription = 5;

    /**
     * Clears the field "ManeuverDescription".
     *
     * The field will be set to its default value. The hasManeuverDescription()
     * method will return false.
     */
    inline void clearManeuverDescription();

    /**
     * Checks whether the field "ManeuverDescription" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setManeuverDescription()). Otherwise it will return false.
     */
    inline bool hasManeuverDescription () const;

    /**
     * Returns the value of the member "ManeuverDescription".
     *
     * ManeuverDescription
     *
     * @return The value of the field "ManeuverDescription"
     */
    inline const ::std::string& getManeuverDescription () const;

    /**
     * Retrieves the value of the field "ManeuverDescription" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ManeuverDescription".
     */
    inline ::std::string& getManeuverDescriptionMutable ();

    /**
     * Sets the value of the member "ManeuverDescription".
     *
     * ManeuverDescription
     *
     * @param ManeuverDescription The value which will be set
     */
    inline void setManeuverDescription (const ::std::string& ManeuverDescription_);

    /**
     * Sets the value of the member "ManeuverDescription".
     *
     * ManeuverDescription
     *
     * @param ManeuverDescription The value which will be set
     */
    inline void setManeuverDescription (const char* ManeuverDescription_);

    /**
     * Sets the value of the member "ManeuverDescription".
     *
     * ManeuverDescription
     *
     * @param ManeuverDescription The value which will be set
     */
    inline void setManeuverDescription (const char* value, size_t size);

    // API of field "bManeuverTypeAvailable"

    static const int kBManeuverTypeAvailable = 6;

    /**
     * Clears the field "bManeuverTypeAvailable".
     *
     * The field will be set to its default value. The hasBManeuverTypeAvailable()
     * method will return false.
     */
    inline void clearBManeuverTypeAvailable();

    /**
     * Checks whether the field "bManeuverTypeAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBManeuverTypeAvailable()). Otherwise it will return false.
     */
    inline bool hasBManeuverTypeAvailable () const;

    /**
     * Returns the value of the member "bManeuverTypeAvailable".
     *
     * Availability of ManeuverType parameter
     *
     * @return The value of the field "bManeuverTypeAvailable"
     */
    inline bool getBManeuverTypeAvailable () const;

    /**
     * Sets the value of the member "bManeuverTypeAvailable".
     *
     * Availability of ManeuverType parameter
     *
     * @param bManeuverTypeAvailable The value which will be set
     */
    inline void setBManeuverTypeAvailable (bool bManeuverTypeAvailable_);

    // API of field "e8ManeuverType"

    static const int kE8ManeuverType = 7;

    /**
     * Clears the field "e8ManeuverType".
     *
     * The field will be set to its default value. The hasE8ManeuverType()
     * method will return false.
     */
    inline void clearE8ManeuverType();

    /**
     * Checks whether the field "e8ManeuverType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ManeuverType()). Otherwise it will return false.
     */
    inline bool hasE8ManeuverType () const;

    /**
     * Returns the value of the member "e8ManeuverType".
     *
     * ManeuverType enum.
     *
     * @return The value of the field "e8ManeuverType"
     */
    inline T_e8_ManeuverType getE8ManeuverType () const;

    /**
     * Sets the value of the member "e8ManeuverType".
     *
     * ManeuverType enum.
     *
     * @param e8ManeuverType The value which will be set
     */
    inline void setE8ManeuverType (T_e8_ManeuverType e8ManeuverType_);

    // API of field "bAfterManeuverRoadNameAvailable"

    static const int kBAfterManeuverRoadNameAvailable = 8;

    /**
     * Clears the field "bAfterManeuverRoadNameAvailable".
     *
     * The field will be set to its default value. The hasBAfterManeuverRoadNameAvailable()
     * method will return false.
     */
    inline void clearBAfterManeuverRoadNameAvailable();

    /**
     * Checks whether the field "bAfterManeuverRoadNameAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAfterManeuverRoadNameAvailable()). Otherwise it will return false.
     */
    inline bool hasBAfterManeuverRoadNameAvailable () const;

    /**
     * Returns the value of the member "bAfterManeuverRoadNameAvailable".
     *
     * Availability of AfterManeuverRoadName parameter
     *
     * @return The value of the field "bAfterManeuverRoadNameAvailable"
     */
    inline bool getBAfterManeuverRoadNameAvailable () const;

    /**
     * Sets the value of the member "bAfterManeuverRoadNameAvailable".
     *
     * Availability of AfterManeuverRoadName parameter
     *
     * @param bAfterManeuverRoadNameAvailable The value which will be set
     */
    inline void setBAfterManeuverRoadNameAvailable (bool bAfterManeuverRoadNameAvailable_);

    // API of field "AfterManeuverRoadName"

    static const int kAfterManeuverRoadName = 9;

    /**
     * Clears the field "AfterManeuverRoadName".
     *
     * The field will be set to its default value. The hasAfterManeuverRoadName()
     * method will return false.
     */
    inline void clearAfterManeuverRoadName();

    /**
     * Checks whether the field "AfterManeuverRoadName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAfterManeuverRoadName()). Otherwise it will return false.
     */
    inline bool hasAfterManeuverRoadName () const;

    /**
     * Returns the value of the member "AfterManeuverRoadName".
     *
     * The name of the road the vehicle will end up on after the maneuver is completed successfully.
     *
     * @return The value of the field "AfterManeuverRoadName"
     */
    inline const ::std::string& getAfterManeuverRoadName () const;

    /**
     * Retrieves the value of the field "AfterManeuverRoadName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AfterManeuverRoadName".
     */
    inline ::std::string& getAfterManeuverRoadNameMutable ();

    /**
     * Sets the value of the member "AfterManeuverRoadName".
     *
     * The name of the road the vehicle will end up on after the maneuver is completed successfully.
     *
     * @param AfterManeuverRoadName The value which will be set
     */
    inline void setAfterManeuverRoadName (const ::std::string& AfterManeuverRoadName_);

    /**
     * Sets the value of the member "AfterManeuverRoadName".
     *
     * The name of the road the vehicle will end up on after the maneuver is completed successfully.
     *
     * @param AfterManeuverRoadName The value which will be set
     */
    inline void setAfterManeuverRoadName (const char* AfterManeuverRoadName_);

    /**
     * Sets the value of the member "AfterManeuverRoadName".
     *
     * The name of the road the vehicle will end up on after the maneuver is completed successfully.
     *
     * @param AfterManeuverRoadName The value which will be set
     */
    inline void setAfterManeuverRoadName (const char* value, size_t size);

    // API of field "bDistanceBetweenManeuverAvailable"

    static const int kBDistanceBetweenManeuverAvailable = 10;

    /**
     * Clears the field "bDistanceBetweenManeuverAvailable".
     *
     * The field will be set to its default value. The hasBDistanceBetweenManeuverAvailable()
     * method will return false.
     */
    inline void clearBDistanceBetweenManeuverAvailable();

    /**
     * Checks whether the field "bDistanceBetweenManeuverAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDistanceBetweenManeuverAvailable()). Otherwise it will return false.
     */
    inline bool hasBDistanceBetweenManeuverAvailable () const;

    /**
     * Returns the value of the member "bDistanceBetweenManeuverAvailable".
     *
     * Availability of DistanceBetweenManeuve parameter
     *
     * @return The value of the field "bDistanceBetweenManeuverAvailable"
     */
    inline bool getBDistanceBetweenManeuverAvailable () const;

    /**
     * Sets the value of the member "bDistanceBetweenManeuverAvailable".
     *
     * Availability of DistanceBetweenManeuve parameter
     *
     * @param bDistanceBetweenManeuverAvailable The value which will be set
     */
    inline void setBDistanceBetweenManeuverAvailable (bool bDistanceBetweenManeuverAvailable_);

    // API of field "DistanceBetweenManeuver"

    static const int kDistanceBetweenManeuver = 11;

    /**
     * Clears the field "DistanceBetweenManeuver".
     *
     * The field will be set to its default value. The hasDistanceBetweenManeuver()
     * method will return false.
     */
    inline void clearDistanceBetweenManeuver();

    /**
     * Checks whether the field "DistanceBetweenManeuver" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceBetweenManeuver()). Otherwise it will return false.
     */
    inline bool hasDistanceBetweenManeuver () const;

    /**
     * Returns the value of the member "DistanceBetweenManeuver".
     *
     * Meters between previous maneuver to this maneuver.This value must not be displayed to the user in text. It is only to be used for generating graphics, e.g. countdown bars.
     *
     * @return The value of the field "DistanceBetweenManeuver"
     */
    inline uint32 getDistanceBetweenManeuver () const;

    /**
     * Sets the value of the member "DistanceBetweenManeuver".
     *
     * Meters between previous maneuver to this maneuver.This value must not be displayed to the user in text. It is only to be used for generating graphics, e.g. countdown bars.
     *
     * @param DistanceBetweenManeuver The value which will be set
     */
    inline void setDistanceBetweenManeuver (uint32 DistanceBetweenManeuver_);

    // API of field "bDistanceBetweenManeuverDisplayStrAvailable"

    static const int kBDistanceBetweenManeuverDisplayStrAvailable = 12;

    /**
     * Clears the field "bDistanceBetweenManeuverDisplayStrAvailable".
     *
     * The field will be set to its default value. The hasBDistanceBetweenManeuverDisplayStrAvailable()
     * method will return false.
     */
    inline void clearBDistanceBetweenManeuverDisplayStrAvailable();

    /**
     * Checks whether the field "bDistanceBetweenManeuverDisplayStrAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDistanceBetweenManeuverDisplayStrAvailable()). Otherwise it will return false.
     */
    inline bool hasBDistanceBetweenManeuverDisplayStrAvailable () const;

    /**
     * Returns the value of the member "bDistanceBetweenManeuverDisplayStrAvailable".
     *
     * Availability of DistanceBetweenManeuverDisplayStr parameter
     *
     * @return The value of the field "bDistanceBetweenManeuverDisplayStrAvailable"
     */
    inline bool getBDistanceBetweenManeuverDisplayStrAvailable () const;

    /**
     * Sets the value of the member "bDistanceBetweenManeuverDisplayStrAvailable".
     *
     * Availability of DistanceBetweenManeuverDisplayStr parameter
     *
     * @param bDistanceBetweenManeuverDisplayStrAvailable The value which will be set
     */
    inline void setBDistanceBetweenManeuverDisplayStrAvailable (bool bDistanceBetweenManeuverDisplayStrAvailable_);

    // API of field "DistanceBetweenManeuverDisplayStr"

    static const int kDistanceBetweenManeuverDisplayStr = 13;

    /**
     * Clears the field "DistanceBetweenManeuverDisplayStr".
     *
     * The field will be set to its default value. The hasDistanceBetweenManeuverDisplayStr()
     * method will return false.
     */
    inline void clearDistanceBetweenManeuverDisplayStr();

    /**
     * Checks whether the field "DistanceBetweenManeuverDisplayStr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceBetweenManeuverDisplayStr()). Otherwise it will return false.
     */
    inline bool hasDistanceBetweenManeuverDisplayStr () const;

    /**
     * Returns the value of the member "DistanceBetweenManeuverDisplayStr".
     *
     * Display string representation of DistanceBetweenManeuver in DistanceBetweenManeuver-DisplayUnits units. Does not contain the units string.
     * Must be displayed without unit conversion to the user.
     *
     * @return The value of the field "DistanceBetweenManeuverDisplayStr"
     */
    inline const ::std::string& getDistanceBetweenManeuverDisplayStr () const;

    /**
     * Retrieves the value of the field "DistanceBetweenManeuverDisplayStr" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DistanceBetweenManeuverDisplayStr".
     */
    inline ::std::string& getDistanceBetweenManeuverDisplayStrMutable ();

    /**
     * Sets the value of the member "DistanceBetweenManeuverDisplayStr".
     *
     * Display string representation of DistanceBetweenManeuver in DistanceBetweenManeuver-DisplayUnits units. Does not contain the units string.
     * Must be displayed without unit conversion to the user.
     *
     * @param DistanceBetweenManeuverDisplayStr The value which will be set
     */
    inline void setDistanceBetweenManeuverDisplayStr (const ::std::string& DistanceBetweenManeuverDisplayStr_);

    /**
     * Sets the value of the member "DistanceBetweenManeuverDisplayStr".
     *
     * Display string representation of DistanceBetweenManeuver in DistanceBetweenManeuver-DisplayUnits units. Does not contain the units string.
     * Must be displayed without unit conversion to the user.
     *
     * @param DistanceBetweenManeuverDisplayStr The value which will be set
     */
    inline void setDistanceBetweenManeuverDisplayStr (const char* DistanceBetweenManeuverDisplayStr_);

    /**
     * Sets the value of the member "DistanceBetweenManeuverDisplayStr".
     *
     * Display string representation of DistanceBetweenManeuver in DistanceBetweenManeuver-DisplayUnits units. Does not contain the units string.
     * Must be displayed without unit conversion to the user.
     *
     * @param DistanceBetweenManeuverDisplayStr The value which will be set
     */
    inline void setDistanceBetweenManeuverDisplayStr (const char* value, size_t size);

    // API of field "bDistanceBetweenManeuverDisplayUnitsAvailable"

    static const int kBDistanceBetweenManeuverDisplayUnitsAvailable = 14;

    /**
     * Clears the field "bDistanceBetweenManeuverDisplayUnitsAvailable".
     *
     * The field will be set to its default value. The hasBDistanceBetweenManeuverDisplayUnitsAvailable()
     * method will return false.
     */
    inline void clearBDistanceBetweenManeuverDisplayUnitsAvailable();

    /**
     * Checks whether the field "bDistanceBetweenManeuverDisplayUnitsAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDistanceBetweenManeuverDisplayUnitsAvailable()). Otherwise it will return false.
     */
    inline bool hasBDistanceBetweenManeuverDisplayUnitsAvailable () const;

    /**
     * Returns the value of the member "bDistanceBetweenManeuverDisplayUnitsAvailable".
     *
     * Availability of DistanceBetweenManeuverDisplayUnits parameter
     *
     * @return The value of the field "bDistanceBetweenManeuverDisplayUnitsAvailable"
     */
    inline bool getBDistanceBetweenManeuverDisplayUnitsAvailable () const;

    /**
     * Sets the value of the member "bDistanceBetweenManeuverDisplayUnitsAvailable".
     *
     * Availability of DistanceBetweenManeuverDisplayUnits parameter
     *
     * @param bDistanceBetweenManeuverDisplayUnitsAvailable The value which will be set
     */
    inline void setBDistanceBetweenManeuverDisplayUnitsAvailable (bool bDistanceBetweenManeuverDisplayUnitsAvailable_);

    // API of field "e8DistanceBetweenManeuverDisplayUnits"

    static const int kE8DistanceBetweenManeuverDisplayUnits = 15;

    /**
     * Clears the field "e8DistanceBetweenManeuverDisplayUnits".
     *
     * The field will be set to its default value. The hasE8DistanceBetweenManeuverDisplayUnits()
     * method will return false.
     */
    inline void clearE8DistanceBetweenManeuverDisplayUnits();

    /**
     * Checks whether the field "e8DistanceBetweenManeuverDisplayUnits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DistanceBetweenManeuverDisplayUnits()). Otherwise it will return false.
     */
    inline bool hasE8DistanceBetweenManeuverDisplayUnits () const;

    /**
     * Returns the value of the member "e8DistanceBetweenManeuverDisplayUnits".
     *
     * Units that must accompany DistanceBetweenManeuver-DisplayStr when displayed to the user.
     *
     * @return The value of the field "e8DistanceBetweenManeuverDisplayUnits"
     */
    inline T_e8_DistanceDisplayUnits getE8DistanceBetweenManeuverDisplayUnits () const;

    /**
     * Sets the value of the member "e8DistanceBetweenManeuverDisplayUnits".
     *
     * Units that must accompany DistanceBetweenManeuver-DisplayStr when displayed to the user.
     *
     * @param e8DistanceBetweenManeuverDisplayUnits The value which will be set
     */
    inline void setE8DistanceBetweenManeuverDisplayUnits (T_e8_DistanceDisplayUnits e8DistanceBetweenManeuverDisplayUnits_);

    // API of field "bDrivingSideAvailable"

    static const int kBDrivingSideAvailable = 16;

    /**
     * Clears the field "bDrivingSideAvailable".
     *
     * The field will be set to its default value. The hasBDrivingSideAvailable()
     * method will return false.
     */
    inline void clearBDrivingSideAvailable();

    /**
     * Checks whether the field "bDrivingSideAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDrivingSideAvailable()). Otherwise it will return false.
     */
    inline bool hasBDrivingSideAvailable () const;

    /**
     * Returns the value of the member "bDrivingSideAvailable".
     *
     * Availability of DrivingSideAvailable parameter
     *
     * @return The value of the field "bDrivingSideAvailable"
     */
    inline bool getBDrivingSideAvailable () const;

    /**
     * Sets the value of the member "bDrivingSideAvailable".
     *
     * Availability of DrivingSideAvailable parameter
     *
     * @param bDrivingSideAvailable The value which will be set
     */
    inline void setBDrivingSideAvailable (bool bDrivingSideAvailable_);

    // API of field "e8DrivingSide"

    static const int kE8DrivingSide = 17;

    /**
     * Clears the field "e8DrivingSide".
     *
     * The field will be set to its default value. The hasE8DrivingSide()
     * method will return false.
     */
    inline void clearE8DrivingSide();

    /**
     * Checks whether the field "e8DrivingSide" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DrivingSide()). Otherwise it will return false.
     */
    inline bool hasE8DrivingSide () const;

    /**
     * Returns the value of the member "e8DrivingSide".
     *
     * Whether cars should drive on right or left side of the road.For roundabout, specifies the direction of traffic around the roundabout.
     *
     * @return The value of the field "e8DrivingSide"
     */
    inline T_e8_DrivingSide getE8DrivingSide () const;

    /**
     * Sets the value of the member "e8DrivingSide".
     *
     * Whether cars should drive on right or left side of the road.For roundabout, specifies the direction of traffic around the roundabout.
     *
     * @param e8DrivingSide The value which will be set
     */
    inline void setE8DrivingSide (T_e8_DrivingSide e8DrivingSide_);

    // API of field "bJunctionTypeAvailable"

    static const int kBJunctionTypeAvailable = 18;

    /**
     * Clears the field "bJunctionTypeAvailable".
     *
     * The field will be set to its default value. The hasBJunctionTypeAvailable()
     * method will return false.
     */
    inline void clearBJunctionTypeAvailable();

    /**
     * Checks whether the field "bJunctionTypeAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBJunctionTypeAvailable()). Otherwise it will return false.
     */
    inline bool hasBJunctionTypeAvailable () const;

    /**
     * Returns the value of the member "bJunctionTypeAvailable".
     *
     * Availability of JunctionType parameter
     *
     * @return The value of the field "bJunctionTypeAvailable"
     */
    inline bool getBJunctionTypeAvailable () const;

    /**
     * Sets the value of the member "bJunctionTypeAvailable".
     *
     * Availability of JunctionType parameter
     *
     * @param bJunctionTypeAvailable The value which will be set
     */
    inline void setBJunctionTypeAvailable (bool bJunctionTypeAvailable_);

    // API of field "e8JunctionType"

    static const int kE8JunctionType = 19;

    /**
     * Clears the field "e8JunctionType".
     *
     * The field will be set to its default value. The hasE8JunctionType()
     * method will return false.
     */
    inline void clearE8JunctionType();

    /**
     * Checks whether the field "e8JunctionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8JunctionType()). Otherwise it will return false.
     */
    inline bool hasE8JunctionType () const;

    /**
     * Returns the value of the member "e8JunctionType".
     *
     * JunctionType enum.
     *
     * @return The value of the field "e8JunctionType"
     */
    inline T_e8_JunctionType getE8JunctionType () const;

    /**
     * Sets the value of the member "e8JunctionType".
     *
     * JunctionType enum.
     *
     * @param e8JunctionType The value which will be set
     */
    inline void setE8JunctionType (T_e8_JunctionType e8JunctionType_);

    // API of field "bJunctionElementAngleAvailable"

    static const int kBJunctionElementAngleAvailable = 20;

    /**
     * Clears the field "bJunctionElementAngleAvailable".
     *
     * The field will be set to its default value. The hasBJunctionElementAngleAvailable()
     * method will return false.
     */
    inline void clearBJunctionElementAngleAvailable();

    /**
     * Checks whether the field "bJunctionElementAngleAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBJunctionElementAngleAvailable()). Otherwise it will return false.
     */
    inline bool hasBJunctionElementAngleAvailable () const;

    /**
     * Returns the value of the member "bJunctionElementAngleAvailable".
     *
     * Availability of JunctionElementAngle parameter
     *
     * @return The value of the field "bJunctionElementAngleAvailable"
     */
    inline bool getBJunctionElementAngleAvailable () const;

    /**
     * Sets the value of the member "bJunctionElementAngleAvailable".
     *
     * Availability of JunctionElementAngle parameter
     *
     * @param bJunctionElementAngleAvailable The value which will be set
     */
    inline void setBJunctionElementAngleAvailable (bool bJunctionElementAngleAvailable_);

    // API of field "JunctionElementAngle"

    static const int kJunctionElementAngle = 21;

    /**
     * Clears the field "JunctionElementAngle".
     *
     * The field will be set to its default value. The hasJunctionElementAngle()
     * method will return false.
     */
    inline void clearJunctionElementAngle();

    /**
     * Checks whether the field "JunctionElementAngle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJunctionElementAngle()). Otherwise it will return false.
     */
    inline bool hasJunctionElementAngle () const;

    /**
     * Returns the value of the member "JunctionElementAngle".
     *
     * Angle of a junction element (+/- 180). Accessory must show all junction elements together. An entry junction element is implied at angle 180.
     *
     * @return The value of the field "JunctionElementAngle"
     */
    inline const T_JunctionElementAngles& getJunctionElementAngle () const;

    /**
     * Retrieves the value of the field "JunctionElementAngle" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "JunctionElementAngle".
     */
    inline T_JunctionElementAngles& getJunctionElementAngleMutable ();

    /**
     * Sets the value of the member "JunctionElementAngle".
     *
     * Angle of a junction element (+/- 180). Accessory must show all junction elements together. An entry junction element is implied at angle 180.
     *
     * @param JunctionElementAngle The value which will be set
     */
    inline void setJunctionElementAngle (const T_JunctionElementAngles& JunctionElementAngle_);

    // API of field "bJunctionElementExitAngleAvailable"

    static const int kBJunctionElementExitAngleAvailable = 22;

    /**
     * Clears the field "bJunctionElementExitAngleAvailable".
     *
     * The field will be set to its default value. The hasBJunctionElementExitAngleAvailable()
     * method will return false.
     */
    inline void clearBJunctionElementExitAngleAvailable();

    /**
     * Checks whether the field "bJunctionElementExitAngleAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBJunctionElementExitAngleAvailable()). Otherwise it will return false.
     */
    inline bool hasBJunctionElementExitAngleAvailable () const;

    /**
     * Returns the value of the member "bJunctionElementExitAngleAvailable".
     *
     * Availability of JunctionElementExitAngle parameter
     *
     * @return The value of the field "bJunctionElementExitAngleAvailable"
     */
    inline bool getBJunctionElementExitAngleAvailable () const;

    /**
     * Sets the value of the member "bJunctionElementExitAngleAvailable".
     *
     * Availability of JunctionElementExitAngle parameter
     *
     * @param bJunctionElementExitAngleAvailable The value which will be set
     */
    inline void setBJunctionElementExitAngleAvailable (bool bJunctionElementExitAngleAvailable_);

    // API of field "JunctionElementExitAngle"

    static const int kJunctionElementExitAngle = 23;

    /**
     * Clears the field "JunctionElementExitAngle".
     *
     * The field will be set to its default value. The hasJunctionElementExitAngle()
     * method will return false.
     */
    inline void clearJunctionElementExitAngle();

    /**
     * Checks whether the field "JunctionElementExitAngle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJunctionElementExitAngle()). Otherwise it will return false.
     */
    inline bool hasJunctionElementExitAngle () const;

    /**
     * Returns the value of the member "JunctionElementExitAngle".
     *
     * Angle of an exit junction element (+/- 180). Junction element describing the road used to exit the junction, or exit of the manuever. Accessory must show all
     * junction elements together.An entry junction element is implied at angle 180.
     *
     * @return The value of the field "JunctionElementExitAngle"
     */
    inline int16 getJunctionElementExitAngle () const;

    /**
     * Sets the value of the member "JunctionElementExitAngle".
     *
     * Angle of an exit junction element (+/- 180). Junction element describing the road used to exit the junction, or exit of the manuever. Accessory must show all
     * junction elements together.An entry junction element is implied at angle 180.
     *
     * @param JunctionElementExitAngle The value which will be set
     */
    inline void setJunctionElementExitAngle (int16 JunctionElementExitAngle_);

    static const T_RouteGuidanceManeuverUpdate &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    static const ::std::vector< int16 >& getInt16List_DefaultInstance ();

    inline void set_has_bRouteGuidanceDisplayComponentIDsAvailable ();

    inline void clear_has_bRouteGuidanceDisplayComponentIDsAvailable ();

    inline void set_has_RouteGuidanceDisplayComponentIDs ();

    inline void clear_has_RouteGuidanceDisplayComponentIDs ();

    inline void set_has_bIndexAvailable ();

    inline void clear_has_bIndexAvailable ();

    inline void set_has_Index ();

    inline void clear_has_Index ();

    inline void set_has_bManeuverDescriptionAvailable ();

    inline void clear_has_bManeuverDescriptionAvailable ();

    inline void set_has_ManeuverDescription ();

    inline void clear_has_ManeuverDescription ();

    inline void set_has_bManeuverTypeAvailable ();

    inline void clear_has_bManeuverTypeAvailable ();

    inline void set_has_e8ManeuverType ();

    inline void clear_has_e8ManeuverType ();

    inline void set_has_bAfterManeuverRoadNameAvailable ();

    inline void clear_has_bAfterManeuverRoadNameAvailable ();

    inline void set_has_AfterManeuverRoadName ();

    inline void clear_has_AfterManeuverRoadName ();

    inline void set_has_bDistanceBetweenManeuverAvailable ();

    inline void clear_has_bDistanceBetweenManeuverAvailable ();

    inline void set_has_DistanceBetweenManeuver ();

    inline void clear_has_DistanceBetweenManeuver ();

    inline void set_has_bDistanceBetweenManeuverDisplayStrAvailable ();

    inline void clear_has_bDistanceBetweenManeuverDisplayStrAvailable ();

    inline void set_has_DistanceBetweenManeuverDisplayStr ();

    inline void clear_has_DistanceBetweenManeuverDisplayStr ();

    inline void set_has_bDistanceBetweenManeuverDisplayUnitsAvailable ();

    inline void clear_has_bDistanceBetweenManeuverDisplayUnitsAvailable ();

    inline void set_has_e8DistanceBetweenManeuverDisplayUnits ();

    inline void clear_has_e8DistanceBetweenManeuverDisplayUnits ();

    inline void set_has_bDrivingSideAvailable ();

    inline void clear_has_bDrivingSideAvailable ();

    inline void set_has_e8DrivingSide ();

    inline void clear_has_e8DrivingSide ();

    inline void set_has_bJunctionTypeAvailable ();

    inline void clear_has_bJunctionTypeAvailable ();

    inline void set_has_e8JunctionType ();

    inline void clear_has_e8JunctionType ();

    inline void set_has_bJunctionElementAngleAvailable ();

    inline void clear_has_bJunctionElementAngleAvailable ();

    inline void set_has_JunctionElementAngle ();

    inline void clear_has_JunctionElementAngle ();

    inline void set_has_bJunctionElementExitAngleAvailable ();

    inline void clear_has_bJunctionElementExitAngleAvailable ();

    inline void set_has_JunctionElementExitAngle ();

    inline void clear_has_JunctionElementExitAngle ();

    uint32 _has_bits_[ (24 + 31) / 32];

    bool _bRouteGuidanceDisplayComponentIDsAvailable;

    T_RouteGuidanceDisplayComponentIDs _RouteGuidanceDisplayComponentIDs;

    bool _bIndexAvailable;

    uint16 _Index;

    bool _bManeuverDescriptionAvailable;

    ::std::string _ManeuverDescription;

    bool _bManeuverTypeAvailable;

    T_e8_ManeuverType _e8ManeuverType;

    bool _bAfterManeuverRoadNameAvailable;

    ::std::string _AfterManeuverRoadName;

    bool _bDistanceBetweenManeuverAvailable;

    uint32 _DistanceBetweenManeuver;

    bool _bDistanceBetweenManeuverDisplayStrAvailable;

    ::std::string _DistanceBetweenManeuverDisplayStr;

    bool _bDistanceBetweenManeuverDisplayUnitsAvailable;

    T_e8_DistanceDisplayUnits _e8DistanceBetweenManeuverDisplayUnits;

    bool _bDrivingSideAvailable;

    T_e8_DrivingSide _e8DrivingSide;

    bool _bJunctionTypeAvailable;

    T_e8_JunctionType _e8JunctionType;

    bool _bJunctionElementAngleAvailable;

    T_JunctionElementAngles _JunctionElementAngle;

    bool _bJunctionElementExitAngleAvailable;

    int16 _JunctionElementExitAngle;

};

/**
 * Bitfield for the Call control configuration flags
 */
class T_CallControlsConfiguration {
public:

    /**
     * Default constructor
     */
    inline  T_CallControlsConfiguration ();

    /**
     * Copy constructor
     */
    inline  T_CallControlsConfiguration (const T_CallControlsConfiguration &c);

    /**
     * Field constructor
     */
    inline  T_CallControlsConfiguration (bool InitiateCall, bool AcceptCall, bool EndCall, bool SwapCalls, bool MergeCalls, bool HoldStatusUpdate, bool MuteStatusUpdate, bool SendDTMF);

    /**
     * Assignment operator
     */
    inline T_CallControlsConfiguration& operator = (const T_CallControlsConfiguration& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CallControlsConfiguration& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CallControlsConfiguration& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CallControlsConfiguration& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CallControlsConfiguration& rhs) const;

    /**
     * Sets the value of the member "InitiateCall".
     *
     * If the meaning of "InitiateCall" isn't clear, then there should be a description here.
     *
     * @param InitiateCall The value which will be set
     */
    inline void setInitiateCall (bool InitiateCall);

    /**
     * Returns the value of the member "InitiateCall".
     *
     * If the meaning of "InitiateCall" isn't clear, then there should be a description here.
     *
     * @return The value of the field "InitiateCall"
     */
    inline bool getInitiateCall () const;

    /**
     * Sets the value of the member "AcceptCall".
     *
     * If the meaning of "AcceptCall" isn't clear, then there should be a description here.
     *
     * @param AcceptCall The value which will be set
     */
    inline void setAcceptCall (bool AcceptCall);

    /**
     * Returns the value of the member "AcceptCall".
     *
     * If the meaning of "AcceptCall" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AcceptCall"
     */
    inline bool getAcceptCall () const;

    /**
     * Sets the value of the member "EndCall".
     *
     * If the meaning of "EndCall" isn't clear, then there should be a description here.
     *
     * @param EndCall The value which will be set
     */
    inline void setEndCall (bool EndCall);

    /**
     * Returns the value of the member "EndCall".
     *
     * If the meaning of "EndCall" isn't clear, then there should be a description here.
     *
     * @return The value of the field "EndCall"
     */
    inline bool getEndCall () const;

    /**
     * Sets the value of the member "SwapCalls".
     *
     * If the meaning of "SwapCalls" isn't clear, then there should be a description here.
     *
     * @param SwapCalls The value which will be set
     */
    inline void setSwapCalls (bool SwapCalls);

    /**
     * Returns the value of the member "SwapCalls".
     *
     * If the meaning of "SwapCalls" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SwapCalls"
     */
    inline bool getSwapCalls () const;

    /**
     * Sets the value of the member "MergeCalls".
     *
     * If the meaning of "MergeCalls" isn't clear, then there should be a description here.
     *
     * @param MergeCalls The value which will be set
     */
    inline void setMergeCalls (bool MergeCalls);

    /**
     * Returns the value of the member "MergeCalls".
     *
     * If the meaning of "MergeCalls" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MergeCalls"
     */
    inline bool getMergeCalls () const;

    /**
     * Sets the value of the member "HoldStatusUpdate".
     *
     * If the meaning of "HoldStatusUpdate" isn't clear, then there should be a description here.
     *
     * @param HoldStatusUpdate The value which will be set
     */
    inline void setHoldStatusUpdate (bool HoldStatusUpdate);

    /**
     * Returns the value of the member "HoldStatusUpdate".
     *
     * If the meaning of "HoldStatusUpdate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "HoldStatusUpdate"
     */
    inline bool getHoldStatusUpdate () const;

    /**
     * Sets the value of the member "MuteStatusUpdate".
     *
     * If the meaning of "MuteStatusUpdate" isn't clear, then there should be a description here.
     *
     * @param MuteStatusUpdate The value which will be set
     */
    inline void setMuteStatusUpdate (bool MuteStatusUpdate);

    /**
     * Returns the value of the member "MuteStatusUpdate".
     *
     * If the meaning of "MuteStatusUpdate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MuteStatusUpdate"
     */
    inline bool getMuteStatusUpdate () const;

    /**
     * Sets the value of the member "SendDTMF".
     *
     * If the meaning of "SendDTMF" isn't clear, then there should be a description here.
     *
     * @param SendDTMF The value which will be set
     */
    inline void setSendDTMF (bool SendDTMF);

    /**
     * Returns the value of the member "SendDTMF".
     *
     * If the meaning of "SendDTMF" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SendDTMF"
     */
    inline bool getSendDTMF () const;

    static const T_CallControlsConfiguration &getDefaultInstance();

private:

    bool _InitiateCall:1;

    bool _AcceptCall:1;

    bool _EndCall:1;

    bool _SwapCalls:1;

    bool _MergeCalls:1;

    bool _HoldStatusUpdate:1;

    bool _MuteStatusUpdate:1;

    bool _SendDTMF:1;

};

class T_AppInfo {
public:

    /**
     * Default constructor
     */
    inline  T_AppInfo ();

    /**
     * Copy constructor
     */
    inline  T_AppInfo (const T_AppInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_AppInfo (const ::std::string& sAppName_, const ::std::string& sProtocol_, const ::std::string& sBundleID_);

    /**
     * Destructor
     */
    inline  ~T_AppInfo();

    /**
     * Assignment operator
     */
    inline T_AppInfo& operator = (const T_AppInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AppInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AppInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AppInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AppInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sAppName"

    static const int kSAppName = 0;

    /**
     * Clears the field "sAppName".
     *
     * The field will be set to its default value. The hasSAppName()
     * method will return false.
     */
    inline void clearSAppName();

    /**
     * Checks whether the field "sAppName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAppName()). Otherwise it will return false.
     */
    inline bool hasSAppName () const;

    /**
     * Returns the value of the member "sAppName".
     *
     * App Name
     *
     * @return The value of the field "sAppName"
     */
    inline const ::std::string& getSAppName () const;

    /**
     * Retrieves the value of the field "sAppName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAppName".
     */
    inline ::std::string& getSAppNameMutable ();

    /**
     * Sets the value of the member "sAppName".
     *
     * App Name
     *
     * @param sAppName The value which will be set
     */
    inline void setSAppName (const ::std::string& sAppName_);

    /**
     * Sets the value of the member "sAppName".
     *
     * App Name
     *
     * @param sAppName The value which will be set
     */
    inline void setSAppName (const char* sAppName_);

    /**
     * Sets the value of the member "sAppName".
     *
     * App Name
     *
     * @param sAppName The value which will be set
     */
    inline void setSAppName (const char* value, size_t size);

    // API of field "sProtocol"

    static const int kSProtocol = 1;

    /**
     * Clears the field "sProtocol".
     *
     * The field will be set to its default value. The hasSProtocol()
     * method will return false.
     */
    inline void clearSProtocol();

    /**
     * Checks whether the field "sProtocol" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSProtocol()). Otherwise it will return false.
     */
    inline bool hasSProtocol () const;

    /**
     * Returns the value of the member "sProtocol".
     *
     * App Protocol Name
     *
     * @return The value of the field "sProtocol"
     */
    inline const ::std::string& getSProtocol () const;

    /**
     * Retrieves the value of the field "sProtocol" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sProtocol".
     */
    inline ::std::string& getSProtocolMutable ();

    /**
     * Sets the value of the member "sProtocol".
     *
     * App Protocol Name
     *
     * @param sProtocol The value which will be set
     */
    inline void setSProtocol (const ::std::string& sProtocol_);

    /**
     * Sets the value of the member "sProtocol".
     *
     * App Protocol Name
     *
     * @param sProtocol The value which will be set
     */
    inline void setSProtocol (const char* sProtocol_);

    /**
     * Sets the value of the member "sProtocol".
     *
     * App Protocol Name
     *
     * @param sProtocol The value which will be set
     */
    inline void setSProtocol (const char* value, size_t size);

    // API of field "sBundleID"

    static const int kSBundleID = 2;

    /**
     * Clears the field "sBundleID".
     *
     * The field will be set to its default value. The hasSBundleID()
     * method will return false.
     */
    inline void clearSBundleID();

    /**
     * Checks whether the field "sBundleID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBundleID()). Otherwise it will return false.
     */
    inline bool hasSBundleID () const;

    /**
     * Returns the value of the member "sBundleID".
     *
     * App Bundle ID.
     *
     * @return The value of the field "sBundleID"
     */
    inline const ::std::string& getSBundleID () const;

    /**
     * Retrieves the value of the field "sBundleID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBundleID".
     */
    inline ::std::string& getSBundleIDMutable ();

    /**
     * Sets the value of the member "sBundleID".
     *
     * App Bundle ID.
     *
     * @param sBundleID The value which will be set
     */
    inline void setSBundleID (const ::std::string& sBundleID_);

    /**
     * Sets the value of the member "sBundleID".
     *
     * App Bundle ID.
     *
     * @param sBundleID The value which will be set
     */
    inline void setSBundleID (const char* sBundleID_);

    /**
     * Sets the value of the member "sBundleID".
     *
     * App Bundle ID.
     *
     * @param sBundleID The value which will be set
     */
    inline void setSBundleID (const char* value, size_t size);

    static const T_AppInfo &getDefaultInstance();

private:

    inline void set_has_sAppName ();

    inline void clear_has_sAppName ();

    inline void set_has_sProtocol ();

    inline void clear_has_sProtocol ();

    inline void set_has_sBundleID ();

    inline void clear_has_sBundleID ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _sAppName;

    ::std::string _sProtocol;

    ::std::string _sBundleID;

};

/**
 * If the meaning of "T_DeviceTimeUpdate" isn't clear, then there should be a description here.
 */
class T_DeviceTimeUpdate {
public:

    /**
     * Default constructor
     */
    inline  T_DeviceTimeUpdate ();

    /**
     * Copy constructor
     */
    inline  T_DeviceTimeUpdate (const T_DeviceTimeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  T_DeviceTimeUpdate (uint64 u64SecondsSinceReferenceDate_, int16 s16TimeZoneOffsetMinutes_, int8 s8DaylightSavingsOffsetMinutes_);

    /**
     * Destructor
     */
    inline  ~T_DeviceTimeUpdate();

    /**
     * Assignment operator
     */
    inline T_DeviceTimeUpdate& operator = (const T_DeviceTimeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DeviceTimeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DeviceTimeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DeviceTimeUpdate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DeviceTimeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u64SecondsSinceReferenceDate"

    static const int kU64SecondsSinceReferenceDate = 0;

    /**
     * Clears the field "u64SecondsSinceReferenceDate".
     *
     * The field will be set to its default value. The hasU64SecondsSinceReferenceDate()
     * method will return false.
     */
    inline void clearU64SecondsSinceReferenceDate();

    /**
     * Checks whether the field "u64SecondsSinceReferenceDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU64SecondsSinceReferenceDate()). Otherwise it will return false.
     */
    inline bool hasU64SecondsSinceReferenceDate () const;

    /**
     * Returns the value of the member "u64SecondsSinceReferenceDate".
     *
     * Time interval in seconds since reference date (Jan 1, 1970, GMT)
     *
     * @return The value of the field "u64SecondsSinceReferenceDate"
     */
    inline uint64 getU64SecondsSinceReferenceDate () const;

    /**
     * Sets the value of the member "u64SecondsSinceReferenceDate".
     *
     * Time interval in seconds since reference date (Jan 1, 1970, GMT)
     *
     * @param u64SecondsSinceReferenceDate The value which will be set
     */
    inline void setU64SecondsSinceReferenceDate (uint64 u64SecondsSinceReferenceDate_);

    // API of field "s16TimeZoneOffsetMinutes"

    static const int kS16TimeZoneOffsetMinutes = 1;

    /**
     * Clears the field "s16TimeZoneOffsetMinutes".
     *
     * The field will be set to its default value. The hasS16TimeZoneOffsetMinutes()
     * method will return false.
     */
    inline void clearS16TimeZoneOffsetMinutes();

    /**
     * Checks whether the field "s16TimeZoneOffsetMinutes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16TimeZoneOffsetMinutes()). Otherwise it will return false.
     */
    inline bool hasS16TimeZoneOffsetMinutes () const;

    /**
     * Returns the value of the member "s16TimeZoneOffsetMinutes".
     *
     * Difference in minutes between device time zone and GMT.
     *
     * @return The value of the field "s16TimeZoneOffsetMinutes"
     */
    inline int16 getS16TimeZoneOffsetMinutes () const;

    /**
     * Sets the value of the member "s16TimeZoneOffsetMinutes".
     *
     * Difference in minutes between device time zone and GMT.
     *
     * @param s16TimeZoneOffsetMinutes The value which will be set
     */
    inline void setS16TimeZoneOffsetMinutes (int16 s16TimeZoneOffsetMinutes_);

    // API of field "s8DaylightSavingsOffsetMinutes"

    static const int kS8DaylightSavingsOffsetMinutes = 2;

    /**
     * Clears the field "s8DaylightSavingsOffsetMinutes".
     *
     * The field will be set to its default value. The hasS8DaylightSavingsOffsetMinutes()
     * method will return false.
     */
    inline void clearS8DaylightSavingsOffsetMinutes();

    /**
     * Checks whether the field "s8DaylightSavingsOffsetMinutes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8DaylightSavingsOffsetMinutes()). Otherwise it will return false.
     */
    inline bool hasS8DaylightSavingsOffsetMinutes () const;

    /**
     * Returns the value of the member "s8DaylightSavingsOffsetMinutes".
     *
     * Daylight savings time offset in minutes.
     *
     * @return The value of the field "s8DaylightSavingsOffsetMinutes"
     */
    inline int8 getS8DaylightSavingsOffsetMinutes () const;

    /**
     * Sets the value of the member "s8DaylightSavingsOffsetMinutes".
     *
     * Daylight savings time offset in minutes.
     *
     * @param s8DaylightSavingsOffsetMinutes The value which will be set
     */
    inline void setS8DaylightSavingsOffsetMinutes (int8 s8DaylightSavingsOffsetMinutes_);

    static const T_DeviceTimeUpdate &getDefaultInstance();

private:

    inline void set_has_u64SecondsSinceReferenceDate ();

    inline void clear_has_u64SecondsSinceReferenceDate ();

    inline void set_has_s16TimeZoneOffsetMinutes ();

    inline void clear_has_s16TimeZoneOffsetMinutes ();

    inline void set_has_s8DaylightSavingsOffsetMinutes ();

    inline void clear_has_s8DaylightSavingsOffsetMinutes ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint64 _u64SecondsSinceReferenceDate;

    int16 _s16TimeZoneOffsetMinutes;

    int8 _s8DaylightSavingsOffsetMinutes;

};

inline  T_DiPODeviceInfoItem::T_DiPODeviceInfoItem ()  :
    _u8DeviceTag (0u),
    _sDeviceName (),
    _e8DeviceType (::mplay_appcontrol_fi_types::T_e8_DiPODeviceType__e8DTY_UNKNOWN),
    _sDeviceSerialNumber (),
    _bDeviceConnected (false),
    _bDeviceActiveSource (false),
    _bDiPOCapable (false),
    _bDiPOActive (false),
    _sDiPOVersion (),
    _e8ConnectionType (::mplay_appcontrol_fi_types::T_e8_DiPOConnectionType__e8DCT_UNKNOWN),
    _e8ConnectionState (::mplay_appcontrol_fi_types::T_e8_DiPOConnectionState__e8CS_CONNECTED),
    _sMountPoint (),
    _sAccessoryName (),
    _e8DiPOCaps (::mplay_appcontrol_fi_types::T_e8_DiPOCaps__e8DIPO_CAP_NONE),
    _e8DeviceState (::mplay_appcontrol_fi_types::T_e8_DiPODeviceStatus__e8DS_NONE),
    _sDeviceUUID (),
    _sDeviceBTMacAddress (),
    _sDeviceUSBSerialNumber ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DiPODeviceInfoItem::T_DiPODeviceInfoItem (const T_DiPODeviceInfoItem &rhs)  :
    _u8DeviceTag (0u),
    _sDeviceName (),
    _e8DeviceType (::mplay_appcontrol_fi_types::T_e8_DiPODeviceType__e8DTY_UNKNOWN),
    _sDeviceSerialNumber (),
    _bDeviceConnected (false),
    _bDeviceActiveSource (false),
    _bDiPOCapable (false),
    _bDiPOActive (false),
    _sDiPOVersion (),
    _e8ConnectionType (::mplay_appcontrol_fi_types::T_e8_DiPOConnectionType__e8DCT_UNKNOWN),
    _e8ConnectionState (::mplay_appcontrol_fi_types::T_e8_DiPOConnectionState__e8CS_CONNECTED),
    _sMountPoint (),
    _sAccessoryName (),
    _e8DiPOCaps (::mplay_appcontrol_fi_types::T_e8_DiPOCaps__e8DIPO_CAP_NONE),
    _e8DeviceState (::mplay_appcontrol_fi_types::T_e8_DiPODeviceStatus__e8DS_NONE),
    _sDeviceUUID (),
    _sDeviceBTMacAddress (),
    _sDeviceUSBSerialNumber ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DiPODeviceInfoItem::T_DiPODeviceInfoItem (uint8 u8DeviceTag_, const ::std::string& sDeviceName_, T_e8_DiPODeviceType e8DeviceType_, const ::std::string& sDeviceSerialNumber_, bool bDeviceConnected_, bool bDeviceActiveSource_, bool bDiPOCapable_, bool bDiPOActive_, const ::std::string& sDiPOVersion_, T_e8_DiPOConnectionType e8ConnectionType_, T_e8_DiPOConnectionState e8ConnectionState_, const ::std::string& sMountPoint_, const ::std::string& sAccessoryName_, T_e8_DiPOCaps e8DiPOCaps_, T_e8_DiPODeviceStatus e8DeviceState_, const ::std::string& sDeviceUUID_, const ::std::string& sDeviceBTMacAddress_, const ::std::string& sDeviceUSBSerialNumber_)  :
    _u8DeviceTag (u8DeviceTag_),
    _sDeviceName (sDeviceName_),
    _e8DeviceType (e8DeviceType_),
    _sDeviceSerialNumber (sDeviceSerialNumber_),
    _bDeviceConnected (bDeviceConnected_),
    _bDeviceActiveSource (bDeviceActiveSource_),
    _bDiPOCapable (bDiPOCapable_),
    _bDiPOActive (bDiPOActive_),
    _sDiPOVersion (sDiPOVersion_),
    _e8ConnectionType (e8ConnectionType_),
    _e8ConnectionState (e8ConnectionState_),
    _sMountPoint (sMountPoint_),
    _sAccessoryName (sAccessoryName_),
    _e8DiPOCaps (e8DiPOCaps_),
    _e8DeviceState (e8DeviceState_),
    _sDeviceUUID (sDeviceUUID_),
    _sDeviceBTMacAddress (sDeviceBTMacAddress_),
    _sDeviceUSBSerialNumber (sDeviceUSBSerialNumber_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_DiPODeviceType_IsValid(e8DeviceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceType_, "T_e8_DiPODeviceType", "e8DeviceType", "T_DiPODeviceInfoItem");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDiPOVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_DiPOConnectionType_IsValid(e8ConnectionType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ConnectionType_, "T_e8_DiPOConnectionType", "e8ConnectionType", "T_DiPODeviceInfoItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_DiPOConnectionState_IsValid(e8ConnectionState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ConnectionState_, "T_e8_DiPOConnectionState", "e8ConnectionState", "T_DiPODeviceInfoItem");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMountPoint_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAccessoryName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_DiPOCaps_IsValid(e8DiPOCaps_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DiPOCaps_, "T_e8_DiPOCaps", "e8DiPOCaps", "T_DiPODeviceInfoItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_DiPODeviceStatus_IsValid(e8DeviceState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceState_, "T_e8_DiPODeviceStatus", "e8DeviceState", "T_DiPODeviceInfoItem");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUUID_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceBTMacAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DiPODeviceInfoItem::~T_DiPODeviceInfoItem() {
}

inline T_DiPODeviceInfoItem& T_DiPODeviceInfoItem::operator = (const T_DiPODeviceInfoItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8DeviceTag()) {
            setU8DeviceTag(rhs.getU8DeviceTag());
        } else {
            clearU8DeviceTag();
        }
        if (rhs.hasSDeviceName()) {
            setSDeviceName(rhs.getSDeviceName());
        } else {
            clearSDeviceName();
        }
        if (rhs.hasE8DeviceType()) {
            setE8DeviceType(rhs.getE8DeviceType());
        } else {
            clearE8DeviceType();
        }
        if (rhs.hasSDeviceSerialNumber()) {
            setSDeviceSerialNumber(rhs.getSDeviceSerialNumber());
        } else {
            clearSDeviceSerialNumber();
        }
        if (rhs.hasBDeviceConnected()) {
            setBDeviceConnected(rhs.getBDeviceConnected());
        } else {
            clearBDeviceConnected();
        }
        if (rhs.hasBDeviceActiveSource()) {
            setBDeviceActiveSource(rhs.getBDeviceActiveSource());
        } else {
            clearBDeviceActiveSource();
        }
        if (rhs.hasBDiPOCapable()) {
            setBDiPOCapable(rhs.getBDiPOCapable());
        } else {
            clearBDiPOCapable();
        }
        if (rhs.hasBDiPOActive()) {
            setBDiPOActive(rhs.getBDiPOActive());
        } else {
            clearBDiPOActive();
        }
        if (rhs.hasSDiPOVersion()) {
            setSDiPOVersion(rhs.getSDiPOVersion());
        } else {
            clearSDiPOVersion();
        }
        if (rhs.hasE8ConnectionType()) {
            setE8ConnectionType(rhs.getE8ConnectionType());
        } else {
            clearE8ConnectionType();
        }
        if (rhs.hasE8ConnectionState()) {
            setE8ConnectionState(rhs.getE8ConnectionState());
        } else {
            clearE8ConnectionState();
        }
        if (rhs.hasSMountPoint()) {
            setSMountPoint(rhs.getSMountPoint());
        } else {
            clearSMountPoint();
        }
        if (rhs.hasSAccessoryName()) {
            setSAccessoryName(rhs.getSAccessoryName());
        } else {
            clearSAccessoryName();
        }
        if (rhs.hasE8DiPOCaps()) {
            setE8DiPOCaps(rhs.getE8DiPOCaps());
        } else {
            clearE8DiPOCaps();
        }
        if (rhs.hasE8DeviceState()) {
            setE8DeviceState(rhs.getE8DeviceState());
        } else {
            clearE8DeviceState();
        }
        if (rhs.hasSDeviceUUID()) {
            setSDeviceUUID(rhs.getSDeviceUUID());
        } else {
            clearSDeviceUUID();
        }
        if (rhs.hasSDeviceBTMacAddress()) {
            setSDeviceBTMacAddress(rhs.getSDeviceBTMacAddress());
        } else {
            clearSDeviceBTMacAddress();
        }
        if (rhs.hasSDeviceUSBSerialNumber()) {
            setSDeviceUSBSerialNumber(rhs.getSDeviceUSBSerialNumber());
        } else {
            clearSDeviceUSBSerialNumber();
        }
    }
    return *this;
}

inline bool T_DiPODeviceInfoItem::operator == (const T_DiPODeviceInfoItem& rhs) const {
    return (((!hasU8DeviceTag() && !rhs.hasU8DeviceTag()) || getU8DeviceTag() == rhs.getU8DeviceTag()) &&
        ((!hasSDeviceName() && !rhs.hasSDeviceName()) || getSDeviceName() == rhs.getSDeviceName()) &&
        ((!hasE8DeviceType() && !rhs.hasE8DeviceType()) || getE8DeviceType() == rhs.getE8DeviceType()) &&
        ((!hasSDeviceSerialNumber() && !rhs.hasSDeviceSerialNumber()) || getSDeviceSerialNumber() == rhs.getSDeviceSerialNumber()) &&
        ((!hasBDeviceConnected() && !rhs.hasBDeviceConnected()) || getBDeviceConnected() == rhs.getBDeviceConnected()) &&
        ((!hasBDeviceActiveSource() && !rhs.hasBDeviceActiveSource()) || getBDeviceActiveSource() == rhs.getBDeviceActiveSource()) &&
        ((!hasBDiPOCapable() && !rhs.hasBDiPOCapable()) || getBDiPOCapable() == rhs.getBDiPOCapable()) &&
        ((!hasBDiPOActive() && !rhs.hasBDiPOActive()) || getBDiPOActive() == rhs.getBDiPOActive()) &&
        ((!hasSDiPOVersion() && !rhs.hasSDiPOVersion()) || getSDiPOVersion() == rhs.getSDiPOVersion()) &&
        ((!hasE8ConnectionType() && !rhs.hasE8ConnectionType()) || getE8ConnectionType() == rhs.getE8ConnectionType()) &&
        ((!hasE8ConnectionState() && !rhs.hasE8ConnectionState()) || getE8ConnectionState() == rhs.getE8ConnectionState()) &&
        ((!hasSMountPoint() && !rhs.hasSMountPoint()) || getSMountPoint() == rhs.getSMountPoint()) &&
        ((!hasSAccessoryName() && !rhs.hasSAccessoryName()) || getSAccessoryName() == rhs.getSAccessoryName()) &&
        ((!hasE8DiPOCaps() && !rhs.hasE8DiPOCaps()) || getE8DiPOCaps() == rhs.getE8DiPOCaps()) &&
        ((!hasE8DeviceState() && !rhs.hasE8DeviceState()) || getE8DeviceState() == rhs.getE8DeviceState()) &&
        ((!hasSDeviceUUID() && !rhs.hasSDeviceUUID()) || getSDeviceUUID() == rhs.getSDeviceUUID()) &&
        ((!hasSDeviceBTMacAddress() && !rhs.hasSDeviceBTMacAddress()) || getSDeviceBTMacAddress() == rhs.getSDeviceBTMacAddress()) &&
        ((!hasSDeviceUSBSerialNumber() && !rhs.hasSDeviceUSBSerialNumber()) || getSDeviceUSBSerialNumber() == rhs.getSDeviceUSBSerialNumber()));
}

inline bool T_DiPODeviceInfoItem::operator != (const T_DiPODeviceInfoItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DiPODeviceInfoItem::operator < (const T_DiPODeviceInfoItem& rhs) const {
    if (hasU8DeviceTag() || rhs.hasU8DeviceTag()) {
        if (getU8DeviceTag() < rhs.getU8DeviceTag()) return true;
        if (getU8DeviceTag() > rhs.getU8DeviceTag()) return false;
    }
    if (hasSDeviceName() || rhs.hasSDeviceName()) {
        if (getSDeviceName() < rhs.getSDeviceName()) return true;
        if (getSDeviceName() > rhs.getSDeviceName()) return false;
    }
    if (hasE8DeviceType() || rhs.hasE8DeviceType()) {
        if ((uint32)getE8DeviceType() < (uint32)rhs.getE8DeviceType()) return true;
        if ((uint32)getE8DeviceType() > (uint32)rhs.getE8DeviceType()) return false;
    }
    if (hasSDeviceSerialNumber() || rhs.hasSDeviceSerialNumber()) {
        if (getSDeviceSerialNumber() < rhs.getSDeviceSerialNumber()) return true;
        if (getSDeviceSerialNumber() > rhs.getSDeviceSerialNumber()) return false;
    }
    if (hasBDeviceConnected() || rhs.hasBDeviceConnected()) {
        if (getBDeviceConnected() < rhs.getBDeviceConnected()) return true;
        if (getBDeviceConnected() > rhs.getBDeviceConnected()) return false;
    }
    if (hasBDeviceActiveSource() || rhs.hasBDeviceActiveSource()) {
        if (getBDeviceActiveSource() < rhs.getBDeviceActiveSource()) return true;
        if (getBDeviceActiveSource() > rhs.getBDeviceActiveSource()) return false;
    }
    if (hasBDiPOCapable() || rhs.hasBDiPOCapable()) {
        if (getBDiPOCapable() < rhs.getBDiPOCapable()) return true;
        if (getBDiPOCapable() > rhs.getBDiPOCapable()) return false;
    }
    if (hasBDiPOActive() || rhs.hasBDiPOActive()) {
        if (getBDiPOActive() < rhs.getBDiPOActive()) return true;
        if (getBDiPOActive() > rhs.getBDiPOActive()) return false;
    }
    if (hasSDiPOVersion() || rhs.hasSDiPOVersion()) {
        if (getSDiPOVersion() < rhs.getSDiPOVersion()) return true;
        if (getSDiPOVersion() > rhs.getSDiPOVersion()) return false;
    }
    if (hasE8ConnectionType() || rhs.hasE8ConnectionType()) {
        if ((uint32)getE8ConnectionType() < (uint32)rhs.getE8ConnectionType()) return true;
        if ((uint32)getE8ConnectionType() > (uint32)rhs.getE8ConnectionType()) return false;
    }
    if (hasE8ConnectionState() || rhs.hasE8ConnectionState()) {
        if ((uint32)getE8ConnectionState() < (uint32)rhs.getE8ConnectionState()) return true;
        if ((uint32)getE8ConnectionState() > (uint32)rhs.getE8ConnectionState()) return false;
    }
    if (hasSMountPoint() || rhs.hasSMountPoint()) {
        if (getSMountPoint() < rhs.getSMountPoint()) return true;
        if (getSMountPoint() > rhs.getSMountPoint()) return false;
    }
    if (hasSAccessoryName() || rhs.hasSAccessoryName()) {
        if (getSAccessoryName() < rhs.getSAccessoryName()) return true;
        if (getSAccessoryName() > rhs.getSAccessoryName()) return false;
    }
    if (hasE8DiPOCaps() || rhs.hasE8DiPOCaps()) {
        if ((uint32)getE8DiPOCaps() < (uint32)rhs.getE8DiPOCaps()) return true;
        if ((uint32)getE8DiPOCaps() > (uint32)rhs.getE8DiPOCaps()) return false;
    }
    if (hasE8DeviceState() || rhs.hasE8DeviceState()) {
        if ((uint32)getE8DeviceState() < (uint32)rhs.getE8DeviceState()) return true;
        if ((uint32)getE8DeviceState() > (uint32)rhs.getE8DeviceState()) return false;
    }
    if (hasSDeviceUUID() || rhs.hasSDeviceUUID()) {
        if (getSDeviceUUID() < rhs.getSDeviceUUID()) return true;
        if (getSDeviceUUID() > rhs.getSDeviceUUID()) return false;
    }
    if (hasSDeviceBTMacAddress() || rhs.hasSDeviceBTMacAddress()) {
        if (getSDeviceBTMacAddress() < rhs.getSDeviceBTMacAddress()) return true;
        if (getSDeviceBTMacAddress() > rhs.getSDeviceBTMacAddress()) return false;
    }
    if (hasSDeviceUSBSerialNumber() || rhs.hasSDeviceUSBSerialNumber()) {
        if (getSDeviceUSBSerialNumber() < rhs.getSDeviceUSBSerialNumber()) return true;
        if (getSDeviceUSBSerialNumber() > rhs.getSDeviceUSBSerialNumber()) return false;
    }
    return false;
}

inline bool T_DiPODeviceInfoItem::operator > (const T_DiPODeviceInfoItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DiPODeviceInfoItem::clear() {
    clearU8DeviceTag();
    clearSDeviceName();
    clearE8DeviceType();
    clearSDeviceSerialNumber();
    clearBDeviceConnected();
    clearBDeviceActiveSource();
    clearBDiPOCapable();
    clearBDiPOActive();
    clearSDiPOVersion();
    clearE8ConnectionType();
    clearE8ConnectionState();
    clearSMountPoint();
    clearSAccessoryName();
    clearE8DiPOCaps();
    clearE8DeviceState();
    clearSDeviceUUID();
    clearSDeviceBTMacAddress();
    clearSDeviceUSBSerialNumber();
}

inline void T_DiPODeviceInfoItem::clearU8DeviceTag() {
    if (hasU8DeviceTag()) {
         clear_has_u8DeviceTag();
        _u8DeviceTag = 0u;
     }
}

inline bool T_DiPODeviceInfoItem::hasU8DeviceTag () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_DiPODeviceInfoItem::getU8DeviceTag () const {
    return _u8DeviceTag;
}

inline void T_DiPODeviceInfoItem::setU8DeviceTag (uint8 u8DeviceTag_) {
    set_has_u8DeviceTag();
    this->_u8DeviceTag = u8DeviceTag_;
}

inline void T_DiPODeviceInfoItem::clearSDeviceName() {
    if (hasSDeviceName()) {
         clear_has_sDeviceName();
        _sDeviceName.clear();
     }
}

inline bool T_DiPODeviceInfoItem::hasSDeviceName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_DiPODeviceInfoItem::getSDeviceName () const {
    return _sDeviceName;
}

inline ::std::string& T_DiPODeviceInfoItem::getSDeviceNameMutable () {
    set_has_sDeviceName();
    return _sDeviceName;
}

inline void T_DiPODeviceInfoItem::setSDeviceName (const ::std::string& sDeviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceName();
    this->_sDeviceName = sDeviceName_;
}

inline void T_DiPODeviceInfoItem::setSDeviceName (const char* sDeviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceName();
    this->_sDeviceName.assign(sDeviceName_);
}

inline void T_DiPODeviceInfoItem::setSDeviceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceName();
    this->_sDeviceName.assign(value, size);
}

inline void T_DiPODeviceInfoItem::clearE8DeviceType() {
    if (hasE8DeviceType()) {
         clear_has_e8DeviceType();
        _e8DeviceType = ::mplay_appcontrol_fi_types::T_e8_DiPODeviceType__e8DTY_UNKNOWN;
     }
}

inline bool T_DiPODeviceInfoItem::hasE8DeviceType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_DiPODeviceType T_DiPODeviceInfoItem::getE8DeviceType () const {
    return _e8DeviceType;
}

inline void T_DiPODeviceInfoItem::setE8DeviceType (T_e8_DiPODeviceType e8DeviceType_) {
    #ifndef NDEBUG
    if (!(T_e8_DiPODeviceType_IsValid(e8DeviceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceType_, "T_e8_DiPODeviceType", "e8DeviceType", "T_DiPODeviceInfoItem");
    }
    #endif
    set_has_e8DeviceType();
    this->_e8DeviceType = e8DeviceType_;
}

inline void T_DiPODeviceInfoItem::clearSDeviceSerialNumber() {
    if (hasSDeviceSerialNumber()) {
         clear_has_sDeviceSerialNumber();
        _sDeviceSerialNumber.clear();
     }
}

inline bool T_DiPODeviceInfoItem::hasSDeviceSerialNumber () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_DiPODeviceInfoItem::getSDeviceSerialNumber () const {
    return _sDeviceSerialNumber;
}

inline ::std::string& T_DiPODeviceInfoItem::getSDeviceSerialNumberMutable () {
    set_has_sDeviceSerialNumber();
    return _sDeviceSerialNumber;
}

inline void T_DiPODeviceInfoItem::setSDeviceSerialNumber (const ::std::string& sDeviceSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceSerialNumber();
    this->_sDeviceSerialNumber = sDeviceSerialNumber_;
}

inline void T_DiPODeviceInfoItem::setSDeviceSerialNumber (const char* sDeviceSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceSerialNumber();
    this->_sDeviceSerialNumber.assign(sDeviceSerialNumber_);
}

inline void T_DiPODeviceInfoItem::setSDeviceSerialNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceSerialNumber();
    this->_sDeviceSerialNumber.assign(value, size);
}

inline void T_DiPODeviceInfoItem::clearBDeviceConnected() {
    if (hasBDeviceConnected()) {
         clear_has_bDeviceConnected();
        _bDeviceConnected = false;
     }
}

inline bool T_DiPODeviceInfoItem::hasBDeviceConnected () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool T_DiPODeviceInfoItem::getBDeviceConnected () const {
    return _bDeviceConnected;
}

inline void T_DiPODeviceInfoItem::setBDeviceConnected (bool bDeviceConnected_) {
    set_has_bDeviceConnected();
    this->_bDeviceConnected = bDeviceConnected_;
}

inline void T_DiPODeviceInfoItem::clearBDeviceActiveSource() {
    if (hasBDeviceActiveSource()) {
         clear_has_bDeviceActiveSource();
        _bDeviceActiveSource = false;
     }
}

inline bool T_DiPODeviceInfoItem::hasBDeviceActiveSource () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline bool T_DiPODeviceInfoItem::getBDeviceActiveSource () const {
    return _bDeviceActiveSource;
}

inline void T_DiPODeviceInfoItem::setBDeviceActiveSource (bool bDeviceActiveSource_) {
    set_has_bDeviceActiveSource();
    this->_bDeviceActiveSource = bDeviceActiveSource_;
}

inline void T_DiPODeviceInfoItem::clearBDiPOCapable() {
    if (hasBDiPOCapable()) {
         clear_has_bDiPOCapable();
        _bDiPOCapable = false;
     }
}

inline bool T_DiPODeviceInfoItem::hasBDiPOCapable () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool T_DiPODeviceInfoItem::getBDiPOCapable () const {
    return _bDiPOCapable;
}

inline void T_DiPODeviceInfoItem::setBDiPOCapable (bool bDiPOCapable_) {
    set_has_bDiPOCapable();
    this->_bDiPOCapable = bDiPOCapable_;
}

inline void T_DiPODeviceInfoItem::clearBDiPOActive() {
    if (hasBDiPOActive()) {
         clear_has_bDiPOActive();
        _bDiPOActive = false;
     }
}

inline bool T_DiPODeviceInfoItem::hasBDiPOActive () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline bool T_DiPODeviceInfoItem::getBDiPOActive () const {
    return _bDiPOActive;
}

inline void T_DiPODeviceInfoItem::setBDiPOActive (bool bDiPOActive_) {
    set_has_bDiPOActive();
    this->_bDiPOActive = bDiPOActive_;
}

inline void T_DiPODeviceInfoItem::clearSDiPOVersion() {
    if (hasSDiPOVersion()) {
         clear_has_sDiPOVersion();
        _sDiPOVersion.clear();
     }
}

inline bool T_DiPODeviceInfoItem::hasSDiPOVersion () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_DiPODeviceInfoItem::getSDiPOVersion () const {
    return _sDiPOVersion;
}

inline ::std::string& T_DiPODeviceInfoItem::getSDiPOVersionMutable () {
    set_has_sDiPOVersion();
    return _sDiPOVersion;
}

inline void T_DiPODeviceInfoItem::setSDiPOVersion (const ::std::string& sDiPOVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDiPOVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDiPOVersion();
    this->_sDiPOVersion = sDiPOVersion_;
}

inline void T_DiPODeviceInfoItem::setSDiPOVersion (const char* sDiPOVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDiPOVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDiPOVersion();
    this->_sDiPOVersion.assign(sDiPOVersion_);
}

inline void T_DiPODeviceInfoItem::setSDiPOVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDiPOVersion();
    this->_sDiPOVersion.assign(value, size);
}

inline void T_DiPODeviceInfoItem::clearE8ConnectionType() {
    if (hasE8ConnectionType()) {
         clear_has_e8ConnectionType();
        _e8ConnectionType = ::mplay_appcontrol_fi_types::T_e8_DiPOConnectionType__e8DCT_UNKNOWN;
     }
}

inline bool T_DiPODeviceInfoItem::hasE8ConnectionType () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline T_e8_DiPOConnectionType T_DiPODeviceInfoItem::getE8ConnectionType () const {
    return _e8ConnectionType;
}

inline void T_DiPODeviceInfoItem::setE8ConnectionType (T_e8_DiPOConnectionType e8ConnectionType_) {
    #ifndef NDEBUG
    if (!(T_e8_DiPOConnectionType_IsValid(e8ConnectionType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ConnectionType_, "T_e8_DiPOConnectionType", "e8ConnectionType", "T_DiPODeviceInfoItem");
    }
    #endif
    set_has_e8ConnectionType();
    this->_e8ConnectionType = e8ConnectionType_;
}

inline void T_DiPODeviceInfoItem::clearE8ConnectionState() {
    if (hasE8ConnectionState()) {
         clear_has_e8ConnectionState();
        _e8ConnectionState = ::mplay_appcontrol_fi_types::T_e8_DiPOConnectionState__e8CS_CONNECTED;
     }
}

inline bool T_DiPODeviceInfoItem::hasE8ConnectionState () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline T_e8_DiPOConnectionState T_DiPODeviceInfoItem::getE8ConnectionState () const {
    return _e8ConnectionState;
}

inline void T_DiPODeviceInfoItem::setE8ConnectionState (T_e8_DiPOConnectionState e8ConnectionState_) {
    #ifndef NDEBUG
    if (!(T_e8_DiPOConnectionState_IsValid(e8ConnectionState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ConnectionState_, "T_e8_DiPOConnectionState", "e8ConnectionState", "T_DiPODeviceInfoItem");
    }
    #endif
    set_has_e8ConnectionState();
    this->_e8ConnectionState = e8ConnectionState_;
}

inline void T_DiPODeviceInfoItem::clearSMountPoint() {
    if (hasSMountPoint()) {
         clear_has_sMountPoint();
        _sMountPoint.clear();
     }
}

inline bool T_DiPODeviceInfoItem::hasSMountPoint () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const ::std::string& T_DiPODeviceInfoItem::getSMountPoint () const {
    return _sMountPoint;
}

inline ::std::string& T_DiPODeviceInfoItem::getSMountPointMutable () {
    set_has_sMountPoint();
    return _sMountPoint;
}

inline void T_DiPODeviceInfoItem::setSMountPoint (const ::std::string& sMountPoint_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMountPoint_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMountPoint();
    this->_sMountPoint = sMountPoint_;
}

inline void T_DiPODeviceInfoItem::setSMountPoint (const char* sMountPoint_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMountPoint_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMountPoint();
    this->_sMountPoint.assign(sMountPoint_);
}

inline void T_DiPODeviceInfoItem::setSMountPoint (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMountPoint();
    this->_sMountPoint.assign(value, size);
}

inline void T_DiPODeviceInfoItem::clearSAccessoryName() {
    if (hasSAccessoryName()) {
         clear_has_sAccessoryName();
        _sAccessoryName.clear();
     }
}

inline bool T_DiPODeviceInfoItem::hasSAccessoryName () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline const ::std::string& T_DiPODeviceInfoItem::getSAccessoryName () const {
    return _sAccessoryName;
}

inline ::std::string& T_DiPODeviceInfoItem::getSAccessoryNameMutable () {
    set_has_sAccessoryName();
    return _sAccessoryName;
}

inline void T_DiPODeviceInfoItem::setSAccessoryName (const ::std::string& sAccessoryName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAccessoryName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAccessoryName();
    this->_sAccessoryName = sAccessoryName_;
}

inline void T_DiPODeviceInfoItem::setSAccessoryName (const char* sAccessoryName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAccessoryName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAccessoryName();
    this->_sAccessoryName.assign(sAccessoryName_);
}

inline void T_DiPODeviceInfoItem::setSAccessoryName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAccessoryName();
    this->_sAccessoryName.assign(value, size);
}

inline void T_DiPODeviceInfoItem::clearE8DiPOCaps() {
    if (hasE8DiPOCaps()) {
         clear_has_e8DiPOCaps();
        _e8DiPOCaps = ::mplay_appcontrol_fi_types::T_e8_DiPOCaps__e8DIPO_CAP_NONE;
     }
}

inline bool T_DiPODeviceInfoItem::hasE8DiPOCaps () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline T_e8_DiPOCaps T_DiPODeviceInfoItem::getE8DiPOCaps () const {
    return _e8DiPOCaps;
}

inline void T_DiPODeviceInfoItem::setE8DiPOCaps (T_e8_DiPOCaps e8DiPOCaps_) {
    #ifndef NDEBUG
    if (!(T_e8_DiPOCaps_IsValid(e8DiPOCaps_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DiPOCaps_, "T_e8_DiPOCaps", "e8DiPOCaps", "T_DiPODeviceInfoItem");
    }
    #endif
    set_has_e8DiPOCaps();
    this->_e8DiPOCaps = e8DiPOCaps_;
}

inline void T_DiPODeviceInfoItem::clearE8DeviceState() {
    if (hasE8DeviceState()) {
         clear_has_e8DeviceState();
        _e8DeviceState = ::mplay_appcontrol_fi_types::T_e8_DiPODeviceStatus__e8DS_NONE;
     }
}

inline bool T_DiPODeviceInfoItem::hasE8DeviceState () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline T_e8_DiPODeviceStatus T_DiPODeviceInfoItem::getE8DeviceState () const {
    return _e8DeviceState;
}

inline void T_DiPODeviceInfoItem::setE8DeviceState (T_e8_DiPODeviceStatus e8DeviceState_) {
    #ifndef NDEBUG
    if (!(T_e8_DiPODeviceStatus_IsValid(e8DeviceState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceState_, "T_e8_DiPODeviceStatus", "e8DeviceState", "T_DiPODeviceInfoItem");
    }
    #endif
    set_has_e8DeviceState();
    this->_e8DeviceState = e8DeviceState_;
}

inline void T_DiPODeviceInfoItem::clearSDeviceUUID() {
    if (hasSDeviceUUID()) {
         clear_has_sDeviceUUID();
        _sDeviceUUID.clear();
     }
}

inline bool T_DiPODeviceInfoItem::hasSDeviceUUID () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline const ::std::string& T_DiPODeviceInfoItem::getSDeviceUUID () const {
    return _sDeviceUUID;
}

inline ::std::string& T_DiPODeviceInfoItem::getSDeviceUUIDMutable () {
    set_has_sDeviceUUID();
    return _sDeviceUUID;
}

inline void T_DiPODeviceInfoItem::setSDeviceUUID (const ::std::string& sDeviceUUID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUUID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUUID();
    this->_sDeviceUUID = sDeviceUUID_;
}

inline void T_DiPODeviceInfoItem::setSDeviceUUID (const char* sDeviceUUID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUUID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUUID();
    this->_sDeviceUUID.assign(sDeviceUUID_);
}

inline void T_DiPODeviceInfoItem::setSDeviceUUID (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUUID();
    this->_sDeviceUUID.assign(value, size);
}

inline void T_DiPODeviceInfoItem::clearSDeviceBTMacAddress() {
    if (hasSDeviceBTMacAddress()) {
         clear_has_sDeviceBTMacAddress();
        _sDeviceBTMacAddress.clear();
     }
}

inline bool T_DiPODeviceInfoItem::hasSDeviceBTMacAddress () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline const ::std::string& T_DiPODeviceInfoItem::getSDeviceBTMacAddress () const {
    return _sDeviceBTMacAddress;
}

inline ::std::string& T_DiPODeviceInfoItem::getSDeviceBTMacAddressMutable () {
    set_has_sDeviceBTMacAddress();
    return _sDeviceBTMacAddress;
}

inline void T_DiPODeviceInfoItem::setSDeviceBTMacAddress (const ::std::string& sDeviceBTMacAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceBTMacAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceBTMacAddress();
    this->_sDeviceBTMacAddress = sDeviceBTMacAddress_;
}

inline void T_DiPODeviceInfoItem::setSDeviceBTMacAddress (const char* sDeviceBTMacAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceBTMacAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceBTMacAddress();
    this->_sDeviceBTMacAddress.assign(sDeviceBTMacAddress_);
}

inline void T_DiPODeviceInfoItem::setSDeviceBTMacAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceBTMacAddress();
    this->_sDeviceBTMacAddress.assign(value, size);
}

inline void T_DiPODeviceInfoItem::clearSDeviceUSBSerialNumber() {
    if (hasSDeviceUSBSerialNumber()) {
         clear_has_sDeviceUSBSerialNumber();
        _sDeviceUSBSerialNumber.clear();
     }
}

inline bool T_DiPODeviceInfoItem::hasSDeviceUSBSerialNumber () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline const ::std::string& T_DiPODeviceInfoItem::getSDeviceUSBSerialNumber () const {
    return _sDeviceUSBSerialNumber;
}

inline ::std::string& T_DiPODeviceInfoItem::getSDeviceUSBSerialNumberMutable () {
    set_has_sDeviceUSBSerialNumber();
    return _sDeviceUSBSerialNumber;
}

inline void T_DiPODeviceInfoItem::setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber = sDeviceUSBSerialNumber_;
}

inline void T_DiPODeviceInfoItem::setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber.assign(sDeviceUSBSerialNumber_);
}

inline void T_DiPODeviceInfoItem::setSDeviceUSBSerialNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber.assign(value, size);
}

inline void T_DiPODeviceInfoItem::set_has_u8DeviceTag () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DiPODeviceInfoItem::clear_has_u8DeviceTag () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DiPODeviceInfoItem::set_has_sDeviceName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DiPODeviceInfoItem::clear_has_sDeviceName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DiPODeviceInfoItem::set_has_e8DeviceType () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DiPODeviceInfoItem::clear_has_e8DeviceType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DiPODeviceInfoItem::set_has_sDeviceSerialNumber () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DiPODeviceInfoItem::clear_has_sDeviceSerialNumber () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_DiPODeviceInfoItem::set_has_bDeviceConnected () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_DiPODeviceInfoItem::clear_has_bDeviceConnected () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_DiPODeviceInfoItem::set_has_bDeviceActiveSource () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_DiPODeviceInfoItem::clear_has_bDeviceActiveSource () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_DiPODeviceInfoItem::set_has_bDiPOCapable () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_DiPODeviceInfoItem::clear_has_bDiPOCapable () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_DiPODeviceInfoItem::set_has_bDiPOActive () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_DiPODeviceInfoItem::clear_has_bDiPOActive () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_DiPODeviceInfoItem::set_has_sDiPOVersion () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_DiPODeviceInfoItem::clear_has_sDiPOVersion () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_DiPODeviceInfoItem::set_has_e8ConnectionType () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_DiPODeviceInfoItem::clear_has_e8ConnectionType () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_DiPODeviceInfoItem::set_has_e8ConnectionState () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_DiPODeviceInfoItem::clear_has_e8ConnectionState () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_DiPODeviceInfoItem::set_has_sMountPoint () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_DiPODeviceInfoItem::clear_has_sMountPoint () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_DiPODeviceInfoItem::set_has_sAccessoryName () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_DiPODeviceInfoItem::clear_has_sAccessoryName () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_DiPODeviceInfoItem::set_has_e8DiPOCaps () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_DiPODeviceInfoItem::clear_has_e8DiPOCaps () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_DiPODeviceInfoItem::set_has_e8DeviceState () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_DiPODeviceInfoItem::clear_has_e8DeviceState () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_DiPODeviceInfoItem::set_has_sDeviceUUID () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_DiPODeviceInfoItem::clear_has_sDeviceUUID () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_DiPODeviceInfoItem::set_has_sDeviceBTMacAddress () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_DiPODeviceInfoItem::clear_has_sDeviceBTMacAddress () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void T_DiPODeviceInfoItem::set_has_sDeviceUSBSerialNumber () {
    _has_bits_[0] |= 1u << 17;
}

inline void T_DiPODeviceInfoItem::clear_has_sDeviceUSBSerialNumber () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline  T_b8_DiPOLocationInfoType::T_b8_DiPOLocationInfoType ()  :
    _GPGGA (false),
    _GPRMC (false),
    _GPGSV (false),
    _GPHDT (false),
    _PASCD (false),
    _PAGCD (false),
    _PAACD (false)
{
}

inline  T_b8_DiPOLocationInfoType::T_b8_DiPOLocationInfoType (const T_b8_DiPOLocationInfoType &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_DiPOLocationInfoType::T_b8_DiPOLocationInfoType (bool GPGGA, bool GPRMC, bool GPGSV, bool GPHDT, bool PASCD, bool PAGCD, bool PAACD) :
    _GPGGA (GPGGA),
    _GPRMC (GPRMC),
    _GPGSV (GPGSV),
    _GPHDT (GPHDT),
    _PASCD (PASCD),
    _PAGCD (PAGCD),
    _PAACD (PAACD)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_DiPOLocationInfoType& T_b8_DiPOLocationInfoType::operator = (const T_b8_DiPOLocationInfoType& rhs) {
    if( this != &rhs ) {
        _GPGGA = rhs._GPGGA;
        _GPRMC = rhs._GPRMC;
        _GPGSV = rhs._GPGSV;
        _GPHDT = rhs._GPHDT;
        _PASCD = rhs._PASCD;
        _PAGCD = rhs._PAGCD;
        _PAACD = rhs._PAACD;
    }
    return *this;
}

inline bool T_b8_DiPOLocationInfoType::operator == (const T_b8_DiPOLocationInfoType& rhs) const {
    return (_GPGGA == rhs._GPGGA &&
        _GPRMC == rhs._GPRMC &&
        _GPGSV == rhs._GPGSV &&
        _GPHDT == rhs._GPHDT &&
        _PASCD == rhs._PASCD &&
        _PAGCD == rhs._PAGCD &&
        _PAACD == rhs._PAACD);
}

inline bool T_b8_DiPOLocationInfoType::operator != (const T_b8_DiPOLocationInfoType& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_DiPOLocationInfoType::operator < (const T_b8_DiPOLocationInfoType& rhs) const {
    if (getGPGGA() < rhs.getGPGGA()) return true;
    if (getGPGGA() > rhs.getGPGGA()) return false;

    if (getGPRMC() < rhs.getGPRMC()) return true;
    if (getGPRMC() > rhs.getGPRMC()) return false;

    if (getGPGSV() < rhs.getGPGSV()) return true;
    if (getGPGSV() > rhs.getGPGSV()) return false;

    if (getGPHDT() < rhs.getGPHDT()) return true;
    if (getGPHDT() > rhs.getGPHDT()) return false;

    if (getPASCD() < rhs.getPASCD()) return true;
    if (getPASCD() > rhs.getPASCD()) return false;

    if (getPAGCD() < rhs.getPAGCD()) return true;
    if (getPAGCD() > rhs.getPAGCD()) return false;

    if (getPAACD() < rhs.getPAACD()) return true;
    if (getPAACD() > rhs.getPAACD()) return false;

    return false;
}

inline bool T_b8_DiPOLocationInfoType::operator > (const T_b8_DiPOLocationInfoType& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_DiPOLocationInfoType::setGPGGA (bool GPGGA) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_GPGGA = GPGGA;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DiPOLocationInfoType::getGPGGA () const {
    return _GPGGA;
}

inline void T_b8_DiPOLocationInfoType::setGPRMC (bool GPRMC) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_GPRMC = GPRMC;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DiPOLocationInfoType::getGPRMC () const {
    return _GPRMC;
}

inline void T_b8_DiPOLocationInfoType::setGPGSV (bool GPGSV) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_GPGSV = GPGSV;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DiPOLocationInfoType::getGPGSV () const {
    return _GPGSV;
}

inline void T_b8_DiPOLocationInfoType::setGPHDT (bool GPHDT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_GPHDT = GPHDT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DiPOLocationInfoType::getGPHDT () const {
    return _GPHDT;
}

inline void T_b8_DiPOLocationInfoType::setPASCD (bool PASCD) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_PASCD = PASCD;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DiPOLocationInfoType::getPASCD () const {
    return _PASCD;
}

inline void T_b8_DiPOLocationInfoType::setPAGCD (bool PAGCD) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_PAGCD = PAGCD;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DiPOLocationInfoType::getPAGCD () const {
    return _PAGCD;
}

inline void T_b8_DiPOLocationInfoType::setPAACD (bool PAACD) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_PAACD = PAACD;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DiPOLocationInfoType::getPAACD () const {
    return _PAACD;
}

inline  T_b8_DiPOGPRMCDataStatusValues::T_b8_DiPOGPRMCDataStatusValues ()  :
    _GPRMCDataStatusValueA (false),
    _GPRMCDataStatusValueV (false),
    _GPRMCDataStatusValueX (false)
{
}

inline  T_b8_DiPOGPRMCDataStatusValues::T_b8_DiPOGPRMCDataStatusValues (const T_b8_DiPOGPRMCDataStatusValues &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_DiPOGPRMCDataStatusValues::T_b8_DiPOGPRMCDataStatusValues (bool GPRMCDataStatusValueA, bool GPRMCDataStatusValueV, bool GPRMCDataStatusValueX) :
    _GPRMCDataStatusValueA (GPRMCDataStatusValueA),
    _GPRMCDataStatusValueV (GPRMCDataStatusValueV),
    _GPRMCDataStatusValueX (GPRMCDataStatusValueX)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_DiPOGPRMCDataStatusValues& T_b8_DiPOGPRMCDataStatusValues::operator = (const T_b8_DiPOGPRMCDataStatusValues& rhs) {
    if( this != &rhs ) {
        _GPRMCDataStatusValueA = rhs._GPRMCDataStatusValueA;
        _GPRMCDataStatusValueV = rhs._GPRMCDataStatusValueV;
        _GPRMCDataStatusValueX = rhs._GPRMCDataStatusValueX;
    }
    return *this;
}

inline bool T_b8_DiPOGPRMCDataStatusValues::operator == (const T_b8_DiPOGPRMCDataStatusValues& rhs) const {
    return (_GPRMCDataStatusValueA == rhs._GPRMCDataStatusValueA &&
        _GPRMCDataStatusValueV == rhs._GPRMCDataStatusValueV &&
        _GPRMCDataStatusValueX == rhs._GPRMCDataStatusValueX);
}

inline bool T_b8_DiPOGPRMCDataStatusValues::operator != (const T_b8_DiPOGPRMCDataStatusValues& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_DiPOGPRMCDataStatusValues::operator < (const T_b8_DiPOGPRMCDataStatusValues& rhs) const {
    if (getGPRMCDataStatusValueA() < rhs.getGPRMCDataStatusValueA()) return true;
    if (getGPRMCDataStatusValueA() > rhs.getGPRMCDataStatusValueA()) return false;

    if (getGPRMCDataStatusValueV() < rhs.getGPRMCDataStatusValueV()) return true;
    if (getGPRMCDataStatusValueV() > rhs.getGPRMCDataStatusValueV()) return false;

    if (getGPRMCDataStatusValueX() < rhs.getGPRMCDataStatusValueX()) return true;
    if (getGPRMCDataStatusValueX() > rhs.getGPRMCDataStatusValueX()) return false;

    return false;
}

inline bool T_b8_DiPOGPRMCDataStatusValues::operator > (const T_b8_DiPOGPRMCDataStatusValues& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_DiPOGPRMCDataStatusValues::setGPRMCDataStatusValueA (bool GPRMCDataStatusValueA) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_GPRMCDataStatusValueA = GPRMCDataStatusValueA;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DiPOGPRMCDataStatusValues::getGPRMCDataStatusValueA () const {
    return _GPRMCDataStatusValueA;
}

inline void T_b8_DiPOGPRMCDataStatusValues::setGPRMCDataStatusValueV (bool GPRMCDataStatusValueV) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_GPRMCDataStatusValueV = GPRMCDataStatusValueV;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DiPOGPRMCDataStatusValues::getGPRMCDataStatusValueV () const {
    return _GPRMCDataStatusValueV;
}

inline void T_b8_DiPOGPRMCDataStatusValues::setGPRMCDataStatusValueX (bool GPRMCDataStatusValueX) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_GPRMCDataStatusValueX = GPRMCDataStatusValueX;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_DiPOGPRMCDataStatusValues::getGPRMCDataStatusValueX () const {
    return _GPRMCDataStatusValueX;
}

inline  T_b32_BTProfileType::T_b32_BTProfileType ()  :
    _HandsFree (false),
    _PhoneBookAccess (false),
    _AudioVideoRemoteControl (false),
    _AdvancedAudioDistribution (false),
    _HumanInterfaceDevice (false),
    _iAP2Link (false),
    _PersonalAreaNetworkAccessPoint (false),
    _MessageAccess (false),
    _PersonalAreaNetworkClient (false)
{
}

inline  T_b32_BTProfileType::T_b32_BTProfileType (const T_b32_BTProfileType &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b32_BTProfileType::T_b32_BTProfileType (bool HandsFree, bool PhoneBookAccess, bool AudioVideoRemoteControl, bool AdvancedAudioDistribution, bool HumanInterfaceDevice, bool iAP2Link, bool PersonalAreaNetworkAccessPoint, bool MessageAccess, bool PersonalAreaNetworkClient) :
    _HandsFree (HandsFree),
    _PhoneBookAccess (PhoneBookAccess),
    _AudioVideoRemoteControl (AudioVideoRemoteControl),
    _AdvancedAudioDistribution (AdvancedAudioDistribution),
    _HumanInterfaceDevice (HumanInterfaceDevice),
    _iAP2Link (iAP2Link),
    _PersonalAreaNetworkAccessPoint (PersonalAreaNetworkAccessPoint),
    _MessageAccess (MessageAccess),
    _PersonalAreaNetworkClient (PersonalAreaNetworkClient)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b32_BTProfileType& T_b32_BTProfileType::operator = (const T_b32_BTProfileType& rhs) {
    if( this != &rhs ) {
        _HandsFree = rhs._HandsFree;
        _PhoneBookAccess = rhs._PhoneBookAccess;
        _AudioVideoRemoteControl = rhs._AudioVideoRemoteControl;
        _AdvancedAudioDistribution = rhs._AdvancedAudioDistribution;
        _HumanInterfaceDevice = rhs._HumanInterfaceDevice;
        _iAP2Link = rhs._iAP2Link;
        _PersonalAreaNetworkAccessPoint = rhs._PersonalAreaNetworkAccessPoint;
        _MessageAccess = rhs._MessageAccess;
        _PersonalAreaNetworkClient = rhs._PersonalAreaNetworkClient;
    }
    return *this;
}

inline bool T_b32_BTProfileType::operator == (const T_b32_BTProfileType& rhs) const {
    return (_HandsFree == rhs._HandsFree &&
        _PhoneBookAccess == rhs._PhoneBookAccess &&
        _AudioVideoRemoteControl == rhs._AudioVideoRemoteControl &&
        _AdvancedAudioDistribution == rhs._AdvancedAudioDistribution &&
        _HumanInterfaceDevice == rhs._HumanInterfaceDevice &&
        _iAP2Link == rhs._iAP2Link &&
        _PersonalAreaNetworkAccessPoint == rhs._PersonalAreaNetworkAccessPoint &&
        _MessageAccess == rhs._MessageAccess &&
        _PersonalAreaNetworkClient == rhs._PersonalAreaNetworkClient);
}

inline bool T_b32_BTProfileType::operator != (const T_b32_BTProfileType& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b32_BTProfileType::operator < (const T_b32_BTProfileType& rhs) const {
    if (getHandsFree() < rhs.getHandsFree()) return true;
    if (getHandsFree() > rhs.getHandsFree()) return false;

    if (getPhoneBookAccess() < rhs.getPhoneBookAccess()) return true;
    if (getPhoneBookAccess() > rhs.getPhoneBookAccess()) return false;

    if (getAudioVideoRemoteControl() < rhs.getAudioVideoRemoteControl()) return true;
    if (getAudioVideoRemoteControl() > rhs.getAudioVideoRemoteControl()) return false;

    if (getAdvancedAudioDistribution() < rhs.getAdvancedAudioDistribution()) return true;
    if (getAdvancedAudioDistribution() > rhs.getAdvancedAudioDistribution()) return false;

    if (getHumanInterfaceDevice() < rhs.getHumanInterfaceDevice()) return true;
    if (getHumanInterfaceDevice() > rhs.getHumanInterfaceDevice()) return false;

    if (getIAP2Link() < rhs.getIAP2Link()) return true;
    if (getIAP2Link() > rhs.getIAP2Link()) return false;

    if (getPersonalAreaNetworkAccessPoint() < rhs.getPersonalAreaNetworkAccessPoint()) return true;
    if (getPersonalAreaNetworkAccessPoint() > rhs.getPersonalAreaNetworkAccessPoint()) return false;

    if (getMessageAccess() < rhs.getMessageAccess()) return true;
    if (getMessageAccess() > rhs.getMessageAccess()) return false;

    if (getPersonalAreaNetworkClient() < rhs.getPersonalAreaNetworkClient()) return true;
    if (getPersonalAreaNetworkClient() > rhs.getPersonalAreaNetworkClient()) return false;

    return false;
}

inline bool T_b32_BTProfileType::operator > (const T_b32_BTProfileType& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b32_BTProfileType::setHandsFree (bool HandsFree) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_HandsFree = HandsFree;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_BTProfileType::getHandsFree () const {
    return _HandsFree;
}

inline void T_b32_BTProfileType::setPhoneBookAccess (bool PhoneBookAccess) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_PhoneBookAccess = PhoneBookAccess;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_BTProfileType::getPhoneBookAccess () const {
    return _PhoneBookAccess;
}

inline void T_b32_BTProfileType::setAudioVideoRemoteControl (bool AudioVideoRemoteControl) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_AudioVideoRemoteControl = AudioVideoRemoteControl;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_BTProfileType::getAudioVideoRemoteControl () const {
    return _AudioVideoRemoteControl;
}

inline void T_b32_BTProfileType::setAdvancedAudioDistribution (bool AdvancedAudioDistribution) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_AdvancedAudioDistribution = AdvancedAudioDistribution;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_BTProfileType::getAdvancedAudioDistribution () const {
    return _AdvancedAudioDistribution;
}

inline void T_b32_BTProfileType::setHumanInterfaceDevice (bool HumanInterfaceDevice) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_HumanInterfaceDevice = HumanInterfaceDevice;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_BTProfileType::getHumanInterfaceDevice () const {
    return _HumanInterfaceDevice;
}

inline void T_b32_BTProfileType::setIAP2Link (bool iAP2Link) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_iAP2Link = iAP2Link;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_BTProfileType::getIAP2Link () const {
    return _iAP2Link;
}

inline void T_b32_BTProfileType::setPersonalAreaNetworkAccessPoint (bool PersonalAreaNetworkAccessPoint) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_PersonalAreaNetworkAccessPoint = PersonalAreaNetworkAccessPoint;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_BTProfileType::getPersonalAreaNetworkAccessPoint () const {
    return _PersonalAreaNetworkAccessPoint;
}

inline void T_b32_BTProfileType::setMessageAccess (bool MessageAccess) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_MessageAccess = MessageAccess;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_BTProfileType::getMessageAccess () const {
    return _MessageAccess;
}

inline void T_b32_BTProfileType::setPersonalAreaNetworkClient (bool PersonalAreaNetworkClient) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_PersonalAreaNetworkClient = PersonalAreaNetworkClient;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_BTProfileType::getPersonalAreaNetworkClient () const {
    return _PersonalAreaNetworkClient;
}

inline  T_BTProfileItem::T_BTProfileItem ()  :
    _u8DeviceId (0u),
    _b32BTProfile ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTProfileItem::T_BTProfileItem (const T_BTProfileItem &rhs)  :
    _u8DeviceId (0u),
    _b32BTProfile ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTProfileItem::T_BTProfileItem (uint8 u8DeviceId_, const T_b32_BTProfileType& b32BTProfile_)  :
    _u8DeviceId (u8DeviceId_),
    _b32BTProfile (b32BTProfile_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTProfileItem::~T_BTProfileItem() {
}

inline T_BTProfileItem& T_BTProfileItem::operator = (const T_BTProfileItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8DeviceId()) {
            setU8DeviceId(rhs.getU8DeviceId());
        } else {
            clearU8DeviceId();
        }
        if (rhs.hasB32BTProfile()) {
            setB32BTProfile(rhs.getB32BTProfile());
        } else {
            clearB32BTProfile();
        }
    }
    return *this;
}

inline bool T_BTProfileItem::operator == (const T_BTProfileItem& rhs) const {
    return (((!hasU8DeviceId() && !rhs.hasU8DeviceId()) || getU8DeviceId() == rhs.getU8DeviceId()) &&
        ((!hasB32BTProfile() && !rhs.hasB32BTProfile()) || getB32BTProfile() == rhs.getB32BTProfile()));
}

inline bool T_BTProfileItem::operator != (const T_BTProfileItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTProfileItem::operator < (const T_BTProfileItem& rhs) const {
    if (hasU8DeviceId() || rhs.hasU8DeviceId()) {
        if (getU8DeviceId() < rhs.getU8DeviceId()) return true;
        if (getU8DeviceId() > rhs.getU8DeviceId()) return false;
    }
    if (hasB32BTProfile() || rhs.hasB32BTProfile()) {
        if (getB32BTProfile() < rhs.getB32BTProfile()) return true;
        if (getB32BTProfile() > rhs.getB32BTProfile()) return false;
    }
    return false;
}

inline bool T_BTProfileItem::operator > (const T_BTProfileItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTProfileItem::clear() {
    clearU8DeviceId();
    clearB32BTProfile();
}

inline void T_BTProfileItem::clearU8DeviceId() {
    if (hasU8DeviceId()) {
         clear_has_u8DeviceId();
        _u8DeviceId = 0u;
     }
}

inline bool T_BTProfileItem::hasU8DeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_BTProfileItem::getU8DeviceId () const {
    return _u8DeviceId;
}

inline void T_BTProfileItem::setU8DeviceId (uint8 u8DeviceId_) {
    set_has_u8DeviceId();
    this->_u8DeviceId = u8DeviceId_;
}

inline void T_BTProfileItem::clearB32BTProfile() {
    if (hasB32BTProfile()) {
         clear_has_b32BTProfile();
        _b32BTProfile = T_b32_BTProfileType ();
     }
}

inline bool T_BTProfileItem::hasB32BTProfile () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_b32_BTProfileType& T_BTProfileItem::getB32BTProfile () const {
    return _b32BTProfile;
}

inline T_b32_BTProfileType& T_BTProfileItem::getB32BTProfileMutable () {
    set_has_b32BTProfile();
    return _b32BTProfile;
}

inline void T_BTProfileItem::setB32BTProfile (const T_b32_BTProfileType& b32BTProfile_) {
    set_has_b32BTProfile();
    this->_b32BTProfile = b32BTProfile_;
}

inline void T_BTProfileItem::set_has_u8DeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTProfileItem::clear_has_u8DeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTProfileItem::set_has_b32BTProfile () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTProfileItem::clear_has_b32BTProfile () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_DiPOCallStateItem::T_DiPOCallStateItem ()  :
    _sRemoteID (),
    _sDisplayName (),
    _eStatus (::mplay_appcontrol_fi_types::T_e8_DiPOCallStateUpdateStatus__e8DIPO_CSUS_DISCONNECTED),
    _eDirection (::mplay_appcontrol_fi_types::T_e8_DiPOCallStateUpdateDirection__e8DIPO_CSUD_UNKNOWN),
    _sCallUUID (),
    _sAddressBookID (),
    _sLabel (),
    _eService (::mplay_appcontrol_fi_types::T_e8_DiPOCallStateUpdateService__e8DIPO_CSEV_UNKNOWN),
    _bIsConferenced (false),
    _u8ConferenceGroup (0u),
    _eDisconnectReason (::mplay_appcontrol_fi_types::T_e8_DiPOCallStateUpdateDisconnectReason__e8DIPO_CSDR_ENDED),
    _u64StartTimestamp (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DiPOCallStateItem::T_DiPOCallStateItem (const T_DiPOCallStateItem &rhs)  :
    _sRemoteID (),
    _sDisplayName (),
    _eStatus (::mplay_appcontrol_fi_types::T_e8_DiPOCallStateUpdateStatus__e8DIPO_CSUS_DISCONNECTED),
    _eDirection (::mplay_appcontrol_fi_types::T_e8_DiPOCallStateUpdateDirection__e8DIPO_CSUD_UNKNOWN),
    _sCallUUID (),
    _sAddressBookID (),
    _sLabel (),
    _eService (::mplay_appcontrol_fi_types::T_e8_DiPOCallStateUpdateService__e8DIPO_CSEV_UNKNOWN),
    _bIsConferenced (false),
    _u8ConferenceGroup (0u),
    _eDisconnectReason (::mplay_appcontrol_fi_types::T_e8_DiPOCallStateUpdateDisconnectReason__e8DIPO_CSDR_ENDED),
    _u64StartTimestamp (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DiPOCallStateItem::T_DiPOCallStateItem (const ::std::string& sRemoteID_, const ::std::string& sDisplayName_, T_e8_DiPOCallStateUpdateStatus eStatus_, T_e8_DiPOCallStateUpdateDirection eDirection_, const ::std::string& sCallUUID_, const ::std::string& sAddressBookID_, const ::std::string& sLabel_, T_e8_DiPOCallStateUpdateService eService_, bool bIsConferenced_, uint8 u8ConferenceGroup_, T_e8_DiPOCallStateUpdateDisconnectReason eDisconnectReason_, uint64 u64StartTimestamp_)  :
    _sRemoteID (sRemoteID_),
    _sDisplayName (sDisplayName_),
    _eStatus (eStatus_),
    _eDirection (eDirection_),
    _sCallUUID (sCallUUID_),
    _sAddressBookID (sAddressBookID_),
    _sLabel (sLabel_),
    _eService (eService_),
    _bIsConferenced (bIsConferenced_),
    _u8ConferenceGroup (u8ConferenceGroup_),
    _eDisconnectReason (eDisconnectReason_),
    _u64StartTimestamp (u64StartTimestamp_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sRemoteID_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDisplayName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_DiPOCallStateUpdateStatus_IsValid(eStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eStatus_, "T_e8_DiPOCallStateUpdateStatus", "eStatus", "T_DiPOCallStateItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_DiPOCallStateUpdateDirection_IsValid(eDirection_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eDirection_, "T_e8_DiPOCallStateUpdateDirection", "eDirection", "T_DiPOCallStateItem");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCallUUID_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAddressBookID_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_DiPOCallStateUpdateService_IsValid(eService_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eService_, "T_e8_DiPOCallStateUpdateService", "eService", "T_DiPOCallStateItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_DiPOCallStateUpdateDisconnectReason_IsValid(eDisconnectReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eDisconnectReason_, "T_e8_DiPOCallStateUpdateDisconnectReason", "eDisconnectReason", "T_DiPOCallStateItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DiPOCallStateItem::~T_DiPOCallStateItem() {
}

inline T_DiPOCallStateItem& T_DiPOCallStateItem::operator = (const T_DiPOCallStateItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSRemoteID()) {
            setSRemoteID(rhs.getSRemoteID());
        } else {
            clearSRemoteID();
        }
        if (rhs.hasSDisplayName()) {
            setSDisplayName(rhs.getSDisplayName());
        } else {
            clearSDisplayName();
        }
        if (rhs.hasEStatus()) {
            setEStatus(rhs.getEStatus());
        } else {
            clearEStatus();
        }
        if (rhs.hasEDirection()) {
            setEDirection(rhs.getEDirection());
        } else {
            clearEDirection();
        }
        if (rhs.hasSCallUUID()) {
            setSCallUUID(rhs.getSCallUUID());
        } else {
            clearSCallUUID();
        }
        if (rhs.hasSAddressBookID()) {
            setSAddressBookID(rhs.getSAddressBookID());
        } else {
            clearSAddressBookID();
        }
        if (rhs.hasSLabel()) {
            setSLabel(rhs.getSLabel());
        } else {
            clearSLabel();
        }
        if (rhs.hasEService()) {
            setEService(rhs.getEService());
        } else {
            clearEService();
        }
        if (rhs.hasBIsConferenced()) {
            setBIsConferenced(rhs.getBIsConferenced());
        } else {
            clearBIsConferenced();
        }
        if (rhs.hasU8ConferenceGroup()) {
            setU8ConferenceGroup(rhs.getU8ConferenceGroup());
        } else {
            clearU8ConferenceGroup();
        }
        if (rhs.hasEDisconnectReason()) {
            setEDisconnectReason(rhs.getEDisconnectReason());
        } else {
            clearEDisconnectReason();
        }
        if (rhs.hasU64StartTimestamp()) {
            setU64StartTimestamp(rhs.getU64StartTimestamp());
        } else {
            clearU64StartTimestamp();
        }
    }
    return *this;
}

inline bool T_DiPOCallStateItem::operator == (const T_DiPOCallStateItem& rhs) const {
    return (((!hasSRemoteID() && !rhs.hasSRemoteID()) || getSRemoteID() == rhs.getSRemoteID()) &&
        ((!hasSDisplayName() && !rhs.hasSDisplayName()) || getSDisplayName() == rhs.getSDisplayName()) &&
        ((!hasEStatus() && !rhs.hasEStatus()) || getEStatus() == rhs.getEStatus()) &&
        ((!hasEDirection() && !rhs.hasEDirection()) || getEDirection() == rhs.getEDirection()) &&
        ((!hasSCallUUID() && !rhs.hasSCallUUID()) || getSCallUUID() == rhs.getSCallUUID()) &&
        ((!hasSAddressBookID() && !rhs.hasSAddressBookID()) || getSAddressBookID() == rhs.getSAddressBookID()) &&
        ((!hasSLabel() && !rhs.hasSLabel()) || getSLabel() == rhs.getSLabel()) &&
        ((!hasEService() && !rhs.hasEService()) || getEService() == rhs.getEService()) &&
        ((!hasBIsConferenced() && !rhs.hasBIsConferenced()) || getBIsConferenced() == rhs.getBIsConferenced()) &&
        ((!hasU8ConferenceGroup() && !rhs.hasU8ConferenceGroup()) || getU8ConferenceGroup() == rhs.getU8ConferenceGroup()) &&
        ((!hasEDisconnectReason() && !rhs.hasEDisconnectReason()) || getEDisconnectReason() == rhs.getEDisconnectReason()) &&
        ((!hasU64StartTimestamp() && !rhs.hasU64StartTimestamp()) || getU64StartTimestamp() == rhs.getU64StartTimestamp()));
}

inline bool T_DiPOCallStateItem::operator != (const T_DiPOCallStateItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DiPOCallStateItem::operator < (const T_DiPOCallStateItem& rhs) const {
    if (hasSRemoteID() || rhs.hasSRemoteID()) {
        if (getSRemoteID() < rhs.getSRemoteID()) return true;
        if (getSRemoteID() > rhs.getSRemoteID()) return false;
    }
    if (hasSDisplayName() || rhs.hasSDisplayName()) {
        if (getSDisplayName() < rhs.getSDisplayName()) return true;
        if (getSDisplayName() > rhs.getSDisplayName()) return false;
    }
    if (hasEStatus() || rhs.hasEStatus()) {
        if ((uint32)getEStatus() < (uint32)rhs.getEStatus()) return true;
        if ((uint32)getEStatus() > (uint32)rhs.getEStatus()) return false;
    }
    if (hasEDirection() || rhs.hasEDirection()) {
        if ((uint32)getEDirection() < (uint32)rhs.getEDirection()) return true;
        if ((uint32)getEDirection() > (uint32)rhs.getEDirection()) return false;
    }
    if (hasSCallUUID() || rhs.hasSCallUUID()) {
        if (getSCallUUID() < rhs.getSCallUUID()) return true;
        if (getSCallUUID() > rhs.getSCallUUID()) return false;
    }
    if (hasSAddressBookID() || rhs.hasSAddressBookID()) {
        if (getSAddressBookID() < rhs.getSAddressBookID()) return true;
        if (getSAddressBookID() > rhs.getSAddressBookID()) return false;
    }
    if (hasSLabel() || rhs.hasSLabel()) {
        if (getSLabel() < rhs.getSLabel()) return true;
        if (getSLabel() > rhs.getSLabel()) return false;
    }
    if (hasEService() || rhs.hasEService()) {
        if ((uint32)getEService() < (uint32)rhs.getEService()) return true;
        if ((uint32)getEService() > (uint32)rhs.getEService()) return false;
    }
    if (hasBIsConferenced() || rhs.hasBIsConferenced()) {
        if (getBIsConferenced() < rhs.getBIsConferenced()) return true;
        if (getBIsConferenced() > rhs.getBIsConferenced()) return false;
    }
    if (hasU8ConferenceGroup() || rhs.hasU8ConferenceGroup()) {
        if (getU8ConferenceGroup() < rhs.getU8ConferenceGroup()) return true;
        if (getU8ConferenceGroup() > rhs.getU8ConferenceGroup()) return false;
    }
    if (hasEDisconnectReason() || rhs.hasEDisconnectReason()) {
        if ((uint32)getEDisconnectReason() < (uint32)rhs.getEDisconnectReason()) return true;
        if ((uint32)getEDisconnectReason() > (uint32)rhs.getEDisconnectReason()) return false;
    }
    if (hasU64StartTimestamp() || rhs.hasU64StartTimestamp()) {
        if (getU64StartTimestamp() < rhs.getU64StartTimestamp()) return true;
        if (getU64StartTimestamp() > rhs.getU64StartTimestamp()) return false;
    }
    return false;
}

inline bool T_DiPOCallStateItem::operator > (const T_DiPOCallStateItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DiPOCallStateItem::clear() {
    clearSRemoteID();
    clearSDisplayName();
    clearEStatus();
    clearEDirection();
    clearSCallUUID();
    clearSAddressBookID();
    clearSLabel();
    clearEService();
    clearBIsConferenced();
    clearU8ConferenceGroup();
    clearEDisconnectReason();
    clearU64StartTimestamp();
}

inline void T_DiPOCallStateItem::clearSRemoteID() {
    if (hasSRemoteID()) {
         clear_has_sRemoteID();
        _sRemoteID.clear();
     }
}

inline bool T_DiPOCallStateItem::hasSRemoteID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_DiPOCallStateItem::getSRemoteID () const {
    return _sRemoteID;
}

inline ::std::string& T_DiPOCallStateItem::getSRemoteIDMutable () {
    set_has_sRemoteID();
    return _sRemoteID;
}

inline void T_DiPOCallStateItem::setSRemoteID (const ::std::string& sRemoteID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sRemoteID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sRemoteID();
    this->_sRemoteID = sRemoteID_;
}

inline void T_DiPOCallStateItem::setSRemoteID (const char* sRemoteID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sRemoteID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sRemoteID();
    this->_sRemoteID.assign(sRemoteID_);
}

inline void T_DiPOCallStateItem::setSRemoteID (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sRemoteID();
    this->_sRemoteID.assign(value, size);
}

inline void T_DiPOCallStateItem::clearSDisplayName() {
    if (hasSDisplayName()) {
         clear_has_sDisplayName();
        _sDisplayName.clear();
     }
}

inline bool T_DiPOCallStateItem::hasSDisplayName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_DiPOCallStateItem::getSDisplayName () const {
    return _sDisplayName;
}

inline ::std::string& T_DiPOCallStateItem::getSDisplayNameMutable () {
    set_has_sDisplayName();
    return _sDisplayName;
}

inline void T_DiPOCallStateItem::setSDisplayName (const ::std::string& sDisplayName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDisplayName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDisplayName();
    this->_sDisplayName = sDisplayName_;
}

inline void T_DiPOCallStateItem::setSDisplayName (const char* sDisplayName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDisplayName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDisplayName();
    this->_sDisplayName.assign(sDisplayName_);
}

inline void T_DiPOCallStateItem::setSDisplayName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDisplayName();
    this->_sDisplayName.assign(value, size);
}

inline void T_DiPOCallStateItem::clearEStatus() {
    if (hasEStatus()) {
         clear_has_eStatus();
        _eStatus = ::mplay_appcontrol_fi_types::T_e8_DiPOCallStateUpdateStatus__e8DIPO_CSUS_DISCONNECTED;
     }
}

inline bool T_DiPOCallStateItem::hasEStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_DiPOCallStateUpdateStatus T_DiPOCallStateItem::getEStatus () const {
    return _eStatus;
}

inline void T_DiPOCallStateItem::setEStatus (T_e8_DiPOCallStateUpdateStatus eStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_DiPOCallStateUpdateStatus_IsValid(eStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eStatus_, "T_e8_DiPOCallStateUpdateStatus", "eStatus", "T_DiPOCallStateItem");
    }
    #endif
    set_has_eStatus();
    this->_eStatus = eStatus_;
}

inline void T_DiPOCallStateItem::clearEDirection() {
    if (hasEDirection()) {
         clear_has_eDirection();
        _eDirection = ::mplay_appcontrol_fi_types::T_e8_DiPOCallStateUpdateDirection__e8DIPO_CSUD_UNKNOWN;
     }
}

inline bool T_DiPOCallStateItem::hasEDirection () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_DiPOCallStateUpdateDirection T_DiPOCallStateItem::getEDirection () const {
    return _eDirection;
}

inline void T_DiPOCallStateItem::setEDirection (T_e8_DiPOCallStateUpdateDirection eDirection_) {
    #ifndef NDEBUG
    if (!(T_e8_DiPOCallStateUpdateDirection_IsValid(eDirection_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eDirection_, "T_e8_DiPOCallStateUpdateDirection", "eDirection", "T_DiPOCallStateItem");
    }
    #endif
    set_has_eDirection();
    this->_eDirection = eDirection_;
}

inline void T_DiPOCallStateItem::clearSCallUUID() {
    if (hasSCallUUID()) {
         clear_has_sCallUUID();
        _sCallUUID.clear();
     }
}

inline bool T_DiPOCallStateItem::hasSCallUUID () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_DiPOCallStateItem::getSCallUUID () const {
    return _sCallUUID;
}

inline ::std::string& T_DiPOCallStateItem::getSCallUUIDMutable () {
    set_has_sCallUUID();
    return _sCallUUID;
}

inline void T_DiPOCallStateItem::setSCallUUID (const ::std::string& sCallUUID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCallUUID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCallUUID();
    this->_sCallUUID = sCallUUID_;
}

inline void T_DiPOCallStateItem::setSCallUUID (const char* sCallUUID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCallUUID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCallUUID();
    this->_sCallUUID.assign(sCallUUID_);
}

inline void T_DiPOCallStateItem::setSCallUUID (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCallUUID();
    this->_sCallUUID.assign(value, size);
}

inline void T_DiPOCallStateItem::clearSAddressBookID() {
    if (hasSAddressBookID()) {
         clear_has_sAddressBookID();
        _sAddressBookID.clear();
     }
}

inline bool T_DiPOCallStateItem::hasSAddressBookID () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_DiPOCallStateItem::getSAddressBookID () const {
    return _sAddressBookID;
}

inline ::std::string& T_DiPOCallStateItem::getSAddressBookIDMutable () {
    set_has_sAddressBookID();
    return _sAddressBookID;
}

inline void T_DiPOCallStateItem::setSAddressBookID (const ::std::string& sAddressBookID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAddressBookID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAddressBookID();
    this->_sAddressBookID = sAddressBookID_;
}

inline void T_DiPOCallStateItem::setSAddressBookID (const char* sAddressBookID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAddressBookID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAddressBookID();
    this->_sAddressBookID.assign(sAddressBookID_);
}

inline void T_DiPOCallStateItem::setSAddressBookID (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAddressBookID();
    this->_sAddressBookID.assign(value, size);
}

inline void T_DiPOCallStateItem::clearSLabel() {
    if (hasSLabel()) {
         clear_has_sLabel();
        _sLabel.clear();
     }
}

inline bool T_DiPOCallStateItem::hasSLabel () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& T_DiPOCallStateItem::getSLabel () const {
    return _sLabel;
}

inline ::std::string& T_DiPOCallStateItem::getSLabelMutable () {
    set_has_sLabel();
    return _sLabel;
}

inline void T_DiPOCallStateItem::setSLabel (const ::std::string& sLabel_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLabel();
    this->_sLabel = sLabel_;
}

inline void T_DiPOCallStateItem::setSLabel (const char* sLabel_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLabel();
    this->_sLabel.assign(sLabel_);
}

inline void T_DiPOCallStateItem::setSLabel (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLabel();
    this->_sLabel.assign(value, size);
}

inline void T_DiPOCallStateItem::clearEService() {
    if (hasEService()) {
         clear_has_eService();
        _eService = ::mplay_appcontrol_fi_types::T_e8_DiPOCallStateUpdateService__e8DIPO_CSEV_UNKNOWN;
     }
}

inline bool T_DiPOCallStateItem::hasEService () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline T_e8_DiPOCallStateUpdateService T_DiPOCallStateItem::getEService () const {
    return _eService;
}

inline void T_DiPOCallStateItem::setEService (T_e8_DiPOCallStateUpdateService eService_) {
    #ifndef NDEBUG
    if (!(T_e8_DiPOCallStateUpdateService_IsValid(eService_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eService_, "T_e8_DiPOCallStateUpdateService", "eService", "T_DiPOCallStateItem");
    }
    #endif
    set_has_eService();
    this->_eService = eService_;
}

inline void T_DiPOCallStateItem::clearBIsConferenced() {
    if (hasBIsConferenced()) {
         clear_has_bIsConferenced();
        _bIsConferenced = false;
     }
}

inline bool T_DiPOCallStateItem::hasBIsConferenced () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline bool T_DiPOCallStateItem::getBIsConferenced () const {
    return _bIsConferenced;
}

inline void T_DiPOCallStateItem::setBIsConferenced (bool bIsConferenced_) {
    set_has_bIsConferenced();
    this->_bIsConferenced = bIsConferenced_;
}

inline void T_DiPOCallStateItem::clearU8ConferenceGroup() {
    if (hasU8ConferenceGroup()) {
         clear_has_u8ConferenceGroup();
        _u8ConferenceGroup = 0u;
     }
}

inline bool T_DiPOCallStateItem::hasU8ConferenceGroup () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline uint8 T_DiPOCallStateItem::getU8ConferenceGroup () const {
    return _u8ConferenceGroup;
}

inline void T_DiPOCallStateItem::setU8ConferenceGroup (uint8 u8ConferenceGroup_) {
    set_has_u8ConferenceGroup();
    this->_u8ConferenceGroup = u8ConferenceGroup_;
}

inline void T_DiPOCallStateItem::clearEDisconnectReason() {
    if (hasEDisconnectReason()) {
         clear_has_eDisconnectReason();
        _eDisconnectReason = ::mplay_appcontrol_fi_types::T_e8_DiPOCallStateUpdateDisconnectReason__e8DIPO_CSDR_ENDED;
     }
}

inline bool T_DiPOCallStateItem::hasEDisconnectReason () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline T_e8_DiPOCallStateUpdateDisconnectReason T_DiPOCallStateItem::getEDisconnectReason () const {
    return _eDisconnectReason;
}

inline void T_DiPOCallStateItem::setEDisconnectReason (T_e8_DiPOCallStateUpdateDisconnectReason eDisconnectReason_) {
    #ifndef NDEBUG
    if (!(T_e8_DiPOCallStateUpdateDisconnectReason_IsValid(eDisconnectReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eDisconnectReason_, "T_e8_DiPOCallStateUpdateDisconnectReason", "eDisconnectReason", "T_DiPOCallStateItem");
    }
    #endif
    set_has_eDisconnectReason();
    this->_eDisconnectReason = eDisconnectReason_;
}

inline void T_DiPOCallStateItem::clearU64StartTimestamp() {
    if (hasU64StartTimestamp()) {
         clear_has_u64StartTimestamp();
        _u64StartTimestamp = 0u;
     }
}

inline bool T_DiPOCallStateItem::hasU64StartTimestamp () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline uint64 T_DiPOCallStateItem::getU64StartTimestamp () const {
    return _u64StartTimestamp;
}

inline void T_DiPOCallStateItem::setU64StartTimestamp (uint64 u64StartTimestamp_) {
    set_has_u64StartTimestamp();
    this->_u64StartTimestamp = u64StartTimestamp_;
}

inline void T_DiPOCallStateItem::set_has_sRemoteID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DiPOCallStateItem::clear_has_sRemoteID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DiPOCallStateItem::set_has_sDisplayName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DiPOCallStateItem::clear_has_sDisplayName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DiPOCallStateItem::set_has_eStatus () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DiPOCallStateItem::clear_has_eStatus () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_DiPOCallStateItem::set_has_eDirection () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_DiPOCallStateItem::clear_has_eDirection () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_DiPOCallStateItem::set_has_sCallUUID () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_DiPOCallStateItem::clear_has_sCallUUID () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_DiPOCallStateItem::set_has_sAddressBookID () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_DiPOCallStateItem::clear_has_sAddressBookID () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_DiPOCallStateItem::set_has_sLabel () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_DiPOCallStateItem::clear_has_sLabel () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_DiPOCallStateItem::set_has_eService () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_DiPOCallStateItem::clear_has_eService () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_DiPOCallStateItem::set_has_bIsConferenced () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_DiPOCallStateItem::clear_has_bIsConferenced () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_DiPOCallStateItem::set_has_u8ConferenceGroup () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_DiPOCallStateItem::clear_has_u8ConferenceGroup () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_DiPOCallStateItem::set_has_eDisconnectReason () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_DiPOCallStateItem::clear_has_eDisconnectReason () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_DiPOCallStateItem::set_has_u64StartTimestamp () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_DiPOCallStateItem::clear_has_u64StartTimestamp () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline  T_RouteGuidanceDisplayComponentItem::T_RouteGuidanceDisplayComponentItem ()  :
    _Identifier (0u),
    _Name (),
    _MaxCurrentRoadNameLength (0u),
    _MaxDestinationNameLength (0u),
    _MaxAfterManeuverRoadNameLength (0u),
    _MaxManeuverDescriptionLength (0u),
    _MaxGuidanceManeuverCapacity (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_RouteGuidanceDisplayComponentItem::T_RouteGuidanceDisplayComponentItem (const T_RouteGuidanceDisplayComponentItem &rhs)  :
    _Identifier (0u),
    _Name (),
    _MaxCurrentRoadNameLength (0u),
    _MaxDestinationNameLength (0u),
    _MaxAfterManeuverRoadNameLength (0u),
    _MaxManeuverDescriptionLength (0u),
    _MaxGuidanceManeuverCapacity (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_RouteGuidanceDisplayComponentItem::T_RouteGuidanceDisplayComponentItem (uint16 Identifier_, const ::std::string& Name_, uint16 MaxCurrentRoadNameLength_, uint16 MaxDestinationNameLength_, uint16 MaxAfterManeuverRoadNameLength_, uint16 MaxManeuverDescriptionLength_, uint16 MaxGuidanceManeuverCapacity_)  :
    _Identifier (Identifier_),
    _Name (Name_),
    _MaxCurrentRoadNameLength (MaxCurrentRoadNameLength_),
    _MaxDestinationNameLength (MaxDestinationNameLength_),
    _MaxAfterManeuverRoadNameLength (MaxAfterManeuverRoadNameLength_),
    _MaxManeuverDescriptionLength (MaxManeuverDescriptionLength_),
    _MaxGuidanceManeuverCapacity (MaxGuidanceManeuverCapacity_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_RouteGuidanceDisplayComponentItem::~T_RouteGuidanceDisplayComponentItem() {
}

inline T_RouteGuidanceDisplayComponentItem& T_RouteGuidanceDisplayComponentItem::operator = (const T_RouteGuidanceDisplayComponentItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasIdentifier()) {
            setIdentifier(rhs.getIdentifier());
        } else {
            clearIdentifier();
        }
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasMaxCurrentRoadNameLength()) {
            setMaxCurrentRoadNameLength(rhs.getMaxCurrentRoadNameLength());
        } else {
            clearMaxCurrentRoadNameLength();
        }
        if (rhs.hasMaxDestinationNameLength()) {
            setMaxDestinationNameLength(rhs.getMaxDestinationNameLength());
        } else {
            clearMaxDestinationNameLength();
        }
        if (rhs.hasMaxAfterManeuverRoadNameLength()) {
            setMaxAfterManeuverRoadNameLength(rhs.getMaxAfterManeuverRoadNameLength());
        } else {
            clearMaxAfterManeuverRoadNameLength();
        }
        if (rhs.hasMaxManeuverDescriptionLength()) {
            setMaxManeuverDescriptionLength(rhs.getMaxManeuverDescriptionLength());
        } else {
            clearMaxManeuverDescriptionLength();
        }
        if (rhs.hasMaxGuidanceManeuverCapacity()) {
            setMaxGuidanceManeuverCapacity(rhs.getMaxGuidanceManeuverCapacity());
        } else {
            clearMaxGuidanceManeuverCapacity();
        }
    }
    return *this;
}

inline bool T_RouteGuidanceDisplayComponentItem::operator == (const T_RouteGuidanceDisplayComponentItem& rhs) const {
    return (((!hasIdentifier() && !rhs.hasIdentifier()) || getIdentifier() == rhs.getIdentifier()) &&
        ((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasMaxCurrentRoadNameLength() && !rhs.hasMaxCurrentRoadNameLength()) || getMaxCurrentRoadNameLength() == rhs.getMaxCurrentRoadNameLength()) &&
        ((!hasMaxDestinationNameLength() && !rhs.hasMaxDestinationNameLength()) || getMaxDestinationNameLength() == rhs.getMaxDestinationNameLength()) &&
        ((!hasMaxAfterManeuverRoadNameLength() && !rhs.hasMaxAfterManeuverRoadNameLength()) || getMaxAfterManeuverRoadNameLength() == rhs.getMaxAfterManeuverRoadNameLength()) &&
        ((!hasMaxManeuverDescriptionLength() && !rhs.hasMaxManeuverDescriptionLength()) || getMaxManeuverDescriptionLength() == rhs.getMaxManeuverDescriptionLength()) &&
        ((!hasMaxGuidanceManeuverCapacity() && !rhs.hasMaxGuidanceManeuverCapacity()) || getMaxGuidanceManeuverCapacity() == rhs.getMaxGuidanceManeuverCapacity()));
}

inline bool T_RouteGuidanceDisplayComponentItem::operator != (const T_RouteGuidanceDisplayComponentItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_RouteGuidanceDisplayComponentItem::operator < (const T_RouteGuidanceDisplayComponentItem& rhs) const {
    if (hasIdentifier() || rhs.hasIdentifier()) {
        if (getIdentifier() < rhs.getIdentifier()) return true;
        if (getIdentifier() > rhs.getIdentifier()) return false;
    }
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasMaxCurrentRoadNameLength() || rhs.hasMaxCurrentRoadNameLength()) {
        if (getMaxCurrentRoadNameLength() < rhs.getMaxCurrentRoadNameLength()) return true;
        if (getMaxCurrentRoadNameLength() > rhs.getMaxCurrentRoadNameLength()) return false;
    }
    if (hasMaxDestinationNameLength() || rhs.hasMaxDestinationNameLength()) {
        if (getMaxDestinationNameLength() < rhs.getMaxDestinationNameLength()) return true;
        if (getMaxDestinationNameLength() > rhs.getMaxDestinationNameLength()) return false;
    }
    if (hasMaxAfterManeuverRoadNameLength() || rhs.hasMaxAfterManeuverRoadNameLength()) {
        if (getMaxAfterManeuverRoadNameLength() < rhs.getMaxAfterManeuverRoadNameLength()) return true;
        if (getMaxAfterManeuverRoadNameLength() > rhs.getMaxAfterManeuverRoadNameLength()) return false;
    }
    if (hasMaxManeuverDescriptionLength() || rhs.hasMaxManeuverDescriptionLength()) {
        if (getMaxManeuverDescriptionLength() < rhs.getMaxManeuverDescriptionLength()) return true;
        if (getMaxManeuverDescriptionLength() > rhs.getMaxManeuverDescriptionLength()) return false;
    }
    if (hasMaxGuidanceManeuverCapacity() || rhs.hasMaxGuidanceManeuverCapacity()) {
        if (getMaxGuidanceManeuverCapacity() < rhs.getMaxGuidanceManeuverCapacity()) return true;
        if (getMaxGuidanceManeuverCapacity() > rhs.getMaxGuidanceManeuverCapacity()) return false;
    }
    return false;
}

inline bool T_RouteGuidanceDisplayComponentItem::operator > (const T_RouteGuidanceDisplayComponentItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_RouteGuidanceDisplayComponentItem::clear() {
    clearIdentifier();
    clearName();
    clearMaxCurrentRoadNameLength();
    clearMaxDestinationNameLength();
    clearMaxAfterManeuverRoadNameLength();
    clearMaxManeuverDescriptionLength();
    clearMaxGuidanceManeuverCapacity();
}

inline void T_RouteGuidanceDisplayComponentItem::clearIdentifier() {
    if (hasIdentifier()) {
         clear_has_Identifier();
        _Identifier = 0u;
     }
}

inline bool T_RouteGuidanceDisplayComponentItem::hasIdentifier () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_RouteGuidanceDisplayComponentItem::getIdentifier () const {
    return _Identifier;
}

inline void T_RouteGuidanceDisplayComponentItem::setIdentifier (uint16 Identifier_) {
    set_has_Identifier();
    this->_Identifier = Identifier_;
}

inline void T_RouteGuidanceDisplayComponentItem::clearName() {
    if (hasName()) {
         clear_has_Name();
        _Name.clear();
     }
}

inline bool T_RouteGuidanceDisplayComponentItem::hasName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_RouteGuidanceDisplayComponentItem::getName () const {
    return _Name;
}

inline ::std::string& T_RouteGuidanceDisplayComponentItem::getNameMutable () {
    set_has_Name();
    return _Name;
}

inline void T_RouteGuidanceDisplayComponentItem::setName (const ::std::string& Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name = Name_;
}

inline void T_RouteGuidanceDisplayComponentItem::setName (const char* Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name.assign(Name_);
}

inline void T_RouteGuidanceDisplayComponentItem::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name.assign(value, size);
}

inline void T_RouteGuidanceDisplayComponentItem::clearMaxCurrentRoadNameLength() {
    if (hasMaxCurrentRoadNameLength()) {
         clear_has_MaxCurrentRoadNameLength();
        _MaxCurrentRoadNameLength = 0u;
     }
}

inline bool T_RouteGuidanceDisplayComponentItem::hasMaxCurrentRoadNameLength () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_RouteGuidanceDisplayComponentItem::getMaxCurrentRoadNameLength () const {
    return _MaxCurrentRoadNameLength;
}

inline void T_RouteGuidanceDisplayComponentItem::setMaxCurrentRoadNameLength (uint16 MaxCurrentRoadNameLength_) {
    set_has_MaxCurrentRoadNameLength();
    this->_MaxCurrentRoadNameLength = MaxCurrentRoadNameLength_;
}

inline void T_RouteGuidanceDisplayComponentItem::clearMaxDestinationNameLength() {
    if (hasMaxDestinationNameLength()) {
         clear_has_MaxDestinationNameLength();
        _MaxDestinationNameLength = 0u;
     }
}

inline bool T_RouteGuidanceDisplayComponentItem::hasMaxDestinationNameLength () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 T_RouteGuidanceDisplayComponentItem::getMaxDestinationNameLength () const {
    return _MaxDestinationNameLength;
}

inline void T_RouteGuidanceDisplayComponentItem::setMaxDestinationNameLength (uint16 MaxDestinationNameLength_) {
    set_has_MaxDestinationNameLength();
    this->_MaxDestinationNameLength = MaxDestinationNameLength_;
}

inline void T_RouteGuidanceDisplayComponentItem::clearMaxAfterManeuverRoadNameLength() {
    if (hasMaxAfterManeuverRoadNameLength()) {
         clear_has_MaxAfterManeuverRoadNameLength();
        _MaxAfterManeuverRoadNameLength = 0u;
     }
}

inline bool T_RouteGuidanceDisplayComponentItem::hasMaxAfterManeuverRoadNameLength () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint16 T_RouteGuidanceDisplayComponentItem::getMaxAfterManeuverRoadNameLength () const {
    return _MaxAfterManeuverRoadNameLength;
}

inline void T_RouteGuidanceDisplayComponentItem::setMaxAfterManeuverRoadNameLength (uint16 MaxAfterManeuverRoadNameLength_) {
    set_has_MaxAfterManeuverRoadNameLength();
    this->_MaxAfterManeuverRoadNameLength = MaxAfterManeuverRoadNameLength_;
}

inline void T_RouteGuidanceDisplayComponentItem::clearMaxManeuverDescriptionLength() {
    if (hasMaxManeuverDescriptionLength()) {
         clear_has_MaxManeuverDescriptionLength();
        _MaxManeuverDescriptionLength = 0u;
     }
}

inline bool T_RouteGuidanceDisplayComponentItem::hasMaxManeuverDescriptionLength () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint16 T_RouteGuidanceDisplayComponentItem::getMaxManeuverDescriptionLength () const {
    return _MaxManeuverDescriptionLength;
}

inline void T_RouteGuidanceDisplayComponentItem::setMaxManeuverDescriptionLength (uint16 MaxManeuverDescriptionLength_) {
    set_has_MaxManeuverDescriptionLength();
    this->_MaxManeuverDescriptionLength = MaxManeuverDescriptionLength_;
}

inline void T_RouteGuidanceDisplayComponentItem::clearMaxGuidanceManeuverCapacity() {
    if (hasMaxGuidanceManeuverCapacity()) {
         clear_has_MaxGuidanceManeuverCapacity();
        _MaxGuidanceManeuverCapacity = 0u;
     }
}

inline bool T_RouteGuidanceDisplayComponentItem::hasMaxGuidanceManeuverCapacity () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint16 T_RouteGuidanceDisplayComponentItem::getMaxGuidanceManeuverCapacity () const {
    return _MaxGuidanceManeuverCapacity;
}

inline void T_RouteGuidanceDisplayComponentItem::setMaxGuidanceManeuverCapacity (uint16 MaxGuidanceManeuverCapacity_) {
    set_has_MaxGuidanceManeuverCapacity();
    this->_MaxGuidanceManeuverCapacity = MaxGuidanceManeuverCapacity_;
}

inline void T_RouteGuidanceDisplayComponentItem::set_has_Identifier () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_RouteGuidanceDisplayComponentItem::clear_has_Identifier () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_RouteGuidanceDisplayComponentItem::set_has_Name () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_RouteGuidanceDisplayComponentItem::clear_has_Name () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_RouteGuidanceDisplayComponentItem::set_has_MaxCurrentRoadNameLength () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_RouteGuidanceDisplayComponentItem::clear_has_MaxCurrentRoadNameLength () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_RouteGuidanceDisplayComponentItem::set_has_MaxDestinationNameLength () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_RouteGuidanceDisplayComponentItem::clear_has_MaxDestinationNameLength () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_RouteGuidanceDisplayComponentItem::set_has_MaxAfterManeuverRoadNameLength () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_RouteGuidanceDisplayComponentItem::clear_has_MaxAfterManeuverRoadNameLength () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_RouteGuidanceDisplayComponentItem::set_has_MaxManeuverDescriptionLength () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_RouteGuidanceDisplayComponentItem::clear_has_MaxManeuverDescriptionLength () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_RouteGuidanceDisplayComponentItem::set_has_MaxGuidanceManeuverCapacity () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_RouteGuidanceDisplayComponentItem::clear_has_MaxGuidanceManeuverCapacity () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_RouteGuidanceUpdate::T_RouteGuidanceUpdate ()  :
    _bRouteGuidanceDisplayComponentIDsAvailable (false),
    _RouteGuidanceDisplayComponentIDs (),
    _bRouteGuidanceStateAvailable (false),
    _e8RouteGuidanceState (::mplay_appcontrol_fi_types::T_e8_RouteGuidanceState__e8DIPO_ROUTE_GUIDANCE_STATE_NO_ROUTE_SET),
    _bManeuverStateAvailable (false),
    _e8ManeuverState (::mplay_appcontrol_fi_types::T_e8_ManeuverState__e8DIPO_MANEUVER_STATE_CONTINUE),
    _bCurrentRoadNameAvailable (false),
    _CurrentRoadName (),
    _bDestinationNameAvailable (false),
    _DestinationName (),
    _bEstimatedTimeOfArrivalAvailable (false),
    _EstimatedTimeOfArrival (0u),
    _bTimeRemainingToDestinationAvailable (false),
    _TimeRemainingToDestination (0u),
    _bDistanceRemainingAvailable (false),
    _DistanceRemaining (0u),
    _bDistanceRemainingDisplayStrAvailable (false),
    _DistanceRemainingDisplayStr (),
    _bDistanceRemainingDisplayUnitsAvailable (false),
    _e8DistanceRemainingDisplayUnits (::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_KM),
    _bDistanceToNextManeuverAvailable (false),
    _DistanceToNextManeuver (0u),
    _bDistanceToNextManeuverDisplayStrAvailable (false),
    _DistanceToNextManeuverDisplayStr (),
    _bDistanceToNextManeuverDisplayUnitsAvailable (false),
    _e8DistanceToNextManeuverDisplayUnits (::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_KM),
    _bRouteGuidanceManeuverCurrentListAvailable (false),
    _RouteGuidanceManeuverCurrentList (),
    _bRouteGuidanceManeuverCountAvailable (false),
    _RouteGuidanceManeuverCount (0u),
    _bRouteGuidanceVisibleInAppAvailable (false),
    _RouteGuidanceVisibleInApp (false),
    _bSourceNameAvailable (false),
    _SourceName (),
    _bSourceSupportsRouteGuidanceAvailable (false),
    _SourceSupportsRouteGuidance (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_RouteGuidanceUpdate::T_RouteGuidanceUpdate (const T_RouteGuidanceUpdate &rhs)  :
    _bRouteGuidanceDisplayComponentIDsAvailable (false),
    _RouteGuidanceDisplayComponentIDs (),
    _bRouteGuidanceStateAvailable (false),
    _e8RouteGuidanceState (::mplay_appcontrol_fi_types::T_e8_RouteGuidanceState__e8DIPO_ROUTE_GUIDANCE_STATE_NO_ROUTE_SET),
    _bManeuverStateAvailable (false),
    _e8ManeuverState (::mplay_appcontrol_fi_types::T_e8_ManeuverState__e8DIPO_MANEUVER_STATE_CONTINUE),
    _bCurrentRoadNameAvailable (false),
    _CurrentRoadName (),
    _bDestinationNameAvailable (false),
    _DestinationName (),
    _bEstimatedTimeOfArrivalAvailable (false),
    _EstimatedTimeOfArrival (0u),
    _bTimeRemainingToDestinationAvailable (false),
    _TimeRemainingToDestination (0u),
    _bDistanceRemainingAvailable (false),
    _DistanceRemaining (0u),
    _bDistanceRemainingDisplayStrAvailable (false),
    _DistanceRemainingDisplayStr (),
    _bDistanceRemainingDisplayUnitsAvailable (false),
    _e8DistanceRemainingDisplayUnits (::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_KM),
    _bDistanceToNextManeuverAvailable (false),
    _DistanceToNextManeuver (0u),
    _bDistanceToNextManeuverDisplayStrAvailable (false),
    _DistanceToNextManeuverDisplayStr (),
    _bDistanceToNextManeuverDisplayUnitsAvailable (false),
    _e8DistanceToNextManeuverDisplayUnits (::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_KM),
    _bRouteGuidanceManeuverCurrentListAvailable (false),
    _RouteGuidanceManeuverCurrentList (),
    _bRouteGuidanceManeuverCountAvailable (false),
    _RouteGuidanceManeuverCount (0u),
    _bRouteGuidanceVisibleInAppAvailable (false),
    _RouteGuidanceVisibleInApp (false),
    _bSourceNameAvailable (false),
    _SourceName (),
    _bSourceSupportsRouteGuidanceAvailable (false),
    _SourceSupportsRouteGuidance (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_RouteGuidanceUpdate::T_RouteGuidanceUpdate (bool bRouteGuidanceDisplayComponentIDsAvailable_, const T_RouteGuidanceDisplayComponentIDs& RouteGuidanceDisplayComponentIDs_, bool bRouteGuidanceStateAvailable_, T_e8_RouteGuidanceState e8RouteGuidanceState_, bool bManeuverStateAvailable_, T_e8_ManeuverState e8ManeuverState_, bool bCurrentRoadNameAvailable_, const ::std::string& CurrentRoadName_, bool bDestinationNameAvailable_, const ::std::string& DestinationName_, bool bEstimatedTimeOfArrivalAvailable_, uint64 EstimatedTimeOfArrival_, bool bTimeRemainingToDestinationAvailable_, uint64 TimeRemainingToDestination_, bool bDistanceRemainingAvailable_, uint32 DistanceRemaining_, bool bDistanceRemainingDisplayStrAvailable_, const ::std::string& DistanceRemainingDisplayStr_, bool bDistanceRemainingDisplayUnitsAvailable_, T_e8_DistanceDisplayUnits e8DistanceRemainingDisplayUnits_, bool bDistanceToNextManeuverAvailable_, uint32 DistanceToNextManeuver_, bool bDistanceToNextManeuverDisplayStrAvailable_, const ::std::string& DistanceToNextManeuverDisplayStr_, bool bDistanceToNextManeuverDisplayUnitsAvailable_, T_e8_DistanceDisplayUnits e8DistanceToNextManeuverDisplayUnits_, bool bRouteGuidanceManeuverCurrentListAvailable_, const T_RouteGuidanceManeuverCurrentList& RouteGuidanceManeuverCurrentList_, bool bRouteGuidanceManeuverCountAvailable_, uint16 RouteGuidanceManeuverCount_, bool bRouteGuidanceVisibleInAppAvailable_, bool RouteGuidanceVisibleInApp_, bool bSourceNameAvailable_, const ::std::string& SourceName_, bool bSourceSupportsRouteGuidanceAvailable_, bool SourceSupportsRouteGuidance_)  :
    _bRouteGuidanceDisplayComponentIDsAvailable (bRouteGuidanceDisplayComponentIDsAvailable_),
    _RouteGuidanceDisplayComponentIDs (RouteGuidanceDisplayComponentIDs_),
    _bRouteGuidanceStateAvailable (bRouteGuidanceStateAvailable_),
    _e8RouteGuidanceState (e8RouteGuidanceState_),
    _bManeuverStateAvailable (bManeuverStateAvailable_),
    _e8ManeuverState (e8ManeuverState_),
    _bCurrentRoadNameAvailable (bCurrentRoadNameAvailable_),
    _CurrentRoadName (CurrentRoadName_),
    _bDestinationNameAvailable (bDestinationNameAvailable_),
    _DestinationName (DestinationName_),
    _bEstimatedTimeOfArrivalAvailable (bEstimatedTimeOfArrivalAvailable_),
    _EstimatedTimeOfArrival (EstimatedTimeOfArrival_),
    _bTimeRemainingToDestinationAvailable (bTimeRemainingToDestinationAvailable_),
    _TimeRemainingToDestination (TimeRemainingToDestination_),
    _bDistanceRemainingAvailable (bDistanceRemainingAvailable_),
    _DistanceRemaining (DistanceRemaining_),
    _bDistanceRemainingDisplayStrAvailable (bDistanceRemainingDisplayStrAvailable_),
    _DistanceRemainingDisplayStr (DistanceRemainingDisplayStr_),
    _bDistanceRemainingDisplayUnitsAvailable (bDistanceRemainingDisplayUnitsAvailable_),
    _e8DistanceRemainingDisplayUnits (e8DistanceRemainingDisplayUnits_),
    _bDistanceToNextManeuverAvailable (bDistanceToNextManeuverAvailable_),
    _DistanceToNextManeuver (DistanceToNextManeuver_),
    _bDistanceToNextManeuverDisplayStrAvailable (bDistanceToNextManeuverDisplayStrAvailable_),
    _DistanceToNextManeuverDisplayStr (DistanceToNextManeuverDisplayStr_),
    _bDistanceToNextManeuverDisplayUnitsAvailable (bDistanceToNextManeuverDisplayUnitsAvailable_),
    _e8DistanceToNextManeuverDisplayUnits (e8DistanceToNextManeuverDisplayUnits_),
    _bRouteGuidanceManeuverCurrentListAvailable (bRouteGuidanceManeuverCurrentListAvailable_),
    _RouteGuidanceManeuverCurrentList (RouteGuidanceManeuverCurrentList_),
    _bRouteGuidanceManeuverCountAvailable (bRouteGuidanceManeuverCountAvailable_),
    _RouteGuidanceManeuverCount (RouteGuidanceManeuverCount_),
    _bRouteGuidanceVisibleInAppAvailable (bRouteGuidanceVisibleInAppAvailable_),
    _RouteGuidanceVisibleInApp (RouteGuidanceVisibleInApp_),
    _bSourceNameAvailable (bSourceNameAvailable_),
    _SourceName (SourceName_),
    _bSourceSupportsRouteGuidanceAvailable (bSourceSupportsRouteGuidanceAvailable_),
    _SourceSupportsRouteGuidance (SourceSupportsRouteGuidance_)
{
    #ifndef NDEBUG
    if (!(T_e8_RouteGuidanceState_IsValid(e8RouteGuidanceState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8RouteGuidanceState_, "T_e8_RouteGuidanceState", "e8RouteGuidanceState", "T_RouteGuidanceUpdate");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_ManeuverState_IsValid(e8ManeuverState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ManeuverState_, "T_e8_ManeuverState", "e8ManeuverState", "T_RouteGuidanceUpdate");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CurrentRoadName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestinationName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DistanceRemainingDisplayStr_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_DistanceDisplayUnits_IsValid(e8DistanceRemainingDisplayUnits_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DistanceRemainingDisplayUnits_, "T_e8_DistanceDisplayUnits", "e8DistanceRemainingDisplayUnits", "T_RouteGuidanceUpdate");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DistanceToNextManeuverDisplayStr_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_DistanceDisplayUnits_IsValid(e8DistanceToNextManeuverDisplayUnits_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DistanceToNextManeuverDisplayUnits_, "T_e8_DistanceDisplayUnits", "e8DistanceToNextManeuverDisplayUnits", "T_RouteGuidanceUpdate");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SourceName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_RouteGuidanceUpdate::~T_RouteGuidanceUpdate() {
}

inline T_RouteGuidanceUpdate& T_RouteGuidanceUpdate::operator = (const T_RouteGuidanceUpdate& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBRouteGuidanceDisplayComponentIDsAvailable()) {
            setBRouteGuidanceDisplayComponentIDsAvailable(rhs.getBRouteGuidanceDisplayComponentIDsAvailable());
        } else {
            clearBRouteGuidanceDisplayComponentIDsAvailable();
        }
        if (rhs.hasRouteGuidanceDisplayComponentIDs()) {
            setRouteGuidanceDisplayComponentIDs(rhs.getRouteGuidanceDisplayComponentIDs());
        } else {
            clearRouteGuidanceDisplayComponentIDs();
        }
        if (rhs.hasBRouteGuidanceStateAvailable()) {
            setBRouteGuidanceStateAvailable(rhs.getBRouteGuidanceStateAvailable());
        } else {
            clearBRouteGuidanceStateAvailable();
        }
        if (rhs.hasE8RouteGuidanceState()) {
            setE8RouteGuidanceState(rhs.getE8RouteGuidanceState());
        } else {
            clearE8RouteGuidanceState();
        }
        if (rhs.hasBManeuverStateAvailable()) {
            setBManeuverStateAvailable(rhs.getBManeuverStateAvailable());
        } else {
            clearBManeuverStateAvailable();
        }
        if (rhs.hasE8ManeuverState()) {
            setE8ManeuverState(rhs.getE8ManeuverState());
        } else {
            clearE8ManeuverState();
        }
        if (rhs.hasBCurrentRoadNameAvailable()) {
            setBCurrentRoadNameAvailable(rhs.getBCurrentRoadNameAvailable());
        } else {
            clearBCurrentRoadNameAvailable();
        }
        if (rhs.hasCurrentRoadName()) {
            setCurrentRoadName(rhs.getCurrentRoadName());
        } else {
            clearCurrentRoadName();
        }
        if (rhs.hasBDestinationNameAvailable()) {
            setBDestinationNameAvailable(rhs.getBDestinationNameAvailable());
        } else {
            clearBDestinationNameAvailable();
        }
        if (rhs.hasDestinationName()) {
            setDestinationName(rhs.getDestinationName());
        } else {
            clearDestinationName();
        }
        if (rhs.hasBEstimatedTimeOfArrivalAvailable()) {
            setBEstimatedTimeOfArrivalAvailable(rhs.getBEstimatedTimeOfArrivalAvailable());
        } else {
            clearBEstimatedTimeOfArrivalAvailable();
        }
        if (rhs.hasEstimatedTimeOfArrival()) {
            setEstimatedTimeOfArrival(rhs.getEstimatedTimeOfArrival());
        } else {
            clearEstimatedTimeOfArrival();
        }
        if (rhs.hasBTimeRemainingToDestinationAvailable()) {
            setBTimeRemainingToDestinationAvailable(rhs.getBTimeRemainingToDestinationAvailable());
        } else {
            clearBTimeRemainingToDestinationAvailable();
        }
        if (rhs.hasTimeRemainingToDestination()) {
            setTimeRemainingToDestination(rhs.getTimeRemainingToDestination());
        } else {
            clearTimeRemainingToDestination();
        }
        if (rhs.hasBDistanceRemainingAvailable()) {
            setBDistanceRemainingAvailable(rhs.getBDistanceRemainingAvailable());
        } else {
            clearBDistanceRemainingAvailable();
        }
        if (rhs.hasDistanceRemaining()) {
            setDistanceRemaining(rhs.getDistanceRemaining());
        } else {
            clearDistanceRemaining();
        }
        if (rhs.hasBDistanceRemainingDisplayStrAvailable()) {
            setBDistanceRemainingDisplayStrAvailable(rhs.getBDistanceRemainingDisplayStrAvailable());
        } else {
            clearBDistanceRemainingDisplayStrAvailable();
        }
        if (rhs.hasDistanceRemainingDisplayStr()) {
            setDistanceRemainingDisplayStr(rhs.getDistanceRemainingDisplayStr());
        } else {
            clearDistanceRemainingDisplayStr();
        }
        if (rhs.hasBDistanceRemainingDisplayUnitsAvailable()) {
            setBDistanceRemainingDisplayUnitsAvailable(rhs.getBDistanceRemainingDisplayUnitsAvailable());
        } else {
            clearBDistanceRemainingDisplayUnitsAvailable();
        }
        if (rhs.hasE8DistanceRemainingDisplayUnits()) {
            setE8DistanceRemainingDisplayUnits(rhs.getE8DistanceRemainingDisplayUnits());
        } else {
            clearE8DistanceRemainingDisplayUnits();
        }
        if (rhs.hasBDistanceToNextManeuverAvailable()) {
            setBDistanceToNextManeuverAvailable(rhs.getBDistanceToNextManeuverAvailable());
        } else {
            clearBDistanceToNextManeuverAvailable();
        }
        if (rhs.hasDistanceToNextManeuver()) {
            setDistanceToNextManeuver(rhs.getDistanceToNextManeuver());
        } else {
            clearDistanceToNextManeuver();
        }
        if (rhs.hasBDistanceToNextManeuverDisplayStrAvailable()) {
            setBDistanceToNextManeuverDisplayStrAvailable(rhs.getBDistanceToNextManeuverDisplayStrAvailable());
        } else {
            clearBDistanceToNextManeuverDisplayStrAvailable();
        }
        if (rhs.hasDistanceToNextManeuverDisplayStr()) {
            setDistanceToNextManeuverDisplayStr(rhs.getDistanceToNextManeuverDisplayStr());
        } else {
            clearDistanceToNextManeuverDisplayStr();
        }
        if (rhs.hasBDistanceToNextManeuverDisplayUnitsAvailable()) {
            setBDistanceToNextManeuverDisplayUnitsAvailable(rhs.getBDistanceToNextManeuverDisplayUnitsAvailable());
        } else {
            clearBDistanceToNextManeuverDisplayUnitsAvailable();
        }
        if (rhs.hasE8DistanceToNextManeuverDisplayUnits()) {
            setE8DistanceToNextManeuverDisplayUnits(rhs.getE8DistanceToNextManeuverDisplayUnits());
        } else {
            clearE8DistanceToNextManeuverDisplayUnits();
        }
        if (rhs.hasBRouteGuidanceManeuverCurrentListAvailable()) {
            setBRouteGuidanceManeuverCurrentListAvailable(rhs.getBRouteGuidanceManeuverCurrentListAvailable());
        } else {
            clearBRouteGuidanceManeuverCurrentListAvailable();
        }
        if (rhs.hasRouteGuidanceManeuverCurrentList()) {
            setRouteGuidanceManeuverCurrentList(rhs.getRouteGuidanceManeuverCurrentList());
        } else {
            clearRouteGuidanceManeuverCurrentList();
        }
        if (rhs.hasBRouteGuidanceManeuverCountAvailable()) {
            setBRouteGuidanceManeuverCountAvailable(rhs.getBRouteGuidanceManeuverCountAvailable());
        } else {
            clearBRouteGuidanceManeuverCountAvailable();
        }
        if (rhs.hasRouteGuidanceManeuverCount()) {
            setRouteGuidanceManeuverCount(rhs.getRouteGuidanceManeuverCount());
        } else {
            clearRouteGuidanceManeuverCount();
        }
        if (rhs.hasBRouteGuidanceVisibleInAppAvailable()) {
            setBRouteGuidanceVisibleInAppAvailable(rhs.getBRouteGuidanceVisibleInAppAvailable());
        } else {
            clearBRouteGuidanceVisibleInAppAvailable();
        }
        if (rhs.hasRouteGuidanceVisibleInApp()) {
            setRouteGuidanceVisibleInApp(rhs.getRouteGuidanceVisibleInApp());
        } else {
            clearRouteGuidanceVisibleInApp();
        }
        if (rhs.hasBSourceNameAvailable()) {
            setBSourceNameAvailable(rhs.getBSourceNameAvailable());
        } else {
            clearBSourceNameAvailable();
        }
        if (rhs.hasSourceName()) {
            setSourceName(rhs.getSourceName());
        } else {
            clearSourceName();
        }
        if (rhs.hasBSourceSupportsRouteGuidanceAvailable()) {
            setBSourceSupportsRouteGuidanceAvailable(rhs.getBSourceSupportsRouteGuidanceAvailable());
        } else {
            clearBSourceSupportsRouteGuidanceAvailable();
        }
        if (rhs.hasSourceSupportsRouteGuidance()) {
            setSourceSupportsRouteGuidance(rhs.getSourceSupportsRouteGuidance());
        } else {
            clearSourceSupportsRouteGuidance();
        }
    }
    return *this;
}

inline bool T_RouteGuidanceUpdate::operator == (const T_RouteGuidanceUpdate& rhs) const {
    return (((!hasBRouteGuidanceDisplayComponentIDsAvailable() && !rhs.hasBRouteGuidanceDisplayComponentIDsAvailable()) || getBRouteGuidanceDisplayComponentIDsAvailable() == rhs.getBRouteGuidanceDisplayComponentIDsAvailable()) &&
        ((!hasRouteGuidanceDisplayComponentIDs() && !rhs.hasRouteGuidanceDisplayComponentIDs()) || getRouteGuidanceDisplayComponentIDs() == rhs.getRouteGuidanceDisplayComponentIDs()) &&
        ((!hasBRouteGuidanceStateAvailable() && !rhs.hasBRouteGuidanceStateAvailable()) || getBRouteGuidanceStateAvailable() == rhs.getBRouteGuidanceStateAvailable()) &&
        ((!hasE8RouteGuidanceState() && !rhs.hasE8RouteGuidanceState()) || getE8RouteGuidanceState() == rhs.getE8RouteGuidanceState()) &&
        ((!hasBManeuverStateAvailable() && !rhs.hasBManeuverStateAvailable()) || getBManeuverStateAvailable() == rhs.getBManeuverStateAvailable()) &&
        ((!hasE8ManeuverState() && !rhs.hasE8ManeuverState()) || getE8ManeuverState() == rhs.getE8ManeuverState()) &&
        ((!hasBCurrentRoadNameAvailable() && !rhs.hasBCurrentRoadNameAvailable()) || getBCurrentRoadNameAvailable() == rhs.getBCurrentRoadNameAvailable()) &&
        ((!hasCurrentRoadName() && !rhs.hasCurrentRoadName()) || getCurrentRoadName() == rhs.getCurrentRoadName()) &&
        ((!hasBDestinationNameAvailable() && !rhs.hasBDestinationNameAvailable()) || getBDestinationNameAvailable() == rhs.getBDestinationNameAvailable()) &&
        ((!hasDestinationName() && !rhs.hasDestinationName()) || getDestinationName() == rhs.getDestinationName()) &&
        ((!hasBEstimatedTimeOfArrivalAvailable() && !rhs.hasBEstimatedTimeOfArrivalAvailable()) || getBEstimatedTimeOfArrivalAvailable() == rhs.getBEstimatedTimeOfArrivalAvailable()) &&
        ((!hasEstimatedTimeOfArrival() && !rhs.hasEstimatedTimeOfArrival()) || getEstimatedTimeOfArrival() == rhs.getEstimatedTimeOfArrival()) &&
        ((!hasBTimeRemainingToDestinationAvailable() && !rhs.hasBTimeRemainingToDestinationAvailable()) || getBTimeRemainingToDestinationAvailable() == rhs.getBTimeRemainingToDestinationAvailable()) &&
        ((!hasTimeRemainingToDestination() && !rhs.hasTimeRemainingToDestination()) || getTimeRemainingToDestination() == rhs.getTimeRemainingToDestination()) &&
        ((!hasBDistanceRemainingAvailable() && !rhs.hasBDistanceRemainingAvailable()) || getBDistanceRemainingAvailable() == rhs.getBDistanceRemainingAvailable()) &&
        ((!hasDistanceRemaining() && !rhs.hasDistanceRemaining()) || getDistanceRemaining() == rhs.getDistanceRemaining()) &&
        ((!hasBDistanceRemainingDisplayStrAvailable() && !rhs.hasBDistanceRemainingDisplayStrAvailable()) || getBDistanceRemainingDisplayStrAvailable() == rhs.getBDistanceRemainingDisplayStrAvailable()) &&
        ((!hasDistanceRemainingDisplayStr() && !rhs.hasDistanceRemainingDisplayStr()) || getDistanceRemainingDisplayStr() == rhs.getDistanceRemainingDisplayStr()) &&
        ((!hasBDistanceRemainingDisplayUnitsAvailable() && !rhs.hasBDistanceRemainingDisplayUnitsAvailable()) || getBDistanceRemainingDisplayUnitsAvailable() == rhs.getBDistanceRemainingDisplayUnitsAvailable()) &&
        ((!hasE8DistanceRemainingDisplayUnits() && !rhs.hasE8DistanceRemainingDisplayUnits()) || getE8DistanceRemainingDisplayUnits() == rhs.getE8DistanceRemainingDisplayUnits()) &&
        ((!hasBDistanceToNextManeuverAvailable() && !rhs.hasBDistanceToNextManeuverAvailable()) || getBDistanceToNextManeuverAvailable() == rhs.getBDistanceToNextManeuverAvailable()) &&
        ((!hasDistanceToNextManeuver() && !rhs.hasDistanceToNextManeuver()) || getDistanceToNextManeuver() == rhs.getDistanceToNextManeuver()) &&
        ((!hasBDistanceToNextManeuverDisplayStrAvailable() && !rhs.hasBDistanceToNextManeuverDisplayStrAvailable()) || getBDistanceToNextManeuverDisplayStrAvailable() == rhs.getBDistanceToNextManeuverDisplayStrAvailable()) &&
        ((!hasDistanceToNextManeuverDisplayStr() && !rhs.hasDistanceToNextManeuverDisplayStr()) || getDistanceToNextManeuverDisplayStr() == rhs.getDistanceToNextManeuverDisplayStr()) &&
        ((!hasBDistanceToNextManeuverDisplayUnitsAvailable() && !rhs.hasBDistanceToNextManeuverDisplayUnitsAvailable()) || getBDistanceToNextManeuverDisplayUnitsAvailable() == rhs.getBDistanceToNextManeuverDisplayUnitsAvailable()) &&
        ((!hasE8DistanceToNextManeuverDisplayUnits() && !rhs.hasE8DistanceToNextManeuverDisplayUnits()) || getE8DistanceToNextManeuverDisplayUnits() == rhs.getE8DistanceToNextManeuverDisplayUnits()) &&
        ((!hasBRouteGuidanceManeuverCurrentListAvailable() && !rhs.hasBRouteGuidanceManeuverCurrentListAvailable()) || getBRouteGuidanceManeuverCurrentListAvailable() == rhs.getBRouteGuidanceManeuverCurrentListAvailable()) &&
        ((!hasRouteGuidanceManeuverCurrentList() && !rhs.hasRouteGuidanceManeuverCurrentList()) || getRouteGuidanceManeuverCurrentList() == rhs.getRouteGuidanceManeuverCurrentList()) &&
        ((!hasBRouteGuidanceManeuverCountAvailable() && !rhs.hasBRouteGuidanceManeuverCountAvailable()) || getBRouteGuidanceManeuverCountAvailable() == rhs.getBRouteGuidanceManeuverCountAvailable()) &&
        ((!hasRouteGuidanceManeuverCount() && !rhs.hasRouteGuidanceManeuverCount()) || getRouteGuidanceManeuverCount() == rhs.getRouteGuidanceManeuverCount()) &&
        ((!hasBRouteGuidanceVisibleInAppAvailable() && !rhs.hasBRouteGuidanceVisibleInAppAvailable()) || getBRouteGuidanceVisibleInAppAvailable() == rhs.getBRouteGuidanceVisibleInAppAvailable()) &&
        ((!hasRouteGuidanceVisibleInApp() && !rhs.hasRouteGuidanceVisibleInApp()) || getRouteGuidanceVisibleInApp() == rhs.getRouteGuidanceVisibleInApp()) &&
        ((!hasBSourceNameAvailable() && !rhs.hasBSourceNameAvailable()) || getBSourceNameAvailable() == rhs.getBSourceNameAvailable()) &&
        ((!hasSourceName() && !rhs.hasSourceName()) || getSourceName() == rhs.getSourceName()) &&
        ((!hasBSourceSupportsRouteGuidanceAvailable() && !rhs.hasBSourceSupportsRouteGuidanceAvailable()) || getBSourceSupportsRouteGuidanceAvailable() == rhs.getBSourceSupportsRouteGuidanceAvailable()) &&
        ((!hasSourceSupportsRouteGuidance() && !rhs.hasSourceSupportsRouteGuidance()) || getSourceSupportsRouteGuidance() == rhs.getSourceSupportsRouteGuidance()));
}

inline bool T_RouteGuidanceUpdate::operator != (const T_RouteGuidanceUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool T_RouteGuidanceUpdate::operator < (const T_RouteGuidanceUpdate& rhs) const {
    if (hasBRouteGuidanceDisplayComponentIDsAvailable() || rhs.hasBRouteGuidanceDisplayComponentIDsAvailable()) {
        if (getBRouteGuidanceDisplayComponentIDsAvailable() < rhs.getBRouteGuidanceDisplayComponentIDsAvailable()) return true;
        if (getBRouteGuidanceDisplayComponentIDsAvailable() > rhs.getBRouteGuidanceDisplayComponentIDsAvailable()) return false;
    }
    if (hasRouteGuidanceDisplayComponentIDs() || rhs.hasRouteGuidanceDisplayComponentIDs()) {
        if (getRouteGuidanceDisplayComponentIDs() < rhs.getRouteGuidanceDisplayComponentIDs()) return true;
        if (getRouteGuidanceDisplayComponentIDs() > rhs.getRouteGuidanceDisplayComponentIDs()) return false;
    }
    if (hasBRouteGuidanceStateAvailable() || rhs.hasBRouteGuidanceStateAvailable()) {
        if (getBRouteGuidanceStateAvailable() < rhs.getBRouteGuidanceStateAvailable()) return true;
        if (getBRouteGuidanceStateAvailable() > rhs.getBRouteGuidanceStateAvailable()) return false;
    }
    if (hasE8RouteGuidanceState() || rhs.hasE8RouteGuidanceState()) {
        if ((uint32)getE8RouteGuidanceState() < (uint32)rhs.getE8RouteGuidanceState()) return true;
        if ((uint32)getE8RouteGuidanceState() > (uint32)rhs.getE8RouteGuidanceState()) return false;
    }
    if (hasBManeuverStateAvailable() || rhs.hasBManeuverStateAvailable()) {
        if (getBManeuverStateAvailable() < rhs.getBManeuverStateAvailable()) return true;
        if (getBManeuverStateAvailable() > rhs.getBManeuverStateAvailable()) return false;
    }
    if (hasE8ManeuverState() || rhs.hasE8ManeuverState()) {
        if ((uint32)getE8ManeuverState() < (uint32)rhs.getE8ManeuverState()) return true;
        if ((uint32)getE8ManeuverState() > (uint32)rhs.getE8ManeuverState()) return false;
    }
    if (hasBCurrentRoadNameAvailable() || rhs.hasBCurrentRoadNameAvailable()) {
        if (getBCurrentRoadNameAvailable() < rhs.getBCurrentRoadNameAvailable()) return true;
        if (getBCurrentRoadNameAvailable() > rhs.getBCurrentRoadNameAvailable()) return false;
    }
    if (hasCurrentRoadName() || rhs.hasCurrentRoadName()) {
        if (getCurrentRoadName() < rhs.getCurrentRoadName()) return true;
        if (getCurrentRoadName() > rhs.getCurrentRoadName()) return false;
    }
    if (hasBDestinationNameAvailable() || rhs.hasBDestinationNameAvailable()) {
        if (getBDestinationNameAvailable() < rhs.getBDestinationNameAvailable()) return true;
        if (getBDestinationNameAvailable() > rhs.getBDestinationNameAvailable()) return false;
    }
    if (hasDestinationName() || rhs.hasDestinationName()) {
        if (getDestinationName() < rhs.getDestinationName()) return true;
        if (getDestinationName() > rhs.getDestinationName()) return false;
    }
    if (hasBEstimatedTimeOfArrivalAvailable() || rhs.hasBEstimatedTimeOfArrivalAvailable()) {
        if (getBEstimatedTimeOfArrivalAvailable() < rhs.getBEstimatedTimeOfArrivalAvailable()) return true;
        if (getBEstimatedTimeOfArrivalAvailable() > rhs.getBEstimatedTimeOfArrivalAvailable()) return false;
    }
    if (hasEstimatedTimeOfArrival() || rhs.hasEstimatedTimeOfArrival()) {
        if (getEstimatedTimeOfArrival() < rhs.getEstimatedTimeOfArrival()) return true;
        if (getEstimatedTimeOfArrival() > rhs.getEstimatedTimeOfArrival()) return false;
    }
    if (hasBTimeRemainingToDestinationAvailable() || rhs.hasBTimeRemainingToDestinationAvailable()) {
        if (getBTimeRemainingToDestinationAvailable() < rhs.getBTimeRemainingToDestinationAvailable()) return true;
        if (getBTimeRemainingToDestinationAvailable() > rhs.getBTimeRemainingToDestinationAvailable()) return false;
    }
    if (hasTimeRemainingToDestination() || rhs.hasTimeRemainingToDestination()) {
        if (getTimeRemainingToDestination() < rhs.getTimeRemainingToDestination()) return true;
        if (getTimeRemainingToDestination() > rhs.getTimeRemainingToDestination()) return false;
    }
    if (hasBDistanceRemainingAvailable() || rhs.hasBDistanceRemainingAvailable()) {
        if (getBDistanceRemainingAvailable() < rhs.getBDistanceRemainingAvailable()) return true;
        if (getBDistanceRemainingAvailable() > rhs.getBDistanceRemainingAvailable()) return false;
    }
    if (hasDistanceRemaining() || rhs.hasDistanceRemaining()) {
        if (getDistanceRemaining() < rhs.getDistanceRemaining()) return true;
        if (getDistanceRemaining() > rhs.getDistanceRemaining()) return false;
    }
    if (hasBDistanceRemainingDisplayStrAvailable() || rhs.hasBDistanceRemainingDisplayStrAvailable()) {
        if (getBDistanceRemainingDisplayStrAvailable() < rhs.getBDistanceRemainingDisplayStrAvailable()) return true;
        if (getBDistanceRemainingDisplayStrAvailable() > rhs.getBDistanceRemainingDisplayStrAvailable()) return false;
    }
    if (hasDistanceRemainingDisplayStr() || rhs.hasDistanceRemainingDisplayStr()) {
        if (getDistanceRemainingDisplayStr() < rhs.getDistanceRemainingDisplayStr()) return true;
        if (getDistanceRemainingDisplayStr() > rhs.getDistanceRemainingDisplayStr()) return false;
    }
    if (hasBDistanceRemainingDisplayUnitsAvailable() || rhs.hasBDistanceRemainingDisplayUnitsAvailable()) {
        if (getBDistanceRemainingDisplayUnitsAvailable() < rhs.getBDistanceRemainingDisplayUnitsAvailable()) return true;
        if (getBDistanceRemainingDisplayUnitsAvailable() > rhs.getBDistanceRemainingDisplayUnitsAvailable()) return false;
    }
    if (hasE8DistanceRemainingDisplayUnits() || rhs.hasE8DistanceRemainingDisplayUnits()) {
        if ((uint32)getE8DistanceRemainingDisplayUnits() < (uint32)rhs.getE8DistanceRemainingDisplayUnits()) return true;
        if ((uint32)getE8DistanceRemainingDisplayUnits() > (uint32)rhs.getE8DistanceRemainingDisplayUnits()) return false;
    }
    if (hasBDistanceToNextManeuverAvailable() || rhs.hasBDistanceToNextManeuverAvailable()) {
        if (getBDistanceToNextManeuverAvailable() < rhs.getBDistanceToNextManeuverAvailable()) return true;
        if (getBDistanceToNextManeuverAvailable() > rhs.getBDistanceToNextManeuverAvailable()) return false;
    }
    if (hasDistanceToNextManeuver() || rhs.hasDistanceToNextManeuver()) {
        if (getDistanceToNextManeuver() < rhs.getDistanceToNextManeuver()) return true;
        if (getDistanceToNextManeuver() > rhs.getDistanceToNextManeuver()) return false;
    }
    if (hasBDistanceToNextManeuverDisplayStrAvailable() || rhs.hasBDistanceToNextManeuverDisplayStrAvailable()) {
        if (getBDistanceToNextManeuverDisplayStrAvailable() < rhs.getBDistanceToNextManeuverDisplayStrAvailable()) return true;
        if (getBDistanceToNextManeuverDisplayStrAvailable() > rhs.getBDistanceToNextManeuverDisplayStrAvailable()) return false;
    }
    if (hasDistanceToNextManeuverDisplayStr() || rhs.hasDistanceToNextManeuverDisplayStr()) {
        if (getDistanceToNextManeuverDisplayStr() < rhs.getDistanceToNextManeuverDisplayStr()) return true;
        if (getDistanceToNextManeuverDisplayStr() > rhs.getDistanceToNextManeuverDisplayStr()) return false;
    }
    if (hasBDistanceToNextManeuverDisplayUnitsAvailable() || rhs.hasBDistanceToNextManeuverDisplayUnitsAvailable()) {
        if (getBDistanceToNextManeuverDisplayUnitsAvailable() < rhs.getBDistanceToNextManeuverDisplayUnitsAvailable()) return true;
        if (getBDistanceToNextManeuverDisplayUnitsAvailable() > rhs.getBDistanceToNextManeuverDisplayUnitsAvailable()) return false;
    }
    if (hasE8DistanceToNextManeuverDisplayUnits() || rhs.hasE8DistanceToNextManeuverDisplayUnits()) {
        if ((uint32)getE8DistanceToNextManeuverDisplayUnits() < (uint32)rhs.getE8DistanceToNextManeuverDisplayUnits()) return true;
        if ((uint32)getE8DistanceToNextManeuverDisplayUnits() > (uint32)rhs.getE8DistanceToNextManeuverDisplayUnits()) return false;
    }
    if (hasBRouteGuidanceManeuverCurrentListAvailable() || rhs.hasBRouteGuidanceManeuverCurrentListAvailable()) {
        if (getBRouteGuidanceManeuverCurrentListAvailable() < rhs.getBRouteGuidanceManeuverCurrentListAvailable()) return true;
        if (getBRouteGuidanceManeuverCurrentListAvailable() > rhs.getBRouteGuidanceManeuverCurrentListAvailable()) return false;
    }
    if (hasRouteGuidanceManeuverCurrentList() || rhs.hasRouteGuidanceManeuverCurrentList()) {
        if (getRouteGuidanceManeuverCurrentList() < rhs.getRouteGuidanceManeuverCurrentList()) return true;
        if (getRouteGuidanceManeuverCurrentList() > rhs.getRouteGuidanceManeuverCurrentList()) return false;
    }
    if (hasBRouteGuidanceManeuverCountAvailable() || rhs.hasBRouteGuidanceManeuverCountAvailable()) {
        if (getBRouteGuidanceManeuverCountAvailable() < rhs.getBRouteGuidanceManeuverCountAvailable()) return true;
        if (getBRouteGuidanceManeuverCountAvailable() > rhs.getBRouteGuidanceManeuverCountAvailable()) return false;
    }
    if (hasRouteGuidanceManeuverCount() || rhs.hasRouteGuidanceManeuverCount()) {
        if (getRouteGuidanceManeuverCount() < rhs.getRouteGuidanceManeuverCount()) return true;
        if (getRouteGuidanceManeuverCount() > rhs.getRouteGuidanceManeuverCount()) return false;
    }
    if (hasBRouteGuidanceVisibleInAppAvailable() || rhs.hasBRouteGuidanceVisibleInAppAvailable()) {
        if (getBRouteGuidanceVisibleInAppAvailable() < rhs.getBRouteGuidanceVisibleInAppAvailable()) return true;
        if (getBRouteGuidanceVisibleInAppAvailable() > rhs.getBRouteGuidanceVisibleInAppAvailable()) return false;
    }
    if (hasRouteGuidanceVisibleInApp() || rhs.hasRouteGuidanceVisibleInApp()) {
        if (getRouteGuidanceVisibleInApp() < rhs.getRouteGuidanceVisibleInApp()) return true;
        if (getRouteGuidanceVisibleInApp() > rhs.getRouteGuidanceVisibleInApp()) return false;
    }
    if (hasBSourceNameAvailable() || rhs.hasBSourceNameAvailable()) {
        if (getBSourceNameAvailable() < rhs.getBSourceNameAvailable()) return true;
        if (getBSourceNameAvailable() > rhs.getBSourceNameAvailable()) return false;
    }
    if (hasSourceName() || rhs.hasSourceName()) {
        if (getSourceName() < rhs.getSourceName()) return true;
        if (getSourceName() > rhs.getSourceName()) return false;
    }
    if (hasBSourceSupportsRouteGuidanceAvailable() || rhs.hasBSourceSupportsRouteGuidanceAvailable()) {
        if (getBSourceSupportsRouteGuidanceAvailable() < rhs.getBSourceSupportsRouteGuidanceAvailable()) return true;
        if (getBSourceSupportsRouteGuidanceAvailable() > rhs.getBSourceSupportsRouteGuidanceAvailable()) return false;
    }
    if (hasSourceSupportsRouteGuidance() || rhs.hasSourceSupportsRouteGuidance()) {
        if (getSourceSupportsRouteGuidance() < rhs.getSourceSupportsRouteGuidance()) return true;
        if (getSourceSupportsRouteGuidance() > rhs.getSourceSupportsRouteGuidance()) return false;
    }
    return false;
}

inline bool T_RouteGuidanceUpdate::operator > (const T_RouteGuidanceUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_RouteGuidanceUpdate::clear() {
    clearBRouteGuidanceDisplayComponentIDsAvailable();
    clearRouteGuidanceDisplayComponentIDs();
    clearBRouteGuidanceStateAvailable();
    clearE8RouteGuidanceState();
    clearBManeuverStateAvailable();
    clearE8ManeuverState();
    clearBCurrentRoadNameAvailable();
    clearCurrentRoadName();
    clearBDestinationNameAvailable();
    clearDestinationName();
    clearBEstimatedTimeOfArrivalAvailable();
    clearEstimatedTimeOfArrival();
    clearBTimeRemainingToDestinationAvailable();
    clearTimeRemainingToDestination();
    clearBDistanceRemainingAvailable();
    clearDistanceRemaining();
    clearBDistanceRemainingDisplayStrAvailable();
    clearDistanceRemainingDisplayStr();
    clearBDistanceRemainingDisplayUnitsAvailable();
    clearE8DistanceRemainingDisplayUnits();
    clearBDistanceToNextManeuverAvailable();
    clearDistanceToNextManeuver();
    clearBDistanceToNextManeuverDisplayStrAvailable();
    clearDistanceToNextManeuverDisplayStr();
    clearBDistanceToNextManeuverDisplayUnitsAvailable();
    clearE8DistanceToNextManeuverDisplayUnits();
    clearBRouteGuidanceManeuverCurrentListAvailable();
    clearRouteGuidanceManeuverCurrentList();
    clearBRouteGuidanceManeuverCountAvailable();
    clearRouteGuidanceManeuverCount();
    clearBRouteGuidanceVisibleInAppAvailable();
    clearRouteGuidanceVisibleInApp();
    clearBSourceNameAvailable();
    clearSourceName();
    clearBSourceSupportsRouteGuidanceAvailable();
    clearSourceSupportsRouteGuidance();
}

inline void T_RouteGuidanceUpdate::clearBRouteGuidanceDisplayComponentIDsAvailable() {
    if (hasBRouteGuidanceDisplayComponentIDsAvailable()) {
         clear_has_bRouteGuidanceDisplayComponentIDsAvailable();
        _bRouteGuidanceDisplayComponentIDsAvailable = false;
     }
}

inline bool T_RouteGuidanceUpdate::hasBRouteGuidanceDisplayComponentIDsAvailable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_RouteGuidanceUpdate::getBRouteGuidanceDisplayComponentIDsAvailable () const {
    return _bRouteGuidanceDisplayComponentIDsAvailable;
}

inline void T_RouteGuidanceUpdate::setBRouteGuidanceDisplayComponentIDsAvailable (bool bRouteGuidanceDisplayComponentIDsAvailable_) {
    set_has_bRouteGuidanceDisplayComponentIDsAvailable();
    this->_bRouteGuidanceDisplayComponentIDsAvailable = bRouteGuidanceDisplayComponentIDsAvailable_;
}

inline void T_RouteGuidanceUpdate::clearRouteGuidanceDisplayComponentIDs() {
    if (hasRouteGuidanceDisplayComponentIDs()) {
         clear_has_RouteGuidanceDisplayComponentIDs();
        _RouteGuidanceDisplayComponentIDs.clear();
     }
}

inline bool T_RouteGuidanceUpdate::hasRouteGuidanceDisplayComponentIDs () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_RouteGuidanceDisplayComponentIDs& T_RouteGuidanceUpdate::getRouteGuidanceDisplayComponentIDs () const {
    return _RouteGuidanceDisplayComponentIDs;
}

inline T_RouteGuidanceDisplayComponentIDs& T_RouteGuidanceUpdate::getRouteGuidanceDisplayComponentIDsMutable () {
    set_has_RouteGuidanceDisplayComponentIDs();
    return _RouteGuidanceDisplayComponentIDs;
}

inline void T_RouteGuidanceUpdate::setRouteGuidanceDisplayComponentIDs (const T_RouteGuidanceDisplayComponentIDs& RouteGuidanceDisplayComponentIDs_) {
    set_has_RouteGuidanceDisplayComponentIDs();
    this->_RouteGuidanceDisplayComponentIDs = RouteGuidanceDisplayComponentIDs_;
}

inline void T_RouteGuidanceUpdate::clearBRouteGuidanceStateAvailable() {
    if (hasBRouteGuidanceStateAvailable()) {
         clear_has_bRouteGuidanceStateAvailable();
        _bRouteGuidanceStateAvailable = false;
     }
}

inline bool T_RouteGuidanceUpdate::hasBRouteGuidanceStateAvailable () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_RouteGuidanceUpdate::getBRouteGuidanceStateAvailable () const {
    return _bRouteGuidanceStateAvailable;
}

inline void T_RouteGuidanceUpdate::setBRouteGuidanceStateAvailable (bool bRouteGuidanceStateAvailable_) {
    set_has_bRouteGuidanceStateAvailable();
    this->_bRouteGuidanceStateAvailable = bRouteGuidanceStateAvailable_;
}

inline void T_RouteGuidanceUpdate::clearE8RouteGuidanceState() {
    if (hasE8RouteGuidanceState()) {
         clear_has_e8RouteGuidanceState();
        _e8RouteGuidanceState = ::mplay_appcontrol_fi_types::T_e8_RouteGuidanceState__e8DIPO_ROUTE_GUIDANCE_STATE_NO_ROUTE_SET;
     }
}

inline bool T_RouteGuidanceUpdate::hasE8RouteGuidanceState () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_RouteGuidanceState T_RouteGuidanceUpdate::getE8RouteGuidanceState () const {
    return _e8RouteGuidanceState;
}

inline void T_RouteGuidanceUpdate::setE8RouteGuidanceState (T_e8_RouteGuidanceState e8RouteGuidanceState_) {
    #ifndef NDEBUG
    if (!(T_e8_RouteGuidanceState_IsValid(e8RouteGuidanceState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8RouteGuidanceState_, "T_e8_RouteGuidanceState", "e8RouteGuidanceState", "T_RouteGuidanceUpdate");
    }
    #endif
    set_has_e8RouteGuidanceState();
    this->_e8RouteGuidanceState = e8RouteGuidanceState_;
}

inline void T_RouteGuidanceUpdate::clearBManeuverStateAvailable() {
    if (hasBManeuverStateAvailable()) {
         clear_has_bManeuverStateAvailable();
        _bManeuverStateAvailable = false;
     }
}

inline bool T_RouteGuidanceUpdate::hasBManeuverStateAvailable () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool T_RouteGuidanceUpdate::getBManeuverStateAvailable () const {
    return _bManeuverStateAvailable;
}

inline void T_RouteGuidanceUpdate::setBManeuverStateAvailable (bool bManeuverStateAvailable_) {
    set_has_bManeuverStateAvailable();
    this->_bManeuverStateAvailable = bManeuverStateAvailable_;
}

inline void T_RouteGuidanceUpdate::clearE8ManeuverState() {
    if (hasE8ManeuverState()) {
         clear_has_e8ManeuverState();
        _e8ManeuverState = ::mplay_appcontrol_fi_types::T_e8_ManeuverState__e8DIPO_MANEUVER_STATE_CONTINUE;
     }
}

inline bool T_RouteGuidanceUpdate::hasE8ManeuverState () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e8_ManeuverState T_RouteGuidanceUpdate::getE8ManeuverState () const {
    return _e8ManeuverState;
}

inline void T_RouteGuidanceUpdate::setE8ManeuverState (T_e8_ManeuverState e8ManeuverState_) {
    #ifndef NDEBUG
    if (!(T_e8_ManeuverState_IsValid(e8ManeuverState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ManeuverState_, "T_e8_ManeuverState", "e8ManeuverState", "T_RouteGuidanceUpdate");
    }
    #endif
    set_has_e8ManeuverState();
    this->_e8ManeuverState = e8ManeuverState_;
}

inline void T_RouteGuidanceUpdate::clearBCurrentRoadNameAvailable() {
    if (hasBCurrentRoadNameAvailable()) {
         clear_has_bCurrentRoadNameAvailable();
        _bCurrentRoadNameAvailable = false;
     }
}

inline bool T_RouteGuidanceUpdate::hasBCurrentRoadNameAvailable () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool T_RouteGuidanceUpdate::getBCurrentRoadNameAvailable () const {
    return _bCurrentRoadNameAvailable;
}

inline void T_RouteGuidanceUpdate::setBCurrentRoadNameAvailable (bool bCurrentRoadNameAvailable_) {
    set_has_bCurrentRoadNameAvailable();
    this->_bCurrentRoadNameAvailable = bCurrentRoadNameAvailable_;
}

inline void T_RouteGuidanceUpdate::clearCurrentRoadName() {
    if (hasCurrentRoadName()) {
         clear_has_CurrentRoadName();
        _CurrentRoadName.clear();
     }
}

inline bool T_RouteGuidanceUpdate::hasCurrentRoadName () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& T_RouteGuidanceUpdate::getCurrentRoadName () const {
    return _CurrentRoadName;
}

inline ::std::string& T_RouteGuidanceUpdate::getCurrentRoadNameMutable () {
    set_has_CurrentRoadName();
    return _CurrentRoadName;
}

inline void T_RouteGuidanceUpdate::setCurrentRoadName (const ::std::string& CurrentRoadName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CurrentRoadName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CurrentRoadName();
    this->_CurrentRoadName = CurrentRoadName_;
}

inline void T_RouteGuidanceUpdate::setCurrentRoadName (const char* CurrentRoadName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CurrentRoadName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CurrentRoadName();
    this->_CurrentRoadName.assign(CurrentRoadName_);
}

inline void T_RouteGuidanceUpdate::setCurrentRoadName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CurrentRoadName();
    this->_CurrentRoadName.assign(value, size);
}

inline void T_RouteGuidanceUpdate::clearBDestinationNameAvailable() {
    if (hasBDestinationNameAvailable()) {
         clear_has_bDestinationNameAvailable();
        _bDestinationNameAvailable = false;
     }
}

inline bool T_RouteGuidanceUpdate::hasBDestinationNameAvailable () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline bool T_RouteGuidanceUpdate::getBDestinationNameAvailable () const {
    return _bDestinationNameAvailable;
}

inline void T_RouteGuidanceUpdate::setBDestinationNameAvailable (bool bDestinationNameAvailable_) {
    set_has_bDestinationNameAvailable();
    this->_bDestinationNameAvailable = bDestinationNameAvailable_;
}

inline void T_RouteGuidanceUpdate::clearDestinationName() {
    if (hasDestinationName()) {
         clear_has_DestinationName();
        _DestinationName.clear();
     }
}

inline bool T_RouteGuidanceUpdate::hasDestinationName () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::std::string& T_RouteGuidanceUpdate::getDestinationName () const {
    return _DestinationName;
}

inline ::std::string& T_RouteGuidanceUpdate::getDestinationNameMutable () {
    set_has_DestinationName();
    return _DestinationName;
}

inline void T_RouteGuidanceUpdate::setDestinationName (const ::std::string& DestinationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestinationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestinationName();
    this->_DestinationName = DestinationName_;
}

inline void T_RouteGuidanceUpdate::setDestinationName (const char* DestinationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestinationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestinationName();
    this->_DestinationName.assign(DestinationName_);
}

inline void T_RouteGuidanceUpdate::setDestinationName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestinationName();
    this->_DestinationName.assign(value, size);
}

inline void T_RouteGuidanceUpdate::clearBEstimatedTimeOfArrivalAvailable() {
    if (hasBEstimatedTimeOfArrivalAvailable()) {
         clear_has_bEstimatedTimeOfArrivalAvailable();
        _bEstimatedTimeOfArrivalAvailable = false;
     }
}

inline bool T_RouteGuidanceUpdate::hasBEstimatedTimeOfArrivalAvailable () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline bool T_RouteGuidanceUpdate::getBEstimatedTimeOfArrivalAvailable () const {
    return _bEstimatedTimeOfArrivalAvailable;
}

inline void T_RouteGuidanceUpdate::setBEstimatedTimeOfArrivalAvailable (bool bEstimatedTimeOfArrivalAvailable_) {
    set_has_bEstimatedTimeOfArrivalAvailable();
    this->_bEstimatedTimeOfArrivalAvailable = bEstimatedTimeOfArrivalAvailable_;
}

inline void T_RouteGuidanceUpdate::clearEstimatedTimeOfArrival() {
    if (hasEstimatedTimeOfArrival()) {
         clear_has_EstimatedTimeOfArrival();
        _EstimatedTimeOfArrival = 0u;
     }
}

inline bool T_RouteGuidanceUpdate::hasEstimatedTimeOfArrival () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline uint64 T_RouteGuidanceUpdate::getEstimatedTimeOfArrival () const {
    return _EstimatedTimeOfArrival;
}

inline void T_RouteGuidanceUpdate::setEstimatedTimeOfArrival (uint64 EstimatedTimeOfArrival_) {
    set_has_EstimatedTimeOfArrival();
    this->_EstimatedTimeOfArrival = EstimatedTimeOfArrival_;
}

inline void T_RouteGuidanceUpdate::clearBTimeRemainingToDestinationAvailable() {
    if (hasBTimeRemainingToDestinationAvailable()) {
         clear_has_bTimeRemainingToDestinationAvailable();
        _bTimeRemainingToDestinationAvailable = false;
     }
}

inline bool T_RouteGuidanceUpdate::hasBTimeRemainingToDestinationAvailable () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline bool T_RouteGuidanceUpdate::getBTimeRemainingToDestinationAvailable () const {
    return _bTimeRemainingToDestinationAvailable;
}

inline void T_RouteGuidanceUpdate::setBTimeRemainingToDestinationAvailable (bool bTimeRemainingToDestinationAvailable_) {
    set_has_bTimeRemainingToDestinationAvailable();
    this->_bTimeRemainingToDestinationAvailable = bTimeRemainingToDestinationAvailable_;
}

inline void T_RouteGuidanceUpdate::clearTimeRemainingToDestination() {
    if (hasTimeRemainingToDestination()) {
         clear_has_TimeRemainingToDestination();
        _TimeRemainingToDestination = 0u;
     }
}

inline bool T_RouteGuidanceUpdate::hasTimeRemainingToDestination () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint64 T_RouteGuidanceUpdate::getTimeRemainingToDestination () const {
    return _TimeRemainingToDestination;
}

inline void T_RouteGuidanceUpdate::setTimeRemainingToDestination (uint64 TimeRemainingToDestination_) {
    set_has_TimeRemainingToDestination();
    this->_TimeRemainingToDestination = TimeRemainingToDestination_;
}

inline void T_RouteGuidanceUpdate::clearBDistanceRemainingAvailable() {
    if (hasBDistanceRemainingAvailable()) {
         clear_has_bDistanceRemainingAvailable();
        _bDistanceRemainingAvailable = false;
     }
}

inline bool T_RouteGuidanceUpdate::hasBDistanceRemainingAvailable () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline bool T_RouteGuidanceUpdate::getBDistanceRemainingAvailable () const {
    return _bDistanceRemainingAvailable;
}

inline void T_RouteGuidanceUpdate::setBDistanceRemainingAvailable (bool bDistanceRemainingAvailable_) {
    set_has_bDistanceRemainingAvailable();
    this->_bDistanceRemainingAvailable = bDistanceRemainingAvailable_;
}

inline void T_RouteGuidanceUpdate::clearDistanceRemaining() {
    if (hasDistanceRemaining()) {
         clear_has_DistanceRemaining();
        _DistanceRemaining = 0u;
     }
}

inline bool T_RouteGuidanceUpdate::hasDistanceRemaining () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline uint32 T_RouteGuidanceUpdate::getDistanceRemaining () const {
    return _DistanceRemaining;
}

inline void T_RouteGuidanceUpdate::setDistanceRemaining (uint32 DistanceRemaining_) {
    set_has_DistanceRemaining();
    this->_DistanceRemaining = DistanceRemaining_;
}

inline void T_RouteGuidanceUpdate::clearBDistanceRemainingDisplayStrAvailable() {
    if (hasBDistanceRemainingDisplayStrAvailable()) {
         clear_has_bDistanceRemainingDisplayStrAvailable();
        _bDistanceRemainingDisplayStrAvailable = false;
     }
}

inline bool T_RouteGuidanceUpdate::hasBDistanceRemainingDisplayStrAvailable () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline bool T_RouteGuidanceUpdate::getBDistanceRemainingDisplayStrAvailable () const {
    return _bDistanceRemainingDisplayStrAvailable;
}

inline void T_RouteGuidanceUpdate::setBDistanceRemainingDisplayStrAvailable (bool bDistanceRemainingDisplayStrAvailable_) {
    set_has_bDistanceRemainingDisplayStrAvailable();
    this->_bDistanceRemainingDisplayStrAvailable = bDistanceRemainingDisplayStrAvailable_;
}

inline void T_RouteGuidanceUpdate::clearDistanceRemainingDisplayStr() {
    if (hasDistanceRemainingDisplayStr()) {
         clear_has_DistanceRemainingDisplayStr();
        _DistanceRemainingDisplayStr.clear();
     }
}

inline bool T_RouteGuidanceUpdate::hasDistanceRemainingDisplayStr () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline const ::std::string& T_RouteGuidanceUpdate::getDistanceRemainingDisplayStr () const {
    return _DistanceRemainingDisplayStr;
}

inline ::std::string& T_RouteGuidanceUpdate::getDistanceRemainingDisplayStrMutable () {
    set_has_DistanceRemainingDisplayStr();
    return _DistanceRemainingDisplayStr;
}

inline void T_RouteGuidanceUpdate::setDistanceRemainingDisplayStr (const ::std::string& DistanceRemainingDisplayStr_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DistanceRemainingDisplayStr_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DistanceRemainingDisplayStr();
    this->_DistanceRemainingDisplayStr = DistanceRemainingDisplayStr_;
}

inline void T_RouteGuidanceUpdate::setDistanceRemainingDisplayStr (const char* DistanceRemainingDisplayStr_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DistanceRemainingDisplayStr_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DistanceRemainingDisplayStr();
    this->_DistanceRemainingDisplayStr.assign(DistanceRemainingDisplayStr_);
}

inline void T_RouteGuidanceUpdate::setDistanceRemainingDisplayStr (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DistanceRemainingDisplayStr();
    this->_DistanceRemainingDisplayStr.assign(value, size);
}

inline void T_RouteGuidanceUpdate::clearBDistanceRemainingDisplayUnitsAvailable() {
    if (hasBDistanceRemainingDisplayUnitsAvailable()) {
         clear_has_bDistanceRemainingDisplayUnitsAvailable();
        _bDistanceRemainingDisplayUnitsAvailable = false;
     }
}

inline bool T_RouteGuidanceUpdate::hasBDistanceRemainingDisplayUnitsAvailable () const {
    return (_has_bits_[0] & (1u << 18)) > 0;
}

inline bool T_RouteGuidanceUpdate::getBDistanceRemainingDisplayUnitsAvailable () const {
    return _bDistanceRemainingDisplayUnitsAvailable;
}

inline void T_RouteGuidanceUpdate::setBDistanceRemainingDisplayUnitsAvailable (bool bDistanceRemainingDisplayUnitsAvailable_) {
    set_has_bDistanceRemainingDisplayUnitsAvailable();
    this->_bDistanceRemainingDisplayUnitsAvailable = bDistanceRemainingDisplayUnitsAvailable_;
}

inline void T_RouteGuidanceUpdate::clearE8DistanceRemainingDisplayUnits() {
    if (hasE8DistanceRemainingDisplayUnits()) {
         clear_has_e8DistanceRemainingDisplayUnits();
        _e8DistanceRemainingDisplayUnits = ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_KM;
     }
}

inline bool T_RouteGuidanceUpdate::hasE8DistanceRemainingDisplayUnits () const {
    return (_has_bits_[0] & (1u << 19)) > 0;
}

inline T_e8_DistanceDisplayUnits T_RouteGuidanceUpdate::getE8DistanceRemainingDisplayUnits () const {
    return _e8DistanceRemainingDisplayUnits;
}

inline void T_RouteGuidanceUpdate::setE8DistanceRemainingDisplayUnits (T_e8_DistanceDisplayUnits e8DistanceRemainingDisplayUnits_) {
    #ifndef NDEBUG
    if (!(T_e8_DistanceDisplayUnits_IsValid(e8DistanceRemainingDisplayUnits_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DistanceRemainingDisplayUnits_, "T_e8_DistanceDisplayUnits", "e8DistanceRemainingDisplayUnits", "T_RouteGuidanceUpdate");
    }
    #endif
    set_has_e8DistanceRemainingDisplayUnits();
    this->_e8DistanceRemainingDisplayUnits = e8DistanceRemainingDisplayUnits_;
}

inline void T_RouteGuidanceUpdate::clearBDistanceToNextManeuverAvailable() {
    if (hasBDistanceToNextManeuverAvailable()) {
         clear_has_bDistanceToNextManeuverAvailable();
        _bDistanceToNextManeuverAvailable = false;
     }
}

inline bool T_RouteGuidanceUpdate::hasBDistanceToNextManeuverAvailable () const {
    return (_has_bits_[0] & (1u << 20)) > 0;
}

inline bool T_RouteGuidanceUpdate::getBDistanceToNextManeuverAvailable () const {
    return _bDistanceToNextManeuverAvailable;
}

inline void T_RouteGuidanceUpdate::setBDistanceToNextManeuverAvailable (bool bDistanceToNextManeuverAvailable_) {
    set_has_bDistanceToNextManeuverAvailable();
    this->_bDistanceToNextManeuverAvailable = bDistanceToNextManeuverAvailable_;
}

inline void T_RouteGuidanceUpdate::clearDistanceToNextManeuver() {
    if (hasDistanceToNextManeuver()) {
         clear_has_DistanceToNextManeuver();
        _DistanceToNextManeuver = 0u;
     }
}

inline bool T_RouteGuidanceUpdate::hasDistanceToNextManeuver () const {
    return (_has_bits_[0] & (1u << 21)) > 0;
}

inline uint32 T_RouteGuidanceUpdate::getDistanceToNextManeuver () const {
    return _DistanceToNextManeuver;
}

inline void T_RouteGuidanceUpdate::setDistanceToNextManeuver (uint32 DistanceToNextManeuver_) {
    set_has_DistanceToNextManeuver();
    this->_DistanceToNextManeuver = DistanceToNextManeuver_;
}

inline void T_RouteGuidanceUpdate::clearBDistanceToNextManeuverDisplayStrAvailable() {
    if (hasBDistanceToNextManeuverDisplayStrAvailable()) {
         clear_has_bDistanceToNextManeuverDisplayStrAvailable();
        _bDistanceToNextManeuverDisplayStrAvailable = false;
     }
}

inline bool T_RouteGuidanceUpdate::hasBDistanceToNextManeuverDisplayStrAvailable () const {
    return (_has_bits_[0] & (1u << 22)) > 0;
}

inline bool T_RouteGuidanceUpdate::getBDistanceToNextManeuverDisplayStrAvailable () const {
    return _bDistanceToNextManeuverDisplayStrAvailable;
}

inline void T_RouteGuidanceUpdate::setBDistanceToNextManeuverDisplayStrAvailable (bool bDistanceToNextManeuverDisplayStrAvailable_) {
    set_has_bDistanceToNextManeuverDisplayStrAvailable();
    this->_bDistanceToNextManeuverDisplayStrAvailable = bDistanceToNextManeuverDisplayStrAvailable_;
}

inline void T_RouteGuidanceUpdate::clearDistanceToNextManeuverDisplayStr() {
    if (hasDistanceToNextManeuverDisplayStr()) {
         clear_has_DistanceToNextManeuverDisplayStr();
        _DistanceToNextManeuverDisplayStr.clear();
     }
}

inline bool T_RouteGuidanceUpdate::hasDistanceToNextManeuverDisplayStr () const {
    return (_has_bits_[0] & (1u << 23)) > 0;
}

inline const ::std::string& T_RouteGuidanceUpdate::getDistanceToNextManeuverDisplayStr () const {
    return _DistanceToNextManeuverDisplayStr;
}

inline ::std::string& T_RouteGuidanceUpdate::getDistanceToNextManeuverDisplayStrMutable () {
    set_has_DistanceToNextManeuverDisplayStr();
    return _DistanceToNextManeuverDisplayStr;
}

inline void T_RouteGuidanceUpdate::setDistanceToNextManeuverDisplayStr (const ::std::string& DistanceToNextManeuverDisplayStr_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DistanceToNextManeuverDisplayStr_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DistanceToNextManeuverDisplayStr();
    this->_DistanceToNextManeuverDisplayStr = DistanceToNextManeuverDisplayStr_;
}

inline void T_RouteGuidanceUpdate::setDistanceToNextManeuverDisplayStr (const char* DistanceToNextManeuverDisplayStr_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DistanceToNextManeuverDisplayStr_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DistanceToNextManeuverDisplayStr();
    this->_DistanceToNextManeuverDisplayStr.assign(DistanceToNextManeuverDisplayStr_);
}

inline void T_RouteGuidanceUpdate::setDistanceToNextManeuverDisplayStr (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DistanceToNextManeuverDisplayStr();
    this->_DistanceToNextManeuverDisplayStr.assign(value, size);
}

inline void T_RouteGuidanceUpdate::clearBDistanceToNextManeuverDisplayUnitsAvailable() {
    if (hasBDistanceToNextManeuverDisplayUnitsAvailable()) {
         clear_has_bDistanceToNextManeuverDisplayUnitsAvailable();
        _bDistanceToNextManeuverDisplayUnitsAvailable = false;
     }
}

inline bool T_RouteGuidanceUpdate::hasBDistanceToNextManeuverDisplayUnitsAvailable () const {
    return (_has_bits_[0] & (1u << 24)) > 0;
}

inline bool T_RouteGuidanceUpdate::getBDistanceToNextManeuverDisplayUnitsAvailable () const {
    return _bDistanceToNextManeuverDisplayUnitsAvailable;
}

inline void T_RouteGuidanceUpdate::setBDistanceToNextManeuverDisplayUnitsAvailable (bool bDistanceToNextManeuverDisplayUnitsAvailable_) {
    set_has_bDistanceToNextManeuverDisplayUnitsAvailable();
    this->_bDistanceToNextManeuverDisplayUnitsAvailable = bDistanceToNextManeuverDisplayUnitsAvailable_;
}

inline void T_RouteGuidanceUpdate::clearE8DistanceToNextManeuverDisplayUnits() {
    if (hasE8DistanceToNextManeuverDisplayUnits()) {
         clear_has_e8DistanceToNextManeuverDisplayUnits();
        _e8DistanceToNextManeuverDisplayUnits = ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_KM;
     }
}

inline bool T_RouteGuidanceUpdate::hasE8DistanceToNextManeuverDisplayUnits () const {
    return (_has_bits_[0] & (1u << 25)) > 0;
}

inline T_e8_DistanceDisplayUnits T_RouteGuidanceUpdate::getE8DistanceToNextManeuverDisplayUnits () const {
    return _e8DistanceToNextManeuverDisplayUnits;
}

inline void T_RouteGuidanceUpdate::setE8DistanceToNextManeuverDisplayUnits (T_e8_DistanceDisplayUnits e8DistanceToNextManeuverDisplayUnits_) {
    #ifndef NDEBUG
    if (!(T_e8_DistanceDisplayUnits_IsValid(e8DistanceToNextManeuverDisplayUnits_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DistanceToNextManeuverDisplayUnits_, "T_e8_DistanceDisplayUnits", "e8DistanceToNextManeuverDisplayUnits", "T_RouteGuidanceUpdate");
    }
    #endif
    set_has_e8DistanceToNextManeuverDisplayUnits();
    this->_e8DistanceToNextManeuverDisplayUnits = e8DistanceToNextManeuverDisplayUnits_;
}

inline void T_RouteGuidanceUpdate::clearBRouteGuidanceManeuverCurrentListAvailable() {
    if (hasBRouteGuidanceManeuverCurrentListAvailable()) {
         clear_has_bRouteGuidanceManeuverCurrentListAvailable();
        _bRouteGuidanceManeuverCurrentListAvailable = false;
     }
}

inline bool T_RouteGuidanceUpdate::hasBRouteGuidanceManeuverCurrentListAvailable () const {
    return (_has_bits_[0] & (1u << 26)) > 0;
}

inline bool T_RouteGuidanceUpdate::getBRouteGuidanceManeuverCurrentListAvailable () const {
    return _bRouteGuidanceManeuverCurrentListAvailable;
}

inline void T_RouteGuidanceUpdate::setBRouteGuidanceManeuverCurrentListAvailable (bool bRouteGuidanceManeuverCurrentListAvailable_) {
    set_has_bRouteGuidanceManeuverCurrentListAvailable();
    this->_bRouteGuidanceManeuverCurrentListAvailable = bRouteGuidanceManeuverCurrentListAvailable_;
}

inline void T_RouteGuidanceUpdate::clearRouteGuidanceManeuverCurrentList() {
    if (hasRouteGuidanceManeuverCurrentList()) {
         clear_has_RouteGuidanceManeuverCurrentList();
        _RouteGuidanceManeuverCurrentList.clear();
     }
}

inline bool T_RouteGuidanceUpdate::hasRouteGuidanceManeuverCurrentList () const {
    return (_has_bits_[0] & (1u << 27)) > 0;
}

inline const T_RouteGuidanceManeuverCurrentList& T_RouteGuidanceUpdate::getRouteGuidanceManeuverCurrentList () const {
    return _RouteGuidanceManeuverCurrentList;
}

inline T_RouteGuidanceManeuverCurrentList& T_RouteGuidanceUpdate::getRouteGuidanceManeuverCurrentListMutable () {
    set_has_RouteGuidanceManeuverCurrentList();
    return _RouteGuidanceManeuverCurrentList;
}

inline void T_RouteGuidanceUpdate::setRouteGuidanceManeuverCurrentList (const T_RouteGuidanceManeuverCurrentList& RouteGuidanceManeuverCurrentList_) {
    set_has_RouteGuidanceManeuverCurrentList();
    this->_RouteGuidanceManeuverCurrentList = RouteGuidanceManeuverCurrentList_;
}

inline void T_RouteGuidanceUpdate::clearBRouteGuidanceManeuverCountAvailable() {
    if (hasBRouteGuidanceManeuverCountAvailable()) {
         clear_has_bRouteGuidanceManeuverCountAvailable();
        _bRouteGuidanceManeuverCountAvailable = false;
     }
}

inline bool T_RouteGuidanceUpdate::hasBRouteGuidanceManeuverCountAvailable () const {
    return (_has_bits_[0] & (1u << 28)) > 0;
}

inline bool T_RouteGuidanceUpdate::getBRouteGuidanceManeuverCountAvailable () const {
    return _bRouteGuidanceManeuverCountAvailable;
}

inline void T_RouteGuidanceUpdate::setBRouteGuidanceManeuverCountAvailable (bool bRouteGuidanceManeuverCountAvailable_) {
    set_has_bRouteGuidanceManeuverCountAvailable();
    this->_bRouteGuidanceManeuverCountAvailable = bRouteGuidanceManeuverCountAvailable_;
}

inline void T_RouteGuidanceUpdate::clearRouteGuidanceManeuverCount() {
    if (hasRouteGuidanceManeuverCount()) {
         clear_has_RouteGuidanceManeuverCount();
        _RouteGuidanceManeuverCount = 0u;
     }
}

inline bool T_RouteGuidanceUpdate::hasRouteGuidanceManeuverCount () const {
    return (_has_bits_[0] & (1u << 29)) > 0;
}

inline uint16 T_RouteGuidanceUpdate::getRouteGuidanceManeuverCount () const {
    return _RouteGuidanceManeuverCount;
}

inline void T_RouteGuidanceUpdate::setRouteGuidanceManeuverCount (uint16 RouteGuidanceManeuverCount_) {
    set_has_RouteGuidanceManeuverCount();
    this->_RouteGuidanceManeuverCount = RouteGuidanceManeuverCount_;
}

inline void T_RouteGuidanceUpdate::clearBRouteGuidanceVisibleInAppAvailable() {
    if (hasBRouteGuidanceVisibleInAppAvailable()) {
         clear_has_bRouteGuidanceVisibleInAppAvailable();
        _bRouteGuidanceVisibleInAppAvailable = false;
     }
}

inline bool T_RouteGuidanceUpdate::hasBRouteGuidanceVisibleInAppAvailable () const {
    return (_has_bits_[0] & (1u << 30)) > 0;
}

inline bool T_RouteGuidanceUpdate::getBRouteGuidanceVisibleInAppAvailable () const {
    return _bRouteGuidanceVisibleInAppAvailable;
}

inline void T_RouteGuidanceUpdate::setBRouteGuidanceVisibleInAppAvailable (bool bRouteGuidanceVisibleInAppAvailable_) {
    set_has_bRouteGuidanceVisibleInAppAvailable();
    this->_bRouteGuidanceVisibleInAppAvailable = bRouteGuidanceVisibleInAppAvailable_;
}

inline void T_RouteGuidanceUpdate::clearRouteGuidanceVisibleInApp() {
    if (hasRouteGuidanceVisibleInApp()) {
         clear_has_RouteGuidanceVisibleInApp();
        _RouteGuidanceVisibleInApp = false;
     }
}

inline bool T_RouteGuidanceUpdate::hasRouteGuidanceVisibleInApp () const {
    return (_has_bits_[0] & (1u << 31)) > 0;
}

inline bool T_RouteGuidanceUpdate::getRouteGuidanceVisibleInApp () const {
    return _RouteGuidanceVisibleInApp;
}

inline void T_RouteGuidanceUpdate::setRouteGuidanceVisibleInApp (bool RouteGuidanceVisibleInApp_) {
    set_has_RouteGuidanceVisibleInApp();
    this->_RouteGuidanceVisibleInApp = RouteGuidanceVisibleInApp_;
}

inline void T_RouteGuidanceUpdate::clearBSourceNameAvailable() {
    if (hasBSourceNameAvailable()) {
         clear_has_bSourceNameAvailable();
        _bSourceNameAvailable = false;
     }
}

inline bool T_RouteGuidanceUpdate::hasBSourceNameAvailable () const {
    return (_has_bits_[1] & (1u << 0)) > 0;
}

inline bool T_RouteGuidanceUpdate::getBSourceNameAvailable () const {
    return _bSourceNameAvailable;
}

inline void T_RouteGuidanceUpdate::setBSourceNameAvailable (bool bSourceNameAvailable_) {
    set_has_bSourceNameAvailable();
    this->_bSourceNameAvailable = bSourceNameAvailable_;
}

inline void T_RouteGuidanceUpdate::clearSourceName() {
    if (hasSourceName()) {
         clear_has_SourceName();
        _SourceName.clear();
     }
}

inline bool T_RouteGuidanceUpdate::hasSourceName () const {
    return (_has_bits_[1] & (1u << 1)) > 0;
}

inline const ::std::string& T_RouteGuidanceUpdate::getSourceName () const {
    return _SourceName;
}

inline ::std::string& T_RouteGuidanceUpdate::getSourceNameMutable () {
    set_has_SourceName();
    return _SourceName;
}

inline void T_RouteGuidanceUpdate::setSourceName (const ::std::string& SourceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SourceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SourceName();
    this->_SourceName = SourceName_;
}

inline void T_RouteGuidanceUpdate::setSourceName (const char* SourceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SourceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SourceName();
    this->_SourceName.assign(SourceName_);
}

inline void T_RouteGuidanceUpdate::setSourceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SourceName();
    this->_SourceName.assign(value, size);
}

inline void T_RouteGuidanceUpdate::clearBSourceSupportsRouteGuidanceAvailable() {
    if (hasBSourceSupportsRouteGuidanceAvailable()) {
         clear_has_bSourceSupportsRouteGuidanceAvailable();
        _bSourceSupportsRouteGuidanceAvailable = false;
     }
}

inline bool T_RouteGuidanceUpdate::hasBSourceSupportsRouteGuidanceAvailable () const {
    return (_has_bits_[1] & (1u << 2)) > 0;
}

inline bool T_RouteGuidanceUpdate::getBSourceSupportsRouteGuidanceAvailable () const {
    return _bSourceSupportsRouteGuidanceAvailable;
}

inline void T_RouteGuidanceUpdate::setBSourceSupportsRouteGuidanceAvailable (bool bSourceSupportsRouteGuidanceAvailable_) {
    set_has_bSourceSupportsRouteGuidanceAvailable();
    this->_bSourceSupportsRouteGuidanceAvailable = bSourceSupportsRouteGuidanceAvailable_;
}

inline void T_RouteGuidanceUpdate::clearSourceSupportsRouteGuidance() {
    if (hasSourceSupportsRouteGuidance()) {
         clear_has_SourceSupportsRouteGuidance();
        _SourceSupportsRouteGuidance = false;
     }
}

inline bool T_RouteGuidanceUpdate::hasSourceSupportsRouteGuidance () const {
    return (_has_bits_[1] & (1u << 3)) > 0;
}

inline bool T_RouteGuidanceUpdate::getSourceSupportsRouteGuidance () const {
    return _SourceSupportsRouteGuidance;
}

inline void T_RouteGuidanceUpdate::setSourceSupportsRouteGuidance (bool SourceSupportsRouteGuidance_) {
    set_has_SourceSupportsRouteGuidance();
    this->_SourceSupportsRouteGuidance = SourceSupportsRouteGuidance_;
}

inline void T_RouteGuidanceUpdate::set_has_bRouteGuidanceDisplayComponentIDsAvailable () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_RouteGuidanceUpdate::clear_has_bRouteGuidanceDisplayComponentIDsAvailable () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_RouteGuidanceUpdate::set_has_RouteGuidanceDisplayComponentIDs () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_RouteGuidanceUpdate::clear_has_RouteGuidanceDisplayComponentIDs () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_RouteGuidanceUpdate::set_has_bRouteGuidanceStateAvailable () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_RouteGuidanceUpdate::clear_has_bRouteGuidanceStateAvailable () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_RouteGuidanceUpdate::set_has_e8RouteGuidanceState () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_RouteGuidanceUpdate::clear_has_e8RouteGuidanceState () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_RouteGuidanceUpdate::set_has_bManeuverStateAvailable () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_RouteGuidanceUpdate::clear_has_bManeuverStateAvailable () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_RouteGuidanceUpdate::set_has_e8ManeuverState () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_RouteGuidanceUpdate::clear_has_e8ManeuverState () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_RouteGuidanceUpdate::set_has_bCurrentRoadNameAvailable () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_RouteGuidanceUpdate::clear_has_bCurrentRoadNameAvailable () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_RouteGuidanceUpdate::set_has_CurrentRoadName () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_RouteGuidanceUpdate::clear_has_CurrentRoadName () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_RouteGuidanceUpdate::set_has_bDestinationNameAvailable () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_RouteGuidanceUpdate::clear_has_bDestinationNameAvailable () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_RouteGuidanceUpdate::set_has_DestinationName () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_RouteGuidanceUpdate::clear_has_DestinationName () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_RouteGuidanceUpdate::set_has_bEstimatedTimeOfArrivalAvailable () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_RouteGuidanceUpdate::clear_has_bEstimatedTimeOfArrivalAvailable () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_RouteGuidanceUpdate::set_has_EstimatedTimeOfArrival () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_RouteGuidanceUpdate::clear_has_EstimatedTimeOfArrival () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_RouteGuidanceUpdate::set_has_bTimeRemainingToDestinationAvailable () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_RouteGuidanceUpdate::clear_has_bTimeRemainingToDestinationAvailable () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_RouteGuidanceUpdate::set_has_TimeRemainingToDestination () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_RouteGuidanceUpdate::clear_has_TimeRemainingToDestination () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_RouteGuidanceUpdate::set_has_bDistanceRemainingAvailable () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_RouteGuidanceUpdate::clear_has_bDistanceRemainingAvailable () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_RouteGuidanceUpdate::set_has_DistanceRemaining () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_RouteGuidanceUpdate::clear_has_DistanceRemaining () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_RouteGuidanceUpdate::set_has_bDistanceRemainingDisplayStrAvailable () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_RouteGuidanceUpdate::clear_has_bDistanceRemainingDisplayStrAvailable () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void T_RouteGuidanceUpdate::set_has_DistanceRemainingDisplayStr () {
    _has_bits_[0] |= 1u << 17;
}

inline void T_RouteGuidanceUpdate::clear_has_DistanceRemainingDisplayStr () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline void T_RouteGuidanceUpdate::set_has_bDistanceRemainingDisplayUnitsAvailable () {
    _has_bits_[0] |= 1u << 18;
}

inline void T_RouteGuidanceUpdate::clear_has_bDistanceRemainingDisplayUnitsAvailable () {
    _has_bits_[0] &= ~ (1u << 18);
}

inline void T_RouteGuidanceUpdate::set_has_e8DistanceRemainingDisplayUnits () {
    _has_bits_[0] |= 1u << 19;
}

inline void T_RouteGuidanceUpdate::clear_has_e8DistanceRemainingDisplayUnits () {
    _has_bits_[0] &= ~ (1u << 19);
}

inline void T_RouteGuidanceUpdate::set_has_bDistanceToNextManeuverAvailable () {
    _has_bits_[0] |= 1u << 20;
}

inline void T_RouteGuidanceUpdate::clear_has_bDistanceToNextManeuverAvailable () {
    _has_bits_[0] &= ~ (1u << 20);
}

inline void T_RouteGuidanceUpdate::set_has_DistanceToNextManeuver () {
    _has_bits_[0] |= 1u << 21;
}

inline void T_RouteGuidanceUpdate::clear_has_DistanceToNextManeuver () {
    _has_bits_[0] &= ~ (1u << 21);
}

inline void T_RouteGuidanceUpdate::set_has_bDistanceToNextManeuverDisplayStrAvailable () {
    _has_bits_[0] |= 1u << 22;
}

inline void T_RouteGuidanceUpdate::clear_has_bDistanceToNextManeuverDisplayStrAvailable () {
    _has_bits_[0] &= ~ (1u << 22);
}

inline void T_RouteGuidanceUpdate::set_has_DistanceToNextManeuverDisplayStr () {
    _has_bits_[0] |= 1u << 23;
}

inline void T_RouteGuidanceUpdate::clear_has_DistanceToNextManeuverDisplayStr () {
    _has_bits_[0] &= ~ (1u << 23);
}

inline void T_RouteGuidanceUpdate::set_has_bDistanceToNextManeuverDisplayUnitsAvailable () {
    _has_bits_[0] |= 1u << 24;
}

inline void T_RouteGuidanceUpdate::clear_has_bDistanceToNextManeuverDisplayUnitsAvailable () {
    _has_bits_[0] &= ~ (1u << 24);
}

inline void T_RouteGuidanceUpdate::set_has_e8DistanceToNextManeuverDisplayUnits () {
    _has_bits_[0] |= 1u << 25;
}

inline void T_RouteGuidanceUpdate::clear_has_e8DistanceToNextManeuverDisplayUnits () {
    _has_bits_[0] &= ~ (1u << 25);
}

inline void T_RouteGuidanceUpdate::set_has_bRouteGuidanceManeuverCurrentListAvailable () {
    _has_bits_[0] |= 1u << 26;
}

inline void T_RouteGuidanceUpdate::clear_has_bRouteGuidanceManeuverCurrentListAvailable () {
    _has_bits_[0] &= ~ (1u << 26);
}

inline void T_RouteGuidanceUpdate::set_has_RouteGuidanceManeuverCurrentList () {
    _has_bits_[0] |= 1u << 27;
}

inline void T_RouteGuidanceUpdate::clear_has_RouteGuidanceManeuverCurrentList () {
    _has_bits_[0] &= ~ (1u << 27);
}

inline void T_RouteGuidanceUpdate::set_has_bRouteGuidanceManeuverCountAvailable () {
    _has_bits_[0] |= 1u << 28;
}

inline void T_RouteGuidanceUpdate::clear_has_bRouteGuidanceManeuverCountAvailable () {
    _has_bits_[0] &= ~ (1u << 28);
}

inline void T_RouteGuidanceUpdate::set_has_RouteGuidanceManeuverCount () {
    _has_bits_[0] |= 1u << 29;
}

inline void T_RouteGuidanceUpdate::clear_has_RouteGuidanceManeuverCount () {
    _has_bits_[0] &= ~ (1u << 29);
}

inline void T_RouteGuidanceUpdate::set_has_bRouteGuidanceVisibleInAppAvailable () {
    _has_bits_[0] |= 1u << 30;
}

inline void T_RouteGuidanceUpdate::clear_has_bRouteGuidanceVisibleInAppAvailable () {
    _has_bits_[0] &= ~ (1u << 30);
}

inline void T_RouteGuidanceUpdate::set_has_RouteGuidanceVisibleInApp () {
    _has_bits_[0] |= 1u << 31;
}

inline void T_RouteGuidanceUpdate::clear_has_RouteGuidanceVisibleInApp () {
    _has_bits_[0] &= ~ (1u << 31);
}

inline void T_RouteGuidanceUpdate::set_has_bSourceNameAvailable () {
    _has_bits_[1] |= 1u << 0;
}

inline void T_RouteGuidanceUpdate::clear_has_bSourceNameAvailable () {
    _has_bits_[1] &= ~ (1u << 0);
}

inline void T_RouteGuidanceUpdate::set_has_SourceName () {
    _has_bits_[1] |= 1u << 1;
}

inline void T_RouteGuidanceUpdate::clear_has_SourceName () {
    _has_bits_[1] &= ~ (1u << 1);
}

inline void T_RouteGuidanceUpdate::set_has_bSourceSupportsRouteGuidanceAvailable () {
    _has_bits_[1] |= 1u << 2;
}

inline void T_RouteGuidanceUpdate::clear_has_bSourceSupportsRouteGuidanceAvailable () {
    _has_bits_[1] &= ~ (1u << 2);
}

inline void T_RouteGuidanceUpdate::set_has_SourceSupportsRouteGuidance () {
    _has_bits_[1] |= 1u << 3;
}

inline void T_RouteGuidanceUpdate::clear_has_SourceSupportsRouteGuidance () {
    _has_bits_[1] &= ~ (1u << 3);
}

inline  T_RouteGuidanceManeuverUpdate::T_RouteGuidanceManeuverUpdate ()  :
    _bRouteGuidanceDisplayComponentIDsAvailable (false),
    _RouteGuidanceDisplayComponentIDs (),
    _bIndexAvailable (false),
    _Index (0u),
    _bManeuverDescriptionAvailable (false),
    _ManeuverDescription (),
    _bManeuverTypeAvailable (false),
    _e8ManeuverType (::mplay_appcontrol_fi_types::T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_NO_TURN),
    _bAfterManeuverRoadNameAvailable (false),
    _AfterManeuverRoadName (),
    _bDistanceBetweenManeuverAvailable (false),
    _DistanceBetweenManeuver (0u),
    _bDistanceBetweenManeuverDisplayStrAvailable (false),
    _DistanceBetweenManeuverDisplayStr (),
    _bDistanceBetweenManeuverDisplayUnitsAvailable (false),
    _e8DistanceBetweenManeuverDisplayUnits (::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_KM),
    _bDrivingSideAvailable (false),
    _e8DrivingSide (::mplay_appcontrol_fi_types::T_e8_DrivingSide__e8DIPO_DRIVING_SIDE_RIGHT),
    _bJunctionTypeAvailable (false),
    _e8JunctionType (::mplay_appcontrol_fi_types::T_e8_JunctionType__e8DIPO_JUNCTION_TYPE_SINGLE_INTERSECTION),
    _bJunctionElementAngleAvailable (false),
    _JunctionElementAngle (),
    _bJunctionElementExitAngleAvailable (false),
    _JunctionElementExitAngle (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_RouteGuidanceManeuverUpdate::T_RouteGuidanceManeuverUpdate (const T_RouteGuidanceManeuverUpdate &rhs)  :
    _bRouteGuidanceDisplayComponentIDsAvailable (false),
    _RouteGuidanceDisplayComponentIDs (),
    _bIndexAvailable (false),
    _Index (0u),
    _bManeuverDescriptionAvailable (false),
    _ManeuverDescription (),
    _bManeuverTypeAvailable (false),
    _e8ManeuverType (::mplay_appcontrol_fi_types::T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_NO_TURN),
    _bAfterManeuverRoadNameAvailable (false),
    _AfterManeuverRoadName (),
    _bDistanceBetweenManeuverAvailable (false),
    _DistanceBetweenManeuver (0u),
    _bDistanceBetweenManeuverDisplayStrAvailable (false),
    _DistanceBetweenManeuverDisplayStr (),
    _bDistanceBetweenManeuverDisplayUnitsAvailable (false),
    _e8DistanceBetweenManeuverDisplayUnits (::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_KM),
    _bDrivingSideAvailable (false),
    _e8DrivingSide (::mplay_appcontrol_fi_types::T_e8_DrivingSide__e8DIPO_DRIVING_SIDE_RIGHT),
    _bJunctionTypeAvailable (false),
    _e8JunctionType (::mplay_appcontrol_fi_types::T_e8_JunctionType__e8DIPO_JUNCTION_TYPE_SINGLE_INTERSECTION),
    _bJunctionElementAngleAvailable (false),
    _JunctionElementAngle (),
    _bJunctionElementExitAngleAvailable (false),
    _JunctionElementExitAngle (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_RouteGuidanceManeuverUpdate::T_RouteGuidanceManeuverUpdate (bool bRouteGuidanceDisplayComponentIDsAvailable_, const T_RouteGuidanceDisplayComponentIDs& RouteGuidanceDisplayComponentIDs_, bool bIndexAvailable_, uint16 Index_, bool bManeuverDescriptionAvailable_, const ::std::string& ManeuverDescription_, bool bManeuverTypeAvailable_, T_e8_ManeuverType e8ManeuverType_, bool bAfterManeuverRoadNameAvailable_, const ::std::string& AfterManeuverRoadName_, bool bDistanceBetweenManeuverAvailable_, uint32 DistanceBetweenManeuver_, bool bDistanceBetweenManeuverDisplayStrAvailable_, const ::std::string& DistanceBetweenManeuverDisplayStr_, bool bDistanceBetweenManeuverDisplayUnitsAvailable_, T_e8_DistanceDisplayUnits e8DistanceBetweenManeuverDisplayUnits_, bool bDrivingSideAvailable_, T_e8_DrivingSide e8DrivingSide_, bool bJunctionTypeAvailable_, T_e8_JunctionType e8JunctionType_, bool bJunctionElementAngleAvailable_, const T_JunctionElementAngles& JunctionElementAngle_, bool bJunctionElementExitAngleAvailable_, int16 JunctionElementExitAngle_)  :
    _bRouteGuidanceDisplayComponentIDsAvailable (bRouteGuidanceDisplayComponentIDsAvailable_),
    _RouteGuidanceDisplayComponentIDs (RouteGuidanceDisplayComponentIDs_),
    _bIndexAvailable (bIndexAvailable_),
    _Index (Index_),
    _bManeuverDescriptionAvailable (bManeuverDescriptionAvailable_),
    _ManeuverDescription (ManeuverDescription_),
    _bManeuverTypeAvailable (bManeuverTypeAvailable_),
    _e8ManeuverType (e8ManeuverType_),
    _bAfterManeuverRoadNameAvailable (bAfterManeuverRoadNameAvailable_),
    _AfterManeuverRoadName (AfterManeuverRoadName_),
    _bDistanceBetweenManeuverAvailable (bDistanceBetweenManeuverAvailable_),
    _DistanceBetweenManeuver (DistanceBetweenManeuver_),
    _bDistanceBetweenManeuverDisplayStrAvailable (bDistanceBetweenManeuverDisplayStrAvailable_),
    _DistanceBetweenManeuverDisplayStr (DistanceBetweenManeuverDisplayStr_),
    _bDistanceBetweenManeuverDisplayUnitsAvailable (bDistanceBetweenManeuverDisplayUnitsAvailable_),
    _e8DistanceBetweenManeuverDisplayUnits (e8DistanceBetweenManeuverDisplayUnits_),
    _bDrivingSideAvailable (bDrivingSideAvailable_),
    _e8DrivingSide (e8DrivingSide_),
    _bJunctionTypeAvailable (bJunctionTypeAvailable_),
    _e8JunctionType (e8JunctionType_),
    _bJunctionElementAngleAvailable (bJunctionElementAngleAvailable_),
    _JunctionElementAngle (JunctionElementAngle_),
    _bJunctionElementExitAngleAvailable (bJunctionElementExitAngleAvailable_),
    _JunctionElementExitAngle (JunctionElementExitAngle_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ManeuverDescription_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_ManeuverType_IsValid(e8ManeuverType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ManeuverType_, "T_e8_ManeuverType", "e8ManeuverType", "T_RouteGuidanceManeuverUpdate");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AfterManeuverRoadName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DistanceBetweenManeuverDisplayStr_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_DistanceDisplayUnits_IsValid(e8DistanceBetweenManeuverDisplayUnits_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DistanceBetweenManeuverDisplayUnits_, "T_e8_DistanceDisplayUnits", "e8DistanceBetweenManeuverDisplayUnits", "T_RouteGuidanceManeuverUpdate");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_DrivingSide_IsValid(e8DrivingSide_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DrivingSide_, "T_e8_DrivingSide", "e8DrivingSide", "T_RouteGuidanceManeuverUpdate");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_JunctionType_IsValid(e8JunctionType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8JunctionType_, "T_e8_JunctionType", "e8JunctionType", "T_RouteGuidanceManeuverUpdate");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_RouteGuidanceManeuverUpdate::~T_RouteGuidanceManeuverUpdate() {
}

inline T_RouteGuidanceManeuverUpdate& T_RouteGuidanceManeuverUpdate::operator = (const T_RouteGuidanceManeuverUpdate& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBRouteGuidanceDisplayComponentIDsAvailable()) {
            setBRouteGuidanceDisplayComponentIDsAvailable(rhs.getBRouteGuidanceDisplayComponentIDsAvailable());
        } else {
            clearBRouteGuidanceDisplayComponentIDsAvailable();
        }
        if (rhs.hasRouteGuidanceDisplayComponentIDs()) {
            setRouteGuidanceDisplayComponentIDs(rhs.getRouteGuidanceDisplayComponentIDs());
        } else {
            clearRouteGuidanceDisplayComponentIDs();
        }
        if (rhs.hasBIndexAvailable()) {
            setBIndexAvailable(rhs.getBIndexAvailable());
        } else {
            clearBIndexAvailable();
        }
        if (rhs.hasIndex()) {
            setIndex(rhs.getIndex());
        } else {
            clearIndex();
        }
        if (rhs.hasBManeuverDescriptionAvailable()) {
            setBManeuverDescriptionAvailable(rhs.getBManeuverDescriptionAvailable());
        } else {
            clearBManeuverDescriptionAvailable();
        }
        if (rhs.hasManeuverDescription()) {
            setManeuverDescription(rhs.getManeuverDescription());
        } else {
            clearManeuverDescription();
        }
        if (rhs.hasBManeuverTypeAvailable()) {
            setBManeuverTypeAvailable(rhs.getBManeuverTypeAvailable());
        } else {
            clearBManeuverTypeAvailable();
        }
        if (rhs.hasE8ManeuverType()) {
            setE8ManeuverType(rhs.getE8ManeuverType());
        } else {
            clearE8ManeuverType();
        }
        if (rhs.hasBAfterManeuverRoadNameAvailable()) {
            setBAfterManeuverRoadNameAvailable(rhs.getBAfterManeuverRoadNameAvailable());
        } else {
            clearBAfterManeuverRoadNameAvailable();
        }
        if (rhs.hasAfterManeuverRoadName()) {
            setAfterManeuverRoadName(rhs.getAfterManeuverRoadName());
        } else {
            clearAfterManeuverRoadName();
        }
        if (rhs.hasBDistanceBetweenManeuverAvailable()) {
            setBDistanceBetweenManeuverAvailable(rhs.getBDistanceBetweenManeuverAvailable());
        } else {
            clearBDistanceBetweenManeuverAvailable();
        }
        if (rhs.hasDistanceBetweenManeuver()) {
            setDistanceBetweenManeuver(rhs.getDistanceBetweenManeuver());
        } else {
            clearDistanceBetweenManeuver();
        }
        if (rhs.hasBDistanceBetweenManeuverDisplayStrAvailable()) {
            setBDistanceBetweenManeuverDisplayStrAvailable(rhs.getBDistanceBetweenManeuverDisplayStrAvailable());
        } else {
            clearBDistanceBetweenManeuverDisplayStrAvailable();
        }
        if (rhs.hasDistanceBetweenManeuverDisplayStr()) {
            setDistanceBetweenManeuverDisplayStr(rhs.getDistanceBetweenManeuverDisplayStr());
        } else {
            clearDistanceBetweenManeuverDisplayStr();
        }
        if (rhs.hasBDistanceBetweenManeuverDisplayUnitsAvailable()) {
            setBDistanceBetweenManeuverDisplayUnitsAvailable(rhs.getBDistanceBetweenManeuverDisplayUnitsAvailable());
        } else {
            clearBDistanceBetweenManeuverDisplayUnitsAvailable();
        }
        if (rhs.hasE8DistanceBetweenManeuverDisplayUnits()) {
            setE8DistanceBetweenManeuverDisplayUnits(rhs.getE8DistanceBetweenManeuverDisplayUnits());
        } else {
            clearE8DistanceBetweenManeuverDisplayUnits();
        }
        if (rhs.hasBDrivingSideAvailable()) {
            setBDrivingSideAvailable(rhs.getBDrivingSideAvailable());
        } else {
            clearBDrivingSideAvailable();
        }
        if (rhs.hasE8DrivingSide()) {
            setE8DrivingSide(rhs.getE8DrivingSide());
        } else {
            clearE8DrivingSide();
        }
        if (rhs.hasBJunctionTypeAvailable()) {
            setBJunctionTypeAvailable(rhs.getBJunctionTypeAvailable());
        } else {
            clearBJunctionTypeAvailable();
        }
        if (rhs.hasE8JunctionType()) {
            setE8JunctionType(rhs.getE8JunctionType());
        } else {
            clearE8JunctionType();
        }
        if (rhs.hasBJunctionElementAngleAvailable()) {
            setBJunctionElementAngleAvailable(rhs.getBJunctionElementAngleAvailable());
        } else {
            clearBJunctionElementAngleAvailable();
        }
        if (rhs.hasJunctionElementAngle()) {
            setJunctionElementAngle(rhs.getJunctionElementAngle());
        } else {
            clearJunctionElementAngle();
        }
        if (rhs.hasBJunctionElementExitAngleAvailable()) {
            setBJunctionElementExitAngleAvailable(rhs.getBJunctionElementExitAngleAvailable());
        } else {
            clearBJunctionElementExitAngleAvailable();
        }
        if (rhs.hasJunctionElementExitAngle()) {
            setJunctionElementExitAngle(rhs.getJunctionElementExitAngle());
        } else {
            clearJunctionElementExitAngle();
        }
    }
    return *this;
}

inline bool T_RouteGuidanceManeuverUpdate::operator == (const T_RouteGuidanceManeuverUpdate& rhs) const {
    return (((!hasBRouteGuidanceDisplayComponentIDsAvailable() && !rhs.hasBRouteGuidanceDisplayComponentIDsAvailable()) || getBRouteGuidanceDisplayComponentIDsAvailable() == rhs.getBRouteGuidanceDisplayComponentIDsAvailable()) &&
        ((!hasRouteGuidanceDisplayComponentIDs() && !rhs.hasRouteGuidanceDisplayComponentIDs()) || getRouteGuidanceDisplayComponentIDs() == rhs.getRouteGuidanceDisplayComponentIDs()) &&
        ((!hasBIndexAvailable() && !rhs.hasBIndexAvailable()) || getBIndexAvailable() == rhs.getBIndexAvailable()) &&
        ((!hasIndex() && !rhs.hasIndex()) || getIndex() == rhs.getIndex()) &&
        ((!hasBManeuverDescriptionAvailable() && !rhs.hasBManeuverDescriptionAvailable()) || getBManeuverDescriptionAvailable() == rhs.getBManeuverDescriptionAvailable()) &&
        ((!hasManeuverDescription() && !rhs.hasManeuverDescription()) || getManeuverDescription() == rhs.getManeuverDescription()) &&
        ((!hasBManeuverTypeAvailable() && !rhs.hasBManeuverTypeAvailable()) || getBManeuverTypeAvailable() == rhs.getBManeuverTypeAvailable()) &&
        ((!hasE8ManeuverType() && !rhs.hasE8ManeuverType()) || getE8ManeuverType() == rhs.getE8ManeuverType()) &&
        ((!hasBAfterManeuverRoadNameAvailable() && !rhs.hasBAfterManeuverRoadNameAvailable()) || getBAfterManeuverRoadNameAvailable() == rhs.getBAfterManeuverRoadNameAvailable()) &&
        ((!hasAfterManeuverRoadName() && !rhs.hasAfterManeuverRoadName()) || getAfterManeuverRoadName() == rhs.getAfterManeuverRoadName()) &&
        ((!hasBDistanceBetweenManeuverAvailable() && !rhs.hasBDistanceBetweenManeuverAvailable()) || getBDistanceBetweenManeuverAvailable() == rhs.getBDistanceBetweenManeuverAvailable()) &&
        ((!hasDistanceBetweenManeuver() && !rhs.hasDistanceBetweenManeuver()) || getDistanceBetweenManeuver() == rhs.getDistanceBetweenManeuver()) &&
        ((!hasBDistanceBetweenManeuverDisplayStrAvailable() && !rhs.hasBDistanceBetweenManeuverDisplayStrAvailable()) || getBDistanceBetweenManeuverDisplayStrAvailable() == rhs.getBDistanceBetweenManeuverDisplayStrAvailable()) &&
        ((!hasDistanceBetweenManeuverDisplayStr() && !rhs.hasDistanceBetweenManeuverDisplayStr()) || getDistanceBetweenManeuverDisplayStr() == rhs.getDistanceBetweenManeuverDisplayStr()) &&
        ((!hasBDistanceBetweenManeuverDisplayUnitsAvailable() && !rhs.hasBDistanceBetweenManeuverDisplayUnitsAvailable()) || getBDistanceBetweenManeuverDisplayUnitsAvailable() == rhs.getBDistanceBetweenManeuverDisplayUnitsAvailable()) &&
        ((!hasE8DistanceBetweenManeuverDisplayUnits() && !rhs.hasE8DistanceBetweenManeuverDisplayUnits()) || getE8DistanceBetweenManeuverDisplayUnits() == rhs.getE8DistanceBetweenManeuverDisplayUnits()) &&
        ((!hasBDrivingSideAvailable() && !rhs.hasBDrivingSideAvailable()) || getBDrivingSideAvailable() == rhs.getBDrivingSideAvailable()) &&
        ((!hasE8DrivingSide() && !rhs.hasE8DrivingSide()) || getE8DrivingSide() == rhs.getE8DrivingSide()) &&
        ((!hasBJunctionTypeAvailable() && !rhs.hasBJunctionTypeAvailable()) || getBJunctionTypeAvailable() == rhs.getBJunctionTypeAvailable()) &&
        ((!hasE8JunctionType() && !rhs.hasE8JunctionType()) || getE8JunctionType() == rhs.getE8JunctionType()) &&
        ((!hasBJunctionElementAngleAvailable() && !rhs.hasBJunctionElementAngleAvailable()) || getBJunctionElementAngleAvailable() == rhs.getBJunctionElementAngleAvailable()) &&
        ((!hasJunctionElementAngle() && !rhs.hasJunctionElementAngle()) || getJunctionElementAngle() == rhs.getJunctionElementAngle()) &&
        ((!hasBJunctionElementExitAngleAvailable() && !rhs.hasBJunctionElementExitAngleAvailable()) || getBJunctionElementExitAngleAvailable() == rhs.getBJunctionElementExitAngleAvailable()) &&
        ((!hasJunctionElementExitAngle() && !rhs.hasJunctionElementExitAngle()) || getJunctionElementExitAngle() == rhs.getJunctionElementExitAngle()));
}

inline bool T_RouteGuidanceManeuverUpdate::operator != (const T_RouteGuidanceManeuverUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool T_RouteGuidanceManeuverUpdate::operator < (const T_RouteGuidanceManeuverUpdate& rhs) const {
    if (hasBRouteGuidanceDisplayComponentIDsAvailable() || rhs.hasBRouteGuidanceDisplayComponentIDsAvailable()) {
        if (getBRouteGuidanceDisplayComponentIDsAvailable() < rhs.getBRouteGuidanceDisplayComponentIDsAvailable()) return true;
        if (getBRouteGuidanceDisplayComponentIDsAvailable() > rhs.getBRouteGuidanceDisplayComponentIDsAvailable()) return false;
    }
    if (hasRouteGuidanceDisplayComponentIDs() || rhs.hasRouteGuidanceDisplayComponentIDs()) {
        if (getRouteGuidanceDisplayComponentIDs() < rhs.getRouteGuidanceDisplayComponentIDs()) return true;
        if (getRouteGuidanceDisplayComponentIDs() > rhs.getRouteGuidanceDisplayComponentIDs()) return false;
    }
    if (hasBIndexAvailable() || rhs.hasBIndexAvailable()) {
        if (getBIndexAvailable() < rhs.getBIndexAvailable()) return true;
        if (getBIndexAvailable() > rhs.getBIndexAvailable()) return false;
    }
    if (hasIndex() || rhs.hasIndex()) {
        if (getIndex() < rhs.getIndex()) return true;
        if (getIndex() > rhs.getIndex()) return false;
    }
    if (hasBManeuverDescriptionAvailable() || rhs.hasBManeuverDescriptionAvailable()) {
        if (getBManeuverDescriptionAvailable() < rhs.getBManeuverDescriptionAvailable()) return true;
        if (getBManeuverDescriptionAvailable() > rhs.getBManeuverDescriptionAvailable()) return false;
    }
    if (hasManeuverDescription() || rhs.hasManeuverDescription()) {
        if (getManeuverDescription() < rhs.getManeuverDescription()) return true;
        if (getManeuverDescription() > rhs.getManeuverDescription()) return false;
    }
    if (hasBManeuverTypeAvailable() || rhs.hasBManeuverTypeAvailable()) {
        if (getBManeuverTypeAvailable() < rhs.getBManeuverTypeAvailable()) return true;
        if (getBManeuverTypeAvailable() > rhs.getBManeuverTypeAvailable()) return false;
    }
    if (hasE8ManeuverType() || rhs.hasE8ManeuverType()) {
        if ((uint32)getE8ManeuverType() < (uint32)rhs.getE8ManeuverType()) return true;
        if ((uint32)getE8ManeuverType() > (uint32)rhs.getE8ManeuverType()) return false;
    }
    if (hasBAfterManeuverRoadNameAvailable() || rhs.hasBAfterManeuverRoadNameAvailable()) {
        if (getBAfterManeuverRoadNameAvailable() < rhs.getBAfterManeuverRoadNameAvailable()) return true;
        if (getBAfterManeuverRoadNameAvailable() > rhs.getBAfterManeuverRoadNameAvailable()) return false;
    }
    if (hasAfterManeuverRoadName() || rhs.hasAfterManeuverRoadName()) {
        if (getAfterManeuverRoadName() < rhs.getAfterManeuverRoadName()) return true;
        if (getAfterManeuverRoadName() > rhs.getAfterManeuverRoadName()) return false;
    }
    if (hasBDistanceBetweenManeuverAvailable() || rhs.hasBDistanceBetweenManeuverAvailable()) {
        if (getBDistanceBetweenManeuverAvailable() < rhs.getBDistanceBetweenManeuverAvailable()) return true;
        if (getBDistanceBetweenManeuverAvailable() > rhs.getBDistanceBetweenManeuverAvailable()) return false;
    }
    if (hasDistanceBetweenManeuver() || rhs.hasDistanceBetweenManeuver()) {
        if (getDistanceBetweenManeuver() < rhs.getDistanceBetweenManeuver()) return true;
        if (getDistanceBetweenManeuver() > rhs.getDistanceBetweenManeuver()) return false;
    }
    if (hasBDistanceBetweenManeuverDisplayStrAvailable() || rhs.hasBDistanceBetweenManeuverDisplayStrAvailable()) {
        if (getBDistanceBetweenManeuverDisplayStrAvailable() < rhs.getBDistanceBetweenManeuverDisplayStrAvailable()) return true;
        if (getBDistanceBetweenManeuverDisplayStrAvailable() > rhs.getBDistanceBetweenManeuverDisplayStrAvailable()) return false;
    }
    if (hasDistanceBetweenManeuverDisplayStr() || rhs.hasDistanceBetweenManeuverDisplayStr()) {
        if (getDistanceBetweenManeuverDisplayStr() < rhs.getDistanceBetweenManeuverDisplayStr()) return true;
        if (getDistanceBetweenManeuverDisplayStr() > rhs.getDistanceBetweenManeuverDisplayStr()) return false;
    }
    if (hasBDistanceBetweenManeuverDisplayUnitsAvailable() || rhs.hasBDistanceBetweenManeuverDisplayUnitsAvailable()) {
        if (getBDistanceBetweenManeuverDisplayUnitsAvailable() < rhs.getBDistanceBetweenManeuverDisplayUnitsAvailable()) return true;
        if (getBDistanceBetweenManeuverDisplayUnitsAvailable() > rhs.getBDistanceBetweenManeuverDisplayUnitsAvailable()) return false;
    }
    if (hasE8DistanceBetweenManeuverDisplayUnits() || rhs.hasE8DistanceBetweenManeuverDisplayUnits()) {
        if ((uint32)getE8DistanceBetweenManeuverDisplayUnits() < (uint32)rhs.getE8DistanceBetweenManeuverDisplayUnits()) return true;
        if ((uint32)getE8DistanceBetweenManeuverDisplayUnits() > (uint32)rhs.getE8DistanceBetweenManeuverDisplayUnits()) return false;
    }
    if (hasBDrivingSideAvailable() || rhs.hasBDrivingSideAvailable()) {
        if (getBDrivingSideAvailable() < rhs.getBDrivingSideAvailable()) return true;
        if (getBDrivingSideAvailable() > rhs.getBDrivingSideAvailable()) return false;
    }
    if (hasE8DrivingSide() || rhs.hasE8DrivingSide()) {
        if ((uint32)getE8DrivingSide() < (uint32)rhs.getE8DrivingSide()) return true;
        if ((uint32)getE8DrivingSide() > (uint32)rhs.getE8DrivingSide()) return false;
    }
    if (hasBJunctionTypeAvailable() || rhs.hasBJunctionTypeAvailable()) {
        if (getBJunctionTypeAvailable() < rhs.getBJunctionTypeAvailable()) return true;
        if (getBJunctionTypeAvailable() > rhs.getBJunctionTypeAvailable()) return false;
    }
    if (hasE8JunctionType() || rhs.hasE8JunctionType()) {
        if ((uint32)getE8JunctionType() < (uint32)rhs.getE8JunctionType()) return true;
        if ((uint32)getE8JunctionType() > (uint32)rhs.getE8JunctionType()) return false;
    }
    if (hasBJunctionElementAngleAvailable() || rhs.hasBJunctionElementAngleAvailable()) {
        if (getBJunctionElementAngleAvailable() < rhs.getBJunctionElementAngleAvailable()) return true;
        if (getBJunctionElementAngleAvailable() > rhs.getBJunctionElementAngleAvailable()) return false;
    }
    if (hasJunctionElementAngle() || rhs.hasJunctionElementAngle()) {
        if (getJunctionElementAngle() < rhs.getJunctionElementAngle()) return true;
        if (getJunctionElementAngle() > rhs.getJunctionElementAngle()) return false;
    }
    if (hasBJunctionElementExitAngleAvailable() || rhs.hasBJunctionElementExitAngleAvailable()) {
        if (getBJunctionElementExitAngleAvailable() < rhs.getBJunctionElementExitAngleAvailable()) return true;
        if (getBJunctionElementExitAngleAvailable() > rhs.getBJunctionElementExitAngleAvailable()) return false;
    }
    if (hasJunctionElementExitAngle() || rhs.hasJunctionElementExitAngle()) {
        if (getJunctionElementExitAngle() < rhs.getJunctionElementExitAngle()) return true;
        if (getJunctionElementExitAngle() > rhs.getJunctionElementExitAngle()) return false;
    }
    return false;
}

inline bool T_RouteGuidanceManeuverUpdate::operator > (const T_RouteGuidanceManeuverUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_RouteGuidanceManeuverUpdate::clear() {
    clearBRouteGuidanceDisplayComponentIDsAvailable();
    clearRouteGuidanceDisplayComponentIDs();
    clearBIndexAvailable();
    clearIndex();
    clearBManeuverDescriptionAvailable();
    clearManeuverDescription();
    clearBManeuverTypeAvailable();
    clearE8ManeuverType();
    clearBAfterManeuverRoadNameAvailable();
    clearAfterManeuverRoadName();
    clearBDistanceBetweenManeuverAvailable();
    clearDistanceBetweenManeuver();
    clearBDistanceBetweenManeuverDisplayStrAvailable();
    clearDistanceBetweenManeuverDisplayStr();
    clearBDistanceBetweenManeuverDisplayUnitsAvailable();
    clearE8DistanceBetweenManeuverDisplayUnits();
    clearBDrivingSideAvailable();
    clearE8DrivingSide();
    clearBJunctionTypeAvailable();
    clearE8JunctionType();
    clearBJunctionElementAngleAvailable();
    clearJunctionElementAngle();
    clearBJunctionElementExitAngleAvailable();
    clearJunctionElementExitAngle();
}

inline void T_RouteGuidanceManeuverUpdate::clearBRouteGuidanceDisplayComponentIDsAvailable() {
    if (hasBRouteGuidanceDisplayComponentIDsAvailable()) {
         clear_has_bRouteGuidanceDisplayComponentIDsAvailable();
        _bRouteGuidanceDisplayComponentIDsAvailable = false;
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasBRouteGuidanceDisplayComponentIDsAvailable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_RouteGuidanceManeuverUpdate::getBRouteGuidanceDisplayComponentIDsAvailable () const {
    return _bRouteGuidanceDisplayComponentIDsAvailable;
}

inline void T_RouteGuidanceManeuverUpdate::setBRouteGuidanceDisplayComponentIDsAvailable (bool bRouteGuidanceDisplayComponentIDsAvailable_) {
    set_has_bRouteGuidanceDisplayComponentIDsAvailable();
    this->_bRouteGuidanceDisplayComponentIDsAvailable = bRouteGuidanceDisplayComponentIDsAvailable_;
}

inline void T_RouteGuidanceManeuverUpdate::clearRouteGuidanceDisplayComponentIDs() {
    if (hasRouteGuidanceDisplayComponentIDs()) {
         clear_has_RouteGuidanceDisplayComponentIDs();
        _RouteGuidanceDisplayComponentIDs.clear();
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasRouteGuidanceDisplayComponentIDs () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_RouteGuidanceDisplayComponentIDs& T_RouteGuidanceManeuverUpdate::getRouteGuidanceDisplayComponentIDs () const {
    return _RouteGuidanceDisplayComponentIDs;
}

inline T_RouteGuidanceDisplayComponentIDs& T_RouteGuidanceManeuverUpdate::getRouteGuidanceDisplayComponentIDsMutable () {
    set_has_RouteGuidanceDisplayComponentIDs();
    return _RouteGuidanceDisplayComponentIDs;
}

inline void T_RouteGuidanceManeuverUpdate::setRouteGuidanceDisplayComponentIDs (const T_RouteGuidanceDisplayComponentIDs& RouteGuidanceDisplayComponentIDs_) {
    set_has_RouteGuidanceDisplayComponentIDs();
    this->_RouteGuidanceDisplayComponentIDs = RouteGuidanceDisplayComponentIDs_;
}

inline void T_RouteGuidanceManeuverUpdate::clearBIndexAvailable() {
    if (hasBIndexAvailable()) {
         clear_has_bIndexAvailable();
        _bIndexAvailable = false;
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasBIndexAvailable () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_RouteGuidanceManeuverUpdate::getBIndexAvailable () const {
    return _bIndexAvailable;
}

inline void T_RouteGuidanceManeuverUpdate::setBIndexAvailable (bool bIndexAvailable_) {
    set_has_bIndexAvailable();
    this->_bIndexAvailable = bIndexAvailable_;
}

inline void T_RouteGuidanceManeuverUpdate::clearIndex() {
    if (hasIndex()) {
         clear_has_Index();
        _Index = 0u;
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasIndex () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 T_RouteGuidanceManeuverUpdate::getIndex () const {
    return _Index;
}

inline void T_RouteGuidanceManeuverUpdate::setIndex (uint16 Index_) {
    set_has_Index();
    this->_Index = Index_;
}

inline void T_RouteGuidanceManeuverUpdate::clearBManeuverDescriptionAvailable() {
    if (hasBManeuverDescriptionAvailable()) {
         clear_has_bManeuverDescriptionAvailable();
        _bManeuverDescriptionAvailable = false;
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasBManeuverDescriptionAvailable () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool T_RouteGuidanceManeuverUpdate::getBManeuverDescriptionAvailable () const {
    return _bManeuverDescriptionAvailable;
}

inline void T_RouteGuidanceManeuverUpdate::setBManeuverDescriptionAvailable (bool bManeuverDescriptionAvailable_) {
    set_has_bManeuverDescriptionAvailable();
    this->_bManeuverDescriptionAvailable = bManeuverDescriptionAvailable_;
}

inline void T_RouteGuidanceManeuverUpdate::clearManeuverDescription() {
    if (hasManeuverDescription()) {
         clear_has_ManeuverDescription();
        _ManeuverDescription.clear();
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasManeuverDescription () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_RouteGuidanceManeuverUpdate::getManeuverDescription () const {
    return _ManeuverDescription;
}

inline ::std::string& T_RouteGuidanceManeuverUpdate::getManeuverDescriptionMutable () {
    set_has_ManeuverDescription();
    return _ManeuverDescription;
}

inline void T_RouteGuidanceManeuverUpdate::setManeuverDescription (const ::std::string& ManeuverDescription_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ManeuverDescription_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ManeuverDescription();
    this->_ManeuverDescription = ManeuverDescription_;
}

inline void T_RouteGuidanceManeuverUpdate::setManeuverDescription (const char* ManeuverDescription_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ManeuverDescription_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ManeuverDescription();
    this->_ManeuverDescription.assign(ManeuverDescription_);
}

inline void T_RouteGuidanceManeuverUpdate::setManeuverDescription (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ManeuverDescription();
    this->_ManeuverDescription.assign(value, size);
}

inline void T_RouteGuidanceManeuverUpdate::clearBManeuverTypeAvailable() {
    if (hasBManeuverTypeAvailable()) {
         clear_has_bManeuverTypeAvailable();
        _bManeuverTypeAvailable = false;
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasBManeuverTypeAvailable () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool T_RouteGuidanceManeuverUpdate::getBManeuverTypeAvailable () const {
    return _bManeuverTypeAvailable;
}

inline void T_RouteGuidanceManeuverUpdate::setBManeuverTypeAvailable (bool bManeuverTypeAvailable_) {
    set_has_bManeuverTypeAvailable();
    this->_bManeuverTypeAvailable = bManeuverTypeAvailable_;
}

inline void T_RouteGuidanceManeuverUpdate::clearE8ManeuverType() {
    if (hasE8ManeuverType()) {
         clear_has_e8ManeuverType();
        _e8ManeuverType = ::mplay_appcontrol_fi_types::T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_NO_TURN;
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasE8ManeuverType () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline T_e8_ManeuverType T_RouteGuidanceManeuverUpdate::getE8ManeuverType () const {
    return _e8ManeuverType;
}

inline void T_RouteGuidanceManeuverUpdate::setE8ManeuverType (T_e8_ManeuverType e8ManeuverType_) {
    #ifndef NDEBUG
    if (!(T_e8_ManeuverType_IsValid(e8ManeuverType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ManeuverType_, "T_e8_ManeuverType", "e8ManeuverType", "T_RouteGuidanceManeuverUpdate");
    }
    #endif
    set_has_e8ManeuverType();
    this->_e8ManeuverType = e8ManeuverType_;
}

inline void T_RouteGuidanceManeuverUpdate::clearBAfterManeuverRoadNameAvailable() {
    if (hasBAfterManeuverRoadNameAvailable()) {
         clear_has_bAfterManeuverRoadNameAvailable();
        _bAfterManeuverRoadNameAvailable = false;
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasBAfterManeuverRoadNameAvailable () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline bool T_RouteGuidanceManeuverUpdate::getBAfterManeuverRoadNameAvailable () const {
    return _bAfterManeuverRoadNameAvailable;
}

inline void T_RouteGuidanceManeuverUpdate::setBAfterManeuverRoadNameAvailable (bool bAfterManeuverRoadNameAvailable_) {
    set_has_bAfterManeuverRoadNameAvailable();
    this->_bAfterManeuverRoadNameAvailable = bAfterManeuverRoadNameAvailable_;
}

inline void T_RouteGuidanceManeuverUpdate::clearAfterManeuverRoadName() {
    if (hasAfterManeuverRoadName()) {
         clear_has_AfterManeuverRoadName();
        _AfterManeuverRoadName.clear();
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasAfterManeuverRoadName () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::std::string& T_RouteGuidanceManeuverUpdate::getAfterManeuverRoadName () const {
    return _AfterManeuverRoadName;
}

inline ::std::string& T_RouteGuidanceManeuverUpdate::getAfterManeuverRoadNameMutable () {
    set_has_AfterManeuverRoadName();
    return _AfterManeuverRoadName;
}

inline void T_RouteGuidanceManeuverUpdate::setAfterManeuverRoadName (const ::std::string& AfterManeuverRoadName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AfterManeuverRoadName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AfterManeuverRoadName();
    this->_AfterManeuverRoadName = AfterManeuverRoadName_;
}

inline void T_RouteGuidanceManeuverUpdate::setAfterManeuverRoadName (const char* AfterManeuverRoadName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AfterManeuverRoadName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AfterManeuverRoadName();
    this->_AfterManeuverRoadName.assign(AfterManeuverRoadName_);
}

inline void T_RouteGuidanceManeuverUpdate::setAfterManeuverRoadName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AfterManeuverRoadName();
    this->_AfterManeuverRoadName.assign(value, size);
}

inline void T_RouteGuidanceManeuverUpdate::clearBDistanceBetweenManeuverAvailable() {
    if (hasBDistanceBetweenManeuverAvailable()) {
         clear_has_bDistanceBetweenManeuverAvailable();
        _bDistanceBetweenManeuverAvailable = false;
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasBDistanceBetweenManeuverAvailable () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline bool T_RouteGuidanceManeuverUpdate::getBDistanceBetweenManeuverAvailable () const {
    return _bDistanceBetweenManeuverAvailable;
}

inline void T_RouteGuidanceManeuverUpdate::setBDistanceBetweenManeuverAvailable (bool bDistanceBetweenManeuverAvailable_) {
    set_has_bDistanceBetweenManeuverAvailable();
    this->_bDistanceBetweenManeuverAvailable = bDistanceBetweenManeuverAvailable_;
}

inline void T_RouteGuidanceManeuverUpdate::clearDistanceBetweenManeuver() {
    if (hasDistanceBetweenManeuver()) {
         clear_has_DistanceBetweenManeuver();
        _DistanceBetweenManeuver = 0u;
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasDistanceBetweenManeuver () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline uint32 T_RouteGuidanceManeuverUpdate::getDistanceBetweenManeuver () const {
    return _DistanceBetweenManeuver;
}

inline void T_RouteGuidanceManeuverUpdate::setDistanceBetweenManeuver (uint32 DistanceBetweenManeuver_) {
    set_has_DistanceBetweenManeuver();
    this->_DistanceBetweenManeuver = DistanceBetweenManeuver_;
}

inline void T_RouteGuidanceManeuverUpdate::clearBDistanceBetweenManeuverDisplayStrAvailable() {
    if (hasBDistanceBetweenManeuverDisplayStrAvailable()) {
         clear_has_bDistanceBetweenManeuverDisplayStrAvailable();
        _bDistanceBetweenManeuverDisplayStrAvailable = false;
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasBDistanceBetweenManeuverDisplayStrAvailable () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline bool T_RouteGuidanceManeuverUpdate::getBDistanceBetweenManeuverDisplayStrAvailable () const {
    return _bDistanceBetweenManeuverDisplayStrAvailable;
}

inline void T_RouteGuidanceManeuverUpdate::setBDistanceBetweenManeuverDisplayStrAvailable (bool bDistanceBetweenManeuverDisplayStrAvailable_) {
    set_has_bDistanceBetweenManeuverDisplayStrAvailable();
    this->_bDistanceBetweenManeuverDisplayStrAvailable = bDistanceBetweenManeuverDisplayStrAvailable_;
}

inline void T_RouteGuidanceManeuverUpdate::clearDistanceBetweenManeuverDisplayStr() {
    if (hasDistanceBetweenManeuverDisplayStr()) {
         clear_has_DistanceBetweenManeuverDisplayStr();
        _DistanceBetweenManeuverDisplayStr.clear();
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasDistanceBetweenManeuverDisplayStr () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline const ::std::string& T_RouteGuidanceManeuverUpdate::getDistanceBetweenManeuverDisplayStr () const {
    return _DistanceBetweenManeuverDisplayStr;
}

inline ::std::string& T_RouteGuidanceManeuverUpdate::getDistanceBetweenManeuverDisplayStrMutable () {
    set_has_DistanceBetweenManeuverDisplayStr();
    return _DistanceBetweenManeuverDisplayStr;
}

inline void T_RouteGuidanceManeuverUpdate::setDistanceBetweenManeuverDisplayStr (const ::std::string& DistanceBetweenManeuverDisplayStr_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DistanceBetweenManeuverDisplayStr_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DistanceBetweenManeuverDisplayStr();
    this->_DistanceBetweenManeuverDisplayStr = DistanceBetweenManeuverDisplayStr_;
}

inline void T_RouteGuidanceManeuverUpdate::setDistanceBetweenManeuverDisplayStr (const char* DistanceBetweenManeuverDisplayStr_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DistanceBetweenManeuverDisplayStr_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DistanceBetweenManeuverDisplayStr();
    this->_DistanceBetweenManeuverDisplayStr.assign(DistanceBetweenManeuverDisplayStr_);
}

inline void T_RouteGuidanceManeuverUpdate::setDistanceBetweenManeuverDisplayStr (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DistanceBetweenManeuverDisplayStr();
    this->_DistanceBetweenManeuverDisplayStr.assign(value, size);
}

inline void T_RouteGuidanceManeuverUpdate::clearBDistanceBetweenManeuverDisplayUnitsAvailable() {
    if (hasBDistanceBetweenManeuverDisplayUnitsAvailable()) {
         clear_has_bDistanceBetweenManeuverDisplayUnitsAvailable();
        _bDistanceBetweenManeuverDisplayUnitsAvailable = false;
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasBDistanceBetweenManeuverDisplayUnitsAvailable () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline bool T_RouteGuidanceManeuverUpdate::getBDistanceBetweenManeuverDisplayUnitsAvailable () const {
    return _bDistanceBetweenManeuverDisplayUnitsAvailable;
}

inline void T_RouteGuidanceManeuverUpdate::setBDistanceBetweenManeuverDisplayUnitsAvailable (bool bDistanceBetweenManeuverDisplayUnitsAvailable_) {
    set_has_bDistanceBetweenManeuverDisplayUnitsAvailable();
    this->_bDistanceBetweenManeuverDisplayUnitsAvailable = bDistanceBetweenManeuverDisplayUnitsAvailable_;
}

inline void T_RouteGuidanceManeuverUpdate::clearE8DistanceBetweenManeuverDisplayUnits() {
    if (hasE8DistanceBetweenManeuverDisplayUnits()) {
         clear_has_e8DistanceBetweenManeuverDisplayUnits();
        _e8DistanceBetweenManeuverDisplayUnits = ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_KM;
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasE8DistanceBetweenManeuverDisplayUnits () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline T_e8_DistanceDisplayUnits T_RouteGuidanceManeuverUpdate::getE8DistanceBetweenManeuverDisplayUnits () const {
    return _e8DistanceBetweenManeuverDisplayUnits;
}

inline void T_RouteGuidanceManeuverUpdate::setE8DistanceBetweenManeuverDisplayUnits (T_e8_DistanceDisplayUnits e8DistanceBetweenManeuverDisplayUnits_) {
    #ifndef NDEBUG
    if (!(T_e8_DistanceDisplayUnits_IsValid(e8DistanceBetweenManeuverDisplayUnits_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DistanceBetweenManeuverDisplayUnits_, "T_e8_DistanceDisplayUnits", "e8DistanceBetweenManeuverDisplayUnits", "T_RouteGuidanceManeuverUpdate");
    }
    #endif
    set_has_e8DistanceBetweenManeuverDisplayUnits();
    this->_e8DistanceBetweenManeuverDisplayUnits = e8DistanceBetweenManeuverDisplayUnits_;
}

inline void T_RouteGuidanceManeuverUpdate::clearBDrivingSideAvailable() {
    if (hasBDrivingSideAvailable()) {
         clear_has_bDrivingSideAvailable();
        _bDrivingSideAvailable = false;
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasBDrivingSideAvailable () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline bool T_RouteGuidanceManeuverUpdate::getBDrivingSideAvailable () const {
    return _bDrivingSideAvailable;
}

inline void T_RouteGuidanceManeuverUpdate::setBDrivingSideAvailable (bool bDrivingSideAvailable_) {
    set_has_bDrivingSideAvailable();
    this->_bDrivingSideAvailable = bDrivingSideAvailable_;
}

inline void T_RouteGuidanceManeuverUpdate::clearE8DrivingSide() {
    if (hasE8DrivingSide()) {
         clear_has_e8DrivingSide();
        _e8DrivingSide = ::mplay_appcontrol_fi_types::T_e8_DrivingSide__e8DIPO_DRIVING_SIDE_RIGHT;
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasE8DrivingSide () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline T_e8_DrivingSide T_RouteGuidanceManeuverUpdate::getE8DrivingSide () const {
    return _e8DrivingSide;
}

inline void T_RouteGuidanceManeuverUpdate::setE8DrivingSide (T_e8_DrivingSide e8DrivingSide_) {
    #ifndef NDEBUG
    if (!(T_e8_DrivingSide_IsValid(e8DrivingSide_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DrivingSide_, "T_e8_DrivingSide", "e8DrivingSide", "T_RouteGuidanceManeuverUpdate");
    }
    #endif
    set_has_e8DrivingSide();
    this->_e8DrivingSide = e8DrivingSide_;
}

inline void T_RouteGuidanceManeuverUpdate::clearBJunctionTypeAvailable() {
    if (hasBJunctionTypeAvailable()) {
         clear_has_bJunctionTypeAvailable();
        _bJunctionTypeAvailable = false;
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasBJunctionTypeAvailable () const {
    return (_has_bits_[0] & (1u << 18)) > 0;
}

inline bool T_RouteGuidanceManeuverUpdate::getBJunctionTypeAvailable () const {
    return _bJunctionTypeAvailable;
}

inline void T_RouteGuidanceManeuverUpdate::setBJunctionTypeAvailable (bool bJunctionTypeAvailable_) {
    set_has_bJunctionTypeAvailable();
    this->_bJunctionTypeAvailable = bJunctionTypeAvailable_;
}

inline void T_RouteGuidanceManeuverUpdate::clearE8JunctionType() {
    if (hasE8JunctionType()) {
         clear_has_e8JunctionType();
        _e8JunctionType = ::mplay_appcontrol_fi_types::T_e8_JunctionType__e8DIPO_JUNCTION_TYPE_SINGLE_INTERSECTION;
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasE8JunctionType () const {
    return (_has_bits_[0] & (1u << 19)) > 0;
}

inline T_e8_JunctionType T_RouteGuidanceManeuverUpdate::getE8JunctionType () const {
    return _e8JunctionType;
}

inline void T_RouteGuidanceManeuverUpdate::setE8JunctionType (T_e8_JunctionType e8JunctionType_) {
    #ifndef NDEBUG
    if (!(T_e8_JunctionType_IsValid(e8JunctionType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8JunctionType_, "T_e8_JunctionType", "e8JunctionType", "T_RouteGuidanceManeuverUpdate");
    }
    #endif
    set_has_e8JunctionType();
    this->_e8JunctionType = e8JunctionType_;
}

inline void T_RouteGuidanceManeuverUpdate::clearBJunctionElementAngleAvailable() {
    if (hasBJunctionElementAngleAvailable()) {
         clear_has_bJunctionElementAngleAvailable();
        _bJunctionElementAngleAvailable = false;
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasBJunctionElementAngleAvailable () const {
    return (_has_bits_[0] & (1u << 20)) > 0;
}

inline bool T_RouteGuidanceManeuverUpdate::getBJunctionElementAngleAvailable () const {
    return _bJunctionElementAngleAvailable;
}

inline void T_RouteGuidanceManeuverUpdate::setBJunctionElementAngleAvailable (bool bJunctionElementAngleAvailable_) {
    set_has_bJunctionElementAngleAvailable();
    this->_bJunctionElementAngleAvailable = bJunctionElementAngleAvailable_;
}

inline void T_RouteGuidanceManeuverUpdate::clearJunctionElementAngle() {
    if (hasJunctionElementAngle()) {
         clear_has_JunctionElementAngle();
        _JunctionElementAngle.clear();
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasJunctionElementAngle () const {
    return (_has_bits_[0] & (1u << 21)) > 0;
}

inline const T_JunctionElementAngles& T_RouteGuidanceManeuverUpdate::getJunctionElementAngle () const {
    return _JunctionElementAngle;
}

inline T_JunctionElementAngles& T_RouteGuidanceManeuverUpdate::getJunctionElementAngleMutable () {
    set_has_JunctionElementAngle();
    return _JunctionElementAngle;
}

inline void T_RouteGuidanceManeuverUpdate::setJunctionElementAngle (const T_JunctionElementAngles& JunctionElementAngle_) {
    set_has_JunctionElementAngle();
    this->_JunctionElementAngle = JunctionElementAngle_;
}

inline void T_RouteGuidanceManeuverUpdate::clearBJunctionElementExitAngleAvailable() {
    if (hasBJunctionElementExitAngleAvailable()) {
         clear_has_bJunctionElementExitAngleAvailable();
        _bJunctionElementExitAngleAvailable = false;
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasBJunctionElementExitAngleAvailable () const {
    return (_has_bits_[0] & (1u << 22)) > 0;
}

inline bool T_RouteGuidanceManeuverUpdate::getBJunctionElementExitAngleAvailable () const {
    return _bJunctionElementExitAngleAvailable;
}

inline void T_RouteGuidanceManeuverUpdate::setBJunctionElementExitAngleAvailable (bool bJunctionElementExitAngleAvailable_) {
    set_has_bJunctionElementExitAngleAvailable();
    this->_bJunctionElementExitAngleAvailable = bJunctionElementExitAngleAvailable_;
}

inline void T_RouteGuidanceManeuverUpdate::clearJunctionElementExitAngle() {
    if (hasJunctionElementExitAngle()) {
         clear_has_JunctionElementExitAngle();
        _JunctionElementExitAngle = 0;
     }
}

inline bool T_RouteGuidanceManeuverUpdate::hasJunctionElementExitAngle () const {
    return (_has_bits_[0] & (1u << 23)) > 0;
}

inline int16 T_RouteGuidanceManeuverUpdate::getJunctionElementExitAngle () const {
    return _JunctionElementExitAngle;
}

inline void T_RouteGuidanceManeuverUpdate::setJunctionElementExitAngle (int16 JunctionElementExitAngle_) {
    set_has_JunctionElementExitAngle();
    this->_JunctionElementExitAngle = JunctionElementExitAngle_;
}

inline void T_RouteGuidanceManeuverUpdate::set_has_bRouteGuidanceDisplayComponentIDsAvailable () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_bRouteGuidanceDisplayComponentIDsAvailable () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_RouteGuidanceDisplayComponentIDs () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_RouteGuidanceDisplayComponentIDs () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_bIndexAvailable () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_bIndexAvailable () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_Index () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_Index () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_bManeuverDescriptionAvailable () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_bManeuverDescriptionAvailable () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_ManeuverDescription () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_ManeuverDescription () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_bManeuverTypeAvailable () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_bManeuverTypeAvailable () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_e8ManeuverType () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_e8ManeuverType () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_bAfterManeuverRoadNameAvailable () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_bAfterManeuverRoadNameAvailable () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_AfterManeuverRoadName () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_AfterManeuverRoadName () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_bDistanceBetweenManeuverAvailable () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_bDistanceBetweenManeuverAvailable () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_DistanceBetweenManeuver () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_DistanceBetweenManeuver () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_bDistanceBetweenManeuverDisplayStrAvailable () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_bDistanceBetweenManeuverDisplayStrAvailable () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_DistanceBetweenManeuverDisplayStr () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_DistanceBetweenManeuverDisplayStr () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_bDistanceBetweenManeuverDisplayUnitsAvailable () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_bDistanceBetweenManeuverDisplayUnitsAvailable () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_e8DistanceBetweenManeuverDisplayUnits () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_e8DistanceBetweenManeuverDisplayUnits () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_bDrivingSideAvailable () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_bDrivingSideAvailable () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_e8DrivingSide () {
    _has_bits_[0] |= 1u << 17;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_e8DrivingSide () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_bJunctionTypeAvailable () {
    _has_bits_[0] |= 1u << 18;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_bJunctionTypeAvailable () {
    _has_bits_[0] &= ~ (1u << 18);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_e8JunctionType () {
    _has_bits_[0] |= 1u << 19;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_e8JunctionType () {
    _has_bits_[0] &= ~ (1u << 19);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_bJunctionElementAngleAvailable () {
    _has_bits_[0] |= 1u << 20;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_bJunctionElementAngleAvailable () {
    _has_bits_[0] &= ~ (1u << 20);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_JunctionElementAngle () {
    _has_bits_[0] |= 1u << 21;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_JunctionElementAngle () {
    _has_bits_[0] &= ~ (1u << 21);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_bJunctionElementExitAngleAvailable () {
    _has_bits_[0] |= 1u << 22;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_bJunctionElementExitAngleAvailable () {
    _has_bits_[0] &= ~ (1u << 22);
}

inline void T_RouteGuidanceManeuverUpdate::set_has_JunctionElementExitAngle () {
    _has_bits_[0] |= 1u << 23;
}

inline void T_RouteGuidanceManeuverUpdate::clear_has_JunctionElementExitAngle () {
    _has_bits_[0] &= ~ (1u << 23);
}

inline  T_CallControlsConfiguration::T_CallControlsConfiguration ()  :
    _InitiateCall (false),
    _AcceptCall (false),
    _EndCall (false),
    _SwapCalls (false),
    _MergeCalls (false),
    _HoldStatusUpdate (false),
    _MuteStatusUpdate (false),
    _SendDTMF (false)
{
}

inline  T_CallControlsConfiguration::T_CallControlsConfiguration (const T_CallControlsConfiguration &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_CallControlsConfiguration::T_CallControlsConfiguration (bool InitiateCall, bool AcceptCall, bool EndCall, bool SwapCalls, bool MergeCalls, bool HoldStatusUpdate, bool MuteStatusUpdate, bool SendDTMF) :
    _InitiateCall (InitiateCall),
    _AcceptCall (AcceptCall),
    _EndCall (EndCall),
    _SwapCalls (SwapCalls),
    _MergeCalls (MergeCalls),
    _HoldStatusUpdate (HoldStatusUpdate),
    _MuteStatusUpdate (MuteStatusUpdate),
    _SendDTMF (SendDTMF)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_CallControlsConfiguration& T_CallControlsConfiguration::operator = (const T_CallControlsConfiguration& rhs) {
    if( this != &rhs ) {
        _InitiateCall = rhs._InitiateCall;
        _AcceptCall = rhs._AcceptCall;
        _EndCall = rhs._EndCall;
        _SwapCalls = rhs._SwapCalls;
        _MergeCalls = rhs._MergeCalls;
        _HoldStatusUpdate = rhs._HoldStatusUpdate;
        _MuteStatusUpdate = rhs._MuteStatusUpdate;
        _SendDTMF = rhs._SendDTMF;
    }
    return *this;
}

inline bool T_CallControlsConfiguration::operator == (const T_CallControlsConfiguration& rhs) const {
    return (_InitiateCall == rhs._InitiateCall &&
        _AcceptCall == rhs._AcceptCall &&
        _EndCall == rhs._EndCall &&
        _SwapCalls == rhs._SwapCalls &&
        _MergeCalls == rhs._MergeCalls &&
        _HoldStatusUpdate == rhs._HoldStatusUpdate &&
        _MuteStatusUpdate == rhs._MuteStatusUpdate &&
        _SendDTMF == rhs._SendDTMF);
}

inline bool T_CallControlsConfiguration::operator != (const T_CallControlsConfiguration& rhs) const {
    return ! (*this == rhs);
}

inline bool T_CallControlsConfiguration::operator < (const T_CallControlsConfiguration& rhs) const {
    if (getInitiateCall() < rhs.getInitiateCall()) return true;
    if (getInitiateCall() > rhs.getInitiateCall()) return false;

    if (getAcceptCall() < rhs.getAcceptCall()) return true;
    if (getAcceptCall() > rhs.getAcceptCall()) return false;

    if (getEndCall() < rhs.getEndCall()) return true;
    if (getEndCall() > rhs.getEndCall()) return false;

    if (getSwapCalls() < rhs.getSwapCalls()) return true;
    if (getSwapCalls() > rhs.getSwapCalls()) return false;

    if (getMergeCalls() < rhs.getMergeCalls()) return true;
    if (getMergeCalls() > rhs.getMergeCalls()) return false;

    if (getHoldStatusUpdate() < rhs.getHoldStatusUpdate()) return true;
    if (getHoldStatusUpdate() > rhs.getHoldStatusUpdate()) return false;

    if (getMuteStatusUpdate() < rhs.getMuteStatusUpdate()) return true;
    if (getMuteStatusUpdate() > rhs.getMuteStatusUpdate()) return false;

    if (getSendDTMF() < rhs.getSendDTMF()) return true;
    if (getSendDTMF() > rhs.getSendDTMF()) return false;

    return false;
}

inline bool T_CallControlsConfiguration::operator > (const T_CallControlsConfiguration& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_CallControlsConfiguration::setInitiateCall (bool InitiateCall) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_InitiateCall = InitiateCall;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_CallControlsConfiguration::getInitiateCall () const {
    return _InitiateCall;
}

inline void T_CallControlsConfiguration::setAcceptCall (bool AcceptCall) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_AcceptCall = AcceptCall;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_CallControlsConfiguration::getAcceptCall () const {
    return _AcceptCall;
}

inline void T_CallControlsConfiguration::setEndCall (bool EndCall) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_EndCall = EndCall;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_CallControlsConfiguration::getEndCall () const {
    return _EndCall;
}

inline void T_CallControlsConfiguration::setSwapCalls (bool SwapCalls) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SwapCalls = SwapCalls;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_CallControlsConfiguration::getSwapCalls () const {
    return _SwapCalls;
}

inline void T_CallControlsConfiguration::setMergeCalls (bool MergeCalls) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_MergeCalls = MergeCalls;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_CallControlsConfiguration::getMergeCalls () const {
    return _MergeCalls;
}

inline void T_CallControlsConfiguration::setHoldStatusUpdate (bool HoldStatusUpdate) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_HoldStatusUpdate = HoldStatusUpdate;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_CallControlsConfiguration::getHoldStatusUpdate () const {
    return _HoldStatusUpdate;
}

inline void T_CallControlsConfiguration::setMuteStatusUpdate (bool MuteStatusUpdate) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_MuteStatusUpdate = MuteStatusUpdate;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_CallControlsConfiguration::getMuteStatusUpdate () const {
    return _MuteStatusUpdate;
}

inline void T_CallControlsConfiguration::setSendDTMF (bool SendDTMF) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SendDTMF = SendDTMF;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_CallControlsConfiguration::getSendDTMF () const {
    return _SendDTMF;
}

inline  T_AppInfo::T_AppInfo ()  :
    _sAppName (),
    _sProtocol (),
    _sBundleID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AppInfo::T_AppInfo (const T_AppInfo &rhs)  :
    _sAppName (),
    _sProtocol (),
    _sBundleID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AppInfo::T_AppInfo (const ::std::string& sAppName_, const ::std::string& sProtocol_, const ::std::string& sBundleID_)  :
    _sAppName (sAppName_),
    _sProtocol (sProtocol_),
    _sBundleID (sBundleID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sProtocol_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBundleID_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AppInfo::~T_AppInfo() {
}

inline T_AppInfo& T_AppInfo::operator = (const T_AppInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSAppName()) {
            setSAppName(rhs.getSAppName());
        } else {
            clearSAppName();
        }
        if (rhs.hasSProtocol()) {
            setSProtocol(rhs.getSProtocol());
        } else {
            clearSProtocol();
        }
        if (rhs.hasSBundleID()) {
            setSBundleID(rhs.getSBundleID());
        } else {
            clearSBundleID();
        }
    }
    return *this;
}

inline bool T_AppInfo::operator == (const T_AppInfo& rhs) const {
    return (((!hasSAppName() && !rhs.hasSAppName()) || getSAppName() == rhs.getSAppName()) &&
        ((!hasSProtocol() && !rhs.hasSProtocol()) || getSProtocol() == rhs.getSProtocol()) &&
        ((!hasSBundleID() && !rhs.hasSBundleID()) || getSBundleID() == rhs.getSBundleID()));
}

inline bool T_AppInfo::operator != (const T_AppInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AppInfo::operator < (const T_AppInfo& rhs) const {
    if (hasSAppName() || rhs.hasSAppName()) {
        if (getSAppName() < rhs.getSAppName()) return true;
        if (getSAppName() > rhs.getSAppName()) return false;
    }
    if (hasSProtocol() || rhs.hasSProtocol()) {
        if (getSProtocol() < rhs.getSProtocol()) return true;
        if (getSProtocol() > rhs.getSProtocol()) return false;
    }
    if (hasSBundleID() || rhs.hasSBundleID()) {
        if (getSBundleID() < rhs.getSBundleID()) return true;
        if (getSBundleID() > rhs.getSBundleID()) return false;
    }
    return false;
}

inline bool T_AppInfo::operator > (const T_AppInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AppInfo::clear() {
    clearSAppName();
    clearSProtocol();
    clearSBundleID();
}

inline void T_AppInfo::clearSAppName() {
    if (hasSAppName()) {
         clear_has_sAppName();
        _sAppName.clear();
     }
}

inline bool T_AppInfo::hasSAppName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_AppInfo::getSAppName () const {
    return _sAppName;
}

inline ::std::string& T_AppInfo::getSAppNameMutable () {
    set_has_sAppName();
    return _sAppName;
}

inline void T_AppInfo::setSAppName (const ::std::string& sAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAppName();
    this->_sAppName = sAppName_;
}

inline void T_AppInfo::setSAppName (const char* sAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAppName();
    this->_sAppName.assign(sAppName_);
}

inline void T_AppInfo::setSAppName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAppName();
    this->_sAppName.assign(value, size);
}

inline void T_AppInfo::clearSProtocol() {
    if (hasSProtocol()) {
         clear_has_sProtocol();
        _sProtocol.clear();
     }
}

inline bool T_AppInfo::hasSProtocol () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_AppInfo::getSProtocol () const {
    return _sProtocol;
}

inline ::std::string& T_AppInfo::getSProtocolMutable () {
    set_has_sProtocol();
    return _sProtocol;
}

inline void T_AppInfo::setSProtocol (const ::std::string& sProtocol_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sProtocol_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sProtocol();
    this->_sProtocol = sProtocol_;
}

inline void T_AppInfo::setSProtocol (const char* sProtocol_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sProtocol_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sProtocol();
    this->_sProtocol.assign(sProtocol_);
}

inline void T_AppInfo::setSProtocol (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sProtocol();
    this->_sProtocol.assign(value, size);
}

inline void T_AppInfo::clearSBundleID() {
    if (hasSBundleID()) {
         clear_has_sBundleID();
        _sBundleID.clear();
     }
}

inline bool T_AppInfo::hasSBundleID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_AppInfo::getSBundleID () const {
    return _sBundleID;
}

inline ::std::string& T_AppInfo::getSBundleIDMutable () {
    set_has_sBundleID();
    return _sBundleID;
}

inline void T_AppInfo::setSBundleID (const ::std::string& sBundleID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBundleID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sBundleID();
    this->_sBundleID = sBundleID_;
}

inline void T_AppInfo::setSBundleID (const char* sBundleID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBundleID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sBundleID();
    this->_sBundleID.assign(sBundleID_);
}

inline void T_AppInfo::setSBundleID (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sBundleID();
    this->_sBundleID.assign(value, size);
}

inline void T_AppInfo::set_has_sAppName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AppInfo::clear_has_sAppName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AppInfo::set_has_sProtocol () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AppInfo::clear_has_sProtocol () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_AppInfo::set_has_sBundleID () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_AppInfo::clear_has_sBundleID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_DeviceTimeUpdate::T_DeviceTimeUpdate ()  :
    _u64SecondsSinceReferenceDate (0u),
    _s16TimeZoneOffsetMinutes (0),
    _s8DaylightSavingsOffsetMinutes (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DeviceTimeUpdate::T_DeviceTimeUpdate (const T_DeviceTimeUpdate &rhs)  :
    _u64SecondsSinceReferenceDate (0u),
    _s16TimeZoneOffsetMinutes (0),
    _s8DaylightSavingsOffsetMinutes (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DeviceTimeUpdate::T_DeviceTimeUpdate (uint64 u64SecondsSinceReferenceDate_, int16 s16TimeZoneOffsetMinutes_, int8 s8DaylightSavingsOffsetMinutes_)  :
    _u64SecondsSinceReferenceDate (u64SecondsSinceReferenceDate_),
    _s16TimeZoneOffsetMinutes (s16TimeZoneOffsetMinutes_),
    _s8DaylightSavingsOffsetMinutes (s8DaylightSavingsOffsetMinutes_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DeviceTimeUpdate::~T_DeviceTimeUpdate() {
}

inline T_DeviceTimeUpdate& T_DeviceTimeUpdate::operator = (const T_DeviceTimeUpdate& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU64SecondsSinceReferenceDate()) {
            setU64SecondsSinceReferenceDate(rhs.getU64SecondsSinceReferenceDate());
        } else {
            clearU64SecondsSinceReferenceDate();
        }
        if (rhs.hasS16TimeZoneOffsetMinutes()) {
            setS16TimeZoneOffsetMinutes(rhs.getS16TimeZoneOffsetMinutes());
        } else {
            clearS16TimeZoneOffsetMinutes();
        }
        if (rhs.hasS8DaylightSavingsOffsetMinutes()) {
            setS8DaylightSavingsOffsetMinutes(rhs.getS8DaylightSavingsOffsetMinutes());
        } else {
            clearS8DaylightSavingsOffsetMinutes();
        }
    }
    return *this;
}

inline bool T_DeviceTimeUpdate::operator == (const T_DeviceTimeUpdate& rhs) const {
    return (((!hasU64SecondsSinceReferenceDate() && !rhs.hasU64SecondsSinceReferenceDate()) || getU64SecondsSinceReferenceDate() == rhs.getU64SecondsSinceReferenceDate()) &&
        ((!hasS16TimeZoneOffsetMinutes() && !rhs.hasS16TimeZoneOffsetMinutes()) || getS16TimeZoneOffsetMinutes() == rhs.getS16TimeZoneOffsetMinutes()) &&
        ((!hasS8DaylightSavingsOffsetMinutes() && !rhs.hasS8DaylightSavingsOffsetMinutes()) || getS8DaylightSavingsOffsetMinutes() == rhs.getS8DaylightSavingsOffsetMinutes()));
}

inline bool T_DeviceTimeUpdate::operator != (const T_DeviceTimeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DeviceTimeUpdate::operator < (const T_DeviceTimeUpdate& rhs) const {
    if (hasU64SecondsSinceReferenceDate() || rhs.hasU64SecondsSinceReferenceDate()) {
        if (getU64SecondsSinceReferenceDate() < rhs.getU64SecondsSinceReferenceDate()) return true;
        if (getU64SecondsSinceReferenceDate() > rhs.getU64SecondsSinceReferenceDate()) return false;
    }
    if (hasS16TimeZoneOffsetMinutes() || rhs.hasS16TimeZoneOffsetMinutes()) {
        if (getS16TimeZoneOffsetMinutes() < rhs.getS16TimeZoneOffsetMinutes()) return true;
        if (getS16TimeZoneOffsetMinutes() > rhs.getS16TimeZoneOffsetMinutes()) return false;
    }
    if (hasS8DaylightSavingsOffsetMinutes() || rhs.hasS8DaylightSavingsOffsetMinutes()) {
        if (getS8DaylightSavingsOffsetMinutes() < rhs.getS8DaylightSavingsOffsetMinutes()) return true;
        if (getS8DaylightSavingsOffsetMinutes() > rhs.getS8DaylightSavingsOffsetMinutes()) return false;
    }
    return false;
}

inline bool T_DeviceTimeUpdate::operator > (const T_DeviceTimeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DeviceTimeUpdate::clear() {
    clearU64SecondsSinceReferenceDate();
    clearS16TimeZoneOffsetMinutes();
    clearS8DaylightSavingsOffsetMinutes();
}

inline void T_DeviceTimeUpdate::clearU64SecondsSinceReferenceDate() {
    if (hasU64SecondsSinceReferenceDate()) {
         clear_has_u64SecondsSinceReferenceDate();
        _u64SecondsSinceReferenceDate = 0u;
     }
}

inline bool T_DeviceTimeUpdate::hasU64SecondsSinceReferenceDate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint64 T_DeviceTimeUpdate::getU64SecondsSinceReferenceDate () const {
    return _u64SecondsSinceReferenceDate;
}

inline void T_DeviceTimeUpdate::setU64SecondsSinceReferenceDate (uint64 u64SecondsSinceReferenceDate_) {
    set_has_u64SecondsSinceReferenceDate();
    this->_u64SecondsSinceReferenceDate = u64SecondsSinceReferenceDate_;
}

inline void T_DeviceTimeUpdate::clearS16TimeZoneOffsetMinutes() {
    if (hasS16TimeZoneOffsetMinutes()) {
         clear_has_s16TimeZoneOffsetMinutes();
        _s16TimeZoneOffsetMinutes = 0;
     }
}

inline bool T_DeviceTimeUpdate::hasS16TimeZoneOffsetMinutes () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 T_DeviceTimeUpdate::getS16TimeZoneOffsetMinutes () const {
    return _s16TimeZoneOffsetMinutes;
}

inline void T_DeviceTimeUpdate::setS16TimeZoneOffsetMinutes (int16 s16TimeZoneOffsetMinutes_) {
    set_has_s16TimeZoneOffsetMinutes();
    this->_s16TimeZoneOffsetMinutes = s16TimeZoneOffsetMinutes_;
}

inline void T_DeviceTimeUpdate::clearS8DaylightSavingsOffsetMinutes() {
    if (hasS8DaylightSavingsOffsetMinutes()) {
         clear_has_s8DaylightSavingsOffsetMinutes();
        _s8DaylightSavingsOffsetMinutes = 0;
     }
}

inline bool T_DeviceTimeUpdate::hasS8DaylightSavingsOffsetMinutes () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int8 T_DeviceTimeUpdate::getS8DaylightSavingsOffsetMinutes () const {
    return _s8DaylightSavingsOffsetMinutes;
}

inline void T_DeviceTimeUpdate::setS8DaylightSavingsOffsetMinutes (int8 s8DaylightSavingsOffsetMinutes_) {
    set_has_s8DaylightSavingsOffsetMinutes();
    this->_s8DaylightSavingsOffsetMinutes = s8DaylightSavingsOffsetMinutes_;
}

inline void T_DeviceTimeUpdate::set_has_u64SecondsSinceReferenceDate () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DeviceTimeUpdate::clear_has_u64SecondsSinceReferenceDate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DeviceTimeUpdate::set_has_s16TimeZoneOffsetMinutes () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DeviceTimeUpdate::clear_has_s16TimeZoneOffsetMinutes () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DeviceTimeUpdate::set_has_s8DaylightSavingsOffsetMinutes () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DeviceTimeUpdate::clear_has_s8DaylightSavingsOffsetMinutes () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace mplay_appcontrol_fi_types

#endif // MPLAY_APPCONTROL_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
