/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MPLAY_APPCONTROL_FIPROXY_H
#define MPLAY_APPCONTROL_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Blob.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "mplay_appcontrol_fi.h"
#include "mplay_appcontrol_fi_types.h"
#include "mplay_appcontrol_fi_typesConst.h"
#include <string>

namespace mplay_appcontrol_fi {

class Mplay_appcontrol_fiProxy;

class CloseCallbackIF {
public:
    virtual ~CloseCallbackIF() {}

    virtual void onCloseError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< CloseError >& error) = 0;

    virtual void onCloseResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< CloseResult >& result) = 0;
};

class CommandCallbackIF {
public:
    virtual ~CommandCallbackIF() {}

    virtual void onCommandError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< CommandError >& error) = 0;

    virtual void onCommandResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< CommandResult >& result) = 0;
};

class ConnectCallbackIF {
public:
    virtual ~ConnectCallbackIF() {}

    virtual void onConnectError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< ConnectError >& error) = 0;

    virtual void onConnectResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< ConnectResult >& result) = 0;
};

class ConnectedBluetoothProfilesCallbackIF {
public:
    virtual ~ConnectedBluetoothProfilesCallbackIF() {}

    virtual void onConnectedBluetoothProfilesError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< ConnectedBluetoothProfilesError >& error) = 0;

    virtual void onConnectedBluetoothProfilesStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< ConnectedBluetoothProfilesStatus >& status) = 0;
};

class DataResponseCallbackIF {
public:
    virtual ~DataResponseCallbackIF() {}

    virtual void onDataResponseError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DataResponseError >& error) = 0;

    virtual void onDataResponseStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DataResponseStatus >& status) = 0;
};

class DiPOAcceptCallCallbackIF {
public:
    virtual ~DiPOAcceptCallCallbackIF() {}

    virtual void onDiPOAcceptCallError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOAcceptCallError >& error) = 0;

    virtual void onDiPOAcceptCallResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOAcceptCallResult >& result) = 0;
};

class DiPOActiveDeviceCallbackIF {
public:
    virtual ~DiPOActiveDeviceCallbackIF() {}

    virtual void onDiPOActiveDeviceError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOActiveDeviceError >& error) = 0;

    virtual void onDiPOActiveDeviceResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOActiveDeviceResult >& result) = 0;
};

class DiPOBluetoothAudioDeviceStatusCallbackIF {
public:
    virtual ~DiPOBluetoothAudioDeviceStatusCallbackIF() {}

    virtual void onDiPOBluetoothAudioDeviceStatusError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOBluetoothAudioDeviceStatusError >& error) = 0;

    virtual void onDiPOBluetoothAudioDeviceStatusStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOBluetoothAudioDeviceStatusStatus >& status) = 0;
};

class DiPOCallDurationCallbackIF {
public:
    virtual ~DiPOCallDurationCallbackIF() {}

    virtual void onDiPOCallDurationError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOCallDurationError >& error) = 0;

    virtual void onDiPOCallDurationStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOCallDurationStatus >& status) = 0;
};

class DiPOCallStateCallbackIF {
public:
    virtual ~DiPOCallStateCallbackIF() {}

    virtual void onDiPOCallStateError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOCallStateError >& error) = 0;

    virtual void onDiPOCallStateStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOCallStateStatus >& status) = 0;
};

class DiPOCommunicationErrorCallbackIF {
public:
    virtual ~DiPOCommunicationErrorCallbackIF() {}

    virtual void onDiPOCommunicationErrorError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOCommunicationErrorError >& error) = 0;

    virtual void onDiPOCommunicationErrorStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOCommunicationErrorStatus >& status) = 0;
};

class DiPOCommunicationsCallbackIF {
public:
    virtual ~DiPOCommunicationsCallbackIF() {}

    virtual void onDiPOCommunicationsError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOCommunicationsError >& error) = 0;

    virtual void onDiPOCommunicationsStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOCommunicationsStatus >& status) = 0;
};

class DiPODeviceConnectionsCallbackIF {
public:
    virtual ~DiPODeviceConnectionsCallbackIF() {}

    virtual void onDiPODeviceConnectionsError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPODeviceConnectionsError >& error) = 0;

    virtual void onDiPODeviceConnectionsStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPODeviceConnectionsStatus >& status) = 0;
};

class DiPODeviceTimeUpdateCallbackIF {
public:
    virtual ~DiPODeviceTimeUpdateCallbackIF() {}

    virtual void onDiPODeviceTimeUpdateError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPODeviceTimeUpdateError >& error) = 0;

    virtual void onDiPODeviceTimeUpdateStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPODeviceTimeUpdateStatus >& status) = 0;
};

class DiPOEndCallCallbackIF {
public:
    virtual ~DiPOEndCallCallbackIF() {}

    virtual void onDiPOEndCallError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOEndCallError >& error) = 0;

    virtual void onDiPOEndCallResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOEndCallResult >& result) = 0;
};

class DiPOGPRMCDataStatusValuesCallbackIF {
public:
    virtual ~DiPOGPRMCDataStatusValuesCallbackIF() {}

    virtual void onDiPOGPRMCDataStatusValuesError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOGPRMCDataStatusValuesError >& error) = 0;

    virtual void onDiPOGPRMCDataStatusValuesStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOGPRMCDataStatusValuesStatus >& status) = 0;
};

class DiPOGetMediaObjectAlbumArtCallbackIF {
public:
    virtual ~DiPOGetMediaObjectAlbumArtCallbackIF() {}

    virtual void onDiPOGetMediaObjectAlbumArtError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOGetMediaObjectAlbumArtError >& error) = 0;

    virtual void onDiPOGetMediaObjectAlbumArtResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOGetMediaObjectAlbumArtResult >& result) = 0;
};

class DiPOGetMediaObjectAlbumArtInfoCallbackIF {
public:
    virtual ~DiPOGetMediaObjectAlbumArtInfoCallbackIF() {}

    virtual void onDiPOGetMediaObjectAlbumArtInfoError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOGetMediaObjectAlbumArtInfoError >& error) = 0;

    virtual void onDiPOGetMediaObjectAlbumArtInfoResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOGetMediaObjectAlbumArtInfoResult >& result) = 0;
};

class DiPOHoldStatusUpdateCallbackIF {
public:
    virtual ~DiPOHoldStatusUpdateCallbackIF() {}

    virtual void onDiPOHoldStatusUpdateError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOHoldStatusUpdateError >& error) = 0;

    virtual void onDiPOHoldStatusUpdateResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOHoldStatusUpdateResult >& result) = 0;
};

class DiPOInitiateCallCallbackIF {
public:
    virtual ~DiPOInitiateCallCallbackIF() {}

    virtual void onDiPOInitiateCallError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOInitiateCallError >& error) = 0;

    virtual void onDiPOInitiateCallResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOInitiateCallResult >& result) = 0;
};

class DiPOLocationInfoCallbackIF {
public:
    virtual ~DiPOLocationInfoCallbackIF() {}

    virtual void onDiPOLocationInfoError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOLocationInfoError >& error) = 0;

    virtual void onDiPOLocationInfoStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOLocationInfoStatus >& status) = 0;
};

class DiPOMergeCallsCallbackIF {
public:
    virtual ~DiPOMergeCallsCallbackIF() {}

    virtual void onDiPOMergeCallsError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOMergeCallsError >& error) = 0;

    virtual void onDiPOMergeCallsResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOMergeCallsResult >& result) = 0;
};

class DiPOMetaDataCallbackIF {
public:
    virtual ~DiPOMetaDataCallbackIF() {}

    virtual void onDiPOMetaDataError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOMetaDataError >& error) = 0;

    virtual void onDiPOMetaDataStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOMetaDataStatus >& status) = 0;
};

class DiPOMuteStatusUpdateCallbackIF {
public:
    virtual ~DiPOMuteStatusUpdateCallbackIF() {}

    virtual void onDiPOMuteStatusUpdateError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOMuteStatusUpdateError >& error) = 0;

    virtual void onDiPOMuteStatusUpdateResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOMuteStatusUpdateResult >& result) = 0;
};

class DiPONowPlayingCallbackIF {
public:
    virtual ~DiPONowPlayingCallbackIF() {}

    virtual void onDiPONowPlayingError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPONowPlayingError >& error) = 0;

    virtual void onDiPONowPlayingStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPONowPlayingStatus >& status) = 0;
};

class DiPOPhoneDataCallbackIF {
public:
    virtual ~DiPOPhoneDataCallbackIF() {}

    virtual void onDiPOPhoneDataError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOPhoneDataError >& error) = 0;

    virtual void onDiPOPhoneDataStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOPhoneDataStatus >& status) = 0;
};

class DiPOPlaybackRepeatModeCallbackIF {
public:
    virtual ~DiPOPlaybackRepeatModeCallbackIF() {}

    virtual void onDiPOPlaybackRepeatModeError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOPlaybackRepeatModeError >& error) = 0;

    virtual void onDiPOPlaybackRepeatModeStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOPlaybackRepeatModeStatus >& status) = 0;
};

class DiPOPlaybackShuffleModeCallbackIF {
public:
    virtual ~DiPOPlaybackShuffleModeCallbackIF() {}

    virtual void onDiPOPlaybackShuffleModeError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOPlaybackShuffleModeError >& error) = 0;

    virtual void onDiPOPlaybackShuffleModeStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOPlaybackShuffleModeStatus >& status) = 0;
};

class DiPOPlaybackStatusCallbackIF {
public:
    virtual ~DiPOPlaybackStatusCallbackIF() {}

    virtual void onDiPOPlaybackStatusError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOPlaybackStatusError >& error) = 0;

    virtual void onDiPOPlaybackStatusStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOPlaybackStatusStatus >& status) = 0;
};

class DiPOPlaytimeCallbackIF {
public:
    virtual ~DiPOPlaytimeCallbackIF() {}

    virtual void onDiPOPlaytimeError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOPlaytimeError >& error) = 0;

    virtual void onDiPOPlaytimeStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOPlaytimeStatus >& status) = 0;
};

class DiPOPowerCallbackIF {
public:
    virtual ~DiPOPowerCallbackIF() {}

    virtual void onDiPOPowerError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOPowerError >& error) = 0;

    virtual void onDiPOPowerStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOPowerStatus >& status) = 0;
};

class DiPOReleaseAudioDeviceCallbackIF {
public:
    virtual ~DiPOReleaseAudioDeviceCallbackIF() {}

    virtual void onDiPOReleaseAudioDeviceError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOReleaseAudioDeviceError >& error) = 0;

    virtual void onDiPOReleaseAudioDeviceResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOReleaseAudioDeviceResult >& result) = 0;
};

class DiPORequestAudioDeviceCallbackIF {
public:
    virtual ~DiPORequestAudioDeviceCallbackIF() {}

    virtual void onDiPORequestAudioDeviceError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPORequestAudioDeviceError >& error) = 0;

    virtual void onDiPORequestAudioDeviceResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPORequestAudioDeviceResult >& result) = 0;
};

class DiPORequestBluetoothAudioDeviceCallbackIF {
public:
    virtual ~DiPORequestBluetoothAudioDeviceCallbackIF() {}

    virtual void onDiPORequestBluetoothAudioDeviceError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPORequestBluetoothAudioDeviceError >& error) = 0;

    virtual void onDiPORequestBluetoothAudioDeviceResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPORequestBluetoothAudioDeviceResult >& result) = 0;
};

class DiPORequestPlaybackActionCallbackIF {
public:
    virtual ~DiPORequestPlaybackActionCallbackIF() {}

    virtual void onDiPORequestPlaybackActionError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPORequestPlaybackActionError >& error) = 0;

    virtual void onDiPORequestPlaybackActionResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPORequestPlaybackActionResult >& result) = 0;
};

class DiPORoleSwitchRequestCallbackIF {
public:
    virtual ~DiPORoleSwitchRequestCallbackIF() {}

    virtual void onDiPORoleSwitchRequestError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPORoleSwitchRequestError >& error) = 0;

    virtual void onDiPORoleSwitchRequestResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPORoleSwitchRequestResult >& result) = 0;
};

class DiPORouteGuidance2CallbackIF {
public:
    virtual ~DiPORouteGuidance2CallbackIF() {}

    virtual void onDiPORouteGuidance2Error(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPORouteGuidance2Error >& error) = 0;

    virtual void onDiPORouteGuidance2Status(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPORouteGuidance2Status >& status) = 0;
};

class DiPORouteGuidanceCallbackIF {
public:
    virtual ~DiPORouteGuidanceCallbackIF() {}

    virtual void onDiPORouteGuidanceError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPORouteGuidanceError >& error) = 0;

    virtual void onDiPORouteGuidanceStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPORouteGuidanceStatus >& status) = 0;
};

class DiPORouteGuidanceManeuver2CallbackIF {
public:
    virtual ~DiPORouteGuidanceManeuver2CallbackIF() {}

    virtual void onDiPORouteGuidanceManeuver2Error(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPORouteGuidanceManeuver2Error >& error) = 0;

    virtual void onDiPORouteGuidanceManeuver2Status(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPORouteGuidanceManeuver2Status >& status) = 0;
};

class DiPORouteGuidanceManeuverCallbackIF {
public:
    virtual ~DiPORouteGuidanceManeuverCallbackIF() {}

    virtual void onDiPORouteGuidanceManeuverError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPORouteGuidanceManeuverError >& error) = 0;

    virtual void onDiPORouteGuidanceManeuverStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPORouteGuidanceManeuverStatus >& status) = 0;
};

class DiPOSendDTMFCallbackIF {
public:
    virtual ~DiPOSendDTMFCallbackIF() {}

    virtual void onDiPOSendDTMFError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOSendDTMFError >& error) = 0;

    virtual void onDiPOSendDTMFResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOSendDTMFResult >& result) = 0;
};

class DiPOSetAppleIdentificationInfoCallbackIF {
public:
    virtual ~DiPOSetAppleIdentificationInfoCallbackIF() {}

    virtual void onDiPOSetAppleIdentificationInfoError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOSetAppleIdentificationInfoError >& error) = 0;

    virtual void onDiPOSetAppleIdentificationInfoResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOSetAppleIdentificationInfoResult >& result) = 0;
};

class DiPOSetCallControlsConfigurationCallbackIF {
public:
    virtual ~DiPOSetCallControlsConfigurationCallbackIF() {}

    virtual void onDiPOSetCallControlsConfigurationError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOSetCallControlsConfigurationError >& error) = 0;

    virtual void onDiPOSetCallControlsConfigurationResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOSetCallControlsConfigurationResult >& result) = 0;
};

class DiPOSetRouteGuidanceDisplayComponentInfoCallbackIF {
public:
    virtual ~DiPOSetRouteGuidanceDisplayComponentInfoCallbackIF() {}

    virtual void onDiPOSetRouteGuidanceDisplayComponentInfoError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOSetRouteGuidanceDisplayComponentInfoError >& error) = 0;

    virtual void onDiPOSetRouteGuidanceDisplayComponentInfoResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOSetRouteGuidanceDisplayComponentInfoResult >& result) = 0;
};

class DiPOStartIAP2OverCarPlayWifiCallbackIF {
public:
    virtual ~DiPOStartIAP2OverCarPlayWifiCallbackIF() {}

    virtual void onDiPOStartIAP2OverCarPlayWifiError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOStartIAP2OverCarPlayWifiError >& error) = 0;

    virtual void onDiPOStartIAP2OverCarPlayWifiResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOStartIAP2OverCarPlayWifiResult >& result) = 0;
};

class DiPOStartRouteGuidance2CallbackIF {
public:
    virtual ~DiPOStartRouteGuidance2CallbackIF() {}

    virtual void onDiPOStartRouteGuidance2Error(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOStartRouteGuidance2Error >& error) = 0;

    virtual void onDiPOStartRouteGuidance2Result(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOStartRouteGuidance2Result >& result) = 0;
};

class DiPOStartRouteGuidanceCallbackIF {
public:
    virtual ~DiPOStartRouteGuidanceCallbackIF() {}

    virtual void onDiPOStartRouteGuidanceError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOStartRouteGuidanceError >& error) = 0;

    virtual void onDiPOStartRouteGuidanceResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOStartRouteGuidanceResult >& result) = 0;
};

class DiPOStopRouteGuidance2CallbackIF {
public:
    virtual ~DiPOStopRouteGuidance2CallbackIF() {}

    virtual void onDiPOStopRouteGuidance2Error(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOStopRouteGuidance2Error >& error) = 0;

    virtual void onDiPOStopRouteGuidance2Result(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOStopRouteGuidance2Result >& result) = 0;
};

class DiPOStopRouteGuidanceCallbackIF {
public:
    virtual ~DiPOStopRouteGuidanceCallbackIF() {}

    virtual void onDiPOStopRouteGuidanceError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOStopRouteGuidanceError >& error) = 0;

    virtual void onDiPOStopRouteGuidanceResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOStopRouteGuidanceResult >& result) = 0;
};

class DiPOSwapCallsCallbackIF {
public:
    virtual ~DiPOSwapCallsCallbackIF() {}

    virtual void onDiPOSwapCallsError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOSwapCallsError >& error) = 0;

    virtual void onDiPOSwapCallsResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOSwapCallsResult >& result) = 0;
};

class DiPOTransferDRDataCallbackIF {
public:
    virtual ~DiPOTransferDRDataCallbackIF() {}

    virtual void onDiPOTransferDRDataError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOTransferDRDataError >& error) = 0;

    virtual void onDiPOTransferDRDataResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOTransferDRDataResult >& result) = 0;
};

class DiPOTransferGPSDataCallbackIF {
public:
    virtual ~DiPOTransferGPSDataCallbackIF() {}

    virtual void onDiPOTransferGPSDataError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOTransferGPSDataError >& error) = 0;

    virtual void onDiPOTransferGPSDataResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< DiPOTransferGPSDataResult >& result) = 0;
};

class NativeTransportStartCallbackIF {
public:
    virtual ~NativeTransportStartCallbackIF() {}

    virtual void onNativeTransportStartError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< NativeTransportStartError >& error) = 0;

    virtual void onNativeTransportStartStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< NativeTransportStartStatus >& status) = 0;
};

class NativeTransportStopCallbackIF {
public:
    virtual ~NativeTransportStopCallbackIF() {}

    virtual void onNativeTransportStopError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< NativeTransportStopError >& error) = 0;

    virtual void onNativeTransportStopStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< NativeTransportStopStatus >& status) = 0;
};

class SessionClosedCallbackIF {
public:
    virtual ~SessionClosedCallbackIF() {}

    virtual void onSessionClosedError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< SessionClosedError >& error) = 0;

    virtual void onSessionClosedStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< SessionClosedStatus >& status) = 0;
};

class SessionOpenedCallbackIF {
public:
    virtual ~SessionOpenedCallbackIF() {}

    virtual void onSessionOpenedError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< SessionOpenedError >& error) = 0;

    virtual void onSessionOpenedStatus(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< SessionOpenedStatus >& status) = 0;
};

class StartAudioCallbackIF {
public:
    virtual ~StartAudioCallbackIF() {}

    virtual void onStartAudioError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< StartAudioError >& error) = 0;

    virtual void onStartAudioResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< StartAudioResult >& result) = 0;
};

class StopAudioCallbackIF {
public:
    virtual ~StopAudioCallbackIF() {}

    virtual void onStopAudioError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< StopAudioError >& error) = 0;

    virtual void onStopAudioResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< StopAudioResult >& result) = 0;
};

class SwapCallsCallbackIF {
public:
    virtual ~SwapCallsCallbackIF() {}

    virtual void onSwapCallsError(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< SwapCallsError >& error) = 0;

    virtual void onSwapCallsResult(const ::boost::shared_ptr< Mplay_appcontrol_fiProxy >& proxy, const ::boost::shared_ptr< SwapCallsResult >& result) = 0;
};

class Mplay_appcontrol_fiProxyCallback;

/**
 * Mplay_appcontrol_fiProxy is the client side representation of the CCA
 * Functional Interface 'mplay_appcontrol_fi' (specified in file
 * mplay_appcontrol_fi.xml).
 *
 * CCA Functional Interface 'mplay_appcontrol_fi'
 *
 * Fullname: Application Control Interface
 *
 * Version: $Revision: 2.2$
 *
 * Author: Ulrich Deuper
 *
 * Date: $Date:22.10.2019$
 *
 * Department: BSOT/ENG
 *
 * Title: mplay_appcontrol_fi
 *
 * <b>Description of 'mplay_appcontrol_fi':</b>
 *
 * Application Control Interface
 */
class Mplay_appcontrol_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Mplay_appcontrol_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Mplay_appcontrol_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Mplay_appcontrol_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Mplay_appcontrol_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Mplay_appcontrol_fiProxy. The caller has to
     * pass the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Mplay_appcontrol_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Mplay_appcontrol_fiProxy. The destructor will send
     * RelUpReg messages for all property notifications and call the error
     * callback of all pending method invocations.
     */
    ~Mplay_appcontrol_fiProxy();

    // Method 'Connect'

    /**
     * Call the method 'Connect'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'Connect'</b>:
     *
     * The AppControl Connect method provides the interface for the Internet Radio to tell the
     * iPod device control to connect to the Pandora application using the MediaPlayer.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param szDeviceId A string containing the iPhone device HID name.
     *
     * @param szProtocol A string containing protocl of the IAP application.
     *
     * @param szBundleSeedID A string containing the bundle seed ID of the IAP application.
     *
     * @param szAppName A string containing App name of the IAP application.
     *
     * @param e8AppLaunchOption An enum containing the app launch option (e.g. user alert popup).
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectStart(ConnectCallbackIF& cb, const ::std::string& szDeviceId, const ::std::string& szProtocol, const ::std::string& szBundleSeedID, const ::std::string& szAppName, ::mplay_appcontrol_fi_types::T_e8_AppLaunchOption e8AppLaunchOption);

    // Method 'Command'

    /**
     * Call the method 'Command'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'Command'</b>:
     *
     * The AppControl Command method provides the interface for the Internet Radio to send
     * an IAP command to the MediaPlayer.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param szDeviceId A string containing the iPhone device HID name.
     *
     * @param szAppName A string containing the App name of the IAP application.
     *
     * @param u16SessionId The session ID of the connected IAP application.
     *
     * @param au8CommandBuffer IAP commands.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCommandStart(CommandCallbackIF& cb, const ::std::string& szDeviceId, const ::std::string& szAppName, uint16 u16SessionId, const ::asf::core::Blob& au8CommandBuffer);

    // Method 'Close'

    /**
     * Call the method 'Close'. This method sends a MethodStart message to the
     * CCA server.
     *
     * <b>Documentation of 'Close'</b>:
     *
     * The AppControl Close method provides the interface for the Internet Radio to send an IAP
     * command to the MediaPlayer to terminate the IAP session with the Pandora application.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param szDeviceId A string containing the iPhone device HID name
     *
     * @param szAppName A string containing the App name of the IAP application.
     *
     * @param u16SessionId The session ID of the connected IAP application.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCloseStart(CloseCallbackIF& cb, const ::std::string& szDeviceId, const ::std::string& szAppName, uint16 u16SessionId);

    // Method 'StartAudio'

    /**
     * Call the method 'StartAudio'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'StartAudio'</b>:
     *
     * Starts audio playback on apple device. This function must be called if application wants to playback an audio stream on apple device
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param szDeviceId A string containing the iPhone device HID name
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartAudioStart(StartAudioCallbackIF& cb, const ::std::string& szDeviceId);

    // Method 'StopAudio'

    /**
     * Call the method 'StopAudio'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'StopAudio'</b>:
     *
     * Stops audio playback on apple device. This function must be called if application does not want to play audio stream anymore.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param szDeviceId A string containing the iPhone device HID name
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStopAudioStart(StopAudioCallbackIF& cb, const ::std::string& szDeviceId);

    // Method 'DiPOActiveDevice'

    /**
     * Call the method 'DiPOActiveDevice'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DiPOActiveDevice'</b>:
     *
     * Deprecated!
     * MediaPlayer is informed when a device is used as DiPO device. This information can be used by MediaPlayer
     * to transfer metadata if available
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceTag Unique identifier of the device.
     *
     * @param bDiPOActive "True" if DiPO session is active. "False" if DiPO session is not active.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOActiveDeviceStart(DiPOActiveDeviceCallbackIF& cb, uint8 u8DeviceTag, bool bDiPOActive);

    // Method 'DiPORoleSwitchRequest'

    /**
     * Call the method 'DiPORoleSwitchRequest'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DiPORoleSwitchRequest'</b>:
     *
     * Requests a USB role switch: From USB client to USB host or vice versa
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceTag Unique identifier of the device.
     *
     * @param sDeviceUSBSerialNumber USB serial Number of Apple device.
     *
     * @param e8DiPORoleStatus Role status
     *
     * @param oAppInfo App name with Protocol(Carplay or MySpin or Carlife) and bundle id
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPORoleSwitchRequestStart(DiPORoleSwitchRequestCallbackIF& cb, uint8 u8DeviceTag, const ::std::string& sDeviceUSBSerialNumber, ::mplay_appcontrol_fi_types::T_e8_DiPORoleStatus e8DiPORoleStatus, const ::mplay_appcontrol_fi_types::T_AppInfo& oAppInfo);

    // Method 'DiPOGetMediaObjectAlbumArtInfo'

    /**
     * Call the method 'DiPOGetMediaObjectAlbumArtInfo'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DiPOGetMediaObjectAlbumArtInfo'</b>:
     *
     * This Method is used to retrieve the MIME type and size of the album art
     * image associated with a particular media object. The actual album art image is retrieved by calling the
     * DiPOGetMediaObjectAlbumArt function.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sAlbumArt Filename (URL) of the image to display for a given song
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOGetMediaObjectAlbumArtInfoStart(DiPOGetMediaObjectAlbumArtInfoCallbackIF& cb, const ::std::string& sAlbumArt);

    // Method 'DiPOGetMediaObjectAlbumArt'

    /**
     * Call the method 'DiPOGetMediaObjectAlbumArt'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DiPOGetMediaObjectAlbumArt'</b>:
     *
     * The DiPOGetMediaObjectAlbumArt method is called to retrieve the album art
     * image, if it exists, for a particular media object. The image is returned
     * in a MIME-typed image format. To get the MIME type, as well as image size,
     * controllers first call the DiPOGetMediaObjectAlbumArtInfo Method, retrieve the
     * MIME type and size to set up the retrieval of the album art, then call
     * DiPOGetMediaObjectAlbumArt to retrieve the actual image data.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sAlbumArt Filename (URL) of the image to display for a given song
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOGetMediaObjectAlbumArtStart(DiPOGetMediaObjectAlbumArtCallbackIF& cb, const ::std::string& sAlbumArt);

    // Method 'DiPOTransferGPSData'

    /**
     * Call the method 'DiPOTransferGPSData'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DiPOTransferGPSData'</b>:
     *
     * Transfers GPS data to DiPO device. If string is empty data is not transferred to apple device
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceTag Unique identifier of the device.
     *
     * @param sDeviceUSBSerialNumber USB serial Number of Apple device.
     *
     * @param sGPGGAData GPS data in GPGGA format as specified by apple
     *
     * @param sGPRMCData GPS data in GPRMC format as specified by apple
     *
     * @param sGPGSVData GPS data in GPGSV format as specified by apple
     *
     * @param sGPHDTData GPS data in GPHDT format as specified by apple
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOTransferGPSDataStart(DiPOTransferGPSDataCallbackIF& cb, uint8 u8DeviceTag, const ::std::string& sDeviceUSBSerialNumber, const ::std::string& sGPGGAData, const ::std::string& sGPRMCData, const ::std::string& sGPGSVData, const ::std::string& sGPHDTData);

    // Method 'DiPOTransferDRData'

    /**
     * Call the method 'DiPOTransferDRData'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DiPOTransferDRData'</b>:
     *
     * Transfers Dead Reckoning sensor data to DiPO device
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceTag Unique identifier of the device.
     *
     * @param sDeviceUSBSerialNumber USB serial Number of Apple device.
     *
     * @param sPASCDData Vehicle speed data arrang in the format as specified by apple
     *
     * @param sPAGCDData Vehicle gyro data arrang in the format as specified by apple
     *
     * @param sPAACDData Vehicle accelerometer data arrang in the format as specified by apple
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOTransferDRDataStart(DiPOTransferDRDataCallbackIF& cb, uint8 u8DeviceTag, const ::std::string& sDeviceUSBSerialNumber, const ::std::string& sPASCDData, const ::std::string& sPAGCDData, const ::std::string& sPAACDData);

    // Method 'DiPORequestAudioDevice'

    /**
     * Call the method 'DiPORequestAudioDevice'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DiPORequestAudioDevice'</b>:
     *
     * Request for DiPO Audio device name.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceTag Unique identifier of the device.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPORequestAudioDeviceStart(DiPORequestAudioDeviceCallbackIF& cb, uint8 u8DeviceTag);

    // Method 'DiPOReleaseAudioDevice'

    /**
     * Call the method 'DiPOReleaseAudioDevice'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DiPOReleaseAudioDevice'</b>:
     *
     * Request to release audio device.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceTag Unique identifier of the device.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOReleaseAudioDeviceStart(DiPOReleaseAudioDeviceCallbackIF& cb, uint8 u8DeviceTag);

    // Method 'DiPORequestPlaybackAction'

    /**
     * Call the method 'DiPORequestPlaybackAction'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DiPORequestPlaybackAction'</b>:
     *
     * Requests the playback action for a certain devicve
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceTag Unique identifier of the device.
     *
     * @param e8Action Specifies the playback action to request.
     *
     * @param u8NextPrevSkipCount The number of tracks to skip on a next or previous action.
     * Note that this parameter is unsigned and must be greater/equal 1.
     * This parameter is only defined for Next or Previous.
     * For the other Actions, it is not defined and shall be defaulted to 1.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPORequestPlaybackActionStart(DiPORequestPlaybackActionCallbackIF& cb, uint8 u8DeviceTag, ::mplay_appcontrol_fi_types::T_e8_DiPOPlaypackAction e8Action, uint8 u8NextPrevSkipCount);

    // Method 'DiPOStartIAP2OverCarPlayWifi'

    /**
     * Call the method 'DiPOStartIAP2OverCarPlayWifi'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DiPOStartIAP2OverCarPlayWifi'</b>:
     *
     * Requests to Start iAP2 session over Carplay Wifi
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sDeviceBTMacAddress BT Mac Address of the Apple device.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOStartIAP2OverCarPlayWifiStart(DiPOStartIAP2OverCarPlayWifiCallbackIF& cb, const ::std::string& sDeviceBTMacAddress);

    // Method 'DiPOStartRouteGuidance'

    /**
     * Call the method 'DiPOStartRouteGuidance'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DiPOStartRouteGuidance'</b>:
     *
     * StartRouteGuidanceUpdate must be sent when accessory is ready to display navigation route guidance
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sDeviceUSBSerialNumber USB serial Number of Apple device.
     *
     * @param u16RouteGuidanceDisplayComponentID If none are specified, assume all such components are being started.
     *
     * @param SourceName Must be included to receive SourceName in RouteGuidanceUpdate.
     * If SourceName is TRUE, we will receive name of application providing turn-by-turn information
     * in Carplay, for display purposes only. Eg: XL Gadget
     *
     * @param SourceSupportsRouteGuidance Must be included to receive SourceSupportsRouteGuidance in RouteGuidanceUpdate.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOStartRouteGuidanceStart(DiPOStartRouteGuidanceCallbackIF& cb, const ::std::string& sDeviceUSBSerialNumber, uint16 u16RouteGuidanceDisplayComponentID, bool sourceName, bool sourceSupportsRouteGuidance);

    // Method 'DiPOStopRouteGuidance'

    /**
     * Call the method 'DiPOStopRouteGuidance'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DiPOStopRouteGuidance'</b>:
     *
     * StopRouteGuidanceUpdate must be sent when navigation route guidance is not being displayed by the accessory.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sDeviceUSBSerialNumber USB serial Number of Apple device.
     *
     * @param u16RouteGuidanceDisplayComponentID If none are specified, assume all such components are to be stopped.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOStopRouteGuidanceStart(DiPOStopRouteGuidanceCallbackIF& cb, const ::std::string& sDeviceUSBSerialNumber, uint16 u16RouteGuidanceDisplayComponentID);

    // Method 'SwapCalls'

    /**
     * Call the method 'SwapCalls'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'SwapCalls'</b>:
     *
     * Swap current call with on hold call.
     * Deprecated : Use DiPOSwapCalls
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceTag Unique identifier of the iPhone device.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSwapCallsStart(SwapCallsCallbackIF& cb, uint8 u8DeviceTag);

    // Method 'DiPOSetRouteGuidanceDisplayComponentInfo'

    /**
     * Call the method 'DiPOSetRouteGuidanceDisplayComponentInfo'. This method
     * sends a MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DiPOSetRouteGuidanceDisplayComponentInfo'</b>:
     *
     * Set the RouteGuidance DisplayComponents information for iAP2 identification.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param RouteGuidanceDisplayComponents Display Components info.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOSetRouteGuidanceDisplayComponentInfoStart(DiPOSetRouteGuidanceDisplayComponentInfoCallbackIF& cb, const ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponents& routeGuidanceDisplayComponents);

    // Method 'DiPOStopRouteGuidance2'

    /**
     * Call the method 'DiPOStopRouteGuidance2'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DiPOStopRouteGuidance2'</b>:
     *
     * StopRouteGuidanceUpdate must be sent when navigation route guidance is not being displayed by the accessory.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sDeviceUSBSerialNumber USB serial Number of Apple device.
     *
     * @param RouteGuidanceDisplayComponentIDs If none are specified, assume all such components are to be stopped.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOStopRouteGuidance2Start(DiPOStopRouteGuidance2CallbackIF& cb, const ::std::string& sDeviceUSBSerialNumber, const ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponentIDs& routeGuidanceDisplayComponentIDs);

    // Method 'DiPOStartRouteGuidance2'

    /**
     * Call the method 'DiPOStartRouteGuidance2'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DiPOStartRouteGuidance2'</b>:
     *
     * StartRouteGuidanceUpdate must be sent when accessory is ready to display navigation route guidance
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sDeviceUSBSerialNumber USB serial Number of Apple device.
     *
     * @param RouteGuidanceDisplayComponentIDs If none are specified, assume all such components are being started.
     *
     * @param SourceName Must be included to receive SourceName in RouteGuidanceUpdate.
     *
     * @param SourceSupportsRouteGuidance Must be included to receive SourceSupportsRouteGuidance in RouteGuidanceUpdate.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOStartRouteGuidance2Start(DiPOStartRouteGuidance2CallbackIF& cb, const ::std::string& sDeviceUSBSerialNumber, const ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponentIDs& routeGuidanceDisplayComponentIDs, bool sourceName, bool sourceSupportsRouteGuidance);

    // Method 'DiPOSetCallControlsConfiguration'

    /**
     * Call the method 'DiPOSetCallControlsConfiguration'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DiPOSetCallControlsConfiguration'</b>:
     *
     * Set the CallControls message configuration information for iAP2 identification.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param callControlsConfiguration CallControls configuration info.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOSetCallControlsConfigurationStart(DiPOSetCallControlsConfigurationCallbackIF& cb, const ::mplay_appcontrol_fi_types::T_CallControlsConfiguration& callControlsConfiguration);

    // Method 'DiPOInitiateCall'

    /**
     * Call the method 'DiPOInitiateCall'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DiPOInitiateCall'</b>:
     *
     * Initiate call Method.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param deviceUSBSerialNumber USBSerialNumber of the iPhone device.
     *
     * @param type Initiate call type parameter.
     *
     * @param service Required for Destination call.
     * Telephony, FaceTimeAudio/Video
     *
     * @param destinationID Required for Destination call. Number to call.
     * Format: 4089961010
     * Format: +14089961010
     * (utf8 string)
     *
     * @param addressBookID AddressBookID parameter for InitiateCall.
     * (utf8 string)
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOInitiateCallStart(DiPOInitiateCallCallbackIF& cb, const ::std::string& deviceUSBSerialNumber, ::mplay_appcontrol_fi_types::T_e_InitiateCallType type, ::mplay_appcontrol_fi_types::T_e_InitiateCallService service, const ::std::string& destinationID, const ::std::string& addressBookID);

    // Method 'DiPOAcceptCall'

    /**
     * Call the method 'DiPOAcceptCall'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DiPOAcceptCall'</b>:
     *
     * Accept call Method.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param deviceUSBSerialNumber USBSerialNumber of the iPhone device.
     *
     * @param acceptAction Accept Action parameter.
     *
     * @param callUUID UUID of call to accept.
     * (utf8 string)
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOAcceptCallStart(DiPOAcceptCallCallbackIF& cb, const ::std::string& deviceUSBSerialNumber, ::mplay_appcontrol_fi_types::T_e_AcceptAction acceptAction, const ::std::string& callUUID);

    // Method 'DiPOEndCall'

    /**
     * Call the method 'DiPOEndCall'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'DiPOEndCall'</b>:
     *
     * End call Method.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param deviceUSBSerialNumber USBSerialNumber of the iPhone device.
     *
     * @param endAction End Action parameter.
     *
     * @param callUUID UUID of call to end.
     * (utf8 string)
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOEndCallStart(DiPOEndCallCallbackIF& cb, const ::std::string& deviceUSBSerialNumber, ::mplay_appcontrol_fi_types::T_e_EndAction endAction, const ::std::string& callUUID);

    // Method 'DiPOMergeCalls'

    /**
     * Call the method 'DiPOMergeCalls'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DiPOMergeCalls'</b>:
     *
     * Merge calls Method.
     * Note: Method not yet implemented.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param deviceUSBSerialNumber USBSerialNumber of the iPhone device.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOMergeCallsStart(DiPOMergeCallsCallbackIF& cb, const ::std::string& deviceUSBSerialNumber);

    // Method 'DiPOHoldStatusUpdate'

    /**
     * Call the method 'DiPOHoldStatusUpdate'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DiPOHoldStatusUpdate'</b>:
     *
     * HoldStatusUpdate method.
     * Note: Method not yet implemented.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param deviceUSBSerialNumber USBSerialNumber of the iPhone device.
     *
     * @param holdStatus HoldStatus parameter.
     *
     * @param callUUID UUID of call to update hold status.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOHoldStatusUpdateStart(DiPOHoldStatusUpdateCallbackIF& cb, const ::std::string& deviceUSBSerialNumber, bool holdStatus, const ::std::string& callUUID);

    // Method 'DiPOMuteStatusUpdate'

    /**
     * Call the method 'DiPOMuteStatusUpdate'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DiPOMuteStatusUpdate'</b>:
     *
     * MuteStatusUpdate method.
     * Note: Method not yet implemented.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param deviceUSBSerialNumber USBSerialNumber of the iPhone device.
     *
     * @param muteStatus MuteStatus parameter.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOMuteStatusUpdateStart(DiPOMuteStatusUpdateCallbackIF& cb, const ::std::string& deviceUSBSerialNumber, bool muteStatus);

    // Method 'DiPOSendDTMF'

    /**
     * Call the method 'DiPOSendDTMF'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'DiPOSendDTMF'</b>:
     *
     * SendDTMF method.
     * Note: Method not yet implemented.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param deviceUSBSerialNumber USBSerialNumber of the iPhone device.
     *
     * @param tone DTMFTone parameter.
     *
     * @param callUUID UUID of call to play tone.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOSendDTMFStart(DiPOSendDTMFCallbackIF& cb, const ::std::string& deviceUSBSerialNumber, ::mplay_appcontrol_fi_types::T_e_SendDTMFTone tone, const ::std::string& callUUID);

    // Method 'DiPOSwapCalls'

    /**
     * Call the method 'DiPOSwapCalls'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DiPOSwapCalls'</b>:
     *
     * Swap current call with on hold call.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param deviceUSBSerialNumber USBSerialNumber of the iPhone device.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOSwapCallsStart(DiPOSwapCallsCallbackIF& cb, const ::std::string& deviceUSBSerialNumber);

    // Method 'DiPOSetAppleIdentificationInfo'

    /**
     * Call the method 'DiPOSetAppleIdentificationInfo'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DiPOSetAppleIdentificationInfo'</b>:
     *
     * Set the neccessary iAP2 parameters required for iAP2 identification acceptance during Carplay session.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ProductPlanUUID It is a unique ID for each Product Plan ID in MFI portal.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOSetAppleIdentificationInfoStart(DiPOSetAppleIdentificationInfoCallbackIF& cb, const ::std::string& productPlanUUID);

    // Method 'DiPORequestBluetoothAudioDevice'

    /**
     * Call the method 'DiPORequestBluetoothAudioDevice'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DiPORequestBluetoothAudioDevice'</b>:
     *
     * Method to request or release BT audio device
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param bRequestAction Client has to request the BT audio device only if the pipe is free. This will be checked
     * by checking the status of property DiPOBluetoothAudioDeviceStatus.
     * 0 = release access to the audio device.
     * 1 = request access to the audio device.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPORequestBluetoothAudioDeviceStart(DiPORequestBluetoothAudioDeviceCallbackIF& cb, bool bRequestAction);

    // Property 'DataResponse'

    /**
     * Notify on the property 'DataResponse'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DataResponse'</b>:
     *
     * The AppControl Response property provides asynchronous notifications of the IAP
     * responses received from the iPod Device control to the Internet Radio FBlock over CCA.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDataResponseUpReg(DataResponseCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DataResponse'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DataResponse'</b>:
     *
     * The AppControl Response property provides asynchronous notifications of the IAP
     * responses received from the iPod Device control to the Internet Radio FBlock over CCA.
     *
     * @param act The act which was previously returned by the
     * sendDataResponseUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDataResponseRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DataResponse'.
     */
    void sendDataResponseRelUpRegAll ();

    /**
     * Returns the current value of the property 'DataResponse' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDataResponse() returns true.
     *
     * @return the previously received value of the property 'DataResponse'.
     */
    const DataResponseStatus& getDataResponse() const;

    /**
     * Determines whether a status message for the property 'DataResponse' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDataResponse() const;

    /**
     * Request the value of the property 'DataResponse' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DataResponse'</b>:
     *
     * The AppControl Response property provides asynchronous notifications of the IAP
     * responses received from the iPod Device control to the Internet Radio FBlock over CCA.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDataResponseGet(DataResponseCallbackIF& cb);

    // Property 'SessionOpened'

    /**
     * Notify on the property 'SessionOpened'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'SessionOpened'</b>:
     *
     * The AppControl Response property provides asynchronous notifications of the IAP
     * data session open event received from the iPod Device control to the Internet Radio FBlock over CCA.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSessionOpenedUpReg(SessionOpenedCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SessionOpened'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SessionOpened'</b>:
     *
     * The AppControl Response property provides asynchronous notifications of the IAP
     * data session open event received from the iPod Device control to the Internet Radio FBlock over CCA.
     *
     * @param act The act which was previously returned by the
     * sendSessionOpenedUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSessionOpenedRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SessionOpened'.
     */
    void sendSessionOpenedRelUpRegAll ();

    /**
     * Returns the current value of the property 'SessionOpened' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSessionOpened() returns true.
     *
     * @return the previously received value of the property 'SessionOpened'.
     */
    const SessionOpenedStatus& getSessionOpened() const;

    /**
     * Determines whether a status message for the property 'SessionOpened' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSessionOpened() const;

    /**
     * Request the value of the property 'SessionOpened' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SessionOpened'</b>:
     *
     * The AppControl Response property provides asynchronous notifications of the IAP
     * data session open event received from the iPod Device control to the Internet Radio FBlock over CCA.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSessionOpenedGet(SessionOpenedCallbackIF& cb);

    // Property 'SessionClosed'

    /**
     * Notify on the property 'SessionClosed'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'SessionClosed'</b>:
     *
     * The AppControl SessionClosed property provides asynchronous notifications of the IAP
     * data session close event received from the iPod Device control to the Internet Radio FBlock over CCA.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSessionClosedUpReg(SessionClosedCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SessionClosed'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SessionClosed'</b>:
     *
     * The AppControl SessionClosed property provides asynchronous notifications of the IAP
     * data session close event received from the iPod Device control to the Internet Radio FBlock over CCA.
     *
     * @param act The act which was previously returned by the
     * sendSessionClosedUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSessionClosedRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SessionClosed'.
     */
    void sendSessionClosedRelUpRegAll ();

    /**
     * Returns the current value of the property 'SessionClosed' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSessionClosed() returns true.
     *
     * @return the previously received value of the property 'SessionClosed'.
     */
    const SessionClosedStatus& getSessionClosed() const;

    /**
     * Determines whether a status message for the property 'SessionClosed' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSessionClosed() const;

    /**
     * Request the value of the property 'SessionClosed' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SessionClosed'</b>:
     *
     * The AppControl SessionClosed property provides asynchronous notifications of the IAP
     * data session close event received from the iPod Device control to the Internet Radio FBlock over CCA.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSessionClosedGet(SessionClosedCallbackIF& cb);

    // Property 'DiPODeviceConnections'

    /**
     * Notify on the property 'DiPODeviceConnections'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPODeviceConnections'</b>:
     *
     * Provides notification of the number of devices connected that support media playback.  For each connected device, this property provides specific information about the device.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPODeviceConnectionsUpReg(DiPODeviceConnectionsCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiPODeviceConnections'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPODeviceConnections'</b>:
     *
     * Provides notification of the number of devices connected that support media playback.  For each connected device, this property provides specific information about the device.
     *
     * @param act The act which was previously returned by the
     * sendDiPODeviceConnectionsUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiPODeviceConnectionsRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiPODeviceConnections'.
     */
    void sendDiPODeviceConnectionsRelUpRegAll ();

    /**
     * Returns the current value of the property 'DiPODeviceConnections' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDiPODeviceConnections() returns true.
     *
     * @return the previously received value of the property 'DiPODeviceConnections'.
     */
    const DiPODeviceConnectionsStatus& getDiPODeviceConnections() const;

    /**
     * Determines whether a status message for the property 'DiPODeviceConnections' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiPODeviceConnections() const;

    /**
     * Request the value of the property 'DiPODeviceConnections' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiPODeviceConnections'</b>:
     *
     * Provides notification of the number of devices connected that support media playback.  For each connected device, this property provides specific information about the device.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPODeviceConnectionsGet(DiPODeviceConnectionsCallbackIF& cb);

    // Property 'DiPOPlaytime'

    /**
     * Notify on the property 'DiPOPlaytime'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DiPOPlaytime'</b>:
     *
     * Identifies the amount of time elapsed and total duration of a media object. Resolution is in seconds.
     * The MediaPlayer shall send out updates to registered HMI controllers upon each 1 second change.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOPlaytimeUpReg(DiPOPlaytimeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiPOPlaytime'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPOPlaytime'</b>:
     *
     * Identifies the amount of time elapsed and total duration of a media object. Resolution is in seconds.
     * The MediaPlayer shall send out updates to registered HMI controllers upon each 1 second change.
     *
     * @param act The act which was previously returned by the
     * sendDiPOPlaytimeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiPOPlaytimeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiPOPlaytime'.
     */
    void sendDiPOPlaytimeRelUpRegAll ();

    /**
     * Returns the current value of the property 'DiPOPlaytime' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDiPOPlaytime() returns true.
     *
     * @return the previously received value of the property 'DiPOPlaytime'.
     */
    const DiPOPlaytimeStatus& getDiPOPlaytime() const;

    /**
     * Determines whether a status message for the property 'DiPOPlaytime' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiPOPlaytime() const;

    /**
     * Request the value of the property 'DiPOPlaytime' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiPOPlaytime'</b>:
     *
     * Identifies the amount of time elapsed and total duration of a media object. Resolution is in seconds.
     * The MediaPlayer shall send out updates to registered HMI controllers upon each 1 second change.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOPlaytimeGet(DiPOPlaytimeCallbackIF& cb);

    // Property 'DiPOLocationInfo'

    /**
     * Notify on the property 'DiPOLocationInfo'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DiPOLocationInfo'</b>:
     *
     * MediaPlayer informs the client if location info should be sent
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOLocationInfoUpReg(DiPOLocationInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiPOLocationInfo'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPOLocationInfo'</b>:
     *
     * MediaPlayer informs the client if location info should be sent
     *
     * @param act The act which was previously returned by the
     * sendDiPOLocationInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiPOLocationInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiPOLocationInfo'.
     */
    void sendDiPOLocationInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'DiPOLocationInfo' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDiPOLocationInfo() returns true.
     *
     * @return the previously received value of the property 'DiPOLocationInfo'.
     */
    const DiPOLocationInfoStatus& getDiPOLocationInfo() const;

    /**
     * Determines whether a status message for the property 'DiPOLocationInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiPOLocationInfo() const;

    /**
     * Request the value of the property 'DiPOLocationInfo' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiPOLocationInfo'</b>:
     *
     * MediaPlayer informs the client if location info should be sent
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOLocationInfoGet(DiPOLocationInfoCallbackIF& cb);

    // Property 'DiPOMetaData'

    /**
     * Notify on the property 'DiPOMetaData'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DiPOMetaData'</b>:
     *
     * Deprecated, use DiPONowPlaying instead.
     * Property contains the metadata of the currently playing song
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOMetaDataUpReg(DiPOMetaDataCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiPOMetaData'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPOMetaData'</b>:
     *
     * Deprecated, use DiPONowPlaying instead.
     * Property contains the metadata of the currently playing song
     *
     * @param act The act which was previously returned by the
     * sendDiPOMetaDataUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiPOMetaDataRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiPOMetaData'.
     */
    void sendDiPOMetaDataRelUpRegAll ();

    /**
     * Returns the current value of the property 'DiPOMetaData' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDiPOMetaData() returns true.
     *
     * @return the previously received value of the property 'DiPOMetaData'.
     */
    const DiPOMetaDataStatus& getDiPOMetaData() const;

    /**
     * Determines whether a status message for the property 'DiPOMetaData' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiPOMetaData() const;

    /**
     * Request the value of the property 'DiPOMetaData' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiPOMetaData'</b>:
     *
     * Deprecated, use DiPONowPlaying instead.
     * Property contains the metadata of the currently playing song
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOMetaDataGet(DiPOMetaDataCallbackIF& cb);

    // Property 'DiPOPhoneData'

    /**
     * Notify on the property 'DiPOPhoneData'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DiPOPhoneData'</b>:
     *
     * Deprecated, use DiPOCallState instead.
     * Property contains the phone information
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOPhoneDataUpReg(DiPOPhoneDataCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiPOPhoneData'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPOPhoneData'</b>:
     *
     * Deprecated, use DiPOCallState instead.
     * Property contains the phone information
     *
     * @param act The act which was previously returned by the
     * sendDiPOPhoneDataUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiPOPhoneDataRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiPOPhoneData'.
     */
    void sendDiPOPhoneDataRelUpRegAll ();

    /**
     * Returns the current value of the property 'DiPOPhoneData' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDiPOPhoneData() returns true.
     *
     * @return the previously received value of the property 'DiPOPhoneData'.
     */
    const DiPOPhoneDataStatus& getDiPOPhoneData() const;

    /**
     * Determines whether a status message for the property 'DiPOPhoneData' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiPOPhoneData() const;

    /**
     * Request the value of the property 'DiPOPhoneData' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiPOPhoneData'</b>:
     *
     * Deprecated, use DiPOCallState instead.
     * Property contains the phone information
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOPhoneDataGet(DiPOPhoneDataCallbackIF& cb);

    // Property 'NativeTransportStart'

    /**
     * Notify on the property 'NativeTransportStart'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'NativeTransportStart'</b>:
     *
     * The AppControl Response property provides asynchronous notifications of the IAP2
     * EA Native Transport Open event received from the iPod Device.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNativeTransportStartUpReg(NativeTransportStartCallbackIF& cb);

    /**
     * Remove the notifcation on property 'NativeTransportStart'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'NativeTransportStart'</b>:
     *
     * The AppControl Response property provides asynchronous notifications of the IAP2
     * EA Native Transport Open event received from the iPod Device.
     *
     * @param act The act which was previously returned by the
     * sendNativeTransportStartUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendNativeTransportStartRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'NativeTransportStart'.
     */
    void sendNativeTransportStartRelUpRegAll ();

    /**
     * Returns the current value of the property 'NativeTransportStart' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasNativeTransportStart() returns true.
     *
     * @return the previously received value of the property 'NativeTransportStart'.
     */
    const NativeTransportStartStatus& getNativeTransportStart() const;

    /**
     * Determines whether a status message for the property 'NativeTransportStart' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNativeTransportStart() const;

    /**
     * Request the value of the property 'NativeTransportStart' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'NativeTransportStart'</b>:
     *
     * The AppControl Response property provides asynchronous notifications of the IAP2
     * EA Native Transport Open event received from the iPod Device.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNativeTransportStartGet(NativeTransportStartCallbackIF& cb);

    // Property 'NativeTransportStop'

    /**
     * Notify on the property 'NativeTransportStop'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'NativeTransportStop'</b>:
     *
     * The AppControl Response property provides asynchronous notifications of the IAP2
     * EA Native Transport Close event received from the iPod Device.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNativeTransportStopUpReg(NativeTransportStopCallbackIF& cb);

    /**
     * Remove the notifcation on property 'NativeTransportStop'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'NativeTransportStop'</b>:
     *
     * The AppControl Response property provides asynchronous notifications of the IAP2
     * EA Native Transport Close event received from the iPod Device.
     *
     * @param act The act which was previously returned by the
     * sendNativeTransportStopUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendNativeTransportStopRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'NativeTransportStop'.
     */
    void sendNativeTransportStopRelUpRegAll ();

    /**
     * Returns the current value of the property 'NativeTransportStop' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasNativeTransportStop() returns true.
     *
     * @return the previously received value of the property 'NativeTransportStop'.
     */
    const NativeTransportStopStatus& getNativeTransportStop() const;

    /**
     * Determines whether a status message for the property 'NativeTransportStop' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNativeTransportStop() const;

    /**
     * Request the value of the property 'NativeTransportStop' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'NativeTransportStop'</b>:
     *
     * The AppControl Response property provides asynchronous notifications of the IAP2
     * EA Native Transport Close event received from the iPod Device.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNativeTransportStopGet(NativeTransportStopCallbackIF& cb);

    // Property 'ConnectedBluetoothProfiles'

    /**
     * Notify on the property 'ConnectedBluetoothProfiles'. This method sends
     * a UpReg message to the CCA server.
     *
     * <b>Documentation of 'ConnectedBluetoothProfiles'</b>:
     *
     * MediaPlayer informs the client about connected bluetooth profiles (iAP2 connections, host and device mode)
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectedBluetoothProfilesUpReg(ConnectedBluetoothProfilesCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ConnectedBluetoothProfiles'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ConnectedBluetoothProfiles'</b>:
     *
     * MediaPlayer informs the client about connected bluetooth profiles (iAP2 connections, host and device mode)
     *
     * @param act The act which was previously returned by the
     * sendConnectedBluetoothProfilesUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendConnectedBluetoothProfilesRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ConnectedBluetoothProfiles'.
     */
    void sendConnectedBluetoothProfilesRelUpRegAll ();

    /**
     * Returns the current value of the property 'ConnectedBluetoothProfiles'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasConnectedBluetoothProfiles() returns true.
     *
     * @return the previously received value of the property 'ConnectedBluetoothProfiles'.
     */
    const ConnectedBluetoothProfilesStatus& getConnectedBluetoothProfiles() const;

    /**
     * Determines whether a status message for the property 'ConnectedBluetoothProfiles' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasConnectedBluetoothProfiles() const;

    /**
     * Request the value of the property 'ConnectedBluetoothProfiles' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'ConnectedBluetoothProfiles'</b>:
     *
     * MediaPlayer informs the client about connected bluetooth profiles (iAP2 connections, host and device mode)
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectedBluetoothProfilesGet(ConnectedBluetoothProfilesCallbackIF& cb);

    // Property 'DiPONowPlaying'

    /**
     * Notify on the property 'DiPONowPlaying'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DiPONowPlaying'</b>:
     *
     * Property contains all metadata of the last iAP2 NowPlayingUpdate from the current DiPO device
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPONowPlayingUpReg(DiPONowPlayingCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiPONowPlaying'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPONowPlaying'</b>:
     *
     * Property contains all metadata of the last iAP2 NowPlayingUpdate from the current DiPO device
     *
     * @param act The act which was previously returned by the
     * sendDiPONowPlayingUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiPONowPlayingRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiPONowPlaying'.
     */
    void sendDiPONowPlayingRelUpRegAll ();

    /**
     * Returns the current value of the property 'DiPONowPlaying' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDiPONowPlaying() returns true.
     *
     * @return the previously received value of the property 'DiPONowPlaying'.
     */
    const DiPONowPlayingStatus& getDiPONowPlaying() const;

    /**
     * Determines whether a status message for the property 'DiPONowPlaying' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiPONowPlaying() const;

    /**
     * Request the value of the property 'DiPONowPlaying' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiPONowPlaying'</b>:
     *
     * Property contains all metadata of the last iAP2 NowPlayingUpdate from the current DiPO device
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPONowPlayingGet(DiPONowPlayingCallbackIF& cb);

    // Property 'DiPOPlaybackStatus'

    /**
     * Notify on the property 'DiPOPlaybackStatus'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DiPOPlaybackStatus'</b>:
     *
     * Property contains PlaybackStatus of the current DiPO device
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOPlaybackStatusUpReg(DiPOPlaybackStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiPOPlaybackStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPOPlaybackStatus'</b>:
     *
     * Property contains PlaybackStatus of the current DiPO device
     *
     * @param act The act which was previously returned by the
     * sendDiPOPlaybackStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiPOPlaybackStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiPOPlaybackStatus'.
     */
    void sendDiPOPlaybackStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'DiPOPlaybackStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDiPOPlaybackStatus() returns true.
     *
     * @return the previously received value of the property 'DiPOPlaybackStatus'.
     */
    const DiPOPlaybackStatusStatus& getDiPOPlaybackStatus() const;

    /**
     * Determines whether a status message for the property 'DiPOPlaybackStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiPOPlaybackStatus() const;

    /**
     * Request the value of the property 'DiPOPlaybackStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiPOPlaybackStatus'</b>:
     *
     * Property contains PlaybackStatus of the current DiPO device
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOPlaybackStatusGet(DiPOPlaybackStatusCallbackIF& cb);

    // Property 'DiPOPlaybackShuffleMode'

    /**
     * Notify on the property 'DiPOPlaybackShuffleMode'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPOPlaybackShuffleMode'</b>:
     *
     * Property contains ShuffleMode of the current DiPO device
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOPlaybackShuffleModeUpReg(DiPOPlaybackShuffleModeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiPOPlaybackShuffleMode'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPOPlaybackShuffleMode'</b>:
     *
     * Property contains ShuffleMode of the current DiPO device
     *
     * @param act The act which was previously returned by the
     * sendDiPOPlaybackShuffleModeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiPOPlaybackShuffleModeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiPOPlaybackShuffleMode'.
     */
    void sendDiPOPlaybackShuffleModeRelUpRegAll ();

    /**
     * Returns the current value of the property 'DiPOPlaybackShuffleMode' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDiPOPlaybackShuffleMode() returns true.
     *
     * @return the previously received value of the property 'DiPOPlaybackShuffleMode'.
     */
    const DiPOPlaybackShuffleModeStatus& getDiPOPlaybackShuffleMode() const;

    /**
     * Determines whether a status message for the property 'DiPOPlaybackShuffleMode' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiPOPlaybackShuffleMode() const;

    /**
     * Request the value of the property 'DiPOPlaybackShuffleMode' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiPOPlaybackShuffleMode'</b>:
     *
     * Property contains ShuffleMode of the current DiPO device
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOPlaybackShuffleModeGet(DiPOPlaybackShuffleModeCallbackIF& cb);

    // Property 'DiPOPlaybackRepeatMode'

    /**
     * Notify on the property 'DiPOPlaybackRepeatMode'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPOPlaybackRepeatMode'</b>:
     *
     * Property contains RepeatMode of the current DiPO device
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOPlaybackRepeatModeUpReg(DiPOPlaybackRepeatModeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiPOPlaybackRepeatMode'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPOPlaybackRepeatMode'</b>:
     *
     * Property contains RepeatMode of the current DiPO device
     *
     * @param act The act which was previously returned by the
     * sendDiPOPlaybackRepeatModeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiPOPlaybackRepeatModeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiPOPlaybackRepeatMode'.
     */
    void sendDiPOPlaybackRepeatModeRelUpRegAll ();

    /**
     * Returns the current value of the property 'DiPOPlaybackRepeatMode' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDiPOPlaybackRepeatMode() returns true.
     *
     * @return the previously received value of the property 'DiPOPlaybackRepeatMode'.
     */
    const DiPOPlaybackRepeatModeStatus& getDiPOPlaybackRepeatMode() const;

    /**
     * Determines whether a status message for the property 'DiPOPlaybackRepeatMode' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiPOPlaybackRepeatMode() const;

    /**
     * Request the value of the property 'DiPOPlaybackRepeatMode' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiPOPlaybackRepeatMode'</b>:
     *
     * Property contains RepeatMode of the current DiPO device
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOPlaybackRepeatModeGet(DiPOPlaybackRepeatModeCallbackIF& cb);

    // Property 'DiPOCallState'

    /**
     * Notify on the property 'DiPOCallState'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DiPOCallState'</b>:
     *
     * Property contains CallStateUpdates of the current DiPO device
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOCallStateUpReg(DiPOCallStateCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiPOCallState'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPOCallState'</b>:
     *
     * Property contains CallStateUpdates of the current DiPO device
     *
     * @param act The act which was previously returned by the
     * sendDiPOCallStateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiPOCallStateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiPOCallState'.
     */
    void sendDiPOCallStateRelUpRegAll ();

    /**
     * Returns the current value of the property 'DiPOCallState' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDiPOCallState() returns true.
     *
     * @return the previously received value of the property 'DiPOCallState'.
     */
    const DiPOCallStateStatus& getDiPOCallState() const;

    /**
     * Determines whether a status message for the property 'DiPOCallState' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiPOCallState() const;

    /**
     * Request the value of the property 'DiPOCallState' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiPOCallState'</b>:
     *
     * Property contains CallStateUpdates of the current DiPO device
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOCallStateGet(DiPOCallStateCallbackIF& cb);

    // Property 'DiPOCommunications'

    /**
     * Notify on the property 'DiPOCommunications'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DiPOCommunications'</b>:
     *
     * Property contains CommunicationsUpdates of the current DiPO device
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOCommunicationsUpReg(DiPOCommunicationsCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiPOCommunications'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPOCommunications'</b>:
     *
     * Property contains CommunicationsUpdates of the current DiPO device
     *
     * @param act The act which was previously returned by the
     * sendDiPOCommunicationsUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiPOCommunicationsRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiPOCommunications'.
     */
    void sendDiPOCommunicationsRelUpRegAll ();

    /**
     * Returns the current value of the property 'DiPOCommunications' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDiPOCommunications() returns true.
     *
     * @return the previously received value of the property 'DiPOCommunications'.
     */
    const DiPOCommunicationsStatus& getDiPOCommunications() const;

    /**
     * Determines whether a status message for the property 'DiPOCommunications' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiPOCommunications() const;

    /**
     * Request the value of the property 'DiPOCommunications' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiPOCommunications'</b>:
     *
     * Property contains CommunicationsUpdates of the current DiPO device
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOCommunicationsGet(DiPOCommunicationsCallbackIF& cb);

    // Property 'DiPOCommunicationError'

    /**
     * Notify on the property 'DiPOCommunicationError'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPOCommunicationError'</b>:
     *
     * The DiPOCommunicationError property provides update to SPI for any error received by Media Player from apple device for the commands executed during carplay connection.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOCommunicationErrorUpReg(DiPOCommunicationErrorCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiPOCommunicationError'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPOCommunicationError'</b>:
     *
     * The DiPOCommunicationError property provides update to SPI for any error received by Media Player from apple device for the commands executed during carplay connection.
     *
     * @param act The act which was previously returned by the
     * sendDiPOCommunicationErrorUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiPOCommunicationErrorRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiPOCommunicationError'.
     */
    void sendDiPOCommunicationErrorRelUpRegAll ();

    /**
     * Returns the current value of the property 'DiPOCommunicationError' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDiPOCommunicationError() returns true.
     *
     * @return the previously received value of the property 'DiPOCommunicationError'.
     */
    const DiPOCommunicationErrorStatus& getDiPOCommunicationError() const;

    /**
     * Determines whether a status message for the property 'DiPOCommunicationError' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiPOCommunicationError() const;

    /**
     * Request the value of the property 'DiPOCommunicationError' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiPOCommunicationError'</b>:
     *
     * The DiPOCommunicationError property provides update to SPI for any error received by Media Player from apple device for the commands executed during carplay connection.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOCommunicationErrorGet(DiPOCommunicationErrorCallbackIF& cb);

    // Property 'DiPOCallDuration'

    /**
     * Notify on the property 'DiPOCallDuration'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DiPOCallDuration'</b>:
     *
     * Property contains CallDurationUpdate.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOCallDurationUpReg(DiPOCallDurationCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiPOCallDuration'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPOCallDuration'</b>:
     *
     * Property contains CallDurationUpdate.
     *
     * @param act The act which was previously returned by the
     * sendDiPOCallDurationUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiPOCallDurationRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiPOCallDuration'.
     */
    void sendDiPOCallDurationRelUpRegAll ();

    /**
     * Returns the current value of the property 'DiPOCallDuration' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDiPOCallDuration() returns true.
     *
     * @return the previously received value of the property 'DiPOCallDuration'.
     */
    const DiPOCallDurationStatus& getDiPOCallDuration() const;

    /**
     * Determines whether a status message for the property 'DiPOCallDuration' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiPOCallDuration() const;

    /**
     * Request the value of the property 'DiPOCallDuration' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiPOCallDuration'</b>:
     *
     * Property contains CallDurationUpdate.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOCallDurationGet(DiPOCallDurationCallbackIF& cb);

    // Property 'DiPOPower'

    /**
     * Notify on the property 'DiPOPower'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'DiPOPower'</b>:
     *
     * Property contains PowerUpdate.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOPowerUpReg(DiPOPowerCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiPOPower'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPOPower'</b>:
     *
     * Property contains PowerUpdate.
     *
     * @param act The act which was previously returned by the
     * sendDiPOPowerUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiPOPowerRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiPOPower'.
     */
    void sendDiPOPowerRelUpRegAll ();

    /**
     * Returns the current value of the property 'DiPOPower' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasDiPOPower()
     * returns true.
     *
     * @return the previously received value of the property 'DiPOPower'.
     */
    const DiPOPowerStatus& getDiPOPower() const;

    /**
     * Determines whether a status message for the property 'DiPOPower' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiPOPower() const;

    /**
     * Request the value of the property 'DiPOPower' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiPOPower'</b>:
     *
     * Property contains PowerUpdate.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOPowerGet(DiPOPowerCallbackIF& cb);

    // Property 'DiPORouteGuidance'

    /**
     * Notify on the property 'DiPORouteGuidance'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DiPORouteGuidance'</b>:
     *
     * Property contains RouteGuidance Update.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPORouteGuidanceUpReg(DiPORouteGuidanceCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiPORouteGuidance'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPORouteGuidance'</b>:
     *
     * Property contains RouteGuidance Update.
     *
     * @param act The act which was previously returned by the
     * sendDiPORouteGuidanceUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiPORouteGuidanceRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiPORouteGuidance'.
     */
    void sendDiPORouteGuidanceRelUpRegAll ();

    /**
     * Returns the current value of the property 'DiPORouteGuidance' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDiPORouteGuidance() returns true.
     *
     * @return the previously received value of the property 'DiPORouteGuidance'.
     */
    const DiPORouteGuidanceStatus& getDiPORouteGuidance() const;

    /**
     * Determines whether a status message for the property 'DiPORouteGuidance' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiPORouteGuidance() const;

    /**
     * Request the value of the property 'DiPORouteGuidance' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiPORouteGuidance'</b>:
     *
     * Property contains RouteGuidance Update.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPORouteGuidanceGet(DiPORouteGuidanceCallbackIF& cb);

    // Property 'DiPORouteGuidanceManeuver'

    /**
     * Notify on the property 'DiPORouteGuidanceManeuver'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPORouteGuidanceManeuver'</b>:
     *
     * Property contains RouteGuidanceManeuver Update.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPORouteGuidanceManeuverUpReg(DiPORouteGuidanceManeuverCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiPORouteGuidanceManeuver'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPORouteGuidanceManeuver'</b>:
     *
     * Property contains RouteGuidanceManeuver Update.
     *
     * @param act The act which was previously returned by the
     * sendDiPORouteGuidanceManeuverUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiPORouteGuidanceManeuverRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiPORouteGuidanceManeuver'.
     */
    void sendDiPORouteGuidanceManeuverRelUpRegAll ();

    /**
     * Returns the current value of the property 'DiPORouteGuidanceManeuver'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDiPORouteGuidanceManeuver() returns true.
     *
     * @return the previously received value of the property 'DiPORouteGuidanceManeuver'.
     */
    const DiPORouteGuidanceManeuverStatus& getDiPORouteGuidanceManeuver() const;

    /**
     * Determines whether a status message for the property 'DiPORouteGuidanceManeuver' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiPORouteGuidanceManeuver() const;

    /**
     * Request the value of the property 'DiPORouteGuidanceManeuver' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiPORouteGuidanceManeuver'</b>:
     *
     * Property contains RouteGuidanceManeuver Update.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPORouteGuidanceManeuverGet(DiPORouteGuidanceManeuverCallbackIF& cb);

    // Property 'DiPOGPRMCDataStatusValues'

    /**
     * Notify on the property 'DiPOGPRMCDataStatusValues'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPOGPRMCDataStatusValues'</b>:
     *
     * MediaPlayer notifies the client on the GPRMC data status values received form device(A,V,X).
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOGPRMCDataStatusValuesUpReg(DiPOGPRMCDataStatusValuesCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiPOGPRMCDataStatusValues'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPOGPRMCDataStatusValues'</b>:
     *
     * MediaPlayer notifies the client on the GPRMC data status values received form device(A,V,X).
     *
     * @param act The act which was previously returned by the
     * sendDiPOGPRMCDataStatusValuesUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiPOGPRMCDataStatusValuesRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiPOGPRMCDataStatusValues'.
     */
    void sendDiPOGPRMCDataStatusValuesRelUpRegAll ();

    /**
     * Returns the current value of the property 'DiPOGPRMCDataStatusValues'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDiPOGPRMCDataStatusValues() returns true.
     *
     * @return the previously received value of the property 'DiPOGPRMCDataStatusValues'.
     */
    const DiPOGPRMCDataStatusValuesStatus& getDiPOGPRMCDataStatusValues() const;

    /**
     * Determines whether a status message for the property 'DiPOGPRMCDataStatusValues' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiPOGPRMCDataStatusValues() const;

    /**
     * Request the value of the property 'DiPOGPRMCDataStatusValues' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiPOGPRMCDataStatusValues'</b>:
     *
     * MediaPlayer notifies the client on the GPRMC data status values received form device(A,V,X).
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOGPRMCDataStatusValuesGet(DiPOGPRMCDataStatusValuesCallbackIF& cb);

    // Property 'DiPORouteGuidance2'

    /**
     * Notify on the property 'DiPORouteGuidance2'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DiPORouteGuidance2'</b>:
     *
     * Property contains RouteGuidance Update.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPORouteGuidance2UpReg(DiPORouteGuidance2CallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiPORouteGuidance2'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPORouteGuidance2'</b>:
     *
     * Property contains RouteGuidance Update.
     *
     * @param act The act which was previously returned by the
     * sendDiPORouteGuidance2UpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiPORouteGuidance2RelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiPORouteGuidance2'.
     */
    void sendDiPORouteGuidance2RelUpRegAll ();

    /**
     * Returns the current value of the property 'DiPORouteGuidance2' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDiPORouteGuidance2() returns true.
     *
     * @return the previously received value of the property 'DiPORouteGuidance2'.
     */
    const DiPORouteGuidance2Status& getDiPORouteGuidance2() const;

    /**
     * Determines whether a status message for the property 'DiPORouteGuidance2' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiPORouteGuidance2() const;

    /**
     * Request the value of the property 'DiPORouteGuidance2' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiPORouteGuidance2'</b>:
     *
     * Property contains RouteGuidance Update.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPORouteGuidance2Get(DiPORouteGuidance2CallbackIF& cb);

    // Property 'DiPORouteGuidanceManeuver2'

    /**
     * Notify on the property 'DiPORouteGuidanceManeuver2'. This method sends
     * a UpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPORouteGuidanceManeuver2'</b>:
     *
     * Property contains RouteGuidanceManeuver Update.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPORouteGuidanceManeuver2UpReg(DiPORouteGuidanceManeuver2CallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiPORouteGuidanceManeuver2'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPORouteGuidanceManeuver2'</b>:
     *
     * Property contains RouteGuidanceManeuver Update.
     *
     * @param act The act which was previously returned by the
     * sendDiPORouteGuidanceManeuver2UpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiPORouteGuidanceManeuver2RelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiPORouteGuidanceManeuver2'.
     */
    void sendDiPORouteGuidanceManeuver2RelUpRegAll ();

    /**
     * Returns the current value of the property 'DiPORouteGuidanceManeuver2'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDiPORouteGuidanceManeuver2() returns true.
     *
     * @return the previously received value of the property 'DiPORouteGuidanceManeuver2'.
     */
    const DiPORouteGuidanceManeuver2Status& getDiPORouteGuidanceManeuver2() const;

    /**
     * Determines whether a status message for the property 'DiPORouteGuidanceManeuver2' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiPORouteGuidanceManeuver2() const;

    /**
     * Request the value of the property 'DiPORouteGuidanceManeuver2' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiPORouteGuidanceManeuver2'</b>:
     *
     * Property contains RouteGuidanceManeuver Update.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPORouteGuidanceManeuver2Get(DiPORouteGuidanceManeuver2CallbackIF& cb);

    // Property 'DiPOBluetoothAudioDeviceStatus'

    /**
     * Notify on the property 'DiPOBluetoothAudioDeviceStatus'. This method
     * sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPOBluetoothAudioDeviceStatus'</b>:
     *
     * Update the busy or free status of Bluetooth Audio input device.
     * BT audio input device should not be read by multiple processes. Incase any process
     * wants to use Bluetooth Audio input device, process has to request the device
     * to Mediaplayer by method DiPORequestBluetoothAudioDevice if the device is free
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOBluetoothAudioDeviceStatusUpReg(DiPOBluetoothAudioDeviceStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiPOBluetoothAudioDeviceStatus'.
     * This method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPOBluetoothAudioDeviceStatus'</b>:
     *
     * Update the busy or free status of Bluetooth Audio input device.
     * BT audio input device should not be read by multiple processes. Incase any process
     * wants to use Bluetooth Audio input device, process has to request the device
     * to Mediaplayer by method DiPORequestBluetoothAudioDevice if the device is free
     *
     * @param act The act which was previously returned by the
     * sendDiPOBluetoothAudioDeviceStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiPOBluetoothAudioDeviceStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiPOBluetoothAudioDeviceStatus'.
     */
    void sendDiPOBluetoothAudioDeviceStatusRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'DiPOBluetoothAudioDeviceStatus' (as known by the proxy). This method
     * is only allowed to be called when a status message for this property
     * was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasDiPOBluetoothAudioDeviceStatus() returns true.
     *
     * @return the previously received value of the property 'DiPOBluetoothAudioDeviceStatus'.
     */
    const DiPOBluetoothAudioDeviceStatusStatus& getDiPOBluetoothAudioDeviceStatus() const;

    /**
     * Determines whether a status message for the property 'DiPOBluetoothAudioDeviceStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiPOBluetoothAudioDeviceStatus() const;

    /**
     * Request the value of the property 'DiPOBluetoothAudioDeviceStatus' from
     * the CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiPOBluetoothAudioDeviceStatus'</b>:
     *
     * Update the busy or free status of Bluetooth Audio input device.
     * BT audio input device should not be read by multiple processes. Incase any process
     * wants to use Bluetooth Audio input device, process has to request the device
     * to Mediaplayer by method DiPORequestBluetoothAudioDevice if the device is free
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOBluetoothAudioDeviceStatusGet(DiPOBluetoothAudioDeviceStatusCallbackIF& cb);

    // Property 'DiPODeviceTimeUpdate'

    /**
     * Notify on the property 'DiPODeviceTimeUpdate'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPODeviceTimeUpdate'</b>:
     *
     * Property contains Device time update of apple device which is connected for CP or CPW.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPODeviceTimeUpdateUpReg(DiPODeviceTimeUpdateCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiPODeviceTimeUpdate'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPODeviceTimeUpdate'</b>:
     *
     * Property contains Device time update of apple device which is connected for CP or CPW.
     *
     * @param act The act which was previously returned by the
     * sendDiPODeviceTimeUpdateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiPODeviceTimeUpdateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiPODeviceTimeUpdate'.
     */
    void sendDiPODeviceTimeUpdateRelUpRegAll ();

    /**
     * Returns the current value of the property 'DiPODeviceTimeUpdate' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDiPODeviceTimeUpdate() returns true.
     *
     * @return the previously received value of the property 'DiPODeviceTimeUpdate'.
     */
    const DiPODeviceTimeUpdateStatus& getDiPODeviceTimeUpdate() const;

    /**
     * Determines whether a status message for the property 'DiPODeviceTimeUpdate' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiPODeviceTimeUpdate() const;

    /**
     * Request the value of the property 'DiPODeviceTimeUpdate' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiPODeviceTimeUpdate'</b>:
     *
     * Property contains Device time update of apple device which is connected for CP or CPW.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPODeviceTimeUpdateGet(DiPODeviceTimeUpdateCallbackIF& cb);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Mplay_appcontrol_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'DataResponse'

    ::asf::core::nullable< DataResponseStatus > _dataResponse;

    // Property 'SessionOpened'

    ::asf::core::nullable< SessionOpenedStatus > _sessionOpened;

    // Property 'SessionClosed'

    ::asf::core::nullable< SessionClosedStatus > _sessionClosed;

    // Property 'DiPODeviceConnections'

    ::asf::core::nullable< DiPODeviceConnectionsStatus > _diPODeviceConnections;

    // Property 'DiPOPlaytime'

    ::asf::core::nullable< DiPOPlaytimeStatus > _diPOPlaytime;

    // Property 'DiPOLocationInfo'

    ::asf::core::nullable< DiPOLocationInfoStatus > _diPOLocationInfo;

    // Property 'DiPOMetaData'

    ::asf::core::nullable< DiPOMetaDataStatus > _diPOMetaData;

    // Property 'DiPOPhoneData'

    ::asf::core::nullable< DiPOPhoneDataStatus > _diPOPhoneData;

    // Property 'NativeTransportStart'

    ::asf::core::nullable< NativeTransportStartStatus > _nativeTransportStart;

    // Property 'NativeTransportStop'

    ::asf::core::nullable< NativeTransportStopStatus > _nativeTransportStop;

    // Property 'ConnectedBluetoothProfiles'

    ::asf::core::nullable< ConnectedBluetoothProfilesStatus > _connectedBluetoothProfiles;

    // Property 'DiPONowPlaying'

    ::asf::core::nullable< DiPONowPlayingStatus > _diPONowPlaying;

    // Property 'DiPOPlaybackStatus'

    ::asf::core::nullable< DiPOPlaybackStatusStatus > _diPOPlaybackStatus;

    // Property 'DiPOPlaybackShuffleMode'

    ::asf::core::nullable< DiPOPlaybackShuffleModeStatus > _diPOPlaybackShuffleMode;

    // Property 'DiPOPlaybackRepeatMode'

    ::asf::core::nullable< DiPOPlaybackRepeatModeStatus > _diPOPlaybackRepeatMode;

    // Property 'DiPOCallState'

    ::asf::core::nullable< DiPOCallStateStatus > _diPOCallState;

    // Property 'DiPOCommunications'

    ::asf::core::nullable< DiPOCommunicationsStatus > _diPOCommunications;

    // Property 'DiPOCommunicationError'

    ::asf::core::nullable< DiPOCommunicationErrorStatus > _diPOCommunicationError;

    // Property 'DiPOCallDuration'

    ::asf::core::nullable< DiPOCallDurationStatus > _diPOCallDuration;

    // Property 'DiPOPower'

    ::asf::core::nullable< DiPOPowerStatus > _diPOPower;

    // Property 'DiPORouteGuidance'

    ::asf::core::nullable< DiPORouteGuidanceStatus > _diPORouteGuidance;

    // Property 'DiPORouteGuidanceManeuver'

    ::asf::core::nullable< DiPORouteGuidanceManeuverStatus > _diPORouteGuidanceManeuver;

    // Property 'DiPOGPRMCDataStatusValues'

    ::asf::core::nullable< DiPOGPRMCDataStatusValuesStatus > _diPOGPRMCDataStatusValues;

    // Property 'DiPORouteGuidance2'

    ::asf::core::nullable< DiPORouteGuidance2Status > _diPORouteGuidance2;

    // Property 'DiPORouteGuidanceManeuver2'

    ::asf::core::nullable< DiPORouteGuidanceManeuver2Status > _diPORouteGuidanceManeuver2;

    // Property 'DiPOBluetoothAudioDeviceStatus'

    ::asf::core::nullable< DiPOBluetoothAudioDeviceStatusStatus > _diPOBluetoothAudioDeviceStatus;

    // Property 'DiPODeviceTimeUpdate'

    ::asf::core::nullable< DiPODeviceTimeUpdateStatus > _diPODeviceTimeUpdate;

    DECLARE_CLASS_LOGGER();

    friend class Mplay_appcontrol_fiProxyCallback;
};

} // namespace mplay_appcontrol_fi

#endif // MPLAY_APPCONTROL_FIPROXY_H
