#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MPLAY_APPCONTROL_FI_H
#define MPLAY_APPCONTROL_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/core/Blob.h"
#include "asf/core/Internal.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "mplay_appcontrol_fi_types.h"
#include "mplay_appcontrol_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'mplay_appcontrol_fi'
 *
 * Fullname: Application Control Interface
 *
 * Version: $Revision: 2.2$
 *
 * Author: Ulrich Deuper
 *
 * Date: $Date:22.10.2019$
 *
 * Department: BSOT/ENG
 *
 * Title: mplay_appcontrol_fi
 *
 * <b>Description of 'mplay_appcontrol_fi':</b>
 *
 * Application Control Interface
 */

namespace mplay_appcontrol_fi {

static const int SERVICE_ID = 121;

static const int FID_DataResponse = 1;

static const int FID_SessionOpened = 2;

static const int FID_SessionClosed = 3;

static const int FID_DiPODeviceConnections = 4;

static const int FID_DiPOPlaytime = 5;

static const int FID_DiPOLocationInfo = 6;

static const int FID_DiPOMetaData = 7;

static const int FID_DiPOPhoneData = 8;

static const int FID_NativeTransportStart = 16;

static const int FID_NativeTransportStop = 17;

static const int FID_ConnectedBluetoothProfiles = 18;

static const int FID_DiPONowPlaying = 19;

static const int FID_DiPOPlaybackStatus = 20;

static const int FID_DiPOPlaybackShuffleMode = 21;

static const int FID_DiPOPlaybackRepeatMode = 22;

static const int FID_DiPOCallState = 23;

static const int FID_DiPOCommunications = 24;

static const int FID_DiPOCommunicationError = 25;

static const int FID_DiPOCallDuration = 32;

static const int FID_DiPOPower = 33;

static const int FID_DiPORouteGuidance = 34;

static const int FID_DiPORouteGuidanceManeuver = 35;

static const int FID_DiPOGPRMCDataStatusValues = 36;

static const int FID_DiPORouteGuidance2 = 37;

static const int FID_DiPORouteGuidanceManeuver2 = 38;

static const int FID_DiPOBluetoothAudioDeviceStatus = 39;

static const int FID_DiPODeviceTimeUpdate = 41;

static const int FID_Connect = 256;

static const int FID_Command = 257;

static const int FID_Close = 258;

static const int FID_StartAudio = 288;

static const int FID_StopAudio = 289;

static const int FID_DiPOActiveDevice = 259;

static const int FID_DiPORoleSwitchRequest = 260;

static const int FID_DiPOGetMediaObjectAlbumArtInfo = 261;

static const int FID_DiPOGetMediaObjectAlbumArt = 262;

static const int FID_DiPOTransferGPSData = 263;

static const int FID_DiPOTransferDRData = 264;

static const int FID_DiPORequestAudioDevice = 265;

static const int FID_DiPOReleaseAudioDevice = 272;

static const int FID_DiPORequestPlaybackAction = 273;

static const int FID_DiPOStartIAP2OverCarPlayWifi = 274;

static const int FID_DiPOStartRouteGuidance = 275;

static const int FID_DiPOStopRouteGuidance = 276;

static const int FID_SwapCalls = 277;

static const int FID_DiPOSetRouteGuidanceDisplayComponentInfo = 278;

static const int FID_DiPOStopRouteGuidance2 = 279;

static const int FID_DiPOStartRouteGuidance2 = 280;

static const int FID_DiPOSetCallControlsConfiguration = 281;

static const int FID_DiPOInitiateCall = 290;

static const int FID_DiPOAcceptCall = 291;

static const int FID_DiPOEndCall = 292;

static const int FID_DiPOMergeCalls = 293;

static const int FID_DiPOHoldStatusUpdate = 294;

static const int FID_DiPOMuteStatusUpdate = 295;

static const int FID_DiPOSendDTMF = 296;

static const int FID_DiPOSwapCalls = 297;

static const int FID_DiPOSetAppleIdentificationInfo = 304;

static const int FID_DiPORequestBluetoothAudioDevice = 305;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 1;

static const int VERSION_PATCH = 0;

// forward declarations
class DataResponseStatus;

class SessionOpenedStatus;

class SessionClosedStatus;

class DiPODeviceConnectionsStatus;

class DiPOPlaytimeStatus;

class DiPOLocationInfoStatus;

class DiPOMetaDataStatus;

class DiPOPhoneDataStatus;

class NativeTransportStartStatus;

class NativeTransportStopStatus;

class ConnectedBluetoothProfilesStatus;

class DiPONowPlayingStatus;

class DiPOPlaybackStatusStatus;

class DiPOPlaybackShuffleModeStatus;

class DiPOPlaybackRepeatModeStatus;

class DiPOCallStateStatus;

class DiPOCommunicationsStatus;

class DiPOCommunicationErrorStatus;

class DiPOCallDurationStatus;

class DiPOPowerStatus;

class DiPORouteGuidanceStatus;

class DiPORouteGuidanceManeuverStatus;

class DiPOGPRMCDataStatusValuesStatus;

class DiPORouteGuidance2Status;

class DiPORouteGuidanceManeuver2Status;

class DiPOBluetoothAudioDeviceStatusStatus;

class DiPODeviceTimeUpdateStatus;

class ConnectStart;

class ConnectResult;

class CommandStart;

class CommandResult;

class CloseStart;

class StartAudioStart;

class StopAudioStart;

class DiPOActiveDeviceStart;

class DiPOActiveDeviceResult;

class DiPORoleSwitchRequestStart;

class DiPORoleSwitchRequestResult;

class DiPOGetMediaObjectAlbumArtInfoStart;

class DiPOGetMediaObjectAlbumArtInfoResult;

class DiPOGetMediaObjectAlbumArtStart;

class DiPOGetMediaObjectAlbumArtResult;

class DiPOTransferGPSDataStart;

class DiPOTransferGPSDataResult;

class DiPOTransferDRDataStart;

class DiPOTransferDRDataResult;

class DiPORequestAudioDeviceStart;

class DiPORequestAudioDeviceResult;

class DiPOReleaseAudioDeviceStart;

class DiPOReleaseAudioDeviceResult;

class DiPORequestPlaybackActionStart;

class DiPOStartIAP2OverCarPlayWifiStart;

class DiPOStartRouteGuidanceStart;

class DiPOStopRouteGuidanceStart;

class SwapCallsStart;

class DiPOSetRouteGuidanceDisplayComponentInfoStart;

class DiPOStopRouteGuidance2Start;

class DiPOStartRouteGuidance2Start;

class DiPOSetCallControlsConfigurationStart;

class DiPOInitiateCallStart;

class DiPOAcceptCallStart;

class DiPOEndCallStart;

class DiPOMergeCallsStart;

class DiPOHoldStatusUpdateStart;

class DiPOMuteStatusUpdateStart;

class DiPOSendDTMFStart;

class DiPOSwapCallsStart;

class DiPOSetAppleIdentificationInfoStart;

class DiPOSetAppleIdentificationInfoResult;

class DiPORequestBluetoothAudioDeviceStart;

class DiPORequestBluetoothAudioDeviceResult;

// type definitions
/**
 * The get message of the property "DataResponse"
 * The AppControl Response property provides asynchronous notifications of the IAP
 * responses received from the iPod Device control to the Internet Radio FBlock over CCA.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DataResponseGet;

/**
 * The upreg message of the property "DataResponse"
 * The AppControl Response property provides asynchronous notifications of the IAP
 * responses received from the iPod Device control to the Internet Radio FBlock over CCA.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DataResponseUpReg;

/**
 * The relUpReg message of the property "DataResponse"
 * The AppControl Response property provides asynchronous notifications of the IAP
 * responses received from the iPod Device control to the Internet Radio FBlock over CCA.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DataResponseRelUpReg;

/**
 * The error message of 'DataResponse'
 */
typedef ::asf::cca::CcaTypes::DefaultError DataResponseError;

/**
 * The get message of the property "SessionOpened"
 * The AppControl Response property provides asynchronous notifications of the IAP
 * data session open event received from the iPod Device control to the Internet Radio FBlock over CCA.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SessionOpenedGet;

/**
 * The upreg message of the property "SessionOpened"
 * The AppControl Response property provides asynchronous notifications of the IAP
 * data session open event received from the iPod Device control to the Internet Radio FBlock over CCA.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SessionOpenedUpReg;

/**
 * The relUpReg message of the property "SessionOpened"
 * The AppControl Response property provides asynchronous notifications of the IAP
 * data session open event received from the iPod Device control to the Internet Radio FBlock over CCA.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SessionOpenedRelUpReg;

/**
 * The error message of 'SessionOpened'
 */
typedef ::asf::cca::CcaTypes::DefaultError SessionOpenedError;

/**
 * The get message of the property "SessionClosed"
 * The AppControl SessionClosed property provides asynchronous notifications of the IAP
 * data session close event received from the iPod Device control to the Internet Radio FBlock over CCA.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SessionClosedGet;

/**
 * The upreg message of the property "SessionClosed"
 * The AppControl SessionClosed property provides asynchronous notifications of the IAP
 * data session close event received from the iPod Device control to the Internet Radio FBlock over CCA.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SessionClosedUpReg;

/**
 * The relUpReg message of the property "SessionClosed"
 * The AppControl SessionClosed property provides asynchronous notifications of the IAP
 * data session close event received from the iPod Device control to the Internet Radio FBlock over CCA.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SessionClosedRelUpReg;

/**
 * The error message of 'SessionClosed'
 */
typedef ::asf::cca::CcaTypes::DefaultError SessionClosedError;

/**
 * The get message of the property "DiPODeviceConnections"
 * Provides notification of the number of devices connected that support media playback.  For each connected device, this property provides specific information about the device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPODeviceConnectionsGet;

/**
 * The upreg message of the property "DiPODeviceConnections"
 * Provides notification of the number of devices connected that support media playback.  For each connected device, this property provides specific information about the device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPODeviceConnectionsUpReg;

/**
 * The relUpReg message of the property "DiPODeviceConnections"
 * Provides notification of the number of devices connected that support media playback.  For each connected device, this property provides specific information about the device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPODeviceConnectionsRelUpReg;

/**
 * The error message of 'DiPODeviceConnections'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPODeviceConnectionsError;

/**
 * The get message of the property "DiPOPlaytime"
 * Identifies the amount of time elapsed and total duration of a media object. Resolution is in seconds.
 * The MediaPlayer shall send out updates to registered HMI controllers upon each 1 second change.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOPlaytimeGet;

/**
 * The upreg message of the property "DiPOPlaytime"
 * Identifies the amount of time elapsed and total duration of a media object. Resolution is in seconds.
 * The MediaPlayer shall send out updates to registered HMI controllers upon each 1 second change.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOPlaytimeUpReg;

/**
 * The relUpReg message of the property "DiPOPlaytime"
 * Identifies the amount of time elapsed and total duration of a media object. Resolution is in seconds.
 * The MediaPlayer shall send out updates to registered HMI controllers upon each 1 second change.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOPlaytimeRelUpReg;

/**
 * The error message of 'DiPOPlaytime'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOPlaytimeError;

/**
 * The get message of the property "DiPOLocationInfo"
 * MediaPlayer informs the client if location info should be sent
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOLocationInfoGet;

/**
 * The upreg message of the property "DiPOLocationInfo"
 * MediaPlayer informs the client if location info should be sent
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOLocationInfoUpReg;

/**
 * The relUpReg message of the property "DiPOLocationInfo"
 * MediaPlayer informs the client if location info should be sent
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOLocationInfoRelUpReg;

/**
 * The error message of 'DiPOLocationInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOLocationInfoError;

/**
 * The get message of the property "DiPOMetaData"
 * Deprecated, use DiPONowPlaying instead.
 * Property contains the metadata of the currently playing song
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOMetaDataGet;

/**
 * The upreg message of the property "DiPOMetaData"
 * Deprecated, use DiPONowPlaying instead.
 * Property contains the metadata of the currently playing song
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOMetaDataUpReg;

/**
 * The relUpReg message of the property "DiPOMetaData"
 * Deprecated, use DiPONowPlaying instead.
 * Property contains the metadata of the currently playing song
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOMetaDataRelUpReg;

/**
 * The error message of 'DiPOMetaData'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOMetaDataError;

/**
 * The get message of the property "DiPOPhoneData"
 * Deprecated, use DiPOCallState instead.
 * Property contains the phone information
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOPhoneDataGet;

/**
 * The upreg message of the property "DiPOPhoneData"
 * Deprecated, use DiPOCallState instead.
 * Property contains the phone information
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOPhoneDataUpReg;

/**
 * The relUpReg message of the property "DiPOPhoneData"
 * Deprecated, use DiPOCallState instead.
 * Property contains the phone information
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOPhoneDataRelUpReg;

/**
 * The error message of 'DiPOPhoneData'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOPhoneDataError;

/**
 * The get message of the property "NativeTransportStart"
 * The AppControl Response property provides asynchronous notifications of the IAP2
 * EA Native Transport Open event received from the iPod Device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NativeTransportStartGet;

/**
 * The upreg message of the property "NativeTransportStart"
 * The AppControl Response property provides asynchronous notifications of the IAP2
 * EA Native Transport Open event received from the iPod Device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NativeTransportStartUpReg;

/**
 * The relUpReg message of the property "NativeTransportStart"
 * The AppControl Response property provides asynchronous notifications of the IAP2
 * EA Native Transport Open event received from the iPod Device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NativeTransportStartRelUpReg;

/**
 * The error message of 'NativeTransportStart'
 */
typedef ::asf::cca::CcaTypes::DefaultError NativeTransportStartError;

/**
 * The get message of the property "NativeTransportStop"
 * The AppControl Response property provides asynchronous notifications of the IAP2
 * EA Native Transport Close event received from the iPod Device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NativeTransportStopGet;

/**
 * The upreg message of the property "NativeTransportStop"
 * The AppControl Response property provides asynchronous notifications of the IAP2
 * EA Native Transport Close event received from the iPod Device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NativeTransportStopUpReg;

/**
 * The relUpReg message of the property "NativeTransportStop"
 * The AppControl Response property provides asynchronous notifications of the IAP2
 * EA Native Transport Close event received from the iPod Device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NativeTransportStopRelUpReg;

/**
 * The error message of 'NativeTransportStop'
 */
typedef ::asf::cca::CcaTypes::DefaultError NativeTransportStopError;

/**
 * The get message of the property "ConnectedBluetoothProfiles"
 * MediaPlayer informs the client about connected bluetooth profiles (iAP2 connections, host and device mode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConnectedBluetoothProfilesGet;

/**
 * The upreg message of the property "ConnectedBluetoothProfiles"
 * MediaPlayer informs the client about connected bluetooth profiles (iAP2 connections, host and device mode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConnectedBluetoothProfilesUpReg;

/**
 * The relUpReg message of the property "ConnectedBluetoothProfiles"
 * MediaPlayer informs the client about connected bluetooth profiles (iAP2 connections, host and device mode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConnectedBluetoothProfilesRelUpReg;

/**
 * The error message of 'ConnectedBluetoothProfiles'
 */
typedef ::asf::cca::CcaTypes::DefaultError ConnectedBluetoothProfilesError;

/**
 * The get message of the property "DiPONowPlaying"
 * Property contains all metadata of the last iAP2 NowPlayingUpdate from the current DiPO device
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPONowPlayingGet;

/**
 * The upreg message of the property "DiPONowPlaying"
 * Property contains all metadata of the last iAP2 NowPlayingUpdate from the current DiPO device
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPONowPlayingUpReg;

/**
 * The relUpReg message of the property "DiPONowPlaying"
 * Property contains all metadata of the last iAP2 NowPlayingUpdate from the current DiPO device
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPONowPlayingRelUpReg;

/**
 * The error message of 'DiPONowPlaying'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPONowPlayingError;

/**
 * The get message of the property "DiPOPlaybackStatus"
 * Property contains PlaybackStatus of the current DiPO device
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOPlaybackStatusGet;

/**
 * The upreg message of the property "DiPOPlaybackStatus"
 * Property contains PlaybackStatus of the current DiPO device
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOPlaybackStatusUpReg;

/**
 * The relUpReg message of the property "DiPOPlaybackStatus"
 * Property contains PlaybackStatus of the current DiPO device
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOPlaybackStatusRelUpReg;

/**
 * The error message of 'DiPOPlaybackStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOPlaybackStatusError;

/**
 * The get message of the property "DiPOPlaybackShuffleMode"
 * Property contains ShuffleMode of the current DiPO device
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOPlaybackShuffleModeGet;

/**
 * The upreg message of the property "DiPOPlaybackShuffleMode"
 * Property contains ShuffleMode of the current DiPO device
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOPlaybackShuffleModeUpReg;

/**
 * The relUpReg message of the property "DiPOPlaybackShuffleMode"
 * Property contains ShuffleMode of the current DiPO device
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOPlaybackShuffleModeRelUpReg;

/**
 * The error message of 'DiPOPlaybackShuffleMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOPlaybackShuffleModeError;

/**
 * The get message of the property "DiPOPlaybackRepeatMode"
 * Property contains RepeatMode of the current DiPO device
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOPlaybackRepeatModeGet;

/**
 * The upreg message of the property "DiPOPlaybackRepeatMode"
 * Property contains RepeatMode of the current DiPO device
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOPlaybackRepeatModeUpReg;

/**
 * The relUpReg message of the property "DiPOPlaybackRepeatMode"
 * Property contains RepeatMode of the current DiPO device
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOPlaybackRepeatModeRelUpReg;

/**
 * The error message of 'DiPOPlaybackRepeatMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOPlaybackRepeatModeError;

/**
 * The get message of the property "DiPOCallState"
 * Property contains CallStateUpdates of the current DiPO device
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOCallStateGet;

/**
 * The upreg message of the property "DiPOCallState"
 * Property contains CallStateUpdates of the current DiPO device
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOCallStateUpReg;

/**
 * The relUpReg message of the property "DiPOCallState"
 * Property contains CallStateUpdates of the current DiPO device
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOCallStateRelUpReg;

/**
 * The error message of 'DiPOCallState'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOCallStateError;

/**
 * The get message of the property "DiPOCommunications"
 * Property contains CommunicationsUpdates of the current DiPO device
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOCommunicationsGet;

/**
 * The upreg message of the property "DiPOCommunications"
 * Property contains CommunicationsUpdates of the current DiPO device
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOCommunicationsUpReg;

/**
 * The relUpReg message of the property "DiPOCommunications"
 * Property contains CommunicationsUpdates of the current DiPO device
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOCommunicationsRelUpReg;

/**
 * The error message of 'DiPOCommunications'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOCommunicationsError;

/**
 * The get message of the property "DiPOCommunicationError"
 * The DiPOCommunicationError property provides update to SPI for any error received by Media Player from apple device for the commands executed during carplay connection.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOCommunicationErrorGet;

/**
 * The upreg message of the property "DiPOCommunicationError"
 * The DiPOCommunicationError property provides update to SPI for any error received by Media Player from apple device for the commands executed during carplay connection.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOCommunicationErrorUpReg;

/**
 * The relUpReg message of the property "DiPOCommunicationError"
 * The DiPOCommunicationError property provides update to SPI for any error received by Media Player from apple device for the commands executed during carplay connection.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOCommunicationErrorRelUpReg;

/**
 * The error message of 'DiPOCommunicationError'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOCommunicationErrorError;

/**
 * The get message of the property "DiPOCallDuration"
 * Property contains CallDurationUpdate.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOCallDurationGet;

/**
 * The upreg message of the property "DiPOCallDuration"
 * Property contains CallDurationUpdate.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOCallDurationUpReg;

/**
 * The relUpReg message of the property "DiPOCallDuration"
 * Property contains CallDurationUpdate.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOCallDurationRelUpReg;

/**
 * The error message of 'DiPOCallDuration'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOCallDurationError;

/**
 * The get message of the property "DiPOPower"
 * Property contains PowerUpdate.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOPowerGet;

/**
 * The upreg message of the property "DiPOPower"
 * Property contains PowerUpdate.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOPowerUpReg;

/**
 * The relUpReg message of the property "DiPOPower"
 * Property contains PowerUpdate.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOPowerRelUpReg;

/**
 * The error message of 'DiPOPower'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOPowerError;

/**
 * The get message of the property "DiPORouteGuidance"
 * Property contains RouteGuidance Update.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPORouteGuidanceGet;

/**
 * The upreg message of the property "DiPORouteGuidance"
 * Property contains RouteGuidance Update.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPORouteGuidanceUpReg;

/**
 * The relUpReg message of the property "DiPORouteGuidance"
 * Property contains RouteGuidance Update.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPORouteGuidanceRelUpReg;

/**
 * The error message of 'DiPORouteGuidance'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPORouteGuidanceError;

/**
 * The get message of the property "DiPORouteGuidanceManeuver"
 * Property contains RouteGuidanceManeuver Update.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPORouteGuidanceManeuverGet;

/**
 * The upreg message of the property "DiPORouteGuidanceManeuver"
 * Property contains RouteGuidanceManeuver Update.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPORouteGuidanceManeuverUpReg;

/**
 * The relUpReg message of the property "DiPORouteGuidanceManeuver"
 * Property contains RouteGuidanceManeuver Update.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPORouteGuidanceManeuverRelUpReg;

/**
 * The error message of 'DiPORouteGuidanceManeuver'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPORouteGuidanceManeuverError;

/**
 * The get message of the property "DiPOGPRMCDataStatusValues"
 * MediaPlayer notifies the client on the GPRMC data status values received form device(A,V,X).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOGPRMCDataStatusValuesGet;

/**
 * The upreg message of the property "DiPOGPRMCDataStatusValues"
 * MediaPlayer notifies the client on the GPRMC data status values received form device(A,V,X).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOGPRMCDataStatusValuesUpReg;

/**
 * The relUpReg message of the property "DiPOGPRMCDataStatusValues"
 * MediaPlayer notifies the client on the GPRMC data status values received form device(A,V,X).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOGPRMCDataStatusValuesRelUpReg;

/**
 * The error message of 'DiPOGPRMCDataStatusValues'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOGPRMCDataStatusValuesError;

/**
 * The get message of the property "DiPORouteGuidance2"
 * Property contains RouteGuidance Update.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPORouteGuidance2Get;

/**
 * The upreg message of the property "DiPORouteGuidance2"
 * Property contains RouteGuidance Update.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPORouteGuidance2UpReg;

/**
 * The relUpReg message of the property "DiPORouteGuidance2"
 * Property contains RouteGuidance Update.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPORouteGuidance2RelUpReg;

/**
 * The error message of 'DiPORouteGuidance2'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPORouteGuidance2Error;

/**
 * The get message of the property "DiPORouteGuidanceManeuver2"
 * Property contains RouteGuidanceManeuver Update.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPORouteGuidanceManeuver2Get;

/**
 * The upreg message of the property "DiPORouteGuidanceManeuver2"
 * Property contains RouteGuidanceManeuver Update.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPORouteGuidanceManeuver2UpReg;

/**
 * The relUpReg message of the property "DiPORouteGuidanceManeuver2"
 * Property contains RouteGuidanceManeuver Update.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPORouteGuidanceManeuver2RelUpReg;

/**
 * The error message of 'DiPORouteGuidanceManeuver2'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPORouteGuidanceManeuver2Error;

/**
 * The get message of the property "DiPOBluetoothAudioDeviceStatus"
 * Update the busy or free status of Bluetooth Audio input device.
 * BT audio input device should not be read by multiple processes. Incase any process
 * wants to use Bluetooth Audio input device, process has to request the device
 * to Mediaplayer by method DiPORequestBluetoothAudioDevice if the device is free
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOBluetoothAudioDeviceStatusGet;

/**
 * The upreg message of the property "DiPOBluetoothAudioDeviceStatus"
 * Update the busy or free status of Bluetooth Audio input device.
 * BT audio input device should not be read by multiple processes. Incase any process
 * wants to use Bluetooth Audio input device, process has to request the device
 * to Mediaplayer by method DiPORequestBluetoothAudioDevice if the device is free
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOBluetoothAudioDeviceStatusUpReg;

/**
 * The relUpReg message of the property "DiPOBluetoothAudioDeviceStatus"
 * Update the busy or free status of Bluetooth Audio input device.
 * BT audio input device should not be read by multiple processes. Incase any process
 * wants to use Bluetooth Audio input device, process has to request the device
 * to Mediaplayer by method DiPORequestBluetoothAudioDevice if the device is free
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOBluetoothAudioDeviceStatusRelUpReg;

/**
 * The error message of 'DiPOBluetoothAudioDeviceStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOBluetoothAudioDeviceStatusError;

/**
 * The get message of the property "DiPODeviceTimeUpdate"
 * Property contains Device time update of apple device which is connected for CP or CPW.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPODeviceTimeUpdateGet;

/**
 * The upreg message of the property "DiPODeviceTimeUpdate"
 * Property contains Device time update of apple device which is connected for CP or CPW.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPODeviceTimeUpdateUpReg;

/**
 * The relUpReg message of the property "DiPODeviceTimeUpdate"
 * Property contains Device time update of apple device which is connected for CP or CPW.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPODeviceTimeUpdateRelUpReg;

/**
 * The error message of 'DiPODeviceTimeUpdate'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPODeviceTimeUpdateError;

/**
 * The abort error message of the method "Connect"
 * The AppControl Connect method provides the interface for the Internet Radio to tell the
 * iPod device control to connect to the Pandora application using the MediaPlayer.
 */
typedef ::asf::cca::CcaTypes::DefaultError ConnectAbortError;

/**
 * The error message of 'Connect'
 */
typedef ::asf::cca::CcaTypes::DefaultError ConnectError;

/**
 * The abort error message of the method "Command"
 * The AppControl Command method provides the interface for the Internet Radio to send
 * an IAP command to the MediaPlayer.
 */
typedef ::asf::cca::CcaTypes::DefaultError CommandAbortError;

/**
 * The error message of 'Command'
 */
typedef ::asf::cca::CcaTypes::DefaultError CommandError;

/**
 * The result message of the method "Close"
 * The AppControl Close method provides the interface for the Internet Radio to send an IAP
 * command to the MediaPlayer to terminate the IAP session with the Pandora application.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CloseResult;

/**
 * The abort error message of the method "Close"
 * The AppControl Close method provides the interface for the Internet Radio to send an IAP
 * command to the MediaPlayer to terminate the IAP session with the Pandora application.
 */
typedef ::asf::cca::CcaTypes::DefaultError CloseAbortError;

/**
 * The error message of 'Close'
 */
typedef ::asf::cca::CcaTypes::DefaultError CloseError;

/**
 * The result message of the method "StartAudio"
 * Starts audio playback on apple device. This function must be called if application wants to playback an audio stream on apple device
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StartAudioResult;

/**
 * The abort error message of the method "StartAudio"
 * Starts audio playback on apple device. This function must be called if application wants to playback an audio stream on apple device
 */
typedef ::asf::cca::CcaTypes::DefaultError StartAudioAbortError;

/**
 * The error message of 'StartAudio'
 */
typedef ::asf::cca::CcaTypes::DefaultError StartAudioError;

/**
 * The result message of the method "StopAudio"
 * Stops audio playback on apple device. This function must be called if application does not want to play audio stream anymore.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StopAudioResult;

/**
 * The abort error message of the method "StopAudio"
 * Stops audio playback on apple device. This function must be called if application does not want to play audio stream anymore.
 */
typedef ::asf::cca::CcaTypes::DefaultError StopAudioAbortError;

/**
 * The error message of 'StopAudio'
 */
typedef ::asf::cca::CcaTypes::DefaultError StopAudioError;

/**
 * The abort error message of the method "DiPOActiveDevice"
 * Deprecated!
 * MediaPlayer is informed when a device is used as DiPO device. This information can be used by MediaPlayer
 * to transfer metadata if available
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOActiveDeviceAbortError;

/**
 * The error message of 'DiPOActiveDevice'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOActiveDeviceError;

/**
 * The abort error message of the method "DiPORoleSwitchRequest"
 * Requests a USB role switch: From USB client to USB host or vice versa
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPORoleSwitchRequestAbortError;

/**
 * The error message of 'DiPORoleSwitchRequest'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPORoleSwitchRequestError;

/**
 * The abort error message of the method "DiPOGetMediaObjectAlbumArtInfo"
 * This Method is used to retrieve the MIME type and size of the album art
 * image associated with a particular media object. The actual album art image is retrieved by calling the
 * DiPOGetMediaObjectAlbumArt function.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOGetMediaObjectAlbumArtInfoAbortError;

/**
 * The error message of 'DiPOGetMediaObjectAlbumArtInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOGetMediaObjectAlbumArtInfoError;

/**
 * The abort error message of the method "DiPOGetMediaObjectAlbumArt"
 * The DiPOGetMediaObjectAlbumArt method is called to retrieve the album art
 * image, if it exists, for a particular media object. The image is returned
 * in a MIME-typed image format. To get the MIME type, as well as image size,
 * controllers first call the DiPOGetMediaObjectAlbumArtInfo Method, retrieve the
 * MIME type and size to set up the retrieval of the album art, then call
 * DiPOGetMediaObjectAlbumArt to retrieve the actual image data.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOGetMediaObjectAlbumArtAbortError;

/**
 * The error message of 'DiPOGetMediaObjectAlbumArt'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOGetMediaObjectAlbumArtError;

/**
 * The abort error message of the method "DiPOTransferGPSData"
 * Transfers GPS data to DiPO device. If string is empty data is not transferred to apple device
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOTransferGPSDataAbortError;

/**
 * The error message of 'DiPOTransferGPSData'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOTransferGPSDataError;

/**
 * The abort error message of the method "DiPOTransferDRData"
 * Transfers Dead Reckoning sensor data to DiPO device
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOTransferDRDataAbortError;

/**
 * The error message of 'DiPOTransferDRData'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOTransferDRDataError;

/**
 * The abort error message of the method "DiPORequestAudioDevice"
 * Request for DiPO Audio device name.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPORequestAudioDeviceAbortError;

/**
 * The error message of 'DiPORequestAudioDevice'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPORequestAudioDeviceError;

/**
 * The abort error message of the method "DiPOReleaseAudioDevice"
 * Request to release audio device.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOReleaseAudioDeviceAbortError;

/**
 * The error message of 'DiPOReleaseAudioDevice'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOReleaseAudioDeviceError;

/**
 * The result message of the method "DiPORequestPlaybackAction"
 * Requests the playback action for a certain devicve
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPORequestPlaybackActionResult;

/**
 * The abort error message of the method "DiPORequestPlaybackAction"
 * Requests the playback action for a certain devicve
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPORequestPlaybackActionAbortError;

/**
 * The error message of 'DiPORequestPlaybackAction'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPORequestPlaybackActionError;

/**
 * The result message of the method "DiPOStartIAP2OverCarPlayWifi"
 * Requests to Start iAP2 session over Carplay Wifi
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOStartIAP2OverCarPlayWifiResult;

/**
 * The abort error message of the method "DiPOStartIAP2OverCarPlayWifi"
 * Requests to Start iAP2 session over Carplay Wifi
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOStartIAP2OverCarPlayWifiAbortError;

/**
 * The error message of 'DiPOStartIAP2OverCarPlayWifi'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOStartIAP2OverCarPlayWifiError;

/**
 * The result message of the method "DiPOStartRouteGuidance"
 * StartRouteGuidanceUpdate must be sent when accessory is ready to display navigation route guidance
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOStartRouteGuidanceResult;

/**
 * The abort error message of the method "DiPOStartRouteGuidance"
 * StartRouteGuidanceUpdate must be sent when accessory is ready to display navigation route guidance
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOStartRouteGuidanceAbortError;

/**
 * The error message of 'DiPOStartRouteGuidance'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOStartRouteGuidanceError;

/**
 * The result message of the method "DiPOStopRouteGuidance"
 * StopRouteGuidanceUpdate must be sent when navigation route guidance is not being displayed by the accessory.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOStopRouteGuidanceResult;

/**
 * The abort error message of the method "DiPOStopRouteGuidance"
 * StopRouteGuidanceUpdate must be sent when navigation route guidance is not being displayed by the accessory.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOStopRouteGuidanceAbortError;

/**
 * The error message of 'DiPOStopRouteGuidance'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOStopRouteGuidanceError;

/**
 * The result message of the method "SwapCalls"
 * Swap current call with on hold call.
 * Deprecated : Use DiPOSwapCalls
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SwapCallsResult;

/**
 * The abort error message of the method "SwapCalls"
 * Swap current call with on hold call.
 * Deprecated : Use DiPOSwapCalls
 */
typedef ::asf::cca::CcaTypes::DefaultError SwapCallsAbortError;

/**
 * The error message of 'SwapCalls'
 */
typedef ::asf::cca::CcaTypes::DefaultError SwapCallsError;

/**
 * The result message of the method "DiPOSetRouteGuidanceDisplayComponentInfo"
 * Set the RouteGuidance DisplayComponents information for iAP2 identification.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOSetRouteGuidanceDisplayComponentInfoResult;

/**
 * The abort error message of the method "DiPOSetRouteGuidanceDisplayComponentInfo"
 * Set the RouteGuidance DisplayComponents information for iAP2 identification.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOSetRouteGuidanceDisplayComponentInfoAbortError;

/**
 * The error message of 'DiPOSetRouteGuidanceDisplayComponentInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOSetRouteGuidanceDisplayComponentInfoError;

/**
 * The result message of the method "DiPOStopRouteGuidance2"
 * StopRouteGuidanceUpdate must be sent when navigation route guidance is not being displayed by the accessory.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOStopRouteGuidance2Result;

/**
 * The abort error message of the method "DiPOStopRouteGuidance2"
 * StopRouteGuidanceUpdate must be sent when navigation route guidance is not being displayed by the accessory.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOStopRouteGuidance2AbortError;

/**
 * The error message of 'DiPOStopRouteGuidance2'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOStopRouteGuidance2Error;

/**
 * The result message of the method "DiPOStartRouteGuidance2"
 * StartRouteGuidanceUpdate must be sent when accessory is ready to display navigation route guidance
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOStartRouteGuidance2Result;

/**
 * The abort error message of the method "DiPOStartRouteGuidance2"
 * StartRouteGuidanceUpdate must be sent when accessory is ready to display navigation route guidance
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOStartRouteGuidance2AbortError;

/**
 * The error message of 'DiPOStartRouteGuidance2'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOStartRouteGuidance2Error;

/**
 * The result message of the method "DiPOSetCallControlsConfiguration"
 * Set the CallControls message configuration information for iAP2 identification.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOSetCallControlsConfigurationResult;

/**
 * The abort error message of the method "DiPOSetCallControlsConfiguration"
 * Set the CallControls message configuration information for iAP2 identification.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOSetCallControlsConfigurationAbortError;

/**
 * The error message of 'DiPOSetCallControlsConfiguration'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOSetCallControlsConfigurationError;

/**
 * The result message of the method "DiPOInitiateCall"
 * Initiate call Method.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOInitiateCallResult;

/**
 * The abort error message of the method "DiPOInitiateCall"
 * Initiate call Method.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOInitiateCallAbortError;

/**
 * The error message of 'DiPOInitiateCall'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOInitiateCallError;

/**
 * The result message of the method "DiPOAcceptCall"
 * Accept call Method.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOAcceptCallResult;

/**
 * The abort error message of the method "DiPOAcceptCall"
 * Accept call Method.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOAcceptCallAbortError;

/**
 * The error message of 'DiPOAcceptCall'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOAcceptCallError;

/**
 * The result message of the method "DiPOEndCall"
 * End call Method.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOEndCallResult;

/**
 * The abort error message of the method "DiPOEndCall"
 * End call Method.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOEndCallAbortError;

/**
 * The error message of 'DiPOEndCall'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOEndCallError;

/**
 * The result message of the method "DiPOMergeCalls"
 * Merge calls Method.
 * Note: Method not yet implemented.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOMergeCallsResult;

/**
 * The abort error message of the method "DiPOMergeCalls"
 * Merge calls Method.
 * Note: Method not yet implemented.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOMergeCallsAbortError;

/**
 * The error message of 'DiPOMergeCalls'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOMergeCallsError;

/**
 * The result message of the method "DiPOHoldStatusUpdate"
 * HoldStatusUpdate method.
 * Note: Method not yet implemented.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOHoldStatusUpdateResult;

/**
 * The abort error message of the method "DiPOHoldStatusUpdate"
 * HoldStatusUpdate method.
 * Note: Method not yet implemented.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOHoldStatusUpdateAbortError;

/**
 * The error message of 'DiPOHoldStatusUpdate'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOHoldStatusUpdateError;

/**
 * The result message of the method "DiPOMuteStatusUpdate"
 * MuteStatusUpdate method.
 * Note: Method not yet implemented.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOMuteStatusUpdateResult;

/**
 * The abort error message of the method "DiPOMuteStatusUpdate"
 * MuteStatusUpdate method.
 * Note: Method not yet implemented.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOMuteStatusUpdateAbortError;

/**
 * The error message of 'DiPOMuteStatusUpdate'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOMuteStatusUpdateError;

/**
 * The result message of the method "DiPOSendDTMF"
 * SendDTMF method.
 * Note: Method not yet implemented.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOSendDTMFResult;

/**
 * The abort error message of the method "DiPOSendDTMF"
 * SendDTMF method.
 * Note: Method not yet implemented.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOSendDTMFAbortError;

/**
 * The error message of 'DiPOSendDTMF'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOSendDTMFError;

/**
 * The result message of the method "DiPOSwapCalls"
 * Swap current call with on hold call.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiPOSwapCallsResult;

/**
 * The abort error message of the method "DiPOSwapCalls"
 * Swap current call with on hold call.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOSwapCallsAbortError;

/**
 * The error message of 'DiPOSwapCalls'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOSwapCallsError;

/**
 * The abort error message of the method "DiPOSetAppleIdentificationInfo"
 * Set the neccessary iAP2 parameters required for iAP2 identification acceptance during Carplay session.
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOSetAppleIdentificationInfoAbortError;

/**
 * The error message of 'DiPOSetAppleIdentificationInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPOSetAppleIdentificationInfoError;

/**
 * The abort error message of the method "DiPORequestBluetoothAudioDevice"
 * Method to request or release BT audio device
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPORequestBluetoothAudioDeviceAbortError;

/**
 * The error message of 'DiPORequestBluetoothAudioDevice'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiPORequestBluetoothAudioDeviceError;


/**
 * The status message of the property "DataResponse"
 * The AppControl Response property provides asynchronous notifications of the IAP
 * responses received from the iPod Device control to the Internet Radio FBlock over CCA.
 * Notify IAP command responses to the Internet Radio FBlock
 */
class DataResponseStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DataResponseStatus ();

    /**
     * Copy constructor
     */
    inline  DataResponseStatus (const DataResponseStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DataResponseStatus (const ::std::string& szDeviceId_, const ::std::string& szAppName_, uint16 u16SessionId_, const ::asf::core::Blob& au8CommandResponseBuffer_);

    /**
     * Destructor
     */
    inline virtual  ~DataResponseStatus();

    /**
     * Assignment operator
     */
    inline DataResponseStatus& operator = (const DataResponseStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DataResponseStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DataResponseStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DataResponseStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DataResponseStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "szDeviceId"

    static const int kSzDeviceId = 0;

    /**
     * Clears the field "szDeviceId".
     *
     * The field will be set to its default value. The hasSzDeviceId()
     * method will return false.
     */
    inline void clearSzDeviceId();

    /**
     * Checks whether the field "szDeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDeviceId()). Otherwise it will return false.
     */
    inline bool hasSzDeviceId () const;

    /**
     * Returns the value of the member "szDeviceId".
     *
     * A string containing the iPhone HID device name.
     *
     * @return The value of the field "szDeviceId"
     */
    inline const ::std::string& getSzDeviceId () const;

    /**
     * Retrieves the value of the field "szDeviceId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDeviceId".
     */
    inline ::std::string& getSzDeviceIdMutable ();

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone HID device name.
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const ::std::string& szDeviceId_);

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone HID device name.
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const char* szDeviceId_);

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone HID device name.
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const char* value, size_t size);

    // API of field "szAppName"

    static const int kSzAppName = 1;

    /**
     * Clears the field "szAppName".
     *
     * The field will be set to its default value. The hasSzAppName()
     * method will return false.
     */
    inline void clearSzAppName();

    /**
     * Checks whether the field "szAppName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzAppName()). Otherwise it will return false.
     */
    inline bool hasSzAppName () const;

    /**
     * Returns the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @return The value of the field "szAppName"
     */
    inline const ::std::string& getSzAppName () const;

    /**
     * Retrieves the value of the field "szAppName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szAppName".
     */
    inline ::std::string& getSzAppNameMutable ();

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const ::std::string& szAppName_);

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const char* szAppName_);

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const char* value, size_t size);

    // API of field "u16SessionId"

    static const int kU16SessionId = 2;

    /**
     * Clears the field "u16SessionId".
     *
     * The field will be set to its default value. The hasU16SessionId()
     * method will return false.
     */
    inline void clearU16SessionId();

    /**
     * Checks whether the field "u16SessionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SessionId()). Otherwise it will return false.
     */
    inline bool hasU16SessionId () const;

    /**
     * Returns the value of the member "u16SessionId".
     *
     * The session ID of the connection to the Pandora application.
     *
     * @return The value of the field "u16SessionId"
     */
    inline uint16 getU16SessionId () const;

    /**
     * Sets the value of the member "u16SessionId".
     *
     * The session ID of the connection to the Pandora application.
     *
     * @param u16SessionId The value which will be set
     */
    inline void setU16SessionId (uint16 u16SessionId_);

    // API of field "au8CommandResponseBuffer"

    static const int kAu8CommandResponseBuffer = 3;

    /**
     * Clears the field "au8CommandResponseBuffer".
     *
     * The field will be set to its default value. The hasAu8CommandResponseBuffer()
     * method will return false.
     */
    inline void clearAu8CommandResponseBuffer();

    /**
     * Checks whether the field "au8CommandResponseBuffer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAu8CommandResponseBuffer()). Otherwise it will return false.
     */
    inline bool hasAu8CommandResponseBuffer () const;

    /**
     * Returns the value of the member "au8CommandResponseBuffer".
     *
     * IAP command response.
     *
     * @return The value of the field "au8CommandResponseBuffer"
     */
    inline const ::asf::core::Blob& getAu8CommandResponseBuffer () const;

    /**
     * Retrieves the value of the field "au8CommandResponseBuffer" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "au8CommandResponseBuffer".
     */
    inline ::asf::core::Blob& getAu8CommandResponseBufferMutable ();

    /**
     * Sets the value of the member "au8CommandResponseBuffer".
     *
     * IAP command response.
     *
     * @param au8CommandResponseBuffer The value which will be set
     */
    inline void setAu8CommandResponseBuffer (const ::asf::core::Blob& au8CommandResponseBuffer_);

    static const DataResponseStatus &getDefaultInstance();

private:

    inline void set_has_szDeviceId ();

    inline void clear_has_szDeviceId ();

    inline void set_has_szAppName ();

    inline void clear_has_szAppName ();

    inline void set_has_u16SessionId ();

    inline void clear_has_u16SessionId ();

    inline void set_has_au8CommandResponseBuffer ();

    inline void clear_has_au8CommandResponseBuffer ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _szDeviceId;

    ::std::string _szAppName;

    uint16 _u16SessionId;

    ::asf::core::Blob _au8CommandResponseBuffer;

};

/**
 * The status message of the property "SessionOpened"
 * The AppControl Response property provides asynchronous notifications of the IAP
 * data session open event received from the iPod Device control to the Internet Radio FBlock over CCA.
 * Notify IAP command responses to the Internet Radio FBlock
 */
class SessionOpenedStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SessionOpenedStatus ();

    /**
     * Copy constructor
     */
    inline  SessionOpenedStatus (const SessionOpenedStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SessionOpenedStatus (const ::std::string& szDeviceId_, const ::std::string& szAppName_, uint16 u16SessionId_, const ::std::string& szProtocolName_);

    /**
     * Destructor
     */
    inline virtual  ~SessionOpenedStatus();

    /**
     * Assignment operator
     */
    inline SessionOpenedStatus& operator = (const SessionOpenedStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SessionOpenedStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SessionOpenedStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SessionOpenedStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SessionOpenedStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "szDeviceId"

    static const int kSzDeviceId = 0;

    /**
     * Clears the field "szDeviceId".
     *
     * The field will be set to its default value. The hasSzDeviceId()
     * method will return false.
     */
    inline void clearSzDeviceId();

    /**
     * Checks whether the field "szDeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDeviceId()). Otherwise it will return false.
     */
    inline bool hasSzDeviceId () const;

    /**
     * Returns the value of the member "szDeviceId".
     *
     * A string containing the iPhone HID device name.
     *
     * @return The value of the field "szDeviceId"
     */
    inline const ::std::string& getSzDeviceId () const;

    /**
     * Retrieves the value of the field "szDeviceId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDeviceId".
     */
    inline ::std::string& getSzDeviceIdMutable ();

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone HID device name.
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const ::std::string& szDeviceId_);

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone HID device name.
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const char* szDeviceId_);

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone HID device name.
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const char* value, size_t size);

    // API of field "szAppName"

    static const int kSzAppName = 1;

    /**
     * Clears the field "szAppName".
     *
     * The field will be set to its default value. The hasSzAppName()
     * method will return false.
     */
    inline void clearSzAppName();

    /**
     * Checks whether the field "szAppName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzAppName()). Otherwise it will return false.
     */
    inline bool hasSzAppName () const;

    /**
     * Returns the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @return The value of the field "szAppName"
     */
    inline const ::std::string& getSzAppName () const;

    /**
     * Retrieves the value of the field "szAppName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szAppName".
     */
    inline ::std::string& getSzAppNameMutable ();

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const ::std::string& szAppName_);

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const char* szAppName_);

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const char* value, size_t size);

    // API of field "u16SessionId"

    static const int kU16SessionId = 2;

    /**
     * Clears the field "u16SessionId".
     *
     * The field will be set to its default value. The hasU16SessionId()
     * method will return false.
     */
    inline void clearU16SessionId();

    /**
     * Checks whether the field "u16SessionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SessionId()). Otherwise it will return false.
     */
    inline bool hasU16SessionId () const;

    /**
     * Returns the value of the member "u16SessionId".
     *
     * The session ID of the connected IAP application.
     *
     * @return The value of the field "u16SessionId"
     */
    inline uint16 getU16SessionId () const;

    /**
     * Sets the value of the member "u16SessionId".
     *
     * The session ID of the connected IAP application.
     *
     * @param u16SessionId The value which will be set
     */
    inline void setU16SessionId (uint16 u16SessionId_);

    // API of field "szProtocolName"

    static const int kSzProtocolName = 3;

    /**
     * Clears the field "szProtocolName".
     *
     * The field will be set to its default value. The hasSzProtocolName()
     * method will return false.
     */
    inline void clearSzProtocolName();

    /**
     * Checks whether the field "szProtocolName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzProtocolName()). Otherwise it will return false.
     */
    inline bool hasSzProtocolName () const;

    /**
     * Returns the value of the member "szProtocolName".
     *
     * A string containing the Protocol name of the IAP application.
     *
     * @return The value of the field "szProtocolName"
     */
    inline const ::std::string& getSzProtocolName () const;

    /**
     * Retrieves the value of the field "szProtocolName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szProtocolName".
     */
    inline ::std::string& getSzProtocolNameMutable ();

    /**
     * Sets the value of the member "szProtocolName".
     *
     * A string containing the Protocol name of the IAP application.
     *
     * @param szProtocolName The value which will be set
     */
    inline void setSzProtocolName (const ::std::string& szProtocolName_);

    /**
     * Sets the value of the member "szProtocolName".
     *
     * A string containing the Protocol name of the IAP application.
     *
     * @param szProtocolName The value which will be set
     */
    inline void setSzProtocolName (const char* szProtocolName_);

    /**
     * Sets the value of the member "szProtocolName".
     *
     * A string containing the Protocol name of the IAP application.
     *
     * @param szProtocolName The value which will be set
     */
    inline void setSzProtocolName (const char* value, size_t size);

    static const SessionOpenedStatus &getDefaultInstance();

private:

    inline void set_has_szDeviceId ();

    inline void clear_has_szDeviceId ();

    inline void set_has_szAppName ();

    inline void clear_has_szAppName ();

    inline void set_has_u16SessionId ();

    inline void clear_has_u16SessionId ();

    inline void set_has_szProtocolName ();

    inline void clear_has_szProtocolName ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _szDeviceId;

    ::std::string _szAppName;

    uint16 _u16SessionId;

    ::std::string _szProtocolName;

};

/**
 * The status message of the property "SessionClosed"
 * The AppControl SessionClosed property provides asynchronous notifications of the IAP
 * data session close event received from the iPod Device control to the Internet Radio FBlock over CCA.
 * Notify IAP command responses to the Internet Radio FBlock
 */
class SessionClosedStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SessionClosedStatus ();

    /**
     * Copy constructor
     */
    inline  SessionClosedStatus (const SessionClosedStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SessionClosedStatus (const ::std::string& szDeviceId_, const ::std::string& szAppName_, uint16 u16SessionId_);

    /**
     * Destructor
     */
    inline virtual  ~SessionClosedStatus();

    /**
     * Assignment operator
     */
    inline SessionClosedStatus& operator = (const SessionClosedStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SessionClosedStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SessionClosedStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SessionClosedStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SessionClosedStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "szDeviceId"

    static const int kSzDeviceId = 0;

    /**
     * Clears the field "szDeviceId".
     *
     * The field will be set to its default value. The hasSzDeviceId()
     * method will return false.
     */
    inline void clearSzDeviceId();

    /**
     * Checks whether the field "szDeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDeviceId()). Otherwise it will return false.
     */
    inline bool hasSzDeviceId () const;

    /**
     * Returns the value of the member "szDeviceId".
     *
     * A string containing the iPhone HID device name.
     *
     * @return The value of the field "szDeviceId"
     */
    inline const ::std::string& getSzDeviceId () const;

    /**
     * Retrieves the value of the field "szDeviceId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDeviceId".
     */
    inline ::std::string& getSzDeviceIdMutable ();

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone HID device name.
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const ::std::string& szDeviceId_);

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone HID device name.
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const char* szDeviceId_);

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone HID device name.
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const char* value, size_t size);

    // API of field "szAppName"

    static const int kSzAppName = 1;

    /**
     * Clears the field "szAppName".
     *
     * The field will be set to its default value. The hasSzAppName()
     * method will return false.
     */
    inline void clearSzAppName();

    /**
     * Checks whether the field "szAppName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzAppName()). Otherwise it will return false.
     */
    inline bool hasSzAppName () const;

    /**
     * Returns the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @return The value of the field "szAppName"
     */
    inline const ::std::string& getSzAppName () const;

    /**
     * Retrieves the value of the field "szAppName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szAppName".
     */
    inline ::std::string& getSzAppNameMutable ();

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const ::std::string& szAppName_);

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const char* szAppName_);

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const char* value, size_t size);

    // API of field "u16SessionId"

    static const int kU16SessionId = 2;

    /**
     * Clears the field "u16SessionId".
     *
     * The field will be set to its default value. The hasU16SessionId()
     * method will return false.
     */
    inline void clearU16SessionId();

    /**
     * Checks whether the field "u16SessionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SessionId()). Otherwise it will return false.
     */
    inline bool hasU16SessionId () const;

    /**
     * Returns the value of the member "u16SessionId".
     *
     * The session ID of the connected IAP application.
     *
     * @return The value of the field "u16SessionId"
     */
    inline uint16 getU16SessionId () const;

    /**
     * Sets the value of the member "u16SessionId".
     *
     * The session ID of the connected IAP application.
     *
     * @param u16SessionId The value which will be set
     */
    inline void setU16SessionId (uint16 u16SessionId_);

    static const SessionClosedStatus &getDefaultInstance();

private:

    inline void set_has_szDeviceId ();

    inline void clear_has_szDeviceId ();

    inline void set_has_szAppName ();

    inline void clear_has_szAppName ();

    inline void set_has_u16SessionId ();

    inline void clear_has_u16SessionId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _szDeviceId;

    ::std::string _szAppName;

    uint16 _u16SessionId;

};

/**
 * The status message of the property "DiPODeviceConnections"
 * Provides notification of the number of devices connected that support media playback.  For each connected device, this property provides specific information about the device.
 */
class DiPODeviceConnectionsStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPODeviceConnectionsStatus ();

    /**
     * Copy constructor
     */
    inline  DiPODeviceConnectionsStatus (const DiPODeviceConnectionsStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiPODeviceConnectionsStatus (const ::mplay_appcontrol_fi_types::T_DiPODeviceInfo& oDeviceInfo_);

    /**
     * Destructor
     */
    inline virtual  ~DiPODeviceConnectionsStatus();

    /**
     * Assignment operator
     */
    inline DiPODeviceConnectionsStatus& operator = (const DiPODeviceConnectionsStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPODeviceConnectionsStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPODeviceConnectionsStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPODeviceConnectionsStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPODeviceConnectionsStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oDeviceInfo"

    static const int kODeviceInfo = 0;

    /**
     * Clears the field "oDeviceInfo".
     *
     * The field will be set to its default value. The hasODeviceInfo()
     * method will return false.
     */
    inline void clearODeviceInfo();

    /**
     * Checks whether the field "oDeviceInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setODeviceInfo()). Otherwise it will return false.
     */
    inline bool hasODeviceInfo () const;

    /**
     * Returns the value of the member "oDeviceInfo".
     *
     * Specific information about the connected devices.
     *
     * @return The value of the field "oDeviceInfo"
     */
    inline const ::mplay_appcontrol_fi_types::T_DiPODeviceInfo& getODeviceInfo () const;

    /**
     * Retrieves the value of the field "oDeviceInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oDeviceInfo".
     */
    inline ::mplay_appcontrol_fi_types::T_DiPODeviceInfo& getODeviceInfoMutable ();

    /**
     * Sets the value of the member "oDeviceInfo".
     *
     * Specific information about the connected devices.
     *
     * @param oDeviceInfo The value which will be set
     */
    inline void setODeviceInfo (const ::mplay_appcontrol_fi_types::T_DiPODeviceInfo& oDeviceInfo_);

    static const DiPODeviceConnectionsStatus &getDefaultInstance();

private:

    static const ::std::vector< ::mplay_appcontrol_fi_types::T_DiPODeviceInfoItem >& getT_DiPODeviceInfoItemList_DefaultInstance ();

    inline void set_has_oDeviceInfo ();

    inline void clear_has_oDeviceInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::mplay_appcontrol_fi_types::T_DiPODeviceInfo _oDeviceInfo;

};

/**
 * The status message of the property "DiPOPlaytime"
 * Identifies the amount of time elapsed and total duration of a media object. Resolution is in seconds.
 * The MediaPlayer shall send out updates to registered HMI controllers upon each 1 second change.
 */
class DiPOPlaytimeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOPlaytimeStatus ();

    /**
     * Copy constructor
     */
    inline  DiPOPlaytimeStatus (const DiPOPlaytimeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOPlaytimeStatus (uint8 u8DeviceId_, uint32 u32ElapsedPlaytime_, uint32 u32TotalPlaytime_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOPlaytimeStatus();

    /**
     * Assignment operator
     */
    inline DiPOPlaytimeStatus& operator = (const DiPOPlaytimeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOPlaytimeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOPlaytimeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOPlaytimeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOPlaytimeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceId"

    static const int kU8DeviceId = 0;

    /**
     * Clears the field "u8DeviceId".
     *
     * The field will be set to its default value. The hasU8DeviceId()
     * method will return false.
     */
    inline void clearU8DeviceId();

    /**
     * Checks whether the field "u8DeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceId()). Otherwise it will return false.
     */
    inline bool hasU8DeviceId () const;

    /**
     * Returns the value of the member "u8DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @return The value of the field "u8DeviceId"
     */
    inline uint8 getU8DeviceId () const;

    /**
     * Sets the value of the member "u8DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @param u8DeviceId The value which will be set
     */
    inline void setU8DeviceId (uint8 u8DeviceId_);

    // API of field "u32ElapsedPlaytime"

    static const int kU32ElapsedPlaytime = 1;

    /**
     * Clears the field "u32ElapsedPlaytime".
     *
     * The field will be set to its default value. The hasU32ElapsedPlaytime()
     * method will return false.
     */
    inline void clearU32ElapsedPlaytime();

    /**
     * Checks whether the field "u32ElapsedPlaytime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ElapsedPlaytime()). Otherwise it will return false.
     */
    inline bool hasU32ElapsedPlaytime () const;

    /**
     * Returns the value of the member "u32ElapsedPlaytime".
     *
     * Contains the elapsed playtime of the currently playing media file in seconds.
     *
     * @return The value of the field "u32ElapsedPlaytime"
     */
    inline uint32 getU32ElapsedPlaytime () const;

    /**
     * Sets the value of the member "u32ElapsedPlaytime".
     *
     * Contains the elapsed playtime of the currently playing media file in seconds.
     *
     * @param u32ElapsedPlaytime The value which will be set
     */
    inline void setU32ElapsedPlaytime (uint32 u32ElapsedPlaytime_);

    // API of field "u32TotalPlaytime"

    static const int kU32TotalPlaytime = 2;

    /**
     * Clears the field "u32TotalPlaytime".
     *
     * The field will be set to its default value. The hasU32TotalPlaytime()
     * method will return false.
     */
    inline void clearU32TotalPlaytime();

    /**
     * Checks whether the field "u32TotalPlaytime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32TotalPlaytime()). Otherwise it will return false.
     */
    inline bool hasU32TotalPlaytime () const;

    /**
     * Returns the value of the member "u32TotalPlaytime".
     *
     * Total playtime of the media object in seconds.
     *
     * @return The value of the field "u32TotalPlaytime"
     */
    inline uint32 getU32TotalPlaytime () const;

    /**
     * Sets the value of the member "u32TotalPlaytime".
     *
     * Total playtime of the media object in seconds.
     *
     * @param u32TotalPlaytime The value which will be set
     */
    inline void setU32TotalPlaytime (uint32 u32TotalPlaytime_);

    static const DiPOPlaytimeStatus &getDefaultInstance();

private:

    inline void set_has_u8DeviceId ();

    inline void clear_has_u8DeviceId ();

    inline void set_has_u32ElapsedPlaytime ();

    inline void clear_has_u32ElapsedPlaytime ();

    inline void set_has_u32TotalPlaytime ();

    inline void clear_has_u32TotalPlaytime ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8DeviceId;

    uint32 _u32ElapsedPlaytime;

    uint32 _u32TotalPlaytime;

};

/**
 * The status message of the property "DiPOLocationInfo"
 * MediaPlayer informs the client if location info should be sent
 */
class DiPOLocationInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOLocationInfoStatus ();

    /**
     * Copy constructor
     */
    inline  DiPOLocationInfoStatus (const DiPOLocationInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOLocationInfoStatus (bool bStartStopLocationInfo_, const ::mplay_appcontrol_fi_types::T_b8_DiPOLocationInfoType& b8LocationInfoType_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOLocationInfoStatus();

    /**
     * Assignment operator
     */
    inline DiPOLocationInfoStatus& operator = (const DiPOLocationInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOLocationInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOLocationInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOLocationInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOLocationInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bStartStopLocationInfo"

    static const int kBStartStopLocationInfo = 0;

    /**
     * Clears the field "bStartStopLocationInfo".
     *
     * The field will be set to its default value. The hasBStartStopLocationInfo()
     * method will return false.
     */
    inline void clearBStartStopLocationInfo();

    /**
     * Checks whether the field "bStartStopLocationInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBStartStopLocationInfo()). Otherwise it will return false.
     */
    inline bool hasBStartStopLocationInfo () const;

    /**
     * Returns the value of the member "bStartStopLocationInfo".
     *
     * Indicates whether location information transfer to mediaplayer should be started/stopped. .
     *
     * @return The value of the field "bStartStopLocationInfo"
     */
    inline bool getBStartStopLocationInfo () const;

    /**
     * Sets the value of the member "bStartStopLocationInfo".
     *
     * Indicates whether location information transfer to mediaplayer should be started/stopped. .
     *
     * @param bStartStopLocationInfo The value which will be set
     */
    inline void setBStartStopLocationInfo (bool bStartStopLocationInfo_);

    // API of field "b8LocationInfoType"

    static const int kB8LocationInfoType = 1;

    /**
     * Clears the field "b8LocationInfoType".
     *
     * The field will be set to its default value. The hasB8LocationInfoType()
     * method will return false.
     */
    inline void clearB8LocationInfoType();

    /**
     * Checks whether the field "b8LocationInfoType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB8LocationInfoType()). Otherwise it will return false.
     */
    inline bool hasB8LocationInfoType () const;

    /**
     * Returns the value of the member "b8LocationInfoType".
     *
     * Indicates the type(s) of Location information to be sent. (This field is ignored if StartStopLocationInfo == FALSE).
     *
     * @return The value of the field "b8LocationInfoType"
     */
    inline const ::mplay_appcontrol_fi_types::T_b8_DiPOLocationInfoType& getB8LocationInfoType () const;

    /**
     * Retrieves the value of the field "b8LocationInfoType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b8LocationInfoType".
     */
    inline ::mplay_appcontrol_fi_types::T_b8_DiPOLocationInfoType& getB8LocationInfoTypeMutable ();

    /**
     * Sets the value of the member "b8LocationInfoType".
     *
     * Indicates the type(s) of Location information to be sent. (This field is ignored if StartStopLocationInfo == FALSE).
     *
     * @param b8LocationInfoType The value which will be set
     */
    inline void setB8LocationInfoType (const ::mplay_appcontrol_fi_types::T_b8_DiPOLocationInfoType& b8LocationInfoType_);

    static const DiPOLocationInfoStatus &getDefaultInstance();

private:

    inline void set_has_bStartStopLocationInfo ();

    inline void clear_has_bStartStopLocationInfo ();

    inline void set_has_b8LocationInfoType ();

    inline void clear_has_b8LocationInfoType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bStartStopLocationInfo;

    ::mplay_appcontrol_fi_types::T_b8_DiPOLocationInfoType _b8LocationInfoType;

};

/**
 * The status message of the property "DiPOMetaData"
 * Deprecated, use DiPONowPlaying instead.
 * Property contains the metadata of the currently playing song
 */
class DiPOMetaDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOMetaDataStatus ();

    /**
     * Copy constructor
     */
    inline  DiPOMetaDataStatus (const DiPOMetaDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOMetaDataStatus (uint8 u8DeviceId_, const ::std::string& sArtist_, const ::std::string& sTitle_, const ::std::string& sAlbum_, const ::std::string& sGenre_, const ::std::string& sAlbumArt_, const ::std::string& sAppName_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOMetaDataStatus();

    /**
     * Assignment operator
     */
    inline DiPOMetaDataStatus& operator = (const DiPOMetaDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOMetaDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOMetaDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOMetaDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOMetaDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceId"

    static const int kU8DeviceId = 0;

    /**
     * Clears the field "u8DeviceId".
     *
     * The field will be set to its default value. The hasU8DeviceId()
     * method will return false.
     */
    inline void clearU8DeviceId();

    /**
     * Checks whether the field "u8DeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceId()). Otherwise it will return false.
     */
    inline bool hasU8DeviceId () const;

    /**
     * Returns the value of the member "u8DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @return The value of the field "u8DeviceId"
     */
    inline uint8 getU8DeviceId () const;

    /**
     * Sets the value of the member "u8DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @param u8DeviceId The value which will be set
     */
    inline void setU8DeviceId (uint8 u8DeviceId_);

    // API of field "sArtist"

    static const int kSArtist = 1;

    /**
     * Clears the field "sArtist".
     *
     * The field will be set to its default value. The hasSArtist()
     * method will return false.
     */
    inline void clearSArtist();

    /**
     * Checks whether the field "sArtist" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSArtist()). Otherwise it will return false.
     */
    inline bool hasSArtist () const;

    /**
     * Returns the value of the member "sArtist".
     *
     * Artist of the currently playing song.
     *
     * @return The value of the field "sArtist"
     */
    inline const ::std::string& getSArtist () const;

    /**
     * Retrieves the value of the field "sArtist" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sArtist".
     */
    inline ::std::string& getSArtistMutable ();

    /**
     * Sets the value of the member "sArtist".
     *
     * Artist of the currently playing song.
     *
     * @param sArtist The value which will be set
     */
    inline void setSArtist (const ::std::string& sArtist_);

    /**
     * Sets the value of the member "sArtist".
     *
     * Artist of the currently playing song.
     *
     * @param sArtist The value which will be set
     */
    inline void setSArtist (const char* sArtist_);

    /**
     * Sets the value of the member "sArtist".
     *
     * Artist of the currently playing song.
     *
     * @param sArtist The value which will be set
     */
    inline void setSArtist (const char* value, size_t size);

    // API of field "sTitle"

    static const int kSTitle = 2;

    /**
     * Clears the field "sTitle".
     *
     * The field will be set to its default value. The hasSTitle()
     * method will return false.
     */
    inline void clearSTitle();

    /**
     * Checks whether the field "sTitle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTitle()). Otherwise it will return false.
     */
    inline bool hasSTitle () const;

    /**
     * Returns the value of the member "sTitle".
     *
     * Title of the currently playing song.
     *
     * @return The value of the field "sTitle"
     */
    inline const ::std::string& getSTitle () const;

    /**
     * Retrieves the value of the field "sTitle" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTitle".
     */
    inline ::std::string& getSTitleMutable ();

    /**
     * Sets the value of the member "sTitle".
     *
     * Title of the currently playing song.
     *
     * @param sTitle The value which will be set
     */
    inline void setSTitle (const ::std::string& sTitle_);

    /**
     * Sets the value of the member "sTitle".
     *
     * Title of the currently playing song.
     *
     * @param sTitle The value which will be set
     */
    inline void setSTitle (const char* sTitle_);

    /**
     * Sets the value of the member "sTitle".
     *
     * Title of the currently playing song.
     *
     * @param sTitle The value which will be set
     */
    inline void setSTitle (const char* value, size_t size);

    // API of field "sAlbum"

    static const int kSAlbum = 3;

    /**
     * Clears the field "sAlbum".
     *
     * The field will be set to its default value. The hasSAlbum()
     * method will return false.
     */
    inline void clearSAlbum();

    /**
     * Checks whether the field "sAlbum" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAlbum()). Otherwise it will return false.
     */
    inline bool hasSAlbum () const;

    /**
     * Returns the value of the member "sAlbum".
     *
     * Album of the currently playing song.
     *
     * @return The value of the field "sAlbum"
     */
    inline const ::std::string& getSAlbum () const;

    /**
     * Retrieves the value of the field "sAlbum" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAlbum".
     */
    inline ::std::string& getSAlbumMutable ();

    /**
     * Sets the value of the member "sAlbum".
     *
     * Album of the currently playing song.
     *
     * @param sAlbum The value which will be set
     */
    inline void setSAlbum (const ::std::string& sAlbum_);

    /**
     * Sets the value of the member "sAlbum".
     *
     * Album of the currently playing song.
     *
     * @param sAlbum The value which will be set
     */
    inline void setSAlbum (const char* sAlbum_);

    /**
     * Sets the value of the member "sAlbum".
     *
     * Album of the currently playing song.
     *
     * @param sAlbum The value which will be set
     */
    inline void setSAlbum (const char* value, size_t size);

    // API of field "sGenre"

    static const int kSGenre = 4;

    /**
     * Clears the field "sGenre".
     *
     * The field will be set to its default value. The hasSGenre()
     * method will return false.
     */
    inline void clearSGenre();

    /**
     * Checks whether the field "sGenre" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSGenre()). Otherwise it will return false.
     */
    inline bool hasSGenre () const;

    /**
     * Returns the value of the member "sGenre".
     *
     * Genre of the currently playing song.
     *
     * @return The value of the field "sGenre"
     */
    inline const ::std::string& getSGenre () const;

    /**
     * Retrieves the value of the field "sGenre" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sGenre".
     */
    inline ::std::string& getSGenreMutable ();

    /**
     * Sets the value of the member "sGenre".
     *
     * Genre of the currently playing song.
     *
     * @param sGenre The value which will be set
     */
    inline void setSGenre (const ::std::string& sGenre_);

    /**
     * Sets the value of the member "sGenre".
     *
     * Genre of the currently playing song.
     *
     * @param sGenre The value which will be set
     */
    inline void setSGenre (const char* sGenre_);

    /**
     * Sets the value of the member "sGenre".
     *
     * Genre of the currently playing song.
     *
     * @param sGenre The value which will be set
     */
    inline void setSGenre (const char* value, size_t size);

    // API of field "sAlbumArt"

    static const int kSAlbumArt = 5;

    /**
     * Clears the field "sAlbumArt".
     *
     * The field will be set to its default value. The hasSAlbumArt()
     * method will return false.
     */
    inline void clearSAlbumArt();

    /**
     * Checks whether the field "sAlbumArt" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAlbumArt()). Otherwise it will return false.
     */
    inline bool hasSAlbumArt () const;

    /**
     * Returns the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for the currently playing song.
     *
     * @return The value of the field "sAlbumArt"
     */
    inline const ::std::string& getSAlbumArt () const;

    /**
     * Retrieves the value of the field "sAlbumArt" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAlbumArt".
     */
    inline ::std::string& getSAlbumArtMutable ();

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for the currently playing song.
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const ::std::string& sAlbumArt_);

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for the currently playing song.
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const char* sAlbumArt_);

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for the currently playing song.
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const char* value, size_t size);

    // API of field "sAppName"

    static const int kSAppName = 6;

    /**
     * Clears the field "sAppName".
     *
     * The field will be set to its default value. The hasSAppName()
     * method will return false.
     */
    inline void clearSAppName();

    /**
     * Checks whether the field "sAppName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAppName()). Otherwise it will return false.
     */
    inline bool hasSAppName () const;

    /**
     * Returns the value of the member "sAppName".
     *
     * The name of the apple application.
     *
     * @return The value of the field "sAppName"
     */
    inline const ::std::string& getSAppName () const;

    /**
     * Retrieves the value of the field "sAppName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAppName".
     */
    inline ::std::string& getSAppNameMutable ();

    /**
     * Sets the value of the member "sAppName".
     *
     * The name of the apple application.
     *
     * @param sAppName The value which will be set
     */
    inline void setSAppName (const ::std::string& sAppName_);

    /**
     * Sets the value of the member "sAppName".
     *
     * The name of the apple application.
     *
     * @param sAppName The value which will be set
     */
    inline void setSAppName (const char* sAppName_);

    /**
     * Sets the value of the member "sAppName".
     *
     * The name of the apple application.
     *
     * @param sAppName The value which will be set
     */
    inline void setSAppName (const char* value, size_t size);

    static const DiPOMetaDataStatus &getDefaultInstance();

private:

    inline void set_has_u8DeviceId ();

    inline void clear_has_u8DeviceId ();

    inline void set_has_sArtist ();

    inline void clear_has_sArtist ();

    inline void set_has_sTitle ();

    inline void clear_has_sTitle ();

    inline void set_has_sAlbum ();

    inline void clear_has_sAlbum ();

    inline void set_has_sGenre ();

    inline void clear_has_sGenre ();

    inline void set_has_sAlbumArt ();

    inline void clear_has_sAlbumArt ();

    inline void set_has_sAppName ();

    inline void clear_has_sAppName ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint8 _u8DeviceId;

    ::std::string _sArtist;

    ::std::string _sTitle;

    ::std::string _sAlbum;

    ::std::string _sGenre;

    ::std::string _sAlbumArt;

    ::std::string _sAppName;

};

/**
 * The status message of the property "DiPOPhoneData"
 * Deprecated, use DiPOCallState instead.
 * Property contains the phone information
 */
class DiPOPhoneDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOPhoneDataStatus ();

    /**
     * Copy constructor
     */
    inline  DiPOPhoneDataStatus (const DiPOPhoneDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOPhoneDataStatus (const ::std::string& sPhoneCaller_, const ::std::string& sPhoneCallInfo_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOPhoneDataStatus();

    /**
     * Assignment operator
     */
    inline DiPOPhoneDataStatus& operator = (const DiPOPhoneDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOPhoneDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOPhoneDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOPhoneDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOPhoneDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sPhoneCaller"

    static const int kSPhoneCaller = 0;

    /**
     * Clears the field "sPhoneCaller".
     *
     * The field will be set to its default value. The hasSPhoneCaller()
     * method will return false.
     */
    inline void clearSPhoneCaller();

    /**
     * Checks whether the field "sPhoneCaller" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPhoneCaller()). Otherwise it will return false.
     */
    inline bool hasSPhoneCaller () const;

    /**
     * Returns the value of the member "sPhoneCaller".
     *
     * Contains an outgoing caller name, incoming caller ID, or phone number, and is populated only during a phone call.
     * If no data is available, the string is empty.
     *
     * @return The value of the field "sPhoneCaller"
     */
    inline const ::std::string& getSPhoneCaller () const;

    /**
     * Retrieves the value of the field "sPhoneCaller" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPhoneCaller".
     */
    inline ::std::string& getSPhoneCallerMutable ();

    /**
     * Sets the value of the member "sPhoneCaller".
     *
     * Contains an outgoing caller name, incoming caller ID, or phone number, and is populated only during a phone call.
     * If no data is available, the string is empty.
     *
     * @param sPhoneCaller The value which will be set
     */
    inline void setSPhoneCaller (const ::std::string& sPhoneCaller_);

    /**
     * Sets the value of the member "sPhoneCaller".
     *
     * Contains an outgoing caller name, incoming caller ID, or phone number, and is populated only during a phone call.
     * If no data is available, the string is empty.
     *
     * @param sPhoneCaller The value which will be set
     */
    inline void setSPhoneCaller (const char* sPhoneCaller_);

    /**
     * Sets the value of the member "sPhoneCaller".
     *
     * Contains an outgoing caller name, incoming caller ID, or phone number, and is populated only during a phone call.
     * If no data is available, the string is empty.
     *
     * @param sPhoneCaller The value which will be set
     */
    inline void setSPhoneCaller (const char* value, size_t size);

    // API of field "sPhoneCallInfo"

    static const int kSPhoneCallInfo = 1;

    /**
     * Clears the field "sPhoneCallInfo".
     *
     * The field will be set to its default value. The hasSPhoneCallInfo()
     * method will return false.
     */
    inline void clearSPhoneCallInfo();

    /**
     * Checks whether the field "sPhoneCallInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPhoneCallInfo()). Otherwise it will return false.
     */
    inline bool hasSPhoneCallInfo () const;

    /**
     * Returns the value of the member "sPhoneCallInfo".
     *
     * Formatted string of information such as call time that is valid during a phone call, intended to be display on a second line along with the PhoneCaller text.
     * If no data is available, the string is empty.
     *
     * @return The value of the field "sPhoneCallInfo"
     */
    inline const ::std::string& getSPhoneCallInfo () const;

    /**
     * Retrieves the value of the field "sPhoneCallInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPhoneCallInfo".
     */
    inline ::std::string& getSPhoneCallInfoMutable ();

    /**
     * Sets the value of the member "sPhoneCallInfo".
     *
     * Formatted string of information such as call time that is valid during a phone call, intended to be display on a second line along with the PhoneCaller text.
     * If no data is available, the string is empty.
     *
     * @param sPhoneCallInfo The value which will be set
     */
    inline void setSPhoneCallInfo (const ::std::string& sPhoneCallInfo_);

    /**
     * Sets the value of the member "sPhoneCallInfo".
     *
     * Formatted string of information such as call time that is valid during a phone call, intended to be display on a second line along with the PhoneCaller text.
     * If no data is available, the string is empty.
     *
     * @param sPhoneCallInfo The value which will be set
     */
    inline void setSPhoneCallInfo (const char* sPhoneCallInfo_);

    /**
     * Sets the value of the member "sPhoneCallInfo".
     *
     * Formatted string of information such as call time that is valid during a phone call, intended to be display on a second line along with the PhoneCaller text.
     * If no data is available, the string is empty.
     *
     * @param sPhoneCallInfo The value which will be set
     */
    inline void setSPhoneCallInfo (const char* value, size_t size);

    static const DiPOPhoneDataStatus &getDefaultInstance();

private:

    inline void set_has_sPhoneCaller ();

    inline void clear_has_sPhoneCaller ();

    inline void set_has_sPhoneCallInfo ();

    inline void clear_has_sPhoneCallInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _sPhoneCaller;

    ::std::string _sPhoneCallInfo;

};

/**
 * The status message of the property "NativeTransportStart"
 * The AppControl Response property provides asynchronous notifications of the IAP2
 * EA Native Transport Open event received from the iPod Device.
 * Notify iAP2 EAP Native Transport channel changes to registered modules.
 */
class NativeTransportStartStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NativeTransportStartStatus ();

    /**
     * Copy constructor
     */
    inline  NativeTransportStartStatus (const NativeTransportStartStatus &rhs);

    /**
     * All fields constructor
     */
    inline  NativeTransportStartStatus (uint32 u32DeviceId_, uint8 u8IAP2iOSAppIdentifier_, uint8 u8SinkEndpoint_, uint8 u8SourceEndpoint_);

    /**
     * Destructor
     */
    inline virtual  ~NativeTransportStartStatus();

    /**
     * Assignment operator
     */
    inline NativeTransportStartStatus& operator = (const NativeTransportStartStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NativeTransportStartStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NativeTransportStartStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NativeTransportStartStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NativeTransportStartStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32DeviceId"

    static const int kU32DeviceId = 0;

    /**
     * Clears the field "u32DeviceId".
     *
     * The field will be set to its default value. The hasU32DeviceId()
     * method will return false.
     */
    inline void clearU32DeviceId();

    /**
     * Checks whether the field "u32DeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DeviceId()). Otherwise it will return false.
     */
    inline bool hasU32DeviceId () const;

    /**
     * Returns the value of the member "u32DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @return The value of the field "u32DeviceId"
     */
    inline uint32 getU32DeviceId () const;

    /**
     * Sets the value of the member "u32DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @param u32DeviceId The value which will be set
     */
    inline void setU32DeviceId (uint32 u32DeviceId_);

    // API of field "u8IAP2iOSAppIdentifier"

    static const int kU8IAP2iOSAppIdentifier = 1;

    /**
     * Clears the field "u8IAP2iOSAppIdentifier".
     *
     * The field will be set to its default value. The hasU8IAP2iOSAppIdentifier()
     * method will return false.
     */
    inline void clearU8IAP2iOSAppIdentifier();

    /**
     * Checks whether the field "u8IAP2iOSAppIdentifier" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8IAP2iOSAppIdentifier()). Otherwise it will return false.
     */
    inline bool hasU8IAP2iOSAppIdentifier () const;

    /**
     * Returns the value of the member "u8IAP2iOSAppIdentifier".
     *
     * The iOS app identifier of the connected iAP2 application.
     *
     * @return The value of the field "u8IAP2iOSAppIdentifier"
     */
    inline uint8 getU8IAP2iOSAppIdentifier () const;

    /**
     * Sets the value of the member "u8IAP2iOSAppIdentifier".
     *
     * The iOS app identifier of the connected iAP2 application.
     *
     * @param u8IAP2iOSAppIdentifier The value which will be set
     */
    inline void setU8IAP2iOSAppIdentifier (uint8 u8IAP2iOSAppIdentifier_);

    // API of field "u8SinkEndpoint"

    static const int kU8SinkEndpoint = 2;

    /**
     * Clears the field "u8SinkEndpoint".
     *
     * The field will be set to its default value. The hasU8SinkEndpoint()
     * method will return false.
     */
    inline void clearU8SinkEndpoint();

    /**
     * Checks whether the field "u8SinkEndpoint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SinkEndpoint()). Otherwise it will return false.
     */
    inline bool hasU8SinkEndpoint () const;

    /**
     * Returns the value of the member "u8SinkEndpoint".
     *
     * The identifier of the USB endpoint that acts as sink to the iAP2 application.
     *
     * @return The value of the field "u8SinkEndpoint"
     */
    inline uint8 getU8SinkEndpoint () const;

    /**
     * Sets the value of the member "u8SinkEndpoint".
     *
     * The identifier of the USB endpoint that acts as sink to the iAP2 application.
     *
     * @param u8SinkEndpoint The value which will be set
     */
    inline void setU8SinkEndpoint (uint8 u8SinkEndpoint_);

    // API of field "u8SourceEndpoint"

    static const int kU8SourceEndpoint = 3;

    /**
     * Clears the field "u8SourceEndpoint".
     *
     * The field will be set to its default value. The hasU8SourceEndpoint()
     * method will return false.
     */
    inline void clearU8SourceEndpoint();

    /**
     * Checks whether the field "u8SourceEndpoint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SourceEndpoint()). Otherwise it will return false.
     */
    inline bool hasU8SourceEndpoint () const;

    /**
     * Returns the value of the member "u8SourceEndpoint".
     *
     * The identifier of the USB endpoint that acts as source from the iAP2 application.
     *
     * @return The value of the field "u8SourceEndpoint"
     */
    inline uint8 getU8SourceEndpoint () const;

    /**
     * Sets the value of the member "u8SourceEndpoint".
     *
     * The identifier of the USB endpoint that acts as source from the iAP2 application.
     *
     * @param u8SourceEndpoint The value which will be set
     */
    inline void setU8SourceEndpoint (uint8 u8SourceEndpoint_);

    static const NativeTransportStartStatus &getDefaultInstance();

private:

    inline void set_has_u32DeviceId ();

    inline void clear_has_u32DeviceId ();

    inline void set_has_u8IAP2iOSAppIdentifier ();

    inline void clear_has_u8IAP2iOSAppIdentifier ();

    inline void set_has_u8SinkEndpoint ();

    inline void clear_has_u8SinkEndpoint ();

    inline void set_has_u8SourceEndpoint ();

    inline void clear_has_u8SourceEndpoint ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _u32DeviceId;

    uint8 _u8IAP2iOSAppIdentifier;

    uint8 _u8SinkEndpoint;

    uint8 _u8SourceEndpoint;

};

/**
 * The status message of the property "NativeTransportStop"
 * The AppControl Response property provides asynchronous notifications of the IAP2
 * EA Native Transport Close event received from the iPod Device.
 * Notify iAP2 EAP Native Transport channel changes to registered modules.
 */
class NativeTransportStopStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NativeTransportStopStatus ();

    /**
     * Copy constructor
     */
    inline  NativeTransportStopStatus (const NativeTransportStopStatus &rhs);

    /**
     * All fields constructor
     */
    inline  NativeTransportStopStatus (uint32 u32DeviceId_, uint8 u8IAP2iOSAppIdentifier_, uint8 u8SinkEndpoint_, uint8 u8SourceEndpoint_);

    /**
     * Destructor
     */
    inline virtual  ~NativeTransportStopStatus();

    /**
     * Assignment operator
     */
    inline NativeTransportStopStatus& operator = (const NativeTransportStopStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NativeTransportStopStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NativeTransportStopStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NativeTransportStopStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NativeTransportStopStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32DeviceId"

    static const int kU32DeviceId = 0;

    /**
     * Clears the field "u32DeviceId".
     *
     * The field will be set to its default value. The hasU32DeviceId()
     * method will return false.
     */
    inline void clearU32DeviceId();

    /**
     * Checks whether the field "u32DeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DeviceId()). Otherwise it will return false.
     */
    inline bool hasU32DeviceId () const;

    /**
     * Returns the value of the member "u32DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @return The value of the field "u32DeviceId"
     */
    inline uint32 getU32DeviceId () const;

    /**
     * Sets the value of the member "u32DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @param u32DeviceId The value which will be set
     */
    inline void setU32DeviceId (uint32 u32DeviceId_);

    // API of field "u8IAP2iOSAppIdentifier"

    static const int kU8IAP2iOSAppIdentifier = 1;

    /**
     * Clears the field "u8IAP2iOSAppIdentifier".
     *
     * The field will be set to its default value. The hasU8IAP2iOSAppIdentifier()
     * method will return false.
     */
    inline void clearU8IAP2iOSAppIdentifier();

    /**
     * Checks whether the field "u8IAP2iOSAppIdentifier" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8IAP2iOSAppIdentifier()). Otherwise it will return false.
     */
    inline bool hasU8IAP2iOSAppIdentifier () const;

    /**
     * Returns the value of the member "u8IAP2iOSAppIdentifier".
     *
     * The iOS app identifier of the connected iAP2 application.
     *
     * @return The value of the field "u8IAP2iOSAppIdentifier"
     */
    inline uint8 getU8IAP2iOSAppIdentifier () const;

    /**
     * Sets the value of the member "u8IAP2iOSAppIdentifier".
     *
     * The iOS app identifier of the connected iAP2 application.
     *
     * @param u8IAP2iOSAppIdentifier The value which will be set
     */
    inline void setU8IAP2iOSAppIdentifier (uint8 u8IAP2iOSAppIdentifier_);

    // API of field "u8SinkEndpoint"

    static const int kU8SinkEndpoint = 2;

    /**
     * Clears the field "u8SinkEndpoint".
     *
     * The field will be set to its default value. The hasU8SinkEndpoint()
     * method will return false.
     */
    inline void clearU8SinkEndpoint();

    /**
     * Checks whether the field "u8SinkEndpoint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SinkEndpoint()). Otherwise it will return false.
     */
    inline bool hasU8SinkEndpoint () const;

    /**
     * Returns the value of the member "u8SinkEndpoint".
     *
     * The identifier of the USB endpoint that acts as sink to the iAP2 application.
     *
     * @return The value of the field "u8SinkEndpoint"
     */
    inline uint8 getU8SinkEndpoint () const;

    /**
     * Sets the value of the member "u8SinkEndpoint".
     *
     * The identifier of the USB endpoint that acts as sink to the iAP2 application.
     *
     * @param u8SinkEndpoint The value which will be set
     */
    inline void setU8SinkEndpoint (uint8 u8SinkEndpoint_);

    // API of field "u8SourceEndpoint"

    static const int kU8SourceEndpoint = 3;

    /**
     * Clears the field "u8SourceEndpoint".
     *
     * The field will be set to its default value. The hasU8SourceEndpoint()
     * method will return false.
     */
    inline void clearU8SourceEndpoint();

    /**
     * Checks whether the field "u8SourceEndpoint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SourceEndpoint()). Otherwise it will return false.
     */
    inline bool hasU8SourceEndpoint () const;

    /**
     * Returns the value of the member "u8SourceEndpoint".
     *
     * The identifier of the USB endpoint that acts as source from the iAP2 application.
     *
     * @return The value of the field "u8SourceEndpoint"
     */
    inline uint8 getU8SourceEndpoint () const;

    /**
     * Sets the value of the member "u8SourceEndpoint".
     *
     * The identifier of the USB endpoint that acts as source from the iAP2 application.
     *
     * @param u8SourceEndpoint The value which will be set
     */
    inline void setU8SourceEndpoint (uint8 u8SourceEndpoint_);

    static const NativeTransportStopStatus &getDefaultInstance();

private:

    inline void set_has_u32DeviceId ();

    inline void clear_has_u32DeviceId ();

    inline void set_has_u8IAP2iOSAppIdentifier ();

    inline void clear_has_u8IAP2iOSAppIdentifier ();

    inline void set_has_u8SinkEndpoint ();

    inline void clear_has_u8SinkEndpoint ();

    inline void set_has_u8SourceEndpoint ();

    inline void clear_has_u8SourceEndpoint ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _u32DeviceId;

    uint8 _u8IAP2iOSAppIdentifier;

    uint8 _u8SinkEndpoint;

    uint8 _u8SourceEndpoint;

};

/**
 * The status message of the property "ConnectedBluetoothProfiles"
 * MediaPlayer informs the client about connected bluetooth profiles (iAP2 connections, host and device mode)
 */
class ConnectedBluetoothProfilesStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectedBluetoothProfilesStatus ();

    /**
     * Copy constructor
     */
    inline  ConnectedBluetoothProfilesStatus (const ConnectedBluetoothProfilesStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectedBluetoothProfilesStatus (const ::mplay_appcontrol_fi_types::T_BTProfileInfo& oBTProfileInfo_);

    /**
     * Destructor
     */
    inline virtual  ~ConnectedBluetoothProfilesStatus();

    /**
     * Assignment operator
     */
    inline ConnectedBluetoothProfilesStatus& operator = (const ConnectedBluetoothProfilesStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectedBluetoothProfilesStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectedBluetoothProfilesStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectedBluetoothProfilesStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectedBluetoothProfilesStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oBTProfileInfo"

    static const int kOBTProfileInfo = 0;

    /**
     * Clears the field "oBTProfileInfo".
     *
     * The field will be set to its default value. The hasOBTProfileInfo()
     * method will return false.
     */
    inline void clearOBTProfileInfo();

    /**
     * Checks whether the field "oBTProfileInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOBTProfileInfo()). Otherwise it will return false.
     */
    inline bool hasOBTProfileInfo () const;

    /**
     * Returns the value of the member "oBTProfileInfo".
     *
     * Specific information about the connected BT profiles.
     *
     * @return The value of the field "oBTProfileInfo"
     */
    inline const ::mplay_appcontrol_fi_types::T_BTProfileInfo& getOBTProfileInfo () const;

    /**
     * Retrieves the value of the field "oBTProfileInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oBTProfileInfo".
     */
    inline ::mplay_appcontrol_fi_types::T_BTProfileInfo& getOBTProfileInfoMutable ();

    /**
     * Sets the value of the member "oBTProfileInfo".
     *
     * Specific information about the connected BT profiles.
     *
     * @param oBTProfileInfo The value which will be set
     */
    inline void setOBTProfileInfo (const ::mplay_appcontrol_fi_types::T_BTProfileInfo& oBTProfileInfo_);

    static const ConnectedBluetoothProfilesStatus &getDefaultInstance();

private:

    static const ::std::vector< ::mplay_appcontrol_fi_types::T_BTProfileItem >& getT_BTProfileItemList_DefaultInstance ();

    inline void set_has_oBTProfileInfo ();

    inline void clear_has_oBTProfileInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::mplay_appcontrol_fi_types::T_BTProfileInfo _oBTProfileInfo;

};

/**
 * The status message of the property "DiPONowPlaying"
 * Property contains all metadata of the last iAP2 NowPlayingUpdate from the current DiPO device
 */
class DiPONowPlayingStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPONowPlayingStatus ();

    /**
     * Copy constructor
     */
    inline  DiPONowPlayingStatus (const DiPONowPlayingStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiPONowPlayingStatus (uint8 u8DeviceId_, const ::std::string& sTitle_, const ::std::string& sArtist_, const ::std::string& sAlbum_, const ::std::string& sGenre_, const ::std::string& sComposer_, const ::std::string& sAlbumArt_, const ::std::string& sAppName_, uint16 u16AlbumTrackNumber_, uint16 u16AlbumTrackCount_, uint16 u16AlbumDiscNumber_, uint16 u16AlbumDiscCount_, uint16 u16ChapterCount_, uint32 u32QueueIndex_, uint32 u32QueueCount_, uint32 u32QueueChapterIndex_, bool biTunesRadioAd_, const ::std::string& siTunesRadioStationName_);

    /**
     * Destructor
     */
    inline virtual  ~DiPONowPlayingStatus();

    /**
     * Assignment operator
     */
    inline DiPONowPlayingStatus& operator = (const DiPONowPlayingStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPONowPlayingStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPONowPlayingStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPONowPlayingStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPONowPlayingStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceId"

    static const int kU8DeviceId = 0;

    /**
     * Clears the field "u8DeviceId".
     *
     * The field will be set to its default value. The hasU8DeviceId()
     * method will return false.
     */
    inline void clearU8DeviceId();

    /**
     * Checks whether the field "u8DeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceId()). Otherwise it will return false.
     */
    inline bool hasU8DeviceId () const;

    /**
     * Returns the value of the member "u8DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @return The value of the field "u8DeviceId"
     */
    inline uint8 getU8DeviceId () const;

    /**
     * Sets the value of the member "u8DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @param u8DeviceId The value which will be set
     */
    inline void setU8DeviceId (uint8 u8DeviceId_);

    // API of field "sTitle"

    static const int kSTitle = 1;

    /**
     * Clears the field "sTitle".
     *
     * The field will be set to its default value. The hasSTitle()
     * method will return false.
     */
    inline void clearSTitle();

    /**
     * Checks whether the field "sTitle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTitle()). Otherwise it will return false.
     */
    inline bool hasSTitle () const;

    /**
     * Returns the value of the member "sTitle".
     *
     * Title of the currently playing song.
     *
     * @return The value of the field "sTitle"
     */
    inline const ::std::string& getSTitle () const;

    /**
     * Retrieves the value of the field "sTitle" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTitle".
     */
    inline ::std::string& getSTitleMutable ();

    /**
     * Sets the value of the member "sTitle".
     *
     * Title of the currently playing song.
     *
     * @param sTitle The value which will be set
     */
    inline void setSTitle (const ::std::string& sTitle_);

    /**
     * Sets the value of the member "sTitle".
     *
     * Title of the currently playing song.
     *
     * @param sTitle The value which will be set
     */
    inline void setSTitle (const char* sTitle_);

    /**
     * Sets the value of the member "sTitle".
     *
     * Title of the currently playing song.
     *
     * @param sTitle The value which will be set
     */
    inline void setSTitle (const char* value, size_t size);

    // API of field "sArtist"

    static const int kSArtist = 2;

    /**
     * Clears the field "sArtist".
     *
     * The field will be set to its default value. The hasSArtist()
     * method will return false.
     */
    inline void clearSArtist();

    /**
     * Checks whether the field "sArtist" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSArtist()). Otherwise it will return false.
     */
    inline bool hasSArtist () const;

    /**
     * Returns the value of the member "sArtist".
     *
     * Artist of the currently playing song.
     *
     * @return The value of the field "sArtist"
     */
    inline const ::std::string& getSArtist () const;

    /**
     * Retrieves the value of the field "sArtist" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sArtist".
     */
    inline ::std::string& getSArtistMutable ();

    /**
     * Sets the value of the member "sArtist".
     *
     * Artist of the currently playing song.
     *
     * @param sArtist The value which will be set
     */
    inline void setSArtist (const ::std::string& sArtist_);

    /**
     * Sets the value of the member "sArtist".
     *
     * Artist of the currently playing song.
     *
     * @param sArtist The value which will be set
     */
    inline void setSArtist (const char* sArtist_);

    /**
     * Sets the value of the member "sArtist".
     *
     * Artist of the currently playing song.
     *
     * @param sArtist The value which will be set
     */
    inline void setSArtist (const char* value, size_t size);

    // API of field "sAlbum"

    static const int kSAlbum = 3;

    /**
     * Clears the field "sAlbum".
     *
     * The field will be set to its default value. The hasSAlbum()
     * method will return false.
     */
    inline void clearSAlbum();

    /**
     * Checks whether the field "sAlbum" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAlbum()). Otherwise it will return false.
     */
    inline bool hasSAlbum () const;

    /**
     * Returns the value of the member "sAlbum".
     *
     * Album of the currently playing song.
     *
     * @return The value of the field "sAlbum"
     */
    inline const ::std::string& getSAlbum () const;

    /**
     * Retrieves the value of the field "sAlbum" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAlbum".
     */
    inline ::std::string& getSAlbumMutable ();

    /**
     * Sets the value of the member "sAlbum".
     *
     * Album of the currently playing song.
     *
     * @param sAlbum The value which will be set
     */
    inline void setSAlbum (const ::std::string& sAlbum_);

    /**
     * Sets the value of the member "sAlbum".
     *
     * Album of the currently playing song.
     *
     * @param sAlbum The value which will be set
     */
    inline void setSAlbum (const char* sAlbum_);

    /**
     * Sets the value of the member "sAlbum".
     *
     * Album of the currently playing song.
     *
     * @param sAlbum The value which will be set
     */
    inline void setSAlbum (const char* value, size_t size);

    // API of field "sGenre"

    static const int kSGenre = 4;

    /**
     * Clears the field "sGenre".
     *
     * The field will be set to its default value. The hasSGenre()
     * method will return false.
     */
    inline void clearSGenre();

    /**
     * Checks whether the field "sGenre" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSGenre()). Otherwise it will return false.
     */
    inline bool hasSGenre () const;

    /**
     * Returns the value of the member "sGenre".
     *
     * Genre of the currently playing song.
     *
     * @return The value of the field "sGenre"
     */
    inline const ::std::string& getSGenre () const;

    /**
     * Retrieves the value of the field "sGenre" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sGenre".
     */
    inline ::std::string& getSGenreMutable ();

    /**
     * Sets the value of the member "sGenre".
     *
     * Genre of the currently playing song.
     *
     * @param sGenre The value which will be set
     */
    inline void setSGenre (const ::std::string& sGenre_);

    /**
     * Sets the value of the member "sGenre".
     *
     * Genre of the currently playing song.
     *
     * @param sGenre The value which will be set
     */
    inline void setSGenre (const char* sGenre_);

    /**
     * Sets the value of the member "sGenre".
     *
     * Genre of the currently playing song.
     *
     * @param sGenre The value which will be set
     */
    inline void setSGenre (const char* value, size_t size);

    // API of field "sComposer"

    static const int kSComposer = 5;

    /**
     * Clears the field "sComposer".
     *
     * The field will be set to its default value. The hasSComposer()
     * method will return false.
     */
    inline void clearSComposer();

    /**
     * Checks whether the field "sComposer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSComposer()). Otherwise it will return false.
     */
    inline bool hasSComposer () const;

    /**
     * Returns the value of the member "sComposer".
     *
     * Composer of the currently playing song.
     *
     * @return The value of the field "sComposer"
     */
    inline const ::std::string& getSComposer () const;

    /**
     * Retrieves the value of the field "sComposer" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sComposer".
     */
    inline ::std::string& getSComposerMutable ();

    /**
     * Sets the value of the member "sComposer".
     *
     * Composer of the currently playing song.
     *
     * @param sComposer The value which will be set
     */
    inline void setSComposer (const ::std::string& sComposer_);

    /**
     * Sets the value of the member "sComposer".
     *
     * Composer of the currently playing song.
     *
     * @param sComposer The value which will be set
     */
    inline void setSComposer (const char* sComposer_);

    /**
     * Sets the value of the member "sComposer".
     *
     * Composer of the currently playing song.
     *
     * @param sComposer The value which will be set
     */
    inline void setSComposer (const char* value, size_t size);

    // API of field "sAlbumArt"

    static const int kSAlbumArt = 6;

    /**
     * Clears the field "sAlbumArt".
     *
     * The field will be set to its default value. The hasSAlbumArt()
     * method will return false.
     */
    inline void clearSAlbumArt();

    /**
     * Checks whether the field "sAlbumArt" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAlbumArt()). Otherwise it will return false.
     */
    inline bool hasSAlbumArt () const;

    /**
     * Returns the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for the currently playing song.
     *
     * @return The value of the field "sAlbumArt"
     */
    inline const ::std::string& getSAlbumArt () const;

    /**
     * Retrieves the value of the field "sAlbumArt" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAlbumArt".
     */
    inline ::std::string& getSAlbumArtMutable ();

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for the currently playing song.
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const ::std::string& sAlbumArt_);

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for the currently playing song.
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const char* sAlbumArt_);

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for the currently playing song.
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const char* value, size_t size);

    // API of field "sAppName"

    static const int kSAppName = 7;

    /**
     * Clears the field "sAppName".
     *
     * The field will be set to its default value. The hasSAppName()
     * method will return false.
     */
    inline void clearSAppName();

    /**
     * Checks whether the field "sAppName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAppName()). Otherwise it will return false.
     */
    inline bool hasSAppName () const;

    /**
     * Returns the value of the member "sAppName".
     *
     * The name of the apple application.
     *
     * @return The value of the field "sAppName"
     */
    inline const ::std::string& getSAppName () const;

    /**
     * Retrieves the value of the field "sAppName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAppName".
     */
    inline ::std::string& getSAppNameMutable ();

    /**
     * Sets the value of the member "sAppName".
     *
     * The name of the apple application.
     *
     * @param sAppName The value which will be set
     */
    inline void setSAppName (const ::std::string& sAppName_);

    /**
     * Sets the value of the member "sAppName".
     *
     * The name of the apple application.
     *
     * @param sAppName The value which will be set
     */
    inline void setSAppName (const char* sAppName_);

    /**
     * Sets the value of the member "sAppName".
     *
     * The name of the apple application.
     *
     * @param sAppName The value which will be set
     */
    inline void setSAppName (const char* value, size_t size);

    // API of field "u16AlbumTrackNumber"

    static const int kU16AlbumTrackNumber = 8;

    /**
     * Clears the field "u16AlbumTrackNumber".
     *
     * The field will be set to its default value. The hasU16AlbumTrackNumber()
     * method will return false.
     */
    inline void clearU16AlbumTrackNumber();

    /**
     * Checks whether the field "u16AlbumTrackNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AlbumTrackNumber()). Otherwise it will return false.
     */
    inline bool hasU16AlbumTrackNumber () const;

    /**
     * Returns the value of the member "u16AlbumTrackNumber".
     *
     * Now playing info according iAP2 Spec.
     *
     * @return The value of the field "u16AlbumTrackNumber"
     */
    inline uint16 getU16AlbumTrackNumber () const;

    /**
     * Sets the value of the member "u16AlbumTrackNumber".
     *
     * Now playing info according iAP2 Spec.
     *
     * @param u16AlbumTrackNumber The value which will be set
     */
    inline void setU16AlbumTrackNumber (uint16 u16AlbumTrackNumber_);

    // API of field "u16AlbumTrackCount"

    static const int kU16AlbumTrackCount = 9;

    /**
     * Clears the field "u16AlbumTrackCount".
     *
     * The field will be set to its default value. The hasU16AlbumTrackCount()
     * method will return false.
     */
    inline void clearU16AlbumTrackCount();

    /**
     * Checks whether the field "u16AlbumTrackCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AlbumTrackCount()). Otherwise it will return false.
     */
    inline bool hasU16AlbumTrackCount () const;

    /**
     * Returns the value of the member "u16AlbumTrackCount".
     *
     * Now playing info according iAP2 Spec.
     *
     * @return The value of the field "u16AlbumTrackCount"
     */
    inline uint16 getU16AlbumTrackCount () const;

    /**
     * Sets the value of the member "u16AlbumTrackCount".
     *
     * Now playing info according iAP2 Spec.
     *
     * @param u16AlbumTrackCount The value which will be set
     */
    inline void setU16AlbumTrackCount (uint16 u16AlbumTrackCount_);

    // API of field "u16AlbumDiscNumber"

    static const int kU16AlbumDiscNumber = 10;

    /**
     * Clears the field "u16AlbumDiscNumber".
     *
     * The field will be set to its default value. The hasU16AlbumDiscNumber()
     * method will return false.
     */
    inline void clearU16AlbumDiscNumber();

    /**
     * Checks whether the field "u16AlbumDiscNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AlbumDiscNumber()). Otherwise it will return false.
     */
    inline bool hasU16AlbumDiscNumber () const;

    /**
     * Returns the value of the member "u16AlbumDiscNumber".
     *
     * Now playing info according iAP2 Spec.
     *
     * @return The value of the field "u16AlbumDiscNumber"
     */
    inline uint16 getU16AlbumDiscNumber () const;

    /**
     * Sets the value of the member "u16AlbumDiscNumber".
     *
     * Now playing info according iAP2 Spec.
     *
     * @param u16AlbumDiscNumber The value which will be set
     */
    inline void setU16AlbumDiscNumber (uint16 u16AlbumDiscNumber_);

    // API of field "u16AlbumDiscCount"

    static const int kU16AlbumDiscCount = 11;

    /**
     * Clears the field "u16AlbumDiscCount".
     *
     * The field will be set to its default value. The hasU16AlbumDiscCount()
     * method will return false.
     */
    inline void clearU16AlbumDiscCount();

    /**
     * Checks whether the field "u16AlbumDiscCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AlbumDiscCount()). Otherwise it will return false.
     */
    inline bool hasU16AlbumDiscCount () const;

    /**
     * Returns the value of the member "u16AlbumDiscCount".
     *
     * Now playing info according iAP2 Spec.
     *
     * @return The value of the field "u16AlbumDiscCount"
     */
    inline uint16 getU16AlbumDiscCount () const;

    /**
     * Sets the value of the member "u16AlbumDiscCount".
     *
     * Now playing info according iAP2 Spec.
     *
     * @param u16AlbumDiscCount The value which will be set
     */
    inline void setU16AlbumDiscCount (uint16 u16AlbumDiscCount_);

    // API of field "u16ChapterCount"

    static const int kU16ChapterCount = 12;

    /**
     * Clears the field "u16ChapterCount".
     *
     * The field will be set to its default value. The hasU16ChapterCount()
     * method will return false.
     */
    inline void clearU16ChapterCount();

    /**
     * Checks whether the field "u16ChapterCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ChapterCount()). Otherwise it will return false.
     */
    inline bool hasU16ChapterCount () const;

    /**
     * Returns the value of the member "u16ChapterCount".
     *
     * Now playing info according iAP2 Spec.
     *
     * @return The value of the field "u16ChapterCount"
     */
    inline uint16 getU16ChapterCount () const;

    /**
     * Sets the value of the member "u16ChapterCount".
     *
     * Now playing info according iAP2 Spec.
     *
     * @param u16ChapterCount The value which will be set
     */
    inline void setU16ChapterCount (uint16 u16ChapterCount_);

    // API of field "u32QueueIndex"

    static const int kU32QueueIndex = 13;

    /**
     * Clears the field "u32QueueIndex".
     *
     * The field will be set to its default value. The hasU32QueueIndex()
     * method will return false.
     */
    inline void clearU32QueueIndex();

    /**
     * Checks whether the field "u32QueueIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32QueueIndex()). Otherwise it will return false.
     */
    inline bool hasU32QueueIndex () const;

    /**
     * Returns the value of the member "u32QueueIndex".
     *
     * Now playing info according iAP2 Spec.
     *
     * @return The value of the field "u32QueueIndex"
     */
    inline uint32 getU32QueueIndex () const;

    /**
     * Sets the value of the member "u32QueueIndex".
     *
     * Now playing info according iAP2 Spec.
     *
     * @param u32QueueIndex The value which will be set
     */
    inline void setU32QueueIndex (uint32 u32QueueIndex_);

    // API of field "u32QueueCount"

    static const int kU32QueueCount = 14;

    /**
     * Clears the field "u32QueueCount".
     *
     * The field will be set to its default value. The hasU32QueueCount()
     * method will return false.
     */
    inline void clearU32QueueCount();

    /**
     * Checks whether the field "u32QueueCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32QueueCount()). Otherwise it will return false.
     */
    inline bool hasU32QueueCount () const;

    /**
     * Returns the value of the member "u32QueueCount".
     *
     * Now playing info according iAP2 Spec.
     *
     * @return The value of the field "u32QueueCount"
     */
    inline uint32 getU32QueueCount () const;

    /**
     * Sets the value of the member "u32QueueCount".
     *
     * Now playing info according iAP2 Spec.
     *
     * @param u32QueueCount The value which will be set
     */
    inline void setU32QueueCount (uint32 u32QueueCount_);

    // API of field "u32QueueChapterIndex"

    static const int kU32QueueChapterIndex = 15;

    /**
     * Clears the field "u32QueueChapterIndex".
     *
     * The field will be set to its default value. The hasU32QueueChapterIndex()
     * method will return false.
     */
    inline void clearU32QueueChapterIndex();

    /**
     * Checks whether the field "u32QueueChapterIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32QueueChapterIndex()). Otherwise it will return false.
     */
    inline bool hasU32QueueChapterIndex () const;

    /**
     * Returns the value of the member "u32QueueChapterIndex".
     *
     * Now playing info according iAP2 Spec.
     *
     * @return The value of the field "u32QueueChapterIndex"
     */
    inline uint32 getU32QueueChapterIndex () const;

    /**
     * Sets the value of the member "u32QueueChapterIndex".
     *
     * Now playing info according iAP2 Spec.
     *
     * @param u32QueueChapterIndex The value which will be set
     */
    inline void setU32QueueChapterIndex (uint32 u32QueueChapterIndex_);

    // API of field "biTunesRadioAd"

    static const int kBiTunesRadioAd = 16;

    /**
     * Clears the field "biTunesRadioAd".
     *
     * The field will be set to its default value. The hasBiTunesRadioAd()
     * method will return false.
     */
    inline void clearBiTunesRadioAd();

    /**
     * Checks whether the field "biTunesRadioAd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBiTunesRadioAd()). Otherwise it will return false.
     */
    inline bool hasBiTunesRadioAd () const;

    /**
     * Returns the value of the member "biTunesRadioAd".
     *
     * Now playing info according iAP2 Spec.
     *
     * @return The value of the field "biTunesRadioAd"
     */
    inline bool getBiTunesRadioAd () const;

    /**
     * Sets the value of the member "biTunesRadioAd".
     *
     * Now playing info according iAP2 Spec.
     *
     * @param biTunesRadioAd The value which will be set
     */
    inline void setBiTunesRadioAd (bool biTunesRadioAd_);

    // API of field "siTunesRadioStationName"

    static const int kSiTunesRadioStationName = 17;

    /**
     * Clears the field "siTunesRadioStationName".
     *
     * The field will be set to its default value. The hasSiTunesRadioStationName()
     * method will return false.
     */
    inline void clearSiTunesRadioStationName();

    /**
     * Checks whether the field "siTunesRadioStationName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSiTunesRadioStationName()). Otherwise it will return false.
     */
    inline bool hasSiTunesRadioStationName () const;

    /**
     * Returns the value of the member "siTunesRadioStationName".
     *
     * Now playing info according iAP2 Spec.
     *
     * @return The value of the field "siTunesRadioStationName"
     */
    inline const ::std::string& getSiTunesRadioStationName () const;

    /**
     * Retrieves the value of the field "siTunesRadioStationName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "siTunesRadioStationName".
     */
    inline ::std::string& getSiTunesRadioStationNameMutable ();

    /**
     * Sets the value of the member "siTunesRadioStationName".
     *
     * Now playing info according iAP2 Spec.
     *
     * @param siTunesRadioStationName The value which will be set
     */
    inline void setSiTunesRadioStationName (const ::std::string& siTunesRadioStationName_);

    /**
     * Sets the value of the member "siTunesRadioStationName".
     *
     * Now playing info according iAP2 Spec.
     *
     * @param siTunesRadioStationName The value which will be set
     */
    inline void setSiTunesRadioStationName (const char* siTunesRadioStationName_);

    /**
     * Sets the value of the member "siTunesRadioStationName".
     *
     * Now playing info according iAP2 Spec.
     *
     * @param siTunesRadioStationName The value which will be set
     */
    inline void setSiTunesRadioStationName (const char* value, size_t size);

    static const DiPONowPlayingStatus &getDefaultInstance();

private:

    inline void set_has_u8DeviceId ();

    inline void clear_has_u8DeviceId ();

    inline void set_has_sTitle ();

    inline void clear_has_sTitle ();

    inline void set_has_sArtist ();

    inline void clear_has_sArtist ();

    inline void set_has_sAlbum ();

    inline void clear_has_sAlbum ();

    inline void set_has_sGenre ();

    inline void clear_has_sGenre ();

    inline void set_has_sComposer ();

    inline void clear_has_sComposer ();

    inline void set_has_sAlbumArt ();

    inline void clear_has_sAlbumArt ();

    inline void set_has_sAppName ();

    inline void clear_has_sAppName ();

    inline void set_has_u16AlbumTrackNumber ();

    inline void clear_has_u16AlbumTrackNumber ();

    inline void set_has_u16AlbumTrackCount ();

    inline void clear_has_u16AlbumTrackCount ();

    inline void set_has_u16AlbumDiscNumber ();

    inline void clear_has_u16AlbumDiscNumber ();

    inline void set_has_u16AlbumDiscCount ();

    inline void clear_has_u16AlbumDiscCount ();

    inline void set_has_u16ChapterCount ();

    inline void clear_has_u16ChapterCount ();

    inline void set_has_u32QueueIndex ();

    inline void clear_has_u32QueueIndex ();

    inline void set_has_u32QueueCount ();

    inline void clear_has_u32QueueCount ();

    inline void set_has_u32QueueChapterIndex ();

    inline void clear_has_u32QueueChapterIndex ();

    inline void set_has_biTunesRadioAd ();

    inline void clear_has_biTunesRadioAd ();

    inline void set_has_siTunesRadioStationName ();

    inline void clear_has_siTunesRadioStationName ();

    uint32 _has_bits_[ (18 + 31) / 32];

    uint8 _u8DeviceId;

    ::std::string _sTitle;

    ::std::string _sArtist;

    ::std::string _sAlbum;

    ::std::string _sGenre;

    ::std::string _sComposer;

    ::std::string _sAlbumArt;

    ::std::string _sAppName;

    uint16 _u16AlbumTrackNumber;

    uint16 _u16AlbumTrackCount;

    uint16 _u16AlbumDiscNumber;

    uint16 _u16AlbumDiscCount;

    uint16 _u16ChapterCount;

    uint32 _u32QueueIndex;

    uint32 _u32QueueCount;

    uint32 _u32QueueChapterIndex;

    bool _biTunesRadioAd;

    ::std::string _siTunesRadioStationName;

};

/**
 * The status message of the property "DiPOPlaybackStatus"
 * Property contains PlaybackStatus of the current DiPO device
 */
class DiPOPlaybackStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOPlaybackStatusStatus ();

    /**
     * Copy constructor
     */
    inline  DiPOPlaybackStatusStatus (const DiPOPlaybackStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOPlaybackStatusStatus (uint8 u8DeviceId_, ::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackStatus e8State_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOPlaybackStatusStatus();

    /**
     * Assignment operator
     */
    inline DiPOPlaybackStatusStatus& operator = (const DiPOPlaybackStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOPlaybackStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOPlaybackStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOPlaybackStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOPlaybackStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceId"

    static const int kU8DeviceId = 0;

    /**
     * Clears the field "u8DeviceId".
     *
     * The field will be set to its default value. The hasU8DeviceId()
     * method will return false.
     */
    inline void clearU8DeviceId();

    /**
     * Checks whether the field "u8DeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceId()). Otherwise it will return false.
     */
    inline bool hasU8DeviceId () const;

    /**
     * Returns the value of the member "u8DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @return The value of the field "u8DeviceId"
     */
    inline uint8 getU8DeviceId () const;

    /**
     * Sets the value of the member "u8DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @param u8DeviceId The value which will be set
     */
    inline void setU8DeviceId (uint8 u8DeviceId_);

    // API of field "e8State"

    static const int kE8State = 1;

    /**
     * Clears the field "e8State".
     *
     * The field will be set to its default value. The hasE8State()
     * method will return false.
     */
    inline void clearE8State();

    /**
     * Checks whether the field "e8State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8State()). Otherwise it will return false.
     */
    inline bool hasE8State () const;

    /**
     * Returns the value of the member "e8State".
     *
     * Playback state of the current DiPO device
     *
     * @return The value of the field "e8State"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackStatus getE8State () const;

    /**
     * Sets the value of the member "e8State".
     *
     * Playback state of the current DiPO device
     *
     * @param e8State The value which will be set
     */
    inline void setE8State (::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackStatus e8State_);

    static const DiPOPlaybackStatusStatus &getDefaultInstance();

private:

    inline void set_has_u8DeviceId ();

    inline void clear_has_u8DeviceId ();

    inline void set_has_e8State ();

    inline void clear_has_e8State ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceId;

    ::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackStatus _e8State;

};

/**
 * The status message of the property "DiPOPlaybackShuffleMode"
 * Property contains ShuffleMode of the current DiPO device
 */
class DiPOPlaybackShuffleModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOPlaybackShuffleModeStatus ();

    /**
     * Copy constructor
     */
    inline  DiPOPlaybackShuffleModeStatus (const DiPOPlaybackShuffleModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOPlaybackShuffleModeStatus (uint8 u8DeviceId_, ::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackShuffleMode e8Mode_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOPlaybackShuffleModeStatus();

    /**
     * Assignment operator
     */
    inline DiPOPlaybackShuffleModeStatus& operator = (const DiPOPlaybackShuffleModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOPlaybackShuffleModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOPlaybackShuffleModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOPlaybackShuffleModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOPlaybackShuffleModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceId"

    static const int kU8DeviceId = 0;

    /**
     * Clears the field "u8DeviceId".
     *
     * The field will be set to its default value. The hasU8DeviceId()
     * method will return false.
     */
    inline void clearU8DeviceId();

    /**
     * Checks whether the field "u8DeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceId()). Otherwise it will return false.
     */
    inline bool hasU8DeviceId () const;

    /**
     * Returns the value of the member "u8DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @return The value of the field "u8DeviceId"
     */
    inline uint8 getU8DeviceId () const;

    /**
     * Sets the value of the member "u8DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @param u8DeviceId The value which will be set
     */
    inline void setU8DeviceId (uint8 u8DeviceId_);

    // API of field "e8Mode"

    static const int kE8Mode = 1;

    /**
     * Clears the field "e8Mode".
     *
     * The field will be set to its default value. The hasE8Mode()
     * method will return false.
     */
    inline void clearE8Mode();

    /**
     * Checks whether the field "e8Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Mode()). Otherwise it will return false.
     */
    inline bool hasE8Mode () const;

    /**
     * Returns the value of the member "e8Mode".
     *
     * Shuffle mode of the current DiPO device
     *
     * @return The value of the field "e8Mode"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackShuffleMode getE8Mode () const;

    /**
     * Sets the value of the member "e8Mode".
     *
     * Shuffle mode of the current DiPO device
     *
     * @param e8Mode The value which will be set
     */
    inline void setE8Mode (::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackShuffleMode e8Mode_);

    static const DiPOPlaybackShuffleModeStatus &getDefaultInstance();

private:

    inline void set_has_u8DeviceId ();

    inline void clear_has_u8DeviceId ();

    inline void set_has_e8Mode ();

    inline void clear_has_e8Mode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceId;

    ::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackShuffleMode _e8Mode;

};

/**
 * The status message of the property "DiPOPlaybackRepeatMode"
 * Property contains RepeatMode of the current DiPO device
 */
class DiPOPlaybackRepeatModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOPlaybackRepeatModeStatus ();

    /**
     * Copy constructor
     */
    inline  DiPOPlaybackRepeatModeStatus (const DiPOPlaybackRepeatModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOPlaybackRepeatModeStatus (uint8 u8DeviceId_, ::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackRepeatMode e8Mode_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOPlaybackRepeatModeStatus();

    /**
     * Assignment operator
     */
    inline DiPOPlaybackRepeatModeStatus& operator = (const DiPOPlaybackRepeatModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOPlaybackRepeatModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOPlaybackRepeatModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOPlaybackRepeatModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOPlaybackRepeatModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceId"

    static const int kU8DeviceId = 0;

    /**
     * Clears the field "u8DeviceId".
     *
     * The field will be set to its default value. The hasU8DeviceId()
     * method will return false.
     */
    inline void clearU8DeviceId();

    /**
     * Checks whether the field "u8DeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceId()). Otherwise it will return false.
     */
    inline bool hasU8DeviceId () const;

    /**
     * Returns the value of the member "u8DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @return The value of the field "u8DeviceId"
     */
    inline uint8 getU8DeviceId () const;

    /**
     * Sets the value of the member "u8DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @param u8DeviceId The value which will be set
     */
    inline void setU8DeviceId (uint8 u8DeviceId_);

    // API of field "e8Mode"

    static const int kE8Mode = 1;

    /**
     * Clears the field "e8Mode".
     *
     * The field will be set to its default value. The hasE8Mode()
     * method will return false.
     */
    inline void clearE8Mode();

    /**
     * Checks whether the field "e8Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Mode()). Otherwise it will return false.
     */
    inline bool hasE8Mode () const;

    /**
     * Returns the value of the member "e8Mode".
     *
     * Repeat mode of the current DiPO device
     *
     * @return The value of the field "e8Mode"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackRepeatMode getE8Mode () const;

    /**
     * Sets the value of the member "e8Mode".
     *
     * Repeat mode of the current DiPO device
     *
     * @param e8Mode The value which will be set
     */
    inline void setE8Mode (::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackRepeatMode e8Mode_);

    static const DiPOPlaybackRepeatModeStatus &getDefaultInstance();

private:

    inline void set_has_u8DeviceId ();

    inline void clear_has_u8DeviceId ();

    inline void set_has_e8Mode ();

    inline void clear_has_e8Mode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceId;

    ::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackRepeatMode _e8Mode;

};

/**
 * The status message of the property "DiPOCallState"
 * Property contains CallStateUpdates of the current DiPO device
 */
class DiPOCallStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOCallStateStatus ();

    /**
     * Copy constructor
     */
    inline  DiPOCallStateStatus (const DiPOCallStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOCallStateStatus (uint8 u8DeviceId_, const ::mplay_appcontrol_fi_types::T_DiPOCallStateUpdate& oCallStateUpdate_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOCallStateStatus();

    /**
     * Assignment operator
     */
    inline DiPOCallStateStatus& operator = (const DiPOCallStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOCallStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOCallStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOCallStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOCallStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceId"

    static const int kU8DeviceId = 0;

    /**
     * Clears the field "u8DeviceId".
     *
     * The field will be set to its default value. The hasU8DeviceId()
     * method will return false.
     */
    inline void clearU8DeviceId();

    /**
     * Checks whether the field "u8DeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceId()). Otherwise it will return false.
     */
    inline bool hasU8DeviceId () const;

    /**
     * Returns the value of the member "u8DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @return The value of the field "u8DeviceId"
     */
    inline uint8 getU8DeviceId () const;

    /**
     * Sets the value of the member "u8DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @param u8DeviceId The value which will be set
     */
    inline void setU8DeviceId (uint8 u8DeviceId_);

    // API of field "oCallStateUpdate"

    static const int kOCallStateUpdate = 1;

    /**
     * Clears the field "oCallStateUpdate".
     *
     * The field will be set to its default value. The hasOCallStateUpdate()
     * method will return false.
     */
    inline void clearOCallStateUpdate();

    /**
     * Checks whether the field "oCallStateUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOCallStateUpdate()). Otherwise it will return false.
     */
    inline bool hasOCallStateUpdate () const;

    /**
     * Returns the value of the member "oCallStateUpdate".
     *
     * CallStates of the current DiPO device
     *
     * @return The value of the field "oCallStateUpdate"
     */
    inline const ::mplay_appcontrol_fi_types::T_DiPOCallStateUpdate& getOCallStateUpdate () const;

    /**
     * Retrieves the value of the field "oCallStateUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oCallStateUpdate".
     */
    inline ::mplay_appcontrol_fi_types::T_DiPOCallStateUpdate& getOCallStateUpdateMutable ();

    /**
     * Sets the value of the member "oCallStateUpdate".
     *
     * CallStates of the current DiPO device
     *
     * @param oCallStateUpdate The value which will be set
     */
    inline void setOCallStateUpdate (const ::mplay_appcontrol_fi_types::T_DiPOCallStateUpdate& oCallStateUpdate_);

    static const DiPOCallStateStatus &getDefaultInstance();

private:

    static const ::std::vector< ::mplay_appcontrol_fi_types::T_DiPOCallStateItem >& getT_DiPOCallStateItemList_DefaultInstance ();

    inline void set_has_u8DeviceId ();

    inline void clear_has_u8DeviceId ();

    inline void set_has_oCallStateUpdate ();

    inline void clear_has_oCallStateUpdate ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceId;

    ::mplay_appcontrol_fi_types::T_DiPOCallStateUpdate _oCallStateUpdate;

};

/**
 * The status message of the property "DiPOCommunications"
 * Property contains CommunicationsUpdates of the current DiPO device
 */
class DiPOCommunicationsStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOCommunicationsStatus ();

    /**
     * Copy constructor
     */
    inline  DiPOCommunicationsStatus (const DiPOCommunicationsStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOCommunicationsStatus (uint8 u8DeviceId_, ::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateSignalStrength eSignalStrength_, ::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateRegistrationStatus eRegistrationStatus_, bool bAirplaneModeStatus_, const ::std::string& sCarrierName_, bool bCellularSupported_, bool bTelephonyEnabled_, bool bFaceTimeAudioEnabled_, bool bFaceTimeVideoEnabled_, bool bMuteStatus_, uint8 u8CurrentCallCount_, uint8 u8NewVoicemailCount_, bool bInitiateCallAvalable_, bool bEndAndAcceptAvailable_, bool bHoldAndAcceptAvailable_, bool bSwapAvailable_, bool bMergeAvailable_, bool bHoldAvailable_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOCommunicationsStatus();

    /**
     * Assignment operator
     */
    inline DiPOCommunicationsStatus& operator = (const DiPOCommunicationsStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOCommunicationsStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOCommunicationsStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOCommunicationsStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOCommunicationsStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceId"

    static const int kU8DeviceId = 0;

    /**
     * Clears the field "u8DeviceId".
     *
     * The field will be set to its default value. The hasU8DeviceId()
     * method will return false.
     */
    inline void clearU8DeviceId();

    /**
     * Checks whether the field "u8DeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceId()). Otherwise it will return false.
     */
    inline bool hasU8DeviceId () const;

    /**
     * Returns the value of the member "u8DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @return The value of the field "u8DeviceId"
     */
    inline uint8 getU8DeviceId () const;

    /**
     * Sets the value of the member "u8DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @param u8DeviceId The value which will be set
     */
    inline void setU8DeviceId (uint8 u8DeviceId_);

    // API of field "eSignalStrength"

    static const int kESignalStrength = 1;

    /**
     * Clears the field "eSignalStrength".
     *
     * The field will be set to its default value. The hasESignalStrength()
     * method will return false.
     */
    inline void clearESignalStrength();

    /**
     * Checks whether the field "eSignalStrength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setESignalStrength()). Otherwise it will return false.
     */
    inline bool hasESignalStrength () const;

    /**
     * Returns the value of the member "eSignalStrength".
     *
     * Signal strength of the current DiPO device
     *
     * @return The value of the field "eSignalStrength"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateSignalStrength getESignalStrength () const;

    /**
     * Sets the value of the member "eSignalStrength".
     *
     * Signal strength of the current DiPO device
     *
     * @param eSignalStrength The value which will be set
     */
    inline void setESignalStrength (::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateSignalStrength eSignalStrength_);

    // API of field "eRegistrationStatus"

    static const int kERegistrationStatus = 2;

    /**
     * Clears the field "eRegistrationStatus".
     *
     * The field will be set to its default value. The hasERegistrationStatus()
     * method will return false.
     */
    inline void clearERegistrationStatus();

    /**
     * Checks whether the field "eRegistrationStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setERegistrationStatus()). Otherwise it will return false.
     */
    inline bool hasERegistrationStatus () const;

    /**
     * Returns the value of the member "eRegistrationStatus".
     *
     * Registration status of the current DiPO device
     *
     * @return The value of the field "eRegistrationStatus"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateRegistrationStatus getERegistrationStatus () const;

    /**
     * Sets the value of the member "eRegistrationStatus".
     *
     * Registration status of the current DiPO device
     *
     * @param eRegistrationStatus The value which will be set
     */
    inline void setERegistrationStatus (::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateRegistrationStatus eRegistrationStatus_);

    // API of field "bAirplaneModeStatus"

    static const int kBAirplaneModeStatus = 3;

    /**
     * Clears the field "bAirplaneModeStatus".
     *
     * The field will be set to its default value. The hasBAirplaneModeStatus()
     * method will return false.
     */
    inline void clearBAirplaneModeStatus();

    /**
     * Checks whether the field "bAirplaneModeStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAirplaneModeStatus()). Otherwise it will return false.
     */
    inline bool hasBAirplaneModeStatus () const;

    /**
     * Returns the value of the member "bAirplaneModeStatus".
     *
     *
     *
     * @return The value of the field "bAirplaneModeStatus"
     */
    inline bool getBAirplaneModeStatus () const;

    /**
     * Sets the value of the member "bAirplaneModeStatus".
     *
     *
     *
     * @param bAirplaneModeStatus The value which will be set
     */
    inline void setBAirplaneModeStatus (bool bAirplaneModeStatus_);

    // API of field "sCarrierName"

    static const int kSCarrierName = 4;

    /**
     * Clears the field "sCarrierName".
     *
     * The field will be set to its default value. The hasSCarrierName()
     * method will return false.
     */
    inline void clearSCarrierName();

    /**
     * Checks whether the field "sCarrierName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCarrierName()). Otherwise it will return false.
     */
    inline bool hasSCarrierName () const;

    /**
     * Returns the value of the member "sCarrierName".
     *
     *
     *
     * @return The value of the field "sCarrierName"
     */
    inline const ::std::string& getSCarrierName () const;

    /**
     * Retrieves the value of the field "sCarrierName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCarrierName".
     */
    inline ::std::string& getSCarrierNameMutable ();

    /**
     * Sets the value of the member "sCarrierName".
     *
     *
     *
     * @param sCarrierName The value which will be set
     */
    inline void setSCarrierName (const ::std::string& sCarrierName_);

    /**
     * Sets the value of the member "sCarrierName".
     *
     *
     *
     * @param sCarrierName The value which will be set
     */
    inline void setSCarrierName (const char* sCarrierName_);

    /**
     * Sets the value of the member "sCarrierName".
     *
     *
     *
     * @param sCarrierName The value which will be set
     */
    inline void setSCarrierName (const char* value, size_t size);

    // API of field "bCellularSupported"

    static const int kBCellularSupported = 5;

    /**
     * Clears the field "bCellularSupported".
     *
     * The field will be set to its default value. The hasBCellularSupported()
     * method will return false.
     */
    inline void clearBCellularSupported();

    /**
     * Checks whether the field "bCellularSupported" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBCellularSupported()). Otherwise it will return false.
     */
    inline bool hasBCellularSupported () const;

    /**
     * Returns the value of the member "bCellularSupported".
     *
     *
     *
     * @return The value of the field "bCellularSupported"
     */
    inline bool getBCellularSupported () const;

    /**
     * Sets the value of the member "bCellularSupported".
     *
     *
     *
     * @param bCellularSupported The value which will be set
     */
    inline void setBCellularSupported (bool bCellularSupported_);

    // API of field "bTelephonyEnabled"

    static const int kBTelephonyEnabled = 6;

    /**
     * Clears the field "bTelephonyEnabled".
     *
     * The field will be set to its default value. The hasBTelephonyEnabled()
     * method will return false.
     */
    inline void clearBTelephonyEnabled();

    /**
     * Checks whether the field "bTelephonyEnabled" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTelephonyEnabled()). Otherwise it will return false.
     */
    inline bool hasBTelephonyEnabled () const;

    /**
     * Returns the value of the member "bTelephonyEnabled".
     *
     *
     *
     * @return The value of the field "bTelephonyEnabled"
     */
    inline bool getBTelephonyEnabled () const;

    /**
     * Sets the value of the member "bTelephonyEnabled".
     *
     *
     *
     * @param bTelephonyEnabled The value which will be set
     */
    inline void setBTelephonyEnabled (bool bTelephonyEnabled_);

    // API of field "bFaceTimeAudioEnabled"

    static const int kBFaceTimeAudioEnabled = 7;

    /**
     * Clears the field "bFaceTimeAudioEnabled".
     *
     * The field will be set to its default value. The hasBFaceTimeAudioEnabled()
     * method will return false.
     */
    inline void clearBFaceTimeAudioEnabled();

    /**
     * Checks whether the field "bFaceTimeAudioEnabled" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBFaceTimeAudioEnabled()). Otherwise it will return false.
     */
    inline bool hasBFaceTimeAudioEnabled () const;

    /**
     * Returns the value of the member "bFaceTimeAudioEnabled".
     *
     *
     *
     * @return The value of the field "bFaceTimeAudioEnabled"
     */
    inline bool getBFaceTimeAudioEnabled () const;

    /**
     * Sets the value of the member "bFaceTimeAudioEnabled".
     *
     *
     *
     * @param bFaceTimeAudioEnabled The value which will be set
     */
    inline void setBFaceTimeAudioEnabled (bool bFaceTimeAudioEnabled_);

    // API of field "bFaceTimeVideoEnabled"

    static const int kBFaceTimeVideoEnabled = 8;

    /**
     * Clears the field "bFaceTimeVideoEnabled".
     *
     * The field will be set to its default value. The hasBFaceTimeVideoEnabled()
     * method will return false.
     */
    inline void clearBFaceTimeVideoEnabled();

    /**
     * Checks whether the field "bFaceTimeVideoEnabled" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBFaceTimeVideoEnabled()). Otherwise it will return false.
     */
    inline bool hasBFaceTimeVideoEnabled () const;

    /**
     * Returns the value of the member "bFaceTimeVideoEnabled".
     *
     *
     *
     * @return The value of the field "bFaceTimeVideoEnabled"
     */
    inline bool getBFaceTimeVideoEnabled () const;

    /**
     * Sets the value of the member "bFaceTimeVideoEnabled".
     *
     *
     *
     * @param bFaceTimeVideoEnabled The value which will be set
     */
    inline void setBFaceTimeVideoEnabled (bool bFaceTimeVideoEnabled_);

    // API of field "bMuteStatus"

    static const int kBMuteStatus = 9;

    /**
     * Clears the field "bMuteStatus".
     *
     * The field will be set to its default value. The hasBMuteStatus()
     * method will return false.
     */
    inline void clearBMuteStatus();

    /**
     * Checks whether the field "bMuteStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMuteStatus()). Otherwise it will return false.
     */
    inline bool hasBMuteStatus () const;

    /**
     * Returns the value of the member "bMuteStatus".
     *
     *
     *
     * @return The value of the field "bMuteStatus"
     */
    inline bool getBMuteStatus () const;

    /**
     * Sets the value of the member "bMuteStatus".
     *
     *
     *
     * @param bMuteStatus The value which will be set
     */
    inline void setBMuteStatus (bool bMuteStatus_);

    // API of field "u8CurrentCallCount"

    static const int kU8CurrentCallCount = 10;

    /**
     * Clears the field "u8CurrentCallCount".
     *
     * The field will be set to its default value. The hasU8CurrentCallCount()
     * method will return false.
     */
    inline void clearU8CurrentCallCount();

    /**
     * Checks whether the field "u8CurrentCallCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CurrentCallCount()). Otherwise it will return false.
     */
    inline bool hasU8CurrentCallCount () const;

    /**
     * Returns the value of the member "u8CurrentCallCount".
     *
     *
     *
     * @return The value of the field "u8CurrentCallCount"
     */
    inline uint8 getU8CurrentCallCount () const;

    /**
     * Sets the value of the member "u8CurrentCallCount".
     *
     *
     *
     * @param u8CurrentCallCount The value which will be set
     */
    inline void setU8CurrentCallCount (uint8 u8CurrentCallCount_);

    // API of field "u8NewVoicemailCount"

    static const int kU8NewVoicemailCount = 11;

    /**
     * Clears the field "u8NewVoicemailCount".
     *
     * The field will be set to its default value. The hasU8NewVoicemailCount()
     * method will return false.
     */
    inline void clearU8NewVoicemailCount();

    /**
     * Checks whether the field "u8NewVoicemailCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NewVoicemailCount()). Otherwise it will return false.
     */
    inline bool hasU8NewVoicemailCount () const;

    /**
     * Returns the value of the member "u8NewVoicemailCount".
     *
     *
     *
     * @return The value of the field "u8NewVoicemailCount"
     */
    inline uint8 getU8NewVoicemailCount () const;

    /**
     * Sets the value of the member "u8NewVoicemailCount".
     *
     *
     *
     * @param u8NewVoicemailCount The value which will be set
     */
    inline void setU8NewVoicemailCount (uint8 u8NewVoicemailCount_);

    // API of field "bInitiateCallAvalable"

    static const int kBInitiateCallAvalable = 12;

    /**
     * Clears the field "bInitiateCallAvalable".
     *
     * The field will be set to its default value. The hasBInitiateCallAvalable()
     * method will return false.
     */
    inline void clearBInitiateCallAvalable();

    /**
     * Checks whether the field "bInitiateCallAvalable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBInitiateCallAvalable()). Otherwise it will return false.
     */
    inline bool hasBInitiateCallAvalable () const;

    /**
     * Returns the value of the member "bInitiateCallAvalable".
     *
     * Allow to initiate a call or add a call if one is already active
     *
     * @return The value of the field "bInitiateCallAvalable"
     */
    inline bool getBInitiateCallAvalable () const;

    /**
     * Sets the value of the member "bInitiateCallAvalable".
     *
     * Allow to initiate a call or add a call if one is already active
     *
     * @param bInitiateCallAvalable The value which will be set
     */
    inline void setBInitiateCallAvalable (bool bInitiateCallAvalable_);

    // API of field "bEndAndAcceptAvailable"

    static const int kBEndAndAcceptAvailable = 13;

    /**
     * Clears the field "bEndAndAcceptAvailable".
     *
     * The field will be set to its default value. The hasBEndAndAcceptAvailable()
     * method will return false.
     */
    inline void clearBEndAndAcceptAvailable();

    /**
     * Checks whether the field "bEndAndAcceptAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEndAndAcceptAvailable()). Otherwise it will return false.
     */
    inline bool hasBEndAndAcceptAvailable () const;

    /**
     * Returns the value of the member "bEndAndAcceptAvailable".
     *
     *
     *
     * @return The value of the field "bEndAndAcceptAvailable"
     */
    inline bool getBEndAndAcceptAvailable () const;

    /**
     * Sets the value of the member "bEndAndAcceptAvailable".
     *
     *
     *
     * @param bEndAndAcceptAvailable The value which will be set
     */
    inline void setBEndAndAcceptAvailable (bool bEndAndAcceptAvailable_);

    // API of field "bHoldAndAcceptAvailable"

    static const int kBHoldAndAcceptAvailable = 14;

    /**
     * Clears the field "bHoldAndAcceptAvailable".
     *
     * The field will be set to its default value. The hasBHoldAndAcceptAvailable()
     * method will return false.
     */
    inline void clearBHoldAndAcceptAvailable();

    /**
     * Checks whether the field "bHoldAndAcceptAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBHoldAndAcceptAvailable()). Otherwise it will return false.
     */
    inline bool hasBHoldAndAcceptAvailable () const;

    /**
     * Returns the value of the member "bHoldAndAcceptAvailable".
     *
     *
     *
     * @return The value of the field "bHoldAndAcceptAvailable"
     */
    inline bool getBHoldAndAcceptAvailable () const;

    /**
     * Sets the value of the member "bHoldAndAcceptAvailable".
     *
     *
     *
     * @param bHoldAndAcceptAvailable The value which will be set
     */
    inline void setBHoldAndAcceptAvailable (bool bHoldAndAcceptAvailable_);

    // API of field "bSwapAvailable"

    static const int kBSwapAvailable = 15;

    /**
     * Clears the field "bSwapAvailable".
     *
     * The field will be set to its default value. The hasBSwapAvailable()
     * method will return false.
     */
    inline void clearBSwapAvailable();

    /**
     * Checks whether the field "bSwapAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSwapAvailable()). Otherwise it will return false.
     */
    inline bool hasBSwapAvailable () const;

    /**
     * Returns the value of the member "bSwapAvailable".
     *
     *
     *
     * @return The value of the field "bSwapAvailable"
     */
    inline bool getBSwapAvailable () const;

    /**
     * Sets the value of the member "bSwapAvailable".
     *
     *
     *
     * @param bSwapAvailable The value which will be set
     */
    inline void setBSwapAvailable (bool bSwapAvailable_);

    // API of field "bMergeAvailable"

    static const int kBMergeAvailable = 16;

    /**
     * Clears the field "bMergeAvailable".
     *
     * The field will be set to its default value. The hasBMergeAvailable()
     * method will return false.
     */
    inline void clearBMergeAvailable();

    /**
     * Checks whether the field "bMergeAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMergeAvailable()). Otherwise it will return false.
     */
    inline bool hasBMergeAvailable () const;

    /**
     * Returns the value of the member "bMergeAvailable".
     *
     *
     *
     * @return The value of the field "bMergeAvailable"
     */
    inline bool getBMergeAvailable () const;

    /**
     * Sets the value of the member "bMergeAvailable".
     *
     *
     *
     * @param bMergeAvailable The value which will be set
     */
    inline void setBMergeAvailable (bool bMergeAvailable_);

    // API of field "bHoldAvailable"

    static const int kBHoldAvailable = 17;

    /**
     * Clears the field "bHoldAvailable".
     *
     * The field will be set to its default value. The hasBHoldAvailable()
     * method will return false.
     */
    inline void clearBHoldAvailable();

    /**
     * Checks whether the field "bHoldAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBHoldAvailable()). Otherwise it will return false.
     */
    inline bool hasBHoldAvailable () const;

    /**
     * Returns the value of the member "bHoldAvailable".
     *
     *
     *
     * @return The value of the field "bHoldAvailable"
     */
    inline bool getBHoldAvailable () const;

    /**
     * Sets the value of the member "bHoldAvailable".
     *
     *
     *
     * @param bHoldAvailable The value which will be set
     */
    inline void setBHoldAvailable (bool bHoldAvailable_);

    static const DiPOCommunicationsStatus &getDefaultInstance();

private:

    inline void set_has_u8DeviceId ();

    inline void clear_has_u8DeviceId ();

    inline void set_has_eSignalStrength ();

    inline void clear_has_eSignalStrength ();

    inline void set_has_eRegistrationStatus ();

    inline void clear_has_eRegistrationStatus ();

    inline void set_has_bAirplaneModeStatus ();

    inline void clear_has_bAirplaneModeStatus ();

    inline void set_has_sCarrierName ();

    inline void clear_has_sCarrierName ();

    inline void set_has_bCellularSupported ();

    inline void clear_has_bCellularSupported ();

    inline void set_has_bTelephonyEnabled ();

    inline void clear_has_bTelephonyEnabled ();

    inline void set_has_bFaceTimeAudioEnabled ();

    inline void clear_has_bFaceTimeAudioEnabled ();

    inline void set_has_bFaceTimeVideoEnabled ();

    inline void clear_has_bFaceTimeVideoEnabled ();

    inline void set_has_bMuteStatus ();

    inline void clear_has_bMuteStatus ();

    inline void set_has_u8CurrentCallCount ();

    inline void clear_has_u8CurrentCallCount ();

    inline void set_has_u8NewVoicemailCount ();

    inline void clear_has_u8NewVoicemailCount ();

    inline void set_has_bInitiateCallAvalable ();

    inline void clear_has_bInitiateCallAvalable ();

    inline void set_has_bEndAndAcceptAvailable ();

    inline void clear_has_bEndAndAcceptAvailable ();

    inline void set_has_bHoldAndAcceptAvailable ();

    inline void clear_has_bHoldAndAcceptAvailable ();

    inline void set_has_bSwapAvailable ();

    inline void clear_has_bSwapAvailable ();

    inline void set_has_bMergeAvailable ();

    inline void clear_has_bMergeAvailable ();

    inline void set_has_bHoldAvailable ();

    inline void clear_has_bHoldAvailable ();

    uint32 _has_bits_[ (18 + 31) / 32];

    uint8 _u8DeviceId;

    ::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateSignalStrength _eSignalStrength;

    ::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateRegistrationStatus _eRegistrationStatus;

    bool _bAirplaneModeStatus;

    ::std::string _sCarrierName;

    bool _bCellularSupported;

    bool _bTelephonyEnabled;

    bool _bFaceTimeAudioEnabled;

    bool _bFaceTimeVideoEnabled;

    bool _bMuteStatus;

    uint8 _u8CurrentCallCount;

    uint8 _u8NewVoicemailCount;

    bool _bInitiateCallAvalable;

    bool _bEndAndAcceptAvailable;

    bool _bHoldAndAcceptAvailable;

    bool _bSwapAvailable;

    bool _bMergeAvailable;

    bool _bHoldAvailable;

};

/**
 * The status message of the property "DiPOCommunicationError"
 * The DiPOCommunicationError property provides update to SPI for any error received by Media Player from apple device for the commands executed during carplay connection.
 */
class DiPOCommunicationErrorStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOCommunicationErrorStatus ();

    /**
     * Copy constructor
     */
    inline  DiPOCommunicationErrorStatus (const DiPOCommunicationErrorStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOCommunicationErrorStatus (uint8 u8DeviceTag_, ::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationError e8DiPOCommunicationError_, const ::std::string& sDeviceUSBSerialNumber_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOCommunicationErrorStatus();

    /**
     * Assignment operator
     */
    inline DiPOCommunicationErrorStatus& operator = (const DiPOCommunicationErrorStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOCommunicationErrorStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOCommunicationErrorStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOCommunicationErrorStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOCommunicationErrorStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 0;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the iPhone device from where communication errors are received.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the iPhone device from where communication errors are received.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "e8DiPOCommunicationError"

    static const int kE8DiPOCommunicationError = 1;

    /**
     * Clears the field "e8DiPOCommunicationError".
     *
     * The field will be set to its default value. The hasE8DiPOCommunicationError()
     * method will return false.
     */
    inline void clearE8DiPOCommunicationError();

    /**
     * Checks whether the field "e8DiPOCommunicationError" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DiPOCommunicationError()). Otherwise it will return false.
     */
    inline bool hasE8DiPOCommunicationError () const;

    /**
     * Returns the value of the member "e8DiPOCommunicationError".
     *
     * iPod Communication Errors sent by device to MediaPlayer for carplay connection.
     *
     * @return The value of the field "e8DiPOCommunicationError"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationError getE8DiPOCommunicationError () const;

    /**
     * Sets the value of the member "e8DiPOCommunicationError".
     *
     * iPod Communication Errors sent by device to MediaPlayer for carplay connection.
     *
     * @param e8DiPOCommunicationError The value which will be set
     */
    inline void setE8DiPOCommunicationError (::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationError e8DiPOCommunicationError_);

    // API of field "sDeviceUSBSerialNumber"

    static const int kSDeviceUSBSerialNumber = 2;

    /**
     * Clears the field "sDeviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasSDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearSDeviceUSBSerialNumber();

    /**
     * Checks whether the field "sDeviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasSDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @return The value of the field "sDeviceUSBSerialNumber"
     */
    inline const ::std::string& getSDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "sDeviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceUSBSerialNumber".
     */
    inline ::std::string& getSDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* value, size_t size);

    static const DiPOCommunicationErrorStatus &getDefaultInstance();

private:

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_e8DiPOCommunicationError ();

    inline void clear_has_e8DiPOCommunicationError ();

    inline void set_has_sDeviceUSBSerialNumber ();

    inline void clear_has_sDeviceUSBSerialNumber ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8DeviceTag;

    ::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationError _e8DiPOCommunicationError;

    ::std::string _sDeviceUSBSerialNumber;

};

/**
 * The status message of the property "DiPOCallDuration"
 * Property contains CallDurationUpdate.
 */
class DiPOCallDurationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOCallDurationStatus ();

    /**
     * Copy constructor
     */
    inline  DiPOCallDurationStatus (const DiPOCallDurationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOCallDurationStatus (uint8 u8DeviceId_, uint32 u32CallDuration_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOCallDurationStatus();

    /**
     * Assignment operator
     */
    inline DiPOCallDurationStatus& operator = (const DiPOCallDurationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOCallDurationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOCallDurationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOCallDurationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOCallDurationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceId"

    static const int kU8DeviceId = 0;

    /**
     * Clears the field "u8DeviceId".
     *
     * The field will be set to its default value. The hasU8DeviceId()
     * method will return false.
     */
    inline void clearU8DeviceId();

    /**
     * Checks whether the field "u8DeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceId()). Otherwise it will return false.
     */
    inline bool hasU8DeviceId () const;

    /**
     * Returns the value of the member "u8DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @return The value of the field "u8DeviceId"
     */
    inline uint8 getU8DeviceId () const;

    /**
     * Sets the value of the member "u8DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @param u8DeviceId The value which will be set
     */
    inline void setU8DeviceId (uint8 u8DeviceId_);

    // API of field "u32CallDuration"

    static const int kU32CallDuration = 1;

    /**
     * Clears the field "u32CallDuration".
     *
     * The field will be set to its default value. The hasU32CallDuration()
     * method will return false.
     */
    inline void clearU32CallDuration();

    /**
     * Checks whether the field "u32CallDuration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32CallDuration()). Otherwise it will return false.
     */
    inline bool hasU32CallDuration () const;

    /**
     * Returns the value of the member "u32CallDuration".
     *
     * Contains the call duraion in second while device in host mode.
     *
     * @return The value of the field "u32CallDuration"
     */
    inline uint32 getU32CallDuration () const;

    /**
     * Sets the value of the member "u32CallDuration".
     *
     * Contains the call duraion in second while device in host mode.
     *
     * @param u32CallDuration The value which will be set
     */
    inline void setU32CallDuration (uint32 u32CallDuration_);

    static const DiPOCallDurationStatus &getDefaultInstance();

private:

    inline void set_has_u8DeviceId ();

    inline void clear_has_u8DeviceId ();

    inline void set_has_u32CallDuration ();

    inline void clear_has_u32CallDuration ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceId;

    uint32 _u32CallDuration;

};

/**
 * The status message of the property "DiPOPower"
 * Property contains PowerUpdate.
 */
class DiPOPowerStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOPowerStatus ();

    /**
     * Copy constructor
     */
    inline  DiPOPowerStatus (const DiPOPowerStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOPowerStatus (uint8 u8DeviceId_, uint16 u16BatteryChargeLevel_, ::mplay_appcontrol_fi_types::T_e8_AccessoryPowerMode e8AccessoryPowerMode_, uint16 u16MaximumCurrentDrawnFromAccessory_, bool bDeviceBatteryWillChargeIfPowerIsPresent_, ::mplay_appcontrol_fi_types::T_e8_BatteryChargingState e8BatteryChargingState_, bool bIsExternalChargerConnected_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOPowerStatus();

    /**
     * Assignment operator
     */
    inline DiPOPowerStatus& operator = (const DiPOPowerStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOPowerStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOPowerStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOPowerStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOPowerStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceId"

    static const int kU8DeviceId = 0;

    /**
     * Clears the field "u8DeviceId".
     *
     * The field will be set to its default value. The hasU8DeviceId()
     * method will return false.
     */
    inline void clearU8DeviceId();

    /**
     * Checks whether the field "u8DeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceId()). Otherwise it will return false.
     */
    inline bool hasU8DeviceId () const;

    /**
     * Returns the value of the member "u8DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @return The value of the field "u8DeviceId"
     */
    inline uint8 getU8DeviceId () const;

    /**
     * Sets the value of the member "u8DeviceId".
     *
     * Device ID of connected iOS device.
     *
     * @param u8DeviceId The value which will be set
     */
    inline void setU8DeviceId (uint8 u8DeviceId_);

    // API of field "u16BatteryChargeLevel"

    static const int kU16BatteryChargeLevel = 1;

    /**
     * Clears the field "u16BatteryChargeLevel".
     *
     * The field will be set to its default value. The hasU16BatteryChargeLevel()
     * method will return false.
     */
    inline void clearU16BatteryChargeLevel();

    /**
     * Checks whether the field "u16BatteryChargeLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16BatteryChargeLevel()). Otherwise it will return false.
     */
    inline bool hasU16BatteryChargeLevel () const;

    /**
     * Returns the value of the member "u16BatteryChargeLevel".
     *
     * Contains the Battery Charge Level in (1-100).
     *
     * @return The value of the field "u16BatteryChargeLevel"
     */
    inline uint16 getU16BatteryChargeLevel () const;

    /**
     * Sets the value of the member "u16BatteryChargeLevel".
     *
     * Contains the Battery Charge Level in (1-100).
     *
     * @param u16BatteryChargeLevel The value which will be set
     */
    inline void setU16BatteryChargeLevel (uint16 u16BatteryChargeLevel_);

    // API of field "e8AccessoryPowerMode"

    static const int kE8AccessoryPowerMode = 2;

    /**
     * Clears the field "e8AccessoryPowerMode".
     *
     * The field will be set to its default value. The hasE8AccessoryPowerMode()
     * method will return false.
     */
    inline void clearE8AccessoryPowerMode();

    /**
     * Checks whether the field "e8AccessoryPowerMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AccessoryPowerMode()). Otherwise it will return false.
     */
    inline bool hasE8AccessoryPowerMode () const;

    /**
     * Returns the value of the member "e8AccessoryPowerMode".
     *
     * the PowerMode.
     *
     * @return The value of the field "e8AccessoryPowerMode"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_AccessoryPowerMode getE8AccessoryPowerMode () const;

    /**
     * Sets the value of the member "e8AccessoryPowerMode".
     *
     * the PowerMode.
     *
     * @param e8AccessoryPowerMode The value which will be set
     */
    inline void setE8AccessoryPowerMode (::mplay_appcontrol_fi_types::T_e8_AccessoryPowerMode e8AccessoryPowerMode_);

    // API of field "u16MaximumCurrentDrawnFromAccessory"

    static const int kU16MaximumCurrentDrawnFromAccessory = 3;

    /**
     * Clears the field "u16MaximumCurrentDrawnFromAccessory".
     *
     * The field will be set to its default value. The hasU16MaximumCurrentDrawnFromAccessory()
     * method will return false.
     */
    inline void clearU16MaximumCurrentDrawnFromAccessory();

    /**
     * Checks whether the field "u16MaximumCurrentDrawnFromAccessory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16MaximumCurrentDrawnFromAccessory()). Otherwise it will return false.
     */
    inline bool hasU16MaximumCurrentDrawnFromAccessory () const;

    /**
     * Returns the value of the member "u16MaximumCurrentDrawnFromAccessory".
     *
     * Apple Device will draw up to this amount of current(mA)from the Accessory.
     *
     * @return The value of the field "u16MaximumCurrentDrawnFromAccessory"
     */
    inline uint16 getU16MaximumCurrentDrawnFromAccessory () const;

    /**
     * Sets the value of the member "u16MaximumCurrentDrawnFromAccessory".
     *
     * Apple Device will draw up to this amount of current(mA)from the Accessory.
     *
     * @param u16MaximumCurrentDrawnFromAccessory The value which will be set
     */
    inline void setU16MaximumCurrentDrawnFromAccessory (uint16 u16MaximumCurrentDrawnFromAccessory_);

    // API of field "bDeviceBatteryWillChargeIfPowerIsPresent"

    static const int kBDeviceBatteryWillChargeIfPowerIsPresent = 4;

    /**
     * Clears the field "bDeviceBatteryWillChargeIfPowerIsPresent".
     *
     * The field will be set to its default value. The hasBDeviceBatteryWillChargeIfPowerIsPresent()
     * method will return false.
     */
    inline void clearBDeviceBatteryWillChargeIfPowerIsPresent();

    /**
     * Checks whether the field "bDeviceBatteryWillChargeIfPowerIsPresent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDeviceBatteryWillChargeIfPowerIsPresent()). Otherwise it will return false.
     */
    inline bool hasBDeviceBatteryWillChargeIfPowerIsPresent () const;

    /**
     * Returns the value of the member "bDeviceBatteryWillChargeIfPowerIsPresent".
     *
     * DeviceBatteryWillChargeIfPowerIsPresent.
     *
     * @return The value of the field "bDeviceBatteryWillChargeIfPowerIsPresent"
     */
    inline bool getBDeviceBatteryWillChargeIfPowerIsPresent () const;

    /**
     * Sets the value of the member "bDeviceBatteryWillChargeIfPowerIsPresent".
     *
     * DeviceBatteryWillChargeIfPowerIsPresent.
     *
     * @param bDeviceBatteryWillChargeIfPowerIsPresent The value which will be set
     */
    inline void setBDeviceBatteryWillChargeIfPowerIsPresent (bool bDeviceBatteryWillChargeIfPowerIsPresent_);

    // API of field "e8BatteryChargingState"

    static const int kE8BatteryChargingState = 5;

    /**
     * Clears the field "e8BatteryChargingState".
     *
     * The field will be set to its default value. The hasE8BatteryChargingState()
     * method will return false.
     */
    inline void clearE8BatteryChargingState();

    /**
     * Checks whether the field "e8BatteryChargingState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8BatteryChargingState()). Otherwise it will return false.
     */
    inline bool hasE8BatteryChargingState () const;

    /**
     * Returns the value of the member "e8BatteryChargingState".
     *
     * BatteryChargingState 0-disabled 1-charging 2-charged.
     *
     * @return The value of the field "e8BatteryChargingState"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_BatteryChargingState getE8BatteryChargingState () const;

    /**
     * Sets the value of the member "e8BatteryChargingState".
     *
     * BatteryChargingState 0-disabled 1-charging 2-charged.
     *
     * @param e8BatteryChargingState The value which will be set
     */
    inline void setE8BatteryChargingState (::mplay_appcontrol_fi_types::T_e8_BatteryChargingState e8BatteryChargingState_);

    // API of field "bIsExternalChargerConnected"

    static const int kBIsExternalChargerConnected = 6;

    /**
     * Clears the field "bIsExternalChargerConnected".
     *
     * The field will be set to its default value. The hasBIsExternalChargerConnected()
     * method will return false.
     */
    inline void clearBIsExternalChargerConnected();

    /**
     * Checks whether the field "bIsExternalChargerConnected" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsExternalChargerConnected()). Otherwise it will return false.
     */
    inline bool hasBIsExternalChargerConnected () const;

    /**
     * Returns the value of the member "bIsExternalChargerConnected".
     *
     * When an external charger connected or disconnected.
     *
     * @return The value of the field "bIsExternalChargerConnected"
     */
    inline bool getBIsExternalChargerConnected () const;

    /**
     * Sets the value of the member "bIsExternalChargerConnected".
     *
     * When an external charger connected or disconnected.
     *
     * @param bIsExternalChargerConnected The value which will be set
     */
    inline void setBIsExternalChargerConnected (bool bIsExternalChargerConnected_);

    static const DiPOPowerStatus &getDefaultInstance();

private:

    inline void set_has_u8DeviceId ();

    inline void clear_has_u8DeviceId ();

    inline void set_has_u16BatteryChargeLevel ();

    inline void clear_has_u16BatteryChargeLevel ();

    inline void set_has_e8AccessoryPowerMode ();

    inline void clear_has_e8AccessoryPowerMode ();

    inline void set_has_u16MaximumCurrentDrawnFromAccessory ();

    inline void clear_has_u16MaximumCurrentDrawnFromAccessory ();

    inline void set_has_bDeviceBatteryWillChargeIfPowerIsPresent ();

    inline void clear_has_bDeviceBatteryWillChargeIfPowerIsPresent ();

    inline void set_has_e8BatteryChargingState ();

    inline void clear_has_e8BatteryChargingState ();

    inline void set_has_bIsExternalChargerConnected ();

    inline void clear_has_bIsExternalChargerConnected ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint8 _u8DeviceId;

    uint16 _u16BatteryChargeLevel;

    ::mplay_appcontrol_fi_types::T_e8_AccessoryPowerMode _e8AccessoryPowerMode;

    uint16 _u16MaximumCurrentDrawnFromAccessory;

    bool _bDeviceBatteryWillChargeIfPowerIsPresent;

    ::mplay_appcontrol_fi_types::T_e8_BatteryChargingState _e8BatteryChargingState;

    bool _bIsExternalChargerConnected;

};

/**
 * The status message of the property "DiPORouteGuidance"
 * Property contains RouteGuidance Update.
 */
class DiPORouteGuidanceStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPORouteGuidanceStatus ();

    /**
     * Copy constructor
     */
    inline  DiPORouteGuidanceStatus (const DiPORouteGuidanceStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiPORouteGuidanceStatus (const ::std::string& sDeviceUSBSerialNumber_, uint16 u16RouteGuidanceDisplayComponentID_, ::mplay_appcontrol_fi_types::T_e8_RouteGuidanceState e8RouteGuidanceState_, ::mplay_appcontrol_fi_types::T_e8_ManeuverState e8ManeuverState_, const ::std::string& szCurrentRoadName_, const ::std::string& szDestinationName_, uint64 u64EstimatedTimeOfArrival_, uint64 u64TimeRemainingToDestination_, uint32 u32DistanceRemaining_, const ::std::string& szDistanceRemainingDisplayStr_, ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits e8DistanceRemainingDisplayUnits_, uint32 u32DistanceToNextManeuver_, const ::std::string& szDistanceToNextManeuverDisplayStr_, ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits e8DistanceToNextManeuverDisplayUnits_, const ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverCurrentList& u16RouteGuidanceManeuverCurrentList_, uint16 u16RouteGuidanceManeuverCount_, bool bIsRouteGuidanceVisibleInApp_, const ::std::string& SourceName_, bool SourceSupportsRouteGuidance_);

    /**
     * Destructor
     */
    inline virtual  ~DiPORouteGuidanceStatus();

    /**
     * Assignment operator
     */
    inline DiPORouteGuidanceStatus& operator = (const DiPORouteGuidanceStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPORouteGuidanceStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPORouteGuidanceStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPORouteGuidanceStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPORouteGuidanceStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sDeviceUSBSerialNumber"

    static const int kSDeviceUSBSerialNumber = 0;

    /**
     * Clears the field "sDeviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasSDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearSDeviceUSBSerialNumber();

    /**
     * Checks whether the field "sDeviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasSDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @return The value of the field "sDeviceUSBSerialNumber"
     */
    inline const ::std::string& getSDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "sDeviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceUSBSerialNumber".
     */
    inline ::std::string& getSDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* value, size_t size);

    // API of field "u16RouteGuidanceDisplayComponentID"

    static const int kU16RouteGuidanceDisplayComponentID = 1;

    /**
     * Clears the field "u16RouteGuidanceDisplayComponentID".
     *
     * The field will be set to its default value. The hasU16RouteGuidanceDisplayComponentID()
     * method will return false.
     */
    inline void clearU16RouteGuidanceDisplayComponentID();

    /**
     * Checks whether the field "u16RouteGuidanceDisplayComponentID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RouteGuidanceDisplayComponentID()). Otherwise it will return false.
     */
    inline bool hasU16RouteGuidanceDisplayComponentID () const;

    /**
     * Returns the value of the member "u16RouteGuidanceDisplayComponentID".
     *
     * If none specified, it means the update applies to all components. If more than one are specified, update is applied to all specified components.
     *
     * @return The value of the field "u16RouteGuidanceDisplayComponentID"
     */
    inline uint16 getU16RouteGuidanceDisplayComponentID () const;

    /**
     * Sets the value of the member "u16RouteGuidanceDisplayComponentID".
     *
     * If none specified, it means the update applies to all components. If more than one are specified, update is applied to all specified components.
     *
     * @param u16RouteGuidanceDisplayComponentID The value which will be set
     */
    inline void setU16RouteGuidanceDisplayComponentID (uint16 u16RouteGuidanceDisplayComponentID_);

    // API of field "e8RouteGuidanceState"

    static const int kE8RouteGuidanceState = 2;

    /**
     * Clears the field "e8RouteGuidanceState".
     *
     * The field will be set to its default value. The hasE8RouteGuidanceState()
     * method will return false.
     */
    inline void clearE8RouteGuidanceState();

    /**
     * Checks whether the field "e8RouteGuidanceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8RouteGuidanceState()). Otherwise it will return false.
     */
    inline bool hasE8RouteGuidanceState () const;

    /**
     * Returns the value of the member "e8RouteGuidanceState".
     *
     * Indicates current RouteGuidance state which is one of the route guidance state enum.
     *
     * @return The value of the field "e8RouteGuidanceState"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_RouteGuidanceState getE8RouteGuidanceState () const;

    /**
     * Sets the value of the member "e8RouteGuidanceState".
     *
     * Indicates current RouteGuidance state which is one of the route guidance state enum.
     *
     * @param e8RouteGuidanceState The value which will be set
     */
    inline void setE8RouteGuidanceState (::mplay_appcontrol_fi_types::T_e8_RouteGuidanceState e8RouteGuidanceState_);

    // API of field "e8ManeuverState"

    static const int kE8ManeuverState = 3;

    /**
     * Clears the field "e8ManeuverState".
     *
     * The field will be set to its default value. The hasE8ManeuverState()
     * method will return false.
     */
    inline void clearE8ManeuverState();

    /**
     * Checks whether the field "e8ManeuverState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ManeuverState()). Otherwise it will return false.
     */
    inline bool hasE8ManeuverState () const;

    /**
     * Returns the value of the member "e8ManeuverState".
     *
     * ManeuverState enum.
     *
     * @return The value of the field "e8ManeuverState"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_ManeuverState getE8ManeuverState () const;

    /**
     * Sets the value of the member "e8ManeuverState".
     *
     * ManeuverState enum.
     *
     * @param e8ManeuverState The value which will be set
     */
    inline void setE8ManeuverState (::mplay_appcontrol_fi_types::T_e8_ManeuverState e8ManeuverState_);

    // API of field "szCurrentRoadName"

    static const int kSzCurrentRoadName = 4;

    /**
     * Clears the field "szCurrentRoadName".
     *
     * The field will be set to its default value. The hasSzCurrentRoadName()
     * method will return false.
     */
    inline void clearSzCurrentRoadName();

    /**
     * Checks whether the field "szCurrentRoadName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzCurrentRoadName()). Otherwise it will return false.
     */
    inline bool hasSzCurrentRoadName () const;

    /**
     * Returns the value of the member "szCurrentRoadName".
     *
     * The name of the current road.
     *
     * @return The value of the field "szCurrentRoadName"
     */
    inline const ::std::string& getSzCurrentRoadName () const;

    /**
     * Retrieves the value of the field "szCurrentRoadName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szCurrentRoadName".
     */
    inline ::std::string& getSzCurrentRoadNameMutable ();

    /**
     * Sets the value of the member "szCurrentRoadName".
     *
     * The name of the current road.
     *
     * @param szCurrentRoadName The value which will be set
     */
    inline void setSzCurrentRoadName (const ::std::string& szCurrentRoadName_);

    /**
     * Sets the value of the member "szCurrentRoadName".
     *
     * The name of the current road.
     *
     * @param szCurrentRoadName The value which will be set
     */
    inline void setSzCurrentRoadName (const char* szCurrentRoadName_);

    /**
     * Sets the value of the member "szCurrentRoadName".
     *
     * The name of the current road.
     *
     * @param szCurrentRoadName The value which will be set
     */
    inline void setSzCurrentRoadName (const char* value, size_t size);

    // API of field "szDestinationName"

    static const int kSzDestinationName = 5;

    /**
     * Clears the field "szDestinationName".
     *
     * The field will be set to its default value. The hasSzDestinationName()
     * method will return false.
     */
    inline void clearSzDestinationName();

    /**
     * Checks whether the field "szDestinationName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDestinationName()). Otherwise it will return false.
     */
    inline bool hasSzDestinationName () const;

    /**
     * Returns the value of the member "szDestinationName".
     *
     * The name of the Destination.
     *
     * @return The value of the field "szDestinationName"
     */
    inline const ::std::string& getSzDestinationName () const;

    /**
     * Retrieves the value of the field "szDestinationName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDestinationName".
     */
    inline ::std::string& getSzDestinationNameMutable ();

    /**
     * Sets the value of the member "szDestinationName".
     *
     * The name of the Destination.
     *
     * @param szDestinationName The value which will be set
     */
    inline void setSzDestinationName (const ::std::string& szDestinationName_);

    /**
     * Sets the value of the member "szDestinationName".
     *
     * The name of the Destination.
     *
     * @param szDestinationName The value which will be set
     */
    inline void setSzDestinationName (const char* szDestinationName_);

    /**
     * Sets the value of the member "szDestinationName".
     *
     * The name of the Destination.
     *
     * @param szDestinationName The value which will be set
     */
    inline void setSzDestinationName (const char* value, size_t size);

    // API of field "u64EstimatedTimeOfArrival"

    static const int kU64EstimatedTimeOfArrival = 6;

    /**
     * Clears the field "u64EstimatedTimeOfArrival".
     *
     * The field will be set to its default value. The hasU64EstimatedTimeOfArrival()
     * method will return false.
     */
    inline void clearU64EstimatedTimeOfArrival();

    /**
     * Checks whether the field "u64EstimatedTimeOfArrival" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU64EstimatedTimeOfArrival()). Otherwise it will return false.
     */
    inline bool hasU64EstimatedTimeOfArrival () const;

    /**
     * Returns the value of the member "u64EstimatedTimeOfArrival".
     *
     * Number of seconds from reference date (Jan 1, 1970 GMT).Similar to DeviceTimeUpdate, Accessory should use DeviceTimeUpdate and use the TimeZoneOfisetMinutes and DaylightSavingsOffsetMinutes information to apply the adjustment necessary for local time
     *
     * @return The value of the field "u64EstimatedTimeOfArrival"
     */
    inline uint64 getU64EstimatedTimeOfArrival () const;

    /**
     * Sets the value of the member "u64EstimatedTimeOfArrival".
     *
     * Number of seconds from reference date (Jan 1, 1970 GMT).Similar to DeviceTimeUpdate, Accessory should use DeviceTimeUpdate and use the TimeZoneOfisetMinutes and DaylightSavingsOffsetMinutes information to apply the adjustment necessary for local time
     *
     * @param u64EstimatedTimeOfArrival The value which will be set
     */
    inline void setU64EstimatedTimeOfArrival (uint64 u64EstimatedTimeOfArrival_);

    // API of field "u64TimeRemainingToDestination"

    static const int kU64TimeRemainingToDestination = 7;

    /**
     * Clears the field "u64TimeRemainingToDestination".
     *
     * The field will be set to its default value. The hasU64TimeRemainingToDestination()
     * method will return false.
     */
    inline void clearU64TimeRemainingToDestination();

    /**
     * Checks whether the field "u64TimeRemainingToDestination" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU64TimeRemainingToDestination()). Otherwise it will return false.
     */
    inline bool hasU64TimeRemainingToDestination () const;

    /**
     * Returns the value of the member "u64TimeRemainingToDestination".
     *
     * Number of seconds to Destination.
     *
     * @return The value of the field "u64TimeRemainingToDestination"
     */
    inline uint64 getU64TimeRemainingToDestination () const;

    /**
     * Sets the value of the member "u64TimeRemainingToDestination".
     *
     * Number of seconds to Destination.
     *
     * @param u64TimeRemainingToDestination The value which will be set
     */
    inline void setU64TimeRemainingToDestination (uint64 u64TimeRemainingToDestination_);

    // API of field "u32DistanceRemaining"

    static const int kU32DistanceRemaining = 8;

    /**
     * Clears the field "u32DistanceRemaining".
     *
     * The field will be set to its default value. The hasU32DistanceRemaining()
     * method will return false.
     */
    inline void clearU32DistanceRemaining();

    /**
     * Checks whether the field "u32DistanceRemaining" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DistanceRemaining()). Otherwise it will return false.
     */
    inline bool hasU32DistanceRemaining () const;

    /**
     * Returns the value of the member "u32DistanceRemaining".
     *
     * Meters to end of trip. This value must not be displayed to the user in text. It is only to be used for generating graphics, e.g. countdown bars.
     *
     * @return The value of the field "u32DistanceRemaining"
     */
    inline uint32 getU32DistanceRemaining () const;

    /**
     * Sets the value of the member "u32DistanceRemaining".
     *
     * Meters to end of trip. This value must not be displayed to the user in text. It is only to be used for generating graphics, e.g. countdown bars.
     *
     * @param u32DistanceRemaining The value which will be set
     */
    inline void setU32DistanceRemaining (uint32 u32DistanceRemaining_);

    // API of field "szDistanceRemainingDisplayStr"

    static const int kSzDistanceRemainingDisplayStr = 9;

    /**
     * Clears the field "szDistanceRemainingDisplayStr".
     *
     * The field will be set to its default value. The hasSzDistanceRemainingDisplayStr()
     * method will return false.
     */
    inline void clearSzDistanceRemainingDisplayStr();

    /**
     * Checks whether the field "szDistanceRemainingDisplayStr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDistanceRemainingDisplayStr()). Otherwise it will return false.
     */
    inline bool hasSzDistanceRemainingDisplayStr () const;

    /**
     * Returns the value of the member "szDistanceRemainingDisplayStr".
     *
     * Display string representation of DistanceRemaining in DistanceRemainingDisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @return The value of the field "szDistanceRemainingDisplayStr"
     */
    inline const ::std::string& getSzDistanceRemainingDisplayStr () const;

    /**
     * Retrieves the value of the field "szDistanceRemainingDisplayStr" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDistanceRemainingDisplayStr".
     */
    inline ::std::string& getSzDistanceRemainingDisplayStrMutable ();

    /**
     * Sets the value of the member "szDistanceRemainingDisplayStr".
     *
     * Display string representation of DistanceRemaining in DistanceRemainingDisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @param szDistanceRemainingDisplayStr The value which will be set
     */
    inline void setSzDistanceRemainingDisplayStr (const ::std::string& szDistanceRemainingDisplayStr_);

    /**
     * Sets the value of the member "szDistanceRemainingDisplayStr".
     *
     * Display string representation of DistanceRemaining in DistanceRemainingDisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @param szDistanceRemainingDisplayStr The value which will be set
     */
    inline void setSzDistanceRemainingDisplayStr (const char* szDistanceRemainingDisplayStr_);

    /**
     * Sets the value of the member "szDistanceRemainingDisplayStr".
     *
     * Display string representation of DistanceRemaining in DistanceRemainingDisplayUnits units. Does not contain the units string. Must be displayed without unit conversion to the user.
     *
     * @param szDistanceRemainingDisplayStr The value which will be set
     */
    inline void setSzDistanceRemainingDisplayStr (const char* value, size_t size);

    // API of field "e8DistanceRemainingDisplayUnits"

    static const int kE8DistanceRemainingDisplayUnits = 10;

    /**
     * Clears the field "e8DistanceRemainingDisplayUnits".
     *
     * The field will be set to its default value. The hasE8DistanceRemainingDisplayUnits()
     * method will return false.
     */
    inline void clearE8DistanceRemainingDisplayUnits();

    /**
     * Checks whether the field "e8DistanceRemainingDisplayUnits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DistanceRemainingDisplayUnits()). Otherwise it will return false.
     */
    inline bool hasE8DistanceRemainingDisplayUnits () const;

    /**
     * Returns the value of the member "e8DistanceRemainingDisplayUnits".
     *
     * Units that must accompany DistanceRemainingDisplaystr when displayed to the user.
     *
     * @return The value of the field "e8DistanceRemainingDisplayUnits"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits getE8DistanceRemainingDisplayUnits () const;

    /**
     * Sets the value of the member "e8DistanceRemainingDisplayUnits".
     *
     * Units that must accompany DistanceRemainingDisplaystr when displayed to the user.
     *
     * @param e8DistanceRemainingDisplayUnits The value which will be set
     */
    inline void setE8DistanceRemainingDisplayUnits (::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits e8DistanceRemainingDisplayUnits_);

    // API of field "u32DistanceToNextManeuver"

    static const int kU32DistanceToNextManeuver = 11;

    /**
     * Clears the field "u32DistanceToNextManeuver".
     *
     * The field will be set to its default value. The hasU32DistanceToNextManeuver()
     * method will return false.
     */
    inline void clearU32DistanceToNextManeuver();

    /**
     * Checks whether the field "u32DistanceToNextManeuver" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DistanceToNextManeuver()). Otherwise it will return false.
     */
    inline bool hasU32DistanceToNextManeuver () const;

    /**
     * Returns the value of the member "u32DistanceToNextManeuver".
     *
     * Meters to next me euver. This value must not be displayed to the user in text. It is only to be used for generating graphics,e.g. countdown bars.
     *
     * @return The value of the field "u32DistanceToNextManeuver"
     */
    inline uint32 getU32DistanceToNextManeuver () const;

    /**
     * Sets the value of the member "u32DistanceToNextManeuver".
     *
     * Meters to next me euver. This value must not be displayed to the user in text. It is only to be used for generating graphics,e.g. countdown bars.
     *
     * @param u32DistanceToNextManeuver The value which will be set
     */
    inline void setU32DistanceToNextManeuver (uint32 u32DistanceToNextManeuver_);

    // API of field "szDistanceToNextManeuverDisplayStr"

    static const int kSzDistanceToNextManeuverDisplayStr = 12;

    /**
     * Clears the field "szDistanceToNextManeuverDisplayStr".
     *
     * The field will be set to its default value. The hasSzDistanceToNextManeuverDisplayStr()
     * method will return false.
     */
    inline void clearSzDistanceToNextManeuverDisplayStr();

    /**
     * Checks whether the field "szDistanceToNextManeuverDisplayStr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDistanceToNextManeuverDisplayStr()). Otherwise it will return false.
     */
    inline bool hasSzDistanceToNextManeuverDisplayStr () const;

    /**
     * Returns the value of the member "szDistanceToNextManeuverDisplayStr".
     *
     * Display string representation of DistanceToNextManeuver in DistanceToNextManeuverDispIayUnits units. Does not contain the units string. Must be displayed Without unit conversion to the user.
     *
     * @return The value of the field "szDistanceToNextManeuverDisplayStr"
     */
    inline const ::std::string& getSzDistanceToNextManeuverDisplayStr () const;

    /**
     * Retrieves the value of the field "szDistanceToNextManeuverDisplayStr" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDistanceToNextManeuverDisplayStr".
     */
    inline ::std::string& getSzDistanceToNextManeuverDisplayStrMutable ();

    /**
     * Sets the value of the member "szDistanceToNextManeuverDisplayStr".
     *
     * Display string representation of DistanceToNextManeuver in DistanceToNextManeuverDispIayUnits units. Does not contain the units string. Must be displayed Without unit conversion to the user.
     *
     * @param szDistanceToNextManeuverDisplayStr The value which will be set
     */
    inline void setSzDistanceToNextManeuverDisplayStr (const ::std::string& szDistanceToNextManeuverDisplayStr_);

    /**
     * Sets the value of the member "szDistanceToNextManeuverDisplayStr".
     *
     * Display string representation of DistanceToNextManeuver in DistanceToNextManeuverDispIayUnits units. Does not contain the units string. Must be displayed Without unit conversion to the user.
     *
     * @param szDistanceToNextManeuverDisplayStr The value which will be set
     */
    inline void setSzDistanceToNextManeuverDisplayStr (const char* szDistanceToNextManeuverDisplayStr_);

    /**
     * Sets the value of the member "szDistanceToNextManeuverDisplayStr".
     *
     * Display string representation of DistanceToNextManeuver in DistanceToNextManeuverDispIayUnits units. Does not contain the units string. Must be displayed Without unit conversion to the user.
     *
     * @param szDistanceToNextManeuverDisplayStr The value which will be set
     */
    inline void setSzDistanceToNextManeuverDisplayStr (const char* value, size_t size);

    // API of field "e8DistanceToNextManeuverDisplayUnits"

    static const int kE8DistanceToNextManeuverDisplayUnits = 13;

    /**
     * Clears the field "e8DistanceToNextManeuverDisplayUnits".
     *
     * The field will be set to its default value. The hasE8DistanceToNextManeuverDisplayUnits()
     * method will return false.
     */
    inline void clearE8DistanceToNextManeuverDisplayUnits();

    /**
     * Checks whether the field "e8DistanceToNextManeuverDisplayUnits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DistanceToNextManeuverDisplayUnits()). Otherwise it will return false.
     */
    inline bool hasE8DistanceToNextManeuverDisplayUnits () const;

    /**
     * Returns the value of the member "e8DistanceToNextManeuverDisplayUnits".
     *
     * Units that must accompany DistanceToNextManeuverDisplayStr when displayed to the user.
     *
     * @return The value of the field "e8DistanceToNextManeuverDisplayUnits"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits getE8DistanceToNextManeuverDisplayUnits () const;

    /**
     * Sets the value of the member "e8DistanceToNextManeuverDisplayUnits".
     *
     * Units that must accompany DistanceToNextManeuverDisplayStr when displayed to the user.
     *
     * @param e8DistanceToNextManeuverDisplayUnits The value which will be set
     */
    inline void setE8DistanceToNextManeuverDisplayUnits (::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits e8DistanceToNextManeuverDisplayUnits_);

    // API of field "u16RouteGuidanceManeuverCurrentList"

    static const int kU16RouteGuidanceManeuverCurrentList = 14;

    /**
     * Clears the field "u16RouteGuidanceManeuverCurrentList".
     *
     * The field will be set to its default value. The hasU16RouteGuidanceManeuverCurrentList()
     * method will return false.
     */
    inline void clearU16RouteGuidanceManeuverCurrentList();

    /**
     * Checks whether the field "u16RouteGuidanceManeuverCurrentList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RouteGuidanceManeuverCurrentList()). Otherwise it will return false.
     */
    inline bool hasU16RouteGuidanceManeuverCurrentList () const;

    /**
     * Returns the value of the member "u16RouteGuidanceManeuverCurrentList".
     *
     * Indices of next upcoming maneuvers in the RouteGuidance maneuver list. Multiple manuvers that occur very close together
     * can be grouped into an ordered list of indices with this parameter. Normally there would only be one entry for the current
     * upcoming maneuver. If more than one item is present in RouteGuidanceManeuverCurrent-List the maneuvers should be
     * executed in quick succession and can be displayed next to one another on the display.
     *
     * @return The value of the field "u16RouteGuidanceManeuverCurrentList"
     */
    inline const ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverCurrentList& getU16RouteGuidanceManeuverCurrentList () const;

    /**
     * Retrieves the value of the field "u16RouteGuidanceManeuverCurrentList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "u16RouteGuidanceManeuverCurrentList".
     */
    inline ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverCurrentList& getU16RouteGuidanceManeuverCurrentListMutable ();

    /**
     * Sets the value of the member "u16RouteGuidanceManeuverCurrentList".
     *
     * Indices of next upcoming maneuvers in the RouteGuidance maneuver list. Multiple manuvers that occur very close together
     * can be grouped into an ordered list of indices with this parameter. Normally there would only be one entry for the current
     * upcoming maneuver. If more than one item is present in RouteGuidanceManeuverCurrent-List the maneuvers should be
     * executed in quick succession and can be displayed next to one another on the display.
     *
     * @param u16RouteGuidanceManeuverCurrentList The value which will be set
     */
    inline void setU16RouteGuidanceManeuverCurrentList (const ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverCurrentList& u16RouteGuidanceManeuverCurrentList_);

    // API of field "u16RouteGuidanceManeuverCount"

    static const int kU16RouteGuidanceManeuverCount = 15;

    /**
     * Clears the field "u16RouteGuidanceManeuverCount".
     *
     * The field will be set to its default value. The hasU16RouteGuidanceManeuverCount()
     * method will return false.
     */
    inline void clearU16RouteGuidanceManeuverCount();

    /**
     * Checks whether the field "u16RouteGuidanceManeuverCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RouteGuidanceManeuverCount()). Otherwise it will return false.
     */
    inline bool hasU16RouteGuidanceManeuverCount () const;

    /**
     * Returns the value of the member "u16RouteGuidanceManeuverCount".
     *
     * Total number of maneuvers in the RouteGuidance maneuver list.
     *
     * @return The value of the field "u16RouteGuidanceManeuverCount"
     */
    inline uint16 getU16RouteGuidanceManeuverCount () const;

    /**
     * Sets the value of the member "u16RouteGuidanceManeuverCount".
     *
     * Total number of maneuvers in the RouteGuidance maneuver list.
     *
     * @param u16RouteGuidanceManeuverCount The value which will be set
     */
    inline void setU16RouteGuidanceManeuverCount (uint16 u16RouteGuidanceManeuverCount_);

    // API of field "bIsRouteGuidanceVisibleInApp"

    static const int kBIsRouteGuidanceVisibleInApp = 16;

    /**
     * Clears the field "bIsRouteGuidanceVisibleInApp".
     *
     * The field will be set to its default value. The hasBIsRouteGuidanceVisibleInApp()
     * method will return false.
     */
    inline void clearBIsRouteGuidanceVisibleInApp();

    /**
     * Checks whether the field "bIsRouteGuidanceVisibleInApp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsRouteGuidanceVisibleInApp()). Otherwise it will return false.
     */
    inline bool hasBIsRouteGuidanceVisibleInApp () const;

    /**
     * Returns the value of the member "bIsRouteGuidanceVisibleInApp".
     *
     * Whether Route guidance is visible in the navigation app.
     *
     * @return The value of the field "bIsRouteGuidanceVisibleInApp"
     */
    inline bool getBIsRouteGuidanceVisibleInApp () const;

    /**
     * Sets the value of the member "bIsRouteGuidanceVisibleInApp".
     *
     * Whether Route guidance is visible in the navigation app.
     *
     * @param bIsRouteGuidanceVisibleInApp The value which will be set
     */
    inline void setBIsRouteGuidanceVisibleInApp (bool bIsRouteGuidanceVisibleInApp_);

    // API of field "SourceName"

    static const int kSourceName = 17;

    /**
     * Clears the field "SourceName".
     *
     * The field will be set to its default value. The hasSourceName()
     * method will return false.
     */
    inline void clearSourceName();

    /**
     * Checks whether the field "SourceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceName()). Otherwise it will return false.
     */
    inline bool hasSourceName () const;

    /**
     * Returns the value of the member "SourceName".
     *
     * Name of application providing turn-by-turn information
     * in Carplay, for display purposes only. Do not use for basing
     * any behaviour change decisions.
     *
     * @return The value of the field "SourceName"
     */
    inline const ::std::string& getSourceName () const;

    /**
     * Retrieves the value of the field "SourceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SourceName".
     */
    inline ::std::string& getSourceNameMutable ();

    /**
     * Sets the value of the member "SourceName".
     *
     * Name of application providing turn-by-turn information
     * in Carplay, for display purposes only. Do not use for basing
     * any behaviour change decisions.
     *
     * @param SourceName The value which will be set
     */
    inline void setSourceName (const ::std::string& SourceName_);

    /**
     * Sets the value of the member "SourceName".
     *
     * Name of application providing turn-by-turn information
     * in Carplay, for display purposes only. Do not use for basing
     * any behaviour change decisions.
     *
     * @param SourceName The value which will be set
     */
    inline void setSourceName (const char* SourceName_);

    /**
     * Sets the value of the member "SourceName".
     *
     * Name of application providing turn-by-turn information
     * in Carplay, for display purposes only. Do not use for basing
     * any behaviour change decisions.
     *
     * @param SourceName The value which will be set
     */
    inline void setSourceName (const char* value, size_t size);

    // API of field "SourceSupportsRouteGuidance"

    static const int kSourceSupportsRouteGuidance = 18;

    /**
     * Clears the field "SourceSupportsRouteGuidance".
     *
     * The field will be set to its default value. The hasSourceSupportsRouteGuidance()
     * method will return false.
     */
    inline void clearSourceSupportsRouteGuidance();

    /**
     * Checks whether the field "SourceSupportsRouteGuidance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceSupportsRouteGuidance()). Otherwise it will return false.
     */
    inline bool hasSourceSupportsRouteGuidance () const;

    /**
     * Returns the value of the member "SourceSupportsRouteGuidance".
     *
     * Whether application providing turn-by-turn information
     * iin Carplay can populate RouteGuidanceManeuverInformation or
     * parameters 0-15 in RouteGuidance.
     *
     * @return The value of the field "SourceSupportsRouteGuidance"
     */
    inline bool getSourceSupportsRouteGuidance () const;

    /**
     * Sets the value of the member "SourceSupportsRouteGuidance".
     *
     * Whether application providing turn-by-turn information
     * iin Carplay can populate RouteGuidanceManeuverInformation or
     * parameters 0-15 in RouteGuidance.
     *
     * @param SourceSupportsRouteGuidance The value which will be set
     */
    inline void setSourceSupportsRouteGuidance (bool SourceSupportsRouteGuidance_);

    static const DiPORouteGuidanceStatus &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_sDeviceUSBSerialNumber ();

    inline void clear_has_sDeviceUSBSerialNumber ();

    inline void set_has_u16RouteGuidanceDisplayComponentID ();

    inline void clear_has_u16RouteGuidanceDisplayComponentID ();

    inline void set_has_e8RouteGuidanceState ();

    inline void clear_has_e8RouteGuidanceState ();

    inline void set_has_e8ManeuverState ();

    inline void clear_has_e8ManeuverState ();

    inline void set_has_szCurrentRoadName ();

    inline void clear_has_szCurrentRoadName ();

    inline void set_has_szDestinationName ();

    inline void clear_has_szDestinationName ();

    inline void set_has_u64EstimatedTimeOfArrival ();

    inline void clear_has_u64EstimatedTimeOfArrival ();

    inline void set_has_u64TimeRemainingToDestination ();

    inline void clear_has_u64TimeRemainingToDestination ();

    inline void set_has_u32DistanceRemaining ();

    inline void clear_has_u32DistanceRemaining ();

    inline void set_has_szDistanceRemainingDisplayStr ();

    inline void clear_has_szDistanceRemainingDisplayStr ();

    inline void set_has_e8DistanceRemainingDisplayUnits ();

    inline void clear_has_e8DistanceRemainingDisplayUnits ();

    inline void set_has_u32DistanceToNextManeuver ();

    inline void clear_has_u32DistanceToNextManeuver ();

    inline void set_has_szDistanceToNextManeuverDisplayStr ();

    inline void clear_has_szDistanceToNextManeuverDisplayStr ();

    inline void set_has_e8DistanceToNextManeuverDisplayUnits ();

    inline void clear_has_e8DistanceToNextManeuverDisplayUnits ();

    inline void set_has_u16RouteGuidanceManeuverCurrentList ();

    inline void clear_has_u16RouteGuidanceManeuverCurrentList ();

    inline void set_has_u16RouteGuidanceManeuverCount ();

    inline void clear_has_u16RouteGuidanceManeuverCount ();

    inline void set_has_bIsRouteGuidanceVisibleInApp ();

    inline void clear_has_bIsRouteGuidanceVisibleInApp ();

    inline void set_has_SourceName ();

    inline void clear_has_SourceName ();

    inline void set_has_SourceSupportsRouteGuidance ();

    inline void clear_has_SourceSupportsRouteGuidance ();

    uint32 _has_bits_[ (19 + 31) / 32];

    ::std::string _sDeviceUSBSerialNumber;

    uint16 _u16RouteGuidanceDisplayComponentID;

    ::mplay_appcontrol_fi_types::T_e8_RouteGuidanceState _e8RouteGuidanceState;

    ::mplay_appcontrol_fi_types::T_e8_ManeuverState _e8ManeuverState;

    ::std::string _szCurrentRoadName;

    ::std::string _szDestinationName;

    uint64 _u64EstimatedTimeOfArrival;

    uint64 _u64TimeRemainingToDestination;

    uint32 _u32DistanceRemaining;

    ::std::string _szDistanceRemainingDisplayStr;

    ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits _e8DistanceRemainingDisplayUnits;

    uint32 _u32DistanceToNextManeuver;

    ::std::string _szDistanceToNextManeuverDisplayStr;

    ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits _e8DistanceToNextManeuverDisplayUnits;

    ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverCurrentList _u16RouteGuidanceManeuverCurrentList;

    uint16 _u16RouteGuidanceManeuverCount;

    bool _bIsRouteGuidanceVisibleInApp;

    ::std::string _SourceName;

    bool _SourceSupportsRouteGuidance;

};

/**
 * The status message of the property "DiPORouteGuidanceManeuver"
 * Property contains RouteGuidanceManeuver Update.
 */
class DiPORouteGuidanceManeuverStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPORouteGuidanceManeuverStatus ();

    /**
     * Copy constructor
     */
    inline  DiPORouteGuidanceManeuverStatus (const DiPORouteGuidanceManeuverStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiPORouteGuidanceManeuverStatus (const ::std::string& sDeviceUSBSerialNumber_, uint16 u16RouteGuidanceDisplayComponentID_, uint16 u16Index_, const ::std::string& szManeuverDescription_, ::mplay_appcontrol_fi_types::T_e8_ManeuverType e8ManeuverType_, const ::std::string& szAfterManeuverRoadName_, uint32 u32DistanceBetweenManeuver_, const ::std::string& szDistanceBetweenManeuverDisplayStr_, ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits e8DistanceBetweenManeuverDisplayUnits_, ::mplay_appcontrol_fi_types::T_e8_DrivingSide e8DrivingSide_, ::mplay_appcontrol_fi_types::T_e8_JunctionType e8JunctionType_, int16 s16JunctionElementAngle_, int16 s16JunctionElementExitAngle_);

    /**
     * Destructor
     */
    inline virtual  ~DiPORouteGuidanceManeuverStatus();

    /**
     * Assignment operator
     */
    inline DiPORouteGuidanceManeuverStatus& operator = (const DiPORouteGuidanceManeuverStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPORouteGuidanceManeuverStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPORouteGuidanceManeuverStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPORouteGuidanceManeuverStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPORouteGuidanceManeuverStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sDeviceUSBSerialNumber"

    static const int kSDeviceUSBSerialNumber = 0;

    /**
     * Clears the field "sDeviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasSDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearSDeviceUSBSerialNumber();

    /**
     * Checks whether the field "sDeviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasSDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @return The value of the field "sDeviceUSBSerialNumber"
     */
    inline const ::std::string& getSDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "sDeviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceUSBSerialNumber".
     */
    inline ::std::string& getSDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* value, size_t size);

    // API of field "u16RouteGuidanceDisplayComponentID"

    static const int kU16RouteGuidanceDisplayComponentID = 1;

    /**
     * Clears the field "u16RouteGuidanceDisplayComponentID".
     *
     * The field will be set to its default value. The hasU16RouteGuidanceDisplayComponentID()
     * method will return false.
     */
    inline void clearU16RouteGuidanceDisplayComponentID();

    /**
     * Checks whether the field "u16RouteGuidanceDisplayComponentID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RouteGuidanceDisplayComponentID()). Otherwise it will return false.
     */
    inline bool hasU16RouteGuidanceDisplayComponentID () const;

    /**
     * Returns the value of the member "u16RouteGuidanceDisplayComponentID".
     *
     * If none specified, it means the update applies to all components. If more than one are specified, update is applied to all specified components.
     *
     * @return The value of the field "u16RouteGuidanceDisplayComponentID"
     */
    inline uint16 getU16RouteGuidanceDisplayComponentID () const;

    /**
     * Sets the value of the member "u16RouteGuidanceDisplayComponentID".
     *
     * If none specified, it means the update applies to all components. If more than one are specified, update is applied to all specified components.
     *
     * @param u16RouteGuidanceDisplayComponentID The value which will be set
     */
    inline void setU16RouteGuidanceDisplayComponentID (uint16 u16RouteGuidanceDisplayComponentID_);

    // API of field "u16Index"

    static const int kU16Index = 2;

    /**
     * Clears the field "u16Index".
     *
     * The field will be set to its default value. The hasU16Index()
     * method will return false.
     */
    inline void clearU16Index();

    /**
     * Checks whether the field "u16Index" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Index()). Otherwise it will return false.
     */
    inline bool hasU16Index () const;

    /**
     * Returns the value of the member "u16Index".
     *
     * Specifies which item in the list is being updated.
     *
     * @return The value of the field "u16Index"
     */
    inline uint16 getU16Index () const;

    /**
     * Sets the value of the member "u16Index".
     *
     * Specifies which item in the list is being updated.
     *
     * @param u16Index The value which will be set
     */
    inline void setU16Index (uint16 u16Index_);

    // API of field "szManeuverDescription"

    static const int kSzManeuverDescription = 3;

    /**
     * Clears the field "szManeuverDescription".
     *
     * The field will be set to its default value. The hasSzManeuverDescription()
     * method will return false.
     */
    inline void clearSzManeuverDescription();

    /**
     * Checks whether the field "szManeuverDescription" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzManeuverDescription()). Otherwise it will return false.
     */
    inline bool hasSzManeuverDescription () const;

    /**
     * Returns the value of the member "szManeuverDescription".
     *
     * ManeuverDescription
     *
     * @return The value of the field "szManeuverDescription"
     */
    inline const ::std::string& getSzManeuverDescription () const;

    /**
     * Retrieves the value of the field "szManeuverDescription" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szManeuverDescription".
     */
    inline ::std::string& getSzManeuverDescriptionMutable ();

    /**
     * Sets the value of the member "szManeuverDescription".
     *
     * ManeuverDescription
     *
     * @param szManeuverDescription The value which will be set
     */
    inline void setSzManeuverDescription (const ::std::string& szManeuverDescription_);

    /**
     * Sets the value of the member "szManeuverDescription".
     *
     * ManeuverDescription
     *
     * @param szManeuverDescription The value which will be set
     */
    inline void setSzManeuverDescription (const char* szManeuverDescription_);

    /**
     * Sets the value of the member "szManeuverDescription".
     *
     * ManeuverDescription
     *
     * @param szManeuverDescription The value which will be set
     */
    inline void setSzManeuverDescription (const char* value, size_t size);

    // API of field "e8ManeuverType"

    static const int kE8ManeuverType = 4;

    /**
     * Clears the field "e8ManeuverType".
     *
     * The field will be set to its default value. The hasE8ManeuverType()
     * method will return false.
     */
    inline void clearE8ManeuverType();

    /**
     * Checks whether the field "e8ManeuverType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ManeuverType()). Otherwise it will return false.
     */
    inline bool hasE8ManeuverType () const;

    /**
     * Returns the value of the member "e8ManeuverType".
     *
     * ManeuverType enum.
     *
     * @return The value of the field "e8ManeuverType"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_ManeuverType getE8ManeuverType () const;

    /**
     * Sets the value of the member "e8ManeuverType".
     *
     * ManeuverType enum.
     *
     * @param e8ManeuverType The value which will be set
     */
    inline void setE8ManeuverType (::mplay_appcontrol_fi_types::T_e8_ManeuverType e8ManeuverType_);

    // API of field "szAfterManeuverRoadName"

    static const int kSzAfterManeuverRoadName = 5;

    /**
     * Clears the field "szAfterManeuverRoadName".
     *
     * The field will be set to its default value. The hasSzAfterManeuverRoadName()
     * method will return false.
     */
    inline void clearSzAfterManeuverRoadName();

    /**
     * Checks whether the field "szAfterManeuverRoadName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzAfterManeuverRoadName()). Otherwise it will return false.
     */
    inline bool hasSzAfterManeuverRoadName () const;

    /**
     * Returns the value of the member "szAfterManeuverRoadName".
     *
     * The name of the road the vehicle will end up on after the maneuver is completed successfully.
     *
     * @return The value of the field "szAfterManeuverRoadName"
     */
    inline const ::std::string& getSzAfterManeuverRoadName () const;

    /**
     * Retrieves the value of the field "szAfterManeuverRoadName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szAfterManeuverRoadName".
     */
    inline ::std::string& getSzAfterManeuverRoadNameMutable ();

    /**
     * Sets the value of the member "szAfterManeuverRoadName".
     *
     * The name of the road the vehicle will end up on after the maneuver is completed successfully.
     *
     * @param szAfterManeuverRoadName The value which will be set
     */
    inline void setSzAfterManeuverRoadName (const ::std::string& szAfterManeuverRoadName_);

    /**
     * Sets the value of the member "szAfterManeuverRoadName".
     *
     * The name of the road the vehicle will end up on after the maneuver is completed successfully.
     *
     * @param szAfterManeuverRoadName The value which will be set
     */
    inline void setSzAfterManeuverRoadName (const char* szAfterManeuverRoadName_);

    /**
     * Sets the value of the member "szAfterManeuverRoadName".
     *
     * The name of the road the vehicle will end up on after the maneuver is completed successfully.
     *
     * @param szAfterManeuverRoadName The value which will be set
     */
    inline void setSzAfterManeuverRoadName (const char* value, size_t size);

    // API of field "u32DistanceBetweenManeuver"

    static const int kU32DistanceBetweenManeuver = 6;

    /**
     * Clears the field "u32DistanceBetweenManeuver".
     *
     * The field will be set to its default value. The hasU32DistanceBetweenManeuver()
     * method will return false.
     */
    inline void clearU32DistanceBetweenManeuver();

    /**
     * Checks whether the field "u32DistanceBetweenManeuver" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DistanceBetweenManeuver()). Otherwise it will return false.
     */
    inline bool hasU32DistanceBetweenManeuver () const;

    /**
     * Returns the value of the member "u32DistanceBetweenManeuver".
     *
     * Meters between previous maneuver to this maneuver.This value must not be displayed to the user in text. It is only to be used for generating graphics, e.g. countdown bars.
     *
     * @return The value of the field "u32DistanceBetweenManeuver"
     */
    inline uint32 getU32DistanceBetweenManeuver () const;

    /**
     * Sets the value of the member "u32DistanceBetweenManeuver".
     *
     * Meters between previous maneuver to this maneuver.This value must not be displayed to the user in text. It is only to be used for generating graphics, e.g. countdown bars.
     *
     * @param u32DistanceBetweenManeuver The value which will be set
     */
    inline void setU32DistanceBetweenManeuver (uint32 u32DistanceBetweenManeuver_);

    // API of field "szDistanceBetweenManeuverDisplayStr"

    static const int kSzDistanceBetweenManeuverDisplayStr = 7;

    /**
     * Clears the field "szDistanceBetweenManeuverDisplayStr".
     *
     * The field will be set to its default value. The hasSzDistanceBetweenManeuverDisplayStr()
     * method will return false.
     */
    inline void clearSzDistanceBetweenManeuverDisplayStr();

    /**
     * Checks whether the field "szDistanceBetweenManeuverDisplayStr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDistanceBetweenManeuverDisplayStr()). Otherwise it will return false.
     */
    inline bool hasSzDistanceBetweenManeuverDisplayStr () const;

    /**
     * Returns the value of the member "szDistanceBetweenManeuverDisplayStr".
     *
     * Display string representation of DistanceBetweenManeuver in DistanceBetweenManeuver-DisplayUnits units. Does not contain the units string.
     * Must be displayed without unit conversion to the user.
     *
     * @return The value of the field "szDistanceBetweenManeuverDisplayStr"
     */
    inline const ::std::string& getSzDistanceBetweenManeuverDisplayStr () const;

    /**
     * Retrieves the value of the field "szDistanceBetweenManeuverDisplayStr" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDistanceBetweenManeuverDisplayStr".
     */
    inline ::std::string& getSzDistanceBetweenManeuverDisplayStrMutable ();

    /**
     * Sets the value of the member "szDistanceBetweenManeuverDisplayStr".
     *
     * Display string representation of DistanceBetweenManeuver in DistanceBetweenManeuver-DisplayUnits units. Does not contain the units string.
     * Must be displayed without unit conversion to the user.
     *
     * @param szDistanceBetweenManeuverDisplayStr The value which will be set
     */
    inline void setSzDistanceBetweenManeuverDisplayStr (const ::std::string& szDistanceBetweenManeuverDisplayStr_);

    /**
     * Sets the value of the member "szDistanceBetweenManeuverDisplayStr".
     *
     * Display string representation of DistanceBetweenManeuver in DistanceBetweenManeuver-DisplayUnits units. Does not contain the units string.
     * Must be displayed without unit conversion to the user.
     *
     * @param szDistanceBetweenManeuverDisplayStr The value which will be set
     */
    inline void setSzDistanceBetweenManeuverDisplayStr (const char* szDistanceBetweenManeuverDisplayStr_);

    /**
     * Sets the value of the member "szDistanceBetweenManeuverDisplayStr".
     *
     * Display string representation of DistanceBetweenManeuver in DistanceBetweenManeuver-DisplayUnits units. Does not contain the units string.
     * Must be displayed without unit conversion to the user.
     *
     * @param szDistanceBetweenManeuverDisplayStr The value which will be set
     */
    inline void setSzDistanceBetweenManeuverDisplayStr (const char* value, size_t size);

    // API of field "e8DistanceBetweenManeuverDisplayUnits"

    static const int kE8DistanceBetweenManeuverDisplayUnits = 8;

    /**
     * Clears the field "e8DistanceBetweenManeuverDisplayUnits".
     *
     * The field will be set to its default value. The hasE8DistanceBetweenManeuverDisplayUnits()
     * method will return false.
     */
    inline void clearE8DistanceBetweenManeuverDisplayUnits();

    /**
     * Checks whether the field "e8DistanceBetweenManeuverDisplayUnits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DistanceBetweenManeuverDisplayUnits()). Otherwise it will return false.
     */
    inline bool hasE8DistanceBetweenManeuverDisplayUnits () const;

    /**
     * Returns the value of the member "e8DistanceBetweenManeuverDisplayUnits".
     *
     * Units that must accompany DistanceBetweenManeuver-DisplayStr when displayed to the user.
     *
     * @return The value of the field "e8DistanceBetweenManeuverDisplayUnits"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits getE8DistanceBetweenManeuverDisplayUnits () const;

    /**
     * Sets the value of the member "e8DistanceBetweenManeuverDisplayUnits".
     *
     * Units that must accompany DistanceBetweenManeuver-DisplayStr when displayed to the user.
     *
     * @param e8DistanceBetweenManeuverDisplayUnits The value which will be set
     */
    inline void setE8DistanceBetweenManeuverDisplayUnits (::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits e8DistanceBetweenManeuverDisplayUnits_);

    // API of field "e8DrivingSide"

    static const int kE8DrivingSide = 9;

    /**
     * Clears the field "e8DrivingSide".
     *
     * The field will be set to its default value. The hasE8DrivingSide()
     * method will return false.
     */
    inline void clearE8DrivingSide();

    /**
     * Checks whether the field "e8DrivingSide" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DrivingSide()). Otherwise it will return false.
     */
    inline bool hasE8DrivingSide () const;

    /**
     * Returns the value of the member "e8DrivingSide".
     *
     * Whether cars should drive on right or left side of the road.For roundabout, specifies the direction of traffic around the roundabout.
     *
     * @return The value of the field "e8DrivingSide"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_DrivingSide getE8DrivingSide () const;

    /**
     * Sets the value of the member "e8DrivingSide".
     *
     * Whether cars should drive on right or left side of the road.For roundabout, specifies the direction of traffic around the roundabout.
     *
     * @param e8DrivingSide The value which will be set
     */
    inline void setE8DrivingSide (::mplay_appcontrol_fi_types::T_e8_DrivingSide e8DrivingSide_);

    // API of field "e8JunctionType"

    static const int kE8JunctionType = 10;

    /**
     * Clears the field "e8JunctionType".
     *
     * The field will be set to its default value. The hasE8JunctionType()
     * method will return false.
     */
    inline void clearE8JunctionType();

    /**
     * Checks whether the field "e8JunctionType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8JunctionType()). Otherwise it will return false.
     */
    inline bool hasE8JunctionType () const;

    /**
     * Returns the value of the member "e8JunctionType".
     *
     * JunctionType enum.
     *
     * @return The value of the field "e8JunctionType"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_JunctionType getE8JunctionType () const;

    /**
     * Sets the value of the member "e8JunctionType".
     *
     * JunctionType enum.
     *
     * @param e8JunctionType The value which will be set
     */
    inline void setE8JunctionType (::mplay_appcontrol_fi_types::T_e8_JunctionType e8JunctionType_);

    // API of field "s16JunctionElementAngle"

    static const int kS16JunctionElementAngle = 11;

    /**
     * Clears the field "s16JunctionElementAngle".
     *
     * The field will be set to its default value. The hasS16JunctionElementAngle()
     * method will return false.
     */
    inline void clearS16JunctionElementAngle();

    /**
     * Checks whether the field "s16JunctionElementAngle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16JunctionElementAngle()). Otherwise it will return false.
     */
    inline bool hasS16JunctionElementAngle () const;

    /**
     * Returns the value of the member "s16JunctionElementAngle".
     *
     * Angle of a junction element (+/- 180). Accessory must show all junction elements together. An entry junction element is implied at angle 180.
     *
     * @return The value of the field "s16JunctionElementAngle"
     */
    inline int16 getS16JunctionElementAngle () const;

    /**
     * Sets the value of the member "s16JunctionElementAngle".
     *
     * Angle of a junction element (+/- 180). Accessory must show all junction elements together. An entry junction element is implied at angle 180.
     *
     * @param s16JunctionElementAngle The value which will be set
     */
    inline void setS16JunctionElementAngle (int16 s16JunctionElementAngle_);

    // API of field "s16JunctionElementExitAngle"

    static const int kS16JunctionElementExitAngle = 12;

    /**
     * Clears the field "s16JunctionElementExitAngle".
     *
     * The field will be set to its default value. The hasS16JunctionElementExitAngle()
     * method will return false.
     */
    inline void clearS16JunctionElementExitAngle();

    /**
     * Checks whether the field "s16JunctionElementExitAngle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16JunctionElementExitAngle()). Otherwise it will return false.
     */
    inline bool hasS16JunctionElementExitAngle () const;

    /**
     * Returns the value of the member "s16JunctionElementExitAngle".
     *
     * Angle of an exit junction element (+/- 180). Junction element describing the road used to exit the junction, or exit of the manuever. Accessory must show all
     * junction elements together.An entry junction element is implied at angle 180.
     *
     * @return The value of the field "s16JunctionElementExitAngle"
     */
    inline int16 getS16JunctionElementExitAngle () const;

    /**
     * Sets the value of the member "s16JunctionElementExitAngle".
     *
     * Angle of an exit junction element (+/- 180). Junction element describing the road used to exit the junction, or exit of the manuever. Accessory must show all
     * junction elements together.An entry junction element is implied at angle 180.
     *
     * @param s16JunctionElementExitAngle The value which will be set
     */
    inline void setS16JunctionElementExitAngle (int16 s16JunctionElementExitAngle_);

    static const DiPORouteGuidanceManeuverStatus &getDefaultInstance();

private:

    inline void set_has_sDeviceUSBSerialNumber ();

    inline void clear_has_sDeviceUSBSerialNumber ();

    inline void set_has_u16RouteGuidanceDisplayComponentID ();

    inline void clear_has_u16RouteGuidanceDisplayComponentID ();

    inline void set_has_u16Index ();

    inline void clear_has_u16Index ();

    inline void set_has_szManeuverDescription ();

    inline void clear_has_szManeuverDescription ();

    inline void set_has_e8ManeuverType ();

    inline void clear_has_e8ManeuverType ();

    inline void set_has_szAfterManeuverRoadName ();

    inline void clear_has_szAfterManeuverRoadName ();

    inline void set_has_u32DistanceBetweenManeuver ();

    inline void clear_has_u32DistanceBetweenManeuver ();

    inline void set_has_szDistanceBetweenManeuverDisplayStr ();

    inline void clear_has_szDistanceBetweenManeuverDisplayStr ();

    inline void set_has_e8DistanceBetweenManeuverDisplayUnits ();

    inline void clear_has_e8DistanceBetweenManeuverDisplayUnits ();

    inline void set_has_e8DrivingSide ();

    inline void clear_has_e8DrivingSide ();

    inline void set_has_e8JunctionType ();

    inline void clear_has_e8JunctionType ();

    inline void set_has_s16JunctionElementAngle ();

    inline void clear_has_s16JunctionElementAngle ();

    inline void set_has_s16JunctionElementExitAngle ();

    inline void clear_has_s16JunctionElementExitAngle ();

    uint32 _has_bits_[ (13 + 31) / 32];

    ::std::string _sDeviceUSBSerialNumber;

    uint16 _u16RouteGuidanceDisplayComponentID;

    uint16 _u16Index;

    ::std::string _szManeuverDescription;

    ::mplay_appcontrol_fi_types::T_e8_ManeuverType _e8ManeuverType;

    ::std::string _szAfterManeuverRoadName;

    uint32 _u32DistanceBetweenManeuver;

    ::std::string _szDistanceBetweenManeuverDisplayStr;

    ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits _e8DistanceBetweenManeuverDisplayUnits;

    ::mplay_appcontrol_fi_types::T_e8_DrivingSide _e8DrivingSide;

    ::mplay_appcontrol_fi_types::T_e8_JunctionType _e8JunctionType;

    int16 _s16JunctionElementAngle;

    int16 _s16JunctionElementExitAngle;

};

/**
 * The status message of the property "DiPOGPRMCDataStatusValues"
 * MediaPlayer notifies the client on the GPRMC data status values received form device(A,V,X).
 */
class DiPOGPRMCDataStatusValuesStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOGPRMCDataStatusValuesStatus ();

    /**
     * Copy constructor
     */
    inline  DiPOGPRMCDataStatusValuesStatus (const DiPOGPRMCDataStatusValuesStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOGPRMCDataStatusValuesStatus (uint8 u8DeviceId_, const ::std::string& sDeviceUSBSerialNumber_, const ::mplay_appcontrol_fi_types::T_b8_DiPOGPRMCDataStatusValues& b8GPRMCDataStatusValues_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOGPRMCDataStatusValuesStatus();

    /**
     * Assignment operator
     */
    inline DiPOGPRMCDataStatusValuesStatus& operator = (const DiPOGPRMCDataStatusValuesStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOGPRMCDataStatusValuesStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOGPRMCDataStatusValuesStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOGPRMCDataStatusValuesStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOGPRMCDataStatusValuesStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceId"

    static const int kU8DeviceId = 0;

    /**
     * Clears the field "u8DeviceId".
     *
     * The field will be set to its default value. The hasU8DeviceId()
     * method will return false.
     */
    inline void clearU8DeviceId();

    /**
     * Checks whether the field "u8DeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceId()). Otherwise it will return false.
     */
    inline bool hasU8DeviceId () const;

    /**
     * Returns the value of the member "u8DeviceId".
     *
     * DeviceID of the connected iPhone.
     *
     * @return The value of the field "u8DeviceId"
     */
    inline uint8 getU8DeviceId () const;

    /**
     * Sets the value of the member "u8DeviceId".
     *
     * DeviceID of the connected iPhone.
     *
     * @param u8DeviceId The value which will be set
     */
    inline void setU8DeviceId (uint8 u8DeviceId_);

    // API of field "sDeviceUSBSerialNumber"

    static const int kSDeviceUSBSerialNumber = 1;

    /**
     * Clears the field "sDeviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasSDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearSDeviceUSBSerialNumber();

    /**
     * Checks whether the field "sDeviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasSDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial number of Apple device.
     *
     * @return The value of the field "sDeviceUSBSerialNumber"
     */
    inline const ::std::string& getSDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "sDeviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceUSBSerialNumber".
     */
    inline ::std::string& getSDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* value, size_t size);

    // API of field "b8GPRMCDataStatusValues"

    static const int kB8GPRMCDataStatusValues = 2;

    /**
     * Clears the field "b8GPRMCDataStatusValues".
     *
     * The field will be set to its default value. The hasB8GPRMCDataStatusValues()
     * method will return false.
     */
    inline void clearB8GPRMCDataStatusValues();

    /**
     * Checks whether the field "b8GPRMCDataStatusValues" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB8GPRMCDataStatusValues()). Otherwise it will return false.
     */
    inline bool hasB8GPRMCDataStatusValues () const;

    /**
     * Returns the value of the member "b8GPRMCDataStatusValues".
     *
     * Notifies the GPRMC Data status values(A,V,X) to be sent.
     *
     * @return The value of the field "b8GPRMCDataStatusValues"
     */
    inline const ::mplay_appcontrol_fi_types::T_b8_DiPOGPRMCDataStatusValues& getB8GPRMCDataStatusValues () const;

    /**
     * Retrieves the value of the field "b8GPRMCDataStatusValues" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b8GPRMCDataStatusValues".
     */
    inline ::mplay_appcontrol_fi_types::T_b8_DiPOGPRMCDataStatusValues& getB8GPRMCDataStatusValuesMutable ();

    /**
     * Sets the value of the member "b8GPRMCDataStatusValues".
     *
     * Notifies the GPRMC Data status values(A,V,X) to be sent.
     *
     * @param b8GPRMCDataStatusValues The value which will be set
     */
    inline void setB8GPRMCDataStatusValues (const ::mplay_appcontrol_fi_types::T_b8_DiPOGPRMCDataStatusValues& b8GPRMCDataStatusValues_);

    static const DiPOGPRMCDataStatusValuesStatus &getDefaultInstance();

private:

    inline void set_has_u8DeviceId ();

    inline void clear_has_u8DeviceId ();

    inline void set_has_sDeviceUSBSerialNumber ();

    inline void clear_has_sDeviceUSBSerialNumber ();

    inline void set_has_b8GPRMCDataStatusValues ();

    inline void clear_has_b8GPRMCDataStatusValues ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8DeviceId;

    ::std::string _sDeviceUSBSerialNumber;

    ::mplay_appcontrol_fi_types::T_b8_DiPOGPRMCDataStatusValues _b8GPRMCDataStatusValues;

};

/**
 * The status message of the property "DiPORouteGuidance2"
 * Property contains RouteGuidance Update.
 */
class DiPORouteGuidance2Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPORouteGuidance2Status ();

    /**
     * Copy constructor
     */
    inline  DiPORouteGuidance2Status (const DiPORouteGuidance2Status &rhs);

    /**
     * All fields constructor
     */
    inline  DiPORouteGuidance2Status (const ::std::string& sDeviceUSBSerialNumber_, const ::mplay_appcontrol_fi_types::T_RouteGuidanceUpdate& RouteGuidanceUpdate_);

    /**
     * Destructor
     */
    inline virtual  ~DiPORouteGuidance2Status();

    /**
     * Assignment operator
     */
    inline DiPORouteGuidance2Status& operator = (const DiPORouteGuidance2Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPORouteGuidance2Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPORouteGuidance2Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPORouteGuidance2Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPORouteGuidance2Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sDeviceUSBSerialNumber"

    static const int kSDeviceUSBSerialNumber = 0;

    /**
     * Clears the field "sDeviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasSDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearSDeviceUSBSerialNumber();

    /**
     * Checks whether the field "sDeviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasSDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @return The value of the field "sDeviceUSBSerialNumber"
     */
    inline const ::std::string& getSDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "sDeviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceUSBSerialNumber".
     */
    inline ::std::string& getSDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* value, size_t size);

    // API of field "RouteGuidanceUpdate"

    static const int kRouteGuidanceUpdate = 1;

    /**
     * Clears the field "RouteGuidanceUpdate".
     *
     * The field will be set to its default value. The hasRouteGuidanceUpdate()
     * method will return false.
     */
    inline void clearRouteGuidanceUpdate();

    /**
     * Checks whether the field "RouteGuidanceUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteGuidanceUpdate()). Otherwise it will return false.
     */
    inline bool hasRouteGuidanceUpdate () const;

    /**
     * Returns the value of the member "RouteGuidanceUpdate".
     *
     * RouteguidanceUpdate message from Apple device.
     *
     * Note: This is an update so information can be sent all together or individually and the accessory should keep a
     * cache of the information and update as the information arrives.
     *
     * @return The value of the field "RouteGuidanceUpdate"
     */
    inline const ::mplay_appcontrol_fi_types::T_RouteGuidanceUpdate& getRouteGuidanceUpdate () const;

    /**
     * Retrieves the value of the field "RouteGuidanceUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RouteGuidanceUpdate".
     */
    inline ::mplay_appcontrol_fi_types::T_RouteGuidanceUpdate& getRouteGuidanceUpdateMutable ();

    /**
     * Sets the value of the member "RouteGuidanceUpdate".
     *
     * RouteguidanceUpdate message from Apple device.
     *
     * Note: This is an update so information can be sent all together or individually and the accessory should keep a
     * cache of the information and update as the information arrives.
     *
     * @param RouteGuidanceUpdate The value which will be set
     */
    inline void setRouteGuidanceUpdate (const ::mplay_appcontrol_fi_types::T_RouteGuidanceUpdate& RouteGuidanceUpdate_);

    static const DiPORouteGuidance2Status &getDefaultInstance();

private:

    inline void set_has_sDeviceUSBSerialNumber ();

    inline void clear_has_sDeviceUSBSerialNumber ();

    inline void set_has_RouteGuidanceUpdate ();

    inline void clear_has_RouteGuidanceUpdate ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _sDeviceUSBSerialNumber;

    ::mplay_appcontrol_fi_types::T_RouteGuidanceUpdate _RouteGuidanceUpdate;

};

/**
 * The status message of the property "DiPORouteGuidanceManeuver2"
 * Property contains RouteGuidanceManeuver Update.
 */
class DiPORouteGuidanceManeuver2Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPORouteGuidanceManeuver2Status ();

    /**
     * Copy constructor
     */
    inline  DiPORouteGuidanceManeuver2Status (const DiPORouteGuidanceManeuver2Status &rhs);

    /**
     * All fields constructor
     */
    inline  DiPORouteGuidanceManeuver2Status (const ::std::string& sDeviceUSBSerialNumber_, const ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverUpdate& RouteGuidanceManeuverUpdate_);

    /**
     * Destructor
     */
    inline virtual  ~DiPORouteGuidanceManeuver2Status();

    /**
     * Assignment operator
     */
    inline DiPORouteGuidanceManeuver2Status& operator = (const DiPORouteGuidanceManeuver2Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPORouteGuidanceManeuver2Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPORouteGuidanceManeuver2Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPORouteGuidanceManeuver2Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPORouteGuidanceManeuver2Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sDeviceUSBSerialNumber"

    static const int kSDeviceUSBSerialNumber = 0;

    /**
     * Clears the field "sDeviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasSDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearSDeviceUSBSerialNumber();

    /**
     * Checks whether the field "sDeviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasSDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @return The value of the field "sDeviceUSBSerialNumber"
     */
    inline const ::std::string& getSDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "sDeviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceUSBSerialNumber".
     */
    inline ::std::string& getSDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* value, size_t size);

    // API of field "RouteGuidanceManeuverUpdate"

    static const int kRouteGuidanceManeuverUpdate = 1;

    /**
     * Clears the field "RouteGuidanceManeuverUpdate".
     *
     * The field will be set to its default value. The hasRouteGuidanceManeuverUpdate()
     * method will return false.
     */
    inline void clearRouteGuidanceManeuverUpdate();

    /**
     * Checks whether the field "RouteGuidanceManeuverUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteGuidanceManeuverUpdate()). Otherwise it will return false.
     */
    inline bool hasRouteGuidanceManeuverUpdate () const;

    /**
     * Returns the value of the member "RouteGuidanceManeuverUpdate".
     *
     * RouteGuidanceManeuverUpdate message from Apple device.
     * Note: If a RouteGuidanceManeuverInformation message is received with an index matching a maneuver already
     * stored on the accessory, the stored maneuver must be removed and replaced by the information in that
     * RouteGuidanceManeuverInformation message.
     * Note: Each message contains one RouteGuidance maneuver item in the RouteGuidance maneuver list. Index
     * specifies which item in the list is being updated. If the index specifies an entry outside of the
     * MaxGuidanceManeuverStorageCapacity, the oldest entry should be deleted and the new entry added. The set
     * of junction elements describe the junction where the maneuver needs to take place. The entry junction
     * element is implied at angle 180 and is not included as a JunctionElementAngle. Multiple junction elements for
     * a maneuver must be shown together. Junction elements may not be provided for a maneuver and should be used to
     * supplement the ManeuverType when present.
     *
     * @return The value of the field "RouteGuidanceManeuverUpdate"
     */
    inline const ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverUpdate& getRouteGuidanceManeuverUpdate () const;

    /**
     * Retrieves the value of the field "RouteGuidanceManeuverUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RouteGuidanceManeuverUpdate".
     */
    inline ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverUpdate& getRouteGuidanceManeuverUpdateMutable ();

    /**
     * Sets the value of the member "RouteGuidanceManeuverUpdate".
     *
     * RouteGuidanceManeuverUpdate message from Apple device.
     * Note: If a RouteGuidanceManeuverInformation message is received with an index matching a maneuver already
     * stored on the accessory, the stored maneuver must be removed and replaced by the information in that
     * RouteGuidanceManeuverInformation message.
     * Note: Each message contains one RouteGuidance maneuver item in the RouteGuidance maneuver list. Index
     * specifies which item in the list is being updated. If the index specifies an entry outside of the
     * MaxGuidanceManeuverStorageCapacity, the oldest entry should be deleted and the new entry added. The set
     * of junction elements describe the junction where the maneuver needs to take place. The entry junction
     * element is implied at angle 180 and is not included as a JunctionElementAngle. Multiple junction elements for
     * a maneuver must be shown together. Junction elements may not be provided for a maneuver and should be used to
     * supplement the ManeuverType when present.
     *
     * @param RouteGuidanceManeuverUpdate The value which will be set
     */
    inline void setRouteGuidanceManeuverUpdate (const ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverUpdate& RouteGuidanceManeuverUpdate_);

    static const DiPORouteGuidanceManeuver2Status &getDefaultInstance();

private:

    inline void set_has_sDeviceUSBSerialNumber ();

    inline void clear_has_sDeviceUSBSerialNumber ();

    inline void set_has_RouteGuidanceManeuverUpdate ();

    inline void clear_has_RouteGuidanceManeuverUpdate ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _sDeviceUSBSerialNumber;

    ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverUpdate _RouteGuidanceManeuverUpdate;

};

/**
 * The status message of the property "DiPOBluetoothAudioDeviceStatus"
 * Update the busy or free status of Bluetooth Audio input device.
 * BT audio input device should not be read by multiple processes. Incase any process
 * wants to use Bluetooth Audio input device, process has to request the device
 * to Mediaplayer by method DiPORequestBluetoothAudioDevice if the device is free
 */
class DiPOBluetoothAudioDeviceStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOBluetoothAudioDeviceStatusStatus ();

    /**
     * Copy constructor
     */
    inline  DiPOBluetoothAudioDeviceStatusStatus (const DiPOBluetoothAudioDeviceStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOBluetoothAudioDeviceStatusStatus (bool bAudioDeviceStatus_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOBluetoothAudioDeviceStatusStatus();

    /**
     * Assignment operator
     */
    inline DiPOBluetoothAudioDeviceStatusStatus& operator = (const DiPOBluetoothAudioDeviceStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOBluetoothAudioDeviceStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOBluetoothAudioDeviceStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOBluetoothAudioDeviceStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOBluetoothAudioDeviceStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bAudioDeviceStatus"

    static const int kBAudioDeviceStatus = 0;

    /**
     * Clears the field "bAudioDeviceStatus".
     *
     * The field will be set to its default value. The hasBAudioDeviceStatus()
     * method will return false.
     */
    inline void clearBAudioDeviceStatus();

    /**
     * Checks whether the field "bAudioDeviceStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAudioDeviceStatus()). Otherwise it will return false.
     */
    inline bool hasBAudioDeviceStatus () const;

    /**
     * Returns the value of the member "bAudioDeviceStatus".
     *
     * 1 = busy, 0 = free
     *
     * @return The value of the field "bAudioDeviceStatus"
     */
    inline bool getBAudioDeviceStatus () const;

    /**
     * Sets the value of the member "bAudioDeviceStatus".
     *
     * 1 = busy, 0 = free
     *
     * @param bAudioDeviceStatus The value which will be set
     */
    inline void setBAudioDeviceStatus (bool bAudioDeviceStatus_);

    static const DiPOBluetoothAudioDeviceStatusStatus &getDefaultInstance();

private:

    inline void set_has_bAudioDeviceStatus ();

    inline void clear_has_bAudioDeviceStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bAudioDeviceStatus;

};

/**
 * The status message of the property "DiPODeviceTimeUpdate"
 * Property contains Device time update of apple device which is connected for CP or CPW.
 */
class DiPODeviceTimeUpdateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPODeviceTimeUpdateStatus ();

    /**
     * Copy constructor
     */
    inline  DiPODeviceTimeUpdateStatus (const DiPODeviceTimeUpdateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiPODeviceTimeUpdateStatus (const ::std::string& sDeviceUSBSerialNumber_, const ::mplay_appcontrol_fi_types::T_DeviceTimeUpdate& DeviceTimeUpdate_);

    /**
     * Destructor
     */
    inline virtual  ~DiPODeviceTimeUpdateStatus();

    /**
     * Assignment operator
     */
    inline DiPODeviceTimeUpdateStatus& operator = (const DiPODeviceTimeUpdateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPODeviceTimeUpdateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPODeviceTimeUpdateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPODeviceTimeUpdateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPODeviceTimeUpdateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sDeviceUSBSerialNumber"

    static const int kSDeviceUSBSerialNumber = 0;

    /**
     * Clears the field "sDeviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasSDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearSDeviceUSBSerialNumber();

    /**
     * Checks whether the field "sDeviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasSDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @return The value of the field "sDeviceUSBSerialNumber"
     */
    inline const ::std::string& getSDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "sDeviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceUSBSerialNumber".
     */
    inline ::std::string& getSDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* value, size_t size);

    // API of field "DeviceTimeUpdate"

    static const int kDeviceTimeUpdate = 1;

    /**
     * Clears the field "DeviceTimeUpdate".
     *
     * The field will be set to its default value. The hasDeviceTimeUpdate()
     * method will return false.
     */
    inline void clearDeviceTimeUpdate();

    /**
     * Checks whether the field "DeviceTimeUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceTimeUpdate()). Otherwise it will return false.
     */
    inline bool hasDeviceTimeUpdate () const;

    /**
     * Returns the value of the member "DeviceTimeUpdate".
     *
     * DeviceTimeUpdate message from Apple device.
     * Note: After receiving DeviceTimeUpdate, the accessory must maintain its own clock.
     * Subsequent notification will be sent when there is significant change,
     * e.g. a device time zone or daylight savings time change.
     *
     * @return The value of the field "DeviceTimeUpdate"
     */
    inline const ::mplay_appcontrol_fi_types::T_DeviceTimeUpdate& getDeviceTimeUpdate () const;

    /**
     * Retrieves the value of the field "DeviceTimeUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceTimeUpdate".
     */
    inline ::mplay_appcontrol_fi_types::T_DeviceTimeUpdate& getDeviceTimeUpdateMutable ();

    /**
     * Sets the value of the member "DeviceTimeUpdate".
     *
     * DeviceTimeUpdate message from Apple device.
     * Note: After receiving DeviceTimeUpdate, the accessory must maintain its own clock.
     * Subsequent notification will be sent when there is significant change,
     * e.g. a device time zone or daylight savings time change.
     *
     * @param DeviceTimeUpdate The value which will be set
     */
    inline void setDeviceTimeUpdate (const ::mplay_appcontrol_fi_types::T_DeviceTimeUpdate& DeviceTimeUpdate_);

    static const DiPODeviceTimeUpdateStatus &getDefaultInstance();

private:

    inline void set_has_sDeviceUSBSerialNumber ();

    inline void clear_has_sDeviceUSBSerialNumber ();

    inline void set_has_DeviceTimeUpdate ();

    inline void clear_has_DeviceTimeUpdate ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _sDeviceUSBSerialNumber;

    ::mplay_appcontrol_fi_types::T_DeviceTimeUpdate _DeviceTimeUpdate;

};

/**
 * The start message of the method "Connect"
 * The AppControl Connect method provides the interface for the Internet Radio to tell the
 * iPod device control to connect to the Pandora application using the MediaPlayer.
 */
class ConnectStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectStart ();

    /**
     * Copy constructor
     */
    inline  ConnectStart (const ConnectStart &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectStart (const ::std::string& szDeviceId_, const ::std::string& szProtocol_, const ::std::string& szBundleSeedID_, const ::std::string& szAppName_, ::mplay_appcontrol_fi_types::T_e8_AppLaunchOption e8AppLaunchOption_);

    /**
     * Destructor
     */
    inline virtual  ~ConnectStart();

    /**
     * Assignment operator
     */
    inline ConnectStart& operator = (const ConnectStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "szDeviceId"

    static const int kSzDeviceId = 0;

    /**
     * Clears the field "szDeviceId".
     *
     * The field will be set to its default value. The hasSzDeviceId()
     * method will return false.
     */
    inline void clearSzDeviceId();

    /**
     * Checks whether the field "szDeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDeviceId()). Otherwise it will return false.
     */
    inline bool hasSzDeviceId () const;

    /**
     * Returns the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name.
     *
     * @return The value of the field "szDeviceId"
     */
    inline const ::std::string& getSzDeviceId () const;

    /**
     * Retrieves the value of the field "szDeviceId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDeviceId".
     */
    inline ::std::string& getSzDeviceIdMutable ();

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name.
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const ::std::string& szDeviceId_);

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name.
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const char* szDeviceId_);

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name.
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const char* value, size_t size);

    // API of field "szProtocol"

    static const int kSzProtocol = 1;

    /**
     * Clears the field "szProtocol".
     *
     * The field will be set to its default value. The hasSzProtocol()
     * method will return false.
     */
    inline void clearSzProtocol();

    /**
     * Checks whether the field "szProtocol" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzProtocol()). Otherwise it will return false.
     */
    inline bool hasSzProtocol () const;

    /**
     * Returns the value of the member "szProtocol".
     *
     * A string containing protocl of the IAP application.
     *
     * @return The value of the field "szProtocol"
     */
    inline const ::std::string& getSzProtocol () const;

    /**
     * Retrieves the value of the field "szProtocol" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szProtocol".
     */
    inline ::std::string& getSzProtocolMutable ();

    /**
     * Sets the value of the member "szProtocol".
     *
     * A string containing protocl of the IAP application.
     *
     * @param szProtocol The value which will be set
     */
    inline void setSzProtocol (const ::std::string& szProtocol_);

    /**
     * Sets the value of the member "szProtocol".
     *
     * A string containing protocl of the IAP application.
     *
     * @param szProtocol The value which will be set
     */
    inline void setSzProtocol (const char* szProtocol_);

    /**
     * Sets the value of the member "szProtocol".
     *
     * A string containing protocl of the IAP application.
     *
     * @param szProtocol The value which will be set
     */
    inline void setSzProtocol (const char* value, size_t size);

    // API of field "szBundleSeedID"

    static const int kSzBundleSeedID = 2;

    /**
     * Clears the field "szBundleSeedID".
     *
     * The field will be set to its default value. The hasSzBundleSeedID()
     * method will return false.
     */
    inline void clearSzBundleSeedID();

    /**
     * Checks whether the field "szBundleSeedID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzBundleSeedID()). Otherwise it will return false.
     */
    inline bool hasSzBundleSeedID () const;

    /**
     * Returns the value of the member "szBundleSeedID".
     *
     * A string containing the bundle seed ID of the IAP application.
     *
     * @return The value of the field "szBundleSeedID"
     */
    inline const ::std::string& getSzBundleSeedID () const;

    /**
     * Retrieves the value of the field "szBundleSeedID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szBundleSeedID".
     */
    inline ::std::string& getSzBundleSeedIDMutable ();

    /**
     * Sets the value of the member "szBundleSeedID".
     *
     * A string containing the bundle seed ID of the IAP application.
     *
     * @param szBundleSeedID The value which will be set
     */
    inline void setSzBundleSeedID (const ::std::string& szBundleSeedID_);

    /**
     * Sets the value of the member "szBundleSeedID".
     *
     * A string containing the bundle seed ID of the IAP application.
     *
     * @param szBundleSeedID The value which will be set
     */
    inline void setSzBundleSeedID (const char* szBundleSeedID_);

    /**
     * Sets the value of the member "szBundleSeedID".
     *
     * A string containing the bundle seed ID of the IAP application.
     *
     * @param szBundleSeedID The value which will be set
     */
    inline void setSzBundleSeedID (const char* value, size_t size);

    // API of field "szAppName"

    static const int kSzAppName = 3;

    /**
     * Clears the field "szAppName".
     *
     * The field will be set to its default value. The hasSzAppName()
     * method will return false.
     */
    inline void clearSzAppName();

    /**
     * Checks whether the field "szAppName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzAppName()). Otherwise it will return false.
     */
    inline bool hasSzAppName () const;

    /**
     * Returns the value of the member "szAppName".
     *
     * A string containing App name of the IAP application.
     *
     * @return The value of the field "szAppName"
     */
    inline const ::std::string& getSzAppName () const;

    /**
     * Retrieves the value of the field "szAppName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szAppName".
     */
    inline ::std::string& getSzAppNameMutable ();

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing App name of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const ::std::string& szAppName_);

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing App name of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const char* szAppName_);

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing App name of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const char* value, size_t size);

    // API of field "e8AppLaunchOption"

    static const int kE8AppLaunchOption = 4;

    /**
     * Clears the field "e8AppLaunchOption".
     *
     * The field will be set to its default value. The hasE8AppLaunchOption()
     * method will return false.
     */
    inline void clearE8AppLaunchOption();

    /**
     * Checks whether the field "e8AppLaunchOption" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AppLaunchOption()). Otherwise it will return false.
     */
    inline bool hasE8AppLaunchOption () const;

    /**
     * Returns the value of the member "e8AppLaunchOption".
     *
     * An enum containing the app launch option (e.g. user alert popup).
     *
     * @return The value of the field "e8AppLaunchOption"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_AppLaunchOption getE8AppLaunchOption () const;

    /**
     * Sets the value of the member "e8AppLaunchOption".
     *
     * An enum containing the app launch option (e.g. user alert popup).
     *
     * @param e8AppLaunchOption The value which will be set
     */
    inline void setE8AppLaunchOption (::mplay_appcontrol_fi_types::T_e8_AppLaunchOption e8AppLaunchOption_);

    static const ConnectStart &getDefaultInstance();

private:

    inline void set_has_szDeviceId ();

    inline void clear_has_szDeviceId ();

    inline void set_has_szProtocol ();

    inline void clear_has_szProtocol ();

    inline void set_has_szBundleSeedID ();

    inline void clear_has_szBundleSeedID ();

    inline void set_has_szAppName ();

    inline void clear_has_szAppName ();

    inline void set_has_e8AppLaunchOption ();

    inline void clear_has_e8AppLaunchOption ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _szDeviceId;

    ::std::string _szProtocol;

    ::std::string _szBundleSeedID;

    ::std::string _szAppName;

    ::mplay_appcontrol_fi_types::T_e8_AppLaunchOption _e8AppLaunchOption;

};

/**
 * The result message of the method "Connect"
 * The AppControl Connect method provides the interface for the Internet Radio to tell the
 * iPod device control to connect to the Pandora application using the MediaPlayer.
 */
class ConnectResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectResult ();

    /**
     * Copy constructor
     */
    inline  ConnectResult (const ConnectResult &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectResult (const ::std::string& szDeviceId_, uint16 u16SessionId_, const ::std::string& szAppName_);

    /**
     * Destructor
     */
    inline virtual  ~ConnectResult();

    /**
     * Assignment operator
     */
    inline ConnectResult& operator = (const ConnectResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "szDeviceId"

    static const int kSzDeviceId = 0;

    /**
     * Clears the field "szDeviceId".
     *
     * The field will be set to its default value. The hasSzDeviceId()
     * method will return false.
     */
    inline void clearSzDeviceId();

    /**
     * Checks whether the field "szDeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDeviceId()). Otherwise it will return false.
     */
    inline bool hasSzDeviceId () const;

    /**
     * Returns the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name.
     *
     * @return The value of the field "szDeviceId"
     */
    inline const ::std::string& getSzDeviceId () const;

    /**
     * Retrieves the value of the field "szDeviceId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDeviceId".
     */
    inline ::std::string& getSzDeviceIdMutable ();

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name.
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const ::std::string& szDeviceId_);

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name.
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const char* szDeviceId_);

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name.
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const char* value, size_t size);

    // API of field "u16SessionId"

    static const int kU16SessionId = 1;

    /**
     * Clears the field "u16SessionId".
     *
     * The field will be set to its default value. The hasU16SessionId()
     * method will return false.
     */
    inline void clearU16SessionId();

    /**
     * Checks whether the field "u16SessionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SessionId()). Otherwise it will return false.
     */
    inline bool hasU16SessionId () const;

    /**
     * Returns the value of the member "u16SessionId".
     *
     * The session ID of the connected IAP application.
     *
     * @return The value of the field "u16SessionId"
     */
    inline uint16 getU16SessionId () const;

    /**
     * Sets the value of the member "u16SessionId".
     *
     * The session ID of the connected IAP application.
     *
     * @param u16SessionId The value which will be set
     */
    inline void setU16SessionId (uint16 u16SessionId_);

    // API of field "szAppName"

    static const int kSzAppName = 2;

    /**
     * Clears the field "szAppName".
     *
     * The field will be set to its default value. The hasSzAppName()
     * method will return false.
     */
    inline void clearSzAppName();

    /**
     * Checks whether the field "szAppName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzAppName()). Otherwise it will return false.
     */
    inline bool hasSzAppName () const;

    /**
     * Returns the value of the member "szAppName".
     *
     * A string containing Appname of the IAP application.
     *
     * @return The value of the field "szAppName"
     */
    inline const ::std::string& getSzAppName () const;

    /**
     * Retrieves the value of the field "szAppName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szAppName".
     */
    inline ::std::string& getSzAppNameMutable ();

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing Appname of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const ::std::string& szAppName_);

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing Appname of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const char* szAppName_);

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing Appname of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const char* value, size_t size);

    static const ConnectResult &getDefaultInstance();

private:

    inline void set_has_szDeviceId ();

    inline void clear_has_szDeviceId ();

    inline void set_has_u16SessionId ();

    inline void clear_has_u16SessionId ();

    inline void set_has_szAppName ();

    inline void clear_has_szAppName ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _szDeviceId;

    uint16 _u16SessionId;

    ::std::string _szAppName;

};

/**
 * The start message of the method "Command"
 * The AppControl Command method provides the interface for the Internet Radio to send
 * an IAP command to the MediaPlayer.
 */
class CommandStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CommandStart ();

    /**
     * Copy constructor
     */
    inline  CommandStart (const CommandStart &rhs);

    /**
     * All fields constructor
     */
    inline  CommandStart (const ::std::string& szDeviceId_, const ::std::string& szAppName_, uint16 u16SessionId_, const ::asf::core::Blob& au8CommandBuffer_);

    /**
     * Destructor
     */
    inline virtual  ~CommandStart();

    /**
     * Assignment operator
     */
    inline CommandStart& operator = (const CommandStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CommandStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CommandStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CommandStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CommandStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "szDeviceId"

    static const int kSzDeviceId = 0;

    /**
     * Clears the field "szDeviceId".
     *
     * The field will be set to its default value. The hasSzDeviceId()
     * method will return false.
     */
    inline void clearSzDeviceId();

    /**
     * Checks whether the field "szDeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDeviceId()). Otherwise it will return false.
     */
    inline bool hasSzDeviceId () const;

    /**
     * Returns the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name.
     *
     * @return The value of the field "szDeviceId"
     */
    inline const ::std::string& getSzDeviceId () const;

    /**
     * Retrieves the value of the field "szDeviceId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDeviceId".
     */
    inline ::std::string& getSzDeviceIdMutable ();

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name.
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const ::std::string& szDeviceId_);

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name.
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const char* szDeviceId_);

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name.
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const char* value, size_t size);

    // API of field "szAppName"

    static const int kSzAppName = 1;

    /**
     * Clears the field "szAppName".
     *
     * The field will be set to its default value. The hasSzAppName()
     * method will return false.
     */
    inline void clearSzAppName();

    /**
     * Checks whether the field "szAppName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzAppName()). Otherwise it will return false.
     */
    inline bool hasSzAppName () const;

    /**
     * Returns the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @return The value of the field "szAppName"
     */
    inline const ::std::string& getSzAppName () const;

    /**
     * Retrieves the value of the field "szAppName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szAppName".
     */
    inline ::std::string& getSzAppNameMutable ();

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const ::std::string& szAppName_);

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const char* szAppName_);

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const char* value, size_t size);

    // API of field "u16SessionId"

    static const int kU16SessionId = 2;

    /**
     * Clears the field "u16SessionId".
     *
     * The field will be set to its default value. The hasU16SessionId()
     * method will return false.
     */
    inline void clearU16SessionId();

    /**
     * Checks whether the field "u16SessionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SessionId()). Otherwise it will return false.
     */
    inline bool hasU16SessionId () const;

    /**
     * Returns the value of the member "u16SessionId".
     *
     * The session ID of the connected IAP application.
     *
     * @return The value of the field "u16SessionId"
     */
    inline uint16 getU16SessionId () const;

    /**
     * Sets the value of the member "u16SessionId".
     *
     * The session ID of the connected IAP application.
     *
     * @param u16SessionId The value which will be set
     */
    inline void setU16SessionId (uint16 u16SessionId_);

    // API of field "au8CommandBuffer"

    static const int kAu8CommandBuffer = 3;

    /**
     * Clears the field "au8CommandBuffer".
     *
     * The field will be set to its default value. The hasAu8CommandBuffer()
     * method will return false.
     */
    inline void clearAu8CommandBuffer();

    /**
     * Checks whether the field "au8CommandBuffer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAu8CommandBuffer()). Otherwise it will return false.
     */
    inline bool hasAu8CommandBuffer () const;

    /**
     * Returns the value of the member "au8CommandBuffer".
     *
     * IAP commands.
     *
     * @return The value of the field "au8CommandBuffer"
     */
    inline const ::asf::core::Blob& getAu8CommandBuffer () const;

    /**
     * Retrieves the value of the field "au8CommandBuffer" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "au8CommandBuffer".
     */
    inline ::asf::core::Blob& getAu8CommandBufferMutable ();

    /**
     * Sets the value of the member "au8CommandBuffer".
     *
     * IAP commands.
     *
     * @param au8CommandBuffer The value which will be set
     */
    inline void setAu8CommandBuffer (const ::asf::core::Blob& au8CommandBuffer_);

    static const CommandStart &getDefaultInstance();

private:

    inline void set_has_szDeviceId ();

    inline void clear_has_szDeviceId ();

    inline void set_has_szAppName ();

    inline void clear_has_szAppName ();

    inline void set_has_u16SessionId ();

    inline void clear_has_u16SessionId ();

    inline void set_has_au8CommandBuffer ();

    inline void clear_has_au8CommandBuffer ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _szDeviceId;

    ::std::string _szAppName;

    uint16 _u16SessionId;

    ::asf::core::Blob _au8CommandBuffer;

};

/**
 * The result message of the method "Command"
 * The AppControl Command method provides the interface for the Internet Radio to send
 * an IAP command to the MediaPlayer.
 */
class CommandResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CommandResult ();

    /**
     * Copy constructor
     */
    inline  CommandResult (const CommandResult &rhs);

    /**
     * All fields constructor
     */
    inline  CommandResult (const ::std::string& szDeviceId_, const ::std::string& szAppName_, uint16 u16SessionId_, const ::asf::core::Blob& au8CommandResponseBuffer_);

    /**
     * Destructor
     */
    inline virtual  ~CommandResult();

    /**
     * Assignment operator
     */
    inline CommandResult& operator = (const CommandResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CommandResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CommandResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CommandResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CommandResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "szDeviceId"

    static const int kSzDeviceId = 0;

    /**
     * Clears the field "szDeviceId".
     *
     * The field will be set to its default value. The hasSzDeviceId()
     * method will return false.
     */
    inline void clearSzDeviceId();

    /**
     * Checks whether the field "szDeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDeviceId()). Otherwise it will return false.
     */
    inline bool hasSzDeviceId () const;

    /**
     * Returns the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name.
     *
     * @return The value of the field "szDeviceId"
     */
    inline const ::std::string& getSzDeviceId () const;

    /**
     * Retrieves the value of the field "szDeviceId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDeviceId".
     */
    inline ::std::string& getSzDeviceIdMutable ();

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name.
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const ::std::string& szDeviceId_);

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name.
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const char* szDeviceId_);

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name.
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const char* value, size_t size);

    // API of field "szAppName"

    static const int kSzAppName = 1;

    /**
     * Clears the field "szAppName".
     *
     * The field will be set to its default value. The hasSzAppName()
     * method will return false.
     */
    inline void clearSzAppName();

    /**
     * Checks whether the field "szAppName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzAppName()). Otherwise it will return false.
     */
    inline bool hasSzAppName () const;

    /**
     * Returns the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @return The value of the field "szAppName"
     */
    inline const ::std::string& getSzAppName () const;

    /**
     * Retrieves the value of the field "szAppName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szAppName".
     */
    inline ::std::string& getSzAppNameMutable ();

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const ::std::string& szAppName_);

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const char* szAppName_);

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const char* value, size_t size);

    // API of field "u16SessionId"

    static const int kU16SessionId = 2;

    /**
     * Clears the field "u16SessionId".
     *
     * The field will be set to its default value. The hasU16SessionId()
     * method will return false.
     */
    inline void clearU16SessionId();

    /**
     * Checks whether the field "u16SessionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SessionId()). Otherwise it will return false.
     */
    inline bool hasU16SessionId () const;

    /**
     * Returns the value of the member "u16SessionId".
     *
     * The session ID of the connected IAP application.
     *
     * @return The value of the field "u16SessionId"
     */
    inline uint16 getU16SessionId () const;

    /**
     * Sets the value of the member "u16SessionId".
     *
     * The session ID of the connected IAP application.
     *
     * @param u16SessionId The value which will be set
     */
    inline void setU16SessionId (uint16 u16SessionId_);

    // API of field "au8CommandResponseBuffer"

    static const int kAu8CommandResponseBuffer = 3;

    /**
     * Clears the field "au8CommandResponseBuffer".
     *
     * The field will be set to its default value. The hasAu8CommandResponseBuffer()
     * method will return false.
     */
    inline void clearAu8CommandResponseBuffer();

    /**
     * Checks whether the field "au8CommandResponseBuffer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAu8CommandResponseBuffer()). Otherwise it will return false.
     */
    inline bool hasAu8CommandResponseBuffer () const;

    /**
     * Returns the value of the member "au8CommandResponseBuffer".
     *
     * IAP command response.
     *
     * @return The value of the field "au8CommandResponseBuffer"
     */
    inline const ::asf::core::Blob& getAu8CommandResponseBuffer () const;

    /**
     * Retrieves the value of the field "au8CommandResponseBuffer" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "au8CommandResponseBuffer".
     */
    inline ::asf::core::Blob& getAu8CommandResponseBufferMutable ();

    /**
     * Sets the value of the member "au8CommandResponseBuffer".
     *
     * IAP command response.
     *
     * @param au8CommandResponseBuffer The value which will be set
     */
    inline void setAu8CommandResponseBuffer (const ::asf::core::Blob& au8CommandResponseBuffer_);

    static const CommandResult &getDefaultInstance();

private:

    inline void set_has_szDeviceId ();

    inline void clear_has_szDeviceId ();

    inline void set_has_szAppName ();

    inline void clear_has_szAppName ();

    inline void set_has_u16SessionId ();

    inline void clear_has_u16SessionId ();

    inline void set_has_au8CommandResponseBuffer ();

    inline void clear_has_au8CommandResponseBuffer ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _szDeviceId;

    ::std::string _szAppName;

    uint16 _u16SessionId;

    ::asf::core::Blob _au8CommandResponseBuffer;

};

/**
 * The start message of the method "Close"
 * The AppControl Close method provides the interface for the Internet Radio to send an IAP
 * command to the MediaPlayer to terminate the IAP session with the Pandora application.
 */
class CloseStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CloseStart ();

    /**
     * Copy constructor
     */
    inline  CloseStart (const CloseStart &rhs);

    /**
     * All fields constructor
     */
    inline  CloseStart (const ::std::string& szDeviceId_, const ::std::string& szAppName_, uint16 u16SessionId_);

    /**
     * Destructor
     */
    inline virtual  ~CloseStart();

    /**
     * Assignment operator
     */
    inline CloseStart& operator = (const CloseStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CloseStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CloseStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CloseStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CloseStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "szDeviceId"

    static const int kSzDeviceId = 0;

    /**
     * Clears the field "szDeviceId".
     *
     * The field will be set to its default value. The hasSzDeviceId()
     * method will return false.
     */
    inline void clearSzDeviceId();

    /**
     * Checks whether the field "szDeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDeviceId()). Otherwise it will return false.
     */
    inline bool hasSzDeviceId () const;

    /**
     * Returns the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name
     *
     * @return The value of the field "szDeviceId"
     */
    inline const ::std::string& getSzDeviceId () const;

    /**
     * Retrieves the value of the field "szDeviceId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDeviceId".
     */
    inline ::std::string& getSzDeviceIdMutable ();

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const ::std::string& szDeviceId_);

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const char* szDeviceId_);

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const char* value, size_t size);

    // API of field "szAppName"

    static const int kSzAppName = 1;

    /**
     * Clears the field "szAppName".
     *
     * The field will be set to its default value. The hasSzAppName()
     * method will return false.
     */
    inline void clearSzAppName();

    /**
     * Checks whether the field "szAppName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzAppName()). Otherwise it will return false.
     */
    inline bool hasSzAppName () const;

    /**
     * Returns the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @return The value of the field "szAppName"
     */
    inline const ::std::string& getSzAppName () const;

    /**
     * Retrieves the value of the field "szAppName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szAppName".
     */
    inline ::std::string& getSzAppNameMutable ();

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const ::std::string& szAppName_);

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const char* szAppName_);

    /**
     * Sets the value of the member "szAppName".
     *
     * A string containing the App name of the IAP application.
     *
     * @param szAppName The value which will be set
     */
    inline void setSzAppName (const char* value, size_t size);

    // API of field "u16SessionId"

    static const int kU16SessionId = 2;

    /**
     * Clears the field "u16SessionId".
     *
     * The field will be set to its default value. The hasU16SessionId()
     * method will return false.
     */
    inline void clearU16SessionId();

    /**
     * Checks whether the field "u16SessionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SessionId()). Otherwise it will return false.
     */
    inline bool hasU16SessionId () const;

    /**
     * Returns the value of the member "u16SessionId".
     *
     * The session ID of the connected IAP application.
     *
     * @return The value of the field "u16SessionId"
     */
    inline uint16 getU16SessionId () const;

    /**
     * Sets the value of the member "u16SessionId".
     *
     * The session ID of the connected IAP application.
     *
     * @param u16SessionId The value which will be set
     */
    inline void setU16SessionId (uint16 u16SessionId_);

    static const CloseStart &getDefaultInstance();

private:

    inline void set_has_szDeviceId ();

    inline void clear_has_szDeviceId ();

    inline void set_has_szAppName ();

    inline void clear_has_szAppName ();

    inline void set_has_u16SessionId ();

    inline void clear_has_u16SessionId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _szDeviceId;

    ::std::string _szAppName;

    uint16 _u16SessionId;

};

/**
 * The start message of the method "StartAudio"
 * Starts audio playback on apple device. This function must be called if application wants to playback an audio stream on apple device
 */
class StartAudioStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartAudioStart ();

    /**
     * Copy constructor
     */
    inline  StartAudioStart (const StartAudioStart &rhs);

    /**
     * All fields constructor
     */
    inline  StartAudioStart (const ::std::string& szDeviceId_);

    /**
     * Destructor
     */
    inline virtual  ~StartAudioStart();

    /**
     * Assignment operator
     */
    inline StartAudioStart& operator = (const StartAudioStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartAudioStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartAudioStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartAudioStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartAudioStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "szDeviceId"

    static const int kSzDeviceId = 0;

    /**
     * Clears the field "szDeviceId".
     *
     * The field will be set to its default value. The hasSzDeviceId()
     * method will return false.
     */
    inline void clearSzDeviceId();

    /**
     * Checks whether the field "szDeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDeviceId()). Otherwise it will return false.
     */
    inline bool hasSzDeviceId () const;

    /**
     * Returns the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name
     *
     * @return The value of the field "szDeviceId"
     */
    inline const ::std::string& getSzDeviceId () const;

    /**
     * Retrieves the value of the field "szDeviceId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDeviceId".
     */
    inline ::std::string& getSzDeviceIdMutable ();

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const ::std::string& szDeviceId_);

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const char* szDeviceId_);

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const char* value, size_t size);

    static const StartAudioStart &getDefaultInstance();

private:

    inline void set_has_szDeviceId ();

    inline void clear_has_szDeviceId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _szDeviceId;

};

/**
 * The start message of the method "StopAudio"
 * Stops audio playback on apple device. This function must be called if application does not want to play audio stream anymore.
 */
class StopAudioStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StopAudioStart ();

    /**
     * Copy constructor
     */
    inline  StopAudioStart (const StopAudioStart &rhs);

    /**
     * All fields constructor
     */
    inline  StopAudioStart (const ::std::string& szDeviceId_);

    /**
     * Destructor
     */
    inline virtual  ~StopAudioStart();

    /**
     * Assignment operator
     */
    inline StopAudioStart& operator = (const StopAudioStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopAudioStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopAudioStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopAudioStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopAudioStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "szDeviceId"

    static const int kSzDeviceId = 0;

    /**
     * Clears the field "szDeviceId".
     *
     * The field will be set to its default value. The hasSzDeviceId()
     * method will return false.
     */
    inline void clearSzDeviceId();

    /**
     * Checks whether the field "szDeviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzDeviceId()). Otherwise it will return false.
     */
    inline bool hasSzDeviceId () const;

    /**
     * Returns the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name
     *
     * @return The value of the field "szDeviceId"
     */
    inline const ::std::string& getSzDeviceId () const;

    /**
     * Retrieves the value of the field "szDeviceId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szDeviceId".
     */
    inline ::std::string& getSzDeviceIdMutable ();

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const ::std::string& szDeviceId_);

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const char* szDeviceId_);

    /**
     * Sets the value of the member "szDeviceId".
     *
     * A string containing the iPhone device HID name
     *
     * @param szDeviceId The value which will be set
     */
    inline void setSzDeviceId (const char* value, size_t size);

    static const StopAudioStart &getDefaultInstance();

private:

    inline void set_has_szDeviceId ();

    inline void clear_has_szDeviceId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _szDeviceId;

};

/**
 * The start message of the method "DiPOActiveDevice"
 * Deprecated!
 * MediaPlayer is informed when a device is used as DiPO device. This information can be used by MediaPlayer
 * to transfer metadata if available
 */
class DiPOActiveDeviceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOActiveDeviceStart ();

    /**
     * Copy constructor
     */
    inline  DiPOActiveDeviceStart (const DiPOActiveDeviceStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOActiveDeviceStart (uint8 u8DeviceTag_, bool bDiPOActive_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOActiveDeviceStart();

    /**
     * Assignment operator
     */
    inline DiPOActiveDeviceStart& operator = (const DiPOActiveDeviceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOActiveDeviceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOActiveDeviceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOActiveDeviceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOActiveDeviceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 0;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "bDiPOActive"

    static const int kBDiPOActive = 1;

    /**
     * Clears the field "bDiPOActive".
     *
     * The field will be set to its default value. The hasBDiPOActive()
     * method will return false.
     */
    inline void clearBDiPOActive();

    /**
     * Checks whether the field "bDiPOActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDiPOActive()). Otherwise it will return false.
     */
    inline bool hasBDiPOActive () const;

    /**
     * Returns the value of the member "bDiPOActive".
     *
     * "True" if DiPO session is active. "False" if DiPO session is not active.
     *
     * @return The value of the field "bDiPOActive"
     */
    inline bool getBDiPOActive () const;

    /**
     * Sets the value of the member "bDiPOActive".
     *
     * "True" if DiPO session is active. "False" if DiPO session is not active.
     *
     * @param bDiPOActive The value which will be set
     */
    inline void setBDiPOActive (bool bDiPOActive_);

    static const DiPOActiveDeviceStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_bDiPOActive ();

    inline void clear_has_bDiPOActive ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceTag;

    bool _bDiPOActive;

};

/**
 * The result message of the method "DiPOActiveDevice"
 * Deprecated!
 * MediaPlayer is informed when a device is used as DiPO device. This information can be used by MediaPlayer
 * to transfer metadata if available
 */
class DiPOActiveDeviceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOActiveDeviceResult ();

    /**
     * Copy constructor
     */
    inline  DiPOActiveDeviceResult (const DiPOActiveDeviceResult &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOActiveDeviceResult (::mplay_appcontrol_fi_types::T_e8_DiPOResponse e8DiPOResponse_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOActiveDeviceResult();

    /**
     * Assignment operator
     */
    inline DiPOActiveDeviceResult& operator = (const DiPOActiveDeviceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOActiveDeviceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOActiveDeviceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOActiveDeviceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOActiveDeviceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DiPOResponse"

    static const int kE8DiPOResponse = 0;

    /**
     * Clears the field "e8DiPOResponse".
     *
     * The field will be set to its default value. The hasE8DiPOResponse()
     * method will return false.
     */
    inline void clearE8DiPOResponse();

    /**
     * Checks whether the field "e8DiPOResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DiPOResponse()). Otherwise it will return false.
     */
    inline bool hasE8DiPOResponse () const;

    /**
     * Returns the value of the member "e8DiPOResponse".
     *
     * Result of the operation
     *
     * @return The value of the field "e8DiPOResponse"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_DiPOResponse getE8DiPOResponse () const;

    /**
     * Sets the value of the member "e8DiPOResponse".
     *
     * Result of the operation
     *
     * @param e8DiPOResponse The value which will be set
     */
    inline void setE8DiPOResponse (::mplay_appcontrol_fi_types::T_e8_DiPOResponse e8DiPOResponse_);

    static const DiPOActiveDeviceResult &getDefaultInstance();

private:

    inline void set_has_e8DiPOResponse ();

    inline void clear_has_e8DiPOResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::mplay_appcontrol_fi_types::T_e8_DiPOResponse _e8DiPOResponse;

};

/**
 * The start message of the method "DiPORoleSwitchRequest"
 * Requests a USB role switch: From USB client to USB host or vice versa
 */
class DiPORoleSwitchRequestStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPORoleSwitchRequestStart ();

    /**
     * Copy constructor
     */
    inline  DiPORoleSwitchRequestStart (const DiPORoleSwitchRequestStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPORoleSwitchRequestStart (uint8 u8DeviceTag_, const ::std::string& sDeviceUSBSerialNumber_, ::mplay_appcontrol_fi_types::T_e8_DiPORoleStatus e8DiPORoleStatus_, const ::mplay_appcontrol_fi_types::T_AppInfo& oAppInfo_);

    /**
     * Destructor
     */
    inline virtual  ~DiPORoleSwitchRequestStart();

    /**
     * Assignment operator
     */
    inline DiPORoleSwitchRequestStart& operator = (const DiPORoleSwitchRequestStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPORoleSwitchRequestStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPORoleSwitchRequestStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPORoleSwitchRequestStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPORoleSwitchRequestStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 0;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "sDeviceUSBSerialNumber"

    static const int kSDeviceUSBSerialNumber = 1;

    /**
     * Clears the field "sDeviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasSDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearSDeviceUSBSerialNumber();

    /**
     * Checks whether the field "sDeviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasSDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @return The value of the field "sDeviceUSBSerialNumber"
     */
    inline const ::std::string& getSDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "sDeviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceUSBSerialNumber".
     */
    inline ::std::string& getSDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* value, size_t size);

    // API of field "e8DiPORoleStatus"

    static const int kE8DiPORoleStatus = 2;

    /**
     * Clears the field "e8DiPORoleStatus".
     *
     * The field will be set to its default value. The hasE8DiPORoleStatus()
     * method will return false.
     */
    inline void clearE8DiPORoleStatus();

    /**
     * Checks whether the field "e8DiPORoleStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DiPORoleStatus()). Otherwise it will return false.
     */
    inline bool hasE8DiPORoleStatus () const;

    /**
     * Returns the value of the member "e8DiPORoleStatus".
     *
     * Role status
     *
     * @return The value of the field "e8DiPORoleStatus"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_DiPORoleStatus getE8DiPORoleStatus () const;

    /**
     * Sets the value of the member "e8DiPORoleStatus".
     *
     * Role status
     *
     * @param e8DiPORoleStatus The value which will be set
     */
    inline void setE8DiPORoleStatus (::mplay_appcontrol_fi_types::T_e8_DiPORoleStatus e8DiPORoleStatus_);

    // API of field "oAppInfo"

    static const int kOAppInfo = 3;

    /**
     * Clears the field "oAppInfo".
     *
     * The field will be set to its default value. The hasOAppInfo()
     * method will return false.
     */
    inline void clearOAppInfo();

    /**
     * Checks whether the field "oAppInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOAppInfo()). Otherwise it will return false.
     */
    inline bool hasOAppInfo () const;

    /**
     * Returns the value of the member "oAppInfo".
     *
     * App name with Protocol(Carplay or MySpin or Carlife) and bundle id
     *
     * @return The value of the field "oAppInfo"
     */
    inline const ::mplay_appcontrol_fi_types::T_AppInfo& getOAppInfo () const;

    /**
     * Retrieves the value of the field "oAppInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oAppInfo".
     */
    inline ::mplay_appcontrol_fi_types::T_AppInfo& getOAppInfoMutable ();

    /**
     * Sets the value of the member "oAppInfo".
     *
     * App name with Protocol(Carplay or MySpin or Carlife) and bundle id
     *
     * @param oAppInfo The value which will be set
     */
    inline void setOAppInfo (const ::mplay_appcontrol_fi_types::T_AppInfo& oAppInfo_);

    static const DiPORoleSwitchRequestStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_sDeviceUSBSerialNumber ();

    inline void clear_has_sDeviceUSBSerialNumber ();

    inline void set_has_e8DiPORoleStatus ();

    inline void clear_has_e8DiPORoleStatus ();

    inline void set_has_oAppInfo ();

    inline void clear_has_oAppInfo ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _u8DeviceTag;

    ::std::string _sDeviceUSBSerialNumber;

    ::mplay_appcontrol_fi_types::T_e8_DiPORoleStatus _e8DiPORoleStatus;

    ::mplay_appcontrol_fi_types::T_AppInfo _oAppInfo;

};

/**
 * The result message of the method "DiPORoleSwitchRequest"
 * Requests a USB role switch: From USB client to USB host or vice versa
 */
class DiPORoleSwitchRequestResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPORoleSwitchRequestResult ();

    /**
     * Copy constructor
     */
    inline  DiPORoleSwitchRequestResult (const DiPORoleSwitchRequestResult &rhs);

    /**
     * All fields constructor
     */
    inline  DiPORoleSwitchRequestResult (::mplay_appcontrol_fi_types::T_e8_DiPOResponse e8DiPOResponse_, const ::std::string& sDeviceUSBSerialNumber_);

    /**
     * Destructor
     */
    inline virtual  ~DiPORoleSwitchRequestResult();

    /**
     * Assignment operator
     */
    inline DiPORoleSwitchRequestResult& operator = (const DiPORoleSwitchRequestResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPORoleSwitchRequestResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPORoleSwitchRequestResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPORoleSwitchRequestResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPORoleSwitchRequestResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DiPOResponse"

    static const int kE8DiPOResponse = 0;

    /**
     * Clears the field "e8DiPOResponse".
     *
     * The field will be set to its default value. The hasE8DiPOResponse()
     * method will return false.
     */
    inline void clearE8DiPOResponse();

    /**
     * Checks whether the field "e8DiPOResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DiPOResponse()). Otherwise it will return false.
     */
    inline bool hasE8DiPOResponse () const;

    /**
     * Returns the value of the member "e8DiPOResponse".
     *
     * Result of the operation
     *
     * @return The value of the field "e8DiPOResponse"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_DiPOResponse getE8DiPOResponse () const;

    /**
     * Sets the value of the member "e8DiPOResponse".
     *
     * Result of the operation
     *
     * @param e8DiPOResponse The value which will be set
     */
    inline void setE8DiPOResponse (::mplay_appcontrol_fi_types::T_e8_DiPOResponse e8DiPOResponse_);

    // API of field "sDeviceUSBSerialNumber"

    static const int kSDeviceUSBSerialNumber = 1;

    /**
     * Clears the field "sDeviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasSDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearSDeviceUSBSerialNumber();

    /**
     * Checks whether the field "sDeviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasSDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @return The value of the field "sDeviceUSBSerialNumber"
     */
    inline const ::std::string& getSDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "sDeviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceUSBSerialNumber".
     */
    inline ::std::string& getSDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* value, size_t size);

    static const DiPORoleSwitchRequestResult &getDefaultInstance();

private:

    inline void set_has_e8DiPOResponse ();

    inline void clear_has_e8DiPOResponse ();

    inline void set_has_sDeviceUSBSerialNumber ();

    inline void clear_has_sDeviceUSBSerialNumber ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::mplay_appcontrol_fi_types::T_e8_DiPOResponse _e8DiPOResponse;

    ::std::string _sDeviceUSBSerialNumber;

};

/**
 * The start message of the method "DiPOGetMediaObjectAlbumArtInfo"
 * This Method is used to retrieve the MIME type and size of the album art
 * image associated with a particular media object. The actual album art image is retrieved by calling the
 * DiPOGetMediaObjectAlbumArt function.
 */
class DiPOGetMediaObjectAlbumArtInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOGetMediaObjectAlbumArtInfoStart ();

    /**
     * Copy constructor
     */
    inline  DiPOGetMediaObjectAlbumArtInfoStart (const DiPOGetMediaObjectAlbumArtInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOGetMediaObjectAlbumArtInfoStart (const ::std::string& sAlbumArt_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOGetMediaObjectAlbumArtInfoStart();

    /**
     * Assignment operator
     */
    inline DiPOGetMediaObjectAlbumArtInfoStart& operator = (const DiPOGetMediaObjectAlbumArtInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOGetMediaObjectAlbumArtInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOGetMediaObjectAlbumArtInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOGetMediaObjectAlbumArtInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOGetMediaObjectAlbumArtInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sAlbumArt"

    static const int kSAlbumArt = 0;

    /**
     * Clears the field "sAlbumArt".
     *
     * The field will be set to its default value. The hasSAlbumArt()
     * method will return false.
     */
    inline void clearSAlbumArt();

    /**
     * Checks whether the field "sAlbumArt" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAlbumArt()). Otherwise it will return false.
     */
    inline bool hasSAlbumArt () const;

    /**
     * Returns the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @return The value of the field "sAlbumArt"
     */
    inline const ::std::string& getSAlbumArt () const;

    /**
     * Retrieves the value of the field "sAlbumArt" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAlbumArt".
     */
    inline ::std::string& getSAlbumArtMutable ();

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const ::std::string& sAlbumArt_);

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const char* sAlbumArt_);

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const char* value, size_t size);

    static const DiPOGetMediaObjectAlbumArtInfoStart &getDefaultInstance();

private:

    inline void set_has_sAlbumArt ();

    inline void clear_has_sAlbumArt ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _sAlbumArt;

};

/**
 * The result message of the method "DiPOGetMediaObjectAlbumArtInfo"
 * This Method is used to retrieve the MIME type and size of the album art
 * image associated with a particular media object. The actual album art image is retrieved by calling the
 * DiPOGetMediaObjectAlbumArt function.
 */
class DiPOGetMediaObjectAlbumArtInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOGetMediaObjectAlbumArtInfoResult ();

    /**
     * Copy constructor
     */
    inline  DiPOGetMediaObjectAlbumArtInfoResult (const DiPOGetMediaObjectAlbumArtInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOGetMediaObjectAlbumArtInfoResult (const ::std::string& sMIMEImageSubtype_, uint32 u32PhotoSize_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOGetMediaObjectAlbumArtInfoResult();

    /**
     * Assignment operator
     */
    inline DiPOGetMediaObjectAlbumArtInfoResult& operator = (const DiPOGetMediaObjectAlbumArtInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOGetMediaObjectAlbumArtInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOGetMediaObjectAlbumArtInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOGetMediaObjectAlbumArtInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOGetMediaObjectAlbumArtInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sMIMEImageSubtype"

    static const int kSMIMEImageSubtype = 0;

    /**
     * Clears the field "sMIMEImageSubtype".
     *
     * The field will be set to its default value. The hasSMIMEImageSubtype()
     * method will return false.
     */
    inline void clearSMIMEImageSubtype();

    /**
     * Checks whether the field "sMIMEImageSubtype" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMIMEImageSubtype()). Otherwise it will return false.
     */
    inline bool hasSMIMEImageSubtype () const;

    /**
     * Returns the value of the member "sMIMEImageSubtype".
     *
     * Identifies the MIME image subtype
     *
     * @return The value of the field "sMIMEImageSubtype"
     */
    inline const ::std::string& getSMIMEImageSubtype () const;

    /**
     * Retrieves the value of the field "sMIMEImageSubtype" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sMIMEImageSubtype".
     */
    inline ::std::string& getSMIMEImageSubtypeMutable ();

    /**
     * Sets the value of the member "sMIMEImageSubtype".
     *
     * Identifies the MIME image subtype
     *
     * @param sMIMEImageSubtype The value which will be set
     */
    inline void setSMIMEImageSubtype (const ::std::string& sMIMEImageSubtype_);

    /**
     * Sets the value of the member "sMIMEImageSubtype".
     *
     * Identifies the MIME image subtype
     *
     * @param sMIMEImageSubtype The value which will be set
     */
    inline void setSMIMEImageSubtype (const char* sMIMEImageSubtype_);

    /**
     * Sets the value of the member "sMIMEImageSubtype".
     *
     * Identifies the MIME image subtype
     *
     * @param sMIMEImageSubtype The value which will be set
     */
    inline void setSMIMEImageSubtype (const char* value, size_t size);

    // API of field "u32PhotoSize"

    static const int kU32PhotoSize = 1;

    /**
     * Clears the field "u32PhotoSize".
     *
     * The field will be set to its default value. The hasU32PhotoSize()
     * method will return false.
     */
    inline void clearU32PhotoSize();

    /**
     * Checks whether the field "u32PhotoSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32PhotoSize()). Otherwise it will return false.
     */
    inline bool hasU32PhotoSize () const;

    /**
     * Returns the value of the member "u32PhotoSize".
     *
     * The size of the photo in bytes
     *
     * @return The value of the field "u32PhotoSize"
     */
    inline uint32 getU32PhotoSize () const;

    /**
     * Sets the value of the member "u32PhotoSize".
     *
     * The size of the photo in bytes
     *
     * @param u32PhotoSize The value which will be set
     */
    inline void setU32PhotoSize (uint32 u32PhotoSize_);

    static const DiPOGetMediaObjectAlbumArtInfoResult &getDefaultInstance();

private:

    inline void set_has_sMIMEImageSubtype ();

    inline void clear_has_sMIMEImageSubtype ();

    inline void set_has_u32PhotoSize ();

    inline void clear_has_u32PhotoSize ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _sMIMEImageSubtype;

    uint32 _u32PhotoSize;

};

/**
 * The start message of the method "DiPOGetMediaObjectAlbumArt"
 * The DiPOGetMediaObjectAlbumArt method is called to retrieve the album art
 * image, if it exists, for a particular media object. The image is returned
 * in a MIME-typed image format. To get the MIME type, as well as image size,
 * controllers first call the DiPOGetMediaObjectAlbumArtInfo Method, retrieve the
 * MIME type and size to set up the retrieval of the album art, then call
 * DiPOGetMediaObjectAlbumArt to retrieve the actual image data.
 */
class DiPOGetMediaObjectAlbumArtStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOGetMediaObjectAlbumArtStart ();

    /**
     * Copy constructor
     */
    inline  DiPOGetMediaObjectAlbumArtStart (const DiPOGetMediaObjectAlbumArtStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOGetMediaObjectAlbumArtStart (const ::std::string& sAlbumArt_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOGetMediaObjectAlbumArtStart();

    /**
     * Assignment operator
     */
    inline DiPOGetMediaObjectAlbumArtStart& operator = (const DiPOGetMediaObjectAlbumArtStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOGetMediaObjectAlbumArtStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOGetMediaObjectAlbumArtStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOGetMediaObjectAlbumArtStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOGetMediaObjectAlbumArtStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sAlbumArt"

    static const int kSAlbumArt = 0;

    /**
     * Clears the field "sAlbumArt".
     *
     * The field will be set to its default value. The hasSAlbumArt()
     * method will return false.
     */
    inline void clearSAlbumArt();

    /**
     * Checks whether the field "sAlbumArt" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAlbumArt()). Otherwise it will return false.
     */
    inline bool hasSAlbumArt () const;

    /**
     * Returns the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @return The value of the field "sAlbumArt"
     */
    inline const ::std::string& getSAlbumArt () const;

    /**
     * Retrieves the value of the field "sAlbumArt" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAlbumArt".
     */
    inline ::std::string& getSAlbumArtMutable ();

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const ::std::string& sAlbumArt_);

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const char* sAlbumArt_);

    /**
     * Sets the value of the member "sAlbumArt".
     *
     * Filename (URL) of the image to display for a given song
     *
     * @param sAlbumArt The value which will be set
     */
    inline void setSAlbumArt (const char* value, size_t size);

    static const DiPOGetMediaObjectAlbumArtStart &getDefaultInstance();

private:

    inline void set_has_sAlbumArt ();

    inline void clear_has_sAlbumArt ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _sAlbumArt;

};

/**
 * The result message of the method "DiPOGetMediaObjectAlbumArt"
 * The DiPOGetMediaObjectAlbumArt method is called to retrieve the album art
 * image, if it exists, for a particular media object. The image is returned
 * in a MIME-typed image format. To get the MIME type, as well as image size,
 * controllers first call the DiPOGetMediaObjectAlbumArtInfo Method, retrieve the
 * MIME type and size to set up the retrieval of the album art, then call
 * DiPOGetMediaObjectAlbumArt to retrieve the actual image data.
 */
class DiPOGetMediaObjectAlbumArtResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOGetMediaObjectAlbumArtResult ();

    /**
     * Copy constructor
     */
    inline  DiPOGetMediaObjectAlbumArtResult (const DiPOGetMediaObjectAlbumArtResult &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOGetMediaObjectAlbumArtResult (const ::mplay_appcontrol_fi_types::T_DiPOImageData& oImageData_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOGetMediaObjectAlbumArtResult();

    /**
     * Assignment operator
     */
    inline DiPOGetMediaObjectAlbumArtResult& operator = (const DiPOGetMediaObjectAlbumArtResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOGetMediaObjectAlbumArtResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOGetMediaObjectAlbumArtResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOGetMediaObjectAlbumArtResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOGetMediaObjectAlbumArtResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oImageData"

    static const int kOImageData = 0;

    /**
     * Clears the field "oImageData".
     *
     * The field will be set to its default value. The hasOImageData()
     * method will return false.
     */
    inline void clearOImageData();

    /**
     * Checks whether the field "oImageData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOImageData()). Otherwise it will return false.
     */
    inline bool hasOImageData () const;

    /**
     * Returns the value of the member "oImageData".
     *
     * An image
     *
     * @return The value of the field "oImageData"
     */
    inline const ::mplay_appcontrol_fi_types::T_DiPOImageData& getOImageData () const;

    /**
     * Retrieves the value of the field "oImageData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oImageData".
     */
    inline ::mplay_appcontrol_fi_types::T_DiPOImageData& getOImageDataMutable ();

    /**
     * Sets the value of the member "oImageData".
     *
     * An image
     *
     * @param oImageData The value which will be set
     */
    inline void setOImageData (const ::mplay_appcontrol_fi_types::T_DiPOImageData& oImageData_);

    static const DiPOGetMediaObjectAlbumArtResult &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_oImageData ();

    inline void clear_has_oImageData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::mplay_appcontrol_fi_types::T_DiPOImageData _oImageData;

};

/**
 * The start message of the method "DiPOTransferGPSData"
 * Transfers GPS data to DiPO device. If string is empty data is not transferred to apple device
 */
class DiPOTransferGPSDataStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOTransferGPSDataStart ();

    /**
     * Copy constructor
     */
    inline  DiPOTransferGPSDataStart (const DiPOTransferGPSDataStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOTransferGPSDataStart (uint8 u8DeviceTag_, const ::std::string& sDeviceUSBSerialNumber_, const ::std::string& sGPGGAData_, const ::std::string& sGPRMCData_, const ::std::string& sGPGSVData_, const ::std::string& sGPHDTData_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOTransferGPSDataStart();

    /**
     * Assignment operator
     */
    inline DiPOTransferGPSDataStart& operator = (const DiPOTransferGPSDataStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOTransferGPSDataStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOTransferGPSDataStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOTransferGPSDataStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOTransferGPSDataStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 0;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "sDeviceUSBSerialNumber"

    static const int kSDeviceUSBSerialNumber = 1;

    /**
     * Clears the field "sDeviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasSDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearSDeviceUSBSerialNumber();

    /**
     * Checks whether the field "sDeviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasSDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @return The value of the field "sDeviceUSBSerialNumber"
     */
    inline const ::std::string& getSDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "sDeviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceUSBSerialNumber".
     */
    inline ::std::string& getSDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* value, size_t size);

    // API of field "sGPGGAData"

    static const int kSGPGGAData = 2;

    /**
     * Clears the field "sGPGGAData".
     *
     * The field will be set to its default value. The hasSGPGGAData()
     * method will return false.
     */
    inline void clearSGPGGAData();

    /**
     * Checks whether the field "sGPGGAData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSGPGGAData()). Otherwise it will return false.
     */
    inline bool hasSGPGGAData () const;

    /**
     * Returns the value of the member "sGPGGAData".
     *
     * GPS data in GPGGA format as specified by apple
     *
     * @return The value of the field "sGPGGAData"
     */
    inline const ::std::string& getSGPGGAData () const;

    /**
     * Retrieves the value of the field "sGPGGAData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sGPGGAData".
     */
    inline ::std::string& getSGPGGADataMutable ();

    /**
     * Sets the value of the member "sGPGGAData".
     *
     * GPS data in GPGGA format as specified by apple
     *
     * @param sGPGGAData The value which will be set
     */
    inline void setSGPGGAData (const ::std::string& sGPGGAData_);

    /**
     * Sets the value of the member "sGPGGAData".
     *
     * GPS data in GPGGA format as specified by apple
     *
     * @param sGPGGAData The value which will be set
     */
    inline void setSGPGGAData (const char* sGPGGAData_);

    /**
     * Sets the value of the member "sGPGGAData".
     *
     * GPS data in GPGGA format as specified by apple
     *
     * @param sGPGGAData The value which will be set
     */
    inline void setSGPGGAData (const char* value, size_t size);

    // API of field "sGPRMCData"

    static const int kSGPRMCData = 3;

    /**
     * Clears the field "sGPRMCData".
     *
     * The field will be set to its default value. The hasSGPRMCData()
     * method will return false.
     */
    inline void clearSGPRMCData();

    /**
     * Checks whether the field "sGPRMCData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSGPRMCData()). Otherwise it will return false.
     */
    inline bool hasSGPRMCData () const;

    /**
     * Returns the value of the member "sGPRMCData".
     *
     * GPS data in GPRMC format as specified by apple
     *
     * @return The value of the field "sGPRMCData"
     */
    inline const ::std::string& getSGPRMCData () const;

    /**
     * Retrieves the value of the field "sGPRMCData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sGPRMCData".
     */
    inline ::std::string& getSGPRMCDataMutable ();

    /**
     * Sets the value of the member "sGPRMCData".
     *
     * GPS data in GPRMC format as specified by apple
     *
     * @param sGPRMCData The value which will be set
     */
    inline void setSGPRMCData (const ::std::string& sGPRMCData_);

    /**
     * Sets the value of the member "sGPRMCData".
     *
     * GPS data in GPRMC format as specified by apple
     *
     * @param sGPRMCData The value which will be set
     */
    inline void setSGPRMCData (const char* sGPRMCData_);

    /**
     * Sets the value of the member "sGPRMCData".
     *
     * GPS data in GPRMC format as specified by apple
     *
     * @param sGPRMCData The value which will be set
     */
    inline void setSGPRMCData (const char* value, size_t size);

    // API of field "sGPGSVData"

    static const int kSGPGSVData = 4;

    /**
     * Clears the field "sGPGSVData".
     *
     * The field will be set to its default value. The hasSGPGSVData()
     * method will return false.
     */
    inline void clearSGPGSVData();

    /**
     * Checks whether the field "sGPGSVData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSGPGSVData()). Otherwise it will return false.
     */
    inline bool hasSGPGSVData () const;

    /**
     * Returns the value of the member "sGPGSVData".
     *
     * GPS data in GPGSV format as specified by apple
     *
     * @return The value of the field "sGPGSVData"
     */
    inline const ::std::string& getSGPGSVData () const;

    /**
     * Retrieves the value of the field "sGPGSVData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sGPGSVData".
     */
    inline ::std::string& getSGPGSVDataMutable ();

    /**
     * Sets the value of the member "sGPGSVData".
     *
     * GPS data in GPGSV format as specified by apple
     *
     * @param sGPGSVData The value which will be set
     */
    inline void setSGPGSVData (const ::std::string& sGPGSVData_);

    /**
     * Sets the value of the member "sGPGSVData".
     *
     * GPS data in GPGSV format as specified by apple
     *
     * @param sGPGSVData The value which will be set
     */
    inline void setSGPGSVData (const char* sGPGSVData_);

    /**
     * Sets the value of the member "sGPGSVData".
     *
     * GPS data in GPGSV format as specified by apple
     *
     * @param sGPGSVData The value which will be set
     */
    inline void setSGPGSVData (const char* value, size_t size);

    // API of field "sGPHDTData"

    static const int kSGPHDTData = 5;

    /**
     * Clears the field "sGPHDTData".
     *
     * The field will be set to its default value. The hasSGPHDTData()
     * method will return false.
     */
    inline void clearSGPHDTData();

    /**
     * Checks whether the field "sGPHDTData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSGPHDTData()). Otherwise it will return false.
     */
    inline bool hasSGPHDTData () const;

    /**
     * Returns the value of the member "sGPHDTData".
     *
     * GPS data in GPHDT format as specified by apple
     *
     * @return The value of the field "sGPHDTData"
     */
    inline const ::std::string& getSGPHDTData () const;

    /**
     * Retrieves the value of the field "sGPHDTData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sGPHDTData".
     */
    inline ::std::string& getSGPHDTDataMutable ();

    /**
     * Sets the value of the member "sGPHDTData".
     *
     * GPS data in GPHDT format as specified by apple
     *
     * @param sGPHDTData The value which will be set
     */
    inline void setSGPHDTData (const ::std::string& sGPHDTData_);

    /**
     * Sets the value of the member "sGPHDTData".
     *
     * GPS data in GPHDT format as specified by apple
     *
     * @param sGPHDTData The value which will be set
     */
    inline void setSGPHDTData (const char* sGPHDTData_);

    /**
     * Sets the value of the member "sGPHDTData".
     *
     * GPS data in GPHDT format as specified by apple
     *
     * @param sGPHDTData The value which will be set
     */
    inline void setSGPHDTData (const char* value, size_t size);

    static const DiPOTransferGPSDataStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_sDeviceUSBSerialNumber ();

    inline void clear_has_sDeviceUSBSerialNumber ();

    inline void set_has_sGPGGAData ();

    inline void clear_has_sGPGGAData ();

    inline void set_has_sGPRMCData ();

    inline void clear_has_sGPRMCData ();

    inline void set_has_sGPGSVData ();

    inline void clear_has_sGPGSVData ();

    inline void set_has_sGPHDTData ();

    inline void clear_has_sGPHDTData ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint8 _u8DeviceTag;

    ::std::string _sDeviceUSBSerialNumber;

    ::std::string _sGPGGAData;

    ::std::string _sGPRMCData;

    ::std::string _sGPGSVData;

    ::std::string _sGPHDTData;

};

/**
 * The result message of the method "DiPOTransferGPSData"
 * Transfers GPS data to DiPO device. If string is empty data is not transferred to apple device
 */
class DiPOTransferGPSDataResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOTransferGPSDataResult ();

    /**
     * Copy constructor
     */
    inline  DiPOTransferGPSDataResult (const DiPOTransferGPSDataResult &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOTransferGPSDataResult (::mplay_appcontrol_fi_types::T_e8_DiPOResponse e8DiPOResponse_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOTransferGPSDataResult();

    /**
     * Assignment operator
     */
    inline DiPOTransferGPSDataResult& operator = (const DiPOTransferGPSDataResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOTransferGPSDataResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOTransferGPSDataResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOTransferGPSDataResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOTransferGPSDataResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DiPOResponse"

    static const int kE8DiPOResponse = 0;

    /**
     * Clears the field "e8DiPOResponse".
     *
     * The field will be set to its default value. The hasE8DiPOResponse()
     * method will return false.
     */
    inline void clearE8DiPOResponse();

    /**
     * Checks whether the field "e8DiPOResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DiPOResponse()). Otherwise it will return false.
     */
    inline bool hasE8DiPOResponse () const;

    /**
     * Returns the value of the member "e8DiPOResponse".
     *
     * Result of the operation
     *
     * @return The value of the field "e8DiPOResponse"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_DiPOResponse getE8DiPOResponse () const;

    /**
     * Sets the value of the member "e8DiPOResponse".
     *
     * Result of the operation
     *
     * @param e8DiPOResponse The value which will be set
     */
    inline void setE8DiPOResponse (::mplay_appcontrol_fi_types::T_e8_DiPOResponse e8DiPOResponse_);

    static const DiPOTransferGPSDataResult &getDefaultInstance();

private:

    inline void set_has_e8DiPOResponse ();

    inline void clear_has_e8DiPOResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::mplay_appcontrol_fi_types::T_e8_DiPOResponse _e8DiPOResponse;

};

/**
 * The start message of the method "DiPOTransferDRData"
 * Transfers Dead Reckoning sensor data to DiPO device
 */
class DiPOTransferDRDataStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOTransferDRDataStart ();

    /**
     * Copy constructor
     */
    inline  DiPOTransferDRDataStart (const DiPOTransferDRDataStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOTransferDRDataStart (uint8 u8DeviceTag_, const ::std::string& sDeviceUSBSerialNumber_, const ::std::string& sPASCDData_, const ::std::string& sPAGCDData_, const ::std::string& sPAACDData_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOTransferDRDataStart();

    /**
     * Assignment operator
     */
    inline DiPOTransferDRDataStart& operator = (const DiPOTransferDRDataStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOTransferDRDataStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOTransferDRDataStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOTransferDRDataStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOTransferDRDataStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 0;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "sDeviceUSBSerialNumber"

    static const int kSDeviceUSBSerialNumber = 1;

    /**
     * Clears the field "sDeviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasSDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearSDeviceUSBSerialNumber();

    /**
     * Checks whether the field "sDeviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasSDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @return The value of the field "sDeviceUSBSerialNumber"
     */
    inline const ::std::string& getSDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "sDeviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceUSBSerialNumber".
     */
    inline ::std::string& getSDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* value, size_t size);

    // API of field "sPASCDData"

    static const int kSPASCDData = 2;

    /**
     * Clears the field "sPASCDData".
     *
     * The field will be set to its default value. The hasSPASCDData()
     * method will return false.
     */
    inline void clearSPASCDData();

    /**
     * Checks whether the field "sPASCDData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPASCDData()). Otherwise it will return false.
     */
    inline bool hasSPASCDData () const;

    /**
     * Returns the value of the member "sPASCDData".
     *
     * Vehicle speed data arrang in the format as specified by apple
     *
     * @return The value of the field "sPASCDData"
     */
    inline const ::std::string& getSPASCDData () const;

    /**
     * Retrieves the value of the field "sPASCDData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPASCDData".
     */
    inline ::std::string& getSPASCDDataMutable ();

    /**
     * Sets the value of the member "sPASCDData".
     *
     * Vehicle speed data arrang in the format as specified by apple
     *
     * @param sPASCDData The value which will be set
     */
    inline void setSPASCDData (const ::std::string& sPASCDData_);

    /**
     * Sets the value of the member "sPASCDData".
     *
     * Vehicle speed data arrang in the format as specified by apple
     *
     * @param sPASCDData The value which will be set
     */
    inline void setSPASCDData (const char* sPASCDData_);

    /**
     * Sets the value of the member "sPASCDData".
     *
     * Vehicle speed data arrang in the format as specified by apple
     *
     * @param sPASCDData The value which will be set
     */
    inline void setSPASCDData (const char* value, size_t size);

    // API of field "sPAGCDData"

    static const int kSPAGCDData = 3;

    /**
     * Clears the field "sPAGCDData".
     *
     * The field will be set to its default value. The hasSPAGCDData()
     * method will return false.
     */
    inline void clearSPAGCDData();

    /**
     * Checks whether the field "sPAGCDData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPAGCDData()). Otherwise it will return false.
     */
    inline bool hasSPAGCDData () const;

    /**
     * Returns the value of the member "sPAGCDData".
     *
     * Vehicle gyro data arrang in the format as specified by apple
     *
     * @return The value of the field "sPAGCDData"
     */
    inline const ::std::string& getSPAGCDData () const;

    /**
     * Retrieves the value of the field "sPAGCDData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPAGCDData".
     */
    inline ::std::string& getSPAGCDDataMutable ();

    /**
     * Sets the value of the member "sPAGCDData".
     *
     * Vehicle gyro data arrang in the format as specified by apple
     *
     * @param sPAGCDData The value which will be set
     */
    inline void setSPAGCDData (const ::std::string& sPAGCDData_);

    /**
     * Sets the value of the member "sPAGCDData".
     *
     * Vehicle gyro data arrang in the format as specified by apple
     *
     * @param sPAGCDData The value which will be set
     */
    inline void setSPAGCDData (const char* sPAGCDData_);

    /**
     * Sets the value of the member "sPAGCDData".
     *
     * Vehicle gyro data arrang in the format as specified by apple
     *
     * @param sPAGCDData The value which will be set
     */
    inline void setSPAGCDData (const char* value, size_t size);

    // API of field "sPAACDData"

    static const int kSPAACDData = 4;

    /**
     * Clears the field "sPAACDData".
     *
     * The field will be set to its default value. The hasSPAACDData()
     * method will return false.
     */
    inline void clearSPAACDData();

    /**
     * Checks whether the field "sPAACDData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPAACDData()). Otherwise it will return false.
     */
    inline bool hasSPAACDData () const;

    /**
     * Returns the value of the member "sPAACDData".
     *
     * Vehicle accelerometer data arrang in the format as specified by apple
     *
     * @return The value of the field "sPAACDData"
     */
    inline const ::std::string& getSPAACDData () const;

    /**
     * Retrieves the value of the field "sPAACDData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPAACDData".
     */
    inline ::std::string& getSPAACDDataMutable ();

    /**
     * Sets the value of the member "sPAACDData".
     *
     * Vehicle accelerometer data arrang in the format as specified by apple
     *
     * @param sPAACDData The value which will be set
     */
    inline void setSPAACDData (const ::std::string& sPAACDData_);

    /**
     * Sets the value of the member "sPAACDData".
     *
     * Vehicle accelerometer data arrang in the format as specified by apple
     *
     * @param sPAACDData The value which will be set
     */
    inline void setSPAACDData (const char* sPAACDData_);

    /**
     * Sets the value of the member "sPAACDData".
     *
     * Vehicle accelerometer data arrang in the format as specified by apple
     *
     * @param sPAACDData The value which will be set
     */
    inline void setSPAACDData (const char* value, size_t size);

    static const DiPOTransferDRDataStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_sDeviceUSBSerialNumber ();

    inline void clear_has_sDeviceUSBSerialNumber ();

    inline void set_has_sPASCDData ();

    inline void clear_has_sPASCDData ();

    inline void set_has_sPAGCDData ();

    inline void clear_has_sPAGCDData ();

    inline void set_has_sPAACDData ();

    inline void clear_has_sPAACDData ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint8 _u8DeviceTag;

    ::std::string _sDeviceUSBSerialNumber;

    ::std::string _sPASCDData;

    ::std::string _sPAGCDData;

    ::std::string _sPAACDData;

};

/**
 * The result message of the method "DiPOTransferDRData"
 * Transfers Dead Reckoning sensor data to DiPO device
 */
class DiPOTransferDRDataResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOTransferDRDataResult ();

    /**
     * Copy constructor
     */
    inline  DiPOTransferDRDataResult (const DiPOTransferDRDataResult &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOTransferDRDataResult (::mplay_appcontrol_fi_types::T_e8_DiPOResponse e8DiPOResponse_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOTransferDRDataResult();

    /**
     * Assignment operator
     */
    inline DiPOTransferDRDataResult& operator = (const DiPOTransferDRDataResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOTransferDRDataResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOTransferDRDataResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOTransferDRDataResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOTransferDRDataResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DiPOResponse"

    static const int kE8DiPOResponse = 0;

    /**
     * Clears the field "e8DiPOResponse".
     *
     * The field will be set to its default value. The hasE8DiPOResponse()
     * method will return false.
     */
    inline void clearE8DiPOResponse();

    /**
     * Checks whether the field "e8DiPOResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DiPOResponse()). Otherwise it will return false.
     */
    inline bool hasE8DiPOResponse () const;

    /**
     * Returns the value of the member "e8DiPOResponse".
     *
     * Result of the operation
     *
     * @return The value of the field "e8DiPOResponse"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_DiPOResponse getE8DiPOResponse () const;

    /**
     * Sets the value of the member "e8DiPOResponse".
     *
     * Result of the operation
     *
     * @param e8DiPOResponse The value which will be set
     */
    inline void setE8DiPOResponse (::mplay_appcontrol_fi_types::T_e8_DiPOResponse e8DiPOResponse_);

    static const DiPOTransferDRDataResult &getDefaultInstance();

private:

    inline void set_has_e8DiPOResponse ();

    inline void clear_has_e8DiPOResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::mplay_appcontrol_fi_types::T_e8_DiPOResponse _e8DiPOResponse;

};

/**
 * The start message of the method "DiPORequestAudioDevice"
 * Request for DiPO Audio device name.
 */
class DiPORequestAudioDeviceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPORequestAudioDeviceStart ();

    /**
     * Copy constructor
     */
    inline  DiPORequestAudioDeviceStart (const DiPORequestAudioDeviceStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPORequestAudioDeviceStart (uint8 u8DeviceTag_);

    /**
     * Destructor
     */
    inline virtual  ~DiPORequestAudioDeviceStart();

    /**
     * Assignment operator
     */
    inline DiPORequestAudioDeviceStart& operator = (const DiPORequestAudioDeviceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPORequestAudioDeviceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPORequestAudioDeviceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPORequestAudioDeviceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPORequestAudioDeviceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 0;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    static const DiPORequestAudioDeviceStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DeviceTag;

};

/**
 * The result message of the method "DiPORequestAudioDevice"
 * Request for DiPO Audio device name.
 */
class DiPORequestAudioDeviceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPORequestAudioDeviceResult ();

    /**
     * Copy constructor
     */
    inline  DiPORequestAudioDeviceResult (const DiPORequestAudioDeviceResult &rhs);

    /**
     * All fields constructor
     */
    inline  DiPORequestAudioDeviceResult (const ::std::string& sDeviceName_, ::mplay_appcontrol_fi_types::T_e8_AudioError e8Error_);

    /**
     * Destructor
     */
    inline virtual  ~DiPORequestAudioDeviceResult();

    /**
     * Assignment operator
     */
    inline DiPORequestAudioDeviceResult& operator = (const DiPORequestAudioDeviceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPORequestAudioDeviceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPORequestAudioDeviceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPORequestAudioDeviceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPORequestAudioDeviceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sDeviceName"

    static const int kSDeviceName = 0;

    /**
     * Clears the field "sDeviceName".
     *
     * The field will be set to its default value. The hasSDeviceName()
     * method will return false.
     */
    inline void clearSDeviceName();

    /**
     * Checks whether the field "sDeviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceName()). Otherwise it will return false.
     */
    inline bool hasSDeviceName () const;

    /**
     * Returns the value of the member "sDeviceName".
     *
     * ALSA device Name
     *
     * @return The value of the field "sDeviceName"
     */
    inline const ::std::string& getSDeviceName () const;

    /**
     * Retrieves the value of the field "sDeviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceName".
     */
    inline ::std::string& getSDeviceNameMutable ();

    /**
     * Sets the value of the member "sDeviceName".
     *
     * ALSA device Name
     *
     * @param sDeviceName The value which will be set
     */
    inline void setSDeviceName (const ::std::string& sDeviceName_);

    /**
     * Sets the value of the member "sDeviceName".
     *
     * ALSA device Name
     *
     * @param sDeviceName The value which will be set
     */
    inline void setSDeviceName (const char* sDeviceName_);

    /**
     * Sets the value of the member "sDeviceName".
     *
     * ALSA device Name
     *
     * @param sDeviceName The value which will be set
     */
    inline void setSDeviceName (const char* value, size_t size);

    // API of field "e8Error"

    static const int kE8Error = 1;

    /**
     * Clears the field "e8Error".
     *
     * The field will be set to its default value. The hasE8Error()
     * method will return false.
     */
    inline void clearE8Error();

    /**
     * Checks whether the field "e8Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Error()). Otherwise it will return false.
     */
    inline bool hasE8Error () const;

    /**
     * Returns the value of the member "e8Error".
     *
     * Audio Activation Error
     *
     * @return The value of the field "e8Error"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_AudioError getE8Error () const;

    /**
     * Sets the value of the member "e8Error".
     *
     * Audio Activation Error
     *
     * @param e8Error The value which will be set
     */
    inline void setE8Error (::mplay_appcontrol_fi_types::T_e8_AudioError e8Error_);

    static const DiPORequestAudioDeviceResult &getDefaultInstance();

private:

    inline void set_has_sDeviceName ();

    inline void clear_has_sDeviceName ();

    inline void set_has_e8Error ();

    inline void clear_has_e8Error ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _sDeviceName;

    ::mplay_appcontrol_fi_types::T_e8_AudioError _e8Error;

};

/**
 * The start message of the method "DiPOReleaseAudioDevice"
 * Request to release audio device.
 */
class DiPOReleaseAudioDeviceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOReleaseAudioDeviceStart ();

    /**
     * Copy constructor
     */
    inline  DiPOReleaseAudioDeviceStart (const DiPOReleaseAudioDeviceStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOReleaseAudioDeviceStart (uint8 u8DeviceTag_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOReleaseAudioDeviceStart();

    /**
     * Assignment operator
     */
    inline DiPOReleaseAudioDeviceStart& operator = (const DiPOReleaseAudioDeviceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOReleaseAudioDeviceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOReleaseAudioDeviceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOReleaseAudioDeviceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOReleaseAudioDeviceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 0;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    static const DiPOReleaseAudioDeviceStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DeviceTag;

};

/**
 * The result message of the method "DiPOReleaseAudioDevice"
 * Request to release audio device.
 */
class DiPOReleaseAudioDeviceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOReleaseAudioDeviceResult ();

    /**
     * Copy constructor
     */
    inline  DiPOReleaseAudioDeviceResult (const DiPOReleaseAudioDeviceResult &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOReleaseAudioDeviceResult (::mplay_appcontrol_fi_types::T_e8_AudioError e8Error_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOReleaseAudioDeviceResult();

    /**
     * Assignment operator
     */
    inline DiPOReleaseAudioDeviceResult& operator = (const DiPOReleaseAudioDeviceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOReleaseAudioDeviceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOReleaseAudioDeviceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOReleaseAudioDeviceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOReleaseAudioDeviceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Error"

    static const int kE8Error = 0;

    /**
     * Clears the field "e8Error".
     *
     * The field will be set to its default value. The hasE8Error()
     * method will return false.
     */
    inline void clearE8Error();

    /**
     * Checks whether the field "e8Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Error()). Otherwise it will return false.
     */
    inline bool hasE8Error () const;

    /**
     * Returns the value of the member "e8Error".
     *
     * Audio Deactivation Error
     *
     * @return The value of the field "e8Error"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_AudioError getE8Error () const;

    /**
     * Sets the value of the member "e8Error".
     *
     * Audio Deactivation Error
     *
     * @param e8Error The value which will be set
     */
    inline void setE8Error (::mplay_appcontrol_fi_types::T_e8_AudioError e8Error_);

    static const DiPOReleaseAudioDeviceResult &getDefaultInstance();

private:

    inline void set_has_e8Error ();

    inline void clear_has_e8Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::mplay_appcontrol_fi_types::T_e8_AudioError _e8Error;

};

/**
 * The start message of the method "DiPORequestPlaybackAction"
 * Requests the playback action for a certain devicve
 */
class DiPORequestPlaybackActionStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPORequestPlaybackActionStart ();

    /**
     * Copy constructor
     */
    inline  DiPORequestPlaybackActionStart (const DiPORequestPlaybackActionStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPORequestPlaybackActionStart (uint8 u8DeviceTag_, ::mplay_appcontrol_fi_types::T_e8_DiPOPlaypackAction e8Action_, uint8 u8NextPrevSkipCount_);

    /**
     * Destructor
     */
    inline virtual  ~DiPORequestPlaybackActionStart();

    /**
     * Assignment operator
     */
    inline DiPORequestPlaybackActionStart& operator = (const DiPORequestPlaybackActionStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPORequestPlaybackActionStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPORequestPlaybackActionStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPORequestPlaybackActionStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPORequestPlaybackActionStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 0;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the device.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    // API of field "e8Action"

    static const int kE8Action = 1;

    /**
     * Clears the field "e8Action".
     *
     * The field will be set to its default value. The hasE8Action()
     * method will return false.
     */
    inline void clearE8Action();

    /**
     * Checks whether the field "e8Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Action()). Otherwise it will return false.
     */
    inline bool hasE8Action () const;

    /**
     * Returns the value of the member "e8Action".
     *
     * Specifies the playback action to request.
     *
     * @return The value of the field "e8Action"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_DiPOPlaypackAction getE8Action () const;

    /**
     * Sets the value of the member "e8Action".
     *
     * Specifies the playback action to request.
     *
     * @param e8Action The value which will be set
     */
    inline void setE8Action (::mplay_appcontrol_fi_types::T_e8_DiPOPlaypackAction e8Action_);

    // API of field "u8NextPrevSkipCount"

    static const int kU8NextPrevSkipCount = 2;

    /**
     * Clears the field "u8NextPrevSkipCount".
     *
     * The field will be set to its default value. The hasU8NextPrevSkipCount()
     * method will return false.
     */
    inline void clearU8NextPrevSkipCount();

    /**
     * Checks whether the field "u8NextPrevSkipCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NextPrevSkipCount()). Otherwise it will return false.
     */
    inline bool hasU8NextPrevSkipCount () const;

    /**
     * Returns the value of the member "u8NextPrevSkipCount".
     *
     * The number of tracks to skip on a next or previous action.
     * Note that this parameter is unsigned and must be greater/equal 1.
     * This parameter is only defined for Next or Previous.
     * For the other Actions, it is not defined and shall be defaulted to 1.
     *
     * @return The value of the field "u8NextPrevSkipCount"
     */
    inline uint8 getU8NextPrevSkipCount () const;

    /**
     * Sets the value of the member "u8NextPrevSkipCount".
     *
     * The number of tracks to skip on a next or previous action.
     * Note that this parameter is unsigned and must be greater/equal 1.
     * This parameter is only defined for Next or Previous.
     * For the other Actions, it is not defined and shall be defaulted to 1.
     *
     * @param u8NextPrevSkipCount The value which will be set
     */
    inline void setU8NextPrevSkipCount (uint8 u8NextPrevSkipCount_);

    static const DiPORequestPlaybackActionStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    inline void set_has_e8Action ();

    inline void clear_has_e8Action ();

    inline void set_has_u8NextPrevSkipCount ();

    inline void clear_has_u8NextPrevSkipCount ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8DeviceTag;

    ::mplay_appcontrol_fi_types::T_e8_DiPOPlaypackAction _e8Action;

    uint8 _u8NextPrevSkipCount;

};

/**
 * The start message of the method "DiPOStartIAP2OverCarPlayWifi"
 * Requests to Start iAP2 session over Carplay Wifi
 */
class DiPOStartIAP2OverCarPlayWifiStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOStartIAP2OverCarPlayWifiStart ();

    /**
     * Copy constructor
     */
    inline  DiPOStartIAP2OverCarPlayWifiStart (const DiPOStartIAP2OverCarPlayWifiStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOStartIAP2OverCarPlayWifiStart (const ::std::string& sDeviceBTMacAddress_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOStartIAP2OverCarPlayWifiStart();

    /**
     * Assignment operator
     */
    inline DiPOStartIAP2OverCarPlayWifiStart& operator = (const DiPOStartIAP2OverCarPlayWifiStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOStartIAP2OverCarPlayWifiStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOStartIAP2OverCarPlayWifiStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOStartIAP2OverCarPlayWifiStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOStartIAP2OverCarPlayWifiStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sDeviceBTMacAddress"

    static const int kSDeviceBTMacAddress = 0;

    /**
     * Clears the field "sDeviceBTMacAddress".
     *
     * The field will be set to its default value. The hasSDeviceBTMacAddress()
     * method will return false.
     */
    inline void clearSDeviceBTMacAddress();

    /**
     * Checks whether the field "sDeviceBTMacAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceBTMacAddress()). Otherwise it will return false.
     */
    inline bool hasSDeviceBTMacAddress () const;

    /**
     * Returns the value of the member "sDeviceBTMacAddress".
     *
     * BT Mac Address of the Apple device.
     *
     * @return The value of the field "sDeviceBTMacAddress"
     */
    inline const ::std::string& getSDeviceBTMacAddress () const;

    /**
     * Retrieves the value of the field "sDeviceBTMacAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceBTMacAddress".
     */
    inline ::std::string& getSDeviceBTMacAddressMutable ();

    /**
     * Sets the value of the member "sDeviceBTMacAddress".
     *
     * BT Mac Address of the Apple device.
     *
     * @param sDeviceBTMacAddress The value which will be set
     */
    inline void setSDeviceBTMacAddress (const ::std::string& sDeviceBTMacAddress_);

    /**
     * Sets the value of the member "sDeviceBTMacAddress".
     *
     * BT Mac Address of the Apple device.
     *
     * @param sDeviceBTMacAddress The value which will be set
     */
    inline void setSDeviceBTMacAddress (const char* sDeviceBTMacAddress_);

    /**
     * Sets the value of the member "sDeviceBTMacAddress".
     *
     * BT Mac Address of the Apple device.
     *
     * @param sDeviceBTMacAddress The value which will be set
     */
    inline void setSDeviceBTMacAddress (const char* value, size_t size);

    static const DiPOStartIAP2OverCarPlayWifiStart &getDefaultInstance();

private:

    inline void set_has_sDeviceBTMacAddress ();

    inline void clear_has_sDeviceBTMacAddress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _sDeviceBTMacAddress;

};

/**
 * The start message of the method "DiPOStartRouteGuidance"
 * StartRouteGuidanceUpdate must be sent when accessory is ready to display navigation route guidance
 */
class DiPOStartRouteGuidanceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOStartRouteGuidanceStart ();

    /**
     * Copy constructor
     */
    inline  DiPOStartRouteGuidanceStart (const DiPOStartRouteGuidanceStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOStartRouteGuidanceStart (const ::std::string& sDeviceUSBSerialNumber_, uint16 u16RouteGuidanceDisplayComponentID_, bool SourceName_, bool SourceSupportsRouteGuidance_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOStartRouteGuidanceStart();

    /**
     * Assignment operator
     */
    inline DiPOStartRouteGuidanceStart& operator = (const DiPOStartRouteGuidanceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOStartRouteGuidanceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOStartRouteGuidanceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOStartRouteGuidanceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOStartRouteGuidanceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sDeviceUSBSerialNumber"

    static const int kSDeviceUSBSerialNumber = 0;

    /**
     * Clears the field "sDeviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasSDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearSDeviceUSBSerialNumber();

    /**
     * Checks whether the field "sDeviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasSDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @return The value of the field "sDeviceUSBSerialNumber"
     */
    inline const ::std::string& getSDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "sDeviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceUSBSerialNumber".
     */
    inline ::std::string& getSDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* value, size_t size);

    // API of field "u16RouteGuidanceDisplayComponentID"

    static const int kU16RouteGuidanceDisplayComponentID = 1;

    /**
     * Clears the field "u16RouteGuidanceDisplayComponentID".
     *
     * The field will be set to its default value. The hasU16RouteGuidanceDisplayComponentID()
     * method will return false.
     */
    inline void clearU16RouteGuidanceDisplayComponentID();

    /**
     * Checks whether the field "u16RouteGuidanceDisplayComponentID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RouteGuidanceDisplayComponentID()). Otherwise it will return false.
     */
    inline bool hasU16RouteGuidanceDisplayComponentID () const;

    /**
     * Returns the value of the member "u16RouteGuidanceDisplayComponentID".
     *
     * If none are specified, assume all such components are being started.
     *
     * @return The value of the field "u16RouteGuidanceDisplayComponentID"
     */
    inline uint16 getU16RouteGuidanceDisplayComponentID () const;

    /**
     * Sets the value of the member "u16RouteGuidanceDisplayComponentID".
     *
     * If none are specified, assume all such components are being started.
     *
     * @param u16RouteGuidanceDisplayComponentID The value which will be set
     */
    inline void setU16RouteGuidanceDisplayComponentID (uint16 u16RouteGuidanceDisplayComponentID_);

    // API of field "SourceName"

    static const int kSourceName = 2;

    /**
     * Clears the field "SourceName".
     *
     * The field will be set to its default value. The hasSourceName()
     * method will return false.
     */
    inline void clearSourceName();

    /**
     * Checks whether the field "SourceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceName()). Otherwise it will return false.
     */
    inline bool hasSourceName () const;

    /**
     * Returns the value of the member "SourceName".
     *
     * Must be included to receive SourceName in RouteGuidanceUpdate.
     * If SourceName is TRUE, we will receive name of application providing turn-by-turn information
     * in Carplay, for display purposes only. Eg: XL Gadget
     *
     * @return The value of the field "SourceName"
     */
    inline bool getSourceName () const;

    /**
     * Sets the value of the member "SourceName".
     *
     * Must be included to receive SourceName in RouteGuidanceUpdate.
     * If SourceName is TRUE, we will receive name of application providing turn-by-turn information
     * in Carplay, for display purposes only. Eg: XL Gadget
     *
     * @param SourceName The value which will be set
     */
    inline void setSourceName (bool SourceName_);

    // API of field "SourceSupportsRouteGuidance"

    static const int kSourceSupportsRouteGuidance = 3;

    /**
     * Clears the field "SourceSupportsRouteGuidance".
     *
     * The field will be set to its default value. The hasSourceSupportsRouteGuidance()
     * method will return false.
     */
    inline void clearSourceSupportsRouteGuidance();

    /**
     * Checks whether the field "SourceSupportsRouteGuidance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceSupportsRouteGuidance()). Otherwise it will return false.
     */
    inline bool hasSourceSupportsRouteGuidance () const;

    /**
     * Returns the value of the member "SourceSupportsRouteGuidance".
     *
     * Must be included to receive SourceSupportsRouteGuidance in RouteGuidanceUpdate.
     *
     * @return The value of the field "SourceSupportsRouteGuidance"
     */
    inline bool getSourceSupportsRouteGuidance () const;

    /**
     * Sets the value of the member "SourceSupportsRouteGuidance".
     *
     * Must be included to receive SourceSupportsRouteGuidance in RouteGuidanceUpdate.
     *
     * @param SourceSupportsRouteGuidance The value which will be set
     */
    inline void setSourceSupportsRouteGuidance (bool SourceSupportsRouteGuidance_);

    static const DiPOStartRouteGuidanceStart &getDefaultInstance();

private:

    inline void set_has_sDeviceUSBSerialNumber ();

    inline void clear_has_sDeviceUSBSerialNumber ();

    inline void set_has_u16RouteGuidanceDisplayComponentID ();

    inline void clear_has_u16RouteGuidanceDisplayComponentID ();

    inline void set_has_SourceName ();

    inline void clear_has_SourceName ();

    inline void set_has_SourceSupportsRouteGuidance ();

    inline void clear_has_SourceSupportsRouteGuidance ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _sDeviceUSBSerialNumber;

    uint16 _u16RouteGuidanceDisplayComponentID;

    bool _SourceName;

    bool _SourceSupportsRouteGuidance;

};

/**
 * The start message of the method "DiPOStopRouteGuidance"
 * StopRouteGuidanceUpdate must be sent when navigation route guidance is not being displayed by the accessory.
 */
class DiPOStopRouteGuidanceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOStopRouteGuidanceStart ();

    /**
     * Copy constructor
     */
    inline  DiPOStopRouteGuidanceStart (const DiPOStopRouteGuidanceStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOStopRouteGuidanceStart (const ::std::string& sDeviceUSBSerialNumber_, uint16 u16RouteGuidanceDisplayComponentID_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOStopRouteGuidanceStart();

    /**
     * Assignment operator
     */
    inline DiPOStopRouteGuidanceStart& operator = (const DiPOStopRouteGuidanceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOStopRouteGuidanceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOStopRouteGuidanceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOStopRouteGuidanceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOStopRouteGuidanceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sDeviceUSBSerialNumber"

    static const int kSDeviceUSBSerialNumber = 0;

    /**
     * Clears the field "sDeviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasSDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearSDeviceUSBSerialNumber();

    /**
     * Checks whether the field "sDeviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasSDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @return The value of the field "sDeviceUSBSerialNumber"
     */
    inline const ::std::string& getSDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "sDeviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceUSBSerialNumber".
     */
    inline ::std::string& getSDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* value, size_t size);

    // API of field "u16RouteGuidanceDisplayComponentID"

    static const int kU16RouteGuidanceDisplayComponentID = 1;

    /**
     * Clears the field "u16RouteGuidanceDisplayComponentID".
     *
     * The field will be set to its default value. The hasU16RouteGuidanceDisplayComponentID()
     * method will return false.
     */
    inline void clearU16RouteGuidanceDisplayComponentID();

    /**
     * Checks whether the field "u16RouteGuidanceDisplayComponentID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RouteGuidanceDisplayComponentID()). Otherwise it will return false.
     */
    inline bool hasU16RouteGuidanceDisplayComponentID () const;

    /**
     * Returns the value of the member "u16RouteGuidanceDisplayComponentID".
     *
     * If none are specified, assume all such components are to be stopped.
     *
     * @return The value of the field "u16RouteGuidanceDisplayComponentID"
     */
    inline uint16 getU16RouteGuidanceDisplayComponentID () const;

    /**
     * Sets the value of the member "u16RouteGuidanceDisplayComponentID".
     *
     * If none are specified, assume all such components are to be stopped.
     *
     * @param u16RouteGuidanceDisplayComponentID The value which will be set
     */
    inline void setU16RouteGuidanceDisplayComponentID (uint16 u16RouteGuidanceDisplayComponentID_);

    static const DiPOStopRouteGuidanceStart &getDefaultInstance();

private:

    inline void set_has_sDeviceUSBSerialNumber ();

    inline void clear_has_sDeviceUSBSerialNumber ();

    inline void set_has_u16RouteGuidanceDisplayComponentID ();

    inline void clear_has_u16RouteGuidanceDisplayComponentID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _sDeviceUSBSerialNumber;

    uint16 _u16RouteGuidanceDisplayComponentID;

};

/**
 * The start message of the method "SwapCalls"
 * Swap current call with on hold call.
 * Deprecated : Use DiPOSwapCalls
 */
class SwapCallsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SwapCallsStart ();

    /**
     * Copy constructor
     */
    inline  SwapCallsStart (const SwapCallsStart &rhs);

    /**
     * All fields constructor
     */
    inline  SwapCallsStart (uint8 u8DeviceTag_);

    /**
     * Destructor
     */
    inline virtual  ~SwapCallsStart();

    /**
     * Assignment operator
     */
    inline SwapCallsStart& operator = (const SwapCallsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwapCallsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwapCallsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwapCallsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwapCallsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceTag"

    static const int kU8DeviceTag = 0;

    /**
     * Clears the field "u8DeviceTag".
     *
     * The field will be set to its default value. The hasU8DeviceTag()
     * method will return false.
     */
    inline void clearU8DeviceTag();

    /**
     * Checks whether the field "u8DeviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceTag()). Otherwise it will return false.
     */
    inline bool hasU8DeviceTag () const;

    /**
     * Returns the value of the member "u8DeviceTag".
     *
     * Unique identifier of the iPhone device.
     *
     * @return The value of the field "u8DeviceTag"
     */
    inline uint8 getU8DeviceTag () const;

    /**
     * Sets the value of the member "u8DeviceTag".
     *
     * Unique identifier of the iPhone device.
     *
     * @param u8DeviceTag The value which will be set
     */
    inline void setU8DeviceTag (uint8 u8DeviceTag_);

    static const SwapCallsStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceTag ();

    inline void clear_has_u8DeviceTag ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DeviceTag;

};

/**
 * The start message of the method "DiPOSetRouteGuidanceDisplayComponentInfo"
 * Set the RouteGuidance DisplayComponents information for iAP2 identification.
 */
class DiPOSetRouteGuidanceDisplayComponentInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOSetRouteGuidanceDisplayComponentInfoStart ();

    /**
     * Copy constructor
     */
    inline  DiPOSetRouteGuidanceDisplayComponentInfoStart (const DiPOSetRouteGuidanceDisplayComponentInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOSetRouteGuidanceDisplayComponentInfoStart (const ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponents& RouteGuidanceDisplayComponents_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOSetRouteGuidanceDisplayComponentInfoStart();

    /**
     * Assignment operator
     */
    inline DiPOSetRouteGuidanceDisplayComponentInfoStart& operator = (const DiPOSetRouteGuidanceDisplayComponentInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOSetRouteGuidanceDisplayComponentInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOSetRouteGuidanceDisplayComponentInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOSetRouteGuidanceDisplayComponentInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOSetRouteGuidanceDisplayComponentInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RouteGuidanceDisplayComponents"

    static const int kRouteGuidanceDisplayComponents = 0;

    /**
     * Clears the field "RouteGuidanceDisplayComponents".
     *
     * The field will be set to its default value. The hasRouteGuidanceDisplayComponents()
     * method will return false.
     */
    inline void clearRouteGuidanceDisplayComponents();

    /**
     * Checks whether the field "RouteGuidanceDisplayComponents" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteGuidanceDisplayComponents()). Otherwise it will return false.
     */
    inline bool hasRouteGuidanceDisplayComponents () const;

    /**
     * Returns the value of the member "RouteGuidanceDisplayComponents".
     *
     * Display Components info.
     *
     * @return The value of the field "RouteGuidanceDisplayComponents"
     */
    inline const ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponents& getRouteGuidanceDisplayComponents () const;

    /**
     * Retrieves the value of the field "RouteGuidanceDisplayComponents" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RouteGuidanceDisplayComponents".
     */
    inline ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponents& getRouteGuidanceDisplayComponentsMutable ();

    /**
     * Sets the value of the member "RouteGuidanceDisplayComponents".
     *
     * Display Components info.
     *
     * @param RouteGuidanceDisplayComponents The value which will be set
     */
    inline void setRouteGuidanceDisplayComponents (const ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponents& RouteGuidanceDisplayComponents_);

    static const DiPOSetRouteGuidanceDisplayComponentInfoStart &getDefaultInstance();

private:

    static const ::std::vector< ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponentItem >& getT_RouteGuidanceDisplayComponentItemList_DefaultInstance ();

    inline void set_has_RouteGuidanceDisplayComponents ();

    inline void clear_has_RouteGuidanceDisplayComponents ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponents _RouteGuidanceDisplayComponents;

};

/**
 * The start message of the method "DiPOStopRouteGuidance2"
 * StopRouteGuidanceUpdate must be sent when navigation route guidance is not being displayed by the accessory.
 */
class DiPOStopRouteGuidance2Start  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOStopRouteGuidance2Start ();

    /**
     * Copy constructor
     */
    inline  DiPOStopRouteGuidance2Start (const DiPOStopRouteGuidance2Start &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOStopRouteGuidance2Start (const ::std::string& sDeviceUSBSerialNumber_, const ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponentIDs& RouteGuidanceDisplayComponentIDs_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOStopRouteGuidance2Start();

    /**
     * Assignment operator
     */
    inline DiPOStopRouteGuidance2Start& operator = (const DiPOStopRouteGuidance2Start& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOStopRouteGuidance2Start& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOStopRouteGuidance2Start& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOStopRouteGuidance2Start& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOStopRouteGuidance2Start& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sDeviceUSBSerialNumber"

    static const int kSDeviceUSBSerialNumber = 0;

    /**
     * Clears the field "sDeviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasSDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearSDeviceUSBSerialNumber();

    /**
     * Checks whether the field "sDeviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasSDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @return The value of the field "sDeviceUSBSerialNumber"
     */
    inline const ::std::string& getSDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "sDeviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceUSBSerialNumber".
     */
    inline ::std::string& getSDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* value, size_t size);

    // API of field "RouteGuidanceDisplayComponentIDs"

    static const int kRouteGuidanceDisplayComponentIDs = 1;

    /**
     * Clears the field "RouteGuidanceDisplayComponentIDs".
     *
     * The field will be set to its default value. The hasRouteGuidanceDisplayComponentIDs()
     * method will return false.
     */
    inline void clearRouteGuidanceDisplayComponentIDs();

    /**
     * Checks whether the field "RouteGuidanceDisplayComponentIDs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteGuidanceDisplayComponentIDs()). Otherwise it will return false.
     */
    inline bool hasRouteGuidanceDisplayComponentIDs () const;

    /**
     * Returns the value of the member "RouteGuidanceDisplayComponentIDs".
     *
     * If none are specified, assume all such components are to be stopped.
     *
     * @return The value of the field "RouteGuidanceDisplayComponentIDs"
     */
    inline const ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponentIDs& getRouteGuidanceDisplayComponentIDs () const;

    /**
     * Retrieves the value of the field "RouteGuidanceDisplayComponentIDs" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RouteGuidanceDisplayComponentIDs".
     */
    inline ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponentIDs& getRouteGuidanceDisplayComponentIDsMutable ();

    /**
     * Sets the value of the member "RouteGuidanceDisplayComponentIDs".
     *
     * If none are specified, assume all such components are to be stopped.
     *
     * @param RouteGuidanceDisplayComponentIDs The value which will be set
     */
    inline void setRouteGuidanceDisplayComponentIDs (const ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponentIDs& RouteGuidanceDisplayComponentIDs_);

    static const DiPOStopRouteGuidance2Start &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_sDeviceUSBSerialNumber ();

    inline void clear_has_sDeviceUSBSerialNumber ();

    inline void set_has_RouteGuidanceDisplayComponentIDs ();

    inline void clear_has_RouteGuidanceDisplayComponentIDs ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _sDeviceUSBSerialNumber;

    ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponentIDs _RouteGuidanceDisplayComponentIDs;

};

/**
 * The start message of the method "DiPOStartRouteGuidance2"
 * StartRouteGuidanceUpdate must be sent when accessory is ready to display navigation route guidance
 */
class DiPOStartRouteGuidance2Start  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOStartRouteGuidance2Start ();

    /**
     * Copy constructor
     */
    inline  DiPOStartRouteGuidance2Start (const DiPOStartRouteGuidance2Start &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOStartRouteGuidance2Start (const ::std::string& sDeviceUSBSerialNumber_, const ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponentIDs& RouteGuidanceDisplayComponentIDs_, bool SourceName_, bool SourceSupportsRouteGuidance_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOStartRouteGuidance2Start();

    /**
     * Assignment operator
     */
    inline DiPOStartRouteGuidance2Start& operator = (const DiPOStartRouteGuidance2Start& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOStartRouteGuidance2Start& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOStartRouteGuidance2Start& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOStartRouteGuidance2Start& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOStartRouteGuidance2Start& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sDeviceUSBSerialNumber"

    static const int kSDeviceUSBSerialNumber = 0;

    /**
     * Clears the field "sDeviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasSDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearSDeviceUSBSerialNumber();

    /**
     * Checks whether the field "sDeviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasSDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @return The value of the field "sDeviceUSBSerialNumber"
     */
    inline const ::std::string& getSDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "sDeviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceUSBSerialNumber".
     */
    inline ::std::string& getSDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_);

    /**
     * Sets the value of the member "sDeviceUSBSerialNumber".
     *
     * USB serial Number of Apple device.
     *
     * @param sDeviceUSBSerialNumber The value which will be set
     */
    inline void setSDeviceUSBSerialNumber (const char* value, size_t size);

    // API of field "RouteGuidanceDisplayComponentIDs"

    static const int kRouteGuidanceDisplayComponentIDs = 1;

    /**
     * Clears the field "RouteGuidanceDisplayComponentIDs".
     *
     * The field will be set to its default value. The hasRouteGuidanceDisplayComponentIDs()
     * method will return false.
     */
    inline void clearRouteGuidanceDisplayComponentIDs();

    /**
     * Checks whether the field "RouteGuidanceDisplayComponentIDs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteGuidanceDisplayComponentIDs()). Otherwise it will return false.
     */
    inline bool hasRouteGuidanceDisplayComponentIDs () const;

    /**
     * Returns the value of the member "RouteGuidanceDisplayComponentIDs".
     *
     * If none are specified, assume all such components are being started.
     *
     * @return The value of the field "RouteGuidanceDisplayComponentIDs"
     */
    inline const ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponentIDs& getRouteGuidanceDisplayComponentIDs () const;

    /**
     * Retrieves the value of the field "RouteGuidanceDisplayComponentIDs" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RouteGuidanceDisplayComponentIDs".
     */
    inline ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponentIDs& getRouteGuidanceDisplayComponentIDsMutable ();

    /**
     * Sets the value of the member "RouteGuidanceDisplayComponentIDs".
     *
     * If none are specified, assume all such components are being started.
     *
     * @param RouteGuidanceDisplayComponentIDs The value which will be set
     */
    inline void setRouteGuidanceDisplayComponentIDs (const ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponentIDs& RouteGuidanceDisplayComponentIDs_);

    // API of field "SourceName"

    static const int kSourceName = 2;

    /**
     * Clears the field "SourceName".
     *
     * The field will be set to its default value. The hasSourceName()
     * method will return false.
     */
    inline void clearSourceName();

    /**
     * Checks whether the field "SourceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceName()). Otherwise it will return false.
     */
    inline bool hasSourceName () const;

    /**
     * Returns the value of the member "SourceName".
     *
     * Must be included to receive SourceName in RouteGuidanceUpdate.
     *
     * @return The value of the field "SourceName"
     */
    inline bool getSourceName () const;

    /**
     * Sets the value of the member "SourceName".
     *
     * Must be included to receive SourceName in RouteGuidanceUpdate.
     *
     * @param SourceName The value which will be set
     */
    inline void setSourceName (bool SourceName_);

    // API of field "SourceSupportsRouteGuidance"

    static const int kSourceSupportsRouteGuidance = 3;

    /**
     * Clears the field "SourceSupportsRouteGuidance".
     *
     * The field will be set to its default value. The hasSourceSupportsRouteGuidance()
     * method will return false.
     */
    inline void clearSourceSupportsRouteGuidance();

    /**
     * Checks whether the field "SourceSupportsRouteGuidance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceSupportsRouteGuidance()). Otherwise it will return false.
     */
    inline bool hasSourceSupportsRouteGuidance () const;

    /**
     * Returns the value of the member "SourceSupportsRouteGuidance".
     *
     * Must be included to receive SourceSupportsRouteGuidance in RouteGuidanceUpdate.
     *
     * @return The value of the field "SourceSupportsRouteGuidance"
     */
    inline bool getSourceSupportsRouteGuidance () const;

    /**
     * Sets the value of the member "SourceSupportsRouteGuidance".
     *
     * Must be included to receive SourceSupportsRouteGuidance in RouteGuidanceUpdate.
     *
     * @param SourceSupportsRouteGuidance The value which will be set
     */
    inline void setSourceSupportsRouteGuidance (bool SourceSupportsRouteGuidance_);

    static const DiPOStartRouteGuidance2Start &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_sDeviceUSBSerialNumber ();

    inline void clear_has_sDeviceUSBSerialNumber ();

    inline void set_has_RouteGuidanceDisplayComponentIDs ();

    inline void clear_has_RouteGuidanceDisplayComponentIDs ();

    inline void set_has_SourceName ();

    inline void clear_has_SourceName ();

    inline void set_has_SourceSupportsRouteGuidance ();

    inline void clear_has_SourceSupportsRouteGuidance ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _sDeviceUSBSerialNumber;

    ::mplay_appcontrol_fi_types::T_RouteGuidanceDisplayComponentIDs _RouteGuidanceDisplayComponentIDs;

    bool _SourceName;

    bool _SourceSupportsRouteGuidance;

};

/**
 * The start message of the method "DiPOSetCallControlsConfiguration"
 * Set the CallControls message configuration information for iAP2 identification.
 */
class DiPOSetCallControlsConfigurationStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOSetCallControlsConfigurationStart ();

    /**
     * Copy constructor
     */
    inline  DiPOSetCallControlsConfigurationStart (const DiPOSetCallControlsConfigurationStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOSetCallControlsConfigurationStart (const ::mplay_appcontrol_fi_types::T_CallControlsConfiguration& callControlsConfiguration_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOSetCallControlsConfigurationStart();

    /**
     * Assignment operator
     */
    inline DiPOSetCallControlsConfigurationStart& operator = (const DiPOSetCallControlsConfigurationStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOSetCallControlsConfigurationStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOSetCallControlsConfigurationStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOSetCallControlsConfigurationStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOSetCallControlsConfigurationStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "callControlsConfiguration"

    static const int kCallControlsConfiguration = 0;

    /**
     * Clears the field "callControlsConfiguration".
     *
     * The field will be set to its default value. The hasCallControlsConfiguration()
     * method will return false.
     */
    inline void clearCallControlsConfiguration();

    /**
     * Checks whether the field "callControlsConfiguration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallControlsConfiguration()). Otherwise it will return false.
     */
    inline bool hasCallControlsConfiguration () const;

    /**
     * Returns the value of the member "callControlsConfiguration".
     *
     * CallControls configuration info.
     *
     * @return The value of the field "callControlsConfiguration"
     */
    inline const ::mplay_appcontrol_fi_types::T_CallControlsConfiguration& getCallControlsConfiguration () const;

    /**
     * Retrieves the value of the field "callControlsConfiguration" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "callControlsConfiguration".
     */
    inline ::mplay_appcontrol_fi_types::T_CallControlsConfiguration& getCallControlsConfigurationMutable ();

    /**
     * Sets the value of the member "callControlsConfiguration".
     *
     * CallControls configuration info.
     *
     * @param callControlsConfiguration The value which will be set
     */
    inline void setCallControlsConfiguration (const ::mplay_appcontrol_fi_types::T_CallControlsConfiguration& callControlsConfiguration_);

    static const DiPOSetCallControlsConfigurationStart &getDefaultInstance();

private:

    inline void set_has_callControlsConfiguration ();

    inline void clear_has_callControlsConfiguration ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::mplay_appcontrol_fi_types::T_CallControlsConfiguration _callControlsConfiguration;

};

/**
 * The start message of the method "DiPOInitiateCall"
 * Initiate call Method.
 */
class DiPOInitiateCallStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOInitiateCallStart ();

    /**
     * Copy constructor
     */
    inline  DiPOInitiateCallStart (const DiPOInitiateCallStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOInitiateCallStart (const ::std::string& deviceUSBSerialNumber_, ::mplay_appcontrol_fi_types::T_e_InitiateCallType type_, ::mplay_appcontrol_fi_types::T_e_InitiateCallService service_, const ::std::string& destinationID_, const ::std::string& addressBookID_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOInitiateCallStart();

    /**
     * Assignment operator
     */
    inline DiPOInitiateCallStart& operator = (const DiPOInitiateCallStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOInitiateCallStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOInitiateCallStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOInitiateCallStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOInitiateCallStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "deviceUSBSerialNumber"

    static const int kDeviceUSBSerialNumber = 0;

    /**
     * Clears the field "deviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearDeviceUSBSerialNumber();

    /**
     * Checks whether the field "deviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @return The value of the field "deviceUSBSerialNumber"
     */
    inline const ::std::string& getDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "deviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "deviceUSBSerialNumber".
     */
    inline ::std::string& getDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const ::std::string& deviceUSBSerialNumber_);

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const char* deviceUSBSerialNumber_);

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const char* value, size_t size);

    // API of field "type"

    static const int kType = 1;

    /**
     * Clears the field "type".
     *
     * The field will be set to its default value. The hasType()
     * method will return false.
     */
    inline void clearType();

    /**
     * Checks whether the field "type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setType()). Otherwise it will return false.
     */
    inline bool hasType () const;

    /**
     * Returns the value of the member "type".
     *
     * Initiate call type parameter.
     *
     * @return The value of the field "type"
     */
    inline ::mplay_appcontrol_fi_types::T_e_InitiateCallType getType () const;

    /**
     * Sets the value of the member "type".
     *
     * Initiate call type parameter.
     *
     * @param type The value which will be set
     */
    inline void setType (::mplay_appcontrol_fi_types::T_e_InitiateCallType type_);

    // API of field "service"

    static const int kService = 2;

    /**
     * Clears the field "service".
     *
     * The field will be set to its default value. The hasService()
     * method will return false.
     */
    inline void clearService();

    /**
     * Checks whether the field "service" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setService()). Otherwise it will return false.
     */
    inline bool hasService () const;

    /**
     * Returns the value of the member "service".
     *
     * Required for Destination call.
     * Telephony, FaceTimeAudio/Video
     *
     * @return The value of the field "service"
     */
    inline ::mplay_appcontrol_fi_types::T_e_InitiateCallService getService () const;

    /**
     * Sets the value of the member "service".
     *
     * Required for Destination call.
     * Telephony, FaceTimeAudio/Video
     *
     * @param service The value which will be set
     */
    inline void setService (::mplay_appcontrol_fi_types::T_e_InitiateCallService service_);

    // API of field "destinationID"

    static const int kDestinationID = 3;

    /**
     * Clears the field "destinationID".
     *
     * The field will be set to its default value. The hasDestinationID()
     * method will return false.
     */
    inline void clearDestinationID();

    /**
     * Checks whether the field "destinationID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestinationID()). Otherwise it will return false.
     */
    inline bool hasDestinationID () const;

    /**
     * Returns the value of the member "destinationID".
     *
     * Required for Destination call. Number to call.
     * Format: 4089961010
     * Format: +14089961010
     * (utf8 string)
     *
     * @return The value of the field "destinationID"
     */
    inline const ::std::string& getDestinationID () const;

    /**
     * Retrieves the value of the field "destinationID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "destinationID".
     */
    inline ::std::string& getDestinationIDMutable ();

    /**
     * Sets the value of the member "destinationID".
     *
     * Required for Destination call. Number to call.
     * Format: 4089961010
     * Format: +14089961010
     * (utf8 string)
     *
     * @param destinationID The value which will be set
     */
    inline void setDestinationID (const ::std::string& destinationID_);

    /**
     * Sets the value of the member "destinationID".
     *
     * Required for Destination call. Number to call.
     * Format: 4089961010
     * Format: +14089961010
     * (utf8 string)
     *
     * @param destinationID The value which will be set
     */
    inline void setDestinationID (const char* destinationID_);

    /**
     * Sets the value of the member "destinationID".
     *
     * Required for Destination call. Number to call.
     * Format: 4089961010
     * Format: +14089961010
     * (utf8 string)
     *
     * @param destinationID The value which will be set
     */
    inline void setDestinationID (const char* value, size_t size);

    // API of field "addressBookID"

    static const int kAddressBookID = 4;

    /**
     * Clears the field "addressBookID".
     *
     * The field will be set to its default value. The hasAddressBookID()
     * method will return false.
     */
    inline void clearAddressBookID();

    /**
     * Checks whether the field "addressBookID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddressBookID()). Otherwise it will return false.
     */
    inline bool hasAddressBookID () const;

    /**
     * Returns the value of the member "addressBookID".
     *
     * AddressBookID parameter for InitiateCall.
     * (utf8 string)
     *
     * @return The value of the field "addressBookID"
     */
    inline const ::std::string& getAddressBookID () const;

    /**
     * Retrieves the value of the field "addressBookID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "addressBookID".
     */
    inline ::std::string& getAddressBookIDMutable ();

    /**
     * Sets the value of the member "addressBookID".
     *
     * AddressBookID parameter for InitiateCall.
     * (utf8 string)
     *
     * @param addressBookID The value which will be set
     */
    inline void setAddressBookID (const ::std::string& addressBookID_);

    /**
     * Sets the value of the member "addressBookID".
     *
     * AddressBookID parameter for InitiateCall.
     * (utf8 string)
     *
     * @param addressBookID The value which will be set
     */
    inline void setAddressBookID (const char* addressBookID_);

    /**
     * Sets the value of the member "addressBookID".
     *
     * AddressBookID parameter for InitiateCall.
     * (utf8 string)
     *
     * @param addressBookID The value which will be set
     */
    inline void setAddressBookID (const char* value, size_t size);

    static const DiPOInitiateCallStart &getDefaultInstance();

private:

    inline void set_has_deviceUSBSerialNumber ();

    inline void clear_has_deviceUSBSerialNumber ();

    inline void set_has_type ();

    inline void clear_has_type ();

    inline void set_has_service ();

    inline void clear_has_service ();

    inline void set_has_destinationID ();

    inline void clear_has_destinationID ();

    inline void set_has_addressBookID ();

    inline void clear_has_addressBookID ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _deviceUSBSerialNumber;

    ::mplay_appcontrol_fi_types::T_e_InitiateCallType _type;

    ::mplay_appcontrol_fi_types::T_e_InitiateCallService _service;

    ::std::string _destinationID;

    ::std::string _addressBookID;

};

/**
 * The start message of the method "DiPOAcceptCall"
 * Accept call Method.
 */
class DiPOAcceptCallStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOAcceptCallStart ();

    /**
     * Copy constructor
     */
    inline  DiPOAcceptCallStart (const DiPOAcceptCallStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOAcceptCallStart (const ::std::string& deviceUSBSerialNumber_, ::mplay_appcontrol_fi_types::T_e_AcceptAction acceptAction_, const ::std::string& callUUID_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOAcceptCallStart();

    /**
     * Assignment operator
     */
    inline DiPOAcceptCallStart& operator = (const DiPOAcceptCallStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOAcceptCallStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOAcceptCallStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOAcceptCallStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOAcceptCallStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "deviceUSBSerialNumber"

    static const int kDeviceUSBSerialNumber = 0;

    /**
     * Clears the field "deviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearDeviceUSBSerialNumber();

    /**
     * Checks whether the field "deviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @return The value of the field "deviceUSBSerialNumber"
     */
    inline const ::std::string& getDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "deviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "deviceUSBSerialNumber".
     */
    inline ::std::string& getDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const ::std::string& deviceUSBSerialNumber_);

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const char* deviceUSBSerialNumber_);

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const char* value, size_t size);

    // API of field "acceptAction"

    static const int kAcceptAction = 1;

    /**
     * Clears the field "acceptAction".
     *
     * The field will be set to its default value. The hasAcceptAction()
     * method will return false.
     */
    inline void clearAcceptAction();

    /**
     * Checks whether the field "acceptAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAcceptAction()). Otherwise it will return false.
     */
    inline bool hasAcceptAction () const;

    /**
     * Returns the value of the member "acceptAction".
     *
     * Accept Action parameter.
     *
     * @return The value of the field "acceptAction"
     */
    inline ::mplay_appcontrol_fi_types::T_e_AcceptAction getAcceptAction () const;

    /**
     * Sets the value of the member "acceptAction".
     *
     * Accept Action parameter.
     *
     * @param acceptAction The value which will be set
     */
    inline void setAcceptAction (::mplay_appcontrol_fi_types::T_e_AcceptAction acceptAction_);

    // API of field "callUUID"

    static const int kCallUUID = 2;

    /**
     * Clears the field "callUUID".
     *
     * The field will be set to its default value. The hasCallUUID()
     * method will return false.
     */
    inline void clearCallUUID();

    /**
     * Checks whether the field "callUUID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallUUID()). Otherwise it will return false.
     */
    inline bool hasCallUUID () const;

    /**
     * Returns the value of the member "callUUID".
     *
     * UUID of call to accept.
     * (utf8 string)
     *
     * @return The value of the field "callUUID"
     */
    inline const ::std::string& getCallUUID () const;

    /**
     * Retrieves the value of the field "callUUID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "callUUID".
     */
    inline ::std::string& getCallUUIDMutable ();

    /**
     * Sets the value of the member "callUUID".
     *
     * UUID of call to accept.
     * (utf8 string)
     *
     * @param callUUID The value which will be set
     */
    inline void setCallUUID (const ::std::string& callUUID_);

    /**
     * Sets the value of the member "callUUID".
     *
     * UUID of call to accept.
     * (utf8 string)
     *
     * @param callUUID The value which will be set
     */
    inline void setCallUUID (const char* callUUID_);

    /**
     * Sets the value of the member "callUUID".
     *
     * UUID of call to accept.
     * (utf8 string)
     *
     * @param callUUID The value which will be set
     */
    inline void setCallUUID (const char* value, size_t size);

    static const DiPOAcceptCallStart &getDefaultInstance();

private:

    inline void set_has_deviceUSBSerialNumber ();

    inline void clear_has_deviceUSBSerialNumber ();

    inline void set_has_acceptAction ();

    inline void clear_has_acceptAction ();

    inline void set_has_callUUID ();

    inline void clear_has_callUUID ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _deviceUSBSerialNumber;

    ::mplay_appcontrol_fi_types::T_e_AcceptAction _acceptAction;

    ::std::string _callUUID;

};

/**
 * The start message of the method "DiPOEndCall"
 * End call Method.
 */
class DiPOEndCallStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOEndCallStart ();

    /**
     * Copy constructor
     */
    inline  DiPOEndCallStart (const DiPOEndCallStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOEndCallStart (const ::std::string& deviceUSBSerialNumber_, ::mplay_appcontrol_fi_types::T_e_EndAction endAction_, const ::std::string& callUUID_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOEndCallStart();

    /**
     * Assignment operator
     */
    inline DiPOEndCallStart& operator = (const DiPOEndCallStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOEndCallStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOEndCallStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOEndCallStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOEndCallStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "deviceUSBSerialNumber"

    static const int kDeviceUSBSerialNumber = 0;

    /**
     * Clears the field "deviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearDeviceUSBSerialNumber();

    /**
     * Checks whether the field "deviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @return The value of the field "deviceUSBSerialNumber"
     */
    inline const ::std::string& getDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "deviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "deviceUSBSerialNumber".
     */
    inline ::std::string& getDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const ::std::string& deviceUSBSerialNumber_);

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const char* deviceUSBSerialNumber_);

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const char* value, size_t size);

    // API of field "endAction"

    static const int kEndAction = 1;

    /**
     * Clears the field "endAction".
     *
     * The field will be set to its default value. The hasEndAction()
     * method will return false.
     */
    inline void clearEndAction();

    /**
     * Checks whether the field "endAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEndAction()). Otherwise it will return false.
     */
    inline bool hasEndAction () const;

    /**
     * Returns the value of the member "endAction".
     *
     * End Action parameter.
     *
     * @return The value of the field "endAction"
     */
    inline ::mplay_appcontrol_fi_types::T_e_EndAction getEndAction () const;

    /**
     * Sets the value of the member "endAction".
     *
     * End Action parameter.
     *
     * @param endAction The value which will be set
     */
    inline void setEndAction (::mplay_appcontrol_fi_types::T_e_EndAction endAction_);

    // API of field "callUUID"

    static const int kCallUUID = 2;

    /**
     * Clears the field "callUUID".
     *
     * The field will be set to its default value. The hasCallUUID()
     * method will return false.
     */
    inline void clearCallUUID();

    /**
     * Checks whether the field "callUUID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallUUID()). Otherwise it will return false.
     */
    inline bool hasCallUUID () const;

    /**
     * Returns the value of the member "callUUID".
     *
     * UUID of call to end.
     * (utf8 string)
     *
     * @return The value of the field "callUUID"
     */
    inline const ::std::string& getCallUUID () const;

    /**
     * Retrieves the value of the field "callUUID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "callUUID".
     */
    inline ::std::string& getCallUUIDMutable ();

    /**
     * Sets the value of the member "callUUID".
     *
     * UUID of call to end.
     * (utf8 string)
     *
     * @param callUUID The value which will be set
     */
    inline void setCallUUID (const ::std::string& callUUID_);

    /**
     * Sets the value of the member "callUUID".
     *
     * UUID of call to end.
     * (utf8 string)
     *
     * @param callUUID The value which will be set
     */
    inline void setCallUUID (const char* callUUID_);

    /**
     * Sets the value of the member "callUUID".
     *
     * UUID of call to end.
     * (utf8 string)
     *
     * @param callUUID The value which will be set
     */
    inline void setCallUUID (const char* value, size_t size);

    static const DiPOEndCallStart &getDefaultInstance();

private:

    inline void set_has_deviceUSBSerialNumber ();

    inline void clear_has_deviceUSBSerialNumber ();

    inline void set_has_endAction ();

    inline void clear_has_endAction ();

    inline void set_has_callUUID ();

    inline void clear_has_callUUID ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _deviceUSBSerialNumber;

    ::mplay_appcontrol_fi_types::T_e_EndAction _endAction;

    ::std::string _callUUID;

};

/**
 * The start message of the method "DiPOMergeCalls"
 * Merge calls Method.
 * Note: Method not yet implemented.
 */
class DiPOMergeCallsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOMergeCallsStart ();

    /**
     * Copy constructor
     */
    inline  DiPOMergeCallsStart (const DiPOMergeCallsStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOMergeCallsStart (const ::std::string& deviceUSBSerialNumber_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOMergeCallsStart();

    /**
     * Assignment operator
     */
    inline DiPOMergeCallsStart& operator = (const DiPOMergeCallsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOMergeCallsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOMergeCallsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOMergeCallsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOMergeCallsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "deviceUSBSerialNumber"

    static const int kDeviceUSBSerialNumber = 0;

    /**
     * Clears the field "deviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearDeviceUSBSerialNumber();

    /**
     * Checks whether the field "deviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @return The value of the field "deviceUSBSerialNumber"
     */
    inline const ::std::string& getDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "deviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "deviceUSBSerialNumber".
     */
    inline ::std::string& getDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const ::std::string& deviceUSBSerialNumber_);

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const char* deviceUSBSerialNumber_);

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const char* value, size_t size);

    static const DiPOMergeCallsStart &getDefaultInstance();

private:

    inline void set_has_deviceUSBSerialNumber ();

    inline void clear_has_deviceUSBSerialNumber ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _deviceUSBSerialNumber;

};

/**
 * The start message of the method "DiPOHoldStatusUpdate"
 * HoldStatusUpdate method.
 * Note: Method not yet implemented.
 */
class DiPOHoldStatusUpdateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOHoldStatusUpdateStart ();

    /**
     * Copy constructor
     */
    inline  DiPOHoldStatusUpdateStart (const DiPOHoldStatusUpdateStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOHoldStatusUpdateStart (const ::std::string& deviceUSBSerialNumber_, bool holdStatus_, const ::std::string& callUUID_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOHoldStatusUpdateStart();

    /**
     * Assignment operator
     */
    inline DiPOHoldStatusUpdateStart& operator = (const DiPOHoldStatusUpdateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOHoldStatusUpdateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOHoldStatusUpdateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOHoldStatusUpdateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOHoldStatusUpdateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "deviceUSBSerialNumber"

    static const int kDeviceUSBSerialNumber = 0;

    /**
     * Clears the field "deviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearDeviceUSBSerialNumber();

    /**
     * Checks whether the field "deviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @return The value of the field "deviceUSBSerialNumber"
     */
    inline const ::std::string& getDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "deviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "deviceUSBSerialNumber".
     */
    inline ::std::string& getDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const ::std::string& deviceUSBSerialNumber_);

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const char* deviceUSBSerialNumber_);

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const char* value, size_t size);

    // API of field "holdStatus"

    static const int kHoldStatus = 1;

    /**
     * Clears the field "holdStatus".
     *
     * The field will be set to its default value. The hasHoldStatus()
     * method will return false.
     */
    inline void clearHoldStatus();

    /**
     * Checks whether the field "holdStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHoldStatus()). Otherwise it will return false.
     */
    inline bool hasHoldStatus () const;

    /**
     * Returns the value of the member "holdStatus".
     *
     * HoldStatus parameter.
     *
     * @return The value of the field "holdStatus"
     */
    inline bool getHoldStatus () const;

    /**
     * Sets the value of the member "holdStatus".
     *
     * HoldStatus parameter.
     *
     * @param holdStatus The value which will be set
     */
    inline void setHoldStatus (bool holdStatus_);

    // API of field "callUUID"

    static const int kCallUUID = 2;

    /**
     * Clears the field "callUUID".
     *
     * The field will be set to its default value. The hasCallUUID()
     * method will return false.
     */
    inline void clearCallUUID();

    /**
     * Checks whether the field "callUUID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallUUID()). Otherwise it will return false.
     */
    inline bool hasCallUUID () const;

    /**
     * Returns the value of the member "callUUID".
     *
     * UUID of call to update hold status.
     *
     * @return The value of the field "callUUID"
     */
    inline const ::std::string& getCallUUID () const;

    /**
     * Retrieves the value of the field "callUUID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "callUUID".
     */
    inline ::std::string& getCallUUIDMutable ();

    /**
     * Sets the value of the member "callUUID".
     *
     * UUID of call to update hold status.
     *
     * @param callUUID The value which will be set
     */
    inline void setCallUUID (const ::std::string& callUUID_);

    /**
     * Sets the value of the member "callUUID".
     *
     * UUID of call to update hold status.
     *
     * @param callUUID The value which will be set
     */
    inline void setCallUUID (const char* callUUID_);

    /**
     * Sets the value of the member "callUUID".
     *
     * UUID of call to update hold status.
     *
     * @param callUUID The value which will be set
     */
    inline void setCallUUID (const char* value, size_t size);

    static const DiPOHoldStatusUpdateStart &getDefaultInstance();

private:

    inline void set_has_deviceUSBSerialNumber ();

    inline void clear_has_deviceUSBSerialNumber ();

    inline void set_has_holdStatus ();

    inline void clear_has_holdStatus ();

    inline void set_has_callUUID ();

    inline void clear_has_callUUID ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _deviceUSBSerialNumber;

    bool _holdStatus;

    ::std::string _callUUID;

};

/**
 * The start message of the method "DiPOMuteStatusUpdate"
 * MuteStatusUpdate method.
 * Note: Method not yet implemented.
 */
class DiPOMuteStatusUpdateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOMuteStatusUpdateStart ();

    /**
     * Copy constructor
     */
    inline  DiPOMuteStatusUpdateStart (const DiPOMuteStatusUpdateStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOMuteStatusUpdateStart (const ::std::string& deviceUSBSerialNumber_, bool muteStatus_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOMuteStatusUpdateStart();

    /**
     * Assignment operator
     */
    inline DiPOMuteStatusUpdateStart& operator = (const DiPOMuteStatusUpdateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOMuteStatusUpdateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOMuteStatusUpdateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOMuteStatusUpdateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOMuteStatusUpdateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "deviceUSBSerialNumber"

    static const int kDeviceUSBSerialNumber = 0;

    /**
     * Clears the field "deviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearDeviceUSBSerialNumber();

    /**
     * Checks whether the field "deviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @return The value of the field "deviceUSBSerialNumber"
     */
    inline const ::std::string& getDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "deviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "deviceUSBSerialNumber".
     */
    inline ::std::string& getDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const ::std::string& deviceUSBSerialNumber_);

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const char* deviceUSBSerialNumber_);

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const char* value, size_t size);

    // API of field "muteStatus"

    static const int kMuteStatus = 1;

    /**
     * Clears the field "muteStatus".
     *
     * The field will be set to its default value. The hasMuteStatus()
     * method will return false.
     */
    inline void clearMuteStatus();

    /**
     * Checks whether the field "muteStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMuteStatus()). Otherwise it will return false.
     */
    inline bool hasMuteStatus () const;

    /**
     * Returns the value of the member "muteStatus".
     *
     * MuteStatus parameter.
     *
     * @return The value of the field "muteStatus"
     */
    inline bool getMuteStatus () const;

    /**
     * Sets the value of the member "muteStatus".
     *
     * MuteStatus parameter.
     *
     * @param muteStatus The value which will be set
     */
    inline void setMuteStatus (bool muteStatus_);

    static const DiPOMuteStatusUpdateStart &getDefaultInstance();

private:

    inline void set_has_deviceUSBSerialNumber ();

    inline void clear_has_deviceUSBSerialNumber ();

    inline void set_has_muteStatus ();

    inline void clear_has_muteStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _deviceUSBSerialNumber;

    bool _muteStatus;

};

/**
 * The start message of the method "DiPOSendDTMF"
 * SendDTMF method.
 * Note: Method not yet implemented.
 */
class DiPOSendDTMFStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOSendDTMFStart ();

    /**
     * Copy constructor
     */
    inline  DiPOSendDTMFStart (const DiPOSendDTMFStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOSendDTMFStart (const ::std::string& deviceUSBSerialNumber_, ::mplay_appcontrol_fi_types::T_e_SendDTMFTone tone_, const ::std::string& callUUID_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOSendDTMFStart();

    /**
     * Assignment operator
     */
    inline DiPOSendDTMFStart& operator = (const DiPOSendDTMFStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOSendDTMFStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOSendDTMFStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOSendDTMFStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOSendDTMFStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "deviceUSBSerialNumber"

    static const int kDeviceUSBSerialNumber = 0;

    /**
     * Clears the field "deviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearDeviceUSBSerialNumber();

    /**
     * Checks whether the field "deviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @return The value of the field "deviceUSBSerialNumber"
     */
    inline const ::std::string& getDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "deviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "deviceUSBSerialNumber".
     */
    inline ::std::string& getDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const ::std::string& deviceUSBSerialNumber_);

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const char* deviceUSBSerialNumber_);

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const char* value, size_t size);

    // API of field "tone"

    static const int kTone = 1;

    /**
     * Clears the field "tone".
     *
     * The field will be set to its default value. The hasTone()
     * method will return false.
     */
    inline void clearTone();

    /**
     * Checks whether the field "tone" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTone()). Otherwise it will return false.
     */
    inline bool hasTone () const;

    /**
     * Returns the value of the member "tone".
     *
     * DTMFTone parameter.
     *
     * @return The value of the field "tone"
     */
    inline ::mplay_appcontrol_fi_types::T_e_SendDTMFTone getTone () const;

    /**
     * Sets the value of the member "tone".
     *
     * DTMFTone parameter.
     *
     * @param tone The value which will be set
     */
    inline void setTone (::mplay_appcontrol_fi_types::T_e_SendDTMFTone tone_);

    // API of field "callUUID"

    static const int kCallUUID = 2;

    /**
     * Clears the field "callUUID".
     *
     * The field will be set to its default value. The hasCallUUID()
     * method will return false.
     */
    inline void clearCallUUID();

    /**
     * Checks whether the field "callUUID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallUUID()). Otherwise it will return false.
     */
    inline bool hasCallUUID () const;

    /**
     * Returns the value of the member "callUUID".
     *
     * UUID of call to play tone.
     *
     * @return The value of the field "callUUID"
     */
    inline const ::std::string& getCallUUID () const;

    /**
     * Retrieves the value of the field "callUUID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "callUUID".
     */
    inline ::std::string& getCallUUIDMutable ();

    /**
     * Sets the value of the member "callUUID".
     *
     * UUID of call to play tone.
     *
     * @param callUUID The value which will be set
     */
    inline void setCallUUID (const ::std::string& callUUID_);

    /**
     * Sets the value of the member "callUUID".
     *
     * UUID of call to play tone.
     *
     * @param callUUID The value which will be set
     */
    inline void setCallUUID (const char* callUUID_);

    /**
     * Sets the value of the member "callUUID".
     *
     * UUID of call to play tone.
     *
     * @param callUUID The value which will be set
     */
    inline void setCallUUID (const char* value, size_t size);

    static const DiPOSendDTMFStart &getDefaultInstance();

private:

    inline void set_has_deviceUSBSerialNumber ();

    inline void clear_has_deviceUSBSerialNumber ();

    inline void set_has_tone ();

    inline void clear_has_tone ();

    inline void set_has_callUUID ();

    inline void clear_has_callUUID ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _deviceUSBSerialNumber;

    ::mplay_appcontrol_fi_types::T_e_SendDTMFTone _tone;

    ::std::string _callUUID;

};

/**
 * The start message of the method "DiPOSwapCalls"
 * Swap current call with on hold call.
 */
class DiPOSwapCallsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOSwapCallsStart ();

    /**
     * Copy constructor
     */
    inline  DiPOSwapCallsStart (const DiPOSwapCallsStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOSwapCallsStart (const ::std::string& deviceUSBSerialNumber_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOSwapCallsStart();

    /**
     * Assignment operator
     */
    inline DiPOSwapCallsStart& operator = (const DiPOSwapCallsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOSwapCallsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOSwapCallsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOSwapCallsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOSwapCallsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "deviceUSBSerialNumber"

    static const int kDeviceUSBSerialNumber = 0;

    /**
     * Clears the field "deviceUSBSerialNumber".
     *
     * The field will be set to its default value. The hasDeviceUSBSerialNumber()
     * method will return false.
     */
    inline void clearDeviceUSBSerialNumber();

    /**
     * Checks whether the field "deviceUSBSerialNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceUSBSerialNumber()). Otherwise it will return false.
     */
    inline bool hasDeviceUSBSerialNumber () const;

    /**
     * Returns the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @return The value of the field "deviceUSBSerialNumber"
     */
    inline const ::std::string& getDeviceUSBSerialNumber () const;

    /**
     * Retrieves the value of the field "deviceUSBSerialNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "deviceUSBSerialNumber".
     */
    inline ::std::string& getDeviceUSBSerialNumberMutable ();

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const ::std::string& deviceUSBSerialNumber_);

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const char* deviceUSBSerialNumber_);

    /**
     * Sets the value of the member "deviceUSBSerialNumber".
     *
     * USBSerialNumber of the iPhone device.
     *
     * @param deviceUSBSerialNumber The value which will be set
     */
    inline void setDeviceUSBSerialNumber (const char* value, size_t size);

    static const DiPOSwapCallsStart &getDefaultInstance();

private:

    inline void set_has_deviceUSBSerialNumber ();

    inline void clear_has_deviceUSBSerialNumber ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _deviceUSBSerialNumber;

};

/**
 * The start message of the method "DiPOSetAppleIdentificationInfo"
 * Set the neccessary iAP2 parameters required for iAP2 identification acceptance during Carplay session.
 */
class DiPOSetAppleIdentificationInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOSetAppleIdentificationInfoStart ();

    /**
     * Copy constructor
     */
    inline  DiPOSetAppleIdentificationInfoStart (const DiPOSetAppleIdentificationInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOSetAppleIdentificationInfoStart (const ::std::string& ProductPlanUUID_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOSetAppleIdentificationInfoStart();

    /**
     * Assignment operator
     */
    inline DiPOSetAppleIdentificationInfoStart& operator = (const DiPOSetAppleIdentificationInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOSetAppleIdentificationInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOSetAppleIdentificationInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOSetAppleIdentificationInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOSetAppleIdentificationInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ProductPlanUUID"

    static const int kProductPlanUUID = 0;

    /**
     * Clears the field "ProductPlanUUID".
     *
     * The field will be set to its default value. The hasProductPlanUUID()
     * method will return false.
     */
    inline void clearProductPlanUUID();

    /**
     * Checks whether the field "ProductPlanUUID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductPlanUUID()). Otherwise it will return false.
     */
    inline bool hasProductPlanUUID () const;

    /**
     * Returns the value of the member "ProductPlanUUID".
     *
     * It is a unique ID for each Product Plan ID in MFI portal.
     *
     * @return The value of the field "ProductPlanUUID"
     */
    inline const ::std::string& getProductPlanUUID () const;

    /**
     * Retrieves the value of the field "ProductPlanUUID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ProductPlanUUID".
     */
    inline ::std::string& getProductPlanUUIDMutable ();

    /**
     * Sets the value of the member "ProductPlanUUID".
     *
     * It is a unique ID for each Product Plan ID in MFI portal.
     *
     * @param ProductPlanUUID The value which will be set
     */
    inline void setProductPlanUUID (const ::std::string& ProductPlanUUID_);

    /**
     * Sets the value of the member "ProductPlanUUID".
     *
     * It is a unique ID for each Product Plan ID in MFI portal.
     *
     * @param ProductPlanUUID The value which will be set
     */
    inline void setProductPlanUUID (const char* ProductPlanUUID_);

    /**
     * Sets the value of the member "ProductPlanUUID".
     *
     * It is a unique ID for each Product Plan ID in MFI portal.
     *
     * @param ProductPlanUUID The value which will be set
     */
    inline void setProductPlanUUID (const char* value, size_t size);

    static const DiPOSetAppleIdentificationInfoStart &getDefaultInstance();

private:

    inline void set_has_ProductPlanUUID ();

    inline void clear_has_ProductPlanUUID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _ProductPlanUUID;

};

/**
 * The result message of the method "DiPOSetAppleIdentificationInfo"
 * Set the neccessary iAP2 parameters required for iAP2 identification acceptance during Carplay session.
 */
class DiPOSetAppleIdentificationInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPOSetAppleIdentificationInfoResult ();

    /**
     * Copy constructor
     */
    inline  DiPOSetAppleIdentificationInfoResult (const DiPOSetAppleIdentificationInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  DiPOSetAppleIdentificationInfoResult (::mplay_appcontrol_fi_types::T_e8_DiPOResponse e8DiPOResponse_);

    /**
     * Destructor
     */
    inline virtual  ~DiPOSetAppleIdentificationInfoResult();

    /**
     * Assignment operator
     */
    inline DiPOSetAppleIdentificationInfoResult& operator = (const DiPOSetAppleIdentificationInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPOSetAppleIdentificationInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPOSetAppleIdentificationInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPOSetAppleIdentificationInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPOSetAppleIdentificationInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DiPOResponse"

    static const int kE8DiPOResponse = 0;

    /**
     * Clears the field "e8DiPOResponse".
     *
     * The field will be set to its default value. The hasE8DiPOResponse()
     * method will return false.
     */
    inline void clearE8DiPOResponse();

    /**
     * Checks whether the field "e8DiPOResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DiPOResponse()). Otherwise it will return false.
     */
    inline bool hasE8DiPOResponse () const;

    /**
     * Returns the value of the member "e8DiPOResponse".
     *
     * Result of the SetAppleIdentificationInfo operation
     *
     * @return The value of the field "e8DiPOResponse"
     */
    inline ::mplay_appcontrol_fi_types::T_e8_DiPOResponse getE8DiPOResponse () const;

    /**
     * Sets the value of the member "e8DiPOResponse".
     *
     * Result of the SetAppleIdentificationInfo operation
     *
     * @param e8DiPOResponse The value which will be set
     */
    inline void setE8DiPOResponse (::mplay_appcontrol_fi_types::T_e8_DiPOResponse e8DiPOResponse_);

    static const DiPOSetAppleIdentificationInfoResult &getDefaultInstance();

private:

    inline void set_has_e8DiPOResponse ();

    inline void clear_has_e8DiPOResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::mplay_appcontrol_fi_types::T_e8_DiPOResponse _e8DiPOResponse;

};

/**
 * The start message of the method "DiPORequestBluetoothAudioDevice"
 * Method to request or release BT audio device
 */
class DiPORequestBluetoothAudioDeviceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPORequestBluetoothAudioDeviceStart ();

    /**
     * Copy constructor
     */
    inline  DiPORequestBluetoothAudioDeviceStart (const DiPORequestBluetoothAudioDeviceStart &rhs);

    /**
     * All fields constructor
     */
    inline  DiPORequestBluetoothAudioDeviceStart (bool bRequestAction_);

    /**
     * Destructor
     */
    inline virtual  ~DiPORequestBluetoothAudioDeviceStart();

    /**
     * Assignment operator
     */
    inline DiPORequestBluetoothAudioDeviceStart& operator = (const DiPORequestBluetoothAudioDeviceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPORequestBluetoothAudioDeviceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPORequestBluetoothAudioDeviceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPORequestBluetoothAudioDeviceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPORequestBluetoothAudioDeviceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bRequestAction"

    static const int kBRequestAction = 0;

    /**
     * Clears the field "bRequestAction".
     *
     * The field will be set to its default value. The hasBRequestAction()
     * method will return false.
     */
    inline void clearBRequestAction();

    /**
     * Checks whether the field "bRequestAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRequestAction()). Otherwise it will return false.
     */
    inline bool hasBRequestAction () const;

    /**
     * Returns the value of the member "bRequestAction".
     *
     * Client has to request the BT audio device only if the pipe is free. This will be checked
     * by checking the status of property DiPOBluetoothAudioDeviceStatus.
     * 0 = release access to the audio device.
     * 1 = request access to the audio device.
     *
     * @return The value of the field "bRequestAction"
     */
    inline bool getBRequestAction () const;

    /**
     * Sets the value of the member "bRequestAction".
     *
     * Client has to request the BT audio device only if the pipe is free. This will be checked
     * by checking the status of property DiPOBluetoothAudioDeviceStatus.
     * 0 = release access to the audio device.
     * 1 = request access to the audio device.
     *
     * @param bRequestAction The value which will be set
     */
    inline void setBRequestAction (bool bRequestAction_);

    static const DiPORequestBluetoothAudioDeviceStart &getDefaultInstance();

private:

    inline void set_has_bRequestAction ();

    inline void clear_has_bRequestAction ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bRequestAction;

};

/**
 * The result message of the method "DiPORequestBluetoothAudioDevice"
 * Method to request or release BT audio device
 */
class DiPORequestBluetoothAudioDeviceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiPORequestBluetoothAudioDeviceResult ();

    /**
     * Copy constructor
     */
    inline  DiPORequestBluetoothAudioDeviceResult (const DiPORequestBluetoothAudioDeviceResult &rhs);

    /**
     * All fields constructor
     */
    inline  DiPORequestBluetoothAudioDeviceResult (bool bRequestStatus_);

    /**
     * Destructor
     */
    inline virtual  ~DiPORequestBluetoothAudioDeviceResult();

    /**
     * Assignment operator
     */
    inline DiPORequestBluetoothAudioDeviceResult& operator = (const DiPORequestBluetoothAudioDeviceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiPORequestBluetoothAudioDeviceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiPORequestBluetoothAudioDeviceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiPORequestBluetoothAudioDeviceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiPORequestBluetoothAudioDeviceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bRequestStatus"

    static const int kBRequestStatus = 0;

    /**
     * Clears the field "bRequestStatus".
     *
     * The field will be set to its default value. The hasBRequestStatus()
     * method will return false.
     */
    inline void clearBRequestStatus();

    /**
     * Checks whether the field "bRequestStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRequestStatus()). Otherwise it will return false.
     */
    inline bool hasBRequestStatus () const;

    /**
     * Returns the value of the member "bRequestStatus".
     *
     * 0 = access or release rejected as it might be busy
     * 1 = access or release granted
     *
     * @return The value of the field "bRequestStatus"
     */
    inline bool getBRequestStatus () const;

    /**
     * Sets the value of the member "bRequestStatus".
     *
     * 0 = access or release rejected as it might be busy
     * 1 = access or release granted
     *
     * @param bRequestStatus The value which will be set
     */
    inline void setBRequestStatus (bool bRequestStatus_);

    static const DiPORequestBluetoothAudioDeviceResult &getDefaultInstance();

private:

    inline void set_has_bRequestStatus ();

    inline void clear_has_bRequestStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bRequestStatus;

};

inline  DataResponseStatus::DataResponseStatus ()  :
    _szDeviceId (),
    _szAppName (),
    _u16SessionId (0u),
    _au8CommandResponseBuffer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DataResponseStatus::DataResponseStatus (const DataResponseStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _szDeviceId (),
    _szAppName (),
    _u16SessionId (0u),
    _au8CommandResponseBuffer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DataResponseStatus::DataResponseStatus (const ::std::string& szDeviceId_, const ::std::string& szAppName_, uint16 u16SessionId_, const ::asf::core::Blob& au8CommandResponseBuffer_)  :
    _szDeviceId (szDeviceId_),
    _szAppName (szAppName_),
    _u16SessionId (u16SessionId_),
    _au8CommandResponseBuffer (au8CommandResponseBuffer_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DataResponseStatus::~DataResponseStatus() {
}

inline DataResponseStatus& DataResponseStatus::operator = (const DataResponseStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSzDeviceId()) {
            setSzDeviceId(rhs.getSzDeviceId());
        } else {
            clearSzDeviceId();
        }
        if (rhs.hasSzAppName()) {
            setSzAppName(rhs.getSzAppName());
        } else {
            clearSzAppName();
        }
        if (rhs.hasU16SessionId()) {
            setU16SessionId(rhs.getU16SessionId());
        } else {
            clearU16SessionId();
        }
        if (rhs.hasAu8CommandResponseBuffer()) {
            setAu8CommandResponseBuffer(rhs.getAu8CommandResponseBuffer());
        } else {
            clearAu8CommandResponseBuffer();
        }
    }
    return *this;
}

inline bool DataResponseStatus::operator == (const DataResponseStatus& rhs) const {
    return (((!hasSzDeviceId() && !rhs.hasSzDeviceId()) || getSzDeviceId() == rhs.getSzDeviceId()) &&
        ((!hasSzAppName() && !rhs.hasSzAppName()) || getSzAppName() == rhs.getSzAppName()) &&
        ((!hasU16SessionId() && !rhs.hasU16SessionId()) || getU16SessionId() == rhs.getU16SessionId()) &&
        ((!hasAu8CommandResponseBuffer() && !rhs.hasAu8CommandResponseBuffer()) || getAu8CommandResponseBuffer() == rhs.getAu8CommandResponseBuffer()));
}

inline bool DataResponseStatus::operator != (const DataResponseStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DataResponseStatus::operator < (const DataResponseStatus& rhs) const {
    if (hasSzDeviceId() || rhs.hasSzDeviceId()) {
        if (getSzDeviceId() < rhs.getSzDeviceId()) return true;
        if (getSzDeviceId() > rhs.getSzDeviceId()) return false;
    }
    if (hasSzAppName() || rhs.hasSzAppName()) {
        if (getSzAppName() < rhs.getSzAppName()) return true;
        if (getSzAppName() > rhs.getSzAppName()) return false;
    }
    if (hasU16SessionId() || rhs.hasU16SessionId()) {
        if (getU16SessionId() < rhs.getU16SessionId()) return true;
        if (getU16SessionId() > rhs.getU16SessionId()) return false;
    }
    if (hasAu8CommandResponseBuffer() || rhs.hasAu8CommandResponseBuffer()) {
        if (getAu8CommandResponseBuffer() < rhs.getAu8CommandResponseBuffer()) return true;
        if (getAu8CommandResponseBuffer() > rhs.getAu8CommandResponseBuffer()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DataResponseStatus::clone() {
    return new DataResponseStatus(*this);
}

inline bool DataResponseStatus::operator > (const DataResponseStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DataResponseStatus::clear() {
    clearSzDeviceId();
    clearSzAppName();
    clearU16SessionId();
    clearAu8CommandResponseBuffer();
}

inline void DataResponseStatus::clearSzDeviceId() {
    if (hasSzDeviceId()) {
         clear_has_szDeviceId();
        _szDeviceId.clear();
     }
}

inline bool DataResponseStatus::hasSzDeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DataResponseStatus::getSzDeviceId () const {
    return _szDeviceId;
}

inline ::std::string& DataResponseStatus::getSzDeviceIdMutable () {
    set_has_szDeviceId();
    return _szDeviceId;
}

inline void DataResponseStatus::setSzDeviceId (const ::std::string& szDeviceId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId = szDeviceId_;
}

inline void DataResponseStatus::setSzDeviceId (const char* szDeviceId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId.assign(szDeviceId_);
}

inline void DataResponseStatus::setSzDeviceId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId.assign(value, size);
}

inline void DataResponseStatus::clearSzAppName() {
    if (hasSzAppName()) {
         clear_has_szAppName();
        _szAppName.clear();
     }
}

inline bool DataResponseStatus::hasSzAppName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& DataResponseStatus::getSzAppName () const {
    return _szAppName;
}

inline ::std::string& DataResponseStatus::getSzAppNameMutable () {
    set_has_szAppName();
    return _szAppName;
}

inline void DataResponseStatus::setSzAppName (const ::std::string& szAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName = szAppName_;
}

inline void DataResponseStatus::setSzAppName (const char* szAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName.assign(szAppName_);
}

inline void DataResponseStatus::setSzAppName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName.assign(value, size);
}

inline void DataResponseStatus::clearU16SessionId() {
    if (hasU16SessionId()) {
         clear_has_u16SessionId();
        _u16SessionId = 0u;
     }
}

inline bool DataResponseStatus::hasU16SessionId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 DataResponseStatus::getU16SessionId () const {
    return _u16SessionId;
}

inline void DataResponseStatus::setU16SessionId (uint16 u16SessionId_) {
    set_has_u16SessionId();
    this->_u16SessionId = u16SessionId_;
}

inline void DataResponseStatus::clearAu8CommandResponseBuffer() {
    if (hasAu8CommandResponseBuffer()) {
         clear_has_au8CommandResponseBuffer();
        _au8CommandResponseBuffer = ::asf::core::theEmptyBlob;
     }
}

inline bool DataResponseStatus::hasAu8CommandResponseBuffer () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::asf::core::Blob& DataResponseStatus::getAu8CommandResponseBuffer () const {
    return _au8CommandResponseBuffer;
}

inline ::asf::core::Blob& DataResponseStatus::getAu8CommandResponseBufferMutable () {
    set_has_au8CommandResponseBuffer();
    return _au8CommandResponseBuffer;
}

inline void DataResponseStatus::setAu8CommandResponseBuffer (const ::asf::core::Blob& au8CommandResponseBuffer_) {
    set_has_au8CommandResponseBuffer();
    this->_au8CommandResponseBuffer = au8CommandResponseBuffer_;
}

inline void DataResponseStatus::set_has_szDeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void DataResponseStatus::clear_has_szDeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DataResponseStatus::set_has_szAppName () {
    _has_bits_[0] |= 1u << 1;
}

inline void DataResponseStatus::clear_has_szAppName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DataResponseStatus::set_has_u16SessionId () {
    _has_bits_[0] |= 1u << 2;
}

inline void DataResponseStatus::clear_has_u16SessionId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DataResponseStatus::set_has_au8CommandResponseBuffer () {
    _has_bits_[0] |= 1u << 3;
}

inline void DataResponseStatus::clear_has_au8CommandResponseBuffer () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  SessionOpenedStatus::SessionOpenedStatus ()  :
    _szDeviceId (),
    _szAppName (),
    _u16SessionId (0u),
    _szProtocolName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SessionOpenedStatus::SessionOpenedStatus (const SessionOpenedStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _szDeviceId (),
    _szAppName (),
    _u16SessionId (0u),
    _szProtocolName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SessionOpenedStatus::SessionOpenedStatus (const ::std::string& szDeviceId_, const ::std::string& szAppName_, uint16 u16SessionId_, const ::std::string& szProtocolName_)  :
    _szDeviceId (szDeviceId_),
    _szAppName (szAppName_),
    _u16SessionId (u16SessionId_),
    _szProtocolName (szProtocolName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szProtocolName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SessionOpenedStatus::~SessionOpenedStatus() {
}

inline SessionOpenedStatus& SessionOpenedStatus::operator = (const SessionOpenedStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSzDeviceId()) {
            setSzDeviceId(rhs.getSzDeviceId());
        } else {
            clearSzDeviceId();
        }
        if (rhs.hasSzAppName()) {
            setSzAppName(rhs.getSzAppName());
        } else {
            clearSzAppName();
        }
        if (rhs.hasU16SessionId()) {
            setU16SessionId(rhs.getU16SessionId());
        } else {
            clearU16SessionId();
        }
        if (rhs.hasSzProtocolName()) {
            setSzProtocolName(rhs.getSzProtocolName());
        } else {
            clearSzProtocolName();
        }
    }
    return *this;
}

inline bool SessionOpenedStatus::operator == (const SessionOpenedStatus& rhs) const {
    return (((!hasSzDeviceId() && !rhs.hasSzDeviceId()) || getSzDeviceId() == rhs.getSzDeviceId()) &&
        ((!hasSzAppName() && !rhs.hasSzAppName()) || getSzAppName() == rhs.getSzAppName()) &&
        ((!hasU16SessionId() && !rhs.hasU16SessionId()) || getU16SessionId() == rhs.getU16SessionId()) &&
        ((!hasSzProtocolName() && !rhs.hasSzProtocolName()) || getSzProtocolName() == rhs.getSzProtocolName()));
}

inline bool SessionOpenedStatus::operator != (const SessionOpenedStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SessionOpenedStatus::operator < (const SessionOpenedStatus& rhs) const {
    if (hasSzDeviceId() || rhs.hasSzDeviceId()) {
        if (getSzDeviceId() < rhs.getSzDeviceId()) return true;
        if (getSzDeviceId() > rhs.getSzDeviceId()) return false;
    }
    if (hasSzAppName() || rhs.hasSzAppName()) {
        if (getSzAppName() < rhs.getSzAppName()) return true;
        if (getSzAppName() > rhs.getSzAppName()) return false;
    }
    if (hasU16SessionId() || rhs.hasU16SessionId()) {
        if (getU16SessionId() < rhs.getU16SessionId()) return true;
        if (getU16SessionId() > rhs.getU16SessionId()) return false;
    }
    if (hasSzProtocolName() || rhs.hasSzProtocolName()) {
        if (getSzProtocolName() < rhs.getSzProtocolName()) return true;
        if (getSzProtocolName() > rhs.getSzProtocolName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SessionOpenedStatus::clone() {
    return new SessionOpenedStatus(*this);
}

inline bool SessionOpenedStatus::operator > (const SessionOpenedStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SessionOpenedStatus::clear() {
    clearSzDeviceId();
    clearSzAppName();
    clearU16SessionId();
    clearSzProtocolName();
}

inline void SessionOpenedStatus::clearSzDeviceId() {
    if (hasSzDeviceId()) {
         clear_has_szDeviceId();
        _szDeviceId.clear();
     }
}

inline bool SessionOpenedStatus::hasSzDeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SessionOpenedStatus::getSzDeviceId () const {
    return _szDeviceId;
}

inline ::std::string& SessionOpenedStatus::getSzDeviceIdMutable () {
    set_has_szDeviceId();
    return _szDeviceId;
}

inline void SessionOpenedStatus::setSzDeviceId (const ::std::string& szDeviceId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId = szDeviceId_;
}

inline void SessionOpenedStatus::setSzDeviceId (const char* szDeviceId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId.assign(szDeviceId_);
}

inline void SessionOpenedStatus::setSzDeviceId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId.assign(value, size);
}

inline void SessionOpenedStatus::clearSzAppName() {
    if (hasSzAppName()) {
         clear_has_szAppName();
        _szAppName.clear();
     }
}

inline bool SessionOpenedStatus::hasSzAppName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SessionOpenedStatus::getSzAppName () const {
    return _szAppName;
}

inline ::std::string& SessionOpenedStatus::getSzAppNameMutable () {
    set_has_szAppName();
    return _szAppName;
}

inline void SessionOpenedStatus::setSzAppName (const ::std::string& szAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName = szAppName_;
}

inline void SessionOpenedStatus::setSzAppName (const char* szAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName.assign(szAppName_);
}

inline void SessionOpenedStatus::setSzAppName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName.assign(value, size);
}

inline void SessionOpenedStatus::clearU16SessionId() {
    if (hasU16SessionId()) {
         clear_has_u16SessionId();
        _u16SessionId = 0u;
     }
}

inline bool SessionOpenedStatus::hasU16SessionId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 SessionOpenedStatus::getU16SessionId () const {
    return _u16SessionId;
}

inline void SessionOpenedStatus::setU16SessionId (uint16 u16SessionId_) {
    set_has_u16SessionId();
    this->_u16SessionId = u16SessionId_;
}

inline void SessionOpenedStatus::clearSzProtocolName() {
    if (hasSzProtocolName()) {
         clear_has_szProtocolName();
        _szProtocolName.clear();
     }
}

inline bool SessionOpenedStatus::hasSzProtocolName () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& SessionOpenedStatus::getSzProtocolName () const {
    return _szProtocolName;
}

inline ::std::string& SessionOpenedStatus::getSzProtocolNameMutable () {
    set_has_szProtocolName();
    return _szProtocolName;
}

inline void SessionOpenedStatus::setSzProtocolName (const ::std::string& szProtocolName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szProtocolName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szProtocolName();
    this->_szProtocolName = szProtocolName_;
}

inline void SessionOpenedStatus::setSzProtocolName (const char* szProtocolName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szProtocolName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szProtocolName();
    this->_szProtocolName.assign(szProtocolName_);
}

inline void SessionOpenedStatus::setSzProtocolName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szProtocolName();
    this->_szProtocolName.assign(value, size);
}

inline void SessionOpenedStatus::set_has_szDeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void SessionOpenedStatus::clear_has_szDeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SessionOpenedStatus::set_has_szAppName () {
    _has_bits_[0] |= 1u << 1;
}

inline void SessionOpenedStatus::clear_has_szAppName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SessionOpenedStatus::set_has_u16SessionId () {
    _has_bits_[0] |= 1u << 2;
}

inline void SessionOpenedStatus::clear_has_u16SessionId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SessionOpenedStatus::set_has_szProtocolName () {
    _has_bits_[0] |= 1u << 3;
}

inline void SessionOpenedStatus::clear_has_szProtocolName () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  SessionClosedStatus::SessionClosedStatus ()  :
    _szDeviceId (),
    _szAppName (),
    _u16SessionId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SessionClosedStatus::SessionClosedStatus (const SessionClosedStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _szDeviceId (),
    _szAppName (),
    _u16SessionId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SessionClosedStatus::SessionClosedStatus (const ::std::string& szDeviceId_, const ::std::string& szAppName_, uint16 u16SessionId_)  :
    _szDeviceId (szDeviceId_),
    _szAppName (szAppName_),
    _u16SessionId (u16SessionId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SessionClosedStatus::~SessionClosedStatus() {
}

inline SessionClosedStatus& SessionClosedStatus::operator = (const SessionClosedStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSzDeviceId()) {
            setSzDeviceId(rhs.getSzDeviceId());
        } else {
            clearSzDeviceId();
        }
        if (rhs.hasSzAppName()) {
            setSzAppName(rhs.getSzAppName());
        } else {
            clearSzAppName();
        }
        if (rhs.hasU16SessionId()) {
            setU16SessionId(rhs.getU16SessionId());
        } else {
            clearU16SessionId();
        }
    }
    return *this;
}

inline bool SessionClosedStatus::operator == (const SessionClosedStatus& rhs) const {
    return (((!hasSzDeviceId() && !rhs.hasSzDeviceId()) || getSzDeviceId() == rhs.getSzDeviceId()) &&
        ((!hasSzAppName() && !rhs.hasSzAppName()) || getSzAppName() == rhs.getSzAppName()) &&
        ((!hasU16SessionId() && !rhs.hasU16SessionId()) || getU16SessionId() == rhs.getU16SessionId()));
}

inline bool SessionClosedStatus::operator != (const SessionClosedStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SessionClosedStatus::operator < (const SessionClosedStatus& rhs) const {
    if (hasSzDeviceId() || rhs.hasSzDeviceId()) {
        if (getSzDeviceId() < rhs.getSzDeviceId()) return true;
        if (getSzDeviceId() > rhs.getSzDeviceId()) return false;
    }
    if (hasSzAppName() || rhs.hasSzAppName()) {
        if (getSzAppName() < rhs.getSzAppName()) return true;
        if (getSzAppName() > rhs.getSzAppName()) return false;
    }
    if (hasU16SessionId() || rhs.hasU16SessionId()) {
        if (getU16SessionId() < rhs.getU16SessionId()) return true;
        if (getU16SessionId() > rhs.getU16SessionId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SessionClosedStatus::clone() {
    return new SessionClosedStatus(*this);
}

inline bool SessionClosedStatus::operator > (const SessionClosedStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SessionClosedStatus::clear() {
    clearSzDeviceId();
    clearSzAppName();
    clearU16SessionId();
}

inline void SessionClosedStatus::clearSzDeviceId() {
    if (hasSzDeviceId()) {
         clear_has_szDeviceId();
        _szDeviceId.clear();
     }
}

inline bool SessionClosedStatus::hasSzDeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SessionClosedStatus::getSzDeviceId () const {
    return _szDeviceId;
}

inline ::std::string& SessionClosedStatus::getSzDeviceIdMutable () {
    set_has_szDeviceId();
    return _szDeviceId;
}

inline void SessionClosedStatus::setSzDeviceId (const ::std::string& szDeviceId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId = szDeviceId_;
}

inline void SessionClosedStatus::setSzDeviceId (const char* szDeviceId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId.assign(szDeviceId_);
}

inline void SessionClosedStatus::setSzDeviceId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId.assign(value, size);
}

inline void SessionClosedStatus::clearSzAppName() {
    if (hasSzAppName()) {
         clear_has_szAppName();
        _szAppName.clear();
     }
}

inline bool SessionClosedStatus::hasSzAppName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SessionClosedStatus::getSzAppName () const {
    return _szAppName;
}

inline ::std::string& SessionClosedStatus::getSzAppNameMutable () {
    set_has_szAppName();
    return _szAppName;
}

inline void SessionClosedStatus::setSzAppName (const ::std::string& szAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName = szAppName_;
}

inline void SessionClosedStatus::setSzAppName (const char* szAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName.assign(szAppName_);
}

inline void SessionClosedStatus::setSzAppName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName.assign(value, size);
}

inline void SessionClosedStatus::clearU16SessionId() {
    if (hasU16SessionId()) {
         clear_has_u16SessionId();
        _u16SessionId = 0u;
     }
}

inline bool SessionClosedStatus::hasU16SessionId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 SessionClosedStatus::getU16SessionId () const {
    return _u16SessionId;
}

inline void SessionClosedStatus::setU16SessionId (uint16 u16SessionId_) {
    set_has_u16SessionId();
    this->_u16SessionId = u16SessionId_;
}

inline void SessionClosedStatus::set_has_szDeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void SessionClosedStatus::clear_has_szDeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SessionClosedStatus::set_has_szAppName () {
    _has_bits_[0] |= 1u << 1;
}

inline void SessionClosedStatus::clear_has_szAppName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SessionClosedStatus::set_has_u16SessionId () {
    _has_bits_[0] |= 1u << 2;
}

inline void SessionClosedStatus::clear_has_u16SessionId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  DiPODeviceConnectionsStatus::DiPODeviceConnectionsStatus ()  :
    _oDeviceInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPODeviceConnectionsStatus::DiPODeviceConnectionsStatus (const DiPODeviceConnectionsStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _oDeviceInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPODeviceConnectionsStatus::DiPODeviceConnectionsStatus (const ::mplay_appcontrol_fi_types::T_DiPODeviceInfo& oDeviceInfo_)  :
    _oDeviceInfo (oDeviceInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPODeviceConnectionsStatus::~DiPODeviceConnectionsStatus() {
}

inline DiPODeviceConnectionsStatus& DiPODeviceConnectionsStatus::operator = (const DiPODeviceConnectionsStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasODeviceInfo()) {
            setODeviceInfo(rhs.getODeviceInfo());
        } else {
            clearODeviceInfo();
        }
    }
    return *this;
}

inline bool DiPODeviceConnectionsStatus::operator == (const DiPODeviceConnectionsStatus& rhs) const {
    return (((!hasODeviceInfo() && !rhs.hasODeviceInfo()) || getODeviceInfo() == rhs.getODeviceInfo()));
}

inline bool DiPODeviceConnectionsStatus::operator != (const DiPODeviceConnectionsStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPODeviceConnectionsStatus::operator < (const DiPODeviceConnectionsStatus& rhs) const {
    if (hasODeviceInfo() || rhs.hasODeviceInfo()) {
        if (getODeviceInfo() < rhs.getODeviceInfo()) return true;
        if (getODeviceInfo() > rhs.getODeviceInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPODeviceConnectionsStatus::clone() {
    return new DiPODeviceConnectionsStatus(*this);
}

inline bool DiPODeviceConnectionsStatus::operator > (const DiPODeviceConnectionsStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPODeviceConnectionsStatus::clear() {
    clearODeviceInfo();
}

inline void DiPODeviceConnectionsStatus::clearODeviceInfo() {
    if (hasODeviceInfo()) {
         clear_has_oDeviceInfo();
        _oDeviceInfo.clear();
     }
}

inline bool DiPODeviceConnectionsStatus::hasODeviceInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::mplay_appcontrol_fi_types::T_DiPODeviceInfo& DiPODeviceConnectionsStatus::getODeviceInfo () const {
    return _oDeviceInfo;
}

inline ::mplay_appcontrol_fi_types::T_DiPODeviceInfo& DiPODeviceConnectionsStatus::getODeviceInfoMutable () {
    set_has_oDeviceInfo();
    return _oDeviceInfo;
}

inline void DiPODeviceConnectionsStatus::setODeviceInfo (const ::mplay_appcontrol_fi_types::T_DiPODeviceInfo& oDeviceInfo_) {
    set_has_oDeviceInfo();
    this->_oDeviceInfo = oDeviceInfo_;
}

inline void DiPODeviceConnectionsStatus::set_has_oDeviceInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPODeviceConnectionsStatus::clear_has_oDeviceInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DiPOPlaytimeStatus::DiPOPlaytimeStatus ()  :
    _u8DeviceId (0u),
    _u32ElapsedPlaytime (0u),
    _u32TotalPlaytime (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPOPlaytimeStatus::DiPOPlaytimeStatus (const DiPOPlaytimeStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _u8DeviceId (0u),
    _u32ElapsedPlaytime (0u),
    _u32TotalPlaytime (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPOPlaytimeStatus::DiPOPlaytimeStatus (uint8 u8DeviceId_, uint32 u32ElapsedPlaytime_, uint32 u32TotalPlaytime_)  :
    _u8DeviceId (u8DeviceId_),
    _u32ElapsedPlaytime (u32ElapsedPlaytime_),
    _u32TotalPlaytime (u32TotalPlaytime_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPOPlaytimeStatus::~DiPOPlaytimeStatus() {
}

inline DiPOPlaytimeStatus& DiPOPlaytimeStatus::operator = (const DiPOPlaytimeStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8DeviceId()) {
            setU8DeviceId(rhs.getU8DeviceId());
        } else {
            clearU8DeviceId();
        }
        if (rhs.hasU32ElapsedPlaytime()) {
            setU32ElapsedPlaytime(rhs.getU32ElapsedPlaytime());
        } else {
            clearU32ElapsedPlaytime();
        }
        if (rhs.hasU32TotalPlaytime()) {
            setU32TotalPlaytime(rhs.getU32TotalPlaytime());
        } else {
            clearU32TotalPlaytime();
        }
    }
    return *this;
}

inline bool DiPOPlaytimeStatus::operator == (const DiPOPlaytimeStatus& rhs) const {
    return (((!hasU8DeviceId() && !rhs.hasU8DeviceId()) || getU8DeviceId() == rhs.getU8DeviceId()) &&
        ((!hasU32ElapsedPlaytime() && !rhs.hasU32ElapsedPlaytime()) || getU32ElapsedPlaytime() == rhs.getU32ElapsedPlaytime()) &&
        ((!hasU32TotalPlaytime() && !rhs.hasU32TotalPlaytime()) || getU32TotalPlaytime() == rhs.getU32TotalPlaytime()));
}

inline bool DiPOPlaytimeStatus::operator != (const DiPOPlaytimeStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPOPlaytimeStatus::operator < (const DiPOPlaytimeStatus& rhs) const {
    if (hasU8DeviceId() || rhs.hasU8DeviceId()) {
        if (getU8DeviceId() < rhs.getU8DeviceId()) return true;
        if (getU8DeviceId() > rhs.getU8DeviceId()) return false;
    }
    if (hasU32ElapsedPlaytime() || rhs.hasU32ElapsedPlaytime()) {
        if (getU32ElapsedPlaytime() < rhs.getU32ElapsedPlaytime()) return true;
        if (getU32ElapsedPlaytime() > rhs.getU32ElapsedPlaytime()) return false;
    }
    if (hasU32TotalPlaytime() || rhs.hasU32TotalPlaytime()) {
        if (getU32TotalPlaytime() < rhs.getU32TotalPlaytime()) return true;
        if (getU32TotalPlaytime() > rhs.getU32TotalPlaytime()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPOPlaytimeStatus::clone() {
    return new DiPOPlaytimeStatus(*this);
}

inline bool DiPOPlaytimeStatus::operator > (const DiPOPlaytimeStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPOPlaytimeStatus::clear() {
    clearU8DeviceId();
    clearU32ElapsedPlaytime();
    clearU32TotalPlaytime();
}

inline void DiPOPlaytimeStatus::clearU8DeviceId() {
    if (hasU8DeviceId()) {
         clear_has_u8DeviceId();
        _u8DeviceId = 0u;
     }
}

inline bool DiPOPlaytimeStatus::hasU8DeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DiPOPlaytimeStatus::getU8DeviceId () const {
    return _u8DeviceId;
}

inline void DiPOPlaytimeStatus::setU8DeviceId (uint8 u8DeviceId_) {
    set_has_u8DeviceId();
    this->_u8DeviceId = u8DeviceId_;
}

inline void DiPOPlaytimeStatus::clearU32ElapsedPlaytime() {
    if (hasU32ElapsedPlaytime()) {
         clear_has_u32ElapsedPlaytime();
        _u32ElapsedPlaytime = 0u;
     }
}

inline bool DiPOPlaytimeStatus::hasU32ElapsedPlaytime () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 DiPOPlaytimeStatus::getU32ElapsedPlaytime () const {
    return _u32ElapsedPlaytime;
}

inline void DiPOPlaytimeStatus::setU32ElapsedPlaytime (uint32 u32ElapsedPlaytime_) {
    set_has_u32ElapsedPlaytime();
    this->_u32ElapsedPlaytime = u32ElapsedPlaytime_;
}

inline void DiPOPlaytimeStatus::clearU32TotalPlaytime() {
    if (hasU32TotalPlaytime()) {
         clear_has_u32TotalPlaytime();
        _u32TotalPlaytime = 0u;
     }
}

inline bool DiPOPlaytimeStatus::hasU32TotalPlaytime () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 DiPOPlaytimeStatus::getU32TotalPlaytime () const {
    return _u32TotalPlaytime;
}

inline void DiPOPlaytimeStatus::setU32TotalPlaytime (uint32 u32TotalPlaytime_) {
    set_has_u32TotalPlaytime();
    this->_u32TotalPlaytime = u32TotalPlaytime_;
}

inline void DiPOPlaytimeStatus::set_has_u8DeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPOPlaytimeStatus::clear_has_u8DeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiPOPlaytimeStatus::set_has_u32ElapsedPlaytime () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiPOPlaytimeStatus::clear_has_u32ElapsedPlaytime () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DiPOPlaytimeStatus::set_has_u32TotalPlaytime () {
    _has_bits_[0] |= 1u << 2;
}

inline void DiPOPlaytimeStatus::clear_has_u32TotalPlaytime () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  DiPOLocationInfoStatus::DiPOLocationInfoStatus ()  :
    _bStartStopLocationInfo (false),
    _b8LocationInfoType ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPOLocationInfoStatus::DiPOLocationInfoStatus (const DiPOLocationInfoStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _bStartStopLocationInfo (false),
    _b8LocationInfoType ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPOLocationInfoStatus::DiPOLocationInfoStatus (bool bStartStopLocationInfo_, const ::mplay_appcontrol_fi_types::T_b8_DiPOLocationInfoType& b8LocationInfoType_)  :
    _bStartStopLocationInfo (bStartStopLocationInfo_),
    _b8LocationInfoType (b8LocationInfoType_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPOLocationInfoStatus::~DiPOLocationInfoStatus() {
}

inline DiPOLocationInfoStatus& DiPOLocationInfoStatus::operator = (const DiPOLocationInfoStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBStartStopLocationInfo()) {
            setBStartStopLocationInfo(rhs.getBStartStopLocationInfo());
        } else {
            clearBStartStopLocationInfo();
        }
        if (rhs.hasB8LocationInfoType()) {
            setB8LocationInfoType(rhs.getB8LocationInfoType());
        } else {
            clearB8LocationInfoType();
        }
    }
    return *this;
}

inline bool DiPOLocationInfoStatus::operator == (const DiPOLocationInfoStatus& rhs) const {
    return (((!hasBStartStopLocationInfo() && !rhs.hasBStartStopLocationInfo()) || getBStartStopLocationInfo() == rhs.getBStartStopLocationInfo()) &&
        ((!hasB8LocationInfoType() && !rhs.hasB8LocationInfoType()) || getB8LocationInfoType() == rhs.getB8LocationInfoType()));
}

inline bool DiPOLocationInfoStatus::operator != (const DiPOLocationInfoStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPOLocationInfoStatus::operator < (const DiPOLocationInfoStatus& rhs) const {
    if (hasBStartStopLocationInfo() || rhs.hasBStartStopLocationInfo()) {
        if (getBStartStopLocationInfo() < rhs.getBStartStopLocationInfo()) return true;
        if (getBStartStopLocationInfo() > rhs.getBStartStopLocationInfo()) return false;
    }
    if (hasB8LocationInfoType() || rhs.hasB8LocationInfoType()) {
        if (getB8LocationInfoType() < rhs.getB8LocationInfoType()) return true;
        if (getB8LocationInfoType() > rhs.getB8LocationInfoType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPOLocationInfoStatus::clone() {
    return new DiPOLocationInfoStatus(*this);
}

inline bool DiPOLocationInfoStatus::operator > (const DiPOLocationInfoStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPOLocationInfoStatus::clear() {
    clearBStartStopLocationInfo();
    clearB8LocationInfoType();
}

inline void DiPOLocationInfoStatus::clearBStartStopLocationInfo() {
    if (hasBStartStopLocationInfo()) {
         clear_has_bStartStopLocationInfo();
        _bStartStopLocationInfo = false;
     }
}

inline bool DiPOLocationInfoStatus::hasBStartStopLocationInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DiPOLocationInfoStatus::getBStartStopLocationInfo () const {
    return _bStartStopLocationInfo;
}

inline void DiPOLocationInfoStatus::setBStartStopLocationInfo (bool bStartStopLocationInfo_) {
    set_has_bStartStopLocationInfo();
    this->_bStartStopLocationInfo = bStartStopLocationInfo_;
}

inline void DiPOLocationInfoStatus::clearB8LocationInfoType() {
    if (hasB8LocationInfoType()) {
         clear_has_b8LocationInfoType();
        _b8LocationInfoType = ::mplay_appcontrol_fi_types::T_b8_DiPOLocationInfoType ();
     }
}

inline bool DiPOLocationInfoStatus::hasB8LocationInfoType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::mplay_appcontrol_fi_types::T_b8_DiPOLocationInfoType& DiPOLocationInfoStatus::getB8LocationInfoType () const {
    return _b8LocationInfoType;
}

inline ::mplay_appcontrol_fi_types::T_b8_DiPOLocationInfoType& DiPOLocationInfoStatus::getB8LocationInfoTypeMutable () {
    set_has_b8LocationInfoType();
    return _b8LocationInfoType;
}

inline void DiPOLocationInfoStatus::setB8LocationInfoType (const ::mplay_appcontrol_fi_types::T_b8_DiPOLocationInfoType& b8LocationInfoType_) {
    set_has_b8LocationInfoType();
    this->_b8LocationInfoType = b8LocationInfoType_;
}

inline void DiPOLocationInfoStatus::set_has_bStartStopLocationInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPOLocationInfoStatus::clear_has_bStartStopLocationInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiPOLocationInfoStatus::set_has_b8LocationInfoType () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiPOLocationInfoStatus::clear_has_b8LocationInfoType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DiPOMetaDataStatus::DiPOMetaDataStatus ()  :
    _u8DeviceId (0u),
    _sArtist (),
    _sTitle (),
    _sAlbum (),
    _sGenre (),
    _sAlbumArt (),
    _sAppName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPOMetaDataStatus::DiPOMetaDataStatus (const DiPOMetaDataStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _u8DeviceId (0u),
    _sArtist (),
    _sTitle (),
    _sAlbum (),
    _sGenre (),
    _sAlbumArt (),
    _sAppName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPOMetaDataStatus::DiPOMetaDataStatus (uint8 u8DeviceId_, const ::std::string& sArtist_, const ::std::string& sTitle_, const ::std::string& sAlbum_, const ::std::string& sGenre_, const ::std::string& sAlbumArt_, const ::std::string& sAppName_)  :
    _u8DeviceId (u8DeviceId_),
    _sArtist (sArtist_),
    _sTitle (sTitle_),
    _sAlbum (sAlbum_),
    _sGenre (sGenre_),
    _sAlbumArt (sAlbumArt_),
    _sAppName (sAppName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sArtist_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAlbum_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sGenre_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAlbumArt_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPOMetaDataStatus::~DiPOMetaDataStatus() {
}

inline DiPOMetaDataStatus& DiPOMetaDataStatus::operator = (const DiPOMetaDataStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8DeviceId()) {
            setU8DeviceId(rhs.getU8DeviceId());
        } else {
            clearU8DeviceId();
        }
        if (rhs.hasSArtist()) {
            setSArtist(rhs.getSArtist());
        } else {
            clearSArtist();
        }
        if (rhs.hasSTitle()) {
            setSTitle(rhs.getSTitle());
        } else {
            clearSTitle();
        }
        if (rhs.hasSAlbum()) {
            setSAlbum(rhs.getSAlbum());
        } else {
            clearSAlbum();
        }
        if (rhs.hasSGenre()) {
            setSGenre(rhs.getSGenre());
        } else {
            clearSGenre();
        }
        if (rhs.hasSAlbumArt()) {
            setSAlbumArt(rhs.getSAlbumArt());
        } else {
            clearSAlbumArt();
        }
        if (rhs.hasSAppName()) {
            setSAppName(rhs.getSAppName());
        } else {
            clearSAppName();
        }
    }
    return *this;
}

inline bool DiPOMetaDataStatus::operator == (const DiPOMetaDataStatus& rhs) const {
    return (((!hasU8DeviceId() && !rhs.hasU8DeviceId()) || getU8DeviceId() == rhs.getU8DeviceId()) &&
        ((!hasSArtist() && !rhs.hasSArtist()) || getSArtist() == rhs.getSArtist()) &&
        ((!hasSTitle() && !rhs.hasSTitle()) || getSTitle() == rhs.getSTitle()) &&
        ((!hasSAlbum() && !rhs.hasSAlbum()) || getSAlbum() == rhs.getSAlbum()) &&
        ((!hasSGenre() && !rhs.hasSGenre()) || getSGenre() == rhs.getSGenre()) &&
        ((!hasSAlbumArt() && !rhs.hasSAlbumArt()) || getSAlbumArt() == rhs.getSAlbumArt()) &&
        ((!hasSAppName() && !rhs.hasSAppName()) || getSAppName() == rhs.getSAppName()));
}

inline bool DiPOMetaDataStatus::operator != (const DiPOMetaDataStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPOMetaDataStatus::operator < (const DiPOMetaDataStatus& rhs) const {
    if (hasU8DeviceId() || rhs.hasU8DeviceId()) {
        if (getU8DeviceId() < rhs.getU8DeviceId()) return true;
        if (getU8DeviceId() > rhs.getU8DeviceId()) return false;
    }
    if (hasSArtist() || rhs.hasSArtist()) {
        if (getSArtist() < rhs.getSArtist()) return true;
        if (getSArtist() > rhs.getSArtist()) return false;
    }
    if (hasSTitle() || rhs.hasSTitle()) {
        if (getSTitle() < rhs.getSTitle()) return true;
        if (getSTitle() > rhs.getSTitle()) return false;
    }
    if (hasSAlbum() || rhs.hasSAlbum()) {
        if (getSAlbum() < rhs.getSAlbum()) return true;
        if (getSAlbum() > rhs.getSAlbum()) return false;
    }
    if (hasSGenre() || rhs.hasSGenre()) {
        if (getSGenre() < rhs.getSGenre()) return true;
        if (getSGenre() > rhs.getSGenre()) return false;
    }
    if (hasSAlbumArt() || rhs.hasSAlbumArt()) {
        if (getSAlbumArt() < rhs.getSAlbumArt()) return true;
        if (getSAlbumArt() > rhs.getSAlbumArt()) return false;
    }
    if (hasSAppName() || rhs.hasSAppName()) {
        if (getSAppName() < rhs.getSAppName()) return true;
        if (getSAppName() > rhs.getSAppName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPOMetaDataStatus::clone() {
    return new DiPOMetaDataStatus(*this);
}

inline bool DiPOMetaDataStatus::operator > (const DiPOMetaDataStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPOMetaDataStatus::clear() {
    clearU8DeviceId();
    clearSArtist();
    clearSTitle();
    clearSAlbum();
    clearSGenre();
    clearSAlbumArt();
    clearSAppName();
}

inline void DiPOMetaDataStatus::clearU8DeviceId() {
    if (hasU8DeviceId()) {
         clear_has_u8DeviceId();
        _u8DeviceId = 0u;
     }
}

inline bool DiPOMetaDataStatus::hasU8DeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DiPOMetaDataStatus::getU8DeviceId () const {
    return _u8DeviceId;
}

inline void DiPOMetaDataStatus::setU8DeviceId (uint8 u8DeviceId_) {
    set_has_u8DeviceId();
    this->_u8DeviceId = u8DeviceId_;
}

inline void DiPOMetaDataStatus::clearSArtist() {
    if (hasSArtist()) {
         clear_has_sArtist();
        _sArtist.clear();
     }
}

inline bool DiPOMetaDataStatus::hasSArtist () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& DiPOMetaDataStatus::getSArtist () const {
    return _sArtist;
}

inline ::std::string& DiPOMetaDataStatus::getSArtistMutable () {
    set_has_sArtist();
    return _sArtist;
}

inline void DiPOMetaDataStatus::setSArtist (const ::std::string& sArtist_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sArtist_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sArtist();
    this->_sArtist = sArtist_;
}

inline void DiPOMetaDataStatus::setSArtist (const char* sArtist_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sArtist_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sArtist();
    this->_sArtist.assign(sArtist_);
}

inline void DiPOMetaDataStatus::setSArtist (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sArtist();
    this->_sArtist.assign(value, size);
}

inline void DiPOMetaDataStatus::clearSTitle() {
    if (hasSTitle()) {
         clear_has_sTitle();
        _sTitle.clear();
     }
}

inline bool DiPOMetaDataStatus::hasSTitle () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& DiPOMetaDataStatus::getSTitle () const {
    return _sTitle;
}

inline ::std::string& DiPOMetaDataStatus::getSTitleMutable () {
    set_has_sTitle();
    return _sTitle;
}

inline void DiPOMetaDataStatus::setSTitle (const ::std::string& sTitle_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTitle();
    this->_sTitle = sTitle_;
}

inline void DiPOMetaDataStatus::setSTitle (const char* sTitle_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTitle();
    this->_sTitle.assign(sTitle_);
}

inline void DiPOMetaDataStatus::setSTitle (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTitle();
    this->_sTitle.assign(value, size);
}

inline void DiPOMetaDataStatus::clearSAlbum() {
    if (hasSAlbum()) {
         clear_has_sAlbum();
        _sAlbum.clear();
     }
}

inline bool DiPOMetaDataStatus::hasSAlbum () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& DiPOMetaDataStatus::getSAlbum () const {
    return _sAlbum;
}

inline ::std::string& DiPOMetaDataStatus::getSAlbumMutable () {
    set_has_sAlbum();
    return _sAlbum;
}

inline void DiPOMetaDataStatus::setSAlbum (const ::std::string& sAlbum_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAlbum_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAlbum();
    this->_sAlbum = sAlbum_;
}

inline void DiPOMetaDataStatus::setSAlbum (const char* sAlbum_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAlbum_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAlbum();
    this->_sAlbum.assign(sAlbum_);
}

inline void DiPOMetaDataStatus::setSAlbum (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAlbum();
    this->_sAlbum.assign(value, size);
}

inline void DiPOMetaDataStatus::clearSGenre() {
    if (hasSGenre()) {
         clear_has_sGenre();
        _sGenre.clear();
     }
}

inline bool DiPOMetaDataStatus::hasSGenre () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& DiPOMetaDataStatus::getSGenre () const {
    return _sGenre;
}

inline ::std::string& DiPOMetaDataStatus::getSGenreMutable () {
    set_has_sGenre();
    return _sGenre;
}

inline void DiPOMetaDataStatus::setSGenre (const ::std::string& sGenre_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sGenre_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sGenre();
    this->_sGenre = sGenre_;
}

inline void DiPOMetaDataStatus::setSGenre (const char* sGenre_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sGenre_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sGenre();
    this->_sGenre.assign(sGenre_);
}

inline void DiPOMetaDataStatus::setSGenre (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sGenre();
    this->_sGenre.assign(value, size);
}

inline void DiPOMetaDataStatus::clearSAlbumArt() {
    if (hasSAlbumArt()) {
         clear_has_sAlbumArt();
        _sAlbumArt.clear();
     }
}

inline bool DiPOMetaDataStatus::hasSAlbumArt () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& DiPOMetaDataStatus::getSAlbumArt () const {
    return _sAlbumArt;
}

inline ::std::string& DiPOMetaDataStatus::getSAlbumArtMutable () {
    set_has_sAlbumArt();
    return _sAlbumArt;
}

inline void DiPOMetaDataStatus::setSAlbumArt (const ::std::string& sAlbumArt_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAlbumArt_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAlbumArt();
    this->_sAlbumArt = sAlbumArt_;
}

inline void DiPOMetaDataStatus::setSAlbumArt (const char* sAlbumArt_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAlbumArt_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAlbumArt();
    this->_sAlbumArt.assign(sAlbumArt_);
}

inline void DiPOMetaDataStatus::setSAlbumArt (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAlbumArt();
    this->_sAlbumArt.assign(value, size);
}

inline void DiPOMetaDataStatus::clearSAppName() {
    if (hasSAppName()) {
         clear_has_sAppName();
        _sAppName.clear();
     }
}

inline bool DiPOMetaDataStatus::hasSAppName () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& DiPOMetaDataStatus::getSAppName () const {
    return _sAppName;
}

inline ::std::string& DiPOMetaDataStatus::getSAppNameMutable () {
    set_has_sAppName();
    return _sAppName;
}

inline void DiPOMetaDataStatus::setSAppName (const ::std::string& sAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAppName();
    this->_sAppName = sAppName_;
}

inline void DiPOMetaDataStatus::setSAppName (const char* sAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAppName();
    this->_sAppName.assign(sAppName_);
}

inline void DiPOMetaDataStatus::setSAppName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAppName();
    this->_sAppName.assign(value, size);
}

inline void DiPOMetaDataStatus::set_has_u8DeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPOMetaDataStatus::clear_has_u8DeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiPOMetaDataStatus::set_has_sArtist () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiPOMetaDataStatus::clear_has_sArtist () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DiPOMetaDataStatus::set_has_sTitle () {
    _has_bits_[0] |= 1u << 2;
}

inline void DiPOMetaDataStatus::clear_has_sTitle () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DiPOMetaDataStatus::set_has_sAlbum () {
    _has_bits_[0] |= 1u << 3;
}

inline void DiPOMetaDataStatus::clear_has_sAlbum () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void DiPOMetaDataStatus::set_has_sGenre () {
    _has_bits_[0] |= 1u << 4;
}

inline void DiPOMetaDataStatus::clear_has_sGenre () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void DiPOMetaDataStatus::set_has_sAlbumArt () {
    _has_bits_[0] |= 1u << 5;
}

inline void DiPOMetaDataStatus::clear_has_sAlbumArt () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void DiPOMetaDataStatus::set_has_sAppName () {
    _has_bits_[0] |= 1u << 6;
}

inline void DiPOMetaDataStatus::clear_has_sAppName () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  DiPOPhoneDataStatus::DiPOPhoneDataStatus ()  :
    _sPhoneCaller (),
    _sPhoneCallInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPOPhoneDataStatus::DiPOPhoneDataStatus (const DiPOPhoneDataStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _sPhoneCaller (),
    _sPhoneCallInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPOPhoneDataStatus::DiPOPhoneDataStatus (const ::std::string& sPhoneCaller_, const ::std::string& sPhoneCallInfo_)  :
    _sPhoneCaller (sPhoneCaller_),
    _sPhoneCallInfo (sPhoneCallInfo_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPhoneCaller_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPhoneCallInfo_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPOPhoneDataStatus::~DiPOPhoneDataStatus() {
}

inline DiPOPhoneDataStatus& DiPOPhoneDataStatus::operator = (const DiPOPhoneDataStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSPhoneCaller()) {
            setSPhoneCaller(rhs.getSPhoneCaller());
        } else {
            clearSPhoneCaller();
        }
        if (rhs.hasSPhoneCallInfo()) {
            setSPhoneCallInfo(rhs.getSPhoneCallInfo());
        } else {
            clearSPhoneCallInfo();
        }
    }
    return *this;
}

inline bool DiPOPhoneDataStatus::operator == (const DiPOPhoneDataStatus& rhs) const {
    return (((!hasSPhoneCaller() && !rhs.hasSPhoneCaller()) || getSPhoneCaller() == rhs.getSPhoneCaller()) &&
        ((!hasSPhoneCallInfo() && !rhs.hasSPhoneCallInfo()) || getSPhoneCallInfo() == rhs.getSPhoneCallInfo()));
}

inline bool DiPOPhoneDataStatus::operator != (const DiPOPhoneDataStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPOPhoneDataStatus::operator < (const DiPOPhoneDataStatus& rhs) const {
    if (hasSPhoneCaller() || rhs.hasSPhoneCaller()) {
        if (getSPhoneCaller() < rhs.getSPhoneCaller()) return true;
        if (getSPhoneCaller() > rhs.getSPhoneCaller()) return false;
    }
    if (hasSPhoneCallInfo() || rhs.hasSPhoneCallInfo()) {
        if (getSPhoneCallInfo() < rhs.getSPhoneCallInfo()) return true;
        if (getSPhoneCallInfo() > rhs.getSPhoneCallInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPOPhoneDataStatus::clone() {
    return new DiPOPhoneDataStatus(*this);
}

inline bool DiPOPhoneDataStatus::operator > (const DiPOPhoneDataStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPOPhoneDataStatus::clear() {
    clearSPhoneCaller();
    clearSPhoneCallInfo();
}

inline void DiPOPhoneDataStatus::clearSPhoneCaller() {
    if (hasSPhoneCaller()) {
         clear_has_sPhoneCaller();
        _sPhoneCaller.clear();
     }
}

inline bool DiPOPhoneDataStatus::hasSPhoneCaller () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DiPOPhoneDataStatus::getSPhoneCaller () const {
    return _sPhoneCaller;
}

inline ::std::string& DiPOPhoneDataStatus::getSPhoneCallerMutable () {
    set_has_sPhoneCaller();
    return _sPhoneCaller;
}

inline void DiPOPhoneDataStatus::setSPhoneCaller (const ::std::string& sPhoneCaller_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPhoneCaller_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPhoneCaller();
    this->_sPhoneCaller = sPhoneCaller_;
}

inline void DiPOPhoneDataStatus::setSPhoneCaller (const char* sPhoneCaller_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPhoneCaller_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPhoneCaller();
    this->_sPhoneCaller.assign(sPhoneCaller_);
}

inline void DiPOPhoneDataStatus::setSPhoneCaller (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPhoneCaller();
    this->_sPhoneCaller.assign(value, size);
}

inline void DiPOPhoneDataStatus::clearSPhoneCallInfo() {
    if (hasSPhoneCallInfo()) {
         clear_has_sPhoneCallInfo();
        _sPhoneCallInfo.clear();
     }
}

inline bool DiPOPhoneDataStatus::hasSPhoneCallInfo () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& DiPOPhoneDataStatus::getSPhoneCallInfo () const {
    return _sPhoneCallInfo;
}

inline ::std::string& DiPOPhoneDataStatus::getSPhoneCallInfoMutable () {
    set_has_sPhoneCallInfo();
    return _sPhoneCallInfo;
}

inline void DiPOPhoneDataStatus::setSPhoneCallInfo (const ::std::string& sPhoneCallInfo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPhoneCallInfo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPhoneCallInfo();
    this->_sPhoneCallInfo = sPhoneCallInfo_;
}

inline void DiPOPhoneDataStatus::setSPhoneCallInfo (const char* sPhoneCallInfo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPhoneCallInfo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPhoneCallInfo();
    this->_sPhoneCallInfo.assign(sPhoneCallInfo_);
}

inline void DiPOPhoneDataStatus::setSPhoneCallInfo (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPhoneCallInfo();
    this->_sPhoneCallInfo.assign(value, size);
}

inline void DiPOPhoneDataStatus::set_has_sPhoneCaller () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPOPhoneDataStatus::clear_has_sPhoneCaller () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiPOPhoneDataStatus::set_has_sPhoneCallInfo () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiPOPhoneDataStatus::clear_has_sPhoneCallInfo () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  NativeTransportStartStatus::NativeTransportStartStatus ()  :
    _u32DeviceId (0u),
    _u8IAP2iOSAppIdentifier (0u),
    _u8SinkEndpoint (0u),
    _u8SourceEndpoint (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NativeTransportStartStatus::NativeTransportStartStatus (const NativeTransportStartStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _u32DeviceId (0u),
    _u8IAP2iOSAppIdentifier (0u),
    _u8SinkEndpoint (0u),
    _u8SourceEndpoint (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NativeTransportStartStatus::NativeTransportStartStatus (uint32 u32DeviceId_, uint8 u8IAP2iOSAppIdentifier_, uint8 u8SinkEndpoint_, uint8 u8SourceEndpoint_)  :
    _u32DeviceId (u32DeviceId_),
    _u8IAP2iOSAppIdentifier (u8IAP2iOSAppIdentifier_),
    _u8SinkEndpoint (u8SinkEndpoint_),
    _u8SourceEndpoint (u8SourceEndpoint_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NativeTransportStartStatus::~NativeTransportStartStatus() {
}

inline NativeTransportStartStatus& NativeTransportStartStatus::operator = (const NativeTransportStartStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU32DeviceId()) {
            setU32DeviceId(rhs.getU32DeviceId());
        } else {
            clearU32DeviceId();
        }
        if (rhs.hasU8IAP2iOSAppIdentifier()) {
            setU8IAP2iOSAppIdentifier(rhs.getU8IAP2iOSAppIdentifier());
        } else {
            clearU8IAP2iOSAppIdentifier();
        }
        if (rhs.hasU8SinkEndpoint()) {
            setU8SinkEndpoint(rhs.getU8SinkEndpoint());
        } else {
            clearU8SinkEndpoint();
        }
        if (rhs.hasU8SourceEndpoint()) {
            setU8SourceEndpoint(rhs.getU8SourceEndpoint());
        } else {
            clearU8SourceEndpoint();
        }
    }
    return *this;
}

inline bool NativeTransportStartStatus::operator == (const NativeTransportStartStatus& rhs) const {
    return (((!hasU32DeviceId() && !rhs.hasU32DeviceId()) || getU32DeviceId() == rhs.getU32DeviceId()) &&
        ((!hasU8IAP2iOSAppIdentifier() && !rhs.hasU8IAP2iOSAppIdentifier()) || getU8IAP2iOSAppIdentifier() == rhs.getU8IAP2iOSAppIdentifier()) &&
        ((!hasU8SinkEndpoint() && !rhs.hasU8SinkEndpoint()) || getU8SinkEndpoint() == rhs.getU8SinkEndpoint()) &&
        ((!hasU8SourceEndpoint() && !rhs.hasU8SourceEndpoint()) || getU8SourceEndpoint() == rhs.getU8SourceEndpoint()));
}

inline bool NativeTransportStartStatus::operator != (const NativeTransportStartStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool NativeTransportStartStatus::operator < (const NativeTransportStartStatus& rhs) const {
    if (hasU32DeviceId() || rhs.hasU32DeviceId()) {
        if (getU32DeviceId() < rhs.getU32DeviceId()) return true;
        if (getU32DeviceId() > rhs.getU32DeviceId()) return false;
    }
    if (hasU8IAP2iOSAppIdentifier() || rhs.hasU8IAP2iOSAppIdentifier()) {
        if (getU8IAP2iOSAppIdentifier() < rhs.getU8IAP2iOSAppIdentifier()) return true;
        if (getU8IAP2iOSAppIdentifier() > rhs.getU8IAP2iOSAppIdentifier()) return false;
    }
    if (hasU8SinkEndpoint() || rhs.hasU8SinkEndpoint()) {
        if (getU8SinkEndpoint() < rhs.getU8SinkEndpoint()) return true;
        if (getU8SinkEndpoint() > rhs.getU8SinkEndpoint()) return false;
    }
    if (hasU8SourceEndpoint() || rhs.hasU8SourceEndpoint()) {
        if (getU8SourceEndpoint() < rhs.getU8SourceEndpoint()) return true;
        if (getU8SourceEndpoint() > rhs.getU8SourceEndpoint()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NativeTransportStartStatus::clone() {
    return new NativeTransportStartStatus(*this);
}

inline bool NativeTransportStartStatus::operator > (const NativeTransportStartStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NativeTransportStartStatus::clear() {
    clearU32DeviceId();
    clearU8IAP2iOSAppIdentifier();
    clearU8SinkEndpoint();
    clearU8SourceEndpoint();
}

inline void NativeTransportStartStatus::clearU32DeviceId() {
    if (hasU32DeviceId()) {
         clear_has_u32DeviceId();
        _u32DeviceId = 0u;
     }
}

inline bool NativeTransportStartStatus::hasU32DeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 NativeTransportStartStatus::getU32DeviceId () const {
    return _u32DeviceId;
}

inline void NativeTransportStartStatus::setU32DeviceId (uint32 u32DeviceId_) {
    set_has_u32DeviceId();
    this->_u32DeviceId = u32DeviceId_;
}

inline void NativeTransportStartStatus::clearU8IAP2iOSAppIdentifier() {
    if (hasU8IAP2iOSAppIdentifier()) {
         clear_has_u8IAP2iOSAppIdentifier();
        _u8IAP2iOSAppIdentifier = 0u;
     }
}

inline bool NativeTransportStartStatus::hasU8IAP2iOSAppIdentifier () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 NativeTransportStartStatus::getU8IAP2iOSAppIdentifier () const {
    return _u8IAP2iOSAppIdentifier;
}

inline void NativeTransportStartStatus::setU8IAP2iOSAppIdentifier (uint8 u8IAP2iOSAppIdentifier_) {
    set_has_u8IAP2iOSAppIdentifier();
    this->_u8IAP2iOSAppIdentifier = u8IAP2iOSAppIdentifier_;
}

inline void NativeTransportStartStatus::clearU8SinkEndpoint() {
    if (hasU8SinkEndpoint()) {
         clear_has_u8SinkEndpoint();
        _u8SinkEndpoint = 0u;
     }
}

inline bool NativeTransportStartStatus::hasU8SinkEndpoint () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 NativeTransportStartStatus::getU8SinkEndpoint () const {
    return _u8SinkEndpoint;
}

inline void NativeTransportStartStatus::setU8SinkEndpoint (uint8 u8SinkEndpoint_) {
    set_has_u8SinkEndpoint();
    this->_u8SinkEndpoint = u8SinkEndpoint_;
}

inline void NativeTransportStartStatus::clearU8SourceEndpoint() {
    if (hasU8SourceEndpoint()) {
         clear_has_u8SourceEndpoint();
        _u8SourceEndpoint = 0u;
     }
}

inline bool NativeTransportStartStatus::hasU8SourceEndpoint () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 NativeTransportStartStatus::getU8SourceEndpoint () const {
    return _u8SourceEndpoint;
}

inline void NativeTransportStartStatus::setU8SourceEndpoint (uint8 u8SourceEndpoint_) {
    set_has_u8SourceEndpoint();
    this->_u8SourceEndpoint = u8SourceEndpoint_;
}

inline void NativeTransportStartStatus::set_has_u32DeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void NativeTransportStartStatus::clear_has_u32DeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void NativeTransportStartStatus::set_has_u8IAP2iOSAppIdentifier () {
    _has_bits_[0] |= 1u << 1;
}

inline void NativeTransportStartStatus::clear_has_u8IAP2iOSAppIdentifier () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void NativeTransportStartStatus::set_has_u8SinkEndpoint () {
    _has_bits_[0] |= 1u << 2;
}

inline void NativeTransportStartStatus::clear_has_u8SinkEndpoint () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void NativeTransportStartStatus::set_has_u8SourceEndpoint () {
    _has_bits_[0] |= 1u << 3;
}

inline void NativeTransportStartStatus::clear_has_u8SourceEndpoint () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  NativeTransportStopStatus::NativeTransportStopStatus ()  :
    _u32DeviceId (0u),
    _u8IAP2iOSAppIdentifier (0u),
    _u8SinkEndpoint (0u),
    _u8SourceEndpoint (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NativeTransportStopStatus::NativeTransportStopStatus (const NativeTransportStopStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _u32DeviceId (0u),
    _u8IAP2iOSAppIdentifier (0u),
    _u8SinkEndpoint (0u),
    _u8SourceEndpoint (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NativeTransportStopStatus::NativeTransportStopStatus (uint32 u32DeviceId_, uint8 u8IAP2iOSAppIdentifier_, uint8 u8SinkEndpoint_, uint8 u8SourceEndpoint_)  :
    _u32DeviceId (u32DeviceId_),
    _u8IAP2iOSAppIdentifier (u8IAP2iOSAppIdentifier_),
    _u8SinkEndpoint (u8SinkEndpoint_),
    _u8SourceEndpoint (u8SourceEndpoint_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NativeTransportStopStatus::~NativeTransportStopStatus() {
}

inline NativeTransportStopStatus& NativeTransportStopStatus::operator = (const NativeTransportStopStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU32DeviceId()) {
            setU32DeviceId(rhs.getU32DeviceId());
        } else {
            clearU32DeviceId();
        }
        if (rhs.hasU8IAP2iOSAppIdentifier()) {
            setU8IAP2iOSAppIdentifier(rhs.getU8IAP2iOSAppIdentifier());
        } else {
            clearU8IAP2iOSAppIdentifier();
        }
        if (rhs.hasU8SinkEndpoint()) {
            setU8SinkEndpoint(rhs.getU8SinkEndpoint());
        } else {
            clearU8SinkEndpoint();
        }
        if (rhs.hasU8SourceEndpoint()) {
            setU8SourceEndpoint(rhs.getU8SourceEndpoint());
        } else {
            clearU8SourceEndpoint();
        }
    }
    return *this;
}

inline bool NativeTransportStopStatus::operator == (const NativeTransportStopStatus& rhs) const {
    return (((!hasU32DeviceId() && !rhs.hasU32DeviceId()) || getU32DeviceId() == rhs.getU32DeviceId()) &&
        ((!hasU8IAP2iOSAppIdentifier() && !rhs.hasU8IAP2iOSAppIdentifier()) || getU8IAP2iOSAppIdentifier() == rhs.getU8IAP2iOSAppIdentifier()) &&
        ((!hasU8SinkEndpoint() && !rhs.hasU8SinkEndpoint()) || getU8SinkEndpoint() == rhs.getU8SinkEndpoint()) &&
        ((!hasU8SourceEndpoint() && !rhs.hasU8SourceEndpoint()) || getU8SourceEndpoint() == rhs.getU8SourceEndpoint()));
}

inline bool NativeTransportStopStatus::operator != (const NativeTransportStopStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool NativeTransportStopStatus::operator < (const NativeTransportStopStatus& rhs) const {
    if (hasU32DeviceId() || rhs.hasU32DeviceId()) {
        if (getU32DeviceId() < rhs.getU32DeviceId()) return true;
        if (getU32DeviceId() > rhs.getU32DeviceId()) return false;
    }
    if (hasU8IAP2iOSAppIdentifier() || rhs.hasU8IAP2iOSAppIdentifier()) {
        if (getU8IAP2iOSAppIdentifier() < rhs.getU8IAP2iOSAppIdentifier()) return true;
        if (getU8IAP2iOSAppIdentifier() > rhs.getU8IAP2iOSAppIdentifier()) return false;
    }
    if (hasU8SinkEndpoint() || rhs.hasU8SinkEndpoint()) {
        if (getU8SinkEndpoint() < rhs.getU8SinkEndpoint()) return true;
        if (getU8SinkEndpoint() > rhs.getU8SinkEndpoint()) return false;
    }
    if (hasU8SourceEndpoint() || rhs.hasU8SourceEndpoint()) {
        if (getU8SourceEndpoint() < rhs.getU8SourceEndpoint()) return true;
        if (getU8SourceEndpoint() > rhs.getU8SourceEndpoint()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NativeTransportStopStatus::clone() {
    return new NativeTransportStopStatus(*this);
}

inline bool NativeTransportStopStatus::operator > (const NativeTransportStopStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NativeTransportStopStatus::clear() {
    clearU32DeviceId();
    clearU8IAP2iOSAppIdentifier();
    clearU8SinkEndpoint();
    clearU8SourceEndpoint();
}

inline void NativeTransportStopStatus::clearU32DeviceId() {
    if (hasU32DeviceId()) {
         clear_has_u32DeviceId();
        _u32DeviceId = 0u;
     }
}

inline bool NativeTransportStopStatus::hasU32DeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 NativeTransportStopStatus::getU32DeviceId () const {
    return _u32DeviceId;
}

inline void NativeTransportStopStatus::setU32DeviceId (uint32 u32DeviceId_) {
    set_has_u32DeviceId();
    this->_u32DeviceId = u32DeviceId_;
}

inline void NativeTransportStopStatus::clearU8IAP2iOSAppIdentifier() {
    if (hasU8IAP2iOSAppIdentifier()) {
         clear_has_u8IAP2iOSAppIdentifier();
        _u8IAP2iOSAppIdentifier = 0u;
     }
}

inline bool NativeTransportStopStatus::hasU8IAP2iOSAppIdentifier () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 NativeTransportStopStatus::getU8IAP2iOSAppIdentifier () const {
    return _u8IAP2iOSAppIdentifier;
}

inline void NativeTransportStopStatus::setU8IAP2iOSAppIdentifier (uint8 u8IAP2iOSAppIdentifier_) {
    set_has_u8IAP2iOSAppIdentifier();
    this->_u8IAP2iOSAppIdentifier = u8IAP2iOSAppIdentifier_;
}

inline void NativeTransportStopStatus::clearU8SinkEndpoint() {
    if (hasU8SinkEndpoint()) {
         clear_has_u8SinkEndpoint();
        _u8SinkEndpoint = 0u;
     }
}

inline bool NativeTransportStopStatus::hasU8SinkEndpoint () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 NativeTransportStopStatus::getU8SinkEndpoint () const {
    return _u8SinkEndpoint;
}

inline void NativeTransportStopStatus::setU8SinkEndpoint (uint8 u8SinkEndpoint_) {
    set_has_u8SinkEndpoint();
    this->_u8SinkEndpoint = u8SinkEndpoint_;
}

inline void NativeTransportStopStatus::clearU8SourceEndpoint() {
    if (hasU8SourceEndpoint()) {
         clear_has_u8SourceEndpoint();
        _u8SourceEndpoint = 0u;
     }
}

inline bool NativeTransportStopStatus::hasU8SourceEndpoint () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 NativeTransportStopStatus::getU8SourceEndpoint () const {
    return _u8SourceEndpoint;
}

inline void NativeTransportStopStatus::setU8SourceEndpoint (uint8 u8SourceEndpoint_) {
    set_has_u8SourceEndpoint();
    this->_u8SourceEndpoint = u8SourceEndpoint_;
}

inline void NativeTransportStopStatus::set_has_u32DeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void NativeTransportStopStatus::clear_has_u32DeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void NativeTransportStopStatus::set_has_u8IAP2iOSAppIdentifier () {
    _has_bits_[0] |= 1u << 1;
}

inline void NativeTransportStopStatus::clear_has_u8IAP2iOSAppIdentifier () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void NativeTransportStopStatus::set_has_u8SinkEndpoint () {
    _has_bits_[0] |= 1u << 2;
}

inline void NativeTransportStopStatus::clear_has_u8SinkEndpoint () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void NativeTransportStopStatus::set_has_u8SourceEndpoint () {
    _has_bits_[0] |= 1u << 3;
}

inline void NativeTransportStopStatus::clear_has_u8SourceEndpoint () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ConnectedBluetoothProfilesStatus::ConnectedBluetoothProfilesStatus ()  :
    _oBTProfileInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConnectedBluetoothProfilesStatus::ConnectedBluetoothProfilesStatus (const ConnectedBluetoothProfilesStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _oBTProfileInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConnectedBluetoothProfilesStatus::ConnectedBluetoothProfilesStatus (const ::mplay_appcontrol_fi_types::T_BTProfileInfo& oBTProfileInfo_)  :
    _oBTProfileInfo (oBTProfileInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConnectedBluetoothProfilesStatus::~ConnectedBluetoothProfilesStatus() {
}

inline ConnectedBluetoothProfilesStatus& ConnectedBluetoothProfilesStatus::operator = (const ConnectedBluetoothProfilesStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasOBTProfileInfo()) {
            setOBTProfileInfo(rhs.getOBTProfileInfo());
        } else {
            clearOBTProfileInfo();
        }
    }
    return *this;
}

inline bool ConnectedBluetoothProfilesStatus::operator == (const ConnectedBluetoothProfilesStatus& rhs) const {
    return (((!hasOBTProfileInfo() && !rhs.hasOBTProfileInfo()) || getOBTProfileInfo() == rhs.getOBTProfileInfo()));
}

inline bool ConnectedBluetoothProfilesStatus::operator != (const ConnectedBluetoothProfilesStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool ConnectedBluetoothProfilesStatus::operator < (const ConnectedBluetoothProfilesStatus& rhs) const {
    if (hasOBTProfileInfo() || rhs.hasOBTProfileInfo()) {
        if (getOBTProfileInfo() < rhs.getOBTProfileInfo()) return true;
        if (getOBTProfileInfo() > rhs.getOBTProfileInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConnectedBluetoothProfilesStatus::clone() {
    return new ConnectedBluetoothProfilesStatus(*this);
}

inline bool ConnectedBluetoothProfilesStatus::operator > (const ConnectedBluetoothProfilesStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConnectedBluetoothProfilesStatus::clear() {
    clearOBTProfileInfo();
}

inline void ConnectedBluetoothProfilesStatus::clearOBTProfileInfo() {
    if (hasOBTProfileInfo()) {
         clear_has_oBTProfileInfo();
        _oBTProfileInfo.clear();
     }
}

inline bool ConnectedBluetoothProfilesStatus::hasOBTProfileInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::mplay_appcontrol_fi_types::T_BTProfileInfo& ConnectedBluetoothProfilesStatus::getOBTProfileInfo () const {
    return _oBTProfileInfo;
}

inline ::mplay_appcontrol_fi_types::T_BTProfileInfo& ConnectedBluetoothProfilesStatus::getOBTProfileInfoMutable () {
    set_has_oBTProfileInfo();
    return _oBTProfileInfo;
}

inline void ConnectedBluetoothProfilesStatus::setOBTProfileInfo (const ::mplay_appcontrol_fi_types::T_BTProfileInfo& oBTProfileInfo_) {
    set_has_oBTProfileInfo();
    this->_oBTProfileInfo = oBTProfileInfo_;
}

inline void ConnectedBluetoothProfilesStatus::set_has_oBTProfileInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConnectedBluetoothProfilesStatus::clear_has_oBTProfileInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DiPONowPlayingStatus::DiPONowPlayingStatus ()  :
    _u8DeviceId (0u),
    _sTitle (),
    _sArtist (),
    _sAlbum (),
    _sGenre (),
    _sComposer (),
    _sAlbumArt (),
    _sAppName (),
    _u16AlbumTrackNumber (0u),
    _u16AlbumTrackCount (0u),
    _u16AlbumDiscNumber (0u),
    _u16AlbumDiscCount (0u),
    _u16ChapterCount (0u),
    _u32QueueIndex (0u),
    _u32QueueCount (0u),
    _u32QueueChapterIndex (0u),
    _biTunesRadioAd (false),
    _siTunesRadioStationName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPONowPlayingStatus::DiPONowPlayingStatus (const DiPONowPlayingStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _u8DeviceId (0u),
    _sTitle (),
    _sArtist (),
    _sAlbum (),
    _sGenre (),
    _sComposer (),
    _sAlbumArt (),
    _sAppName (),
    _u16AlbumTrackNumber (0u),
    _u16AlbumTrackCount (0u),
    _u16AlbumDiscNumber (0u),
    _u16AlbumDiscCount (0u),
    _u16ChapterCount (0u),
    _u32QueueIndex (0u),
    _u32QueueCount (0u),
    _u32QueueChapterIndex (0u),
    _biTunesRadioAd (false),
    _siTunesRadioStationName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPONowPlayingStatus::DiPONowPlayingStatus (uint8 u8DeviceId_, const ::std::string& sTitle_, const ::std::string& sArtist_, const ::std::string& sAlbum_, const ::std::string& sGenre_, const ::std::string& sComposer_, const ::std::string& sAlbumArt_, const ::std::string& sAppName_, uint16 u16AlbumTrackNumber_, uint16 u16AlbumTrackCount_, uint16 u16AlbumDiscNumber_, uint16 u16AlbumDiscCount_, uint16 u16ChapterCount_, uint32 u32QueueIndex_, uint32 u32QueueCount_, uint32 u32QueueChapterIndex_, bool biTunesRadioAd_, const ::std::string& siTunesRadioStationName_)  :
    _u8DeviceId (u8DeviceId_),
    _sTitle (sTitle_),
    _sArtist (sArtist_),
    _sAlbum (sAlbum_),
    _sGenre (sGenre_),
    _sComposer (sComposer_),
    _sAlbumArt (sAlbumArt_),
    _sAppName (sAppName_),
    _u16AlbumTrackNumber (u16AlbumTrackNumber_),
    _u16AlbumTrackCount (u16AlbumTrackCount_),
    _u16AlbumDiscNumber (u16AlbumDiscNumber_),
    _u16AlbumDiscCount (u16AlbumDiscCount_),
    _u16ChapterCount (u16ChapterCount_),
    _u32QueueIndex (u32QueueIndex_),
    _u32QueueCount (u32QueueCount_),
    _u32QueueChapterIndex (u32QueueChapterIndex_),
    _biTunesRadioAd (biTunesRadioAd_),
    _siTunesRadioStationName (siTunesRadioStationName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sArtist_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAlbum_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sGenre_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sComposer_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAlbumArt_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (siTunesRadioStationName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPONowPlayingStatus::~DiPONowPlayingStatus() {
}

inline DiPONowPlayingStatus& DiPONowPlayingStatus::operator = (const DiPONowPlayingStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8DeviceId()) {
            setU8DeviceId(rhs.getU8DeviceId());
        } else {
            clearU8DeviceId();
        }
        if (rhs.hasSTitle()) {
            setSTitle(rhs.getSTitle());
        } else {
            clearSTitle();
        }
        if (rhs.hasSArtist()) {
            setSArtist(rhs.getSArtist());
        } else {
            clearSArtist();
        }
        if (rhs.hasSAlbum()) {
            setSAlbum(rhs.getSAlbum());
        } else {
            clearSAlbum();
        }
        if (rhs.hasSGenre()) {
            setSGenre(rhs.getSGenre());
        } else {
            clearSGenre();
        }
        if (rhs.hasSComposer()) {
            setSComposer(rhs.getSComposer());
        } else {
            clearSComposer();
        }
        if (rhs.hasSAlbumArt()) {
            setSAlbumArt(rhs.getSAlbumArt());
        } else {
            clearSAlbumArt();
        }
        if (rhs.hasSAppName()) {
            setSAppName(rhs.getSAppName());
        } else {
            clearSAppName();
        }
        if (rhs.hasU16AlbumTrackNumber()) {
            setU16AlbumTrackNumber(rhs.getU16AlbumTrackNumber());
        } else {
            clearU16AlbumTrackNumber();
        }
        if (rhs.hasU16AlbumTrackCount()) {
            setU16AlbumTrackCount(rhs.getU16AlbumTrackCount());
        } else {
            clearU16AlbumTrackCount();
        }
        if (rhs.hasU16AlbumDiscNumber()) {
            setU16AlbumDiscNumber(rhs.getU16AlbumDiscNumber());
        } else {
            clearU16AlbumDiscNumber();
        }
        if (rhs.hasU16AlbumDiscCount()) {
            setU16AlbumDiscCount(rhs.getU16AlbumDiscCount());
        } else {
            clearU16AlbumDiscCount();
        }
        if (rhs.hasU16ChapterCount()) {
            setU16ChapterCount(rhs.getU16ChapterCount());
        } else {
            clearU16ChapterCount();
        }
        if (rhs.hasU32QueueIndex()) {
            setU32QueueIndex(rhs.getU32QueueIndex());
        } else {
            clearU32QueueIndex();
        }
        if (rhs.hasU32QueueCount()) {
            setU32QueueCount(rhs.getU32QueueCount());
        } else {
            clearU32QueueCount();
        }
        if (rhs.hasU32QueueChapterIndex()) {
            setU32QueueChapterIndex(rhs.getU32QueueChapterIndex());
        } else {
            clearU32QueueChapterIndex();
        }
        if (rhs.hasBiTunesRadioAd()) {
            setBiTunesRadioAd(rhs.getBiTunesRadioAd());
        } else {
            clearBiTunesRadioAd();
        }
        if (rhs.hasSiTunesRadioStationName()) {
            setSiTunesRadioStationName(rhs.getSiTunesRadioStationName());
        } else {
            clearSiTunesRadioStationName();
        }
    }
    return *this;
}

inline bool DiPONowPlayingStatus::operator == (const DiPONowPlayingStatus& rhs) const {
    return (((!hasU8DeviceId() && !rhs.hasU8DeviceId()) || getU8DeviceId() == rhs.getU8DeviceId()) &&
        ((!hasSTitle() && !rhs.hasSTitle()) || getSTitle() == rhs.getSTitle()) &&
        ((!hasSArtist() && !rhs.hasSArtist()) || getSArtist() == rhs.getSArtist()) &&
        ((!hasSAlbum() && !rhs.hasSAlbum()) || getSAlbum() == rhs.getSAlbum()) &&
        ((!hasSGenre() && !rhs.hasSGenre()) || getSGenre() == rhs.getSGenre()) &&
        ((!hasSComposer() && !rhs.hasSComposer()) || getSComposer() == rhs.getSComposer()) &&
        ((!hasSAlbumArt() && !rhs.hasSAlbumArt()) || getSAlbumArt() == rhs.getSAlbumArt()) &&
        ((!hasSAppName() && !rhs.hasSAppName()) || getSAppName() == rhs.getSAppName()) &&
        ((!hasU16AlbumTrackNumber() && !rhs.hasU16AlbumTrackNumber()) || getU16AlbumTrackNumber() == rhs.getU16AlbumTrackNumber()) &&
        ((!hasU16AlbumTrackCount() && !rhs.hasU16AlbumTrackCount()) || getU16AlbumTrackCount() == rhs.getU16AlbumTrackCount()) &&
        ((!hasU16AlbumDiscNumber() && !rhs.hasU16AlbumDiscNumber()) || getU16AlbumDiscNumber() == rhs.getU16AlbumDiscNumber()) &&
        ((!hasU16AlbumDiscCount() && !rhs.hasU16AlbumDiscCount()) || getU16AlbumDiscCount() == rhs.getU16AlbumDiscCount()) &&
        ((!hasU16ChapterCount() && !rhs.hasU16ChapterCount()) || getU16ChapterCount() == rhs.getU16ChapterCount()) &&
        ((!hasU32QueueIndex() && !rhs.hasU32QueueIndex()) || getU32QueueIndex() == rhs.getU32QueueIndex()) &&
        ((!hasU32QueueCount() && !rhs.hasU32QueueCount()) || getU32QueueCount() == rhs.getU32QueueCount()) &&
        ((!hasU32QueueChapterIndex() && !rhs.hasU32QueueChapterIndex()) || getU32QueueChapterIndex() == rhs.getU32QueueChapterIndex()) &&
        ((!hasBiTunesRadioAd() && !rhs.hasBiTunesRadioAd()) || getBiTunesRadioAd() == rhs.getBiTunesRadioAd()) &&
        ((!hasSiTunesRadioStationName() && !rhs.hasSiTunesRadioStationName()) || getSiTunesRadioStationName() == rhs.getSiTunesRadioStationName()));
}

inline bool DiPONowPlayingStatus::operator != (const DiPONowPlayingStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPONowPlayingStatus::operator < (const DiPONowPlayingStatus& rhs) const {
    if (hasU8DeviceId() || rhs.hasU8DeviceId()) {
        if (getU8DeviceId() < rhs.getU8DeviceId()) return true;
        if (getU8DeviceId() > rhs.getU8DeviceId()) return false;
    }
    if (hasSTitle() || rhs.hasSTitle()) {
        if (getSTitle() < rhs.getSTitle()) return true;
        if (getSTitle() > rhs.getSTitle()) return false;
    }
    if (hasSArtist() || rhs.hasSArtist()) {
        if (getSArtist() < rhs.getSArtist()) return true;
        if (getSArtist() > rhs.getSArtist()) return false;
    }
    if (hasSAlbum() || rhs.hasSAlbum()) {
        if (getSAlbum() < rhs.getSAlbum()) return true;
        if (getSAlbum() > rhs.getSAlbum()) return false;
    }
    if (hasSGenre() || rhs.hasSGenre()) {
        if (getSGenre() < rhs.getSGenre()) return true;
        if (getSGenre() > rhs.getSGenre()) return false;
    }
    if (hasSComposer() || rhs.hasSComposer()) {
        if (getSComposer() < rhs.getSComposer()) return true;
        if (getSComposer() > rhs.getSComposer()) return false;
    }
    if (hasSAlbumArt() || rhs.hasSAlbumArt()) {
        if (getSAlbumArt() < rhs.getSAlbumArt()) return true;
        if (getSAlbumArt() > rhs.getSAlbumArt()) return false;
    }
    if (hasSAppName() || rhs.hasSAppName()) {
        if (getSAppName() < rhs.getSAppName()) return true;
        if (getSAppName() > rhs.getSAppName()) return false;
    }
    if (hasU16AlbumTrackNumber() || rhs.hasU16AlbumTrackNumber()) {
        if (getU16AlbumTrackNumber() < rhs.getU16AlbumTrackNumber()) return true;
        if (getU16AlbumTrackNumber() > rhs.getU16AlbumTrackNumber()) return false;
    }
    if (hasU16AlbumTrackCount() || rhs.hasU16AlbumTrackCount()) {
        if (getU16AlbumTrackCount() < rhs.getU16AlbumTrackCount()) return true;
        if (getU16AlbumTrackCount() > rhs.getU16AlbumTrackCount()) return false;
    }
    if (hasU16AlbumDiscNumber() || rhs.hasU16AlbumDiscNumber()) {
        if (getU16AlbumDiscNumber() < rhs.getU16AlbumDiscNumber()) return true;
        if (getU16AlbumDiscNumber() > rhs.getU16AlbumDiscNumber()) return false;
    }
    if (hasU16AlbumDiscCount() || rhs.hasU16AlbumDiscCount()) {
        if (getU16AlbumDiscCount() < rhs.getU16AlbumDiscCount()) return true;
        if (getU16AlbumDiscCount() > rhs.getU16AlbumDiscCount()) return false;
    }
    if (hasU16ChapterCount() || rhs.hasU16ChapterCount()) {
        if (getU16ChapterCount() < rhs.getU16ChapterCount()) return true;
        if (getU16ChapterCount() > rhs.getU16ChapterCount()) return false;
    }
    if (hasU32QueueIndex() || rhs.hasU32QueueIndex()) {
        if (getU32QueueIndex() < rhs.getU32QueueIndex()) return true;
        if (getU32QueueIndex() > rhs.getU32QueueIndex()) return false;
    }
    if (hasU32QueueCount() || rhs.hasU32QueueCount()) {
        if (getU32QueueCount() < rhs.getU32QueueCount()) return true;
        if (getU32QueueCount() > rhs.getU32QueueCount()) return false;
    }
    if (hasU32QueueChapterIndex() || rhs.hasU32QueueChapterIndex()) {
        if (getU32QueueChapterIndex() < rhs.getU32QueueChapterIndex()) return true;
        if (getU32QueueChapterIndex() > rhs.getU32QueueChapterIndex()) return false;
    }
    if (hasBiTunesRadioAd() || rhs.hasBiTunesRadioAd()) {
        if (getBiTunesRadioAd() < rhs.getBiTunesRadioAd()) return true;
        if (getBiTunesRadioAd() > rhs.getBiTunesRadioAd()) return false;
    }
    if (hasSiTunesRadioStationName() || rhs.hasSiTunesRadioStationName()) {
        if (getSiTunesRadioStationName() < rhs.getSiTunesRadioStationName()) return true;
        if (getSiTunesRadioStationName() > rhs.getSiTunesRadioStationName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPONowPlayingStatus::clone() {
    return new DiPONowPlayingStatus(*this);
}

inline bool DiPONowPlayingStatus::operator > (const DiPONowPlayingStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPONowPlayingStatus::clear() {
    clearU8DeviceId();
    clearSTitle();
    clearSArtist();
    clearSAlbum();
    clearSGenre();
    clearSComposer();
    clearSAlbumArt();
    clearSAppName();
    clearU16AlbumTrackNumber();
    clearU16AlbumTrackCount();
    clearU16AlbumDiscNumber();
    clearU16AlbumDiscCount();
    clearU16ChapterCount();
    clearU32QueueIndex();
    clearU32QueueCount();
    clearU32QueueChapterIndex();
    clearBiTunesRadioAd();
    clearSiTunesRadioStationName();
}

inline void DiPONowPlayingStatus::clearU8DeviceId() {
    if (hasU8DeviceId()) {
         clear_has_u8DeviceId();
        _u8DeviceId = 0u;
     }
}

inline bool DiPONowPlayingStatus::hasU8DeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DiPONowPlayingStatus::getU8DeviceId () const {
    return _u8DeviceId;
}

inline void DiPONowPlayingStatus::setU8DeviceId (uint8 u8DeviceId_) {
    set_has_u8DeviceId();
    this->_u8DeviceId = u8DeviceId_;
}

inline void DiPONowPlayingStatus::clearSTitle() {
    if (hasSTitle()) {
         clear_has_sTitle();
        _sTitle.clear();
     }
}

inline bool DiPONowPlayingStatus::hasSTitle () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& DiPONowPlayingStatus::getSTitle () const {
    return _sTitle;
}

inline ::std::string& DiPONowPlayingStatus::getSTitleMutable () {
    set_has_sTitle();
    return _sTitle;
}

inline void DiPONowPlayingStatus::setSTitle (const ::std::string& sTitle_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTitle();
    this->_sTitle = sTitle_;
}

inline void DiPONowPlayingStatus::setSTitle (const char* sTitle_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTitle();
    this->_sTitle.assign(sTitle_);
}

inline void DiPONowPlayingStatus::setSTitle (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sTitle();
    this->_sTitle.assign(value, size);
}

inline void DiPONowPlayingStatus::clearSArtist() {
    if (hasSArtist()) {
         clear_has_sArtist();
        _sArtist.clear();
     }
}

inline bool DiPONowPlayingStatus::hasSArtist () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& DiPONowPlayingStatus::getSArtist () const {
    return _sArtist;
}

inline ::std::string& DiPONowPlayingStatus::getSArtistMutable () {
    set_has_sArtist();
    return _sArtist;
}

inline void DiPONowPlayingStatus::setSArtist (const ::std::string& sArtist_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sArtist_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sArtist();
    this->_sArtist = sArtist_;
}

inline void DiPONowPlayingStatus::setSArtist (const char* sArtist_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sArtist_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sArtist();
    this->_sArtist.assign(sArtist_);
}

inline void DiPONowPlayingStatus::setSArtist (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sArtist();
    this->_sArtist.assign(value, size);
}

inline void DiPONowPlayingStatus::clearSAlbum() {
    if (hasSAlbum()) {
         clear_has_sAlbum();
        _sAlbum.clear();
     }
}

inline bool DiPONowPlayingStatus::hasSAlbum () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& DiPONowPlayingStatus::getSAlbum () const {
    return _sAlbum;
}

inline ::std::string& DiPONowPlayingStatus::getSAlbumMutable () {
    set_has_sAlbum();
    return _sAlbum;
}

inline void DiPONowPlayingStatus::setSAlbum (const ::std::string& sAlbum_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAlbum_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAlbum();
    this->_sAlbum = sAlbum_;
}

inline void DiPONowPlayingStatus::setSAlbum (const char* sAlbum_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAlbum_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAlbum();
    this->_sAlbum.assign(sAlbum_);
}

inline void DiPONowPlayingStatus::setSAlbum (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAlbum();
    this->_sAlbum.assign(value, size);
}

inline void DiPONowPlayingStatus::clearSGenre() {
    if (hasSGenre()) {
         clear_has_sGenre();
        _sGenre.clear();
     }
}

inline bool DiPONowPlayingStatus::hasSGenre () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& DiPONowPlayingStatus::getSGenre () const {
    return _sGenre;
}

inline ::std::string& DiPONowPlayingStatus::getSGenreMutable () {
    set_has_sGenre();
    return _sGenre;
}

inline void DiPONowPlayingStatus::setSGenre (const ::std::string& sGenre_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sGenre_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sGenre();
    this->_sGenre = sGenre_;
}

inline void DiPONowPlayingStatus::setSGenre (const char* sGenre_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sGenre_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sGenre();
    this->_sGenre.assign(sGenre_);
}

inline void DiPONowPlayingStatus::setSGenre (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sGenre();
    this->_sGenre.assign(value, size);
}

inline void DiPONowPlayingStatus::clearSComposer() {
    if (hasSComposer()) {
         clear_has_sComposer();
        _sComposer.clear();
     }
}

inline bool DiPONowPlayingStatus::hasSComposer () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& DiPONowPlayingStatus::getSComposer () const {
    return _sComposer;
}

inline ::std::string& DiPONowPlayingStatus::getSComposerMutable () {
    set_has_sComposer();
    return _sComposer;
}

inline void DiPONowPlayingStatus::setSComposer (const ::std::string& sComposer_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sComposer_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sComposer();
    this->_sComposer = sComposer_;
}

inline void DiPONowPlayingStatus::setSComposer (const char* sComposer_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sComposer_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sComposer();
    this->_sComposer.assign(sComposer_);
}

inline void DiPONowPlayingStatus::setSComposer (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sComposer();
    this->_sComposer.assign(value, size);
}

inline void DiPONowPlayingStatus::clearSAlbumArt() {
    if (hasSAlbumArt()) {
         clear_has_sAlbumArt();
        _sAlbumArt.clear();
     }
}

inline bool DiPONowPlayingStatus::hasSAlbumArt () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& DiPONowPlayingStatus::getSAlbumArt () const {
    return _sAlbumArt;
}

inline ::std::string& DiPONowPlayingStatus::getSAlbumArtMutable () {
    set_has_sAlbumArt();
    return _sAlbumArt;
}

inline void DiPONowPlayingStatus::setSAlbumArt (const ::std::string& sAlbumArt_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAlbumArt_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAlbumArt();
    this->_sAlbumArt = sAlbumArt_;
}

inline void DiPONowPlayingStatus::setSAlbumArt (const char* sAlbumArt_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAlbumArt_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAlbumArt();
    this->_sAlbumArt.assign(sAlbumArt_);
}

inline void DiPONowPlayingStatus::setSAlbumArt (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAlbumArt();
    this->_sAlbumArt.assign(value, size);
}

inline void DiPONowPlayingStatus::clearSAppName() {
    if (hasSAppName()) {
         clear_has_sAppName();
        _sAppName.clear();
     }
}

inline bool DiPONowPlayingStatus::hasSAppName () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& DiPONowPlayingStatus::getSAppName () const {
    return _sAppName;
}

inline ::std::string& DiPONowPlayingStatus::getSAppNameMutable () {
    set_has_sAppName();
    return _sAppName;
}

inline void DiPONowPlayingStatus::setSAppName (const ::std::string& sAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAppName();
    this->_sAppName = sAppName_;
}

inline void DiPONowPlayingStatus::setSAppName (const char* sAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAppName();
    this->_sAppName.assign(sAppName_);
}

inline void DiPONowPlayingStatus::setSAppName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAppName();
    this->_sAppName.assign(value, size);
}

inline void DiPONowPlayingStatus::clearU16AlbumTrackNumber() {
    if (hasU16AlbumTrackNumber()) {
         clear_has_u16AlbumTrackNumber();
        _u16AlbumTrackNumber = 0u;
     }
}

inline bool DiPONowPlayingStatus::hasU16AlbumTrackNumber () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint16 DiPONowPlayingStatus::getU16AlbumTrackNumber () const {
    return _u16AlbumTrackNumber;
}

inline void DiPONowPlayingStatus::setU16AlbumTrackNumber (uint16 u16AlbumTrackNumber_) {
    set_has_u16AlbumTrackNumber();
    this->_u16AlbumTrackNumber = u16AlbumTrackNumber_;
}

inline void DiPONowPlayingStatus::clearU16AlbumTrackCount() {
    if (hasU16AlbumTrackCount()) {
         clear_has_u16AlbumTrackCount();
        _u16AlbumTrackCount = 0u;
     }
}

inline bool DiPONowPlayingStatus::hasU16AlbumTrackCount () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline uint16 DiPONowPlayingStatus::getU16AlbumTrackCount () const {
    return _u16AlbumTrackCount;
}

inline void DiPONowPlayingStatus::setU16AlbumTrackCount (uint16 u16AlbumTrackCount_) {
    set_has_u16AlbumTrackCount();
    this->_u16AlbumTrackCount = u16AlbumTrackCount_;
}

inline void DiPONowPlayingStatus::clearU16AlbumDiscNumber() {
    if (hasU16AlbumDiscNumber()) {
         clear_has_u16AlbumDiscNumber();
        _u16AlbumDiscNumber = 0u;
     }
}

inline bool DiPONowPlayingStatus::hasU16AlbumDiscNumber () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline uint16 DiPONowPlayingStatus::getU16AlbumDiscNumber () const {
    return _u16AlbumDiscNumber;
}

inline void DiPONowPlayingStatus::setU16AlbumDiscNumber (uint16 u16AlbumDiscNumber_) {
    set_has_u16AlbumDiscNumber();
    this->_u16AlbumDiscNumber = u16AlbumDiscNumber_;
}

inline void DiPONowPlayingStatus::clearU16AlbumDiscCount() {
    if (hasU16AlbumDiscCount()) {
         clear_has_u16AlbumDiscCount();
        _u16AlbumDiscCount = 0u;
     }
}

inline bool DiPONowPlayingStatus::hasU16AlbumDiscCount () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline uint16 DiPONowPlayingStatus::getU16AlbumDiscCount () const {
    return _u16AlbumDiscCount;
}

inline void DiPONowPlayingStatus::setU16AlbumDiscCount (uint16 u16AlbumDiscCount_) {
    set_has_u16AlbumDiscCount();
    this->_u16AlbumDiscCount = u16AlbumDiscCount_;
}

inline void DiPONowPlayingStatus::clearU16ChapterCount() {
    if (hasU16ChapterCount()) {
         clear_has_u16ChapterCount();
        _u16ChapterCount = 0u;
     }
}

inline bool DiPONowPlayingStatus::hasU16ChapterCount () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline uint16 DiPONowPlayingStatus::getU16ChapterCount () const {
    return _u16ChapterCount;
}

inline void DiPONowPlayingStatus::setU16ChapterCount (uint16 u16ChapterCount_) {
    set_has_u16ChapterCount();
    this->_u16ChapterCount = u16ChapterCount_;
}

inline void DiPONowPlayingStatus::clearU32QueueIndex() {
    if (hasU32QueueIndex()) {
         clear_has_u32QueueIndex();
        _u32QueueIndex = 0u;
     }
}

inline bool DiPONowPlayingStatus::hasU32QueueIndex () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint32 DiPONowPlayingStatus::getU32QueueIndex () const {
    return _u32QueueIndex;
}

inline void DiPONowPlayingStatus::setU32QueueIndex (uint32 u32QueueIndex_) {
    set_has_u32QueueIndex();
    this->_u32QueueIndex = u32QueueIndex_;
}

inline void DiPONowPlayingStatus::clearU32QueueCount() {
    if (hasU32QueueCount()) {
         clear_has_u32QueueCount();
        _u32QueueCount = 0u;
     }
}

inline bool DiPONowPlayingStatus::hasU32QueueCount () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline uint32 DiPONowPlayingStatus::getU32QueueCount () const {
    return _u32QueueCount;
}

inline void DiPONowPlayingStatus::setU32QueueCount (uint32 u32QueueCount_) {
    set_has_u32QueueCount();
    this->_u32QueueCount = u32QueueCount_;
}

inline void DiPONowPlayingStatus::clearU32QueueChapterIndex() {
    if (hasU32QueueChapterIndex()) {
         clear_has_u32QueueChapterIndex();
        _u32QueueChapterIndex = 0u;
     }
}

inline bool DiPONowPlayingStatus::hasU32QueueChapterIndex () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline uint32 DiPONowPlayingStatus::getU32QueueChapterIndex () const {
    return _u32QueueChapterIndex;
}

inline void DiPONowPlayingStatus::setU32QueueChapterIndex (uint32 u32QueueChapterIndex_) {
    set_has_u32QueueChapterIndex();
    this->_u32QueueChapterIndex = u32QueueChapterIndex_;
}

inline void DiPONowPlayingStatus::clearBiTunesRadioAd() {
    if (hasBiTunesRadioAd()) {
         clear_has_biTunesRadioAd();
        _biTunesRadioAd = false;
     }
}

inline bool DiPONowPlayingStatus::hasBiTunesRadioAd () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline bool DiPONowPlayingStatus::getBiTunesRadioAd () const {
    return _biTunesRadioAd;
}

inline void DiPONowPlayingStatus::setBiTunesRadioAd (bool biTunesRadioAd_) {
    set_has_biTunesRadioAd();
    this->_biTunesRadioAd = biTunesRadioAd_;
}

inline void DiPONowPlayingStatus::clearSiTunesRadioStationName() {
    if (hasSiTunesRadioStationName()) {
         clear_has_siTunesRadioStationName();
        _siTunesRadioStationName.clear();
     }
}

inline bool DiPONowPlayingStatus::hasSiTunesRadioStationName () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline const ::std::string& DiPONowPlayingStatus::getSiTunesRadioStationName () const {
    return _siTunesRadioStationName;
}

inline ::std::string& DiPONowPlayingStatus::getSiTunesRadioStationNameMutable () {
    set_has_siTunesRadioStationName();
    return _siTunesRadioStationName;
}

inline void DiPONowPlayingStatus::setSiTunesRadioStationName (const ::std::string& siTunesRadioStationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (siTunesRadioStationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_siTunesRadioStationName();
    this->_siTunesRadioStationName = siTunesRadioStationName_;
}

inline void DiPONowPlayingStatus::setSiTunesRadioStationName (const char* siTunesRadioStationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (siTunesRadioStationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_siTunesRadioStationName();
    this->_siTunesRadioStationName.assign(siTunesRadioStationName_);
}

inline void DiPONowPlayingStatus::setSiTunesRadioStationName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_siTunesRadioStationName();
    this->_siTunesRadioStationName.assign(value, size);
}

inline void DiPONowPlayingStatus::set_has_u8DeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPONowPlayingStatus::clear_has_u8DeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiPONowPlayingStatus::set_has_sTitle () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiPONowPlayingStatus::clear_has_sTitle () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DiPONowPlayingStatus::set_has_sArtist () {
    _has_bits_[0] |= 1u << 2;
}

inline void DiPONowPlayingStatus::clear_has_sArtist () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DiPONowPlayingStatus::set_has_sAlbum () {
    _has_bits_[0] |= 1u << 3;
}

inline void DiPONowPlayingStatus::clear_has_sAlbum () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void DiPONowPlayingStatus::set_has_sGenre () {
    _has_bits_[0] |= 1u << 4;
}

inline void DiPONowPlayingStatus::clear_has_sGenre () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void DiPONowPlayingStatus::set_has_sComposer () {
    _has_bits_[0] |= 1u << 5;
}

inline void DiPONowPlayingStatus::clear_has_sComposer () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void DiPONowPlayingStatus::set_has_sAlbumArt () {
    _has_bits_[0] |= 1u << 6;
}

inline void DiPONowPlayingStatus::clear_has_sAlbumArt () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void DiPONowPlayingStatus::set_has_sAppName () {
    _has_bits_[0] |= 1u << 7;
}

inline void DiPONowPlayingStatus::clear_has_sAppName () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void DiPONowPlayingStatus::set_has_u16AlbumTrackNumber () {
    _has_bits_[0] |= 1u << 8;
}

inline void DiPONowPlayingStatus::clear_has_u16AlbumTrackNumber () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void DiPONowPlayingStatus::set_has_u16AlbumTrackCount () {
    _has_bits_[0] |= 1u << 9;
}

inline void DiPONowPlayingStatus::clear_has_u16AlbumTrackCount () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void DiPONowPlayingStatus::set_has_u16AlbumDiscNumber () {
    _has_bits_[0] |= 1u << 10;
}

inline void DiPONowPlayingStatus::clear_has_u16AlbumDiscNumber () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void DiPONowPlayingStatus::set_has_u16AlbumDiscCount () {
    _has_bits_[0] |= 1u << 11;
}

inline void DiPONowPlayingStatus::clear_has_u16AlbumDiscCount () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void DiPONowPlayingStatus::set_has_u16ChapterCount () {
    _has_bits_[0] |= 1u << 12;
}

inline void DiPONowPlayingStatus::clear_has_u16ChapterCount () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void DiPONowPlayingStatus::set_has_u32QueueIndex () {
    _has_bits_[0] |= 1u << 13;
}

inline void DiPONowPlayingStatus::clear_has_u32QueueIndex () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void DiPONowPlayingStatus::set_has_u32QueueCount () {
    _has_bits_[0] |= 1u << 14;
}

inline void DiPONowPlayingStatus::clear_has_u32QueueCount () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void DiPONowPlayingStatus::set_has_u32QueueChapterIndex () {
    _has_bits_[0] |= 1u << 15;
}

inline void DiPONowPlayingStatus::clear_has_u32QueueChapterIndex () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void DiPONowPlayingStatus::set_has_biTunesRadioAd () {
    _has_bits_[0] |= 1u << 16;
}

inline void DiPONowPlayingStatus::clear_has_biTunesRadioAd () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void DiPONowPlayingStatus::set_has_siTunesRadioStationName () {
    _has_bits_[0] |= 1u << 17;
}

inline void DiPONowPlayingStatus::clear_has_siTunesRadioStationName () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline  DiPOPlaybackStatusStatus::DiPOPlaybackStatusStatus ()  :
    _u8DeviceId (0u),
    _e8State (::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackStatus__e8DIPO_PBS_STOPPED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPOPlaybackStatusStatus::DiPOPlaybackStatusStatus (const DiPOPlaybackStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _u8DeviceId (0u),
    _e8State (::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackStatus__e8DIPO_PBS_STOPPED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPOPlaybackStatusStatus::DiPOPlaybackStatusStatus (uint8 u8DeviceId_, ::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackStatus e8State_)  :
    _u8DeviceId (u8DeviceId_),
    _e8State (e8State_)
{
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackStatus_IsValid(e8State_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8State_, "T_e8_DiPOPlaybackStatus", "e8State", "DiPOPlaybackStatusStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPOPlaybackStatusStatus::~DiPOPlaybackStatusStatus() {
}

inline DiPOPlaybackStatusStatus& DiPOPlaybackStatusStatus::operator = (const DiPOPlaybackStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8DeviceId()) {
            setU8DeviceId(rhs.getU8DeviceId());
        } else {
            clearU8DeviceId();
        }
        if (rhs.hasE8State()) {
            setE8State(rhs.getE8State());
        } else {
            clearE8State();
        }
    }
    return *this;
}

inline bool DiPOPlaybackStatusStatus::operator == (const DiPOPlaybackStatusStatus& rhs) const {
    return (((!hasU8DeviceId() && !rhs.hasU8DeviceId()) || getU8DeviceId() == rhs.getU8DeviceId()) &&
        ((!hasE8State() && !rhs.hasE8State()) || getE8State() == rhs.getE8State()));
}

inline bool DiPOPlaybackStatusStatus::operator != (const DiPOPlaybackStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPOPlaybackStatusStatus::operator < (const DiPOPlaybackStatusStatus& rhs) const {
    if (hasU8DeviceId() || rhs.hasU8DeviceId()) {
        if (getU8DeviceId() < rhs.getU8DeviceId()) return true;
        if (getU8DeviceId() > rhs.getU8DeviceId()) return false;
    }
    if (hasE8State() || rhs.hasE8State()) {
        if ((uint32)getE8State() < (uint32)rhs.getE8State()) return true;
        if ((uint32)getE8State() > (uint32)rhs.getE8State()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPOPlaybackStatusStatus::clone() {
    return new DiPOPlaybackStatusStatus(*this);
}

inline bool DiPOPlaybackStatusStatus::operator > (const DiPOPlaybackStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPOPlaybackStatusStatus::clear() {
    clearU8DeviceId();
    clearE8State();
}

inline void DiPOPlaybackStatusStatus::clearU8DeviceId() {
    if (hasU8DeviceId()) {
         clear_has_u8DeviceId();
        _u8DeviceId = 0u;
     }
}

inline bool DiPOPlaybackStatusStatus::hasU8DeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DiPOPlaybackStatusStatus::getU8DeviceId () const {
    return _u8DeviceId;
}

inline void DiPOPlaybackStatusStatus::setU8DeviceId (uint8 u8DeviceId_) {
    set_has_u8DeviceId();
    this->_u8DeviceId = u8DeviceId_;
}

inline void DiPOPlaybackStatusStatus::clearE8State() {
    if (hasE8State()) {
         clear_has_e8State();
        _e8State = ::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackStatus__e8DIPO_PBS_STOPPED;
     }
}

inline bool DiPOPlaybackStatusStatus::hasE8State () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackStatus DiPOPlaybackStatusStatus::getE8State () const {
    return _e8State;
}

inline void DiPOPlaybackStatusStatus::setE8State (::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackStatus e8State_) {
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackStatus_IsValid(e8State_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8State_, "T_e8_DiPOPlaybackStatus", "e8State", "DiPOPlaybackStatusStatus");
    }
    #endif
    set_has_e8State();
    this->_e8State = e8State_;
}

inline void DiPOPlaybackStatusStatus::set_has_u8DeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPOPlaybackStatusStatus::clear_has_u8DeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiPOPlaybackStatusStatus::set_has_e8State () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiPOPlaybackStatusStatus::clear_has_e8State () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DiPOPlaybackShuffleModeStatus::DiPOPlaybackShuffleModeStatus ()  :
    _u8DeviceId (0u),
    _e8Mode (::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackShuffleMode__e8DIPO_PBSM_OFF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPOPlaybackShuffleModeStatus::DiPOPlaybackShuffleModeStatus (const DiPOPlaybackShuffleModeStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _u8DeviceId (0u),
    _e8Mode (::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackShuffleMode__e8DIPO_PBSM_OFF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPOPlaybackShuffleModeStatus::DiPOPlaybackShuffleModeStatus (uint8 u8DeviceId_, ::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackShuffleMode e8Mode_)  :
    _u8DeviceId (u8DeviceId_),
    _e8Mode (e8Mode_)
{
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackShuffleMode_IsValid(e8Mode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Mode_, "T_e8_DiPOPlaybackShuffleMode", "e8Mode", "DiPOPlaybackShuffleModeStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPOPlaybackShuffleModeStatus::~DiPOPlaybackShuffleModeStatus() {
}

inline DiPOPlaybackShuffleModeStatus& DiPOPlaybackShuffleModeStatus::operator = (const DiPOPlaybackShuffleModeStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8DeviceId()) {
            setU8DeviceId(rhs.getU8DeviceId());
        } else {
            clearU8DeviceId();
        }
        if (rhs.hasE8Mode()) {
            setE8Mode(rhs.getE8Mode());
        } else {
            clearE8Mode();
        }
    }
    return *this;
}

inline bool DiPOPlaybackShuffleModeStatus::operator == (const DiPOPlaybackShuffleModeStatus& rhs) const {
    return (((!hasU8DeviceId() && !rhs.hasU8DeviceId()) || getU8DeviceId() == rhs.getU8DeviceId()) &&
        ((!hasE8Mode() && !rhs.hasE8Mode()) || getE8Mode() == rhs.getE8Mode()));
}

inline bool DiPOPlaybackShuffleModeStatus::operator != (const DiPOPlaybackShuffleModeStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPOPlaybackShuffleModeStatus::operator < (const DiPOPlaybackShuffleModeStatus& rhs) const {
    if (hasU8DeviceId() || rhs.hasU8DeviceId()) {
        if (getU8DeviceId() < rhs.getU8DeviceId()) return true;
        if (getU8DeviceId() > rhs.getU8DeviceId()) return false;
    }
    if (hasE8Mode() || rhs.hasE8Mode()) {
        if ((uint32)getE8Mode() < (uint32)rhs.getE8Mode()) return true;
        if ((uint32)getE8Mode() > (uint32)rhs.getE8Mode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPOPlaybackShuffleModeStatus::clone() {
    return new DiPOPlaybackShuffleModeStatus(*this);
}

inline bool DiPOPlaybackShuffleModeStatus::operator > (const DiPOPlaybackShuffleModeStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPOPlaybackShuffleModeStatus::clear() {
    clearU8DeviceId();
    clearE8Mode();
}

inline void DiPOPlaybackShuffleModeStatus::clearU8DeviceId() {
    if (hasU8DeviceId()) {
         clear_has_u8DeviceId();
        _u8DeviceId = 0u;
     }
}

inline bool DiPOPlaybackShuffleModeStatus::hasU8DeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DiPOPlaybackShuffleModeStatus::getU8DeviceId () const {
    return _u8DeviceId;
}

inline void DiPOPlaybackShuffleModeStatus::setU8DeviceId (uint8 u8DeviceId_) {
    set_has_u8DeviceId();
    this->_u8DeviceId = u8DeviceId_;
}

inline void DiPOPlaybackShuffleModeStatus::clearE8Mode() {
    if (hasE8Mode()) {
         clear_has_e8Mode();
        _e8Mode = ::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackShuffleMode__e8DIPO_PBSM_OFF;
     }
}

inline bool DiPOPlaybackShuffleModeStatus::hasE8Mode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackShuffleMode DiPOPlaybackShuffleModeStatus::getE8Mode () const {
    return _e8Mode;
}

inline void DiPOPlaybackShuffleModeStatus::setE8Mode (::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackShuffleMode e8Mode_) {
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackShuffleMode_IsValid(e8Mode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Mode_, "T_e8_DiPOPlaybackShuffleMode", "e8Mode", "DiPOPlaybackShuffleModeStatus");
    }
    #endif
    set_has_e8Mode();
    this->_e8Mode = e8Mode_;
}

inline void DiPOPlaybackShuffleModeStatus::set_has_u8DeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPOPlaybackShuffleModeStatus::clear_has_u8DeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiPOPlaybackShuffleModeStatus::set_has_e8Mode () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiPOPlaybackShuffleModeStatus::clear_has_e8Mode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DiPOPlaybackRepeatModeStatus::DiPOPlaybackRepeatModeStatus ()  :
    _u8DeviceId (0u),
    _e8Mode (::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackRepeatMode__e8DIPO_PBRM_OFF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPOPlaybackRepeatModeStatus::DiPOPlaybackRepeatModeStatus (const DiPOPlaybackRepeatModeStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _u8DeviceId (0u),
    _e8Mode (::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackRepeatMode__e8DIPO_PBRM_OFF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPOPlaybackRepeatModeStatus::DiPOPlaybackRepeatModeStatus (uint8 u8DeviceId_, ::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackRepeatMode e8Mode_)  :
    _u8DeviceId (u8DeviceId_),
    _e8Mode (e8Mode_)
{
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackRepeatMode_IsValid(e8Mode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Mode_, "T_e8_DiPOPlaybackRepeatMode", "e8Mode", "DiPOPlaybackRepeatModeStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPOPlaybackRepeatModeStatus::~DiPOPlaybackRepeatModeStatus() {
}

inline DiPOPlaybackRepeatModeStatus& DiPOPlaybackRepeatModeStatus::operator = (const DiPOPlaybackRepeatModeStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8DeviceId()) {
            setU8DeviceId(rhs.getU8DeviceId());
        } else {
            clearU8DeviceId();
        }
        if (rhs.hasE8Mode()) {
            setE8Mode(rhs.getE8Mode());
        } else {
            clearE8Mode();
        }
    }
    return *this;
}

inline bool DiPOPlaybackRepeatModeStatus::operator == (const DiPOPlaybackRepeatModeStatus& rhs) const {
    return (((!hasU8DeviceId() && !rhs.hasU8DeviceId()) || getU8DeviceId() == rhs.getU8DeviceId()) &&
        ((!hasE8Mode() && !rhs.hasE8Mode()) || getE8Mode() == rhs.getE8Mode()));
}

inline bool DiPOPlaybackRepeatModeStatus::operator != (const DiPOPlaybackRepeatModeStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPOPlaybackRepeatModeStatus::operator < (const DiPOPlaybackRepeatModeStatus& rhs) const {
    if (hasU8DeviceId() || rhs.hasU8DeviceId()) {
        if (getU8DeviceId() < rhs.getU8DeviceId()) return true;
        if (getU8DeviceId() > rhs.getU8DeviceId()) return false;
    }
    if (hasE8Mode() || rhs.hasE8Mode()) {
        if ((uint32)getE8Mode() < (uint32)rhs.getE8Mode()) return true;
        if ((uint32)getE8Mode() > (uint32)rhs.getE8Mode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPOPlaybackRepeatModeStatus::clone() {
    return new DiPOPlaybackRepeatModeStatus(*this);
}

inline bool DiPOPlaybackRepeatModeStatus::operator > (const DiPOPlaybackRepeatModeStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPOPlaybackRepeatModeStatus::clear() {
    clearU8DeviceId();
    clearE8Mode();
}

inline void DiPOPlaybackRepeatModeStatus::clearU8DeviceId() {
    if (hasU8DeviceId()) {
         clear_has_u8DeviceId();
        _u8DeviceId = 0u;
     }
}

inline bool DiPOPlaybackRepeatModeStatus::hasU8DeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DiPOPlaybackRepeatModeStatus::getU8DeviceId () const {
    return _u8DeviceId;
}

inline void DiPOPlaybackRepeatModeStatus::setU8DeviceId (uint8 u8DeviceId_) {
    set_has_u8DeviceId();
    this->_u8DeviceId = u8DeviceId_;
}

inline void DiPOPlaybackRepeatModeStatus::clearE8Mode() {
    if (hasE8Mode()) {
         clear_has_e8Mode();
        _e8Mode = ::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackRepeatMode__e8DIPO_PBRM_OFF;
     }
}

inline bool DiPOPlaybackRepeatModeStatus::hasE8Mode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackRepeatMode DiPOPlaybackRepeatModeStatus::getE8Mode () const {
    return _e8Mode;
}

inline void DiPOPlaybackRepeatModeStatus::setE8Mode (::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackRepeatMode e8Mode_) {
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DiPOPlaybackRepeatMode_IsValid(e8Mode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Mode_, "T_e8_DiPOPlaybackRepeatMode", "e8Mode", "DiPOPlaybackRepeatModeStatus");
    }
    #endif
    set_has_e8Mode();
    this->_e8Mode = e8Mode_;
}

inline void DiPOPlaybackRepeatModeStatus::set_has_u8DeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPOPlaybackRepeatModeStatus::clear_has_u8DeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiPOPlaybackRepeatModeStatus::set_has_e8Mode () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiPOPlaybackRepeatModeStatus::clear_has_e8Mode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DiPOCallStateStatus::DiPOCallStateStatus ()  :
    _u8DeviceId (0u),
    _oCallStateUpdate ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPOCallStateStatus::DiPOCallStateStatus (const DiPOCallStateStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _u8DeviceId (0u),
    _oCallStateUpdate ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPOCallStateStatus::DiPOCallStateStatus (uint8 u8DeviceId_, const ::mplay_appcontrol_fi_types::T_DiPOCallStateUpdate& oCallStateUpdate_)  :
    _u8DeviceId (u8DeviceId_),
    _oCallStateUpdate (oCallStateUpdate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPOCallStateStatus::~DiPOCallStateStatus() {
}

inline DiPOCallStateStatus& DiPOCallStateStatus::operator = (const DiPOCallStateStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8DeviceId()) {
            setU8DeviceId(rhs.getU8DeviceId());
        } else {
            clearU8DeviceId();
        }
        if (rhs.hasOCallStateUpdate()) {
            setOCallStateUpdate(rhs.getOCallStateUpdate());
        } else {
            clearOCallStateUpdate();
        }
    }
    return *this;
}

inline bool DiPOCallStateStatus::operator == (const DiPOCallStateStatus& rhs) const {
    return (((!hasU8DeviceId() && !rhs.hasU8DeviceId()) || getU8DeviceId() == rhs.getU8DeviceId()) &&
        ((!hasOCallStateUpdate() && !rhs.hasOCallStateUpdate()) || getOCallStateUpdate() == rhs.getOCallStateUpdate()));
}

inline bool DiPOCallStateStatus::operator != (const DiPOCallStateStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPOCallStateStatus::operator < (const DiPOCallStateStatus& rhs) const {
    if (hasU8DeviceId() || rhs.hasU8DeviceId()) {
        if (getU8DeviceId() < rhs.getU8DeviceId()) return true;
        if (getU8DeviceId() > rhs.getU8DeviceId()) return false;
    }
    if (hasOCallStateUpdate() || rhs.hasOCallStateUpdate()) {
        if (getOCallStateUpdate() < rhs.getOCallStateUpdate()) return true;
        if (getOCallStateUpdate() > rhs.getOCallStateUpdate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPOCallStateStatus::clone() {
    return new DiPOCallStateStatus(*this);
}

inline bool DiPOCallStateStatus::operator > (const DiPOCallStateStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPOCallStateStatus::clear() {
    clearU8DeviceId();
    clearOCallStateUpdate();
}

inline void DiPOCallStateStatus::clearU8DeviceId() {
    if (hasU8DeviceId()) {
         clear_has_u8DeviceId();
        _u8DeviceId = 0u;
     }
}

inline bool DiPOCallStateStatus::hasU8DeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DiPOCallStateStatus::getU8DeviceId () const {
    return _u8DeviceId;
}

inline void DiPOCallStateStatus::setU8DeviceId (uint8 u8DeviceId_) {
    set_has_u8DeviceId();
    this->_u8DeviceId = u8DeviceId_;
}

inline void DiPOCallStateStatus::clearOCallStateUpdate() {
    if (hasOCallStateUpdate()) {
         clear_has_oCallStateUpdate();
        _oCallStateUpdate.clear();
     }
}

inline bool DiPOCallStateStatus::hasOCallStateUpdate () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::mplay_appcontrol_fi_types::T_DiPOCallStateUpdate& DiPOCallStateStatus::getOCallStateUpdate () const {
    return _oCallStateUpdate;
}

inline ::mplay_appcontrol_fi_types::T_DiPOCallStateUpdate& DiPOCallStateStatus::getOCallStateUpdateMutable () {
    set_has_oCallStateUpdate();
    return _oCallStateUpdate;
}

inline void DiPOCallStateStatus::setOCallStateUpdate (const ::mplay_appcontrol_fi_types::T_DiPOCallStateUpdate& oCallStateUpdate_) {
    set_has_oCallStateUpdate();
    this->_oCallStateUpdate = oCallStateUpdate_;
}

inline void DiPOCallStateStatus::set_has_u8DeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPOCallStateStatus::clear_has_u8DeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiPOCallStateStatus::set_has_oCallStateUpdate () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiPOCallStateStatus::clear_has_oCallStateUpdate () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DiPOCommunicationsStatus::DiPOCommunicationsStatus ()  :
    _u8DeviceId (0u),
    _eSignalStrength (::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateSignalStrength__e8DIPO_CUSS_0BARS),
    _eRegistrationStatus (::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateRegistrationStatus__e8DIPO_CURS_UNKNONW),
    _bAirplaneModeStatus (false),
    _sCarrierName (),
    _bCellularSupported (false),
    _bTelephonyEnabled (false),
    _bFaceTimeAudioEnabled (false),
    _bFaceTimeVideoEnabled (false),
    _bMuteStatus (false),
    _u8CurrentCallCount (0u),
    _u8NewVoicemailCount (0u),
    _bInitiateCallAvalable (false),
    _bEndAndAcceptAvailable (false),
    _bHoldAndAcceptAvailable (false),
    _bSwapAvailable (false),
    _bMergeAvailable (false),
    _bHoldAvailable (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPOCommunicationsStatus::DiPOCommunicationsStatus (const DiPOCommunicationsStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _u8DeviceId (0u),
    _eSignalStrength (::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateSignalStrength__e8DIPO_CUSS_0BARS),
    _eRegistrationStatus (::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateRegistrationStatus__e8DIPO_CURS_UNKNONW),
    _bAirplaneModeStatus (false),
    _sCarrierName (),
    _bCellularSupported (false),
    _bTelephonyEnabled (false),
    _bFaceTimeAudioEnabled (false),
    _bFaceTimeVideoEnabled (false),
    _bMuteStatus (false),
    _u8CurrentCallCount (0u),
    _u8NewVoicemailCount (0u),
    _bInitiateCallAvalable (false),
    _bEndAndAcceptAvailable (false),
    _bHoldAndAcceptAvailable (false),
    _bSwapAvailable (false),
    _bMergeAvailable (false),
    _bHoldAvailable (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPOCommunicationsStatus::DiPOCommunicationsStatus (uint8 u8DeviceId_, ::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateSignalStrength eSignalStrength_, ::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateRegistrationStatus eRegistrationStatus_, bool bAirplaneModeStatus_, const ::std::string& sCarrierName_, bool bCellularSupported_, bool bTelephonyEnabled_, bool bFaceTimeAudioEnabled_, bool bFaceTimeVideoEnabled_, bool bMuteStatus_, uint8 u8CurrentCallCount_, uint8 u8NewVoicemailCount_, bool bInitiateCallAvalable_, bool bEndAndAcceptAvailable_, bool bHoldAndAcceptAvailable_, bool bSwapAvailable_, bool bMergeAvailable_, bool bHoldAvailable_)  :
    _u8DeviceId (u8DeviceId_),
    _eSignalStrength (eSignalStrength_),
    _eRegistrationStatus (eRegistrationStatus_),
    _bAirplaneModeStatus (bAirplaneModeStatus_),
    _sCarrierName (sCarrierName_),
    _bCellularSupported (bCellularSupported_),
    _bTelephonyEnabled (bTelephonyEnabled_),
    _bFaceTimeAudioEnabled (bFaceTimeAudioEnabled_),
    _bFaceTimeVideoEnabled (bFaceTimeVideoEnabled_),
    _bMuteStatus (bMuteStatus_),
    _u8CurrentCallCount (u8CurrentCallCount_),
    _u8NewVoicemailCount (u8NewVoicemailCount_),
    _bInitiateCallAvalable (bInitiateCallAvalable_),
    _bEndAndAcceptAvailable (bEndAndAcceptAvailable_),
    _bHoldAndAcceptAvailable (bHoldAndAcceptAvailable_),
    _bSwapAvailable (bSwapAvailable_),
    _bMergeAvailable (bMergeAvailable_),
    _bHoldAvailable (bHoldAvailable_)
{
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateSignalStrength_IsValid(eSignalStrength_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eSignalStrength_, "T_e8_DiPOCommunicationsUpdateSignalStrength", "eSignalStrength", "DiPOCommunicationsStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateRegistrationStatus_IsValid(eRegistrationStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eRegistrationStatus_, "T_e8_DiPOCommunicationsUpdateRegistrationStatus", "eRegistrationStatus", "DiPOCommunicationsStatus");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCarrierName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPOCommunicationsStatus::~DiPOCommunicationsStatus() {
}

inline DiPOCommunicationsStatus& DiPOCommunicationsStatus::operator = (const DiPOCommunicationsStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8DeviceId()) {
            setU8DeviceId(rhs.getU8DeviceId());
        } else {
            clearU8DeviceId();
        }
        if (rhs.hasESignalStrength()) {
            setESignalStrength(rhs.getESignalStrength());
        } else {
            clearESignalStrength();
        }
        if (rhs.hasERegistrationStatus()) {
            setERegistrationStatus(rhs.getERegistrationStatus());
        } else {
            clearERegistrationStatus();
        }
        if (rhs.hasBAirplaneModeStatus()) {
            setBAirplaneModeStatus(rhs.getBAirplaneModeStatus());
        } else {
            clearBAirplaneModeStatus();
        }
        if (rhs.hasSCarrierName()) {
            setSCarrierName(rhs.getSCarrierName());
        } else {
            clearSCarrierName();
        }
        if (rhs.hasBCellularSupported()) {
            setBCellularSupported(rhs.getBCellularSupported());
        } else {
            clearBCellularSupported();
        }
        if (rhs.hasBTelephonyEnabled()) {
            setBTelephonyEnabled(rhs.getBTelephonyEnabled());
        } else {
            clearBTelephonyEnabled();
        }
        if (rhs.hasBFaceTimeAudioEnabled()) {
            setBFaceTimeAudioEnabled(rhs.getBFaceTimeAudioEnabled());
        } else {
            clearBFaceTimeAudioEnabled();
        }
        if (rhs.hasBFaceTimeVideoEnabled()) {
            setBFaceTimeVideoEnabled(rhs.getBFaceTimeVideoEnabled());
        } else {
            clearBFaceTimeVideoEnabled();
        }
        if (rhs.hasBMuteStatus()) {
            setBMuteStatus(rhs.getBMuteStatus());
        } else {
            clearBMuteStatus();
        }
        if (rhs.hasU8CurrentCallCount()) {
            setU8CurrentCallCount(rhs.getU8CurrentCallCount());
        } else {
            clearU8CurrentCallCount();
        }
        if (rhs.hasU8NewVoicemailCount()) {
            setU8NewVoicemailCount(rhs.getU8NewVoicemailCount());
        } else {
            clearU8NewVoicemailCount();
        }
        if (rhs.hasBInitiateCallAvalable()) {
            setBInitiateCallAvalable(rhs.getBInitiateCallAvalable());
        } else {
            clearBInitiateCallAvalable();
        }
        if (rhs.hasBEndAndAcceptAvailable()) {
            setBEndAndAcceptAvailable(rhs.getBEndAndAcceptAvailable());
        } else {
            clearBEndAndAcceptAvailable();
        }
        if (rhs.hasBHoldAndAcceptAvailable()) {
            setBHoldAndAcceptAvailable(rhs.getBHoldAndAcceptAvailable());
        } else {
            clearBHoldAndAcceptAvailable();
        }
        if (rhs.hasBSwapAvailable()) {
            setBSwapAvailable(rhs.getBSwapAvailable());
        } else {
            clearBSwapAvailable();
        }
        if (rhs.hasBMergeAvailable()) {
            setBMergeAvailable(rhs.getBMergeAvailable());
        } else {
            clearBMergeAvailable();
        }
        if (rhs.hasBHoldAvailable()) {
            setBHoldAvailable(rhs.getBHoldAvailable());
        } else {
            clearBHoldAvailable();
        }
    }
    return *this;
}

inline bool DiPOCommunicationsStatus::operator == (const DiPOCommunicationsStatus& rhs) const {
    return (((!hasU8DeviceId() && !rhs.hasU8DeviceId()) || getU8DeviceId() == rhs.getU8DeviceId()) &&
        ((!hasESignalStrength() && !rhs.hasESignalStrength()) || getESignalStrength() == rhs.getESignalStrength()) &&
        ((!hasERegistrationStatus() && !rhs.hasERegistrationStatus()) || getERegistrationStatus() == rhs.getERegistrationStatus()) &&
        ((!hasBAirplaneModeStatus() && !rhs.hasBAirplaneModeStatus()) || getBAirplaneModeStatus() == rhs.getBAirplaneModeStatus()) &&
        ((!hasSCarrierName() && !rhs.hasSCarrierName()) || getSCarrierName() == rhs.getSCarrierName()) &&
        ((!hasBCellularSupported() && !rhs.hasBCellularSupported()) || getBCellularSupported() == rhs.getBCellularSupported()) &&
        ((!hasBTelephonyEnabled() && !rhs.hasBTelephonyEnabled()) || getBTelephonyEnabled() == rhs.getBTelephonyEnabled()) &&
        ((!hasBFaceTimeAudioEnabled() && !rhs.hasBFaceTimeAudioEnabled()) || getBFaceTimeAudioEnabled() == rhs.getBFaceTimeAudioEnabled()) &&
        ((!hasBFaceTimeVideoEnabled() && !rhs.hasBFaceTimeVideoEnabled()) || getBFaceTimeVideoEnabled() == rhs.getBFaceTimeVideoEnabled()) &&
        ((!hasBMuteStatus() && !rhs.hasBMuteStatus()) || getBMuteStatus() == rhs.getBMuteStatus()) &&
        ((!hasU8CurrentCallCount() && !rhs.hasU8CurrentCallCount()) || getU8CurrentCallCount() == rhs.getU8CurrentCallCount()) &&
        ((!hasU8NewVoicemailCount() && !rhs.hasU8NewVoicemailCount()) || getU8NewVoicemailCount() == rhs.getU8NewVoicemailCount()) &&
        ((!hasBInitiateCallAvalable() && !rhs.hasBInitiateCallAvalable()) || getBInitiateCallAvalable() == rhs.getBInitiateCallAvalable()) &&
        ((!hasBEndAndAcceptAvailable() && !rhs.hasBEndAndAcceptAvailable()) || getBEndAndAcceptAvailable() == rhs.getBEndAndAcceptAvailable()) &&
        ((!hasBHoldAndAcceptAvailable() && !rhs.hasBHoldAndAcceptAvailable()) || getBHoldAndAcceptAvailable() == rhs.getBHoldAndAcceptAvailable()) &&
        ((!hasBSwapAvailable() && !rhs.hasBSwapAvailable()) || getBSwapAvailable() == rhs.getBSwapAvailable()) &&
        ((!hasBMergeAvailable() && !rhs.hasBMergeAvailable()) || getBMergeAvailable() == rhs.getBMergeAvailable()) &&
        ((!hasBHoldAvailable() && !rhs.hasBHoldAvailable()) || getBHoldAvailable() == rhs.getBHoldAvailable()));
}

inline bool DiPOCommunicationsStatus::operator != (const DiPOCommunicationsStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPOCommunicationsStatus::operator < (const DiPOCommunicationsStatus& rhs) const {
    if (hasU8DeviceId() || rhs.hasU8DeviceId()) {
        if (getU8DeviceId() < rhs.getU8DeviceId()) return true;
        if (getU8DeviceId() > rhs.getU8DeviceId()) return false;
    }
    if (hasESignalStrength() || rhs.hasESignalStrength()) {
        if ((uint32)getESignalStrength() < (uint32)rhs.getESignalStrength()) return true;
        if ((uint32)getESignalStrength() > (uint32)rhs.getESignalStrength()) return false;
    }
    if (hasERegistrationStatus() || rhs.hasERegistrationStatus()) {
        if ((uint32)getERegistrationStatus() < (uint32)rhs.getERegistrationStatus()) return true;
        if ((uint32)getERegistrationStatus() > (uint32)rhs.getERegistrationStatus()) return false;
    }
    if (hasBAirplaneModeStatus() || rhs.hasBAirplaneModeStatus()) {
        if (getBAirplaneModeStatus() < rhs.getBAirplaneModeStatus()) return true;
        if (getBAirplaneModeStatus() > rhs.getBAirplaneModeStatus()) return false;
    }
    if (hasSCarrierName() || rhs.hasSCarrierName()) {
        if (getSCarrierName() < rhs.getSCarrierName()) return true;
        if (getSCarrierName() > rhs.getSCarrierName()) return false;
    }
    if (hasBCellularSupported() || rhs.hasBCellularSupported()) {
        if (getBCellularSupported() < rhs.getBCellularSupported()) return true;
        if (getBCellularSupported() > rhs.getBCellularSupported()) return false;
    }
    if (hasBTelephonyEnabled() || rhs.hasBTelephonyEnabled()) {
        if (getBTelephonyEnabled() < rhs.getBTelephonyEnabled()) return true;
        if (getBTelephonyEnabled() > rhs.getBTelephonyEnabled()) return false;
    }
    if (hasBFaceTimeAudioEnabled() || rhs.hasBFaceTimeAudioEnabled()) {
        if (getBFaceTimeAudioEnabled() < rhs.getBFaceTimeAudioEnabled()) return true;
        if (getBFaceTimeAudioEnabled() > rhs.getBFaceTimeAudioEnabled()) return false;
    }
    if (hasBFaceTimeVideoEnabled() || rhs.hasBFaceTimeVideoEnabled()) {
        if (getBFaceTimeVideoEnabled() < rhs.getBFaceTimeVideoEnabled()) return true;
        if (getBFaceTimeVideoEnabled() > rhs.getBFaceTimeVideoEnabled()) return false;
    }
    if (hasBMuteStatus() || rhs.hasBMuteStatus()) {
        if (getBMuteStatus() < rhs.getBMuteStatus()) return true;
        if (getBMuteStatus() > rhs.getBMuteStatus()) return false;
    }
    if (hasU8CurrentCallCount() || rhs.hasU8CurrentCallCount()) {
        if (getU8CurrentCallCount() < rhs.getU8CurrentCallCount()) return true;
        if (getU8CurrentCallCount() > rhs.getU8CurrentCallCount()) return false;
    }
    if (hasU8NewVoicemailCount() || rhs.hasU8NewVoicemailCount()) {
        if (getU8NewVoicemailCount() < rhs.getU8NewVoicemailCount()) return true;
        if (getU8NewVoicemailCount() > rhs.getU8NewVoicemailCount()) return false;
    }
    if (hasBInitiateCallAvalable() || rhs.hasBInitiateCallAvalable()) {
        if (getBInitiateCallAvalable() < rhs.getBInitiateCallAvalable()) return true;
        if (getBInitiateCallAvalable() > rhs.getBInitiateCallAvalable()) return false;
    }
    if (hasBEndAndAcceptAvailable() || rhs.hasBEndAndAcceptAvailable()) {
        if (getBEndAndAcceptAvailable() < rhs.getBEndAndAcceptAvailable()) return true;
        if (getBEndAndAcceptAvailable() > rhs.getBEndAndAcceptAvailable()) return false;
    }
    if (hasBHoldAndAcceptAvailable() || rhs.hasBHoldAndAcceptAvailable()) {
        if (getBHoldAndAcceptAvailable() < rhs.getBHoldAndAcceptAvailable()) return true;
        if (getBHoldAndAcceptAvailable() > rhs.getBHoldAndAcceptAvailable()) return false;
    }
    if (hasBSwapAvailable() || rhs.hasBSwapAvailable()) {
        if (getBSwapAvailable() < rhs.getBSwapAvailable()) return true;
        if (getBSwapAvailable() > rhs.getBSwapAvailable()) return false;
    }
    if (hasBMergeAvailable() || rhs.hasBMergeAvailable()) {
        if (getBMergeAvailable() < rhs.getBMergeAvailable()) return true;
        if (getBMergeAvailable() > rhs.getBMergeAvailable()) return false;
    }
    if (hasBHoldAvailable() || rhs.hasBHoldAvailable()) {
        if (getBHoldAvailable() < rhs.getBHoldAvailable()) return true;
        if (getBHoldAvailable() > rhs.getBHoldAvailable()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPOCommunicationsStatus::clone() {
    return new DiPOCommunicationsStatus(*this);
}

inline bool DiPOCommunicationsStatus::operator > (const DiPOCommunicationsStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPOCommunicationsStatus::clear() {
    clearU8DeviceId();
    clearESignalStrength();
    clearERegistrationStatus();
    clearBAirplaneModeStatus();
    clearSCarrierName();
    clearBCellularSupported();
    clearBTelephonyEnabled();
    clearBFaceTimeAudioEnabled();
    clearBFaceTimeVideoEnabled();
    clearBMuteStatus();
    clearU8CurrentCallCount();
    clearU8NewVoicemailCount();
    clearBInitiateCallAvalable();
    clearBEndAndAcceptAvailable();
    clearBHoldAndAcceptAvailable();
    clearBSwapAvailable();
    clearBMergeAvailable();
    clearBHoldAvailable();
}

inline void DiPOCommunicationsStatus::clearU8DeviceId() {
    if (hasU8DeviceId()) {
         clear_has_u8DeviceId();
        _u8DeviceId = 0u;
     }
}

inline bool DiPOCommunicationsStatus::hasU8DeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DiPOCommunicationsStatus::getU8DeviceId () const {
    return _u8DeviceId;
}

inline void DiPOCommunicationsStatus::setU8DeviceId (uint8 u8DeviceId_) {
    set_has_u8DeviceId();
    this->_u8DeviceId = u8DeviceId_;
}

inline void DiPOCommunicationsStatus::clearESignalStrength() {
    if (hasESignalStrength()) {
         clear_has_eSignalStrength();
        _eSignalStrength = ::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateSignalStrength__e8DIPO_CUSS_0BARS;
     }
}

inline bool DiPOCommunicationsStatus::hasESignalStrength () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateSignalStrength DiPOCommunicationsStatus::getESignalStrength () const {
    return _eSignalStrength;
}

inline void DiPOCommunicationsStatus::setESignalStrength (::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateSignalStrength eSignalStrength_) {
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateSignalStrength_IsValid(eSignalStrength_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eSignalStrength_, "T_e8_DiPOCommunicationsUpdateSignalStrength", "eSignalStrength", "DiPOCommunicationsStatus");
    }
    #endif
    set_has_eSignalStrength();
    this->_eSignalStrength = eSignalStrength_;
}

inline void DiPOCommunicationsStatus::clearERegistrationStatus() {
    if (hasERegistrationStatus()) {
         clear_has_eRegistrationStatus();
        _eRegistrationStatus = ::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateRegistrationStatus__e8DIPO_CURS_UNKNONW;
     }
}

inline bool DiPOCommunicationsStatus::hasERegistrationStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateRegistrationStatus DiPOCommunicationsStatus::getERegistrationStatus () const {
    return _eRegistrationStatus;
}

inline void DiPOCommunicationsStatus::setERegistrationStatus (::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateRegistrationStatus eRegistrationStatus_) {
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationsUpdateRegistrationStatus_IsValid(eRegistrationStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eRegistrationStatus_, "T_e8_DiPOCommunicationsUpdateRegistrationStatus", "eRegistrationStatus", "DiPOCommunicationsStatus");
    }
    #endif
    set_has_eRegistrationStatus();
    this->_eRegistrationStatus = eRegistrationStatus_;
}

inline void DiPOCommunicationsStatus::clearBAirplaneModeStatus() {
    if (hasBAirplaneModeStatus()) {
         clear_has_bAirplaneModeStatus();
        _bAirplaneModeStatus = false;
     }
}

inline bool DiPOCommunicationsStatus::hasBAirplaneModeStatus () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool DiPOCommunicationsStatus::getBAirplaneModeStatus () const {
    return _bAirplaneModeStatus;
}

inline void DiPOCommunicationsStatus::setBAirplaneModeStatus (bool bAirplaneModeStatus_) {
    set_has_bAirplaneModeStatus();
    this->_bAirplaneModeStatus = bAirplaneModeStatus_;
}

inline void DiPOCommunicationsStatus::clearSCarrierName() {
    if (hasSCarrierName()) {
         clear_has_sCarrierName();
        _sCarrierName.clear();
     }
}

inline bool DiPOCommunicationsStatus::hasSCarrierName () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& DiPOCommunicationsStatus::getSCarrierName () const {
    return _sCarrierName;
}

inline ::std::string& DiPOCommunicationsStatus::getSCarrierNameMutable () {
    set_has_sCarrierName();
    return _sCarrierName;
}

inline void DiPOCommunicationsStatus::setSCarrierName (const ::std::string& sCarrierName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCarrierName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCarrierName();
    this->_sCarrierName = sCarrierName_;
}

inline void DiPOCommunicationsStatus::setSCarrierName (const char* sCarrierName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCarrierName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCarrierName();
    this->_sCarrierName.assign(sCarrierName_);
}

inline void DiPOCommunicationsStatus::setSCarrierName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCarrierName();
    this->_sCarrierName.assign(value, size);
}

inline void DiPOCommunicationsStatus::clearBCellularSupported() {
    if (hasBCellularSupported()) {
         clear_has_bCellularSupported();
        _bCellularSupported = false;
     }
}

inline bool DiPOCommunicationsStatus::hasBCellularSupported () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline bool DiPOCommunicationsStatus::getBCellularSupported () const {
    return _bCellularSupported;
}

inline void DiPOCommunicationsStatus::setBCellularSupported (bool bCellularSupported_) {
    set_has_bCellularSupported();
    this->_bCellularSupported = bCellularSupported_;
}

inline void DiPOCommunicationsStatus::clearBTelephonyEnabled() {
    if (hasBTelephonyEnabled()) {
         clear_has_bTelephonyEnabled();
        _bTelephonyEnabled = false;
     }
}

inline bool DiPOCommunicationsStatus::hasBTelephonyEnabled () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool DiPOCommunicationsStatus::getBTelephonyEnabled () const {
    return _bTelephonyEnabled;
}

inline void DiPOCommunicationsStatus::setBTelephonyEnabled (bool bTelephonyEnabled_) {
    set_has_bTelephonyEnabled();
    this->_bTelephonyEnabled = bTelephonyEnabled_;
}

inline void DiPOCommunicationsStatus::clearBFaceTimeAudioEnabled() {
    if (hasBFaceTimeAudioEnabled()) {
         clear_has_bFaceTimeAudioEnabled();
        _bFaceTimeAudioEnabled = false;
     }
}

inline bool DiPOCommunicationsStatus::hasBFaceTimeAudioEnabled () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline bool DiPOCommunicationsStatus::getBFaceTimeAudioEnabled () const {
    return _bFaceTimeAudioEnabled;
}

inline void DiPOCommunicationsStatus::setBFaceTimeAudioEnabled (bool bFaceTimeAudioEnabled_) {
    set_has_bFaceTimeAudioEnabled();
    this->_bFaceTimeAudioEnabled = bFaceTimeAudioEnabled_;
}

inline void DiPOCommunicationsStatus::clearBFaceTimeVideoEnabled() {
    if (hasBFaceTimeVideoEnabled()) {
         clear_has_bFaceTimeVideoEnabled();
        _bFaceTimeVideoEnabled = false;
     }
}

inline bool DiPOCommunicationsStatus::hasBFaceTimeVideoEnabled () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline bool DiPOCommunicationsStatus::getBFaceTimeVideoEnabled () const {
    return _bFaceTimeVideoEnabled;
}

inline void DiPOCommunicationsStatus::setBFaceTimeVideoEnabled (bool bFaceTimeVideoEnabled_) {
    set_has_bFaceTimeVideoEnabled();
    this->_bFaceTimeVideoEnabled = bFaceTimeVideoEnabled_;
}

inline void DiPOCommunicationsStatus::clearBMuteStatus() {
    if (hasBMuteStatus()) {
         clear_has_bMuteStatus();
        _bMuteStatus = false;
     }
}

inline bool DiPOCommunicationsStatus::hasBMuteStatus () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline bool DiPOCommunicationsStatus::getBMuteStatus () const {
    return _bMuteStatus;
}

inline void DiPOCommunicationsStatus::setBMuteStatus (bool bMuteStatus_) {
    set_has_bMuteStatus();
    this->_bMuteStatus = bMuteStatus_;
}

inline void DiPOCommunicationsStatus::clearU8CurrentCallCount() {
    if (hasU8CurrentCallCount()) {
         clear_has_u8CurrentCallCount();
        _u8CurrentCallCount = 0u;
     }
}

inline bool DiPOCommunicationsStatus::hasU8CurrentCallCount () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline uint8 DiPOCommunicationsStatus::getU8CurrentCallCount () const {
    return _u8CurrentCallCount;
}

inline void DiPOCommunicationsStatus::setU8CurrentCallCount (uint8 u8CurrentCallCount_) {
    set_has_u8CurrentCallCount();
    this->_u8CurrentCallCount = u8CurrentCallCount_;
}

inline void DiPOCommunicationsStatus::clearU8NewVoicemailCount() {
    if (hasU8NewVoicemailCount()) {
         clear_has_u8NewVoicemailCount();
        _u8NewVoicemailCount = 0u;
     }
}

inline bool DiPOCommunicationsStatus::hasU8NewVoicemailCount () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline uint8 DiPOCommunicationsStatus::getU8NewVoicemailCount () const {
    return _u8NewVoicemailCount;
}

inline void DiPOCommunicationsStatus::setU8NewVoicemailCount (uint8 u8NewVoicemailCount_) {
    set_has_u8NewVoicemailCount();
    this->_u8NewVoicemailCount = u8NewVoicemailCount_;
}

inline void DiPOCommunicationsStatus::clearBInitiateCallAvalable() {
    if (hasBInitiateCallAvalable()) {
         clear_has_bInitiateCallAvalable();
        _bInitiateCallAvalable = false;
     }
}

inline bool DiPOCommunicationsStatus::hasBInitiateCallAvalable () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline bool DiPOCommunicationsStatus::getBInitiateCallAvalable () const {
    return _bInitiateCallAvalable;
}

inline void DiPOCommunicationsStatus::setBInitiateCallAvalable (bool bInitiateCallAvalable_) {
    set_has_bInitiateCallAvalable();
    this->_bInitiateCallAvalable = bInitiateCallAvalable_;
}

inline void DiPOCommunicationsStatus::clearBEndAndAcceptAvailable() {
    if (hasBEndAndAcceptAvailable()) {
         clear_has_bEndAndAcceptAvailable();
        _bEndAndAcceptAvailable = false;
     }
}

inline bool DiPOCommunicationsStatus::hasBEndAndAcceptAvailable () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline bool DiPOCommunicationsStatus::getBEndAndAcceptAvailable () const {
    return _bEndAndAcceptAvailable;
}

inline void DiPOCommunicationsStatus::setBEndAndAcceptAvailable (bool bEndAndAcceptAvailable_) {
    set_has_bEndAndAcceptAvailable();
    this->_bEndAndAcceptAvailable = bEndAndAcceptAvailable_;
}

inline void DiPOCommunicationsStatus::clearBHoldAndAcceptAvailable() {
    if (hasBHoldAndAcceptAvailable()) {
         clear_has_bHoldAndAcceptAvailable();
        _bHoldAndAcceptAvailable = false;
     }
}

inline bool DiPOCommunicationsStatus::hasBHoldAndAcceptAvailable () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline bool DiPOCommunicationsStatus::getBHoldAndAcceptAvailable () const {
    return _bHoldAndAcceptAvailable;
}

inline void DiPOCommunicationsStatus::setBHoldAndAcceptAvailable (bool bHoldAndAcceptAvailable_) {
    set_has_bHoldAndAcceptAvailable();
    this->_bHoldAndAcceptAvailable = bHoldAndAcceptAvailable_;
}

inline void DiPOCommunicationsStatus::clearBSwapAvailable() {
    if (hasBSwapAvailable()) {
         clear_has_bSwapAvailable();
        _bSwapAvailable = false;
     }
}

inline bool DiPOCommunicationsStatus::hasBSwapAvailable () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline bool DiPOCommunicationsStatus::getBSwapAvailable () const {
    return _bSwapAvailable;
}

inline void DiPOCommunicationsStatus::setBSwapAvailable (bool bSwapAvailable_) {
    set_has_bSwapAvailable();
    this->_bSwapAvailable = bSwapAvailable_;
}

inline void DiPOCommunicationsStatus::clearBMergeAvailable() {
    if (hasBMergeAvailable()) {
         clear_has_bMergeAvailable();
        _bMergeAvailable = false;
     }
}

inline bool DiPOCommunicationsStatus::hasBMergeAvailable () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline bool DiPOCommunicationsStatus::getBMergeAvailable () const {
    return _bMergeAvailable;
}

inline void DiPOCommunicationsStatus::setBMergeAvailable (bool bMergeAvailable_) {
    set_has_bMergeAvailable();
    this->_bMergeAvailable = bMergeAvailable_;
}

inline void DiPOCommunicationsStatus::clearBHoldAvailable() {
    if (hasBHoldAvailable()) {
         clear_has_bHoldAvailable();
        _bHoldAvailable = false;
     }
}

inline bool DiPOCommunicationsStatus::hasBHoldAvailable () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline bool DiPOCommunicationsStatus::getBHoldAvailable () const {
    return _bHoldAvailable;
}

inline void DiPOCommunicationsStatus::setBHoldAvailable (bool bHoldAvailable_) {
    set_has_bHoldAvailable();
    this->_bHoldAvailable = bHoldAvailable_;
}

inline void DiPOCommunicationsStatus::set_has_u8DeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPOCommunicationsStatus::clear_has_u8DeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiPOCommunicationsStatus::set_has_eSignalStrength () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiPOCommunicationsStatus::clear_has_eSignalStrength () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DiPOCommunicationsStatus::set_has_eRegistrationStatus () {
    _has_bits_[0] |= 1u << 2;
}

inline void DiPOCommunicationsStatus::clear_has_eRegistrationStatus () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DiPOCommunicationsStatus::set_has_bAirplaneModeStatus () {
    _has_bits_[0] |= 1u << 3;
}

inline void DiPOCommunicationsStatus::clear_has_bAirplaneModeStatus () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void DiPOCommunicationsStatus::set_has_sCarrierName () {
    _has_bits_[0] |= 1u << 4;
}

inline void DiPOCommunicationsStatus::clear_has_sCarrierName () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void DiPOCommunicationsStatus::set_has_bCellularSupported () {
    _has_bits_[0] |= 1u << 5;
}

inline void DiPOCommunicationsStatus::clear_has_bCellularSupported () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void DiPOCommunicationsStatus::set_has_bTelephonyEnabled () {
    _has_bits_[0] |= 1u << 6;
}

inline void DiPOCommunicationsStatus::clear_has_bTelephonyEnabled () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void DiPOCommunicationsStatus::set_has_bFaceTimeAudioEnabled () {
    _has_bits_[0] |= 1u << 7;
}

inline void DiPOCommunicationsStatus::clear_has_bFaceTimeAudioEnabled () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void DiPOCommunicationsStatus::set_has_bFaceTimeVideoEnabled () {
    _has_bits_[0] |= 1u << 8;
}

inline void DiPOCommunicationsStatus::clear_has_bFaceTimeVideoEnabled () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void DiPOCommunicationsStatus::set_has_bMuteStatus () {
    _has_bits_[0] |= 1u << 9;
}

inline void DiPOCommunicationsStatus::clear_has_bMuteStatus () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void DiPOCommunicationsStatus::set_has_u8CurrentCallCount () {
    _has_bits_[0] |= 1u << 10;
}

inline void DiPOCommunicationsStatus::clear_has_u8CurrentCallCount () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void DiPOCommunicationsStatus::set_has_u8NewVoicemailCount () {
    _has_bits_[0] |= 1u << 11;
}

inline void DiPOCommunicationsStatus::clear_has_u8NewVoicemailCount () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void DiPOCommunicationsStatus::set_has_bInitiateCallAvalable () {
    _has_bits_[0] |= 1u << 12;
}

inline void DiPOCommunicationsStatus::clear_has_bInitiateCallAvalable () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void DiPOCommunicationsStatus::set_has_bEndAndAcceptAvailable () {
    _has_bits_[0] |= 1u << 13;
}

inline void DiPOCommunicationsStatus::clear_has_bEndAndAcceptAvailable () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void DiPOCommunicationsStatus::set_has_bHoldAndAcceptAvailable () {
    _has_bits_[0] |= 1u << 14;
}

inline void DiPOCommunicationsStatus::clear_has_bHoldAndAcceptAvailable () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void DiPOCommunicationsStatus::set_has_bSwapAvailable () {
    _has_bits_[0] |= 1u << 15;
}

inline void DiPOCommunicationsStatus::clear_has_bSwapAvailable () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void DiPOCommunicationsStatus::set_has_bMergeAvailable () {
    _has_bits_[0] |= 1u << 16;
}

inline void DiPOCommunicationsStatus::clear_has_bMergeAvailable () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void DiPOCommunicationsStatus::set_has_bHoldAvailable () {
    _has_bits_[0] |= 1u << 17;
}

inline void DiPOCommunicationsStatus::clear_has_bHoldAvailable () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline  DiPOCommunicationErrorStatus::DiPOCommunicationErrorStatus ()  :
    _u8DeviceTag (0u),
    _e8DiPOCommunicationError (::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationError__e8IPOD_NO_ERROR),
    _sDeviceUSBSerialNumber ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPOCommunicationErrorStatus::DiPOCommunicationErrorStatus (const DiPOCommunicationErrorStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _u8DeviceTag (0u),
    _e8DiPOCommunicationError (::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationError__e8IPOD_NO_ERROR),
    _sDeviceUSBSerialNumber ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPOCommunicationErrorStatus::DiPOCommunicationErrorStatus (uint8 u8DeviceTag_, ::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationError e8DiPOCommunicationError_, const ::std::string& sDeviceUSBSerialNumber_)  :
    _u8DeviceTag (u8DeviceTag_),
    _e8DiPOCommunicationError (e8DiPOCommunicationError_),
    _sDeviceUSBSerialNumber (sDeviceUSBSerialNumber_)
{
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationError_IsValid(e8DiPOCommunicationError_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DiPOCommunicationError_, "T_e8_DiPOCommunicationError", "e8DiPOCommunicationError", "DiPOCommunicationErrorStatus");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPOCommunicationErrorStatus::~DiPOCommunicationErrorStatus() {
}

inline DiPOCommunicationErrorStatus& DiPOCommunicationErrorStatus::operator = (const DiPOCommunicationErrorStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8DeviceTag()) {
            setU8DeviceTag(rhs.getU8DeviceTag());
        } else {
            clearU8DeviceTag();
        }
        if (rhs.hasE8DiPOCommunicationError()) {
            setE8DiPOCommunicationError(rhs.getE8DiPOCommunicationError());
        } else {
            clearE8DiPOCommunicationError();
        }
        if (rhs.hasSDeviceUSBSerialNumber()) {
            setSDeviceUSBSerialNumber(rhs.getSDeviceUSBSerialNumber());
        } else {
            clearSDeviceUSBSerialNumber();
        }
    }
    return *this;
}

inline bool DiPOCommunicationErrorStatus::operator == (const DiPOCommunicationErrorStatus& rhs) const {
    return (((!hasU8DeviceTag() && !rhs.hasU8DeviceTag()) || getU8DeviceTag() == rhs.getU8DeviceTag()) &&
        ((!hasE8DiPOCommunicationError() && !rhs.hasE8DiPOCommunicationError()) || getE8DiPOCommunicationError() == rhs.getE8DiPOCommunicationError()) &&
        ((!hasSDeviceUSBSerialNumber() && !rhs.hasSDeviceUSBSerialNumber()) || getSDeviceUSBSerialNumber() == rhs.getSDeviceUSBSerialNumber()));
}

inline bool DiPOCommunicationErrorStatus::operator != (const DiPOCommunicationErrorStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPOCommunicationErrorStatus::operator < (const DiPOCommunicationErrorStatus& rhs) const {
    if (hasU8DeviceTag() || rhs.hasU8DeviceTag()) {
        if (getU8DeviceTag() < rhs.getU8DeviceTag()) return true;
        if (getU8DeviceTag() > rhs.getU8DeviceTag()) return false;
    }
    if (hasE8DiPOCommunicationError() || rhs.hasE8DiPOCommunicationError()) {
        if ((uint32)getE8DiPOCommunicationError() < (uint32)rhs.getE8DiPOCommunicationError()) return true;
        if ((uint32)getE8DiPOCommunicationError() > (uint32)rhs.getE8DiPOCommunicationError()) return false;
    }
    if (hasSDeviceUSBSerialNumber() || rhs.hasSDeviceUSBSerialNumber()) {
        if (getSDeviceUSBSerialNumber() < rhs.getSDeviceUSBSerialNumber()) return true;
        if (getSDeviceUSBSerialNumber() > rhs.getSDeviceUSBSerialNumber()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPOCommunicationErrorStatus::clone() {
    return new DiPOCommunicationErrorStatus(*this);
}

inline bool DiPOCommunicationErrorStatus::operator > (const DiPOCommunicationErrorStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPOCommunicationErrorStatus::clear() {
    clearU8DeviceTag();
    clearE8DiPOCommunicationError();
    clearSDeviceUSBSerialNumber();
}

inline void DiPOCommunicationErrorStatus::clearU8DeviceTag() {
    if (hasU8DeviceTag()) {
         clear_has_u8DeviceTag();
        _u8DeviceTag = 0u;
     }
}

inline bool DiPOCommunicationErrorStatus::hasU8DeviceTag () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DiPOCommunicationErrorStatus::getU8DeviceTag () const {
    return _u8DeviceTag;
}

inline void DiPOCommunicationErrorStatus::setU8DeviceTag (uint8 u8DeviceTag_) {
    set_has_u8DeviceTag();
    this->_u8DeviceTag = u8DeviceTag_;
}

inline void DiPOCommunicationErrorStatus::clearE8DiPOCommunicationError() {
    if (hasE8DiPOCommunicationError()) {
         clear_has_e8DiPOCommunicationError();
        _e8DiPOCommunicationError = ::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationError__e8IPOD_NO_ERROR;
     }
}

inline bool DiPOCommunicationErrorStatus::hasE8DiPOCommunicationError () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationError DiPOCommunicationErrorStatus::getE8DiPOCommunicationError () const {
    return _e8DiPOCommunicationError;
}

inline void DiPOCommunicationErrorStatus::setE8DiPOCommunicationError (::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationError e8DiPOCommunicationError_) {
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DiPOCommunicationError_IsValid(e8DiPOCommunicationError_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DiPOCommunicationError_, "T_e8_DiPOCommunicationError", "e8DiPOCommunicationError", "DiPOCommunicationErrorStatus");
    }
    #endif
    set_has_e8DiPOCommunicationError();
    this->_e8DiPOCommunicationError = e8DiPOCommunicationError_;
}

inline void DiPOCommunicationErrorStatus::clearSDeviceUSBSerialNumber() {
    if (hasSDeviceUSBSerialNumber()) {
         clear_has_sDeviceUSBSerialNumber();
        _sDeviceUSBSerialNumber.clear();
     }
}

inline bool DiPOCommunicationErrorStatus::hasSDeviceUSBSerialNumber () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& DiPOCommunicationErrorStatus::getSDeviceUSBSerialNumber () const {
    return _sDeviceUSBSerialNumber;
}

inline ::std::string& DiPOCommunicationErrorStatus::getSDeviceUSBSerialNumberMutable () {
    set_has_sDeviceUSBSerialNumber();
    return _sDeviceUSBSerialNumber;
}

inline void DiPOCommunicationErrorStatus::setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber = sDeviceUSBSerialNumber_;
}

inline void DiPOCommunicationErrorStatus::setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber.assign(sDeviceUSBSerialNumber_);
}

inline void DiPOCommunicationErrorStatus::setSDeviceUSBSerialNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber.assign(value, size);
}

inline void DiPOCommunicationErrorStatus::set_has_u8DeviceTag () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPOCommunicationErrorStatus::clear_has_u8DeviceTag () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiPOCommunicationErrorStatus::set_has_e8DiPOCommunicationError () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiPOCommunicationErrorStatus::clear_has_e8DiPOCommunicationError () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DiPOCommunicationErrorStatus::set_has_sDeviceUSBSerialNumber () {
    _has_bits_[0] |= 1u << 2;
}

inline void DiPOCommunicationErrorStatus::clear_has_sDeviceUSBSerialNumber () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  DiPOCallDurationStatus::DiPOCallDurationStatus ()  :
    _u8DeviceId (0u),
    _u32CallDuration (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPOCallDurationStatus::DiPOCallDurationStatus (const DiPOCallDurationStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _u8DeviceId (0u),
    _u32CallDuration (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPOCallDurationStatus::DiPOCallDurationStatus (uint8 u8DeviceId_, uint32 u32CallDuration_)  :
    _u8DeviceId (u8DeviceId_),
    _u32CallDuration (u32CallDuration_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPOCallDurationStatus::~DiPOCallDurationStatus() {
}

inline DiPOCallDurationStatus& DiPOCallDurationStatus::operator = (const DiPOCallDurationStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8DeviceId()) {
            setU8DeviceId(rhs.getU8DeviceId());
        } else {
            clearU8DeviceId();
        }
        if (rhs.hasU32CallDuration()) {
            setU32CallDuration(rhs.getU32CallDuration());
        } else {
            clearU32CallDuration();
        }
    }
    return *this;
}

inline bool DiPOCallDurationStatus::operator == (const DiPOCallDurationStatus& rhs) const {
    return (((!hasU8DeviceId() && !rhs.hasU8DeviceId()) || getU8DeviceId() == rhs.getU8DeviceId()) &&
        ((!hasU32CallDuration() && !rhs.hasU32CallDuration()) || getU32CallDuration() == rhs.getU32CallDuration()));
}

inline bool DiPOCallDurationStatus::operator != (const DiPOCallDurationStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPOCallDurationStatus::operator < (const DiPOCallDurationStatus& rhs) const {
    if (hasU8DeviceId() || rhs.hasU8DeviceId()) {
        if (getU8DeviceId() < rhs.getU8DeviceId()) return true;
        if (getU8DeviceId() > rhs.getU8DeviceId()) return false;
    }
    if (hasU32CallDuration() || rhs.hasU32CallDuration()) {
        if (getU32CallDuration() < rhs.getU32CallDuration()) return true;
        if (getU32CallDuration() > rhs.getU32CallDuration()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPOCallDurationStatus::clone() {
    return new DiPOCallDurationStatus(*this);
}

inline bool DiPOCallDurationStatus::operator > (const DiPOCallDurationStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPOCallDurationStatus::clear() {
    clearU8DeviceId();
    clearU32CallDuration();
}

inline void DiPOCallDurationStatus::clearU8DeviceId() {
    if (hasU8DeviceId()) {
         clear_has_u8DeviceId();
        _u8DeviceId = 0u;
     }
}

inline bool DiPOCallDurationStatus::hasU8DeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DiPOCallDurationStatus::getU8DeviceId () const {
    return _u8DeviceId;
}

inline void DiPOCallDurationStatus::setU8DeviceId (uint8 u8DeviceId_) {
    set_has_u8DeviceId();
    this->_u8DeviceId = u8DeviceId_;
}

inline void DiPOCallDurationStatus::clearU32CallDuration() {
    if (hasU32CallDuration()) {
         clear_has_u32CallDuration();
        _u32CallDuration = 0u;
     }
}

inline bool DiPOCallDurationStatus::hasU32CallDuration () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 DiPOCallDurationStatus::getU32CallDuration () const {
    return _u32CallDuration;
}

inline void DiPOCallDurationStatus::setU32CallDuration (uint32 u32CallDuration_) {
    set_has_u32CallDuration();
    this->_u32CallDuration = u32CallDuration_;
}

inline void DiPOCallDurationStatus::set_has_u8DeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPOCallDurationStatus::clear_has_u8DeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiPOCallDurationStatus::set_has_u32CallDuration () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiPOCallDurationStatus::clear_has_u32CallDuration () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DiPOPowerStatus::DiPOPowerStatus ()  :
    _u8DeviceId (0u),
    _u16BatteryChargeLevel (0u),
    _e8AccessoryPowerMode (::mplay_appcontrol_fi_types::T_e8_AccessoryPowerMode__e8DIPO_APM_INTERMITTENT_HIGH_POWER_MODE),
    _u16MaximumCurrentDrawnFromAccessory (0u),
    _bDeviceBatteryWillChargeIfPowerIsPresent (false),
    _e8BatteryChargingState (::mplay_appcontrol_fi_types::T_e8_BatteryChargingState__e8DIPO_BCS_CHARGED),
    _bIsExternalChargerConnected (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPOPowerStatus::DiPOPowerStatus (const DiPOPowerStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _u8DeviceId (0u),
    _u16BatteryChargeLevel (0u),
    _e8AccessoryPowerMode (::mplay_appcontrol_fi_types::T_e8_AccessoryPowerMode__e8DIPO_APM_INTERMITTENT_HIGH_POWER_MODE),
    _u16MaximumCurrentDrawnFromAccessory (0u),
    _bDeviceBatteryWillChargeIfPowerIsPresent (false),
    _e8BatteryChargingState (::mplay_appcontrol_fi_types::T_e8_BatteryChargingState__e8DIPO_BCS_CHARGED),
    _bIsExternalChargerConnected (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPOPowerStatus::DiPOPowerStatus (uint8 u8DeviceId_, uint16 u16BatteryChargeLevel_, ::mplay_appcontrol_fi_types::T_e8_AccessoryPowerMode e8AccessoryPowerMode_, uint16 u16MaximumCurrentDrawnFromAccessory_, bool bDeviceBatteryWillChargeIfPowerIsPresent_, ::mplay_appcontrol_fi_types::T_e8_BatteryChargingState e8BatteryChargingState_, bool bIsExternalChargerConnected_)  :
    _u8DeviceId (u8DeviceId_),
    _u16BatteryChargeLevel (u16BatteryChargeLevel_),
    _e8AccessoryPowerMode (e8AccessoryPowerMode_),
    _u16MaximumCurrentDrawnFromAccessory (u16MaximumCurrentDrawnFromAccessory_),
    _bDeviceBatteryWillChargeIfPowerIsPresent (bDeviceBatteryWillChargeIfPowerIsPresent_),
    _e8BatteryChargingState (e8BatteryChargingState_),
    _bIsExternalChargerConnected (bIsExternalChargerConnected_)
{
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_AccessoryPowerMode_IsValid(e8AccessoryPowerMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AccessoryPowerMode_, "T_e8_AccessoryPowerMode", "e8AccessoryPowerMode", "DiPOPowerStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_BatteryChargingState_IsValid(e8BatteryChargingState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8BatteryChargingState_, "T_e8_BatteryChargingState", "e8BatteryChargingState", "DiPOPowerStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPOPowerStatus::~DiPOPowerStatus() {
}

inline DiPOPowerStatus& DiPOPowerStatus::operator = (const DiPOPowerStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8DeviceId()) {
            setU8DeviceId(rhs.getU8DeviceId());
        } else {
            clearU8DeviceId();
        }
        if (rhs.hasU16BatteryChargeLevel()) {
            setU16BatteryChargeLevel(rhs.getU16BatteryChargeLevel());
        } else {
            clearU16BatteryChargeLevel();
        }
        if (rhs.hasE8AccessoryPowerMode()) {
            setE8AccessoryPowerMode(rhs.getE8AccessoryPowerMode());
        } else {
            clearE8AccessoryPowerMode();
        }
        if (rhs.hasU16MaximumCurrentDrawnFromAccessory()) {
            setU16MaximumCurrentDrawnFromAccessory(rhs.getU16MaximumCurrentDrawnFromAccessory());
        } else {
            clearU16MaximumCurrentDrawnFromAccessory();
        }
        if (rhs.hasBDeviceBatteryWillChargeIfPowerIsPresent()) {
            setBDeviceBatteryWillChargeIfPowerIsPresent(rhs.getBDeviceBatteryWillChargeIfPowerIsPresent());
        } else {
            clearBDeviceBatteryWillChargeIfPowerIsPresent();
        }
        if (rhs.hasE8BatteryChargingState()) {
            setE8BatteryChargingState(rhs.getE8BatteryChargingState());
        } else {
            clearE8BatteryChargingState();
        }
        if (rhs.hasBIsExternalChargerConnected()) {
            setBIsExternalChargerConnected(rhs.getBIsExternalChargerConnected());
        } else {
            clearBIsExternalChargerConnected();
        }
    }
    return *this;
}

inline bool DiPOPowerStatus::operator == (const DiPOPowerStatus& rhs) const {
    return (((!hasU8DeviceId() && !rhs.hasU8DeviceId()) || getU8DeviceId() == rhs.getU8DeviceId()) &&
        ((!hasU16BatteryChargeLevel() && !rhs.hasU16BatteryChargeLevel()) || getU16BatteryChargeLevel() == rhs.getU16BatteryChargeLevel()) &&
        ((!hasE8AccessoryPowerMode() && !rhs.hasE8AccessoryPowerMode()) || getE8AccessoryPowerMode() == rhs.getE8AccessoryPowerMode()) &&
        ((!hasU16MaximumCurrentDrawnFromAccessory() && !rhs.hasU16MaximumCurrentDrawnFromAccessory()) || getU16MaximumCurrentDrawnFromAccessory() == rhs.getU16MaximumCurrentDrawnFromAccessory()) &&
        ((!hasBDeviceBatteryWillChargeIfPowerIsPresent() && !rhs.hasBDeviceBatteryWillChargeIfPowerIsPresent()) || getBDeviceBatteryWillChargeIfPowerIsPresent() == rhs.getBDeviceBatteryWillChargeIfPowerIsPresent()) &&
        ((!hasE8BatteryChargingState() && !rhs.hasE8BatteryChargingState()) || getE8BatteryChargingState() == rhs.getE8BatteryChargingState()) &&
        ((!hasBIsExternalChargerConnected() && !rhs.hasBIsExternalChargerConnected()) || getBIsExternalChargerConnected() == rhs.getBIsExternalChargerConnected()));
}

inline bool DiPOPowerStatus::operator != (const DiPOPowerStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPOPowerStatus::operator < (const DiPOPowerStatus& rhs) const {
    if (hasU8DeviceId() || rhs.hasU8DeviceId()) {
        if (getU8DeviceId() < rhs.getU8DeviceId()) return true;
        if (getU8DeviceId() > rhs.getU8DeviceId()) return false;
    }
    if (hasU16BatteryChargeLevel() || rhs.hasU16BatteryChargeLevel()) {
        if (getU16BatteryChargeLevel() < rhs.getU16BatteryChargeLevel()) return true;
        if (getU16BatteryChargeLevel() > rhs.getU16BatteryChargeLevel()) return false;
    }
    if (hasE8AccessoryPowerMode() || rhs.hasE8AccessoryPowerMode()) {
        if ((uint32)getE8AccessoryPowerMode() < (uint32)rhs.getE8AccessoryPowerMode()) return true;
        if ((uint32)getE8AccessoryPowerMode() > (uint32)rhs.getE8AccessoryPowerMode()) return false;
    }
    if (hasU16MaximumCurrentDrawnFromAccessory() || rhs.hasU16MaximumCurrentDrawnFromAccessory()) {
        if (getU16MaximumCurrentDrawnFromAccessory() < rhs.getU16MaximumCurrentDrawnFromAccessory()) return true;
        if (getU16MaximumCurrentDrawnFromAccessory() > rhs.getU16MaximumCurrentDrawnFromAccessory()) return false;
    }
    if (hasBDeviceBatteryWillChargeIfPowerIsPresent() || rhs.hasBDeviceBatteryWillChargeIfPowerIsPresent()) {
        if (getBDeviceBatteryWillChargeIfPowerIsPresent() < rhs.getBDeviceBatteryWillChargeIfPowerIsPresent()) return true;
        if (getBDeviceBatteryWillChargeIfPowerIsPresent() > rhs.getBDeviceBatteryWillChargeIfPowerIsPresent()) return false;
    }
    if (hasE8BatteryChargingState() || rhs.hasE8BatteryChargingState()) {
        if ((uint32)getE8BatteryChargingState() < (uint32)rhs.getE8BatteryChargingState()) return true;
        if ((uint32)getE8BatteryChargingState() > (uint32)rhs.getE8BatteryChargingState()) return false;
    }
    if (hasBIsExternalChargerConnected() || rhs.hasBIsExternalChargerConnected()) {
        if (getBIsExternalChargerConnected() < rhs.getBIsExternalChargerConnected()) return true;
        if (getBIsExternalChargerConnected() > rhs.getBIsExternalChargerConnected()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPOPowerStatus::clone() {
    return new DiPOPowerStatus(*this);
}

inline bool DiPOPowerStatus::operator > (const DiPOPowerStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPOPowerStatus::clear() {
    clearU8DeviceId();
    clearU16BatteryChargeLevel();
    clearE8AccessoryPowerMode();
    clearU16MaximumCurrentDrawnFromAccessory();
    clearBDeviceBatteryWillChargeIfPowerIsPresent();
    clearE8BatteryChargingState();
    clearBIsExternalChargerConnected();
}

inline void DiPOPowerStatus::clearU8DeviceId() {
    if (hasU8DeviceId()) {
         clear_has_u8DeviceId();
        _u8DeviceId = 0u;
     }
}

inline bool DiPOPowerStatus::hasU8DeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DiPOPowerStatus::getU8DeviceId () const {
    return _u8DeviceId;
}

inline void DiPOPowerStatus::setU8DeviceId (uint8 u8DeviceId_) {
    set_has_u8DeviceId();
    this->_u8DeviceId = u8DeviceId_;
}

inline void DiPOPowerStatus::clearU16BatteryChargeLevel() {
    if (hasU16BatteryChargeLevel()) {
         clear_has_u16BatteryChargeLevel();
        _u16BatteryChargeLevel = 0u;
     }
}

inline bool DiPOPowerStatus::hasU16BatteryChargeLevel () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 DiPOPowerStatus::getU16BatteryChargeLevel () const {
    return _u16BatteryChargeLevel;
}

inline void DiPOPowerStatus::setU16BatteryChargeLevel (uint16 u16BatteryChargeLevel_) {
    set_has_u16BatteryChargeLevel();
    this->_u16BatteryChargeLevel = u16BatteryChargeLevel_;
}

inline void DiPOPowerStatus::clearE8AccessoryPowerMode() {
    if (hasE8AccessoryPowerMode()) {
         clear_has_e8AccessoryPowerMode();
        _e8AccessoryPowerMode = ::mplay_appcontrol_fi_types::T_e8_AccessoryPowerMode__e8DIPO_APM_INTERMITTENT_HIGH_POWER_MODE;
     }
}

inline bool DiPOPowerStatus::hasE8AccessoryPowerMode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::mplay_appcontrol_fi_types::T_e8_AccessoryPowerMode DiPOPowerStatus::getE8AccessoryPowerMode () const {
    return _e8AccessoryPowerMode;
}

inline void DiPOPowerStatus::setE8AccessoryPowerMode (::mplay_appcontrol_fi_types::T_e8_AccessoryPowerMode e8AccessoryPowerMode_) {
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_AccessoryPowerMode_IsValid(e8AccessoryPowerMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AccessoryPowerMode_, "T_e8_AccessoryPowerMode", "e8AccessoryPowerMode", "DiPOPowerStatus");
    }
    #endif
    set_has_e8AccessoryPowerMode();
    this->_e8AccessoryPowerMode = e8AccessoryPowerMode_;
}

inline void DiPOPowerStatus::clearU16MaximumCurrentDrawnFromAccessory() {
    if (hasU16MaximumCurrentDrawnFromAccessory()) {
         clear_has_u16MaximumCurrentDrawnFromAccessory();
        _u16MaximumCurrentDrawnFromAccessory = 0u;
     }
}

inline bool DiPOPowerStatus::hasU16MaximumCurrentDrawnFromAccessory () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 DiPOPowerStatus::getU16MaximumCurrentDrawnFromAccessory () const {
    return _u16MaximumCurrentDrawnFromAccessory;
}

inline void DiPOPowerStatus::setU16MaximumCurrentDrawnFromAccessory (uint16 u16MaximumCurrentDrawnFromAccessory_) {
    set_has_u16MaximumCurrentDrawnFromAccessory();
    this->_u16MaximumCurrentDrawnFromAccessory = u16MaximumCurrentDrawnFromAccessory_;
}

inline void DiPOPowerStatus::clearBDeviceBatteryWillChargeIfPowerIsPresent() {
    if (hasBDeviceBatteryWillChargeIfPowerIsPresent()) {
         clear_has_bDeviceBatteryWillChargeIfPowerIsPresent();
        _bDeviceBatteryWillChargeIfPowerIsPresent = false;
     }
}

inline bool DiPOPowerStatus::hasBDeviceBatteryWillChargeIfPowerIsPresent () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool DiPOPowerStatus::getBDeviceBatteryWillChargeIfPowerIsPresent () const {
    return _bDeviceBatteryWillChargeIfPowerIsPresent;
}

inline void DiPOPowerStatus::setBDeviceBatteryWillChargeIfPowerIsPresent (bool bDeviceBatteryWillChargeIfPowerIsPresent_) {
    set_has_bDeviceBatteryWillChargeIfPowerIsPresent();
    this->_bDeviceBatteryWillChargeIfPowerIsPresent = bDeviceBatteryWillChargeIfPowerIsPresent_;
}

inline void DiPOPowerStatus::clearE8BatteryChargingState() {
    if (hasE8BatteryChargingState()) {
         clear_has_e8BatteryChargingState();
        _e8BatteryChargingState = ::mplay_appcontrol_fi_types::T_e8_BatteryChargingState__e8DIPO_BCS_CHARGED;
     }
}

inline bool DiPOPowerStatus::hasE8BatteryChargingState () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline ::mplay_appcontrol_fi_types::T_e8_BatteryChargingState DiPOPowerStatus::getE8BatteryChargingState () const {
    return _e8BatteryChargingState;
}

inline void DiPOPowerStatus::setE8BatteryChargingState (::mplay_appcontrol_fi_types::T_e8_BatteryChargingState e8BatteryChargingState_) {
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_BatteryChargingState_IsValid(e8BatteryChargingState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8BatteryChargingState_, "T_e8_BatteryChargingState", "e8BatteryChargingState", "DiPOPowerStatus");
    }
    #endif
    set_has_e8BatteryChargingState();
    this->_e8BatteryChargingState = e8BatteryChargingState_;
}

inline void DiPOPowerStatus::clearBIsExternalChargerConnected() {
    if (hasBIsExternalChargerConnected()) {
         clear_has_bIsExternalChargerConnected();
        _bIsExternalChargerConnected = false;
     }
}

inline bool DiPOPowerStatus::hasBIsExternalChargerConnected () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool DiPOPowerStatus::getBIsExternalChargerConnected () const {
    return _bIsExternalChargerConnected;
}

inline void DiPOPowerStatus::setBIsExternalChargerConnected (bool bIsExternalChargerConnected_) {
    set_has_bIsExternalChargerConnected();
    this->_bIsExternalChargerConnected = bIsExternalChargerConnected_;
}

inline void DiPOPowerStatus::set_has_u8DeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPOPowerStatus::clear_has_u8DeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiPOPowerStatus::set_has_u16BatteryChargeLevel () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiPOPowerStatus::clear_has_u16BatteryChargeLevel () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DiPOPowerStatus::set_has_e8AccessoryPowerMode () {
    _has_bits_[0] |= 1u << 2;
}

inline void DiPOPowerStatus::clear_has_e8AccessoryPowerMode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DiPOPowerStatus::set_has_u16MaximumCurrentDrawnFromAccessory () {
    _has_bits_[0] |= 1u << 3;
}

inline void DiPOPowerStatus::clear_has_u16MaximumCurrentDrawnFromAccessory () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void DiPOPowerStatus::set_has_bDeviceBatteryWillChargeIfPowerIsPresent () {
    _has_bits_[0] |= 1u << 4;
}

inline void DiPOPowerStatus::clear_has_bDeviceBatteryWillChargeIfPowerIsPresent () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void DiPOPowerStatus::set_has_e8BatteryChargingState () {
    _has_bits_[0] |= 1u << 5;
}

inline void DiPOPowerStatus::clear_has_e8BatteryChargingState () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void DiPOPowerStatus::set_has_bIsExternalChargerConnected () {
    _has_bits_[0] |= 1u << 6;
}

inline void DiPOPowerStatus::clear_has_bIsExternalChargerConnected () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  DiPORouteGuidanceStatus::DiPORouteGuidanceStatus ()  :
    _sDeviceUSBSerialNumber (),
    _u16RouteGuidanceDisplayComponentID (0u),
    _e8RouteGuidanceState (::mplay_appcontrol_fi_types::T_e8_RouteGuidanceState__e8DIPO_ROUTE_GUIDANCE_STATE_NO_ROUTE_SET),
    _e8ManeuverState (::mplay_appcontrol_fi_types::T_e8_ManeuverState__e8DIPO_MANEUVER_STATE_CONTINUE),
    _szCurrentRoadName (),
    _szDestinationName (),
    _u64EstimatedTimeOfArrival (0u),
    _u64TimeRemainingToDestination (0u),
    _u32DistanceRemaining (0u),
    _szDistanceRemainingDisplayStr (),
    _e8DistanceRemainingDisplayUnits (::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_KM),
    _u32DistanceToNextManeuver (0u),
    _szDistanceToNextManeuverDisplayStr (),
    _e8DistanceToNextManeuverDisplayUnits (::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_KM),
    _u16RouteGuidanceManeuverCurrentList (),
    _u16RouteGuidanceManeuverCount (0u),
    _bIsRouteGuidanceVisibleInApp (false),
    _SourceName (),
    _SourceSupportsRouteGuidance (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPORouteGuidanceStatus::DiPORouteGuidanceStatus (const DiPORouteGuidanceStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _sDeviceUSBSerialNumber (),
    _u16RouteGuidanceDisplayComponentID (0u),
    _e8RouteGuidanceState (::mplay_appcontrol_fi_types::T_e8_RouteGuidanceState__e8DIPO_ROUTE_GUIDANCE_STATE_NO_ROUTE_SET),
    _e8ManeuverState (::mplay_appcontrol_fi_types::T_e8_ManeuverState__e8DIPO_MANEUVER_STATE_CONTINUE),
    _szCurrentRoadName (),
    _szDestinationName (),
    _u64EstimatedTimeOfArrival (0u),
    _u64TimeRemainingToDestination (0u),
    _u32DistanceRemaining (0u),
    _szDistanceRemainingDisplayStr (),
    _e8DistanceRemainingDisplayUnits (::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_KM),
    _u32DistanceToNextManeuver (0u),
    _szDistanceToNextManeuverDisplayStr (),
    _e8DistanceToNextManeuverDisplayUnits (::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_KM),
    _u16RouteGuidanceManeuverCurrentList (),
    _u16RouteGuidanceManeuverCount (0u),
    _bIsRouteGuidanceVisibleInApp (false),
    _SourceName (),
    _SourceSupportsRouteGuidance (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPORouteGuidanceStatus::DiPORouteGuidanceStatus (const ::std::string& sDeviceUSBSerialNumber_, uint16 u16RouteGuidanceDisplayComponentID_, ::mplay_appcontrol_fi_types::T_e8_RouteGuidanceState e8RouteGuidanceState_, ::mplay_appcontrol_fi_types::T_e8_ManeuverState e8ManeuverState_, const ::std::string& szCurrentRoadName_, const ::std::string& szDestinationName_, uint64 u64EstimatedTimeOfArrival_, uint64 u64TimeRemainingToDestination_, uint32 u32DistanceRemaining_, const ::std::string& szDistanceRemainingDisplayStr_, ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits e8DistanceRemainingDisplayUnits_, uint32 u32DistanceToNextManeuver_, const ::std::string& szDistanceToNextManeuverDisplayStr_, ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits e8DistanceToNextManeuverDisplayUnits_, const ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverCurrentList& u16RouteGuidanceManeuverCurrentList_, uint16 u16RouteGuidanceManeuverCount_, bool bIsRouteGuidanceVisibleInApp_, const ::std::string& SourceName_, bool SourceSupportsRouteGuidance_)  :
    _sDeviceUSBSerialNumber (sDeviceUSBSerialNumber_),
    _u16RouteGuidanceDisplayComponentID (u16RouteGuidanceDisplayComponentID_),
    _e8RouteGuidanceState (e8RouteGuidanceState_),
    _e8ManeuverState (e8ManeuverState_),
    _szCurrentRoadName (szCurrentRoadName_),
    _szDestinationName (szDestinationName_),
    _u64EstimatedTimeOfArrival (u64EstimatedTimeOfArrival_),
    _u64TimeRemainingToDestination (u64TimeRemainingToDestination_),
    _u32DistanceRemaining (u32DistanceRemaining_),
    _szDistanceRemainingDisplayStr (szDistanceRemainingDisplayStr_),
    _e8DistanceRemainingDisplayUnits (e8DistanceRemainingDisplayUnits_),
    _u32DistanceToNextManeuver (u32DistanceToNextManeuver_),
    _szDistanceToNextManeuverDisplayStr (szDistanceToNextManeuverDisplayStr_),
    _e8DistanceToNextManeuverDisplayUnits (e8DistanceToNextManeuverDisplayUnits_),
    _u16RouteGuidanceManeuverCurrentList (u16RouteGuidanceManeuverCurrentList_),
    _u16RouteGuidanceManeuverCount (u16RouteGuidanceManeuverCount_),
    _bIsRouteGuidanceVisibleInApp (bIsRouteGuidanceVisibleInApp_),
    _SourceName (SourceName_),
    _SourceSupportsRouteGuidance (SourceSupportsRouteGuidance_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_RouteGuidanceState_IsValid(e8RouteGuidanceState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8RouteGuidanceState_, "T_e8_RouteGuidanceState", "e8RouteGuidanceState", "DiPORouteGuidanceStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_ManeuverState_IsValid(e8ManeuverState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ManeuverState_, "T_e8_ManeuverState", "e8ManeuverState", "DiPORouteGuidanceStatus");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szCurrentRoadName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDestinationName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDistanceRemainingDisplayStr_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits_IsValid(e8DistanceRemainingDisplayUnits_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DistanceRemainingDisplayUnits_, "T_e8_DistanceDisplayUnits", "e8DistanceRemainingDisplayUnits", "DiPORouteGuidanceStatus");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDistanceToNextManeuverDisplayStr_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits_IsValid(e8DistanceToNextManeuverDisplayUnits_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DistanceToNextManeuverDisplayUnits_, "T_e8_DistanceDisplayUnits", "e8DistanceToNextManeuverDisplayUnits", "DiPORouteGuidanceStatus");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SourceName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPORouteGuidanceStatus::~DiPORouteGuidanceStatus() {
}

inline DiPORouteGuidanceStatus& DiPORouteGuidanceStatus::operator = (const DiPORouteGuidanceStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSDeviceUSBSerialNumber()) {
            setSDeviceUSBSerialNumber(rhs.getSDeviceUSBSerialNumber());
        } else {
            clearSDeviceUSBSerialNumber();
        }
        if (rhs.hasU16RouteGuidanceDisplayComponentID()) {
            setU16RouteGuidanceDisplayComponentID(rhs.getU16RouteGuidanceDisplayComponentID());
        } else {
            clearU16RouteGuidanceDisplayComponentID();
        }
        if (rhs.hasE8RouteGuidanceState()) {
            setE8RouteGuidanceState(rhs.getE8RouteGuidanceState());
        } else {
            clearE8RouteGuidanceState();
        }
        if (rhs.hasE8ManeuverState()) {
            setE8ManeuverState(rhs.getE8ManeuverState());
        } else {
            clearE8ManeuverState();
        }
        if (rhs.hasSzCurrentRoadName()) {
            setSzCurrentRoadName(rhs.getSzCurrentRoadName());
        } else {
            clearSzCurrentRoadName();
        }
        if (rhs.hasSzDestinationName()) {
            setSzDestinationName(rhs.getSzDestinationName());
        } else {
            clearSzDestinationName();
        }
        if (rhs.hasU64EstimatedTimeOfArrival()) {
            setU64EstimatedTimeOfArrival(rhs.getU64EstimatedTimeOfArrival());
        } else {
            clearU64EstimatedTimeOfArrival();
        }
        if (rhs.hasU64TimeRemainingToDestination()) {
            setU64TimeRemainingToDestination(rhs.getU64TimeRemainingToDestination());
        } else {
            clearU64TimeRemainingToDestination();
        }
        if (rhs.hasU32DistanceRemaining()) {
            setU32DistanceRemaining(rhs.getU32DistanceRemaining());
        } else {
            clearU32DistanceRemaining();
        }
        if (rhs.hasSzDistanceRemainingDisplayStr()) {
            setSzDistanceRemainingDisplayStr(rhs.getSzDistanceRemainingDisplayStr());
        } else {
            clearSzDistanceRemainingDisplayStr();
        }
        if (rhs.hasE8DistanceRemainingDisplayUnits()) {
            setE8DistanceRemainingDisplayUnits(rhs.getE8DistanceRemainingDisplayUnits());
        } else {
            clearE8DistanceRemainingDisplayUnits();
        }
        if (rhs.hasU32DistanceToNextManeuver()) {
            setU32DistanceToNextManeuver(rhs.getU32DistanceToNextManeuver());
        } else {
            clearU32DistanceToNextManeuver();
        }
        if (rhs.hasSzDistanceToNextManeuverDisplayStr()) {
            setSzDistanceToNextManeuverDisplayStr(rhs.getSzDistanceToNextManeuverDisplayStr());
        } else {
            clearSzDistanceToNextManeuverDisplayStr();
        }
        if (rhs.hasE8DistanceToNextManeuverDisplayUnits()) {
            setE8DistanceToNextManeuverDisplayUnits(rhs.getE8DistanceToNextManeuverDisplayUnits());
        } else {
            clearE8DistanceToNextManeuverDisplayUnits();
        }
        if (rhs.hasU16RouteGuidanceManeuverCurrentList()) {
            setU16RouteGuidanceManeuverCurrentList(rhs.getU16RouteGuidanceManeuverCurrentList());
        } else {
            clearU16RouteGuidanceManeuverCurrentList();
        }
        if (rhs.hasU16RouteGuidanceManeuverCount()) {
            setU16RouteGuidanceManeuverCount(rhs.getU16RouteGuidanceManeuverCount());
        } else {
            clearU16RouteGuidanceManeuverCount();
        }
        if (rhs.hasBIsRouteGuidanceVisibleInApp()) {
            setBIsRouteGuidanceVisibleInApp(rhs.getBIsRouteGuidanceVisibleInApp());
        } else {
            clearBIsRouteGuidanceVisibleInApp();
        }
        if (rhs.hasSourceName()) {
            setSourceName(rhs.getSourceName());
        } else {
            clearSourceName();
        }
        if (rhs.hasSourceSupportsRouteGuidance()) {
            setSourceSupportsRouteGuidance(rhs.getSourceSupportsRouteGuidance());
        } else {
            clearSourceSupportsRouteGuidance();
        }
    }
    return *this;
}

inline bool DiPORouteGuidanceStatus::operator == (const DiPORouteGuidanceStatus& rhs) const {
    return (((!hasSDeviceUSBSerialNumber() && !rhs.hasSDeviceUSBSerialNumber()) || getSDeviceUSBSerialNumber() == rhs.getSDeviceUSBSerialNumber()) &&
        ((!hasU16RouteGuidanceDisplayComponentID() && !rhs.hasU16RouteGuidanceDisplayComponentID()) || getU16RouteGuidanceDisplayComponentID() == rhs.getU16RouteGuidanceDisplayComponentID()) &&
        ((!hasE8RouteGuidanceState() && !rhs.hasE8RouteGuidanceState()) || getE8RouteGuidanceState() == rhs.getE8RouteGuidanceState()) &&
        ((!hasE8ManeuverState() && !rhs.hasE8ManeuverState()) || getE8ManeuverState() == rhs.getE8ManeuverState()) &&
        ((!hasSzCurrentRoadName() && !rhs.hasSzCurrentRoadName()) || getSzCurrentRoadName() == rhs.getSzCurrentRoadName()) &&
        ((!hasSzDestinationName() && !rhs.hasSzDestinationName()) || getSzDestinationName() == rhs.getSzDestinationName()) &&
        ((!hasU64EstimatedTimeOfArrival() && !rhs.hasU64EstimatedTimeOfArrival()) || getU64EstimatedTimeOfArrival() == rhs.getU64EstimatedTimeOfArrival()) &&
        ((!hasU64TimeRemainingToDestination() && !rhs.hasU64TimeRemainingToDestination()) || getU64TimeRemainingToDestination() == rhs.getU64TimeRemainingToDestination()) &&
        ((!hasU32DistanceRemaining() && !rhs.hasU32DistanceRemaining()) || getU32DistanceRemaining() == rhs.getU32DistanceRemaining()) &&
        ((!hasSzDistanceRemainingDisplayStr() && !rhs.hasSzDistanceRemainingDisplayStr()) || getSzDistanceRemainingDisplayStr() == rhs.getSzDistanceRemainingDisplayStr()) &&
        ((!hasE8DistanceRemainingDisplayUnits() && !rhs.hasE8DistanceRemainingDisplayUnits()) || getE8DistanceRemainingDisplayUnits() == rhs.getE8DistanceRemainingDisplayUnits()) &&
        ((!hasU32DistanceToNextManeuver() && !rhs.hasU32DistanceToNextManeuver()) || getU32DistanceToNextManeuver() == rhs.getU32DistanceToNextManeuver()) &&
        ((!hasSzDistanceToNextManeuverDisplayStr() && !rhs.hasSzDistanceToNextManeuverDisplayStr()) || getSzDistanceToNextManeuverDisplayStr() == rhs.getSzDistanceToNextManeuverDisplayStr()) &&
        ((!hasE8DistanceToNextManeuverDisplayUnits() && !rhs.hasE8DistanceToNextManeuverDisplayUnits()) || getE8DistanceToNextManeuverDisplayUnits() == rhs.getE8DistanceToNextManeuverDisplayUnits()) &&
        ((!hasU16RouteGuidanceManeuverCurrentList() && !rhs.hasU16RouteGuidanceManeuverCurrentList()) || getU16RouteGuidanceManeuverCurrentList() == rhs.getU16RouteGuidanceManeuverCurrentList()) &&
        ((!hasU16RouteGuidanceManeuverCount() && !rhs.hasU16RouteGuidanceManeuverCount()) || getU16RouteGuidanceManeuverCount() == rhs.getU16RouteGuidanceManeuverCount()) &&
        ((!hasBIsRouteGuidanceVisibleInApp() && !rhs.hasBIsRouteGuidanceVisibleInApp()) || getBIsRouteGuidanceVisibleInApp() == rhs.getBIsRouteGuidanceVisibleInApp()) &&
        ((!hasSourceName() && !rhs.hasSourceName()) || getSourceName() == rhs.getSourceName()) &&
        ((!hasSourceSupportsRouteGuidance() && !rhs.hasSourceSupportsRouteGuidance()) || getSourceSupportsRouteGuidance() == rhs.getSourceSupportsRouteGuidance()));
}

inline bool DiPORouteGuidanceStatus::operator != (const DiPORouteGuidanceStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPORouteGuidanceStatus::operator < (const DiPORouteGuidanceStatus& rhs) const {
    if (hasSDeviceUSBSerialNumber() || rhs.hasSDeviceUSBSerialNumber()) {
        if (getSDeviceUSBSerialNumber() < rhs.getSDeviceUSBSerialNumber()) return true;
        if (getSDeviceUSBSerialNumber() > rhs.getSDeviceUSBSerialNumber()) return false;
    }
    if (hasU16RouteGuidanceDisplayComponentID() || rhs.hasU16RouteGuidanceDisplayComponentID()) {
        if (getU16RouteGuidanceDisplayComponentID() < rhs.getU16RouteGuidanceDisplayComponentID()) return true;
        if (getU16RouteGuidanceDisplayComponentID() > rhs.getU16RouteGuidanceDisplayComponentID()) return false;
    }
    if (hasE8RouteGuidanceState() || rhs.hasE8RouteGuidanceState()) {
        if ((uint32)getE8RouteGuidanceState() < (uint32)rhs.getE8RouteGuidanceState()) return true;
        if ((uint32)getE8RouteGuidanceState() > (uint32)rhs.getE8RouteGuidanceState()) return false;
    }
    if (hasE8ManeuverState() || rhs.hasE8ManeuverState()) {
        if ((uint32)getE8ManeuverState() < (uint32)rhs.getE8ManeuverState()) return true;
        if ((uint32)getE8ManeuverState() > (uint32)rhs.getE8ManeuverState()) return false;
    }
    if (hasSzCurrentRoadName() || rhs.hasSzCurrentRoadName()) {
        if (getSzCurrentRoadName() < rhs.getSzCurrentRoadName()) return true;
        if (getSzCurrentRoadName() > rhs.getSzCurrentRoadName()) return false;
    }
    if (hasSzDestinationName() || rhs.hasSzDestinationName()) {
        if (getSzDestinationName() < rhs.getSzDestinationName()) return true;
        if (getSzDestinationName() > rhs.getSzDestinationName()) return false;
    }
    if (hasU64EstimatedTimeOfArrival() || rhs.hasU64EstimatedTimeOfArrival()) {
        if (getU64EstimatedTimeOfArrival() < rhs.getU64EstimatedTimeOfArrival()) return true;
        if (getU64EstimatedTimeOfArrival() > rhs.getU64EstimatedTimeOfArrival()) return false;
    }
    if (hasU64TimeRemainingToDestination() || rhs.hasU64TimeRemainingToDestination()) {
        if (getU64TimeRemainingToDestination() < rhs.getU64TimeRemainingToDestination()) return true;
        if (getU64TimeRemainingToDestination() > rhs.getU64TimeRemainingToDestination()) return false;
    }
    if (hasU32DistanceRemaining() || rhs.hasU32DistanceRemaining()) {
        if (getU32DistanceRemaining() < rhs.getU32DistanceRemaining()) return true;
        if (getU32DistanceRemaining() > rhs.getU32DistanceRemaining()) return false;
    }
    if (hasSzDistanceRemainingDisplayStr() || rhs.hasSzDistanceRemainingDisplayStr()) {
        if (getSzDistanceRemainingDisplayStr() < rhs.getSzDistanceRemainingDisplayStr()) return true;
        if (getSzDistanceRemainingDisplayStr() > rhs.getSzDistanceRemainingDisplayStr()) return false;
    }
    if (hasE8DistanceRemainingDisplayUnits() || rhs.hasE8DistanceRemainingDisplayUnits()) {
        if ((uint32)getE8DistanceRemainingDisplayUnits() < (uint32)rhs.getE8DistanceRemainingDisplayUnits()) return true;
        if ((uint32)getE8DistanceRemainingDisplayUnits() > (uint32)rhs.getE8DistanceRemainingDisplayUnits()) return false;
    }
    if (hasU32DistanceToNextManeuver() || rhs.hasU32DistanceToNextManeuver()) {
        if (getU32DistanceToNextManeuver() < rhs.getU32DistanceToNextManeuver()) return true;
        if (getU32DistanceToNextManeuver() > rhs.getU32DistanceToNextManeuver()) return false;
    }
    if (hasSzDistanceToNextManeuverDisplayStr() || rhs.hasSzDistanceToNextManeuverDisplayStr()) {
        if (getSzDistanceToNextManeuverDisplayStr() < rhs.getSzDistanceToNextManeuverDisplayStr()) return true;
        if (getSzDistanceToNextManeuverDisplayStr() > rhs.getSzDistanceToNextManeuverDisplayStr()) return false;
    }
    if (hasE8DistanceToNextManeuverDisplayUnits() || rhs.hasE8DistanceToNextManeuverDisplayUnits()) {
        if ((uint32)getE8DistanceToNextManeuverDisplayUnits() < (uint32)rhs.getE8DistanceToNextManeuverDisplayUnits()) return true;
        if ((uint32)getE8DistanceToNextManeuverDisplayUnits() > (uint32)rhs.getE8DistanceToNextManeuverDisplayUnits()) return false;
    }
    if (hasU16RouteGuidanceManeuverCurrentList() || rhs.hasU16RouteGuidanceManeuverCurrentList()) {
        if (getU16RouteGuidanceManeuverCurrentList() < rhs.getU16RouteGuidanceManeuverCurrentList()) return true;
        if (getU16RouteGuidanceManeuverCurrentList() > rhs.getU16RouteGuidanceManeuverCurrentList()) return false;
    }
    if (hasU16RouteGuidanceManeuverCount() || rhs.hasU16RouteGuidanceManeuverCount()) {
        if (getU16RouteGuidanceManeuverCount() < rhs.getU16RouteGuidanceManeuverCount()) return true;
        if (getU16RouteGuidanceManeuverCount() > rhs.getU16RouteGuidanceManeuverCount()) return false;
    }
    if (hasBIsRouteGuidanceVisibleInApp() || rhs.hasBIsRouteGuidanceVisibleInApp()) {
        if (getBIsRouteGuidanceVisibleInApp() < rhs.getBIsRouteGuidanceVisibleInApp()) return true;
        if (getBIsRouteGuidanceVisibleInApp() > rhs.getBIsRouteGuidanceVisibleInApp()) return false;
    }
    if (hasSourceName() || rhs.hasSourceName()) {
        if (getSourceName() < rhs.getSourceName()) return true;
        if (getSourceName() > rhs.getSourceName()) return false;
    }
    if (hasSourceSupportsRouteGuidance() || rhs.hasSourceSupportsRouteGuidance()) {
        if (getSourceSupportsRouteGuidance() < rhs.getSourceSupportsRouteGuidance()) return true;
        if (getSourceSupportsRouteGuidance() > rhs.getSourceSupportsRouteGuidance()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPORouteGuidanceStatus::clone() {
    return new DiPORouteGuidanceStatus(*this);
}

inline bool DiPORouteGuidanceStatus::operator > (const DiPORouteGuidanceStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPORouteGuidanceStatus::clear() {
    clearSDeviceUSBSerialNumber();
    clearU16RouteGuidanceDisplayComponentID();
    clearE8RouteGuidanceState();
    clearE8ManeuverState();
    clearSzCurrentRoadName();
    clearSzDestinationName();
    clearU64EstimatedTimeOfArrival();
    clearU64TimeRemainingToDestination();
    clearU32DistanceRemaining();
    clearSzDistanceRemainingDisplayStr();
    clearE8DistanceRemainingDisplayUnits();
    clearU32DistanceToNextManeuver();
    clearSzDistanceToNextManeuverDisplayStr();
    clearE8DistanceToNextManeuverDisplayUnits();
    clearU16RouteGuidanceManeuverCurrentList();
    clearU16RouteGuidanceManeuverCount();
    clearBIsRouteGuidanceVisibleInApp();
    clearSourceName();
    clearSourceSupportsRouteGuidance();
}

inline void DiPORouteGuidanceStatus::clearSDeviceUSBSerialNumber() {
    if (hasSDeviceUSBSerialNumber()) {
         clear_has_sDeviceUSBSerialNumber();
        _sDeviceUSBSerialNumber.clear();
     }
}

inline bool DiPORouteGuidanceStatus::hasSDeviceUSBSerialNumber () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DiPORouteGuidanceStatus::getSDeviceUSBSerialNumber () const {
    return _sDeviceUSBSerialNumber;
}

inline ::std::string& DiPORouteGuidanceStatus::getSDeviceUSBSerialNumberMutable () {
    set_has_sDeviceUSBSerialNumber();
    return _sDeviceUSBSerialNumber;
}

inline void DiPORouteGuidanceStatus::setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber = sDeviceUSBSerialNumber_;
}

inline void DiPORouteGuidanceStatus::setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber.assign(sDeviceUSBSerialNumber_);
}

inline void DiPORouteGuidanceStatus::setSDeviceUSBSerialNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber.assign(value, size);
}

inline void DiPORouteGuidanceStatus::clearU16RouteGuidanceDisplayComponentID() {
    if (hasU16RouteGuidanceDisplayComponentID()) {
         clear_has_u16RouteGuidanceDisplayComponentID();
        _u16RouteGuidanceDisplayComponentID = 0u;
     }
}

inline bool DiPORouteGuidanceStatus::hasU16RouteGuidanceDisplayComponentID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 DiPORouteGuidanceStatus::getU16RouteGuidanceDisplayComponentID () const {
    return _u16RouteGuidanceDisplayComponentID;
}

inline void DiPORouteGuidanceStatus::setU16RouteGuidanceDisplayComponentID (uint16 u16RouteGuidanceDisplayComponentID_) {
    set_has_u16RouteGuidanceDisplayComponentID();
    this->_u16RouteGuidanceDisplayComponentID = u16RouteGuidanceDisplayComponentID_;
}

inline void DiPORouteGuidanceStatus::clearE8RouteGuidanceState() {
    if (hasE8RouteGuidanceState()) {
         clear_has_e8RouteGuidanceState();
        _e8RouteGuidanceState = ::mplay_appcontrol_fi_types::T_e8_RouteGuidanceState__e8DIPO_ROUTE_GUIDANCE_STATE_NO_ROUTE_SET;
     }
}

inline bool DiPORouteGuidanceStatus::hasE8RouteGuidanceState () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::mplay_appcontrol_fi_types::T_e8_RouteGuidanceState DiPORouteGuidanceStatus::getE8RouteGuidanceState () const {
    return _e8RouteGuidanceState;
}

inline void DiPORouteGuidanceStatus::setE8RouteGuidanceState (::mplay_appcontrol_fi_types::T_e8_RouteGuidanceState e8RouteGuidanceState_) {
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_RouteGuidanceState_IsValid(e8RouteGuidanceState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8RouteGuidanceState_, "T_e8_RouteGuidanceState", "e8RouteGuidanceState", "DiPORouteGuidanceStatus");
    }
    #endif
    set_has_e8RouteGuidanceState();
    this->_e8RouteGuidanceState = e8RouteGuidanceState_;
}

inline void DiPORouteGuidanceStatus::clearE8ManeuverState() {
    if (hasE8ManeuverState()) {
         clear_has_e8ManeuverState();
        _e8ManeuverState = ::mplay_appcontrol_fi_types::T_e8_ManeuverState__e8DIPO_MANEUVER_STATE_CONTINUE;
     }
}

inline bool DiPORouteGuidanceStatus::hasE8ManeuverState () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline ::mplay_appcontrol_fi_types::T_e8_ManeuverState DiPORouteGuidanceStatus::getE8ManeuverState () const {
    return _e8ManeuverState;
}

inline void DiPORouteGuidanceStatus::setE8ManeuverState (::mplay_appcontrol_fi_types::T_e8_ManeuverState e8ManeuverState_) {
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_ManeuverState_IsValid(e8ManeuverState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ManeuverState_, "T_e8_ManeuverState", "e8ManeuverState", "DiPORouteGuidanceStatus");
    }
    #endif
    set_has_e8ManeuverState();
    this->_e8ManeuverState = e8ManeuverState_;
}

inline void DiPORouteGuidanceStatus::clearSzCurrentRoadName() {
    if (hasSzCurrentRoadName()) {
         clear_has_szCurrentRoadName();
        _szCurrentRoadName.clear();
     }
}

inline bool DiPORouteGuidanceStatus::hasSzCurrentRoadName () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& DiPORouteGuidanceStatus::getSzCurrentRoadName () const {
    return _szCurrentRoadName;
}

inline ::std::string& DiPORouteGuidanceStatus::getSzCurrentRoadNameMutable () {
    set_has_szCurrentRoadName();
    return _szCurrentRoadName;
}

inline void DiPORouteGuidanceStatus::setSzCurrentRoadName (const ::std::string& szCurrentRoadName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szCurrentRoadName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szCurrentRoadName();
    this->_szCurrentRoadName = szCurrentRoadName_;
}

inline void DiPORouteGuidanceStatus::setSzCurrentRoadName (const char* szCurrentRoadName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szCurrentRoadName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szCurrentRoadName();
    this->_szCurrentRoadName.assign(szCurrentRoadName_);
}

inline void DiPORouteGuidanceStatus::setSzCurrentRoadName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szCurrentRoadName();
    this->_szCurrentRoadName.assign(value, size);
}

inline void DiPORouteGuidanceStatus::clearSzDestinationName() {
    if (hasSzDestinationName()) {
         clear_has_szDestinationName();
        _szDestinationName.clear();
     }
}

inline bool DiPORouteGuidanceStatus::hasSzDestinationName () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& DiPORouteGuidanceStatus::getSzDestinationName () const {
    return _szDestinationName;
}

inline ::std::string& DiPORouteGuidanceStatus::getSzDestinationNameMutable () {
    set_has_szDestinationName();
    return _szDestinationName;
}

inline void DiPORouteGuidanceStatus::setSzDestinationName (const ::std::string& szDestinationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDestinationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDestinationName();
    this->_szDestinationName = szDestinationName_;
}

inline void DiPORouteGuidanceStatus::setSzDestinationName (const char* szDestinationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDestinationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDestinationName();
    this->_szDestinationName.assign(szDestinationName_);
}

inline void DiPORouteGuidanceStatus::setSzDestinationName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDestinationName();
    this->_szDestinationName.assign(value, size);
}

inline void DiPORouteGuidanceStatus::clearU64EstimatedTimeOfArrival() {
    if (hasU64EstimatedTimeOfArrival()) {
         clear_has_u64EstimatedTimeOfArrival();
        _u64EstimatedTimeOfArrival = 0u;
     }
}

inline bool DiPORouteGuidanceStatus::hasU64EstimatedTimeOfArrival () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint64 DiPORouteGuidanceStatus::getU64EstimatedTimeOfArrival () const {
    return _u64EstimatedTimeOfArrival;
}

inline void DiPORouteGuidanceStatus::setU64EstimatedTimeOfArrival (uint64 u64EstimatedTimeOfArrival_) {
    set_has_u64EstimatedTimeOfArrival();
    this->_u64EstimatedTimeOfArrival = u64EstimatedTimeOfArrival_;
}

inline void DiPORouteGuidanceStatus::clearU64TimeRemainingToDestination() {
    if (hasU64TimeRemainingToDestination()) {
         clear_has_u64TimeRemainingToDestination();
        _u64TimeRemainingToDestination = 0u;
     }
}

inline bool DiPORouteGuidanceStatus::hasU64TimeRemainingToDestination () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint64 DiPORouteGuidanceStatus::getU64TimeRemainingToDestination () const {
    return _u64TimeRemainingToDestination;
}

inline void DiPORouteGuidanceStatus::setU64TimeRemainingToDestination (uint64 u64TimeRemainingToDestination_) {
    set_has_u64TimeRemainingToDestination();
    this->_u64TimeRemainingToDestination = u64TimeRemainingToDestination_;
}

inline void DiPORouteGuidanceStatus::clearU32DistanceRemaining() {
    if (hasU32DistanceRemaining()) {
         clear_has_u32DistanceRemaining();
        _u32DistanceRemaining = 0u;
     }
}

inline bool DiPORouteGuidanceStatus::hasU32DistanceRemaining () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint32 DiPORouteGuidanceStatus::getU32DistanceRemaining () const {
    return _u32DistanceRemaining;
}

inline void DiPORouteGuidanceStatus::setU32DistanceRemaining (uint32 u32DistanceRemaining_) {
    set_has_u32DistanceRemaining();
    this->_u32DistanceRemaining = u32DistanceRemaining_;
}

inline void DiPORouteGuidanceStatus::clearSzDistanceRemainingDisplayStr() {
    if (hasSzDistanceRemainingDisplayStr()) {
         clear_has_szDistanceRemainingDisplayStr();
        _szDistanceRemainingDisplayStr.clear();
     }
}

inline bool DiPORouteGuidanceStatus::hasSzDistanceRemainingDisplayStr () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::std::string& DiPORouteGuidanceStatus::getSzDistanceRemainingDisplayStr () const {
    return _szDistanceRemainingDisplayStr;
}

inline ::std::string& DiPORouteGuidanceStatus::getSzDistanceRemainingDisplayStrMutable () {
    set_has_szDistanceRemainingDisplayStr();
    return _szDistanceRemainingDisplayStr;
}

inline void DiPORouteGuidanceStatus::setSzDistanceRemainingDisplayStr (const ::std::string& szDistanceRemainingDisplayStr_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDistanceRemainingDisplayStr_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDistanceRemainingDisplayStr();
    this->_szDistanceRemainingDisplayStr = szDistanceRemainingDisplayStr_;
}

inline void DiPORouteGuidanceStatus::setSzDistanceRemainingDisplayStr (const char* szDistanceRemainingDisplayStr_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDistanceRemainingDisplayStr_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDistanceRemainingDisplayStr();
    this->_szDistanceRemainingDisplayStr.assign(szDistanceRemainingDisplayStr_);
}

inline void DiPORouteGuidanceStatus::setSzDistanceRemainingDisplayStr (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDistanceRemainingDisplayStr();
    this->_szDistanceRemainingDisplayStr.assign(value, size);
}

inline void DiPORouteGuidanceStatus::clearE8DistanceRemainingDisplayUnits() {
    if (hasE8DistanceRemainingDisplayUnits()) {
         clear_has_e8DistanceRemainingDisplayUnits();
        _e8DistanceRemainingDisplayUnits = ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_KM;
     }
}

inline bool DiPORouteGuidanceStatus::hasE8DistanceRemainingDisplayUnits () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits DiPORouteGuidanceStatus::getE8DistanceRemainingDisplayUnits () const {
    return _e8DistanceRemainingDisplayUnits;
}

inline void DiPORouteGuidanceStatus::setE8DistanceRemainingDisplayUnits (::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits e8DistanceRemainingDisplayUnits_) {
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits_IsValid(e8DistanceRemainingDisplayUnits_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DistanceRemainingDisplayUnits_, "T_e8_DistanceDisplayUnits", "e8DistanceRemainingDisplayUnits", "DiPORouteGuidanceStatus");
    }
    #endif
    set_has_e8DistanceRemainingDisplayUnits();
    this->_e8DistanceRemainingDisplayUnits = e8DistanceRemainingDisplayUnits_;
}

inline void DiPORouteGuidanceStatus::clearU32DistanceToNextManeuver() {
    if (hasU32DistanceToNextManeuver()) {
         clear_has_u32DistanceToNextManeuver();
        _u32DistanceToNextManeuver = 0u;
     }
}

inline bool DiPORouteGuidanceStatus::hasU32DistanceToNextManeuver () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline uint32 DiPORouteGuidanceStatus::getU32DistanceToNextManeuver () const {
    return _u32DistanceToNextManeuver;
}

inline void DiPORouteGuidanceStatus::setU32DistanceToNextManeuver (uint32 u32DistanceToNextManeuver_) {
    set_has_u32DistanceToNextManeuver();
    this->_u32DistanceToNextManeuver = u32DistanceToNextManeuver_;
}

inline void DiPORouteGuidanceStatus::clearSzDistanceToNextManeuverDisplayStr() {
    if (hasSzDistanceToNextManeuverDisplayStr()) {
         clear_has_szDistanceToNextManeuverDisplayStr();
        _szDistanceToNextManeuverDisplayStr.clear();
     }
}

inline bool DiPORouteGuidanceStatus::hasSzDistanceToNextManeuverDisplayStr () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline const ::std::string& DiPORouteGuidanceStatus::getSzDistanceToNextManeuverDisplayStr () const {
    return _szDistanceToNextManeuverDisplayStr;
}

inline ::std::string& DiPORouteGuidanceStatus::getSzDistanceToNextManeuverDisplayStrMutable () {
    set_has_szDistanceToNextManeuverDisplayStr();
    return _szDistanceToNextManeuverDisplayStr;
}

inline void DiPORouteGuidanceStatus::setSzDistanceToNextManeuverDisplayStr (const ::std::string& szDistanceToNextManeuverDisplayStr_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDistanceToNextManeuverDisplayStr_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDistanceToNextManeuverDisplayStr();
    this->_szDistanceToNextManeuverDisplayStr = szDistanceToNextManeuverDisplayStr_;
}

inline void DiPORouteGuidanceStatus::setSzDistanceToNextManeuverDisplayStr (const char* szDistanceToNextManeuverDisplayStr_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDistanceToNextManeuverDisplayStr_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDistanceToNextManeuverDisplayStr();
    this->_szDistanceToNextManeuverDisplayStr.assign(szDistanceToNextManeuverDisplayStr_);
}

inline void DiPORouteGuidanceStatus::setSzDistanceToNextManeuverDisplayStr (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDistanceToNextManeuverDisplayStr();
    this->_szDistanceToNextManeuverDisplayStr.assign(value, size);
}

inline void DiPORouteGuidanceStatus::clearE8DistanceToNextManeuverDisplayUnits() {
    if (hasE8DistanceToNextManeuverDisplayUnits()) {
         clear_has_e8DistanceToNextManeuverDisplayUnits();
        _e8DistanceToNextManeuverDisplayUnits = ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_KM;
     }
}

inline bool DiPORouteGuidanceStatus::hasE8DistanceToNextManeuverDisplayUnits () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits DiPORouteGuidanceStatus::getE8DistanceToNextManeuverDisplayUnits () const {
    return _e8DistanceToNextManeuverDisplayUnits;
}

inline void DiPORouteGuidanceStatus::setE8DistanceToNextManeuverDisplayUnits (::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits e8DistanceToNextManeuverDisplayUnits_) {
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits_IsValid(e8DistanceToNextManeuverDisplayUnits_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DistanceToNextManeuverDisplayUnits_, "T_e8_DistanceDisplayUnits", "e8DistanceToNextManeuverDisplayUnits", "DiPORouteGuidanceStatus");
    }
    #endif
    set_has_e8DistanceToNextManeuverDisplayUnits();
    this->_e8DistanceToNextManeuverDisplayUnits = e8DistanceToNextManeuverDisplayUnits_;
}

inline void DiPORouteGuidanceStatus::clearU16RouteGuidanceManeuverCurrentList() {
    if (hasU16RouteGuidanceManeuverCurrentList()) {
         clear_has_u16RouteGuidanceManeuverCurrentList();
        _u16RouteGuidanceManeuverCurrentList.clear();
     }
}

inline bool DiPORouteGuidanceStatus::hasU16RouteGuidanceManeuverCurrentList () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline const ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverCurrentList& DiPORouteGuidanceStatus::getU16RouteGuidanceManeuverCurrentList () const {
    return _u16RouteGuidanceManeuverCurrentList;
}

inline ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverCurrentList& DiPORouteGuidanceStatus::getU16RouteGuidanceManeuverCurrentListMutable () {
    set_has_u16RouteGuidanceManeuverCurrentList();
    return _u16RouteGuidanceManeuverCurrentList;
}

inline void DiPORouteGuidanceStatus::setU16RouteGuidanceManeuverCurrentList (const ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverCurrentList& u16RouteGuidanceManeuverCurrentList_) {
    set_has_u16RouteGuidanceManeuverCurrentList();
    this->_u16RouteGuidanceManeuverCurrentList = u16RouteGuidanceManeuverCurrentList_;
}

inline void DiPORouteGuidanceStatus::clearU16RouteGuidanceManeuverCount() {
    if (hasU16RouteGuidanceManeuverCount()) {
         clear_has_u16RouteGuidanceManeuverCount();
        _u16RouteGuidanceManeuverCount = 0u;
     }
}

inline bool DiPORouteGuidanceStatus::hasU16RouteGuidanceManeuverCount () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline uint16 DiPORouteGuidanceStatus::getU16RouteGuidanceManeuverCount () const {
    return _u16RouteGuidanceManeuverCount;
}

inline void DiPORouteGuidanceStatus::setU16RouteGuidanceManeuverCount (uint16 u16RouteGuidanceManeuverCount_) {
    set_has_u16RouteGuidanceManeuverCount();
    this->_u16RouteGuidanceManeuverCount = u16RouteGuidanceManeuverCount_;
}

inline void DiPORouteGuidanceStatus::clearBIsRouteGuidanceVisibleInApp() {
    if (hasBIsRouteGuidanceVisibleInApp()) {
         clear_has_bIsRouteGuidanceVisibleInApp();
        _bIsRouteGuidanceVisibleInApp = false;
     }
}

inline bool DiPORouteGuidanceStatus::hasBIsRouteGuidanceVisibleInApp () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline bool DiPORouteGuidanceStatus::getBIsRouteGuidanceVisibleInApp () const {
    return _bIsRouteGuidanceVisibleInApp;
}

inline void DiPORouteGuidanceStatus::setBIsRouteGuidanceVisibleInApp (bool bIsRouteGuidanceVisibleInApp_) {
    set_has_bIsRouteGuidanceVisibleInApp();
    this->_bIsRouteGuidanceVisibleInApp = bIsRouteGuidanceVisibleInApp_;
}

inline void DiPORouteGuidanceStatus::clearSourceName() {
    if (hasSourceName()) {
         clear_has_SourceName();
        _SourceName.clear();
     }
}

inline bool DiPORouteGuidanceStatus::hasSourceName () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline const ::std::string& DiPORouteGuidanceStatus::getSourceName () const {
    return _SourceName;
}

inline ::std::string& DiPORouteGuidanceStatus::getSourceNameMutable () {
    set_has_SourceName();
    return _SourceName;
}

inline void DiPORouteGuidanceStatus::setSourceName (const ::std::string& SourceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SourceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SourceName();
    this->_SourceName = SourceName_;
}

inline void DiPORouteGuidanceStatus::setSourceName (const char* SourceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SourceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SourceName();
    this->_SourceName.assign(SourceName_);
}

inline void DiPORouteGuidanceStatus::setSourceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SourceName();
    this->_SourceName.assign(value, size);
}

inline void DiPORouteGuidanceStatus::clearSourceSupportsRouteGuidance() {
    if (hasSourceSupportsRouteGuidance()) {
         clear_has_SourceSupportsRouteGuidance();
        _SourceSupportsRouteGuidance = false;
     }
}

inline bool DiPORouteGuidanceStatus::hasSourceSupportsRouteGuidance () const {
    return (_has_bits_[0] & (1u << 18)) > 0;
}

inline bool DiPORouteGuidanceStatus::getSourceSupportsRouteGuidance () const {
    return _SourceSupportsRouteGuidance;
}

inline void DiPORouteGuidanceStatus::setSourceSupportsRouteGuidance (bool SourceSupportsRouteGuidance_) {
    set_has_SourceSupportsRouteGuidance();
    this->_SourceSupportsRouteGuidance = SourceSupportsRouteGuidance_;
}

inline void DiPORouteGuidanceStatus::set_has_sDeviceUSBSerialNumber () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPORouteGuidanceStatus::clear_has_sDeviceUSBSerialNumber () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiPORouteGuidanceStatus::set_has_u16RouteGuidanceDisplayComponentID () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiPORouteGuidanceStatus::clear_has_u16RouteGuidanceDisplayComponentID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DiPORouteGuidanceStatus::set_has_e8RouteGuidanceState () {
    _has_bits_[0] |= 1u << 2;
}

inline void DiPORouteGuidanceStatus::clear_has_e8RouteGuidanceState () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DiPORouteGuidanceStatus::set_has_e8ManeuverState () {
    _has_bits_[0] |= 1u << 3;
}

inline void DiPORouteGuidanceStatus::clear_has_e8ManeuverState () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void DiPORouteGuidanceStatus::set_has_szCurrentRoadName () {
    _has_bits_[0] |= 1u << 4;
}

inline void DiPORouteGuidanceStatus::clear_has_szCurrentRoadName () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void DiPORouteGuidanceStatus::set_has_szDestinationName () {
    _has_bits_[0] |= 1u << 5;
}

inline void DiPORouteGuidanceStatus::clear_has_szDestinationName () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void DiPORouteGuidanceStatus::set_has_u64EstimatedTimeOfArrival () {
    _has_bits_[0] |= 1u << 6;
}

inline void DiPORouteGuidanceStatus::clear_has_u64EstimatedTimeOfArrival () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void DiPORouteGuidanceStatus::set_has_u64TimeRemainingToDestination () {
    _has_bits_[0] |= 1u << 7;
}

inline void DiPORouteGuidanceStatus::clear_has_u64TimeRemainingToDestination () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void DiPORouteGuidanceStatus::set_has_u32DistanceRemaining () {
    _has_bits_[0] |= 1u << 8;
}

inline void DiPORouteGuidanceStatus::clear_has_u32DistanceRemaining () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void DiPORouteGuidanceStatus::set_has_szDistanceRemainingDisplayStr () {
    _has_bits_[0] |= 1u << 9;
}

inline void DiPORouteGuidanceStatus::clear_has_szDistanceRemainingDisplayStr () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void DiPORouteGuidanceStatus::set_has_e8DistanceRemainingDisplayUnits () {
    _has_bits_[0] |= 1u << 10;
}

inline void DiPORouteGuidanceStatus::clear_has_e8DistanceRemainingDisplayUnits () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void DiPORouteGuidanceStatus::set_has_u32DistanceToNextManeuver () {
    _has_bits_[0] |= 1u << 11;
}

inline void DiPORouteGuidanceStatus::clear_has_u32DistanceToNextManeuver () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void DiPORouteGuidanceStatus::set_has_szDistanceToNextManeuverDisplayStr () {
    _has_bits_[0] |= 1u << 12;
}

inline void DiPORouteGuidanceStatus::clear_has_szDistanceToNextManeuverDisplayStr () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void DiPORouteGuidanceStatus::set_has_e8DistanceToNextManeuverDisplayUnits () {
    _has_bits_[0] |= 1u << 13;
}

inline void DiPORouteGuidanceStatus::clear_has_e8DistanceToNextManeuverDisplayUnits () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void DiPORouteGuidanceStatus::set_has_u16RouteGuidanceManeuverCurrentList () {
    _has_bits_[0] |= 1u << 14;
}

inline void DiPORouteGuidanceStatus::clear_has_u16RouteGuidanceManeuverCurrentList () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void DiPORouteGuidanceStatus::set_has_u16RouteGuidanceManeuverCount () {
    _has_bits_[0] |= 1u << 15;
}

inline void DiPORouteGuidanceStatus::clear_has_u16RouteGuidanceManeuverCount () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void DiPORouteGuidanceStatus::set_has_bIsRouteGuidanceVisibleInApp () {
    _has_bits_[0] |= 1u << 16;
}

inline void DiPORouteGuidanceStatus::clear_has_bIsRouteGuidanceVisibleInApp () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void DiPORouteGuidanceStatus::set_has_SourceName () {
    _has_bits_[0] |= 1u << 17;
}

inline void DiPORouteGuidanceStatus::clear_has_SourceName () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline void DiPORouteGuidanceStatus::set_has_SourceSupportsRouteGuidance () {
    _has_bits_[0] |= 1u << 18;
}

inline void DiPORouteGuidanceStatus::clear_has_SourceSupportsRouteGuidance () {
    _has_bits_[0] &= ~ (1u << 18);
}

inline  DiPORouteGuidanceManeuverStatus::DiPORouteGuidanceManeuverStatus ()  :
    _sDeviceUSBSerialNumber (),
    _u16RouteGuidanceDisplayComponentID (0u),
    _u16Index (0u),
    _szManeuverDescription (),
    _e8ManeuverType (::mplay_appcontrol_fi_types::T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_NO_TURN),
    _szAfterManeuverRoadName (),
    _u32DistanceBetweenManeuver (0u),
    _szDistanceBetweenManeuverDisplayStr (),
    _e8DistanceBetweenManeuverDisplayUnits (::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_KM),
    _e8DrivingSide (::mplay_appcontrol_fi_types::T_e8_DrivingSide__e8DIPO_DRIVING_SIDE_RIGHT),
    _e8JunctionType (::mplay_appcontrol_fi_types::T_e8_JunctionType__e8DIPO_JUNCTION_TYPE_SINGLE_INTERSECTION),
    _s16JunctionElementAngle (0),
    _s16JunctionElementExitAngle (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPORouteGuidanceManeuverStatus::DiPORouteGuidanceManeuverStatus (const DiPORouteGuidanceManeuverStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _sDeviceUSBSerialNumber (),
    _u16RouteGuidanceDisplayComponentID (0u),
    _u16Index (0u),
    _szManeuverDescription (),
    _e8ManeuverType (::mplay_appcontrol_fi_types::T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_NO_TURN),
    _szAfterManeuverRoadName (),
    _u32DistanceBetweenManeuver (0u),
    _szDistanceBetweenManeuverDisplayStr (),
    _e8DistanceBetweenManeuverDisplayUnits (::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_KM),
    _e8DrivingSide (::mplay_appcontrol_fi_types::T_e8_DrivingSide__e8DIPO_DRIVING_SIDE_RIGHT),
    _e8JunctionType (::mplay_appcontrol_fi_types::T_e8_JunctionType__e8DIPO_JUNCTION_TYPE_SINGLE_INTERSECTION),
    _s16JunctionElementAngle (0),
    _s16JunctionElementExitAngle (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPORouteGuidanceManeuverStatus::DiPORouteGuidanceManeuverStatus (const ::std::string& sDeviceUSBSerialNumber_, uint16 u16RouteGuidanceDisplayComponentID_, uint16 u16Index_, const ::std::string& szManeuverDescription_, ::mplay_appcontrol_fi_types::T_e8_ManeuverType e8ManeuverType_, const ::std::string& szAfterManeuverRoadName_, uint32 u32DistanceBetweenManeuver_, const ::std::string& szDistanceBetweenManeuverDisplayStr_, ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits e8DistanceBetweenManeuverDisplayUnits_, ::mplay_appcontrol_fi_types::T_e8_DrivingSide e8DrivingSide_, ::mplay_appcontrol_fi_types::T_e8_JunctionType e8JunctionType_, int16 s16JunctionElementAngle_, int16 s16JunctionElementExitAngle_)  :
    _sDeviceUSBSerialNumber (sDeviceUSBSerialNumber_),
    _u16RouteGuidanceDisplayComponentID (u16RouteGuidanceDisplayComponentID_),
    _u16Index (u16Index_),
    _szManeuverDescription (szManeuverDescription_),
    _e8ManeuverType (e8ManeuverType_),
    _szAfterManeuverRoadName (szAfterManeuverRoadName_),
    _u32DistanceBetweenManeuver (u32DistanceBetweenManeuver_),
    _szDistanceBetweenManeuverDisplayStr (szDistanceBetweenManeuverDisplayStr_),
    _e8DistanceBetweenManeuverDisplayUnits (e8DistanceBetweenManeuverDisplayUnits_),
    _e8DrivingSide (e8DrivingSide_),
    _e8JunctionType (e8JunctionType_),
    _s16JunctionElementAngle (s16JunctionElementAngle_),
    _s16JunctionElementExitAngle (s16JunctionElementExitAngle_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szManeuverDescription_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_ManeuverType_IsValid(e8ManeuverType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ManeuverType_, "T_e8_ManeuverType", "e8ManeuverType", "DiPORouteGuidanceManeuverStatus");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAfterManeuverRoadName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDistanceBetweenManeuverDisplayStr_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits_IsValid(e8DistanceBetweenManeuverDisplayUnits_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DistanceBetweenManeuverDisplayUnits_, "T_e8_DistanceDisplayUnits", "e8DistanceBetweenManeuverDisplayUnits", "DiPORouteGuidanceManeuverStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DrivingSide_IsValid(e8DrivingSide_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DrivingSide_, "T_e8_DrivingSide", "e8DrivingSide", "DiPORouteGuidanceManeuverStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_JunctionType_IsValid(e8JunctionType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8JunctionType_, "T_e8_JunctionType", "e8JunctionType", "DiPORouteGuidanceManeuverStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPORouteGuidanceManeuverStatus::~DiPORouteGuidanceManeuverStatus() {
}

inline DiPORouteGuidanceManeuverStatus& DiPORouteGuidanceManeuverStatus::operator = (const DiPORouteGuidanceManeuverStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSDeviceUSBSerialNumber()) {
            setSDeviceUSBSerialNumber(rhs.getSDeviceUSBSerialNumber());
        } else {
            clearSDeviceUSBSerialNumber();
        }
        if (rhs.hasU16RouteGuidanceDisplayComponentID()) {
            setU16RouteGuidanceDisplayComponentID(rhs.getU16RouteGuidanceDisplayComponentID());
        } else {
            clearU16RouteGuidanceDisplayComponentID();
        }
        if (rhs.hasU16Index()) {
            setU16Index(rhs.getU16Index());
        } else {
            clearU16Index();
        }
        if (rhs.hasSzManeuverDescription()) {
            setSzManeuverDescription(rhs.getSzManeuverDescription());
        } else {
            clearSzManeuverDescription();
        }
        if (rhs.hasE8ManeuverType()) {
            setE8ManeuverType(rhs.getE8ManeuverType());
        } else {
            clearE8ManeuverType();
        }
        if (rhs.hasSzAfterManeuverRoadName()) {
            setSzAfterManeuverRoadName(rhs.getSzAfterManeuverRoadName());
        } else {
            clearSzAfterManeuverRoadName();
        }
        if (rhs.hasU32DistanceBetweenManeuver()) {
            setU32DistanceBetweenManeuver(rhs.getU32DistanceBetweenManeuver());
        } else {
            clearU32DistanceBetweenManeuver();
        }
        if (rhs.hasSzDistanceBetweenManeuverDisplayStr()) {
            setSzDistanceBetweenManeuverDisplayStr(rhs.getSzDistanceBetweenManeuverDisplayStr());
        } else {
            clearSzDistanceBetweenManeuverDisplayStr();
        }
        if (rhs.hasE8DistanceBetweenManeuverDisplayUnits()) {
            setE8DistanceBetweenManeuverDisplayUnits(rhs.getE8DistanceBetweenManeuverDisplayUnits());
        } else {
            clearE8DistanceBetweenManeuverDisplayUnits();
        }
        if (rhs.hasE8DrivingSide()) {
            setE8DrivingSide(rhs.getE8DrivingSide());
        } else {
            clearE8DrivingSide();
        }
        if (rhs.hasE8JunctionType()) {
            setE8JunctionType(rhs.getE8JunctionType());
        } else {
            clearE8JunctionType();
        }
        if (rhs.hasS16JunctionElementAngle()) {
            setS16JunctionElementAngle(rhs.getS16JunctionElementAngle());
        } else {
            clearS16JunctionElementAngle();
        }
        if (rhs.hasS16JunctionElementExitAngle()) {
            setS16JunctionElementExitAngle(rhs.getS16JunctionElementExitAngle());
        } else {
            clearS16JunctionElementExitAngle();
        }
    }
    return *this;
}

inline bool DiPORouteGuidanceManeuverStatus::operator == (const DiPORouteGuidanceManeuverStatus& rhs) const {
    return (((!hasSDeviceUSBSerialNumber() && !rhs.hasSDeviceUSBSerialNumber()) || getSDeviceUSBSerialNumber() == rhs.getSDeviceUSBSerialNumber()) &&
        ((!hasU16RouteGuidanceDisplayComponentID() && !rhs.hasU16RouteGuidanceDisplayComponentID()) || getU16RouteGuidanceDisplayComponentID() == rhs.getU16RouteGuidanceDisplayComponentID()) &&
        ((!hasU16Index() && !rhs.hasU16Index()) || getU16Index() == rhs.getU16Index()) &&
        ((!hasSzManeuverDescription() && !rhs.hasSzManeuverDescription()) || getSzManeuverDescription() == rhs.getSzManeuverDescription()) &&
        ((!hasE8ManeuverType() && !rhs.hasE8ManeuverType()) || getE8ManeuverType() == rhs.getE8ManeuverType()) &&
        ((!hasSzAfterManeuverRoadName() && !rhs.hasSzAfterManeuverRoadName()) || getSzAfterManeuverRoadName() == rhs.getSzAfterManeuverRoadName()) &&
        ((!hasU32DistanceBetweenManeuver() && !rhs.hasU32DistanceBetweenManeuver()) || getU32DistanceBetweenManeuver() == rhs.getU32DistanceBetweenManeuver()) &&
        ((!hasSzDistanceBetweenManeuverDisplayStr() && !rhs.hasSzDistanceBetweenManeuverDisplayStr()) || getSzDistanceBetweenManeuverDisplayStr() == rhs.getSzDistanceBetweenManeuverDisplayStr()) &&
        ((!hasE8DistanceBetweenManeuverDisplayUnits() && !rhs.hasE8DistanceBetweenManeuverDisplayUnits()) || getE8DistanceBetweenManeuverDisplayUnits() == rhs.getE8DistanceBetweenManeuverDisplayUnits()) &&
        ((!hasE8DrivingSide() && !rhs.hasE8DrivingSide()) || getE8DrivingSide() == rhs.getE8DrivingSide()) &&
        ((!hasE8JunctionType() && !rhs.hasE8JunctionType()) || getE8JunctionType() == rhs.getE8JunctionType()) &&
        ((!hasS16JunctionElementAngle() && !rhs.hasS16JunctionElementAngle()) || getS16JunctionElementAngle() == rhs.getS16JunctionElementAngle()) &&
        ((!hasS16JunctionElementExitAngle() && !rhs.hasS16JunctionElementExitAngle()) || getS16JunctionElementExitAngle() == rhs.getS16JunctionElementExitAngle()));
}

inline bool DiPORouteGuidanceManeuverStatus::operator != (const DiPORouteGuidanceManeuverStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPORouteGuidanceManeuverStatus::operator < (const DiPORouteGuidanceManeuverStatus& rhs) const {
    if (hasSDeviceUSBSerialNumber() || rhs.hasSDeviceUSBSerialNumber()) {
        if (getSDeviceUSBSerialNumber() < rhs.getSDeviceUSBSerialNumber()) return true;
        if (getSDeviceUSBSerialNumber() > rhs.getSDeviceUSBSerialNumber()) return false;
    }
    if (hasU16RouteGuidanceDisplayComponentID() || rhs.hasU16RouteGuidanceDisplayComponentID()) {
        if (getU16RouteGuidanceDisplayComponentID() < rhs.getU16RouteGuidanceDisplayComponentID()) return true;
        if (getU16RouteGuidanceDisplayComponentID() > rhs.getU16RouteGuidanceDisplayComponentID()) return false;
    }
    if (hasU16Index() || rhs.hasU16Index()) {
        if (getU16Index() < rhs.getU16Index()) return true;
        if (getU16Index() > rhs.getU16Index()) return false;
    }
    if (hasSzManeuverDescription() || rhs.hasSzManeuverDescription()) {
        if (getSzManeuverDescription() < rhs.getSzManeuverDescription()) return true;
        if (getSzManeuverDescription() > rhs.getSzManeuverDescription()) return false;
    }
    if (hasE8ManeuverType() || rhs.hasE8ManeuverType()) {
        if ((uint32)getE8ManeuverType() < (uint32)rhs.getE8ManeuverType()) return true;
        if ((uint32)getE8ManeuverType() > (uint32)rhs.getE8ManeuverType()) return false;
    }
    if (hasSzAfterManeuverRoadName() || rhs.hasSzAfterManeuverRoadName()) {
        if (getSzAfterManeuverRoadName() < rhs.getSzAfterManeuverRoadName()) return true;
        if (getSzAfterManeuverRoadName() > rhs.getSzAfterManeuverRoadName()) return false;
    }
    if (hasU32DistanceBetweenManeuver() || rhs.hasU32DistanceBetweenManeuver()) {
        if (getU32DistanceBetweenManeuver() < rhs.getU32DistanceBetweenManeuver()) return true;
        if (getU32DistanceBetweenManeuver() > rhs.getU32DistanceBetweenManeuver()) return false;
    }
    if (hasSzDistanceBetweenManeuverDisplayStr() || rhs.hasSzDistanceBetweenManeuverDisplayStr()) {
        if (getSzDistanceBetweenManeuverDisplayStr() < rhs.getSzDistanceBetweenManeuverDisplayStr()) return true;
        if (getSzDistanceBetweenManeuverDisplayStr() > rhs.getSzDistanceBetweenManeuverDisplayStr()) return false;
    }
    if (hasE8DistanceBetweenManeuverDisplayUnits() || rhs.hasE8DistanceBetweenManeuverDisplayUnits()) {
        if ((uint32)getE8DistanceBetweenManeuverDisplayUnits() < (uint32)rhs.getE8DistanceBetweenManeuverDisplayUnits()) return true;
        if ((uint32)getE8DistanceBetweenManeuverDisplayUnits() > (uint32)rhs.getE8DistanceBetweenManeuverDisplayUnits()) return false;
    }
    if (hasE8DrivingSide() || rhs.hasE8DrivingSide()) {
        if ((uint32)getE8DrivingSide() < (uint32)rhs.getE8DrivingSide()) return true;
        if ((uint32)getE8DrivingSide() > (uint32)rhs.getE8DrivingSide()) return false;
    }
    if (hasE8JunctionType() || rhs.hasE8JunctionType()) {
        if ((uint32)getE8JunctionType() < (uint32)rhs.getE8JunctionType()) return true;
        if ((uint32)getE8JunctionType() > (uint32)rhs.getE8JunctionType()) return false;
    }
    if (hasS16JunctionElementAngle() || rhs.hasS16JunctionElementAngle()) {
        if (getS16JunctionElementAngle() < rhs.getS16JunctionElementAngle()) return true;
        if (getS16JunctionElementAngle() > rhs.getS16JunctionElementAngle()) return false;
    }
    if (hasS16JunctionElementExitAngle() || rhs.hasS16JunctionElementExitAngle()) {
        if (getS16JunctionElementExitAngle() < rhs.getS16JunctionElementExitAngle()) return true;
        if (getS16JunctionElementExitAngle() > rhs.getS16JunctionElementExitAngle()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPORouteGuidanceManeuverStatus::clone() {
    return new DiPORouteGuidanceManeuverStatus(*this);
}

inline bool DiPORouteGuidanceManeuverStatus::operator > (const DiPORouteGuidanceManeuverStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPORouteGuidanceManeuverStatus::clear() {
    clearSDeviceUSBSerialNumber();
    clearU16RouteGuidanceDisplayComponentID();
    clearU16Index();
    clearSzManeuverDescription();
    clearE8ManeuverType();
    clearSzAfterManeuverRoadName();
    clearU32DistanceBetweenManeuver();
    clearSzDistanceBetweenManeuverDisplayStr();
    clearE8DistanceBetweenManeuverDisplayUnits();
    clearE8DrivingSide();
    clearE8JunctionType();
    clearS16JunctionElementAngle();
    clearS16JunctionElementExitAngle();
}

inline void DiPORouteGuidanceManeuverStatus::clearSDeviceUSBSerialNumber() {
    if (hasSDeviceUSBSerialNumber()) {
         clear_has_sDeviceUSBSerialNumber();
        _sDeviceUSBSerialNumber.clear();
     }
}

inline bool DiPORouteGuidanceManeuverStatus::hasSDeviceUSBSerialNumber () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DiPORouteGuidanceManeuverStatus::getSDeviceUSBSerialNumber () const {
    return _sDeviceUSBSerialNumber;
}

inline ::std::string& DiPORouteGuidanceManeuverStatus::getSDeviceUSBSerialNumberMutable () {
    set_has_sDeviceUSBSerialNumber();
    return _sDeviceUSBSerialNumber;
}

inline void DiPORouteGuidanceManeuverStatus::setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber = sDeviceUSBSerialNumber_;
}

inline void DiPORouteGuidanceManeuverStatus::setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber.assign(sDeviceUSBSerialNumber_);
}

inline void DiPORouteGuidanceManeuverStatus::setSDeviceUSBSerialNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber.assign(value, size);
}

inline void DiPORouteGuidanceManeuverStatus::clearU16RouteGuidanceDisplayComponentID() {
    if (hasU16RouteGuidanceDisplayComponentID()) {
         clear_has_u16RouteGuidanceDisplayComponentID();
        _u16RouteGuidanceDisplayComponentID = 0u;
     }
}

inline bool DiPORouteGuidanceManeuverStatus::hasU16RouteGuidanceDisplayComponentID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 DiPORouteGuidanceManeuverStatus::getU16RouteGuidanceDisplayComponentID () const {
    return _u16RouteGuidanceDisplayComponentID;
}

inline void DiPORouteGuidanceManeuverStatus::setU16RouteGuidanceDisplayComponentID (uint16 u16RouteGuidanceDisplayComponentID_) {
    set_has_u16RouteGuidanceDisplayComponentID();
    this->_u16RouteGuidanceDisplayComponentID = u16RouteGuidanceDisplayComponentID_;
}

inline void DiPORouteGuidanceManeuverStatus::clearU16Index() {
    if (hasU16Index()) {
         clear_has_u16Index();
        _u16Index = 0u;
     }
}

inline bool DiPORouteGuidanceManeuverStatus::hasU16Index () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 DiPORouteGuidanceManeuverStatus::getU16Index () const {
    return _u16Index;
}

inline void DiPORouteGuidanceManeuverStatus::setU16Index (uint16 u16Index_) {
    set_has_u16Index();
    this->_u16Index = u16Index_;
}

inline void DiPORouteGuidanceManeuverStatus::clearSzManeuverDescription() {
    if (hasSzManeuverDescription()) {
         clear_has_szManeuverDescription();
        _szManeuverDescription.clear();
     }
}

inline bool DiPORouteGuidanceManeuverStatus::hasSzManeuverDescription () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& DiPORouteGuidanceManeuverStatus::getSzManeuverDescription () const {
    return _szManeuverDescription;
}

inline ::std::string& DiPORouteGuidanceManeuverStatus::getSzManeuverDescriptionMutable () {
    set_has_szManeuverDescription();
    return _szManeuverDescription;
}

inline void DiPORouteGuidanceManeuverStatus::setSzManeuverDescription (const ::std::string& szManeuverDescription_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szManeuverDescription_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szManeuverDescription();
    this->_szManeuverDescription = szManeuverDescription_;
}

inline void DiPORouteGuidanceManeuverStatus::setSzManeuverDescription (const char* szManeuverDescription_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szManeuverDescription_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szManeuverDescription();
    this->_szManeuverDescription.assign(szManeuverDescription_);
}

inline void DiPORouteGuidanceManeuverStatus::setSzManeuverDescription (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szManeuverDescription();
    this->_szManeuverDescription.assign(value, size);
}

inline void DiPORouteGuidanceManeuverStatus::clearE8ManeuverType() {
    if (hasE8ManeuverType()) {
         clear_has_e8ManeuverType();
        _e8ManeuverType = ::mplay_appcontrol_fi_types::T_e8_ManeuverType__e8DIPO_MANEUVER_TYPE_NO_TURN;
     }
}

inline bool DiPORouteGuidanceManeuverStatus::hasE8ManeuverType () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline ::mplay_appcontrol_fi_types::T_e8_ManeuverType DiPORouteGuidanceManeuverStatus::getE8ManeuverType () const {
    return _e8ManeuverType;
}

inline void DiPORouteGuidanceManeuverStatus::setE8ManeuverType (::mplay_appcontrol_fi_types::T_e8_ManeuverType e8ManeuverType_) {
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_ManeuverType_IsValid(e8ManeuverType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ManeuverType_, "T_e8_ManeuverType", "e8ManeuverType", "DiPORouteGuidanceManeuverStatus");
    }
    #endif
    set_has_e8ManeuverType();
    this->_e8ManeuverType = e8ManeuverType_;
}

inline void DiPORouteGuidanceManeuverStatus::clearSzAfterManeuverRoadName() {
    if (hasSzAfterManeuverRoadName()) {
         clear_has_szAfterManeuverRoadName();
        _szAfterManeuverRoadName.clear();
     }
}

inline bool DiPORouteGuidanceManeuverStatus::hasSzAfterManeuverRoadName () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& DiPORouteGuidanceManeuverStatus::getSzAfterManeuverRoadName () const {
    return _szAfterManeuverRoadName;
}

inline ::std::string& DiPORouteGuidanceManeuverStatus::getSzAfterManeuverRoadNameMutable () {
    set_has_szAfterManeuverRoadName();
    return _szAfterManeuverRoadName;
}

inline void DiPORouteGuidanceManeuverStatus::setSzAfterManeuverRoadName (const ::std::string& szAfterManeuverRoadName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAfterManeuverRoadName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAfterManeuverRoadName();
    this->_szAfterManeuverRoadName = szAfterManeuverRoadName_;
}

inline void DiPORouteGuidanceManeuverStatus::setSzAfterManeuverRoadName (const char* szAfterManeuverRoadName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAfterManeuverRoadName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAfterManeuverRoadName();
    this->_szAfterManeuverRoadName.assign(szAfterManeuverRoadName_);
}

inline void DiPORouteGuidanceManeuverStatus::setSzAfterManeuverRoadName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAfterManeuverRoadName();
    this->_szAfterManeuverRoadName.assign(value, size);
}

inline void DiPORouteGuidanceManeuverStatus::clearU32DistanceBetweenManeuver() {
    if (hasU32DistanceBetweenManeuver()) {
         clear_has_u32DistanceBetweenManeuver();
        _u32DistanceBetweenManeuver = 0u;
     }
}

inline bool DiPORouteGuidanceManeuverStatus::hasU32DistanceBetweenManeuver () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint32 DiPORouteGuidanceManeuverStatus::getU32DistanceBetweenManeuver () const {
    return _u32DistanceBetweenManeuver;
}

inline void DiPORouteGuidanceManeuverStatus::setU32DistanceBetweenManeuver (uint32 u32DistanceBetweenManeuver_) {
    set_has_u32DistanceBetweenManeuver();
    this->_u32DistanceBetweenManeuver = u32DistanceBetweenManeuver_;
}

inline void DiPORouteGuidanceManeuverStatus::clearSzDistanceBetweenManeuverDisplayStr() {
    if (hasSzDistanceBetweenManeuverDisplayStr()) {
         clear_has_szDistanceBetweenManeuverDisplayStr();
        _szDistanceBetweenManeuverDisplayStr.clear();
     }
}

inline bool DiPORouteGuidanceManeuverStatus::hasSzDistanceBetweenManeuverDisplayStr () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& DiPORouteGuidanceManeuverStatus::getSzDistanceBetweenManeuverDisplayStr () const {
    return _szDistanceBetweenManeuverDisplayStr;
}

inline ::std::string& DiPORouteGuidanceManeuverStatus::getSzDistanceBetweenManeuverDisplayStrMutable () {
    set_has_szDistanceBetweenManeuverDisplayStr();
    return _szDistanceBetweenManeuverDisplayStr;
}

inline void DiPORouteGuidanceManeuverStatus::setSzDistanceBetweenManeuverDisplayStr (const ::std::string& szDistanceBetweenManeuverDisplayStr_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDistanceBetweenManeuverDisplayStr_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDistanceBetweenManeuverDisplayStr();
    this->_szDistanceBetweenManeuverDisplayStr = szDistanceBetweenManeuverDisplayStr_;
}

inline void DiPORouteGuidanceManeuverStatus::setSzDistanceBetweenManeuverDisplayStr (const char* szDistanceBetweenManeuverDisplayStr_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDistanceBetweenManeuverDisplayStr_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDistanceBetweenManeuverDisplayStr();
    this->_szDistanceBetweenManeuverDisplayStr.assign(szDistanceBetweenManeuverDisplayStr_);
}

inline void DiPORouteGuidanceManeuverStatus::setSzDistanceBetweenManeuverDisplayStr (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDistanceBetweenManeuverDisplayStr();
    this->_szDistanceBetweenManeuverDisplayStr.assign(value, size);
}

inline void DiPORouteGuidanceManeuverStatus::clearE8DistanceBetweenManeuverDisplayUnits() {
    if (hasE8DistanceBetweenManeuverDisplayUnits()) {
         clear_has_e8DistanceBetweenManeuverDisplayUnits();
        _e8DistanceBetweenManeuverDisplayUnits = ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits__e8DIPO_DISTANCE_DISPLAY_UNIT_KM;
     }
}

inline bool DiPORouteGuidanceManeuverStatus::hasE8DistanceBetweenManeuverDisplayUnits () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline ::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits DiPORouteGuidanceManeuverStatus::getE8DistanceBetweenManeuverDisplayUnits () const {
    return _e8DistanceBetweenManeuverDisplayUnits;
}

inline void DiPORouteGuidanceManeuverStatus::setE8DistanceBetweenManeuverDisplayUnits (::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits e8DistanceBetweenManeuverDisplayUnits_) {
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DistanceDisplayUnits_IsValid(e8DistanceBetweenManeuverDisplayUnits_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DistanceBetweenManeuverDisplayUnits_, "T_e8_DistanceDisplayUnits", "e8DistanceBetweenManeuverDisplayUnits", "DiPORouteGuidanceManeuverStatus");
    }
    #endif
    set_has_e8DistanceBetweenManeuverDisplayUnits();
    this->_e8DistanceBetweenManeuverDisplayUnits = e8DistanceBetweenManeuverDisplayUnits_;
}

inline void DiPORouteGuidanceManeuverStatus::clearE8DrivingSide() {
    if (hasE8DrivingSide()) {
         clear_has_e8DrivingSide();
        _e8DrivingSide = ::mplay_appcontrol_fi_types::T_e8_DrivingSide__e8DIPO_DRIVING_SIDE_RIGHT;
     }
}

inline bool DiPORouteGuidanceManeuverStatus::hasE8DrivingSide () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline ::mplay_appcontrol_fi_types::T_e8_DrivingSide DiPORouteGuidanceManeuverStatus::getE8DrivingSide () const {
    return _e8DrivingSide;
}

inline void DiPORouteGuidanceManeuverStatus::setE8DrivingSide (::mplay_appcontrol_fi_types::T_e8_DrivingSide e8DrivingSide_) {
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DrivingSide_IsValid(e8DrivingSide_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DrivingSide_, "T_e8_DrivingSide", "e8DrivingSide", "DiPORouteGuidanceManeuverStatus");
    }
    #endif
    set_has_e8DrivingSide();
    this->_e8DrivingSide = e8DrivingSide_;
}

inline void DiPORouteGuidanceManeuverStatus::clearE8JunctionType() {
    if (hasE8JunctionType()) {
         clear_has_e8JunctionType();
        _e8JunctionType = ::mplay_appcontrol_fi_types::T_e8_JunctionType__e8DIPO_JUNCTION_TYPE_SINGLE_INTERSECTION;
     }
}

inline bool DiPORouteGuidanceManeuverStatus::hasE8JunctionType () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline ::mplay_appcontrol_fi_types::T_e8_JunctionType DiPORouteGuidanceManeuverStatus::getE8JunctionType () const {
    return _e8JunctionType;
}

inline void DiPORouteGuidanceManeuverStatus::setE8JunctionType (::mplay_appcontrol_fi_types::T_e8_JunctionType e8JunctionType_) {
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_JunctionType_IsValid(e8JunctionType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8JunctionType_, "T_e8_JunctionType", "e8JunctionType", "DiPORouteGuidanceManeuverStatus");
    }
    #endif
    set_has_e8JunctionType();
    this->_e8JunctionType = e8JunctionType_;
}

inline void DiPORouteGuidanceManeuverStatus::clearS16JunctionElementAngle() {
    if (hasS16JunctionElementAngle()) {
         clear_has_s16JunctionElementAngle();
        _s16JunctionElementAngle = 0;
     }
}

inline bool DiPORouteGuidanceManeuverStatus::hasS16JunctionElementAngle () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline int16 DiPORouteGuidanceManeuverStatus::getS16JunctionElementAngle () const {
    return _s16JunctionElementAngle;
}

inline void DiPORouteGuidanceManeuverStatus::setS16JunctionElementAngle (int16 s16JunctionElementAngle_) {
    set_has_s16JunctionElementAngle();
    this->_s16JunctionElementAngle = s16JunctionElementAngle_;
}

inline void DiPORouteGuidanceManeuverStatus::clearS16JunctionElementExitAngle() {
    if (hasS16JunctionElementExitAngle()) {
         clear_has_s16JunctionElementExitAngle();
        _s16JunctionElementExitAngle = 0;
     }
}

inline bool DiPORouteGuidanceManeuverStatus::hasS16JunctionElementExitAngle () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline int16 DiPORouteGuidanceManeuverStatus::getS16JunctionElementExitAngle () const {
    return _s16JunctionElementExitAngle;
}

inline void DiPORouteGuidanceManeuverStatus::setS16JunctionElementExitAngle (int16 s16JunctionElementExitAngle_) {
    set_has_s16JunctionElementExitAngle();
    this->_s16JunctionElementExitAngle = s16JunctionElementExitAngle_;
}

inline void DiPORouteGuidanceManeuverStatus::set_has_sDeviceUSBSerialNumber () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPORouteGuidanceManeuverStatus::clear_has_sDeviceUSBSerialNumber () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiPORouteGuidanceManeuverStatus::set_has_u16RouteGuidanceDisplayComponentID () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiPORouteGuidanceManeuverStatus::clear_has_u16RouteGuidanceDisplayComponentID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DiPORouteGuidanceManeuverStatus::set_has_u16Index () {
    _has_bits_[0] |= 1u << 2;
}

inline void DiPORouteGuidanceManeuverStatus::clear_has_u16Index () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DiPORouteGuidanceManeuverStatus::set_has_szManeuverDescription () {
    _has_bits_[0] |= 1u << 3;
}

inline void DiPORouteGuidanceManeuverStatus::clear_has_szManeuverDescription () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void DiPORouteGuidanceManeuverStatus::set_has_e8ManeuverType () {
    _has_bits_[0] |= 1u << 4;
}

inline void DiPORouteGuidanceManeuverStatus::clear_has_e8ManeuverType () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void DiPORouteGuidanceManeuverStatus::set_has_szAfterManeuverRoadName () {
    _has_bits_[0] |= 1u << 5;
}

inline void DiPORouteGuidanceManeuverStatus::clear_has_szAfterManeuverRoadName () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void DiPORouteGuidanceManeuverStatus::set_has_u32DistanceBetweenManeuver () {
    _has_bits_[0] |= 1u << 6;
}

inline void DiPORouteGuidanceManeuverStatus::clear_has_u32DistanceBetweenManeuver () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void DiPORouteGuidanceManeuverStatus::set_has_szDistanceBetweenManeuverDisplayStr () {
    _has_bits_[0] |= 1u << 7;
}

inline void DiPORouteGuidanceManeuverStatus::clear_has_szDistanceBetweenManeuverDisplayStr () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void DiPORouteGuidanceManeuverStatus::set_has_e8DistanceBetweenManeuverDisplayUnits () {
    _has_bits_[0] |= 1u << 8;
}

inline void DiPORouteGuidanceManeuverStatus::clear_has_e8DistanceBetweenManeuverDisplayUnits () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void DiPORouteGuidanceManeuverStatus::set_has_e8DrivingSide () {
    _has_bits_[0] |= 1u << 9;
}

inline void DiPORouteGuidanceManeuverStatus::clear_has_e8DrivingSide () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void DiPORouteGuidanceManeuverStatus::set_has_e8JunctionType () {
    _has_bits_[0] |= 1u << 10;
}

inline void DiPORouteGuidanceManeuverStatus::clear_has_e8JunctionType () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void DiPORouteGuidanceManeuverStatus::set_has_s16JunctionElementAngle () {
    _has_bits_[0] |= 1u << 11;
}

inline void DiPORouteGuidanceManeuverStatus::clear_has_s16JunctionElementAngle () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void DiPORouteGuidanceManeuverStatus::set_has_s16JunctionElementExitAngle () {
    _has_bits_[0] |= 1u << 12;
}

inline void DiPORouteGuidanceManeuverStatus::clear_has_s16JunctionElementExitAngle () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline  DiPOGPRMCDataStatusValuesStatus::DiPOGPRMCDataStatusValuesStatus ()  :
    _u8DeviceId (0u),
    _sDeviceUSBSerialNumber (),
    _b8GPRMCDataStatusValues ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPOGPRMCDataStatusValuesStatus::DiPOGPRMCDataStatusValuesStatus (const DiPOGPRMCDataStatusValuesStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _u8DeviceId (0u),
    _sDeviceUSBSerialNumber (),
    _b8GPRMCDataStatusValues ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPOGPRMCDataStatusValuesStatus::DiPOGPRMCDataStatusValuesStatus (uint8 u8DeviceId_, const ::std::string& sDeviceUSBSerialNumber_, const ::mplay_appcontrol_fi_types::T_b8_DiPOGPRMCDataStatusValues& b8GPRMCDataStatusValues_)  :
    _u8DeviceId (u8DeviceId_),
    _sDeviceUSBSerialNumber (sDeviceUSBSerialNumber_),
    _b8GPRMCDataStatusValues (b8GPRMCDataStatusValues_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPOGPRMCDataStatusValuesStatus::~DiPOGPRMCDataStatusValuesStatus() {
}

inline DiPOGPRMCDataStatusValuesStatus& DiPOGPRMCDataStatusValuesStatus::operator = (const DiPOGPRMCDataStatusValuesStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8DeviceId()) {
            setU8DeviceId(rhs.getU8DeviceId());
        } else {
            clearU8DeviceId();
        }
        if (rhs.hasSDeviceUSBSerialNumber()) {
            setSDeviceUSBSerialNumber(rhs.getSDeviceUSBSerialNumber());
        } else {
            clearSDeviceUSBSerialNumber();
        }
        if (rhs.hasB8GPRMCDataStatusValues()) {
            setB8GPRMCDataStatusValues(rhs.getB8GPRMCDataStatusValues());
        } else {
            clearB8GPRMCDataStatusValues();
        }
    }
    return *this;
}

inline bool DiPOGPRMCDataStatusValuesStatus::operator == (const DiPOGPRMCDataStatusValuesStatus& rhs) const {
    return (((!hasU8DeviceId() && !rhs.hasU8DeviceId()) || getU8DeviceId() == rhs.getU8DeviceId()) &&
        ((!hasSDeviceUSBSerialNumber() && !rhs.hasSDeviceUSBSerialNumber()) || getSDeviceUSBSerialNumber() == rhs.getSDeviceUSBSerialNumber()) &&
        ((!hasB8GPRMCDataStatusValues() && !rhs.hasB8GPRMCDataStatusValues()) || getB8GPRMCDataStatusValues() == rhs.getB8GPRMCDataStatusValues()));
}

inline bool DiPOGPRMCDataStatusValuesStatus::operator != (const DiPOGPRMCDataStatusValuesStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPOGPRMCDataStatusValuesStatus::operator < (const DiPOGPRMCDataStatusValuesStatus& rhs) const {
    if (hasU8DeviceId() || rhs.hasU8DeviceId()) {
        if (getU8DeviceId() < rhs.getU8DeviceId()) return true;
        if (getU8DeviceId() > rhs.getU8DeviceId()) return false;
    }
    if (hasSDeviceUSBSerialNumber() || rhs.hasSDeviceUSBSerialNumber()) {
        if (getSDeviceUSBSerialNumber() < rhs.getSDeviceUSBSerialNumber()) return true;
        if (getSDeviceUSBSerialNumber() > rhs.getSDeviceUSBSerialNumber()) return false;
    }
    if (hasB8GPRMCDataStatusValues() || rhs.hasB8GPRMCDataStatusValues()) {
        if (getB8GPRMCDataStatusValues() < rhs.getB8GPRMCDataStatusValues()) return true;
        if (getB8GPRMCDataStatusValues() > rhs.getB8GPRMCDataStatusValues()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPOGPRMCDataStatusValuesStatus::clone() {
    return new DiPOGPRMCDataStatusValuesStatus(*this);
}

inline bool DiPOGPRMCDataStatusValuesStatus::operator > (const DiPOGPRMCDataStatusValuesStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPOGPRMCDataStatusValuesStatus::clear() {
    clearU8DeviceId();
    clearSDeviceUSBSerialNumber();
    clearB8GPRMCDataStatusValues();
}

inline void DiPOGPRMCDataStatusValuesStatus::clearU8DeviceId() {
    if (hasU8DeviceId()) {
         clear_has_u8DeviceId();
        _u8DeviceId = 0u;
     }
}

inline bool DiPOGPRMCDataStatusValuesStatus::hasU8DeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DiPOGPRMCDataStatusValuesStatus::getU8DeviceId () const {
    return _u8DeviceId;
}

inline void DiPOGPRMCDataStatusValuesStatus::setU8DeviceId (uint8 u8DeviceId_) {
    set_has_u8DeviceId();
    this->_u8DeviceId = u8DeviceId_;
}

inline void DiPOGPRMCDataStatusValuesStatus::clearSDeviceUSBSerialNumber() {
    if (hasSDeviceUSBSerialNumber()) {
         clear_has_sDeviceUSBSerialNumber();
        _sDeviceUSBSerialNumber.clear();
     }
}

inline bool DiPOGPRMCDataStatusValuesStatus::hasSDeviceUSBSerialNumber () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& DiPOGPRMCDataStatusValuesStatus::getSDeviceUSBSerialNumber () const {
    return _sDeviceUSBSerialNumber;
}

inline ::std::string& DiPOGPRMCDataStatusValuesStatus::getSDeviceUSBSerialNumberMutable () {
    set_has_sDeviceUSBSerialNumber();
    return _sDeviceUSBSerialNumber;
}

inline void DiPOGPRMCDataStatusValuesStatus::setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber = sDeviceUSBSerialNumber_;
}

inline void DiPOGPRMCDataStatusValuesStatus::setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber.assign(sDeviceUSBSerialNumber_);
}

inline void DiPOGPRMCDataStatusValuesStatus::setSDeviceUSBSerialNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber.assign(value, size);
}

inline void DiPOGPRMCDataStatusValuesStatus::clearB8GPRMCDataStatusValues() {
    if (hasB8GPRMCDataStatusValues()) {
         clear_has_b8GPRMCDataStatusValues();
        _b8GPRMCDataStatusValues = ::mplay_appcontrol_fi_types::T_b8_DiPOGPRMCDataStatusValues ();
     }
}

inline bool DiPOGPRMCDataStatusValuesStatus::hasB8GPRMCDataStatusValues () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::mplay_appcontrol_fi_types::T_b8_DiPOGPRMCDataStatusValues& DiPOGPRMCDataStatusValuesStatus::getB8GPRMCDataStatusValues () const {
    return _b8GPRMCDataStatusValues;
}

inline ::mplay_appcontrol_fi_types::T_b8_DiPOGPRMCDataStatusValues& DiPOGPRMCDataStatusValuesStatus::getB8GPRMCDataStatusValuesMutable () {
    set_has_b8GPRMCDataStatusValues();
    return _b8GPRMCDataStatusValues;
}

inline void DiPOGPRMCDataStatusValuesStatus::setB8GPRMCDataStatusValues (const ::mplay_appcontrol_fi_types::T_b8_DiPOGPRMCDataStatusValues& b8GPRMCDataStatusValues_) {
    set_has_b8GPRMCDataStatusValues();
    this->_b8GPRMCDataStatusValues = b8GPRMCDataStatusValues_;
}

inline void DiPOGPRMCDataStatusValuesStatus::set_has_u8DeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPOGPRMCDataStatusValuesStatus::clear_has_u8DeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiPOGPRMCDataStatusValuesStatus::set_has_sDeviceUSBSerialNumber () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiPOGPRMCDataStatusValuesStatus::clear_has_sDeviceUSBSerialNumber () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DiPOGPRMCDataStatusValuesStatus::set_has_b8GPRMCDataStatusValues () {
    _has_bits_[0] |= 1u << 2;
}

inline void DiPOGPRMCDataStatusValuesStatus::clear_has_b8GPRMCDataStatusValues () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  DiPORouteGuidance2Status::DiPORouteGuidance2Status ()  :
    _sDeviceUSBSerialNumber (),
    _RouteGuidanceUpdate ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPORouteGuidance2Status::DiPORouteGuidance2Status (const DiPORouteGuidance2Status &rhs)  :
    ::asf::core::Payload(rhs),
    _sDeviceUSBSerialNumber (),
    _RouteGuidanceUpdate ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPORouteGuidance2Status::DiPORouteGuidance2Status (const ::std::string& sDeviceUSBSerialNumber_, const ::mplay_appcontrol_fi_types::T_RouteGuidanceUpdate& RouteGuidanceUpdate_)  :
    _sDeviceUSBSerialNumber (sDeviceUSBSerialNumber_),
    _RouteGuidanceUpdate (RouteGuidanceUpdate_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPORouteGuidance2Status::~DiPORouteGuidance2Status() {
}

inline DiPORouteGuidance2Status& DiPORouteGuidance2Status::operator = (const DiPORouteGuidance2Status& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSDeviceUSBSerialNumber()) {
            setSDeviceUSBSerialNumber(rhs.getSDeviceUSBSerialNumber());
        } else {
            clearSDeviceUSBSerialNumber();
        }
        if (rhs.hasRouteGuidanceUpdate()) {
            setRouteGuidanceUpdate(rhs.getRouteGuidanceUpdate());
        } else {
            clearRouteGuidanceUpdate();
        }
    }
    return *this;
}

inline bool DiPORouteGuidance2Status::operator == (const DiPORouteGuidance2Status& rhs) const {
    return (((!hasSDeviceUSBSerialNumber() && !rhs.hasSDeviceUSBSerialNumber()) || getSDeviceUSBSerialNumber() == rhs.getSDeviceUSBSerialNumber()) &&
        ((!hasRouteGuidanceUpdate() && !rhs.hasRouteGuidanceUpdate()) || getRouteGuidanceUpdate() == rhs.getRouteGuidanceUpdate()));
}

inline bool DiPORouteGuidance2Status::operator != (const DiPORouteGuidance2Status& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPORouteGuidance2Status::operator < (const DiPORouteGuidance2Status& rhs) const {
    if (hasSDeviceUSBSerialNumber() || rhs.hasSDeviceUSBSerialNumber()) {
        if (getSDeviceUSBSerialNumber() < rhs.getSDeviceUSBSerialNumber()) return true;
        if (getSDeviceUSBSerialNumber() > rhs.getSDeviceUSBSerialNumber()) return false;
    }
    if (hasRouteGuidanceUpdate() || rhs.hasRouteGuidanceUpdate()) {
        if (getRouteGuidanceUpdate() < rhs.getRouteGuidanceUpdate()) return true;
        if (getRouteGuidanceUpdate() > rhs.getRouteGuidanceUpdate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPORouteGuidance2Status::clone() {
    return new DiPORouteGuidance2Status(*this);
}

inline bool DiPORouteGuidance2Status::operator > (const DiPORouteGuidance2Status& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPORouteGuidance2Status::clear() {
    clearSDeviceUSBSerialNumber();
    clearRouteGuidanceUpdate();
}

inline void DiPORouteGuidance2Status::clearSDeviceUSBSerialNumber() {
    if (hasSDeviceUSBSerialNumber()) {
         clear_has_sDeviceUSBSerialNumber();
        _sDeviceUSBSerialNumber.clear();
     }
}

inline bool DiPORouteGuidance2Status::hasSDeviceUSBSerialNumber () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DiPORouteGuidance2Status::getSDeviceUSBSerialNumber () const {
    return _sDeviceUSBSerialNumber;
}

inline ::std::string& DiPORouteGuidance2Status::getSDeviceUSBSerialNumberMutable () {
    set_has_sDeviceUSBSerialNumber();
    return _sDeviceUSBSerialNumber;
}

inline void DiPORouteGuidance2Status::setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber = sDeviceUSBSerialNumber_;
}

inline void DiPORouteGuidance2Status::setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber.assign(sDeviceUSBSerialNumber_);
}

inline void DiPORouteGuidance2Status::setSDeviceUSBSerialNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber.assign(value, size);
}

inline void DiPORouteGuidance2Status::clearRouteGuidanceUpdate() {
    if (hasRouteGuidanceUpdate()) {
         clear_has_RouteGuidanceUpdate();
        _RouteGuidanceUpdate.clear();
     }
}

inline bool DiPORouteGuidance2Status::hasRouteGuidanceUpdate () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::mplay_appcontrol_fi_types::T_RouteGuidanceUpdate& DiPORouteGuidance2Status::getRouteGuidanceUpdate () const {
    return _RouteGuidanceUpdate;
}

inline ::mplay_appcontrol_fi_types::T_RouteGuidanceUpdate& DiPORouteGuidance2Status::getRouteGuidanceUpdateMutable () {
    set_has_RouteGuidanceUpdate();
    return _RouteGuidanceUpdate;
}

inline void DiPORouteGuidance2Status::setRouteGuidanceUpdate (const ::mplay_appcontrol_fi_types::T_RouteGuidanceUpdate& RouteGuidanceUpdate_) {
    set_has_RouteGuidanceUpdate();
    this->_RouteGuidanceUpdate = RouteGuidanceUpdate_;
}

inline void DiPORouteGuidance2Status::set_has_sDeviceUSBSerialNumber () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPORouteGuidance2Status::clear_has_sDeviceUSBSerialNumber () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiPORouteGuidance2Status::set_has_RouteGuidanceUpdate () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiPORouteGuidance2Status::clear_has_RouteGuidanceUpdate () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DiPORouteGuidanceManeuver2Status::DiPORouteGuidanceManeuver2Status ()  :
    _sDeviceUSBSerialNumber (),
    _RouteGuidanceManeuverUpdate ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPORouteGuidanceManeuver2Status::DiPORouteGuidanceManeuver2Status (const DiPORouteGuidanceManeuver2Status &rhs)  :
    ::asf::core::Payload(rhs),
    _sDeviceUSBSerialNumber (),
    _RouteGuidanceManeuverUpdate ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPORouteGuidanceManeuver2Status::DiPORouteGuidanceManeuver2Status (const ::std::string& sDeviceUSBSerialNumber_, const ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverUpdate& RouteGuidanceManeuverUpdate_)  :
    _sDeviceUSBSerialNumber (sDeviceUSBSerialNumber_),
    _RouteGuidanceManeuverUpdate (RouteGuidanceManeuverUpdate_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPORouteGuidanceManeuver2Status::~DiPORouteGuidanceManeuver2Status() {
}

inline DiPORouteGuidanceManeuver2Status& DiPORouteGuidanceManeuver2Status::operator = (const DiPORouteGuidanceManeuver2Status& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSDeviceUSBSerialNumber()) {
            setSDeviceUSBSerialNumber(rhs.getSDeviceUSBSerialNumber());
        } else {
            clearSDeviceUSBSerialNumber();
        }
        if (rhs.hasRouteGuidanceManeuverUpdate()) {
            setRouteGuidanceManeuverUpdate(rhs.getRouteGuidanceManeuverUpdate());
        } else {
            clearRouteGuidanceManeuverUpdate();
        }
    }
    return *this;
}

inline bool DiPORouteGuidanceManeuver2Status::operator == (const DiPORouteGuidanceManeuver2Status& rhs) const {
    return (((!hasSDeviceUSBSerialNumber() && !rhs.hasSDeviceUSBSerialNumber()) || getSDeviceUSBSerialNumber() == rhs.getSDeviceUSBSerialNumber()) &&
        ((!hasRouteGuidanceManeuverUpdate() && !rhs.hasRouteGuidanceManeuverUpdate()) || getRouteGuidanceManeuverUpdate() == rhs.getRouteGuidanceManeuverUpdate()));
}

inline bool DiPORouteGuidanceManeuver2Status::operator != (const DiPORouteGuidanceManeuver2Status& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPORouteGuidanceManeuver2Status::operator < (const DiPORouteGuidanceManeuver2Status& rhs) const {
    if (hasSDeviceUSBSerialNumber() || rhs.hasSDeviceUSBSerialNumber()) {
        if (getSDeviceUSBSerialNumber() < rhs.getSDeviceUSBSerialNumber()) return true;
        if (getSDeviceUSBSerialNumber() > rhs.getSDeviceUSBSerialNumber()) return false;
    }
    if (hasRouteGuidanceManeuverUpdate() || rhs.hasRouteGuidanceManeuverUpdate()) {
        if (getRouteGuidanceManeuverUpdate() < rhs.getRouteGuidanceManeuverUpdate()) return true;
        if (getRouteGuidanceManeuverUpdate() > rhs.getRouteGuidanceManeuverUpdate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPORouteGuidanceManeuver2Status::clone() {
    return new DiPORouteGuidanceManeuver2Status(*this);
}

inline bool DiPORouteGuidanceManeuver2Status::operator > (const DiPORouteGuidanceManeuver2Status& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPORouteGuidanceManeuver2Status::clear() {
    clearSDeviceUSBSerialNumber();
    clearRouteGuidanceManeuverUpdate();
}

inline void DiPORouteGuidanceManeuver2Status::clearSDeviceUSBSerialNumber() {
    if (hasSDeviceUSBSerialNumber()) {
         clear_has_sDeviceUSBSerialNumber();
        _sDeviceUSBSerialNumber.clear();
     }
}

inline bool DiPORouteGuidanceManeuver2Status::hasSDeviceUSBSerialNumber () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DiPORouteGuidanceManeuver2Status::getSDeviceUSBSerialNumber () const {
    return _sDeviceUSBSerialNumber;
}

inline ::std::string& DiPORouteGuidanceManeuver2Status::getSDeviceUSBSerialNumberMutable () {
    set_has_sDeviceUSBSerialNumber();
    return _sDeviceUSBSerialNumber;
}

inline void DiPORouteGuidanceManeuver2Status::setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber = sDeviceUSBSerialNumber_;
}

inline void DiPORouteGuidanceManeuver2Status::setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber.assign(sDeviceUSBSerialNumber_);
}

inline void DiPORouteGuidanceManeuver2Status::setSDeviceUSBSerialNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber.assign(value, size);
}

inline void DiPORouteGuidanceManeuver2Status::clearRouteGuidanceManeuverUpdate() {
    if (hasRouteGuidanceManeuverUpdate()) {
         clear_has_RouteGuidanceManeuverUpdate();
        _RouteGuidanceManeuverUpdate.clear();
     }
}

inline bool DiPORouteGuidanceManeuver2Status::hasRouteGuidanceManeuverUpdate () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverUpdate& DiPORouteGuidanceManeuver2Status::getRouteGuidanceManeuverUpdate () const {
    return _RouteGuidanceManeuverUpdate;
}

inline ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverUpdate& DiPORouteGuidanceManeuver2Status::getRouteGuidanceManeuverUpdateMutable () {
    set_has_RouteGuidanceManeuverUpdate();
    return _RouteGuidanceManeuverUpdate;
}

inline void DiPORouteGuidanceManeuver2Status::setRouteGuidanceManeuverUpdate (const ::mplay_appcontrol_fi_types::T_RouteGuidanceManeuverUpdate& RouteGuidanceManeuverUpdate_) {
    set_has_RouteGuidanceManeuverUpdate();
    this->_RouteGuidanceManeuverUpdate = RouteGuidanceManeuverUpdate_;
}

inline void DiPORouteGuidanceManeuver2Status::set_has_sDeviceUSBSerialNumber () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPORouteGuidanceManeuver2Status::clear_has_sDeviceUSBSerialNumber () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiPORouteGuidanceManeuver2Status::set_has_RouteGuidanceManeuverUpdate () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiPORouteGuidanceManeuver2Status::clear_has_RouteGuidanceManeuverUpdate () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DiPOBluetoothAudioDeviceStatusStatus::DiPOBluetoothAudioDeviceStatusStatus ()  :
    _bAudioDeviceStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPOBluetoothAudioDeviceStatusStatus::DiPOBluetoothAudioDeviceStatusStatus (const DiPOBluetoothAudioDeviceStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _bAudioDeviceStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPOBluetoothAudioDeviceStatusStatus::DiPOBluetoothAudioDeviceStatusStatus (bool bAudioDeviceStatus_)  :
    _bAudioDeviceStatus (bAudioDeviceStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPOBluetoothAudioDeviceStatusStatus::~DiPOBluetoothAudioDeviceStatusStatus() {
}

inline DiPOBluetoothAudioDeviceStatusStatus& DiPOBluetoothAudioDeviceStatusStatus::operator = (const DiPOBluetoothAudioDeviceStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBAudioDeviceStatus()) {
            setBAudioDeviceStatus(rhs.getBAudioDeviceStatus());
        } else {
            clearBAudioDeviceStatus();
        }
    }
    return *this;
}

inline bool DiPOBluetoothAudioDeviceStatusStatus::operator == (const DiPOBluetoothAudioDeviceStatusStatus& rhs) const {
    return (((!hasBAudioDeviceStatus() && !rhs.hasBAudioDeviceStatus()) || getBAudioDeviceStatus() == rhs.getBAudioDeviceStatus()));
}

inline bool DiPOBluetoothAudioDeviceStatusStatus::operator != (const DiPOBluetoothAudioDeviceStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPOBluetoothAudioDeviceStatusStatus::operator < (const DiPOBluetoothAudioDeviceStatusStatus& rhs) const {
    if (hasBAudioDeviceStatus() || rhs.hasBAudioDeviceStatus()) {
        if (getBAudioDeviceStatus() < rhs.getBAudioDeviceStatus()) return true;
        if (getBAudioDeviceStatus() > rhs.getBAudioDeviceStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPOBluetoothAudioDeviceStatusStatus::clone() {
    return new DiPOBluetoothAudioDeviceStatusStatus(*this);
}

inline bool DiPOBluetoothAudioDeviceStatusStatus::operator > (const DiPOBluetoothAudioDeviceStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPOBluetoothAudioDeviceStatusStatus::clear() {
    clearBAudioDeviceStatus();
}

inline void DiPOBluetoothAudioDeviceStatusStatus::clearBAudioDeviceStatus() {
    if (hasBAudioDeviceStatus()) {
         clear_has_bAudioDeviceStatus();
        _bAudioDeviceStatus = false;
     }
}

inline bool DiPOBluetoothAudioDeviceStatusStatus::hasBAudioDeviceStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DiPOBluetoothAudioDeviceStatusStatus::getBAudioDeviceStatus () const {
    return _bAudioDeviceStatus;
}

inline void DiPOBluetoothAudioDeviceStatusStatus::setBAudioDeviceStatus (bool bAudioDeviceStatus_) {
    set_has_bAudioDeviceStatus();
    this->_bAudioDeviceStatus = bAudioDeviceStatus_;
}

inline void DiPOBluetoothAudioDeviceStatusStatus::set_has_bAudioDeviceStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPOBluetoothAudioDeviceStatusStatus::clear_has_bAudioDeviceStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DiPODeviceTimeUpdateStatus::DiPODeviceTimeUpdateStatus ()  :
    _sDeviceUSBSerialNumber (),
    _DeviceTimeUpdate ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPODeviceTimeUpdateStatus::DiPODeviceTimeUpdateStatus (const DiPODeviceTimeUpdateStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _sDeviceUSBSerialNumber (),
    _DeviceTimeUpdate ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPODeviceTimeUpdateStatus::DiPODeviceTimeUpdateStatus (const ::std::string& sDeviceUSBSerialNumber_, const ::mplay_appcontrol_fi_types::T_DeviceTimeUpdate& DeviceTimeUpdate_)  :
    _sDeviceUSBSerialNumber (sDeviceUSBSerialNumber_),
    _DeviceTimeUpdate (DeviceTimeUpdate_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPODeviceTimeUpdateStatus::~DiPODeviceTimeUpdateStatus() {
}

inline DiPODeviceTimeUpdateStatus& DiPODeviceTimeUpdateStatus::operator = (const DiPODeviceTimeUpdateStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSDeviceUSBSerialNumber()) {
            setSDeviceUSBSerialNumber(rhs.getSDeviceUSBSerialNumber());
        } else {
            clearSDeviceUSBSerialNumber();
        }
        if (rhs.hasDeviceTimeUpdate()) {
            setDeviceTimeUpdate(rhs.getDeviceTimeUpdate());
        } else {
            clearDeviceTimeUpdate();
        }
    }
    return *this;
}

inline bool DiPODeviceTimeUpdateStatus::operator == (const DiPODeviceTimeUpdateStatus& rhs) const {
    return (((!hasSDeviceUSBSerialNumber() && !rhs.hasSDeviceUSBSerialNumber()) || getSDeviceUSBSerialNumber() == rhs.getSDeviceUSBSerialNumber()) &&
        ((!hasDeviceTimeUpdate() && !rhs.hasDeviceTimeUpdate()) || getDeviceTimeUpdate() == rhs.getDeviceTimeUpdate()));
}

inline bool DiPODeviceTimeUpdateStatus::operator != (const DiPODeviceTimeUpdateStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPODeviceTimeUpdateStatus::operator < (const DiPODeviceTimeUpdateStatus& rhs) const {
    if (hasSDeviceUSBSerialNumber() || rhs.hasSDeviceUSBSerialNumber()) {
        if (getSDeviceUSBSerialNumber() < rhs.getSDeviceUSBSerialNumber()) return true;
        if (getSDeviceUSBSerialNumber() > rhs.getSDeviceUSBSerialNumber()) return false;
    }
    if (hasDeviceTimeUpdate() || rhs.hasDeviceTimeUpdate()) {
        if (getDeviceTimeUpdate() < rhs.getDeviceTimeUpdate()) return true;
        if (getDeviceTimeUpdate() > rhs.getDeviceTimeUpdate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPODeviceTimeUpdateStatus::clone() {
    return new DiPODeviceTimeUpdateStatus(*this);
}

inline bool DiPODeviceTimeUpdateStatus::operator > (const DiPODeviceTimeUpdateStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPODeviceTimeUpdateStatus::clear() {
    clearSDeviceUSBSerialNumber();
    clearDeviceTimeUpdate();
}

inline void DiPODeviceTimeUpdateStatus::clearSDeviceUSBSerialNumber() {
    if (hasSDeviceUSBSerialNumber()) {
         clear_has_sDeviceUSBSerialNumber();
        _sDeviceUSBSerialNumber.clear();
     }
}

inline bool DiPODeviceTimeUpdateStatus::hasSDeviceUSBSerialNumber () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DiPODeviceTimeUpdateStatus::getSDeviceUSBSerialNumber () const {
    return _sDeviceUSBSerialNumber;
}

inline ::std::string& DiPODeviceTimeUpdateStatus::getSDeviceUSBSerialNumberMutable () {
    set_has_sDeviceUSBSerialNumber();
    return _sDeviceUSBSerialNumber;
}

inline void DiPODeviceTimeUpdateStatus::setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber = sDeviceUSBSerialNumber_;
}

inline void DiPODeviceTimeUpdateStatus::setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber.assign(sDeviceUSBSerialNumber_);
}

inline void DiPODeviceTimeUpdateStatus::setSDeviceUSBSerialNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber.assign(value, size);
}

inline void DiPODeviceTimeUpdateStatus::clearDeviceTimeUpdate() {
    if (hasDeviceTimeUpdate()) {
         clear_has_DeviceTimeUpdate();
        _DeviceTimeUpdate.clear();
     }
}

inline bool DiPODeviceTimeUpdateStatus::hasDeviceTimeUpdate () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::mplay_appcontrol_fi_types::T_DeviceTimeUpdate& DiPODeviceTimeUpdateStatus::getDeviceTimeUpdate () const {
    return _DeviceTimeUpdate;
}

inline ::mplay_appcontrol_fi_types::T_DeviceTimeUpdate& DiPODeviceTimeUpdateStatus::getDeviceTimeUpdateMutable () {
    set_has_DeviceTimeUpdate();
    return _DeviceTimeUpdate;
}

inline void DiPODeviceTimeUpdateStatus::setDeviceTimeUpdate (const ::mplay_appcontrol_fi_types::T_DeviceTimeUpdate& DeviceTimeUpdate_) {
    set_has_DeviceTimeUpdate();
    this->_DeviceTimeUpdate = DeviceTimeUpdate_;
}

inline void DiPODeviceTimeUpdateStatus::set_has_sDeviceUSBSerialNumber () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPODeviceTimeUpdateStatus::clear_has_sDeviceUSBSerialNumber () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiPODeviceTimeUpdateStatus::set_has_DeviceTimeUpdate () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiPODeviceTimeUpdateStatus::clear_has_DeviceTimeUpdate () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ConnectStart::ConnectStart ()  :
    _szDeviceId (),
    _szProtocol (),
    _szBundleSeedID (),
    _szAppName (),
    _e8AppLaunchOption (::mplay_appcontrol_fi_types::T_e8_AppLaunchOption__e8LAUNCH_WITH_USER_ALERT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConnectStart::ConnectStart (const ConnectStart &rhs)  :
    ::asf::core::Payload(rhs),
    _szDeviceId (),
    _szProtocol (),
    _szBundleSeedID (),
    _szAppName (),
    _e8AppLaunchOption (::mplay_appcontrol_fi_types::T_e8_AppLaunchOption__e8LAUNCH_WITH_USER_ALERT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConnectStart::ConnectStart (const ::std::string& szDeviceId_, const ::std::string& szProtocol_, const ::std::string& szBundleSeedID_, const ::std::string& szAppName_, ::mplay_appcontrol_fi_types::T_e8_AppLaunchOption e8AppLaunchOption_)  :
    _szDeviceId (szDeviceId_),
    _szProtocol (szProtocol_),
    _szBundleSeedID (szBundleSeedID_),
    _szAppName (szAppName_),
    _e8AppLaunchOption (e8AppLaunchOption_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szProtocol_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szBundleSeedID_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_AppLaunchOption_IsValid(e8AppLaunchOption_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AppLaunchOption_, "T_e8_AppLaunchOption", "e8AppLaunchOption", "ConnectStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConnectStart::~ConnectStart() {
}

inline ConnectStart& ConnectStart::operator = (const ConnectStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSzDeviceId()) {
            setSzDeviceId(rhs.getSzDeviceId());
        } else {
            clearSzDeviceId();
        }
        if (rhs.hasSzProtocol()) {
            setSzProtocol(rhs.getSzProtocol());
        } else {
            clearSzProtocol();
        }
        if (rhs.hasSzBundleSeedID()) {
            setSzBundleSeedID(rhs.getSzBundleSeedID());
        } else {
            clearSzBundleSeedID();
        }
        if (rhs.hasSzAppName()) {
            setSzAppName(rhs.getSzAppName());
        } else {
            clearSzAppName();
        }
        if (rhs.hasE8AppLaunchOption()) {
            setE8AppLaunchOption(rhs.getE8AppLaunchOption());
        } else {
            clearE8AppLaunchOption();
        }
    }
    return *this;
}

inline bool ConnectStart::operator == (const ConnectStart& rhs) const {
    return (((!hasSzDeviceId() && !rhs.hasSzDeviceId()) || getSzDeviceId() == rhs.getSzDeviceId()) &&
        ((!hasSzProtocol() && !rhs.hasSzProtocol()) || getSzProtocol() == rhs.getSzProtocol()) &&
        ((!hasSzBundleSeedID() && !rhs.hasSzBundleSeedID()) || getSzBundleSeedID() == rhs.getSzBundleSeedID()) &&
        ((!hasSzAppName() && !rhs.hasSzAppName()) || getSzAppName() == rhs.getSzAppName()) &&
        ((!hasE8AppLaunchOption() && !rhs.hasE8AppLaunchOption()) || getE8AppLaunchOption() == rhs.getE8AppLaunchOption()));
}

inline bool ConnectStart::operator != (const ConnectStart& rhs) const {
    return ! (*this == rhs);
}

inline bool ConnectStart::operator < (const ConnectStart& rhs) const {
    if (hasSzDeviceId() || rhs.hasSzDeviceId()) {
        if (getSzDeviceId() < rhs.getSzDeviceId()) return true;
        if (getSzDeviceId() > rhs.getSzDeviceId()) return false;
    }
    if (hasSzProtocol() || rhs.hasSzProtocol()) {
        if (getSzProtocol() < rhs.getSzProtocol()) return true;
        if (getSzProtocol() > rhs.getSzProtocol()) return false;
    }
    if (hasSzBundleSeedID() || rhs.hasSzBundleSeedID()) {
        if (getSzBundleSeedID() < rhs.getSzBundleSeedID()) return true;
        if (getSzBundleSeedID() > rhs.getSzBundleSeedID()) return false;
    }
    if (hasSzAppName() || rhs.hasSzAppName()) {
        if (getSzAppName() < rhs.getSzAppName()) return true;
        if (getSzAppName() > rhs.getSzAppName()) return false;
    }
    if (hasE8AppLaunchOption() || rhs.hasE8AppLaunchOption()) {
        if ((uint32)getE8AppLaunchOption() < (uint32)rhs.getE8AppLaunchOption()) return true;
        if ((uint32)getE8AppLaunchOption() > (uint32)rhs.getE8AppLaunchOption()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConnectStart::clone() {
    return new ConnectStart(*this);
}

inline bool ConnectStart::operator > (const ConnectStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConnectStart::clear() {
    clearSzDeviceId();
    clearSzProtocol();
    clearSzBundleSeedID();
    clearSzAppName();
    clearE8AppLaunchOption();
}

inline void ConnectStart::clearSzDeviceId() {
    if (hasSzDeviceId()) {
         clear_has_szDeviceId();
        _szDeviceId.clear();
     }
}

inline bool ConnectStart::hasSzDeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ConnectStart::getSzDeviceId () const {
    return _szDeviceId;
}

inline ::std::string& ConnectStart::getSzDeviceIdMutable () {
    set_has_szDeviceId();
    return _szDeviceId;
}

inline void ConnectStart::setSzDeviceId (const ::std::string& szDeviceId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId = szDeviceId_;
}

inline void ConnectStart::setSzDeviceId (const char* szDeviceId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId.assign(szDeviceId_);
}

inline void ConnectStart::setSzDeviceId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId.assign(value, size);
}

inline void ConnectStart::clearSzProtocol() {
    if (hasSzProtocol()) {
         clear_has_szProtocol();
        _szProtocol.clear();
     }
}

inline bool ConnectStart::hasSzProtocol () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& ConnectStart::getSzProtocol () const {
    return _szProtocol;
}

inline ::std::string& ConnectStart::getSzProtocolMutable () {
    set_has_szProtocol();
    return _szProtocol;
}

inline void ConnectStart::setSzProtocol (const ::std::string& szProtocol_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szProtocol_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szProtocol();
    this->_szProtocol = szProtocol_;
}

inline void ConnectStart::setSzProtocol (const char* szProtocol_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szProtocol_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szProtocol();
    this->_szProtocol.assign(szProtocol_);
}

inline void ConnectStart::setSzProtocol (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szProtocol();
    this->_szProtocol.assign(value, size);
}

inline void ConnectStart::clearSzBundleSeedID() {
    if (hasSzBundleSeedID()) {
         clear_has_szBundleSeedID();
        _szBundleSeedID.clear();
     }
}

inline bool ConnectStart::hasSzBundleSeedID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& ConnectStart::getSzBundleSeedID () const {
    return _szBundleSeedID;
}

inline ::std::string& ConnectStart::getSzBundleSeedIDMutable () {
    set_has_szBundleSeedID();
    return _szBundleSeedID;
}

inline void ConnectStart::setSzBundleSeedID (const ::std::string& szBundleSeedID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szBundleSeedID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szBundleSeedID();
    this->_szBundleSeedID = szBundleSeedID_;
}

inline void ConnectStart::setSzBundleSeedID (const char* szBundleSeedID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szBundleSeedID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szBundleSeedID();
    this->_szBundleSeedID.assign(szBundleSeedID_);
}

inline void ConnectStart::setSzBundleSeedID (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szBundleSeedID();
    this->_szBundleSeedID.assign(value, size);
}

inline void ConnectStart::clearSzAppName() {
    if (hasSzAppName()) {
         clear_has_szAppName();
        _szAppName.clear();
     }
}

inline bool ConnectStart::hasSzAppName () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& ConnectStart::getSzAppName () const {
    return _szAppName;
}

inline ::std::string& ConnectStart::getSzAppNameMutable () {
    set_has_szAppName();
    return _szAppName;
}

inline void ConnectStart::setSzAppName (const ::std::string& szAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName = szAppName_;
}

inline void ConnectStart::setSzAppName (const char* szAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName.assign(szAppName_);
}

inline void ConnectStart::setSzAppName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName.assign(value, size);
}

inline void ConnectStart::clearE8AppLaunchOption() {
    if (hasE8AppLaunchOption()) {
         clear_has_e8AppLaunchOption();
        _e8AppLaunchOption = ::mplay_appcontrol_fi_types::T_e8_AppLaunchOption__e8LAUNCH_WITH_USER_ALERT;
     }
}

inline bool ConnectStart::hasE8AppLaunchOption () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline ::mplay_appcontrol_fi_types::T_e8_AppLaunchOption ConnectStart::getE8AppLaunchOption () const {
    return _e8AppLaunchOption;
}

inline void ConnectStart::setE8AppLaunchOption (::mplay_appcontrol_fi_types::T_e8_AppLaunchOption e8AppLaunchOption_) {
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_AppLaunchOption_IsValid(e8AppLaunchOption_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AppLaunchOption_, "T_e8_AppLaunchOption", "e8AppLaunchOption", "ConnectStart");
    }
    #endif
    set_has_e8AppLaunchOption();
    this->_e8AppLaunchOption = e8AppLaunchOption_;
}

inline void ConnectStart::set_has_szDeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConnectStart::clear_has_szDeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ConnectStart::set_has_szProtocol () {
    _has_bits_[0] |= 1u << 1;
}

inline void ConnectStart::clear_has_szProtocol () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ConnectStart::set_has_szBundleSeedID () {
    _has_bits_[0] |= 1u << 2;
}

inline void ConnectStart::clear_has_szBundleSeedID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ConnectStart::set_has_szAppName () {
    _has_bits_[0] |= 1u << 3;
}

inline void ConnectStart::clear_has_szAppName () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void ConnectStart::set_has_e8AppLaunchOption () {
    _has_bits_[0] |= 1u << 4;
}

inline void ConnectStart::clear_has_e8AppLaunchOption () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  ConnectResult::ConnectResult ()  :
    _szDeviceId (),
    _u16SessionId (0u),
    _szAppName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConnectResult::ConnectResult (const ConnectResult &rhs)  :
    ::asf::core::Payload(rhs),
    _szDeviceId (),
    _u16SessionId (0u),
    _szAppName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConnectResult::ConnectResult (const ::std::string& szDeviceId_, uint16 u16SessionId_, const ::std::string& szAppName_)  :
    _szDeviceId (szDeviceId_),
    _u16SessionId (u16SessionId_),
    _szAppName (szAppName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConnectResult::~ConnectResult() {
}

inline ConnectResult& ConnectResult::operator = (const ConnectResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSzDeviceId()) {
            setSzDeviceId(rhs.getSzDeviceId());
        } else {
            clearSzDeviceId();
        }
        if (rhs.hasU16SessionId()) {
            setU16SessionId(rhs.getU16SessionId());
        } else {
            clearU16SessionId();
        }
        if (rhs.hasSzAppName()) {
            setSzAppName(rhs.getSzAppName());
        } else {
            clearSzAppName();
        }
    }
    return *this;
}

inline bool ConnectResult::operator == (const ConnectResult& rhs) const {
    return (((!hasSzDeviceId() && !rhs.hasSzDeviceId()) || getSzDeviceId() == rhs.getSzDeviceId()) &&
        ((!hasU16SessionId() && !rhs.hasU16SessionId()) || getU16SessionId() == rhs.getU16SessionId()) &&
        ((!hasSzAppName() && !rhs.hasSzAppName()) || getSzAppName() == rhs.getSzAppName()));
}

inline bool ConnectResult::operator != (const ConnectResult& rhs) const {
    return ! (*this == rhs);
}

inline bool ConnectResult::operator < (const ConnectResult& rhs) const {
    if (hasSzDeviceId() || rhs.hasSzDeviceId()) {
        if (getSzDeviceId() < rhs.getSzDeviceId()) return true;
        if (getSzDeviceId() > rhs.getSzDeviceId()) return false;
    }
    if (hasU16SessionId() || rhs.hasU16SessionId()) {
        if (getU16SessionId() < rhs.getU16SessionId()) return true;
        if (getU16SessionId() > rhs.getU16SessionId()) return false;
    }
    if (hasSzAppName() || rhs.hasSzAppName()) {
        if (getSzAppName() < rhs.getSzAppName()) return true;
        if (getSzAppName() > rhs.getSzAppName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConnectResult::clone() {
    return new ConnectResult(*this);
}

inline bool ConnectResult::operator > (const ConnectResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConnectResult::clear() {
    clearSzDeviceId();
    clearU16SessionId();
    clearSzAppName();
}

inline void ConnectResult::clearSzDeviceId() {
    if (hasSzDeviceId()) {
         clear_has_szDeviceId();
        _szDeviceId.clear();
     }
}

inline bool ConnectResult::hasSzDeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ConnectResult::getSzDeviceId () const {
    return _szDeviceId;
}

inline ::std::string& ConnectResult::getSzDeviceIdMutable () {
    set_has_szDeviceId();
    return _szDeviceId;
}

inline void ConnectResult::setSzDeviceId (const ::std::string& szDeviceId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId = szDeviceId_;
}

inline void ConnectResult::setSzDeviceId (const char* szDeviceId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId.assign(szDeviceId_);
}

inline void ConnectResult::setSzDeviceId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId.assign(value, size);
}

inline void ConnectResult::clearU16SessionId() {
    if (hasU16SessionId()) {
         clear_has_u16SessionId();
        _u16SessionId = 0u;
     }
}

inline bool ConnectResult::hasU16SessionId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 ConnectResult::getU16SessionId () const {
    return _u16SessionId;
}

inline void ConnectResult::setU16SessionId (uint16 u16SessionId_) {
    set_has_u16SessionId();
    this->_u16SessionId = u16SessionId_;
}

inline void ConnectResult::clearSzAppName() {
    if (hasSzAppName()) {
         clear_has_szAppName();
        _szAppName.clear();
     }
}

inline bool ConnectResult::hasSzAppName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& ConnectResult::getSzAppName () const {
    return _szAppName;
}

inline ::std::string& ConnectResult::getSzAppNameMutable () {
    set_has_szAppName();
    return _szAppName;
}

inline void ConnectResult::setSzAppName (const ::std::string& szAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName = szAppName_;
}

inline void ConnectResult::setSzAppName (const char* szAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName.assign(szAppName_);
}

inline void ConnectResult::setSzAppName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName.assign(value, size);
}

inline void ConnectResult::set_has_szDeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConnectResult::clear_has_szDeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ConnectResult::set_has_u16SessionId () {
    _has_bits_[0] |= 1u << 1;
}

inline void ConnectResult::clear_has_u16SessionId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ConnectResult::set_has_szAppName () {
    _has_bits_[0] |= 1u << 2;
}

inline void ConnectResult::clear_has_szAppName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  CommandStart::CommandStart ()  :
    _szDeviceId (),
    _szAppName (),
    _u16SessionId (0u),
    _au8CommandBuffer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CommandStart::CommandStart (const CommandStart &rhs)  :
    ::asf::core::Payload(rhs),
    _szDeviceId (),
    _szAppName (),
    _u16SessionId (0u),
    _au8CommandBuffer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CommandStart::CommandStart (const ::std::string& szDeviceId_, const ::std::string& szAppName_, uint16 u16SessionId_, const ::asf::core::Blob& au8CommandBuffer_)  :
    _szDeviceId (szDeviceId_),
    _szAppName (szAppName_),
    _u16SessionId (u16SessionId_),
    _au8CommandBuffer (au8CommandBuffer_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CommandStart::~CommandStart() {
}

inline CommandStart& CommandStart::operator = (const CommandStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSzDeviceId()) {
            setSzDeviceId(rhs.getSzDeviceId());
        } else {
            clearSzDeviceId();
        }
        if (rhs.hasSzAppName()) {
            setSzAppName(rhs.getSzAppName());
        } else {
            clearSzAppName();
        }
        if (rhs.hasU16SessionId()) {
            setU16SessionId(rhs.getU16SessionId());
        } else {
            clearU16SessionId();
        }
        if (rhs.hasAu8CommandBuffer()) {
            setAu8CommandBuffer(rhs.getAu8CommandBuffer());
        } else {
            clearAu8CommandBuffer();
        }
    }
    return *this;
}

inline bool CommandStart::operator == (const CommandStart& rhs) const {
    return (((!hasSzDeviceId() && !rhs.hasSzDeviceId()) || getSzDeviceId() == rhs.getSzDeviceId()) &&
        ((!hasSzAppName() && !rhs.hasSzAppName()) || getSzAppName() == rhs.getSzAppName()) &&
        ((!hasU16SessionId() && !rhs.hasU16SessionId()) || getU16SessionId() == rhs.getU16SessionId()) &&
        ((!hasAu8CommandBuffer() && !rhs.hasAu8CommandBuffer()) || getAu8CommandBuffer() == rhs.getAu8CommandBuffer()));
}

inline bool CommandStart::operator != (const CommandStart& rhs) const {
    return ! (*this == rhs);
}

inline bool CommandStart::operator < (const CommandStart& rhs) const {
    if (hasSzDeviceId() || rhs.hasSzDeviceId()) {
        if (getSzDeviceId() < rhs.getSzDeviceId()) return true;
        if (getSzDeviceId() > rhs.getSzDeviceId()) return false;
    }
    if (hasSzAppName() || rhs.hasSzAppName()) {
        if (getSzAppName() < rhs.getSzAppName()) return true;
        if (getSzAppName() > rhs.getSzAppName()) return false;
    }
    if (hasU16SessionId() || rhs.hasU16SessionId()) {
        if (getU16SessionId() < rhs.getU16SessionId()) return true;
        if (getU16SessionId() > rhs.getU16SessionId()) return false;
    }
    if (hasAu8CommandBuffer() || rhs.hasAu8CommandBuffer()) {
        if (getAu8CommandBuffer() < rhs.getAu8CommandBuffer()) return true;
        if (getAu8CommandBuffer() > rhs.getAu8CommandBuffer()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CommandStart::clone() {
    return new CommandStart(*this);
}

inline bool CommandStart::operator > (const CommandStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CommandStart::clear() {
    clearSzDeviceId();
    clearSzAppName();
    clearU16SessionId();
    clearAu8CommandBuffer();
}

inline void CommandStart::clearSzDeviceId() {
    if (hasSzDeviceId()) {
         clear_has_szDeviceId();
        _szDeviceId.clear();
     }
}

inline bool CommandStart::hasSzDeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& CommandStart::getSzDeviceId () const {
    return _szDeviceId;
}

inline ::std::string& CommandStart::getSzDeviceIdMutable () {
    set_has_szDeviceId();
    return _szDeviceId;
}

inline void CommandStart::setSzDeviceId (const ::std::string& szDeviceId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId = szDeviceId_;
}

inline void CommandStart::setSzDeviceId (const char* szDeviceId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId.assign(szDeviceId_);
}

inline void CommandStart::setSzDeviceId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId.assign(value, size);
}

inline void CommandStart::clearSzAppName() {
    if (hasSzAppName()) {
         clear_has_szAppName();
        _szAppName.clear();
     }
}

inline bool CommandStart::hasSzAppName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& CommandStart::getSzAppName () const {
    return _szAppName;
}

inline ::std::string& CommandStart::getSzAppNameMutable () {
    set_has_szAppName();
    return _szAppName;
}

inline void CommandStart::setSzAppName (const ::std::string& szAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName = szAppName_;
}

inline void CommandStart::setSzAppName (const char* szAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName.assign(szAppName_);
}

inline void CommandStart::setSzAppName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName.assign(value, size);
}

inline void CommandStart::clearU16SessionId() {
    if (hasU16SessionId()) {
         clear_has_u16SessionId();
        _u16SessionId = 0u;
     }
}

inline bool CommandStart::hasU16SessionId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 CommandStart::getU16SessionId () const {
    return _u16SessionId;
}

inline void CommandStart::setU16SessionId (uint16 u16SessionId_) {
    set_has_u16SessionId();
    this->_u16SessionId = u16SessionId_;
}

inline void CommandStart::clearAu8CommandBuffer() {
    if (hasAu8CommandBuffer()) {
         clear_has_au8CommandBuffer();
        _au8CommandBuffer = ::asf::core::theEmptyBlob;
     }
}

inline bool CommandStart::hasAu8CommandBuffer () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::asf::core::Blob& CommandStart::getAu8CommandBuffer () const {
    return _au8CommandBuffer;
}

inline ::asf::core::Blob& CommandStart::getAu8CommandBufferMutable () {
    set_has_au8CommandBuffer();
    return _au8CommandBuffer;
}

inline void CommandStart::setAu8CommandBuffer (const ::asf::core::Blob& au8CommandBuffer_) {
    set_has_au8CommandBuffer();
    this->_au8CommandBuffer = au8CommandBuffer_;
}

inline void CommandStart::set_has_szDeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void CommandStart::clear_has_szDeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CommandStart::set_has_szAppName () {
    _has_bits_[0] |= 1u << 1;
}

inline void CommandStart::clear_has_szAppName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void CommandStart::set_has_u16SessionId () {
    _has_bits_[0] |= 1u << 2;
}

inline void CommandStart::clear_has_u16SessionId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void CommandStart::set_has_au8CommandBuffer () {
    _has_bits_[0] |= 1u << 3;
}

inline void CommandStart::clear_has_au8CommandBuffer () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  CommandResult::CommandResult ()  :
    _szDeviceId (),
    _szAppName (),
    _u16SessionId (0u),
    _au8CommandResponseBuffer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CommandResult::CommandResult (const CommandResult &rhs)  :
    ::asf::core::Payload(rhs),
    _szDeviceId (),
    _szAppName (),
    _u16SessionId (0u),
    _au8CommandResponseBuffer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CommandResult::CommandResult (const ::std::string& szDeviceId_, const ::std::string& szAppName_, uint16 u16SessionId_, const ::asf::core::Blob& au8CommandResponseBuffer_)  :
    _szDeviceId (szDeviceId_),
    _szAppName (szAppName_),
    _u16SessionId (u16SessionId_),
    _au8CommandResponseBuffer (au8CommandResponseBuffer_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CommandResult::~CommandResult() {
}

inline CommandResult& CommandResult::operator = (const CommandResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSzDeviceId()) {
            setSzDeviceId(rhs.getSzDeviceId());
        } else {
            clearSzDeviceId();
        }
        if (rhs.hasSzAppName()) {
            setSzAppName(rhs.getSzAppName());
        } else {
            clearSzAppName();
        }
        if (rhs.hasU16SessionId()) {
            setU16SessionId(rhs.getU16SessionId());
        } else {
            clearU16SessionId();
        }
        if (rhs.hasAu8CommandResponseBuffer()) {
            setAu8CommandResponseBuffer(rhs.getAu8CommandResponseBuffer());
        } else {
            clearAu8CommandResponseBuffer();
        }
    }
    return *this;
}

inline bool CommandResult::operator == (const CommandResult& rhs) const {
    return (((!hasSzDeviceId() && !rhs.hasSzDeviceId()) || getSzDeviceId() == rhs.getSzDeviceId()) &&
        ((!hasSzAppName() && !rhs.hasSzAppName()) || getSzAppName() == rhs.getSzAppName()) &&
        ((!hasU16SessionId() && !rhs.hasU16SessionId()) || getU16SessionId() == rhs.getU16SessionId()) &&
        ((!hasAu8CommandResponseBuffer() && !rhs.hasAu8CommandResponseBuffer()) || getAu8CommandResponseBuffer() == rhs.getAu8CommandResponseBuffer()));
}

inline bool CommandResult::operator != (const CommandResult& rhs) const {
    return ! (*this == rhs);
}

inline bool CommandResult::operator < (const CommandResult& rhs) const {
    if (hasSzDeviceId() || rhs.hasSzDeviceId()) {
        if (getSzDeviceId() < rhs.getSzDeviceId()) return true;
        if (getSzDeviceId() > rhs.getSzDeviceId()) return false;
    }
    if (hasSzAppName() || rhs.hasSzAppName()) {
        if (getSzAppName() < rhs.getSzAppName()) return true;
        if (getSzAppName() > rhs.getSzAppName()) return false;
    }
    if (hasU16SessionId() || rhs.hasU16SessionId()) {
        if (getU16SessionId() < rhs.getU16SessionId()) return true;
        if (getU16SessionId() > rhs.getU16SessionId()) return false;
    }
    if (hasAu8CommandResponseBuffer() || rhs.hasAu8CommandResponseBuffer()) {
        if (getAu8CommandResponseBuffer() < rhs.getAu8CommandResponseBuffer()) return true;
        if (getAu8CommandResponseBuffer() > rhs.getAu8CommandResponseBuffer()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CommandResult::clone() {
    return new CommandResult(*this);
}

inline bool CommandResult::operator > (const CommandResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CommandResult::clear() {
    clearSzDeviceId();
    clearSzAppName();
    clearU16SessionId();
    clearAu8CommandResponseBuffer();
}

inline void CommandResult::clearSzDeviceId() {
    if (hasSzDeviceId()) {
         clear_has_szDeviceId();
        _szDeviceId.clear();
     }
}

inline bool CommandResult::hasSzDeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& CommandResult::getSzDeviceId () const {
    return _szDeviceId;
}

inline ::std::string& CommandResult::getSzDeviceIdMutable () {
    set_has_szDeviceId();
    return _szDeviceId;
}

inline void CommandResult::setSzDeviceId (const ::std::string& szDeviceId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId = szDeviceId_;
}

inline void CommandResult::setSzDeviceId (const char* szDeviceId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId.assign(szDeviceId_);
}

inline void CommandResult::setSzDeviceId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId.assign(value, size);
}

inline void CommandResult::clearSzAppName() {
    if (hasSzAppName()) {
         clear_has_szAppName();
        _szAppName.clear();
     }
}

inline bool CommandResult::hasSzAppName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& CommandResult::getSzAppName () const {
    return _szAppName;
}

inline ::std::string& CommandResult::getSzAppNameMutable () {
    set_has_szAppName();
    return _szAppName;
}

inline void CommandResult::setSzAppName (const ::std::string& szAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName = szAppName_;
}

inline void CommandResult::setSzAppName (const char* szAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName.assign(szAppName_);
}

inline void CommandResult::setSzAppName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName.assign(value, size);
}

inline void CommandResult::clearU16SessionId() {
    if (hasU16SessionId()) {
         clear_has_u16SessionId();
        _u16SessionId = 0u;
     }
}

inline bool CommandResult::hasU16SessionId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 CommandResult::getU16SessionId () const {
    return _u16SessionId;
}

inline void CommandResult::setU16SessionId (uint16 u16SessionId_) {
    set_has_u16SessionId();
    this->_u16SessionId = u16SessionId_;
}

inline void CommandResult::clearAu8CommandResponseBuffer() {
    if (hasAu8CommandResponseBuffer()) {
         clear_has_au8CommandResponseBuffer();
        _au8CommandResponseBuffer = ::asf::core::theEmptyBlob;
     }
}

inline bool CommandResult::hasAu8CommandResponseBuffer () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::asf::core::Blob& CommandResult::getAu8CommandResponseBuffer () const {
    return _au8CommandResponseBuffer;
}

inline ::asf::core::Blob& CommandResult::getAu8CommandResponseBufferMutable () {
    set_has_au8CommandResponseBuffer();
    return _au8CommandResponseBuffer;
}

inline void CommandResult::setAu8CommandResponseBuffer (const ::asf::core::Blob& au8CommandResponseBuffer_) {
    set_has_au8CommandResponseBuffer();
    this->_au8CommandResponseBuffer = au8CommandResponseBuffer_;
}

inline void CommandResult::set_has_szDeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void CommandResult::clear_has_szDeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CommandResult::set_has_szAppName () {
    _has_bits_[0] |= 1u << 1;
}

inline void CommandResult::clear_has_szAppName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void CommandResult::set_has_u16SessionId () {
    _has_bits_[0] |= 1u << 2;
}

inline void CommandResult::clear_has_u16SessionId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void CommandResult::set_has_au8CommandResponseBuffer () {
    _has_bits_[0] |= 1u << 3;
}

inline void CommandResult::clear_has_au8CommandResponseBuffer () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  CloseStart::CloseStart ()  :
    _szDeviceId (),
    _szAppName (),
    _u16SessionId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CloseStart::CloseStart (const CloseStart &rhs)  :
    ::asf::core::Payload(rhs),
    _szDeviceId (),
    _szAppName (),
    _u16SessionId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CloseStart::CloseStart (const ::std::string& szDeviceId_, const ::std::string& szAppName_, uint16 u16SessionId_)  :
    _szDeviceId (szDeviceId_),
    _szAppName (szAppName_),
    _u16SessionId (u16SessionId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CloseStart::~CloseStart() {
}

inline CloseStart& CloseStart::operator = (const CloseStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSzDeviceId()) {
            setSzDeviceId(rhs.getSzDeviceId());
        } else {
            clearSzDeviceId();
        }
        if (rhs.hasSzAppName()) {
            setSzAppName(rhs.getSzAppName());
        } else {
            clearSzAppName();
        }
        if (rhs.hasU16SessionId()) {
            setU16SessionId(rhs.getU16SessionId());
        } else {
            clearU16SessionId();
        }
    }
    return *this;
}

inline bool CloseStart::operator == (const CloseStart& rhs) const {
    return (((!hasSzDeviceId() && !rhs.hasSzDeviceId()) || getSzDeviceId() == rhs.getSzDeviceId()) &&
        ((!hasSzAppName() && !rhs.hasSzAppName()) || getSzAppName() == rhs.getSzAppName()) &&
        ((!hasU16SessionId() && !rhs.hasU16SessionId()) || getU16SessionId() == rhs.getU16SessionId()));
}

inline bool CloseStart::operator != (const CloseStart& rhs) const {
    return ! (*this == rhs);
}

inline bool CloseStart::operator < (const CloseStart& rhs) const {
    if (hasSzDeviceId() || rhs.hasSzDeviceId()) {
        if (getSzDeviceId() < rhs.getSzDeviceId()) return true;
        if (getSzDeviceId() > rhs.getSzDeviceId()) return false;
    }
    if (hasSzAppName() || rhs.hasSzAppName()) {
        if (getSzAppName() < rhs.getSzAppName()) return true;
        if (getSzAppName() > rhs.getSzAppName()) return false;
    }
    if (hasU16SessionId() || rhs.hasU16SessionId()) {
        if (getU16SessionId() < rhs.getU16SessionId()) return true;
        if (getU16SessionId() > rhs.getU16SessionId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CloseStart::clone() {
    return new CloseStart(*this);
}

inline bool CloseStart::operator > (const CloseStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CloseStart::clear() {
    clearSzDeviceId();
    clearSzAppName();
    clearU16SessionId();
}

inline void CloseStart::clearSzDeviceId() {
    if (hasSzDeviceId()) {
         clear_has_szDeviceId();
        _szDeviceId.clear();
     }
}

inline bool CloseStart::hasSzDeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& CloseStart::getSzDeviceId () const {
    return _szDeviceId;
}

inline ::std::string& CloseStart::getSzDeviceIdMutable () {
    set_has_szDeviceId();
    return _szDeviceId;
}

inline void CloseStart::setSzDeviceId (const ::std::string& szDeviceId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId = szDeviceId_;
}

inline void CloseStart::setSzDeviceId (const char* szDeviceId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId.assign(szDeviceId_);
}

inline void CloseStart::setSzDeviceId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId.assign(value, size);
}

inline void CloseStart::clearSzAppName() {
    if (hasSzAppName()) {
         clear_has_szAppName();
        _szAppName.clear();
     }
}

inline bool CloseStart::hasSzAppName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& CloseStart::getSzAppName () const {
    return _szAppName;
}

inline ::std::string& CloseStart::getSzAppNameMutable () {
    set_has_szAppName();
    return _szAppName;
}

inline void CloseStart::setSzAppName (const ::std::string& szAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName = szAppName_;
}

inline void CloseStart::setSzAppName (const char* szAppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szAppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName.assign(szAppName_);
}

inline void CloseStart::setSzAppName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szAppName();
    this->_szAppName.assign(value, size);
}

inline void CloseStart::clearU16SessionId() {
    if (hasU16SessionId()) {
         clear_has_u16SessionId();
        _u16SessionId = 0u;
     }
}

inline bool CloseStart::hasU16SessionId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 CloseStart::getU16SessionId () const {
    return _u16SessionId;
}

inline void CloseStart::setU16SessionId (uint16 u16SessionId_) {
    set_has_u16SessionId();
    this->_u16SessionId = u16SessionId_;
}

inline void CloseStart::set_has_szDeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void CloseStart::clear_has_szDeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CloseStart::set_has_szAppName () {
    _has_bits_[0] |= 1u << 1;
}

inline void CloseStart::clear_has_szAppName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void CloseStart::set_has_u16SessionId () {
    _has_bits_[0] |= 1u << 2;
}

inline void CloseStart::clear_has_u16SessionId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  StartAudioStart::StartAudioStart ()  :
    _szDeviceId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartAudioStart::StartAudioStart (const StartAudioStart &rhs)  :
    ::asf::core::Payload(rhs),
    _szDeviceId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartAudioStart::StartAudioStart (const ::std::string& szDeviceId_)  :
    _szDeviceId (szDeviceId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartAudioStart::~StartAudioStart() {
}

inline StartAudioStart& StartAudioStart::operator = (const StartAudioStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSzDeviceId()) {
            setSzDeviceId(rhs.getSzDeviceId());
        } else {
            clearSzDeviceId();
        }
    }
    return *this;
}

inline bool StartAudioStart::operator == (const StartAudioStart& rhs) const {
    return (((!hasSzDeviceId() && !rhs.hasSzDeviceId()) || getSzDeviceId() == rhs.getSzDeviceId()));
}

inline bool StartAudioStart::operator != (const StartAudioStart& rhs) const {
    return ! (*this == rhs);
}

inline bool StartAudioStart::operator < (const StartAudioStart& rhs) const {
    if (hasSzDeviceId() || rhs.hasSzDeviceId()) {
        if (getSzDeviceId() < rhs.getSzDeviceId()) return true;
        if (getSzDeviceId() > rhs.getSzDeviceId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartAudioStart::clone() {
    return new StartAudioStart(*this);
}

inline bool StartAudioStart::operator > (const StartAudioStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartAudioStart::clear() {
    clearSzDeviceId();
}

inline void StartAudioStart::clearSzDeviceId() {
    if (hasSzDeviceId()) {
         clear_has_szDeviceId();
        _szDeviceId.clear();
     }
}

inline bool StartAudioStart::hasSzDeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StartAudioStart::getSzDeviceId () const {
    return _szDeviceId;
}

inline ::std::string& StartAudioStart::getSzDeviceIdMutable () {
    set_has_szDeviceId();
    return _szDeviceId;
}

inline void StartAudioStart::setSzDeviceId (const ::std::string& szDeviceId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId = szDeviceId_;
}

inline void StartAudioStart::setSzDeviceId (const char* szDeviceId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId.assign(szDeviceId_);
}

inline void StartAudioStart::setSzDeviceId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId.assign(value, size);
}

inline void StartAudioStart::set_has_szDeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartAudioStart::clear_has_szDeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StopAudioStart::StopAudioStart ()  :
    _szDeviceId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StopAudioStart::StopAudioStart (const StopAudioStart &rhs)  :
    ::asf::core::Payload(rhs),
    _szDeviceId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StopAudioStart::StopAudioStart (const ::std::string& szDeviceId_)  :
    _szDeviceId (szDeviceId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StopAudioStart::~StopAudioStart() {
}

inline StopAudioStart& StopAudioStart::operator = (const StopAudioStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSzDeviceId()) {
            setSzDeviceId(rhs.getSzDeviceId());
        } else {
            clearSzDeviceId();
        }
    }
    return *this;
}

inline bool StopAudioStart::operator == (const StopAudioStart& rhs) const {
    return (((!hasSzDeviceId() && !rhs.hasSzDeviceId()) || getSzDeviceId() == rhs.getSzDeviceId()));
}

inline bool StopAudioStart::operator != (const StopAudioStart& rhs) const {
    return ! (*this == rhs);
}

inline bool StopAudioStart::operator < (const StopAudioStart& rhs) const {
    if (hasSzDeviceId() || rhs.hasSzDeviceId()) {
        if (getSzDeviceId() < rhs.getSzDeviceId()) return true;
        if (getSzDeviceId() > rhs.getSzDeviceId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StopAudioStart::clone() {
    return new StopAudioStart(*this);
}

inline bool StopAudioStart::operator > (const StopAudioStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StopAudioStart::clear() {
    clearSzDeviceId();
}

inline void StopAudioStart::clearSzDeviceId() {
    if (hasSzDeviceId()) {
         clear_has_szDeviceId();
        _szDeviceId.clear();
     }
}

inline bool StopAudioStart::hasSzDeviceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StopAudioStart::getSzDeviceId () const {
    return _szDeviceId;
}

inline ::std::string& StopAudioStart::getSzDeviceIdMutable () {
    set_has_szDeviceId();
    return _szDeviceId;
}

inline void StopAudioStart::setSzDeviceId (const ::std::string& szDeviceId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId = szDeviceId_;
}

inline void StopAudioStart::setSzDeviceId (const char* szDeviceId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szDeviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId.assign(szDeviceId_);
}

inline void StopAudioStart::setSzDeviceId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szDeviceId();
    this->_szDeviceId.assign(value, size);
}

inline void StopAudioStart::set_has_szDeviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void StopAudioStart::clear_has_szDeviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DiPOActiveDeviceStart::DiPOActiveDeviceStart ()  :
    _u8DeviceTag (0u),
    _bDiPOActive (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPOActiveDeviceStart::DiPOActiveDeviceStart (const DiPOActiveDeviceStart &rhs)  :
    ::asf::core::Payload(rhs),
    _u8DeviceTag (0u),
    _bDiPOActive (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPOActiveDeviceStart::DiPOActiveDeviceStart (uint8 u8DeviceTag_, bool bDiPOActive_)  :
    _u8DeviceTag (u8DeviceTag_),
    _bDiPOActive (bDiPOActive_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPOActiveDeviceStart::~DiPOActiveDeviceStart() {
}

inline DiPOActiveDeviceStart& DiPOActiveDeviceStart::operator = (const DiPOActiveDeviceStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8DeviceTag()) {
            setU8DeviceTag(rhs.getU8DeviceTag());
        } else {
            clearU8DeviceTag();
        }
        if (rhs.hasBDiPOActive()) {
            setBDiPOActive(rhs.getBDiPOActive());
        } else {
            clearBDiPOActive();
        }
    }
    return *this;
}

inline bool DiPOActiveDeviceStart::operator == (const DiPOActiveDeviceStart& rhs) const {
    return (((!hasU8DeviceTag() && !rhs.hasU8DeviceTag()) || getU8DeviceTag() == rhs.getU8DeviceTag()) &&
        ((!hasBDiPOActive() && !rhs.hasBDiPOActive()) || getBDiPOActive() == rhs.getBDiPOActive()));
}

inline bool DiPOActiveDeviceStart::operator != (const DiPOActiveDeviceStart& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPOActiveDeviceStart::operator < (const DiPOActiveDeviceStart& rhs) const {
    if (hasU8DeviceTag() || rhs.hasU8DeviceTag()) {
        if (getU8DeviceTag() < rhs.getU8DeviceTag()) return true;
        if (getU8DeviceTag() > rhs.getU8DeviceTag()) return false;
    }
    if (hasBDiPOActive() || rhs.hasBDiPOActive()) {
        if (getBDiPOActive() < rhs.getBDiPOActive()) return true;
        if (getBDiPOActive() > rhs.getBDiPOActive()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPOActiveDeviceStart::clone() {
    return new DiPOActiveDeviceStart(*this);
}

inline bool DiPOActiveDeviceStart::operator > (const DiPOActiveDeviceStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPOActiveDeviceStart::clear() {
    clearU8DeviceTag();
    clearBDiPOActive();
}

inline void DiPOActiveDeviceStart::clearU8DeviceTag() {
    if (hasU8DeviceTag()) {
         clear_has_u8DeviceTag();
        _u8DeviceTag = 0u;
     }
}

inline bool DiPOActiveDeviceStart::hasU8DeviceTag () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DiPOActiveDeviceStart::getU8DeviceTag () const {
    return _u8DeviceTag;
}

inline void DiPOActiveDeviceStart::setU8DeviceTag (uint8 u8DeviceTag_) {
    set_has_u8DeviceTag();
    this->_u8DeviceTag = u8DeviceTag_;
}

inline void DiPOActiveDeviceStart::clearBDiPOActive() {
    if (hasBDiPOActive()) {
         clear_has_bDiPOActive();
        _bDiPOActive = false;
     }
}

inline bool DiPOActiveDeviceStart::hasBDiPOActive () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool DiPOActiveDeviceStart::getBDiPOActive () const {
    return _bDiPOActive;
}

inline void DiPOActiveDeviceStart::setBDiPOActive (bool bDiPOActive_) {
    set_has_bDiPOActive();
    this->_bDiPOActive = bDiPOActive_;
}

inline void DiPOActiveDeviceStart::set_has_u8DeviceTag () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPOActiveDeviceStart::clear_has_u8DeviceTag () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiPOActiveDeviceStart::set_has_bDiPOActive () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiPOActiveDeviceStart::clear_has_bDiPOActive () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DiPOActiveDeviceResult::DiPOActiveDeviceResult ()  :
    _e8DiPOResponse (::mplay_appcontrol_fi_types::T_e8_DiPOResponse__e8DIPO_OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPOActiveDeviceResult::DiPOActiveDeviceResult (const DiPOActiveDeviceResult &rhs)  :
    ::asf::core::Payload(rhs),
    _e8DiPOResponse (::mplay_appcontrol_fi_types::T_e8_DiPOResponse__e8DIPO_OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPOActiveDeviceResult::DiPOActiveDeviceResult (::mplay_appcontrol_fi_types::T_e8_DiPOResponse e8DiPOResponse_)  :
    _e8DiPOResponse (e8DiPOResponse_)
{
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DiPOResponse_IsValid(e8DiPOResponse_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DiPOResponse_, "T_e8_DiPOResponse", "e8DiPOResponse", "DiPOActiveDeviceResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPOActiveDeviceResult::~DiPOActiveDeviceResult() {
}

inline DiPOActiveDeviceResult& DiPOActiveDeviceResult::operator = (const DiPOActiveDeviceResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8DiPOResponse()) {
            setE8DiPOResponse(rhs.getE8DiPOResponse());
        } else {
            clearE8DiPOResponse();
        }
    }
    return *this;
}

inline bool DiPOActiveDeviceResult::operator == (const DiPOActiveDeviceResult& rhs) const {
    return (((!hasE8DiPOResponse() && !rhs.hasE8DiPOResponse()) || getE8DiPOResponse() == rhs.getE8DiPOResponse()));
}

inline bool DiPOActiveDeviceResult::operator != (const DiPOActiveDeviceResult& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPOActiveDeviceResult::operator < (const DiPOActiveDeviceResult& rhs) const {
    if (hasE8DiPOResponse() || rhs.hasE8DiPOResponse()) {
        if ((uint32)getE8DiPOResponse() < (uint32)rhs.getE8DiPOResponse()) return true;
        if ((uint32)getE8DiPOResponse() > (uint32)rhs.getE8DiPOResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPOActiveDeviceResult::clone() {
    return new DiPOActiveDeviceResult(*this);
}

inline bool DiPOActiveDeviceResult::operator > (const DiPOActiveDeviceResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPOActiveDeviceResult::clear() {
    clearE8DiPOResponse();
}

inline void DiPOActiveDeviceResult::clearE8DiPOResponse() {
    if (hasE8DiPOResponse()) {
         clear_has_e8DiPOResponse();
        _e8DiPOResponse = ::mplay_appcontrol_fi_types::T_e8_DiPOResponse__e8DIPO_OK;
     }
}

inline bool DiPOActiveDeviceResult::hasE8DiPOResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::mplay_appcontrol_fi_types::T_e8_DiPOResponse DiPOActiveDeviceResult::getE8DiPOResponse () const {
    return _e8DiPOResponse;
}

inline void DiPOActiveDeviceResult::setE8DiPOResponse (::mplay_appcontrol_fi_types::T_e8_DiPOResponse e8DiPOResponse_) {
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DiPOResponse_IsValid(e8DiPOResponse_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DiPOResponse_, "T_e8_DiPOResponse", "e8DiPOResponse", "DiPOActiveDeviceResult");
    }
    #endif
    set_has_e8DiPOResponse();
    this->_e8DiPOResponse = e8DiPOResponse_;
}

inline void DiPOActiveDeviceResult::set_has_e8DiPOResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPOActiveDeviceResult::clear_has_e8DiPOResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DiPORoleSwitchRequestStart::DiPORoleSwitchRequestStart ()  :
    _u8DeviceTag (0u),
    _sDeviceUSBSerialNumber (),
    _e8DiPORoleStatus (::mplay_appcontrol_fi_types::T_e8_DiPORoleStatus__e8DIPO_CLIENTMODE),
    _oAppInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPORoleSwitchRequestStart::DiPORoleSwitchRequestStart (const DiPORoleSwitchRequestStart &rhs)  :
    ::asf::core::Payload(rhs),
    _u8DeviceTag (0u),
    _sDeviceUSBSerialNumber (),
    _e8DiPORoleStatus (::mplay_appcontrol_fi_types::T_e8_DiPORoleStatus__e8DIPO_CLIENTMODE),
    _oAppInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPORoleSwitchRequestStart::DiPORoleSwitchRequestStart (uint8 u8DeviceTag_, const ::std::string& sDeviceUSBSerialNumber_, ::mplay_appcontrol_fi_types::T_e8_DiPORoleStatus e8DiPORoleStatus_, const ::mplay_appcontrol_fi_types::T_AppInfo& oAppInfo_)  :
    _u8DeviceTag (u8DeviceTag_),
    _sDeviceUSBSerialNumber (sDeviceUSBSerialNumber_),
    _e8DiPORoleStatus (e8DiPORoleStatus_),
    _oAppInfo (oAppInfo_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DiPORoleStatus_IsValid(e8DiPORoleStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DiPORoleStatus_, "T_e8_DiPORoleStatus", "e8DiPORoleStatus", "DiPORoleSwitchRequestStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPORoleSwitchRequestStart::~DiPORoleSwitchRequestStart() {
}

inline DiPORoleSwitchRequestStart& DiPORoleSwitchRequestStart::operator = (const DiPORoleSwitchRequestStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8DeviceTag()) {
            setU8DeviceTag(rhs.getU8DeviceTag());
        } else {
            clearU8DeviceTag();
        }
        if (rhs.hasSDeviceUSBSerialNumber()) {
            setSDeviceUSBSerialNumber(rhs.getSDeviceUSBSerialNumber());
        } else {
            clearSDeviceUSBSerialNumber();
        }
        if (rhs.hasE8DiPORoleStatus()) {
            setE8DiPORoleStatus(rhs.getE8DiPORoleStatus());
        } else {
            clearE8DiPORoleStatus();
        }
        if (rhs.hasOAppInfo()) {
            setOAppInfo(rhs.getOAppInfo());
        } else {
            clearOAppInfo();
        }
    }
    return *this;
}

inline bool DiPORoleSwitchRequestStart::operator == (const DiPORoleSwitchRequestStart& rhs) const {
    return (((!hasU8DeviceTag() && !rhs.hasU8DeviceTag()) || getU8DeviceTag() == rhs.getU8DeviceTag()) &&
        ((!hasSDeviceUSBSerialNumber() && !rhs.hasSDeviceUSBSerialNumber()) || getSDeviceUSBSerialNumber() == rhs.getSDeviceUSBSerialNumber()) &&
        ((!hasE8DiPORoleStatus() && !rhs.hasE8DiPORoleStatus()) || getE8DiPORoleStatus() == rhs.getE8DiPORoleStatus()) &&
        ((!hasOAppInfo() && !rhs.hasOAppInfo()) || getOAppInfo() == rhs.getOAppInfo()));
}

inline bool DiPORoleSwitchRequestStart::operator != (const DiPORoleSwitchRequestStart& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPORoleSwitchRequestStart::operator < (const DiPORoleSwitchRequestStart& rhs) const {
    if (hasU8DeviceTag() || rhs.hasU8DeviceTag()) {
        if (getU8DeviceTag() < rhs.getU8DeviceTag()) return true;
        if (getU8DeviceTag() > rhs.getU8DeviceTag()) return false;
    }
    if (hasSDeviceUSBSerialNumber() || rhs.hasSDeviceUSBSerialNumber()) {
        if (getSDeviceUSBSerialNumber() < rhs.getSDeviceUSBSerialNumber()) return true;
        if (getSDeviceUSBSerialNumber() > rhs.getSDeviceUSBSerialNumber()) return false;
    }
    if (hasE8DiPORoleStatus() || rhs.hasE8DiPORoleStatus()) {
        if ((uint32)getE8DiPORoleStatus() < (uint32)rhs.getE8DiPORoleStatus()) return true;
        if ((uint32)getE8DiPORoleStatus() > (uint32)rhs.getE8DiPORoleStatus()) return false;
    }
    if (hasOAppInfo() || rhs.hasOAppInfo()) {
        if (getOAppInfo() < rhs.getOAppInfo()) return true;
        if (getOAppInfo() > rhs.getOAppInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiPORoleSwitchRequestStart::clone() {
    return new DiPORoleSwitchRequestStart(*this);
}

inline bool DiPORoleSwitchRequestStart::operator > (const DiPORoleSwitchRequestStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiPORoleSwitchRequestStart::clear() {
    clearU8DeviceTag();
    clearSDeviceUSBSerialNumber();
    clearE8DiPORoleStatus();
    clearOAppInfo();
}

inline void DiPORoleSwitchRequestStart::clearU8DeviceTag() {
    if (hasU8DeviceTag()) {
         clear_has_u8DeviceTag();
        _u8DeviceTag = 0u;
     }
}

inline bool DiPORoleSwitchRequestStart::hasU8DeviceTag () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DiPORoleSwitchRequestStart::getU8DeviceTag () const {
    return _u8DeviceTag;
}

inline void DiPORoleSwitchRequestStart::setU8DeviceTag (uint8 u8DeviceTag_) {
    set_has_u8DeviceTag();
    this->_u8DeviceTag = u8DeviceTag_;
}

inline void DiPORoleSwitchRequestStart::clearSDeviceUSBSerialNumber() {
    if (hasSDeviceUSBSerialNumber()) {
         clear_has_sDeviceUSBSerialNumber();
        _sDeviceUSBSerialNumber.clear();
     }
}

inline bool DiPORoleSwitchRequestStart::hasSDeviceUSBSerialNumber () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& DiPORoleSwitchRequestStart::getSDeviceUSBSerialNumber () const {
    return _sDeviceUSBSerialNumber;
}

inline ::std::string& DiPORoleSwitchRequestStart::getSDeviceUSBSerialNumberMutable () {
    set_has_sDeviceUSBSerialNumber();
    return _sDeviceUSBSerialNumber;
}

inline void DiPORoleSwitchRequestStart::setSDeviceUSBSerialNumber (const ::std::string& sDeviceUSBSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber = sDeviceUSBSerialNumber_;
}

inline void DiPORoleSwitchRequestStart::setSDeviceUSBSerialNumber (const char* sDeviceUSBSerialNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber.assign(sDeviceUSBSerialNumber_);
}

inline void DiPORoleSwitchRequestStart::setSDeviceUSBSerialNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceUSBSerialNumber();
    this->_sDeviceUSBSerialNumber.assign(value, size);
}

inline void DiPORoleSwitchRequestStart::clearE8DiPORoleStatus() {
    if (hasE8DiPORoleStatus()) {
         clear_has_e8DiPORoleStatus();
        _e8DiPORoleStatus = ::mplay_appcontrol_fi_types::T_e8_DiPORoleStatus__e8DIPO_CLIENTMODE;
     }
}

inline bool DiPORoleSwitchRequestStart::hasE8DiPORoleStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::mplay_appcontrol_fi_types::T_e8_DiPORoleStatus DiPORoleSwitchRequestStart::getE8DiPORoleStatus () const {
    return _e8DiPORoleStatus;
}

inline void DiPORoleSwitchRequestStart::setE8DiPORoleStatus (::mplay_appcontrol_fi_types::T_e8_DiPORoleStatus e8DiPORoleStatus_) {
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DiPORoleStatus_IsValid(e8DiPORoleStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DiPORoleStatus_, "T_e8_DiPORoleStatus", "e8DiPORoleStatus", "DiPORoleSwitchRequestStart");
    }
    #endif
    set_has_e8DiPORoleStatus();
    this->_e8DiPORoleStatus = e8DiPORoleStatus_;
}

inline void DiPORoleSwitchRequestStart::clearOAppInfo() {
    if (hasOAppInfo()) {
         clear_has_oAppInfo();
        _oAppInfo.clear();
     }
}

inline bool DiPORoleSwitchRequestStart::hasOAppInfo () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::mplay_appcontrol_fi_types::T_AppInfo& DiPORoleSwitchRequestStart::getOAppInfo () const {
    return _oAppInfo;
}

inline ::mplay_appcontrol_fi_types::T_AppInfo& DiPORoleSwitchRequestStart::getOAppInfoMutable () {
    set_has_oAppInfo();
    return _oAppInfo;
}

inline void DiPORoleSwitchRequestStart::setOAppInfo (const ::mplay_appcontrol_fi_types::T_AppInfo& oAppInfo_) {
    set_has_oAppInfo();
    this->_oAppInfo = oAppInfo_;
}

inline void DiPORoleSwitchRequestStart::set_has_u8DeviceTag () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiPORoleSwitchRequestStart::clear_has_u8DeviceTag () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DiPORoleSwitchRequestStart::set_has_sDeviceUSBSerialNumber () {
    _has_bits_[0] |= 1u << 1;
}

inline void DiPORoleSwitchRequestStart::clear_has_sDeviceUSBSerialNumber () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DiPORoleSwitchRequestStart::set_has_e8DiPORoleStatus () {
    _has_bits_[0] |= 1u << 2;
}

inline void DiPORoleSwitchRequestStart::clear_has_e8DiPORoleStatus () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DiPORoleSwitchRequestStart::set_has_oAppInfo () {
    _has_bits_[0] |= 1u << 3;
}

inline void DiPORoleSwitchRequestStart::clear_has_oAppInfo () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  DiPORoleSwitchRequestResult::DiPORoleSwitchRequestResult ()  :
    _e8DiPOResponse (::mplay_appcontrol_fi_types::T_e8_DiPOResponse__e8DIPO_OK),
    _sDeviceUSBSerialNumber ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiPORoleSwitchRequestResult::DiPORoleSwitchRequestResult (const DiPORoleSwitchRequestResult &rhs)  :
    ::asf::core::Payload(rhs),
    _e8DiPOResponse (::mplay_appcontrol_fi_types::T_e8_DiPOResponse__e8DIPO_OK),
    _sDeviceUSBSerialNumber ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiPORoleSwitchRequestResult::DiPORoleSwitchRequestResult (::mplay_appcontrol_fi_types::T_e8_DiPOResponse e8DiPOResponse_, const ::std::string& sDeviceUSBSerialNumber_)  :
    _e8DiPOResponse (e8DiPOResponse_),
    _sDeviceUSBSerialNumber (sDeviceUSBSerialNumber_)
{
    #ifndef NDEBUG
    if (!(::mplay_appcontrol_fi_types::T_e8_DiPOResponse_IsValid(e8DiPOResponse_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DiPOResponse_, "T_e8_DiPOResponse", "e8DiPOResponse", "DiPORoleSwitchRequestResult");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceUSBSerialNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiPORoleSwitchRequestResult::~DiPORoleSwitchRequestResult() {
}

inline DiPORoleSwitchRequestResult& DiPORoleSwitchRequestResult::operator = (const DiPORoleSwitchRequestResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8DiPOResponse()) {
            setE8DiPOResponse(rhs.getE8DiPOResponse());
        } else {
            clearE8DiPOResponse();
        }
        if (rhs.hasSDeviceUSBSerialNumber()) {
            setSDeviceUSBSerialNumber(rhs.getSDeviceUSBSerialNumber());
        } else {
            clearSDeviceUSBSerialNumber();
        }
    }
    return *this;
}

inline bool DiPORoleSwitchRequestResult::operator == (const DiPORoleSwitchRequestResult& rhs) const {
    return (((!hasE8DiPOResponse() && !rhs.hasE8DiPOResponse()) || getE8DiPOResponse() == rhs.getE8DiPOResponse()) &&
        ((!hasSDeviceUSBSerialNumber() && !rhs.hasSDeviceUSBSerialNumber()) || getSDeviceUSBSerialNumber() == rhs.getSDeviceUSBSerialNumber()));
}

inline bool DiPORoleSwitchRequestResult::operator != (const DiPORoleSwitchRequestResult& rhs) const {
    return ! (*this == rhs);
}

inline bool DiPORoleSwitchRequestResult::operator < (const DiPORoleSwitchRequestResult& rhs) const {
    if (hasE8DiPOResponse() || rhs.hasE8DiPOResponse()) {
        if ((uint32)getE8DiPOResponse() < (uint32)rhs.getE8DiPOResponse