/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "midw_smartphoneint_fi_typesConst.h"
#include <cstddef>
#include <cstdlib>

/**
 * Types midw_smartphoneint_fi_types
 */

using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi_types {

bool T_e8_ResponseCode_Parse (const char *str, size_t length, T_e8_ResponseCode &value)
{
    static stringEntry entries[] = {
        {7,"FAILURE", 0U},
        {7,"SUCCESS", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_ResponseCode_Name (T_e8_ResponseCode value)
{
    static const char* enumerationLiterals[] = {
        "FAILURE",
        "SUCCESS",
    };

    if (T_e8_ResponseCode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_ResponseCode_IsValid (T_e8_ResponseCode value)
{
    switch (value) {
    case T_e8_ResponseCode__FAILURE:
    case T_e8_ResponseCode__SUCCESS:
        return true;
    default:
        return false;
    }
}

bool T_e8_ErrorType_Parse (const char *str, size_t length, T_e8_ErrorType &value)
{
    static stringEntry entries[] = {
        {8,"NO_ERROR", 0U},
        {11,"FATAL_ERROR", 20U},
        {13,"LAUNCH_FAILED", 7U},
        {13,"RESOURCE_BUSY", 5U},
        {13,"UNKNOWN_ERROR", 1U},
        {14,"INTERNAL_ERROR", 255U},
        {15,"UNSUPPORTED_KEY", 9U},
        {16,"CONNECT_TIME_OUT", 15U},
        {16,"INVALID_ARGUMENT", 2U},
        {16,"SELECTION_FAILED", 12U},
        {16,"TERMINATE_FAILED", 8U},
        {17,"APP_NOT_INSTALLED", 22U},
        {17,"PHONE_UNSUPPORTED", 21U},
        {18,"INVALID_APP_HANDLE", 4U},
        {18,"INVALID_DEV_HANDLE", 3U},
        {18,"OPERATION_REJECTED", 6U},
        {20,"DEVICE_NOT_CONNECTED", 13U},
        {20,"DEVICE_SWITCH_FAILED", 19U},
        {21,"UNSUPPORTED_OPERATION", 10U},
        {22,"INVALID_SERVICE_HANDLE", 11U},
        {22,"PROJECTION_NOT_ENABLED", 17U},
        {23,"REMOTE_APP_START_FAILED", 14U},
        {27,"OPERATION_CANCELLED_BY_USER", 18U},
        {36,"DEVICE_DISCONNECTED_DURING_SELECTION", 16U},
    };

    return lookupInStringEntryTable (str, length, entries, 24, (unsigned int&) value);
}

const char* T_e8_ErrorType_Name (T_e8_ErrorType value)
{
    static const char* enumerationLiterals[] = {
        "NO_ERROR",
        "UNKNOWN_ERROR",
        "INVALID_ARGUMENT",
        "INVALID_DEV_HANDLE",
        "INVALID_APP_HANDLE",
        "RESOURCE_BUSY",
        "OPERATION_REJECTED",
        "LAUNCH_FAILED",
        "TERMINATE_FAILED",
        "UNSUPPORTED_KEY",
        "UNSUPPORTED_OPERATION",
        "INVALID_SERVICE_HANDLE",
        "SELECTION_FAILED",
        "DEVICE_NOT_CONNECTED",
        "REMOTE_APP_START_FAILED",
        "CONNECT_TIME_OUT",
        "DEVICE_DISCONNECTED_DURING_SELECTION",
        "PROJECTION_NOT_ENABLED",
        "OPERATION_CANCELLED_BY_USER",
        "DEVICE_SWITCH_FAILED",
        "FATAL_ERROR",
        "PHONE_UNSUPPORTED",
        "APP_NOT_INSTALLED",
        "INTERNAL_ERROR",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        11U,
        12U,
        13U,
        14U,
        15U,
        16U,
        17U,
        18U,
        19U,
        20U,
        21U,
        22U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 24, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_ErrorType_IsValid (T_e8_ErrorType value)
{
    switch (value) {
    case T_e8_ErrorType__NO_ERROR:
    case T_e8_ErrorType__UNKNOWN_ERROR:
    case T_e8_ErrorType__INVALID_ARGUMENT:
    case T_e8_ErrorType__INVALID_DEV_HANDLE:
    case T_e8_ErrorType__INVALID_APP_HANDLE:
    case T_e8_ErrorType__RESOURCE_BUSY:
    case T_e8_ErrorType__OPERATION_REJECTED:
    case T_e8_ErrorType__LAUNCH_FAILED:
    case T_e8_ErrorType__TERMINATE_FAILED:
    case T_e8_ErrorType__UNSUPPORTED_KEY:
    case T_e8_ErrorType__UNSUPPORTED_OPERATION:
    case T_e8_ErrorType__INVALID_SERVICE_HANDLE:
    case T_e8_ErrorType__SELECTION_FAILED:
    case T_e8_ErrorType__DEVICE_NOT_CONNECTED:
    case T_e8_ErrorType__REMOTE_APP_START_FAILED:
    case T_e8_ErrorType__CONNECT_TIME_OUT:
    case T_e8_ErrorType__DEVICE_DISCONNECTED_DURING_SELECTION:
    case T_e8_ErrorType__PROJECTION_NOT_ENABLED:
    case T_e8_ErrorType__OPERATION_CANCELLED_BY_USER:
    case T_e8_ErrorType__DEVICE_SWITCH_FAILED:
    case T_e8_ErrorType__FATAL_ERROR:
    case T_e8_ErrorType__PHONE_UNSUPPORTED:
    case T_e8_ErrorType__APP_NOT_INSTALLED:
    case T_e8_ErrorType__INTERNAL_ERROR:
        return true;
    default:
        return false;
    }
}

bool T_e8_DeviceCategory_Parse (const char *str, size_t length, T_e8_DeviceCategory &value)
{
    static stringEntry entries[] = {
        {13,"DEV_TYPE_DIPO", 1U},
        {14,"DEV_TYPE_ONCAR", 6U},
        {15,"DEV_TYPE_MYSPIN", 4U},
        {16,"DEV_TYPE_CARLIFE", 5U},
        {16,"DEV_TYPE_DEFAULT", 15U},
        {16,"DEV_TYPE_UNKNOWN", 0U},
        {19,"DEV_TYPE_MIRRORLINK", 2U},
        {20,"DEV_TYPE_ANDROIDAUTO", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 8, (unsigned int&) value);
}

const char* T_e8_DeviceCategory_Name (T_e8_DeviceCategory value)
{
    static const char* enumerationLiterals[] = {
        "DEV_TYPE_UNKNOWN",
        "DEV_TYPE_DIPO",
        "DEV_TYPE_MIRRORLINK",
        "DEV_TYPE_ANDROIDAUTO",
        "DEV_TYPE_MYSPIN",
        "DEV_TYPE_CARLIFE",
        "DEV_TYPE_ONCAR",
        "DEV_TYPE_DEFAULT",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        15U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 8, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_DeviceCategory_IsValid (T_e8_DeviceCategory value)
{
    switch (value) {
    case T_e8_DeviceCategory__DEV_TYPE_UNKNOWN:
    case T_e8_DeviceCategory__DEV_TYPE_DIPO:
    case T_e8_DeviceCategory__DEV_TYPE_MIRRORLINK:
    case T_e8_DeviceCategory__DEV_TYPE_ANDROIDAUTO:
    case T_e8_DeviceCategory__DEV_TYPE_MYSPIN:
    case T_e8_DeviceCategory__DEV_TYPE_CARLIFE:
    case T_e8_DeviceCategory__DEV_TYPE_ONCAR:
    case T_e8_DeviceCategory__DEV_TYPE_DEFAULT:
        return true;
    default:
        return false;
    }
}

bool T_e8_DeviceConnectionStatus_Parse (const char *str, size_t length, T_e8_DeviceConnectionStatus &value)
{
    static stringEntry entries[] = {
        {13,"DEV_CONNECTED", 1U},
        {17,"DEV_NOT_CONNECTED", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_DeviceConnectionStatus_Name (T_e8_DeviceConnectionStatus value)
{
    static const char* enumerationLiterals[] = {
        "DEV_NOT_CONNECTED",
        "DEV_CONNECTED",
    };

    if (T_e8_DeviceConnectionStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DeviceConnectionStatus_IsValid (T_e8_DeviceConnectionStatus value)
{
    switch (value) {
    case T_e8_DeviceConnectionStatus__DEV_NOT_CONNECTED:
    case T_e8_DeviceConnectionStatus__DEV_CONNECTED:
        return true;
    default:
        return false;
    }
}

bool T_e8_DeviceConnectionType_Parse (const char *str, size_t length, T_e8_DeviceConnectionType &value)
{
    static stringEntry entries[] = {
        {13,"USB_CONNECTED", 1U},
        {14,"WIFI_CONNECTED", 2U},
        {18,"UNKNOWN_CONNECTION", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_DeviceConnectionType_Name (T_e8_DeviceConnectionType value)
{
    static const char* enumerationLiterals[] = {
        "UNKNOWN_CONNECTION",
        "USB_CONNECTED",
        "WIFI_CONNECTED",
    };

    if (T_e8_DeviceConnectionType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DeviceConnectionType_IsValid (T_e8_DeviceConnectionType value)
{
    switch (value) {
    case T_e8_DeviceConnectionType__UNKNOWN_CONNECTION:
    case T_e8_DeviceConnectionType__USB_CONNECTED:
    case T_e8_DeviceConnectionType__WIFI_CONNECTED:
        return true;
    default:
        return false;
    }
}

bool T_e8_SessionTransportType_Parse (const char *str, size_t length, T_e8_SessionTransportType &value)
{
    static stringEntry entries[] = {
        {21,"SESSION_TRANSPORT_USB", 1U},
        {22,"SESSION_TRANSPORT_WIFI", 2U},
        {25,"SESSION_TRANSPORT_UNKNOWN", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_SessionTransportType_Name (T_e8_SessionTransportType value)
{
    static const char* enumerationLiterals[] = {
        "SESSION_TRANSPORT_UNKNOWN",
        "SESSION_TRANSPORT_USB",
        "SESSION_TRANSPORT_WIFI",
    };

    if (T_e8_SessionTransportType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_SessionTransportType_IsValid (T_e8_SessionTransportType value)
{
    switch (value) {
    case T_e8_SessionTransportType__SESSION_TRANSPORT_UNKNOWN:
    case T_e8_SessionTransportType__SESSION_TRANSPORT_USB:
    case T_e8_SessionTransportType__SESSION_TRANSPORT_WIFI:
        return true;
    default:
        return false;
    }
}

bool T_e8_DeviceStatusInfo_Parse (const char *str, size_t length, T_e8_DeviceStatusInfo &value)
{
    static stringEntry entries[] = {
        {9,"NOT_KNOWN", 0U},
        {12,"DEVICE_ADDED", 1U},
        {14,"DEVICE_CHANGED", 3U},
        {14,"DEVICE_REMOVED", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_DeviceStatusInfo_Name (T_e8_DeviceStatusInfo value)
{
    static const char* enumerationLiterals[] = {
        "NOT_KNOWN",
        "DEVICE_ADDED",
        "DEVICE_REMOVED",
        "DEVICE_CHANGED",
    };

    if (T_e8_DeviceStatusInfo_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DeviceStatusInfo_IsValid (T_e8_DeviceStatusInfo value)
{
    switch (value) {
    case T_e8_DeviceStatusInfo__NOT_KNOWN:
    case T_e8_DeviceStatusInfo__DEVICE_ADDED:
    case T_e8_DeviceStatusInfo__DEVICE_REMOVED:
    case T_e8_DeviceStatusInfo__DEVICE_CHANGED:
        return true;
    default:
        return false;
    }
}

bool T_e8_AppStatusInfo_Parse (const char *str, size_t length, T_e8_AppStatusInfo &value)
{
    static stringEntry entries[] = {
        {9,"NOT_KNOWN", 0U},
        {16,"APP_LIST_CHANGED", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_AppStatusInfo_Name (T_e8_AppStatusInfo value)
{
    static const char* enumerationLiterals[] = {
        "NOT_KNOWN",
        "APP_LIST_CHANGED",
    };

    if (T_e8_AppStatusInfo_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AppStatusInfo_IsValid (T_e8_AppStatusInfo value)
{
    switch (value) {
    case T_e8_AppStatusInfo__NOT_KNOWN:
    case T_e8_AppStatusInfo__APP_LIST_CHANGED:
        return true;
    default:
        return false;
    }
}

bool T_e8_SessionStatus_Parse (const char *str, size_t length, T_e8_SessionStatus &value)
{
    static stringEntry entries[] = {
        {13,"SESSION_ERROR", 4U},
        {14,"SESSION_ACTIVE", 2U},
        {15,"SESSION_UNKNOWN", 0U},
        {16,"SESSION_INACTIVE", 1U},
        {17,"SESSION_SUSPENDED", 3U},
        {20,"SESSION_PING_FAILURE", 9U},
        {28,"SESSION_SUSPENDED_NON_ML_APP", 5U},
        {30,"SESSION_AUTHENTICATION_FAILURE", 8U},
        {31,"SESSION_SUSPENDED_NON_DRIVE_APP", 6U},
        {32,"SESSION_SUSPENDED_APP_TRANSITION", 7U},
    };

    return lookupInStringEntryTable (str, length, entries, 10, (unsigned int&) value);
}

const char* T_e8_SessionStatus_Name (T_e8_SessionStatus value)
{
    static const char* enumerationLiterals[] = {
        "SESSION_UNKNOWN",
        "SESSION_INACTIVE",
        "SESSION_ACTIVE",
        "SESSION_SUSPENDED",
        "SESSION_ERROR",
        "SESSION_SUSPENDED_NON_ML_APP",
        "SESSION_SUSPENDED_NON_DRIVE_APP",
        "SESSION_SUSPENDED_APP_TRANSITION",
        "SESSION_AUTHENTICATION_FAILURE",
        "SESSION_PING_FAILURE",
    };

    if (T_e8_SessionStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_SessionStatus_IsValid (T_e8_SessionStatus value)
{
    switch (value) {
    case T_e8_SessionStatus__SESSION_UNKNOWN:
    case T_e8_SessionStatus__SESSION_INACTIVE:
    case T_e8_SessionStatus__SESSION_ACTIVE:
    case T_e8_SessionStatus__SESSION_SUSPENDED:
    case T_e8_SessionStatus__SESSION_ERROR:
    case T_e8_SessionStatus__SESSION_SUSPENDED_NON_ML_APP:
    case T_e8_SessionStatus__SESSION_SUSPENDED_NON_DRIVE_APP:
    case T_e8_SessionStatus__SESSION_SUSPENDED_APP_TRANSITION:
    case T_e8_SessionStatus__SESSION_AUTHENTICATION_FAILURE:
    case T_e8_SessionStatus__SESSION_PING_FAILURE:
        return true;
    default:
        return false;
    }
}

bool T_e8_IconMimeType_Parse (const char *str, size_t length, T_e8_IconMimeType &value)
{
    static stringEntry entries[] = {
        {8,"ICON_PNG", 1U},
        {9,"ICON_JPEG", 2U},
        {12,"ICON_INVALID", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_IconMimeType_Name (T_e8_IconMimeType value)
{
    static const char* enumerationLiterals[] = {
        "ICON_INVALID",
        "ICON_PNG",
        "ICON_JPEG",
    };

    if (T_e8_IconMimeType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_IconMimeType_IsValid (T_e8_IconMimeType value)
{
    switch (value) {
    case T_e8_IconMimeType__ICON_INVALID:
    case T_e8_IconMimeType__ICON_PNG:
    case T_e8_IconMimeType__ICON_JPEG:
        return true;
    default:
        return false;
    }
}

bool T_e8_OrientationMode_Parse (const char *str, size_t length, T_e8_OrientationMode &value)
{
    static stringEntry entries[] = {
        {12,"INVALID_MODE", 0U},
        {13,"PORTRAIT_MODE", 1U},
        {14,"LANDSCAPE_MODE", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_OrientationMode_Name (T_e8_OrientationMode value)
{
    static const char* enumerationLiterals[] = {
        "INVALID_MODE",
        "PORTRAIT_MODE",
        "LANDSCAPE_MODE",
    };

    if (T_e8_OrientationMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_OrientationMode_IsValid (T_e8_OrientationMode value)
{
    switch (value) {
    case T_e8_OrientationMode__INVALID_MODE:
    case T_e8_OrientationMode__PORTRAIT_MODE:
    case T_e8_OrientationMode__LANDSCAPE_MODE:
        return true;
    default:
        return false;
    }
}

bool T_e8_BlockingMode_Parse (const char *str, size_t length, T_e8_BlockingMode &value)
{
    static stringEntry entries[] = {
        {15,"ENABLE_BLOCKING", 1U},
        {16,"DISABLE_BLOCKING", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_BlockingMode_Name (T_e8_BlockingMode value)
{
    static const char* enumerationLiterals[] = {
        "DISABLE_BLOCKING",
        "ENABLE_BLOCKING",
    };

    if (T_e8_BlockingMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_BlockingMode_IsValid (T_e8_BlockingMode value)
{
    switch (value) {
    case T_e8_BlockingMode__DISABLE_BLOCKING:
    case T_e8_BlockingMode__ENABLE_BLOCKING:
        return true;
    default:
        return false;
    }
}

bool T_e8_TouchMode_Parse (const char *str, size_t length, T_e8_TouchMode &value)
{
    static stringEntry entries[] = {
        {11,"TOUCH_PRESS", 1U},
        {13,"TOUCH_RELEASE", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TouchMode_Name (T_e8_TouchMode value)
{
    static const char* enumerationLiterals[] = {
        "TOUCH_RELEASE",
        "TOUCH_PRESS",
    };

    if (T_e8_TouchMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TouchMode_IsValid (T_e8_TouchMode value)
{
    switch (value) {
    case T_e8_TouchMode__TOUCH_RELEASE:
    case T_e8_TouchMode__TOUCH_PRESS:
        return true;
    default:
        return false;
    }
}

bool T_e8_KeyMode_Parse (const char *str, size_t length, T_e8_KeyMode &value)
{
    static stringEntry entries[] = {
        {9,"KEY_PRESS", 1U},
        {11,"KEY_RELEASE", 0U},
        {13,"KEY_LONGPRESS", 2U},
        {13,"KEY_SOFTPRESS", 3U},
        {15,"KEY_SOFTRELEASE", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_KeyMode_Name (T_e8_KeyMode value)
{
    static const char* enumerationLiterals[] = {
        "KEY_RELEASE",
        "KEY_PRESS",
        "KEY_LONGPRESS",
        "KEY_SOFTPRESS",
        "KEY_SOFTRELEASE",
    };

    if (T_e8_KeyMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_KeyMode_IsValid (T_e8_KeyMode value)
{
    switch (value) {
    case T_e8_KeyMode__KEY_RELEASE:
    case T_e8_KeyMode__KEY_PRESS:
    case T_e8_KeyMode__KEY_LONGPRESS:
    case T_e8_KeyMode__KEY_SOFTPRESS:
    case T_e8_KeyMode__KEY_SOFTRELEASE:
        return true;
    default:
        return false;
    }
}

bool T_e8_EnabledInfo_Parse (const char *str, size_t length, T_e8_EnabledInfo &value)
{
    static stringEntry entries[] = {
        {13,"USAGE_ENABLED", 1U},
        {14,"USAGE_DISABLED", 0U},
        {15,"USAGE_CONF_REQD", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_EnabledInfo_Name (T_e8_EnabledInfo value)
{
    static const char* enumerationLiterals[] = {
        "USAGE_DISABLED",
        "USAGE_ENABLED",
        "USAGE_CONF_REQD",
    };

    if (T_e8_EnabledInfo_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_EnabledInfo_IsValid (T_e8_EnabledInfo value)
{
    switch (value) {
    case T_e8_EnabledInfo__USAGE_DISABLED:
    case T_e8_EnabledInfo__USAGE_ENABLED:
    case T_e8_EnabledInfo__USAGE_CONF_REQD:
        return true;
    default:
        return false;
    }
}

bool T_e8_ScreenAspectRatio_Parse (const char *str, size_t length, T_e8_ScreenAspectRatio &value)
{
    static stringEntry entries[] = {
        {10,"ASPECT_4_3", 1U},
        {11,"ASPECT_16_9", 2U},
        {14,"ASPECT_UNKNOWN", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_ScreenAspectRatio_Name (T_e8_ScreenAspectRatio value)
{
    static const char* enumerationLiterals[] = {
        "ASPECT_UNKNOWN",
        "ASPECT_4_3",
        "ASPECT_16_9",
    };

    if (T_e8_ScreenAspectRatio_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_ScreenAspectRatio_IsValid (T_e8_ScreenAspectRatio value)
{
    switch (value) {
    case T_e8_ScreenAspectRatio__ASPECT_UNKNOWN:
    case T_e8_ScreenAspectRatio__ASPECT_4_3:
    case T_e8_ScreenAspectRatio__ASPECT_16_9:
        return true;
    default:
        return false;
    }
}

bool T_e8_DeviceConnectionReq_Parse (const char *str, size_t length, T_e8_DeviceConnectionReq &value)
{
    static stringEntry entries[] = {
        {11,"DEV_CONNECT", 0U},
        {14,"DEV_DISCONNECT", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_DeviceConnectionReq_Name (T_e8_DeviceConnectionReq value)
{
    static const char* enumerationLiterals[] = {
        "DEV_CONNECT",
        "DEV_DISCONNECT",
    };

    if (T_e8_DeviceConnectionReq_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DeviceConnectionReq_IsValid (T_e8_DeviceConnectionReq value)
{
    switch (value) {
    case T_e8_DeviceConnectionReq__DEV_CONNECT:
    case T_e8_DeviceConnectionReq__DEV_DISCONNECT:
        return true;
    default:
        return false;
    }
}

bool T_e32_KeyCode_Parse (const char *str, size_t length, T_e32_KeyCode &value)
{
    static stringEntry entries[] = {
        {6,"DEV_OK", 18U},
        {7,"DEV_NAV", 113U},
        {7,"DEV_PTT", 28U},
        {7,"DEV_TEL", 114U},
        {8,"DEV_HOME", 25U},
        {8,"DEV_MENU", 27U},
        {9,"DEV_CLEAR", 22U},
        {9,"DEV_KEY_0", 115U},
        {9,"DEV_KEY_1", 116U},
        {9,"DEV_KEY_2", 117U},
        {9,"DEV_KEY_3", 118U},
        {9,"DEV_KEY_4", 119U},
        {9,"DEV_KEY_5", 120U},
        {9,"DEV_KEY_6", 121U},
        {9,"DEV_KEY_7", 122U},
        {9,"DEV_KEY_8", 123U},
        {9,"DEV_KEY_9", 124U},
        {9,"DEV_MEDIA", 112U},
        {9,"ITU_KEY_0", 0U},
        {9,"ITU_KEY_1", 1U},
        {9,"ITU_KEY_2", 2U},
        {9,"ITU_KEY_3", 3U},
        {9,"ITU_KEY_4", 4U},
        {9,"ITU_KEY_5", 5U},
        {9,"ITU_KEY_6", 6U},
        {9,"ITU_KEY_7", 7U},
        {9,"ITU_KEY_8", 8U},
        {9,"ITU_KEY_9", 9U},
        {10,"DEV_DELETE", 19U},
        {10,"DEV_SEARCH", 26U},
        {11,"DEV_FORWARD", 23U},
        {11,"DEV_ZOOM_IN", 20U},
        {11,"ROTARY_KNOB", 130U},
        {12,"DEV_BACKWARD", 24U},
        {12,"DEV_KEY_HASH", 126U},
        {12,"DEV_KEY_PLUS", 127U},
        {12,"DEV_KEY_STAR", 125U},
        {12,"DEV_ZOOM_OUT", 21U},
        {13,"DEV_PHONE_END", 13U},
        {13,"DEV_SOFT_LEFT", 14U},
        {13,"FUNCTIONKEY_0", 104U},
        {13,"FUNCTIONKEY_1", 105U},
        {13,"FUNCTIONKEY_2", 106U},
        {13,"FUNCTIONKEY_3", 107U},
        {13,"FUNCTIONKEY_4", 108U},
        {13,"FUNCTIONKEY_5", 109U},
        {13,"FUNCTIONKEY_6", 110U},
        {13,"FUNCTIONKEY_7", 111U},
        {13,"ITU_KEY_POUND", 11U},
        {14,"DEV_PHONE_CALL", 12U},
        {14,"DEV_SOFT_RIGHT", 16U},
        {14,"TWODKNOB0_PULL", 49U},
        {14,"TWODKNOB0_PUSH", 48U},
        {14,"TWODKNOB1_PULL", 65U},
        {14,"TWODKNOB1_PUSH", 64U},
        {14,"TWODKNOB2_PULL", 81U},
        {14,"TWODKNOB2_PUSH", 80U},
        {14,"TWODKNOB3_PULL", 97U},
        {14,"TWODKNOB3_PUSH", 96U},
        {15,"DEV_APPLICATION", 17U},
        {15,"DEV_PHONE_FLASH", 39U},
        {15,"DEV_SOFT_MIDDLE", 15U},
        {15,"ITU_KEY_ASTERIX", 10U},
        {15,"MULTIMEDIA_MUTE", 36U},
        {15,"MULTIMEDIA_NEXT", 34U},
        {15,"MULTIMEDIA_PLAY", 29U},
        {15,"MULTIMEDIA_STOP", 31U},
        {16,"MULTIMEDIA_PAUSE", 30U},
        {16,"MULTIMEDIA_PHOTO", 38U},
        {17,"MULTIMEDIA_REWIND", 33U},
        {17,"MULTIMEDIA_UNMUTE", 37U},
        {18,"DEV_KEY_PHONE_MUTE", 128U},
        {18,"MULTIMEDIA_FORWARD", 32U},
        {18,"TWODKNOB0_SHIFT_UP", 42U},
        {18,"TWODKNOB1_SHIFT_UP", 58U},
        {18,"TWODKNOB2_SHIFT_UP", 74U},
        {18,"TWODKNOB3_SHIFT_UP", 90U},
        {19,"MULTIMEDIA_PREVIOUS", 35U},
        {20,"DEV_PHONE_SWAP_CALLS", 132U},
        {20,"TWODKNOB0_SHIFT_DOWN", 45U},
        {20,"TWODKNOB0_SHIFT_LEFT", 41U},
        {20,"TWODKNOB1_SHIFT_DOWN", 61U},
        {20,"TWODKNOB1_SHIFT_LEFT", 57U},
        {20,"TWODKNOB2_SHIFT_DOWN", 77U},
        {20,"TWODKNOB2_SHIFT_LEFT", 73U},
        {20,"TWODKNOB3_SHIFT_DOWN", 93U},
        {20,"TWODKNOB3_SHIFT_LEFT", 89U},
        {21,"DEV_PHONE_MERGE_CALLS", 131U},
        {21,"MULTIMEDIA_PLAY_PAUSE", 129U},
        {21,"TWODKNOB0_SHIFT_RIGHT", 40U},
        {21,"TWODKNOB1_SHIFT_RIGHT", 56U},
        {21,"TWODKNOB2_SHIFT_RIGHT", 72U},
        {21,"TWODKNOB3_SHIFT_RIGHT", 88U},
        {23,"TWODKNOB0_SHIFT_UP_LEFT", 44U},
        {23,"TWODKNOB1_SHIFT_UP_LEFT", 60U},
        {23,"TWODKNOB2_SHIFT_UP_LEFT", 76U},
        {23,"TWODKNOB3_SHIFT_UP_LEFT", 92U},
        {24,"TWODKNOB0_SHIFT_UP_RIGHT", 43U},
        {24,"TWODKNOB1_SHIFT_UP_RIGHT", 59U},
        {24,"TWODKNOB2_SHIFT_UP_RIGHT", 75U},
        {24,"TWODKNOB3_SHIFT_UP_RIGHT", 91U},
        {25,"TWODKNOB0_SHIFT_DOWN_LEFT", 47U},
        {25,"TWODKNOB1_SHIFT_DOWN_LEFT", 63U},
        {25,"TWODKNOB2_SHIFT_DOWN_LEFT", 79U},
        {25,"TWODKNOB3_SHIFT_DOWN_LEFT", 95U},
        {26,"TWODKNOB0_SHIFT_DOWN_RIGHT", 46U},
        {26,"TWODKNOB1_SHIFT_DOWN_RIGHT", 62U},
        {26,"TWODKNOB2_SHIFT_DOWN_RIGHT", 78U},
        {26,"TWODKNOB3_SHIFT_DOWN_RIGHT", 94U},
        {28,"TWODKNOB0_ROTATE_CLOCKWISE_X", 50U},
        {28,"TWODKNOB0_ROTATE_CLOCKWISE_Y", 52U},
        {28,"TWODKNOB0_ROTATE_CLOCKWISE_Z", 54U},
        {28,"TWODKNOB1_ROTATE_CLOCKWISE_X", 66U},
        {28,"TWODKNOB1_ROTATE_CLOCKWISE_Y", 68U},
        {28,"TWODKNOB1_ROTATE_CLOCKWISE_Z", 70U},
        {28,"TWODKNOB2_ROTATE_CLOCKWISE_X", 82U},
        {28,"TWODKNOB2_ROTATE_CLOCKWISE_Y", 84U},
        {28,"TWODKNOB2_ROTATE_CLOCKWISE_Z", 86U},
        {28,"TWODKNOB3_ROTATE_CLOCKWISE_X", 98U},
        {28,"TWODKNOB3_ROTATE_CLOCKWISE_Y", 100U},
        {28,"TWODKNOB3_ROTATE_CLOCKWISE_Z", 102U},
        {32,"TWODKNOB0_ROTATE_ANTICLOCKWISE_X", 51U},
        {32,"TWODKNOB0_ROTATE_ANTICLOCKWISE_Y", 53U},
        {32,"TWODKNOB0_ROTATE_ANTICLOCKWISE_Z", 55U},
        {32,"TWODKNOB1_ROTATE_ANTICLOCKWISE_X", 67U},
        {32,"TWODKNOB1_ROTATE_ANTICLOCKWISE_Y", 69U},
        {32,"TWODKNOB1_ROTATE_ANTICLOCKWISE_Z", 71U},
        {32,"TWODKNOB2_ROTATE_ANTICLOCKWISE_X", 83U},
        {32,"TWODKNOB2_ROTATE_ANTICLOCKWISE_Y", 85U},
        {32,"TWODKNOB2_ROTATE_ANTICLOCKWISE_Z", 87U},
        {32,"TWODKNOB3_ROTATE_ANTICLOCKWISE_X", 99U},
        {32,"TWODKNOB3_ROTATE_ANTICLOCKWISE_Y", 101U},
        {32,"TWODKNOB3_ROTATE_ANTICLOCKWISE_Z", 103U},
    };

    return lookupInStringEntryTable (str, length, entries, 133, (unsigned int&) value);
}

const char* T_e32_KeyCode_Name (T_e32_KeyCode value)
{
    static const char* enumerationLiterals[] = {
        "ITU_KEY_0",
        "ITU_KEY_1",
        "ITU_KEY_2",
        "ITU_KEY_3",
        "ITU_KEY_4",
        "ITU_KEY_5",
        "ITU_KEY_6",
        "ITU_KEY_7",
        "ITU_KEY_8",
        "ITU_KEY_9",
        "ITU_KEY_ASTERIX",
        "ITU_KEY_POUND",
        "DEV_PHONE_CALL",
        "DEV_PHONE_END",
        "DEV_SOFT_LEFT",
        "DEV_SOFT_MIDDLE",
        "DEV_SOFT_RIGHT",
        "DEV_APPLICATION",
        "DEV_OK",
        "DEV_DELETE",
        "DEV_ZOOM_IN",
        "DEV_ZOOM_OUT",
        "DEV_CLEAR",
        "DEV_FORWARD",
        "DEV_BACKWARD",
        "DEV_HOME",
        "DEV_SEARCH",
        "DEV_MENU",
        "DEV_PTT",
        "MULTIMEDIA_PLAY",
        "MULTIMEDIA_PAUSE",
        "MULTIMEDIA_STOP",
        "MULTIMEDIA_FORWARD",
        "MULTIMEDIA_REWIND",
        "MULTIMEDIA_NEXT",
        "MULTIMEDIA_PREVIOUS",
        "MULTIMEDIA_MUTE",
        "MULTIMEDIA_UNMUTE",
        "MULTIMEDIA_PHOTO",
        "DEV_PHONE_FLASH",
        "TWODKNOB0_SHIFT_RIGHT",
        "TWODKNOB0_SHIFT_LEFT",
        "TWODKNOB0_SHIFT_UP",
        "TWODKNOB0_SHIFT_UP_RIGHT",
        "TWODKNOB0_SHIFT_UP_LEFT",
        "TWODKNOB0_SHIFT_DOWN",
        "TWODKNOB0_SHIFT_DOWN_RIGHT",
        "TWODKNOB0_SHIFT_DOWN_LEFT",
        "TWODKNOB0_PUSH",
        "TWODKNOB0_PULL",
        "TWODKNOB0_ROTATE_CLOCKWISE_X",
        "TWODKNOB0_ROTATE_ANTICLOCKWISE_X",
        "TWODKNOB0_ROTATE_CLOCKWISE_Y",
        "TWODKNOB0_ROTATE_ANTICLOCKWISE_Y",
        "TWODKNOB0_ROTATE_CLOCKWISE_Z",
        "TWODKNOB0_ROTATE_ANTICLOCKWISE_Z",
        "TWODKNOB1_SHIFT_RIGHT",
        "TWODKNOB1_SHIFT_LEFT",
        "TWODKNOB1_SHIFT_UP",
        "TWODKNOB1_SHIFT_UP_RIGHT",
        "TWODKNOB1_SHIFT_UP_LEFT",
        "TWODKNOB1_SHIFT_DOWN",
        "TWODKNOB1_SHIFT_DOWN_RIGHT",
        "TWODKNOB1_SHIFT_DOWN_LEFT",
        "TWODKNOB1_PUSH",
        "TWODKNOB1_PULL",
        "TWODKNOB1_ROTATE_CLOCKWISE_X",
        "TWODKNOB1_ROTATE_ANTICLOCKWISE_X",
        "TWODKNOB1_ROTATE_CLOCKWISE_Y",
        "TWODKNOB1_ROTATE_ANTICLOCKWISE_Y",
        "TWODKNOB1_ROTATE_CLOCKWISE_Z",
        "TWODKNOB1_ROTATE_ANTICLOCKWISE_Z",
        "TWODKNOB2_SHIFT_RIGHT",
        "TWODKNOB2_SHIFT_LEFT",
        "TWODKNOB2_SHIFT_UP",
        "TWODKNOB2_SHIFT_UP_RIGHT",
        "TWODKNOB2_SHIFT_UP_LEFT",
        "TWODKNOB2_SHIFT_DOWN",
        "TWODKNOB2_SHIFT_DOWN_RIGHT",
        "TWODKNOB2_SHIFT_DOWN_LEFT",
        "TWODKNOB2_PUSH",
        "TWODKNOB2_PULL",
        "TWODKNOB2_ROTATE_CLOCKWISE_X",
        "TWODKNOB2_ROTATE_ANTICLOCKWISE_X",
        "TWODKNOB2_ROTATE_CLOCKWISE_Y",
        "TWODKNOB2_ROTATE_ANTICLOCKWISE_Y",
        "TWODKNOB2_ROTATE_CLOCKWISE_Z",
        "TWODKNOB2_ROTATE_ANTICLOCKWISE_Z",
        "TWODKNOB3_SHIFT_RIGHT",
        "TWODKNOB3_SHIFT_LEFT",
        "TWODKNOB3_SHIFT_UP",
        "TWODKNOB3_SHIFT_UP_RIGHT",
        "TWODKNOB3_SHIFT_UP_LEFT",
        "TWODKNOB3_SHIFT_DOWN",
        "TWODKNOB3_SHIFT_DOWN_RIGHT",
        "TWODKNOB3_SHIFT_DOWN_LEFT",
        "TWODKNOB3_PUSH",
        "TWODKNOB3_PULL",
        "TWODKNOB3_ROTATE_CLOCKWISE_X",
        "TWODKNOB3_ROTATE_ANTICLOCKWISE_X",
        "TWODKNOB3_ROTATE_CLOCKWISE_Y",
        "TWODKNOB3_ROTATE_ANTICLOCKWISE_Y",
        "TWODKNOB3_ROTATE_CLOCKWISE_Z",
        "TWODKNOB3_ROTATE_ANTICLOCKWISE_Z",
        "FUNCTIONKEY_0",
        "FUNCTIONKEY_1",
        "FUNCTIONKEY_2",
        "FUNCTIONKEY_3",
        "FUNCTIONKEY_4",
        "FUNCTIONKEY_5",
        "FUNCTIONKEY_6",
        "FUNCTIONKEY_7",
        "DEV_MEDIA",
        "DEV_NAV",
        "DEV_TEL",
        "DEV_KEY_0",
        "DEV_KEY_1",
        "DEV_KEY_2",
        "DEV_KEY_3",
        "DEV_KEY_4",
        "DEV_KEY_5",
        "DEV_KEY_6",
        "DEV_KEY_7",
        "DEV_KEY_8",
        "DEV_KEY_9",
        "DEV_KEY_STAR",
        "DEV_KEY_HASH",
        "DEV_KEY_PLUS",
        "DEV_KEY_PHONE_MUTE",
        "MULTIMEDIA_PLAY_PAUSE",
        "ROTARY_KNOB",
        "DEV_PHONE_MERGE_CALLS",
        "DEV_PHONE_SWAP_CALLS",
    };

    if (T_e32_KeyCode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e32_KeyCode_IsValid (T_e32_KeyCode value)
{
    switch (value) {
    case T_e32_KeyCode__ITU_KEY_0:
    case T_e32_KeyCode__ITU_KEY_1:
    case T_e32_KeyCode__ITU_KEY_2:
    case T_e32_KeyCode__ITU_KEY_3:
    case T_e32_KeyCode__ITU_KEY_4:
    case T_e32_KeyCode__ITU_KEY_5:
    case T_e32_KeyCode__ITU_KEY_6:
    case T_e32_KeyCode__ITU_KEY_7:
    case T_e32_KeyCode__ITU_KEY_8:
    case T_e32_KeyCode__ITU_KEY_9:
    case T_e32_KeyCode__ITU_KEY_ASTERIX:
    case T_e32_KeyCode__ITU_KEY_POUND:
    case T_e32_KeyCode__DEV_PHONE_CALL:
    case T_e32_KeyCode__DEV_PHONE_END:
    case T_e32_KeyCode__DEV_SOFT_LEFT:
    case T_e32_KeyCode__DEV_SOFT_MIDDLE:
    case T_e32_KeyCode__DEV_SOFT_RIGHT:
    case T_e32_KeyCode__DEV_APPLICATION:
    case T_e32_KeyCode__DEV_OK:
    case T_e32_KeyCode__DEV_DELETE:
    case T_e32_KeyCode__DEV_ZOOM_IN:
    case T_e32_KeyCode__DEV_ZOOM_OUT:
    case T_e32_KeyCode__DEV_CLEAR:
    case T_e32_KeyCode__DEV_FORWARD:
    case T_e32_KeyCode__DEV_BACKWARD:
    case T_e32_KeyCode__DEV_HOME:
    case T_e32_KeyCode__DEV_SEARCH:
    case T_e32_KeyCode__DEV_MENU:
    case T_e32_KeyCode__DEV_PTT:
    case T_e32_KeyCode__MULTIMEDIA_PLAY:
    case T_e32_KeyCode__MULTIMEDIA_PAUSE:
    case T_e32_KeyCode__MULTIMEDIA_STOP:
    case T_e32_KeyCode__MULTIMEDIA_FORWARD:
    case T_e32_KeyCode__MULTIMEDIA_REWIND:
    case T_e32_KeyCode__MULTIMEDIA_NEXT:
    case T_e32_KeyCode__MULTIMEDIA_PREVIOUS:
    case T_e32_KeyCode__MULTIMEDIA_MUTE:
    case T_e32_KeyCode__MULTIMEDIA_UNMUTE:
    case T_e32_KeyCode__MULTIMEDIA_PHOTO:
    case T_e32_KeyCode__DEV_PHONE_FLASH:
    case T_e32_KeyCode__TWODKNOB0_SHIFT_RIGHT:
    case T_e32_KeyCode__TWODKNOB0_SHIFT_LEFT:
    case T_e32_KeyCode__TWODKNOB0_SHIFT_UP:
    case T_e32_KeyCode__TWODKNOB0_SHIFT_UP_RIGHT:
    case T_e32_KeyCode__TWODKNOB0_SHIFT_UP_LEFT:
    case T_e32_KeyCode__TWODKNOB0_SHIFT_DOWN:
    case T_e32_KeyCode__TWODKNOB0_SHIFT_DOWN_RIGHT:
    case T_e32_KeyCode__TWODKNOB0_SHIFT_DOWN_LEFT:
    case T_e32_KeyCode__TWODKNOB0_PUSH:
    case T_e32_KeyCode__TWODKNOB0_PULL:
    case T_e32_KeyCode__TWODKNOB0_ROTATE_CLOCKWISE_X:
    case T_e32_KeyCode__TWODKNOB0_ROTATE_ANTICLOCKWISE_X:
    case T_e32_KeyCode__TWODKNOB0_ROTATE_CLOCKWISE_Y:
    case T_e32_KeyCode__TWODKNOB0_ROTATE_ANTICLOCKWISE_Y:
    case T_e32_KeyCode__TWODKNOB0_ROTATE_CLOCKWISE_Z:
    case T_e32_KeyCode__TWODKNOB0_ROTATE_ANTICLOCKWISE_Z:
    case T_e32_KeyCode__TWODKNOB1_SHIFT_RIGHT:
    case T_e32_KeyCode__TWODKNOB1_SHIFT_LEFT:
    case T_e32_KeyCode__TWODKNOB1_SHIFT_UP:
    case T_e32_KeyCode__TWODKNOB1_SHIFT_UP_RIGHT:
    case T_e32_KeyCode__TWODKNOB1_SHIFT_UP_LEFT:
    case T_e32_KeyCode__TWODKNOB1_SHIFT_DOWN:
    case T_e32_KeyCode__TWODKNOB1_SHIFT_DOWN_RIGHT:
    case T_e32_KeyCode__TWODKNOB1_SHIFT_DOWN_LEFT:
    case T_e32_KeyCode__TWODKNOB1_PUSH:
    case T_e32_KeyCode__TWODKNOB1_PULL:
    case T_e32_KeyCode__TWODKNOB1_ROTATE_CLOCKWISE_X:
    case T_e32_KeyCode__TWODKNOB1_ROTATE_ANTICLOCKWISE_X:
    case T_e32_KeyCode__TWODKNOB1_ROTATE_CLOCKWISE_Y:
    case T_e32_KeyCode__TWODKNOB1_ROTATE_ANTICLOCKWISE_Y:
    case T_e32_KeyCode__TWODKNOB1_ROTATE_CLOCKWISE_Z:
    case T_e32_KeyCode__TWODKNOB1_ROTATE_ANTICLOCKWISE_Z:
    case T_e32_KeyCode__TWODKNOB2_SHIFT_RIGHT:
    case T_e32_KeyCode__TWODKNOB2_SHIFT_LEFT:
    case T_e32_KeyCode__TWODKNOB2_SHIFT_UP:
    case T_e32_KeyCode__TWODKNOB2_SHIFT_UP_RIGHT:
    case T_e32_KeyCode__TWODKNOB2_SHIFT_UP_LEFT:
    case T_e32_KeyCode__TWODKNOB2_SHIFT_DOWN:
    case T_e32_KeyCode__TWODKNOB2_SHIFT_DOWN_RIGHT:
    case T_e32_KeyCode__TWODKNOB2_SHIFT_DOWN_LEFT:
    case T_e32_KeyCode__TWODKNOB2_PUSH:
    case T_e32_KeyCode__TWODKNOB2_PULL:
    case T_e32_KeyCode__TWODKNOB2_ROTATE_CLOCKWISE_X:
    case T_e32_KeyCode__TWODKNOB2_ROTATE_ANTICLOCKWISE_X:
    case T_e32_KeyCode__TWODKNOB2_ROTATE_CLOCKWISE_Y:
    case T_e32_KeyCode__TWODKNOB2_ROTATE_ANTICLOCKWISE_Y:
    case T_e32_KeyCode__TWODKNOB2_ROTATE_CLOCKWISE_Z:
    case T_e32_KeyCode__TWODKNOB2_ROTATE_ANTICLOCKWISE_Z:
    case T_e32_KeyCode__TWODKNOB3_SHIFT_RIGHT:
    case T_e32_KeyCode__TWODKNOB3_SHIFT_LEFT:
    case T_e32_KeyCode__TWODKNOB3_SHIFT_UP:
    case T_e32_KeyCode__TWODKNOB3_SHIFT_UP_RIGHT:
    case T_e32_KeyCode__TWODKNOB3_SHIFT_UP_LEFT:
    case T_e32_KeyCode__TWODKNOB3_SHIFT_DOWN:
    case T_e32_KeyCode__TWODKNOB3_SHIFT_DOWN_RIGHT:
    case T_e32_KeyCode__TWODKNOB3_SHIFT_DOWN_LEFT:
    case T_e32_KeyCode__TWODKNOB3_PUSH:
    case T_e32_KeyCode__TWODKNOB3_PULL:
    case T_e32_KeyCode__TWODKNOB3_ROTATE_CLOCKWISE_X:
    case T_e32_KeyCode__TWODKNOB3_ROTATE_ANTICLOCKWISE_X:
    case T_e32_KeyCode__TWODKNOB3_ROTATE_CLOCKWISE_Y:
    case T_e32_KeyCode__TWODKNOB3_ROTATE_ANTICLOCKWISE_Y:
    case T_e32_KeyCode__TWODKNOB3_ROTATE_CLOCKWISE_Z:
    case T_e32_KeyCode__TWODKNOB3_ROTATE_ANTICLOCKWISE_Z:
    case T_e32_KeyCode__FUNCTIONKEY_0:
    case T_e32_KeyCode__FUNCTIONKEY_1:
    case T_e32_KeyCode__FUNCTIONKEY_2:
    case T_e32_KeyCode__FUNCTIONKEY_3:
    case T_e32_KeyCode__FUNCTIONKEY_4:
    case T_e32_KeyCode__FUNCTIONKEY_5:
    case T_e32_KeyCode__FUNCTIONKEY_6:
    case T_e32_KeyCode__FUNCTIONKEY_7:
    case T_e32_KeyCode__DEV_MEDIA:
    case T_e32_KeyCode__DEV_NAV:
    case T_e32_KeyCode__DEV_TEL:
    case T_e32_KeyCode__DEV_KEY_0:
    case T_e32_KeyCode__DEV_KEY_1:
    case T_e32_KeyCode__DEV_KEY_2:
    case T_e32_KeyCode__DEV_KEY_3:
    case T_e32_KeyCode__DEV_KEY_4:
    case T_e32_KeyCode__DEV_KEY_5:
    case T_e32_KeyCode__DEV_KEY_6:
    case T_e32_KeyCode__DEV_KEY_7:
    case T_e32_KeyCode__DEV_KEY_8:
    case T_e32_KeyCode__DEV_KEY_9:
    case T_e32_KeyCode__DEV_KEY_STAR:
    case T_e32_KeyCode__DEV_KEY_HASH:
    case T_e32_KeyCode__DEV_KEY_PLUS:
    case T_e32_KeyCode__DEV_KEY_PHONE_MUTE:
    case T_e32_KeyCode__MULTIMEDIA_PLAY_PAUSE:
    case T_e32_KeyCode__ROTARY_KNOB:
    case T_e32_KeyCode__DEV_PHONE_MERGE_CALLS:
    case T_e32_KeyCode__DEV_PHONE_SWAP_CALLS:
        return true;
    default:
        return false;
    }
}

bool T_e32_AppCategory_Parse (const char *str, size_t length, T_e32_AppCategory &value)
{
    static stringEntry entries[] = {
        {6,"APP_UI", 65536U},
        {7,"APP_PIM", 655360U},
        {8,"APP_NOUI", 4026531840U},
        {9,"APP_MEDIA", 196608U},
        {9,"APP_PHONE", 131072U},
        {10,"APP_SYSTEM", 4294901760U},
        {10,"APP_UIMENU", 65538U},
        {11,"APP_BROWSER", 393216U},
        {11,"APP_TESTAPP", 4294836224U},
        {11,"APP_UNKNOWN", 0U},
        {12,"APP_PIMNOTES", 655362U},
        {13,"APP_MESSAGING", 262144U},
        {14,"APP_MEDIAIMAGE", 196612U},
        {14,"APP_MEDIAMUSIC", 196609U},
        {14,"APP_MEDIAVIDEO", 196610U},
        {14,"APP_NAVIGATION", 327680U},
        {14,"APP_UISETTINGS", 65541U},
        {15,"APP_INFORMATION", 524288U},
        {15,"APP_MEDIAGAMING", 196611U},
        {15,"APP_PIMCALENDAR", 655361U},
        {16,"APP_MESSAGINGMMS", 262146U},
        {16,"APP_MESSAGINGSMS", 262145U},
        {16,"APP_PHONECALLLOG", 131074U},
        {16,"APP_PRODUCTIVITY", 458752U},
        {16,"APP_UIHOMESCREEN", 65537U},
        {18,"APP_MESSAGINGEMAIL", 262147U},
        {18,"APP_UINOTIFICATION", 65539U},
        {19,"APP_INFORMATIONNEWS", 524289U},
        {19,"APP_NOUIAUDIOCLIENT", 4026531842U},
        {19,"APP_NOUIAUDIOSERVER", 4026531841U},
        {20,"APP_INFORMATIONCLOCK", 524294U},
        {20,"APP_PHONECONTACTLIST", 131073U},
        {20,"APP_SOCIALNETWORKING", 589824U},
        {20,"APP_SYSTEMINPUTBTPIN", 4294901762U},
        {21,"APP_INFORMATIONSPORTS", 524293U},
        {21,"APP_INFORMATIONSTOCKS", 524291U},
        {21,"APP_INFORMATIONTRAVEL", 524292U},
        {22,"APP_INFORMATIONWEATHER", 524290U},
        {22,"APP_NOUIVOICECMDENGINE", 4026531856U},
        {23,"APP_SYSTEMINPUTOTHERPWD", 4294901775U},
        {24,"APP_SYSTEMINPUTUNLOCKPIN", 4294901761U},
        {24,"APP_UIAPPLICATIONLISTING", 65540U},
        {25,"APP_PRODUCTIVITYDOCEDITOR", 458754U},
        {25,"APP_PRODUCTIVITYDOCVIEWER", 458753U},
        {26,"APP_SWITCHTOCLIENTNATIVEUI", 4026597375U},
        {27,"APP_BROWSERAPPLICATIONSTORE", 393217U},
        {27,"APP_NOUICONVERSATIONALAUDIO", 4026531872U},
        {30,"APP_SYSTEMVOICECMDCONFIRMATION", 4294901776U},
    };

    return lookupInStringEntryTable (str, length, entries, 48, (unsigned int&) value);
}

const char* T_e32_AppCategory_Name (T_e32_AppCategory value)
{
    static const char* enumerationLiterals[] = {
        "App_Unknown",
        "App_UI",
        "App_UIHomeScreen",
        "App_UIMenu",
        "App_UINotification",
        "App_UIApplicationListing",
        "App_UISettings",
        "App_Phone",
        "App_PhoneContactList",
        "App_PhoneCallLog",
        "App_Media",
        "App_MediaMusic",
        "App_MediaVideo",
        "App_MediaGaming",
        "App_MediaImage",
        "App_Messaging",
        "App_MessagingSMS",
        "App_MessagingMMS",
        "App_MessagingEmail",
        "App_Navigation",
        "App_Browser",
        "App_BrowserApplicationStore",
        "App_Productivity",
        "App_ProductivityDocViewer",
        "App_ProductivityDocEditor",
        "App_Information",
        "App_InformationNews",
        "App_InformationWeather",
        "App_InformationStocks",
        "App_InformationTravel",
        "App_InformationSports",
        "App_InformationClock",
        "App_SocialNetworking",
        "App_PIM",
        "App_PIMCalendar",
        "App_PIMNotes",
        "App_NoUI",
        "App_NoUIAudioServer",
        "App_NoUIAudioClient",
        "App_NoUIVoiceCmdEngine",
        "App_NoUIConversationalAudio",
        "App_SwitchToClientNativeUI",
        "App_TestApp",
        "App_System",
        "App_SystemInputUnlockPIN",
        "App_SystemInputBTPIN",
        "App_SystemInputOtherPwd",
        "App_SystemVoiceCmdConfirmation",
    };

    static unsigned int enumerationValues[] = {
        0U,
        65536U,
        65537U,
        65538U,
        65539U,
        65540U,
        65541U,
        131072U,
        131073U,
        131074U,
        196608U,
        196609U,
        196610U,
        196611U,
        196612U,
        262144U,
        262145U,
        262146U,
        262147U,
        327680U,
        393216U,
        393217U,
        458752U,
        458753U,
        458754U,
        524288U,
        524289U,
        524290U,
        524291U,
        524292U,
        524293U,
        524294U,
        589824U,
        655360U,
        655361U,
        655362U,
        4026531840U,
        4026531841U,
        4026531842U,
        4026531856U,
        4026531872U,
        4026597375U,
        4294836224U,
        4294901760U,
        4294901761U,
        4294901762U,
        4294901775U,
        4294901776U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 48, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e32_AppCategory_IsValid (T_e32_AppCategory value)
{
    switch (value) {
    case T_e32_AppCategory__App_Unknown:
    case T_e32_AppCategory__App_UI:
    case T_e32_AppCategory__App_UIHomeScreen:
    case T_e32_AppCategory__App_UIMenu:
    case T_e32_AppCategory__App_UINotification:
    case T_e32_AppCategory__App_UIApplicationListing:
    case T_e32_AppCategory__App_UISettings:
    case T_e32_AppCategory__App_Phone:
    case T_e32_AppCategory__App_PhoneContactList:
    case T_e32_AppCategory__App_PhoneCallLog:
    case T_e32_AppCategory__App_Media:
    case T_e32_AppCategory__App_MediaMusic:
    case T_e32_AppCategory__App_MediaVideo:
    case T_e32_AppCategory__App_MediaGaming:
    case T_e32_AppCategory__App_MediaImage:
    case T_e32_AppCategory__App_Messaging:
    case T_e32_AppCategory__App_MessagingSMS:
    case T_e32_AppCategory__App_MessagingMMS:
    case T_e32_AppCategory__App_MessagingEmail:
    case T_e32_AppCategory__App_Navigation:
    case T_e32_AppCategory__App_Browser:
    case T_e32_AppCategory__App_BrowserApplicationStore:
    case T_e32_AppCategory__App_Productivity:
    case T_e32_AppCategory__App_ProductivityDocViewer:
    case T_e32_AppCategory__App_ProductivityDocEditor:
    case T_e32_AppCategory__App_Information:
    case T_e32_AppCategory__App_InformationNews:
    case T_e32_AppCategory__App_InformationWeather:
    case T_e32_AppCategory__App_InformationStocks:
    case T_e32_AppCategory__App_InformationTravel:
    case T_e32_AppCategory__App_InformationSports:
    case T_e32_AppCategory__App_InformationClock:
    case T_e32_AppCategory__App_SocialNetworking:
    case T_e32_AppCategory__App_PIM:
    case T_e32_AppCategory__App_PIMCalendar:
    case T_e32_AppCategory__App_PIMNotes:
    case T_e32_AppCategory__App_NoUI:
    case T_e32_AppCategory__App_NoUIAudioServer:
    case T_e32_AppCategory__App_NoUIAudioClient:
    case T_e32_AppCategory__App_NoUIVoiceCmdEngine:
    case T_e32_AppCategory__App_NoUIConversationalAudio:
    case T_e32_AppCategory__App_SwitchToClientNativeUI:
    case T_e32_AppCategory__App_TestApp:
    case T_e32_AppCategory__App_System:
    case T_e32_AppCategory__App_SystemInputUnlockPIN:
    case T_e32_AppCategory__App_SystemInputBTPIN:
    case T_e32_AppCategory__App_SystemInputOtherPwd:
    case T_e32_AppCategory__App_SystemVoiceCmdConfirmation:
        return true;
    default:
        return false;
    }
}

bool T_e32_AppDisplayCategory_Parse (const char *str, size_t length, T_e32_AppDisplayCategory &value)
{
    static stringEntry entries[] = {
        {10,"CONTENT_UI", 32U},
        {12,"CONTENT_MISC", 2147483648U},
        {12,"CONTENT_TEXT", 1U},
        {13,"CONTENT_IMAGE", 4U},
        {13,"CONTENT_VIDEO", 2U},
        {15,"CONTENT_CARMODE", 65536U},
        {18,"CONTENT_GRAPHICS3D", 16U},
        {22,"CONTENT_GRAPHICSVECTOR", 128U},
    };

    return lookupInStringEntryTable (str, length, entries, 8, (unsigned int&) value);
}

const char* T_e32_AppDisplayCategory_Name (T_e32_AppDisplayCategory value)
{
    static const char* enumerationLiterals[] = {
        "Content_Text",
        "Content_Video",
        "Content_Image",
        "Content_Graphics3D",
        "Content_UI",
        "Content_GraphicsVector",
        "Content_CarMode",
        "Content_Misc",
    };

    static unsigned int enumerationValues[] = {
        1U,
        2U,
        4U,
        16U,
        32U,
        128U,
        65536U,
        2147483648U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 8, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e32_AppDisplayCategory_IsValid (T_e32_AppDisplayCategory value)
{
    switch (value) {
    case T_e32_AppDisplayCategory__Content_Text:
    case T_e32_AppDisplayCategory__Content_Video:
    case T_e32_AppDisplayCategory__Content_Image:
    case T_e32_AppDisplayCategory__Content_GraphicsVector:
    case T_e32_AppDisplayCategory__Content_Graphics3D:
    case T_e32_AppDisplayCategory__Content_UI:
    case T_e32_AppDisplayCategory__Content_CarMode:
    case T_e32_AppDisplayCategory__Content_Misc:
        return true;
    default:
        return false;
    }
}

bool T_e32_AppAudioCategory_Parse (const char *str, size_t length, T_e32_AppAudioCategory &value)
{
    static stringEntry entries[] = {
        {11,"PHONE_AUDIO", 1U},
        {12,"MISC_CONTENT", 2147483648U},
        {13,"MEDIA_AUDIOIN", 4U},
        {14,"MEDIA_AUDIOOUT", 2U},
        {15,"VOICE_COMMANDIN", 16U},
        {16,"VOICE_COMMANDOUT", 128U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e32_AppAudioCategory_Name (T_e32_AppAudioCategory value)
{
    static const char* enumerationLiterals[] = {
        "Phone_Audio",
        "Media_AudioOut",
        "Media_AudioIn",
        "Voice_CommandIn",
        "Voice_CommandOut",
        "Misc_Content",
    };

    static unsigned int enumerationValues[] = {
        1U,
        2U,
        4U,
        16U,
        128U,
        2147483648U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 6, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e32_AppAudioCategory_IsValid (T_e32_AppAudioCategory value)
{
    switch (value) {
    case T_e32_AppAudioCategory__Phone_Audio:
    case T_e32_AppAudioCategory__Media_AudioOut:
    case T_e32_AppAudioCategory__Media_AudioIn:
    case T_e32_AppAudioCategory__Voice_CommandOut:
    case T_e32_AppAudioCategory__Voice_CommandIn:
    case T_e32_AppAudioCategory__Misc_Content:
        return true;
    default:
        return false;
    }
}

bool T_e16_TrustLevel_Parse (const char *str, size_t length, T_e16_TrustLevel &value)
{
    static stringEntry entries[] = {
        {7,"UNKNOWN", 0U},
        {18,"USER_CONFIGURATION", 64U},
        {22,"REGISTERED_APPLICATION", 128U},
        {23,"APPLICATION_CERTIFICATE", 160U},
        {26,"SELFREGISTERED_APPLICATION", 96U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e16_TrustLevel_Name (T_e16_TrustLevel value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "User_Configuration",
        "SelfRegistered_Application",
        "Registered_Application",
        "Application_Certificate",
    };

    static unsigned int enumerationValues[] = {
        0U,
        64U,
        96U,
        128U,
        160U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 5, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e16_TrustLevel_IsValid (T_e16_TrustLevel value)
{
    switch (value) {
    case T_e16_TrustLevel__Unknown:
    case T_e16_TrustLevel__User_Configuration:
    case T_e16_TrustLevel__SelfRegistered_Application:
    case T_e16_TrustLevel__Registered_Application:
    case T_e16_TrustLevel__Application_Certificate:
        return true;
    default:
        return false;
    }
}

bool T_e8_AppCertificationInfo_Parse (const char *str, size_t length, T_e8_AppCertificationInfo &value)
{
    static stringEntry entries[] = {
        {13,"NOT_CERTIFIED", 0U},
        {14,"BASE_CERTIFIED", 1U},
        {15,"DRIVE_CERTIFIED", 4U},
        {20,"DRIVE_CERTIFIED_ONLY", 3U},
        {23,"NONDRIVE_CERTIFIED_ONLY", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_AppCertificationInfo_Name (T_e8_AppCertificationInfo value)
{
    static const char* enumerationLiterals[] = {
        "NOT_CERTIFIED",
        "BASE_CERTIFIED",
        "NONDRIVE_CERTIFIED_ONLY",
        "DRIVE_CERTIFIED_ONLY",
        "DRIVE_CERTIFIED",
    };

    if (T_e8_AppCertificationInfo_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AppCertificationInfo_IsValid (T_e8_AppCertificationInfo value)
{
    switch (value) {
    case T_e8_AppCertificationInfo__NOT_CERTIFIED:
    case T_e8_AppCertificationInfo__BASE_CERTIFIED:
    case T_e8_AppCertificationInfo__NONDRIVE_CERTIFIED_ONLY:
    case T_e8_AppCertificationInfo__DRIVE_CERTIFIED_ONLY:
    case T_e8_AppCertificationInfo__DRIVE_CERTIFIED:
        return true;
    default:
        return false;
    }
}

bool T_e8_AppCertificationEntity_Parse (const char *str, size_t length, T_e8_AppCertificationEntity &value)
{
    static stringEntry entries[] = {
        {13,"CCC_CERTIFIED", 1U},
        {13,"NOT_CERTIFIED", 0U},
        {20,"CCC_MEMBER_CERTIFIED", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_AppCertificationEntity_Name (T_e8_AppCertificationEntity value)
{
    static const char* enumerationLiterals[] = {
        "NOT_CERTIFIED",
        "CCC_CERTIFIED",
        "CCC_MEMBER_CERTIFIED",
    };

    if (T_e8_AppCertificationEntity_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AppCertificationEntity_IsValid (T_e8_AppCertificationEntity value)
{
    switch (value) {
    case T_e8_AppCertificationEntity__NOT_CERTIFIED:
    case T_e8_AppCertificationEntity__CCC_CERTIFIED:
    case T_e8_AppCertificationEntity__CCC_MEMBER_CERTIFIED:
        return true;
    default:
        return false;
    }
}

bool T_e8_AppStatus_Parse (const char *str, size_t length, T_e8_AppStatus &value)
{
    static stringEntry entries[] = {
        {10,"BACKGROUND", 1U},
        {10,"FOREGROUND", 0U},
        {10,"NOTRUNNING", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_AppStatus_Name (T_e8_AppStatus value)
{
    static const char* enumerationLiterals[] = {
        "FOREGROUND",
        "BACKGROUND",
        "NOTRUNNING",
    };

    if (T_e8_AppStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AppStatus_IsValid (T_e8_AppStatus value)
{
    switch (value) {
    case T_e8_AppStatus__FOREGROUND:
    case T_e8_AppStatus__BACKGROUND:
    case T_e8_AppStatus__NOTRUNNING:
        return true;
    default:
        return false;
    }
}

bool T_e8_DisplayContext_Parse (const char *str, size_t length, T_e8_DisplayContext &value)
{
    static stringEntry entries[] = {
        {21,"DISPLAY_CONTEXT_MEDIA", 4U},
        {21,"DISPLAY_CONTEXT_PHONE", 2U},
        {22,"DISPLAY_CONTEXT_NATIVE", 12U},
        {23,"DISPLAY_CONTEXT_UNKNOWN", 0U},
        {24,"DISPLAY_CONTEXT_SPEAKING", 7U},
        {25,"DISPLAY_CONTEXT_EMERGENCY", 6U},
        {26,"DISPLAY_CONTEXT_NAVIGATION", 3U},
        {26,"DISPLAY_CONTEXT_PROJECTION", 13U},
        {26,"DISPLAY_CONTEXT_SLEEP_MODE", 9U},
        {26,"DISPLAY_CONTEXT_SPEECH_REC", 1U},
        {26,"DISPLAY_CONTEXT_USER_INPUT", 14U},
        {28,"DISPLAY_CONTEXT_SCREEN_SAVER", 11U},
        {28,"DISPLAY_CONTEXT_STANDBY_MODE", 10U},
        {29,"DISPLAY_CONTEXT_INFORMATIONAL", 5U},
        {30,"DISPLAY_CONTEXT_TBT_NAVIGATION", 8U},
    };

    return lookupInStringEntryTable (str, length, entries, 15, (unsigned int&) value);
}

const char* T_e8_DisplayContext_Name (T_e8_DisplayContext value)
{
    static const char* enumerationLiterals[] = {
        "DISPLAY_CONTEXT_UNKNOWN",
        "DISPLAY_CONTEXT_SPEECH_REC",
        "DISPLAY_CONTEXT_PHONE",
        "DISPLAY_CONTEXT_NAVIGATION",
        "DISPLAY_CONTEXT_MEDIA",
        "DISPLAY_CONTEXT_INFORMATIONAL",
        "DISPLAY_CONTEXT_EMERGENCY",
        "DISPLAY_CONTEXT_SPEAKING",
        "DISPLAY_CONTEXT_TBT_NAVIGATION",
        "DISPLAY_CONTEXT_SLEEP_MODE",
        "DISPLAY_CONTEXT_STANDBY_MODE",
        "DISPLAY_CONTEXT_SCREEN_SAVER",
        "DISPLAY_CONTEXT_NATIVE",
        "DISPLAY_CONTEXT_PROJECTION",
        "DISPLAY_CONTEXT_USER_INPUT",
    };

    if (T_e8_DisplayContext_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DisplayContext_IsValid (T_e8_DisplayContext value)
{
    switch (value) {
    case T_e8_DisplayContext__DISPLAY_CONTEXT_UNKNOWN:
    case T_e8_DisplayContext__DISPLAY_CONTEXT_SPEECH_REC:
    case T_e8_DisplayContext__DISPLAY_CONTEXT_PHONE:
    case T_e8_DisplayContext__DISPLAY_CONTEXT_NAVIGATION:
    case T_e8_DisplayContext__DISPLAY_CONTEXT_MEDIA:
    case T_e8_DisplayContext__DISPLAY_CONTEXT_INFORMATIONAL:
    case T_e8_DisplayContext__DISPLAY_CONTEXT_EMERGENCY:
    case T_e8_DisplayContext__DISPLAY_CONTEXT_SPEAKING:
    case T_e8_DisplayContext__DISPLAY_CONTEXT_TBT_NAVIGATION:
    case T_e8_DisplayContext__DISPLAY_CONTEXT_SLEEP_MODE:
    case T_e8_DisplayContext__DISPLAY_CONTEXT_STANDBY_MODE:
    case T_e8_DisplayContext__DISPLAY_CONTEXT_SCREEN_SAVER:
    case T_e8_DisplayContext__DISPLAY_CONTEXT_NATIVE:
    case T_e8_DisplayContext__DISPLAY_CONTEXT_PROJECTION:
    case T_e8_DisplayContext__DISPLAY_CONTEXT_USER_INPUT:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAPStatus_Parse (const char *str, size_t length, T_e8_DAPStatus &value)
{
    static stringEntry entries[] = {
        {10,"DAP_FAILED", 4U},
        {11,"DAP_SUCCESS", 3U},
        {11,"DAP_UNKNOWN", 0U},
        {15,"DAP_IN_PROGRESS", 2U},
        {17,"DAP_NOT_SUPPORTED", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_DAPStatus_Name (T_e8_DAPStatus value)
{
    static const char* enumerationLiterals[] = {
        "DAP_UNKNOWN",
        "DAP_NOT_SUPPORTED",
        "DAP_IN_PROGRESS",
        "DAP_SUCCESS",
        "DAP_FAILED",
    };

    if (T_e8_DAPStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAPStatus_IsValid (T_e8_DAPStatus value)
{
    switch (value) {
    case T_e8_DAPStatus__DAP_UNKNOWN:
    case T_e8_DAPStatus__DAP_NOT_SUPPORTED:
    case T_e8_DAPStatus__DAP_IN_PROGRESS:
    case T_e8_DAPStatus__DAP_SUCCESS:
    case T_e8_DAPStatus__DAP_FAILED:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPOAppType_Parse (const char *str, size_t length, T_e8_DiPOAppType &value)
{
    static stringEntry entries[] = {
        {9,"DIPO_MAPS", 2U},
        {10,"DIPO_MUSIC", 8U},
        {11,"DIPO_NO_URL", 1U},
        {13,"DIPO_NOT_USED", 0U},
        {15,"DIPO_NOWPLAYING", 9U},
        {15,"DIPO_TEL_NUMBER", 4U},
        {16,"DIPO_MOBILEPHONE", 3U},
        {17,"DIPO_SIRI_PREWARN", 5U},
        {18,"DIPO_SIRI_BUTTONUP", 7U},
        {20,"DIPO_SIRI_BUTTONDOWN", 6U},
    };

    return lookupInStringEntryTable (str, length, entries, 10, (unsigned int&) value);
}

const char* T_e8_DiPOAppType_Name (T_e8_DiPOAppType value)
{
    static const char* enumerationLiterals[] = {
        "DIPO_NOT_USED",
        "DIPO_NO_URL",
        "DIPO_MAPS",
        "DIPO_MOBILEPHONE",
        "DIPO_TEL_NUMBER",
        "DIPO_SIRI_PREWARN",
        "DIPO_SIRI_BUTTONDOWN",
        "DIPO_SIRI_BUTTONUP",
        "DIPO_MUSIC",
        "DIPO_NOWPLAYING",
    };

    if (T_e8_DiPOAppType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPOAppType_IsValid (T_e8_DiPOAppType value)
{
    switch (value) {
    case T_e8_DiPOAppType__DIPO_NOT_USED:
    case T_e8_DiPOAppType__DIPO_NO_URL:
    case T_e8_DiPOAppType__DIPO_MAPS:
    case T_e8_DiPOAppType__DIPO_MOBILEPHONE:
    case T_e8_DiPOAppType__DIPO_TEL_NUMBER:
    case T_e8_DiPOAppType__DIPO_SIRI_PREWARN:
    case T_e8_DiPOAppType__DIPO_SIRI_BUTTONDOWN:
    case T_e8_DiPOAppType__DIPO_SIRI_BUTTONUP:
    case T_e8_DiPOAppType__DIPO_MUSIC:
    case T_e8_DiPOAppType__DIPO_NOWPLAYING:
        return true;
    default:
        return false;
    }
}

bool T_e8_EcnrSetting_Parse (const char *str, size_t length, T_e8_EcnrSetting &value)
{
    static stringEntry entries[] = {
        {10,"ECNR_VOICE", 1U},
        {11,"ECNR_SERVER", 2U},
        {13,"ECNR_NOCHANGE", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_EcnrSetting_Name (T_e8_EcnrSetting value)
{
    static const char* enumerationLiterals[] = {
        "ECNR_NOCHANGE",
        "ECNR_VOICE",
        "ECNR_SERVER",
    };

    if (T_e8_EcnrSetting_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_EcnrSetting_IsValid (T_e8_EcnrSetting value)
{
    switch (value) {
    case T_e8_EcnrSetting__ECNR_NOCHANGE:
    case T_e8_EcnrSetting__ECNR_VOICE:
    case T_e8_EcnrSetting__ECNR_SERVER:
        return true;
    default:
        return false;
    }
}

bool T_e8_BTChangeInfo_Parse (const char *str, size_t length, T_e8_BTChangeInfo &value)
{
    static stringEntry entries[] = {
        {9,"NO_CHANGE", 0U},
        {15,"SWITCH_BT_TO_CL", 8U},
        {15,"SWITCH_BT_TO_ML", 1U},
        {15,"SWITCH_CL_TO_BT", 7U},
        {15,"SWITCH_ML_TO_BT", 3U},
        {16,"SWITCH_AAP_TO_BT", 6U},
        {16,"SWITCH_BT_TO_AAP", 5U},
        {17,"SWITCH_BT_TO_DIPO", 2U},
        {17,"SWITCH_DIPO_TO_BT", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 9, (unsigned int&) value);
}

const char* T_e8_BTChangeInfo_Name (T_e8_BTChangeInfo value)
{
    static const char* enumerationLiterals[] = {
        "NO_CHANGE",
        "SWITCH_BT_TO_ML",
        "SWITCH_BT_TO_DIPO",
        "SWITCH_ML_TO_BT",
        "SWITCH_DIPO_TO_BT",
        "SWITCH_BT_TO_AAP",
        "SWITCH_AAP_TO_BT",
        "SWITCH_CL_TO_BT",
        "SWITCH_BT_TO_CL",
    };

    if (T_e8_BTChangeInfo_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_BTChangeInfo_IsValid (T_e8_BTChangeInfo value)
{
    switch (value) {
    case T_e8_BTChangeInfo__NO_CHANGE:
    case T_e8_BTChangeInfo__SWITCH_BT_TO_ML:
    case T_e8_BTChangeInfo__SWITCH_BT_TO_DIPO:
    case T_e8_BTChangeInfo__SWITCH_ML_TO_BT:
    case T_e8_BTChangeInfo__SWITCH_DIPO_TO_BT:
    case T_e8_BTChangeInfo__SWITCH_BT_TO_AAP:
    case T_e8_BTChangeInfo__SWITCH_AAP_TO_BT:
    case T_e8_BTChangeInfo__SWITCH_CL_TO_BT:
    case T_e8_BTChangeInfo__SWITCH_BT_TO_CL:
        return true;
    default:
        return false;
    }
}

bool T_e8_Vehicle_Configuration_Parse (const char *str, size_t length, T_e8_Vehicle_Configuration &value)
{
    static stringEntry entries[] = {
        {8,"DAY_MODE", 2U},
        {10,"NIGHT_MODE", 3U},
        {15,"LEFT_HAND_DRIVE", 5U},
        {16,"RIGHT_HAND_DRIVE", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_Vehicle_Configuration_Name (T_e8_Vehicle_Configuration value)
{
    static const char* enumerationLiterals[] = {
        "DAY_MODE",
        "NIGHT_MODE",
        "RIGHT_HAND_DRIVE",
        "LEFT_HAND_DRIVE",
    };

    if (T_e8_Vehicle_Configuration_IsValid(value))
        return enumerationLiterals[value - 2U];
    else
        return NULL;
}

bool T_e8_Vehicle_Configuration_IsValid (T_e8_Vehicle_Configuration value)
{
    switch (value) {
    case T_e8_Vehicle_Configuration__DAY_MODE:
    case T_e8_Vehicle_Configuration__NIGHT_MODE:
    case T_e8_Vehicle_Configuration__RIGHT_HAND_DRIVE:
    case T_e8_Vehicle_Configuration__LEFT_HAND_DRIVE:
        return true;
    default:
        return false;
    }
}

bool T_e8_Region_Parse (const char *str, size_t length, T_e8_Region &value)
{
    static stringEntry entries[] = {
        {2,"EU", 1U},
        {3,"AUS", 6U},
        {3,"CAN", 3U},
        {3,"CHN", 9U},
        {3,"EPE", 2U},
        {3,"HKG", 10U},
        {3,"IND", 12U},
        {3,"JPN", 8U},
        {3,"KOR", 7U},
        {3,"TPE", 11U},
        {3,"USA", 4U},
        {4,"APAC", 13U},
        {5,"WORLD", 0U},
        {6,"AFRICA", 14U},
        {7,"AMERICA", 5U},
    };

    return lookupInStringEntryTable (str, length, entries, 15, (unsigned int&) value);
}

const char* T_e8_Region_Name (T_e8_Region value)
{
    static const char* enumerationLiterals[] = {
        "WORLD",
        "EU",
        "EPE",
        "CAN",
        "USA",
        "AMERICA",
        "AUS",
        "KOR",
        "JPN",
        "CHN",
        "HKG",
        "TPE",
        "IND",
        "APAC",
        "AFRICA",
    };

    if (T_e8_Region_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Region_IsValid (T_e8_Region value)
{
    switch (value) {
    case T_e8_Region__WORLD:
    case T_e8_Region__EU:
    case T_e8_Region__EPE:
    case T_e8_Region__CAN:
    case T_e8_Region__USA:
    case T_e8_Region__AMERICA:
    case T_e8_Region__AUS:
    case T_e8_Region__KOR:
    case T_e8_Region__JPN:
    case T_e8_Region__CHN:
    case T_e8_Region__HKG:
    case T_e8_Region__TPE:
    case T_e8_Region__IND:
    case T_e8_Region__APAC:
    case T_e8_Region__AFRICA:
        return true;
    default:
        return false;
    }
}

bool T_e8_SupportInfo_Parse (const char *str, size_t length, T_e8_SupportInfo &value)
{
    static stringEntry entries[] = {
        {9,"SUPPORTED", 1U},
        {13,"NOT_SUPPORTED", 2U},
        {17,"SUPPORT_NOT_KNOWN", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_SupportInfo_Name (T_e8_SupportInfo value)
{
    static const char* enumerationLiterals[] = {
        "SUPPORT_NOT_KNOWN",
        "SUPPORTED",
        "NOT_SUPPORTED",
    };

    if (T_e8_SupportInfo_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_SupportInfo_IsValid (T_e8_SupportInfo value)
{
    switch (value) {
    case T_e8_SupportInfo__SUPPORT_NOT_KNOWN:
    case T_e8_SupportInfo__SUPPORTED:
    case T_e8_SupportInfo__NOT_SUPPORTED:
        return true;
    default:
        return false;
    }
}

bool T_e8_USBPortType_Parse (const char *str, size_t length, T_e8_USBPortType &value)
{
    static stringEntry entries[] = {
        {13,"PORT_TYPE_OTG", 1U},
        {17,"PORT_TYPE_NON_OTG", 2U},
        {19,"PORT_TYPE_NOT_KNOWN", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_USBPortType_Name (T_e8_USBPortType value)
{
    static const char* enumerationLiterals[] = {
        "PORT_TYPE_NOT_KNOWN",
        "PORT_TYPE_OTG",
        "PORT_TYPE_NON_OTG",
    };

    if (T_e8_USBPortType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_USBPortType_IsValid (T_e8_USBPortType value)
{
    switch (value) {
    case T_e8_USBPortType__PORT_TYPE_NOT_KNOWN:
    case T_e8_USBPortType__PORT_TYPE_OTG:
    case T_e8_USBPortType__PORT_TYPE_NON_OTG:
        return true;
    default:
        return false;
    }
}

bool T_e8_DeviceType_Parse (const char *str, size_t length, T_e8_DeviceType &value)
{
    static stringEntry entries[] = {
        {12,"APPLE_DEVICE", 2U},
        {14,"ANDROID_DEVICE", 1U},
        {19,"DEVICE_TYPE_UNKNOWN", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_DeviceType_Name (T_e8_DeviceType value)
{
    static const char* enumerationLiterals[] = {
        "DEVICE_TYPE_UNKNOWN",
        "ANDROID_DEVICE",
        "APPLE_DEVICE",
    };

    if (T_e8_DeviceType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DeviceType_IsValid (T_e8_DeviceType value)
{
    switch (value) {
    case T_e8_DeviceType__DEVICE_TYPE_UNKNOWN:
    case T_e8_DeviceType__ANDROID_DEVICE:
    case T_e8_DeviceType__APPLE_DEVICE:
        return true;
    default:
        return false;
    }
}

bool T_e8_DeviceSelectionState_Parse (const char *str, size_t length, T_e8_DeviceSelectionState &value)
{
    static stringEntry entries[] = {
        {15,"DEVICE_SELECTED", 2U},
        {19,"DEVICE_NOT_SELECTED", 0U},
        {22,"DEVICE_SELECTION_ERROR", 5U},
        {22,"DEVICE_USER_DESELECTED", 4U},
        {24,"DEVICE_DESELECTION_ERROR", 6U},
        {27,"DEVICE_SELECTION_INPROGRESS", 1U},
        {29,"DEVICE_DESELECTION_INPROGRESS", 3U},
        {32,"DEVICE_REENUMERATION_IN_PROGRESS", 7U},
    };

    return lookupInStringEntryTable (str, length, entries, 8, (unsigned int&) value);
}

const char* T_e8_DeviceSelectionState_Name (T_e8_DeviceSelectionState value)
{
    static const char* enumerationLiterals[] = {
        "DEVICE_NOT_SELECTED",
        "DEVICE_SELECTION_INPROGRESS",
        "DEVICE_SELECTED",
        "DEVICE_DESELECTION_INPROGRESS",
        "DEVICE_USER_DESELECTED",
        "DEVICE_SELECTION_ERROR",
        "DEVICE_DESELECTION_ERROR",
        "DEVICE_REENUMERATION_IN_PROGRESS",
    };

    if (T_e8_DeviceSelectionState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DeviceSelectionState_IsValid (T_e8_DeviceSelectionState value)
{
    switch (value) {
    case T_e8_DeviceSelectionState__DEVICE_NOT_SELECTED:
    case T_e8_DeviceSelectionState__DEVICE_SELECTION_INPROGRESS:
    case T_e8_DeviceSelectionState__DEVICE_SELECTED:
    case T_e8_DeviceSelectionState__DEVICE_DESELECTION_INPROGRESS:
    case T_e8_DeviceSelectionState__DEVICE_USER_DESELECTED:
    case T_e8_DeviceSelectionState__DEVICE_SELECTION_ERROR:
    case T_e8_DeviceSelectionState__DEVICE_DESELECTION_ERROR:
    case T_e8_DeviceSelectionState__DEVICE_REENUMERATION_IN_PROGRESS:
        return true;
    default:
        return false;
    }
}

bool T_e8_DeviceSelectionErrorType_Parse (const char *str, size_t length, T_e8_DeviceSelectionErrorType &value)
{
    static stringEntry entries[] = {
        {27,"DEVICE_SELECTION_ERROR_NONE", 0U},
        {29,"DEVICE_SELECTION_DEVICE_ERROR", 3U},
        {33,"DEVICE_SELECTION_STA_DISCONNECTED", 10U},
        {34,"DEVICE_SELECTION_CANCELLED_BY_USER", 5U},
        {35,"DEVICE_SELECTION_DEVICE_ERROR_FATAL", 6U},
        {36,"DEVICE_SELECTION_ERROR_NOT_CONNECTED", 1U},
        {36,"DEVICE_SELECTION_ERROR_RESOURCE_BUSY", 2U},
        {36,"DEVICE_SELECTION_ERROR_SWITCH_FAILED", 11U},
        {36,"DEVICE_SELECTION_WIFI_AP_SETUP_ERROR", 9U},
        {38,"DEVICE_SELECTION_ERROR_USBRESET_FAILED", 4U},
        {40,"DEVICE_SELECTION_ERROR_APP_NOT_INSTALLED", 8U},
        {40,"DEVICE_SELECTION_ERROR_PHONE_UNSUPPORTED", 7U},
    };

    return lookupInStringEntryTable (str, length, entries, 12, (unsigned int&) value);
}

const char* T_e8_DeviceSelectionErrorType_Name (T_e8_DeviceSelectionErrorType value)
{
    static const char* enumerationLiterals[] = {
        "DEVICE_SELECTION_ERROR_NONE",
        "DEVICE_SELECTION_ERROR_NOT_CONNECTED",
        "DEVICE_SELECTION_ERROR_RESOURCE_BUSY",
        "DEVICE_SELECTION_DEVICE_ERROR",
        "DEVICE_SELECTION_ERROR_USBRESET_FAILED",
        "DEVICE_SELECTION_CANCELLED_BY_USER",
        "DEVICE_SELECTION_DEVICE_ERROR_FATAL",
        "DEVICE_SELECTION_ERROR_PHONE_UNSUPPORTED",
        "DEVICE_SELECTION_ERROR_APP_NOT_INSTALLED",
        "DEVICE_SELECTION_WIFI_AP_SETUP_ERROR",
        "DEVICE_SELECTION_STA_DISCONNECTED",
        "DEVICE_SELECTION_ERROR_SWITCH_FAILED",
    };

    if (T_e8_DeviceSelectionErrorType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DeviceSelectionErrorType_IsValid (T_e8_DeviceSelectionErrorType value)
{
    switch (value) {
    case T_e8_DeviceSelectionErrorType__DEVICE_SELECTION_ERROR_NONE:
    case T_e8_DeviceSelectionErrorType__DEVICE_SELECTION_ERROR_NOT_CONNECTED:
    case T_e8_DeviceSelectionErrorType__DEVICE_SELECTION_ERROR_RESOURCE_BUSY:
    case T_e8_DeviceSelectionErrorType__DEVICE_SELECTION_DEVICE_ERROR:
    case T_e8_DeviceSelectionErrorType__DEVICE_SELECTION_ERROR_USBRESET_FAILED:
    case T_e8_DeviceSelectionErrorType__DEVICE_SELECTION_CANCELLED_BY_USER:
    case T_e8_DeviceSelectionErrorType__DEVICE_SELECTION_DEVICE_ERROR_FATAL:
    case T_e8_DeviceSelectionErrorType__DEVICE_SELECTION_ERROR_PHONE_UNSUPPORTED:
    case T_e8_DeviceSelectionErrorType__DEVICE_SELECTION_ERROR_APP_NOT_INSTALLED:
    case T_e8_DeviceSelectionErrorType__DEVICE_SELECTION_WIFI_AP_SETUP_ERROR:
    case T_e8_DeviceSelectionErrorType__DEVICE_SELECTION_STA_DISCONNECTED:
    case T_e8_DeviceSelectionErrorType__DEVICE_SELECTION_ERROR_SWITCH_FAILED:
        return true;
    default:
        return false;
    }
}

bool T_e8_SelectionType_Parse (const char *str, size_t length, T_e8_SelectionType &value)
{
    static stringEntry entries[] = {
        {22,"SELECTION_TYPE_UNKNOWN", 0U},
        {28,"SELECTION_TYPE_HMI_TRIGGERED", 2U},
        {29,"SELECTION_TYPE_USER_TRIGGERED", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_SelectionType_Name (T_e8_SelectionType value)
{
    static const char* enumerationLiterals[] = {
        "SELECTION_TYPE_UNKNOWN",
        "SELECTION_TYPE_USER_TRIGGERED",
        "SELECTION_TYPE_HMI_TRIGGERED",
    };

    if (T_e8_SelectionType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_SelectionType_IsValid (T_e8_SelectionType value)
{
    switch (value) {
    case T_e8_SelectionType__SELECTION_TYPE_UNKNOWN:
    case T_e8_SelectionType__SELECTION_TYPE_USER_TRIGGERED:
    case T_e8_SelectionType__SELECTION_TYPE_HMI_TRIGGERED:
        return true;
    default:
        return false;
    }
}

bool T_e8_VideoBlockingReason_Parse (const char *str, size_t length, T_e8_VideoBlockingReason &value)
{
    static stringEntry entries[] = {
        {33,"VIDEO_BLOCKING_REASON_INVALID_APP", 1U},
        {33,"VIDEO_BLOCKING_REASON_USER_ACTION", 0U},
        {35,"VIDEO_BLOCKING_REASON_DISPLAY_VIDEO", 4U},
        {35,"VIDEO_BLOCKING_REASON_NON_DRIVE_APP", 2U},
        {35,"VIDEO_BLOCKING_REASON_PHONE_REQUEST", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_VideoBlockingReason_Name (T_e8_VideoBlockingReason value)
{
    static const char* enumerationLiterals[] = {
        "VIDEO_BLOCKING_REASON_USER_ACTION",
        "VIDEO_BLOCKING_REASON_INVALID_APP",
        "VIDEO_BLOCKING_REASON_NON_DRIVE_APP",
        "VIDEO_BLOCKING_REASON_PHONE_REQUEST",
        "VIDEO_BLOCKING_REASON_DISPLAY_VIDEO",
    };

    if (T_e8_VideoBlockingReason_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_VideoBlockingReason_IsValid (T_e8_VideoBlockingReason value)
{
    switch (value) {
    case T_e8_VideoBlockingReason__VIDEO_BLOCKING_REASON_USER_ACTION:
    case T_e8_VideoBlockingReason__VIDEO_BLOCKING_REASON_INVALID_APP:
    case T_e8_VideoBlockingReason__VIDEO_BLOCKING_REASON_NON_DRIVE_APP:
    case T_e8_VideoBlockingReason__VIDEO_BLOCKING_REASON_PHONE_REQUEST:
    case T_e8_VideoBlockingReason__VIDEO_BLOCKING_REASON_DISPLAY_VIDEO:
        return true;
    default:
        return false;
    }
}

bool T_e8_DeviceSelectionProgressState_Parse (const char *str, size_t length, T_e8_DeviceSelectionProgressState &value)
{
    static stringEntry entries[] = {
        {14,"AUTHENTICATING", 4U},
        {14,"NOT_APPLICABLE", 0U},
        {17,"SERVICE_DISCOVERY", 3U},
        {17,"SWITCHING_PROFILE", 1U},
        {19,"PREPARING_ENDPOINTS", 2U},
        {23,"RESOURCE_INITIALIZATION", 5U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_DeviceSelectionProgressState_Name (T_e8_DeviceSelectionProgressState value)
{
    static const char* enumerationLiterals[] = {
        "NOT_APPLICABLE",
        "SWITCHING_PROFILE",
        "PREPARING_ENDPOINTS",
        "SERVICE_DISCOVERY",
        "AUTHENTICATING",
        "RESOURCE_INITIALIZATION",
    };

    if (T_e8_DeviceSelectionProgressState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DeviceSelectionProgressState_IsValid (T_e8_DeviceSelectionProgressState value)
{
    switch (value) {
    case T_e8_DeviceSelectionProgressState__NOT_APPLICABLE:
    case T_e8_DeviceSelectionProgressState__SWITCHING_PROFILE:
    case T_e8_DeviceSelectionProgressState__PREPARING_ENDPOINTS:
    case T_e8_DeviceSelectionProgressState__SERVICE_DISCOVERY:
    case T_e8_DeviceSelectionProgressState__AUTHENTICATING:
    case T_e8_DeviceSelectionProgressState__RESOURCE_INITIALIZATION:
        return true;
    default:
        return false;
    }
}

bool T_e8_UserAuthorizationStatus_Parse (const char *str, size_t length, T_e8_UserAuthorizationStatus &value)
{
    static stringEntry entries[] = {
        {17,"USER_AUTH_UNKNOWN", 0U},
        {19,"USER_AUTH_CANCELLED", 3U},
        {20,"USER_AUTH_AUTHORIZED", 2U},
        {22,"USER_AUTH_UNAUTHORIZED", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_UserAuthorizationStatus_Name (T_e8_UserAuthorizationStatus value)
{
    static const char* enumerationLiterals[] = {
        "USER_AUTH_UNKNOWN",
        "USER_AUTH_UNAUTHORIZED",
        "USER_AUTH_AUTHORIZED",
        "USER_AUTH_CANCELLED",
    };

    if (T_e8_UserAuthorizationStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_UserAuthorizationStatus_IsValid (T_e8_UserAuthorizationStatus value)
{
    switch (value) {
    case T_e8_UserAuthorizationStatus__USER_AUTH_UNKNOWN:
    case T_e8_UserAuthorizationStatus__USER_AUTH_UNAUTHORIZED:
    case T_e8_UserAuthorizationStatus__USER_AUTH_AUTHORIZED:
    case T_e8_UserAuthorizationStatus__USER_AUTH_CANCELLED:
        return true;
    default:
        return false;
    }
}

bool T_e8_PlayBackState_Parse (const char *str, size_t length, T_e8_PlayBackState &value)
{
    static stringEntry entries[] = {
        {6,"PAUSED", 2U},
        {7,"PLAYING", 1U},
        {7,"STOPPED", 0U},
        {9,"NOT_KNOWN", 255U},
        {11,"SEEKFORWARD", 3U},
        {12,"SEEKBACKWARD", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_PlayBackState_Name (T_e8_PlayBackState value)
{
    static const char* enumerationLiterals[] = {
        "STOPPED",
        "PLAYING",
        "PAUSED",
        "SEEKFORWARD",
        "SEEKBACKWARD",
        "NOT_KNOWN",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 6, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_PlayBackState_IsValid (T_e8_PlayBackState value)
{
    switch (value) {
    case T_e8_PlayBackState__NOT_KNOWN:
    case T_e8_PlayBackState__STOPPED:
    case T_e8_PlayBackState__PLAYING:
    case T_e8_PlayBackState__PAUSED:
    case T_e8_PlayBackState__SEEKFORWARD:
    case T_e8_PlayBackState__SEEKBACKWARD:
        return true;
    default:
        return false;
    }
}

bool T_e8_PlayBackShuffleState_Parse (const char *str, size_t length, T_e8_PlayBackShuffleState &value)
{
    static stringEntry entries[] = {
        {2,"ON", 3U},
        {3,"OFF", 0U},
        {5,"SONGS", 1U},
        {6,"ALBUMS", 2U},
        {9,"NOT_KNOWN", 255U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_PlayBackShuffleState_Name (T_e8_PlayBackShuffleState value)
{
    static const char* enumerationLiterals[] = {
        "OFF",
        "SONGS",
        "ALBUMS",
        "ON",
        "NOT_KNOWN",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 5, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_PlayBackShuffleState_IsValid (T_e8_PlayBackShuffleState value)
{
    switch (value) {
    case T_e8_PlayBackShuffleState__NOT_KNOWN:
    case T_e8_PlayBackShuffleState__OFF:
    case T_e8_PlayBackShuffleState__SONGS:
    case T_e8_PlayBackShuffleState__ALBUMS:
    case T_e8_PlayBackShuffleState__ON:
        return true;
    default:
        return false;
    }
}

bool T_e8_PlayBackRepeatState_Parse (const char *str, size_t length, T_e8_PlayBackRepeatState &value)
{
    static stringEntry entries[] = {
        {3,"ALL", 2U},
        {3,"OFF", 0U},
        {3,"ONE", 1U},
        {9,"NOT_KNOWN", 255U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_PlayBackRepeatState_Name (T_e8_PlayBackRepeatState value)
{
    static const char* enumerationLiterals[] = {
        "OFF",
        "ONE",
        "ALL",
        "NOT_KNOWN",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 4, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_PlayBackRepeatState_IsValid (T_e8_PlayBackRepeatState value)
{
    switch (value) {
    case T_e8_PlayBackRepeatState__NOT_KNOWN:
    case T_e8_PlayBackRepeatState__OFF:
    case T_e8_PlayBackRepeatState__ONE:
    case T_e8_PlayBackRepeatState__ALL:
        return true;
    default:
        return false;
    }
}

bool T_e8_PlayBackMediaType_Parse (const char *str, size_t length, T_e8_PlayBackMediaType &value)
{
    static stringEntry entries[] = {
        {5,"MUSIC", 0U},
        {7,"ITUNESU", 3U},
        {7,"PODCAST", 1U},
        {9,"AUDIOBOOK", 2U},
        {9,"NOT_KNOWN", 255U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_PlayBackMediaType_Name (T_e8_PlayBackMediaType value)
{
    static const char* enumerationLiterals[] = {
        "MUSIC",
        "PODCAST",
        "AUDIOBOOK",
        "ITUNESU",
        "NOT_KNOWN",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 5, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_PlayBackMediaType_IsValid (T_e8_PlayBackMediaType value)
{
    switch (value) {
    case T_e8_PlayBackMediaType__NOT_KNOWN:
    case T_e8_PlayBackMediaType__MUSIC:
    case T_e8_PlayBackMediaType__PODCAST:
    case T_e8_PlayBackMediaType__AUDIOBOOK:
    case T_e8_PlayBackMediaType__ITUNESU:
        return true;
    default:
        return false;
    }
}

bool T_e8_PhoneSignalStrength_Parse (const char *str, size_t length, T_e8_PhoneSignalStrength &value)
{
    static stringEntry entries[] = {
        {7,"ONE_BAR", 1U},
        {8,"TWO_BARS", 2U},
        {9,"FIVE_BARS", 5U},
        {9,"FOUR_BARS", 4U},
        {9,"NOT_KNOWN", 255U},
        {9,"ZERO_BARS", 0U},
        {10,"THREE_BARS", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 7, (unsigned int&) value);
}

const char* T_e8_PhoneSignalStrength_Name (T_e8_PhoneSignalStrength value)
{
    static const char* enumerationLiterals[] = {
        "ZERO_BARS",
        "ONE_BAR",
        "TWO_BARS",
        "THREE_BARS",
        "FOUR_BARS",
        "FIVE_BARS",
        "NOT_KNOWN",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 7, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_PhoneSignalStrength_IsValid (T_e8_PhoneSignalStrength value)
{
    switch (value) {
    case T_e8_PhoneSignalStrength__NOT_KNOWN:
    case T_e8_PhoneSignalStrength__ZERO_BARS:
    case T_e8_PhoneSignalStrength__ONE_BAR:
    case T_e8_PhoneSignalStrength__TWO_BARS:
    case T_e8_PhoneSignalStrength__THREE_BARS:
    case T_e8_PhoneSignalStrength__FOUR_BARS:
    case T_e8_PhoneSignalStrength__FIVE_BARS:
        return true;
    default:
        return false;
    }
}

bool T_e8_PhoneRegistrationStatus_Parse (const char *str, size_t length, T_e8_PhoneRegistrationStatus &value)
{
    static stringEntry entries[] = {
        {6,"DENIED", 3U},
        {9,"NOT_KNOWN", 255U},
        {9,"SEARCHING", 2U},
        {14,"NOT_REGISTERED", 1U},
        {15,"REGISTERED_HOME", 4U},
        {18,"REGISTERED_ROAMING", 5U},
        {20,"EMERGENCY_CALLS_ONLY", 6U},
    };

    return lookupInStringEntryTable (str, length, entries, 7, (unsigned int&) value);
}

const char* T_e8_PhoneRegistrationStatus_Name (T_e8_PhoneRegistrationStatus value)
{
    static const char* enumerationLiterals[] = {
        "NOT_REGISTERED",
        "SEARCHING",
        "DENIED",
        "REGISTERED_HOME",
        "REGISTERED_ROAMING",
        "EMERGENCY_CALLS_ONLY",
        "NOT_KNOWN",
    };

    static unsigned int enumerationValues[] = {
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 7, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_PhoneRegistrationStatus_IsValid (T_e8_PhoneRegistrationStatus value)
{
    switch (value) {
    case T_e8_PhoneRegistrationStatus__NOT_KNOWN:
    case T_e8_PhoneRegistrationStatus__NOT_REGISTERED:
    case T_e8_PhoneRegistrationStatus__SEARCHING:
    case T_e8_PhoneRegistrationStatus__DENIED:
    case T_e8_PhoneRegistrationStatus__REGISTERED_HOME:
    case T_e8_PhoneRegistrationStatus__REGISTERED_ROAMING:
    case T_e8_PhoneRegistrationStatus__EMERGENCY_CALLS_ONLY:
        return true;
    default:
        return false;
    }
}

bool T_e8_PhoneAirPlaneModeStatus_Parse (const char *str, size_t length, T_e8_PhoneAirPlaneModeStatus &value)
{
    static stringEntry entries[] = {
        {4,"TRUE", 1U},
        {5,"FALSE", 0U},
        {9,"NOT_KNOWN", 255U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_PhoneAirPlaneModeStatus_Name (T_e8_PhoneAirPlaneModeStatus value)
{
    static const char* enumerationLiterals[] = {
        "FALSE",
        "TRUE",
        "NOT_KNOWN",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 3, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_PhoneAirPlaneModeStatus_IsValid (T_e8_PhoneAirPlaneModeStatus value)
{
    switch (value) {
    case T_e8_PhoneAirPlaneModeStatus__NOT_KNOWN:
    case T_e8_PhoneAirPlaneModeStatus__FALSE:
    case T_e8_PhoneAirPlaneModeStatus__TRUE:
        return true;
    default:
        return false;
    }
}

bool T_e8_PhoneCallState_Parse (const char *str, size_t length, T_e8_PhoneCallState &value)
{
    static stringEntry entries[] = {
        {4,"HELD", 5U},
        {6,"ACTIVE", 4U},
        {7,"RINGING", 2U},
        {7,"SENDING", 1U},
        {7,"UNKNOWN", 255U},
        {10,"CONNECTING", 3U},
        {12,"DISCONNECTED", 0U},
        {13,"DISCONNECTING", 6U},
    };

    return lookupInStringEntryTable (str, length, entries, 8, (unsigned int&) value);
}

const char* T_e8_PhoneCallState_Name (T_e8_PhoneCallState value)
{
    static const char* enumerationLiterals[] = {
        "DISCONNECTED",
        "SENDING",
        "RINGING",
        "CONNECTING",
        "ACTIVE",
        "HELD",
        "DISCONNECTING",
        "UNKNOWN",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 8, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_PhoneCallState_IsValid (T_e8_PhoneCallState value)
{
    switch (value) {
    case T_e8_PhoneCallState__DISCONNECTED:
    case T_e8_PhoneCallState__SENDING:
    case T_e8_PhoneCallState__RINGING:
    case T_e8_PhoneCallState__CONNECTING:
    case T_e8_PhoneCallState__ACTIVE:
    case T_e8_PhoneCallState__HELD:
    case T_e8_PhoneCallState__DISCONNECTING:
    case T_e8_PhoneCallState__UNKNOWN:
        return true;
    default:
        return false;
    }
}

bool T_e8_PhoneCallDirection_Parse (const char *str, size_t length, T_e8_PhoneCallDirection &value)
{
    static stringEntry entries[] = {
        {8,"INCOMING", 1U},
        {8,"OUTGOING", 2U},
        {9,"NOT_KNOWN", 255U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_PhoneCallDirection_Name (T_e8_PhoneCallDirection value)
{
    static const char* enumerationLiterals[] = {
        "INCOMING",
        "OUTGOING",
        "NOT_KNOWN",
    };

    static unsigned int enumerationValues[] = {
        1U,
        2U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 3, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_PhoneCallDirection_IsValid (T_e8_PhoneCallDirection value)
{
    switch (value) {
    case T_e8_PhoneCallDirection__NOT_KNOWN:
    case T_e8_PhoneCallDirection__INCOMING:
    case T_e8_PhoneCallDirection__OUTGOING:
        return true;
    default:
        return false;
    }
}

bool T_e8_Mute_Parse (const char *str, size_t length, T_e8_Mute &value)
{
    static stringEntry entries[] = {
        {4,"TRUE", 1U},
        {5,"FALSE", 0U},
        {9,"NOT_KNOWN", 255U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_Mute_Name (T_e8_Mute value)
{
    static const char* enumerationLiterals[] = {
        "FALSE",
        "TRUE",
        "NOT_KNOWN",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 3, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_Mute_IsValid (T_e8_Mute value)
{
    switch (value) {
    case T_e8_Mute__NOT_KNOWN:
    case T_e8_Mute__FALSE:
    case T_e8_Mute__TRUE:
        return true;
    default:
        return false;
    }
}

bool T_e8_CallStateUpdateDisconnectReason_Parse (const char *str, size_t length, T_e8_CallStateUpdateDisconnectReason &value)
{
    static stringEntry entries[] = {
        {33,"CALLSTATE_DISCONNECT_REASON_ENDED", 0U},
        {34,"CALLSTATE_DISCONNECT_REASON_FAILED", 2U},
        {35,"CALLSTATE_DISCONNECT_REASON_UNKNOWN", 255U},
        {36,"CALLSTATE_DISCONNECT_REASON_DECLINED", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_CallStateUpdateDisconnectReason_Name (T_e8_CallStateUpdateDisconnectReason value)
{
    static const char* enumerationLiterals[] = {
        "CALLSTATE_DISCONNECT_REASON_ENDED",
        "CALLSTATE_DISCONNECT_REASON_DECLINED",
        "CALLSTATE_DISCONNECT_REASON_FAILED",
        "CALLSTATE_DISCONNECT_REASON_UNKNOWN",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 4, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_CallStateUpdateDisconnectReason_IsValid (T_e8_CallStateUpdateDisconnectReason value)
{
    switch (value) {
    case T_e8_CallStateUpdateDisconnectReason__CALLSTATE_DISCONNECT_REASON_ENDED:
    case T_e8_CallStateUpdateDisconnectReason__CALLSTATE_DISCONNECT_REASON_DECLINED:
    case T_e8_CallStateUpdateDisconnectReason__CALLSTATE_DISCONNECT_REASON_FAILED:
    case T_e8_CallStateUpdateDisconnectReason__CALLSTATE_DISCONNECT_REASON_UNKNOWN:
        return true;
    default:
        return false;
    }
}

bool T_e8_AudioContext_Parse (const char *str, size_t length, T_e8_AudioContext &value)
{
    static stringEntry entries[] = {
        {14,"SPI_AUDIO_MAIN", 0U},
        {14,"SPI_AUDIO_MUTE", 14U},
        {15,"SPI_AUDIO_PHONE", 5U},
        {17,"SPI_AUDIO_TRAFFIC", 7U},
        {18,"SPI_AUDIO_SYNC_MSG", 9U},
        {20,"SPI_AUDIO_EMER_PHONE", 4U},
        {20,"SPI_AUDIO_INCOM_TONE", 6U},
        {20,"SPI_AUDIO_PROJECTION", 16U},
        {20,"SPI_AUDIO_SLEEP_MODE", 12U},
        {20,"SPI_AUDIO_SPEECH_REC", 2U},
        {22,"SPI_AUDIO_INTERNET_APP", 1U},
        {22,"SPI_AUDIO_MAIN_DEFAULT", 15U},
        {22,"SPI_AUDIO_STANDBY_MODE", 13U},
        {23,"SPI_AUDIO_ADVISOR_PHONE", 3U},
        {23,"SPI_AUDIO_EMERGENCY_MSG", 8U},
        {23,"SPI_AUDIO_MIX_BEEP_TONE", 11U},
        {25,"SPI_AUDIO_MIX_NAVI_PROMPT", 10U},
    };

    return lookupInStringEntryTable (str, length, entries, 17, (unsigned int&) value);
}

const char* T_e8_AudioContext_Name (T_e8_AudioContext value)
{
    static const char* enumerationLiterals[] = {
        "SPI_AUDIO_MAIN",
        "SPI_AUDIO_INTERNET_APP",
        "SPI_AUDIO_SPEECH_REC",
        "SPI_AUDIO_ADVISOR_PHONE",
        "SPI_AUDIO_EMER_PHONE",
        "SPI_AUDIO_PHONE",
        "SPI_AUDIO_INCOM_TONE",
        "SPI_AUDIO_TRAFFIC",
        "SPI_AUDIO_EMERGENCY_MSG",
        "SPI_AUDIO_SYNC_MSG",
        "SPI_AUDIO_MIX_NAVI_PROMPT",
        "SPI_AUDIO_MIX_BEEP_TONE",
        "SPI_AUDIO_SLEEP_MODE",
        "SPI_AUDIO_STANDBY_MODE",
        "SPI_AUDIO_MUTE",
        "SPI_AUDIO_MAIN_DEFAULT",
        "SPI_AUDIO_PROJECTION",
    };

    if (T_e8_AudioContext_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AudioContext_IsValid (T_e8_AudioContext value)
{
    switch (value) {
    case T_e8_AudioContext__SPI_AUDIO_MAIN:
    case T_e8_AudioContext__SPI_AUDIO_INTERNET_APP:
    case T_e8_AudioContext__SPI_AUDIO_SPEECH_REC:
    case T_e8_AudioContext__SPI_AUDIO_ADVISOR_PHONE:
    case T_e8_AudioContext__SPI_AUDIO_EMER_PHONE:
    case T_e8_AudioContext__SPI_AUDIO_PHONE:
    case T_e8_AudioContext__SPI_AUDIO_INCOM_TONE:
    case T_e8_AudioContext__SPI_AUDIO_TRAFFIC:
    case T_e8_AudioContext__SPI_AUDIO_EMERGENCY_MSG:
    case T_e8_AudioContext__SPI_AUDIO_SYNC_MSG:
    case T_e8_AudioContext__SPI_AUDIO_MIX_NAVI_PROMPT:
    case T_e8_AudioContext__SPI_AUDIO_MIX_BEEP_TONE:
    case T_e8_AudioContext__SPI_AUDIO_SLEEP_MODE:
    case T_e8_AudioContext__SPI_AUDIO_STANDBY_MODE:
    case T_e8_AudioContext__SPI_AUDIO_MUTE:
    case T_e8_AudioContext__SPI_AUDIO_MAIN_DEFAULT:
    case T_e8_AudioContext__SPI_AUDIO_PROJECTION:
        return true;
    default:
        return false;
    }
}

bool T_e8_SpeechAppState_Parse (const char *str, size_t length, T_e8_SpeechAppState &value)
{
    static stringEntry entries[] = {
        {24,"SPI_APP_STATE_SPEECH_END", 1U},
        {28,"SPI_APP_STATE_SPEECH_UNKNOWN", 0U},
        {29,"SPI_APP_STATE_SPEECH_SPEAKING", 3U},
        {32,"SPI_APP_STATE_SPEECH_RECOGNISING", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_SpeechAppState_Name (T_e8_SpeechAppState value)
{
    static const char* enumerationLiterals[] = {
        "SPI_APP_STATE_SPEECH_UNKNOWN",
        "SPI_APP_STATE_SPEECH_END",
        "SPI_APP_STATE_SPEECH_RECOGNISING",
        "SPI_APP_STATE_SPEECH_SPEAKING",
    };

    if (T_e8_SpeechAppState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_SpeechAppState_IsValid (T_e8_SpeechAppState value)
{
    switch (value) {
    case T_e8_SpeechAppState__SPI_APP_STATE_SPEECH_UNKNOWN:
    case T_e8_SpeechAppState__SPI_APP_STATE_SPEECH_END:
    case T_e8_SpeechAppState__SPI_APP_STATE_SPEECH_RECOGNISING:
    case T_e8_SpeechAppState__SPI_APP_STATE_SPEECH_SPEAKING:
        return true;
    default:
        return false;
    }
}

bool T_e8_PhoneAppState_Parse (const char *str, size_t length, T_e8_PhoneAppState &value)
{
    static stringEntry entries[] = {
        {26,"SPI_APP_STATE_PHONE_ACTIVE", 1U},
        {27,"SPI_APP_STATE_PHONE_UNKNOWN", 0U},
        {29,"SPI_APP_STATE_PHONE_NOTACTIVE", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_PhoneAppState_Name (T_e8_PhoneAppState value)
{
    static const char* enumerationLiterals[] = {
        "SPI_APP_STATE_PHONE_UNKNOWN",
        "SPI_APP_STATE_PHONE_ACTIVE",
        "SPI_APP_STATE_PHONE_NOTACTIVE",
    };

    if (T_e8_PhoneAppState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_PhoneAppState_IsValid (T_e8_PhoneAppState value)
{
    switch (value) {
    case T_e8_PhoneAppState__SPI_APP_STATE_PHONE_UNKNOWN:
    case T_e8_PhoneAppState__SPI_APP_STATE_PHONE_ACTIVE:
    case T_e8_PhoneAppState__SPI_APP_STATE_PHONE_NOTACTIVE:
        return true;
    default:
        return false;
    }
}

bool T_e8_NavigationAppState_Parse (const char *str, size_t length, T_e8_NavigationAppState &value)
{
    static stringEntry entries[] = {
        {24,"SPI_APP_STATE_NAV_ACTIVE", 1U},
        {25,"SPI_APP_STATE_NAV_UNKNOWN", 0U},
        {27,"SPI_APP_STATE_NAV_NOTACTIVE", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_NavigationAppState_Name (T_e8_NavigationAppState value)
{
    static const char* enumerationLiterals[] = {
        "SPI_APP_STATE_NAV_UNKNOWN",
        "SPI_APP_STATE_NAV_ACTIVE",
        "SPI_APP_STATE_NAV_NOTACTIVE",
    };

    if (T_e8_NavigationAppState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_NavigationAppState_IsValid (T_e8_NavigationAppState value)
{
    switch (value) {
    case T_e8_NavigationAppState__SPI_APP_STATE_NAV_UNKNOWN:
    case T_e8_NavigationAppState__SPI_APP_STATE_NAV_ACTIVE:
    case T_e8_NavigationAppState__SPI_APP_STATE_NAV_NOTACTIVE:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPOSwitchReqResponse_Parse (const char *str, size_t length, T_e8_DiPOSwitchReqResponse &value)
{
    static stringEntry entries[] = {
        {27,"E8DIPO_ROLE_SWITCH_REQUIRED", 1U},
        {31,"E8DIPO_ROLE_SWITCH_NOT_REQUIRED", 0U},
        {48,"E8DIPO_ROLE_SWITCH_REQUIRED_FOR_NATIVE_TRANSPORT", 2U},
        {60,"E8DIPO_ROLE_SWITCH_REQUIRED_FOR_CARLIFE_AND_NATIVE_TRANSPORT", 4U},
        {60,"E8DIPO_ROLE_SWITCH_REQUIRED_FOR_CARPLAY_AND_NATIVE_TRANSPORT", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_DiPOSwitchReqResponse_Name (T_e8_DiPOSwitchReqResponse value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_ROLE_SWITCH_NOT_REQUIRED",
        "e8DIPO_ROLE_SWITCH_REQUIRED",
        "e8DIPO_ROLE_SWITCH_REQUIRED_FOR_NATIVE_TRANSPORT",
        "e8DIPO_ROLE_SWITCH_REQUIRED_FOR_CARPLAY_AND_NATIVE_TRANSPORT",
        "e8DIPO_ROLE_SWITCH_REQUIRED_FOR_CARLIFE_AND_NATIVE_TRANSPORT",
    };

    if (T_e8_DiPOSwitchReqResponse_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPOSwitchReqResponse_IsValid (T_e8_DiPOSwitchReqResponse value)
{
    switch (value) {
    case T_e8_DiPOSwitchReqResponse__e8DIPO_ROLE_SWITCH_NOT_REQUIRED:
    case T_e8_DiPOSwitchReqResponse__e8DIPO_ROLE_SWITCH_REQUIRED:
    case T_e8_DiPOSwitchReqResponse__e8DIPO_ROLE_SWITCH_REQUIRED_FOR_NATIVE_TRANSPORT:
    case T_e8_DiPOSwitchReqResponse__e8DIPO_ROLE_SWITCH_REQUIRED_FOR_CARPLAY_AND_NATIVE_TRANSPORT:
    case T_e8_DiPOSwitchReqResponse__e8DIPO_ROLE_SWITCH_REQUIRED_FOR_CARLIFE_AND_NATIVE_TRANSPORT:
        return true;
    default:
        return false;
    }
}

bool T_e8_DisplayInfo_Parse (const char *str, size_t length, T_e8_DisplayInfo &value)
{
    static stringEntry entries[] = {
        {15,"DISPLAY_CONTEXT", 0U},
        {18,"DISPLAY_CONSTRAINT", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_DisplayInfo_Name (T_e8_DisplayInfo value)
{
    static const char* enumerationLiterals[] = {
        "DISPLAY_CONTEXT",
        "DISPLAY_CONSTRAINT",
    };

    if (T_e8_DisplayInfo_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DisplayInfo_IsValid (T_e8_DisplayInfo value)
{
    switch (value) {
    case T_e8_DisplayInfo__DISPLAY_CONTEXT:
    case T_e8_DisplayInfo__DISPLAY_CONSTRAINT:
        return true;
    default:
        return false;
    }
}

bool T_e8_ResourceTransferType_Parse (const char *str, size_t length, T_e8_ResourceTransferType &value)
{
    static stringEntry entries[] = {
        {16,"TRANSFER_TYPE_NA", 0U},
        {18,"TRANSFER_TYPE_TAKE", 1U},
        {20,"TRANSFER_TYPE_BORROW", 3U},
        {20,"TRANSFER_TYPE_UNTAKE", 2U},
        {22,"TRANSFER_TYPE_UNBORROW", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_ResourceTransferType_Name (T_e8_ResourceTransferType value)
{
    static const char* enumerationLiterals[] = {
        "TRANSFER_TYPE_NA",
        "TRANSFER_TYPE_TAKE",
        "TRANSFER_TYPE_UNTAKE",
        "TRANSFER_TYPE_BORROW",
        "TRANSFER_TYPE_UNBORROW",
    };

    if (T_e8_ResourceTransferType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_ResourceTransferType_IsValid (T_e8_ResourceTransferType value)
{
    switch (value) {
    case T_e8_ResourceTransferType__TRANSFER_TYPE_NA:
    case T_e8_ResourceTransferType__TRANSFER_TYPE_TAKE:
    case T_e8_ResourceTransferType__TRANSFER_TYPE_UNTAKE:
    case T_e8_ResourceTransferType__TRANSFER_TYPE_BORROW:
    case T_e8_ResourceTransferType__TRANSFER_TYPE_UNBORROW:
        return true;
    default:
        return false;
    }
}

bool T_e8_ResourceTransferPriority_Parse (const char *str, size_t length, T_e8_ResourceTransferPriority &value)
{
    static stringEntry entries[] = {
        {20,"TRANSFER_PRIORITY_NA", 0U},
        {28,"TRANSFER_PRIORITY_NICETOHAVE", 1U},
        {31,"TRANSFER_PRIORITY_USERINITIATED", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_ResourceTransferPriority_Name (T_e8_ResourceTransferPriority value)
{
    static const char* enumerationLiterals[] = {
        "TRANSFER_PRIORITY_NA",
        "TRANSFER_PRIORITY_NICETOHAVE",
        "TRANSFER_PRIORITY_USERINITIATED",
    };

    if (T_e8_ResourceTransferPriority_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_ResourceTransferPriority_IsValid (T_e8_ResourceTransferPriority value)
{
    switch (value) {
    case T_e8_ResourceTransferPriority__TRANSFER_PRIORITY_NA:
    case T_e8_ResourceTransferPriority__TRANSFER_PRIORITY_NICETOHAVE:
    case T_e8_ResourceTransferPriority__TRANSFER_PRIORITY_USERINITIATED:
        return true;
    default:
        return false;
    }
}

bool T_e8_ResourceTransferConstraint_Parse (const char *str, size_t length, T_e8_ResourceTransferConstraint &value)
{
    static stringEntry entries[] = {
        {22,"TRANSFER_CONSTRAINT_NA", 0U},
        {25,"TRANSFER_CONSTRAINT_NEVER", 3U},
        {27,"TRANSFER_CONSTRAINT_ANYTIME", 1U},
        {33,"TRANSFER_CONSTRAINT_USERINITIATED", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_ResourceTransferConstraint_Name (T_e8_ResourceTransferConstraint value)
{
    static const char* enumerationLiterals[] = {
        "TRANSFER_CONSTRAINT_NA",
        "TRANSFER_CONSTRAINT_ANYTIME",
        "TRANSFER_CONSTRAINT_USERINITIATED",
        "TRANSFER_CONSTRAINT_NEVER",
    };

    if (T_e8_ResourceTransferConstraint_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_ResourceTransferConstraint_IsValid (T_e8_ResourceTransferConstraint value)
{
    switch (value) {
    case T_e8_ResourceTransferConstraint__TRANSFER_CONSTRAINT_NA:
    case T_e8_ResourceTransferConstraint__TRANSFER_CONSTRAINT_ANYTIME:
    case T_e8_ResourceTransferConstraint__TRANSFER_CONSTRAINT_USERINITIATED:
    case T_e8_ResourceTransferConstraint__TRANSFER_CONSTRAINT_NEVER:
        return true;
    default:
        return false;
    }
}

bool T_e8_DisplayType_Parse (const char *str, size_t length, T_e8_DisplayType &value)
{
    static stringEntry entries[] = {
        {11,"E8RESISTIVE", 0U},
        {12,"E8CAPACITIVE", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_DisplayType_Name (T_e8_DisplayType value)
{
    static const char* enumerationLiterals[] = {
        "e8RESISTIVE",
        "e8CAPACITIVE",
    };

    if (T_e8_DisplayType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DisplayType_IsValid (T_e8_DisplayType value)
{
    switch (value) {
    case T_e8_DisplayType__e8RESISTIVE:
    case T_e8_DisplayType__e8CAPACITIVE:
        return true;
    default:
        return false;
    }
}

bool T_e8_DisplayTouchType_Parse (const char *str, size_t length, T_e8_DisplayTouchType &value)
{
    static stringEntry entries[] = {
        {13,"E8MULTI_TOUCH", 1U},
        {14,"E8SINGLE_TOUCH", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_DisplayTouchType_Name (T_e8_DisplayTouchType value)
{
    static const char* enumerationLiterals[] = {
        "e8SINGLE_TOUCH",
        "e8MULTI_TOUCH",
    };

    if (T_e8_DisplayTouchType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DisplayTouchType_IsValid (T_e8_DisplayTouchType value)
{
    switch (value) {
    case T_e8_DisplayTouchType__e8SINGLE_TOUCH:
    case T_e8_DisplayTouchType__e8MULTI_TOUCH:
        return true;
    default:
        return false;
    }
}

bool T_e8_VehicleState_Parse (const char *str, size_t length, T_e8_VehicleState &value)
{
    static stringEntry entries[] = {
        {9,"PARK_MODE", 0U},
        {10,"DRIVE_MODE", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_VehicleState_Name (T_e8_VehicleState value)
{
    static const char* enumerationLiterals[] = {
        "PARK_MODE",
        "DRIVE_MODE",
    };

    if (T_e8_VehicleState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_VehicleState_IsValid (T_e8_VehicleState value)
{
    switch (value) {
    case T_e8_VehicleState__PARK_MODE:
    case T_e8_VehicleState__DRIVE_MODE:
        return true;
    default:
        return false;
    }
}

bool T_e8_ParkBrake_Parse (const char *str, size_t length, T_e8_ParkBrake &value)
{
    static stringEntry entries[] = {
        {18,"PARK_BRAKE_ENGAGED", 2U},
        {22,"PARK_BRAKE_NOT_ENGAGED", 1U},
        {27,"PARK_BRAKE_INFO_UNAVAILABLE", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_ParkBrake_Name (T_e8_ParkBrake value)
{
    static const char* enumerationLiterals[] = {
        "PARK_BRAKE_INFO_UNAVAILABLE",
        "PARK_BRAKE_NOT_ENGAGED",
        "PARK_BRAKE_ENGAGED",
    };

    if (T_e8_ParkBrake_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_ParkBrake_IsValid (T_e8_ParkBrake value)
{
    switch (value) {
    case T_e8_ParkBrake__PARK_BRAKE_INFO_UNAVAILABLE:
    case T_e8_ParkBrake__PARK_BRAKE_NOT_ENGAGED:
    case T_e8_ParkBrake__PARK_BRAKE_ENGAGED:
        return true;
    default:
        return false;
    }
}

bool T_e8_GearState_Parse (const char *str, size_t length, T_e8_GearState &value)
{
    static stringEntry entries[] = {
        {6,"GEAR_1", 1U},
        {6,"GEAR_2", 2U},
        {6,"GEAR_3", 3U},
        {6,"GEAR_4", 4U},
        {6,"GEAR_5", 5U},
        {6,"GEAR_6", 6U},
        {8,"GEAR_LOW", 7U},
        {9,"GEAR_PARK", 101U},
        {10,"GEAR_DRIVE", 100U},
        {12,"GEAR_NEUTRAL", 0U},
        {12,"GEAR_REVERSE", 102U},
        {21,"GEAR_INFO_UNAVAILABLE", 255U},
    };

    return lookupInStringEntryTable (str, length, entries, 12, (unsigned int&) value);
}

const char* T_e8_GearState_Name (T_e8_GearState value)
{
    static const char* enumerationLiterals[] = {
        "GEAR_NEUTRAL",
        "GEAR_1",
        "GEAR_2",
        "GEAR_3",
        "GEAR_4",
        "GEAR_5",
        "GEAR_6",
        "GEAR_LOW",
        "GEAR_DRIVE",
        "GEAR_PARK",
        "GEAR_REVERSE",
        "GEAR_INFO_UNAVAILABLE",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        100U,
        101U,
        102U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 12, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_GearState_IsValid (T_e8_GearState value)
{
    switch (value) {
    case T_e8_GearState__GEAR_NEUTRAL:
    case T_e8_GearState__GEAR_1:
    case T_e8_GearState__GEAR_2:
    case T_e8_GearState__GEAR_3:
    case T_e8_GearState__GEAR_4:
    case T_e8_GearState__GEAR_5:
    case T_e8_GearState__GEAR_6:
    case T_e8_GearState__GEAR_LOW:
    case T_e8_GearState__GEAR_DRIVE:
    case T_e8_GearState__GEAR_PARK:
    case T_e8_GearState__GEAR_REVERSE:
    case T_e8_GearState__GEAR_INFO_UNAVAILABLE:
        return true;
    default:
        return false;
    }
}

bool T_e8_HandsetInteraction_Parse (const char *str, size_t length, T_e8_HandsetInteraction &value)
{
    static stringEntry entries[] = {
        {27,"HANDSET_INTERACTION_UNKNOWN", 0U},
        {28,"HANDSET_INTERACTION_REQUIRED", 1U},
        {32,"HANDSET_INTERACTION_NOT_REQUIRED", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_HandsetInteraction_Name (T_e8_HandsetInteraction value)
{
    static const char* enumerationLiterals[] = {
        "HANDSET_INTERACTION_UNKNOWN",
        "HANDSET_INTERACTION_REQUIRED",
        "HANDSET_INTERACTION_NOT_REQUIRED",
    };

    if (T_e8_HandsetInteraction_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_HandsetInteraction_IsValid (T_e8_HandsetInteraction value)
{
    switch (value) {
    case T_e8_HandsetInteraction__HANDSET_INTERACTION_UNKNOWN:
    case T_e8_HandsetInteraction__HANDSET_INTERACTION_REQUIRED:
    case T_e8_HandsetInteraction__HANDSET_INTERACTION_NOT_REQUIRED:
        return true;
    default:
        return false;
    }
}

bool T_e8_DeviceSelectionMode_Parse (const char *str, size_t length, T_e8_DeviceSelectionMode &value)
{
    static stringEntry entries[] = {
        {21,"SELECTION_MODE_MANUAL", 1U},
        {22,"SELECTION_MODE_UNKNOWN", 0U},
        {24,"SELECTION_MODE_AUTOMATIC", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_DeviceSelectionMode_Name (T_e8_DeviceSelectionMode value)
{
    static const char* enumerationLiterals[] = {
        "SELECTION_MODE_UNKNOWN",
        "SELECTION_MODE_MANUAL",
        "SELECTION_MODE_AUTOMATIC",
    };

    if (T_e8_DeviceSelectionMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DeviceSelectionMode_IsValid (T_e8_DeviceSelectionMode value)
{
    switch (value) {
    case T_e8_DeviceSelectionMode__SELECTION_MODE_UNKNOWN:
    case T_e8_DeviceSelectionMode__SELECTION_MODE_MANUAL:
    case T_e8_DeviceSelectionMode__SELECTION_MODE_AUTOMATIC:
        return true;
    default:
        return false;
    }
}

bool T_e8_TurnSide_Parse (const char *str, size_t length, T_e8_TurnSide &value)
{
    static stringEntry entries[] = {
        {14,"TURN_SIDE_LEFT", 1U},
        {15,"TURN_SIDE_RIGHT", 2U},
        {21,"TURN_SIDE_UNSPECIFIED", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_TurnSide_Name (T_e8_TurnSide value)
{
    static const char* enumerationLiterals[] = {
        "TURN_SIDE_LEFT",
        "TURN_SIDE_RIGHT",
        "TURN_SIDE_UNSPECIFIED",
    };

    if (T_e8_TurnSide_IsValid(value))
        return enumerationLiterals[value - 1U];
    else
        return NULL;
}

bool T_e8_TurnSide_IsValid (T_e8_TurnSide value)
{
    switch (value) {
    case T_e8_TurnSide__TURN_SIDE_LEFT:
    case T_e8_TurnSide__TURN_SIDE_RIGHT:
    case T_e8_TurnSide__TURN_SIDE_UNSPECIFIED:
        return true;
    default:
        return false;
    }
}

bool T_e8_NextTurnEvent_Parse (const char *str, size_t length, T_e8_NextTurnEvent &value)
{
    static stringEntry entries[] = {
        {14,"NEXT_TURN_FORK", 9U},
        {14,"NEXT_TURN_TURN", 4U},
        {15,"NEXT_TURN_MERGE", 10U},
        {16,"NEXT_TURN_DEPART", 1U},
        {16,"NEXT_TURN_U_TURN", 6U},
        {17,"NEXT_TURN_ON_RAMP", 7U},
        {17,"NEXT_TURN_UNKNOWN", 0U},
        {18,"NEXT_TURN_OFF_RAMP", 8U},
        {18,"NEXT_TURN_STRAIGHT", 14U},
        {20,"NEXT_TURN_FERRY_BOAT", 16U},
        {20,"NEXT_TURN_SHARP_TURN", 5U},
        {21,"NEXT_TURN_DESTINATION", 19U},
        {21,"NEXT_TURN_FERRY_TRAIN", 17U},
        {21,"NEXT_TURN_NAME_CHANGE", 2U},
        {21,"NEXT_TURN_SLIGHT_TURN", 3U},
        {25,"NEXT_TURN_ROUNDABOUT_EXIT", 12U},
        {26,"NEXT_TURN_ROUNDABOUT_ENTER", 11U},
        {35,"NEXT_TURN_ROUNDABOUT_ENTER_AND_EXIT", 13U},
    };

    return lookupInStringEntryTable (str, length, entries, 18, (unsigned int&) value);
}

const char* T_e8_NextTurnEvent_Name (T_e8_NextTurnEvent value)
{
    static const char* enumerationLiterals[] = {
        "NEXT_TURN_UNKNOWN",
        "NEXT_TURN_DEPART",
        "NEXT_TURN_NAME_CHANGE",
        "NEXT_TURN_SLIGHT_TURN",
        "NEXT_TURN_TURN",
        "NEXT_TURN_SHARP_TURN",
        "NEXT_TURN_U_TURN",
        "NEXT_TURN_ON_RAMP",
        "NEXT_TURN_OFF_RAMP",
        "NEXT_TURN_FORK",
        "NEXT_TURN_MERGE",
        "NEXT_TURN_ROUNDABOUT_ENTER",
        "NEXT_TURN_ROUNDABOUT_EXIT",
        "NEXT_TURN_ROUNDABOUT_ENTER_AND_EXIT",
        "NEXT_TURN_STRAIGHT",
        "NEXT_TURN_FERRY_BOAT",
        "NEXT_TURN_FERRY_TRAIN",
        "NEXT_TURN_DESTINATION",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        11U,
        12U,
        13U,
        14U,
        16U,
        17U,
        19U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 18, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_NextTurnEvent_IsValid (T_e8_NextTurnEvent value)
{
    switch (value) {
    case T_e8_NextTurnEvent__NEXT_TURN_UNKNOWN:
    case T_e8_NextTurnEvent__NEXT_TURN_DEPART:
    case T_e8_NextTurnEvent__NEXT_TURN_NAME_CHANGE:
    case T_e8_NextTurnEvent__NEXT_TURN_SLIGHT_TURN:
    case T_e8_NextTurnEvent__NEXT_TURN_TURN:
    case T_e8_NextTurnEvent__NEXT_TURN_SHARP_TURN:
    case T_e8_NextTurnEvent__NEXT_TURN_U_TURN:
    case T_e8_NextTurnEvent__NEXT_TURN_ON_RAMP:
    case T_e8_NextTurnEvent__NEXT_TURN_OFF_RAMP:
    case T_e8_NextTurnEvent__NEXT_TURN_FORK:
    case T_e8_NextTurnEvent__NEXT_TURN_MERGE:
    case T_e8_NextTurnEvent__NEXT_TURN_ROUNDABOUT_ENTER:
    case T_e8_NextTurnEvent__NEXT_TURN_ROUNDABOUT_EXIT:
    case T_e8_NextTurnEvent__NEXT_TURN_ROUNDABOUT_ENTER_AND_EXIT:
    case T_e8_NextTurnEvent__NEXT_TURN_STRAIGHT:
    case T_e8_NextTurnEvent__NEXT_TURN_FERRY_BOAT:
    case T_e8_NextTurnEvent__NEXT_TURN_FERRY_TRAIN:
    case T_e8_NextTurnEvent__NEXT_TURN_DESTINATION:
        return true;
    default:
        return false;
    }
}

bool T_e8_ManeuverDistanceUnits_Parse (const char *str, size_t length, T_e8_ManeuverDistanceUnits &value)
{
    static stringEntry entries[] = {
        {28,"MANEUVER_DISTANCE_UNITS_FEET", 6U},
        {29,"MANEUVER_DISTANCE_UNITS_MILES", 4U},
        {29,"MANEUVER_DISTANCE_UNITS_YARDS", 7U},
        {30,"MANEUVER_DISTANCE_UNITS_METERS", 1U},
        {31,"MANEUVER_DISTANCE_UNITS_UNKNOWN", 0U},
        {32,"MANEUVER_DISTANCE_UNITS_MILES_P1", 5U},
        {34,"MANEUVER_DISTANCE_UNITS_KILOMETERS", 2U},
        {37,"MANEUVER_DISTANCE_UNITS_KILOMETERS_P1", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 8, (unsigned int&) value);
}

const char* T_e8_ManeuverDistanceUnits_Name (T_e8_ManeuverDistanceUnits value)
{
    static const char* enumerationLiterals[] = {
        "MANEUVER_DISTANCE_UNITS_UNKNOWN",
        "MANEUVER_DISTANCE_UNITS_METERS",
        "MANEUVER_DISTANCE_UNITS_KILOMETERS",
        "MANEUVER_DISTANCE_UNITS_KILOMETERS_P1",
        "MANEUVER_DISTANCE_UNITS_MILES",
        "MANEUVER_DISTANCE_UNITS_MILES_P1",
        "MANEUVER_DISTANCE_UNITS_FEET",
        "MANEUVER_DISTANCE_UNITS_YARDS",
    };

    if (T_e8_ManeuverDistanceUnits_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_ManeuverDistanceUnits_IsValid (T_e8_ManeuverDistanceUnits value)
{
    switch (value) {
    case T_e8_ManeuverDistanceUnits__MANEUVER_DISTANCE_UNITS_UNKNOWN:
    case T_e8_ManeuverDistanceUnits__MANEUVER_DISTANCE_UNITS_METERS:
    case T_e8_ManeuverDistanceUnits__MANEUVER_DISTANCE_UNITS_KILOMETERS:
    case T_e8_ManeuverDistanceUnits__MANEUVER_DISTANCE_UNITS_KILOMETERS_P1:
    case T_e8_ManeuverDistanceUnits__MANEUVER_DISTANCE_UNITS_MILES:
    case T_e8_ManeuverDistanceUnits__MANEUVER_DISTANCE_UNITS_MILES_P1:
    case T_e8_ManeuverDistanceUnits__MANEUVER_DISTANCE_UNITS_FEET:
    case T_e8_ManeuverDistanceUnits__MANEUVER_DISTANCE_UNITS_YARDS:
        return true;
    default:
        return false;
    }
}

bool T_e8_BTVoiceRecRequest_Parse (const char *str, size_t length, T_e8_BTVoiceRecRequest &value)
{
    static stringEntry entries[] = {
        {17,"VOICESESSION_STOP", 3U},
        {18,"VOICESESSION_START", 1U},
        {27,"VOICESESSION_START_MIC_ONLY", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_BTVoiceRecRequest_Name (T_e8_BTVoiceRecRequest value)
{
    static const char* enumerationLiterals[] = {
        "VOICESESSION_START",
        "VOICESESSION_START_MIC_ONLY",
        "VOICESESSION_STOP",
    };

    if (T_e8_BTVoiceRecRequest_IsValid(value))
        return enumerationLiterals[value - 1U];
    else
        return NULL;
}

bool T_e8_BTVoiceRecRequest_IsValid (T_e8_BTVoiceRecRequest value)
{
    switch (value) {
    case T_e8_BTVoiceRecRequest__VOICESESSION_START:
    case T_e8_BTVoiceRecRequest__VOICESESSION_START_MIC_ONLY:
    case T_e8_BTVoiceRecRequest__VOICESESSION_STOP:
        return true;
    default:
        return false;
    }
}

bool T_e8_BTVoiceRecRequestResponse_Parse (const char *str, size_t length, T_e8_BTVoiceRecRequestResponse &value)
{
    static stringEntry entries[] = {
        {27,"VOICESESSION_REQUEST_DENIED", 2U},
        {28,"VOICESESSION_REQUEST_UNKNOWN", 0U},
        {29,"VOICESESSION_REQUEST_ACCEPTED", 1U},
        {33,"VOICESESSION_REQUEST_DENIED_NOHFP", 3U},
        {46,"VOICESESSION_REQUEST_DENIED_VOICEALREADYACTIVE", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_BTVoiceRecRequestResponse_Name (T_e8_BTVoiceRecRequestResponse value)
{
    static const char* enumerationLiterals[] = {
        "VOICESESSION_REQUEST_UNKNOWN",
        "VOICESESSION_REQUEST_ACCEPTED",
        "VOICESESSION_REQUEST_DENIED",
        "VOICESESSION_REQUEST_DENIED_NOHFP",
        "VOICESESSION_REQUEST_DENIED_VOICEALREADYACTIVE",
    };

    if (T_e8_BTVoiceRecRequestResponse_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_BTVoiceRecRequestResponse_IsValid (T_e8_BTVoiceRecRequestResponse value)
{
    switch (value) {
    case T_e8_BTVoiceRecRequestResponse__VOICESESSION_REQUEST_UNKNOWN:
    case T_e8_BTVoiceRecRequestResponse__VOICESESSION_REQUEST_ACCEPTED:
    case T_e8_BTVoiceRecRequestResponse__VOICESESSION_REQUEST_DENIED:
    case T_e8_BTVoiceRecRequestResponse__VOICESESSION_REQUEST_DENIED_NOHFP:
    case T_e8_BTVoiceRecRequestResponse__VOICESESSION_REQUEST_DENIED_VOICEALREADYACTIVE:
        return true;
    default:
        return false;
    }
}

bool T_e8_WiFiSecurityType_Parse (const char *str, size_t length, T_e8_WiFiSecurityType &value)
{
    static stringEntry entries[] = {
        {3,"WEP", 1U},
        {4,"NONE", 0U},
        {12,"WPA_PERSONAL", 2U},
        {13,"WPA2_PERSONAL", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_WiFiSecurityType_Name (T_e8_WiFiSecurityType value)
{
    static const char* enumerationLiterals[] = {
        "NONE",
        "WEP",
        "WPA_PERSONAL",
        "WPA2_PERSONAL",
    };

    if (T_e8_WiFiSecurityType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_WiFiSecurityType_IsValid (T_e8_WiFiSecurityType value)
{
    switch (value) {
    case T_e8_WiFiSecurityType__NONE:
    case T_e8_WiFiSecurityType__WEP:
    case T_e8_WiFiSecurityType__WPA_PERSONAL:
    case T_e8_WiFiSecurityType__WPA2_PERSONAL:
        return true;
    default:
        return false;
    }
}

bool T_e8_FidelityType_Parse (const char *str, size_t length, T_e8_FidelityType &value)
{
    static stringEntry entries[] = {
        {14,"E8LOW_FIDELITY", 0U},
        {15,"E8HIGH_FIDELITY", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_FidelityType_Name (T_e8_FidelityType value)
{
    static const char* enumerationLiterals[] = {
        "e8LOW_FIDELITY",
        "e8HIGH_FIDELITY",
    };

    if (T_e8_FidelityType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_FidelityType_IsValid (T_e8_FidelityType value)
{
    switch (value) {
    case T_e8_FidelityType__e8LOW_FIDELITY:
    case T_e8_FidelityType__e8HIGH_FIDELITY:
        return true;
    default:
        return false;
    }
}

bool T_e8_BatteryChargingState_Parse (const char *str, size_t length, T_e8_BatteryChargingState &value)
{
    static stringEntry entries[] = {
        {30,"BATTERY_CHARGING_STATE_CHARGED", 2U},
        {30,"BATTERY_CHARGING_STATE_UNKNOWN", 3U},
        {31,"BATTERY_CHARGING_STATE_CHARGING", 1U},
        {31,"BATTERY_CHARGING_STATE_DISABLED", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_BatteryChargingState_Name (T_e8_BatteryChargingState value)
{
    static const char* enumerationLiterals[] = {
        "BATTERY_CHARGING_STATE_DISABLED",
        "BATTERY_CHARGING_STATE_CHARGING",
        "BATTERY_CHARGING_STATE_CHARGED",
        "BATTERY_CHARGING_STATE_UNKNOWN",
    };

    if (T_e8_BatteryChargingState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_BatteryChargingState_IsValid (T_e8_BatteryChargingState value)
{
    switch (value) {
    case T_e8_BatteryChargingState__BATTERY_CHARGING_STATE_DISABLED:
    case T_e8_BatteryChargingState__BATTERY_CHARGING_STATE_CHARGING:
    case T_e8_BatteryChargingState__BATTERY_CHARGING_STATE_CHARGED:
    case T_e8_BatteryChargingState__BATTERY_CHARGING_STATE_UNKNOWN:
        return true;
    default:
        return false;
    }
}

bool T_e8_ComponentID_Parse (const char *str, size_t length, T_e8_ComponentID &value)
{
    static stringEntry entries[] = {
        {18,"DISPLAY_ID_UNKNOWN", 255U},
        {20,"DISPLAY_ID_CLUSTER_1", 11U},
        {20,"DISPLAY_ID_CLUSTER_2", 12U},
        {20,"DISPLAY_ID_CLUSTER_3", 13U},
        {20,"DISPLAY_ID_CLUSTER_4", 14U},
        {20,"DISPLAY_ID_CLUSTER_5", 15U},
        {20,"DISPLAY_ID_CLUSTER_6", 16U},
        {20,"DISPLAY_ID_CLUSTER_7", 17U},
        {20,"DISPLAY_ID_CLUSTER_8", 18U},
        {20,"DISPLAY_ID_CLUSTER_9", 19U},
        {21,"DISPLAY_ID_CLUSTER_10", 20U},
        {28,"DISPLAY_ID_HEAD_UP_DISPLAY_1", 21U},
        {28,"DISPLAY_ID_HEAD_UP_DISPLAY_2", 22U},
        {28,"DISPLAY_ID_HEAD_UP_DISPLAY_3", 23U},
        {28,"DISPLAY_ID_HEAD_UP_DISPLAY_4", 24U},
        {28,"DISPLAY_ID_HEAD_UP_DISPLAY_5", 25U},
        {28,"DISPLAY_ID_HEAD_UP_DISPLAY_6", 26U},
        {28,"DISPLAY_ID_HEAD_UP_DISPLAY_7", 27U},
        {28,"DISPLAY_ID_HEAD_UP_DISPLAY_8", 28U},
        {28,"DISPLAY_ID_HEAD_UP_DISPLAY_9", 29U},
        {29,"DISPLAY_ID_HEADUNIT_DISPLAY_1", 1U},
        {29,"DISPLAY_ID_HEADUNIT_DISPLAY_2", 2U},
        {29,"DISPLAY_ID_HEADUNIT_DISPLAY_3", 3U},
        {29,"DISPLAY_ID_HEADUNIT_DISPLAY_4", 4U},
        {29,"DISPLAY_ID_HEADUNIT_DISPLAY_5", 5U},
        {29,"DISPLAY_ID_HEADUNIT_DISPLAY_6", 6U},
        {29,"DISPLAY_ID_HEADUNIT_DISPLAY_7", 7U},
        {29,"DISPLAY_ID_HEADUNIT_DISPLAY_8", 8U},
        {29,"DISPLAY_ID_HEADUNIT_DISPLAY_9", 9U},
        {29,"DISPLAY_ID_HEAD_UP_DISPLAY_10", 30U},
        {30,"DISPLAY_ID_HEADUNIT_DISPLAY_10", 10U},
        {34,"DISPLAY_ID_MISCELLANEOUS_DISPLAY_1", 31U},
        {34,"DISPLAY_ID_MISCELLANEOUS_DISPLAY_2", 32U},
        {34,"DISPLAY_ID_MISCELLANEOUS_DISPLAY_3", 33U},
        {34,"DISPLAY_ID_MISCELLANEOUS_DISPLAY_4", 34U},
        {34,"DISPLAY_ID_MISCELLANEOUS_DISPLAY_5", 35U},
        {34,"DISPLAY_ID_MISCELLANEOUS_DISPLAY_6", 36U},
        {34,"DISPLAY_ID_MISCELLANEOUS_DISPLAY_7", 37U},
        {34,"DISPLAY_ID_MISCELLANEOUS_DISPLAY_8", 38U},
        {34,"DISPLAY_ID_MISCELLANEOUS_DISPLAY_9", 39U},
        {35,"DISPLAY_ID_MISCELLANEOUS_DISPLAY_10", 40U},
    };

    return lookupInStringEntryTable (str, length, entries, 41, (unsigned int&) value);
}

const char* T_e8_ComponentID_Name (T_e8_ComponentID value)
{
    static const char* enumerationLiterals[] = {
        "DISPLAY_ID_HEADUNIT_DISPLAY_1",
        "DISPLAY_ID_HEADUNIT_DISPLAY_2",
        "DISPLAY_ID_HEADUNIT_DISPLAY_3",
        "DISPLAY_ID_HEADUNIT_DISPLAY_4",
        "DISPLAY_ID_HEADUNIT_DISPLAY_5",
        "DISPLAY_ID_HEADUNIT_DISPLAY_6",
        "DISPLAY_ID_HEADUNIT_DISPLAY_7",
        "DISPLAY_ID_HEADUNIT_DISPLAY_8",
        "DISPLAY_ID_HEADUNIT_DISPLAY_9",
        "DISPLAY_ID_HEADUNIT_DISPLAY_10",
        "DISPLAY_ID_CLUSTER_1",
        "DISPLAY_ID_CLUSTER_2",
        "DISPLAY_ID_CLUSTER_3",
        "DISPLAY_ID_CLUSTER_4",
        "DISPLAY_ID_CLUSTER_5",
        "DISPLAY_ID_CLUSTER_6",
        "DISPLAY_ID_CLUSTER_7",
        "DISPLAY_ID_CLUSTER_8",
        "DISPLAY_ID_CLUSTER_9",
        "DISPLAY_ID_CLUSTER_10",
        "DISPLAY_ID_HEAD_UP_DISPLAY_1",
        "DISPLAY_ID_HEAD_UP_DISPLAY_2",
        "DISPLAY_ID_HEAD_UP_DISPLAY_3",
        "DISPLAY_ID_HEAD_UP_DISPLAY_4",
        "DISPLAY_ID_HEAD_UP_DISPLAY_5",
        "DISPLAY_ID_HEAD_UP_DISPLAY_6",
        "DISPLAY_ID_HEAD_UP_DISPLAY_7",
        "DISPLAY_ID_HEAD_UP_DISPLAY_8",
        "DISPLAY_ID_HEAD_UP_DISPLAY_9",
        "DISPLAY_ID_HEAD_UP_DISPLAY_10",
        "DISPLAY_ID_MISCELLANEOUS_DISPLAY_1",
        "DISPLAY_ID_MISCELLANEOUS_DISPLAY_2",
        "DISPLAY_ID_MISCELLANEOUS_DISPLAY_3",
        "DISPLAY_ID_MISCELLANEOUS_DISPLAY_4",
        "DISPLAY_ID_MISCELLANEOUS_DISPLAY_5",
        "DISPLAY_ID_MISCELLANEOUS_DISPLAY_6",
        "DISPLAY_ID_MISCELLANEOUS_DISPLAY_7",
        "DISPLAY_ID_MISCELLANEOUS_DISPLAY_8",
        "DISPLAY_ID_MISCELLANEOUS_DISPLAY_9",
        "DISPLAY_ID_MISCELLANEOUS_DISPLAY_10",
        "DISPLAY_ID_UNKNOWN",
    };

    static unsigned int enumerationValues[] = {
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        11U,
        12U,
        13U,
        14U,
        15U,
        16U,
        17U,
        18U,
        19U,
        20U,
        21U,
        22U,
        23U,
        24U,
        25U,
        26U,
        27U,
        28U,
        29U,
        30U,
        31U,
        32U,
        33U,
        34U,
        35U,
        36U,
        37U,
        38U,
        39U,
        40U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 41, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_ComponentID_IsValid (T_e8_ComponentID value)
{
    switch (value) {
    case T_e8_ComponentID__DISPLAY_ID_HEADUNIT_DISPLAY_1:
    case T_e8_ComponentID__DISPLAY_ID_HEADUNIT_DISPLAY_2:
    case T_e8_ComponentID__DISPLAY_ID_HEADUNIT_DISPLAY_3:
    case T_e8_ComponentID__DISPLAY_ID_HEADUNIT_DISPLAY_4:
    case T_e8_ComponentID__DISPLAY_ID_HEADUNIT_DISPLAY_5:
    case T_e8_ComponentID__DISPLAY_ID_HEADUNIT_DISPLAY_6:
    case T_e8_ComponentID__DISPLAY_ID_HEADUNIT_DISPLAY_7:
    case T_e8_ComponentID__DISPLAY_ID_HEADUNIT_DISPLAY_8:
    case T_e8_ComponentID__DISPLAY_ID_HEADUNIT_DISPLAY_9:
    case T_e8_ComponentID__DISPLAY_ID_HEADUNIT_DISPLAY_10:
    case T_e8_ComponentID__DISPLAY_ID_CLUSTER_1:
    case T_e8_ComponentID__DISPLAY_ID_CLUSTER_2:
    case T_e8_ComponentID__DISPLAY_ID_CLUSTER_3:
    case T_e8_ComponentID__DISPLAY_ID_CLUSTER_4:
    case T_e8_ComponentID__DISPLAY_ID_CLUSTER_5:
    case T_e8_ComponentID__DISPLAY_ID_CLUSTER_6:
    case T_e8_ComponentID__DISPLAY_ID_CLUSTER_7:
    case T_e8_ComponentID__DISPLAY_ID_CLUSTER_8:
    case T_e8_ComponentID__DISPLAY_ID_CLUSTER_9:
    case T_e8_ComponentID__DISPLAY_ID_CLUSTER_10:
    case T_e8_ComponentID__DISPLAY_ID_HEAD_UP_DISPLAY_1:
    case T_e8_ComponentID__DISPLAY_ID_HEAD_UP_DISPLAY_2:
    case T_e8_ComponentID__DISPLAY_ID_HEAD_UP_DISPLAY_3:
    case T_e8_ComponentID__DISPLAY_ID_HEAD_UP_DISPLAY_4:
    case T_e8_ComponentID__DISPLAY_ID_HEAD_UP_DISPLAY_5:
    case T_e8_ComponentID__DISPLAY_ID_HEAD_UP_DISPLAY_6:
    case T_e8_ComponentID__DISPLAY_ID_HEAD_UP_DISPLAY_7:
    case T_e8_ComponentID__DISPLAY_ID_HEAD_UP_DISPLAY_8:
    case T_e8_ComponentID__DISPLAY_ID_HEAD_UP_DISPLAY_9:
    case T_e8_ComponentID__DISPLAY_ID_HEAD_UP_DISPLAY_10:
    case T_e8_ComponentID__DISPLAY_ID_MISCELLANEOUS_DISPLAY_1:
    case T_e8_ComponentID__DISPLAY_ID_MISCELLANEOUS_DISPLAY_2:
    case T_e8_ComponentID__DISPLAY_ID_MISCELLANEOUS_DISPLAY_3:
    case T_e8_ComponentID__DISPLAY_ID_MISCELLANEOUS_DISPLAY_4:
    case T_e8_ComponentID__DISPLAY_ID_MISCELLANEOUS_DISPLAY_5:
    case T_e8_ComponentID__DISPLAY_ID_MISCELLANEOUS_DISPLAY_6:
    case T_e8_ComponentID__DISPLAY_ID_MISCELLANEOUS_DISPLAY_7:
    case T_e8_ComponentID__DISPLAY_ID_MISCELLANEOUS_DISPLAY_8:
    case T_e8_ComponentID__DISPLAY_ID_MISCELLANEOUS_DISPLAY_9:
    case T_e8_ComponentID__DISPLAY_ID_MISCELLANEOUS_DISPLAY_10:
    case T_e8_ComponentID__DISPLAY_ID_UNKNOWN:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPoRouteGuidanceState_Parse (const char *str, size_t length, T_e8_DiPoRouteGuidanceState &value)
{
    static stringEntry entries[] = {
        {35,"E8DIPO_ROUTE_GUIDANCE_STATE_ARRIVED", 2U},
        {35,"E8DIPO_ROUTE_GUIDANCE_STATE_LOADING", 3U},
        {36,"E8DIPO_ROUTE_GUIDANCE_STATE_LOCATING", 4U},
        {37,"E8DIPO_ROUTE_GUIDANCE_STATE_REROUTING", 5U},
        {37,"E8DIPO_ROUTE_GUIDANCE_STATE_ROUTE_SET", 1U},
        {40,"E8DIPO_ROUTE_GUIDANCE_STATE_NO_ROUTE_SET", 0U},
        {42,"E8DIPO_ROUTE_GUIDANCE_STATE_PROCEEDTOROUTE", 6U},
    };

    return lookupInStringEntryTable (str, length, entries, 7, (unsigned int&) value);
}

const char* T_e8_DiPoRouteGuidanceState_Name (T_e8_DiPoRouteGuidanceState value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_ROUTE_GUIDANCE_STATE_NO_ROUTE_SET",
        "e8DIPO_ROUTE_GUIDANCE_STATE_ROUTE_SET",
        "e8DIPO_ROUTE_GUIDANCE_STATE_ARRIVED",
        "e8DIPO_ROUTE_GUIDANCE_STATE_LOADING",
        "e8DIPO_ROUTE_GUIDANCE_STATE_LOCATING",
        "e8DIPO_ROUTE_GUIDANCE_STATE_REROUTING",
        "e8DIPO_ROUTE_GUIDANCE_STATE_PROCEEDTOROUTE",
    };

    if (T_e8_DiPoRouteGuidanceState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPoRouteGuidanceState_IsValid (T_e8_DiPoRouteGuidanceState value)
{
    switch (value) {
    case T_e8_DiPoRouteGuidanceState__e8DIPO_ROUTE_GUIDANCE_STATE_NO_ROUTE_SET:
    case T_e8_DiPoRouteGuidanceState__e8DIPO_ROUTE_GUIDANCE_STATE_ROUTE_SET:
    case T_e8_DiPoRouteGuidanceState__e8DIPO_ROUTE_GUIDANCE_STATE_ARRIVED:
    case T_e8_DiPoRouteGuidanceState__e8DIPO_ROUTE_GUIDANCE_STATE_LOADING:
    case T_e8_DiPoRouteGuidanceState__e8DIPO_ROUTE_GUIDANCE_STATE_LOCATING:
    case T_e8_DiPoRouteGuidanceState__e8DIPO_ROUTE_GUIDANCE_STATE_REROUTING:
    case T_e8_DiPoRouteGuidanceState__e8DIPO_ROUTE_GUIDANCE_STATE_PROCEEDTOROUTE:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPoManeuverState_Parse (const char *str, size_t length, T_e8_DiPoManeuverState &value)
{
    static stringEntry entries[] = {
        {29,"E8DIPO_MANEUVER_STATE_EXECUTE", 3U},
        {29,"E8DIPO_MANEUVER_STATE_INITIAL", 1U},
        {29,"E8DIPO_MANEUVER_STATE_PREPARE", 2U},
        {30,"E8DIPO_MANEUVER_STATE_CONTINUE", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_DiPoManeuverState_Name (T_e8_DiPoManeuverState value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_MANEUVER_STATE_CONTINUE",
        "e8DIPO_MANEUVER_STATE_INITIAL",
        "e8DIPO_MANEUVER_STATE_PREPARE",
        "e8DIPO_MANEUVER_STATE_EXECUTE",
    };

    if (T_e8_DiPoManeuverState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPoManeuverState_IsValid (T_e8_DiPoManeuverState value)
{
    switch (value) {
    case T_e8_DiPoManeuverState__e8DIPO_MANEUVER_STATE_CONTINUE:
    case T_e8_DiPoManeuverState__e8DIPO_MANEUVER_STATE_INITIAL:
    case T_e8_DiPoManeuverState__e8DIPO_MANEUVER_STATE_PREPARE:
    case T_e8_DiPoManeuverState__e8DIPO_MANEUVER_STATE_EXECUTE:
        return true;
    default:
        return false;
    }
}

bool T_e8_DistanceUnits_Parse (const char *str, size_t length, T_e8_DistanceUnits &value)
{
    static stringEntry entries[] = {
        {28,"MANEUVER_DISTANCE_UNITS_FEET", 6U},
        {29,"MANEUVER_DISTANCE_UNITS_MILES", 4U},
        {29,"MANEUVER_DISTANCE_UNITS_YARDS", 7U},
        {30,"MANEUVER_DISTANCE_UNITS_METERS", 1U},
        {31,"MANEUVER_DISTANCE_UNITS_UNKNOWN", 0U},
        {32,"MANEUVER_DISTANCE_UNITS_MILES_P1", 5U},
        {34,"MANEUVER_DISTANCE_UNITS_KILOMETERS", 2U},
        {37,"MANEUVER_DISTANCE_UNITS_KILOMETERS_P1", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 8, (unsigned int&) value);
}

const char* T_e8_DistanceUnits_Name (T_e8_DistanceUnits value)
{
    static const char* enumerationLiterals[] = {
        "MANEUVER_DISTANCE_UNITS_UNKNOWN",
        "MANEUVER_DISTANCE_UNITS_METERS",
        "MANEUVER_DISTANCE_UNITS_KILOMETERS",
        "MANEUVER_DISTANCE_UNITS_KILOMETERS_P1",
        "MANEUVER_DISTANCE_UNITS_MILES",
        "MANEUVER_DISTANCE_UNITS_MILES_P1",
        "MANEUVER_DISTANCE_UNITS_FEET",
        "MANEUVER_DISTANCE_UNITS_YARDS",
    };

    if (T_e8_DistanceUnits_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DistanceUnits_IsValid (T_e8_DistanceUnits value)
{
    switch (value) {
    case T_e8_DistanceUnits__MANEUVER_DISTANCE_UNITS_UNKNOWN:
    case T_e8_DistanceUnits__MANEUVER_DISTANCE_UNITS_METERS:
    case T_e8_DistanceUnits__MANEUVER_DISTANCE_UNITS_KILOMETERS:
    case T_e8_DistanceUnits__MANEUVER_DISTANCE_UNITS_KILOMETERS_P1:
    case T_e8_DistanceUnits__MANEUVER_DISTANCE_UNITS_MILES:
    case T_e8_DistanceUnits__MANEUVER_DISTANCE_UNITS_MILES_P1:
    case T_e8_DistanceUnits__MANEUVER_DISTANCE_UNITS_FEET:
    case T_e8_DistanceUnits__MANEUVER_DISTANCE_UNITS_YARDS:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPoManeuverType_Parse (const char *str, size_t length, T_e8_DiPoManeuverType &value)
{
    static stringEntry entries[] = {
        {28,"E8DIPO_MANEUVER_TYPE_NO_TURN", 0U},
        {28,"E8DIPO_MANEUVER_TYPE_ON_RAMP", 9U},
        {29,"E8DIPO_MANEUVER_TYPE_CONTINUE", 5U},
        {29,"E8DIPO_MANEUVER_TYPE_OFF_RAMP", 8U},
        {30,"E8DIPO_MANEUVER_TYPE_KEEP_LEFT", 13U},
        {30,"E8DIPO_MANEUVER_TYPE_LEFT_TURN", 1U},
        {31,"E8DIPO_MANEUVER_TYPE_EXIT_FERRY", 16U},
        {31,"E8DIPO_MANEUVER_TYPE_KEEP_RIGHT", 14U},
        {31,"E8DIPO_MANEUVER_TYPE_RIGHT_TURN", 2U},
        {32,"E8DIPO_MANEUVER_TYPE_ENTER_FERRY", 15U},
        {32,"E8DIPO_MANEUVER_TYPE_MAKE_U_TURN", 4U},
        {35,"E8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY", 51U},
        {35,"E8DIPO_MANEUVER_TYPE_STRAIGHT_AHEAD", 3U},
        {36,"E8DIPO_MANEUVER_TYPE_EXIT_ROUNDABOUT", 7U},
        {36,"E8DIPO_MANEUVER_TYPE_SHARP_LEFT_TURN", 47U},
        {37,"E8DIPO_MANEUVER_TYPE_ENTER_ROUNDABOUT", 6U},
        {37,"E8DIPO_MANEUVER_TYPE_SHARP_RIGHT_TURN", 48U},
        {37,"E8DIPO_MANEUVER_TYPE_SLIGHT_LEFT_TURN", 49U},
        {38,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_1", 28U},
        {38,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_2", 29U},
        {38,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_3", 30U},
        {38,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_4", 31U},
        {38,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_5", 32U},
        {38,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_6", 33U},
        {38,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_7", 34U},
        {38,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_8", 35U},
        {38,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_9", 36U},
        {38,"E8DIPO_MANEUVER_TYPE_SLIGHT_RIGHT_TURN", 50U},
        {39,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_10", 37U},
        {39,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_11", 38U},
        {39,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_12", 39U},
        {39,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_13", 40U},
        {39,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_14", 41U},
        {39,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_15", 42U},
        {39,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_16", 43U},
        {39,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_17", 44U},
        {39,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_18", 45U},
        {39,"E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_19", 46U},
        {40,"E8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY_LEFT", 52U},
        {41,"E8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY_RIGHT", 53U},
        {42,"E8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION", 12U},
        {42,"E8DIPO_MANEUVER_TYPE_END_OF_ROAD_TURN_LEFT", 20U},
        {42,"E8DIPO_MANEUVER_TYPE_HIGHWAY_OFF_RAMP_LEFT", 22U},
        {43,"E8DIPO_MANEUVER_TYPE_END_OF_ROAD_TURN_RIGHT", 21U},
        {43,"E8DIPO_MANEUVER_TYPE_HIGHWAY_OFF_RAMP_RIGHT", 23U},
        {45,"E8DIPO_MANEUVER_TYPE_ARRIVE_END_OF_DIRECTIONS", 27U},
        {45,"E8DIPO_MANEUVER_TYPE_ARRIVE_END_OF_NAVIGATION", 10U},
        {46,"E8DIPO_MANEUVER_TYPE_CHANGE_TO_DIFFERENT_FERRY", 17U},
        {46,"E8DIPO_MANEUVER_TYPE_MAKE_U_TURN_WHEN_POSSIBLE", 26U},
        {47,"E8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION_LEFT", 24U},
        {48,"E8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION_RIGHT", 25U},
        {50,"E8DIPO_MANEUVER_TYPE_USE_ROUNDABOUT_TO_MAKE_U_TURN", 19U},
        {53,"E8DIPO_MANEUVER_TYPE_MAKE_U_TURN_AND_PROCEED_TO_ROUTE", 18U},
        {54,"E8DIPO_MANEUVER_TYPE_PROCEED_TO_THE_BEGINNING_OF_ROUTE", 11U},
    };

    return lookupInStringEntryTable (str, length, entries, 54, (unsigned int&) value);
}

const char* T_e8_DiPoManeuverType_Name (T_e8_DiPoManeuverType value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_MANEUVER_TYPE_NO_TURN",
        "e8DIPO_MANEUVER_TYPE_LEFT_TURN",
        "e8DIPO_MANEUVER_TYPE_RIGHT_TURN",
        "e8DIPO_MANEUVER_TYPE_STRAIGHT_AHEAD",
        "e8DIPO_MANEUVER_TYPE_MAKE_U_TURN",
        "e8DIPO_MANEUVER_TYPE_CONTINUE",
        "e8DIPO_MANEUVER_TYPE_ENTER_ROUNDABOUT",
        "e8DIPO_MANEUVER_TYPE_EXIT_ROUNDABOUT",
        "e8DIPO_MANEUVER_TYPE_OFF_RAMP",
        "e8DIPO_MANEUVER_TYPE_ON_RAMP",
        "e8DIPO_MANEUVER_TYPE_ARRIVE_END_OF_NAVIGATION",
        "e8DIPO_MANEUVER_TYPE_PROCEED_TO_THE_BEGINNING_OF_ROUTE",
        "e8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION",
        "e8DIPO_MANEUVER_TYPE_KEEP_LEFT",
        "e8DIPO_MANEUVER_TYPE_KEEP_RIGHT",
        "e8DIPO_MANEUVER_TYPE_ENTER_FERRY",
        "e8DIPO_MANEUVER_TYPE_EXIT_FERRY",
        "e8DIPO_MANEUVER_TYPE_CHANGE_TO_DIFFERENT_FERRY",
        "e8DIPO_MANEUVER_TYPE_MAKE_U_TURN_AND_PROCEED_TO_ROUTE",
        "e8DIPO_MANEUVER_TYPE_USE_ROUNDABOUT_TO_MAKE_U_TURN",
        "e8DIPO_MANEUVER_TYPE_END_OF_ROAD_TURN_LEFT",
        "e8DIPO_MANEUVER_TYPE_END_OF_ROAD_TURN_RIGHT",
        "e8DIPO_MANEUVER_TYPE_HIGHWAY_OFF_RAMP_LEFT",
        "e8DIPO_MANEUVER_TYPE_HIGHWAY_OFF_RAMP_RIGHT",
        "e8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION_LEFT",
        "e8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION_RIGHT",
        "e8DIPO_MANEUVER_TYPE_MAKE_U_TURN_WHEN_POSSIBLE",
        "e8DIPO_MANEUVER_TYPE_ARRIVE_END_OF_DIRECTIONS",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_1",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_2",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_3",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_4",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_5",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_6",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_7",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_8",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_9",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_10",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_11",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_12",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_13",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_14",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_15",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_16",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_17",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_18",
        "e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_19",
        "e8DIPO_MANEUVER_TYPE_SHARP_LEFT_TURN",
        "e8DIPO_MANEUVER_TYPE_SHARP_RIGHT_TURN",
        "e8DIPO_MANEUVER_TYPE_SLIGHT_LEFT_TURN",
        "e8DIPO_MANEUVER_TYPE_SLIGHT_RIGHT_TURN",
        "e8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY",
        "e8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY_LEFT",
        "e8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY_RIGHT",
    };

    if (T_e8_DiPoManeuverType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPoManeuverType_IsValid (T_e8_DiPoManeuverType value)
{
    switch (value) {
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_NO_TURN:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_LEFT_TURN:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_RIGHT_TURN:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_STRAIGHT_AHEAD:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_MAKE_U_TURN:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_CONTINUE:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ENTER_ROUNDABOUT:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_EXIT_ROUNDABOUT:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_OFF_RAMP:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ON_RAMP:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ARRIVE_END_OF_NAVIGATION:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_PROCEED_TO_THE_BEGINNING_OF_ROUTE:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_KEEP_LEFT:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_KEEP_RIGHT:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ENTER_FERRY:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_EXIT_FERRY:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_CHANGE_TO_DIFFERENT_FERRY:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_MAKE_U_TURN_AND_PROCEED_TO_ROUTE:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_USE_ROUNDABOUT_TO_MAKE_U_TURN:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_END_OF_ROAD_TURN_LEFT:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_END_OF_ROAD_TURN_RIGHT:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_HIGHWAY_OFF_RAMP_LEFT:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_HIGHWAY_OFF_RAMP_RIGHT:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION_LEFT:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION_RIGHT:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_MAKE_U_TURN_WHEN_POSSIBLE:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ARRIVE_END_OF_DIRECTIONS:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_1:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_2:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_3:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_4:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_5:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_6:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_7:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_8:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_9:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_10:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_11:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_12:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_13:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_14:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_15:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_16:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_17:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_18:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_19:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_SHARP_LEFT_TURN:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_SHARP_RIGHT_TURN:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_SLIGHT_LEFT_TURN:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_SLIGHT_RIGHT_TURN:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY_LEFT:
    case T_e8_DiPoManeuverType__e8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY_RIGHT:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPoDrivingSide_Parse (const char *str, size_t length, T_e8_DiPoDrivingSide &value)
{
    static stringEntry entries[] = {
        {24,"E8DIPO_DRIVING_SIDE_LEFT", 1U},
        {25,"E8DIPO_DRIVING_SIDE_RIGHT", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_DiPoDrivingSide_Name (T_e8_DiPoDrivingSide value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_DRIVING_SIDE_RIGHT",
        "e8DIPO_DRIVING_SIDE_LEFT",
    };

    if (T_e8_DiPoDrivingSide_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPoDrivingSide_IsValid (T_e8_DiPoDrivingSide value)
{
    switch (value) {
    case T_e8_DiPoDrivingSide__e8DIPO_DRIVING_SIDE_RIGHT:
    case T_e8_DiPoDrivingSide__e8DIPO_DRIVING_SIDE_LEFT:
        return true;
    default:
        return false;
    }
}

bool T_e8_DiPoJunctionType_Parse (const char *str, size_t length, T_e8_DiPoJunctionType &value)
{
    static stringEntry entries[] = {
        {31,"E8DIPO_JUNCTION_TYPE_ROUNDABOUT", 1U},
        {40,"E8DIPO_JUNCTION_TYPE_SINGLE_INTERSECTION", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_DiPoJunctionType_Name (T_e8_DiPoJunctionType value)
{
    static const char* enumerationLiterals[] = {
        "e8DIPO_JUNCTION_TYPE_SINGLE_INTERSECTION",
        "e8DIPO_JUNCTION_TYPE_ROUNDABOUT",
    };

    if (T_e8_DiPoJunctionType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DiPoJunctionType_IsValid (T_e8_DiPoJunctionType value)
{
    switch (value) {
    case T_e8_DiPoJunctionType__e8DIPO_JUNCTION_TYPE_SINGLE_INTERSECTION:
    case T_e8_DiPoJunctionType__e8DIPO_JUNCTION_TYPE_ROUNDABOUT:
        return true;
    default:
        return false;
    }
}

bool T_e8_AAutoTurnSide_Parse (const char *str, size_t length, T_e8_AAutoTurnSide &value)
{
    static stringEntry entries[] = {
        {14,"TURN_SIDE_LEFT", 1U},
        {15,"TURN_SIDE_RIGHT", 2U},
        {21,"TURN_SIDE_UNSPECIFIED", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_AAutoTurnSide_Name (T_e8_AAutoTurnSide value)
{
    static const char* enumerationLiterals[] = {
        "TURN_SIDE_LEFT",
        "TURN_SIDE_RIGHT",
        "TURN_SIDE_UNSPECIFIED",
    };

    if (T_e8_AAutoTurnSide_IsValid(value))
        return enumerationLiterals[value - 1U];
    else
        return NULL;
}

bool T_e8_AAutoTurnSide_IsValid (T_e8_AAutoTurnSide value)
{
    switch (value) {
    case T_e8_AAutoTurnSide__TURN_SIDE_LEFT:
    case T_e8_AAutoTurnSide__TURN_SIDE_RIGHT:
    case T_e8_AAutoTurnSide__TURN_SIDE_UNSPECIFIED:
        return true;
    default:
        return false;
    }
}

bool T_e8_AAutoNextTurnEvent_Parse (const char *str, size_t length, T_e8_AAutoNextTurnEvent &value)
{
    static stringEntry entries[] = {
        {14,"NEXT_TURN_FORK", 9U},
        {14,"NEXT_TURN_TURN", 4U},
        {15,"NEXT_TURN_MERGE", 10U},
        {16,"NEXT_TURN_DEPART", 1U},
        {16,"NEXT_TURN_U_TURN", 6U},
        {17,"NEXT_TURN_ON_RAMP", 7U},
        {17,"NEXT_TURN_UNKNOWN", 0U},
        {18,"NEXT_TURN_OFF_RAMP", 8U},
        {18,"NEXT_TURN_STRAIGHT", 14U},
        {20,"NEXT_TURN_FERRY_BOAT", 16U},
        {20,"NEXT_TURN_SHARP_TURN", 5U},
        {21,"NEXT_TURN_DESTINATION", 19U},
        {21,"NEXT_TURN_FERRY_TRAIN", 17U},
        {21,"NEXT_TURN_NAME_CHANGE", 2U},
        {21,"NEXT_TURN_SLIGHT_TURN", 3U},
        {25,"NEXT_TURN_ROUNDABOUT_EXIT", 12U},
        {26,"NEXT_TURN_ROUNDABOUT_ENTER", 11U},
        {35,"NEXT_TURN_ROUNDABOUT_ENTER_AND_EXIT", 13U},
    };

    return lookupInStringEntryTable (str, length, entries, 18, (unsigned int&) value);
}

const char* T_e8_AAutoNextTurnEvent_Name (T_e8_AAutoNextTurnEvent value)
{
    static const char* enumerationLiterals[] = {
        "NEXT_TURN_UNKNOWN",
        "NEXT_TURN_DEPART",
        "NEXT_TURN_NAME_CHANGE",
        "NEXT_TURN_SLIGHT_TURN",
        "NEXT_TURN_TURN",
        "NEXT_TURN_SHARP_TURN",
        "NEXT_TURN_U_TURN",
        "NEXT_TURN_ON_RAMP",
        "NEXT_TURN_OFF_RAMP",
        "NEXT_TURN_FORK",
        "NEXT_TURN_MERGE",
        "NEXT_TURN_ROUNDABOUT_ENTER",
        "NEXT_TURN_ROUNDABOUT_EXIT",
        "NEXT_TURN_ROUNDABOUT_ENTER_AND_EXIT",
        "NEXT_TURN_STRAIGHT",
        "NEXT_TURN_FERRY_BOAT",
        "NEXT_TURN_FERRY_TRAIN",
        "NEXT_TURN_DESTINATION",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        11U,
        12U,
        13U,
        14U,
        16U,
        17U,
        19U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 18, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_AAutoNextTurnEvent_IsValid (T_e8_AAutoNextTurnEvent value)
{
    switch (value) {
    case T_e8_AAutoNextTurnEvent__NEXT_TURN_UNKNOWN:
    case T_e8_AAutoNextTurnEvent__NEXT_TURN_DEPART:
    case T_e8_AAutoNextTurnEvent__NEXT_TURN_NAME_CHANGE:
    case T_e8_AAutoNextTurnEvent__NEXT_TURN_SLIGHT_TURN:
    case T_e8_AAutoNextTurnEvent__NEXT_TURN_TURN:
    case T_e8_AAutoNextTurnEvent__NEXT_TURN_SHARP_TURN:
    case T_e8_AAutoNextTurnEvent__NEXT_TURN_U_TURN:
    case T_e8_AAutoNextTurnEvent__NEXT_TURN_ON_RAMP:
    case T_e8_AAutoNextTurnEvent__NEXT_TURN_OFF_RAMP:
    case T_e8_AAutoNextTurnEvent__NEXT_TURN_FORK:
    case T_e8_AAutoNextTurnEvent__NEXT_TURN_MERGE:
    case T_e8_AAutoNextTurnEvent__NEXT_TURN_ROUNDABOUT_ENTER:
    case T_e8_AAutoNextTurnEvent__NEXT_TURN_ROUNDABOUT_EXIT:
    case T_e8_AAutoNextTurnEvent__NEXT_TURN_ROUNDABOUT_ENTER_AND_EXIT:
    case T_e8_AAutoNextTurnEvent__NEXT_TURN_STRAIGHT:
    case T_e8_AAutoNextTurnEvent__NEXT_TURN_FERRY_BOAT:
    case T_e8_AAutoNextTurnEvent__NEXT_TURN_FERRY_TRAIN:
    case T_e8_AAutoNextTurnEvent__NEXT_TURN_DESTINATION:
        return true;
    default:
        return false;
    }
}

bool T_e8_AAutoNavigationAppState_Parse (const char *str, size_t length, T_e8_AAutoNavigationAppState &value)
{
    static stringEntry entries[] = {
        {22,"AAUTO_STATE_NAV_ACTIVE", 1U},
        {23,"AAUTO_STATE_NAV_UNKNOWN", 0U},
        {25,"AAUTO_STATE_NAV_NOTACTIVE", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_AAutoNavigationAppState_Name (T_e8_AAutoNavigationAppState value)
{
    static const char* enumerationLiterals[] = {
        "AAUTO_STATE_NAV_UNKNOWN",
        "AAUTO_STATE_NAV_ACTIVE",
        "AAUTO_STATE_NAV_NOTACTIVE",
    };

    if (T_e8_AAutoNavigationAppState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AAutoNavigationAppState_IsValid (T_e8_AAutoNavigationAppState value)
{
    switch (value) {
    case T_e8_AAutoNavigationAppState__AAUTO_STATE_NAV_UNKNOWN:
    case T_e8_AAutoNavigationAppState__AAUTO_STATE_NAV_ACTIVE:
    case T_e8_AAutoNavigationAppState__AAUTO_STATE_NAV_NOTACTIVE:
        return true;
    default:
        return false;
    }
}

bool T_e8_BDCLNavigationAppState_Parse (const char *str, size_t length, T_e8_BDCLNavigationAppState &value)
{
    static stringEntry entries[] = {
        {26,"BDCL_NAV_STATE_ACTION_HIDE", 3U},
        {26,"BDCL_NAV_STATE_ACTION_SHOW", 1U},
        {28,"BDCL_NAV_STATE_ACTION_UPDATE", 2U},
        {29,"BDCL_NAV_STATE_ACTION_INVALID", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_BDCLNavigationAppState_Name (T_e8_BDCLNavigationAppState value)
{
    static const char* enumerationLiterals[] = {
        "BDCL_NAV_STATE_ACTION_INVALID",
        "BDCL_NAV_STATE_ACTION_SHOW",
        "BDCL_NAV_STATE_ACTION_UPDATE",
        "BDCL_NAV_STATE_ACTION_HIDE",
    };

    if (T_e8_BDCLNavigationAppState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_BDCLNavigationAppState_IsValid (T_e8_BDCLNavigationAppState value)
{
    switch (value) {
    case T_e8_BDCLNavigationAppState__BDCL_NAV_STATE_ACTION_INVALID:
    case T_e8_BDCLNavigationAppState__BDCL_NAV_STATE_ACTION_SHOW:
    case T_e8_BDCLNavigationAppState__BDCL_NAV_STATE_ACTION_UPDATE:
    case T_e8_BDCLNavigationAppState__BDCL_NAV_STATE_ACTION_HIDE:
        return true;
    default:
        return false;
    }
}

bool T_e8_BDCLNextTurnType_Parse (const char *str, size_t length, T_e8_BDCLNextTurnType &value)
{
    static stringEntry entries[] = {
        {14,"TURN_KIND_BACK", 5U},
        {14,"TURN_KIND_LEFT", 7U},
        {14,"TURN_KIND_RING", 14U},
        {15,"TURN_KIND_FRONT", 1U},
        {15,"TURN_KIND_RIGHT", 3U},
        {17,"NEXT_TURN_UNKNOWN", 0U},
        {17,"TURN_KIND_INFERRY", 15U},
        {18,"TURN_KIND_OUTFERRY", 16U},
        {18,"TURN_KIND_TOLLGATE", 17U},
        {19,"TURN_KIND_LEFT_BACK", 6U},
        {19,"TURN_KIND_LEFT_SIDE", 9U},
        {20,"TURN_KIND_LEFT_FRONT", 8U},
        {20,"TURN_KIND_RIGHT_BACK", 4U},
        {20,"TURN_KIND_RIGHT_SIDE", 10U},
        {21,"TURN_KIND_BRANCH_LEFT", 11U},
        {21,"TURN_KIND_RIGHT_FRONT", 2U},
        {22,"TURN_KIND_BRANCH_RIGHT", 13U},
        {22,"TURN_KIND_LEFT_SIDE_IC", 20U},
        {23,"TURN_KIND_BRANCH_CENTER", 12U},
        {23,"TURN_KIND_RIGHT_SIDE_IC", 21U},
        {24,"TURN_KIND_BRANCH_LEFT_IC", 29U},
        {24,"TURN_KIND_LEFT_SIDE_MAIN", 18U},
        {25,"TURN_KIND_BRANCH_RIGHT_IC", 31U},
        {25,"TURN_KIND_RIGHT_SIDE_MAIN", 19U},
        {26,"TURN_KIND_BRANCH_CENTER_IC", 30U},
        {28,"TURN_KIND_LEFT_SIDE_STRAIGHT", 24U},
        {29,"TURN_KIND_RIGHT_SIDE_STRAIGHT", 25U},
        {30,"TURN_KIND_BRANCH_LEFT_STRAIGHT", 26U},
        {31,"TURN_KIND_BRANCH_RIGHT_STRAIGHT", 28U},
        {31,"TURN_KIND_LEFT_SIDE_STRAIGHT_IC", 22U},
        {32,"TURN_KIND_BACK_2BRANCH_LEFT_BASE", 54U},
        {32,"TURN_KIND_BACK_3BRANCH_LEFT_BASE", 56U},
        {32,"TURN_KIND_BRANCH_CENTER_STRAIGHT", 27U},
        {32,"TURN_KIND_LEFT_2BRANCH_LEFT_BASE", 40U},
        {32,"TURN_KIND_LEFT_3BRANCH_LEFT_BASE", 42U},
        {32,"TURN_KIND_RIGHT_SIDE_STRAIGHT_IC", 23U},
        {33,"TURN_KIND_BACK_2BRANCH_RIGHT_BASE", 55U},
        {33,"TURN_KIND_BACK_3BRANCH_RIGHT_BASE", 58U},
        {33,"TURN_KIND_BRANCH_LEFT_IC_STRAIGHT", 32U},
        {33,"TURN_KIND_LEFT_2BRANCH_RIGHT_BASE", 41U},
        {33,"TURN_KIND_LEFT_3BRANCH_RIGHT_BASE", 44U},
        {33,"TURN_KIND_RIGHT_2BRANCH_LEFT_BASE", 45U},
        {33,"TURN_KIND_RIGHT_3BRANCH_LEFT_BASE", 47U},
        {34,"TURN_KIND_BACK_3BRANCH_MIDDLE_BASE", 57U},
        {34,"TURN_KIND_BRANCH_RIGHT_IC_STRAIGHT", 34U},
        {34,"TURN_KIND_LEFT_3BRANCH_MIDDLE_BASE", 43U},
        {34,"TURN_KIND_RIGHT_2BRANCH_RIGHT_BASE", 46U},
        {34,"TURN_KIND_RIGHT_3BRANCH_RIGHT_BASE", 49U},
        {35,"TURN_KIND_BRANCH_CENTER_IC_STRAIGHT", 33U},
        {35,"TURN_KIND_RIGHT_3BRANCH_MIDDLE_BASE", 48U},
        {36,"TURN_KIND_STRAIGHT_2BRANCH_LEFT_BASE", 35U},
        {36,"TURN_KIND_STRAIGHT_3BRANCH_LEFT_BASE", 37U},
        {37,"TURN_KIND_STRAIGHT_2BRANCH_RIGHT_BASE", 36U},
        {37,"TURN_KIND_STRAIGHT_3BRANCH_RIGHT_BASE", 39U},
        {38,"TURN_KIND_LEFT_FRONT_2BRANCH_LEFT_BASE", 50U},
        {38,"TURN_KIND_STRAIGHT_3BRANCH_MIDDLE_BASE", 38U},
        {39,"TURN_KIND_LEFT_FRONT_2BRANCH_RIGHT_BASE", 51U},
        {39,"TURN_KIND_RIGHT_FRONT_2BRANCH_LEFT_BASE", 52U},
        {40,"TURN_KIND_RIGHT_FRONT_2BRANCH_RIGHT_BASE", 53U},
    };

    return lookupInStringEntryTable (str, length, entries, 59, (unsigned int&) value);
}

const char* T_e8_BDCLNextTurnType_Name (T_e8_BDCLNextTurnType value)
{
    static const char* enumerationLiterals[] = {
        "NEXT_TURN_UNKNOWN",
        "TURN_KIND_FRONT",
        "TURN_KIND_RIGHT_FRONT",
        "TURN_KIND_RIGHT",
        "TURN_KIND_RIGHT_BACK",
        "TURN_KIND_BACK",
        "TURN_KIND_LEFT_BACK",
        "TURN_KIND_LEFT",
        "TURN_KIND_LEFT_FRONT",
        "TURN_KIND_LEFT_SIDE",
        "TURN_KIND_RIGHT_SIDE",
        "TURN_KIND_BRANCH_LEFT",
        "TURN_KIND_BRANCH_CENTER",
        "TURN_KIND_BRANCH_RIGHT",
        "TURN_KIND_RING",
        "TURN_KIND_INFERRY",
        "TURN_KIND_OUTFERRY",
        "TURN_KIND_TOLLGATE",
        "TURN_KIND_LEFT_SIDE_MAIN",
        "TURN_KIND_RIGHT_SIDE_MAIN",
        "TURN_KIND_LEFT_SIDE_IC",
        "TURN_KIND_RIGHT_SIDE_IC",
        "TURN_KIND_LEFT_SIDE_STRAIGHT_IC",
        "TURN_KIND_RIGHT_SIDE_STRAIGHT_IC",
        "TURN_KIND_LEFT_SIDE_STRAIGHT",
        "TURN_KIND_RIGHT_SIDE_STRAIGHT",
        "TURN_KIND_BRANCH_LEFT_STRAIGHT",
        "TURN_KIND_BRANCH_CENTER_STRAIGHT",
        "TURN_KIND_BRANCH_RIGHT_STRAIGHT",
        "TURN_KIND_BRANCH_LEFT_IC",
        "TURN_KIND_BRANCH_CENTER_IC",
        "TURN_KIND_BRANCH_RIGHT_IC",
        "TURN_KIND_BRANCH_LEFT_IC_STRAIGHT",
        "TURN_KIND_BRANCH_CENTER_IC_STRAIGHT",
        "TURN_KIND_BRANCH_RIGHT_IC_STRAIGHT",
        "TURN_KIND_STRAIGHT_2BRANCH_LEFT_BASE",
        "TURN_KIND_STRAIGHT_2BRANCH_RIGHT_BASE",
        "TURN_KIND_STRAIGHT_3BRANCH_LEFT_BASE",
        "TURN_KIND_STRAIGHT_3BRANCH_MIDDLE_BASE",
        "TURN_KIND_STRAIGHT_3BRANCH_RIGHT_BASE",
        "TURN_KIND_LEFT_2BRANCH_LEFT_BASE",
        "TURN_KIND_LEFT_2BRANCH_RIGHT_BASE",
        "TURN_KIND_LEFT_3BRANCH_LEFT_BASE",
        "TURN_KIND_LEFT_3BRANCH_MIDDLE_BASE",
        "TURN_KIND_LEFT_3BRANCH_RIGHT_BASE",
        "TURN_KIND_RIGHT_2BRANCH_LEFT_BASE",
        "TURN_KIND_RIGHT_2BRANCH_RIGHT_BASE",
        "TURN_KIND_RIGHT_3BRANCH_LEFT_BASE",
        "TURN_KIND_RIGHT_3BRANCH_MIDDLE_BASE",
        "TURN_KIND_RIGHT_3BRANCH_RIGHT_BASE",
        "TURN_KIND_LEFT_FRONT_2BRANCH_LEFT_BASE",
        "TURN_KIND_LEFT_FRONT_2BRANCH_RIGHT_BASE",
        "TURN_KIND_RIGHT_FRONT_2BRANCH_LEFT_BASE",
        "TURN_KIND_RIGHT_FRONT_2BRANCH_RIGHT_BASE",
        "TURN_KIND_BACK_2BRANCH_LEFT_BASE",
        "TURN_KIND_BACK_2BRANCH_RIGHT_BASE",
        "TURN_KIND_BACK_3BRANCH_LEFT_BASE",
        "TURN_KIND_BACK_3BRANCH_MIDDLE_BASE",
        "TURN_KIND_BACK_3BRANCH_RIGHT_BASE",
    };

    if (T_e8_BDCLNextTurnType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_BDCLNextTurnType_IsValid (T_e8_BDCLNextTurnType value)
{
    switch (value) {
    case T_e8_BDCLNextTurnType__NEXT_TURN_UNKNOWN:
    case T_e8_BDCLNextTurnType__TURN_KIND_FRONT:
    case T_e8_BDCLNextTurnType__TURN_KIND_RIGHT_FRONT:
    case T_e8_BDCLNextTurnType__TURN_KIND_RIGHT:
    case T_e8_BDCLNextTurnType__TURN_KIND_RIGHT_BACK:
    case T_e8_BDCLNextTurnType__TURN_KIND_BACK:
    case T_e8_BDCLNextTurnType__TURN_KIND_LEFT_BACK:
    case T_e8_BDCLNextTurnType__TURN_KIND_LEFT:
    case T_e8_BDCLNextTurnType__TURN_KIND_LEFT_FRONT:
    case T_e8_BDCLNextTurnType__TURN_KIND_LEFT_SIDE:
    case T_e8_BDCLNextTurnType__TURN_KIND_RIGHT_SIDE:
    case T_e8_BDCLNextTurnType__TURN_KIND_BRANCH_LEFT:
    case T_e8_BDCLNextTurnType__TURN_KIND_BRANCH_CENTER:
    case T_e8_BDCLNextTurnType__TURN_KIND_BRANCH_RIGHT:
    case T_e8_BDCLNextTurnType__TURN_KIND_RING:
    case T_e8_BDCLNextTurnType__TURN_KIND_INFERRY:
    case T_e8_BDCLNextTurnType__TURN_KIND_OUTFERRY:
    case T_e8_BDCLNextTurnType__TURN_KIND_TOLLGATE:
    case T_e8_BDCLNextTurnType__TURN_KIND_LEFT_SIDE_MAIN:
    case T_e8_BDCLNextTurnType__TURN_KIND_RIGHT_SIDE_MAIN:
    case T_e8_BDCLNextTurnType__TURN_KIND_LEFT_SIDE_IC:
    case T_e8_BDCLNextTurnType__TURN_KIND_RIGHT_SIDE_IC:
    case T_e8_BDCLNextTurnType__TURN_KIND_LEFT_SIDE_STRAIGHT_IC:
    case T_e8_BDCLNextTurnType__TURN_KIND_RIGHT_SIDE_STRAIGHT_IC:
    case T_e8_BDCLNextTurnType__TURN_KIND_LEFT_SIDE_STRAIGHT:
    case T_e8_BDCLNextTurnType__TURN_KIND_RIGHT_SIDE_STRAIGHT:
    case T_e8_BDCLNextTurnType__TURN_KIND_BRANCH_LEFT_STRAIGHT:
    case T_e8_BDCLNextTurnType__TURN_KIND_BRANCH_CENTER_STRAIGHT:
    case T_e8_BDCLNextTurnType__TURN_KIND_BRANCH_RIGHT_STRAIGHT:
    case T_e8_BDCLNextTurnType__TURN_KIND_BRANCH_LEFT_IC:
    case T_e8_BDCLNextTurnType__TURN_KIND_BRANCH_CENTER_IC:
    case T_e8_BDCLNextTurnType__TURN_KIND_BRANCH_RIGHT_IC:
    case T_e8_BDCLNextTurnType__TURN_KIND_BRANCH_LEFT_IC_STRAIGHT:
    case T_e8_BDCLNextTurnType__TURN_KIND_BRANCH_CENTER_IC_STRAIGHT:
    case T_e8_BDCLNextTurnType__TURN_KIND_BRANCH_RIGHT_IC_STRAIGHT:
    case T_e8_BDCLNextTurnType__TURN_KIND_STRAIGHT_2BRANCH_LEFT_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_STRAIGHT_2BRANCH_RIGHT_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_STRAIGHT_3BRANCH_LEFT_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_STRAIGHT_3BRANCH_MIDDLE_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_STRAIGHT_3BRANCH_RIGHT_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_LEFT_2BRANCH_LEFT_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_LEFT_2BRANCH_RIGHT_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_LEFT_3BRANCH_LEFT_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_LEFT_3BRANCH_MIDDLE_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_LEFT_3BRANCH_RIGHT_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_RIGHT_2BRANCH_LEFT_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_RIGHT_2BRANCH_RIGHT_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_RIGHT_3BRANCH_LEFT_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_RIGHT_3BRANCH_MIDDLE_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_RIGHT_3BRANCH_RIGHT_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_LEFT_FRONT_2BRANCH_LEFT_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_LEFT_FRONT_2BRANCH_RIGHT_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_RIGHT_FRONT_2BRANCH_LEFT_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_RIGHT_FRONT_2BRANCH_RIGHT_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_BACK_2BRANCH_LEFT_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_BACK_2BRANCH_RIGHT_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_BACK_3BRANCH_LEFT_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_BACK_3BRANCH_MIDDLE_BASE:
    case T_e8_BDCLNextTurnType__TURN_KIND_BACK_3BRANCH_RIGHT_BASE:
        return true;
    default:
        return false;
    }
}

bool T_e8_BDCLAssistantType_Parse (const char *str, size_t length, T_e8_BDCLAssistantType &value)
{
    static stringEntry entries[] = {
        {27,"BDCL_ASSISTANT_TYPE_INVALID", 0U},
        {31,"BDCL_ASSISTANT_TYPE_SPEEDCAMERA", 2U},
        {31,"BDCL_ASSISTANT_TYPE_TRAFFICSIGN", 1U},
        {34,"BDCL_ASSISTANT_TYPE_INTERVALCAMERA", 5U},
        {34,"BDCL_ASSISTANT_TYPE_PECCANRYCAMERA", 4U},
        {38,"BDCL_ASSISTANT_TYPE_TRAFFICLIGHTCAMERA", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_BDCLAssistantType_Name (T_e8_BDCLAssistantType value)
{
    static const char* enumerationLiterals[] = {
        "BDCL_ASSISTANT_TYPE_INVALID",
        "BDCL_ASSISTANT_TYPE_TRAFFICSIGN",
        "BDCL_ASSISTANT_TYPE_SPEEDCAMERA",
        "BDCL_ASSISTANT_TYPE_TRAFFICLIGHTCAMERA",
        "BDCL_ASSISTANT_TYPE_PECCANRYCAMERA",
        "BDCL_ASSISTANT_TYPE_INTERVALCAMERA",
    };

    if (T_e8_BDCLAssistantType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_BDCLAssistantType_IsValid (T_e8_BDCLAssistantType value)
{
    switch (value) {
    case T_e8_BDCLAssistantType__BDCL_ASSISTANT_TYPE_INVALID:
    case T_e8_BDCLAssistantType__BDCL_ASSISTANT_TYPE_TRAFFICSIGN:
    case T_e8_BDCLAssistantType__BDCL_ASSISTANT_TYPE_SPEEDCAMERA:
    case T_e8_BDCLAssistantType__BDCL_ASSISTANT_TYPE_TRAFFICLIGHTCAMERA:
    case T_e8_BDCLAssistantType__BDCL_ASSISTANT_TYPE_PECCANRYCAMERA:
    case T_e8_BDCLAssistantType__BDCL_ASSISTANT_TYPE_INTERVALCAMERA:
        return true;
    default:
        return false;
    }
}

bool T_e8_BDCLTrafficSignType_Parse (const char *str, size_t length, T_e8_BDCLTrafficSignType &value)
{
    static stringEntry entries[] = {
        {28,"BDCL_TRAFFICSIGNTYPE_INVALID", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 1, (unsigned int&) value);
}

const char* T_e8_BDCLTrafficSignType_Name (T_e8_BDCLTrafficSignType value)
{
    static const char* enumerationLiterals[] = {
        "BDCL_TRAFFICSIGNTYPE_INVALID",
    };

    if (T_e8_BDCLTrafficSignType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_BDCLTrafficSignType_IsValid (T_e8_BDCLTrafficSignType value)
{
    switch (value) {
    case T_e8_BDCLTrafficSignType__BDCL_TRAFFICSIGNTYPE_INVALID:
        return true;
    default:
        return false;
    }
}

bool T_e8_DisplayContextReason_Parse (const char *str, size_t length, T_e8_DisplayContextReason &value)
{
    static stringEntry entries[] = {
        {30,"DISPLAY_CONTEXT_REASON_UNKNOWN", 0U},
        {34,"DISPLAY_CONTEXT_REASON_HOME_SCREEN", 1U},
        {34,"DISPLAY_CONTEXT_REASON_LAST_SCREEN", 2U},
        {39,"DISPLAY_CONTEXT_REASON_PHONE_SCREEN_OFF", 3U},
        {44,"DISPLAY_CONTEXT_REASON_SHOW_NATIVE_BT_SCREEN", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_DisplayContextReason_Name (T_e8_DisplayContextReason value)
{
    static const char* enumerationLiterals[] = {
        "DISPLAY_CONTEXT_REASON_UNKNOWN",
        "DISPLAY_CONTEXT_REASON_HOME_SCREEN",
        "DISPLAY_CONTEXT_REASON_LAST_SCREEN",
        "DISPLAY_CONTEXT_REASON_PHONE_SCREEN_OFF",
        "DISPLAY_CONTEXT_REASON_SHOW_NATIVE_BT_SCREEN",
    };

    if (T_e8_DisplayContextReason_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DisplayContextReason_IsValid (T_e8_DisplayContextReason value)
{
    switch (value) {
    case T_e8_DisplayContextReason__DISPLAY_CONTEXT_REASON_UNKNOWN:
    case T_e8_DisplayContextReason__DISPLAY_CONTEXT_REASON_HOME_SCREEN:
    case T_e8_DisplayContextReason__DISPLAY_CONTEXT_REASON_LAST_SCREEN:
    case T_e8_DisplayContextReason__DISPLAY_CONTEXT_REASON_PHONE_SCREEN_OFF:
    case T_e8_DisplayContextReason__DISPLAY_CONTEXT_REASON_SHOW_NATIVE_BT_SCREEN:
        return true;
    default:
        return false;
    }
}

bool T_e8_MLGuidanceState_Parse (const char *str, size_t length, T_e8_MLGuidanceState &value)
{
    static stringEntry entries[] = {
        {7,"OFF_MAP", 7U},
        {7,"UNKNOWN", 0U},
        {8,"NO_ROUTE", 4U},
        {8,"OFF_ROAD", 6U},
        {9,"NEW_ROUTE", 3U},
        {16,"DESTINATION_AREA", 8U},
        {16,"NORMAL_OPERATION", 5U},
        {17,"CALCULATING_ROUTE", 2U},
        {18,"NO_DESTINATION_SET", 1U},
        {19,"DESTINATION_REACHED", 9U},
    };

    return lookupInStringEntryTable (str, length, entries, 10, (unsigned int&) value);
}

const char* T_e8_MLGuidanceState_Name (T_e8_MLGuidanceState value)
{
    static const char* enumerationLiterals[] = {
        "UNKNOWN",
        "NO_DESTINATION_SET",
        "CALCULATING_ROUTE",
        "NEW_ROUTE",
        "NO_ROUTE",
        "NORMAL_OPERATION",
        "OFF_ROAD",
        "OFF_MAP",
        "DESTINATION_AREA",
        "DESTINATION_REACHED",
    };

    if (T_e8_MLGuidanceState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_MLGuidanceState_IsValid (T_e8_MLGuidanceState value)
{
    switch (value) {
    case T_e8_MLGuidanceState__UNKNOWN:
    case T_e8_MLGuidanceState__NO_DESTINATION_SET:
    case T_e8_MLGuidanceState__CALCULATING_ROUTE:
    case T_e8_MLGuidanceState__NEW_ROUTE:
    case T_e8_MLGuidanceState__NO_ROUTE:
    case T_e8_MLGuidanceState__NORMAL_OPERATION:
    case T_e8_MLGuidanceState__OFF_ROAD:
    case T_e8_MLGuidanceState__OFF_MAP:
    case T_e8_MLGuidanceState__DESTINATION_AREA:
    case T_e8_MLGuidanceState__DESTINATION_REACHED:
        return true;
    default:
        return false;
    }
}

bool T_e8_MLGuidanceActive_Parse (const char *str, size_t length, T_e8_MLGuidanceActive &value)
{
    static stringEntry entries[] = {
        {13,"GUIDANCE_NONE", 1U},
        {15,"GUIDANCE_CLIENT", 0U},
        {15,"GUIDANCE_SERVER", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_MLGuidanceActive_Name (T_e8_MLGuidanceActive value)
{
    static const char* enumerationLiterals[] = {
        "GUIDANCE_CLIENT",
        "GUIDANCE_NONE",
        "GUIDANCE_SERVER",
    };

    if (T_e8_MLGuidanceActive_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_MLGuidanceActive_IsValid (T_e8_MLGuidanceActive value)
{
    switch (value) {
    case T_e8_MLGuidanceActive__GUIDANCE_CLIENT:
    case T_e8_MLGuidanceActive__GUIDANCE_NONE:
    case T_e8_MLGuidanceActive__GUIDANCE_SERVER:
        return true;
    default:
        return false;
    }
}

bool T_e8_MLNextDirection_Parse (const char *str, size_t length, T_e8_MLNextDirection &value)
{
    static stringEntry entries[] = {
        {4,"WALK", 43U},
        {5,"FERRY", 40U},
        {5,"MERGE", 24U},
        {6,"TUNNEL", 37U},
        {7,"COMPASS", 44U},
        {7,"NO_INFO", 1U},
        {9,"EXIT_LEFT", 15U},
        {9,"KEEP_LEFT", 13U},
        {9,"NO_SYMBOL", 0U},
        {9,"TURN_LEFT", 7U},
        {10,"EXIT_RIGHT", 14U},
        {10,"FERRY_EXIT", 41U},
        {10,"KEEP_RIGHT", 12U},
        {10,"TURN_RIGHT", 6U},
        {10,"UTURN_LEFT", 11U},
        {11,"FERRY_ENTER", 39U},
        {11,"TUNNEL_EXIT", 38U},
        {11,"UTURN_RIGHT", 10U},
        {12,"TUNNEL_ENTER", 36U},
        {13,"FOLLOW_STREET", 2U},
        {13,"TURN_STRAIGHT", 3U},
        {14,"HIGHWAY_FOLLOW", 25U},
        {15,"TURN_SHARP_LEFT", 9U},
        {16,"TURN_SHARP_RIGHT", 8U},
        {16,"TURN_SLIGHT_LEFT", 5U},
        {17,"FINAL_DESTINATION", 80U},
        {17,"TURN_SLIGHT_RIGHT", 4U},
        {19,"HIGHWAY_SLIGHT_LEFT", 27U},
        {20,"HIGHWAY_SLIGHT_RIGHT", 26U},
        {21,"PUBLIC_TRANSPORTATION", 42U},
        {24,"DIRECTION_TO_DESTINATION", 45U},
        {24,"INTERMEDIATE_DESTINATION", 83U},
        {24,"ROUNDABOUT_LEFT_EXIT_NOW", 47U},
        {25,"DOUBLE_TURN_LEFT_AND_LEFT", 21U},
        {25,"ROUNDABOUT_RIGHT_EXIT_NOW", 46U},
        {26,"DOUBLE_TURN_LEFT_AND_RIGHT", 23U},
        {26,"DOUBLE_TURN_RIGHT_AND_LEFT", 22U},
        {27,"DOUBLE_TURN_RIGHT_AND_RIGHT", 20U},
        {28,"MICHIGAN_TURN_VARIANT_1_LEFT", 33U},
        {28,"MICHIGAN_TURN_VARIANT_2_LEFT", 35U},
        {29,"FINAL_DESTINATION_ON_THE_LEFT", 82U},
        {29,"MICHIGAN_TURN_VARIANT_1_RIGHT", 32U},
        {29,"MICHIGAN_TURN_VARIANT_2_RIGHT", 34U},
        {30,"FINAL_DESTINATION_ON_THE_RIGHT", 81U},
        {33,"ROUNDABOUT_LEFT_KNOWN_EXIT_NUMBER", 65U},
        {34,"ROUNDABOUT_RIGHT_KNOWN_EXIT_NUMBER", 49U},
        {35,"ROUNDABOUT_LEFT_UNKNOWN_EXIT_NUMBER", 64U},
        {36,"DOUBLE_TURN_SLIGHT_LEFT_AND_STRAIGHT", 19U},
        {36,"INTERMEDIATE_DESTINATION_ON_THE_LEFT", 85U},
        {36,"ROUNDABOUT_RIGHT_UNKNOWN_EXIT_NUMBER", 48U},
        {37,"DOUBLE_TURN_SLIGHT_RIGHT_AND_STRAIGHT", 18U},
        {37,"INTERMEDIATE_DESTINATION_ON_THE_RIGHT", 84U},
        {44,"HIGHWAY_DOUBLE_TURN_SLIGHT_LEFT_AND_STRAIGHT", 31U},
        {45,"DOUBLE_TURN_SLIGHT_LEFT_AND_SLIGHT_LEFT_AGAIN", 17U},
        {45,"HIGHWAY_DOUBLE_TURN_SLIGHT_RIGHT_AND_STRAIGHT", 30U},
        {47,"DOUBLE_TURN_SLIGHT_RIGHT_AND_SLIGHT_RIGHT_AGAIN", 16U},
        {47,"HIGHWAY_DOUBLE_TURN_SLIGHT_LEFT_AND_SLIGHT_LEFT", 29U},
        {49,"HIGHWAY_DOUBLE_TURN_SLIGHT_RIGHT_AND_SLIGHT_RIGHT", 28U},
    };

    return lookupInStringEntryTable (str, length, entries, 58, (unsigned int&) value);
}

const char* T_e8_MLNextDirection_Name (T_e8_MLNextDirection value)
{
    static const char* enumerationLiterals[] = {
        "NO_SYMBOL",
        "NO_INFO",
        "FOLLOW_STREET",
        "TURN_STRAIGHT",
        "TURN_SLIGHT_RIGHT",
        "TURN_SLIGHT_LEFT",
        "TURN_RIGHT",
        "TURN_LEFT",
        "TURN_SHARP_RIGHT",
        "TURN_SHARP_LEFT",
        "UTURN_RIGHT",
        "UTURN_LEFT",
        "KEEP_RIGHT",
        "KEEP_LEFT",
        "EXIT_RIGHT",
        "EXIT_LEFT",
        "DOUBLE_TURN_SLIGHT_RIGHT_AND_SLIGHT_RIGHT_AGAIN",
        "DOUBLE_TURN_SLIGHT_LEFT_AND_SLIGHT_LEFT_AGAIN",
        "DOUBLE_TURN_SLIGHT_RIGHT_AND_STRAIGHT",
        "DOUBLE_TURN_SLIGHT_LEFT_AND_STRAIGHT",
        "DOUBLE_TURN_RIGHT_AND_RIGHT",
        "DOUBLE_TURN_LEFT_AND_LEFT",
        "DOUBLE_TURN_RIGHT_AND_LEFT",
        "DOUBLE_TURN_LEFT_AND_RIGHT",
        "MERGE",
        "HIGHWAY_FOLLOW",
        "HIGHWAY_SLIGHT_RIGHT",
        "HIGHWAY_SLIGHT_LEFT",
        "HIGHWAY_DOUBLE_TURN_SLIGHT_RIGHT_AND_SLIGHT_RIGHT",
        "HIGHWAY_DOUBLE_TURN_SLIGHT_LEFT_AND_SLIGHT_LEFT",
        "HIGHWAY_DOUBLE_TURN_SLIGHT_RIGHT_AND_STRAIGHT",
        "HIGHWAY_DOUBLE_TURN_SLIGHT_LEFT_AND_STRAIGHT",
        "MICHIGAN_TURN_VARIANT_1_RIGHT",
        "MICHIGAN_TURN_VARIANT_1_LEFT",
        "MICHIGAN_TURN_VARIANT_2_RIGHT",
        "MICHIGAN_TURN_VARIANT_2_LEFT",
        "TUNNEL_ENTER",
        "TUNNEL",
        "TUNNEL_EXIT",
        "FERRY_ENTER",
        "FERRY",
        "FERRY_EXIT",
        "PUBLIC_TRANSPORTATION",
        "WALK",
        "COMPASS",
        "DIRECTION_TO_DESTINATION",
        "ROUNDABOUT_RIGHT_EXIT_NOW",
        "ROUNDABOUT_LEFT_EXIT_NOW",
        "ROUNDABOUT_RIGHT_UNKNOWN_EXIT_NUMBER",
        "ROUNDABOUT_RIGHT_KNOWN_EXIT_NUMBER",
        "ROUNDABOUT_LEFT_UNKNOWN_EXIT_NUMBER",
        "ROUNDABOUT_LEFT_KNOWN_EXIT_NUMBER",
        "FINAL_DESTINATION",
        "FINAL_DESTINATION_ON_THE_RIGHT",
        "FINAL_DESTINATION_ON_THE_LEFT",
        "INTERMEDIATE_DESTINATION",
        "INTERMEDIATE_DESTINATION_ON_THE_RIGHT",
        "INTERMEDIATE_DESTINATION_ON_THE_LEFT",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        11U,
        12U,
        13U,
        14U,
        15U,
        16U,
        17U,
        18U,
        19U,
        20U,
        21U,
        22U,
        23U,
        24U,
        25U,
        26U,
        27U,
        28U,
        29U,
        30U,
        31U,
        32U,
        33U,
        34U,
        35U,
        36U,
        37U,
        38U,
        39U,
        40U,
        41U,
        42U,
        43U,
        44U,
        45U,
        46U,
        47U,
        48U,
        49U,
        64U,
        65U,
        80U,
        81U,
        82U,
        83U,
        84U,
        85U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 58, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_MLNextDirection_IsValid (T_e8_MLNextDirection value)
{
    switch (value) {
    case T_e8_MLNextDirection__NO_SYMBOL:
    case T_e8_MLNextDirection__NO_INFO:
    case T_e8_MLNextDirection__FOLLOW_STREET:
    case T_e8_MLNextDirection__TURN_STRAIGHT:
    case T_e8_MLNextDirection__TURN_SLIGHT_RIGHT:
    case T_e8_MLNextDirection__TURN_SLIGHT_LEFT:
    case T_e8_MLNextDirection__TURN_RIGHT:
    case T_e8_MLNextDirection__TURN_LEFT:
    case T_e8_MLNextDirection__TURN_SHARP_RIGHT:
    case T_e8_MLNextDirection__TURN_SHARP_LEFT:
    case T_e8_MLNextDirection__UTURN_RIGHT:
    case T_e8_MLNextDirection__UTURN_LEFT:
    case T_e8_MLNextDirection__KEEP_RIGHT:
    case T_e8_MLNextDirection__KEEP_LEFT:
    case T_e8_MLNextDirection__EXIT_RIGHT:
    case T_e8_MLNextDirection__EXIT_LEFT:
    case T_e8_MLNextDirection__DOUBLE_TURN_SLIGHT_RIGHT_AND_SLIGHT_RIGHT_AGAIN:
    case T_e8_MLNextDirection__DOUBLE_TURN_SLIGHT_LEFT_AND_SLIGHT_LEFT_AGAIN:
    case T_e8_MLNextDirection__DOUBLE_TURN_SLIGHT_RIGHT_AND_STRAIGHT:
    case T_e8_MLNextDirection__DOUBLE_TURN_SLIGHT_LEFT_AND_STRAIGHT:
    case T_e8_MLNextDirection__DOUBLE_TURN_RIGHT_AND_RIGHT:
    case T_e8_MLNextDirection__DOUBLE_TURN_LEFT_AND_LEFT:
    case T_e8_MLNextDirection__DOUBLE_TURN_RIGHT_AND_LEFT:
    case T_e8_MLNextDirection__DOUBLE_TURN_LEFT_AND_RIGHT:
    case T_e8_MLNextDirection__MERGE:
    case T_e8_MLNextDirection__HIGHWAY_FOLLOW:
    case T_e8_MLNextDirection__HIGHWAY_SLIGHT_RIGHT:
    case T_e8_MLNextDirection__HIGHWAY_SLIGHT_LEFT:
    case T_e8_MLNextDirection__HIGHWAY_DOUBLE_TURN_SLIGHT_RIGHT_AND_SLIGHT_RIGHT:
    case T_e8_MLNextDirection__HIGHWAY_DOUBLE_TURN_SLIGHT_LEFT_AND_SLIGHT_LEFT:
    case T_e8_MLNextDirection__HIGHWAY_DOUBLE_TURN_SLIGHT_RIGHT_AND_STRAIGHT:
    case T_e8_MLNextDirection__HIGHWAY_DOUBLE_TURN_SLIGHT_LEFT_AND_STRAIGHT:
    case T_e8_MLNextDirection__MICHIGAN_TURN_VARIANT_1_RIGHT:
    case T_e8_MLNextDirection__MICHIGAN_TURN_VARIANT_1_LEFT:
    case T_e8_MLNextDirection__MICHIGAN_TURN_VARIANT_2_RIGHT:
    case T_e8_MLNextDirection__MICHIGAN_TURN_VARIANT_2_LEFT:
    case T_e8_MLNextDirection__TUNNEL_ENTER:
    case T_e8_MLNextDirection__TUNNEL:
    case T_e8_MLNextDirection__TUNNEL_EXIT:
    case T_e8_MLNextDirection__FERRY_ENTER:
    case T_e8_MLNextDirection__FERRY:
    case T_e8_MLNextDirection__FERRY_EXIT:
    case T_e8_MLNextDirection__PUBLIC_TRANSPORTATION:
    case T_e8_MLNextDirection__WALK:
    case T_e8_MLNextDirection__COMPASS:
    case T_e8_MLNextDirection__DIRECTION_TO_DESTINATION:
    case T_e8_MLNextDirection__ROUNDABOUT_RIGHT_EXIT_NOW:
    case T_e8_MLNextDirection__ROUNDABOUT_LEFT_EXIT_NOW:
    case T_e8_MLNextDirection__ROUNDABOUT_RIGHT_UNKNOWN_EXIT_NUMBER:
    case T_e8_MLNextDirection__ROUNDABOUT_RIGHT_KNOWN_EXIT_NUMBER:
    case T_e8_MLNextDirection__ROUNDABOUT_LEFT_UNKNOWN_EXIT_NUMBER:
    case T_e8_MLNextDirection__ROUNDABOUT_LEFT_KNOWN_EXIT_NUMBER:
    case T_e8_MLNextDirection__FINAL_DESTINATION:
    case T_e8_MLNextDirection__FINAL_DESTINATION_ON_THE_RIGHT:
    case T_e8_MLNextDirection__FINAL_DESTINATION_ON_THE_LEFT:
    case T_e8_MLNextDirection__INTERMEDIATE_DESTINATION:
    case T_e8_MLNextDirection__INTERMEDIATE_DESTINATION_ON_THE_RIGHT:
    case T_e8_MLNextDirection__INTERMEDIATE_DESTINATION_ON_THE_LEFT:
        return true;
    default:
        return false;
    }
}

bool T_e8_DistanceUnit_Parse (const char *str, size_t length, T_e8_DistanceUnit &value)
{
    static stringEntry entries[] = {
        {16,"DISTANCE_UNIT_KM", 1U},
        {18,"DISTANCE_UNIT_FEET", 2U},
        {19,"DISTANCE_UNIT_METER", 0U},
        {19,"DISTANCE_UNIT_MILES", 4U},
        {19,"DISTANCE_UNIT_YARDS", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_DistanceUnit_Name (T_e8_DistanceUnit value)
{
    static const char* enumerationLiterals[] = {
        "DISTANCE_UNIT_METER",
        "DISTANCE_UNIT_KM",
        "DISTANCE_UNIT_FEET",
        "DISTANCE_UNIT_YARDS",
        "DISTANCE_UNIT_MILES",
    };

    if (T_e8_DistanceUnit_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DistanceUnit_IsValid (T_e8_DistanceUnit value)
{
    switch (value) {
    case T_e8_DistanceUnit__DISTANCE_UNIT_METER:
    case T_e8_DistanceUnit__DISTANCE_UNIT_KM:
    case T_e8_DistanceUnit__DISTANCE_UNIT_FEET:
    case T_e8_DistanceUnit__DISTANCE_UNIT_YARDS:
    case T_e8_DistanceUnit__DISTANCE_UNIT_MILES:
        return true;
    default:
        return false;
    }
}

bool T_e32_Language_Parse (const char *str, size_t length, T_e32_Language &value)
{
    static stringEntry entries[] = {
        {13,"LANGUAGE_THAI", 51U},
        {14,"LANGUAGE_CZECH", 8U},
        {14,"LANGUAGE_DUTCH", 10U},
        {14,"LANGUAGE_GREEK", 24U},
        {14,"LANGUAGE_HINDI", 26U},
        {14,"LANGUAGE_MALAY", 34U},
        {15,"LANGUAGE_ARABIC", 2U},
        {15,"LANGUAGE_DANISH", 9U},
        {15,"LANGUAGE_FRENCH", 21U},
        {15,"LANGUAGE_GERMAN", 23U},
        {15,"LANGUAGE_HEBREW", 25U},
        {15,"LANGUAGE_KOREAN", 31U},
        {15,"LANGUAGE_POLISH", 38U},
        {16,"LANGUAGE_FINNISH", 19U},
        {16,"LANGUAGE_FLEMISH", 20U},
        {16,"LANGUAGE_ITALIAN", 29U},
        {16,"LANGUAGE_LATVIAN", 32U},
        {16,"LANGUAGE_RUSSIAN", 42U},
        {16,"LANGUAGE_SERBIAN", 43U},
        {16,"LANGUAGE_SPANISH", 46U},
        {16,"LANGUAGE_SWEDISH", 49U},
        {16,"LANGUAGE_TURKISH", 52U},
        {16,"LANGUAGE_UNKNOWN", 0U},
        {17,"LANGUAGE_ALBANIAN", 1U},
        {17,"LANGUAGE_CROATIAN", 7U},
        {17,"LANGUAGE_ESTONIAN", 18U},
        {17,"LANGUAGE_JAPANESE", 30U},
        {17,"LANGUAGE_ROMANIAN", 41U},
        {18,"LANGUAGE_BULGARIAN", 3U},
        {18,"LANGUAGE_HUNGARIAN", 27U},
        {18,"LANGUAGE_NORWEGIAN", 35U},
        {18,"LANGUAGE_SLOVAKIAN", 44U},
        {18,"LANGUAGE_SLOVENIAN", 45U},
        {18,"LANGUAGE_TAIWANESE", 50U},
        {18,"LANGUAGE_UKRAINIAN", 53U},
        {19,"LANGUAGE_ENGLISH_UK", 12U},
        {19,"LANGUAGE_ENGLISH_US", 13U},
        {19,"LANGUAGE_INDONESIAN", 28U},
        {19,"LANGUAGE_LITHUANIAN", 33U},
        {19,"LANGUAGE_PORTUGUESE", 39U},
        {19,"LANGUAGE_VIETNAMESE", 54U},
        {20,"LANGUAGE_PHILIPPINES", 37U},
        {20,"LANGUAGE_UNSUPPORTED", 2147483647U},
        {22,"LANGUAGE_ENGLISH_INDIA", 17U},
        {23,"LANGUAGE_FRENCH_CANDIAN", 22U},
        {24,"LANGUAGE_SPANISH_MEXICAN", 48U},
        {25,"LANGUAGE_ENGLISH_CANADIAN", 16U},
        {27,"LANGUAGE_ENGLISH_AUSTRALIAN", 11U},
        {27,"LANGUAGE_ENGLISH_US_FOR_JPN", 14U},
        {27,"LANGUAGE_ENGLISH_US_FOR_PRC", 15U},
        {29,"LANGUAGE_PORTUGUESE_BRAZILIAN", 40U},
        {30,"LANGUAGE_PERSIAN_FARSI_IRANIAN", 36U},
        {31,"LANGUAGE_SPANISH_LATIN_AMERICAN", 47U},
        {36,"LANGUAGE_CHINESE_MANDARIN_SIMPLIFIED", 6U},
        {37,"LANGUAGE_CHINESE_CANTONESE_SIMPLIFIED", 4U},
        {38,"LANGUAGE_CHINESE_CANTONESE_TRADITIONAL", 5U},
    };

    return lookupInStringEntryTable (str, length, entries, 56, (unsigned int&) value);
}

const char* T_e32_Language_Name (T_e32_Language value)
{
    static const char* enumerationLiterals[] = {
        "LANGUAGE_UNKNOWN",
        "LANGUAGE_ALBANIAN",
        "LANGUAGE_ARABIC",
        "LANGUAGE_BULGARIAN",
        "LANGUAGE_CHINESE_CANTONESE_SIMPLIFIED",
        "LANGUAGE_CHINESE_CANTONESE_TRADITIONAL",
        "LANGUAGE_CHINESE_MANDARIN_SIMPLIFIED",
        "LANGUAGE_CROATIAN",
        "LANGUAGE_CZECH",
        "LANGUAGE_DANISH",
        "LANGUAGE_DUTCH",
        "LANGUAGE_ENGLISH_AUSTRALIAN",
        "LANGUAGE_ENGLISH_UK",
        "LANGUAGE_ENGLISH_US",
        "LANGUAGE_ENGLISH_US_FOR_JPN",
        "LANGUAGE_ENGLISH_US_FOR_PRC",
        "LANGUAGE_ENGLISH_CANADIAN",
        "LANGUAGE_ENGLISH_INDIA",
        "LANGUAGE_ESTONIAN",
        "LANGUAGE_FINNISH",
        "LANGUAGE_FLEMISH",
        "LANGUAGE_FRENCH",
        "LANGUAGE_FRENCH_CANDIAN",
        "LANGUAGE_GERMAN",
        "LANGUAGE_GREEK",
        "LANGUAGE_HEBREW",
        "LANGUAGE_HINDI",
        "LANGUAGE_HUNGARIAN",
        "LANGUAGE_INDONESIAN",
        "LANGUAGE_ITALIAN",
        "LANGUAGE_JAPANESE",
        "LANGUAGE_KOREAN",
        "LANGUAGE_LATVIAN",
        "LANGUAGE_LITHUANIAN",
        "LANGUAGE_MALAY",
        "LANGUAGE_NORWEGIAN",
        "LANGUAGE_PERSIAN_FARSI_IRANIAN",
        "LANGUAGE_PHILIPPINES",
        "LANGUAGE_POLISH",
        "LANGUAGE_PORTUGUESE",
        "LANGUAGE_PORTUGUESE_BRAZILIAN",
        "LANGUAGE_ROMANIAN",
        "LANGUAGE_RUSSIAN",
        "LANGUAGE_SERBIAN",
        "LANGUAGE_SLOVAKIAN",
        "LANGUAGE_SLOVENIAN",
        "LANGUAGE_SPANISH",
        "LANGUAGE_SPANISH_LATIN_AMERICAN",
        "LANGUAGE_SPANISH_MEXICAN",
        "LANGUAGE_SWEDISH",
        "LANGUAGE_TAIWANESE",
        "LANGUAGE_THAI",
        "LANGUAGE_TURKISH",
        "LANGUAGE_UKRAINIAN",
        "LANGUAGE_VIETNAMESE",
        "LANGUAGE_UNSUPPORTED",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        11U,
        12U,
        13U,
        14U,
        15U,
        16U,
        17U,
        18U,
        19U,
        20U,
        21U,
        22U,
        23U,
        24U,
        25U,
        26U,
        27U,
        28U,
        29U,
        30U,
        31U,
        32U,
        33U,
        34U,
        35U,
        36U,
        37U,
        38U,
        39U,
        40U,
        41U,
        42U,
        43U,
        44U,
        45U,
        46U,
        47U,
        48U,
        49U,
        50U,
        51U,
        52U,
        53U,
        54U,
        2147483647U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 56, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e32_Language_IsValid (T_e32_Language value)
{
    switch (value) {
    case T_e32_Language__LANGUAGE_UNKNOWN:
    case T_e32_Language__LANGUAGE_ALBANIAN:
    case T_e32_Language__LANGUAGE_ARABIC:
    case T_e32_Language__LANGUAGE_BULGARIAN:
    case T_e32_Language__LANGUAGE_CHINESE_CANTONESE_SIMPLIFIED:
    case T_e32_Language__LANGUAGE_CHINESE_CANTONESE_TRADITIONAL:
    case T_e32_Language__LANGUAGE_CHINESE_MANDARIN_SIMPLIFIED:
    case T_e32_Language__LANGUAGE_CROATIAN:
    case T_e32_Language__LANGUAGE_CZECH:
    case T_e32_Language__LANGUAGE_DANISH:
    case T_e32_Language__LANGUAGE_DUTCH:
    case T_e32_Language__LANGUAGE_ENGLISH_AUSTRALIAN:
    case T_e32_Language__LANGUAGE_ENGLISH_UK:
    case T_e32_Language__LANGUAGE_ENGLISH_US:
    case T_e32_Language__LANGUAGE_ENGLISH_US_FOR_JPN:
    case T_e32_Language__LANGUAGE_ENGLISH_US_FOR_PRC:
    case T_e32_Language__LANGUAGE_ENGLISH_CANADIAN:
    case T_e32_Language__LANGUAGE_ENGLISH_INDIA:
    case T_e32_Language__LANGUAGE_ESTONIAN:
    case T_e32_Language__LANGUAGE_FINNISH:
    case T_e32_Language__LANGUAGE_FLEMISH:
    case T_e32_Language__LANGUAGE_FRENCH:
    case T_e32_Language__LANGUAGE_FRENCH_CANDIAN:
    case T_e32_Language__LANGUAGE_GERMAN:
    case T_e32_Language__LANGUAGE_GREEK:
    case T_e32_Language__LANGUAGE_HEBREW:
    case T_e32_Language__LANGUAGE_HINDI:
    case T_e32_Language__LANGUAGE_HUNGARIAN:
    case T_e32_Language__LANGUAGE_INDONESIAN:
    case T_e32_Language__LANGUAGE_ITALIAN:
    case T_e32_Language__LANGUAGE_JAPANESE:
    case T_e32_Language__LANGUAGE_KOREAN:
    case T_e32_Language__LANGUAGE_LATVIAN:
    case T_e32_Language__LANGUAGE_LITHUANIAN:
    case T_e32_Language__LANGUAGE_MALAY:
    case T_e32_Language__LANGUAGE_NORWEGIAN:
    case T_e32_Language__LANGUAGE_PERSIAN_FARSI_IRANIAN:
    case T_e32_Language__LANGUAGE_PHILIPPINES:
    case T_e32_Language__LANGUAGE_POLISH:
    case T_e32_Language__LANGUAGE_PORTUGUESE:
    case T_e32_Language__LANGUAGE_PORTUGUESE_BRAZILIAN:
    case T_e32_Language__LANGUAGE_ROMANIAN:
    case T_e32_Language__LANGUAGE_RUSSIAN:
    case T_e32_Language__LANGUAGE_SERBIAN:
    case T_e32_Language__LANGUAGE_SLOVAKIAN:
    case T_e32_Language__LANGUAGE_SLOVENIAN:
    case T_e32_Language__LANGUAGE_SPANISH:
    case T_e32_Language__LANGUAGE_SPANISH_LATIN_AMERICAN:
    case T_e32_Language__LANGUAGE_SPANISH_MEXICAN:
    case T_e32_Language__LANGUAGE_SWEDISH:
    case T_e32_Language__LANGUAGE_TAIWANESE:
    case T_e32_Language__LANGUAGE_THAI:
    case T_e32_Language__LANGUAGE_TURKISH:
    case T_e32_Language__LANGUAGE_UKRAINIAN:
    case T_e32_Language__LANGUAGE_VIETNAMESE:
    case T_e32_Language__LANGUAGE_UNSUPPORTED:
        return true;
    default:
        return false;
    }
}

bool T_e8_VehiclePowerModeState_Parse (const char *str, size_t length, T_e8_VehiclePowerModeState &value)
{
    static stringEntry entries[] = {
        {5,"SLEEP", 0U},
        {8,"AUTO_ACC", 1U},
        {11,"IGNITION_ON", 2U},
        {14,"ENGINE_RUNNING", 4U},
        {28,"INITIAL_STARTING_IN_PROGRESS", 3U},
        {29,"VEHICLE_POWERMODE_UNSUPPORTED", 255U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_VehiclePowerModeState_Name (T_e8_VehiclePowerModeState value)
{
    static const char* enumerationLiterals[] = {
        "SLEEP",
        "AUTO_ACC",
        "IGNITION_ON",
        "INITIAL_STARTING_IN_PROGRESS",
        "ENGINE_RUNNING",
        "VEHICLE_POWERMODE_UNSUPPORTED",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 6, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_VehiclePowerModeState_IsValid (T_e8_VehiclePowerModeState value)
{
    switch (value) {
    case T_e8_VehiclePowerModeState__SLEEP:
    case T_e8_VehiclePowerModeState__AUTO_ACC:
    case T_e8_VehiclePowerModeState__IGNITION_ON:
    case T_e8_VehiclePowerModeState__INITIAL_STARTING_IN_PROGRESS:
    case T_e8_VehiclePowerModeState__ENGINE_RUNNING:
    case T_e8_VehiclePowerModeState__VEHICLE_POWERMODE_UNSUPPORTED:
        return true;
    default:
        return false;
    }
}

bool T_e8Media_AppCategory_Parse (const char *str, size_t length, T_e8Media_AppCategory &value)
{
    static stringEntry entries[] = {
        {20,"MEDIA_APP_TYPE_IMAGE", 4U},
        {20,"MEDIA_APP_TYPE_MUSIC", 1U},
        {20,"MEDIA_APP_TYPE_RADIO", 0U},
        {20,"MEDIA_APP_TYPE_VIDEO", 2U},
        {21,"MEDIA_APP_TYPE_GAMING", 3U},
        {22,"MEDIA_APP_TYPE_UNKNOWN", 255U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8Media_AppCategory_Name (T_e8Media_AppCategory value)
{
    static const char* enumerationLiterals[] = {
        "MEDIA_APP_TYPE_RADIO",
        "MEDIA_APP_TYPE_MUSIC",
        "MEDIA_APP_TYPE_VIDEO",
        "MEDIA_APP_TYPE_GAMING",
        "MEDIA_APP_TYPE_IMAGE",
        "MEDIA_APP_TYPE_UNKNOWN",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 6, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8Media_AppCategory_IsValid (T_e8Media_AppCategory value)
{
    switch (value) {
    case T_e8Media_AppCategory__MEDIA_APP_TYPE_RADIO:
    case T_e8Media_AppCategory__MEDIA_APP_TYPE_MUSIC:
    case T_e8Media_AppCategory__MEDIA_APP_TYPE_VIDEO:
    case T_e8Media_AppCategory__MEDIA_APP_TYPE_GAMING:
    case T_e8Media_AppCategory__MEDIA_APP_TYPE_IMAGE:
    case T_e8Media_AppCategory__MEDIA_APP_TYPE_UNKNOWN:
        return true;
    default:
        return false;
    }
}

bool T_e8_ClientState_Parse (const char *str, size_t length, T_e8_ClientState &value)
{
    static stringEntry entries[] = {
        {21,"CLIENT_STATUS_UNKNOWN", 0U},
        {25,"CLIENT_STATUS_INITIALIZED", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_ClientState_Name (T_e8_ClientState value)
{
    static const char* enumerationLiterals[] = {
        "CLIENT_STATUS_UNKNOWN",
        "CLIENT_STATUS_INITIALIZED",
    };

    if (T_e8_ClientState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_ClientState_IsValid (T_e8_ClientState value)
{
    switch (value) {
    case T_e8_ClientState__CLIENT_STATUS_UNKNOWN:
    case T_e8_ClientState__CLIENT_STATUS_INITIALIZED:
        return true;
    default:
        return false;
    }
}

bool T_e32_KeyType_Parse (const char *str, size_t length, T_e32_KeyType &value)
{
    static stringEntry entries[] = {
        {8,"HARD_KEY", 0U},
        {8,"SOFT_KEY", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e32_KeyType_Name (T_e32_KeyType value)
{
    static const char* enumerationLiterals[] = {
        "HARD_KEY",
        "SOFT_KEY",
    };

    if (T_e32_KeyType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e32_KeyType_IsValid (T_e32_KeyType value)
{
    switch (value) {
    case T_e32_KeyType__HARD_KEY:
    case T_e32_KeyType__SOFT_KEY:
        return true;
    default:
        return false;
    }
}

bool T_e8_Entity_Parse (const char *str, size_t length, T_e8_Entity &value)
{
    static stringEntry entries[] = {
        {5,"PHONE", 2U},
        {7,"UNKNOWN", 0U},
        {8,"HEADUNIT", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_Entity_Name (T_e8_Entity value)
{
    static const char* enumerationLiterals[] = {
        "UNKNOWN",
        "HEADUNIT",
        "PHONE",
    };

    if (T_e8_Entity_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Entity_IsValid (T_e8_Entity value)
{
    switch (value) {
    case T_e8_Entity__UNKNOWN:
    case T_e8_Entity__HEADUNIT:
    case T_e8_Entity__PHONE:
        return true;
    default:
        return false;
    }
}

} // namespace midw_smartphoneint_fi_types
