/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "midw_smartphoneint_fi.h"
#include "midw_smartphoneint_fiJson.h"
#include "midw_smartphoneint_fi_types.h"
#include "midw_smartphoneint_fi_typesConst.h"
#include "midw_smartphoneint_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "DeviceStatusInfoStatus"

void serializeJson (const ::midw_smartphoneint_fi::DeviceStatusInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasDeviceConnectionType()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceConnectionType" , 20);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType_Name(value.getDeviceConnectionType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceConnectionType());
    }
    if (!isSparse || value.hasDeviceStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceStatus" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceStatusInfo_Name(value.getDeviceStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::DeviceStatusInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AppStatusInfoStatus"

void serializeJson (const ::midw_smartphoneint_fi::AppStatusInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasDeviceConnectionType()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceConnectionType" , 20);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType_Name(value.getDeviceConnectionType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceConnectionType());
    }
    if (!isSparse || value.hasAppStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "AppStatus" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_AppStatusInfo_Name(value.getAppStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAppStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::AppStatusInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DAPStatusInfoStatus"

void serializeJson (const ::midw_smartphoneint_fi::DAPStatusInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasDeviceConnectionType()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceConnectionType" , 20);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType_Name(value.getDeviceConnectionType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceConnectionType());
    }
    if (!isSparse || value.hasDAPStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "DAPStatus" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DAPStatus_Name(value.getDAPStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDAPStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::DAPStatusInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NotificationInfoStatus"

void serializeJson (const ::midw_smartphoneint_fi::NotificationInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasAppHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "AppHandle" , 9);
        yajl_gen_integer(g, (long long)value.getAppHandle());
    }
    if (!isSparse || value.hasNotificationData()) {
        yajl_gen_string(g, (const unsigned char*)  "NotificationData" , 16);
        serializeJson(value.getNotificationData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::NotificationInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ApplicationMediaMetaDataStatus"

void serializeJson (const ::midw_smartphoneint_fi::ApplicationMediaMetaDataStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasMetaDataValid()) {
        yajl_gen_string(g, (const unsigned char*)  "MetaDataValid" , 13);
        yajl_gen_bool(g, (bool)value.getMetaDataValid());
    }
    if (!isSparse || value.hasApplicationMediaMetaData()) {
        yajl_gen_string(g, (const unsigned char*)  "ApplicationMediaMetaData" , 24);
        serializeJson(value.getApplicationMediaMetaData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::ApplicationMediaMetaDataStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeviceDisplayContextStatus"

void serializeJson (const ::midw_smartphoneint_fi::DeviceDisplayContextStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasDisplayFlag()) {
        yajl_gen_string(g, (const unsigned char*)  "DisplayFlag" , 11);
        yajl_gen_bool(g, (bool)value.getDisplayFlag());
    }
    if (!isSparse || value.hasDisplayContextReason()) {
        yajl_gen_string(g, (const unsigned char*)  "DisplayContextReason" , 20);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DisplayContextReason_Name(value.getDisplayContextReason());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDisplayContextReason());
    }
    if (!isSparse || value.hasDisplayPermanentEntity()) {
        yajl_gen_string(g, (const unsigned char*)  "DisplayPermanentEntity" , 22);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_Entity_Name(value.getDisplayPermanentEntity());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDisplayPermanentEntity());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::DeviceDisplayContextStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ApplicationPhoneDataStatus"

void serializeJson (const ::midw_smartphoneint_fi::ApplicationPhoneDataStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasPhoneDataValid()) {
        yajl_gen_string(g, (const unsigned char*)  "PhoneDataValid" , 14);
        yajl_gen_bool(g, (bool)value.getPhoneDataValid());
    }
    if (!isSparse || value.hasPhoneCallMetadata()) {
        yajl_gen_string(g, (const unsigned char*)  "PhoneCallMetadata" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallMetadata >& o1 = value.getPhoneCallMetadata();
        {
            ::std::vector< ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallMetadata >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasSignalStrength()) {
        yajl_gen_string(g, (const unsigned char*)  "SignalStrength" , 14);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_PhoneSignalStrength_Name(value.getSignalStrength());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSignalStrength());
    }
    if (!isSparse || value.hasRegistrationStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "RegistrationStatus" , 18);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_PhoneRegistrationStatus_Name(value.getRegistrationStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRegistrationStatus());
    }
    if (!isSparse || value.hasAirPlaneModeStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "AirPlaneModeStatus" , 18);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_PhoneAirPlaneModeStatus_Name(value.getAirPlaneModeStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAirPlaneModeStatus());
    }
    if (!isSparse || value.hasMute()) {
        yajl_gen_string(g, (const unsigned char*)  "Mute" , 4);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_Mute_Name(value.getMute());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getMute());
    }
    if (!isSparse || value.hasCarrierName()) {
        yajl_gen_string(g, (const unsigned char*)  "CarrierName" , 11);
        const char *s = value.getCarrierName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBatteryChargeLevel()) {
        yajl_gen_string(g, (const unsigned char*)  "BatteryChargeLevel" , 18);
        yajl_gen_integer(g, (long long)value.getBatteryChargeLevel());
    }
    if (!isSparse || value.hasBatteryChargingState()) {
        yajl_gen_string(g, (const unsigned char*)  "BatteryChargingState" , 20);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_BatteryChargingState_Name(value.getBatteryChargingState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getBatteryChargingState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::ApplicationPhoneDataStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BluetoothDeviceStatusStatus"

void serializeJson (const ::midw_smartphoneint_fi::BluetoothDeviceStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBluetoothDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "BluetoothDeviceHandle" , 21);
        yajl_gen_integer(g, (long long)value.getBluetoothDeviceHandle());
    }
    if (!isSparse || value.hasProjectionDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "ProjectionDeviceHandle" , 22);
        yajl_gen_integer(g, (long long)value.getProjectionDeviceHandle());
    }
    if (!isSparse || value.hasConnectedProfiles()) {
        yajl_gen_string(g, (const unsigned char*)  "ConnectedProfiles" , 17);
        yajl_gen_integer(g, (long long)value.getConnectedProfiles());
    }
    if (!isSparse || value.hasBTChangeInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "BTChangeInfo" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_BTChangeInfo_Name(value.getBTChangeInfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getBTChangeInfo());
    }
    if (!isSparse || value.hasSameDevice()) {
        yajl_gen_string(g, (const unsigned char*)  "SameDevice" , 10);
        yajl_gen_bool(g, (bool)value.getSameDevice());
    }
    if (!isSparse || value.hasCallActiveStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "CallActiveStatus" , 16);
        yajl_gen_bool(g, (bool)value.getCallActiveStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::BluetoothDeviceStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeviceAudioContextStatus"

void serializeJson (const ::midw_smartphoneint_fi::DeviceAudioContextStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasAudioFlag()) {
        yajl_gen_string(g, (const unsigned char*)  "AudioFlag" , 9);
        yajl_gen_bool(g, (bool)value.getAudioFlag());
    }
    if (!isSparse || value.hasAudioContext()) {
        yajl_gen_string(g, (const unsigned char*)  "AudioContext" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_AudioContext_Name(value.getAudioContext());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAudioContext());
    }
    if (!isSparse || value.hasAudioPermanentEntity()) {
        yajl_gen_string(g, (const unsigned char*)  "AudioPermanentEntity" , 20);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_Entity_Name(value.getAudioPermanentEntity());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAudioPermanentEntity());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::DeviceAudioContextStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DiPOAppStatusInfoStatus"

void serializeJson (const ::midw_smartphoneint_fi::DiPOAppStatusInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAppStateSpeech()) {
        yajl_gen_string(g, (const unsigned char*)  "AppStateSpeech" , 14);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_SpeechAppState_Name(value.getAppStateSpeech());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAppStateSpeech());
    }
    if (!isSparse || value.hasAppStatePhone()) {
        yajl_gen_string(g, (const unsigned char*)  "AppStatePhone" , 13);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_PhoneAppState_Name(value.getAppStatePhone());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAppStatePhone());
    }
    if (!isSparse || value.hasAppStateNavigation()) {
        yajl_gen_string(g, (const unsigned char*)  "AppStateNavigation" , 18);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_NavigationAppState_Name(value.getAppStateNavigation());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAppStateNavigation());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::DiPOAppStatusInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SessionStatusInfoStatus"

void serializeJson (const ::midw_smartphoneint_fi::SessionStatusInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasDeviceCategory()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceCategory" , 14);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceCategory_Name(value.getDeviceCategory());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceCategory());
    }
    if (!isSparse || value.hasSessionStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "SessionStatus" , 13);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_SessionStatus_Name(value.getSessionStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSessionStatus());
    }
    if (!isSparse || value.hasHandsetInteractionStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "HandsetInteractionStatus" , 24);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_HandsetInteraction_Name(value.getHandsetInteractionStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getHandsetInteractionStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SessionStatusInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BTPairingRequiredStatus"

void serializeJson (const ::midw_smartphoneint_fi::BTPairingRequiredStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSDevBTAddr()) {
        yajl_gen_string(g, (const unsigned char*)  "sDevBTAddr" , 10);
        const char *s = value.getSDevBTAddr().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBPairingReqd()) {
        yajl_gen_string(g, (const unsigned char*)  "bPairingReqd" , 12);
        yajl_gen_bool(g, (bool)value.getBPairingReqd());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::BTPairingRequiredStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MLServerKeyCapabilitiesStatus"

void serializeJson (const ::midw_smartphoneint_fi::MLServerKeyCapabilitiesStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasValidityOfData()) {
        yajl_gen_string(g, (const unsigned char*)  "ValidityOfData" , 14);
        yajl_gen_integer(g, (long long)value.getValidityOfData());
    }
    if (!isSparse || value.hasNumXDeviceKeys()) {
        yajl_gen_string(g, (const unsigned char*)  "NumXDeviceKeys" , 14);
        yajl_gen_integer(g, (long long)value.getNumXDeviceKeys());
    }
    if (!isSparse || value.hasXDeviceKeysList()) {
        yajl_gen_string(g, (const unsigned char*)  "XDeviceKeysList" , 15);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_smartphoneint_fi_types::T_XDeviceKeys >& o3 = value.getXDeviceKeysList();
        {
            ::std::vector< ::midw_smartphoneint_fi_types::T_XDeviceKeys >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasRKeyCapabilities()) {
        yajl_gen_string(g, (const unsigned char*)  "rKeyCapabilities" , 16);
        serializeJson(value.getRKeyCapabilities(), g, options);
    }
    if (!isSparse || value.hasVoiceRecognitionSupportInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "VoiceRecognitionSupportInfo" , 27);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_SupportInfo_Name(value.getVoiceRecognitionSupportInfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getVoiceRecognitionSupportInfo());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::MLServerKeyCapabilitiesStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DialStatus"

void serializeJson (const ::midw_smartphoneint_fi::DialStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasTelephoneNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "TelephoneNumber" , 15);
        const char *s = value.getTelephoneNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasDisplayContent()) {
        yajl_gen_string(g, (const unsigned char*)  "DisplayContent" , 14);
        const char *s = value.getDisplayContent().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::DialStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DialSet"

void serializeJson (const ::midw_smartphoneint_fi::DialSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasPhoneCallState()) {
        yajl_gen_string(g, (const unsigned char*)  "PhoneCallState" , 14);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_PhoneCallState_Name(value.getPhoneCallState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getPhoneCallState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::DialSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MediaPlayBackTimeStatus"

void serializeJson (const ::midw_smartphoneint_fi::MediaPlayBackTimeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasTotalPlayTime()) {
        yajl_gen_string(g, (const unsigned char*)  "TotalPlayTime" , 13);
        yajl_gen_integer(g, (long long)value.getTotalPlayTime());
    }
    if (!isSparse || value.hasElapsedPlayTime()) {
        yajl_gen_string(g, (const unsigned char*)  "ElapsedPlayTime" , 15);
        yajl_gen_integer(g, (long long)value.getElapsedPlayTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::MediaPlayBackTimeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ProjectionDeviceAuthorizationStatus"

void serializeJson (const ::midw_smartphoneint_fi::ProjectionDeviceAuthorizationStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNumDevices()) {
        yajl_gen_string(g, (const unsigned char*)  "NumDevices" , 10);
        yajl_gen_integer(g, (long long)value.getNumDevices());
    }
    if (!isSparse || value.hasDeviceAuthInfoList()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceAuthInfoList" , 18);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_smartphoneint_fi_types::T_DeviceAuthInfo >& o5 = value.getDeviceAuthInfoList();
        {
            ::std::vector< ::midw_smartphoneint_fi_types::T_DeviceAuthInfo >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                serializeJson((*o4), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::ProjectionDeviceAuthorizationStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ProjectionDeviceAuthorizationSet"

void serializeJson (const ::midw_smartphoneint_fi::ProjectionDeviceAuthorizationSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasUserAuthorizationStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "UserAuthorizationStatus" , 23);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_UserAuthorizationStatus_Name(value.getUserAuthorizationStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getUserAuthorizationStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::ProjectionDeviceAuthorizationSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NavigationStatusInfoStatus"

void serializeJson (const ::midw_smartphoneint_fi::NavigationStatusInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasDeviceCategory()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceCategory" , 14);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceCategory_Name(value.getDeviceCategory());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceCategory());
    }
    if (!isSparse || value.hasNavigationStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "NavigationStatus" , 16);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_NavigationAppState_Name(value.getNavigationStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getNavigationStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::NavigationStatusInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NavigationNextTurnDataStatus"

void serializeJson (const ::midw_smartphoneint_fi::NavigationNextTurnDataStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasDeviceCategory()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceCategory" , 14);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceCategory_Name(value.getDeviceCategory());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceCategory());
    }
    if (!isSparse || value.hasRoadName()) {
        yajl_gen_string(g, (const unsigned char*)  "RoadName" , 8);
        const char *s = value.getRoadName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTurnSide()) {
        yajl_gen_string(g, (const unsigned char*)  "TurnSide" , 8);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_TurnSide_Name(value.getTurnSide());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTurnSide());
    }
    if (!isSparse || value.hasNextTurnEvent()) {
        yajl_gen_string(g, (const unsigned char*)  "NextTurnEvent" , 13);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_NextTurnEvent_Name(value.getNextTurnEvent());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getNextTurnEvent());
    }
    if (!isSparse || value.hasImage()) {
        yajl_gen_string(g, (const unsigned char*)  "Image" , 5);
        const char *s = value.getImage().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTurnAngle()) {
        yajl_gen_string(g, (const unsigned char*)  "TurnAngle" , 9);
        yajl_gen_integer(g, (long long)value.getTurnAngle());
    }
    if (!isSparse || value.hasTurnNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "TurnNumber" , 10);
        yajl_gen_integer(g, (long long)value.getTurnNumber());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::NavigationNextTurnDataStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NavigationNextTurnDistanceDataStatus"

void serializeJson (const ::midw_smartphoneint_fi::NavigationNextTurnDistanceDataStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasDeviceCategory()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceCategory" , 14);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceCategory_Name(value.getDeviceCategory());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceCategory());
    }
    if (!isSparse || value.hasDistanceInMeters()) {
        yajl_gen_string(g, (const unsigned char*)  "DistanceInMeters" , 16);
        yajl_gen_integer(g, (long long)value.getDistanceInMeters());
    }
    if (!isSparse || value.hasTimeInSec()) {
        yajl_gen_string(g, (const unsigned char*)  "TimeInSec" , 9);
        yajl_gen_integer(g, (long long)value.getTimeInSec());
    }
    if (!isSparse || value.hasDistanceToManeuver()) {
        yajl_gen_string(g, (const unsigned char*)  "DistanceToManeuver" , 18);
        yajl_gen_integer(g, (long long)value.getDistanceToManeuver());
    }
    if (!isSparse || value.hasManeuverDistanceUnits()) {
        yajl_gen_string(g, (const unsigned char*)  "ManeuverDistanceUnits" , 21);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ManeuverDistanceUnits_Name(value.getManeuverDistanceUnits());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getManeuverDistanceUnits());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::NavigationNextTurnDistanceDataStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AAPNotificationEventStatus"

void serializeJson (const ::midw_smartphoneint_fi::AAPNotificationEventStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasDeviceCategory()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceCategory" , 14);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceCategory_Name(value.getDeviceCategory());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceCategory());
    }
    if (!isSparse || value.hasAAPNotificationId()) {
        yajl_gen_string(g, (const unsigned char*)  "AAPNotificationId" , 17);
        const char *s = value.getAAPNotificationId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasNotificationText()) {
        yajl_gen_string(g, (const unsigned char*)  "NotificationText" , 16);
        const char *s = value.getNotificationText().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasNotificationIcon()) {
        yajl_gen_string(g, (const unsigned char*)  "NotificationIcon" , 16);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o7 = value.getNotificationIcon();
        {
            ::std::vector< uint8 >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                yajl_gen_integer(g, (long long)(*o6));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::AAPNotificationEventStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AAPNotificationEventSet"

void serializeJson (const ::midw_smartphoneint_fi::AAPNotificationEventSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAAPNotificationId()) {
        yajl_gen_string(g, (const unsigned char*)  "AAPNotificationId" , 17);
        const char *s = value.getAAPNotificationId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::AAPNotificationEventSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MySPINBluetoothVoiceRecInfoStatus"

void serializeJson (const ::midw_smartphoneint_fi::MySPINBluetoothVoiceRecInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasBTVoiceRecRequest()) {
        yajl_gen_string(g, (const unsigned char*)  "BTVoiceRecRequest" , 17);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_BTVoiceRecRequest_Name(value.getBTVoiceRecRequest());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getBTVoiceRecRequest());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::MySPINBluetoothVoiceRecInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MySPINBluetoothVoiceRecInfoSet"

void serializeJson (const ::midw_smartphoneint_fi::MySPINBluetoothVoiceRecInfoSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasBTVoiceRecReqResponse()) {
        yajl_gen_string(g, (const unsigned char*)  "BTVoiceRecReqResponse" , 21);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_BTVoiceRecRequestResponse_Name(value.getBTVoiceRecReqResponse());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getBTVoiceRecReqResponse());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::MySPINBluetoothVoiceRecInfoSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TechnologySelectionStatus"

void serializeJson (const ::midw_smartphoneint_fi::TechnologySelectionStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasSelectedTechnology()) {
        yajl_gen_string(g, (const unsigned char*)  "SelectedTechnology" , 18);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceCategory_Name(value.getSelectedTechnology());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSelectedTechnology());
    }
    if (!isSparse || value.hasDeviceType()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceType" , 10);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceType_Name(value.getDeviceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::TechnologySelectionStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TechnologySelectionSet"

void serializeJson (const ::midw_smartphoneint_fi::TechnologySelectionSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasSelectedTechnology()) {
        yajl_gen_string(g, (const unsigned char*)  "SelectedTechnology" , 18);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceCategory_Name(value.getSelectedTechnology());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSelectedTechnology());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::TechnologySelectionSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WiFiCredentialsStatus"

void serializeJson (const ::midw_smartphoneint_fi::WiFiCredentialsStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAccessoryWiFiAPCredentials()) {
        yajl_gen_string(g, (const unsigned char*)  "AccessoryWiFiAPCredentials" , 26);
        serializeJson(value.getAccessoryWiFiAPCredentials(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::WiFiCredentialsStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TurnByTurnInfoStatus"

void serializeJson (const ::midw_smartphoneint_fi::TurnByTurnInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasDeviceCategory()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceCategory" , 14);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceCategory_Name(value.getDeviceCategory());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceCategory());
    }
    if (!isSparse || value.hasCarPlayTBTUpdate()) {
        yajl_gen_string(g, (const unsigned char*)  "CarPlayTBTUpdate" , 16);
        serializeJson(value.getCarPlayTBTUpdate(), g, options);
    }
    if (!isSparse || value.hasAAutoTBTUpdate()) {
        yajl_gen_string(g, (const unsigned char*)  "AAutoTBTUpdate" , 14);
        serializeJson(value.getAAutoTBTUpdate(), g, options);
    }
    if (!isSparse || value.hasBDCLTBTUpdate()) {
        yajl_gen_string(g, (const unsigned char*)  "BDCLTBTUpdate" , 13);
        serializeJson(value.getBDCLTBTUpdate(), g, options);
    }
    if (!isSparse || value.hasMLTBTUpdate()) {
        yajl_gen_string(g, (const unsigned char*)  "MLTBTUpdate" , 11);
        serializeJson(value.getMLTBTUpdate(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::TurnByTurnInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ProjectedVideoInfoStatus"

void serializeJson (const ::midw_smartphoneint_fi::ProjectedVideoInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasProjectedVideoAttributes()) {
        yajl_gen_string(g, (const unsigned char*)  "ProjectedVideoAttributes" , 24);
        serializeJson(value.getProjectedVideoAttributes(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::ProjectedVideoInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeviceLockStatusStatus"

void serializeJson (const ::midw_smartphoneint_fi::DeviceLockStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasDeviceCategory()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceCategory" , 14);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceCategory_Name(value.getDeviceCategory());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceCategory());
    }
    if (!isSparse || value.hasBDeviceLockStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "bDeviceLockStatus" , 17);
        yajl_gen_bool(g, (bool)value.getBDeviceLockStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::DeviceLockStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RelativelyActiveMediaAppStatus"

void serializeJson (const ::midw_smartphoneint_fi::RelativelyActiveMediaAppStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMediaAppHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "MediaAppHandle" , 14);
        yajl_gen_integer(g, (long long)value.getMediaAppHandle());
    }
    if (!isSparse || value.hasMediaAppCategory()) {
        yajl_gen_string(g, (const unsigned char*)  "MediaAppCategory" , 16);
        const char* s = ::midw_smartphoneint_fi_types::T_e8Media_AppCategory_Name(value.getMediaAppCategory());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getMediaAppCategory());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::RelativelyActiveMediaAppStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CarplayRouteGuidanceUpdateStatus"

void serializeJson (const ::midw_smartphoneint_fi::CarplayRouteGuidanceUpdateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasDeviceUSBSerialNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceUSBSerialNumber" , 21);
        const char *s = value.getDeviceUSBSerialNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRouteGuidanceUpdate()) {
        yajl_gen_string(g, (const unsigned char*)  "RouteGuidanceUpdate" , 19);
        serializeJson(value.getRouteGuidanceUpdate(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::CarplayRouteGuidanceUpdateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CarplayRouteGuidanceManeuverUpdateStatus"

void serializeJson (const ::midw_smartphoneint_fi::CarplayRouteGuidanceManeuverUpdateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasDeviceUSBSerialNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceUSBSerialNumber" , 21);
        const char *s = value.getDeviceUSBSerialNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRouteGuidanceManeuverUpdate()) {
        yajl_gen_string(g, (const unsigned char*)  "RouteGuidanceManeuverUpdate" , 27);
        serializeJson(value.getRouteGuidanceManeuverUpdate(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::CarplayRouteGuidanceManeuverUpdateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AAutoTurnByTurnInfoStatus"

void serializeJson (const ::midw_smartphoneint_fi::AAutoTurnByTurnInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasAAutoTBTUpdate()) {
        yajl_gen_string(g, (const unsigned char*)  "AAutoTBTUpdate" , 14);
        serializeJson(value.getAAutoTBTUpdate(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::AAutoTurnByTurnInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BDCLTurnByTurnInfoStatus"

void serializeJson (const ::midw_smartphoneint_fi::BDCLTurnByTurnInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasBDCLTBTUpdate()) {
        yajl_gen_string(g, (const unsigned char*)  "BDCLTBTUpdate" , 13);
        serializeJson(value.getBDCLTBTUpdate(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::BDCLTurnByTurnInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MLTurnByTurnInfoStatus"

void serializeJson (const ::midw_smartphoneint_fi::MLTurnByTurnInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasMLTBTUpdate()) {
        yajl_gen_string(g, (const unsigned char*)  "MLTBTUpdate" , 11);
        serializeJson(value.getMLTBTUpdate(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::MLTurnByTurnInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ApplicationPhoneCallDataStatus"

void serializeJson (const ::midw_smartphoneint_fi::ApplicationPhoneCallDataStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasPhoneCallExtendedMetadata()) {
        yajl_gen_string(g, (const unsigned char*)  "PhoneCallExtendedMetadata" , 25);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallExtendedMetadata >& o9 = value.getPhoneCallExtendedMetadata();
        {
            ::std::vector< ::midw_smartphoneint_fi_types::T_ApplicationPhoneCallExtendedMetadata >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                serializeJson((*o8), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::ApplicationPhoneCallDataStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetDeviceInfoListResult"

void serializeJson (const ::midw_smartphoneint_fi::GetDeviceInfoListResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNumDevices()) {
        yajl_gen_string(g, (const unsigned char*)  "NumDevices" , 10);
        yajl_gen_integer(g, (long long)value.getNumDevices());
    }
    if (!isSparse || value.hasDeviceInfoList()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceInfoList" , 14);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_smartphoneint_fi_types::T_DeviceDetails >& o11 = value.getDeviceInfoList();
        {
            ::std::vector< ::midw_smartphoneint_fi_types::T_DeviceDetails >::const_iterator o10;
            for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                serializeJson((*o10), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::GetDeviceInfoListResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SelectDeviceStart"

void serializeJson (const ::midw_smartphoneint_fi::SelectDeviceStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasDeviceConnectionType()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceConnectionType" , 20);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType_Name(value.getDeviceConnectionType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceConnectionType());
    }
    if (!isSparse || value.hasDeviceConnectionReq()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceConnectionReq" , 19);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionReq_Name(value.getDeviceConnectionReq());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceConnectionReq());
    }
    if (!isSparse || value.hasDAPUsage()) {
        yajl_gen_string(g, (const unsigned char*)  "DAPUsage" , 8);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_EnabledInfo_Name(value.getDAPUsage());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDAPUsage());
    }
    if (!isSparse || value.hasCDBUsage()) {
        yajl_gen_string(g, (const unsigned char*)  "CDBUsage" , 8);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_EnabledInfo_Name(value.getCDBUsage());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCDBUsage());
    }
    if (!isSparse || value.hasDeviceCategory()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceCategory" , 14);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceCategory_Name(value.getDeviceCategory());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceCategory());
    }
    if (!isSparse || value.hasSelectionType()) {
        yajl_gen_string(g, (const unsigned char*)  "SelectionType" , 13);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_SelectionType_Name(value.getSelectionType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSelectionType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SelectDeviceStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SelectDeviceResult"

void serializeJson (const ::midw_smartphoneint_fi::SelectDeviceResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasDeviceConnectionType()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceConnectionType" , 20);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType_Name(value.getDeviceConnectionType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceConnectionType());
    }
    if (!isSparse || value.hasDeviceConnectionReq()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceConnectionReq" , 19);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionReq_Name(value.getDeviceConnectionReq());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceConnectionReq());
    }
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    if (!isSparse || value.hasBTPairingRequired()) {
        yajl_gen_string(g, (const unsigned char*)  "BTPairingRequired" , 17);
        yajl_gen_bool(g, (bool)value.getBTPairingRequired());
    }
    if (!isSparse || value.hasDeviceCategory()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceCategory" , 14);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceCategory_Name(value.getDeviceCategory());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceCategory());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SelectDeviceResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LaunchAppStart"

void serializeJson (const ::midw_smartphoneint_fi::LaunchAppStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasDeviceCategory()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceCategory" , 14);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceCategory_Name(value.getDeviceCategory());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceCategory());
    }
    if (!isSparse || value.hasAppHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "AppHandle" , 9);
        yajl_gen_integer(g, (long long)value.getAppHandle());
    }
    if (!isSparse || value.hasDiPOAppType()) {
        yajl_gen_string(g, (const unsigned char*)  "DiPOAppType" , 11);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DiPOAppType_Name(value.getDiPOAppType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDiPOAppType());
    }
    if (!isSparse || value.hasTelephoneNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "TelephoneNumber" , 15);
        const char *s = value.getTelephoneNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasEcnrSetting()) {
        yajl_gen_string(g, (const unsigned char*)  "EcnrSetting" , 11);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_EcnrSetting_Name(value.getEcnrSetting());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEcnrSetting());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::LaunchAppStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LaunchAppResult"

void serializeJson (const ::midw_smartphoneint_fi::LaunchAppResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasAppHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "AppHandle" , 9);
        yajl_gen_integer(g, (long long)value.getAppHandle());
    }
    if (!isSparse || value.hasDiPOAppType()) {
        yajl_gen_string(g, (const unsigned char*)  "DiPOAppType" , 11);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DiPOAppType_Name(value.getDiPOAppType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDiPOAppType());
    }
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::LaunchAppResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TerminateAppStart"

void serializeJson (const ::midw_smartphoneint_fi::TerminateAppStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasAppHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "AppHandle" , 9);
        yajl_gen_integer(g, (long long)value.getAppHandle());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::TerminateAppStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TerminateAppResult"

void serializeJson (const ::midw_smartphoneint_fi::TerminateAppResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasAppHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "AppHandle" , 9);
        yajl_gen_integer(g, (long long)value.getAppHandle());
    }
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::TerminateAppResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetAppListStart"

void serializeJson (const ::midw_smartphoneint_fi::GetAppListStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::GetAppListStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetAppListResult"

void serializeJson (const ::midw_smartphoneint_fi::GetAppListResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasNumAppDetailsList()) {
        yajl_gen_string(g, (const unsigned char*)  "NumAppDetailsList" , 17);
        yajl_gen_integer(g, (long long)value.getNumAppDetailsList());
    }
    if (!isSparse || value.hasAppDetailsList()) {
        yajl_gen_string(g, (const unsigned char*)  "AppDetailsList" , 14);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_smartphoneint_fi_types::T_AppDetails >& o13 = value.getAppDetailsList();
        {
            ::std::vector< ::midw_smartphoneint_fi_types::T_AppDetails >::const_iterator o12;
            for (o12 = o13.begin(); o12 != o13.end(); ++o12) {
                serializeJson((*o12), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::GetAppListResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetAppIconDataStart"

void serializeJson (const ::midw_smartphoneint_fi::GetAppIconDataStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAppIconURL()) {
        yajl_gen_string(g, (const unsigned char*)  "AppIconURL" , 10);
        const char *s = value.getAppIconURL().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::GetAppIconDataStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetAppIconDataResult"

void serializeJson (const ::midw_smartphoneint_fi::GetAppIconDataResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIconMimeType()) {
        yajl_gen_string(g, (const unsigned char*)  "IconMimeType" , 12);
        const char *s = value.getIconMimeType().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasAppIconData()) {
        yajl_gen_string(g, (const unsigned char*)  "AppIconData" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o15 = value.getAppIconData();
        {
            ::std::vector< uint8 >::const_iterator o14;
            for (o14 = o15.begin(); o14 != o15.end(); ++o14) {
                yajl_gen_integer(g, (long long)(*o14));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::GetAppIconDataResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetAppIconAttributesStart"

void serializeJson (const ::midw_smartphoneint_fi::SetAppIconAttributesStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasAppHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "AppHandle" , 9);
        yajl_gen_integer(g, (long long)value.getAppHandle());
    }
    if (!isSparse || value.hasIconAttributes()) {
        yajl_gen_string(g, (const unsigned char*)  "IconAttributes" , 14);
        serializeJson(value.getIconAttributes(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetAppIconAttributesStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetAppIconAttributesResult"

void serializeJson (const ::midw_smartphoneint_fi::SetAppIconAttributesResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetAppIconAttributesResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetDeviceUsagePreferenceStart"

void serializeJson (const ::midw_smartphoneint_fi::SetDeviceUsagePreferenceStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasDeviceCategory()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceCategory" , 14);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceCategory_Name(value.getDeviceCategory());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceCategory());
    }
    if (!isSparse || value.hasEnabledInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "EnabledInfo" , 11);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_EnabledInfo_Name(value.getEnabledInfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnabledInfo());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetDeviceUsagePreferenceStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetDeviceUsagePreferenceResult"

void serializeJson (const ::midw_smartphoneint_fi::SetDeviceUsagePreferenceResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetDeviceUsagePreferenceResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetMLNotificationEnabledInfoStart"

void serializeJson (const ::midw_smartphoneint_fi::SetMLNotificationEnabledInfoStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasNumNotificationEnableList()) {
        yajl_gen_string(g, (const unsigned char*)  "NumNotificationEnableList" , 25);
        yajl_gen_integer(g, (long long)value.getNumNotificationEnableList());
    }
    if (!isSparse || value.hasNotificationEnableList()) {
        yajl_gen_string(g, (const unsigned char*)  "NotificationEnableList" , 22);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_smartphoneint_fi_types::T_NotificationEnable >& o17 = value.getNotificationEnableList();
        {
            ::std::vector< ::midw_smartphoneint_fi_types::T_NotificationEnable >::const_iterator o16;
            for (o16 = o17.begin(); o16 != o17.end(); ++o16) {
                serializeJson((*o16), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetMLNotificationEnabledInfoStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetMLNotificationEnabledInfoResult"

void serializeJson (const ::midw_smartphoneint_fi::SetMLNotificationEnabledInfoResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetMLNotificationEnabledInfoResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InvokeNotificationActionStart"

void serializeJson (const ::midw_smartphoneint_fi::InvokeNotificationActionStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasAppHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "AppHandle" , 9);
        yajl_gen_integer(g, (long long)value.getAppHandle());
    }
    if (!isSparse || value.hasNotificationID()) {
        yajl_gen_string(g, (const unsigned char*)  "NotificationID" , 14);
        yajl_gen_integer(g, (long long)value.getNotificationID());
    }
    if (!isSparse || value.hasNotificationActionID()) {
        yajl_gen_string(g, (const unsigned char*)  "NotificationActionID" , 20);
        yajl_gen_integer(g, (long long)value.getNotificationActionID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::InvokeNotificationActionStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InvokeNotificationActionResult"

void serializeJson (const ::midw_smartphoneint_fi::InvokeNotificationActionResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::InvokeNotificationActionResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetVideoSettingsStart"

void serializeJson (const ::midw_smartphoneint_fi::GetVideoSettingsStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::GetVideoSettingsStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetVideoSettingsResult"

void serializeJson (const ::midw_smartphoneint_fi::GetVideoSettingsResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasVideoAttributes()) {
        yajl_gen_string(g, (const unsigned char*)  "VideoAttributes" , 15);
        serializeJson(value.getVideoAttributes(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::GetVideoSettingsResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetOrientationModeStart"

void serializeJson (const ::midw_smartphoneint_fi::SetOrientationModeStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasOrientationMode()) {
        yajl_gen_string(g, (const unsigned char*)  "OrientationMode" , 15);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_OrientationMode_Name(value.getOrientationMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getOrientationMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetOrientationModeStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetOrientationModeResult"

void serializeJson (const ::midw_smartphoneint_fi::SetOrientationModeResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetOrientationModeResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetScreenSizeStart"

void serializeJson (const ::midw_smartphoneint_fi::SetScreenSizeStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasScreenAttributes()) {
        yajl_gen_string(g, (const unsigned char*)  "ScreenAttributes" , 16);
        serializeJson(value.getScreenAttributes(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetScreenSizeStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetScreenSizeResult"

void serializeJson (const ::midw_smartphoneint_fi::SetScreenSizeResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetScreenSizeResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetVideoBlockingModeStart"

void serializeJson (const ::midw_smartphoneint_fi::SetVideoBlockingModeStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasBlockingMode()) {
        yajl_gen_string(g, (const unsigned char*)  "BlockingMode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_BlockingMode_Name(value.getBlockingMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getBlockingMode());
    }
    if (!isSparse || value.hasVideoBlockingReason()) {
        yajl_gen_string(g, (const unsigned char*)  "VideoBlockingReason" , 19);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_VideoBlockingReason_Name(value.getVideoBlockingReason());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getVideoBlockingReason());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetVideoBlockingModeStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetVideoBlockingModeResult"

void serializeJson (const ::midw_smartphoneint_fi::SetVideoBlockingModeResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetVideoBlockingModeResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetAudioBlockingModeStart"

void serializeJson (const ::midw_smartphoneint_fi::SetAudioBlockingModeStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasGlobalMuteEnable()) {
        yajl_gen_string(g, (const unsigned char*)  "GlobalMuteEnable" , 16);
        yajl_gen_bool(g, (bool)value.getGlobalMuteEnable());
    }
    if (!isSparse || value.hasMediaAudioBlockingEnable()) {
        yajl_gen_string(g, (const unsigned char*)  "MediaAudioBlockingEnable" , 24);
        yajl_gen_bool(g, (bool)value.getMediaAudioBlockingEnable());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetAudioBlockingModeStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetAudioBlockingModeResult"

void serializeJson (const ::midw_smartphoneint_fi::SetAudioBlockingModeResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetAudioBlockingModeResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetVehicleConfigurationStart"

void serializeJson (const ::midw_smartphoneint_fi::SetVehicleConfigurationStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVehicleConfiguration()) {
        yajl_gen_string(g, (const unsigned char*)  "VehicleConfiguration" , 20);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_Vehicle_Configuration_Name(value.getVehicleConfiguration());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getVehicleConfiguration());
    }
    if (!isSparse || value.hasSetConfiguration()) {
        yajl_gen_string(g, (const unsigned char*)  "SetConfiguration" , 16);
        yajl_gen_bool(g, (bool)value.getSetConfiguration());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetVehicleConfigurationStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetVehicleConfigurationResult"

void serializeJson (const ::midw_smartphoneint_fi::SetVehicleConfigurationResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetVehicleConfigurationResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendTouchEventStart"

void serializeJson (const ::midw_smartphoneint_fi::SendTouchEventStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasTouchData()) {
        yajl_gen_string(g, (const unsigned char*)  "TouchData" , 9);
        serializeJson(value.getTouchData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SendTouchEventStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendTouchEventResult"

void serializeJson (const ::midw_smartphoneint_fi::SendTouchEventResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SendTouchEventResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendKeyEventStart"

void serializeJson (const ::midw_smartphoneint_fi::SendKeyEventStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasKeyMode()) {
        yajl_gen_string(g, (const unsigned char*)  "KeyMode" , 7);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_KeyMode_Name(value.getKeyMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getKeyMode());
    }
    if (!isSparse || value.hasKeyCode()) {
        yajl_gen_string(g, (const unsigned char*)  "KeyCode" , 7);
        const char* s = ::midw_smartphoneint_fi_types::T_e32_KeyCode_Name(value.getKeyCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getKeyCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SendKeyEventStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendKeyEventResult"

void serializeJson (const ::midw_smartphoneint_fi::SendKeyEventResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SendKeyEventResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetClientCapabilitiesStart"

void serializeJson (const ::midw_smartphoneint_fi::SetClientCapabilitiesStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientCapabilities()) {
        yajl_gen_string(g, (const unsigned char*)  "ClientCapabilities" , 18);
        serializeJson(value.getClientCapabilities(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetClientCapabilitiesStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetClientCapabilitiesResult"

void serializeJson (const ::midw_smartphoneint_fi::SetClientCapabilitiesResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetClientCapabilitiesResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AccessoryDisplayContextStart"

void serializeJson (const ::midw_smartphoneint_fi::AccessoryDisplayContextStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasDisplayFlag()) {
        yajl_gen_string(g, (const unsigned char*)  "DisplayFlag" , 11);
        yajl_gen_bool(g, (bool)value.getDisplayFlag());
    }
    if (!isSparse || value.hasDisplayContext()) {
        yajl_gen_string(g, (const unsigned char*)  "DisplayContext" , 14);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DisplayContext_Name(value.getDisplayContext());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDisplayContext());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::AccessoryDisplayContextStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AccessoryDisplayContextResult"

void serializeJson (const ::midw_smartphoneint_fi::AccessoryDisplayContextResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::AccessoryDisplayContextResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetDeviceUsagePreferenceStart"

void serializeJson (const ::midw_smartphoneint_fi::GetDeviceUsagePreferenceStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasDeviceCategory()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceCategory" , 14);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceCategory_Name(value.getDeviceCategory());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceCategory());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::GetDeviceUsagePreferenceStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetDeviceUsagePreferenceResult"

void serializeJson (const ::midw_smartphoneint_fi::GetDeviceUsagePreferenceResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasDeviceCategory()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceCategory" , 14);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceCategory_Name(value.getDeviceCategory());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceCategory());
    }
    if (!isSparse || value.hasEnabledInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "EnabledInfo" , 11);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_EnabledInfo_Name(value.getEnabledInfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnabledInfo());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::GetDeviceUsagePreferenceResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetVehicleBTAddressStart"

void serializeJson (const ::midw_smartphoneint_fi::SetVehicleBTAddressStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBTAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "BTAddress" , 9);
        const char *s = value.getBTAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetVehicleBTAddressStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetVehicleBTAddressResult"

void serializeJson (const ::midw_smartphoneint_fi::SetVehicleBTAddressResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetVehicleBTAddressResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InvokeBluetoothDeviceActionStart"

void serializeJson (const ::midw_smartphoneint_fi::InvokeBluetoothDeviceActionStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBluetoothDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "BluetoothDeviceHandle" , 21);
        yajl_gen_integer(g, (long long)value.getBluetoothDeviceHandle());
    }
    if (!isSparse || value.hasProjectionDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "ProjectionDeviceHandle" , 22);
        yajl_gen_integer(g, (long long)value.getProjectionDeviceHandle());
    }
    if (!isSparse || value.hasBTChangeInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "BTChangeInfo" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_BTChangeInfo_Name(value.getBTChangeInfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getBTChangeInfo());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::InvokeBluetoothDeviceActionStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InvokeBluetoothDeviceActionResult"

void serializeJson (const ::midw_smartphoneint_fi::InvokeBluetoothDeviceActionResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::InvokeBluetoothDeviceActionResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AccessoryAudioContextStart"

void serializeJson (const ::midw_smartphoneint_fi::AccessoryAudioContextStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasAudioFlag()) {
        yajl_gen_string(g, (const unsigned char*)  "AudioFlag" , 9);
        yajl_gen_bool(g, (bool)value.getAudioFlag());
    }
    if (!isSparse || value.hasAudioContext()) {
        yajl_gen_string(g, (const unsigned char*)  "AudioContext" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_AudioContext_Name(value.getAudioContext());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAudioContext());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::AccessoryAudioContextStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AccessoryAudioContextResult"

void serializeJson (const ::midw_smartphoneint_fi::AccessoryAudioContextResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::AccessoryAudioContextResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AccessoryAppStateStart"

void serializeJson (const ::midw_smartphoneint_fi::AccessoryAppStateStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAppStateSpeech()) {
        yajl_gen_string(g, (const unsigned char*)  "AppStateSpeech" , 14);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_SpeechAppState_Name(value.getAppStateSpeech());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAppStateSpeech());
    }
    if (!isSparse || value.hasAppStatePhone()) {
        yajl_gen_string(g, (const unsigned char*)  "AppStatePhone" , 13);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_PhoneAppState_Name(value.getAppStatePhone());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAppStatePhone());
    }
    if (!isSparse || value.hasAppStateNavigation()) {
        yajl_gen_string(g, (const unsigned char*)  "AppStateNavigation" , 18);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_NavigationAppState_Name(value.getAppStateNavigation());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAppStateNavigation());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::AccessoryAppStateStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AccessoryAppStateResult"

void serializeJson (const ::midw_smartphoneint_fi::AccessoryAppStateResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::AccessoryAppStateResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetRegionStart"

void serializeJson (const ::midw_smartphoneint_fi::SetRegionStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRegion()) {
        yajl_gen_string(g, (const unsigned char*)  "Region" , 6);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_Region_Name(value.getRegion());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRegion());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetRegionStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetRegionResult"

void serializeJson (const ::midw_smartphoneint_fi::SetRegionResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetRegionResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DiPORoleSwitchRequiredStart"

void serializeJson (const ::midw_smartphoneint_fi::DiPORoleSwitchRequiredStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasUSBSerialNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "USBSerialNumber" , 15);
        const char *s = value.getUSBSerialNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasDeviceCarplayCapability()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceCarplayCapability" , 23);
        yajl_gen_bool(g, (bool)value.getDeviceCarplayCapability());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::DiPORoleSwitchRequiredStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DiPORoleSwitchRequiredResult"

void serializeJson (const ::midw_smartphoneint_fi::DiPORoleSwitchRequiredResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8DeviceTag()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DeviceTag" , 11);
        yajl_gen_integer(g, (long long)value.getU8DeviceTag());
    }
    if (!isSparse || value.hasE8DiPOSwitchReqResponse()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DiPOSwitchReqResponse" , 23);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DiPOSwitchReqResponse_Name(value.getE8DiPOSwitchReqResponse());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DiPOSwitchReqResponse());
    }
    if (!isSparse || value.hasUSBSerialNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "USBSerialNumber" , 15);
        const char *s = value.getUSBSerialNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasREAPAppInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "rEAPAppInfo" , 11);
        serializeJson(value.getREAPAppInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::DiPORoleSwitchRequiredResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetAccessoryDisplayContextStart"

void serializeJson (const ::midw_smartphoneint_fi::SetAccessoryDisplayContextStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasDisplayContextInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "DisplayContextInfo" , 18);
        serializeJson(value.getDisplayContextInfo(), g, options);
    }
    if (!isSparse || value.hasDisplayConstraintInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "DisplayConstraintInfo" , 21);
        serializeJson(value.getDisplayConstraintInfo(), g, options);
    }
    if (!isSparse || value.hasContextResponsibility()) {
        yajl_gen_string(g, (const unsigned char*)  "ContextResponsibility" , 21);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DisplayInfo_Name(value.getContextResponsibility());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getContextResponsibility());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetAccessoryDisplayContextStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetAccessoryDisplayContextResult"

void serializeJson (const ::midw_smartphoneint_fi::SetAccessoryDisplayContextResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetAccessoryDisplayContextResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetKeyIconDataStart"

void serializeJson (const ::midw_smartphoneint_fi::GetKeyIconDataStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasKeyIconURL()) {
        yajl_gen_string(g, (const unsigned char*)  "KeyIconURL" , 10);
        const char *s = value.getKeyIconURL().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::GetKeyIconDataStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetKeyIconDataResult"

void serializeJson (const ::midw_smartphoneint_fi::GetKeyIconDataResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasKeyIconData()) {
        yajl_gen_string(g, (const unsigned char*)  "KeyIconData" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o19 = value.getKeyIconData();
        {
            ::std::vector< uint8 >::const_iterator o18;
            for (o18 = o19.begin(); o18 != o19.end(); ++o18) {
                yajl_gen_integer(g, (long long)(*o18));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::GetKeyIconDataResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetDisplayAttributesStart"

void serializeJson (const ::midw_smartphoneint_fi::SetDisplayAttributesStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDisplayAttributes()) {
        yajl_gen_string(g, (const unsigned char*)  "DisplayAttributes" , 17);
        serializeJson(value.getDisplayAttributes(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetDisplayAttributesStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetDisplayAttributesResult"

void serializeJson (const ::midw_smartphoneint_fi::SetDisplayAttributesResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetDisplayAttributesResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RotaryControllerEventStart"

void serializeJson (const ::midw_smartphoneint_fi::RotaryControllerEventStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasControllerDeltaCounts()) {
        yajl_gen_string(g, (const unsigned char*)  "ControllerDeltaCounts" , 21);
        yajl_gen_integer(g, (long long)value.getControllerDeltaCounts());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::RotaryControllerEventStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RotaryControllerEventResult"

void serializeJson (const ::midw_smartphoneint_fi::RotaryControllerEventResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::RotaryControllerEventResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetAccessoryAudioContextStart"

void serializeJson (const ::midw_smartphoneint_fi::SetAccessoryAudioContextStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasAudioContextInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "AudioContextInfo" , 16);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_smartphoneint_fi_types::T_AccessoryAudioContext >& o21 = value.getAudioContextInfo();
        {
            ::std::vector< ::midw_smartphoneint_fi_types::T_AccessoryAudioContext >::const_iterator o20;
            for (o20 = o21.begin(); o20 != o21.end(); ++o20) {
                serializeJson((*o20), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetAccessoryAudioContextStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetAccessoryAudioContextResult"

void serializeJson (const ::midw_smartphoneint_fi::SetAccessoryAudioContextResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetAccessoryAudioContextResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetVehicleMovementStateStart"

void serializeJson (const ::midw_smartphoneint_fi::SetVehicleMovementStateStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasParkBrakeInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "ParkBrakeInfo" , 13);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ParkBrake_Name(value.getParkBrakeInfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getParkBrakeInfo());
    }
    if (!isSparse || value.hasGearInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "GearInfo" , 8);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_GearState_Name(value.getGearInfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getGearInfo());
    }
    if (!isSparse || value.hasVehicleState()) {
        yajl_gen_string(g, (const unsigned char*)  "VehicleState" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_VehicleState_Name(value.getVehicleState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getVehicleState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetVehicleMovementStateStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetVehicleMovementStateResult"

void serializeJson (const ::midw_smartphoneint_fi::SetVehicleMovementStateResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetVehicleMovementStateResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetFeatureRestrictionsStart"

void serializeJson (const ::midw_smartphoneint_fi::SetFeatureRestrictionsStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceCategory()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceCategory" , 14);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceCategory_Name(value.getDeviceCategory());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceCategory());
    }
    if (!isSparse || value.hasParkModeRestrictionInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "ParkModeRestrictionInfo" , 23);
        serializeJson(value.getParkModeRestrictionInfo(), g, options);
    }
    if (!isSparse || value.hasDriveModeRestrictionInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "DriveModeRestrictionInfo" , 24);
        serializeJson(value.getDriveModeRestrictionInfo(), g, options);
    }
    if (!isSparse || value.hasGeneralRestrictionInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "GeneralRestrictionInfo" , 22);
        yajl_gen_integer(g, (long long)value.getGeneralRestrictionInfo());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetFeatureRestrictionsStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetFeatureRestrictionsResult"

void serializeJson (const ::midw_smartphoneint_fi::SetFeatureRestrictionsResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetFeatureRestrictionsResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VehicleMechanicalSpeedStart"

void serializeJson (const ::midw_smartphoneint_fi::VehicleMechanicalSpeedStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVehicleSpeed()) {
        yajl_gen_string(g, (const unsigned char*)  "VehicleSpeed" , 12);
        yajl_gen_integer(g, (long long)value.getVehicleSpeed());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::VehicleMechanicalSpeedStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VehicleMechanicalSpeedResult"

void serializeJson (const ::midw_smartphoneint_fi::VehicleMechanicalSpeedResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::VehicleMechanicalSpeedResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetVehicleManufacturerInformationStart"

void serializeJson (const ::midw_smartphoneint_fi::SetVehicleManufacturerInformationStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVehicleMake()) {
        yajl_gen_string(g, (const unsigned char*)  "VehicleMake" , 11);
        const char *s = value.getVehicleMake().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasVehicleModel()) {
        yajl_gen_string(g, (const unsigned char*)  "VehicleModel" , 12);
        const char *s = value.getVehicleModel().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasVehicleModelYear()) {
        yajl_gen_string(g, (const unsigned char*)  "VehicleModelYear" , 16);
        const char *s = value.getVehicleModelYear().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasVehicleHUSwVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "VehicleHUSwVersion" , 18);
        const char *s = value.getVehicleHUSwVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasVehicleHUHwVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "VehicleHUHwVersion" , 18);
        const char *s = value.getVehicleHUHwVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasVehicleHUMake()) {
        yajl_gen_string(g, (const unsigned char*)  "VehicleHUMake" , 13);
        const char *s = value.getVehicleHUMake().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasVehicleHUModel()) {
        yajl_gen_string(g, (const unsigned char*)  "VehicleHUModel" , 14);
        const char *s = value.getVehicleHUModel().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasVehicleHUSwBuild()) {
        yajl_gen_string(g, (const unsigned char*)  "VehicleHUSwBuild" , 16);
        const char *s = value.getVehicleHUSwBuild().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasDriverSideInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "DriverSideInfo" , 14);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_Vehicle_Configuration_Name(value.getDriverSideInfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDriverSideInfo());
    }
    if (!isSparse || value.hasIsNativeNavSupported()) {
        yajl_gen_string(g, (const unsigned char*)  "isNativeNavSupported" , 20);
        yajl_gen_bool(g, (bool)value.getIsNativeNavSupported());
    }
    if (!isSparse || value.hasOEMICONDetails()) {
        yajl_gen_string(g, (const unsigned char*)  "OEMICONDetails" , 14);
        serializeJson(value.getOEMICONDetails(), g, options);
    }
    if (!isSparse || value.hasIsRotaryCtrlSupported()) {
        yajl_gen_string(g, (const unsigned char*)  "isRotaryCtrlSupported" , 21);
        yajl_gen_bool(g, (bool)value.getIsRotaryCtrlSupported());
    }
    if (!isSparse || value.hasFidelityType()) {
        yajl_gen_string(g, (const unsigned char*)  "FidelityType" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_FidelityType_Name(value.getFidelityType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getFidelityType());
    }
    if (!isSparse || value.hasSupportedSPITechnologiesInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "SupportedSPITechnologiesInfo" , 28);
        yajl_gen_integer(g, (long long)value.getSupportedSPITechnologiesInfo());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetVehicleManufacturerInformationStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetVehicleManufacturerInformationResult"

void serializeJson (const ::midw_smartphoneint_fi::SetVehicleManufacturerInformationResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetVehicleManufacturerInformationResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetEnvironmentDataStart"

void serializeJson (const ::midw_smartphoneint_fi::SetEnvironmentDataStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOutsideTemperature()) {
        yajl_gen_string(g, (const unsigned char*)  "OutsideTemperature" , 18);
        yajl_gen_double(g, (double)value.getOutsideTemperature());
    }
    if (!isSparse || value.hasValidTemperature()) {
        yajl_gen_string(g, (const unsigned char*)  "ValidTemperature" , 16);
        yajl_gen_bool(g, (bool)value.getValidTemperature());
    }
    if (!isSparse || value.hasBarometricPressure()) {
        yajl_gen_string(g, (const unsigned char*)  "BarometricPressure" , 18);
        yajl_gen_double(g, (double)value.getBarometricPressure());
    }
    if (!isSparse || value.hasValidPressure()) {
        yajl_gen_string(g, (const unsigned char*)  "ValidPressure" , 13);
        yajl_gen_bool(g, (bool)value.getValidPressure());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetEnvironmentDataStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetEnvironmentDataResult"

void serializeJson (const ::midw_smartphoneint_fi::SetEnvironmentDataResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetEnvironmentDataResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetMediaObjectAlbumArtStart"

void serializeJson (const ::midw_smartphoneint_fi::GetMediaObjectAlbumArtStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasSAlbumArt()) {
        yajl_gen_string(g, (const unsigned char*)  "sAlbumArt" , 9);
        const char *s = value.getSAlbumArt().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::GetMediaObjectAlbumArtStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetMediaObjectAlbumArtResult"

void serializeJson (const ::midw_smartphoneint_fi::GetMediaObjectAlbumArtResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOImageData()) {
        yajl_gen_string(g, (const unsigned char*)  "oImageData" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o23 = value.getOImageData();
        {
            ::std::vector< uint8 >::const_iterator o22;
            for (o22 = o23.begin(); o22 != o23.end(); ++o22) {
                yajl_gen_integer(g, (long long)(*o22));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::GetMediaObjectAlbumArtResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetTechnologyPreferenceStart"

void serializeJson (const ::midw_smartphoneint_fi::SetTechnologyPreferenceStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasNumofPreferences()) {
        yajl_gen_string(g, (const unsigned char*)  "NumofPreferences" , 16);
        yajl_gen_integer(g, (long long)value.getNumofPreferences());
    }
    if (!isSparse || value.hasPreferenceOrderList()) {
        yajl_gen_string(g, (const unsigned char*)  "PreferenceOrderList" , 19);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_smartphoneint_fi_types::T_e8_DeviceCategory >& o25 = value.getPreferenceOrderList();
        {
            ::std::vector< ::midw_smartphoneint_fi_types::T_e8_DeviceCategory >::const_iterator o24;
            for (o24 = o25.begin(); o24 != o25.end(); ++o24) {
                const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceCategory_Name((*o24));
                if (s != NULL)
                    yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
                else
                    yajl_gen_integer(g, (long long)(*o24));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasDeviceType()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceType" , 10);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceType_Name(value.getDeviceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetTechnologyPreferenceStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetTechnologyPreferenceResult"

void serializeJson (const ::midw_smartphoneint_fi::SetTechnologyPreferenceResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetTechnologyPreferenceResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetTechnologyPreferenceStart"

void serializeJson (const ::midw_smartphoneint_fi::GetTechnologyPreferenceStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    if (!isSparse || value.hasDeviceType()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceType" , 10);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceType_Name(value.getDeviceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::GetTechnologyPreferenceStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetTechnologyPreferenceResult"

void serializeJson (const ::midw_smartphoneint_fi::GetTechnologyPreferenceResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNumofPreferences()) {
        yajl_gen_string(g, (const unsigned char*)  "NumofPreferences" , 16);
        yajl_gen_integer(g, (long long)value.getNumofPreferences());
    }
    if (!isSparse || value.hasPreferenceOrderList()) {
        yajl_gen_string(g, (const unsigned char*)  "PreferenceOrderList" , 19);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_smartphoneint_fi_types::T_e8_DeviceCategory >& o27 = value.getPreferenceOrderList();
        {
            ::std::vector< ::midw_smartphoneint_fi_types::T_e8_DeviceCategory >::const_iterator o26;
            for (o26 = o27.begin(); o26 != o27.end(); ++o26) {
                const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceCategory_Name((*o26));
                if (s != NULL)
                    yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
                else
                    yajl_gen_integer(g, (long long)(*o26));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::GetTechnologyPreferenceResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetDeviceSelectionModeStart"

void serializeJson (const ::midw_smartphoneint_fi::SetDeviceSelectionModeStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceSelectionMode()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceSelectionMode" , 19);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceSelectionMode_Name(value.getDeviceSelectionMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceSelectionMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetDeviceSelectionModeStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetDeviceSelectionModeResult"

void serializeJson (const ::midw_smartphoneint_fi::SetDeviceSelectionModeResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetDeviceSelectionModeResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetSPIVersionInfoResult"

void serializeJson (const ::midw_smartphoneint_fi::GetSPIVersionInfoResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSPIVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "SPIVersion" , 10);
        const char *s = value.getSPIVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::GetSPIVersionInfoResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InitiateWirelessDiscoveryStart"

void serializeJson (const ::midw_smartphoneint_fi::InitiateWirelessDiscoveryStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBTMACAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "BTMACAddress" , 12);
        const char *s = value.getBTMACAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTechnology()) {
        yajl_gen_string(g, (const unsigned char*)  "Technology" , 10);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_DeviceCategory_Name(value.getTechnology());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTechnology());
    }
    if (!isSparse || value.hasIsKnownDevice()) {
        yajl_gen_string(g, (const unsigned char*)  "isKnownDevice" , 13);
        yajl_gen_bool(g, (bool)value.getIsKnownDevice());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::InitiateWirelessDiscoveryStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InitiateWirelessDiscoveryResult"

void serializeJson (const ::midw_smartphoneint_fi::InitiateWirelessDiscoveryResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::InitiateWirelessDiscoveryResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteDeviceStart"

void serializeJson (const ::midw_smartphoneint_fi::DeleteDeviceStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceList()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceList" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< uint32 >& o29 = value.getDeviceList();
        {
            ::std::vector< uint32 >::const_iterator o28;
            for (o28 = o29.begin(); o28 != o29.end(); ++o28) {
                yajl_gen_integer(g, (long long)(*o28));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::DeleteDeviceStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteDeviceResult"

void serializeJson (const ::midw_smartphoneint_fi::DeleteDeviceResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceList()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceList" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< uint32 >& o31 = value.getDeviceList();
        {
            ::std::vector< uint32 >::const_iterator o30;
            for (o30 = o31.begin(); o30 != o31.end(); ++o30) {
                yajl_gen_integer(g, (long long)(*o30));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::DeleteDeviceResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetWiFiCredentialsStart"

void serializeJson (const ::midw_smartphoneint_fi::GetWiFiCredentialsStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBTMACAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "BTMACAddress" , 12);
        const char *s = value.getBTMACAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::GetWiFiCredentialsStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetWiFiCredentialsResult"

void serializeJson (const ::midw_smartphoneint_fi::GetWiFiCredentialsResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBTMACAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "BTMACAddress" , 12);
        const char *s = value.getBTMACAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    if (!isSparse || value.hasAccessoryWiFiAPCredentials()) {
        yajl_gen_string(g, (const unsigned char*)  "AccessoryWiFiAPCredentials" , 26);
        serializeJson(value.getAccessoryWiFiAPCredentials(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::GetWiFiCredentialsResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetETCStatusStart"

void serializeJson (const ::midw_smartphoneint_fi::SetETCStatusStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasETCStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "ETCStatus" , 9);
        yajl_gen_bool(g, (bool)value.getETCStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetETCStatusStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetETCStatusResult"

void serializeJson (const ::midw_smartphoneint_fi::SetETCStatusResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetETCStatusResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DistanceToEmptyTankStart"

void serializeJson (const ::midw_smartphoneint_fi::DistanceToEmptyTankStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDistanceToEmptyTank()) {
        yajl_gen_string(g, (const unsigned char*)  "DistanceToEmptyTank" , 19);
        yajl_gen_integer(g, (long long)value.getDistanceToEmptyTank());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::DistanceToEmptyTankStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DistanceToEmptyTankResult"

void serializeJson (const ::midw_smartphoneint_fi::DistanceToEmptyTankResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::DistanceToEmptyTankResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendLanguageSettingStart"

void serializeJson (const ::midw_smartphoneint_fi::SendLanguageSettingStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLanguageSetting()) {
        yajl_gen_string(g, (const unsigned char*)  "LanguageSetting" , 15);
        const char* s = ::midw_smartphoneint_fi_types::T_e32_Language_Name(value.getLanguageSetting());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getLanguageSetting());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SendLanguageSettingStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendLanguageSettingResult"

void serializeJson (const ::midw_smartphoneint_fi::SendLanguageSettingResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SendLanguageSettingResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendVehiclePowerModeStateStart"

void serializeJson (const ::midw_smartphoneint_fi::SendVehiclePowerModeStateStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVehiclePowerModeState()) {
        yajl_gen_string(g, (const unsigned char*)  "VehiclePowerModeState" , 21);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_VehiclePowerModeState_Name(value.getVehiclePowerModeState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getVehiclePowerModeState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SendVehiclePowerModeStateStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendVehiclePowerModeStateResult"

void serializeJson (const ::midw_smartphoneint_fi::SendVehiclePowerModeStateResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SendVehiclePowerModeStateResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendAmbientColourStart"

void serializeJson (const ::midw_smartphoneint_fi::SendAmbientColourStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAmbientColourData()) {
        yajl_gen_string(g, (const unsigned char*)  "AmbientColourData" , 17);
        serializeJson(value.getAmbientColourData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SendAmbientColourStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendAmbientColourResult"

void serializeJson (const ::midw_smartphoneint_fi::SendAmbientColourResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ErrorType_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SendAmbientColourResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RegisterRouteGuidanceDisplayConfigurationStart"

void serializeJson (const ::midw_smartphoneint_fi::RegisterRouteGuidanceDisplayConfigurationStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRouteGuidanceDisplayComponents()) {
        yajl_gen_string(g, (const unsigned char*)  "RouteGuidanceDisplayComponents" , 30);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_smartphoneint_fi_types::T_RouteGuidanceDisplayComponent >& o33 = value.getRouteGuidanceDisplayComponents();
        {
            ::std::vector< ::midw_smartphoneint_fi_types::T_RouteGuidanceDisplayComponent >::const_iterator o32;
            for (o32 = o33.begin(); o32 != o33.end(); ++o32) {
                serializeJson((*o32), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::RegisterRouteGuidanceDisplayConfigurationStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RegisterRouteGuidanceDisplayConfigurationResult"

void serializeJson (const ::midw_smartphoneint_fi::RegisterRouteGuidanceDisplayConfigurationResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::RegisterRouteGuidanceDisplayConfigurationResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartRouteGuidanceUpdatesStart"

void serializeJson (const ::midw_smartphoneint_fi::StartRouteGuidanceUpdatesStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRoutGuidanceComponentID()) {
        yajl_gen_string(g, (const unsigned char*)  "RoutGuidanceComponentID" , 23);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_smartphoneint_fi_types::T_e8_ComponentID >& o35 = value.getRoutGuidanceComponentID();
        {
            ::std::vector< ::midw_smartphoneint_fi_types::T_e8_ComponentID >::const_iterator o34;
            for (o34 = o35.begin(); o34 != o35.end(); ++o34) {
                const char* s = ::midw_smartphoneint_fi_types::T_e8_ComponentID_Name((*o34));
                if (s != NULL)
                    yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
                else
                    yajl_gen_integer(g, (long long)(*o34));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasSourceName()) {
        yajl_gen_string(g, (const unsigned char*)  "SourceName" , 10);
        yajl_gen_bool(g, (bool)value.getSourceName());
    }
    if (!isSparse || value.hasSourceSupportsRouteGuidance()) {
        yajl_gen_string(g, (const unsigned char*)  "SourceSupportsRouteGuidance" , 27);
        yajl_gen_bool(g, (bool)value.getSourceSupportsRouteGuidance());
    }
    if (!isSparse || value.hasNeedAutoStartStopTBTUpdates()) {
        yajl_gen_string(g, (const unsigned char*)  "NeedAutoStartStopTBTUpdates" , 27);
        yajl_gen_bool(g, (bool)value.getNeedAutoStartStopTBTUpdates());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::StartRouteGuidanceUpdatesStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartRouteGuidanceUpdatesResult"

void serializeJson (const ::midw_smartphoneint_fi::StartRouteGuidanceUpdatesResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::StartRouteGuidanceUpdatesResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StopRouteGuidanceUpdatesStart"

void serializeJson (const ::midw_smartphoneint_fi::StopRouteGuidanceUpdatesStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRoutGuidanceComponentID()) {
        yajl_gen_string(g, (const unsigned char*)  "RoutGuidanceComponentID" , 23);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_smartphoneint_fi_types::T_e8_ComponentID >& o37 = value.getRoutGuidanceComponentID();
        {
            ::std::vector< ::midw_smartphoneint_fi_types::T_e8_ComponentID >::const_iterator o36;
            for (o36 = o37.begin(); o36 != o37.end(); ++o36) {
                const char* s = ::midw_smartphoneint_fi_types::T_e8_ComponentID_Name((*o36));
                if (s != NULL)
                    yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
                else
                    yajl_gen_integer(g, (long long)(*o36));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::StopRouteGuidanceUpdatesStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StopRouteGuidanceUpdatesResult"

void serializeJson (const ::midw_smartphoneint_fi::StopRouteGuidanceUpdatesResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::StopRouteGuidanceUpdatesResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetDeviceListStart"

void serializeJson (const ::midw_smartphoneint_fi::GetDeviceListStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceHandle" , 12);
        yajl_gen_integer(g, (long long)value.getDeviceHandle());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::GetDeviceListStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetDeviceListResult"

void serializeJson (const ::midw_smartphoneint_fi::GetDeviceListResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNumDevices()) {
        yajl_gen_string(g, (const unsigned char*)  "NumDevices" , 10);
        yajl_gen_integer(g, (long long)value.getNumDevices());
    }
    if (!isSparse || value.hasDeviceInfoList()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceInfoList" , 14);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_smartphoneint_fi_types::T_DeviceDetails >& o39 = value.getDeviceInfoList();
        {
            ::std::vector< ::midw_smartphoneint_fi_types::T_DeviceDetails >::const_iterator o38;
            for (o38 = o39.begin(); o38 != o39.end(); ++o38) {
                serializeJson((*o38), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::GetDeviceListResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetClientStateStart"

void serializeJson (const ::midw_smartphoneint_fi::SetClientStateStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClientState()) {
        yajl_gen_string(g, (const unsigned char*)  "ClientState" , 11);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ClientState_Name(value.getClientState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getClientState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetClientStateStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetClientStateResult"

void serializeJson (const ::midw_smartphoneint_fi::SetClientStateResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::SetClientStateResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RegisterKeyCodesStart"

void serializeJson (const ::midw_smartphoneint_fi::RegisterKeyCodesStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSupportedKeys()) {
        yajl_gen_string(g, (const unsigned char*)  "SupportedKeys" , 13);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_smartphoneint_fi_types::T_TechnologyKeyConfig >& o41 = value.getSupportedKeys();
        {
            ::std::vector< ::midw_smartphoneint_fi_types::T_TechnologyKeyConfig >::const_iterator o40;
            for (o40 = o41.begin(); o40 != o41.end(); ++o40) {
                serializeJson((*o40), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::RegisterKeyCodesStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RegisterKeyCodesResult"

void serializeJson (const ::midw_smartphoneint_fi::RegisterKeyCodesResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponseCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ResponseCode" , 12);
        const char* s = ::midw_smartphoneint_fi_types::T_e8_ResponseCode_Name(value.getResponseCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResponseCode());
    }
    if (!isSparse || value.hasUnSupportedKeys()) {
        yajl_gen_string(g, (const unsigned char*)  "UnSupportedKeys" , 15);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_smartphoneint_fi_types::T_TechnologyKeyConfig >& o43 = value.getUnSupportedKeys();
        {
            ::std::vector< ::midw_smartphoneint_fi_types::T_TechnologyKeyConfig >::const_iterator o42;
            for (o42 = o43.begin(); o42 != o43.end(); ++o42) {
                serializeJson((*o42), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_smartphoneint_fi::RegisterKeyCodesResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::DeviceStatusInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::AppStatusInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::DAPStatusInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::NotificationInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::ApplicationMediaMetaDataStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::DeviceDisplayContextStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::ApplicationPhoneDataStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::BluetoothDeviceStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::DeviceAudioContextStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::DiPOAppStatusInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SessionStatusInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::BTPairingRequiredStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::MLServerKeyCapabilitiesStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::DialStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::DialSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::MediaPlayBackTimeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::ProjectionDeviceAuthorizationStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::ProjectionDeviceAuthorizationSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::NavigationStatusInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::NavigationNextTurnDataStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::NavigationNextTurnDistanceDataStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::AAPNotificationEventStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::AAPNotificationEventSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::MySPINBluetoothVoiceRecInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::MySPINBluetoothVoiceRecInfoSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::TechnologySelectionStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::TechnologySelectionSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::WiFiCredentialsStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::TurnByTurnInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::ProjectedVideoInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::DeviceLockStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::RelativelyActiveMediaAppStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::CarplayRouteGuidanceUpdateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::CarplayRouteGuidanceManeuverUpdateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::AAutoTurnByTurnInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::BDCLTurnByTurnInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::MLTurnByTurnInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::ApplicationPhoneCallDataStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::GetDeviceInfoListResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SelectDeviceStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SelectDeviceResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::LaunchAppStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::LaunchAppResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::TerminateAppStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::TerminateAppResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::GetAppListStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::GetAppListResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::GetAppIconDataStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::GetAppIconDataResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetAppIconAttributesStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetAppIconAttributesResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetDeviceUsagePreferenceStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetDeviceUsagePreferenceResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetMLNotificationEnabledInfoStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetMLNotificationEnabledInfoResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::InvokeNotificationActionStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::InvokeNotificationActionResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::GetVideoSettingsStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::GetVideoSettingsResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetOrientationModeStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetOrientationModeResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetScreenSizeStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetScreenSizeResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetVideoBlockingModeStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetVideoBlockingModeResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetAudioBlockingModeStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetAudioBlockingModeResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetVehicleConfigurationStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetVehicleConfigurationResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SendTouchEventStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SendTouchEventResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SendKeyEventStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SendKeyEventResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetClientCapabilitiesStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetClientCapabilitiesResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::AccessoryDisplayContextStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::AccessoryDisplayContextResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::GetDeviceUsagePreferenceStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::GetDeviceUsagePreferenceResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetVehicleBTAddressStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetVehicleBTAddressResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::InvokeBluetoothDeviceActionStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::InvokeBluetoothDeviceActionResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::AccessoryAudioContextStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::AccessoryAudioContextResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::AccessoryAppStateStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::AccessoryAppStateResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetRegionStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetRegionResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::DiPORoleSwitchRequiredStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::DiPORoleSwitchRequiredResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetAccessoryDisplayContextStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetAccessoryDisplayContextResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::GetKeyIconDataStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::GetKeyIconDataResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetDisplayAttributesStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetDisplayAttributesResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::RotaryControllerEventStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::RotaryControllerEventResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetAccessoryAudioContextStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetAccessoryAudioContextResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetVehicleMovementStateStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetVehicleMovementStateResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetFeatureRestrictionsStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetFeatureRestrictionsResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::VehicleMechanicalSpeedStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::VehicleMechanicalSpeedResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetVehicleManufacturerInformationStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetVehicleManufacturerInformationResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetEnvironmentDataStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetEnvironmentDataResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::GetMediaObjectAlbumArtStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::GetMediaObjectAlbumArtResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetTechnologyPreferenceStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetTechnologyPreferenceResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::GetTechnologyPreferenceStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::GetTechnologyPreferenceResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetDeviceSelectionModeStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetDeviceSelectionModeResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::GetSPIVersionInfoResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::InitiateWirelessDiscoveryStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::InitiateWirelessDiscoveryResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::DeleteDeviceStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::DeleteDeviceResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::GetWiFiCredentialsStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::GetWiFiCredentialsResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetETCStatusStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetETCStatusResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::DistanceToEmptyTankStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::DistanceToEmptyTankResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SendLanguageSettingStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SendLanguageSettingResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SendVehiclePowerModeStateStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SendVehiclePowerModeStateResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SendAmbientColourStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SendAmbientColourResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::RegisterRouteGuidanceDisplayConfigurationStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::RegisterRouteGuidanceDisplayConfigurationResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::StartRouteGuidanceUpdatesStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::StartRouteGuidanceUpdatesResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::StopRouteGuidanceUpdatesStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::StopRouteGuidanceUpdatesResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::GetDeviceListStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::GetDeviceListResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetClientStateStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::SetClientStateResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::RegisterKeyCodesStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi
using namespace ::asf::stream::json;

namespace midw_smartphoneint_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_smartphoneint_fi::RegisterKeyCodesResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_smartphoneint_fi

