/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "midw_ext_dabtuner_fi_types.h"
#include "midw_ext_dabtuner_fi_typesConst.h"
#include "midw_ext_dabtuner_fi_typesJson.h"
#include "midw_ext_dabtuner_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "T_DAB_Label"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_Label& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "sLabel" , 6);
        const char *s = value.getSLabel().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSLabelShort()) {
        yajl_gen_string(g, (const unsigned char*)  "sLabelShort" , 11);
        const char *s = value.getSLabelShort().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU16LabelMask()) {
        yajl_gen_string(g, (const unsigned char*)  "u16LabelMask" , 12);
        yajl_gen_integer(g, (long long)value.getU16LabelMask());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_Label& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_DAB_MTC_SetMode"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_b8_DAB_MTC_SetMode& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getDAB_SERVICELINKING_FM()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_SERVICELINKING_FM" , 21);
        yajl_gen_bool(g, (bool)value.getDAB_SERVICELINKING_FM());
    }
    if (value.getFM_SERVICELINKING_DAB()) {
        yajl_gen_string(g, (const unsigned char*)  "FM_SERVICELINKING_DAB" , 21);
        yajl_gen_bool(g, (bool)value.getFM_SERVICELINKING_DAB());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_b8_DAB_MTC_SetMode& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b16_DAB_AnnouncementType"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_b16_DAB_AnnouncementType& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getDAB_ANNOTYPE_ALARM()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_ANNOTYPE_ALARM" , 18);
        yajl_gen_bool(g, (bool)value.getDAB_ANNOTYPE_ALARM());
    }
    if (value.getDAB_ANNOTYPE_TA()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_ANNOTYPE_TA" , 15);
        yajl_gen_bool(g, (bool)value.getDAB_ANNOTYPE_TA());
    }
    if (value.getDAB_ANNOTYPE_TRANSPORT()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_ANNOTYPE_TRANSPORT" , 22);
        yajl_gen_bool(g, (bool)value.getDAB_ANNOTYPE_TRANSPORT());
    }
    if (value.getDAB_ANNOTYPE_WARNING()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_ANNOTYPE_WARNING" , 20);
        yajl_gen_bool(g, (bool)value.getDAB_ANNOTYPE_WARNING());
    }
    if (value.getDAB_ANNOTYPE_NEWS()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_ANNOTYPE_NEWS" , 17);
        yajl_gen_bool(g, (bool)value.getDAB_ANNOTYPE_NEWS());
    }
    if (value.getDAB_ANNOTYPE_WEATHER()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_ANNOTYPE_WEATHER" , 20);
        yajl_gen_bool(g, (bool)value.getDAB_ANNOTYPE_WEATHER());
    }
    if (value.getDAB_ANNOTYPE_EVENT()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_ANNOTYPE_EVENT" , 18);
        yajl_gen_bool(g, (bool)value.getDAB_ANNOTYPE_EVENT());
    }
    if (value.getDAB_ANNOTYPE_SPECIALEVENT()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_ANNOTYPE_SPECIALEVENT" , 25);
        yajl_gen_bool(g, (bool)value.getDAB_ANNOTYPE_SPECIALEVENT());
    }
    if (value.getDAB_ANNOTYPE_PROGRAMME()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_ANNOTYPE_PROGRAMME" , 22);
        yajl_gen_bool(g, (bool)value.getDAB_ANNOTYPE_PROGRAMME());
    }
    if (value.getDAB_ANNOTYPE_SPORTS()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_ANNOTYPE_SPORTS" , 19);
        yajl_gen_bool(g, (bool)value.getDAB_ANNOTYPE_SPORTS());
    }
    if (value.getDAB_ANNOTYPE_FINANCE()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_ANNOTYPE_FINANCE" , 20);
        yajl_gen_bool(g, (bool)value.getDAB_ANNOTYPE_FINANCE());
    }
    if (value.getDAB_ANNOTYPE_b11_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_ANNOTYPE_b11_reserved" , 25);
        yajl_gen_bool(g, (bool)value.getDAB_ANNOTYPE_b11_reserved());
    }
    if (value.getDAB_ANNOTYPE_b12_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_ANNOTYPE_b12_reserved" , 25);
        yajl_gen_bool(g, (bool)value.getDAB_ANNOTYPE_b12_reserved());
    }
    if (value.getDAB_ANNOTYPE_b13_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_ANNOTYPE_b13_reserved" , 25);
        yajl_gen_bool(g, (bool)value.getDAB_ANNOTYPE_b13_reserved());
    }
    if (value.getDAB_ANNOTYPE_b14_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_ANNOTYPE_b14_reserved" , 25);
        yajl_gen_bool(g, (bool)value.getDAB_ANNOTYPE_b14_reserved());
    }
    if (value.getDAB_ANNOTYPE_b15_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_ANNOTYPE_b15_reserved" , 25);
        yajl_gen_bool(g, (bool)value.getDAB_ANNOTYPE_b15_reserved());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_b16_DAB_AnnouncementType& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_Frequency"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_Frequency& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32Frequency()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Frequency" , 12);
        yajl_gen_integer(g, (long long)value.getU32Frequency());
    }
    if (!isSparse || value.hasSFreqLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "sFreqLabel" , 10);
        const char *s = value.getSFreqLabel().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_Frequency& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b16_DAB_TunerStatusFlags"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_b16_DAB_TunerStatusFlags& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getDAB_TUNERSTATUSFLAGS_SYNC()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TUNERSTATUSFLAGS_SYNC" , 25);
        yajl_gen_bool(g, (bool)value.getDAB_TUNERSTATUSFLAGS_SYNC());
    }
    if (value.getDAB_TUNERSTATUSFLAGS_ENS_VALID()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TUNERSTATUSFLAGS_ENS_VALID" , 30);
        yajl_gen_bool(g, (bool)value.getDAB_TUNERSTATUSFLAGS_ENS_VALID());
    }
    if (value.getDAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID" , 40);
        yajl_gen_bool(g, (bool)value.getDAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID());
    }
    if (value.getDAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID" , 39);
        yajl_gen_bool(g, (bool)value.getDAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID());
    }
    if (value.getDAB_TUNERSTATUSFLAGS_MUTE()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TUNERSTATUSFLAGS_MUTE" , 25);
        yajl_gen_bool(g, (bool)value.getDAB_TUNERSTATUSFLAGS_MUTE());
    }
    if (value.getDAB_TUNERSTATUSFLAGS_TUNING()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TUNERSTATUSFLAGS_TUNING" , 27);
        yajl_gen_bool(g, (bool)value.getDAB_TUNERSTATUSFLAGS_TUNING());
    }
    if (value.getDAB_TUNERSTATUSFLAGS_b6_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TUNERSTATUSFLAGS_b6_reserved" , 32);
        yajl_gen_bool(g, (bool)value.getDAB_TUNERSTATUSFLAGS_b6_reserved());
    }
    if (value.getDAB_TUNERSTATUSFLAGS_b7_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TUNERSTATUSFLAGS_b7_reserved" , 32);
        yajl_gen_bool(g, (bool)value.getDAB_TUNERSTATUSFLAGS_b7_reserved());
    }
    if (value.getDAB_TUNERSTATUSFLAGS_LEARN()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TUNERSTATUSFLAGS_LEARN" , 26);
        yajl_gen_bool(g, (bool)value.getDAB_TUNERSTATUSFLAGS_LEARN());
    }
    if (value.getDAB_TUNERSTATUSFLAGS_b9_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TUNERSTATUSFLAGS_b9_reserved" , 32);
        yajl_gen_bool(g, (bool)value.getDAB_TUNERSTATUSFLAGS_b9_reserved());
    }
    if (value.getDAB_TUNERSTATUSFLAGS_b10_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TUNERSTATUSFLAGS_b10_reserved" , 33);
        yajl_gen_bool(g, (bool)value.getDAB_TUNERSTATUSFLAGS_b10_reserved());
    }
    if (value.getDAB_TUNERSTATUSFLAGS_b11_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TUNERSTATUSFLAGS_b11_reserved" , 33);
        yajl_gen_bool(g, (bool)value.getDAB_TUNERSTATUSFLAGS_b11_reserved());
    }
    if (value.getDAB_TUNERSTATUSFLAGS_b12_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TUNERSTATUSFLAGS_b12_reserved" , 33);
        yajl_gen_bool(g, (bool)value.getDAB_TUNERSTATUSFLAGS_b12_reserved());
    }
    if (value.getDAB_TUNERSTATUSFLAGS_b13_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TUNERSTATUSFLAGS_b13_reserved" , 33);
        yajl_gen_bool(g, (bool)value.getDAB_TUNERSTATUSFLAGS_b13_reserved());
    }
    if (value.getDAB_TUNERSTATUSFLAGS_b14_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TUNERSTATUSFLAGS_b14_reserved" , 33);
        yajl_gen_bool(g, (bool)value.getDAB_TUNERSTATUSFLAGS_b14_reserved());
    }
    if (value.getDAB_TUNERSTATUSFLAGS_b15_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TUNERSTATUSFLAGS_b15_reserved" , 33);
        yajl_gen_bool(g, (bool)value.getDAB_TUNERSTATUSFLAGS_b15_reserved());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_b16_DAB_TunerStatusFlags& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_TunerStatus"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_TunerStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8TunerActivityType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8TunerActivityType" , 19);
        const char* s = ::midw_ext_dabtuner_fi_types::T_e8_DAB_TunerActivityType_Name(value.getE8TunerActivityType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8TunerActivityType());
    }
    if (!isSparse || value.hasFreqTuned()) {
        yajl_gen_string(g, (const unsigned char*)  "FreqTuned" , 9);
        serializeJson(value.getFreqTuned(), g, options);
    }
    if (!isSparse || value.hasSFrequencyTable()) {
        yajl_gen_string(g, (const unsigned char*)  "sFrequencyTable" , 15);
        const char *s = value.getSFrequencyTable().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasB16Flags()) {
        yajl_gen_string(g, (const unsigned char*)  "b16Flags" , 8);
        serializeJson(value.getB16Flags(), g, options);
    }
    if (!isSparse || value.hasU8SignalQuality()) {
        yajl_gen_string(g, (const unsigned char*)  "u8SignalQuality" , 15);
        yajl_gen_integer(g, (long long)value.getU8SignalQuality());
    }
    if (!isSparse || value.hasU8AudioQuality()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AudioQuality" , 14);
        yajl_gen_integer(g, (long long)value.getU8AudioQuality());
    }
    if (!isSparse || value.hasU32CurrentEnsembleId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32CurrentEnsembleId" , 20);
        yajl_gen_integer(g, (long long)value.getU32CurrentEnsembleId());
    }
    if (!isSparse || value.hasU32CurrentServiceId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32CurrentServiceId" , 19);
        yajl_gen_integer(g, (long long)value.getU32CurrentServiceId());
    }
    if (!isSparse || value.hasU16CurrentSCIDI()) {
        yajl_gen_string(g, (const unsigned char*)  "u16CurrentSCIDI" , 15);
        yajl_gen_integer(g, (long long)value.getU16CurrentSCIDI());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_TunerStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_RadioText"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_RadioText& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSRadioTextData()) {
        yajl_gen_string(g, (const unsigned char*)  "sRadioTextData" , 14);
        const char *s = value.getSRadioTextData().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBValid()) {
        yajl_gen_string(g, (const unsigned char*)  "bValid" , 6);
        yajl_gen_bool(g, (bool)value.getBValid());
    }
    if (!isSparse || value.hasU8CharSet()) {
        yajl_gen_string(g, (const unsigned char*)  "u8CharSet" , 9);
        yajl_gen_integer(g, (long long)value.getU8CharSet());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_RadioText& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_RadioTextPlus"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_RadioTextPlus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8ContentType()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ContentType" , 13);
        yajl_gen_integer(g, (long long)value.getU8ContentType());
    }
    if (!isSparse || value.hasContent()) {
        yajl_gen_string(g, (const unsigned char*)  "Content" , 7);
        serializeJson(value.getContent(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_RadioTextPlus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_EnsembleInfo"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_EnsembleInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32EnsembleId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32EnsembleId" , 13);
        yajl_gen_integer(g, (long long)value.getU32EnsembleId());
    }
    if (!isSparse || value.hasEnsembleLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "EnsembleLabel" , 13);
        serializeJson(value.getEnsembleLabel(), g, options);
    }
    if (!isSparse || value.hasU32Frequency()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Frequency" , 12);
        yajl_gen_integer(g, (long long)value.getU32Frequency());
    }
    if (!isSparse || value.hasU8NumberOfAudioServices()) {
        yajl_gen_string(g, (const unsigned char*)  "u8NumberOfAudioServices" , 23);
        yajl_gen_integer(g, (long long)value.getU8NumberOfAudioServices());
    }
    if (!isSparse || value.hasU8NumberOfDataServices()) {
        yajl_gen_string(g, (const unsigned char*)  "u8NumberOfDataServices" , 22);
        yajl_gen_integer(g, (long long)value.getU8NumberOfDataServices());
    }
    if (!isSparse || value.hasU8NumberOfAudioServiceComponents()) {
        yajl_gen_string(g, (const unsigned char*)  "u8NumberOfAudioServiceComponents" , 32);
        yajl_gen_integer(g, (long long)value.getU8NumberOfAudioServiceComponents());
    }
    if (!isSparse || value.hasU8NumberOfDataServiceComponents()) {
        yajl_gen_string(g, (const unsigned char*)  "u8NumberOfDataServiceComponents" , 31);
        yajl_gen_integer(g, (long long)value.getU8NumberOfDataServiceComponents());
    }
    if (!isSparse || value.hasU8ReceptionQuality()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ReceptionQuality" , 18);
        yajl_gen_integer(g, (long long)value.getU8ReceptionQuality());
    }
    if (!isSparse || value.hasU8NumberOfEnsembles()) {
        yajl_gen_string(g, (const unsigned char*)  "u8NumberOfEnsembles" , 19);
        yajl_gen_integer(g, (long long)value.getU8NumberOfEnsembles());
    }
    if (!isSparse || value.hasU8ListElementId()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ListElementId" , 15);
        yajl_gen_integer(g, (long long)value.getU8ListElementId());
    }
    if (!isSparse || value.hasBReception()) {
        yajl_gen_string(g, (const unsigned char*)  "bReception" , 10);
        yajl_gen_bool(g, (bool)value.getBReception());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_EnsembleInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_DAB_ServiceInfoFlags"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_b8_DAB_ServiceInfoFlags& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getDAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT" , 41);
        yajl_gen_bool(g, (bool)value.getDAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT());
    }
    if (value.getDAB_SERVICEINFO_TMC_COMPONENT()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_SERVICEINFO_TMC_COMPONENT" , 29);
        yajl_gen_bool(g, (bool)value.getDAB_SERVICEINFO_TMC_COMPONENT());
    }
    if (value.getDAB_SERVICEINFO_DRC()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_SERVICEINFO_DRC" , 19);
        yajl_gen_bool(g, (bool)value.getDAB_SERVICEINFO_DRC());
    }
    if (value.getDAB_SERVICEINFO_b3_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_SERVICEINFO_b3_reserved" , 27);
        yajl_gen_bool(g, (bool)value.getDAB_SERVICEINFO_b3_reserved());
    }
    if (value.getDAB_SERVICEINFO_b4_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_SERVICEINFO_b4_reserved" , 27);
        yajl_gen_bool(g, (bool)value.getDAB_SERVICEINFO_b4_reserved());
    }
    if (value.getDAB_SERVICEINFO_b5_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_SERVICEINFO_b5_reserved" , 27);
        yajl_gen_bool(g, (bool)value.getDAB_SERVICEINFO_b5_reserved());
    }
    if (value.getDAB_SERVICEINFO_b6_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_SERVICEINFO_b6_reserved" , 27);
        yajl_gen_bool(g, (bool)value.getDAB_SERVICEINFO_b6_reserved());
    }
    if (value.getDAB_SERVICEINFO_b7_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_SERVICEINFO_b7_reserved" , 27);
        yajl_gen_bool(g, (bool)value.getDAB_SERVICEINFO_b7_reserved());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_b8_DAB_ServiceInfoFlags& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_ServiceInfo"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_ServiceInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ServId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ServId" , 9);
        yajl_gen_integer(g, (long long)value.getU32ServId());
    }
    if (!isSparse || value.hasServiceLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "ServiceLabel" , 12);
        serializeJson(value.getServiceLabel(), g, options);
    }
    if (!isSparse || value.hasE8ServiceType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ServiceType" , 13);
        const char* s = ::midw_ext_dabtuner_fi_types::T_e8_DAB_ServiceType_Name(value.getE8ServiceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ServiceType());
    }
    if (!isSparse || value.hasU8NumberOfAudioComponents()) {
        yajl_gen_string(g, (const unsigned char*)  "u8NumberOfAudioComponents" , 25);
        yajl_gen_integer(g, (long long)value.getU8NumberOfAudioComponents());
    }
    if (!isSparse || value.hasU8NumberOfDataComponents()) {
        yajl_gen_string(g, (const unsigned char*)  "u8NumberOfDataComponents" , 24);
        yajl_gen_integer(g, (long long)value.getU8NumberOfDataComponents());
    }
    if (!isSparse || value.hasB16AvailableAnnoTypesMask()) {
        yajl_gen_string(g, (const unsigned char*)  "b16AvailableAnnoTypesMask" , 25);
        serializeJson(value.getB16AvailableAnnoTypesMask(), g, options);
    }
    if (!isSparse || value.hasU8SampleRate()) {
        yajl_gen_string(g, (const unsigned char*)  "u8SampleRate" , 12);
        yajl_gen_integer(g, (long long)value.getU8SampleRate());
    }
    if (!isSparse || value.hasU16BitRate()) {
        yajl_gen_string(g, (const unsigned char*)  "u16BitRate" , 10);
        yajl_gen_integer(g, (long long)value.getU16BitRate());
    }
    if (!isSparse || value.hasSAudioMode()) {
        yajl_gen_string(g, (const unsigned char*)  "sAudioMode" , 10);
        const char *s = value.getSAudioMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSAdvancedAudioCodec()) {
        yajl_gen_string(g, (const unsigned char*)  "sAdvancedAudioCodec" , 19);
        const char *s = value.getSAdvancedAudioCodec().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSAudioCodec()) {
        yajl_gen_string(g, (const unsigned char*)  "sAudioCodec" , 11);
        const char *s = value.getSAudioCodec().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasB8Flags()) {
        yajl_gen_string(g, (const unsigned char*)  "b8Flags" , 7);
        serializeJson(value.getB8Flags(), g, options);
    }
    if (!isSparse || value.hasU8PresetListElementID()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PresetListElementID" , 21);
        yajl_gen_integer(g, (long long)value.getU8PresetListElementID());
    }
    if (!isSparse || value.hasU16ServiceIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ServiceIndex" , 15);
        yajl_gen_integer(g, (long long)value.getU16ServiceIndex());
    }
    if (!isSparse || value.hasU8PTYCode()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PTYCode" , 9);
        yajl_gen_integer(g, (long long)value.getU8PTYCode());
    }
    if (!isSparse || value.hasE8EncodingType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8EncodingType" , 14);
        const char* s = ::midw_ext_dabtuner_fi_types::T_e8_DAB_Encoding_Name(value.getE8EncodingType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8EncodingType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_ServiceInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_ChannelInfo"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_ChannelInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ServId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ServId" , 9);
        yajl_gen_integer(g, (long long)value.getU32ServId());
    }
    if (!isSparse || value.hasEnState()) {
        yajl_gen_string(g, (const unsigned char*)  "enState" , 7);
        const char* s = ::midw_ext_dabtuner_fi_types::T_e8_DAB_ChannelInfoState_Name(value.getEnState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEnState());
    }
    if (!isSparse || value.hasServiceLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "ServiceLabel" , 12);
        serializeJson(value.getServiceLabel(), g, options);
    }
    if (!isSparse || value.hasU8NumberOfAudioComponents()) {
        yajl_gen_string(g, (const unsigned char*)  "u8NumberOfAudioComponents" , 25);
        yajl_gen_integer(g, (long long)value.getU8NumberOfAudioComponents());
    }
    if (!isSparse || value.hasB16AvailableAnnoTypesMask()) {
        yajl_gen_string(g, (const unsigned char*)  "b16AvailableAnnoTypesMask" , 25);
        serializeJson(value.getB16AvailableAnnoTypesMask(), g, options);
    }
    if (!isSparse || value.hasU8PresetListElementID()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PresetListElementID" , 21);
        yajl_gen_integer(g, (long long)value.getU8PresetListElementID());
    }
    if (!isSparse || value.hasBComponentMode()) {
        yajl_gen_string(g, (const unsigned char*)  "bComponentMode" , 14);
        yajl_gen_bool(g, (bool)value.getBComponentMode());
    }
    if (!isSparse || value.hasBFmServiceFollowActive()) {
        yajl_gen_string(g, (const unsigned char*)  "bFmServiceFollowActive" , 22);
        yajl_gen_bool(g, (bool)value.getBFmServiceFollowActive());
    }
    if (!isSparse || value.hasU16FrozenListElementID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16FrozenListElementID" , 22);
        yajl_gen_integer(g, (long long)value.getU16FrozenListElementID());
    }
    if (!isSparse || value.hasRRadioText()) {
        yajl_gen_string(g, (const unsigned char*)  "rRadioText" , 10);
        serializeJson(value.getRRadioText(), g, options);
    }
    if (!isSparse || value.hasU8NumberOfDLPElements()) {
        yajl_gen_string(g, (const unsigned char*)  "u8NumberOfDLPElements" , 21);
        yajl_gen_integer(g, (long long)value.getU8NumberOfDLPElements());
    }
    if (!isSparse || value.hasDLPlusList()) {
        yajl_gen_string(g, (const unsigned char*)  "DLPlusList" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_ext_dabtuner_fi_types::T_DAB_RadioTextPlus >& o1 = value.getDLPlusList();
        {
            ::std::vector< ::midw_ext_dabtuner_fi_types::T_DAB_RadioTextPlus >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasBMuted()) {
        yajl_gen_string(g, (const unsigned char*)  "bMuted" , 6);
        yajl_gen_bool(g, (bool)value.getBMuted());
    }
    if (!isSparse || value.hasBAFAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bAFAvailable" , 12);
        yajl_gen_bool(g, (bool)value.getBAFAvailable());
    }
    if (!isSparse || value.hasSLogoLink()) {
        yajl_gen_string(g, (const unsigned char*)  "sLogoLink" , 9);
        const char *s = value.getSLogoLink().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU8ScidsValue()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ScidsValue" , 12);
        yajl_gen_integer(g, (long long)value.getU8ScidsValue());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_ChannelInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_ComponentInfo"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_ComponentInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8ComponentId()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ComponentId" , 13);
        yajl_gen_integer(g, (long long)value.getU8ComponentId());
    }
    if (!isSparse || value.hasComponentLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "ComponentLabel" , 14);
        serializeJson(value.getComponentLabel(), g, options);
    }
    if (!isSparse || value.hasU16SCIDI()) {
        yajl_gen_string(g, (const unsigned char*)  "u16SCIDI" , 8);
        yajl_gen_integer(g, (long long)value.getU16SCIDI());
    }
    if (!isSparse || value.hasU8Subchannel()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Subchannel" , 12);
        yajl_gen_integer(g, (long long)value.getU8Subchannel());
    }
    if (!isSparse || value.hasU8SCIDS()) {
        yajl_gen_string(g, (const unsigned char*)  "u8SCIDS" , 7);
        yajl_gen_integer(g, (long long)value.getU8SCIDS());
    }
    if (!isSparse || value.hasE8ComponentType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ComponentType" , 15);
        const char* s = ::midw_ext_dabtuner_fi_types::T_e8_DAB_ComponentType_Name(value.getE8ComponentType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ComponentType());
    }
    if (!isSparse || value.hasE8ServiceType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ServiceType" , 13);
        const char* s = ::midw_ext_dabtuner_fi_types::T_e8_DAB_ServiceType_Name(value.getE8ServiceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ServiceType());
    }
    if (!isSparse || value.hasE8TMIdType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8TMIdType" , 10);
        const char* s = ::midw_ext_dabtuner_fi_types::T_e8_DAB_TMIdType_Name(value.getE8TMIdType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8TMIdType());
    }
    if (!isSparse || value.hasU8AudioDataServiceComponentType()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AudioDataServiceComponentType" , 31);
        yajl_gen_integer(g, (long long)value.getU8AudioDataServiceComponentType());
    }
    if (!isSparse || value.hasU16ComponentIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ComponentIndex" , 17);
        yajl_gen_integer(g, (long long)value.getU16ComponentIndex());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_ComponentInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_AnnoConfig"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_AnnoConfig& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAnnoConfigTypes()) {
        yajl_gen_string(g, (const unsigned char*)  "AnnoConfigTypes" , 15);
        serializeJson(value.getAnnoConfigTypes(), g, options);
    }
    if (!isSparse || value.hasBEnable()) {
        yajl_gen_string(g, (const unsigned char*)  "bEnable" , 7);
        yajl_gen_bool(g, (bool)value.getBEnable());
    }
    if (!isSparse || value.hasAnnoConfigSource()) {
        yajl_gen_string(g, (const unsigned char*)  "AnnoConfigSource" , 16);
        const char* s = ::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementSource_Name(value.getAnnoConfigSource());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAnnoConfigSource());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_AnnoConfig& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_AnnoStatus"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_AnnoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAnnoConfigTypes()) {
        yajl_gen_string(g, (const unsigned char*)  "AnnoConfigTypes" , 15);
        serializeJson(value.getAnnoConfigTypes(), g, options);
    }
    if (!isSparse || value.hasAnnoConfigSource()) {
        yajl_gen_string(g, (const unsigned char*)  "AnnoConfigSource" , 16);
        const char* s = ::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementSource_Name(value.getAnnoConfigSource());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAnnoConfigSource());
    }
    if (!isSparse || value.hasAnnoSupportedTypes()) {
        yajl_gen_string(g, (const unsigned char*)  "AnnoSupportedTypes" , 18);
        serializeJson(value.getAnnoSupportedTypes(), g, options);
    }
    if (!isSparse || value.hasAnnoActiveTypes()) {
        yajl_gen_string(g, (const unsigned char*)  "AnnoActiveTypes" , 15);
        serializeJson(value.getAnnoActiveTypes(), g, options);
    }
    if (!isSparse || value.hasAnnoActiveSource()) {
        yajl_gen_string(g, (const unsigned char*)  "AnnoActiveSource" , 16);
        const char* s = ::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementSource_Name(value.getAnnoActiveSource());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAnnoActiveSource());
    }
    if (!isSparse || value.hasAnnoActiveState()) {
        yajl_gen_string(g, (const unsigned char*)  "AnnoActiveState" , 15);
        const char* s = ::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementStatus_Name(value.getAnnoActiveState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAnnoActiveState());
    }
    if (!isSparse || value.hasAnnoSelectState()) {
        yajl_gen_string(g, (const unsigned char*)  "AnnoSelectState" , 15);
        const char* s = ::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementSelectState_Name(value.getAnnoSelectState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAnnoSelectState());
    }
    if (!isSparse || value.hasAnnoSelectedTypes()) {
        yajl_gen_string(g, (const unsigned char*)  "AnnoSelectedTypes" , 17);
        serializeJson(value.getAnnoSelectedTypes(), g, options);
    }
    if (!isSparse || value.hasAnnoServiceLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "AnnoServiceLabel" , 16);
        serializeJson(value.getAnnoServiceLabel(), g, options);
    }
    if (!isSparse || value.hasAnnouncementList()) {
        yajl_gen_string(g, (const unsigned char*)  "AnnouncementList" , 16);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_ext_dabtuner_fi_types::T_DAB_AnnoElement >& o3 = value.getAnnouncementList();
        {
            ::std::vector< ::midw_ext_dabtuner_fi_types::T_DAB_AnnoElement >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_AnnoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_AnnoElement"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_AnnoElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16AnnoType()) {
        yajl_gen_string(g, (const unsigned char*)  "u16AnnoType" , 11);
        yajl_gen_integer(g, (long long)value.getU16AnnoType());
    }
    if (!isSparse || value.hasAnnoState()) {
        yajl_gen_string(g, (const unsigned char*)  "AnnoState" , 9);
        const char* s = ::midw_ext_dabtuner_fi_types::T_e8_DAB_AnnouncementStatus_Name(value.getAnnoState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAnnoState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_AnnoElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_ADRMsg"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_ADRMsg& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16FktID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16FktID" , 8);
        yajl_gen_integer(g, (long long)value.getU16FktID());
    }
    if (!isSparse || value.hasMsgData()) {
        yajl_gen_string(g, (const unsigned char*)  "MsgData" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o5 = value.getMsgData();
        {
            ::std::vector< uint8 >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                yajl_gen_integer(g, (long long)(*o4));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_ADRMsg& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_LogoElement"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_LogoElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ServiceID()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ServiceID" , 12);
        yajl_gen_integer(g, (long long)value.getU32ServiceID());
    }
    if (!isSparse || value.hasSLogoLink()) {
        yajl_gen_string(g, (const unsigned char*)  "sLogoLink" , 9);
        const char *s = value.getSLogoLink().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_LogoElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_ContentID"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_ContentID& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32ServiceID()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ServiceID" , 12);
        yajl_gen_integer(g, (long long)value.getU32ServiceID());
    }
    if (!isSparse || value.hasU8Scid()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Scid" , 6);
        yajl_gen_integer(g, (long long)value.getU8Scid());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_ContentID& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_TuneParam"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_TuneParam& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8TuneType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8TuneType" , 10);
        const char* s = ::midw_ext_dabtuner_fi_types::T_e8_DAB_TuneType_Name(value.getE8TuneType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8TuneType());
    }
    if (!isSparse || value.hasU32Value()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Value" , 8);
        yajl_gen_integer(g, (long long)value.getU32Value());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_TuneParam& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_LearnParam"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_LearnParam& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8LearnType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8LearnType" , 11);
        const char* s = ::midw_ext_dabtuner_fi_types::T_e8_DAB_LearnType_Name(value.getE8LearnType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8LearnType());
    }
    if (!isSparse || value.hasBRollback()) {
        yajl_gen_string(g, (const unsigned char*)  "bRollback" , 9);
        yajl_gen_bool(g, (bool)value.getBRollback());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_LearnParam& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b32_DAB_SetupMask"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_b32_DAB_SetupMask& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getDAB_SETUPOPERATIONMASK_b0_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_SETUPOPERATIONMASK_b0_reserved" , 34);
        yajl_gen_bool(g, (bool)value.getDAB_SETUPOPERATIONMASK_b0_reserved());
    }
    if (value.getDAB_SETUPOPERATIONMASK_b1_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_SETUPOPERATIONMASK_b1_reserved" , 34);
        yajl_gen_bool(g, (bool)value.getDAB_SETUPOPERATIONMASK_b1_reserved());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_b32_DAB_SetupMask& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b32_DAB_SetupFlags"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_b32_DAB_SetupFlags& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getDAB_SETUPOPERATION_SWITCHON_b0_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_SETUPOPERATION_SWITCHON_b0_reserved" , 39);
        yajl_gen_bool(g, (bool)value.getDAB_SETUPOPERATION_SWITCHON_b0_reserved());
    }
    if (value.getDAB_SETUPOPERATION_SWITCHON_b1_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_SETUPOPERATION_SWITCHON_b1_reserved" , 39);
        yajl_gen_bool(g, (bool)value.getDAB_SETUPOPERATION_SWITCHON_b1_reserved());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_b32_DAB_SetupFlags& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_DAB_LinkingSetupMask"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_b8_DAB_LinkingSetupMask& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getDAB_SETUPLINKING_TH_NONE()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_SETUPLINKING_TH_NONE" , 24);
        yajl_gen_bool(g, (bool)value.getDAB_SETUPLINKING_TH_NONE());
    }
    if (value.getDAB_SETUPLINKING_TH_DAB_FM_LINKING_TH()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH" , 37);
        yajl_gen_bool(g, (bool)value.getDAB_SETUPLINKING_TH_DAB_FM_LINKING_TH());
    }
    if (value.getDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH" , 42);
        yajl_gen_bool(g, (bool)value.getDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH());
    }
    if (value.getDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME" , 55);
        yajl_gen_bool(g, (bool)value.getDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME());
    }
    if (value.getDAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY" , 42);
        yajl_gen_bool(g, (bool)value.getDAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_b8_DAB_LinkingSetupMask& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_DAB_ExtServFollowingFlags"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_b8_DAB_ExtServFollowingFlags& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getDAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION" , 42);
        yajl_gen_bool(g, (bool)value.getDAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION());
    }
    if (value.getDAB_EXTSERVFOLLOWING_SWITCH_DONE()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_EXTSERVFOLLOWING_SWITCH_DONE" , 32);
        yajl_gen_bool(g, (bool)value.getDAB_EXTSERVFOLLOWING_SWITCH_DONE());
    }
    if (value.getDAB_EXTSERVFOLLOWING_SWITCH_REJECTED()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_EXTSERVFOLLOWING_SWITCH_REJECTED" , 36);
        yajl_gen_bool(g, (bool)value.getDAB_EXTSERVFOLLOWING_SWITCH_REJECTED());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_b8_DAB_ExtServFollowingFlags& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_PresetListElement"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_PresetListElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8PresetElementID()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PresetElementID" , 17);
        yajl_gen_integer(g, (long long)value.getU8PresetElementID());
    }
    if (!isSparse || value.hasU32ServiceID()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ServiceID" , 12);
        yajl_gen_integer(g, (long long)value.getU32ServiceID());
    }
    if (!isSparse || value.hasServiceLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "ServiceLabel" , 12);
        serializeJson(value.getServiceLabel(), g, options);
    }
    if (!isSparse || value.hasU32Frequency()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Frequency" , 12);
        yajl_gen_integer(g, (long long)value.getU32Frequency());
    }
    if (!isSparse || value.hasU8Scid()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Scid" , 6);
        yajl_gen_integer(g, (long long)value.getU8Scid());
    }
    if (!isSparse || value.hasComponentLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "ComponentLabel" , 14);
        serializeJson(value.getComponentLabel(), g, options);
    }
    if (!isSparse || value.hasU32EnsembleId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32EnsembleId" , 13);
        yajl_gen_integer(g, (long long)value.getU32EnsembleId());
    }
    if (!isSparse || value.hasEnsembleLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "EnsembleLabel" , 13);
        serializeJson(value.getEnsembleLabel(), g, options);
    }
    if (!isSparse || value.hasSLogoLink()) {
        yajl_gen_string(g, (const unsigned char*)  "sLogoLink" , 9);
        const char *s = value.getSLogoLink().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_PresetListElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_ChnListElement"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_ChnListElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16ListElementID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ListElementID" , 16);
        yajl_gen_integer(g, (long long)value.getU16ListElementID());
    }
    if (!isSparse || value.hasU32DABId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32DABId" , 8);
        yajl_gen_integer(g, (long long)value.getU32DABId());
    }
    if (!isSparse || value.hasU8CompScids()) {
        yajl_gen_string(g, (const unsigned char*)  "u8CompScids" , 11);
        yajl_gen_integer(g, (long long)value.getU8CompScids());
    }
    if (!isSparse || value.hasLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "Label" , 5);
        serializeJson(value.getLabel(), g, options);
    }
    if (!isSparse || value.hasEnsembleLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "EnsembleLabel" , 13);
        serializeJson(value.getEnsembleLabel(), g, options);
    }
    if (!isSparse || value.hasSFreqLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "sFreqLabel" , 10);
        const char *s = value.getSFreqLabel().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU8PresetListElemId()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PresetListElemId" , 18);
        yajl_gen_integer(g, (long long)value.getU8PresetListElemId());
    }
    if (!isSparse || value.hasU8PTY()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PTY" , 5);
        yajl_gen_integer(g, (long long)value.getU8PTY());
    }
    if (!isSparse || value.hasU16ASU()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ASU" , 6);
        yajl_gen_integer(g, (long long)value.getU16ASU());
    }
    if (!isSparse || value.hasBReception()) {
        yajl_gen_string(g, (const unsigned char*)  "bReception" , 10);
        yajl_gen_bool(g, (bool)value.getBReception());
    }
    if (!isSparse || value.hasU8NumberOfComponents()) {
        yajl_gen_string(g, (const unsigned char*)  "u8NumberOfComponents" , 20);
        yajl_gen_integer(g, (long long)value.getU8NumberOfComponents());
    }
    if (!isSparse || value.hasU8ServiceLinkMode()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ServiceLinkMode" , 17);
        yajl_gen_integer(g, (long long)value.getU8ServiceLinkMode());
    }
    if (!isSparse || value.hasSLogoLink()) {
        yajl_gen_string(g, (const unsigned char*)  "sLogoLink" , 9);
        const char *s = value.getSLogoLink().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBEPGSupport()) {
        yajl_gen_string(g, (const unsigned char*)  "bEPGSupport" , 11);
        yajl_gen_integer(g, (long long)value.getBEPGSupport());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_ChnListElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_ListElementAvailInfo"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_ListElementAvailInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16ListElementID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ListElementID" , 16);
        yajl_gen_integer(g, (long long)value.getU16ListElementID());
    }
    if (!isSparse || value.hasBAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "bAvailable" , 10);
        yajl_gen_bool(g, (bool)value.getBAvailable());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_ListElementAvailInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_TIIListElement"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_TIIListElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8MainId()) {
        yajl_gen_string(g, (const unsigned char*)  "u8MainId" , 8);
        yajl_gen_integer(g, (long long)value.getU8MainId());
    }
    if (!isSparse || value.hasU8SubId()) {
        yajl_gen_string(g, (const unsigned char*)  "u8SubId" , 7);
        yajl_gen_integer(g, (long long)value.getU8SubId());
    }
    if (!isSparse || value.hasU32Latitude()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Latitude" , 11);
        yajl_gen_integer(g, (long long)value.getU32Latitude());
    }
    if (!isSparse || value.hasU32Longitude()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Longitude" , 12);
        yajl_gen_integer(g, (long long)value.getU32Longitude());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_TIIListElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_DAB_TestMode_Flags"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_b8_DAB_TestMode_Flags& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getDAB_TESTMODE_FLAGS_AUDIOSOURCE()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TESTMODE_FLAGS_AUDIOSOURCE" , 30);
        yajl_gen_bool(g, (bool)value.getDAB_TESTMODE_FLAGS_AUDIOSOURCE());
    }
    if (value.getDAB_TESTMODE_FLAGS_SFINT()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TESTMODE_FLAGS_SFINT" , 24);
        yajl_gen_bool(g, (bool)value.getDAB_TESTMODE_FLAGS_SFINT());
    }
    if (value.getDAB_TESTMODE_FLAGS_b2_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TESTMODE_FLAGS_b2_reserved" , 30);
        yajl_gen_bool(g, (bool)value.getDAB_TESTMODE_FLAGS_b2_reserved());
    }
    if (value.getDAB_TESTMODE_FLAGS_b3_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TESTMODE_FLAGS_b3_reserved" , 30);
        yajl_gen_bool(g, (bool)value.getDAB_TESTMODE_FLAGS_b3_reserved());
    }
    if (value.getDAB_TESTMODE_FLAGS_b4_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TESTMODE_FLAGS_b4_reserved" , 30);
        yajl_gen_bool(g, (bool)value.getDAB_TESTMODE_FLAGS_b4_reserved());
    }
    if (value.getDAB_TESTMODE_FLAGS_b5_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TESTMODE_FLAGS_b5_reserved" , 30);
        yajl_gen_bool(g, (bool)value.getDAB_TESTMODE_FLAGS_b5_reserved());
    }
    if (value.getDAB_TESTMODE_FLAGS_b6_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TESTMODE_FLAGS_b6_reserved" , 30);
        yajl_gen_bool(g, (bool)value.getDAB_TESTMODE_FLAGS_b6_reserved());
    }
    if (value.getDAB_TESTMODE_FLAGS_b7_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TESTMODE_FLAGS_b7_reserved" , 30);
        yajl_gen_bool(g, (bool)value.getDAB_TESTMODE_FLAGS_b7_reserved());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_b8_DAB_TestMode_Flags& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_DAB_ALT_FM_Valid_Flags"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_b8_DAB_ALT_FM_Valid_Flags& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getDAB_FM_ALT_FM_PI_VALID_FLAG()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_FM_ALT_FM_PI_VALID_FLAG" , 27);
        yajl_gen_bool(g, (bool)value.getDAB_FM_ALT_FM_PI_VALID_FLAG());
    }
    if (value.getDAB_FM_ALT_FM_FREQ_VALID_FLAG()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_FM_ALT_FM_FREQ_VALID_FLAG" , 29);
        yajl_gen_bool(g, (bool)value.getDAB_FM_ALT_FM_FREQ_VALID_FLAG());
    }
    if (value.getDAB_FM_ALT_FM_QUALITY_VALID_FLAG()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_FM_ALT_FM_QUALITY_VALID_FLAG" , 32);
        yajl_gen_bool(g, (bool)value.getDAB_FM_ALT_FM_QUALITY_VALID_FLAG());
    }
    if (value.getDAB_TESTMODE_FLAGS_b3_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TESTMODE_FLAGS_b3_reserved" , 30);
        yajl_gen_bool(g, (bool)value.getDAB_TESTMODE_FLAGS_b3_reserved());
    }
    if (value.getDAB_TESTMODE_FLAGS_b4_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TESTMODE_FLAGS_b4_reserved" , 30);
        yajl_gen_bool(g, (bool)value.getDAB_TESTMODE_FLAGS_b4_reserved());
    }
    if (value.getDAB_TESTMODE_FLAGS_b5_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TESTMODE_FLAGS_b5_reserved" , 30);
        yajl_gen_bool(g, (bool)value.getDAB_TESTMODE_FLAGS_b5_reserved());
    }
    if (value.getDAB_TESTMODE_FLAGS_b6_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TESTMODE_FLAGS_b6_reserved" , 30);
        yajl_gen_bool(g, (bool)value.getDAB_TESTMODE_FLAGS_b6_reserved());
    }
    if (value.getDAB_TESTMODE_FLAGS_b7_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_TESTMODE_FLAGS_b7_reserved" , 30);
        yajl_gen_bool(g, (bool)value.getDAB_TESTMODE_FLAGS_b7_reserved());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_b8_DAB_ALT_FM_Valid_Flags& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_TestModeData"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_TestModeData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32CurrentServID()) {
        yajl_gen_string(g, (const unsigned char*)  "u32CurrentServID" , 16);
        yajl_gen_integer(g, (long long)value.getU32CurrentServID());
    }
    if (!isSparse || value.hasU32MSCBER()) {
        yajl_gen_string(g, (const unsigned char*)  "u32MSCBER" , 9);
        yajl_gen_integer(g, (long long)value.getU32MSCBER());
    }
    if (!isSparse || value.hasU32FICBER()) {
        yajl_gen_string(g, (const unsigned char*)  "u32FICBER" , 9);
        yajl_gen_integer(g, (long long)value.getU32FICBER());
    }
    if (!isSparse || value.hasU32NETBER()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NETBER" , 9);
        yajl_gen_integer(g, (long long)value.getU32NETBER());
    }
    if (!isSparse || value.hasU8RSFEC()) {
        yajl_gen_string(g, (const unsigned char*)  "u8RSFEC" , 7);
        yajl_gen_integer(g, (long long)value.getU8RSFEC());
    }
    if (!isSparse || value.hasU8DABMode()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DABMode" , 9);
        yajl_gen_integer(g, (long long)value.getU8DABMode());
    }
    if (!isSparse || value.hasU8ProtectionLevel()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ProtectionLevel" , 17);
        yajl_gen_integer(g, (long long)value.getU8ProtectionLevel());
    }
    if (!isSparse || value.hasU8ConcealmentLevel()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ConcealmentLevel" , 18);
        yajl_gen_integer(g, (long long)value.getU8ConcealmentLevel());
    }
    if (!isSparse || value.hasE8ServiceLinkingMode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ServiceLinkingMode" , 20);
        const char* s = ::midw_ext_dabtuner_fi_types::T_e8_DAB_ServiceLinkingMode_Name(value.getE8ServiceLinkingMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ServiceLinkingMode());
    }
    if (!isSparse || value.hasB8ValidFMValues()) {
        yajl_gen_string(g, (const unsigned char*)  "b8ValidFMValues" , 15);
        serializeJson(value.getB8ValidFMValues(), g, options);
    }
    if (!isSparse || value.hasU16AltFMPI()) {
        yajl_gen_string(g, (const unsigned char*)  "u16AltFMPI" , 10);
        yajl_gen_integer(g, (long long)value.getU16AltFMPI());
    }
    if (!isSparse || value.hasU32AltFMFrequency()) {
        yajl_gen_string(g, (const unsigned char*)  "u32AltFMFrequency" , 17);
        yajl_gen_integer(g, (long long)value.getU32AltFMFrequency());
    }
    if (!isSparse || value.hasU8AltFMQuality()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AltFMQuality" , 14);
        yajl_gen_integer(g, (long long)value.getU8AltFMQuality());
    }
    if (!isSparse || value.hasB8Flags()) {
        yajl_gen_string(g, (const unsigned char*)  "b8Flags" , 7);
        serializeJson(value.getB8Flags(), g, options);
    }
    if (!isSparse || value.hasS8FieldStrength()) {
        yajl_gen_string(g, (const unsigned char*)  "s8FieldStrength" , 15);
        yajl_gen_integer(g, (long long)value.getS8FieldStrength());
    }
    if (!isSparse || value.hasU16TotalNumberLinks()) {
        yajl_gen_string(g, (const unsigned char*)  "u16TotalNumberLinks" , 19);
        yajl_gen_integer(g, (long long)value.getU16TotalNumberLinks());
    }
    if (!isSparse || value.hasU8ECC()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ECC" , 5);
        yajl_gen_integer(g, (long long)value.getU8ECC());
    }
    if (!isSparse || value.hasU16CountryLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "u16CountryLabel" , 15);
        yajl_gen_integer(g, (long long)value.getU16CountryLabel());
    }
    if (!isSparse || value.hasU16ActivatedLink()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ActivatedLink" , 16);
        yajl_gen_integer(g, (long long)value.getU16ActivatedLink());
    }
    if (!isSparse || value.hasLinkList()) {
        yajl_gen_string(g, (const unsigned char*)  "LinkList" , 8);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_ext_dabtuner_fi_types::T_DAB_LinkListElem >& o7 = value.getLinkList();
        {
            ::std::vector< ::midw_ext_dabtuner_fi_types::T_DAB_LinkListElem >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                serializeJson((*o6), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasDAB_DMB_AltFreqInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB_DMB_AltFreqInfo" , 19);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_ext_dabtuner_fi_types::T_DAB_AltFreqInfo >& o9 = value.getDAB_DMB_AltFreqInfo();
        {
            ::std::vector< ::midw_ext_dabtuner_fi_types::T_DAB_AltFreqInfo >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                serializeJson((*o8), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasBSync()) {
        yajl_gen_string(g, (const unsigned char*)  "bSync" , 5);
        yajl_gen_bool(g, (bool)value.getBSync());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_TestModeData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_LinkListElem"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_LinkListElem& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8LinkType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8LinkType" , 10);
        const char* s = ::midw_ext_dabtuner_fi_types::T_e8_DAB_LinkType_Name(value.getE8LinkType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8LinkType());
    }
    if (!isSparse || value.hasSFreqLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "sFreqLabel" , 10);
        const char *s = value.getSFreqLabel().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32ID()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ID" , 5);
        yajl_gen_integer(g, (long long)value.getU32ID());
    }
    if (!isSparse || value.hasU32EnsembleId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32EnsembleId" , 13);
        yajl_gen_integer(g, (long long)value.getU32EnsembleId());
    }
    if (!isSparse || value.hasU8Quality()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Quality" , 9);
        yajl_gen_integer(g, (long long)value.getU8Quality());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_LinkListElem& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_AltFreqInfo"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_AltFreqInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32Frequency()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Frequency" , 12);
        yajl_gen_integer(g, (long long)value.getU32Frequency());
    }
    if (!isSparse || value.hasS8FieldStrength()) {
        yajl_gen_string(g, (const unsigned char*)  "s8FieldStrength" , 15);
        yajl_gen_integer(g, (long long)value.getS8FieldStrength());
    }
    if (!isSparse || value.hasU8Quality()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Quality" , 9);
        yajl_gen_integer(g, (long long)value.getU8Quality());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_AltFreqInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_BG_TestModeData"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_BG_TestModeData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32BgFrequency()) {
        yajl_gen_string(g, (const unsigned char*)  "u32BgFrequency" , 14);
        yajl_gen_integer(g, (long long)value.getU32BgFrequency());
    }
    if (!isSparse || value.hasU32BgCurrentEnsID()) {
        yajl_gen_string(g, (const unsigned char*)  "u32BgCurrentEnsID" , 17);
        yajl_gen_integer(g, (long long)value.getU32BgCurrentEnsID());
    }
    if (!isSparse || value.hasU32BgFICBER()) {
        yajl_gen_string(g, (const unsigned char*)  "u32BgFICBER" , 11);
        yajl_gen_integer(g, (long long)value.getU32BgFICBER());
    }
    if (!isSparse || value.hasB16BgFlags()) {
        yajl_gen_string(g, (const unsigned char*)  "b16BgFlags" , 10);
        serializeJson(value.getB16BgFlags(), g, options);
    }
    if (!isSparse || value.hasSBgDabMode()) {
        yajl_gen_string(g, (const unsigned char*)  "sBgDabMode" , 10);
        const char *s = value.getSBgDabMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_BG_TestModeData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_Time"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_Time& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32DabSec()) {
        yajl_gen_string(g, (const unsigned char*)  "u32DabSec" , 9);
        yajl_gen_integer(g, (long long)value.getU32DabSec());
    }
    if (!isSparse || value.hasU32DabMin()) {
        yajl_gen_string(g, (const unsigned char*)  "u32DabMin" , 9);
        yajl_gen_integer(g, (long long)value.getU32DabMin());
    }
    if (!isSparse || value.hasU32DabHour()) {
        yajl_gen_string(g, (const unsigned char*)  "u32DabHour" , 10);
        yajl_gen_integer(g, (long long)value.getU32DabHour());
    }
    if (!isSparse || value.hasU32DabMday()) {
        yajl_gen_string(g, (const unsigned char*)  "u32DabMday" , 10);
        yajl_gen_integer(g, (long long)value.getU32DabMday());
    }
    if (!isSparse || value.hasU32DabMon()) {
        yajl_gen_string(g, (const unsigned char*)  "u32DabMon" , 9);
        yajl_gen_integer(g, (long long)value.getU32DabMon());
    }
    if (!isSparse || value.hasU32DabYear()) {
        yajl_gen_string(g, (const unsigned char*)  "u32DabYear" , 10);
        yajl_gen_integer(g, (long long)value.getU32DabYear());
    }
    if (!isSparse || value.hasU32DabWday()) {
        yajl_gen_string(g, (const unsigned char*)  "u32DabWday" , 10);
        yajl_gen_integer(g, (long long)value.getU32DabWday());
    }
    if (!isSparse || value.hasU32DabYday()) {
        yajl_gen_string(g, (const unsigned char*)  "u32DabYday" , 10);
        yajl_gen_integer(g, (long long)value.getU32DabYday());
    }
    if (!isSparse || value.hasU32DabUtcOff()) {
        yajl_gen_string(g, (const unsigned char*)  "u32DabUtcOff" , 12);
        yajl_gen_integer(g, (long long)value.getU32DabUtcOff());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_Time& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_TMC_TPEG_TestModeData"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_TMC_TPEG_TestModeData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32NumTmcServices()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NumTmcServices" , 17);
        yajl_gen_integer(g, (long long)value.getU32NumTmcServices());
    }
    if (!isSparse || value.hasU32NumTpegServices()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NumTpegServices" , 18);
        yajl_gen_integer(g, (long long)value.getU32NumTpegServices());
    }
    if (!isSparse || value.hasU32RcvTmcMsgs()) {
        yajl_gen_string(g, (const unsigned char*)  "u32RcvTmcMsgs" , 13);
        yajl_gen_integer(g, (long long)value.getU32RcvTmcMsgs());
    }
    if (!isSparse || value.hasU32RcvTpegMsgs()) {
        yajl_gen_string(g, (const unsigned char*)  "u32RcvTpegMsgs" , 14);
        yajl_gen_integer(g, (long long)value.getU32RcvTpegMsgs());
    }
    if (!isSparse || value.hasDabTime()) {
        yajl_gen_string(g, (const unsigned char*)  "DabTime" , 7);
        serializeJson(value.getDabTime(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_TMC_TPEG_TestModeData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_RdbId"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_RdbId& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Cc()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Cc" , 4);
        yajl_gen_integer(g, (long long)value.getU8Cc());
    }
    if (!isSparse || value.hasU8Ltn()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Ltn" , 5);
        yajl_gen_integer(g, (long long)value.getU8Ltn());
    }
    if (!isSparse || value.hasU8Bsa()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Bsa" , 5);
        yajl_gen_integer(g, (long long)value.getU8Bsa());
    }
    if (!isSparse || value.hasU16Bsa()) {
        yajl_gen_string(g, (const unsigned char*)  "u16Bsa" , 6);
        yajl_gen_integer(g, (long long)value.getU16Bsa());
    }
    if (!isSparse || value.hasU8Sid()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Sid" , 5);
        yajl_gen_integer(g, (long long)value.getU8Sid());
    }
    if (!isSparse || value.hasBEncrypted()) {
        yajl_gen_string(g, (const unsigned char*)  "bEncrypted" , 10);
        yajl_gen_bool(g, (bool)value.getBEncrypted());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_RdbId& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_TmcData"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_TmcData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8TmcData1()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TmcData1" , 10);
        yajl_gen_integer(g, (long long)value.getU8TmcData1());
    }
    if (!isSparse || value.hasU8TmcData2()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TmcData2" , 10);
        yajl_gen_integer(g, (long long)value.getU8TmcData2());
    }
    if (!isSparse || value.hasU8TmcData3()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TmcData3" , 10);
        yajl_gen_integer(g, (long long)value.getU8TmcData3());
    }
    if (!isSparse || value.hasU8TmcData4()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TmcData4" , 10);
        yajl_gen_integer(g, (long long)value.getU8TmcData4());
    }
    if (!isSparse || value.hasU8TmcData5()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TmcData5" , 10);
        yajl_gen_integer(g, (long long)value.getU8TmcData5());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_TmcData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_Encryption"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_Encryption& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBEncrypted()) {
        yajl_gen_string(g, (const unsigned char*)  "bEncrypted" , 10);
        yajl_gen_bool(g, (bool)value.getBEncrypted());
    }
    if (!isSparse || value.hasU8EncId()) {
        yajl_gen_string(g, (const unsigned char*)  "u8EncId" , 7);
        yajl_gen_integer(g, (long long)value.getU8EncId());
    }
    if (!isSparse || value.hasU8TestBits()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TestBits" , 10);
        yajl_gen_integer(g, (long long)value.getU8TestBits());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_Encryption& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_MsgSource"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_MsgSource& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDabMediumTypeId()) {
        yajl_gen_string(g, (const unsigned char*)  "DabMediumTypeId" , 15);
        const char* s = ::midw_ext_dabtuner_fi_types::T_e8_DAB_TmcMediumType_Name(value.getDabMediumTypeId());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDabMediumTypeId());
    }
    if (!isSparse || value.hasU8Number()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Number" , 8);
        yajl_gen_integer(g, (long long)value.getU8Number());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_MsgSource& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_TmcInfo"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_TmcInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRdbId()) {
        yajl_gen_string(g, (const unsigned char*)  "RdbId" , 5);
        serializeJson(value.getRdbId(), g, options);
    }
    if (!isSparse || value.hasS16Ecc()) {
        yajl_gen_string(g, (const unsigned char*)  "s16Ecc" , 6);
        yajl_gen_integer(g, (long long)value.getS16Ecc());
    }
    if (!isSparse || value.hasU16Aid()) {
        yajl_gen_string(g, (const unsigned char*)  "u16Aid" , 6);
        yajl_gen_integer(g, (long long)value.getU16Aid());
    }
    if (!isSparse || value.hasTmcData()) {
        yajl_gen_string(g, (const unsigned char*)  "TmcData" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o11 = value.getTmcData();
        {
            ::std::vector< uint8 >::const_iterator o10;
            for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                yajl_gen_integer(g, (long long)(*o10));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasU16ProgramId()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ProgramId" , 12);
        yajl_gen_integer(g, (long long)value.getU16ProgramId());
    }
    if (!isSparse || value.hasDabEncryption()) {
        yajl_gen_string(g, (const unsigned char*)  "DabEncryption" , 13);
        serializeJson(value.getDabEncryption(), g, options);
    }
    if (!isSparse || value.hasDabMsgSource()) {
        yajl_gen_string(g, (const unsigned char*)  "DabMsgSource" , 12);
        serializeJson(value.getDabMsgSource(), g, options);
    }
    if (!isSparse || value.hasSProgramServiceName()) {
        yajl_gen_string(g, (const unsigned char*)  "sProgramServiceName" , 19);
        const char *s = value.getSProgramServiceName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSServiceProviderName()) {
        yajl_gen_string(g, (const unsigned char*)  "sServiceProviderName" , 20);
        const char *s = value.getSServiceProviderName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_TmcInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_EnsembleTmcInfo"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_EnsembleTmcInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32EnsembleId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32EnsembleId" , 13);
        yajl_gen_integer(g, (long long)value.getU32EnsembleId());
    }
    if (!isSparse || value.hasU8Quality()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Quality" , 9);
        yajl_gen_integer(g, (long long)value.getU8Quality());
    }
    if (!isSparse || value.hasU8NumberOfRdbIds()) {
        yajl_gen_string(g, (const unsigned char*)  "u8NumberOfRdbIds" , 16);
        yajl_gen_integer(g, (long long)value.getU8NumberOfRdbIds());
    }
    if (!isSparse || value.hasRdbIdList()) {
        yajl_gen_string(g, (const unsigned char*)  "RdbIdList" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_ext_dabtuner_fi_types::T_DAB_RdbId >& o13 = value.getRdbIdList();
        {
            ::std::vector< ::midw_ext_dabtuner_fi_types::T_DAB_RdbId >::const_iterator o12;
            for (o12 = o13.begin(); o12 != o13.end(); ++o12) {
                serializeJson((*o12), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_EnsembleTmcInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DAB_TpegUriChannel"

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_TpegUriChannel& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSTpegUriChn()) {
        yajl_gen_string(g, (const unsigned char*)  "sTpegUriChn" , 11);
        const char *s = value.getSTpegUriChn().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasDabUriSelectState()) {
        yajl_gen_string(g, (const unsigned char*)  "DabUriSelectState" , 17);
        const char* s = ::midw_ext_dabtuner_fi_types::T_e8_DAB_UriSelectState_Name(value.getDabUriSelectState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDabUriSelectState());
    }
    if (!isSparse || value.hasBActive()) {
        yajl_gen_string(g, (const unsigned char*)  "bActive" , 7);
        yajl_gen_bool(g, (bool)value.getBActive());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_ext_dabtuner_fi_types::T_DAB_TpegUriChannel& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_Label& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_b8_DAB_MTC_SetMode& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_b16_DAB_AnnouncementType& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_Frequency& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_b16_DAB_TunerStatusFlags& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_TunerStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_RadioText& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_RadioTextPlus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_EnsembleInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_b8_DAB_ServiceInfoFlags& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_ServiceInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_ChannelInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_ComponentInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_AnnoConfig& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_AnnoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_AnnoElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_ADRMsg& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_LogoElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_ContentID& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_TuneParam& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_LearnParam& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_b32_DAB_SetupMask& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_b32_DAB_SetupFlags& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_b8_DAB_LinkingSetupMask& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_b8_DAB_ExtServFollowingFlags& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_PresetListElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_ChnListElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_ListElementAvailInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_TIIListElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_b8_DAB_TestMode_Flags& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_b8_DAB_ALT_FM_Valid_Flags& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_TestModeData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_LinkListElem& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_AltFreqInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_BG_TestModeData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_Time& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_TMC_TPEG_TestModeData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_RdbId& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_TmcData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_Encryption& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_MsgSource& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_TmcInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_EnsembleTmcInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types
using namespace ::asf::stream::json;

namespace midw_ext_dabtuner_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_ext_dabtuner_fi_types::T_DAB_TpegUriChannel& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_ext_dabtuner_fi_types

