/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MIDW_DIAGNOSTICS_FIPROXY_H
#define MIDW_DIAGNOSTICS_FIPROXY_H

#include "Midw_Diagnostics_FI.h"
#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "midw_diagnostics_fi_types.h"
#include "midw_diagnostics_fi_typesConst.h"
#include <map>
#include <string>

namespace Midw_Diagnostics_FI {

class Midw_Diagnostics_FIProxy;

class AntiTheftStatusCallbackIF {
public:
    virtual ~AntiTheftStatusCallbackIF() {}

    virtual void onAntiTheftStatusError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< AntiTheftStatusError >& error) = 0;

    virtual void onAntiTheftStatusStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< AntiTheftStatusStatus >& status) = 0;
};

class AntiTheftUnlockHMICallbackIF {
public:
    virtual ~AntiTheftUnlockHMICallbackIF() {}

    virtual void onAntiTheftUnlockHMIError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< AntiTheftUnlockHMIError >& error) = 0;

    virtual void onAntiTheftUnlockHMIStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< AntiTheftUnlockHMIStatus >& status) = 0;
};

class AntiTheftUnlockHUCallbackIF {
public:
    virtual ~AntiTheftUnlockHUCallbackIF() {}

    virtual void onAntiTheftUnlockHUError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< AntiTheftUnlockHUError >& error) = 0;

    virtual void onAntiTheftUnlockHUStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< AntiTheftUnlockHUStatus >& status) = 0;
};

class CISswUpdateProcessCallbackIF {
public:
    virtual ~CISswUpdateProcessCallbackIF() {}

    virtual void onCISswUpdateProcessError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< CISswUpdateProcessError >& error) = 0;

    virtual void onCISswUpdateProcessStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< CISswUpdateProcessStatus >& status) = 0;
};

class CISswUpdateStage2ProcessCallbackIF {
public:
    virtual ~CISswUpdateStage2ProcessCallbackIF() {}

    virtual void onCISswUpdateStage2ProcessError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< CISswUpdateStage2ProcessError >& error) = 0;

    virtual void onCISswUpdateStage2ProcessStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< CISswUpdateStage2ProcessStatus >& status) = 0;
};

class CalibrationParameterCallbackIF {
public:
    virtual ~CalibrationParameterCallbackIF() {}

    virtual void onCalibrationParameterError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< CalibrationParameterError >& error) = 0;

    virtual void onCalibrationParameterStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< CalibrationParameterStatus >& status) = 0;
};

class ClearDestinationMemoryCallbackIF {
public:
    virtual ~ClearDestinationMemoryCallbackIF() {}

    virtual void onClearDestinationMemoryError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< ClearDestinationMemoryError >& error) = 0;

    virtual void onClearDestinationMemoryStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< ClearDestinationMemoryStatus >& status) = 0;
};

class ClearDiagLogCallbackIF {
public:
    virtual ~ClearDiagLogCallbackIF() {}

    virtual void onClearDiagLogError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< ClearDiagLogError >& error) = 0;

    virtual void onClearDiagLogResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< ClearDiagLogResult >& result) = 0;
};

class ConfigUpdateViaUSBCallbackIF {
public:
    virtual ~ConfigUpdateViaUSBCallbackIF() {}

    virtual void onConfigUpdateViaUSBError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< ConfigUpdateViaUSBError >& error) = 0;

    virtual void onConfigUpdateViaUSBStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< ConfigUpdateViaUSBStatus >& status) = 0;
};

class DiagConfigItemCallbackIF {
public:
    virtual ~DiagConfigItemCallbackIF() {}

    virtual void onDiagConfigItemError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< DiagConfigItemError >& error) = 0;

    virtual void onDiagConfigItemStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< DiagConfigItemStatus >& status) = 0;
};

class DiagRequestCallbackIF {
public:
    virtual ~DiagRequestCallbackIF() {}

    virtual void onDiagRequestError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< DiagRequestError >& error) = 0;

    virtual void onDiagRequestResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< DiagRequestResult >& result) = 0;
};

class EnableTimeSlotCallbackIF {
public:
    virtual ~EnableTimeSlotCallbackIF() {}

    virtual void onEnableTimeSlotError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< EnableTimeSlotError >& error) = 0;

    virtual void onEnableTimeSlotResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< EnableTimeSlotResult >& result) = 0;
};

class GetDestinationMemorySizeCallbackIF {
public:
    virtual ~GetDestinationMemorySizeCallbackIF() {}

    virtual void onGetDestinationMemorySizeError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< GetDestinationMemorySizeError >& error) = 0;

    virtual void onGetDestinationMemorySizeStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< GetDestinationMemorySizeStatus >& status) = 0;
};

class GetLocaleCallbackIF {
public:
    virtual ~GetLocaleCallbackIF() {}

    virtual void onGetLocaleError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< GetLocaleError >& error) = 0;

    virtual void onGetLocaleStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< GetLocaleStatus >& status) = 0;
};

class KdsEntryCallbackIF {
public:
    virtual ~KdsEntryCallbackIF() {}

    virtual void onKdsEntryError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< KdsEntryError >& error) = 0;

    virtual void onKdsEntryStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< KdsEntryStatus >& status) = 0;
};

class LanguageCallbackIF {
public:
    virtual ~LanguageCallbackIF() {}

    virtual void onLanguageError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< LanguageError >& error) = 0;

    virtual void onLanguageStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< LanguageStatus >& status) = 0;
};

class PartNumberCallbackIF {
public:
    virtual ~PartNumberCallbackIF() {}

    virtual void onPartNumberError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< PartNumberError >& error) = 0;

    virtual void onPartNumberStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< PartNumberStatus >& status) = 0;
};

class RVCSignalStatusCallbackIF {
public:
    virtual ~RVCSignalStatusCallbackIF() {}

    virtual void onRVCSignalStatusError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< RVCSignalStatusError >& error) = 0;

    virtual void onRVCSignalStatusStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< RVCSignalStatusStatus >& status) = 0;
};

class ReadDiagLogCallbackIF {
public:
    virtual ~ReadDiagLogCallbackIF() {}

    virtual void onReadDiagLogError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< ReadDiagLogError >& error) = 0;

    virtual void onReadDiagLogResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< ReadDiagLogResult >& result) = 0;
};

class RemoteControlCallbackIF {
public:
    virtual ~RemoteControlCallbackIF() {}

    virtual void onRemoteControlError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< RemoteControlError >& error) = 0;

    virtual void onRemoteControlStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< RemoteControlStatus >& status) = 0;
};

class ResetSecurityCallbackIF {
public:
    virtual ~ResetSecurityCallbackIF() {}

    virtual void onResetSecurityError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< ResetSecurityError >& error) = 0;

    virtual void onResetSecurityStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< ResetSecurityStatus >& status) = 0;
};

class RouteCalculationResultCallbackIF {
public:
    virtual ~RouteCalculationResultCallbackIF() {}

    virtual void onRouteCalculationResultError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< RouteCalculationResultError >& error) = 0;

    virtual void onRouteCalculationResultStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< RouteCalculationResultStatus >& status) = 0;
};

class SetDefaultSettingsCallbackIF {
public:
    virtual ~SetDefaultSettingsCallbackIF() {}

    virtual void onSetDefaultSettingsError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetDefaultSettingsError >& error) = 0;

    virtual void onSetDefaultSettingsResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetDefaultSettingsResult >& result) = 0;
};

class SetDisplayCallbackIF {
public:
    virtual ~SetDisplayCallbackIF() {}

    virtual void onSetDisplayError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetDisplayError >& error) = 0;

    virtual void onSetDisplayStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetDisplayStatus >& status) = 0;
};

class SetFactorySettingsCallbackIF {
public:
    virtual ~SetFactorySettingsCallbackIF() {}

    virtual void onSetFactorySettingsError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetFactorySettingsError >& error) = 0;

    virtual void onSetFactorySettingsResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetFactorySettingsResult >& result) = 0;
};

class SetFactorySettingsNewCallbackIF {
public:
    virtual ~SetFactorySettingsNewCallbackIF() {}

    virtual void onSetFactorySettingsNewError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetFactorySettingsNewError >& error) = 0;

    virtual void onSetFactorySettingsNewResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetFactorySettingsNewResult >& result) = 0;
};

class SetFactorySettingsStatusCallbackIF {
public:
    virtual ~SetFactorySettingsStatusCallbackIF() {}

    virtual void onSetFactorySettingsStatusError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetFactorySettingsStatusError >& error) = 0;

    virtual void onSetFactorySettingsStatusStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetFactorySettingsStatusStatus >& status) = 0;
};

class SetLocaleResultCallbackIF {
public:
    virtual ~SetLocaleResultCallbackIF() {}

    virtual void onSetLocaleResultError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetLocaleResultError >& error) = 0;

    virtual void onSetLocaleResultStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetLocaleResultStatus >& status) = 0;
};

class SetLocaleStartCallbackIF {
public:
    virtual ~SetLocaleStartCallbackIF() {}

    virtual void onSetLocaleStartError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetLocaleStartError >& error) = 0;

    virtual void onSetLocaleStartStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetLocaleStartStatus >& status) = 0;
};

class SetRVCSignalCallbackIF {
public:
    virtual ~SetRVCSignalCallbackIF() {}

    virtual void onSetRVCSignalError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetRVCSignalError >& error) = 0;

    virtual void onSetRVCSignalStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetRVCSignalStatus >& status) = 0;
};

class SetResetToSupplierDefaultConfigCallbackIF {
public:
    virtual ~SetResetToSupplierDefaultConfigCallbackIF() {}

    virtual void onSetResetToSupplierDefaultConfigError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetResetToSupplierDefaultConfigError >& error) = 0;

    virtual void onSetResetToSupplierDefaultConfigResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetResetToSupplierDefaultConfigResult >& result) = 0;
};

class SetRunTimeSourceDataCallbackIF {
public:
    virtual ~SetRunTimeSourceDataCallbackIF() {}

    virtual void onSetRunTimeSourceDataError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetRunTimeSourceDataError >& error) = 0;

    virtual void onSetRunTimeSourceDataResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetRunTimeSourceDataResult >& result) = 0;
};

class SimulateKeyPressCallbackIF {
public:
    virtual ~SimulateKeyPressCallbackIF() {}

    virtual void onSimulateKeyPressError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SimulateKeyPressError >& error) = 0;

    virtual void onSimulateKeyPressStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SimulateKeyPressStatus >& status) = 0;
};

class SpdLockCallbackIF {
public:
    virtual ~SpdLockCallbackIF() {}

    virtual void onSpdLockError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SpdLockError >& error) = 0;

    virtual void onSpdLockStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SpdLockStatus >& status) = 0;
};

class SpeedLockCallbackIF {
public:
    virtual ~SpeedLockCallbackIF() {}

    virtual void onSpeedLockError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SpeedLockError >& error) = 0;

    virtual void onSpeedLockStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SpeedLockStatus >& status) = 0;
};

class StartCalibrationSessionCallbackIF {
public:
    virtual ~StartCalibrationSessionCallbackIF() {}

    virtual void onStartCalibrationSessionError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< StartCalibrationSessionError >& error) = 0;

    virtual void onStartCalibrationSessionResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< StartCalibrationSessionResult >& result) = 0;
};

class StartDiagnosticTestCallbackIF {
public:
    virtual ~StartDiagnosticTestCallbackIF() {}

    virtual void onStartDiagnosticTestError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< StartDiagnosticTestError >& error) = 0;

    virtual void onStartDiagnosticTestResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< StartDiagnosticTestResult >& result) = 0;
};

class StartRouteCalculationCallbackIF {
public:
    virtual ~StartRouteCalculationCallbackIF() {}

    virtual void onStartRouteCalculationError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< StartRouteCalculationError >& error) = 0;

    virtual void onStartRouteCalculationStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< StartRouteCalculationStatus >& status) = 0;
};

class StopCalibrationSessionCallbackIF {
public:
    virtual ~StopCalibrationSessionCallbackIF() {}

    virtual void onStopCalibrationSessionError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< StopCalibrationSessionError >& error) = 0;

    virtual void onStopCalibrationSessionResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< StopCalibrationSessionResult >& result) = 0;
};

class StopDiagnosticTestCallbackIF {
public:
    virtual ~StopDiagnosticTestCallbackIF() {}

    virtual void onStopDiagnosticTestError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< StopDiagnosticTestError >& error) = 0;

    virtual void onStopDiagnosticTestResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< StopDiagnosticTestResult >& result) = 0;
};

class TestMessageCallbackIF {
public:
    virtual ~TestMessageCallbackIF() {}

    virtual void onTestMessageError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< TestMessageError >& error) = 0;

    virtual void onTestMessageResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< TestMessageResult >& result) = 0;
};

class Midw_Diagnostics_FIProxyCallback;

/**
 * Midw_Diagnostics_FIProxy is the client side representation of the CCA
 * Functional Interface 'Midw_Diagnostics_FI' (specified in file
 * midw_diagnostics_fi.xml).
 *
 * CCA Functional Interface 'Midw_Diagnostics_FI'
 *
 * Fullname: Middleware Diagnostics Application Functional Interface
 *
 * Version: v$Revision:   1.1.0.0  $
 *
 * Author: Mike Barber, Michael Gibron
 *
 * Date: $Date:   Apr 08 2015 10:26:00  $
 *
 * Department:
 *
 * Title: Midw_Diagnostics_FI
 *
 * <b>Description of 'Midw_Diagnostics_FI':</b>
 *
 * ..
 */
class Midw_Diagnostics_FIProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Midw_Diagnostics_FIProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Midw_Diagnostics_FIProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Midw_Diagnostics_FIProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Midw_Diagnostics_FIProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Midw_Diagnostics_FIProxy. The caller has to
     * pass the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Midw_Diagnostics_FIProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Midw_Diagnostics_FIProxy. The destructor will send
     * RelUpReg messages for all property notifications and call the error
     * callback of all pending method invocations.
     */
    ~Midw_Diagnostics_FIProxy();

    // Method 'TestMessage'

    /**
     * Call the method 'TestMessage'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'TestMessage'</b>:
     *
     * The "TestMessage" provides functionality to interprete messages sent by test applications via CCA. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_TESTMESSAGE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = variable
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ProtocolId Select the Protocol Id (MCNET,UDS).
     *
     * @param MessageBuffer Contains MCNET or KWP/UDS test message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTestMessageStart(TestMessageCallbackIF& cb, uint8 protocolId, const ::midw_diagnostics_fi_types::T_MessageBuffer& messageBuffer);

    // Method 'DiagRequest'

    /**
     * Call the method 'DiagRequest'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'DiagRequest'</b>:
     *
     * Diagnosis request to be executed. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_DIAGREQUEST, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = variable
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param protID Specifies the diagnosis protocol used for the diagnosis request (e.g. UDS, GMLAN,...).
     *
     * @param diagData Contains data of the diagnosis request.
     *
     * @param cookie Cookie that is generated by the sender. It is not changed by diagnosis application and is send back with the response.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiagRequestStart(DiagRequestCallbackIF& cb, ::midw_diagnostics_fi_types::T_DiagProtocol protID, const ::midw_diagnostics_fi_types::T_DiagData& diagData, uint32 cookie);

    // Method 'ReadDiagLog'

    /**
     * Call the method 'ReadDiagLog'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'ReadDiagLog'</b>:
     *
     * This method provides functionality for the HMI to read the DTC and ITC from VD_DiagLog. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_READDIAGLOG, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param TroubleCodes Select the type of Trouble Codes to read (DTC or ITC).
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReadDiagLogStart(ReadDiagLogCallbackIF& cb, ::midw_diagnostics_fi_types::T_e8_TroubleCodeType troubleCodes);

    // Method 'ClearDiagLog'

    /**
     * Call the method 'ClearDiagLog'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'ClearDiagLog'</b>:
     *
     * This method provides functionality for the HMI to clear all DTCs in VD_DiagLog. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_CLEARDIAGLOG, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param TroubleCodes Select the type of Trouble Codes to clear.  DTC (customer only) or ITC (customer and production).
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClearDiagLogStart(ClearDiagLogCallbackIF& cb, ::midw_diagnostics_fi_types::T_e8_TroubleCodeType troubleCodes);

    // Method 'StartDiagnosticTest'

    /**
     * Call the method 'StartDiagnosticTest'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'StartDiagnosticTest'</b>:
     *
     * The "Start Test" provides functionality to start the defined test routines. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_STARTDIAGNOSTICTEST, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param TestRoutine Select the test  to run.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartDiagnosticTestStart(StartDiagnosticTestCallbackIF& cb, ::midw_diagnostics_fi_types::T_e8_TestRoutines testRoutine);

    // Method 'SetDefaultSettings'

    /**
     * Call the method 'SetDefaultSettings'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetDefaultSettings'</b>:
     *
     * This method sets default settings for a specified category. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETDEFAULTSETTINGS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param SettingsCategory Category to set default settings for.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetDefaultSettingsStart(SetDefaultSettingsCallbackIF& cb, ::midw_diagnostics_fi_types::T_e8_DefaultSettingsCategories settingsCategory);

    // Method 'EnableTimeSlot'

    /**
     * Call the method 'EnableTimeSlot'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'EnableTimeSlot'</b>:
     *
     * Enables the MAUS setup time slot. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ENABLETIMESLOT, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param MausSetup Enables the MAUS Setup time slot
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEnableTimeSlotStart(EnableTimeSlotCallbackIF& cb, ::midw_diagnostics_fi_types::T_e8_DiagMausSetup mausSetup);

    // Method 'StopDiagnosticTest'

    /**
     * Call the method 'StopDiagnosticTest'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'StopDiagnosticTest'</b>:
     *
     * Provides functionality to stop the specified test routine. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_STOPDIAGNOSTICTEST, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param TestRoutine Select the test  to stop.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStopDiagnosticTestStart(StopDiagnosticTestCallbackIF& cb, ::midw_diagnostics_fi_types::T_e8_TestRoutines testRoutine);

    // Method 'SetFactorySettings'

    /**
     * Call the method 'SetFactorySettings'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetFactorySettings'</b>:
     *
     * This function request the component to set all Variables (depending on USER or TEF) to default
     * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS,</p>
     * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
     * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
     * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
     * <p>The following points have to support by each component:</p>
     * The property answer "SetFactorySettingsStatus" must be available in max 10 sec over all Components, else a Timeout occurred.
     * The Answer SetFactorySettings MessageResult must be send immediately.
     * The command must accept a new reuqest if the process is still running. The Component itself must decide what to do. Normaly the component itself have do decide if it has to retrigger or wait for the last answer. Independend of that it has to confirm the new request.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DefSetStateGroup Identifier of the Default Setting Group.
     *
     * @param DefSetStateMode TEF or USER
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetFactorySettingsStart(SetFactorySettingsCallbackIF& cb, uint8 defSetStateGroup, ::midw_diagnostics_fi_types::T_e8_DefSetMode defSetStateMode);

    // Method 'SetResetToSupplierDefaultConfig'

    /**
     * Call the method 'SetResetToSupplierDefaultConfig'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetResetToSupplierDefaultConfig'</b>:
     *
     * This function request the component to set all Variables (depending on USER or TEF) to default
     * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS,</p>
     * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
     * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
     * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
     * <p>The following points have to support by each component:</p>
     * The property answer "SetResetToSupplierDefaultConfigStatus" must be available in max 10 sec over all Components, else a Timeout occurred.
     * The Answer SetResetToSupplierDefaultConfig MessageResult must be send immediately.
     * The command must accept a new reuqest if the process is still running. The Component itself must decide what to do. Normaly the component itself have do decide if it has to retrigger or wait for the last answer. Independend of that it has to confirm the new request.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ResetSupplierConfig Identifier of the Supplier Default Config.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetResetToSupplierDefaultConfigStart(SetResetToSupplierDefaultConfigCallbackIF& cb, uint8 resetSupplierConfig);

    // Method 'SetRunTimeSourceData'

    /**
     * Call the method 'SetRunTimeSourceData'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetRunTimeSourceData'</b>:
     *
     * This function request the component to set all Variables (depending on USER or TEF) to default
     * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS,</p>
     * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
     * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
     * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
     * <p>The following points have to support by each component:</p>
     * The property answer "SetRunTimeSourceData" must be available in max 10 sec over all Components, else a Timeout occurred.
     * The Answer SetRunTimeSourceData MessageResult must be send immediately.
     * The commponent must accept a new request if the process is still running. The Component itself must decide what to do. Normaly the component itself have do decide if it has to retrigger or wait for the last answer. Independent of that it has to confirm the new request.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param RunTimeSourceAppID Identifier of the RunTime Source Application CCA Id.
     *
     * @param RunTimeSourceAppData Identifier of the RunTime Source App Data.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetRunTimeSourceDataStart(SetRunTimeSourceDataCallbackIF& cb, uint16 runTimeSourceAppID, uint32 runTimeSourceAppData);

    // Method 'SetFactorySettingsNew'

    /**
     * Call the method 'SetFactorySettingsNew'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetFactorySettingsNew'</b>:
     *
     * This function request the component to set all Variables (depending on USER, TEF or OEM) to default
     * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS,</p>
     * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
     * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
     * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
     * <p>The following points have to support by each component:</p>
     * The property answer "SetFactorySettingsStatus" must be available in max 10 sec over all Components, else a Timeout occurred.
     * The Answer SetFactorySettings MessageResult must be send immediately.
     * The command must accept a new reuqest if the process is still running. The Component itself must decide what to do. Normaly the component itself have do decide if it has to retrigger or wait for the last answer. Independend of that it has to confirm the new request.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DefSetStateGroup Identifier of the Default Setting Group.
     *
     * @param DefSetStateMode current Default Setting Id.
     * <p>E.g. USER, TEF, OEM, GET</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetFactorySettingsNewStart(SetFactorySettingsNewCallbackIF& cb, uint8 defSetStateGroup, ::midw_diagnostics_fi_types::T_e8_DefSetMode defSetStateMode);

    // Method 'StartCalibrationSession'

    /**
     * Call the method 'StartCalibrationSession'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'StartCalibrationSession'</b>:
     *
     * Starts a calibration Session for the given table.
     * <p>E.g. SYSTEM, BLUETOOTH, BRAND,...</p>
     * <p>Internally the Diagnosis component loads the table from the EOLLib to a RAM buffer.</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Table The calibration table according to GIS-344 for which parameters will be changed.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartCalibrationSessionStart(StartCalibrationSessionCallbackIF& cb, ::midw_diagnostics_fi_types::T_e8_CalibrationTable table);

    // Method 'StopCalibrationSession'

    /**
     * Call the method 'StopCalibrationSession'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'StopCalibrationSession'</b>:
     *
     * Stops a calibration Session for the given table.
     * <p>E.g. SYSTEM, BLUETOOTH, BRAND,...</p>
     * <p>Internally the Diagnosis component saves the table from the RAM buffer to the EOLLib. After this all components are notified about a SystemSet concerning the calibration table.</p>
     * <p>If an error is detected while writing to the EOLLib or executing the SystemSet, an Error Message is returned.</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param SessionHandle Handle to the session for all pending operations.
     *
     * @param TimeStamp Timestamp of last interaction. This is only saved if there was at least one Set operation on
     * the CalibrationParameter property.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStopCalibrationSessionStart(StopCalibrationSessionCallbackIF& cb, uint32 sessionHandle, const ::midw_diagnostics_fi_types::T_CalibrationTimeStamp& timeStamp);

    // Property 'StartRouteCalculation'

    /**
     * Notify on the property 'StartRouteCalculation'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'StartRouteCalculation'</b>:
     *
     * The route calculation can be started via this property. The client has to register for the property. The route calculation is started via the status message. The start of the route calculation is confirmed via  the set message. The result of the route calculation can be get via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_STARTROUTECALCULATION, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartRouteCalculationUpReg(StartRouteCalculationCallbackIF& cb);

    /**
     * Remove the notifcation on property 'StartRouteCalculation'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'StartRouteCalculation'</b>:
     *
     * The route calculation can be started via this property. The client has to register for the property. The route calculation is started via the status message. The start of the route calculation is confirmed via  the set message. The result of the route calculation can be get via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_STARTROUTECALCULATION, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendStartRouteCalculationUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendStartRouteCalculationRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'StartRouteCalculation'.
     */
    void sendStartRouteCalculationRelUpRegAll ();

    /**
     * Returns the current value of the property 'StartRouteCalculation' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasStartRouteCalculation() returns true.
     *
     * @return the previously received value of the property 'StartRouteCalculation'.
     */
    const StartRouteCalculationStatus& getStartRouteCalculation() const;

    /**
     * Determines whether a status message for the property 'StartRouteCalculation' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasStartRouteCalculation() const;

    /**
     * Set the value of the property 'StartRouteCalculation'. This method
     * sends a Set message to the CCA server.
     *
     * <b>Documentation of 'StartRouteCalculation'</b>:
     *
     * The route calculation can be started via this property. The client has to register for the property. The route calculation is started via the status message. The start of the route calculation is confirmed via  the set message. The result of the route calculation can be get via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_STARTROUTECALCULATION, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param CalculationStarted Pass the confirmation of the route calculation start to FC diagnosis.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartRouteCalculationSet(StartRouteCalculationCallbackIF& cb, bool calculationStarted);

    // Property 'RouteCalculationResult'

    /**
     * Notify on the property 'RouteCalculationResult'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'RouteCalculationResult'</b>:
     *
     * The result of the route calculation is handled via this property. The result is passed via the set message. The route calculation is started via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ROUTECALCULATIONRESULT, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRouteCalculationResultUpReg(RouteCalculationResultCallbackIF& cb);

    /**
     * Remove the notifcation on property 'RouteCalculationResult'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'RouteCalculationResult'</b>:
     *
     * The result of the route calculation is handled via this property. The result is passed via the set message. The route calculation is started via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ROUTECALCULATIONRESULT, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendRouteCalculationResultUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendRouteCalculationResultRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'RouteCalculationResult'.
     */
    void sendRouteCalculationResultRelUpRegAll ();

    /**
     * Returns the current value of the property 'RouteCalculationResult' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasRouteCalculationResult() returns true.
     *
     * @return the previously received value of the property 'RouteCalculationResult'.
     */
    const RouteCalculationResultStatus& getRouteCalculationResult() const;

    /**
     * Determines whether a status message for the property 'RouteCalculationResult' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRouteCalculationResult() const;

    /**
     * Set the value of the property 'RouteCalculationResult'. This method
     * sends a Set message to the CCA server.
     *
     * <b>Documentation of 'RouteCalculationResult'</b>:
     *
     * The result of the route calculation is handled via this property. The result is passed via the set message. The route calculation is started via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ROUTECALCULATIONRESULT, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param CalculationResult Return result of route calculation, length of route and time to destination.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRouteCalculationResultSet(RouteCalculationResultCallbackIF& cb, const ::midw_diagnostics_fi_types::T_RouteCalculationResultParameter& calculationResult);

    // Property 'SetLocaleStart'

    /**
     * Notify on the property 'SetLocaleStart'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'SetLocaleStart'</b>:
     *
     * The locale (country and language) can be set via this property. The client has to register for the property. The locale is set via the status message. The start of the locale switch is confirmed via  the set message. The result of the locale switch can be get via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETLOCALESTART, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetLocaleStartUpReg(SetLocaleStartCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SetLocaleStart'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SetLocaleStart'</b>:
     *
     * The locale (country and language) can be set via this property. The client has to register for the property. The locale is set via the status message. The start of the locale switch is confirmed via  the set message. The result of the locale switch can be get via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETLOCALESTART, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendSetLocaleStartUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSetLocaleStartRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SetLocaleStart'.
     */
    void sendSetLocaleStartRelUpRegAll ();

    /**
     * Returns the current value of the property 'SetLocaleStart' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSetLocaleStart() returns true.
     *
     * @return the previously received value of the property 'SetLocaleStart'.
     */
    const SetLocaleStartStatus& getSetLocaleStart() const;

    /**
     * Determines whether a status message for the property 'SetLocaleStart' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSetLocaleStart() const;

    /**
     * Set the value of the property 'SetLocaleStart'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'SetLocaleStart'</b>:
     *
     * The locale (country and language) can be set via this property. The client has to register for the property. The locale is set via the status message. The start of the locale switch is confirmed via  the set message. The result of the locale switch can be get via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETLOCALESTART, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param LocaleSwitched Pass the confirmation of the locale switch start to FC diagnosis.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetLocaleStartSet(SetLocaleStartCallbackIF& cb, bool localeSwitched);

    // Property 'SetLocaleResult'

    /**
     * Notify on the property 'SetLocaleResult'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'SetLocaleResult'</b>:
     *
     * The result of the locale (country and language) switch is handled via this property. The result is passed via the set message. The switch of the locale is started via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETLOCALERESULT, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetLocaleResultUpReg(SetLocaleResultCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SetLocaleResult'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SetLocaleResult'</b>:
     *
     * The result of the locale (country and language) switch is handled via this property. The result is passed via the set message. The switch of the locale is started via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETLOCALERESULT, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendSetLocaleResultUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSetLocaleResultRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SetLocaleResult'.
     */
    void sendSetLocaleResultRelUpRegAll ();

    /**
     * Returns the current value of the property 'SetLocaleResult' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSetLocaleResult() returns true.
     *
     * @return the previously received value of the property 'SetLocaleResult'.
     */
    const SetLocaleResultStatus& getSetLocaleResult() const;

    /**
     * Determines whether a status message for the property 'SetLocaleResult' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSetLocaleResult() const;

    /**
     * Set the value of the property 'SetLocaleResult'. This method sends a
     * Set message to the CCA server.
     *
     * <b>Documentation of 'SetLocaleResult'</b>:
     *
     * The result of the locale (country and language) switch is handled via this property. The result is passed via the set message. The switch of the locale is started via separate property. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETLOCALERESULT, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param CountryLanguageResult Returns result of locale switch and the locales currently set.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetLocaleResultSet(SetLocaleResultCallbackIF& cb, const ::midw_diagnostics_fi_types::T_CountryLanguageResult& countryLanguageResult);

    // Property 'GetLocale'

    /**
     * Notify on the property 'GetLocale'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'GetLocale'</b>:
     *
     * The locale (country and language) can be obtained via this property. The client has to register for the property. The locale is passed to the HMI via the status message.  The result for the get operation is received via set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_GETLOCALE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetLocaleUpReg(GetLocaleCallbackIF& cb);

    /**
     * Remove the notifcation on property 'GetLocale'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'GetLocale'</b>:
     *
     * The locale (country and language) can be obtained via this property. The client has to register for the property. The locale is passed to the HMI via the status message.  The result for the get operation is received via set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_GETLOCALE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendGetLocaleUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendGetLocaleRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'GetLocale'.
     */
    void sendGetLocaleRelUpRegAll ();

    /**
     * Returns the current value of the property 'GetLocale' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasGetLocale()
     * returns true.
     *
     * @return the previously received value of the property 'GetLocale'.
     */
    const GetLocaleStatus& getGetLocale() const;

    /**
     * Determines whether a status message for the property 'GetLocale' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasGetLocale() const;

    /**
     * Set the value of the property 'GetLocale'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'GetLocale'</b>:
     *
     * The locale (country and language) can be obtained via this property. The client has to register for the property. The locale is passed to the HMI via the status message.  The result for the get operation is received via set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_GETLOCALE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param CountryLanguage Pass  the locale to FC diagnosis.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetLocaleSet(GetLocaleCallbackIF& cb, const ::midw_diagnostics_fi_types::T_CountryLanguage& countryLanguage);

    // Property 'SetDisplay'

    /**
     * Notify on the property 'SetDisplay'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'SetDisplay'</b>:
     *
     * The test pictures and the diagnostics screen can be set via this property. The client has to register for the property. The display to be used is passed to the HMI via the Status message. The result of the operation is recived via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETDISPLAY, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetDisplayUpReg(SetDisplayCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SetDisplay'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SetDisplay'</b>:
     *
     * The test pictures and the diagnostics screen can be set via this property. The client has to register for the property. The display to be used is passed to the HMI via the Status message. The result of the operation is recived via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETDISPLAY, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendSetDisplayUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSetDisplayRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SetDisplay'.
     */
    void sendSetDisplayRelUpRegAll ();

    /**
     * Returns the current value of the property 'SetDisplay' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasSetDisplay() returns true.
     *
     * @return the previously received value of the property 'SetDisplay'.
     */
    const SetDisplayStatus& getSetDisplay() const;

    /**
     * Determines whether a status message for the property 'SetDisplay' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSetDisplay() const;

    /**
     * Set the value of the property 'SetDisplay'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'SetDisplay'</b>:
     *
     * The test pictures and the diagnostics screen can be set via this property. The client has to register for the property. The display to be used is passed to the HMI via the Status message. The result of the operation is recived via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETDISPLAY, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param DisplayTestSuccess Result of displaying test screen.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetDisplaySet(SetDisplayCallbackIF& cb, bool displayTestSuccess);

    // Property 'ConfigUpdateViaUSB'

    /**
     * Notify on the property 'ConfigUpdateViaUSB'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'ConfigUpdateViaUSB'</b>:
     *
     * HMI support to show the status of configuration update through USB- Config update start status, when config file found for the particular variant- Upon config items write, trigger for hash calculation
     * - Show config update success or failure message - Display Restart the system message, if config hash is successful otherwise display update config once again message.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConfigUpdateViaUSBUpReg(ConfigUpdateViaUSBCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ConfigUpdateViaUSB'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ConfigUpdateViaUSB'</b>:
     *
     * HMI support to show the status of configuration update through USB- Config update start status, when config file found for the particular variant- Upon config items write, trigger for hash calculation
     * - Show config update success or failure message - Display Restart the system message, if config hash is successful otherwise display update config once again message.
     *
     * @param act The act which was previously returned by the
     * sendConfigUpdateViaUSBUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendConfigUpdateViaUSBRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ConfigUpdateViaUSB'.
     */
    void sendConfigUpdateViaUSBRelUpRegAll ();

    /**
     * Returns the current value of the property 'ConfigUpdateViaUSB' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasConfigUpdateViaUSB() returns true.
     *
     * @return the previously received value of the property 'ConfigUpdateViaUSB'.
     */
    const ConfigUpdateViaUSBStatus& getConfigUpdateViaUSB() const;

    /**
     * Determines whether a status message for the property 'ConfigUpdateViaUSB' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasConfigUpdateViaUSB() const;

    // Property 'AntiTheftStatus'

    /**
     * Notify on the property 'AntiTheftStatus'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'AntiTheftStatus'</b>:
     *
     * Get status of Anti theft status. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ANTITHEFTSTATUS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAntiTheftStatusUpReg(AntiTheftStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AntiTheftStatus'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AntiTheftStatus'</b>:
     *
     * Get status of Anti theft status. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ANTITHEFTSTATUS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendAntiTheftStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAntiTheftStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AntiTheftStatus'.
     */
    void sendAntiTheftStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'AntiTheftStatus' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAntiTheftStatus() returns true.
     *
     * @return the previously received value of the property 'AntiTheftStatus'.
     */
    const AntiTheftStatusStatus& getAntiTheftStatus() const;

    /**
     * Determines whether a status message for the property 'AntiTheftStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAntiTheftStatus() const;

    /**
     * Set the value of the property 'AntiTheftStatus'. This method sends a
     * Set message to the CCA server.
     *
     * <b>Documentation of 'AntiTheftStatus'</b>:
     *
     * Get status of Anti theft status. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ANTITHEFTSTATUS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param AntiTheftStatus Get status of Antitheft.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAntiTheftStatusSet(AntiTheftStatusCallbackIF& cb, ::midw_diagnostics_fi_types::T_AntiTheftStatus antiTheftStatus);

    // Property 'AntiTheftUnlockHMI'

    /**
     * Notify on the property 'AntiTheftUnlockHMI'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'AntiTheftUnlockHMI'</b>:
     *
     * Unlock HMI if VID write success in Antitheft sequence.. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ANTITHEFT_UNLOCKHMI, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAntiTheftUnlockHMIUpReg(AntiTheftUnlockHMICallbackIF& cb);

    /**
     * Remove the notifcation on property 'AntiTheftUnlockHMI'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AntiTheftUnlockHMI'</b>:
     *
     * Unlock HMI if VID write success in Antitheft sequence.. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ANTITHEFT_UNLOCKHMI, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendAntiTheftUnlockHMIUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAntiTheftUnlockHMIRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AntiTheftUnlockHMI'.
     */
    void sendAntiTheftUnlockHMIRelUpRegAll ();

    /**
     * Returns the current value of the property 'AntiTheftUnlockHMI' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAntiTheftUnlockHMI() returns true.
     *
     * @return the previously received value of the property 'AntiTheftUnlockHMI'.
     */
    const AntiTheftUnlockHMIStatus& getAntiTheftUnlockHMI() const;

    /**
     * Determines whether a status message for the property 'AntiTheftUnlockHMI' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAntiTheftUnlockHMI() const;

    /**
     * Set the value of the property 'AntiTheftUnlockHMI'. This method sends a
     * Set message to the CCA server.
     *
     * <b>Documentation of 'AntiTheftUnlockHMI'</b>:
     *
     * Unlock HMI if VID write success in Antitheft sequence.. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ANTITHEFT_UNLOCKHMI, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAntiTheftUnlockHMISet(AntiTheftUnlockHMICallbackIF& cb);

    // Property 'AntiTheftUnlockHU'

    /**
     * Notify on the property 'AntiTheftUnlockHU'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'AntiTheftUnlockHU'</b>:
     *
     * Unlock HU if PIN Validation success in Antitheft sequence. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ANTITHEFT_UNLOCKHU, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAntiTheftUnlockHUUpReg(AntiTheftUnlockHUCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AntiTheftUnlockHU'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AntiTheftUnlockHU'</b>:
     *
     * Unlock HU if PIN Validation success in Antitheft sequence. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ANTITHEFT_UNLOCKHU, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendAntiTheftUnlockHUUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAntiTheftUnlockHURelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AntiTheftUnlockHU'.
     */
    void sendAntiTheftUnlockHURelUpRegAll ();

    /**
     * Returns the current value of the property 'AntiTheftUnlockHU' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAntiTheftUnlockHU() returns true.
     *
     * @return the previously received value of the property 'AntiTheftUnlockHU'.
     */
    const AntiTheftUnlockHUStatus& getAntiTheftUnlockHU() const;

    /**
     * Determines whether a status message for the property 'AntiTheftUnlockHU' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAntiTheftUnlockHU() const;

    /**
     * Set the value of the property 'AntiTheftUnlockHU'. This method sends a
     * Set message to the CCA server.
     *
     * <b>Documentation of 'AntiTheftUnlockHU'</b>:
     *
     * Unlock HU if PIN Validation success in Antitheft sequence. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_ANTITHEFT_UNLOCKHU, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAntiTheftUnlockHUSet(AntiTheftUnlockHUCallbackIF& cb);

    // Property 'ClearDestinationMemory'

    /**
     * Notify on the property 'ClearDestinationMemory'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'ClearDestinationMemory'</b>:
     *
     * Destination memory can be erased using this property. The client has to register for the property.  The result of the operation is recived via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_CLEARDESTINATIONMEMORY, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClearDestinationMemoryUpReg(ClearDestinationMemoryCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ClearDestinationMemory'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ClearDestinationMemory'</b>:
     *
     * Destination memory can be erased using this property. The client has to register for the property.  The result of the operation is recived via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_CLEARDESTINATIONMEMORY, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendClearDestinationMemoryUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendClearDestinationMemoryRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ClearDestinationMemory'.
     */
    void sendClearDestinationMemoryRelUpRegAll ();

    /**
     * Returns the current value of the property 'ClearDestinationMemory' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasClearDestinationMemory() returns true.
     *
     * @return the previously received value of the property 'ClearDestinationMemory'.
     */
    const ClearDestinationMemoryStatus& getClearDestinationMemory() const;

    /**
     * Determines whether a status message for the property 'ClearDestinationMemory' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasClearDestinationMemory() const;

    /**
     * Set the value of the property 'ClearDestinationMemory'. This method
     * sends a Set message to the CCA server.
     *
     * <b>Documentation of 'ClearDestinationMemory'</b>:
     *
     * Destination memory can be erased using this property. The client has to register for the property.  The result of the operation is recived via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_CLEARDESTINATIONMEMORY, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param ClearMemorySuccess Result of clear operation.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClearDestinationMemorySet(ClearDestinationMemoryCallbackIF& cb, bool clearMemorySuccess);

    // Property 'GetDestinationMemorySize'

    /**
     * Notify on the property 'GetDestinationMemorySize'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'GetDestinationMemorySize'</b>:
     *
     * The current size of the destination memory can be obtained using this property. The client has to register for the property.  The result of the operation is recived via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_GETDESTINATIONMEMORYSIZE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetDestinationMemorySizeUpReg(GetDestinationMemorySizeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'GetDestinationMemorySize'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'GetDestinationMemorySize'</b>:
     *
     * The current size of the destination memory can be obtained using this property. The client has to register for the property.  The result of the operation is recived via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_GETDESTINATIONMEMORYSIZE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendGetDestinationMemorySizeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendGetDestinationMemorySizeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'GetDestinationMemorySize'.
     */
    void sendGetDestinationMemorySizeRelUpRegAll ();

    /**
     * Returns the current value of the property 'GetDestinationMemorySize'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasGetDestinationMemorySize() returns true.
     *
     * @return the previously received value of the property 'GetDestinationMemorySize'.
     */
    const GetDestinationMemorySizeStatus& getGetDestinationMemorySize() const;

    /**
     * Determines whether a status message for the property 'GetDestinationMemorySize' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasGetDestinationMemorySize() const;

    /**
     * Set the value of the property 'GetDestinationMemorySize'. This method
     * sends a Set message to the CCA server.
     *
     * <b>Documentation of 'GetDestinationMemorySize'</b>:
     *
     * The current size of the destination memory can be obtained using this property. The client has to register for the property.  The result of the operation is recived via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_GETDESTINATIONMEMORYSIZE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param RecordCount No of records in the destination memory.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetDestinationMemorySizeSet(GetDestinationMemorySizeCallbackIF& cb, uint16 recordCount);

    // Property 'SimulateKeyPress'

    /**
     * Notify on the property 'SimulateKeyPress'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'SimulateKeyPress'</b>:
     *
     * Instructs the HMI to simulate a key press. The client has to register for the property.  The result of the operation is received via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SIMULATEKEYPRESS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSimulateKeyPressUpReg(SimulateKeyPressCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SimulateKeyPress'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SimulateKeyPress'</b>:
     *
     * Instructs the HMI to simulate a key press. The client has to register for the property.  The result of the operation is received via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SIMULATEKEYPRESS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendSimulateKeyPressUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSimulateKeyPressRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SimulateKeyPress'.
     */
    void sendSimulateKeyPressRelUpRegAll ();

    /**
     * Returns the current value of the property 'SimulateKeyPress' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSimulateKeyPress() returns true.
     *
     * @return the previously received value of the property 'SimulateKeyPress'.
     */
    const SimulateKeyPressStatus& getSimulateKeyPress() const;

    /**
     * Determines whether a status message for the property 'SimulateKeyPress' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSimulateKeyPress() const;

    /**
     * Set the value of the property 'SimulateKeyPress'. This method sends a
     * Set message to the CCA server.
     *
     * <b>Documentation of 'SimulateKeyPress'</b>:
     *
     * Instructs the HMI to simulate a key press. The client has to register for the property.  The result of the operation is received via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SIMULATEKEYPRESS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param KeyPressSuccess Indicates success or failure of key press.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSimulateKeyPressSet(SimulateKeyPressCallbackIF& cb, bool keyPressSuccess);

    // Property 'ResetSecurity'

    /**
     * Notify on the property 'ResetSecurity'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'ResetSecurity'</b>:
     *
     * Instructs the HMI to perform a security reset. E.g. reset the number of unsuccessful password entries. The client has to register for the property.  The result of the operation is received via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_RESETSECURITY, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendResetSecurityUpReg(ResetSecurityCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ResetSecurity'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ResetSecurity'</b>:
     *
     * Instructs the HMI to perform a security reset. E.g. reset the number of unsuccessful password entries. The client has to register for the property.  The result of the operation is received via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_RESETSECURITY, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendResetSecurityUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendResetSecurityRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ResetSecurity'.
     */
    void sendResetSecurityRelUpRegAll ();

    /**
     * Returns the current value of the property 'ResetSecurity' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasResetSecurity() returns true.
     *
     * @return the previously received value of the property 'ResetSecurity'.
     */
    const ResetSecurityStatus& getResetSecurity() const;

    /**
     * Determines whether a status message for the property 'ResetSecurity' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasResetSecurity() const;

    /**
     * Set the value of the property 'ResetSecurity'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'ResetSecurity'</b>:
     *
     * Instructs the HMI to perform a security reset. E.g. reset the number of unsuccessful password entries. The client has to register for the property.  The result of the operation is received via the Set message. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_RESETSECURITY, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param ResetSuccess Indicates success or failure of security reset.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendResetSecuritySet(ResetSecurityCallbackIF& cb, bool resetSuccess);

    // Property 'Language'

    /**
     * Notify on the property 'Language'. This method sends a UpReg message to
     * the CCA server.
     *
     * <b>Documentation of 'Language'</b>:
     *
     * Vehicle type. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_LANGUAGE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLanguageUpReg(LanguageCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Language'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Language'</b>:
     *
     * Vehicle type. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_LANGUAGE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendLanguageUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendLanguageRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Language'.
     */
    void sendLanguageRelUpRegAll ();

    /**
     * Returns the current value of the property 'Language' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasLanguage()
     * returns true.
     *
     * @return the previously received value of the property 'Language'.
     */
    const LanguageStatus& getLanguage() const;

    /**
     * Determines whether a status message for the property 'Language' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasLanguage() const;

    /**
     * Request the value of the property 'Language' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Language'</b>:
     *
     * Vehicle type. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_LANGUAGE, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     * @param Language Language
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLanguageGet(LanguageCallbackIF& cb, ::midw_diagnostics_fi_types::T_e16_Language language);

    // Property 'SpeedLock'

    /**
     * Notify on the property 'SpeedLock'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'SpeedLock'</b>:
     *
     * Get Speed Lock value and Threshold from Diagnosis. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SPEEDLOCK,
     * SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSpeedLockUpReg(SpeedLockCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SpeedLock'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SpeedLock'</b>:
     *
     * Get Speed Lock value and Threshold from Diagnosis. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SPEEDLOCK,
     * SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendSpeedLockUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSpeedLockRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SpeedLock'.
     */
    void sendSpeedLockRelUpRegAll ();

    /**
     * Returns the current value of the property 'SpeedLock' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasSpeedLock()
     * returns true.
     *
     * @return the previously received value of the property 'SpeedLock'.
     */
    const SpeedLockStatus& getSpeedLock() const;

    /**
     * Determines whether a status message for the property 'SpeedLock' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSpeedLock() const;

    /**
     * Request the value of the property 'SpeedLock' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SpeedLock'</b>:
     *
     * Get Speed Lock value and Threshold from Diagnosis. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SPEEDLOCK,
     * SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     * @param SpeedLock Speed Lock
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSpeedLockGet(SpeedLockCallbackIF& cb, ::midw_diagnostics_fi_types::T_e16_SpeedLock speedLock);

    // Property 'SpdLock'

    /**
     * Notify on the property 'SpdLock'. This method sends a UpReg message to
     * the CCA server.
     *
     * <b>Documentation of 'SpdLock'</b>:
     *
     * Activate Speed Lock via HMI where FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SPEEDLOCK,
     * SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSpdLockUpReg(SpdLockCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SpdLock'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SpdLock'</b>:
     *
     * Activate Speed Lock via HMI where FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SPEEDLOCK,
     * SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendSpdLockUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSpdLockRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SpdLock'.
     */
    void sendSpdLockRelUpRegAll ();

    /**
     * Returns the current value of the property 'SpdLock' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasSpdLock()
     * returns true.
     *
     * @return the previously received value of the property 'SpdLock'.
     */
    const SpdLockStatus& getSpdLock() const;

    /**
     * Determines whether a status message for the property 'SpdLock' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSpdLock() const;

    /**
     * Set the value of the property 'SpdLock'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'SpdLock'</b>:
     *
     * Activate Speed Lock via HMI where FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SPEEDLOCK,
     * SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param SpeedLock Speed lock Req Data from HMI
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSpdLockSet(SpdLockCallbackIF& cb, ::midw_diagnostics_fi_types::T_e16_SpeedLock speedLock);

    // Property 'SetRVCSignal'

    /**
     * Notify on the property 'SetRVCSignal'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'SetRVCSignal'</b>:
     *
     * Set RVC Video Signal on or off. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETRVCSIGNAL, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetRVCSignalUpReg(SetRVCSignalCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SetRVCSignal'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SetRVCSignal'</b>:
     *
     * Set RVC Video Signal on or off. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETRVCSIGNAL, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendSetRVCSignalUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSetRVCSignalRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SetRVCSignal'.
     */
    void sendSetRVCSignalRelUpRegAll ();

    /**
     * Returns the current value of the property 'SetRVCSignal' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSetRVCSignal() returns true.
     *
     * @return the previously received value of the property 'SetRVCSignal'.
     */
    const SetRVCSignalStatus& getSetRVCSignal() const;

    /**
     * Determines whether a status message for the property 'SetRVCSignal' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSetRVCSignal() const;

    /**
     * Request the value of the property 'SetRVCSignal' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SetRVCSignal'</b>:
     *
     * Set RVC Video Signal on or off. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETRVCSIGNAL, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     * @param SignalStatus Status of External Video signal to be set
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetRVCSignalGet(SetRVCSignalCallbackIF& cb, ::midw_diagnostics_fi_types::T_e8_DiagRVCSignal signalStatus);

    /**
     * Set the value of the property 'SetRVCSignal'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'SetRVCSignal'</b>:
     *
     * Set RVC Video Signal on or off. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_SETRVCSIGNAL, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param StatusChanged Indicates status change successfully carried out
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetRVCSignalSet(SetRVCSignalCallbackIF& cb, bool statusChanged);

    // Property 'RVCSignalStatus'

    /**
     * Notify on the property 'RVCSignalStatus'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'RVCSignalStatus'</b>:
     *
     * Interrogate status of RVC Video Signal. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_RVCSIGNALSTATUS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRVCSignalStatusUpReg(RVCSignalStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'RVCSignalStatus'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'RVCSignalStatus'</b>:
     *
     * Interrogate status of RVC Video Signal. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_RVCSIGNALSTATUS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendRVCSignalStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendRVCSignalStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'RVCSignalStatus'.
     */
    void sendRVCSignalStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'RVCSignalStatus' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasRVCSignalStatus() returns true.
     *
     * @return the previously received value of the property 'RVCSignalStatus'.
     */
    const RVCSignalStatusStatus& getRVCSignalStatus() const;

    /**
     * Determines whether a status message for the property 'RVCSignalStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRVCSignalStatus() const;

    /**
     * Set the value of the property 'RVCSignalStatus'. This method sends a
     * Set message to the CCA server.
     *
     * <b>Documentation of 'RVCSignalStatus'</b>:
     *
     * Interrogate status of RVC Video Signal. FUNCID = MIDW_DIAGNOSTICSFI_C_U16_RVCSIGNALSTATUS, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param SignalStatus Status of External Video signal
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRVCSignalStatusSet(RVCSignalStatusCallbackIF& cb, ::midw_diagnostics_fi_types::T_e8_DiagRVCSignal signalStatus);

    // Property 'KdsEntry'

    /**
     * Notify on the property 'KdsEntry'. This method sends a UpReg message to
     * the CCA server.
     *
     * <b>Documentation of 'KdsEntry'</b>:
     *
     * This property allowed to read a KDS entry.
     * FUNCID = 0x60, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     * @param KdsEntry KDS entry for which has to be registered.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendKdsEntryUpReg(KdsEntryCallbackIF& cb, uint32 kdsEntry);

    /**
     * Remove the notifcation on property 'KdsEntry'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'KdsEntry'</b>:
     *
     * This property allowed to read a KDS entry.
     * FUNCID = 0x60, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendKdsEntryUpReg() method.
     *
     * @param KdsEntry KDS entry for which has to be registered.
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendKdsEntryRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'KdsEntry'.
     */
    void sendKdsEntryRelUpRegAll ();

    /**
     * Returns the current value of the property 'KdsEntry' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasKdsEntry(uint32 kdsEntry) returns true.
     *
     * @return the previously received value of the property 'KdsEntry'.
     */
    const KdsEntryStatus& getKdsEntry(uint32 kdsEntry) const;

    /**
     * Determines whether a status message for the property 'KdsEntry' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasKdsEntry(uint32 kdsEntry) const;

    /**
     * Request the value of the property 'KdsEntry' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'KdsEntry'</b>:
     *
     * This property allowed to read a KDS entry.
     * FUNCID = 0x60, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     * @param KdsEntry KDS entry which has to be read.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendKdsEntryGet(KdsEntryCallbackIF& cb, uint32 kdsEntry);

    /**
     * Set the value of the property 'KdsEntry'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'KdsEntry'</b>:
     *
     * This property allowed to read a KDS entry.
     * FUNCID = 0x60, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param KdsEntry KDS entry which shall be written (diagnosis will check if the sending application is allowed to write the given KDS key).
     *
     * @param KdsDataList Data of KDS entry.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendKdsEntrySet(KdsEntryCallbackIF& cb, uint32 kdsEntry, const ::midw_diagnostics_fi_types::T_KDSItemList& kdsDataList);

    // Property 'DiagConfigItem'

    /**
     * Notify on the property 'DiagConfigItem'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DiagConfigItem'</b>:
     *
     * This property allowed to read diagnosis internal configuration items. Thereby it doesn't matter if they are in KDS, Registry, RAM or GPIO.
     * FUNCID = 0x61, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     * @param ConfigItem Entry for which has to be registered.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiagConfigItemUpReg(DiagConfigItemCallbackIF& cb, uint32 configItem);

    /**
     * Remove the notifcation on property 'DiagConfigItem'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiagConfigItem'</b>:
     *
     * This property allowed to read diagnosis internal configuration items. Thereby it doesn't matter if they are in KDS, Registry, RAM or GPIO.
     * FUNCID = 0x61, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param act The act which was previously returned by the
     * sendDiagConfigItemUpReg() method.
     *
     * @param ConfigItem Entry for which has to be registered.
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiagConfigItemRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiagConfigItem'.
     */
    void sendDiagConfigItemRelUpRegAll ();

    /**
     * Returns the current value of the property 'DiagConfigItem' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDiagConfigItem(uint32 configItem) returns true.
     *
     * @return the previously received value of the property 'DiagConfigItem'.
     */
    const DiagConfigItemStatus& getDiagConfigItem(uint32 configItem) const;

    /**
     * Determines whether a status message for the property 'DiagConfigItem'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiagConfigItem(uint32 configItem) const;

    /**
     * Request the value of the property 'DiagConfigItem' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DiagConfigItem'</b>:
     *
     * This property allowed to read diagnosis internal configuration items. Thereby it doesn't matter if they are in KDS, Registry, RAM or GPIO.
     * FUNCID = 0x61, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     * @param ConfigItem Entry which has to be read.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiagConfigItemGet(DiagConfigItemCallbackIF& cb, uint32 configItem);

    /**
     * Set the value of the property 'DiagConfigItem'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'DiagConfigItem'</b>:
     *
     * This property allowed to read diagnosis internal configuration items. Thereby it doesn't matter if they are in KDS, Registry, RAM or GPIO.
     * FUNCID = 0x61, SERVICEID = CCA_C_U16_SRV_DIAGDEBUG, APPID = CCA_C_U16_APP_FC_DIAGNOSIS, TARGETID = CCA_C_U16_APP_UI
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param ConfigItem Changed Config Item.
     *
     * @param ConfigItemContent New data of ConfigItem entry.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiagConfigItemSet(DiagConfigItemCallbackIF& cb, uint32 configItem, const ::midw_diagnostics_fi_types::T_ConfigItemList& configItemContent);

    // Property 'SetFactorySettingsStatus'

    /**
     * Notify on the property 'SetFactorySettingsStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'SetFactorySettingsStatus'</b>:
     *
     * This property gives information about the actual DefSetState, it is TRUE if all parameters are in Default State.
     * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS_STATUS,</p>
     * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
     * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
     * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
     * <p>the Identifier for "DefSetStateFirstDifferentParameterId" will be found in the Doors "/Ford HS-LSRNS Dev/System Specification/Parameter Dictionary" Document</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetFactorySettingsStatusUpReg(SetFactorySettingsStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SetFactorySettingsStatus'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SetFactorySettingsStatus'</b>:
     *
     * This property gives information about the actual DefSetState, it is TRUE if all parameters are in Default State.
     * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS_STATUS,</p>
     * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
     * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
     * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
     * <p>the Identifier for "DefSetStateFirstDifferentParameterId" will be found in the Doors "/Ford HS-LSRNS Dev/System Specification/Parameter Dictionary" Document</p>
     *
     * @param act The act which was previously returned by the
     * sendSetFactorySettingsStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSetFactorySettingsStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SetFactorySettingsStatus'.
     */
    void sendSetFactorySettingsStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'SetFactorySettingsStatus'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSetFactorySettingsStatus() returns true.
     *
     * @return the previously received value of the property 'SetFactorySettingsStatus'.
     */
    const SetFactorySettingsStatusStatus& getSetFactorySettingsStatus() const;

    /**
     * Determines whether a status message for the property 'SetFactorySettingsStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSetFactorySettingsStatus() const;

    /**
     * Request the value of the property 'SetFactorySettingsStatus' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SetFactorySettingsStatus'</b>:
     *
     * This property gives information about the actual DefSetState, it is TRUE if all parameters are in Default State.
     * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS_STATUS,</p>
     * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
     * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
     * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
     * <p>the Identifier for "DefSetStateFirstDifferentParameterId" will be found in the Doors "/Ford HS-LSRNS Dev/System Specification/Parameter Dictionary" Document</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     * @param DefSetStateGroup Identifier of the Default Setting Group.
     * <p>E.g. DEFSET_GROUP__RADIO</p>
     *
     * @param DefSetStateMode current Default Setting Id.
     * <p>E.g. USER, TEF, UPREG, RELUPREG</p>
     *
     * @param DefSetStateSuccessful DefSet State True means: all parameter have their default state.
     * <p>only relevant for components who act as a CLIENT, else always TRUE</p>
     *
     * @param DefSetStateFirstDifferentParameterId <p>identifier of an Value which is different to the default value.</p>
     * <p>E.g Def-27 default=CLEAR, current=NOTCLEAR => Id = 27.</p>
     * <p>If Successful== TRUE the Id = 0.</p>
     * <p>only relevant for components who act as a CLIENT, else always 0</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetFactorySettingsStatusGet(SetFactorySettingsStatusCallbackIF& cb, uint8 defSetStateGroup, ::midw_diagnostics_fi_types::T_e8_DefSetMode defSetStateMode, bool defSetStateSuccessful, uint16 defSetStateFirstDifferentParameterId);

    /**
     * Set the value of the property 'SetFactorySettingsStatus'. This method
     * sends a Set message to the CCA server.
     *
     * <b>Documentation of 'SetFactorySettingsStatus'</b>:
     *
     * This property gives information about the actual DefSetState, it is TRUE if all parameters are in Default State.
     * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS_STATUS,</p>
     * <p>SERVICEID = e.g. CCA_C_U16_SRV_DIAG,</p>
     * <p>APPID = e.g. CCA_C_U16_APP_AUDIO,</p>
     * <p>TARGETID = CCA_C_U16_APP_FC_DIAGNOSIS</p>
     * <p>the Identifier for "DefSetStateFirstDifferentParameterId" will be found in the Doors "/Ford HS-LSRNS Dev/System Specification/Parameter Dictionary" Document</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param DefSetStateGroup Identifier of the Default Setting Group.
     * <p>E.g. DEFSET_GROUP__RADIO</p>
     *
     * @param DefSetStateMode current Default Setting Id.
     * <p>E.g. USER, TEF, UPREG, RELUPREG</p>
     *
     * @param DefSetStateSuccessful DefSet State True means: all parameter have their default state.
     * <p>only relevant for components who act as a CLIENT, else always TRUE</p>
     *
     * @param DefSetStateFirstDifferentParameterId <p>identifier of an Value which is different to the default value.</p>
     * <p>E.g Def-27 default=CLEAR, current=NOTCLEAR => Id = 27.</p>
     * <p>If Successful== TRUE the Id = 0.</p>
     * <p>only relevant for components who act as a CLIENT, else always 0</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetFactorySettingsStatusSet(SetFactorySettingsStatusCallbackIF& cb, uint8 defSetStateGroup, ::midw_diagnostics_fi_types::T_e8_DefSetMode defSetStateMode, bool defSetStateSuccessful, uint16 defSetStateFirstDifferentParameterId);

    // Property 'RemoteControl'

    /**
     * Notify on the property 'RemoteControl'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'RemoteControl'</b>:
     *
     * Remote control for customer diagnostics using the UDS protocol
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemoteControlUpReg(RemoteControlCallbackIF& cb);

    /**
     * Remove the notifcation on property 'RemoteControl'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'RemoteControl'</b>:
     *
     * Remote control for customer diagnostics using the UDS protocol
     *
     * @param act The act which was previously returned by the
     * sendRemoteControlUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendRemoteControlRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'RemoteControl'.
     */
    void sendRemoteControlRelUpRegAll ();

    /**
     * Returns the current value of the property 'RemoteControl' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasRemoteControl() returns true.
     *
     * @return the previously received value of the property 'RemoteControl'.
     */
    const RemoteControlStatus& getRemoteControl() const;

    /**
     * Determines whether a status message for the property 'RemoteControl' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRemoteControl() const;

    /**
     * Request the value of the property 'RemoteControl' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'RemoteControl'</b>:
     *
     * Remote control for customer diagnostics using the UDS protocol
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     * @param src Identifies the remote controller (could be HMI, TEF or Customer)
     *
     * @param cmd Identifies the information to be retrieved (is activated, is deactivated, was set to default,...)
     *
     * @param signal Identifies the signal we want to get information about
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemoteControlGet(RemoteControlCallbackIF& cb, ::midw_diagnostics_fi_types::T_e8_RCtrlSource src, ::midw_diagnostics_fi_types::T_e8_RCtrlCommand cmd, ::midw_diagnostics_fi_types::T_e8_RCtrlSignal signal);

    /**
     * Set the value of the property 'RemoteControl'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'RemoteControl'</b>:
     *
     * Remote control for customer diagnostics using the UDS protocol
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param src Identifies the remote controller (could be HMI, TEF or Customer)
     *
     * @param cmd Identifies the command to be performed (activate, deactivate, set to default,...)
     *
     * @param signal Identifies the signal for that the remote control state shall be modified
     *
     * @param status Identifies the signal for that the remote control state shall be modified
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemoteControlSet(RemoteControlCallbackIF& cb, ::midw_diagnostics_fi_types::T_e8_RCtrlSource src, ::midw_diagnostics_fi_types::T_e8_RCtrlCommand cmd, ::midw_diagnostics_fi_types::T_e8_RCtrlSignal signal, bool status);

    // Property 'CISswUpdateProcess'

    /**
     * Notify on the property 'CISswUpdateProcess'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'CISswUpdateProcess'</b>:
     *
     * CIS SW update progress to HMI for customer diagnostics using the UDS protocol
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCISswUpdateProcessUpReg(CISswUpdateProcessCallbackIF& cb);

    /**
     * Remove the notifcation on property 'CISswUpdateProcess'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'CISswUpdateProcess'</b>:
     *
     * CIS SW update progress to HMI for customer diagnostics using the UDS protocol
     *
     * @param act The act which was previously returned by the
     * sendCISswUpdateProcessUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendCISswUpdateProcessRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'CISswUpdateProcess'.
     */
    void sendCISswUpdateProcessRelUpRegAll ();

    /**
     * Returns the current value of the property 'CISswUpdateProcess' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasCISswUpdateProcess() returns true.
     *
     * @return the previously received value of the property 'CISswUpdateProcess'.
     */
    const CISswUpdateProcessStatus& getCISswUpdateProcess() const;

    /**
     * Determines whether a status message for the property 'CISswUpdateProcess' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCISswUpdateProcess() const;

    /**
     * Set the value of the property 'CISswUpdateProcess'. This method sends a
     * Set message to the CCA server.
     *
     * <b>Documentation of 'CISswUpdateProcess'</b>:
     *
     * CIS SW update progress to HMI for customer diagnostics using the UDS protocol
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param status Identifies the signal for that the CIS SW update state shall be modified
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCISswUpdateProcessSet(CISswUpdateProcessCallbackIF& cb, bool status);

    // Property 'CISswUpdateStage2Process'

    /**
     * Notify on the property 'CISswUpdateStage2Process'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'CISswUpdateStage2Process'</b>:
     *
     * CIS SW update stage2 progress to HMI for customer diagnostics using the UDS protocol
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCISswUpdateStage2ProcessUpReg(CISswUpdateStage2ProcessCallbackIF& cb);

    /**
     * Remove the notifcation on property 'CISswUpdateStage2Process'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'CISswUpdateStage2Process'</b>:
     *
     * CIS SW update stage2 progress to HMI for customer diagnostics using the UDS protocol
     *
     * @param act The act which was previously returned by the
     * sendCISswUpdateStage2ProcessUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendCISswUpdateStage2ProcessRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'CISswUpdateStage2Process'.
     */
    void sendCISswUpdateStage2ProcessRelUpRegAll ();

    /**
     * Returns the current value of the property 'CISswUpdateStage2Process'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasCISswUpdateStage2Process() returns true.
     *
     * @return the previously received value of the property 'CISswUpdateStage2Process'.
     */
    const CISswUpdateStage2ProcessStatus& getCISswUpdateStage2Process() const;

    /**
     * Determines whether a status message for the property 'CISswUpdateStage2Process' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCISswUpdateStage2Process() const;

    /**
     * Set the value of the property 'CISswUpdateStage2Process'. This method
     * sends a Set message to the CCA server.
     *
     * <b>Documentation of 'CISswUpdateStage2Process'</b>:
     *
     * CIS SW update stage2 progress to HMI for customer diagnostics using the UDS protocol
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param status Identifies the signal for that the CIS SW update stage2 state shall be modified
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCISswUpdateStage2ProcessSet(CISswUpdateStage2ProcessCallbackIF& cb, bool status);

    // Property 'CalibrationParameter'

    /**
     * Notify on the property 'CalibrationParameter'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'CalibrationParameter'</b>:
     *
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCalibrationParameterUpReg(CalibrationParameterCallbackIF& cb);

    /**
     * Remove the notifcation on property 'CalibrationParameter'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'CalibrationParameter'</b>:
     *
     *
     * @param act The act which was previously returned by the
     * sendCalibrationParameterUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendCalibrationParameterRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'CalibrationParameter'.
     */
    void sendCalibrationParameterRelUpRegAll ();

    /**
     * Returns the current value of the property 'CalibrationParameter' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasCalibrationParameter() returns true.
     *
     * @return the previously received value of the property 'CalibrationParameter'.
     */
    const CalibrationParameterStatus& getCalibrationParameter() const;

    /**
     * Determines whether a status message for the property 'CalibrationParameter' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCalibrationParameter() const;

    /**
     * Request the value of the property 'CalibrationParameter' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'CalibrationParameter'</b>:
     *
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     * @param SessionHandle Handle to the calibration table for which a session was started.
     *
     * @param Name Name of the calibration parameter.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCalibrationParameterGet(CalibrationParameterCallbackIF& cb, uint32 sessionHandle, const ::std::string& name);

    /**
     * Set the value of the property 'CalibrationParameter'. This method sends
     * a Set message to the CCA server.
     *
     * <b>Documentation of 'CalibrationParameter'</b>:
     *
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param SessionHandle Handle to the calibration table for which a session was started.
     *
     * @param Name Name of the calibration parameter.
     *
     * @param Value Value of the calibration parameter packed into a byte array.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCalibrationParameterSet(CalibrationParameterCallbackIF& cb, uint32 sessionHandle, const ::std::string& name, const ::midw_diagnostics_fi_types::T_CalibrationValue& value);

    // Property 'PartNumber'

    /**
     * Notify on the property 'PartNumber'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'PartNumber'</b>:
     *
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPartNumberUpReg(PartNumberCallbackIF& cb);

    /**
     * Remove the notifcation on property 'PartNumber'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'PartNumber'</b>:
     *
     *
     * @param act The act which was previously returned by the
     * sendPartNumberUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendPartNumberRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'PartNumber'.
     */
    void sendPartNumberRelUpRegAll ();

    /**
     * Returns the current value of the property 'PartNumber' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasPartNumber() returns true.
     *
     * @return the previously received value of the property 'PartNumber'.
     */
    const PartNumberStatus& getPartNumber() const;

    /**
     * Determines whether a status message for the property 'PartNumber' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPartNumber() const;

    /**
     * Request the value of the property 'PartNumber' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'PartNumber'</b>:
     *
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     * @param DataIdentifier The DID according to GM's Diagnostic Specification for which a Part Number is requested.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPartNumberGet(PartNumberCallbackIF& cb, uint8 dataIdentifier);

    /**
     * Set the value of the property 'PartNumber'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'PartNumber'</b>:
     *
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param DataIdentifier The DID according to GM's Diagnostic Specification for which a Part Number is requested.
     *
     * @param PartNumber The 32-bit value of the Part Number.
     *
     * @param AlphaCode The two-letter Alpha Code of the Part Number
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPartNumberSet(PartNumberCallbackIF& cb, uint8 dataIdentifier, uint32 partNumber, const ::midw_diagnostics_fi_types::T_AlphaCode& alphaCode);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Midw_Diagnostics_FIProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'StartRouteCalculation'

    ::asf::core::nullable< StartRouteCalculationStatus > _startRouteCalculation;

    // Property 'RouteCalculationResult'

    ::asf::core::nullable< RouteCalculationResultStatus > _routeCalculationResult;

    // Property 'SetLocaleStart'

    ::asf::core::nullable< SetLocaleStartStatus > _setLocaleStart;

    // Property 'SetLocaleResult'

    ::asf::core::nullable< SetLocaleResultStatus > _setLocaleResult;

    // Property 'GetLocale'

    ::asf::core::nullable< GetLocaleStatus > _getLocale;

    // Property 'SetDisplay'

    ::asf::core::nullable< SetDisplayStatus > _setDisplay;

    // Property 'ConfigUpdateViaUSB'

    ::asf::core::nullable< ConfigUpdateViaUSBStatus > _configUpdateViaUSB;

    // Property 'AntiTheftStatus'

    ::asf::core::nullable< AntiTheftStatusStatus > _antiTheftStatus;

    // Property 'AntiTheftUnlockHMI'

    ::asf::core::nullable< AntiTheftUnlockHMIStatus > _antiTheftUnlockHMI;

    // Property 'AntiTheftUnlockHU'

    ::asf::core::nullable< AntiTheftUnlockHUStatus > _antiTheftUnlockHU;

    // Property 'ClearDestinationMemory'

    ::asf::core::nullable< ClearDestinationMemoryStatus > _clearDestinationMemory;

    // Property 'GetDestinationMemorySize'

    ::asf::core::nullable< GetDestinationMemorySizeStatus > _getDestinationMemorySize;

    // Property 'SimulateKeyPress'

    ::asf::core::nullable< SimulateKeyPressStatus > _simulateKeyPress;

    // Property 'ResetSecurity'

    ::asf::core::nullable< ResetSecurityStatus > _resetSecurity;

    // Property 'Language'

    ::asf::core::nullable< LanguageStatus > _language;

    // Property 'SpeedLock'

    ::asf::core::nullable< SpeedLockStatus > _speedLock;

    // Property 'SpdLock'

    ::asf::core::nullable< SpdLockStatus > _spdLock;

    // Property 'SetRVCSignal'

    ::asf::core::nullable< SetRVCSignalStatus > _setRVCSignal;

    // Property 'RVCSignalStatus'

    ::asf::core::nullable< RVCSignalStatusStatus > _rVCSignalStatus;

    // Property 'KdsEntry'

    typedef std::map<KdsEntryRelUpReg, KdsEntryStatus > KdsEntryMap;
    KdsEntryMap _kdsEntryMap;

    // Property 'DiagConfigItem'

    typedef std::map<DiagConfigItemRelUpReg, DiagConfigItemStatus > DiagConfigItemMap;
    DiagConfigItemMap _diagConfigItemMap;

    // Property 'SetFactorySettingsStatus'

    ::asf::core::nullable< SetFactorySettingsStatusStatus > _setFactorySettingsStatus;

    // Property 'RemoteControl'

    ::asf::core::nullable< RemoteControlStatus > _remoteControl;

    // Property 'CISswUpdateProcess'

    ::asf::core::nullable< CISswUpdateProcessStatus > _cISswUpdateProcess;

    // Property 'CISswUpdateStage2Process'

    ::asf::core::nullable< CISswUpdateStage2ProcessStatus > _cISswUpdateStage2Process;

    // Property 'CalibrationParameter'

    ::asf::core::nullable< CalibrationParameterStatus > _calibrationParameter;

    // Property 'PartNumber'

    ::asf::core::nullable< PartNumberStatus > _partNumber;

    DECLARE_CLASS_LOGGER();

    friend class Midw_Diagnostics_FIProxyCallback;
};

} // namespace Midw_Diagnostics_FI

#endif // MIDW_DIAGNOSTICS_FIPROXY_H
