/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/RequiredPort.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include "org/bosch/cm/lcmdbusclient/LcmdbusclientAsf.h"
#include "org/bosch/cm/lcmdbusclient/LcmdbusclientAsfComponent.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "LcmdbusclientAsf" isn't clear, then there should be a description here.
 */

namespace org {
namespace bosch {
namespace cm {
namespace lcmdbusclient {

DEFINE_LOGGER_AND_LEVEL (_logger, "/org/bosch/cm/lcmdbusclient/LcmdbusclientAsf", Info);

/* static */ const char* LcmdbusclientAsf::asfComponent = "asfComponent";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool LcmdbusclientAsf_enabledASFSignalHandler = false;

void importLcmdbusclientAsf() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach LcmdbusclientAsf, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression0;
        {
            __expression0.setApplicationId(243);
        }
        ccaConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSystemConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSystemConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSystemConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSystemConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSystemConnector_(new ::asf::dbus::DBusConnector(*app, dbusSystemConnector));
    app->addStarter(dbusSystemConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSessionConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression2;
        {
            __expression2.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSessionConnector = __expression2;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSessionConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSessionConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSessionConnector_(new ::asf::dbus::DBusConnector(*app, dbusSessionConnector));
    app->addStarter(dbusSessionConnector_);

    // Thread 'AsfClientThread'

    ::asf::core::ComponentContainerSharedPtr AsfClientThread(new ::asf::core::ComponentContainer("AsfClientThread", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (AsfClientThread);

        // Component 'LcmdbusclientAsfComponent asfComponent'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::org::bosch::cm::lcmdbusclient::LcmdbusclientAsfComponent > > asfComponentFactory(new ::asf::core::ComponentFactory< ::org::bosch::cm::lcmdbusclient::LcmdbusclientAsfComponent >);
        ::asf::core::ComponentDescriptionSharedPtr asfComponentDescription(new ::asf::core::ComponentDescription(1, "asfComponent", /* immediate = */ true, /* threadBridge = */ false, asfComponentFactory));
        AsfClientThread->addComponentDescription(asfComponentDescription);

            // Port 'spmFiPort'

            ::asf::core::RequiredPort& asfComponent_spmFiPort = asfComponentDescription->addRequiredPort (::asf::core::RequiredPort ("SPM_CORE_FI", "spmFiPort"));
            (void)asfComponent_spmFiPort; // prevent unused variable warning

            // Port 'NanoMsgLCMPort'

            ::asf::core::RequiredPort& asfComponent_NanoMsgLCMPort = asfComponentDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.di.NanoMsgLCMInterface", "NanoMsgLCMPort"));
            (void)asfComponent_NanoMsgLCMPort; // prevent unused variable warning

            // Port 'NanoMsgGenericPort'

            ::asf::core::RequiredPort& asfComponent_NanoMsgGenericPort = asfComponentDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.di.NanoMsgGenericInterface", "NanoMsgGenericPort"));
            (void)asfComponent_NanoMsgGenericPort; // prevent unused variable warning

    // Expression

    ::asf::cca::CcaImportedPort& spmFiImport = ccaConnector_->importByName (0, 1, 2, 2);
    spmFiImport.setServiceName("SPM_CORE_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (asfComponent_spmFiPort, spmFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& NanoMsgLCMImport = dbusSessionConnector_->importByName (::std::string("NanoMsg_MasterApp.NanoMsgServer.NanoMsgMasterApplication"), ::std::string("/bosch/cm/di/NanoMsgLCMInterface"));
    NanoMsgLCMImport.setServiceName("bosch.cm.di.NanoMsgLCMInterface");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (asfComponent_NanoMsgLCMPort, NanoMsgLCMImport);

    // Expression

    ::asf::dbus::DBusImportedPort& NanoMsgGenericImport = dbusSessionConnector_->importByName (::std::string("NanoMsg_MasterApp.NanoMsgServer.NanoMsgMasterApplication"), ::std::string("/bosch/cm/di/NanoMsgGenericInterface"));
    NanoMsgGenericImport.setServiceName("bosch.cm.di.NanoMsgGenericInterface");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (asfComponent_NanoMsgGenericPort, NanoMsgGenericImport);


    LOG_INFO_STATIC("Starting application 'LcmdbusclientAsf' version 1.0.0");

    app->start();
}

int executeLcmdbusclientAsf(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("org.bosch.cm.lcmdbusclient", "LcmdbusclientAsf");
    } else {
        ::asf::core::Logger::setupLogging ("org.bosch.cm.lcmdbusclient", "LcmdbusclientAsf", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", LcmdbusclientAsf_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("org.bosch.cm.lcmdbusclient", "LcmdbusclientAsf", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create LcmdbusclientAsf");

    app->enableExceptionHandler(false);

    importLcmdbusclientAsf();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace lcmdbusclient
} // namespace cm
} // namespace bosch
} // namespace org

int main(int argc, char* argv[]) {
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::org::bosch::cm::lcmdbusclient::executeLcmdbusclientAsf(argc, argv);
}

