/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_TV_FI_SDSTVSERVICESTUB_H
#define SDS_TV_FI_SDSTVSERVICESTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "sds_tv_fi/SdsTvService.h"

namespace sds_tv_fi {
namespace SdsTvService {

class SdsTvServiceStubDelegate;

class SdsTvServiceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the SdsTvServiceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    SdsTvServiceStub (const std::string& portName);

    /**
     * Create an instance of the SdsTvServiceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    SdsTvServiceStub (const std::string& portName, const std::string& objectPath);

    virtual ~SdsTvServiceStub();

    // signal 'ProcessingFinished'

    /**
     * Raise the signal 'ProcessingFinished' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'ProcessingFinished'</b>:
     *
     * If the meaning of "ProcessingFinished" isn't clear, then there should be a description here.
     */
    void sendProcessingFinishedSignal();

    // signal 'ProcessingInterrupted'

    /**
     * Raise the signal 'ProcessingInterrupted' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'ProcessingInterrupted'</b>:
     *
     * If the meaning of "ProcessingInterrupted" isn't clear, then there should be a description here.
     */
    void sendProcessingInterruptedSignal();

    // method 'storeTVChannelNames'

    /**
     * The method onStoreTVChannelNames() is called by ASF when a client
     * invokes the method 'storeTVChannelNames'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendStoreTVChannelNames() or sendStoreTVChannelNamesError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'storeTVChannelNames'</b>:
     *
     * If the meaning of "storeTVChannelNames" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStoreTVChannelNamesRequest (const ::boost::shared_ptr< StoreTVChannelNamesRequest >& request) = 0;

    /**
     * The method sendStoreTVChannelNamesResponse() sends a response of a
     * previous method invocation of 'storeTVChannelNames' back to the client.
     *
     * <b>Documentation of 'storeTVChannelNames'</b>:
     *
     * If the meaning of "storeTVChannelNames" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onStoreTVChannelNames(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStoreTVChannelNamesResponse (act_t act = 0);

    /**
     * The method sendStoreTVChannelNamesError() sends an error response of a
     * previous method invocation of 'storeTVChannelNames' back to the client.
     *
     * <b>Documentation of 'storeTVChannelNames'</b>:
     *
     * If the meaning of "storeTVChannelNames" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onStoreTVChannelNames().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStoreTVChannelNamesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class SdsTvServiceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace SdsTvService
} // namespace sds_tv_fi

#endif // SDS_TV_FI_SDSTVSERVICESTUB_H
