#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_TV_FI_SDSTVSERVICE_H
#define SDS_TV_FI_SDSTVSERVICE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "sds_tv_fi.SdsTvService" isn't clear, then there should be a description here.
 */

namespace sds_tv_fi {
namespace SdsTvService {

// method IDs
static const uint16 ID_storeTVChannelNames = 0;

// signal IDs
static const uint16 ID_ProcessingFinished = 1;
static const uint16 ID_ProcessingInterrupted = 2;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class TVChannelItem;

class StoreTVChannelNamesRequest;

// type definitions
/**
 * If the meaning of "storeTVChannelNames" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StoreTVChannelNamesResponse;

/**
 * If the meaning of "StoreTVChannelNamesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StoreTVChannelNamesError;

/**
 * If the meaning of "ProcessingFinished" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ProcessingFinishedSignal;

/**
 * If the meaning of "ProcessingFinishedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProcessingFinishedError;

/**
 * If the meaning of "ProcessingInterrupted" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ProcessingInterruptedSignal;

/**
 * If the meaning of "ProcessingInterruptedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProcessingInterruptedError;


/**
 * If the meaning of "TVChannelItem" isn't clear, then there should be a description here.
 */
class TVChannelItem {
public:

    /**
     * Default constructor
     */
    inline  TVChannelItem ();

    /**
     * Copy constructor
     */
    inline  TVChannelItem (const TVChannelItem &rhs);

    /**
     * All fields constructor
     */
    inline  TVChannelItem (uint32 channelID_, uint32 presetType_, const ::std::string& channelName_);

    /**
     * Destructor
     */
    inline  ~TVChannelItem();

    /**
     * Assignment operator
     */
    inline TVChannelItem& operator = (const TVChannelItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TVChannelItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TVChannelItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TVChannelItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TVChannelItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "channelID"

    static const int kChannelID = 0;

    /**
     * Clears the field "channelID".
     *
     * The field will be set to its default value. The hasChannelID()
     * method will return false.
     */
    inline void clearChannelID();

    /**
     * Checks whether the field "channelID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelID()). Otherwise it will return false.
     */
    inline bool hasChannelID () const;

    /**
     * Returns the value of the member "channelID".
     *
     * If the meaning of "channelID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "channelID"
     */
    inline uint32 getChannelID () const;

    /**
     * Sets the value of the member "channelID".
     *
     * If the meaning of "channelID" isn't clear, then there should be a description here.
     *
     * @param channelID The value which will be set
     */
    inline void setChannelID (uint32 channelID_);

    // API of field "presetType"

    static const int kPresetType = 1;

    /**
     * Clears the field "presetType".
     *
     * The field will be set to its default value. The hasPresetType()
     * method will return false.
     */
    inline void clearPresetType();

    /**
     * Checks whether the field "presetType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetType()). Otherwise it will return false.
     */
    inline bool hasPresetType () const;

    /**
     * Returns the value of the member "presetType".
     *
     * If the meaning of "presetType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "presetType"
     */
    inline uint32 getPresetType () const;

    /**
     * Sets the value of the member "presetType".
     *
     * If the meaning of "presetType" isn't clear, then there should be a description here.
     *
     * @param presetType The value which will be set
     */
    inline void setPresetType (uint32 presetType_);

    // API of field "channelName"

    static const int kChannelName = 2;

    /**
     * Clears the field "channelName".
     *
     * The field will be set to its default value. The hasChannelName()
     * method will return false.
     */
    inline void clearChannelName();

    /**
     * Checks whether the field "channelName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelName()). Otherwise it will return false.
     */
    inline bool hasChannelName () const;

    /**
     * Returns the value of the member "channelName".
     *
     * If the meaning of "channelName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "channelName"
     */
    inline const ::std::string& getChannelName () const;

    /**
     * Retrieves the value of the field "channelName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "channelName".
     */
    inline ::std::string& getChannelNameMutable ();

    /**
     * Sets the value of the member "channelName".
     *
     * If the meaning of "channelName" isn't clear, then there should be a description here.
     *
     * @param channelName The value which will be set
     */
    inline void setChannelName (const ::std::string& channelName_);

    /**
     * Sets the value of the member "channelName".
     *
     * If the meaning of "channelName" isn't clear, then there should be a description here.
     *
     * @param channelName The value which will be set
     */
    inline void setChannelName (const char* channelName_);

    /**
     * Sets the value of the member "channelName".
     *
     * If the meaning of "channelName" isn't clear, then there should be a description here.
     *
     * @param channelName The value which will be set
     */
    inline void setChannelName (const char* value, size_t size);

    static const TVChannelItem &getDefaultInstance();

private:

    inline void set_has_channelID ();

    inline void clear_has_channelID ();

    inline void set_has_presetType ();

    inline void clear_has_presetType ();

    inline void set_has_channelName ();

    inline void clear_has_channelName ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _channelID;

    uint32 _presetType;

    ::std::string _channelName;

};

/**
 * If the meaning of "storeTVChannelNames" isn't clear, then there should be a description here.
 */
class StoreTVChannelNamesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StoreTVChannelNamesRequest ();

    /**
     * Copy constructor
     */
    inline  StoreTVChannelNamesRequest (const StoreTVChannelNamesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StoreTVChannelNamesRequest (const ::std::vector< TVChannelItem >& channelList_);

    /**
     * Destructor
     */
    inline virtual  ~StoreTVChannelNamesRequest();

    /**
     * Assignment operator
     */
    inline StoreTVChannelNamesRequest& operator = (const StoreTVChannelNamesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StoreTVChannelNamesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StoreTVChannelNamesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StoreTVChannelNamesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StoreTVChannelNamesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "channelList"

    static const int kChannelList = 0;

    /**
     * Clears the field "channelList".
     *
     * The field will be set to its default value. The hasChannelList()
     * method will return false.
     */
    inline void clearChannelList();

    /**
     * Checks whether the field "channelList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelList()). Otherwise it will return false.
     */
    inline bool hasChannelList () const;

    /**
     * Returns the value of the member "channelList".
     *
     * If the meaning of "channelList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "channelList"
     */
    inline const ::std::vector< TVChannelItem >& getChannelList () const;

    /**
     * Retrieves the value of the field "channelList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "channelList".
     */
    inline ::std::vector< TVChannelItem >& getChannelListMutable ();

    /**
     * Sets the value of the member "channelList".
     *
     * If the meaning of "channelList" isn't clear, then there should be a description here.
     *
     * @param channelList The value which will be set
     */
    inline void setChannelList (const ::std::vector< TVChannelItem >& channelList_);

    static const StoreTVChannelNamesRequest &getDefaultInstance();

private:

    static const ::std::vector< TVChannelItem >& getTVChannelItemList_DefaultInstance ();

    inline void set_has_channelList ();

    inline void clear_has_channelList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< TVChannelItem > _channelList;

};

inline  TVChannelItem::TVChannelItem ()  :
    _channelID (0u),
    _presetType (0u),
    _channelName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TVChannelItem::TVChannelItem (const TVChannelItem &rhs)  :
    _channelID (0u),
    _presetType (0u),
    _channelName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TVChannelItem::TVChannelItem (uint32 channelID_, uint32 presetType_, const ::std::string& channelName_)  :
    _channelID (channelID_),
    _presetType (presetType_),
    _channelName (channelName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (channelName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TVChannelItem::~TVChannelItem() {
}

inline TVChannelItem& TVChannelItem::operator = (const TVChannelItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasChannelID()) {
            setChannelID(rhs.getChannelID());
        } else {
            clearChannelID();
        }
        if (rhs.hasPresetType()) {
            setPresetType(rhs.getPresetType());
        } else {
            clearPresetType();
        }
        if (rhs.hasChannelName()) {
            setChannelName(rhs.getChannelName());
        } else {
            clearChannelName();
        }
    }
    return *this;
}

inline bool TVChannelItem::operator == (const TVChannelItem& rhs) const {
    return (((!hasChannelID() && !rhs.hasChannelID()) || getChannelID() == rhs.getChannelID()) &&
        ((!hasPresetType() && !rhs.hasPresetType()) || getPresetType() == rhs.getPresetType()) &&
        ((!hasChannelName() && !rhs.hasChannelName()) || getChannelName() == rhs.getChannelName()));
}

inline bool TVChannelItem::operator != (const TVChannelItem& rhs) const {
    return ! (*this == rhs);
}

inline bool TVChannelItem::operator < (const TVChannelItem& rhs) const {
    if (hasChannelID() || rhs.hasChannelID()) {
        if (getChannelID() < rhs.getChannelID()) return true;
        if (getChannelID() > rhs.getChannelID()) return false;
    }
    if (hasPresetType() || rhs.hasPresetType()) {
        if (getPresetType() < rhs.getPresetType()) return true;
        if (getPresetType() > rhs.getPresetType()) return false;
    }
    if (hasChannelName() || rhs.hasChannelName()) {
        if (getChannelName() < rhs.getChannelName()) return true;
        if (getChannelName() > rhs.getChannelName()) return false;
    }
    return false;
}

inline bool TVChannelItem::operator > (const TVChannelItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TVChannelItem::clear() {
    clearChannelID();
    clearPresetType();
    clearChannelName();
}

inline void TVChannelItem::clearChannelID() {
    if (hasChannelID()) {
         clear_has_channelID();
        _channelID = 0u;
     }
}

inline bool TVChannelItem::hasChannelID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 TVChannelItem::getChannelID () const {
    return _channelID;
}

inline void TVChannelItem::setChannelID (uint32 channelID_) {
    set_has_channelID();
    this->_channelID = channelID_;
}

inline void TVChannelItem::clearPresetType() {
    if (hasPresetType()) {
         clear_has_presetType();
        _presetType = 0u;
     }
}

inline bool TVChannelItem::hasPresetType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 TVChannelItem::getPresetType () const {
    return _presetType;
}

inline void TVChannelItem::setPresetType (uint32 presetType_) {
    set_has_presetType();
    this->_presetType = presetType_;
}

inline void TVChannelItem::clearChannelName() {
    if (hasChannelName()) {
         clear_has_channelName();
        _channelName.clear();
     }
}

inline bool TVChannelItem::hasChannelName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& TVChannelItem::getChannelName () const {
    return _channelName;
}

inline ::std::string& TVChannelItem::getChannelNameMutable () {
    set_has_channelName();
    return _channelName;
}

inline void TVChannelItem::setChannelName (const ::std::string& channelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (channelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_channelName();
    this->_channelName = channelName_;
}

inline void TVChannelItem::setChannelName (const char* channelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (channelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_channelName();
    this->_channelName.assign(channelName_);
}

inline void TVChannelItem::setChannelName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_channelName();
    this->_channelName.assign(value, size);
}

inline void TVChannelItem::set_has_channelID () {
    _has_bits_[0] |= 1u << 0;
}

inline void TVChannelItem::clear_has_channelID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void TVChannelItem::set_has_presetType () {
    _has_bits_[0] |= 1u << 1;
}

inline void TVChannelItem::clear_has_presetType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void TVChannelItem::set_has_channelName () {
    _has_bits_[0] |= 1u << 2;
}

inline void TVChannelItem::clear_has_channelName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  StoreTVChannelNamesRequest::StoreTVChannelNamesRequest ()  :
    _channelList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StoreTVChannelNamesRequest::StoreTVChannelNamesRequest (const StoreTVChannelNamesRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _channelList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StoreTVChannelNamesRequest::StoreTVChannelNamesRequest (const ::std::vector< TVChannelItem >& channelList_)  :
    _channelList (channelList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StoreTVChannelNamesRequest::~StoreTVChannelNamesRequest() {
}

inline StoreTVChannelNamesRequest& StoreTVChannelNamesRequest::operator = (const StoreTVChannelNamesRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasChannelList()) {
            setChannelList(rhs.getChannelList());
        } else {
            clearChannelList();
        }
    }
    return *this;
}

inline bool StoreTVChannelNamesRequest::operator == (const StoreTVChannelNamesRequest& rhs) const {
    return (((!hasChannelList() && !rhs.hasChannelList()) || getChannelList() == rhs.getChannelList()));
}

inline bool StoreTVChannelNamesRequest::operator != (const StoreTVChannelNamesRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool StoreTVChannelNamesRequest::operator < (const StoreTVChannelNamesRequest& rhs) const {
    if (hasChannelList() || rhs.hasChannelList()) {
        if (getChannelList() < rhs.getChannelList()) return true;
        if (getChannelList() > rhs.getChannelList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StoreTVChannelNamesRequest::clone() {
    return new StoreTVChannelNamesRequest(*this);
}

inline bool StoreTVChannelNamesRequest::operator > (const StoreTVChannelNamesRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StoreTVChannelNamesRequest::clear() {
    clearChannelList();
}

inline void StoreTVChannelNamesRequest::clearChannelList() {
    if (hasChannelList()) {
         clear_has_channelList();
        _channelList.clear();
     }
}

inline bool StoreTVChannelNamesRequest::hasChannelList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< TVChannelItem >& StoreTVChannelNamesRequest::getChannelList () const {
    return _channelList;
}

inline ::std::vector< TVChannelItem >& StoreTVChannelNamesRequest::getChannelListMutable () {
    set_has_channelList();
    return _channelList;
}

inline void StoreTVChannelNamesRequest::setChannelList (const ::std::vector< TVChannelItem >& channelList_) {
    set_has_channelList();
    this->_channelList = channelList_;
}

inline void StoreTVChannelNamesRequest::set_has_channelList () {
    _has_bits_[0] |= 1u << 0;
}

inline void StoreTVChannelNamesRequest::clear_has_channelList () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace SdsTvService
} // namespace sds_tv_fi

#endif // SDS_TV_FI_SDSTVSERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
