/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "sds_sxm_fi/SdsSxmService.h"
#include "sds_sxm_fi/SdsSxmServiceDBus.h"
#include "sds_sxm_fi/SdsSxmServiceJson.h"
#include "sds_sxm_fi/SdsSxmServiceStub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace sds_sxm_fi {
namespace SdsSxmService {

DEFINE_CLASS_LOGGER("/sds_sxm_fi/sds_sxm_fi/SdsSxmService", SdsSxmServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 20, "storeSXMChannelNames", 0 },
    { 20, "storeSXMPhoneticData", 1 },
};


class SdsSxmServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    SdsSxmServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    SdsSxmServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    SdsSxmServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "sds_sxm_fi.SdsSxmService"),
          _logger(logger) {}

    virtual ~SdsSxmServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void SdsSxmServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 2, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'storeSXMChannelNames'

            LOG_DEBUG_STUB("process method '%s'", "storeSXMChannelNames");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StoreSXMChannelNamesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StoreSXMChannelNames", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StoreSXMChannelNamesRequest > payload = ::boost::static_pointer_cast<StoreSXMChannelNamesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsSxmServiceStub*>(getStub())->onStoreSXMChannelNamesRequest(payload);
            return;
        }
        case 1: {

            // method 'storeSXMPhoneticData'

            LOG_DEBUG_STUB("process method '%s'", "storeSXMPhoneticData");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StoreSXMPhoneticDataRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StoreSXMPhoneticData", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StoreSXMPhoneticDataRequest > payload = ::boost::static_pointer_cast<StoreSXMPhoneticDataRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsSxmServiceStub*>(getStub())->onStoreSXMPhoneticDataRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* SdsSxmServiceStubDelegate::introspect() const {
    return     "<interface name=\"sds_sxm_fi.SdsSxmService\">\n"
            "    <method name=\"storeSXMChannelNames\">\n"
            "      <arg direction=\"in\" name=\"channelsList\" type=\"a(qqqs)\">\n"
            "        <doc>\n"
            "          <line>channelsList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"storeSXMPhoneticData\">\n"
            "      <arg direction=\"in\" name=\"phonemesList\" type=\"a(qqs)\">\n"
            "        <doc>\n"
            "          <line>phonemesList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"ProcessingFinished\">\n"
            "      <arg direction=\"out\" name=\"message\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>message = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"ProcessingInterrupted\">\n"
            "      <arg direction=\"out\" name=\"message\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>message = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "</interface>\n";
}

void SdsSxmServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<SdsSxmServiceStub*>(getStub()))->onGetAll (properties);
}

void SdsSxmServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void SdsSxmServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

SdsSxmServiceStub::SdsSxmServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SdsSxmServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SdsSxmServiceStub::SdsSxmServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SdsSxmServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SdsSxmServiceStub::~SdsSxmServiceStub() {
    delete _stubDelegate;
}

void SdsSxmServiceStub::sendProcessingFinishedSignal(const ::std::string& message) {
    if (_stubDelegate->isConnected()) {
        ProcessingFinishedSignal* payload = new ProcessingFinishedSignal(message);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ProcessingFinished", ProcessingFinishedSignal, payload)
        LOG_INFO ("-> send%sSignal", "ProcessingFinished");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ProcessingFinished");
    }
}

void SdsSxmServiceStub::sendProcessingInterruptedSignal(const ::std::string& message) {
    if (_stubDelegate->isConnected()) {
        ProcessingInterruptedSignal* payload = new ProcessingInterruptedSignal(message);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ProcessingInterrupted", ProcessingInterruptedSignal, payload)
        LOG_INFO ("-> send%sSignal", "ProcessingInterrupted");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ProcessingInterrupted");
    }
}

void  SdsSxmServiceStub::sendStoreSXMChannelNamesResponse (act_t act) {
    StoreSXMChannelNamesResponse* payload = new StoreSXMChannelNamesResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "storeSXMChannelNames", StoreSXMChannelNamesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StoreSXMChannelNames", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsSxmServiceStub::sendStoreSXMChannelNamesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StoreSXMChannelNamesError* payload = new StoreSXMChannelNamesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "storeSXMChannelNames", StoreSXMChannelNamesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StoreSXMChannelNames", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsSxmServiceStub::sendStoreSXMPhoneticDataResponse (act_t act) {
    StoreSXMPhoneticDataResponse* payload = new StoreSXMPhoneticDataResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "storeSXMPhoneticData", StoreSXMPhoneticDataResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StoreSXMPhoneticData", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsSxmServiceStub::sendStoreSXMPhoneticDataError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StoreSXMPhoneticDataError* payload = new StoreSXMPhoneticDataError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "storeSXMPhoneticData", StoreSXMPhoneticDataError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StoreSXMPhoneticData", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void SdsSxmServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace SdsSxmService
} // namespace sds_sxm_fi
