/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "sds_sxm_fi/SdsSxmService.h"
#include "sds_sxm_fi/SdsSxmServiceDBus.h"
#include "sds_sxm_fi/SdsSxmServiceJson.h"
#include "sds_sxm_fi/SdsSxmServiceProxy.h"
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace sds_sxm_fi {
namespace SdsSxmService {

DEFINE_CLASS_LOGGER("/sds_sxm_fi/sds_sxm_fi/SdsSxmService", SdsSxmServiceProxy);

class SdsSxmServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    SdsSxmServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< SdsSxmServiceProxy >& proxyShared = ::boost::static_pointer_cast< SdsSxmServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_ProcessingFinished:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProcessingFinishedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProcessingFinished", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ProcessingFinishedSignal> payload = ::boost::static_pointer_cast<ProcessingFinishedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ProcessingFinishedCallbackIF*) _callback)->onProcessingFinishedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_ProcessingInterrupted:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProcessingInterruptedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProcessingInterrupted", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ProcessingInterruptedSignal> payload = ::boost::static_pointer_cast<ProcessingInterruptedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ProcessingInterruptedCallbackIF*) _callback)->onProcessingInterruptedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_storeSXMChannelNames:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StoreSXMChannelNamesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StoreSXMChannelNames", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StoreSXMChannelNamesError> payload = ::boost::static_pointer_cast<StoreSXMChannelNamesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StoreSXMChannelNamesCallbackIF*) _callback)->onStoreSXMChannelNamesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StoreSXMChannelNamesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StoreSXMChannelNames", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StoreSXMChannelNamesResponse> payload = ::boost::static_pointer_cast<StoreSXMChannelNamesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StoreSXMChannelNamesCallbackIF*) _callback)->onStoreSXMChannelNamesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_storeSXMPhoneticData:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StoreSXMPhoneticDataError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StoreSXMPhoneticData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StoreSXMPhoneticDataError> payload = ::boost::static_pointer_cast<StoreSXMPhoneticDataError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StoreSXMPhoneticDataCallbackIF*) _callback)->onStoreSXMPhoneticDataError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StoreSXMPhoneticDataResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StoreSXMPhoneticData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StoreSXMPhoneticDataResponse> payload = ::boost::static_pointer_cast<StoreSXMPhoneticDataResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StoreSXMPhoneticDataCallbackIF*) _callback)->onStoreSXMPhoneticDataResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_ProcessingFinished: {
                ::boost::shared_ptr< ProcessingFinishedError > payload = ::boost::shared_ptr< ProcessingFinishedError >
                (new ProcessingFinishedError(DBUS_ERROR_NO_SERVER, "The DBus service SdsSxmService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ProcessingFinished", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsSxmServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsSxmServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProcessingFinishedCallbackIF*) _callback)->onProcessingFinishedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ProcessingInterrupted: {
                ::boost::shared_ptr< ProcessingInterruptedError > payload = ::boost::shared_ptr< ProcessingInterruptedError >
                (new ProcessingInterruptedError(DBUS_ERROR_NO_SERVER, "The DBus service SdsSxmService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ProcessingInterrupted", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsSxmServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsSxmServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProcessingInterruptedCallbackIF*) _callback)->onProcessingInterruptedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_storeSXMChannelNames: {
                ::boost::shared_ptr< StoreSXMChannelNamesError > payload = ::boost::shared_ptr< StoreSXMChannelNamesError >
                (new StoreSXMChannelNamesError(DBUS_ERROR_NO_SERVER, "The DBus service SdsSxmService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StoreSXMChannelNames", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsSxmServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsSxmServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StoreSXMChannelNamesCallbackIF*) _callback)->onStoreSXMChannelNamesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_storeSXMPhoneticData: {
                ::boost::shared_ptr< StoreSXMPhoneticDataError > payload = ::boost::shared_ptr< StoreSXMPhoneticDataError >
                (new StoreSXMPhoneticDataError(DBUS_ERROR_NO_SERVER, "The DBus service SdsSxmService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StoreSXMPhoneticData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsSxmServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsSxmServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StoreSXMPhoneticDataCallbackIF*) _callback)->onStoreSXMPhoneticDataError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& SdsSxmServiceProxyCallback::_logger (SdsSxmServiceProxy::_logger);

SdsSxmServiceProxy::SdsSxmServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "sds_sxm_fi.SdsSxmService", serviceAvailable, _logger) {
}

SdsSxmServiceProxy::~SdsSxmServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< SdsSxmServiceProxy > SdsSxmServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<SdsSxmServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< SdsSxmServiceProxy > proxyNew(new SdsSxmServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t SdsSxmServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    SdsSxmServiceProxyCallback* callback = new SdsSxmServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t SdsSxmServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    SdsSxmServiceProxyCallback* callback = new SdsSxmServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void SdsSxmServiceProxy::sendDeregisterAll () const
{
    sendProcessingFinishedDeregisterAll();
    sendProcessingInterruptedDeregisterAll();
}

act_t SdsSxmServiceProxy::sendProcessingFinishedRegister(ProcessingFinishedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ProcessingFinished");
    act_t act = addSignalCallback(ID_ProcessingFinished, "ProcessingFinished", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ProcessingFinished", &cb, act);
    return act;
}

bool SdsSxmServiceProxy::sendProcessingFinishedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ProcessingFinished", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ProcessingFinished", act, static_cast<int>(rv));
    return rv;
}

void SdsSxmServiceProxy::sendProcessingFinishedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ProcessingFinished");
    _dbusProxyDelegate->deregisterSignalCallback("ProcessingFinished", 0, _dbusDaemonProxy.get(), false);
}

act_t SdsSxmServiceProxy::sendProcessingInterruptedRegister(ProcessingInterruptedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ProcessingInterrupted");
    act_t act = addSignalCallback(ID_ProcessingInterrupted, "ProcessingInterrupted", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ProcessingInterrupted", &cb, act);
    return act;
}

bool SdsSxmServiceProxy::sendProcessingInterruptedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ProcessingInterrupted", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ProcessingInterrupted", act, static_cast<int>(rv));
    return rv;
}

void SdsSxmServiceProxy::sendProcessingInterruptedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ProcessingInterrupted");
    _dbusProxyDelegate->deregisterSignalCallback("ProcessingInterrupted", 0, _dbusDaemonProxy.get(), false);
}

act_t SdsSxmServiceProxy::sendStoreSXMChannelNamesRequest(StoreSXMChannelNamesCallbackIF& cb, const ::std::vector< SXMChannelItem >& channelsList) const {
    StoreSXMChannelNamesRequest* payload = new StoreSXMChannelNamesRequest();
    CHECK_ALLOCATION(payload);
    payload->setChannelsList(channelsList);
    DBUS_MESSAGE_CALL(dbusMessage, "storeSXMChannelNames", StoreSXMChannelNamesRequest, payload, true)
    act_t act = addMethodCallback(ID_storeSXMChannelNames, dbusMessage.getUniqueSerial(), "storeSXMChannelNames", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StoreSXMChannelNames", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SdsSxmServiceProxy::sendStoreSXMPhoneticDataRequest(StoreSXMPhoneticDataCallbackIF& cb, const ::std::vector< SXMPhoneticData >& phonemesList) const {
    StoreSXMPhoneticDataRequest* payload = new StoreSXMPhoneticDataRequest();
    CHECK_ALLOCATION(payload);
    payload->setPhonemesList(phonemesList);
    DBUS_MESSAGE_CALL(dbusMessage, "storeSXMPhoneticData", StoreSXMPhoneticDataRequest, payload, true)
    act_t act = addMethodCallback(ID_storeSXMPhoneticData, dbusMessage.getUniqueSerial(), "storeSXMPhoneticData", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StoreSXMPhoneticData", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace SdsSxmService
} // namespace sds_sxm_fi
