/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "boost/shared_ptr.hpp"
#include "sds_gui_fi/SettingsService.h"
#include "sds_gui_fi/SettingsServiceConst.h"
#include "sds_gui_fi/SettingsServiceDBus.h"
#include "sds_gui_fi/SettingsServiceJson.h"
#include "sds_gui_fi/SettingsServiceProxy.h"
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace sds_gui_fi {
namespace SettingsService {

DEFINE_CLASS_LOGGER("/sds_gui_fi/sds_gui_fi/SettingsService", SettingsServiceProxy);

class SettingsServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    SettingsServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< SettingsServiceProxy >& proxyShared = ::boost::static_pointer_cast< SettingsServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_bestMatchAudio:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BestMatchAudioError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BestMatchAudio", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BestMatchAudioError> payload = ::boost::static_pointer_cast<BestMatchAudioError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((BestMatchAudioCallbackIF*) _callback)->onBestMatchAudioError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BestMatchAudioUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BestMatchAudio", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BestMatchAudioUpdate> payload = ::boost::static_pointer_cast<BestMatchAudioUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((BestMatchAudioCallbackIF*) _callback)->onBestMatchAudioUpdate(proxyShared, payload);
                        proxyShared->_bestMatchAudio = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_bestMatchPhoneBook:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BestMatchPhoneBookError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BestMatchPhoneBook", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BestMatchPhoneBookError> payload = ::boost::static_pointer_cast<BestMatchPhoneBookError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((BestMatchPhoneBookCallbackIF*) _callback)->onBestMatchPhoneBookError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BestMatchPhoneBookUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BestMatchPhoneBook", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BestMatchPhoneBookUpdate> payload = ::boost::static_pointer_cast<BestMatchPhoneBookUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((BestMatchPhoneBookCallbackIF*) _callback)->onBestMatchPhoneBookUpdate(proxyShared, payload);
                        proxyShared->_bestMatchPhoneBook = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_beepOnlyMode:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BeepOnlyModeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BeepOnlyMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BeepOnlyModeError> payload = ::boost::static_pointer_cast<BeepOnlyModeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((BeepOnlyModeCallbackIF*) _callback)->onBeepOnlyModeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BeepOnlyModeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BeepOnlyMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BeepOnlyModeUpdate> payload = ::boost::static_pointer_cast<BeepOnlyModeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((BeepOnlyModeCallbackIF*) _callback)->onBeepOnlyModeUpdate(proxyShared, payload);
                        proxyShared->_beepOnlyMode = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_shortPrompt:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShortPromptError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ShortPrompt", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShortPromptError> payload = ::boost::static_pointer_cast<ShortPromptError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ShortPromptCallbackIF*) _callback)->onShortPromptError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShortPromptUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ShortPrompt", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShortPromptUpdate> payload = ::boost::static_pointer_cast<ShortPromptUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ShortPromptCallbackIF*) _callback)->onShortPromptUpdate(proxyShared, payload);
                        proxyShared->_shortPrompt = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_voiceBargeIn:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VoiceBargeInError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "VoiceBargeIn", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VoiceBargeInError> payload = ::boost::static_pointer_cast<VoiceBargeInError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((VoiceBargeInCallbackIF*) _callback)->onVoiceBargeInError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VoiceBargeInUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "VoiceBargeIn", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VoiceBargeInUpdate> payload = ::boost::static_pointer_cast<VoiceBargeInUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((VoiceBargeInCallbackIF*) _callback)->onVoiceBargeInUpdate(proxyShared, payload);
                        proxyShared->_voiceBargeIn = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_voicePreference:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VoicePreferenceError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "VoicePreference", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VoicePreferenceError> payload = ::boost::static_pointer_cast<VoicePreferenceError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((VoicePreferenceCallbackIF*) _callback)->onVoicePreferenceError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VoicePreferenceUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "VoicePreference", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VoicePreferenceUpdate> payload = ::boost::static_pointer_cast<VoicePreferenceUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((VoicePreferenceCallbackIF*) _callback)->onVoicePreferenceUpdate(proxyShared, payload);
                        proxyShared->_voicePreference = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_speechRate:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SpeechRateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SpeechRate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SpeechRateError> payload = ::boost::static_pointer_cast<SpeechRateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SpeechRateCallbackIF*) _callback)->onSpeechRateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SpeechRateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SpeechRate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SpeechRateUpdate> payload = ::boost::static_pointer_cast<SpeechRateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SpeechRateCallbackIF*) _callback)->onSpeechRateUpdate(proxyShared, payload);
                        proxyShared->_speechRate = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_speechRecognitionLanguageList:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SpeechRecognitionLanguageListError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SpeechRecognitionLanguageList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SpeechRecognitionLanguageListError> payload = ::boost::static_pointer_cast<SpeechRecognitionLanguageListError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SpeechRecognitionLanguageListCallbackIF*) _callback)->onSpeechRecognitionLanguageListError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SpeechRecognitionLanguageListUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SpeechRecognitionLanguageList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SpeechRecognitionLanguageListUpdate> payload = ::boost::static_pointer_cast<SpeechRecognitionLanguageListUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SpeechRecognitionLanguageListCallbackIF*) _callback)->onSpeechRecognitionLanguageListUpdate(proxyShared, payload);
                        proxyShared->_speechRecognitionLanguageList = *payload.get();
                        return true;
                    }
                }
                break;
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_bestMatchAudio: {
                ::boost::shared_ptr< BestMatchAudioError > payload = ::boost::shared_ptr< BestMatchAudioError >
                (new BestMatchAudioError(DBUS_ERROR_NO_SERVER, "The DBus service SettingsService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BestMatchAudio", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SettingsServiceProxy> proxyShared = ::boost::static_pointer_cast<SettingsServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BestMatchAudioCallbackIF*) _callback)->onBestMatchAudioError (proxyShared,payload);
                return true;
            }
            break;
            case ID_bestMatchPhoneBook: {
                ::boost::shared_ptr< BestMatchPhoneBookError > payload = ::boost::shared_ptr< BestMatchPhoneBookError >
                (new BestMatchPhoneBookError(DBUS_ERROR_NO_SERVER, "The DBus service SettingsService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BestMatchPhoneBook", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SettingsServiceProxy> proxyShared = ::boost::static_pointer_cast<SettingsServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BestMatchPhoneBookCallbackIF*) _callback)->onBestMatchPhoneBookError (proxyShared,payload);
                return true;
            }
            break;
            case ID_beepOnlyMode: {
                ::boost::shared_ptr< BeepOnlyModeError > payload = ::boost::shared_ptr< BeepOnlyModeError >
                (new BeepOnlyModeError(DBUS_ERROR_NO_SERVER, "The DBus service SettingsService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BeepOnlyMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SettingsServiceProxy> proxyShared = ::boost::static_pointer_cast<SettingsServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BeepOnlyModeCallbackIF*) _callback)->onBeepOnlyModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_shortPrompt: {
                ::boost::shared_ptr< ShortPromptError > payload = ::boost::shared_ptr< ShortPromptError >
                (new ShortPromptError(DBUS_ERROR_NO_SERVER, "The DBus service SettingsService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ShortPrompt", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SettingsServiceProxy> proxyShared = ::boost::static_pointer_cast<SettingsServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ShortPromptCallbackIF*) _callback)->onShortPromptError (proxyShared,payload);
                return true;
            }
            break;
            case ID_voiceBargeIn: {
                ::boost::shared_ptr< VoiceBargeInError > payload = ::boost::shared_ptr< VoiceBargeInError >
                (new VoiceBargeInError(DBUS_ERROR_NO_SERVER, "The DBus service SettingsService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "VoiceBargeIn", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SettingsServiceProxy> proxyShared = ::boost::static_pointer_cast<SettingsServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((VoiceBargeInCallbackIF*) _callback)->onVoiceBargeInError (proxyShared,payload);
                return true;
            }
            break;
            case ID_voicePreference: {
                ::boost::shared_ptr< VoicePreferenceError > payload = ::boost::shared_ptr< VoicePreferenceError >
                (new VoicePreferenceError(DBUS_ERROR_NO_SERVER, "The DBus service SettingsService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "VoicePreference", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SettingsServiceProxy> proxyShared = ::boost::static_pointer_cast<SettingsServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((VoicePreferenceCallbackIF*) _callback)->onVoicePreferenceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_speechRate: {
                ::boost::shared_ptr< SpeechRateError > payload = ::boost::shared_ptr< SpeechRateError >
                (new SpeechRateError(DBUS_ERROR_NO_SERVER, "The DBus service SettingsService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SpeechRate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SettingsServiceProxy> proxyShared = ::boost::static_pointer_cast<SettingsServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SpeechRateCallbackIF*) _callback)->onSpeechRateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_speechRecognitionLanguageList: {
                ::boost::shared_ptr< SpeechRecognitionLanguageListError > payload = ::boost::shared_ptr< SpeechRecognitionLanguageListError >
                (new SpeechRecognitionLanguageListError(DBUS_ERROR_NO_SERVER, "The DBus service SettingsService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SpeechRecognitionLanguageList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SettingsServiceProxy> proxyShared = ::boost::static_pointer_cast<SettingsServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SpeechRecognitionLanguageListCallbackIF*) _callback)->onSpeechRecognitionLanguageListError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& SettingsServiceProxyCallback::_logger (SettingsServiceProxy::_logger);

SettingsServiceProxy::SettingsServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "sds_gui_fi.SettingsService", serviceAvailable, _logger) {
}

SettingsServiceProxy::~SettingsServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< SettingsServiceProxy > SettingsServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<SettingsServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< SettingsServiceProxy > proxyNew(new SettingsServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t SettingsServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    SettingsServiceProxyCallback* callback = new SettingsServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t SettingsServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    SettingsServiceProxyCallback* callback = new SettingsServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SettingsServiceProxy::clearAllProperties ()
{
    _bestMatchAudio = ::asf::core::nullable< BestMatchAudioUpdate >();
    _bestMatchPhoneBook = ::asf::core::nullable< BestMatchPhoneBookUpdate >();
    _beepOnlyMode = ::asf::core::nullable< BeepOnlyModeUpdate >();
    _shortPrompt = ::asf::core::nullable< ShortPromptUpdate >();
    _voiceBargeIn = ::asf::core::nullable< VoiceBargeInUpdate >();
    _voicePreference = ::asf::core::nullable< VoicePreferenceUpdate >();
    _speechRate = ::asf::core::nullable< SpeechRateUpdate >();
    _speechRecognitionLanguageList = ::asf::core::nullable< SpeechRecognitionLanguageListUpdate >();
}

void SettingsServiceProxy::sendDeregisterAll () const
{
    sendBestMatchAudioDeregisterAll();
    sendBestMatchPhoneBookDeregisterAll();
    sendBeepOnlyModeDeregisterAll();
    sendShortPromptDeregisterAll();
    sendVoiceBargeInDeregisterAll();
    sendVoicePreferenceDeregisterAll();
    sendSpeechRateDeregisterAll();
    sendSpeechRecognitionLanguageListDeregisterAll();
}

act_t SettingsServiceProxy::sendBestMatchAudioRegister(BestMatchAudioCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_bestMatchAudio, "bestMatchAudio", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BestMatchAudio", &cb, act);
    return act;
}

bool SettingsServiceProxy::sendBestMatchAudioDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("bestMatchAudio", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BestMatchAudio", act, static_cast<int>(rv));
    return rv;
}

act_t SettingsServiceProxy::sendBestMatchAudioGet(BestMatchAudioCallbackIF& cb) {
    SettingsServiceProxyCallback* callback = new SettingsServiceProxyCallback(ID_bestMatchAudio, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "BestMatchAudio", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("bestMatchAudio", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SettingsServiceProxy::sendBestMatchAudioSet(bool bestMatchAudio) {
    BestMatchAudioSet parameter(bestMatchAudio);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "BestMatchAudio");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "bestMatchAudio", propertyContent);
}

act_t SettingsServiceProxy::sendBestMatchAudioSet(BestMatchAudioCallbackIF& cb, bool bestMatchAudio) {
    SettingsServiceProxyCallback* callback = new SettingsServiceProxyCallback(ID_bestMatchAudio, &cb);
    BestMatchAudioSet parameter(bestMatchAudio);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "BestMatchAudio", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "bestMatchAudio", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool SettingsServiceProxy::getBestMatchAudio() const {
    return _bestMatchAudio.get().getBestMatchAudio();
}

bool SettingsServiceProxy::hasBestMatchAudio() const {
    return _bestMatchAudio.hasValue();
}

void SettingsServiceProxy::sendBestMatchAudioDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BestMatchAudio");
    _dbusProxyDelegate->deregisterSignalCallback("bestMatchAudio", 0, _dbusDaemonProxy.get(), true);
}

act_t SettingsServiceProxy::sendBestMatchPhoneBookRegister(BestMatchPhoneBookCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_bestMatchPhoneBook, "bestMatchPhoneBook", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BestMatchPhoneBook", &cb, act);
    return act;
}

bool SettingsServiceProxy::sendBestMatchPhoneBookDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("bestMatchPhoneBook", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BestMatchPhoneBook", act, static_cast<int>(rv));
    return rv;
}

act_t SettingsServiceProxy::sendBestMatchPhoneBookGet(BestMatchPhoneBookCallbackIF& cb) {
    SettingsServiceProxyCallback* callback = new SettingsServiceProxyCallback(ID_bestMatchPhoneBook, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "BestMatchPhoneBook", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("bestMatchPhoneBook", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SettingsServiceProxy::sendBestMatchPhoneBookSet(bool bestMatchPhoneBook) {
    BestMatchPhoneBookSet parameter(bestMatchPhoneBook);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "BestMatchPhoneBook");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "bestMatchPhoneBook", propertyContent);
}

act_t SettingsServiceProxy::sendBestMatchPhoneBookSet(BestMatchPhoneBookCallbackIF& cb, bool bestMatchPhoneBook) {
    SettingsServiceProxyCallback* callback = new SettingsServiceProxyCallback(ID_bestMatchPhoneBook, &cb);
    BestMatchPhoneBookSet parameter(bestMatchPhoneBook);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "BestMatchPhoneBook", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "bestMatchPhoneBook", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool SettingsServiceProxy::getBestMatchPhoneBook() const {
    return _bestMatchPhoneBook.get().getBestMatchPhoneBook();
}

bool SettingsServiceProxy::hasBestMatchPhoneBook() const {
    return _bestMatchPhoneBook.hasValue();
}

void SettingsServiceProxy::sendBestMatchPhoneBookDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BestMatchPhoneBook");
    _dbusProxyDelegate->deregisterSignalCallback("bestMatchPhoneBook", 0, _dbusDaemonProxy.get(), true);
}

act_t SettingsServiceProxy::sendBeepOnlyModeRegister(BeepOnlyModeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_beepOnlyMode, "beepOnlyMode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BeepOnlyMode", &cb, act);
    return act;
}

bool SettingsServiceProxy::sendBeepOnlyModeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("beepOnlyMode", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BeepOnlyMode", act, static_cast<int>(rv));
    return rv;
}

act_t SettingsServiceProxy::sendBeepOnlyModeGet(BeepOnlyModeCallbackIF& cb) {
    SettingsServiceProxyCallback* callback = new SettingsServiceProxyCallback(ID_beepOnlyMode, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "BeepOnlyMode", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("beepOnlyMode", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SettingsServiceProxy::sendBeepOnlyModeSet(bool beepOnlyMode) {
    BeepOnlyModeSet parameter(beepOnlyMode);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "BeepOnlyMode");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "beepOnlyMode", propertyContent);
}

act_t SettingsServiceProxy::sendBeepOnlyModeSet(BeepOnlyModeCallbackIF& cb, bool beepOnlyMode) {
    SettingsServiceProxyCallback* callback = new SettingsServiceProxyCallback(ID_beepOnlyMode, &cb);
    BeepOnlyModeSet parameter(beepOnlyMode);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "BeepOnlyMode", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "beepOnlyMode", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool SettingsServiceProxy::getBeepOnlyMode() const {
    return _beepOnlyMode.get().getBeepOnlyMode();
}

bool SettingsServiceProxy::hasBeepOnlyMode() const {
    return _beepOnlyMode.hasValue();
}

void SettingsServiceProxy::sendBeepOnlyModeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BeepOnlyMode");
    _dbusProxyDelegate->deregisterSignalCallback("beepOnlyMode", 0, _dbusDaemonProxy.get(), true);
}

act_t SettingsServiceProxy::sendShortPromptRegister(ShortPromptCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_shortPrompt, "shortPrompt", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ShortPrompt", &cb, act);
    return act;
}

bool SettingsServiceProxy::sendShortPromptDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("shortPrompt", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ShortPrompt", act, static_cast<int>(rv));
    return rv;
}

act_t SettingsServiceProxy::sendShortPromptGet(ShortPromptCallbackIF& cb) {
    SettingsServiceProxyCallback* callback = new SettingsServiceProxyCallback(ID_shortPrompt, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ShortPrompt", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("shortPrompt", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SettingsServiceProxy::sendShortPromptSet(bool shortPrompt) {
    ShortPromptSet parameter(shortPrompt);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "ShortPrompt");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "shortPrompt", propertyContent);
}

act_t SettingsServiceProxy::sendShortPromptSet(ShortPromptCallbackIF& cb, bool shortPrompt) {
    SettingsServiceProxyCallback* callback = new SettingsServiceProxyCallback(ID_shortPrompt, &cb);
    ShortPromptSet parameter(shortPrompt);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "ShortPrompt", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "shortPrompt", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool SettingsServiceProxy::getShortPrompt() const {
    return _shortPrompt.get().getShortPrompt();
}

bool SettingsServiceProxy::hasShortPrompt() const {
    return _shortPrompt.hasValue();
}

void SettingsServiceProxy::sendShortPromptDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ShortPrompt");
    _dbusProxyDelegate->deregisterSignalCallback("shortPrompt", 0, _dbusDaemonProxy.get(), true);
}

act_t SettingsServiceProxy::sendVoiceBargeInRegister(VoiceBargeInCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_voiceBargeIn, "voiceBargeIn", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "VoiceBargeIn", &cb, act);
    return act;
}

bool SettingsServiceProxy::sendVoiceBargeInDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("voiceBargeIn", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "VoiceBargeIn", act, static_cast<int>(rv));
    return rv;
}

act_t SettingsServiceProxy::sendVoiceBargeInGet(VoiceBargeInCallbackIF& cb) {
    SettingsServiceProxyCallback* callback = new SettingsServiceProxyCallback(ID_voiceBargeIn, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "VoiceBargeIn", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("voiceBargeIn", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SettingsServiceProxy::sendVoiceBargeInSet(bool voiceBargeIn) {
    VoiceBargeInSet parameter(voiceBargeIn);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "VoiceBargeIn");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "voiceBargeIn", propertyContent);
}

act_t SettingsServiceProxy::sendVoiceBargeInSet(VoiceBargeInCallbackIF& cb, bool voiceBargeIn) {
    SettingsServiceProxyCallback* callback = new SettingsServiceProxyCallback(ID_voiceBargeIn, &cb);
    VoiceBargeInSet parameter(voiceBargeIn);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "VoiceBargeIn", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "voiceBargeIn", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool SettingsServiceProxy::getVoiceBargeIn() const {
    return _voiceBargeIn.get().getVoiceBargeIn();
}

bool SettingsServiceProxy::hasVoiceBargeIn() const {
    return _voiceBargeIn.hasValue();
}

void SettingsServiceProxy::sendVoiceBargeInDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "VoiceBargeIn");
    _dbusProxyDelegate->deregisterSignalCallback("voiceBargeIn", 0, _dbusDaemonProxy.get(), true);
}

act_t SettingsServiceProxy::sendVoicePreferenceRegister(VoicePreferenceCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_voicePreference, "voicePreference", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "VoicePreference", &cb, act);
    return act;
}

bool SettingsServiceProxy::sendVoicePreferenceDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("voicePreference", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "VoicePreference", act, static_cast<int>(rv));
    return rv;
}

act_t SettingsServiceProxy::sendVoicePreferenceGet(VoicePreferenceCallbackIF& cb) {
    SettingsServiceProxyCallback* callback = new SettingsServiceProxyCallback(ID_voicePreference, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "VoicePreference", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("voicePreference", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SettingsServiceProxy::sendVoicePreferenceSet(ActiveSpeakerGender voicePreference) {
    VoicePreferenceSet parameter(voicePreference);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "VoicePreference");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "voicePreference", propertyContent);
}

act_t SettingsServiceProxy::sendVoicePreferenceSet(VoicePreferenceCallbackIF& cb, ActiveSpeakerGender voicePreference) {
    SettingsServiceProxyCallback* callback = new SettingsServiceProxyCallback(ID_voicePreference, &cb);
    VoicePreferenceSet parameter(voicePreference);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "VoicePreference", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "voicePreference", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

ActiveSpeakerGender SettingsServiceProxy::getVoicePreference() const {
    return _voicePreference.get().getVoicePreference();
}

bool SettingsServiceProxy::hasVoicePreference() const {
    return _voicePreference.hasValue();
}

void SettingsServiceProxy::sendVoicePreferenceDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "VoicePreference");
    _dbusProxyDelegate->deregisterSignalCallback("voicePreference", 0, _dbusDaemonProxy.get(), true);
}

act_t SettingsServiceProxy::sendSpeechRateRegister(SpeechRateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_speechRate, "speechRate", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SpeechRate", &cb, act);
    return act;
}

bool SettingsServiceProxy::sendSpeechRateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("speechRate", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SpeechRate", act, static_cast<int>(rv));
    return rv;
}

act_t SettingsServiceProxy::sendSpeechRateGet(SpeechRateCallbackIF& cb) {
    SettingsServiceProxyCallback* callback = new SettingsServiceProxyCallback(ID_speechRate, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SpeechRate", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("speechRate", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SettingsServiceProxy::sendSpeechRateSet(uint32 speechRate) {
    SpeechRateSet parameter(speechRate);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "SpeechRate");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "speechRate", propertyContent);
}

act_t SettingsServiceProxy::sendSpeechRateSet(SpeechRateCallbackIF& cb, uint32 speechRate) {
    SettingsServiceProxyCallback* callback = new SettingsServiceProxyCallback(ID_speechRate, &cb);
    SpeechRateSet parameter(speechRate);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "SpeechRate", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "speechRate", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

uint32 SettingsServiceProxy::getSpeechRate() const {
    return _speechRate.get().getSpeechRate();
}

bool SettingsServiceProxy::hasSpeechRate() const {
    return _speechRate.hasValue();
}

void SettingsServiceProxy::sendSpeechRateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SpeechRate");
    _dbusProxyDelegate->deregisterSignalCallback("speechRate", 0, _dbusDaemonProxy.get(), true);
}

act_t SettingsServiceProxy::sendSpeechRecognitionLanguageListRegister(SpeechRecognitionLanguageListCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_speechRecognitionLanguageList, "speechRecognitionLanguageList", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SpeechRecognitionLanguageList", &cb, act);
    return act;
}

bool SettingsServiceProxy::sendSpeechRecognitionLanguageListDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("speechRecognitionLanguageList", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SpeechRecognitionLanguageList", act, static_cast<int>(rv));
    return rv;
}

act_t SettingsServiceProxy::sendSpeechRecognitionLanguageListGet(SpeechRecognitionLanguageListCallbackIF& cb) {
    SettingsServiceProxyCallback* callback = new SettingsServiceProxyCallback(ID_speechRecognitionLanguageList, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SpeechRecognitionLanguageList", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("speechRecognitionLanguageList", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SettingsServiceProxy::sendSpeechRecognitionLanguageListSet(const ::std::vector< SpeechRecognitionLanguage >& speechRecognitionLanguageList) {
    SpeechRecognitionLanguageListSet parameter(speechRecognitionLanguageList);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "SpeechRecognitionLanguageList");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "speechRecognitionLanguageList", propertyContent);
}

act_t SettingsServiceProxy::sendSpeechRecognitionLanguageListSet(SpeechRecognitionLanguageListCallbackIF& cb, const ::std::vector< SpeechRecognitionLanguage >& speechRecognitionLanguageList) {
    SettingsServiceProxyCallback* callback = new SettingsServiceProxyCallback(ID_speechRecognitionLanguageList, &cb);
    SpeechRecognitionLanguageListSet parameter(speechRecognitionLanguageList);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "SpeechRecognitionLanguageList", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "speechRecognitionLanguageList", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::std::vector< SpeechRecognitionLanguage >& SettingsServiceProxy::getSpeechRecognitionLanguageList() const {
    return _speechRecognitionLanguageList.get().getSpeechRecognitionLanguageList();
}

bool SettingsServiceProxy::hasSpeechRecognitionLanguageList() const {
    return _speechRecognitionLanguageList.hasValue();
}

void SettingsServiceProxy::sendSpeechRecognitionLanguageListDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SpeechRecognitionLanguageList");
    _dbusProxyDelegate->deregisterSignalCallback("speechRecognitionLanguageList", 0, _dbusDaemonProxy.get(), true);
}

} // namespace SettingsService
} // namespace sds_gui_fi
