#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_GUI_FI_SETTINGSSERVICE_H
#define SDS_GUI_FI_SETTINGSSERVICE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "sds_gui_fi/SettingsServiceConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "sds_gui_fi.SettingsService" isn't clear, then there should be a description here.
 */

namespace sds_gui_fi {
namespace SettingsService {

// method IDs

// signal IDs

// property IDs
static const uint16 ID_bestMatchAudio = 0;
static const uint16 ID_bestMatchPhoneBook = 1;
static const uint16 ID_beepOnlyMode = 2;
static const uint16 ID_shortPrompt = 3;
static const uint16 ID_voiceBargeIn = 4;
static const uint16 ID_voicePreference = 5;
static const uint16 ID_speechRate = 6;
static const uint16 ID_speechRecognitionLanguageList = 7;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class SpeechRecognitionLanguage;

class BestMatchAudioUpdate;

class BestMatchAudioRegister;

class BestMatchPhoneBookUpdate;

class BestMatchPhoneBookRegister;

class BeepOnlyModeUpdate;

class BeepOnlyModeRegister;

class ShortPromptUpdate;

class ShortPromptRegister;

class VoiceBargeInUpdate;

class VoiceBargeInRegister;

class VoicePreferenceUpdate;

class VoicePreferenceRegister;

class SpeechRateUpdate;

class SpeechRateRegister;

class SpeechRecognitionLanguageListUpdate;

class SpeechRecognitionLanguageListRegister;

// type definitions
/**
 * If the meaning of "bestMatchAudio" isn't clear, then there should be a description here.
 */
typedef BestMatchAudioUpdate BestMatchAudioSet;

/**
 * If the meaning of "bestMatchAudio" isn't clear, then there should be a description here.
 */
typedef BestMatchAudioUpdate BestMatchAudioGet;

/**
 * If the meaning of "BestMatchAudioError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BestMatchAudioError;

/**
 * If the meaning of "bestMatchPhoneBook" isn't clear, then there should be a description here.
 */
typedef BestMatchPhoneBookUpdate BestMatchPhoneBookSet;

/**
 * If the meaning of "bestMatchPhoneBook" isn't clear, then there should be a description here.
 */
typedef BestMatchPhoneBookUpdate BestMatchPhoneBookGet;

/**
 * If the meaning of "BestMatchPhoneBookError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BestMatchPhoneBookError;

/**
 * If the meaning of "beepOnlyMode" isn't clear, then there should be a description here.
 */
typedef BeepOnlyModeUpdate BeepOnlyModeSet;

/**
 * If the meaning of "beepOnlyMode" isn't clear, then there should be a description here.
 */
typedef BeepOnlyModeUpdate BeepOnlyModeGet;

/**
 * If the meaning of "BeepOnlyModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BeepOnlyModeError;

/**
 * If the meaning of "shortPrompt" isn't clear, then there should be a description here.
 */
typedef ShortPromptUpdate ShortPromptSet;

/**
 * If the meaning of "shortPrompt" isn't clear, then there should be a description here.
 */
typedef ShortPromptUpdate ShortPromptGet;

/**
 * If the meaning of "ShortPromptError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShortPromptError;

/**
 * If the meaning of "voiceBargeIn" isn't clear, then there should be a description here.
 */
typedef VoiceBargeInUpdate VoiceBargeInSet;

/**
 * If the meaning of "voiceBargeIn" isn't clear, then there should be a description here.
 */
typedef VoiceBargeInUpdate VoiceBargeInGet;

/**
 * If the meaning of "VoiceBargeInError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VoiceBargeInError;

/**
 * If the meaning of "voicePreference" isn't clear, then there should be a description here.
 */
typedef VoicePreferenceUpdate VoicePreferenceSet;

/**
 * If the meaning of "voicePreference" isn't clear, then there should be a description here.
 */
typedef VoicePreferenceUpdate VoicePreferenceGet;

/**
 * If the meaning of "VoicePreferenceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VoicePreferenceError;

/**
 * If the meaning of "speechRate" isn't clear, then there should be a description here.
 */
typedef SpeechRateUpdate SpeechRateSet;

/**
 * If the meaning of "speechRate" isn't clear, then there should be a description here.
 */
typedef SpeechRateUpdate SpeechRateGet;

/**
 * If the meaning of "SpeechRateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SpeechRateError;

/**
 * If the meaning of "speechRecognitionLanguageList" isn't clear, then there should be a description here.
 */
typedef SpeechRecognitionLanguageListUpdate SpeechRecognitionLanguageListSet;

/**
 * If the meaning of "speechRecognitionLanguageList" isn't clear, then there should be a description here.
 */
typedef SpeechRecognitionLanguageListUpdate SpeechRecognitionLanguageListGet;

/**
 * If the meaning of "SpeechRecognitionLanguageListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SpeechRecognitionLanguageListError;


/**
 * If the meaning of "SpeechRecognitionLanguage" isn't clear, then there should be a description here.
 */
class SpeechRecognitionLanguage {
public:

    /**
     * Default constructor
     */
    inline  SpeechRecognitionLanguage ();

    /**
     * Copy constructor
     */
    inline  SpeechRecognitionLanguage (const SpeechRecognitionLanguage &rhs);

    /**
     * All fields constructor
     */
    inline  SpeechRecognitionLanguage (uint16 speakerId_, const ::std::string& speakerName_, uint16 isoLanguageCode_, uint16 isoCountryCode_, uint8 gender_, bool asrSupported_);

    /**
     * Destructor
     */
    inline  ~SpeechRecognitionLanguage();

    /**
     * Assignment operator
     */
    inline SpeechRecognitionLanguage& operator = (const SpeechRecognitionLanguage& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeechRecognitionLanguage& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeechRecognitionLanguage& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeechRecognitionLanguage& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeechRecognitionLanguage& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "speakerId"

    static const int kSpeakerId = 0;

    /**
     * Clears the field "speakerId".
     *
     * The field will be set to its default value. The hasSpeakerId()
     * method will return false.
     */
    inline void clearSpeakerId();

    /**
     * Checks whether the field "speakerId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeakerId()). Otherwise it will return false.
     */
    inline bool hasSpeakerId () const;

    /**
     * Returns the value of the member "speakerId".
     *
     * If the meaning of "speakerId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "speakerId"
     */
    inline uint16 getSpeakerId () const;

    /**
     * Sets the value of the member "speakerId".
     *
     * If the meaning of "speakerId" isn't clear, then there should be a description here.
     *
     * @param speakerId The value which will be set
     */
    inline void setSpeakerId (uint16 speakerId_);

    // API of field "speakerName"

    static const int kSpeakerName = 1;

    /**
     * Clears the field "speakerName".
     *
     * The field will be set to its default value. The hasSpeakerName()
     * method will return false.
     */
    inline void clearSpeakerName();

    /**
     * Checks whether the field "speakerName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeakerName()). Otherwise it will return false.
     */
    inline bool hasSpeakerName () const;

    /**
     * Returns the value of the member "speakerName".
     *
     * If the meaning of "speakerName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "speakerName"
     */
    inline const ::std::string& getSpeakerName () const;

    /**
     * Retrieves the value of the field "speakerName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "speakerName".
     */
    inline ::std::string& getSpeakerNameMutable ();

    /**
     * Sets the value of the member "speakerName".
     *
     * If the meaning of "speakerName" isn't clear, then there should be a description here.
     *
     * @param speakerName The value which will be set
     */
    inline void setSpeakerName (const ::std::string& speakerName_);

    /**
     * Sets the value of the member "speakerName".
     *
     * If the meaning of "speakerName" isn't clear, then there should be a description here.
     *
     * @param speakerName The value which will be set
     */
    inline void setSpeakerName (const char* speakerName_);

    /**
     * Sets the value of the member "speakerName".
     *
     * If the meaning of "speakerName" isn't clear, then there should be a description here.
     *
     * @param speakerName The value which will be set
     */
    inline void setSpeakerName (const char* value, size_t size);

    // API of field "isoLanguageCode"

    static const int kIsoLanguageCode = 2;

    /**
     * Clears the field "isoLanguageCode".
     *
     * The field will be set to its default value. The hasIsoLanguageCode()
     * method will return false.
     */
    inline void clearIsoLanguageCode();

    /**
     * Checks whether the field "isoLanguageCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsoLanguageCode()). Otherwise it will return false.
     */
    inline bool hasIsoLanguageCode () const;

    /**
     * Returns the value of the member "isoLanguageCode".
     *
     * If the meaning of "isoLanguageCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isoLanguageCode"
     */
    inline uint16 getIsoLanguageCode () const;

    /**
     * Sets the value of the member "isoLanguageCode".
     *
     * If the meaning of "isoLanguageCode" isn't clear, then there should be a description here.
     *
     * @param isoLanguageCode The value which will be set
     */
    inline void setIsoLanguageCode (uint16 isoLanguageCode_);

    // API of field "isoCountryCode"

    static const int kIsoCountryCode = 3;

    /**
     * Clears the field "isoCountryCode".
     *
     * The field will be set to its default value. The hasIsoCountryCode()
     * method will return false.
     */
    inline void clearIsoCountryCode();

    /**
     * Checks whether the field "isoCountryCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsoCountryCode()). Otherwise it will return false.
     */
    inline bool hasIsoCountryCode () const;

    /**
     * Returns the value of the member "isoCountryCode".
     *
     * If the meaning of "isoCountryCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isoCountryCode"
     */
    inline uint16 getIsoCountryCode () const;

    /**
     * Sets the value of the member "isoCountryCode".
     *
     * If the meaning of "isoCountryCode" isn't clear, then there should be a description here.
     *
     * @param isoCountryCode The value which will be set
     */
    inline void setIsoCountryCode (uint16 isoCountryCode_);

    // API of field "gender"

    static const int kGender = 4;

    /**
     * Clears the field "gender".
     *
     * The field will be set to its default value. The hasGender()
     * method will return false.
     */
    inline void clearGender();

    /**
     * Checks whether the field "gender" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGender()). Otherwise it will return false.
     */
    inline bool hasGender () const;

    /**
     * Returns the value of the member "gender".
     *
     * If the meaning of "gender" isn't clear, then there should be a description here.
     *
     * @return The value of the field "gender"
     */
    inline uint8 getGender () const;

    /**
     * Sets the value of the member "gender".
     *
     * If the meaning of "gender" isn't clear, then there should be a description here.
     *
     * @param gender The value which will be set
     */
    inline void setGender (uint8 gender_);

    // API of field "asrSupported"

    static const int kAsrSupported = 5;

    /**
     * Clears the field "asrSupported".
     *
     * The field will be set to its default value. The hasAsrSupported()
     * method will return false.
     */
    inline void clearAsrSupported();

    /**
     * Checks whether the field "asrSupported" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAsrSupported()). Otherwise it will return false.
     */
    inline bool hasAsrSupported () const;

    /**
     * Returns the value of the member "asrSupported".
     *
     * If the meaning of "asrSupported" isn't clear, then there should be a description here.
     *
     * @return The value of the field "asrSupported"
     */
    inline bool getAsrSupported () const;

    /**
     * Sets the value of the member "asrSupported".
     *
     * If the meaning of "asrSupported" isn't clear, then there should be a description here.
     *
     * @param asrSupported The value which will be set
     */
    inline void setAsrSupported (bool asrSupported_);

    static const SpeechRecognitionLanguage &getDefaultInstance();

private:

    inline void set_has_speakerId ();

    inline void clear_has_speakerId ();

    inline void set_has_speakerName ();

    inline void clear_has_speakerName ();

    inline void set_has_isoLanguageCode ();

    inline void clear_has_isoLanguageCode ();

    inline void set_has_isoCountryCode ();

    inline void clear_has_isoCountryCode ();

    inline void set_has_gender ();

    inline void clear_has_gender ();

    inline void set_has_asrSupported ();

    inline void clear_has_asrSupported ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint16 _speakerId;

    ::std::string _speakerName;

    uint16 _isoLanguageCode;

    uint16 _isoCountryCode;

    uint8 _gender;

    bool _asrSupported;

};

/**
 * If the meaning of "bestMatchAudio" isn't clear, then there should be a description here.
 */
class BestMatchAudioUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BestMatchAudioUpdate ();

    /**
     * Copy constructor
     */
    inline  BestMatchAudioUpdate (const BestMatchAudioUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  BestMatchAudioUpdate (bool bestMatchAudio_);

    /**
     * Destructor
     */
    inline virtual  ~BestMatchAudioUpdate();

    /**
     * Assignment operator
     */
    inline BestMatchAudioUpdate& operator = (const BestMatchAudioUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BestMatchAudioUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BestMatchAudioUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BestMatchAudioUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BestMatchAudioUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bestMatchAudio"

    static const int kBestMatchAudio = 0;

    /**
     * Clears the field "bestMatchAudio".
     *
     * The field will be set to its default value. The hasBestMatchAudio()
     * method will return false.
     */
    inline void clearBestMatchAudio();

    /**
     * Checks whether the field "bestMatchAudio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBestMatchAudio()). Otherwise it will return false.
     */
    inline bool hasBestMatchAudio () const;

    /**
     * Returns the value of the member "bestMatchAudio".
     *
     * If the meaning of "bestMatchAudio" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bestMatchAudio"
     */
    inline bool getBestMatchAudio () const;

    /**
     * Sets the value of the member "bestMatchAudio".
     *
     * If the meaning of "bestMatchAudio" isn't clear, then there should be a description here.
     *
     * @param bestMatchAudio The value which will be set
     */
    inline void setBestMatchAudio (bool bestMatchAudio_);

    static const BestMatchAudioUpdate &getDefaultInstance();

private:

    inline void set_has_bestMatchAudio ();

    inline void clear_has_bestMatchAudio ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bestMatchAudio;

};

/**
 * If the meaning of "bestMatchAudio" isn't clear, then there should be a description here.
 */
class BestMatchAudioRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BestMatchAudioRegister ();

    /**
     * Copy constructor
     */
    inline  BestMatchAudioRegister (const BestMatchAudioRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~BestMatchAudioRegister();

    /**
     * Assignment operator
     */
    inline BestMatchAudioRegister& operator = (const BestMatchAudioRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BestMatchAudioRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BestMatchAudioRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BestMatchAudioRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BestMatchAudioRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const BestMatchAudioRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "bestMatchPhoneBook" isn't clear, then there should be a description here.
 */
class BestMatchPhoneBookUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BestMatchPhoneBookUpdate ();

    /**
     * Copy constructor
     */
    inline  BestMatchPhoneBookUpdate (const BestMatchPhoneBookUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  BestMatchPhoneBookUpdate (bool bestMatchPhoneBook_);

    /**
     * Destructor
     */
    inline virtual  ~BestMatchPhoneBookUpdate();

    /**
     * Assignment operator
     */
    inline BestMatchPhoneBookUpdate& operator = (const BestMatchPhoneBookUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BestMatchPhoneBookUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BestMatchPhoneBookUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BestMatchPhoneBookUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BestMatchPhoneBookUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bestMatchPhoneBook"

    static const int kBestMatchPhoneBook = 0;

    /**
     * Clears the field "bestMatchPhoneBook".
     *
     * The field will be set to its default value. The hasBestMatchPhoneBook()
     * method will return false.
     */
    inline void clearBestMatchPhoneBook();

    /**
     * Checks whether the field "bestMatchPhoneBook" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBestMatchPhoneBook()). Otherwise it will return false.
     */
    inline bool hasBestMatchPhoneBook () const;

    /**
     * Returns the value of the member "bestMatchPhoneBook".
     *
     * If the meaning of "bestMatchPhoneBook" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bestMatchPhoneBook"
     */
    inline bool getBestMatchPhoneBook () const;

    /**
     * Sets the value of the member "bestMatchPhoneBook".
     *
     * If the meaning of "bestMatchPhoneBook" isn't clear, then there should be a description here.
     *
     * @param bestMatchPhoneBook The value which will be set
     */
    inline void setBestMatchPhoneBook (bool bestMatchPhoneBook_);

    static const BestMatchPhoneBookUpdate &getDefaultInstance();

private:

    inline void set_has_bestMatchPhoneBook ();

    inline void clear_has_bestMatchPhoneBook ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bestMatchPhoneBook;

};

/**
 * If the meaning of "bestMatchPhoneBook" isn't clear, then there should be a description here.
 */
class BestMatchPhoneBookRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BestMatchPhoneBookRegister ();

    /**
     * Copy constructor
     */
    inline  BestMatchPhoneBookRegister (const BestMatchPhoneBookRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~BestMatchPhoneBookRegister();

    /**
     * Assignment operator
     */
    inline BestMatchPhoneBookRegister& operator = (const BestMatchPhoneBookRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BestMatchPhoneBookRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BestMatchPhoneBookRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BestMatchPhoneBookRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BestMatchPhoneBookRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const BestMatchPhoneBookRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "beepOnlyMode" isn't clear, then there should be a description here.
 */
class BeepOnlyModeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BeepOnlyModeUpdate ();

    /**
     * Copy constructor
     */
    inline  BeepOnlyModeUpdate (const BeepOnlyModeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  BeepOnlyModeUpdate (bool beepOnlyMode_);

    /**
     * Destructor
     */
    inline virtual  ~BeepOnlyModeUpdate();

    /**
     * Assignment operator
     */
    inline BeepOnlyModeUpdate& operator = (const BeepOnlyModeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BeepOnlyModeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BeepOnlyModeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BeepOnlyModeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BeepOnlyModeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "beepOnlyMode"

    static const int kBeepOnlyMode = 0;

    /**
     * Clears the field "beepOnlyMode".
     *
     * The field will be set to its default value. The hasBeepOnlyMode()
     * method will return false.
     */
    inline void clearBeepOnlyMode();

    /**
     * Checks whether the field "beepOnlyMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBeepOnlyMode()). Otherwise it will return false.
     */
    inline bool hasBeepOnlyMode () const;

    /**
     * Returns the value of the member "beepOnlyMode".
     *
     * If the meaning of "beepOnlyMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "beepOnlyMode"
     */
    inline bool getBeepOnlyMode () const;

    /**
     * Sets the value of the member "beepOnlyMode".
     *
     * If the meaning of "beepOnlyMode" isn't clear, then there should be a description here.
     *
     * @param beepOnlyMode The value which will be set
     */
    inline void setBeepOnlyMode (bool beepOnlyMode_);

    static const BeepOnlyModeUpdate &getDefaultInstance();

private:

    inline void set_has_beepOnlyMode ();

    inline void clear_has_beepOnlyMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _beepOnlyMode;

};

/**
 * If the meaning of "beepOnlyMode" isn't clear, then there should be a description here.
 */
class BeepOnlyModeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BeepOnlyModeRegister ();

    /**
     * Copy constructor
     */
    inline  BeepOnlyModeRegister (const BeepOnlyModeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~BeepOnlyModeRegister();

    /**
     * Assignment operator
     */
    inline BeepOnlyModeRegister& operator = (const BeepOnlyModeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BeepOnlyModeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BeepOnlyModeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BeepOnlyModeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BeepOnlyModeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const BeepOnlyModeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "shortPrompt" isn't clear, then there should be a description here.
 */
class ShortPromptUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShortPromptUpdate ();

    /**
     * Copy constructor
     */
    inline  ShortPromptUpdate (const ShortPromptUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ShortPromptUpdate (bool shortPrompt_);

    /**
     * Destructor
     */
    inline virtual  ~ShortPromptUpdate();

    /**
     * Assignment operator
     */
    inline ShortPromptUpdate& operator = (const ShortPromptUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShortPromptUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShortPromptUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShortPromptUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShortPromptUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "shortPrompt"

    static const int kShortPrompt = 0;

    /**
     * Clears the field "shortPrompt".
     *
     * The field will be set to its default value. The hasShortPrompt()
     * method will return false.
     */
    inline void clearShortPrompt();

    /**
     * Checks whether the field "shortPrompt" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setShortPrompt()). Otherwise it will return false.
     */
    inline bool hasShortPrompt () const;

    /**
     * Returns the value of the member "shortPrompt".
     *
     * If the meaning of "shortPrompt" isn't clear, then there should be a description here.
     *
     * @return The value of the field "shortPrompt"
     */
    inline bool getShortPrompt () const;

    /**
     * Sets the value of the member "shortPrompt".
     *
     * If the meaning of "shortPrompt" isn't clear, then there should be a description here.
     *
     * @param shortPrompt The value which will be set
     */
    inline void setShortPrompt (bool shortPrompt_);

    static const ShortPromptUpdate &getDefaultInstance();

private:

    inline void set_has_shortPrompt ();

    inline void clear_has_shortPrompt ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _shortPrompt;

};

/**
 * If the meaning of "shortPrompt" isn't clear, then there should be a description here.
 */
class ShortPromptRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShortPromptRegister ();

    /**
     * Copy constructor
     */
    inline  ShortPromptRegister (const ShortPromptRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ShortPromptRegister();

    /**
     * Assignment operator
     */
    inline ShortPromptRegister& operator = (const ShortPromptRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShortPromptRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShortPromptRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShortPromptRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShortPromptRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ShortPromptRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "voiceBargeIn" isn't clear, then there should be a description here.
 */
class VoiceBargeInUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VoiceBargeInUpdate ();

    /**
     * Copy constructor
     */
    inline  VoiceBargeInUpdate (const VoiceBargeInUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  VoiceBargeInUpdate (bool voiceBargeIn_);

    /**
     * Destructor
     */
    inline virtual  ~VoiceBargeInUpdate();

    /**
     * Assignment operator
     */
    inline VoiceBargeInUpdate& operator = (const VoiceBargeInUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoiceBargeInUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoiceBargeInUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoiceBargeInUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoiceBargeInUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "voiceBargeIn"

    static const int kVoiceBargeIn = 0;

    /**
     * Clears the field "voiceBargeIn".
     *
     * The field will be set to its default value. The hasVoiceBargeIn()
     * method will return false.
     */
    inline void clearVoiceBargeIn();

    /**
     * Checks whether the field "voiceBargeIn" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoiceBargeIn()). Otherwise it will return false.
     */
    inline bool hasVoiceBargeIn () const;

    /**
     * Returns the value of the member "voiceBargeIn".
     *
     * If the meaning of "voiceBargeIn" isn't clear, then there should be a description here.
     *
     * @return The value of the field "voiceBargeIn"
     */
    inline bool getVoiceBargeIn () const;

    /**
     * Sets the value of the member "voiceBargeIn".
     *
     * If the meaning of "voiceBargeIn" isn't clear, then there should be a description here.
     *
     * @param voiceBargeIn The value which will be set
     */
    inline void setVoiceBargeIn (bool voiceBargeIn_);

    static const VoiceBargeInUpdate &getDefaultInstance();

private:

    inline void set_has_voiceBargeIn ();

    inline void clear_has_voiceBargeIn ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _voiceBargeIn;

};

/**
 * If the meaning of "voiceBargeIn" isn't clear, then there should be a description here.
 */
class VoiceBargeInRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VoiceBargeInRegister ();

    /**
     * Copy constructor
     */
    inline  VoiceBargeInRegister (const VoiceBargeInRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~VoiceBargeInRegister();

    /**
     * Assignment operator
     */
    inline VoiceBargeInRegister& operator = (const VoiceBargeInRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoiceBargeInRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoiceBargeInRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoiceBargeInRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoiceBargeInRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const VoiceBargeInRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "voicePreference" isn't clear, then there should be a description here.
 */
class VoicePreferenceUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VoicePreferenceUpdate ();

    /**
     * Copy constructor
     */
    inline  VoicePreferenceUpdate (const VoicePreferenceUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  VoicePreferenceUpdate (ActiveSpeakerGender voicePreference_);

    /**
     * Destructor
     */
    inline virtual  ~VoicePreferenceUpdate();

    /**
     * Assignment operator
     */
    inline VoicePreferenceUpdate& operator = (const VoicePreferenceUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoicePreferenceUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoicePreferenceUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoicePreferenceUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoicePreferenceUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "voicePreference"

    static const int kVoicePreference = 0;

    /**
     * Clears the field "voicePreference".
     *
     * The field will be set to its default value. The hasVoicePreference()
     * method will return false.
     */
    inline void clearVoicePreference();

    /**
     * Checks whether the field "voicePreference" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoicePreference()). Otherwise it will return false.
     */
    inline bool hasVoicePreference () const;

    /**
     * Returns the value of the member "voicePreference".
     *
     * If the meaning of "voicePreference" isn't clear, then there should be a description here.
     *
     * @return The value of the field "voicePreference"
     */
    inline ActiveSpeakerGender getVoicePreference () const;

    /**
     * Sets the value of the member "voicePreference".
     *
     * If the meaning of "voicePreference" isn't clear, then there should be a description here.
     *
     * @param voicePreference The value which will be set
     */
    inline void setVoicePreference (ActiveSpeakerGender voicePreference_);

    static const VoicePreferenceUpdate &getDefaultInstance();

private:

    inline void set_has_voicePreference ();

    inline void clear_has_voicePreference ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ActiveSpeakerGender _voicePreference;

};

/**
 * If the meaning of "voicePreference" isn't clear, then there should be a description here.
 */
class VoicePreferenceRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VoicePreferenceRegister ();

    /**
     * Copy constructor
     */
    inline  VoicePreferenceRegister (const VoicePreferenceRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~VoicePreferenceRegister();

    /**
     * Assignment operator
     */
    inline VoicePreferenceRegister& operator = (const VoicePreferenceRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoicePreferenceRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoicePreferenceRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoicePreferenceRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoicePreferenceRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const VoicePreferenceRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "speechRate" isn't clear, then there should be a description here.
 */
class SpeechRateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeechRateUpdate ();

    /**
     * Copy constructor
     */
    inline  SpeechRateUpdate (const SpeechRateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SpeechRateUpdate (uint32 speechRate_);

    /**
     * Destructor
     */
    inline virtual  ~SpeechRateUpdate();

    /**
     * Assignment operator
     */
    inline SpeechRateUpdate& operator = (const SpeechRateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeechRateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeechRateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeechRateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeechRateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "speechRate"

    static const int kSpeechRate = 0;

    /**
     * Clears the field "speechRate".
     *
     * The field will be set to its default value. The hasSpeechRate()
     * method will return false.
     */
    inline void clearSpeechRate();

    /**
     * Checks whether the field "speechRate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeechRate()). Otherwise it will return false.
     */
    inline bool hasSpeechRate () const;

    /**
     * Returns the value of the member "speechRate".
     *
     * If the meaning of "speechRate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "speechRate"
     */
    inline uint32 getSpeechRate () const;

    /**
     * Sets the value of the member "speechRate".
     *
     * If the meaning of "speechRate" isn't clear, then there should be a description here.
     *
     * @param speechRate The value which will be set
     */
    inline void setSpeechRate (uint32 speechRate_);

    static const SpeechRateUpdate &getDefaultInstance();

private:

    inline void set_has_speechRate ();

    inline void clear_has_speechRate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _speechRate;

};

/**
 * If the meaning of "speechRate" isn't clear, then there should be a description here.
 */
class SpeechRateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeechRateRegister ();

    /**
     * Copy constructor
     */
    inline  SpeechRateRegister (const SpeechRateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SpeechRateRegister();

    /**
     * Assignment operator
     */
    inline SpeechRateRegister& operator = (const SpeechRateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeechRateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeechRateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeechRateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeechRateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SpeechRateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "speechRecognitionLanguageList" isn't clear, then there should be a description here.
 */
class SpeechRecognitionLanguageListUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeechRecognitionLanguageListUpdate ();

    /**
     * Copy constructor
     */
    inline  SpeechRecognitionLanguageListUpdate (const SpeechRecognitionLanguageListUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SpeechRecognitionLanguageListUpdate (const ::std::vector< SpeechRecognitionLanguage >& speechRecognitionLanguageList_);

    /**
     * Destructor
     */
    inline virtual  ~SpeechRecognitionLanguageListUpdate();

    /**
     * Assignment operator
     */
    inline SpeechRecognitionLanguageListUpdate& operator = (const SpeechRecognitionLanguageListUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeechRecognitionLanguageListUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeechRecognitionLanguageListUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeechRecognitionLanguageListUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeechRecognitionLanguageListUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "speechRecognitionLanguageList"

    static const int kSpeechRecognitionLanguageList = 0;

    /**
     * Clears the field "speechRecognitionLanguageList".
     *
     * The field will be set to its default value. The hasSpeechRecognitionLanguageList()
     * method will return false.
     */
    inline void clearSpeechRecognitionLanguageList();

    /**
     * Checks whether the field "speechRecognitionLanguageList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeechRecognitionLanguageList()). Otherwise it will return false.
     */
    inline bool hasSpeechRecognitionLanguageList () const;

    /**
     * Returns the value of the member "speechRecognitionLanguageList".
     *
     * If the meaning of "speechRecognitionLanguageList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "speechRecognitionLanguageList"
     */
    inline const ::std::vector< SpeechRecognitionLanguage >& getSpeechRecognitionLanguageList () const;

    /**
     * Retrieves the value of the field "speechRecognitionLanguageList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "speechRecognitionLanguageList".
     */
    inline ::std::vector< SpeechRecognitionLanguage >& getSpeechRecognitionLanguageListMutable ();

    /**
     * Sets the value of the member "speechRecognitionLanguageList".
     *
     * If the meaning of "speechRecognitionLanguageList" isn't clear, then there should be a description here.
     *
     * @param speechRecognitionLanguageList The value which will be set
     */
    inline void setSpeechRecognitionLanguageList (const ::std::vector< SpeechRecognitionLanguage >& speechRecognitionLanguageList_);

    static const SpeechRecognitionLanguageListUpdate &getDefaultInstance();

private:

    static const ::std::vector< SpeechRecognitionLanguage >& getSpeechRecognitionLanguageList_DefaultInstance ();

    inline void set_has_speechRecognitionLanguageList ();

    inline void clear_has_speechRecognitionLanguageList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< SpeechRecognitionLanguage > _speechRecognitionLanguageList;

};

/**
 * If the meaning of "speechRecognitionLanguageList" isn't clear, then there should be a description here.
 */
class SpeechRecognitionLanguageListRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeechRecognitionLanguageListRegister ();

    /**
     * Copy constructor
     */
    inline  SpeechRecognitionLanguageListRegister (const SpeechRecognitionLanguageListRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SpeechRecognitionLanguageListRegister();

    /**
     * Assignment operator
     */
    inline SpeechRecognitionLanguageListRegister& operator = (const SpeechRecognitionLanguageListRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeechRecognitionLanguageListRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeechRecognitionLanguageListRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeechRecognitionLanguageListRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeechRecognitionLanguageListRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SpeechRecognitionLanguageListRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  SpeechRecognitionLanguage::SpeechRecognitionLanguage ()  :
    _speakerId (0u),
    _speakerName (),
    _isoLanguageCode (0u),
    _isoCountryCode (0u),
    _gender (0u),
    _asrSupported (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SpeechRecognitionLanguage::SpeechRecognitionLanguage (const SpeechRecognitionLanguage &rhs)  :
    _speakerId (0u),
    _speakerName (),
    _isoLanguageCode (0u),
    _isoCountryCode (0u),
    _gender (0u),
    _asrSupported (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SpeechRecognitionLanguage::SpeechRecognitionLanguage (uint16 speakerId_, const ::std::string& speakerName_, uint16 isoLanguageCode_, uint16 isoCountryCode_, uint8 gender_, bool asrSupported_)  :
    _speakerId (speakerId_),
    _speakerName (speakerName_),
    _isoLanguageCode (isoLanguageCode_),
    _isoCountryCode (isoCountryCode_),
    _gender (gender_),
    _asrSupported (asrSupported_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (speakerName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SpeechRecognitionLanguage::~SpeechRecognitionLanguage() {
}

inline SpeechRecognitionLanguage& SpeechRecognitionLanguage::operator = (const SpeechRecognitionLanguage& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSpeakerId()) {
            setSpeakerId(rhs.getSpeakerId());
        } else {
            clearSpeakerId();
        }
        if (rhs.hasSpeakerName()) {
            setSpeakerName(rhs.getSpeakerName());
        } else {
            clearSpeakerName();
        }
        if (rhs.hasIsoLanguageCode()) {
            setIsoLanguageCode(rhs.getIsoLanguageCode());
        } else {
            clearIsoLanguageCode();
        }
        if (rhs.hasIsoCountryCode()) {
            setIsoCountryCode(rhs.getIsoCountryCode());
        } else {
            clearIsoCountryCode();
        }
        if (rhs.hasGender()) {
            setGender(rhs.getGender());
        } else {
            clearGender();
        }
        if (rhs.hasAsrSupported()) {
            setAsrSupported(rhs.getAsrSupported());
        } else {
            clearAsrSupported();
        }
    }
    return *this;
}

inline bool SpeechRecognitionLanguage::operator == (const SpeechRecognitionLanguage& rhs) const {
    return (((!hasSpeakerId() && !rhs.hasSpeakerId()) || getSpeakerId() == rhs.getSpeakerId()) &&
        ((!hasSpeakerName() && !rhs.hasSpeakerName()) || getSpeakerName() == rhs.getSpeakerName()) &&
        ((!hasIsoLanguageCode() && !rhs.hasIsoLanguageCode()) || getIsoLanguageCode() == rhs.getIsoLanguageCode()) &&
        ((!hasIsoCountryCode() && !rhs.hasIsoCountryCode()) || getIsoCountryCode() == rhs.getIsoCountryCode()) &&
        ((!hasGender() && !rhs.hasGender()) || getGender() == rhs.getGender()) &&
        ((!hasAsrSupported() && !rhs.hasAsrSupported()) || getAsrSupported() == rhs.getAsrSupported()));
}

inline bool SpeechRecognitionLanguage::operator != (const SpeechRecognitionLanguage& rhs) const {
    return ! (*this == rhs);
}

inline bool SpeechRecognitionLanguage::operator < (const SpeechRecognitionLanguage& rhs) const {
    if (hasSpeakerId() || rhs.hasSpeakerId()) {
        if (getSpeakerId() < rhs.getSpeakerId()) return true;
        if (getSpeakerId() > rhs.getSpeakerId()) return false;
    }
    if (hasSpeakerName() || rhs.hasSpeakerName()) {
        if (getSpeakerName() < rhs.getSpeakerName()) return true;
        if (getSpeakerName() > rhs.getSpeakerName()) return false;
    }
    if (hasIsoLanguageCode() || rhs.hasIsoLanguageCode()) {
        if (getIsoLanguageCode() < rhs.getIsoLanguageCode()) return true;
        if (getIsoLanguageCode() > rhs.getIsoLanguageCode()) return false;
    }
    if (hasIsoCountryCode() || rhs.hasIsoCountryCode()) {
        if (getIsoCountryCode() < rhs.getIsoCountryCode()) return true;
        if (getIsoCountryCode() > rhs.getIsoCountryCode()) return false;
    }
    if (hasGender() || rhs.hasGender()) {
        if (getGender() < rhs.getGender()) return true;
        if (getGender() > rhs.getGender()) return false;
    }
    if (hasAsrSupported() || rhs.hasAsrSupported()) {
        if (getAsrSupported() < rhs.getAsrSupported()) return true;
        if (getAsrSupported() > rhs.getAsrSupported()) return false;
    }
    return false;
}

inline bool SpeechRecognitionLanguage::operator > (const SpeechRecognitionLanguage& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SpeechRecognitionLanguage::clear() {
    clearSpeakerId();
    clearSpeakerName();
    clearIsoLanguageCode();
    clearIsoCountryCode();
    clearGender();
    clearAsrSupported();
}

inline void SpeechRecognitionLanguage::clearSpeakerId() {
    if (hasSpeakerId()) {
         clear_has_speakerId();
        _speakerId = 0u;
     }
}

inline bool SpeechRecognitionLanguage::hasSpeakerId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SpeechRecognitionLanguage::getSpeakerId () const {
    return _speakerId;
}

inline void SpeechRecognitionLanguage::setSpeakerId (uint16 speakerId_) {
    set_has_speakerId();
    this->_speakerId = speakerId_;
}

inline void SpeechRecognitionLanguage::clearSpeakerName() {
    if (hasSpeakerName()) {
         clear_has_speakerName();
        _speakerName.clear();
     }
}

inline bool SpeechRecognitionLanguage::hasSpeakerName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SpeechRecognitionLanguage::getSpeakerName () const {
    return _speakerName;
}

inline ::std::string& SpeechRecognitionLanguage::getSpeakerNameMutable () {
    set_has_speakerName();
    return _speakerName;
}

inline void SpeechRecognitionLanguage::setSpeakerName (const ::std::string& speakerName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (speakerName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_speakerName();
    this->_speakerName = speakerName_;
}

inline void SpeechRecognitionLanguage::setSpeakerName (const char* speakerName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (speakerName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_speakerName();
    this->_speakerName.assign(speakerName_);
}

inline void SpeechRecognitionLanguage::setSpeakerName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_speakerName();
    this->_speakerName.assign(value, size);
}

inline void SpeechRecognitionLanguage::clearIsoLanguageCode() {
    if (hasIsoLanguageCode()) {
         clear_has_isoLanguageCode();
        _isoLanguageCode = 0u;
     }
}

inline bool SpeechRecognitionLanguage::hasIsoLanguageCode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 SpeechRecognitionLanguage::getIsoLanguageCode () const {
    return _isoLanguageCode;
}

inline void SpeechRecognitionLanguage::setIsoLanguageCode (uint16 isoLanguageCode_) {
    set_has_isoLanguageCode();
    this->_isoLanguageCode = isoLanguageCode_;
}

inline void SpeechRecognitionLanguage::clearIsoCountryCode() {
    if (hasIsoCountryCode()) {
         clear_has_isoCountryCode();
        _isoCountryCode = 0u;
     }
}

inline bool SpeechRecognitionLanguage::hasIsoCountryCode () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 SpeechRecognitionLanguage::getIsoCountryCode () const {
    return _isoCountryCode;
}

inline void SpeechRecognitionLanguage::setIsoCountryCode (uint16 isoCountryCode_) {
    set_has_isoCountryCode();
    this->_isoCountryCode = isoCountryCode_;
}

inline void SpeechRecognitionLanguage::clearGender() {
    if (hasGender()) {
         clear_has_gender();
        _gender = 0u;
     }
}

inline bool SpeechRecognitionLanguage::hasGender () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 SpeechRecognitionLanguage::getGender () const {
    return _gender;
}

inline void SpeechRecognitionLanguage::setGender (uint8 gender_) {
    set_has_gender();
    this->_gender = gender_;
}

inline void SpeechRecognitionLanguage::clearAsrSupported() {
    if (hasAsrSupported()) {
         clear_has_asrSupported();
        _asrSupported = false;
     }
}

inline bool SpeechRecognitionLanguage::hasAsrSupported () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline bool SpeechRecognitionLanguage::getAsrSupported () const {
    return _asrSupported;
}

inline void SpeechRecognitionLanguage::setAsrSupported (bool asrSupported_) {
    set_has_asrSupported();
    this->_asrSupported = asrSupported_;
}

inline void SpeechRecognitionLanguage::set_has_speakerId () {
    _has_bits_[0] |= 1u << 0;
}

inline void SpeechRecognitionLanguage::clear_has_speakerId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SpeechRecognitionLanguage::set_has_speakerName () {
    _has_bits_[0] |= 1u << 1;
}

inline void SpeechRecognitionLanguage::clear_has_speakerName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SpeechRecognitionLanguage::set_has_isoLanguageCode () {
    _has_bits_[0] |= 1u << 2;
}

inline void SpeechRecognitionLanguage::clear_has_isoLanguageCode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SpeechRecognitionLanguage::set_has_isoCountryCode () {
    _has_bits_[0] |= 1u << 3;
}

inline void SpeechRecognitionLanguage::clear_has_isoCountryCode () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void SpeechRecognitionLanguage::set_has_gender () {
    _has_bits_[0] |= 1u << 4;
}

inline void SpeechRecognitionLanguage::clear_has_gender () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void SpeechRecognitionLanguage::set_has_asrSupported () {
    _has_bits_[0] |= 1u << 5;
}

inline void SpeechRecognitionLanguage::clear_has_asrSupported () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  BestMatchAudioUpdate::BestMatchAudioUpdate ()  :
    _bestMatchAudio (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BestMatchAudioUpdate::BestMatchAudioUpdate (const BestMatchAudioUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _bestMatchAudio (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BestMatchAudioUpdate::BestMatchAudioUpdate (bool bestMatchAudio_)  :
    _bestMatchAudio (bestMatchAudio_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BestMatchAudioUpdate::~BestMatchAudioUpdate() {
}

inline BestMatchAudioUpdate& BestMatchAudioUpdate::operator = (const BestMatchAudioUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBestMatchAudio()) {
            setBestMatchAudio(rhs.getBestMatchAudio());
        } else {
            clearBestMatchAudio();
        }
    }
    return *this;
}

inline bool BestMatchAudioUpdate::operator == (const BestMatchAudioUpdate& rhs) const {
    return (((!hasBestMatchAudio() && !rhs.hasBestMatchAudio()) || getBestMatchAudio() == rhs.getBestMatchAudio()));
}

inline bool BestMatchAudioUpdate::operator != (const BestMatchAudioUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool BestMatchAudioUpdate::operator < (const BestMatchAudioUpdate& rhs) const {
    if (hasBestMatchAudio() || rhs.hasBestMatchAudio()) {
        if (getBestMatchAudio() < rhs.getBestMatchAudio()) return true;
        if (getBestMatchAudio() > rhs.getBestMatchAudio()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BestMatchAudioUpdate::clone() {
    return new BestMatchAudioUpdate(*this);
}

inline bool BestMatchAudioUpdate::operator > (const BestMatchAudioUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BestMatchAudioUpdate::clear() {
    clearBestMatchAudio();
}

inline void BestMatchAudioUpdate::clearBestMatchAudio() {
    if (hasBestMatchAudio()) {
         clear_has_bestMatchAudio();
        _bestMatchAudio = false;
     }
}

inline bool BestMatchAudioUpdate::hasBestMatchAudio () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool BestMatchAudioUpdate::getBestMatchAudio () const {
    return _bestMatchAudio;
}

inline void BestMatchAudioUpdate::setBestMatchAudio (bool bestMatchAudio_) {
    set_has_bestMatchAudio();
    this->_bestMatchAudio = bestMatchAudio_;
}

inline void BestMatchAudioUpdate::set_has_bestMatchAudio () {
    _has_bits_[0] |= 1u << 0;
}

inline void BestMatchAudioUpdate::clear_has_bestMatchAudio () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BestMatchAudioRegister::BestMatchAudioRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BestMatchAudioRegister::BestMatchAudioRegister (const BestMatchAudioRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BestMatchAudioRegister::~BestMatchAudioRegister() {
}

inline BestMatchAudioRegister& BestMatchAudioRegister::operator = (const BestMatchAudioRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool BestMatchAudioRegister::operator == (const BestMatchAudioRegister& ) const {
    return true;
}

inline bool BestMatchAudioRegister::operator != (const BestMatchAudioRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool BestMatchAudioRegister::operator < (const BestMatchAudioRegister& ) const {
    return false;
}

inline ::asf::core::Payload* BestMatchAudioRegister::clone() {
    return new BestMatchAudioRegister(*this);
}

inline bool BestMatchAudioRegister::operator > (const BestMatchAudioRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BestMatchAudioRegister::clear() {
}

inline  BestMatchPhoneBookUpdate::BestMatchPhoneBookUpdate ()  :
    _bestMatchPhoneBook (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BestMatchPhoneBookUpdate::BestMatchPhoneBookUpdate (const BestMatchPhoneBookUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _bestMatchPhoneBook (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BestMatchPhoneBookUpdate::BestMatchPhoneBookUpdate (bool bestMatchPhoneBook_)  :
    _bestMatchPhoneBook (bestMatchPhoneBook_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BestMatchPhoneBookUpdate::~BestMatchPhoneBookUpdate() {
}

inline BestMatchPhoneBookUpdate& BestMatchPhoneBookUpdate::operator = (const BestMatchPhoneBookUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBestMatchPhoneBook()) {
            setBestMatchPhoneBook(rhs.getBestMatchPhoneBook());
        } else {
            clearBestMatchPhoneBook();
        }
    }
    return *this;
}

inline bool BestMatchPhoneBookUpdate::operator == (const BestMatchPhoneBookUpdate& rhs) const {
    return (((!hasBestMatchPhoneBook() && !rhs.hasBestMatchPhoneBook()) || getBestMatchPhoneBook() == rhs.getBestMatchPhoneBook()));
}

inline bool BestMatchPhoneBookUpdate::operator != (const BestMatchPhoneBookUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool BestMatchPhoneBookUpdate::operator < (const BestMatchPhoneBookUpdate& rhs) const {
    if (hasBestMatchPhoneBook() || rhs.hasBestMatchPhoneBook()) {
        if (getBestMatchPhoneBook() < rhs.getBestMatchPhoneBook()) return true;
        if (getBestMatchPhoneBook() > rhs.getBestMatchPhoneBook()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BestMatchPhoneBookUpdate::clone() {
    return new BestMatchPhoneBookUpdate(*this);
}

inline bool BestMatchPhoneBookUpdate::operator > (const BestMatchPhoneBookUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BestMatchPhoneBookUpdate::clear() {
    clearBestMatchPhoneBook();
}

inline void BestMatchPhoneBookUpdate::clearBestMatchPhoneBook() {
    if (hasBestMatchPhoneBook()) {
         clear_has_bestMatchPhoneBook();
        _bestMatchPhoneBook = false;
     }
}

inline bool BestMatchPhoneBookUpdate::hasBestMatchPhoneBook () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool BestMatchPhoneBookUpdate::getBestMatchPhoneBook () const {
    return _bestMatchPhoneBook;
}

inline void BestMatchPhoneBookUpdate::setBestMatchPhoneBook (bool bestMatchPhoneBook_) {
    set_has_bestMatchPhoneBook();
    this->_bestMatchPhoneBook = bestMatchPhoneBook_;
}

inline void BestMatchPhoneBookUpdate::set_has_bestMatchPhoneBook () {
    _has_bits_[0] |= 1u << 0;
}

inline void BestMatchPhoneBookUpdate::clear_has_bestMatchPhoneBook () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BestMatchPhoneBookRegister::BestMatchPhoneBookRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BestMatchPhoneBookRegister::BestMatchPhoneBookRegister (const BestMatchPhoneBookRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BestMatchPhoneBookRegister::~BestMatchPhoneBookRegister() {
}

inline BestMatchPhoneBookRegister& BestMatchPhoneBookRegister::operator = (const BestMatchPhoneBookRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool BestMatchPhoneBookRegister::operator == (const BestMatchPhoneBookRegister& ) const {
    return true;
}

inline bool BestMatchPhoneBookRegister::operator != (const BestMatchPhoneBookRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool BestMatchPhoneBookRegister::operator < (const BestMatchPhoneBookRegister& ) const {
    return false;
}

inline ::asf::core::Payload* BestMatchPhoneBookRegister::clone() {
    return new BestMatchPhoneBookRegister(*this);
}

inline bool BestMatchPhoneBookRegister::operator > (const BestMatchPhoneBookRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BestMatchPhoneBookRegister::clear() {
}

inline  BeepOnlyModeUpdate::BeepOnlyModeUpdate ()  :
    _beepOnlyMode (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BeepOnlyModeUpdate::BeepOnlyModeUpdate (const BeepOnlyModeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _beepOnlyMode (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BeepOnlyModeUpdate::BeepOnlyModeUpdate (bool beepOnlyMode_)  :
    _beepOnlyMode (beepOnlyMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BeepOnlyModeUpdate::~BeepOnlyModeUpdate() {
}

inline BeepOnlyModeUpdate& BeepOnlyModeUpdate::operator = (const BeepOnlyModeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBeepOnlyMode()) {
            setBeepOnlyMode(rhs.getBeepOnlyMode());
        } else {
            clearBeepOnlyMode();
        }
    }
    return *this;
}

inline bool BeepOnlyModeUpdate::operator == (const BeepOnlyModeUpdate& rhs) const {
    return (((!hasBeepOnlyMode() && !rhs.hasBeepOnlyMode()) || getBeepOnlyMode() == rhs.getBeepOnlyMode()));
}

inline bool BeepOnlyModeUpdate::operator != (const BeepOnlyModeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool BeepOnlyModeUpdate::operator < (const BeepOnlyModeUpdate& rhs) const {
    if (hasBeepOnlyMode() || rhs.hasBeepOnlyMode()) {
        if (getBeepOnlyMode() < rhs.getBeepOnlyMode()) return true;
        if (getBeepOnlyMode() > rhs.getBeepOnlyMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BeepOnlyModeUpdate::clone() {
    return new BeepOnlyModeUpdate(*this);
}

inline bool BeepOnlyModeUpdate::operator > (const BeepOnlyModeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BeepOnlyModeUpdate::clear() {
    clearBeepOnlyMode();
}

inline void BeepOnlyModeUpdate::clearBeepOnlyMode() {
    if (hasBeepOnlyMode()) {
         clear_has_beepOnlyMode();
        _beepOnlyMode = false;
     }
}

inline bool BeepOnlyModeUpdate::hasBeepOnlyMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool BeepOnlyModeUpdate::getBeepOnlyMode () const {
    return _beepOnlyMode;
}

inline void BeepOnlyModeUpdate::setBeepOnlyMode (bool beepOnlyMode_) {
    set_has_beepOnlyMode();
    this->_beepOnlyMode = beepOnlyMode_;
}

inline void BeepOnlyModeUpdate::set_has_beepOnlyMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void BeepOnlyModeUpdate::clear_has_beepOnlyMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BeepOnlyModeRegister::BeepOnlyModeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BeepOnlyModeRegister::BeepOnlyModeRegister (const BeepOnlyModeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BeepOnlyModeRegister::~BeepOnlyModeRegister() {
}

inline BeepOnlyModeRegister& BeepOnlyModeRegister::operator = (const BeepOnlyModeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool BeepOnlyModeRegister::operator == (const BeepOnlyModeRegister& ) const {
    return true;
}

inline bool BeepOnlyModeRegister::operator != (const BeepOnlyModeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool BeepOnlyModeRegister::operator < (const BeepOnlyModeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* BeepOnlyModeRegister::clone() {
    return new BeepOnlyModeRegister(*this);
}

inline bool BeepOnlyModeRegister::operator > (const BeepOnlyModeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BeepOnlyModeRegister::clear() {
}

inline  ShortPromptUpdate::ShortPromptUpdate ()  :
    _shortPrompt (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ShortPromptUpdate::ShortPromptUpdate (const ShortPromptUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _shortPrompt (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ShortPromptUpdate::ShortPromptUpdate (bool shortPrompt_)  :
    _shortPrompt (shortPrompt_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ShortPromptUpdate::~ShortPromptUpdate() {
}

inline ShortPromptUpdate& ShortPromptUpdate::operator = (const ShortPromptUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasShortPrompt()) {
            setShortPrompt(rhs.getShortPrompt());
        } else {
            clearShortPrompt();
        }
    }
    return *this;
}

inline bool ShortPromptUpdate::operator == (const ShortPromptUpdate& rhs) const {
    return (((!hasShortPrompt() && !rhs.hasShortPrompt()) || getShortPrompt() == rhs.getShortPrompt()));
}

inline bool ShortPromptUpdate::operator != (const ShortPromptUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ShortPromptUpdate::operator < (const ShortPromptUpdate& rhs) const {
    if (hasShortPrompt() || rhs.hasShortPrompt()) {
        if (getShortPrompt() < rhs.getShortPrompt()) return true;
        if (getShortPrompt() > rhs.getShortPrompt()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ShortPromptUpdate::clone() {
    return new ShortPromptUpdate(*this);
}

inline bool ShortPromptUpdate::operator > (const ShortPromptUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ShortPromptUpdate::clear() {
    clearShortPrompt();
}

inline void ShortPromptUpdate::clearShortPrompt() {
    if (hasShortPrompt()) {
         clear_has_shortPrompt();
        _shortPrompt = false;
     }
}

inline bool ShortPromptUpdate::hasShortPrompt () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ShortPromptUpdate::getShortPrompt () const {
    return _shortPrompt;
}

inline void ShortPromptUpdate::setShortPrompt (bool shortPrompt_) {
    set_has_shortPrompt();
    this->_shortPrompt = shortPrompt_;
}

inline void ShortPromptUpdate::set_has_shortPrompt () {
    _has_bits_[0] |= 1u << 0;
}

inline void ShortPromptUpdate::clear_has_shortPrompt () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ShortPromptRegister::ShortPromptRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ShortPromptRegister::ShortPromptRegister (const ShortPromptRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ShortPromptRegister::~ShortPromptRegister() {
}

inline ShortPromptRegister& ShortPromptRegister::operator = (const ShortPromptRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ShortPromptRegister::operator == (const ShortPromptRegister& ) const {
    return true;
}

inline bool ShortPromptRegister::operator != (const ShortPromptRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ShortPromptRegister::operator < (const ShortPromptRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ShortPromptRegister::clone() {
    return new ShortPromptRegister(*this);
}

inline bool ShortPromptRegister::operator > (const ShortPromptRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ShortPromptRegister::clear() {
}

inline  VoiceBargeInUpdate::VoiceBargeInUpdate ()  :
    _voiceBargeIn (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VoiceBargeInUpdate::VoiceBargeInUpdate (const VoiceBargeInUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _voiceBargeIn (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VoiceBargeInUpdate::VoiceBargeInUpdate (bool voiceBargeIn_)  :
    _voiceBargeIn (voiceBargeIn_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VoiceBargeInUpdate::~VoiceBargeInUpdate() {
}

inline VoiceBargeInUpdate& VoiceBargeInUpdate::operator = (const VoiceBargeInUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVoiceBargeIn()) {
            setVoiceBargeIn(rhs.getVoiceBargeIn());
        } else {
            clearVoiceBargeIn();
        }
    }
    return *this;
}

inline bool VoiceBargeInUpdate::operator == (const VoiceBargeInUpdate& rhs) const {
    return (((!hasVoiceBargeIn() && !rhs.hasVoiceBargeIn()) || getVoiceBargeIn() == rhs.getVoiceBargeIn()));
}

inline bool VoiceBargeInUpdate::operator != (const VoiceBargeInUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool VoiceBargeInUpdate::operator < (const VoiceBargeInUpdate& rhs) const {
    if (hasVoiceBargeIn() || rhs.hasVoiceBargeIn()) {
        if (getVoiceBargeIn() < rhs.getVoiceBargeIn()) return true;
        if (getVoiceBargeIn() > rhs.getVoiceBargeIn()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VoiceBargeInUpdate::clone() {
    return new VoiceBargeInUpdate(*this);
}

inline bool VoiceBargeInUpdate::operator > (const VoiceBargeInUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VoiceBargeInUpdate::clear() {
    clearVoiceBargeIn();
}

inline void VoiceBargeInUpdate::clearVoiceBargeIn() {
    if (hasVoiceBargeIn()) {
         clear_has_voiceBargeIn();
        _voiceBargeIn = false;
     }
}

inline bool VoiceBargeInUpdate::hasVoiceBargeIn () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool VoiceBargeInUpdate::getVoiceBargeIn () const {
    return _voiceBargeIn;
}

inline void VoiceBargeInUpdate::setVoiceBargeIn (bool voiceBargeIn_) {
    set_has_voiceBargeIn();
    this->_voiceBargeIn = voiceBargeIn_;
}

inline void VoiceBargeInUpdate::set_has_voiceBargeIn () {
    _has_bits_[0] |= 1u << 0;
}

inline void VoiceBargeInUpdate::clear_has_voiceBargeIn () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  VoiceBargeInRegister::VoiceBargeInRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VoiceBargeInRegister::VoiceBargeInRegister (const VoiceBargeInRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VoiceBargeInRegister::~VoiceBargeInRegister() {
}

inline VoiceBargeInRegister& VoiceBargeInRegister::operator = (const VoiceBargeInRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool VoiceBargeInRegister::operator == (const VoiceBargeInRegister& ) const {
    return true;
}

inline bool VoiceBargeInRegister::operator != (const VoiceBargeInRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool VoiceBargeInRegister::operator < (const VoiceBargeInRegister& ) const {
    return false;
}

inline ::asf::core::Payload* VoiceBargeInRegister::clone() {
    return new VoiceBargeInRegister(*this);
}

inline bool VoiceBargeInRegister::operator > (const VoiceBargeInRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VoiceBargeInRegister::clear() {
}

inline  VoicePreferenceUpdate::VoicePreferenceUpdate ()  :
    _voicePreference (::sds_gui_fi::SettingsService::ActiveSpeakerGender__FEMALE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VoicePreferenceUpdate::VoicePreferenceUpdate (const VoicePreferenceUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _voicePreference (::sds_gui_fi::SettingsService::ActiveSpeakerGender__FEMALE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VoicePreferenceUpdate::VoicePreferenceUpdate (ActiveSpeakerGender voicePreference_)  :
    _voicePreference (voicePreference_)
{
    #ifndef NDEBUG
    if (!(ActiveSpeakerGender_IsValid(voicePreference_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", voicePreference_, "ActiveSpeakerGender", "voicePreference", "VoicePreferenceUpdate");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VoicePreferenceUpdate::~VoicePreferenceUpdate() {
}

inline VoicePreferenceUpdate& VoicePreferenceUpdate::operator = (const VoicePreferenceUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVoicePreference()) {
            setVoicePreference(rhs.getVoicePreference());
        } else {
            clearVoicePreference();
        }
    }
    return *this;
}

inline bool VoicePreferenceUpdate::operator == (const VoicePreferenceUpdate& rhs) const {
    return (((!hasVoicePreference() && !rhs.hasVoicePreference()) || getVoicePreference() == rhs.getVoicePreference()));
}

inline bool VoicePreferenceUpdate::operator != (const VoicePreferenceUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool VoicePreferenceUpdate::operator < (const VoicePreferenceUpdate& rhs) const {
    if (hasVoicePreference() || rhs.hasVoicePreference()) {
        if ((uint32)getVoicePreference() < (uint32)rhs.getVoicePreference()) return true;
        if ((uint32)getVoicePreference() > (uint32)rhs.getVoicePreference()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VoicePreferenceUpdate::clone() {
    return new VoicePreferenceUpdate(*this);
}

inline bool VoicePreferenceUpdate::operator > (const VoicePreferenceUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VoicePreferenceUpdate::clear() {
    clearVoicePreference();
}

inline void VoicePreferenceUpdate::clearVoicePreference() {
    if (hasVoicePreference()) {
         clear_has_voicePreference();
        _voicePreference = ::sds_gui_fi::SettingsService::ActiveSpeakerGender__FEMALE;
     }
}

inline bool VoicePreferenceUpdate::hasVoicePreference () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ActiveSpeakerGender VoicePreferenceUpdate::getVoicePreference () const {
    return _voicePreference;
}

inline void VoicePreferenceUpdate::setVoicePreference (ActiveSpeakerGender voicePreference_) {
    #ifndef NDEBUG
    if (!(ActiveSpeakerGender_IsValid(voicePreference_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", voicePreference_, "ActiveSpeakerGender", "voicePreference", "VoicePreferenceUpdate");
    }
    #endif
    set_has_voicePreference();
    this->_voicePreference = voicePreference_;
}

inline void VoicePreferenceUpdate::set_has_voicePreference () {
    _has_bits_[0] |= 1u << 0;
}

inline void VoicePreferenceUpdate::clear_has_voicePreference () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  VoicePreferenceRegister::VoicePreferenceRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VoicePreferenceRegister::VoicePreferenceRegister (const VoicePreferenceRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VoicePreferenceRegister::~VoicePreferenceRegister() {
}

inline VoicePreferenceRegister& VoicePreferenceRegister::operator = (const VoicePreferenceRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool VoicePreferenceRegister::operator == (const VoicePreferenceRegister& ) const {
    return true;
}

inline bool VoicePreferenceRegister::operator != (const VoicePreferenceRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool VoicePreferenceRegister::operator < (const VoicePreferenceRegister& ) const {
    return false;
}

inline ::asf::core::Payload* VoicePreferenceRegister::clone() {
    return new VoicePreferenceRegister(*this);
}

inline bool VoicePreferenceRegister::operator > (const VoicePreferenceRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VoicePreferenceRegister::clear() {
}

inline  SpeechRateUpdate::SpeechRateUpdate ()  :
    _speechRate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SpeechRateUpdate::SpeechRateUpdate (const SpeechRateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _speechRate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SpeechRateUpdate::SpeechRateUpdate (uint32 speechRate_)  :
    _speechRate (speechRate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SpeechRateUpdate::~SpeechRateUpdate() {
}

inline SpeechRateUpdate& SpeechRateUpdate::operator = (const SpeechRateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSpeechRate()) {
            setSpeechRate(rhs.getSpeechRate());
        } else {
            clearSpeechRate();
        }
    }
    return *this;
}

inline bool SpeechRateUpdate::operator == (const SpeechRateUpdate& rhs) const {
    return (((!hasSpeechRate() && !rhs.hasSpeechRate()) || getSpeechRate() == rhs.getSpeechRate()));
}

inline bool SpeechRateUpdate::operator != (const SpeechRateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SpeechRateUpdate::operator < (const SpeechRateUpdate& rhs) const {
    if (hasSpeechRate() || rhs.hasSpeechRate()) {
        if (getSpeechRate() < rhs.getSpeechRate()) return true;
        if (getSpeechRate() > rhs.getSpeechRate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SpeechRateUpdate::clone() {
    return new SpeechRateUpdate(*this);
}

inline bool SpeechRateUpdate::operator > (const SpeechRateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SpeechRateUpdate::clear() {
    clearSpeechRate();
}

inline void SpeechRateUpdate::clearSpeechRate() {
    if (hasSpeechRate()) {
         clear_has_speechRate();
        _speechRate = 0u;
     }
}

inline bool SpeechRateUpdate::hasSpeechRate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 SpeechRateUpdate::getSpeechRate () const {
    return _speechRate;
}

inline void SpeechRateUpdate::setSpeechRate (uint32 speechRate_) {
    set_has_speechRate();
    this->_speechRate = speechRate_;
}

inline void SpeechRateUpdate::set_has_speechRate () {
    _has_bits_[0] |= 1u << 0;
}

inline void SpeechRateUpdate::clear_has_speechRate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SpeechRateRegister::SpeechRateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SpeechRateRegister::SpeechRateRegister (const SpeechRateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SpeechRateRegister::~SpeechRateRegister() {
}

inline SpeechRateRegister& SpeechRateRegister::operator = (const SpeechRateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SpeechRateRegister::operator == (const SpeechRateRegister& ) const {
    return true;
}

inline bool SpeechRateRegister::operator != (const SpeechRateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SpeechRateRegister::operator < (const SpeechRateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SpeechRateRegister::clone() {
    return new SpeechRateRegister(*this);
}

inline bool SpeechRateRegister::operator > (const SpeechRateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SpeechRateRegister::clear() {
}

inline  SpeechRecognitionLanguageListUpdate::SpeechRecognitionLanguageListUpdate ()  :
    _speechRecognitionLanguageList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SpeechRecognitionLanguageListUpdate::SpeechRecognitionLanguageListUpdate (const SpeechRecognitionLanguageListUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _speechRecognitionLanguageList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SpeechRecognitionLanguageListUpdate::SpeechRecognitionLanguageListUpdate (const ::std::vector< SpeechRecognitionLanguage >& speechRecognitionLanguageList_)  :
    _speechRecognitionLanguageList (speechRecognitionLanguageList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SpeechRecognitionLanguageListUpdate::~SpeechRecognitionLanguageListUpdate() {
}

inline SpeechRecognitionLanguageListUpdate& SpeechRecognitionLanguageListUpdate::operator = (const SpeechRecognitionLanguageListUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSpeechRecognitionLanguageList()) {
            setSpeechRecognitionLanguageList(rhs.getSpeechRecognitionLanguageList());
        } else {
            clearSpeechRecognitionLanguageList();
        }
    }
    return *this;
}

inline bool SpeechRecognitionLanguageListUpdate::operator == (const SpeechRecognitionLanguageListUpdate& rhs) const {
    return (((!hasSpeechRecognitionLanguageList() && !rhs.hasSpeechRecognitionLanguageList()) || getSpeechRecognitionLanguageList() == rhs.getSpeechRecognitionLanguageList()));
}

inline bool SpeechRecognitionLanguageListUpdate::operator != (const SpeechRecognitionLanguageListUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SpeechRecognitionLanguageListUpdate::operator < (const SpeechRecognitionLanguageListUpdate& rhs) const {
    if (hasSpeechRecognitionLanguageList() || rhs.hasSpeechRecognitionLanguageList()) {
        if (getSpeechRecognitionLanguageList() < rhs.getSpeechRecognitionLanguageList()) return true;
        if (getSpeechRecognitionLanguageList() > rhs.getSpeechRecognitionLanguageList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SpeechRecognitionLanguageListUpdate::clone() {
    return new SpeechRecognitionLanguageListUpdate(*this);
}

inline bool SpeechRecognitionLanguageListUpdate::operator > (const SpeechRecognitionLanguageListUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SpeechRecognitionLanguageListUpdate::clear() {
    clearSpeechRecognitionLanguageList();
}

inline void SpeechRecognitionLanguageListUpdate::clearSpeechRecognitionLanguageList() {
    if (hasSpeechRecognitionLanguageList()) {
         clear_has_speechRecognitionLanguageList();
        _speechRecognitionLanguageList.clear();
     }
}

inline bool SpeechRecognitionLanguageListUpdate::hasSpeechRecognitionLanguageList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< SpeechRecognitionLanguage >& SpeechRecognitionLanguageListUpdate::getSpeechRecognitionLanguageList () const {
    return _speechRecognitionLanguageList;
}

inline ::std::vector< SpeechRecognitionLanguage >& SpeechRecognitionLanguageListUpdate::getSpeechRecognitionLanguageListMutable () {
    set_has_speechRecognitionLanguageList();
    return _speechRecognitionLanguageList;
}

inline void SpeechRecognitionLanguageListUpdate::setSpeechRecognitionLanguageList (const ::std::vector< SpeechRecognitionLanguage >& speechRecognitionLanguageList_) {
    set_has_speechRecognitionLanguageList();
    this->_speechRecognitionLanguageList = speechRecognitionLanguageList_;
}

inline void SpeechRecognitionLanguageListUpdate::set_has_speechRecognitionLanguageList () {
    _has_bits_[0] |= 1u << 0;
}

inline void SpeechRecognitionLanguageListUpdate::clear_has_speechRecognitionLanguageList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SpeechRecognitionLanguageListRegister::SpeechRecognitionLanguageListRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SpeechRecognitionLanguageListRegister::SpeechRecognitionLanguageListRegister (const SpeechRecognitionLanguageListRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SpeechRecognitionLanguageListRegister::~SpeechRecognitionLanguageListRegister() {
}

inline SpeechRecognitionLanguageListRegister& SpeechRecognitionLanguageListRegister::operator = (const SpeechRecognitionLanguageListRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SpeechRecognitionLanguageListRegister::operator == (const SpeechRecognitionLanguageListRegister& ) const {
    return true;
}

inline bool SpeechRecognitionLanguageListRegister::operator != (const SpeechRecognitionLanguageListRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SpeechRecognitionLanguageListRegister::operator < (const SpeechRecognitionLanguageListRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SpeechRecognitionLanguageListRegister::clone() {
    return new SpeechRecognitionLanguageListRegister(*this);
}

inline bool SpeechRecognitionLanguageListRegister::operator > (const SpeechRecognitionLanguageListRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SpeechRecognitionLanguageListRegister::clear() {
}

} // namespace SettingsService
} // namespace sds_gui_fi

#endif // SDS_GUI_FI_SETTINGSSERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
