/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_GUI_FI_SDSPHONESERVICESTUB_H
#define SDS_GUI_FI_SDSPHONESERVICESTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "sds_gui_fi/SdsPhoneService.h"
#include "sds_gui_fi/SdsPhoneServiceConst.h"
#include <string>
#include <vector>

namespace sds_gui_fi {
namespace SdsPhoneService {

class SdsPhoneServiceStubDelegate;

class SdsPhoneServiceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the SdsPhoneServiceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    SdsPhoneServiceStub (const std::string& portName);

    /**
     * Create an instance of the SdsPhoneServiceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    SdsPhoneServiceStub (const std::string& portName, const std::string& objectPath);

    virtual ~SdsPhoneServiceStub();

    // signal 'SpokenDigits'

    /**
     * Raise the signal 'SpokenDigits' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'SpokenDigits'</b>:
     *
     * If the meaning of "SpokenDigits" isn't clear, then there should be a description here.
     *
     * @param digits If the meaning of "digits" isn't clear, then there should be a description here.
     */
    void sendSpokenDigitsSignal(const ::std::string& digits);

    // signal 'SmsContent'

    /**
     * Raise the signal 'SmsContent' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'SmsContent'</b>:
     *
     * If the meaning of "SmsContent" isn't clear, then there should be a description here.
     *
     * @param firstLastSMS If the meaning of "firstLastSMS" isn't clear, then there should be a description here.
     *
     * @param message If the meaning of "message" isn't clear, then there should be a description here.
     */
    void sendSmsContentSignal(FirstLastSMS firstLastSMS, const ::std::string& message);

    // signal 'UserWordUpdate'

    /**
     * Raise the signal 'UserWordUpdate' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'UserWordUpdate'</b>:
     *
     * If the meaning of "UserWordUpdate" isn't clear, then there should be a description here.
     *
     * @param userWordLists If the meaning of "userWordLists" isn't clear, then there should be a description here.
     */
    void sendUserWordUpdateSignal(const ::std::vector< UserWordList >& userWordLists);

    // signal 'PhoneBookPhonetization'

    /**
     * Raise the signal 'PhoneBookPhonetization' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'PhoneBookPhonetization'</b>:
     *
     * If the meaning of "PhoneBookPhonetization" isn't clear, then there should be a description here.
     *
     * @param phoneBookPhonetizationStatus If the meaning of "phoneBookPhonetizationStatus" isn't clear, then there should be a description here.
     */
    void sendPhoneBookPhonetizationSignal(PhoneBookPhonetization phoneBookPhonetizationStatus);

    // method 'VoiceTagAction'

    /**
     * The method onVoiceTagAction() is called by ASF when a client invokes
     * the method 'VoiceTagAction'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendVoiceTagAction() or sendVoiceTagActionError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'VoiceTagAction'</b>:
     *
     * If the meaning of "VoiceTagAction" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onVoiceTagActionRequest (const ::boost::shared_ptr< VoiceTagActionRequest >& request) = 0;

    /**
     * The method sendVoiceTagActionResponse() sends a response of a previous
     * method invocation of 'VoiceTagAction' back to the client.
     *
     * <b>Documentation of 'VoiceTagAction'</b>:
     *
     * If the meaning of "VoiceTagAction" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onVoiceTagAction(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendVoiceTagActionResponse (act_t act = 0);

    /**
     * The method sendVoiceTagActionError() sends an error response of a
     * previous method invocation of 'VoiceTagAction' back to the client.
     *
     * <b>Documentation of 'VoiceTagAction'</b>:
     *
     * If the meaning of "VoiceTagAction" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onVoiceTagAction(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendVoiceTagActionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class SdsPhoneServiceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace SdsPhoneService
} // namespace sds_gui_fi

#endif // SDS_GUI_FI_SDSPHONESERVICESTUB_H
