#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_GUI_FI_SDSPHONESERVICE_H
#define SDS_GUI_FI_SDSPHONESERVICE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "sds_gui_fi/SdsPhoneServiceConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "sds_gui_fi.SdsPhoneService" isn't clear, then there should be a description here.
 */

namespace sds_gui_fi {
namespace SdsPhoneService {

// method IDs
static const uint16 ID_VoiceTagAction = 0;

// signal IDs
static const uint16 ID_SpokenDigits = 1;
static const uint16 ID_SmsContent = 2;
static const uint16 ID_UserWordUpdate = 3;
static const uint16 ID_PhoneBookPhonetization = 4;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class UserWordList;

class VoiceTagActionRequest;

class SpokenDigitsSignal;

class SmsContentSignal;

class UserWordUpdateSignal;

class PhoneBookPhonetizationSignal;

// type definitions
/**
 * If the meaning of "VoiceTagAction" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage VoiceTagActionResponse;

/**
 * If the meaning of "VoiceTagActionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VoiceTagActionError;

/**
 * If the meaning of "SpokenDigitsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SpokenDigitsError;

/**
 * If the meaning of "SmsContentError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SmsContentError;

/**
 * If the meaning of "UserWordUpdateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UserWordUpdateError;

/**
 * If the meaning of "PhoneBookPhonetizationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PhoneBookPhonetizationError;


/**
 * If the meaning of "UserWordList" isn't clear, then there should be a description here.
 */
class UserWordList {
public:

    /**
     * Default constructor
     */
    inline  UserWordList ();

    /**
     * Copy constructor
     */
    inline  UserWordList (const UserWordList &rhs);

    /**
     * All fields constructor
     */
    inline  UserWordList (uint32 userWordProfileID_, const ::std::vector< uint32 >& phoneUWID_);

    /**
     * Destructor
     */
    inline  ~UserWordList();

    /**
     * Assignment operator
     */
    inline UserWordList& operator = (const UserWordList& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UserWordList& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UserWordList& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UserWordList& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UserWordList& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "userWordProfileID"

    static const int kUserWordProfileID = 0;

    /**
     * Clears the field "userWordProfileID".
     *
     * The field will be set to its default value. The hasUserWordProfileID()
     * method will return false.
     */
    inline void clearUserWordProfileID();

    /**
     * Checks whether the field "userWordProfileID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserWordProfileID()). Otherwise it will return false.
     */
    inline bool hasUserWordProfileID () const;

    /**
     * Returns the value of the member "userWordProfileID".
     *
     * If the meaning of "userWordProfileID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "userWordProfileID"
     */
    inline uint32 getUserWordProfileID () const;

    /**
     * Sets the value of the member "userWordProfileID".
     *
     * If the meaning of "userWordProfileID" isn't clear, then there should be a description here.
     *
     * @param userWordProfileID The value which will be set
     */
    inline void setUserWordProfileID (uint32 userWordProfileID_);

    // API of field "phoneUWID"

    static const int kPhoneUWID = 1;

    /**
     * Clears the field "phoneUWID".
     *
     * The field will be set to its default value. The hasPhoneUWID()
     * method will return false.
     */
    inline void clearPhoneUWID();

    /**
     * Checks whether the field "phoneUWID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneUWID()). Otherwise it will return false.
     */
    inline bool hasPhoneUWID () const;

    /**
     * Returns the value of the member "phoneUWID".
     *
     * If the meaning of "phoneUWID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "phoneUWID"
     */
    inline const ::std::vector< uint32 >& getPhoneUWID () const;

    /**
     * Retrieves the value of the field "phoneUWID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "phoneUWID".
     */
    inline ::std::vector< uint32 >& getPhoneUWIDMutable ();

    /**
     * Sets the value of the member "phoneUWID".
     *
     * If the meaning of "phoneUWID" isn't clear, then there should be a description here.
     *
     * @param phoneUWID The value which will be set
     */
    inline void setPhoneUWID (const ::std::vector< uint32 >& phoneUWID_);

    static const UserWordList &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_userWordProfileID ();

    inline void clear_has_userWordProfileID ();

    inline void set_has_phoneUWID ();

    inline void clear_has_phoneUWID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _userWordProfileID;

    ::std::vector< uint32 > _phoneUWID;

};

/**
 * If the meaning of "VoiceTagAction" isn't clear, then there should be a description here.
 */
class VoiceTagActionRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VoiceTagActionRequest ();

    /**
     * Copy constructor
     */
    inline  VoiceTagActionRequest (const VoiceTagActionRequest &rhs);

    /**
     * All fields constructor
     */
    inline  VoiceTagActionRequest (UserWordAction userAction_, uint32 uniqueContactID_, uint32 phoneProfileID_);

    /**
     * Destructor
     */
    inline virtual  ~VoiceTagActionRequest();

    /**
     * Assignment operator
     */
    inline VoiceTagActionRequest& operator = (const VoiceTagActionRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoiceTagActionRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoiceTagActionRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoiceTagActionRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoiceTagActionRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "userAction"

    static const int kUserAction = 0;

    /**
     * Clears the field "userAction".
     *
     * The field will be set to its default value. The hasUserAction()
     * method will return false.
     */
    inline void clearUserAction();

    /**
     * Checks whether the field "userAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserAction()). Otherwise it will return false.
     */
    inline bool hasUserAction () const;

    /**
     * Returns the value of the member "userAction".
     *
     * If the meaning of "userAction" isn't clear, then there should be a description here.
     *
     * @return The value of the field "userAction"
     */
    inline UserWordAction getUserAction () const;

    /**
     * Sets the value of the member "userAction".
     *
     * If the meaning of "userAction" isn't clear, then there should be a description here.
     *
     * @param userAction The value which will be set
     */
    inline void setUserAction (UserWordAction userAction_);

    // API of field "uniqueContactID"

    static const int kUniqueContactID = 1;

    /**
     * Clears the field "uniqueContactID".
     *
     * The field will be set to its default value. The hasUniqueContactID()
     * method will return false.
     */
    inline void clearUniqueContactID();

    /**
     * Checks whether the field "uniqueContactID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUniqueContactID()). Otherwise it will return false.
     */
    inline bool hasUniqueContactID () const;

    /**
     * Returns the value of the member "uniqueContactID".
     *
     * If the meaning of "uniqueContactID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "uniqueContactID"
     */
    inline uint32 getUniqueContactID () const;

    /**
     * Sets the value of the member "uniqueContactID".
     *
     * If the meaning of "uniqueContactID" isn't clear, then there should be a description here.
     *
     * @param uniqueContactID The value which will be set
     */
    inline void setUniqueContactID (uint32 uniqueContactID_);

    // API of field "phoneProfileID"

    static const int kPhoneProfileID = 2;

    /**
     * Clears the field "phoneProfileID".
     *
     * The field will be set to its default value. The hasPhoneProfileID()
     * method will return false.
     */
    inline void clearPhoneProfileID();

    /**
     * Checks whether the field "phoneProfileID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneProfileID()). Otherwise it will return false.
     */
    inline bool hasPhoneProfileID () const;

    /**
     * Returns the value of the member "phoneProfileID".
     *
     * If the meaning of "phoneProfileID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "phoneProfileID"
     */
    inline uint32 getPhoneProfileID () const;

    /**
     * Sets the value of the member "phoneProfileID".
     *
     * If the meaning of "phoneProfileID" isn't clear, then there should be a description here.
     *
     * @param phoneProfileID The value which will be set
     */
    inline void setPhoneProfileID (uint32 phoneProfileID_);

    static const VoiceTagActionRequest &getDefaultInstance();

private:

    inline void set_has_userAction ();

    inline void clear_has_userAction ();

    inline void set_has_uniqueContactID ();

    inline void clear_has_uniqueContactID ();

    inline void set_has_phoneProfileID ();

    inline void clear_has_phoneProfileID ();

    uint32 _has_bits_[ (3 + 31) / 32];

    UserWordAction _userAction;

    uint32 _uniqueContactID;

    uint32 _phoneProfileID;

};

/**
 * If the meaning of "SpokenDigits" isn't clear, then there should be a description here.
 */
class SpokenDigitsSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpokenDigitsSignal ();

    /**
     * Copy constructor
     */
    inline  SpokenDigitsSignal (const SpokenDigitsSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SpokenDigitsSignal (const ::std::string& digits_);

    /**
     * Destructor
     */
    inline virtual  ~SpokenDigitsSignal();

    /**
     * Assignment operator
     */
    inline SpokenDigitsSignal& operator = (const SpokenDigitsSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpokenDigitsSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpokenDigitsSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpokenDigitsSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpokenDigitsSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "digits"

    static const int kDigits = 0;

    /**
     * Clears the field "digits".
     *
     * The field will be set to its default value. The hasDigits()
     * method will return false.
     */
    inline void clearDigits();

    /**
     * Checks whether the field "digits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDigits()). Otherwise it will return false.
     */
    inline bool hasDigits () const;

    /**
     * Returns the value of the member "digits".
     *
     * If the meaning of "digits" isn't clear, then there should be a description here.
     *
     * @return The value of the field "digits"
     */
    inline const ::std::string& getDigits () const;

    /**
     * Retrieves the value of the field "digits" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "digits".
     */
    inline ::std::string& getDigitsMutable ();

    /**
     * Sets the value of the member "digits".
     *
     * If the meaning of "digits" isn't clear, then there should be a description here.
     *
     * @param digits The value which will be set
     */
    inline void setDigits (const ::std::string& digits_);

    /**
     * Sets the value of the member "digits".
     *
     * If the meaning of "digits" isn't clear, then there should be a description here.
     *
     * @param digits The value which will be set
     */
    inline void setDigits (const char* digits_);

    /**
     * Sets the value of the member "digits".
     *
     * If the meaning of "digits" isn't clear, then there should be a description here.
     *
     * @param digits The value which will be set
     */
    inline void setDigits (const char* value, size_t size);

    static const SpokenDigitsSignal &getDefaultInstance();

private:

    inline void set_has_digits ();

    inline void clear_has_digits ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _digits;

};

/**
 * If the meaning of "SmsContent" isn't clear, then there should be a description here.
 */
class SmsContentSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SmsContentSignal ();

    /**
     * Copy constructor
     */
    inline  SmsContentSignal (const SmsContentSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SmsContentSignal (FirstLastSMS firstLastSMS_, const ::std::string& message_);

    /**
     * Destructor
     */
    inline virtual  ~SmsContentSignal();

    /**
     * Assignment operator
     */
    inline SmsContentSignal& operator = (const SmsContentSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SmsContentSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SmsContentSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SmsContentSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SmsContentSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "firstLastSMS"

    static const int kFirstLastSMS = 0;

    /**
     * Clears the field "firstLastSMS".
     *
     * The field will be set to its default value. The hasFirstLastSMS()
     * method will return false.
     */
    inline void clearFirstLastSMS();

    /**
     * Checks whether the field "firstLastSMS" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFirstLastSMS()). Otherwise it will return false.
     */
    inline bool hasFirstLastSMS () const;

    /**
     * Returns the value of the member "firstLastSMS".
     *
     * If the meaning of "firstLastSMS" isn't clear, then there should be a description here.
     *
     * @return The value of the field "firstLastSMS"
     */
    inline FirstLastSMS getFirstLastSMS () const;

    /**
     * Sets the value of the member "firstLastSMS".
     *
     * If the meaning of "firstLastSMS" isn't clear, then there should be a description here.
     *
     * @param firstLastSMS The value which will be set
     */
    inline void setFirstLastSMS (FirstLastSMS firstLastSMS_);

    // API of field "message"

    static const int kMessage = 1;

    /**
     * Clears the field "message".
     *
     * The field will be set to its default value. The hasMessage()
     * method will return false.
     */
    inline void clearMessage();

    /**
     * Checks whether the field "message" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMessage()). Otherwise it will return false.
     */
    inline bool hasMessage () const;

    /**
     * Returns the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @return The value of the field "message"
     */
    inline const ::std::string& getMessage () const;

    /**
     * Retrieves the value of the field "message" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "message".
     */
    inline ::std::string& getMessageMutable ();

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const ::std::string& message_);

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const char* message_);

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const char* value, size_t size);

    static const SmsContentSignal &getDefaultInstance();

private:

    inline void set_has_firstLastSMS ();

    inline void clear_has_firstLastSMS ();

    inline void set_has_message ();

    inline void clear_has_message ();

    uint32 _has_bits_[ (2 + 31) / 32];

    FirstLastSMS _firstLastSMS;

    ::std::string _message;

};

/**
 * If the meaning of "UserWordUpdate" isn't clear, then there should be a description here.
 */
class UserWordUpdateSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UserWordUpdateSignal ();

    /**
     * Copy constructor
     */
    inline  UserWordUpdateSignal (const UserWordUpdateSignal &rhs);

    /**
     * All fields constructor
     */
    inline  UserWordUpdateSignal (const ::std::vector< UserWordList >& userWordLists_);

    /**
     * Destructor
     */
    inline virtual  ~UserWordUpdateSignal();

    /**
     * Assignment operator
     */
    inline UserWordUpdateSignal& operator = (const UserWordUpdateSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UserWordUpdateSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UserWordUpdateSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UserWordUpdateSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UserWordUpdateSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "userWordLists"

    static const int kUserWordLists = 0;

    /**
     * Clears the field "userWordLists".
     *
     * The field will be set to its default value. The hasUserWordLists()
     * method will return false.
     */
    inline void clearUserWordLists();

    /**
     * Checks whether the field "userWordLists" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserWordLists()). Otherwise it will return false.
     */
    inline bool hasUserWordLists () const;

    /**
     * Returns the value of the member "userWordLists".
     *
     * If the meaning of "userWordLists" isn't clear, then there should be a description here.
     *
     * @return The value of the field "userWordLists"
     */
    inline const ::std::vector< UserWordList >& getUserWordLists () const;

    /**
     * Retrieves the value of the field "userWordLists" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "userWordLists".
     */
    inline ::std::vector< UserWordList >& getUserWordListsMutable ();

    /**
     * Sets the value of the member "userWordLists".
     *
     * If the meaning of "userWordLists" isn't clear, then there should be a description here.
     *
     * @param userWordLists The value which will be set
     */
    inline void setUserWordLists (const ::std::vector< UserWordList >& userWordLists_);

    static const UserWordUpdateSignal &getDefaultInstance();

private:

    static const ::std::vector< UserWordList >& getUserWordListList_DefaultInstance ();

    inline void set_has_userWordLists ();

    inline void clear_has_userWordLists ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< UserWordList > _userWordLists;

};

/**
 * If the meaning of "PhoneBookPhonetization" isn't clear, then there should be a description here.
 */
class PhoneBookPhonetizationSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneBookPhonetizationSignal ();

    /**
     * Copy constructor
     */
    inline  PhoneBookPhonetizationSignal (const PhoneBookPhonetizationSignal &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneBookPhonetizationSignal (PhoneBookPhonetization phoneBookPhonetizationStatus_);

    /**
     * Destructor
     */
    inline virtual  ~PhoneBookPhonetizationSignal();

    /**
     * Assignment operator
     */
    inline PhoneBookPhonetizationSignal& operator = (const PhoneBookPhonetizationSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneBookPhonetizationSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneBookPhonetizationSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneBookPhonetizationSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneBookPhonetizationSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "phoneBookPhonetizationStatus"

    static const int kPhoneBookPhonetizationStatus = 0;

    /**
     * Clears the field "phoneBookPhonetizationStatus".
     *
     * The field will be set to its default value. The hasPhoneBookPhonetizationStatus()
     * method will return false.
     */
    inline void clearPhoneBookPhonetizationStatus();

    /**
     * Checks whether the field "phoneBookPhonetizationStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneBookPhonetizationStatus()). Otherwise it will return false.
     */
    inline bool hasPhoneBookPhonetizationStatus () const;

    /**
     * Returns the value of the member "phoneBookPhonetizationStatus".
     *
     * If the meaning of "phoneBookPhonetizationStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "phoneBookPhonetizationStatus"
     */
    inline PhoneBookPhonetization getPhoneBookPhonetizationStatus () const;

    /**
     * Sets the value of the member "phoneBookPhonetizationStatus".
     *
     * If the meaning of "phoneBookPhonetizationStatus" isn't clear, then there should be a description here.
     *
     * @param phoneBookPhonetizationStatus The value which will be set
     */
    inline void setPhoneBookPhonetizationStatus (PhoneBookPhonetization phoneBookPhonetizationStatus_);

    static const PhoneBookPhonetizationSignal &getDefaultInstance();

private:

    inline void set_has_phoneBookPhonetizationStatus ();

    inline void clear_has_phoneBookPhonetizationStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    PhoneBookPhonetization _phoneBookPhonetizationStatus;

};

inline  UserWordList::UserWordList ()  :
    _userWordProfileID (0u),
    _phoneUWID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UserWordList::UserWordList (const UserWordList &rhs)  :
    _userWordProfileID (0u),
    _phoneUWID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UserWordList::UserWordList (uint32 userWordProfileID_, const ::std::vector< uint32 >& phoneUWID_)  :
    _userWordProfileID (userWordProfileID_),
    _phoneUWID (phoneUWID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UserWordList::~UserWordList() {
}

inline UserWordList& UserWordList::operator = (const UserWordList& rhs) {
    if( this != &rhs ) {
        if (rhs.hasUserWordProfileID()) {
            setUserWordProfileID(rhs.getUserWordProfileID());
        } else {
            clearUserWordProfileID();
        }
        if (rhs.hasPhoneUWID()) {
            setPhoneUWID(rhs.getPhoneUWID());
        } else {
            clearPhoneUWID();
        }
    }
    return *this;
}

inline bool UserWordList::operator == (const UserWordList& rhs) const {
    return (((!hasUserWordProfileID() && !rhs.hasUserWordProfileID()) || getUserWordProfileID() == rhs.getUserWordProfileID()) &&
        ((!hasPhoneUWID() && !rhs.hasPhoneUWID()) || getPhoneUWID() == rhs.getPhoneUWID()));
}

inline bool UserWordList::operator != (const UserWordList& rhs) const {
    return ! (*this == rhs);
}

inline bool UserWordList::operator < (const UserWordList& rhs) const {
    if (hasUserWordProfileID() || rhs.hasUserWordProfileID()) {
        if (getUserWordProfileID() < rhs.getUserWordProfileID()) return true;
        if (getUserWordProfileID() > rhs.getUserWordProfileID()) return false;
    }
    if (hasPhoneUWID() || rhs.hasPhoneUWID()) {
        if (getPhoneUWID() < rhs.getPhoneUWID()) return true;
        if (getPhoneUWID() > rhs.getPhoneUWID()) return false;
    }
    return false;
}

inline bool UserWordList::operator > (const UserWordList& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UserWordList::clear() {
    clearUserWordProfileID();
    clearPhoneUWID();
}

inline void UserWordList::clearUserWordProfileID() {
    if (hasUserWordProfileID()) {
         clear_has_userWordProfileID();
        _userWordProfileID = 0u;
     }
}

inline bool UserWordList::hasUserWordProfileID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 UserWordList::getUserWordProfileID () const {
    return _userWordProfileID;
}

inline void UserWordList::setUserWordProfileID (uint32 userWordProfileID_) {
    set_has_userWordProfileID();
    this->_userWordProfileID = userWordProfileID_;
}

inline void UserWordList::clearPhoneUWID() {
    if (hasPhoneUWID()) {
         clear_has_phoneUWID();
        _phoneUWID.clear();
     }
}

inline bool UserWordList::hasPhoneUWID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint32 >& UserWordList::getPhoneUWID () const {
    return _phoneUWID;
}

inline ::std::vector< uint32 >& UserWordList::getPhoneUWIDMutable () {
    set_has_phoneUWID();
    return _phoneUWID;
}

inline void UserWordList::setPhoneUWID (const ::std::vector< uint32 >& phoneUWID_) {
    set_has_phoneUWID();
    this->_phoneUWID = phoneUWID_;
}

inline void UserWordList::set_has_userWordProfileID () {
    _has_bits_[0] |= 1u << 0;
}

inline void UserWordList::clear_has_userWordProfileID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void UserWordList::set_has_phoneUWID () {
    _has_bits_[0] |= 1u << 1;
}

inline void UserWordList::clear_has_phoneUWID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  VoiceTagActionRequest::VoiceTagActionRequest ()  :
    _userAction (::sds_gui_fi::SdsPhoneService::UserWordAction__RECORD),
    _uniqueContactID (0u),
    _phoneProfileID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VoiceTagActionRequest::VoiceTagActionRequest (const VoiceTagActionRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _userAction (::sds_gui_fi::SdsPhoneService::UserWordAction__RECORD),
    _uniqueContactID (0u),
    _phoneProfileID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VoiceTagActionRequest::VoiceTagActionRequest (UserWordAction userAction_, uint32 uniqueContactID_, uint32 phoneProfileID_)  :
    _userAction (userAction_),
    _uniqueContactID (uniqueContactID_),
    _phoneProfileID (phoneProfileID_)
{
    #ifndef NDEBUG
    if (!(UserWordAction_IsValid(userAction_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", userAction_, "UserWordAction", "userAction", "VoiceTagActionRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VoiceTagActionRequest::~VoiceTagActionRequest() {
}

inline VoiceTagActionRequest& VoiceTagActionRequest::operator = (const VoiceTagActionRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUserAction()) {
            setUserAction(rhs.getUserAction());
        } else {
            clearUserAction();
        }
        if (rhs.hasUniqueContactID()) {
            setUniqueContactID(rhs.getUniqueContactID());
        } else {
            clearUniqueContactID();
        }
        if (rhs.hasPhoneProfileID()) {
            setPhoneProfileID(rhs.getPhoneProfileID());
        } else {
            clearPhoneProfileID();
        }
    }
    return *this;
}

inline bool VoiceTagActionRequest::operator == (const VoiceTagActionRequest& rhs) const {
    return (((!hasUserAction() && !rhs.hasUserAction()) || getUserAction() == rhs.getUserAction()) &&
        ((!hasUniqueContactID() && !rhs.hasUniqueContactID()) || getUniqueContactID() == rhs.getUniqueContactID()) &&
        ((!hasPhoneProfileID() && !rhs.hasPhoneProfileID()) || getPhoneProfileID() == rhs.getPhoneProfileID()));
}

inline bool VoiceTagActionRequest::operator != (const VoiceTagActionRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool VoiceTagActionRequest::operator < (const VoiceTagActionRequest& rhs) const {
    if (hasUserAction() || rhs.hasUserAction()) {
        if ((uint32)getUserAction() < (uint32)rhs.getUserAction()) return true;
        if ((uint32)getUserAction() > (uint32)rhs.getUserAction()) return false;
    }
    if (hasUniqueContactID() || rhs.hasUniqueContactID()) {
        if (getUniqueContactID() < rhs.getUniqueContactID()) return true;
        if (getUniqueContactID() > rhs.getUniqueContactID()) return false;
    }
    if (hasPhoneProfileID() || rhs.hasPhoneProfileID()) {
        if (getPhoneProfileID() < rhs.getPhoneProfileID()) return true;
        if (getPhoneProfileID() > rhs.getPhoneProfileID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VoiceTagActionRequest::clone() {
    return new VoiceTagActionRequest(*this);
}

inline bool VoiceTagActionRequest::operator > (const VoiceTagActionRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VoiceTagActionRequest::clear() {
    clearUserAction();
    clearUniqueContactID();
    clearPhoneProfileID();
}

inline void VoiceTagActionRequest::clearUserAction() {
    if (hasUserAction()) {
         clear_has_userAction();
        _userAction = ::sds_gui_fi::SdsPhoneService::UserWordAction__RECORD;
     }
}

inline bool VoiceTagActionRequest::hasUserAction () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline UserWordAction VoiceTagActionRequest::getUserAction () const {
    return _userAction;
}

inline void VoiceTagActionRequest::setUserAction (UserWordAction userAction_) {
    #ifndef NDEBUG
    if (!(UserWordAction_IsValid(userAction_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", userAction_, "UserWordAction", "userAction", "VoiceTagActionRequest");
    }
    #endif
    set_has_userAction();
    this->_userAction = userAction_;
}

inline void VoiceTagActionRequest::clearUniqueContactID() {
    if (hasUniqueContactID()) {
         clear_has_uniqueContactID();
        _uniqueContactID = 0u;
     }
}

inline bool VoiceTagActionRequest::hasUniqueContactID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 VoiceTagActionRequest::getUniqueContactID () const {
    return _uniqueContactID;
}

inline void VoiceTagActionRequest::setUniqueContactID (uint32 uniqueContactID_) {
    set_has_uniqueContactID();
    this->_uniqueContactID = uniqueContactID_;
}

inline void VoiceTagActionRequest::clearPhoneProfileID() {
    if (hasPhoneProfileID()) {
         clear_has_phoneProfileID();
        _phoneProfileID = 0u;
     }
}

inline bool VoiceTagActionRequest::hasPhoneProfileID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 VoiceTagActionRequest::getPhoneProfileID () const {
    return _phoneProfileID;
}

inline void VoiceTagActionRequest::setPhoneProfileID (uint32 phoneProfileID_) {
    set_has_phoneProfileID();
    this->_phoneProfileID = phoneProfileID_;
}

inline void VoiceTagActionRequest::set_has_userAction () {
    _has_bits_[0] |= 1u << 0;
}

inline void VoiceTagActionRequest::clear_has_userAction () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void VoiceTagActionRequest::set_has_uniqueContactID () {
    _has_bits_[0] |= 1u << 1;
}

inline void VoiceTagActionRequest::clear_has_uniqueContactID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void VoiceTagActionRequest::set_has_phoneProfileID () {
    _has_bits_[0] |= 1u << 2;
}

inline void VoiceTagActionRequest::clear_has_phoneProfileID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SpokenDigitsSignal::SpokenDigitsSignal ()  :
    _digits ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SpokenDigitsSignal::SpokenDigitsSignal (const SpokenDigitsSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _digits ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SpokenDigitsSignal::SpokenDigitsSignal (const ::std::string& digits_)  :
    _digits (digits_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (digits_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SpokenDigitsSignal::~SpokenDigitsSignal() {
}

inline SpokenDigitsSignal& SpokenDigitsSignal::operator = (const SpokenDigitsSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDigits()) {
            setDigits(rhs.getDigits());
        } else {
            clearDigits();
        }
    }
    return *this;
}

inline bool SpokenDigitsSignal::operator == (const SpokenDigitsSignal& rhs) const {
    return (((!hasDigits() && !rhs.hasDigits()) || getDigits() == rhs.getDigits()));
}

inline bool SpokenDigitsSignal::operator != (const SpokenDigitsSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SpokenDigitsSignal::operator < (const SpokenDigitsSignal& rhs) const {
    if (hasDigits() || rhs.hasDigits()) {
        if (getDigits() < rhs.getDigits()) return true;
        if (getDigits() > rhs.getDigits()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SpokenDigitsSignal::clone() {
    return new SpokenDigitsSignal(*this);
}

inline bool SpokenDigitsSignal::operator > (const SpokenDigitsSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SpokenDigitsSignal::clear() {
    clearDigits();
}

inline void SpokenDigitsSignal::clearDigits() {
    if (hasDigits()) {
         clear_has_digits();
        _digits.clear();
     }
}

inline bool SpokenDigitsSignal::hasDigits () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SpokenDigitsSignal::getDigits () const {
    return _digits;
}

inline ::std::string& SpokenDigitsSignal::getDigitsMutable () {
    set_has_digits();
    return _digits;
}

inline void SpokenDigitsSignal::setDigits (const ::std::string& digits_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (digits_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_digits();
    this->_digits = digits_;
}

inline void SpokenDigitsSignal::setDigits (const char* digits_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (digits_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_digits();
    this->_digits.assign(digits_);
}

inline void SpokenDigitsSignal::setDigits (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_digits();
    this->_digits.assign(value, size);
}

inline void SpokenDigitsSignal::set_has_digits () {
    _has_bits_[0] |= 1u << 0;
}

inline void SpokenDigitsSignal::clear_has_digits () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SmsContentSignal::SmsContentSignal ()  :
    _firstLastSMS (::sds_gui_fi::SdsPhoneService::FirstLastSMS__ONLY_ONE_SMS),
    _message ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SmsContentSignal::SmsContentSignal (const SmsContentSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _firstLastSMS (::sds_gui_fi::SdsPhoneService::FirstLastSMS__ONLY_ONE_SMS),
    _message ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SmsContentSignal::SmsContentSignal (FirstLastSMS firstLastSMS_, const ::std::string& message_)  :
    _firstLastSMS (firstLastSMS_),
    _message (message_)
{
    #ifndef NDEBUG
    if (!(FirstLastSMS_IsValid(firstLastSMS_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", firstLastSMS_, "FirstLastSMS", "firstLastSMS", "SmsContentSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SmsContentSignal::~SmsContentSignal() {
}

inline SmsContentSignal& SmsContentSignal::operator = (const SmsContentSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFirstLastSMS()) {
            setFirstLastSMS(rhs.getFirstLastSMS());
        } else {
            clearFirstLastSMS();
        }
        if (rhs.hasMessage()) {
            setMessage(rhs.getMessage());
        } else {
            clearMessage();
        }
    }
    return *this;
}

inline bool SmsContentSignal::operator == (const SmsContentSignal& rhs) const {
    return (((!hasFirstLastSMS() && !rhs.hasFirstLastSMS()) || getFirstLastSMS() == rhs.getFirstLastSMS()) &&
        ((!hasMessage() && !rhs.hasMessage()) || getMessage() == rhs.getMessage()));
}

inline bool SmsContentSignal::operator != (const SmsContentSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SmsContentSignal::operator < (const SmsContentSignal& rhs) const {
    if (hasFirstLastSMS() || rhs.hasFirstLastSMS()) {
        if ((uint32)getFirstLastSMS() < (uint32)rhs.getFirstLastSMS()) return true;
        if ((uint32)getFirstLastSMS() > (uint32)rhs.getFirstLastSMS()) return false;
    }
    if (hasMessage() || rhs.hasMessage()) {
        if (getMessage() < rhs.getMessage()) return true;
        if (getMessage() > rhs.getMessage()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SmsContentSignal::clone() {
    return new SmsContentSignal(*this);
}

inline bool SmsContentSignal::operator > (const SmsContentSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SmsContentSignal::clear() {
    clearFirstLastSMS();
    clearMessage();
}

inline void SmsContentSignal::clearFirstLastSMS() {
    if (hasFirstLastSMS()) {
         clear_has_firstLastSMS();
        _firstLastSMS = ::sds_gui_fi::SdsPhoneService::FirstLastSMS__ONLY_ONE_SMS;
     }
}

inline bool SmsContentSignal::hasFirstLastSMS () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline FirstLastSMS SmsContentSignal::getFirstLastSMS () const {
    return _firstLastSMS;
}

inline void SmsContentSignal::setFirstLastSMS (FirstLastSMS firstLastSMS_) {
    #ifndef NDEBUG
    if (!(FirstLastSMS_IsValid(firstLastSMS_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", firstLastSMS_, "FirstLastSMS", "firstLastSMS", "SmsContentSignal");
    }
    #endif
    set_has_firstLastSMS();
    this->_firstLastSMS = firstLastSMS_;
}

inline void SmsContentSignal::clearMessage() {
    if (hasMessage()) {
         clear_has_message();
        _message.clear();
     }
}

inline bool SmsContentSignal::hasMessage () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SmsContentSignal::getMessage () const {
    return _message;
}

inline ::std::string& SmsContentSignal::getMessageMutable () {
    set_has_message();
    return _message;
}

inline void SmsContentSignal::setMessage (const ::std::string& message_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    this->_message = message_;
}

inline void SmsContentSignal::setMessage (const char* message_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    this->_message.assign(message_);
}

inline void SmsContentSignal::setMessage (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    this->_message.assign(value, size);
}

inline void SmsContentSignal::set_has_firstLastSMS () {
    _has_bits_[0] |= 1u << 0;
}

inline void SmsContentSignal::clear_has_firstLastSMS () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SmsContentSignal::set_has_message () {
    _has_bits_[0] |= 1u << 1;
}

inline void SmsContentSignal::clear_has_message () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  UserWordUpdateSignal::UserWordUpdateSignal ()  :
    _userWordLists ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UserWordUpdateSignal::UserWordUpdateSignal (const UserWordUpdateSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _userWordLists ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UserWordUpdateSignal::UserWordUpdateSignal (const ::std::vector< UserWordList >& userWordLists_)  :
    _userWordLists (userWordLists_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UserWordUpdateSignal::~UserWordUpdateSignal() {
}

inline UserWordUpdateSignal& UserWordUpdateSignal::operator = (const UserWordUpdateSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUserWordLists()) {
            setUserWordLists(rhs.getUserWordLists());
        } else {
            clearUserWordLists();
        }
    }
    return *this;
}

inline bool UserWordUpdateSignal::operator == (const UserWordUpdateSignal& rhs) const {
    return (((!hasUserWordLists() && !rhs.hasUserWordLists()) || getUserWordLists() == rhs.getUserWordLists()));
}

inline bool UserWordUpdateSignal::operator != (const UserWordUpdateSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool UserWordUpdateSignal::operator < (const UserWordUpdateSignal& rhs) const {
    if (hasUserWordLists() || rhs.hasUserWordLists()) {
        if (getUserWordLists() < rhs.getUserWordLists()) return true;
        if (getUserWordLists() > rhs.getUserWordLists()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UserWordUpdateSignal::clone() {
    return new UserWordUpdateSignal(*this);
}

inline bool UserWordUpdateSignal::operator > (const UserWordUpdateSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UserWordUpdateSignal::clear() {
    clearUserWordLists();
}

inline void UserWordUpdateSignal::clearUserWordLists() {
    if (hasUserWordLists()) {
         clear_has_userWordLists();
        _userWordLists.clear();
     }
}

inline bool UserWordUpdateSignal::hasUserWordLists () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< UserWordList >& UserWordUpdateSignal::getUserWordLists () const {
    return _userWordLists;
}

inline ::std::vector< UserWordList >& UserWordUpdateSignal::getUserWordListsMutable () {
    set_has_userWordLists();
    return _userWordLists;
}

inline void UserWordUpdateSignal::setUserWordLists (const ::std::vector< UserWordList >& userWordLists_) {
    set_has_userWordLists();
    this->_userWordLists = userWordLists_;
}

inline void UserWordUpdateSignal::set_has_userWordLists () {
    _has_bits_[0] |= 1u << 0;
}

inline void UserWordUpdateSignal::clear_has_userWordLists () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PhoneBookPhonetizationSignal::PhoneBookPhonetizationSignal ()  :
    _phoneBookPhonetizationStatus (::sds_gui_fi::SdsPhoneService::PhoneBookPhonetization__DEVICEUNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PhoneBookPhonetizationSignal::PhoneBookPhonetizationSignal (const PhoneBookPhonetizationSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _phoneBookPhonetizationStatus (::sds_gui_fi::SdsPhoneService::PhoneBookPhonetization__DEVICEUNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PhoneBookPhonetizationSignal::PhoneBookPhonetizationSignal (PhoneBookPhonetization phoneBookPhonetizationStatus_)  :
    _phoneBookPhonetizationStatus (phoneBookPhonetizationStatus_)
{
    #ifndef NDEBUG
    if (!(PhoneBookPhonetization_IsValid(phoneBookPhonetizationStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", phoneBookPhonetizationStatus_, "PhoneBookPhonetization", "phoneBookPhonetizationStatus", "PhoneBookPhonetizationSignal");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PhoneBookPhonetizationSignal::~PhoneBookPhonetizationSignal() {
}

inline PhoneBookPhonetizationSignal& PhoneBookPhonetizationSignal::operator = (const PhoneBookPhonetizationSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPhoneBookPhonetizationStatus()) {
            setPhoneBookPhonetizationStatus(rhs.getPhoneBookPhonetizationStatus());
        } else {
            clearPhoneBookPhonetizationStatus();
        }
    }
    return *this;
}

inline bool PhoneBookPhonetizationSignal::operator == (const PhoneBookPhonetizationSignal& rhs) const {
    return (((!hasPhoneBookPhonetizationStatus() && !rhs.hasPhoneBookPhonetizationStatus()) || getPhoneBookPhonetizationStatus() == rhs.getPhoneBookPhonetizationStatus()));
}

inline bool PhoneBookPhonetizationSignal::operator != (const PhoneBookPhonetizationSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool PhoneBookPhonetizationSignal::operator < (const PhoneBookPhonetizationSignal& rhs) const {
    if (hasPhoneBookPhonetizationStatus() || rhs.hasPhoneBookPhonetizationStatus()) {
        if ((uint32)getPhoneBookPhonetizationStatus() < (uint32)rhs.getPhoneBookPhonetizationStatus()) return true;
        if ((uint32)getPhoneBookPhonetizationStatus() > (uint32)rhs.getPhoneBookPhonetizationStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PhoneBookPhonetizationSignal::clone() {
    return new PhoneBookPhonetizationSignal(*this);
}

inline bool PhoneBookPhonetizationSignal::operator > (const PhoneBookPhonetizationSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PhoneBookPhonetizationSignal::clear() {
    clearPhoneBookPhonetizationStatus();
}

inline void PhoneBookPhonetizationSignal::clearPhoneBookPhonetizationStatus() {
    if (hasPhoneBookPhonetizationStatus()) {
         clear_has_phoneBookPhonetizationStatus();
        _phoneBookPhonetizationStatus = ::sds_gui_fi::SdsPhoneService::PhoneBookPhonetization__DEVICEUNAVAILABLE;
     }
}

inline bool PhoneBookPhonetizationSignal::hasPhoneBookPhonetizationStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline PhoneBookPhonetization PhoneBookPhonetizationSignal::getPhoneBookPhonetizationStatus () const {
    return _phoneBookPhonetizationStatus;
}

inline void PhoneBookPhonetizationSignal::setPhoneBookPhonetizationStatus (PhoneBookPhonetization phoneBookPhonetizationStatus_) {
    #ifndef NDEBUG
    if (!(PhoneBookPhonetization_IsValid(phoneBookPhonetizationStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", phoneBookPhonetizationStatus_, "PhoneBookPhonetization", "phoneBookPhonetizationStatus", "PhoneBookPhonetizationSignal");
    }
    #endif
    set_has_phoneBookPhonetizationStatus();
    this->_phoneBookPhonetizationStatus = phoneBookPhonetizationStatus_;
}

inline void PhoneBookPhonetizationSignal::set_has_phoneBookPhonetizationStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void PhoneBookPhonetizationSignal::clear_has_phoneBookPhonetizationStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace SdsPhoneService
} // namespace sds_gui_fi

#endif // SDS_GUI_FI_SDSPHONESERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
