#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_GUI_FI_SDSGUISERVICE_H
#define SDS_GUI_FI_SDSGUISERVICE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "sds_gui_fi/SdsGuiServiceConst.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "sds_gui_fi.SdsGuiService" isn't clear, then there should be a description here.
 */

namespace sds_gui_fi {
namespace SdsGuiService {

// method IDs
static const uint16 ID_pttPress = 0;
static const uint16 ID_startSessionContext = 1;
static const uint16 ID_ManualOperation = 2;
static const uint16 ID_TestModeUpdate = 3;
static const uint16 ID_BackPress = 4;
static const uint16 ID_AbortSession = 5;
static const uint16 ID_StopSession = 6;
static const uint16 ID_PauseSession = 7;
static const uint16 ID_ResumeSession = 8;
static const uint16 ID_settingsCommand = 9;
static const uint16 ID_StartEarlyHandling = 10;
static const uint16 ID_StopEarlyHandling = 11;
static const uint16 ID_helpCommand = 12;
static const uint16 ID_CursorIndexForInitialFocus = 13;

// signal IDs
static const uint16 ID_ActivateAudioDeviceTag = 14;
static const uint16 ID_ActivateAudioSource = 15;
static const uint16 ID_SpokenDigits = 16;
static const uint16 ID_Event = 17;
static const uint16 ID_EarlyPromptFinished = 18;
static const uint16 ID_EarlyPromptTerminated = 19;

// property IDs
static const uint16 ID_sdsStatus = 20;
static const uint16 ID_HighPrioAppStatus = 21;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class PttPressRequest;

class StartSessionContextRequest;

class ManualOperationRequest;

class TestModeUpdateRequest;

class CursorIndexForInitialFocusRequest;

class SdsStatusUpdate;

class SdsStatusRegister;

class HighPrioAppStatusUpdate;

class HighPrioAppStatusRegister;

class ActivateAudioDeviceTagSignal;

class ActivateAudioSourceSignal;

class SpokenDigitsSignal;

class EventSignal;

// type definitions
/**
 * If the meaning of "pttPress" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage PttPressResponse;

/**
 * If the meaning of "PttPressError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PttPressError;

/**
 * If the meaning of "startSessionContext" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StartSessionContextResponse;

/**
 * If the meaning of "StartSessionContextError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartSessionContextError;

/**
 * If the meaning of "ManualOperation" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ManualOperationResponse;

/**
 * If the meaning of "ManualOperationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ManualOperationError;

/**
 * If the meaning of "TestModeUpdate" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage TestModeUpdateResponse;

/**
 * If the meaning of "TestModeUpdateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TestModeUpdateError;

/**
 * If the meaning of "BackPress" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage BackPressRequest;

/**
 * If the meaning of "BackPress" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage BackPressResponse;

/**
 * If the meaning of "BackPressError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BackPressError;

/**
 * If the meaning of "AbortSession" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AbortSessionRequest;

/**
 * If the meaning of "AbortSession" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AbortSessionResponse;

/**
 * If the meaning of "AbortSessionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AbortSessionError;

/**
 * If the meaning of "StopSession" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StopSessionRequest;

/**
 * If the meaning of "StopSession" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StopSessionResponse;

/**
 * If the meaning of "StopSessionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StopSessionError;

/**
 * If the meaning of "PauseSession" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage PauseSessionRequest;

/**
 * If the meaning of "PauseSession" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage PauseSessionResponse;

/**
 * If the meaning of "PauseSessionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PauseSessionError;

/**
 * If the meaning of "ResumeSession" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ResumeSessionRequest;

/**
 * If the meaning of "ResumeSession" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ResumeSessionResponse;

/**
 * If the meaning of "ResumeSessionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ResumeSessionError;

/**
 * If the meaning of "settingsCommand" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SettingsCommandRequest;

/**
 * If the meaning of "settingsCommand" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SettingsCommandResponse;

/**
 * If the meaning of "SettingsCommandError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SettingsCommandError;

/**
 * If the meaning of "StartEarlyHandling" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StartEarlyHandlingRequest;

/**
 * If the meaning of "StartEarlyHandling" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StartEarlyHandlingResponse;

/**
 * If the meaning of "StartEarlyHandlingError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartEarlyHandlingError;

/**
 * If the meaning of "StopEarlyHandling" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StopEarlyHandlingRequest;

/**
 * If the meaning of "StopEarlyHandling" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StopEarlyHandlingResponse;

/**
 * If the meaning of "StopEarlyHandlingError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StopEarlyHandlingError;

/**
 * If the meaning of "helpCommand" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage HelpCommandRequest;

/**
 * If the meaning of "helpCommand" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage HelpCommandResponse;

/**
 * If the meaning of "HelpCommandError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError HelpCommandError;

/**
 * If the meaning of "CursorIndexForInitialFocus" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CursorIndexForInitialFocusResponse;

/**
 * If the meaning of "CursorIndexForInitialFocusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CursorIndexForInitialFocusError;

/**
 * OBSOLETE -> use sdsStatus attribute from sds_gui_fi::PopUpService
 */
typedef SdsStatusUpdate SdsStatusSet;

/**
 * OBSOLETE -> use sdsStatus attribute from sds_gui_fi::PopUpService
 */
typedef SdsStatusUpdate SdsStatusGet;

/**
 * If the meaning of "SdsStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SdsStatusError;

/**
 * If the meaning of "HighPrioAppStatus" isn't clear, then there should be a description here.
 */
typedef HighPrioAppStatusUpdate HighPrioAppStatusSet;

/**
 * If the meaning of "HighPrioAppStatus" isn't clear, then there should be a description here.
 */
typedef HighPrioAppStatusUpdate HighPrioAppStatusGet;

/**
 * If the meaning of "HighPrioAppStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError HighPrioAppStatusError;

/**
 * If the meaning of "ActivateAudioDeviceTagError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActivateAudioDeviceTagError;

/**
 * If the meaning of "ActivateAudioSourceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActivateAudioSourceError;

/**
 * If the meaning of "SpokenDigitsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SpokenDigitsError;

/**
 * If the meaning of "EventError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EventError;

/**
 * If the meaning of "EarlyPromptFinished" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EarlyPromptFinishedSignal;

/**
 * If the meaning of "EarlyPromptFinishedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EarlyPromptFinishedError;

/**
 * If the meaning of "EarlyPromptTerminated" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EarlyPromptTerminatedSignal;

/**
 * If the meaning of "EarlyPromptTerminatedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EarlyPromptTerminatedError;


/**
 * If the meaning of "pttPress" isn't clear, then there should be a description here.
 */
class PttPressRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PttPressRequest ();

    /**
     * Copy constructor
     */
    inline  PttPressRequest (const PttPressRequest &rhs);

    /**
     * All fields constructor
     */
    inline  PttPressRequest (KeyState pttPressType_);

    /**
     * Destructor
     */
    inline virtual  ~PttPressRequest();

    /**
     * Assignment operator
     */
    inline PttPressRequest& operator = (const PttPressRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PttPressRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PttPressRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PttPressRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PttPressRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pttPressType"

    static const int kPttPressType = 0;

    /**
     * Clears the field "pttPressType".
     *
     * The field will be set to its default value. The hasPttPressType()
     * method will return false.
     */
    inline void clearPttPressType();

    /**
     * Checks whether the field "pttPressType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPttPressType()). Otherwise it will return false.
     */
    inline bool hasPttPressType () const;

    /**
     * Returns the value of the member "pttPressType".
     *
     * If the meaning of "pttPressType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pttPressType"
     */
    inline KeyState getPttPressType () const;

    /**
     * Sets the value of the member "pttPressType".
     *
     * If the meaning of "pttPressType" isn't clear, then there should be a description here.
     *
     * @param pttPressType The value which will be set
     */
    inline void setPttPressType (KeyState pttPressType_);

    static const PttPressRequest &getDefaultInstance();

private:

    inline void set_has_pttPressType ();

    inline void clear_has_pttPressType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    KeyState _pttPressType;

};

/**
 * If the meaning of "startSessionContext" isn't clear, then there should be a description here.
 */
class StartSessionContextRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartSessionContextRequest ();

    /**
     * Copy constructor
     */
    inline  StartSessionContextRequest (const StartSessionContextRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StartSessionContextRequest (ContextType startupContextType_);

    /**
     * Destructor
     */
    inline virtual  ~StartSessionContextRequest();

    /**
     * Assignment operator
     */
    inline StartSessionContextRequest& operator = (const StartSessionContextRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartSessionContextRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartSessionContextRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartSessionContextRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartSessionContextRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "startupContextType"

    static const int kStartupContextType = 0;

    /**
     * Clears the field "startupContextType".
     *
     * The field will be set to its default value. The hasStartupContextType()
     * method will return false.
     */
    inline void clearStartupContextType();

    /**
     * Checks whether the field "startupContextType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStartupContextType()). Otherwise it will return false.
     */
    inline bool hasStartupContextType () const;

    /**
     * Returns the value of the member "startupContextType".
     *
     * If the meaning of "startupContextType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "startupContextType"
     */
    inline ContextType getStartupContextType () const;

    /**
     * Sets the value of the member "startupContextType".
     *
     * If the meaning of "startupContextType" isn't clear, then there should be a description here.
     *
     * @param startupContextType The value which will be set
     */
    inline void setStartupContextType (ContextType startupContextType_);

    static const StartSessionContextRequest &getDefaultInstance();

private:

    inline void set_has_startupContextType ();

    inline void clear_has_startupContextType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ContextType _startupContextType;

};

/**
 * If the meaning of "ManualOperation" isn't clear, then there should be a description here.
 */
class ManualOperationRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ManualOperationRequest ();

    /**
     * Copy constructor
     */
    inline  ManualOperationRequest (const ManualOperationRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ManualOperationRequest (OperationType operationType_, uint32 value_);

    /**
     * Destructor
     */
    inline virtual  ~ManualOperationRequest();

    /**
     * Assignment operator
     */
    inline ManualOperationRequest& operator = (const ManualOperationRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ManualOperationRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ManualOperationRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ManualOperationRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ManualOperationRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "operationType"

    static const int kOperationType = 0;

    /**
     * Clears the field "operationType".
     *
     * The field will be set to its default value. The hasOperationType()
     * method will return false.
     */
    inline void clearOperationType();

    /**
     * Checks whether the field "operationType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOperationType()). Otherwise it will return false.
     */
    inline bool hasOperationType () const;

    /**
     * Returns the value of the member "operationType".
     *
     * If the meaning of "operationType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "operationType"
     */
    inline OperationType getOperationType () const;

    /**
     * Sets the value of the member "operationType".
     *
     * If the meaning of "operationType" isn't clear, then there should be a description here.
     *
     * @param operationType The value which will be set
     */
    inline void setOperationType (OperationType operationType_);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline uint32 getValue () const;

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (uint32 value_);

    static const ManualOperationRequest &getDefaultInstance();

private:

    inline void set_has_operationType ();

    inline void clear_has_operationType ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    OperationType _operationType;

    uint32 _value;

};

/**
 * If the meaning of "TestModeUpdate" isn't clear, then there should be a description here.
 */
class TestModeUpdateRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TestModeUpdateRequest ();

    /**
     * Copy constructor
     */
    inline  TestModeUpdateRequest (const TestModeUpdateRequest &rhs);

    /**
     * All fields constructor
     */
    inline  TestModeUpdateRequest (const ::std::string& tModesentence_);

    /**
     * Destructor
     */
    inline virtual  ~TestModeUpdateRequest();

    /**
     * Assignment operator
     */
    inline TestModeUpdateRequest& operator = (const TestModeUpdateRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TestModeUpdateRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TestModeUpdateRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TestModeUpdateRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TestModeUpdateRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tModesentence"

    static const int kTModesentence = 0;

    /**
     * Clears the field "tModesentence".
     *
     * The field will be set to its default value. The hasTModesentence()
     * method will return false.
     */
    inline void clearTModesentence();

    /**
     * Checks whether the field "tModesentence" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTModesentence()). Otherwise it will return false.
     */
    inline bool hasTModesentence () const;

    /**
     * Returns the value of the member "tModesentence".
     *
     * If the meaning of "tModesentence" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tModesentence"
     */
    inline const ::std::string& getTModesentence () const;

    /**
     * Retrieves the value of the field "tModesentence" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tModesentence".
     */
    inline ::std::string& getTModesentenceMutable ();

    /**
     * Sets the value of the member "tModesentence".
     *
     * If the meaning of "tModesentence" isn't clear, then there should be a description here.
     *
     * @param tModesentence The value which will be set
     */
    inline void setTModesentence (const ::std::string& tModesentence_);

    /**
     * Sets the value of the member "tModesentence".
     *
     * If the meaning of "tModesentence" isn't clear, then there should be a description here.
     *
     * @param tModesentence The value which will be set
     */
    inline void setTModesentence (const char* tModesentence_);

    /**
     * Sets the value of the member "tModesentence".
     *
     * If the meaning of "tModesentence" isn't clear, then there should be a description here.
     *
     * @param tModesentence The value which will be set
     */
    inline void setTModesentence (const char* value, size_t size);

    static const TestModeUpdateRequest &getDefaultInstance();

private:

    inline void set_has_tModesentence ();

    inline void clear_has_tModesentence ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _tModesentence;

};

/**
 * If the meaning of "CursorIndexForInitialFocus" isn't clear, then there should be a description here.
 */
class CursorIndexForInitialFocusRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CursorIndexForInitialFocusRequest ();

    /**
     * Copy constructor
     */
    inline  CursorIndexForInitialFocusRequest (const CursorIndexForInitialFocusRequest &rhs);

    /**
     * All fields constructor
     */
    inline  CursorIndexForInitialFocusRequest (uint32 index_);

    /**
     * Destructor
     */
    inline virtual  ~CursorIndexForInitialFocusRequest();

    /**
     * Assignment operator
     */
    inline CursorIndexForInitialFocusRequest& operator = (const CursorIndexForInitialFocusRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CursorIndexForInitialFocusRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CursorIndexForInitialFocusRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CursorIndexForInitialFocusRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CursorIndexForInitialFocusRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "index"

    static const int kIndex = 0;

    /**
     * Clears the field "index".
     *
     * The field will be set to its default value. The hasIndex()
     * method will return false.
     */
    inline void clearIndex();

    /**
     * Checks whether the field "index" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIndex()). Otherwise it will return false.
     */
    inline bool hasIndex () const;

    /**
     * Returns the value of the member "index".
     *
     * If the meaning of "index" isn't clear, then there should be a description here.
     *
     * @return The value of the field "index"
     */
    inline uint32 getIndex () const;

    /**
     * Sets the value of the member "index".
     *
     * If the meaning of "index" isn't clear, then there should be a description here.
     *
     * @param index The value which will be set
     */
    inline void setIndex (uint32 index_);

    static const CursorIndexForInitialFocusRequest &getDefaultInstance();

private:

    inline void set_has_index ();

    inline void clear_has_index ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _index;

};

/**
 * OBSOLETE -> use sdsStatus attribute from sds_gui_fi::PopUpService
 */
class SdsStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  SdsStatusUpdate (const SdsStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SdsStatusUpdate (SpeechInputState sdsStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SdsStatusUpdate();

    /**
     * Assignment operator
     */
    inline SdsStatusUpdate& operator = (const SdsStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsStatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sdsStatus"

    static const int kSdsStatus = 0;

    /**
     * Clears the field "sdsStatus".
     *
     * The field will be set to its default value. The hasSdsStatus()
     * method will return false.
     */
    inline void clearSdsStatus();

    /**
     * Checks whether the field "sdsStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsStatus()). Otherwise it will return false.
     */
    inline bool hasSdsStatus () const;

    /**
     * Returns the value of the member "sdsStatus".
     *
     * OBSOLETE -> use sdsStatus attribute from sds_gui_fi::PopUpService
     *
     * @return The value of the field "sdsStatus"
     */
    inline SpeechInputState getSdsStatus () const;

    /**
     * Sets the value of the member "sdsStatus".
     *
     * OBSOLETE -> use sdsStatus attribute from sds_gui_fi::PopUpService
     *
     * @param sdsStatus The value which will be set
     */
    inline void setSdsStatus (SpeechInputState sdsStatus_);

    static const SdsStatusUpdate &getDefaultInstance();

private:

    inline void set_has_sdsStatus ();

    inline void clear_has_sdsStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SpeechInputState _sdsStatus;

};

/**
 * OBSOLETE -> use sdsStatus attribute from sds_gui_fi::PopUpService
 */
class SdsStatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsStatusRegister ();

    /**
     * Copy constructor
     */
    inline  SdsStatusRegister (const SdsStatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SdsStatusRegister();

    /**
     * Assignment operator
     */
    inline SdsStatusRegister& operator = (const SdsStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsStatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsStatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsStatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SdsStatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "HighPrioAppStatus" isn't clear, then there should be a description here.
 */
class HighPrioAppStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HighPrioAppStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  HighPrioAppStatusUpdate (const HighPrioAppStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  HighPrioAppStatusUpdate (bool HighPrioAppStatus_);

    /**
     * Destructor
     */
    inline virtual  ~HighPrioAppStatusUpdate();

    /**
     * Assignment operator
     */
    inline HighPrioAppStatusUpdate& operator = (const HighPrioAppStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HighPrioAppStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HighPrioAppStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HighPrioAppStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HighPrioAppStatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "HighPrioAppStatus"

    static const int kHighPrioAppStatus = 0;

    /**
     * Clears the field "HighPrioAppStatus".
     *
     * The field will be set to its default value. The hasHighPrioAppStatus()
     * method will return false.
     */
    inline void clearHighPrioAppStatus();

    /**
     * Checks whether the field "HighPrioAppStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHighPrioAppStatus()). Otherwise it will return false.
     */
    inline bool hasHighPrioAppStatus () const;

    /**
     * Returns the value of the member "HighPrioAppStatus".
     *
     * If the meaning of "HighPrioAppStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "HighPrioAppStatus"
     */
    inline bool getHighPrioAppStatus () const;

    /**
     * Sets the value of the member "HighPrioAppStatus".
     *
     * If the meaning of "HighPrioAppStatus" isn't clear, then there should be a description here.
     *
     * @param HighPrioAppStatus The value which will be set
     */
    inline void setHighPrioAppStatus (bool HighPrioAppStatus_);

    static const HighPrioAppStatusUpdate &getDefaultInstance();

private:

    inline void set_has_HighPrioAppStatus ();

    inline void clear_has_HighPrioAppStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _HighPrioAppStatus;

};

/**
 * If the meaning of "HighPrioAppStatus" isn't clear, then there should be a description here.
 */
class HighPrioAppStatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HighPrioAppStatusRegister ();

    /**
     * Copy constructor
     */
    inline  HighPrioAppStatusRegister (const HighPrioAppStatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~HighPrioAppStatusRegister();

    /**
     * Assignment operator
     */
    inline HighPrioAppStatusRegister& operator = (const HighPrioAppStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HighPrioAppStatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HighPrioAppStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HighPrioAppStatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HighPrioAppStatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const HighPrioAppStatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ActivateAudioDeviceTag" isn't clear, then there should be a description here.
 */
class ActivateAudioDeviceTagSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActivateAudioDeviceTagSignal ();

    /**
     * Copy constructor
     */
    inline  ActivateAudioDeviceTagSignal (const ActivateAudioDeviceTagSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ActivateAudioDeviceTagSignal (uint32 deviceTag_, AudioSource audioSource_);

    /**
     * Destructor
     */
    inline virtual  ~ActivateAudioDeviceTagSignal();

    /**
     * Assignment operator
     */
    inline ActivateAudioDeviceTagSignal& operator = (const ActivateAudioDeviceTagSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActivateAudioDeviceTagSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActivateAudioDeviceTagSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActivateAudioDeviceTagSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActivateAudioDeviceTagSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "deviceTag"

    static const int kDeviceTag = 0;

    /**
     * Clears the field "deviceTag".
     *
     * The field will be set to its default value. The hasDeviceTag()
     * method will return false.
     */
    inline void clearDeviceTag();

    /**
     * Checks whether the field "deviceTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceTag()). Otherwise it will return false.
     */
    inline bool hasDeviceTag () const;

    /**
     * Returns the value of the member "deviceTag".
     *
     * If the meaning of "deviceTag" isn't clear, then there should be a description here.
     *
     * @return The value of the field "deviceTag"
     */
    inline uint32 getDeviceTag () const;

    /**
     * Sets the value of the member "deviceTag".
     *
     * If the meaning of "deviceTag" isn't clear, then there should be a description here.
     *
     * @param deviceTag The value which will be set
     */
    inline void setDeviceTag (uint32 deviceTag_);

    // API of field "audioSource"

    static const int kAudioSource = 1;

    /**
     * Clears the field "audioSource".
     *
     * The field will be set to its default value. The hasAudioSource()
     * method will return false.
     */
    inline void clearAudioSource();

    /**
     * Checks whether the field "audioSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioSource()). Otherwise it will return false.
     */
    inline bool hasAudioSource () const;

    /**
     * Returns the value of the member "audioSource".
     *
     * If the meaning of "audioSource" isn't clear, then there should be a description here.
     *
     * @return The value of the field "audioSource"
     */
    inline AudioSource getAudioSource () const;

    /**
     * Sets the value of the member "audioSource".
     *
     * If the meaning of "audioSource" isn't clear, then there should be a description here.
     *
     * @param audioSource The value which will be set
     */
    inline void setAudioSource (AudioSource audioSource_);

    static const ActivateAudioDeviceTagSignal &getDefaultInstance();

private:

    inline void set_has_deviceTag ();

    inline void clear_has_deviceTag ();

    inline void set_has_audioSource ();

    inline void clear_has_audioSource ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _deviceTag;

    AudioSource _audioSource;

};

/**
 * If the meaning of "ActivateAudioSource" isn't clear, then there should be a description here.
 */
class ActivateAudioSourceSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActivateAudioSourceSignal ();

    /**
     * Copy constructor
     */
    inline  ActivateAudioSourceSignal (const ActivateAudioSourceSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ActivateAudioSourceSignal (AudioSource audioSource_);

    /**
     * Destructor
     */
    inline virtual  ~ActivateAudioSourceSignal();

    /**
     * Assignment operator
     */
    inline ActivateAudioSourceSignal& operator = (const ActivateAudioSourceSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActivateAudioSourceSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActivateAudioSourceSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActivateAudioSourceSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActivateAudioSourceSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "audioSource"

    static const int kAudioSource = 0;

    /**
     * Clears the field "audioSource".
     *
     * The field will be set to its default value. The hasAudioSource()
     * method will return false.
     */
    inline void clearAudioSource();

    /**
     * Checks whether the field "audioSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioSource()). Otherwise it will return false.
     */
    inline bool hasAudioSource () const;

    /**
     * Returns the value of the member "audioSource".
     *
     * If the meaning of "audioSource" isn't clear, then there should be a description here.
     *
     * @return The value of the field "audioSource"
     */
    inline AudioSource getAudioSource () const;

    /**
     * Sets the value of the member "audioSource".
     *
     * If the meaning of "audioSource" isn't clear, then there should be a description here.
     *
     * @param audioSource The value which will be set
     */
    inline void setAudioSource (AudioSource audioSource_);

    static const ActivateAudioSourceSignal &getDefaultInstance();

private:

    inline void set_has_audioSource ();

    inline void clear_has_audioSource ();

    uint32 _has_bits_[ (1 + 31) / 32];

    AudioSource _audioSource;

};

/**
 * OBSOLETE -> use SpokenDigits broadcast from sds_gui_fi::SdsPhoneService
 */
class SpokenDigitsSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpokenDigitsSignal ();

    /**
     * Copy constructor
     */
    inline  SpokenDigitsSignal (const SpokenDigitsSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SpokenDigitsSignal (const ::std::string& digits_);

    /**
     * Destructor
     */
    inline virtual  ~SpokenDigitsSignal();

    /**
     * Assignment operator
     */
    inline SpokenDigitsSignal& operator = (const SpokenDigitsSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpokenDigitsSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpokenDigitsSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpokenDigitsSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpokenDigitsSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "digits"

    static const int kDigits = 0;

    /**
     * Clears the field "digits".
     *
     * The field will be set to its default value. The hasDigits()
     * method will return false.
     */
    inline void clearDigits();

    /**
     * Checks whether the field "digits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDigits()). Otherwise it will return false.
     */
    inline bool hasDigits () const;

    /**
     * Returns the value of the member "digits".
     *
     * If the meaning of "digits" isn't clear, then there should be a description here.
     *
     * @return The value of the field "digits"
     */
    inline const ::std::string& getDigits () const;

    /**
     * Retrieves the value of the field "digits" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "digits".
     */
    inline ::std::string& getDigitsMutable ();

    /**
     * Sets the value of the member "digits".
     *
     * If the meaning of "digits" isn't clear, then there should be a description here.
     *
     * @param digits The value which will be set
     */
    inline void setDigits (const ::std::string& digits_);

    /**
     * Sets the value of the member "digits".
     *
     * If the meaning of "digits" isn't clear, then there should be a description here.
     *
     * @param digits The value which will be set
     */
    inline void setDigits (const char* digits_);

    /**
     * Sets the value of the member "digits".
     *
     * If the meaning of "digits" isn't clear, then there should be a description here.
     *
     * @param digits The value which will be set
     */
    inline void setDigits (const char* value, size_t size);

    static const SpokenDigitsSignal &getDefaultInstance();

private:

    inline void set_has_digits ();

    inline void clear_has_digits ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _digits;

};

/**
 * If the meaning of "Event" isn't clear, then there should be a description here.
 */
class EventSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EventSignal ();

    /**
     * Copy constructor
     */
    inline  EventSignal (const EventSignal &rhs);

    /**
     * All fields constructor
     */
    inline  EventSignal (Event guiEvent_);

    /**
     * Destructor
     */
    inline virtual  ~EventSignal();

    /**
     * Assignment operator
     */
    inline EventSignal& operator = (const EventSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EventSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EventSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EventSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EventSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "guiEvent"

    static const int kGuiEvent = 0;

    /**
     * Clears the field "guiEvent".
     *
     * The field will be set to its default value. The hasGuiEvent()
     * method will return false.
     */
    inline void clearGuiEvent();

    /**
     * Checks whether the field "guiEvent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGuiEvent()). Otherwise it will return false.
     */
    inline bool hasGuiEvent () const;

    /**
     * Returns the value of the member "guiEvent".
     *
     * If the meaning of "guiEvent" isn't clear, then there should be a description here.
     *
     * @return The value of the field "guiEvent"
     */
    inline Event getGuiEvent () const;

    /**
     * Sets the value of the member "guiEvent".
     *
     * If the meaning of "guiEvent" isn't clear, then there should be a description here.
     *
     * @param guiEvent The value which will be set
     */
    inline void setGuiEvent (Event guiEvent_);

    static const EventSignal &getDefaultInstance();

private:

    inline void set_has_guiEvent ();

    inline void clear_has_guiEvent ();

    uint32 _has_bits_[ (1 + 31) / 32];

    Event _guiEvent;

};

inline  PttPressRequest::PttPressRequest ()  :
    _pttPressType (::sds_gui_fi::SdsGuiService::KeyState__KEY_UNDEFINED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PttPressRequest::PttPressRequest (const PttPressRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _pttPressType (::sds_gui_fi::SdsGuiService::KeyState__KEY_UNDEFINED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PttPressRequest::PttPressRequest (KeyState pttPressType_)  :
    _pttPressType (pttPressType_)
{
    #ifndef NDEBUG
    if (!(KeyState_IsValid(pttPressType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", pttPressType_, "KeyState", "pttPressType", "PttPressRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PttPressRequest::~PttPressRequest() {
}

inline PttPressRequest& PttPressRequest::operator = (const PttPressRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPttPressType()) {
            setPttPressType(rhs.getPttPressType());
        } else {
            clearPttPressType();
        }
    }
    return *this;
}

inline bool PttPressRequest::operator == (const PttPressRequest& rhs) const {
    return (((!hasPttPressType() && !rhs.hasPttPressType()) || getPttPressType() == rhs.getPttPressType()));
}

inline bool PttPressRequest::operator != (const PttPressRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool PttPressRequest::operator < (const PttPressRequest& rhs) const {
    if (hasPttPressType() || rhs.hasPttPressType()) {
        if ((uint32)getPttPressType() < (uint32)rhs.getPttPressType()) return true;
        if ((uint32)getPttPressType() > (uint32)rhs.getPttPressType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PttPressRequest::clone() {
    return new PttPressRequest(*this);
}

inline bool PttPressRequest::operator > (const PttPressRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PttPressRequest::clear() {
    clearPttPressType();
}

inline void PttPressRequest::clearPttPressType() {
    if (hasPttPressType()) {
         clear_has_pttPressType();
        _pttPressType = ::sds_gui_fi::SdsGuiService::KeyState__KEY_UNDEFINED;
     }
}

inline bool PttPressRequest::hasPttPressType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline KeyState PttPressRequest::getPttPressType () const {
    return _pttPressType;
}

inline void PttPressRequest::setPttPressType (KeyState pttPressType_) {
    #ifndef NDEBUG
    if (!(KeyState_IsValid(pttPressType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", pttPressType_, "KeyState", "pttPressType", "PttPressRequest");
    }
    #endif
    set_has_pttPressType();
    this->_pttPressType = pttPressType_;
}

inline void PttPressRequest::set_has_pttPressType () {
    _has_bits_[0] |= 1u << 0;
}

inline void PttPressRequest::clear_has_pttPressType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StartSessionContextRequest::StartSessionContextRequest ()  :
    _startupContextType (::sds_gui_fi::SdsGuiService::ContextType__SDS_CONTEXT_CALL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartSessionContextRequest::StartSessionContextRequest (const StartSessionContextRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _startupContextType (::sds_gui_fi::SdsGuiService::ContextType__SDS_CONTEXT_CALL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartSessionContextRequest::StartSessionContextRequest (ContextType startupContextType_)  :
    _startupContextType (startupContextType_)
{
    #ifndef NDEBUG
    if (!(ContextType_IsValid(startupContextType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", startupContextType_, "ContextType", "startupContextType", "StartSessionContextRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartSessionContextRequest::~StartSessionContextRequest() {
}

inline StartSessionContextRequest& StartSessionContextRequest::operator = (const StartSessionContextRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStartupContextType()) {
            setStartupContextType(rhs.getStartupContextType());
        } else {
            clearStartupContextType();
        }
    }
    return *this;
}

inline bool StartSessionContextRequest::operator == (const StartSessionContextRequest& rhs) const {
    return (((!hasStartupContextType() && !rhs.hasStartupContextType()) || getStartupContextType() == rhs.getStartupContextType()));
}

inline bool StartSessionContextRequest::operator != (const StartSessionContextRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool StartSessionContextRequest::operator < (const StartSessionContextRequest& rhs) const {
    if (hasStartupContextType() || rhs.hasStartupContextType()) {
        if ((uint32)getStartupContextType() < (uint32)rhs.getStartupContextType()) return true;
        if ((uint32)getStartupContextType() > (uint32)rhs.getStartupContextType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartSessionContextRequest::clone() {
    return new StartSessionContextRequest(*this);
}

inline bool StartSessionContextRequest::operator > (const StartSessionContextRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartSessionContextRequest::clear() {
    clearStartupContextType();
}

inline void StartSessionContextRequest::clearStartupContextType() {
    if (hasStartupContextType()) {
         clear_has_startupContextType();
        _startupContextType = ::sds_gui_fi::SdsGuiService::ContextType__SDS_CONTEXT_CALL;
     }
}

inline bool StartSessionContextRequest::hasStartupContextType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ContextType StartSessionContextRequest::getStartupContextType () const {
    return _startupContextType;
}

inline void StartSessionContextRequest::setStartupContextType (ContextType startupContextType_) {
    #ifndef NDEBUG
    if (!(ContextType_IsValid(startupContextType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", startupContextType_, "ContextType", "startupContextType", "StartSessionContextRequest");
    }
    #endif
    set_has_startupContextType();
    this->_startupContextType = startupContextType_;
}

inline void StartSessionContextRequest::set_has_startupContextType () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartSessionContextRequest::clear_has_startupContextType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ManualOperationRequest::ManualOperationRequest ()  :
    _operationType (::sds_gui_fi::SdsGuiService::OperationType__MANUAL_INTERVENTION_HAPTICAL_SELECTION),
    _value (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ManualOperationRequest::ManualOperationRequest (const ManualOperationRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _operationType (::sds_gui_fi::SdsGuiService::OperationType__MANUAL_INTERVENTION_HAPTICAL_SELECTION),
    _value (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ManualOperationRequest::ManualOperationRequest (OperationType operationType_, uint32 value_)  :
    _operationType (operationType_),
    _value (value_)
{
    #ifndef NDEBUG
    if (!(OperationType_IsValid(operationType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", operationType_, "OperationType", "operationType", "ManualOperationRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ManualOperationRequest::~ManualOperationRequest() {
}

inline ManualOperationRequest& ManualOperationRequest::operator = (const ManualOperationRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasOperationType()) {
            setOperationType(rhs.getOperationType());
        } else {
            clearOperationType();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool ManualOperationRequest::operator == (const ManualOperationRequest& rhs) const {
    return (((!hasOperationType() && !rhs.hasOperationType()) || getOperationType() == rhs.getOperationType()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool ManualOperationRequest::operator != (const ManualOperationRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ManualOperationRequest::operator < (const ManualOperationRequest& rhs) const {
    if (hasOperationType() || rhs.hasOperationType()) {
        if ((uint32)getOperationType() < (uint32)rhs.getOperationType()) return true;
        if ((uint32)getOperationType() > (uint32)rhs.getOperationType()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ManualOperationRequest::clone() {
    return new ManualOperationRequest(*this);
}

inline bool ManualOperationRequest::operator > (const ManualOperationRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ManualOperationRequest::clear() {
    clearOperationType();
    clearValue();
}

inline void ManualOperationRequest::clearOperationType() {
    if (hasOperationType()) {
         clear_has_operationType();
        _operationType = ::sds_gui_fi::SdsGuiService::OperationType__MANUAL_INTERVENTION_HAPTICAL_SELECTION;
     }
}

inline bool ManualOperationRequest::hasOperationType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline OperationType ManualOperationRequest::getOperationType () const {
    return _operationType;
}

inline void ManualOperationRequest::setOperationType (OperationType operationType_) {
    #ifndef NDEBUG
    if (!(OperationType_IsValid(operationType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", operationType_, "OperationType", "operationType", "ManualOperationRequest");
    }
    #endif
    set_has_operationType();
    this->_operationType = operationType_;
}

inline void ManualOperationRequest::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value = 0u;
     }
}

inline bool ManualOperationRequest::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 ManualOperationRequest::getValue () const {
    return _value;
}

inline void ManualOperationRequest::setValue (uint32 value_) {
    set_has_value();
    this->_value = value_;
}

inline void ManualOperationRequest::set_has_operationType () {
    _has_bits_[0] |= 1u << 0;
}

inline void ManualOperationRequest::clear_has_operationType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ManualOperationRequest::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void ManualOperationRequest::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  TestModeUpdateRequest::TestModeUpdateRequest ()  :
    _tModesentence ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TestModeUpdateRequest::TestModeUpdateRequest (const TestModeUpdateRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _tModesentence ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TestModeUpdateRequest::TestModeUpdateRequest (const ::std::string& tModesentence_)  :
    _tModesentence (tModesentence_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tModesentence_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TestModeUpdateRequest::~TestModeUpdateRequest() {
}

inline TestModeUpdateRequest& TestModeUpdateRequest::operator = (const TestModeUpdateRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTModesentence()) {
            setTModesentence(rhs.getTModesentence());
        } else {
            clearTModesentence();
        }
    }
    return *this;
}

inline bool TestModeUpdateRequest::operator == (const TestModeUpdateRequest& rhs) const {
    return (((!hasTModesentence() && !rhs.hasTModesentence()) || getTModesentence() == rhs.getTModesentence()));
}

inline bool TestModeUpdateRequest::operator != (const TestModeUpdateRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool TestModeUpdateRequest::operator < (const TestModeUpdateRequest& rhs) const {
    if (hasTModesentence() || rhs.hasTModesentence()) {
        if (getTModesentence() < rhs.getTModesentence()) return true;
        if (getTModesentence() > rhs.getTModesentence()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TestModeUpdateRequest::clone() {
    return new TestModeUpdateRequest(*this);
}

inline bool TestModeUpdateRequest::operator > (const TestModeUpdateRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TestModeUpdateRequest::clear() {
    clearTModesentence();
}

inline void TestModeUpdateRequest::clearTModesentence() {
    if (hasTModesentence()) {
         clear_has_tModesentence();
        _tModesentence.clear();
     }
}

inline bool TestModeUpdateRequest::hasTModesentence () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& TestModeUpdateRequest::getTModesentence () const {
    return _tModesentence;
}

inline ::std::string& TestModeUpdateRequest::getTModesentenceMutable () {
    set_has_tModesentence();
    return _tModesentence;
}

inline void TestModeUpdateRequest::setTModesentence (const ::std::string& tModesentence_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tModesentence_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tModesentence();
    this->_tModesentence = tModesentence_;
}

inline void TestModeUpdateRequest::setTModesentence (const char* tModesentence_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tModesentence_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tModesentence();
    this->_tModesentence.assign(tModesentence_);
}

inline void TestModeUpdateRequest::setTModesentence (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tModesentence();
    this->_tModesentence.assign(value, size);
}

inline void TestModeUpdateRequest::set_has_tModesentence () {
    _has_bits_[0] |= 1u << 0;
}

inline void TestModeUpdateRequest::clear_has_tModesentence () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CursorIndexForInitialFocusRequest::CursorIndexForInitialFocusRequest ()  :
    _index (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CursorIndexForInitialFocusRequest::CursorIndexForInitialFocusRequest (const CursorIndexForInitialFocusRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _index (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CursorIndexForInitialFocusRequest::CursorIndexForInitialFocusRequest (uint32 index_)  :
    _index (index_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CursorIndexForInitialFocusRequest::~CursorIndexForInitialFocusRequest() {
}

inline CursorIndexForInitialFocusRequest& CursorIndexForInitialFocusRequest::operator = (const CursorIndexForInitialFocusRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasIndex()) {
            setIndex(rhs.getIndex());
        } else {
            clearIndex();
        }
    }
    return *this;
}

inline bool CursorIndexForInitialFocusRequest::operator == (const CursorIndexForInitialFocusRequest& rhs) const {
    return (((!hasIndex() && !rhs.hasIndex()) || getIndex() == rhs.getIndex()));
}

inline bool CursorIndexForInitialFocusRequest::operator != (const CursorIndexForInitialFocusRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool CursorIndexForInitialFocusRequest::operator < (const CursorIndexForInitialFocusRequest& rhs) const {
    if (hasIndex() || rhs.hasIndex()) {
        if (getIndex() < rhs.getIndex()) return true;
        if (getIndex() > rhs.getIndex()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CursorIndexForInitialFocusRequest::clone() {
    return new CursorIndexForInitialFocusRequest(*this);
}

inline bool CursorIndexForInitialFocusRequest::operator > (const CursorIndexForInitialFocusRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CursorIndexForInitialFocusRequest::clear() {
    clearIndex();
}

inline void CursorIndexForInitialFocusRequest::clearIndex() {
    if (hasIndex()) {
         clear_has_index();
        _index = 0u;
     }
}

inline bool CursorIndexForInitialFocusRequest::hasIndex () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 CursorIndexForInitialFocusRequest::getIndex () const {
    return _index;
}

inline void CursorIndexForInitialFocusRequest::setIndex (uint32 index_) {
    set_has_index();
    this->_index = index_;
}

inline void CursorIndexForInitialFocusRequest::set_has_index () {
    _has_bits_[0] |= 1u << 0;
}

inline void CursorIndexForInitialFocusRequest::clear_has_index () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SdsStatusUpdate::SdsStatusUpdate ()  :
    _sdsStatus (::sds_gui_fi::SdsGuiService::SpeechInputState__UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SdsStatusUpdate::SdsStatusUpdate (const SdsStatusUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _sdsStatus (::sds_gui_fi::SdsGuiService::SpeechInputState__UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SdsStatusUpdate::SdsStatusUpdate (SpeechInputState sdsStatus_)  :
    _sdsStatus (sdsStatus_)
{
    #ifndef NDEBUG
    if (!(SpeechInputState_IsValid(sdsStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", sdsStatus_, "SpeechInputState", "sdsStatus", "SdsStatusUpdate");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SdsStatusUpdate::~SdsStatusUpdate() {
}

inline SdsStatusUpdate& SdsStatusUpdate::operator = (const SdsStatusUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSdsStatus()) {
            setSdsStatus(rhs.getSdsStatus());
        } else {
            clearSdsStatus();
        }
    }
    return *this;
}

inline bool SdsStatusUpdate::operator == (const SdsStatusUpdate& rhs) const {
    return (((!hasSdsStatus() && !rhs.hasSdsStatus()) || getSdsStatus() == rhs.getSdsStatus()));
}

inline bool SdsStatusUpdate::operator != (const SdsStatusUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SdsStatusUpdate::operator < (const SdsStatusUpdate& rhs) const {
    if (hasSdsStatus() || rhs.hasSdsStatus()) {
        if ((uint32)getSdsStatus() < (uint32)rhs.getSdsStatus()) return true;
        if ((uint32)getSdsStatus() > (uint32)rhs.getSdsStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SdsStatusUpdate::clone() {
    return new SdsStatusUpdate(*this);
}

inline bool SdsStatusUpdate::operator > (const SdsStatusUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SdsStatusUpdate::clear() {
    clearSdsStatus();
}

inline void SdsStatusUpdate::clearSdsStatus() {
    if (hasSdsStatus()) {
         clear_has_sdsStatus();
        _sdsStatus = ::sds_gui_fi::SdsGuiService::SpeechInputState__UNKNOWN;
     }
}

inline bool SdsStatusUpdate::hasSdsStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline SpeechInputState SdsStatusUpdate::getSdsStatus () const {
    return _sdsStatus;
}

inline void SdsStatusUpdate::setSdsStatus (SpeechInputState sdsStatus_) {
    #ifndef NDEBUG
    if (!(SpeechInputState_IsValid(sdsStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", sdsStatus_, "SpeechInputState", "sdsStatus", "SdsStatusUpdate");
    }
    #endif
    set_has_sdsStatus();
    this->_sdsStatus = sdsStatus_;
}

inline void SdsStatusUpdate::set_has_sdsStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void SdsStatusUpdate::clear_has_sdsStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SdsStatusRegister::SdsStatusRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SdsStatusRegister::SdsStatusRegister (const SdsStatusRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SdsStatusRegister::~SdsStatusRegister() {
}

inline SdsStatusRegister& SdsStatusRegister::operator = (const SdsStatusRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SdsStatusRegister::operator == (const SdsStatusRegister& ) const {
    return true;
}

inline bool SdsStatusRegister::operator != (const SdsStatusRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SdsStatusRegister::operator < (const SdsStatusRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SdsStatusRegister::clone() {
    return new SdsStatusRegister(*this);
}

inline bool SdsStatusRegister::operator > (const SdsStatusRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SdsStatusRegister::clear() {
}

inline  HighPrioAppStatusUpdate::HighPrioAppStatusUpdate ()  :
    _HighPrioAppStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HighPrioAppStatusUpdate::HighPrioAppStatusUpdate (const HighPrioAppStatusUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _HighPrioAppStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HighPrioAppStatusUpdate::HighPrioAppStatusUpdate (bool HighPrioAppStatus_)  :
    _HighPrioAppStatus (HighPrioAppStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  HighPrioAppStatusUpdate::~HighPrioAppStatusUpdate() {
}

inline HighPrioAppStatusUpdate& HighPrioAppStatusUpdate::operator = (const HighPrioAppStatusUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasHighPrioAppStatus()) {
            setHighPrioAppStatus(rhs.getHighPrioAppStatus());
        } else {
            clearHighPrioAppStatus();
        }
    }
    return *this;
}

inline bool HighPrioAppStatusUpdate::operator == (const HighPrioAppStatusUpdate& rhs) const {
    return (((!hasHighPrioAppStatus() && !rhs.hasHighPrioAppStatus()) || getHighPrioAppStatus() == rhs.getHighPrioAppStatus()));
}

inline bool HighPrioAppStatusUpdate::operator != (const HighPrioAppStatusUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool HighPrioAppStatusUpdate::operator < (const HighPrioAppStatusUpdate& rhs) const {
    if (hasHighPrioAppStatus() || rhs.hasHighPrioAppStatus()) {
        if (getHighPrioAppStatus() < rhs.getHighPrioAppStatus()) return true;
        if (getHighPrioAppStatus() > rhs.getHighPrioAppStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* HighPrioAppStatusUpdate::clone() {
    return new HighPrioAppStatusUpdate(*this);
}

inline bool HighPrioAppStatusUpdate::operator > (const HighPrioAppStatusUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HighPrioAppStatusUpdate::clear() {
    clearHighPrioAppStatus();
}

inline void HighPrioAppStatusUpdate::clearHighPrioAppStatus() {
    if (hasHighPrioAppStatus()) {
         clear_has_HighPrioAppStatus();
        _HighPrioAppStatus = false;
     }
}

inline bool HighPrioAppStatusUpdate::hasHighPrioAppStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool HighPrioAppStatusUpdate::getHighPrioAppStatus () const {
    return _HighPrioAppStatus;
}

inline void HighPrioAppStatusUpdate::setHighPrioAppStatus (bool HighPrioAppStatus_) {
    set_has_HighPrioAppStatus();
    this->_HighPrioAppStatus = HighPrioAppStatus_;
}

inline void HighPrioAppStatusUpdate::set_has_HighPrioAppStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void HighPrioAppStatusUpdate::clear_has_HighPrioAppStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  HighPrioAppStatusRegister::HighPrioAppStatusRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HighPrioAppStatusRegister::HighPrioAppStatusRegister (const HighPrioAppStatusRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HighPrioAppStatusRegister::~HighPrioAppStatusRegister() {
}

inline HighPrioAppStatusRegister& HighPrioAppStatusRegister::operator = (const HighPrioAppStatusRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool HighPrioAppStatusRegister::operator == (const HighPrioAppStatusRegister& ) const {
    return true;
}

inline bool HighPrioAppStatusRegister::operator != (const HighPrioAppStatusRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool HighPrioAppStatusRegister::operator < (const HighPrioAppStatusRegister& ) const {
    return false;
}

inline ::asf::core::Payload* HighPrioAppStatusRegister::clone() {
    return new HighPrioAppStatusRegister(*this);
}

inline bool HighPrioAppStatusRegister::operator > (const HighPrioAppStatusRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HighPrioAppStatusRegister::clear() {
}

inline  ActivateAudioDeviceTagSignal::ActivateAudioDeviceTagSignal ()  :
    _deviceTag (0u),
    _audioSource (::sds_gui_fi::SdsGuiService::AudioSource__FM)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActivateAudioDeviceTagSignal::ActivateAudioDeviceTagSignal (const ActivateAudioDeviceTagSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _deviceTag (0u),
    _audioSource (::sds_gui_fi::SdsGuiService::AudioSource__FM)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActivateAudioDeviceTagSignal::ActivateAudioDeviceTagSignal (uint32 deviceTag_, AudioSource audioSource_)  :
    _deviceTag (deviceTag_),
    _audioSource (audioSource_)
{
    #ifndef NDEBUG
    if (!(AudioSource_IsValid(audioSource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", audioSource_, "AudioSource", "audioSource", "ActivateAudioDeviceTagSignal");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActivateAudioDeviceTagSignal::~ActivateAudioDeviceTagSignal() {
}

inline ActivateAudioDeviceTagSignal& ActivateAudioDeviceTagSignal::operator = (const ActivateAudioDeviceTagSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDeviceTag()) {
            setDeviceTag(rhs.getDeviceTag());
        } else {
            clearDeviceTag();
        }
        if (rhs.hasAudioSource()) {
            setAudioSource(rhs.getAudioSource());
        } else {
            clearAudioSource();
        }
    }
    return *this;
}

inline bool ActivateAudioDeviceTagSignal::operator == (const ActivateAudioDeviceTagSignal& rhs) const {
    return (((!hasDeviceTag() && !rhs.hasDeviceTag()) || getDeviceTag() == rhs.getDeviceTag()) &&
        ((!hasAudioSource() && !rhs.hasAudioSource()) || getAudioSource() == rhs.getAudioSource()));
}

inline bool ActivateAudioDeviceTagSignal::operator != (const ActivateAudioDeviceTagSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ActivateAudioDeviceTagSignal::operator < (const ActivateAudioDeviceTagSignal& rhs) const {
    if (hasDeviceTag() || rhs.hasDeviceTag()) {
        if (getDeviceTag() < rhs.getDeviceTag()) return true;
        if (getDeviceTag() > rhs.getDeviceTag()) return false;
    }
    if (hasAudioSource() || rhs.hasAudioSource()) {
        if ((uint32)getAudioSource() < (uint32)rhs.getAudioSource()) return true;
        if ((uint32)getAudioSource() > (uint32)rhs.getAudioSource()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActivateAudioDeviceTagSignal::clone() {
    return new ActivateAudioDeviceTagSignal(*this);
}

inline bool ActivateAudioDeviceTagSignal::operator > (const ActivateAudioDeviceTagSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActivateAudioDeviceTagSignal::clear() {
    clearDeviceTag();
    clearAudioSource();
}

inline void ActivateAudioDeviceTagSignal::clearDeviceTag() {
    if (hasDeviceTag()) {
         clear_has_deviceTag();
        _deviceTag = 0u;
     }
}

inline bool ActivateAudioDeviceTagSignal::hasDeviceTag () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 ActivateAudioDeviceTagSignal::getDeviceTag () const {
    return _deviceTag;
}

inline void ActivateAudioDeviceTagSignal::setDeviceTag (uint32 deviceTag_) {
    set_has_deviceTag();
    this->_deviceTag = deviceTag_;
}

inline void ActivateAudioDeviceTagSignal::clearAudioSource() {
    if (hasAudioSource()) {
         clear_has_audioSource();
        _audioSource = ::sds_gui_fi::SdsGuiService::AudioSource__FM;
     }
}

inline bool ActivateAudioDeviceTagSignal::hasAudioSource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline AudioSource ActivateAudioDeviceTagSignal::getAudioSource () const {
    return _audioSource;
}

inline void ActivateAudioDeviceTagSignal::setAudioSource (AudioSource audioSource_) {
    #ifndef NDEBUG
    if (!(AudioSource_IsValid(audioSource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", audioSource_, "AudioSource", "audioSource", "ActivateAudioDeviceTagSignal");
    }
    #endif
    set_has_audioSource();
    this->_audioSource = audioSource_;
}

inline void ActivateAudioDeviceTagSignal::set_has_deviceTag () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActivateAudioDeviceTagSignal::clear_has_deviceTag () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ActivateAudioDeviceTagSignal::set_has_audioSource () {
    _has_bits_[0] |= 1u << 1;
}

inline void ActivateAudioDeviceTagSignal::clear_has_audioSource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ActivateAudioSourceSignal::ActivateAudioSourceSignal ()  :
    _audioSource (::sds_gui_fi::SdsGuiService::AudioSource__FM)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActivateAudioSourceSignal::ActivateAudioSourceSignal (const ActivateAudioSourceSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _audioSource (::sds_gui_fi::SdsGuiService::AudioSource__FM)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActivateAudioSourceSignal::ActivateAudioSourceSignal (AudioSource audioSource_)  :
    _audioSource (audioSource_)
{
    #ifndef NDEBUG
    if (!(AudioSource_IsValid(audioSource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", audioSource_, "AudioSource", "audioSource", "ActivateAudioSourceSignal");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActivateAudioSourceSignal::~ActivateAudioSourceSignal() {
}

inline ActivateAudioSourceSignal& ActivateAudioSourceSignal::operator = (const ActivateAudioSourceSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAudioSource()) {
            setAudioSource(rhs.getAudioSource());
        } else {
            clearAudioSource();
        }
    }
    return *this;
}

inline bool ActivateAudioSourceSignal::operator == (const ActivateAudioSourceSignal& rhs) const {
    return (((!hasAudioSource() && !rhs.hasAudioSource()) || getAudioSource() == rhs.getAudioSource()));
}

inline bool ActivateAudioSourceSignal::operator != (const ActivateAudioSourceSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ActivateAudioSourceSignal::operator < (const ActivateAudioSourceSignal& rhs) const {
    if (hasAudioSource() || rhs.hasAudioSource()) {
        if ((uint32)getAudioSource() < (uint32)rhs.getAudioSource()) return true;
        if ((uint32)getAudioSource() > (uint32)rhs.getAudioSource()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActivateAudioSourceSignal::clone() {
    return new ActivateAudioSourceSignal(*this);
}

inline bool ActivateAudioSourceSignal::operator > (const ActivateAudioSourceSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActivateAudioSourceSignal::clear() {
    clearAudioSource();
}

inline void ActivateAudioSourceSignal::clearAudioSource() {
    if (hasAudioSource()) {
         clear_has_audioSource();
        _audioSource = ::sds_gui_fi::SdsGuiService::AudioSource__FM;
     }
}

inline bool ActivateAudioSourceSignal::hasAudioSource () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline AudioSource ActivateAudioSourceSignal::getAudioSource () const {
    return _audioSource;
}

inline void ActivateAudioSourceSignal::setAudioSource (AudioSource audioSource_) {
    #ifndef NDEBUG
    if (!(AudioSource_IsValid(audioSource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", audioSource_, "AudioSource", "audioSource", "ActivateAudioSourceSignal");
    }
    #endif
    set_has_audioSource();
    this->_audioSource = audioSource_;
}

inline void ActivateAudioSourceSignal::set_has_audioSource () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActivateAudioSourceSignal::clear_has_audioSource () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SpokenDigitsSignal::SpokenDigitsSignal ()  :
    _digits ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SpokenDigitsSignal::SpokenDigitsSignal (const SpokenDigitsSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _digits ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SpokenDigitsSignal::SpokenDigitsSignal (const ::std::string& digits_)  :
    _digits (digits_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (digits_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SpokenDigitsSignal::~SpokenDigitsSignal() {
}

inline SpokenDigitsSignal& SpokenDigitsSignal::operator = (const SpokenDigitsSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDigits()) {
            setDigits(rhs.getDigits());
        } else {
            clearDigits();
        }
    }
    return *this;
}

inline bool SpokenDigitsSignal::operator == (const SpokenDigitsSignal& rhs) const {
    return (((!hasDigits() && !rhs.hasDigits()) || getDigits() == rhs.getDigits()));
}

inline bool SpokenDigitsSignal::operator != (const SpokenDigitsSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SpokenDigitsSignal::operator < (const SpokenDigitsSignal& rhs) const {
    if (hasDigits() || rhs.hasDigits()) {
        if (getDigits() < rhs.getDigits()) return true;
        if (getDigits() > rhs.getDigits()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SpokenDigitsSignal::clone() {
    return new SpokenDigitsSignal(*this);
}

inline bool SpokenDigitsSignal::operator > (const SpokenDigitsSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SpokenDigitsSignal::clear() {
    clearDigits();
}

inline void SpokenDigitsSignal::clearDigits() {
    if (hasDigits()) {
         clear_has_digits();
        _digits.clear();
     }
}

inline bool SpokenDigitsSignal::hasDigits () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SpokenDigitsSignal::getDigits () const {
    return _digits;
}

inline ::std::string& SpokenDigitsSignal::getDigitsMutable () {
    set_has_digits();
    return _digits;
}

inline void SpokenDigitsSignal::setDigits (const ::std::string& digits_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (digits_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_digits();
    this->_digits = digits_;
}

inline void SpokenDigitsSignal::setDigits (const char* digits_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (digits_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_digits();
    this->_digits.assign(digits_);
}

inline void SpokenDigitsSignal::setDigits (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_digits();
    this->_digits.assign(value, size);
}

inline void SpokenDigitsSignal::set_has_digits () {
    _has_bits_[0] |= 1u << 0;
}

inline void SpokenDigitsSignal::clear_has_digits () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EventSignal::EventSignal ()  :
    _guiEvent (::sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_CLOSE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EventSignal::EventSignal (const EventSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _guiEvent (::sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_CLOSE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EventSignal::EventSignal (Event guiEvent_)  :
    _guiEvent (guiEvent_)
{
    #ifndef NDEBUG
    if (!(Event_IsValid(guiEvent_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", guiEvent_, "Event", "guiEvent", "EventSignal");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EventSignal::~EventSignal() {
}

inline EventSignal& EventSignal::operator = (const EventSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGuiEvent()) {
            setGuiEvent(rhs.getGuiEvent());
        } else {
            clearGuiEvent();
        }
    }
    return *this;
}

inline bool EventSignal::operator == (const EventSignal& rhs) const {
    return (((!hasGuiEvent() && !rhs.hasGuiEvent()) || getGuiEvent() == rhs.getGuiEvent()));
}

inline bool EventSignal::operator != (const EventSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool EventSignal::operator < (const EventSignal& rhs) const {
    if (hasGuiEvent() || rhs.hasGuiEvent()) {
        if ((uint32)getGuiEvent() < (uint32)rhs.getGuiEvent()) return true;
        if ((uint32)getGuiEvent() > (uint32)rhs.getGuiEvent()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EventSignal::clone() {
    return new EventSignal(*this);
}

inline bool EventSignal::operator > (const EventSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EventSignal::clear() {
    clearGuiEvent();
}

inline void EventSignal::clearGuiEvent() {
    if (hasGuiEvent()) {
         clear_has_guiEvent();
        _guiEvent = ::sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_CLOSE;
     }
}

inline bool EventSignal::hasGuiEvent () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline Event EventSignal::getGuiEvent () const {
    return _guiEvent;
}

inline void EventSignal::setGuiEvent (Event guiEvent_) {
    #ifndef NDEBUG
    if (!(Event_IsValid(guiEvent_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", guiEvent_, "Event", "guiEvent", "EventSignal");
    }
    #endif
    set_has_guiEvent();
    this->_guiEvent = guiEvent_;
}

inline void EventSignal::set_has_guiEvent () {
    _has_bits_[0] |= 1u << 0;
}

inline void EventSignal::clear_has_guiEvent () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace SdsGuiService
} // namespace sds_gui_fi

#endif // SDS_GUI_FI_SDSGUISERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
