/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "sds_gui_fi/SdsFocusService.h"
#include "sds_gui_fi/SdsFocusServiceDBus.h"
#include "sds_gui_fi/SdsFocusServiceJson.h"
#include "sds_gui_fi/SdsFocusServiceStub.h"
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace sds_gui_fi {
namespace SdsFocusService {

DEFINE_CLASS_LOGGER("/sds_gui_fi/sds_gui_fi/SdsFocusService", SdsFocusServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 12, "SdsFocusMode", 0 },
    { 21, "SetActiveAppProcessID", 1 },
};


class SdsFocusServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    SdsFocusServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    SdsFocusServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    SdsFocusServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "sds_gui_fi.SdsFocusService"),
          _logger(logger) {}

    virtual ~SdsFocusServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void SdsFocusServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 2, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'SdsFocusMode'

            LOG_DEBUG_STUB("process method '%s'", "SdsFocusMode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsFocusModeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SdsFocusMode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SdsFocusModeRequest > payload = ::boost::static_pointer_cast<SdsFocusModeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsFocusServiceStub*>(getStub())->onSdsFocusModeRequest(payload);
            return;
        }
        case 1: {

            // method 'SetActiveAppProcessID'

            LOG_DEBUG_STUB("process method '%s'", "SetActiveAppProcessID");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetActiveAppProcessIDRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetActiveAppProcessID", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetActiveAppProcessIDRequest > payload = ::boost::static_pointer_cast<SetActiveAppProcessIDRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsFocusServiceStub*>(getStub())->onSetActiveAppProcessIDRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* SdsFocusServiceStubDelegate::introspect() const {
    return     "<interface name=\"sds_gui_fi.SdsFocusService\">\n"
            "    <method name=\"SdsFocusMode\">\n"
            "      <arg direction=\"in\" name=\"identifier\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>identifier = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"sdsFocusModeType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>sdsFocusModeType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetActiveAppProcessID\">\n"
            "      <arg direction=\"in\" name=\"identifier\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>identifier = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"SdsFocusModeUpdate\">\n"
            "      <arg direction=\"out\" name=\"SdsFocusModeList\" type=\"a(uu)\">\n"
            "        <doc>\n"
            "          <line>SdsFocusModeList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"ActiveAppProcessIDUpdate\">\n"
            "      <arg direction=\"out\" name=\"identifier\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>identifier = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "</interface>\n";
}

void SdsFocusServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<SdsFocusServiceStub*>(getStub()))->onGetAll (properties);
}

void SdsFocusServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void SdsFocusServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

SdsFocusServiceStub::SdsFocusServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SdsFocusServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SdsFocusServiceStub::SdsFocusServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SdsFocusServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SdsFocusServiceStub::~SdsFocusServiceStub() {
    delete _stubDelegate;
}

void SdsFocusServiceStub::sendSdsFocusModeUpdateSignal(const ::std::vector< SdsFocusModeList >& sdsFocusModeList) {
    if (_stubDelegate->isConnected()) {
        SdsFocusModeUpdateSignal* payload = new SdsFocusModeUpdateSignal(sdsFocusModeList);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SdsFocusModeUpdate", SdsFocusModeUpdateSignal, payload)
        LOG_INFO ("-> send%sSignal", "SdsFocusModeUpdate");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SdsFocusModeUpdate");
    }
}

void SdsFocusServiceStub::sendActiveAppProcessIDUpdateSignal(uint32 identifier) {
    if (_stubDelegate->isConnected()) {
        ActiveAppProcessIDUpdateSignal* payload = new ActiveAppProcessIDUpdateSignal(identifier);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ActiveAppProcessIDUpdate", ActiveAppProcessIDUpdateSignal, payload)
        LOG_INFO ("-> send%sSignal", "ActiveAppProcessIDUpdate");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ActiveAppProcessIDUpdate");
    }
}

void  SdsFocusServiceStub::sendSdsFocusModeResponse (act_t act) {
    SdsFocusModeResponse* payload = new SdsFocusModeResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SdsFocusMode", SdsFocusModeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SdsFocusMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsFocusServiceStub::sendSdsFocusModeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SdsFocusModeError* payload = new SdsFocusModeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SdsFocusMode", SdsFocusModeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SdsFocusMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsFocusServiceStub::sendSetActiveAppProcessIDResponse (act_t act) {
    SetActiveAppProcessIDResponse* payload = new SetActiveAppProcessIDResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SetActiveAppProcessID", SetActiveAppProcessIDResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetActiveAppProcessID", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsFocusServiceStub::sendSetActiveAppProcessIDError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetActiveAppProcessIDError* payload = new SetActiveAppProcessIDError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetActiveAppProcessID", SetActiveAppProcessIDError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetActiveAppProcessID", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void SdsFocusServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace SdsFocusService
} // namespace sds_gui_fi
