/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "sds_gui_fi/SdsFocusService.h"
#include "sds_gui_fi/SdsFocusServiceConst.h"
#include "sds_gui_fi/SdsFocusServiceDBus.h"
#include "sds_gui_fi/SdsFocusServiceJson.h"
#include "sds_gui_fi/SdsFocusServiceProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace sds_gui_fi {
namespace SdsFocusService {

DEFINE_CLASS_LOGGER("/sds_gui_fi/sds_gui_fi/SdsFocusService", SdsFocusServiceProxy);

class SdsFocusServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    SdsFocusServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< SdsFocusServiceProxy >& proxyShared = ::boost::static_pointer_cast< SdsFocusServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_SdsFocusModeUpdate:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsFocusModeUpdateSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SdsFocusModeUpdate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SdsFocusModeUpdateSignal> payload = ::boost::static_pointer_cast<SdsFocusModeUpdateSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SdsFocusModeUpdateCallbackIF*) _callback)->onSdsFocusModeUpdateSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_ActiveAppProcessIDUpdate:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveAppProcessIDUpdateSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveAppProcessIDUpdate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ActiveAppProcessIDUpdateSignal> payload = ::boost::static_pointer_cast<ActiveAppProcessIDUpdateSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ActiveAppProcessIDUpdateCallbackIF*) _callback)->onActiveAppProcessIDUpdateSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SdsFocusMode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SdsFocusModeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsFocusMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsFocusModeError> payload = ::boost::static_pointer_cast<SdsFocusModeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsFocusModeCallbackIF*) _callback)->onSdsFocusModeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsFocusModeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsFocusMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsFocusModeResponse> payload = ::boost::static_pointer_cast<SdsFocusModeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsFocusModeCallbackIF*) _callback)->onSdsFocusModeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetActiveAppProcessID:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetActiveAppProcessIDError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetActiveAppProcessID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetActiveAppProcessIDError> payload = ::boost::static_pointer_cast<SetActiveAppProcessIDError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetActiveAppProcessIDCallbackIF*) _callback)->onSetActiveAppProcessIDError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetActiveAppProcessIDResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetActiveAppProcessID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetActiveAppProcessIDResponse> payload = ::boost::static_pointer_cast<SetActiveAppProcessIDResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetActiveAppProcessIDCallbackIF*) _callback)->onSetActiveAppProcessIDResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_SdsFocusModeUpdate: {
                ::boost::shared_ptr< SdsFocusModeUpdateError > payload = ::boost::shared_ptr< SdsFocusModeUpdateError >
                (new SdsFocusModeUpdateError(DBUS_ERROR_NO_SERVER, "The DBus service SdsFocusService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SdsFocusModeUpdate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsFocusServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsFocusServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SdsFocusModeUpdateCallbackIF*) _callback)->onSdsFocusModeUpdateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ActiveAppProcessIDUpdate: {
                ::boost::shared_ptr< ActiveAppProcessIDUpdateError > payload = ::boost::shared_ptr< ActiveAppProcessIDUpdateError >
                (new ActiveAppProcessIDUpdateError(DBUS_ERROR_NO_SERVER, "The DBus service SdsFocusService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActiveAppProcessIDUpdate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsFocusServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsFocusServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActiveAppProcessIDUpdateCallbackIF*) _callback)->onActiveAppProcessIDUpdateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SdsFocusMode: {
                ::boost::shared_ptr< SdsFocusModeError > payload = ::boost::shared_ptr< SdsFocusModeError >
                (new SdsFocusModeError(DBUS_ERROR_NO_SERVER, "The DBus service SdsFocusService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SdsFocusMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsFocusServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsFocusServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SdsFocusModeCallbackIF*) _callback)->onSdsFocusModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetActiveAppProcessID: {
                ::boost::shared_ptr< SetActiveAppProcessIDError > payload = ::boost::shared_ptr< SetActiveAppProcessIDError >
                (new SetActiveAppProcessIDError(DBUS_ERROR_NO_SERVER, "The DBus service SdsFocusService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetActiveAppProcessID", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsFocusServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsFocusServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetActiveAppProcessIDCallbackIF*) _callback)->onSetActiveAppProcessIDError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& SdsFocusServiceProxyCallback::_logger (SdsFocusServiceProxy::_logger);

SdsFocusServiceProxy::SdsFocusServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "sds_gui_fi.SdsFocusService", serviceAvailable, _logger) {
}

SdsFocusServiceProxy::~SdsFocusServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< SdsFocusServiceProxy > SdsFocusServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<SdsFocusServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< SdsFocusServiceProxy > proxyNew(new SdsFocusServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t SdsFocusServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    SdsFocusServiceProxyCallback* callback = new SdsFocusServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t SdsFocusServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    SdsFocusServiceProxyCallback* callback = new SdsFocusServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void SdsFocusServiceProxy::sendDeregisterAll () const
{
    sendSdsFocusModeUpdateDeregisterAll();
    sendActiveAppProcessIDUpdateDeregisterAll();
}

act_t SdsFocusServiceProxy::sendSdsFocusModeUpdateRegister(SdsFocusModeUpdateCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SdsFocusModeUpdate");
    act_t act = addSignalCallback(ID_SdsFocusModeUpdate, "SdsFocusModeUpdate", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SdsFocusModeUpdate", &cb, act);
    return act;
}

bool SdsFocusServiceProxy::sendSdsFocusModeUpdateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SdsFocusModeUpdate", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SdsFocusModeUpdate", act, static_cast<int>(rv));
    return rv;
}

void SdsFocusServiceProxy::sendSdsFocusModeUpdateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SdsFocusModeUpdate");
    _dbusProxyDelegate->deregisterSignalCallback("SdsFocusModeUpdate", 0, _dbusDaemonProxy.get(), false);
}

act_t SdsFocusServiceProxy::sendActiveAppProcessIDUpdateRegister(ActiveAppProcessIDUpdateCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ActiveAppProcessIDUpdate");
    act_t act = addSignalCallback(ID_ActiveAppProcessIDUpdate, "ActiveAppProcessIDUpdate", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ActiveAppProcessIDUpdate", &cb, act);
    return act;
}

bool SdsFocusServiceProxy::sendActiveAppProcessIDUpdateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ActiveAppProcessIDUpdate", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ActiveAppProcessIDUpdate", act, static_cast<int>(rv));
    return rv;
}

void SdsFocusServiceProxy::sendActiveAppProcessIDUpdateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ActiveAppProcessIDUpdate");
    _dbusProxyDelegate->deregisterSignalCallback("ActiveAppProcessIDUpdate", 0, _dbusDaemonProxy.get(), false);
}

act_t SdsFocusServiceProxy::sendSdsFocusModeRequest(SdsFocusModeCallbackIF& cb, uint32 identifier, SdsFocusModeType sdsFocusModeType) const {
    SdsFocusModeRequest* payload = new SdsFocusModeRequest();
    CHECK_ALLOCATION(payload);
    payload->setIdentifier(identifier);
    payload->setSdsFocusModeType(sdsFocusModeType);
    DBUS_MESSAGE_CALL(dbusMessage, "SdsFocusMode", SdsFocusModeRequest, payload, true)
    act_t act = addMethodCallback(ID_SdsFocusMode, dbusMessage.getUniqueSerial(), "SdsFocusMode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SdsFocusMode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SdsFocusServiceProxy::sendSetActiveAppProcessIDRequest(SetActiveAppProcessIDCallbackIF& cb, uint32 identifier) const {
    SetActiveAppProcessIDRequest* payload = new SetActiveAppProcessIDRequest();
    CHECK_ALLOCATION(payload);
    payload->setIdentifier(identifier);
    DBUS_MESSAGE_CALL(dbusMessage, "SetActiveAppProcessID", SetActiveAppProcessIDRequest, payload, true)
    act_t act = addMethodCallback(ID_SetActiveAppProcessID, dbusMessage.getUniqueSerial(), "SetActiveAppProcessID", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetActiveAppProcessID", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace SdsFocusService
} // namespace sds_gui_fi
