#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_GUI_FI_SDSDATAHANDOVERSERVICE_H
#define SDS_GUI_FI_SDSDATAHANDOVERSERVICE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "sds_gui_fi/SdsDataHandoverServiceConst.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "sds_gui_fi.SdsDataHandoverService" isn't clear, then there should be a description here.
 */

namespace sds_gui_fi {
namespace SdsDataHandoverService {

// method IDs
static const uint16 ID_DataHandover = 0;

// signal IDs

// property IDs
static const uint16 ID_SendHandoverData = 1;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class DataHandoverRequest;

class SendHandoverDataUpdate;

class SendHandoverDataRegister;

// type definitions
/**
 * If the meaning of "DataHandover" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DataHandoverResponse;

/**
 * If the meaning of "DataHandoverError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DataHandoverError;

/**
 * If the meaning of "SendHandoverData" isn't clear, then there should be a description here.
 */
typedef SendHandoverDataUpdate SendHandoverDataSet;

/**
 * If the meaning of "SendHandoverData" isn't clear, then there should be a description here.
 */
typedef SendHandoverDataUpdate SendHandoverDataGet;

/**
 * If the meaning of "SendHandoverDataError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SendHandoverDataError;


/**
 * If the meaning of "DataHandover" isn't clear, then there should be a description here.
 */
class DataHandoverRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DataHandoverRequest ();

    /**
     * Copy constructor
     */
    inline  DataHandoverRequest (const DataHandoverRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DataHandoverRequest (ScreenType screenType_, ScreenState screenState_, const ::std::string& data_);

    /**
     * Destructor
     */
    inline virtual  ~DataHandoverRequest();

    /**
     * Assignment operator
     */
    inline DataHandoverRequest& operator = (const DataHandoverRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DataHandoverRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DataHandoverRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DataHandoverRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DataHandoverRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "screenType"

    static const int kScreenType = 0;

    /**
     * Clears the field "screenType".
     *
     * The field will be set to its default value. The hasScreenType()
     * method will return false.
     */
    inline void clearScreenType();

    /**
     * Checks whether the field "screenType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setScreenType()). Otherwise it will return false.
     */
    inline bool hasScreenType () const;

    /**
     * Returns the value of the member "screenType".
     *
     * If the meaning of "screenType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "screenType"
     */
    inline ScreenType getScreenType () const;

    /**
     * Sets the value of the member "screenType".
     *
     * If the meaning of "screenType" isn't clear, then there should be a description here.
     *
     * @param screenType The value which will be set
     */
    inline void setScreenType (ScreenType screenType_);

    // API of field "screenState"

    static const int kScreenState = 1;

    /**
     * Clears the field "screenState".
     *
     * The field will be set to its default value. The hasScreenState()
     * method will return false.
     */
    inline void clearScreenState();

    /**
     * Checks whether the field "screenState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setScreenState()). Otherwise it will return false.
     */
    inline bool hasScreenState () const;

    /**
     * Returns the value of the member "screenState".
     *
     * If the meaning of "screenState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "screenState"
     */
    inline ScreenState getScreenState () const;

    /**
     * Sets the value of the member "screenState".
     *
     * If the meaning of "screenState" isn't clear, then there should be a description here.
     *
     * @param screenState The value which will be set
     */
    inline void setScreenState (ScreenState screenState_);

    // API of field "data"

    static const int kData = 2;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::std::string& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::string& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::string& data_);

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const char* data_);

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const char* value, size_t size);

    static const DataHandoverRequest &getDefaultInstance();

private:

    inline void set_has_screenType ();

    inline void clear_has_screenType ();

    inline void set_has_screenState ();

    inline void clear_has_screenState ();

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ScreenType _screenType;

    ScreenState _screenState;

    ::std::string _data;

};

/**
 * If the meaning of "SendHandoverData" isn't clear, then there should be a description here.
 */
class SendHandoverDataUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendHandoverDataUpdate ();

    /**
     * Copy constructor
     */
    inline  SendHandoverDataUpdate (const SendHandoverDataUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SendHandoverDataUpdate (bool SendHandoverData_);

    /**
     * Destructor
     */
    inline virtual  ~SendHandoverDataUpdate();

    /**
     * Assignment operator
     */
    inline SendHandoverDataUpdate& operator = (const SendHandoverDataUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendHandoverDataUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendHandoverDataUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendHandoverDataUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendHandoverDataUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SendHandoverData"

    static const int kSendHandoverData = 0;

    /**
     * Clears the field "SendHandoverData".
     *
     * The field will be set to its default value. The hasSendHandoverData()
     * method will return false.
     */
    inline void clearSendHandoverData();

    /**
     * Checks whether the field "SendHandoverData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSendHandoverData()). Otherwise it will return false.
     */
    inline bool hasSendHandoverData () const;

    /**
     * Returns the value of the member "SendHandoverData".
     *
     * If the meaning of "SendHandoverData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SendHandoverData"
     */
    inline bool getSendHandoverData () const;

    /**
     * Sets the value of the member "SendHandoverData".
     *
     * If the meaning of "SendHandoverData" isn't clear, then there should be a description here.
     *
     * @param SendHandoverData The value which will be set
     */
    inline void setSendHandoverData (bool SendHandoverData_);

    static const SendHandoverDataUpdate &getDefaultInstance();

private:

    inline void set_has_SendHandoverData ();

    inline void clear_has_SendHandoverData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _SendHandoverData;

};

/**
 * If the meaning of "SendHandoverData" isn't clear, then there should be a description here.
 */
class SendHandoverDataRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendHandoverDataRegister ();

    /**
     * Copy constructor
     */
    inline  SendHandoverDataRegister (const SendHandoverDataRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SendHandoverDataRegister();

    /**
     * Assignment operator
     */
    inline SendHandoverDataRegister& operator = (const SendHandoverDataRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendHandoverDataRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendHandoverDataRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendHandoverDataRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendHandoverDataRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SendHandoverDataRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  DataHandoverRequest::DataHandoverRequest ()  :
    _screenType (::sds_gui_fi::SdsDataHandoverService::ScreenType__PHONE_DIAL_NUMBER),
    _screenState (::sds_gui_fi::SdsDataHandoverService::ScreenState__ENTRY),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DataHandoverRequest::DataHandoverRequest (const DataHandoverRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _screenType (::sds_gui_fi::SdsDataHandoverService::ScreenType__PHONE_DIAL_NUMBER),
    _screenState (::sds_gui_fi::SdsDataHandoverService::ScreenState__ENTRY),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DataHandoverRequest::DataHandoverRequest (ScreenType screenType_, ScreenState screenState_, const ::std::string& data_)  :
    _screenType (screenType_),
    _screenState (screenState_),
    _data (data_)
{
    #ifndef NDEBUG
    if (!(ScreenType_IsValid(screenType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", screenType_, "ScreenType", "screenType", "DataHandoverRequest");
    }
    #endif
    #ifndef NDEBUG
    if (!(ScreenState_IsValid(screenState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", screenState_, "ScreenState", "screenState", "DataHandoverRequest");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (data_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DataHandoverRequest::~DataHandoverRequest() {
}

inline DataHandoverRequest& DataHandoverRequest::operator = (const DataHandoverRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasScreenType()) {
            setScreenType(rhs.getScreenType());
        } else {
            clearScreenType();
        }
        if (rhs.hasScreenState()) {
            setScreenState(rhs.getScreenState());
        } else {
            clearScreenState();
        }
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool DataHandoverRequest::operator == (const DataHandoverRequest& rhs) const {
    return (((!hasScreenType() && !rhs.hasScreenType()) || getScreenType() == rhs.getScreenType()) &&
        ((!hasScreenState() && !rhs.hasScreenState()) || getScreenState() == rhs.getScreenState()) &&
        ((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool DataHandoverRequest::operator != (const DataHandoverRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DataHandoverRequest::operator < (const DataHandoverRequest& rhs) const {
    if (hasScreenType() || rhs.hasScreenType()) {
        if ((uint32)getScreenType() < (uint32)rhs.getScreenType()) return true;
        if ((uint32)getScreenType() > (uint32)rhs.getScreenType()) return false;
    }
    if (hasScreenState() || rhs.hasScreenState()) {
        if ((uint32)getScreenState() < (uint32)rhs.getScreenState()) return true;
        if ((uint32)getScreenState() > (uint32)rhs.getScreenState()) return false;
    }
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DataHandoverRequest::clone() {
    return new DataHandoverRequest(*this);
}

inline bool DataHandoverRequest::operator > (const DataHandoverRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DataHandoverRequest::clear() {
    clearScreenType();
    clearScreenState();
    clearData();
}

inline void DataHandoverRequest::clearScreenType() {
    if (hasScreenType()) {
         clear_has_screenType();
        _screenType = ::sds_gui_fi::SdsDataHandoverService::ScreenType__PHONE_DIAL_NUMBER;
     }
}

inline bool DataHandoverRequest::hasScreenType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ScreenType DataHandoverRequest::getScreenType () const {
    return _screenType;
}

inline void DataHandoverRequest::setScreenType (ScreenType screenType_) {
    #ifndef NDEBUG
    if (!(ScreenType_IsValid(screenType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", screenType_, "ScreenType", "screenType", "DataHandoverRequest");
    }
    #endif
    set_has_screenType();
    this->_screenType = screenType_;
}

inline void DataHandoverRequest::clearScreenState() {
    if (hasScreenState()) {
         clear_has_screenState();
        _screenState = ::sds_gui_fi::SdsDataHandoverService::ScreenState__ENTRY;
     }
}

inline bool DataHandoverRequest::hasScreenState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ScreenState DataHandoverRequest::getScreenState () const {
    return _screenState;
}

inline void DataHandoverRequest::setScreenState (ScreenState screenState_) {
    #ifndef NDEBUG
    if (!(ScreenState_IsValid(screenState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", screenState_, "ScreenState", "screenState", "DataHandoverRequest");
    }
    #endif
    set_has_screenState();
    this->_screenState = screenState_;
}

inline void DataHandoverRequest::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool DataHandoverRequest::hasData () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& DataHandoverRequest::getData () const {
    return _data;
}

inline ::std::string& DataHandoverRequest::getDataMutable () {
    set_has_data();
    return _data;
}

inline void DataHandoverRequest::setData (const ::std::string& data_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (data_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_data();
    this->_data = data_;
}

inline void DataHandoverRequest::setData (const char* data_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (data_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_data();
    this->_data.assign(data_);
}

inline void DataHandoverRequest::setData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_data();
    this->_data.assign(value, size);
}

inline void DataHandoverRequest::set_has_screenType () {
    _has_bits_[0] |= 1u << 0;
}

inline void DataHandoverRequest::clear_has_screenType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DataHandoverRequest::set_has_screenState () {
    _has_bits_[0] |= 1u << 1;
}

inline void DataHandoverRequest::clear_has_screenState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DataHandoverRequest::set_has_data () {
    _has_bits_[0] |= 1u << 2;
}

inline void DataHandoverRequest::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SendHandoverDataUpdate::SendHandoverDataUpdate ()  :
    _SendHandoverData (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SendHandoverDataUpdate::SendHandoverDataUpdate (const SendHandoverDataUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _SendHandoverData (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SendHandoverDataUpdate::SendHandoverDataUpdate (bool SendHandoverData_)  :
    _SendHandoverData (SendHandoverData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SendHandoverDataUpdate::~SendHandoverDataUpdate() {
}

inline SendHandoverDataUpdate& SendHandoverDataUpdate::operator = (const SendHandoverDataUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSendHandoverData()) {
            setSendHandoverData(rhs.getSendHandoverData());
        } else {
            clearSendHandoverData();
        }
    }
    return *this;
}

inline bool SendHandoverDataUpdate::operator == (const SendHandoverDataUpdate& rhs) const {
    return (((!hasSendHandoverData() && !rhs.hasSendHandoverData()) || getSendHandoverData() == rhs.getSendHandoverData()));
}

inline bool SendHandoverDataUpdate::operator != (const SendHandoverDataUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SendHandoverDataUpdate::operator < (const SendHandoverDataUpdate& rhs) const {
    if (hasSendHandoverData() || rhs.hasSendHandoverData()) {
        if (getSendHandoverData() < rhs.getSendHandoverData()) return true;
        if (getSendHandoverData() > rhs.getSendHandoverData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SendHandoverDataUpdate::clone() {
    return new SendHandoverDataUpdate(*this);
}

inline bool SendHandoverDataUpdate::operator > (const SendHandoverDataUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SendHandoverDataUpdate::clear() {
    clearSendHandoverData();
}

inline void SendHandoverDataUpdate::clearSendHandoverData() {
    if (hasSendHandoverData()) {
         clear_has_SendHandoverData();
        _SendHandoverData = false;
     }
}

inline bool SendHandoverDataUpdate::hasSendHandoverData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SendHandoverDataUpdate::getSendHandoverData () const {
    return _SendHandoverData;
}

inline void SendHandoverDataUpdate::setSendHandoverData (bool SendHandoverData_) {
    set_has_SendHandoverData();
    this->_SendHandoverData = SendHandoverData_;
}

inline void SendHandoverDataUpdate::set_has_SendHandoverData () {
    _has_bits_[0] |= 1u << 0;
}

inline void SendHandoverDataUpdate::clear_has_SendHandoverData () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SendHandoverDataRegister::SendHandoverDataRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SendHandoverDataRegister::SendHandoverDataRegister (const SendHandoverDataRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SendHandoverDataRegister::~SendHandoverDataRegister() {
}

inline SendHandoverDataRegister& SendHandoverDataRegister::operator = (const SendHandoverDataRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SendHandoverDataRegister::operator == (const SendHandoverDataRegister& ) const {
    return true;
}

inline bool SendHandoverDataRegister::operator != (const SendHandoverDataRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SendHandoverDataRegister::operator < (const SendHandoverDataRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SendHandoverDataRegister::clone() {
    return new SendHandoverDataRegister(*this);
}

inline bool SendHandoverDataRegister::operator > (const SendHandoverDataRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SendHandoverDataRegister::clear() {
}

} // namespace SdsDataHandoverService
} // namespace sds_gui_fi

#endif // SDS_GUI_FI_SDSDATAHANDOVERSERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
