/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_GUI_FI_POPUPSERVICESTUB_H
#define SDS_GUI_FI_POPUPSERVICESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "sds_gui_fi/PopUpService.h"
#include "sds_gui_fi/PopUpServiceConst.h"
#include <string>
#include <vector>

namespace sds_gui_fi {
namespace PopUpService {

class PopUpServiceStubDelegate;

class PopUpServiceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the PopUpServiceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    PopUpServiceStub (const std::string& portName);

    /**
     * Create an instance of the PopUpServiceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    PopUpServiceStub (const std::string& portName, const std::string& objectPath);

    virtual ~PopUpServiceStub();

    // signal 'PopupRequestClose'

    /**
     * Raise the signal 'PopupRequestClose' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'PopupRequestClose'</b>:
     *
     * If the meaning of "PopupRequestClose" isn't clear, then there should be a description here.
     */
    void sendPopupRequestCloseSignal();

    // signal 'PopupRequest'

    /**
     * Raise the signal 'PopupRequest' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'PopupRequest'</b>:
     *
     * If the meaning of "PopupRequest" isn't clear, then there should be a description here.
     *
     * @param layout The layout type of the popup.
     *
     * @param header The headline string. Can contain line breaks.
     *
     * @param speechInputState If the meaning of "speechInputState" isn't clear, then there should be a description here.
     *
     * @param textFields If the meaning of "textFields" isn't clear, then there should be a description here.
     *
     * @param pageNumber The current page number of the list in the popup.
     *                                Values start at 0 for the first page.
     *
     * @param numberOfPages The number of pages of the list in the popup.
     *                                Value 0 means that the feature is not used.
     *                                Values starting at 1 indicate a valid number of pages.
     *
     * @param selectableCommandPointerIndex If the meaning of "selectableCommandPointerIndex" isn't clear, then there should be a description here.
     *
     * @param nextPreviousOption If the meaning of "nextPreviousOption" isn't clear, then there should be a description here.
     *
     * @param speakableList If the meaning of "speakableList" isn't clear, then there should be a description here.
     */
    void sendPopupRequestSignal(const ::std::string& layout, const ::std::string& header, SpeechInputState speechInputState, const ::std::vector< TextField >& textFields, uint32 pageNumber, uint32 numberOfPages, uint32 selectableCommandPointerIndex, NextPreviousOption nextPreviousOption, bool speakableList);

    // property 'screenID'

    /**
     * The method onScreenIDGet() is called by ASF when a client invokes the
     * read method for the property 'screenID'. The onScreenIDGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'screenID'</b>:
     *
     * If the meaning of "screenID" isn't clear, then there should be a description here.
     */
    virtual void onScreenIDGet(const ::boost::shared_ptr< ScreenIDGet >& payload);

    /**
     * Sends back the update to a previous onScreenIDGet().
     *
     * <b>Documentation of 'screenID'</b>:
     *
     * If the meaning of "screenID" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onScreenIDGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendScreenIDGetUpdate(const ::std::string& screenID, act_t act = 0);

    /**
     * Set the value of the property 'screenID' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'screenID'</b>:
     *
     * If the meaning of "screenID" isn't clear, then there should be a description here.
     */
    void setScreenID(const ::std::string& screenID);

    /**
     * Returns the current value of the property 'screenID'.
     *
     * <b>Documentation of 'screenID'</b>:
     *
     * If the meaning of "screenID" isn't clear, then there should be a description here.
     */
    const ::std::string& getScreenID() const;

    /**
     * Returns the current value of the property 'screenID' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendScreenIDUpdate() method.
     *
     * <b>Documentation of 'screenID'</b>:
     *
     * If the meaning of "screenID" isn't clear, then there should be a description here.
     */
    ::std::string& getScreenIDMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendScreenIDUpdate().
     *
     * <b>Documentation of 'screenID'</b>:
     *
     * If the meaning of "screenID" isn't clear, then there should be a description here.
     */
    void sendScreenIDUpdate();

    // property 'sdsStatus'

    /**
     * The method onSdsStatusGet() is called by ASF when a client invokes the
     * read method for the property 'sdsStatus'. The onSdsStatusGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'sdsStatus'</b>:
     *
     * If the meaning of "sdsStatus" isn't clear, then there should be a description here.
     */
    virtual void onSdsStatusGet(const ::boost::shared_ptr< SdsStatusGet >& payload);

    /**
     * Sends back the update to a previous onSdsStatusGet().
     *
     * <b>Documentation of 'sdsStatus'</b>:
     *
     * If the meaning of "sdsStatus" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onSdsStatusGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSdsStatusGetUpdate(SpeechInputState sdsStatus, act_t act = 0);

    /**
     * Set the value of the property 'sdsStatus' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'sdsStatus'</b>:
     *
     * If the meaning of "sdsStatus" isn't clear, then there should be a description here.
     */
    void setSdsStatus(SpeechInputState sdsStatus);

    /**
     * Returns the current value of the property 'sdsStatus'.
     *
     * <b>Documentation of 'sdsStatus'</b>:
     *
     * If the meaning of "sdsStatus" isn't clear, then there should be a description here.
     */
    SpeechInputState getSdsStatus() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSdsStatusUpdate().
     *
     * <b>Documentation of 'sdsStatus'</b>:
     *
     * If the meaning of "sdsStatus" isn't clear, then there should be a description here.
     */
    void sendSdsStatusUpdate();

    // property 'microphoneLevel'

    /**
     * The method onMicrophoneLevelGet() is called by ASF when a client
     * invokes the read method for the property 'microphoneLevel'. The
     * onMicrophoneLevelGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'microphoneLevel'</b>:
     *
     * Indicates the strength of the audio input signal.
     *                        The value is interpreted as percentage.
     *                        The value range is 0 .. 100.
     */
    virtual void onMicrophoneLevelGet(const ::boost::shared_ptr< MicrophoneLevelGet >& payload);

    /**
     * Sends back the update to a previous onMicrophoneLevelGet().
     *
     * <b>Documentation of 'microphoneLevel'</b>:
     *
     * Indicates the strength of the audio input signal.
     *                        The value is interpreted as percentage.
     *                        The value range is 0 .. 100.
     *
     * @param act Identifies a previous invocation of onMicrophoneLevelGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendMicrophoneLevelGetUpdate(uint32 microphoneLevel, act_t act = 0);

    /**
     * Set the value of the property 'microphoneLevel' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'microphoneLevel'</b>:
     *
     * Indicates the strength of the audio input signal.
     *                        The value is interpreted as percentage.
     *                        The value range is 0 .. 100.
     */
    void setMicrophoneLevel(uint32 microphoneLevel);

    /**
     * Returns the current value of the property 'microphoneLevel'.
     *
     * <b>Documentation of 'microphoneLevel'</b>:
     *
     * Indicates the strength of the audio input signal.
     *                        The value is interpreted as percentage.
     *                        The value range is 0 .. 100.
     */
    uint32 getMicrophoneLevel() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMicrophoneLevelUpdate().
     *
     * <b>Documentation of 'microphoneLevel'</b>:
     *
     * Indicates the strength of the audio input signal.
     *                        The value is interpreted as percentage.
     *                        The value range is 0 .. 100.
     */
    void sendMicrophoneLevelUpdate();

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    ScreenIDUpdate _screenIDProperty;

    SdsStatusUpdate _sdsStatusProperty;

    MicrophoneLevelUpdate _microphoneLevelProperty;

    friend class PopUpServiceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace PopUpService
} // namespace sds_gui_fi

#endif // SDS_GUI_FI_POPUPSERVICESTUB_H
