#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_GUI_FI_POPUPSERVICE_H
#define SDS_GUI_FI_POPUPSERVICE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "sds_gui_fi/PopUpServiceConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "sds_gui_fi.PopUpService" isn't clear, then there should be a description here.
 */

namespace sds_gui_fi {
namespace PopUpService {

// method IDs

// signal IDs
static const uint16 ID_PopupRequestClose = 0;
static const uint16 ID_PopupRequest = 1;

// property IDs
static const uint16 ID_screenID = 2;
static const uint16 ID_sdsStatus = 3;
static const uint16 ID_microphoneLevel = 4;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class TextField;

class ScreenIDUpdate;

class ScreenIDRegister;

class SdsStatusUpdate;

class SdsStatusRegister;

class MicrophoneLevelUpdate;

class MicrophoneLevelRegister;

class PopupRequestSignal;

// type definitions
/**
 * If the meaning of "screenID" isn't clear, then there should be a description here.
 */
typedef ScreenIDUpdate ScreenIDSet;

/**
 * If the meaning of "screenID" isn't clear, then there should be a description here.
 */
typedef ScreenIDUpdate ScreenIDGet;

/**
 * If the meaning of "ScreenIDError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ScreenIDError;

/**
 * If the meaning of "sdsStatus" isn't clear, then there should be a description here.
 */
typedef SdsStatusUpdate SdsStatusSet;

/**
 * If the meaning of "sdsStatus" isn't clear, then there should be a description here.
 */
typedef SdsStatusUpdate SdsStatusGet;

/**
 * If the meaning of "SdsStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SdsStatusError;

/**
 * Indicates the strength of the audio input signal.
 *                        The value is interpreted as percentage.
 *                        The value range is 0 .. 100.
 */
typedef MicrophoneLevelUpdate MicrophoneLevelSet;

/**
 * Indicates the strength of the audio input signal.
 *                        The value is interpreted as percentage.
 *                        The value range is 0 .. 100.
 */
typedef MicrophoneLevelUpdate MicrophoneLevelGet;

/**
 * If the meaning of "MicrophoneLevelError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MicrophoneLevelError;

/**
 * If the meaning of "PopupRequestClose" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage PopupRequestCloseSignal;

/**
 * If the meaning of "PopupRequestCloseError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PopupRequestCloseError;

/**
 * If the meaning of "PopupRequestError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PopupRequestError;


/**
 * If the meaning of "TextField" isn't clear, then there should be a description here.
 */
class TextField {
public:

    /**
     * Default constructor
     */
    inline  TextField ();

    /**
     * Copy constructor
     */
    inline  TextField (const TextField &rhs);

    /**
     * All fields constructor
     */
    inline  TextField (const ::std::string& tagName_, const ::std::string& string_, TextAttribute attrib_);

    /**
     * Destructor
     */
    inline  ~TextField();

    /**
     * Assignment operator
     */
    inline TextField& operator = (const TextField& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TextField& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TextField& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TextField& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TextField& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tagName"

    static const int kTagName = 0;

    /**
     * Clears the field "tagName".
     *
     * The field will be set to its default value. The hasTagName()
     * method will return false.
     */
    inline void clearTagName();

    /**
     * Checks whether the field "tagName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTagName()). Otherwise it will return false.
     */
    inline bool hasTagName () const;

    /**
     * Returns the value of the member "tagName".
     *
     * If the meaning of "tagName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tagName"
     */
    inline const ::std::string& getTagName () const;

    /**
     * Retrieves the value of the field "tagName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tagName".
     */
    inline ::std::string& getTagNameMutable ();

    /**
     * Sets the value of the member "tagName".
     *
     * If the meaning of "tagName" isn't clear, then there should be a description here.
     *
     * @param tagName The value which will be set
     */
    inline void setTagName (const ::std::string& tagName_);

    /**
     * Sets the value of the member "tagName".
     *
     * If the meaning of "tagName" isn't clear, then there should be a description here.
     *
     * @param tagName The value which will be set
     */
    inline void setTagName (const char* tagName_);

    /**
     * Sets the value of the member "tagName".
     *
     * If the meaning of "tagName" isn't clear, then there should be a description here.
     *
     * @param tagName The value which will be set
     */
    inline void setTagName (const char* value, size_t size);

    // API of field "string"

    static const int kString = 1;

    /**
     * Clears the field "string".
     *
     * The field will be set to its default value. The hasString()
     * method will return false.
     */
    inline void clearString();

    /**
     * Checks whether the field "string" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setString()). Otherwise it will return false.
     */
    inline bool hasString () const;

    /**
     * Returns the value of the member "string".
     *
     * If the meaning of "string" isn't clear, then there should be a description here.
     *
     * @return The value of the field "string"
     */
    inline const ::std::string& getString () const;

    /**
     * Retrieves the value of the field "string" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "string".
     */
    inline ::std::string& getStringMutable ();

    /**
     * Sets the value of the member "string".
     *
     * If the meaning of "string" isn't clear, then there should be a description here.
     *
     * @param string The value which will be set
     */
    inline void setString (const ::std::string& string_);

    /**
     * Sets the value of the member "string".
     *
     * If the meaning of "string" isn't clear, then there should be a description here.
     *
     * @param string The value which will be set
     */
    inline void setString (const char* string_);

    /**
     * Sets the value of the member "string".
     *
     * If the meaning of "string" isn't clear, then there should be a description here.
     *
     * @param string The value which will be set
     */
    inline void setString (const char* value, size_t size);

    // API of field "attrib"

    static const int kAttrib = 2;

    /**
     * Clears the field "attrib".
     *
     * The field will be set to its default value. The hasAttrib()
     * method will return false.
     */
    inline void clearAttrib();

    /**
     * Checks whether the field "attrib" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAttrib()). Otherwise it will return false.
     */
    inline bool hasAttrib () const;

    /**
     * Returns the value of the member "attrib".
     *
     * If the meaning of "attrib" isn't clear, then there should be a description here.
     *
     * @return The value of the field "attrib"
     */
    inline TextAttribute getAttrib () const;

    /**
     * Sets the value of the member "attrib".
     *
     * If the meaning of "attrib" isn't clear, then there should be a description here.
     *
     * @param attrib The value which will be set
     */
    inline void setAttrib (TextAttribute attrib_);

    static const TextField &getDefaultInstance();

private:

    inline void set_has_tagName ();

    inline void clear_has_tagName ();

    inline void set_has_string ();

    inline void clear_has_string ();

    inline void set_has_attrib ();

    inline void clear_has_attrib ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _tagName;

    ::std::string _string;

    TextAttribute _attrib;

};

/**
 * If the meaning of "screenID" isn't clear, then there should be a description here.
 */
class ScreenIDUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ScreenIDUpdate ();

    /**
     * Copy constructor
     */
    inline  ScreenIDUpdate (const ScreenIDUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ScreenIDUpdate (const ::std::string& screenID_);

    /**
     * Destructor
     */
    inline virtual  ~ScreenIDUpdate();

    /**
     * Assignment operator
     */
    inline ScreenIDUpdate& operator = (const ScreenIDUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ScreenIDUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ScreenIDUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ScreenIDUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ScreenIDUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "screenID"

    static const int kScreenID = 0;

    /**
     * Clears the field "screenID".
     *
     * The field will be set to its default value. The hasScreenID()
     * method will return false.
     */
    inline void clearScreenID();

    /**
     * Checks whether the field "screenID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setScreenID()). Otherwise it will return false.
     */
    inline bool hasScreenID () const;

    /**
     * Returns the value of the member "screenID".
     *
     * If the meaning of "screenID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "screenID"
     */
    inline const ::std::string& getScreenID () const;

    /**
     * Retrieves the value of the field "screenID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "screenID".
     */
    inline ::std::string& getScreenIDMutable ();

    /**
     * Sets the value of the member "screenID".
     *
     * If the meaning of "screenID" isn't clear, then there should be a description here.
     *
     * @param screenID The value which will be set
     */
    inline void setScreenID (const ::std::string& screenID_);

    /**
     * Sets the value of the member "screenID".
     *
     * If the meaning of "screenID" isn't clear, then there should be a description here.
     *
     * @param screenID The value which will be set
     */
    inline void setScreenID (const char* screenID_);

    /**
     * Sets the value of the member "screenID".
     *
     * If the meaning of "screenID" isn't clear, then there should be a description here.
     *
     * @param screenID The value which will be set
     */
    inline void setScreenID (const char* value, size_t size);

    static const ScreenIDUpdate &getDefaultInstance();

private:

    inline void set_has_screenID ();

    inline void clear_has_screenID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _screenID;

};

/**
 * If the meaning of "screenID" isn't clear, then there should be a description here.
 */
class ScreenIDRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ScreenIDRegister ();

    /**
     * Copy constructor
     */
    inline  ScreenIDRegister (const ScreenIDRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ScreenIDRegister();

    /**
     * Assignment operator
     */
    inline ScreenIDRegister& operator = (const ScreenIDRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ScreenIDRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ScreenIDRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ScreenIDRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ScreenIDRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ScreenIDRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "sdsStatus" isn't clear, then there should be a description here.
 */
class SdsStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  SdsStatusUpdate (const SdsStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SdsStatusUpdate (SpeechInputState sdsStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SdsStatusUpdate();

    /**
     * Assignment operator
     */
    inline SdsStatusUpdate& operator = (const SdsStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsStatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sdsStatus"

    static const int kSdsStatus = 0;

    /**
     * Clears the field "sdsStatus".
     *
     * The field will be set to its default value. The hasSdsStatus()
     * method will return false.
     */
    inline void clearSdsStatus();

    /**
     * Checks whether the field "sdsStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsStatus()). Otherwise it will return false.
     */
    inline bool hasSdsStatus () const;

    /**
     * Returns the value of the member "sdsStatus".
     *
     * If the meaning of "sdsStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sdsStatus"
     */
    inline SpeechInputState getSdsStatus () const;

    /**
     * Sets the value of the member "sdsStatus".
     *
     * If the meaning of "sdsStatus" isn't clear, then there should be a description here.
     *
     * @param sdsStatus The value which will be set
     */
    inline void setSdsStatus (SpeechInputState sdsStatus_);

    static const SdsStatusUpdate &getDefaultInstance();

private:

    inline void set_has_sdsStatus ();

    inline void clear_has_sdsStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SpeechInputState _sdsStatus;

};

/**
 * If the meaning of "sdsStatus" isn't clear, then there should be a description here.
 */
class SdsStatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsStatusRegister ();

    /**
     * Copy constructor
     */
    inline  SdsStatusRegister (const SdsStatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SdsStatusRegister();

    /**
     * Assignment operator
     */
    inline SdsStatusRegister& operator = (const SdsStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsStatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsStatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsStatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SdsStatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Indicates the strength of the audio input signal.
 *                        The value is interpreted as percentage.
 *                        The value range is 0 .. 100.
 */
class MicrophoneLevelUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MicrophoneLevelUpdate ();

    /**
     * Copy constructor
     */
    inline  MicrophoneLevelUpdate (const MicrophoneLevelUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  MicrophoneLevelUpdate (uint32 microphoneLevel_);

    /**
     * Destructor
     */
    inline virtual  ~MicrophoneLevelUpdate();

    /**
     * Assignment operator
     */
    inline MicrophoneLevelUpdate& operator = (const MicrophoneLevelUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MicrophoneLevelUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MicrophoneLevelUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MicrophoneLevelUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MicrophoneLevelUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "microphoneLevel"

    static const int kMicrophoneLevel = 0;

    /**
     * Clears the field "microphoneLevel".
     *
     * The field will be set to its default value. The hasMicrophoneLevel()
     * method will return false.
     */
    inline void clearMicrophoneLevel();

    /**
     * Checks whether the field "microphoneLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMicrophoneLevel()). Otherwise it will return false.
     */
    inline bool hasMicrophoneLevel () const;

    /**
     * Returns the value of the member "microphoneLevel".
     *
     * Indicates the strength of the audio input signal.
     *                        The value is interpreted as percentage.
     *                        The value range is 0 .. 100.
     *
     * @return The value of the field "microphoneLevel"
     */
    inline uint32 getMicrophoneLevel () const;

    /**
     * Sets the value of the member "microphoneLevel".
     *
     * Indicates the strength of the audio input signal.
     *                        The value is interpreted as percentage.
     *                        The value range is 0 .. 100.
     *
     * @param microphoneLevel The value which will be set
     */
    inline void setMicrophoneLevel (uint32 microphoneLevel_);

    static const MicrophoneLevelUpdate &getDefaultInstance();

private:

    inline void set_has_microphoneLevel ();

    inline void clear_has_microphoneLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _microphoneLevel;

};

/**
 * Indicates the strength of the audio input signal.
 *                        The value is interpreted as percentage.
 *                        The value range is 0 .. 100.
 */
class MicrophoneLevelRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MicrophoneLevelRegister ();

    /**
     * Copy constructor
     */
    inline  MicrophoneLevelRegister (const MicrophoneLevelRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~MicrophoneLevelRegister();

    /**
     * Assignment operator
     */
    inline MicrophoneLevelRegister& operator = (const MicrophoneLevelRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MicrophoneLevelRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MicrophoneLevelRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MicrophoneLevelRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MicrophoneLevelRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const MicrophoneLevelRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "PopupRequest" isn't clear, then there should be a description here.
 */
class PopupRequestSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PopupRequestSignal ();

    /**
     * Copy constructor
     */
    inline  PopupRequestSignal (const PopupRequestSignal &rhs);

    /**
     * All fields constructor
     */
    inline  PopupRequestSignal (const ::std::string& layout_, const ::std::string& header_, SpeechInputState speechInputState_, const ::std::vector< TextField >& textFields_, uint32 pageNumber_, uint32 numberOfPages_, uint32 selectableCommandPointerIndex_, NextPreviousOption nextPreviousOption_, bool speakableList_);

    /**
     * Destructor
     */
    inline virtual  ~PopupRequestSignal();

    /**
     * Assignment operator
     */
    inline PopupRequestSignal& operator = (const PopupRequestSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PopupRequestSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PopupRequestSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PopupRequestSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PopupRequestSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "layout"

    static const int kLayout = 0;

    /**
     * Clears the field "layout".
     *
     * The field will be set to its default value. The hasLayout()
     * method will return false.
     */
    inline void clearLayout();

    /**
     * Checks whether the field "layout" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLayout()). Otherwise it will return false.
     */
    inline bool hasLayout () const;

    /**
     * Returns the value of the member "layout".
     *
     * The layout type of the popup.
     *
     * @return The value of the field "layout"
     */
    inline const ::std::string& getLayout () const;

    /**
     * Retrieves the value of the field "layout" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "layout".
     */
    inline ::std::string& getLayoutMutable ();

    /**
     * Sets the value of the member "layout".
     *
     * The layout type of the popup.
     *
     * @param layout The value which will be set
     */
    inline void setLayout (const ::std::string& layout_);

    /**
     * Sets the value of the member "layout".
     *
     * The layout type of the popup.
     *
     * @param layout The value which will be set
     */
    inline void setLayout (const char* layout_);

    /**
     * Sets the value of the member "layout".
     *
     * The layout type of the popup.
     *
     * @param layout The value which will be set
     */
    inline void setLayout (const char* value, size_t size);

    // API of field "header"

    static const int kHeader = 1;

    /**
     * Clears the field "header".
     *
     * The field will be set to its default value. The hasHeader()
     * method will return false.
     */
    inline void clearHeader();

    /**
     * Checks whether the field "header" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHeader()). Otherwise it will return false.
     */
    inline bool hasHeader () const;

    /**
     * Returns the value of the member "header".
     *
     * The headline string. Can contain line breaks.
     *
     * @return The value of the field "header"
     */
    inline const ::std::string& getHeader () const;

    /**
     * Retrieves the value of the field "header" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "header".
     */
    inline ::std::string& getHeaderMutable ();

    /**
     * Sets the value of the member "header".
     *
     * The headline string. Can contain line breaks.
     *
     * @param header The value which will be set
     */
    inline void setHeader (const ::std::string& header_);

    /**
     * Sets the value of the member "header".
     *
     * The headline string. Can contain line breaks.
     *
     * @param header The value which will be set
     */
    inline void setHeader (const char* header_);

    /**
     * Sets the value of the member "header".
     *
     * The headline string. Can contain line breaks.
     *
     * @param header The value which will be set
     */
    inline void setHeader (const char* value, size_t size);

    // API of field "speechInputState"

    static const int kSpeechInputState = 2;

    /**
     * Clears the field "speechInputState".
     *
     * The field will be set to its default value. The hasSpeechInputState()
     * method will return false.
     */
    inline void clearSpeechInputState();

    /**
     * Checks whether the field "speechInputState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeechInputState()). Otherwise it will return false.
     */
    inline bool hasSpeechInputState () const;

    /**
     * Returns the value of the member "speechInputState".
     *
     * If the meaning of "speechInputState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "speechInputState"
     */
    inline SpeechInputState getSpeechInputState () const;

    /**
     * Sets the value of the member "speechInputState".
     *
     * If the meaning of "speechInputState" isn't clear, then there should be a description here.
     *
     * @param speechInputState The value which will be set
     */
    inline void setSpeechInputState (SpeechInputState speechInputState_);

    // API of field "textFields"

    static const int kTextFields = 3;

    /**
     * Clears the field "textFields".
     *
     * The field will be set to its default value. The hasTextFields()
     * method will return false.
     */
    inline void clearTextFields();

    /**
     * Checks whether the field "textFields" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTextFields()). Otherwise it will return false.
     */
    inline bool hasTextFields () const;

    /**
     * Returns the value of the member "textFields".
     *
     * If the meaning of "textFields" isn't clear, then there should be a description here.
     *
     * @return The value of the field "textFields"
     */
    inline const ::std::vector< TextField >& getTextFields () const;

    /**
     * Retrieves the value of the field "textFields" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "textFields".
     */
    inline ::std::vector< TextField >& getTextFieldsMutable ();

    /**
     * Sets the value of the member "textFields".
     *
     * If the meaning of "textFields" isn't clear, then there should be a description here.
     *
     * @param textFields The value which will be set
     */
    inline void setTextFields (const ::std::vector< TextField >& textFields_);

    // API of field "pageNumber"

    static const int kPageNumber = 4;

    /**
     * Clears the field "pageNumber".
     *
     * The field will be set to its default value. The hasPageNumber()
     * method will return false.
     */
    inline void clearPageNumber();

    /**
     * Checks whether the field "pageNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPageNumber()). Otherwise it will return false.
     */
    inline bool hasPageNumber () const;

    /**
     * Returns the value of the member "pageNumber".
     *
     * The current page number of the list in the popup.
     *                                Values start at 0 for the first page.
     *
     * @return The value of the field "pageNumber"
     */
    inline uint32 getPageNumber () const;

    /**
     * Sets the value of the member "pageNumber".
     *
     * The current page number of the list in the popup.
     *                                Values start at 0 for the first page.
     *
     * @param pageNumber The value which will be set
     */
    inline void setPageNumber (uint32 pageNumber_);

    // API of field "numberOfPages"

    static const int kNumberOfPages = 5;

    /**
     * Clears the field "numberOfPages".
     *
     * The field will be set to its default value. The hasNumberOfPages()
     * method will return false.
     */
    inline void clearNumberOfPages();

    /**
     * Checks whether the field "numberOfPages" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumberOfPages()). Otherwise it will return false.
     */
    inline bool hasNumberOfPages () const;

    /**
     * Returns the value of the member "numberOfPages".
     *
     * The number of pages of the list in the popup.
     *                                Value 0 means that the feature is not used.
     *                                Values starting at 1 indicate a valid number of pages.
     *
     * @return The value of the field "numberOfPages"
     */
    inline uint32 getNumberOfPages () const;

    /**
     * Sets the value of the member "numberOfPages".
     *
     * The number of pages of the list in the popup.
     *                                Value 0 means that the feature is not used.
     *                                Values starting at 1 indicate a valid number of pages.
     *
     * @param numberOfPages The value which will be set
     */
    inline void setNumberOfPages (uint32 numberOfPages_);

    // API of field "selectableCommandPointerIndex"

    static const int kSelectableCommandPointerIndex = 6;

    /**
     * Clears the field "selectableCommandPointerIndex".
     *
     * The field will be set to its default value. The hasSelectableCommandPointerIndex()
     * method will return false.
     */
    inline void clearSelectableCommandPointerIndex();

    /**
     * Checks whether the field "selectableCommandPointerIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSelectableCommandPointerIndex()). Otherwise it will return false.
     */
    inline bool hasSelectableCommandPointerIndex () const;

    /**
     * Returns the value of the member "selectableCommandPointerIndex".
     *
     * If the meaning of "selectableCommandPointerIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "selectableCommandPointerIndex"
     */
    inline uint32 getSelectableCommandPointerIndex () const;

    /**
     * Sets the value of the member "selectableCommandPointerIndex".
     *
     * If the meaning of "selectableCommandPointerIndex" isn't clear, then there should be a description here.
     *
     * @param selectableCommandPointerIndex The value which will be set
     */
    inline void setSelectableCommandPointerIndex (uint32 selectableCommandPointerIndex_);

    // API of field "nextPreviousOption"

    static const int kNextPreviousOption = 7;

    /**
     * Clears the field "nextPreviousOption".
     *
     * The field will be set to its default value. The hasNextPreviousOption()
     * method will return false.
     */
    inline void clearNextPreviousOption();

    /**
     * Checks whether the field "nextPreviousOption" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNextPreviousOption()). Otherwise it will return false.
     */
    inline bool hasNextPreviousOption () const;

    /**
     * Returns the value of the member "nextPreviousOption".
     *
     * If the meaning of "nextPreviousOption" isn't clear, then there should be a description here.
     *
     * @return The value of the field "nextPreviousOption"
     */
    inline NextPreviousOption getNextPreviousOption () const;

    /**
     * Sets the value of the member "nextPreviousOption".
     *
     * If the meaning of "nextPreviousOption" isn't clear, then there should be a description here.
     *
     * @param nextPreviousOption The value which will be set
     */
    inline void setNextPreviousOption (NextPreviousOption nextPreviousOption_);

    // API of field "speakableList"

    static const int kSpeakableList = 8;

    /**
     * Clears the field "speakableList".
     *
     * The field will be set to its default value. The hasSpeakableList()
     * method will return false.
     */
    inline void clearSpeakableList();

    /**
     * Checks whether the field "speakableList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeakableList()). Otherwise it will return false.
     */
    inline bool hasSpeakableList () const;

    /**
     * Returns the value of the member "speakableList".
     *
     * If the meaning of "speakableList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "speakableList"
     */
    inline bool getSpeakableList () const;

    /**
     * Sets the value of the member "speakableList".
     *
     * If the meaning of "speakableList" isn't clear, then there should be a description here.
     *
     * @param speakableList The value which will be set
     */
    inline void setSpeakableList (bool speakableList_);

    static const PopupRequestSignal &getDefaultInstance();

private:

    static const ::std::vector< TextField >& getTextFieldList_DefaultInstance ();

    inline void set_has_layout ();

    inline void clear_has_layout ();

    inline void set_has_header ();

    inline void clear_has_header ();

    inline void set_has_speechInputState ();

    inline void clear_has_speechInputState ();

    inline void set_has_textFields ();

    inline void clear_has_textFields ();

    inline void set_has_pageNumber ();

    inline void clear_has_pageNumber ();

    inline void set_has_numberOfPages ();

    inline void clear_has_numberOfPages ();

    inline void set_has_selectableCommandPointerIndex ();

    inline void clear_has_selectableCommandPointerIndex ();

    inline void set_has_nextPreviousOption ();

    inline void clear_has_nextPreviousOption ();

    inline void set_has_speakableList ();

    inline void clear_has_speakableList ();

    uint32 _has_bits_[ (9 + 31) / 32];

    ::std::string _layout;

    ::std::string _header;

    SpeechInputState _speechInputState;

    ::std::vector< TextField > _textFields;

    uint32 _pageNumber;

    uint32 _numberOfPages;

    uint32 _selectableCommandPointerIndex;

    NextPreviousOption _nextPreviousOption;

    bool _speakableList;

};

inline  TextField::TextField ()  :
    _tagName (),
    _string (),
    _attrib (::sds_gui_fi::PopUpService::TextAttribute__NORMAL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TextField::TextField (const TextField &rhs)  :
    _tagName (),
    _string (),
    _attrib (::sds_gui_fi::PopUpService::TextAttribute__NORMAL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TextField::TextField (const ::std::string& tagName_, const ::std::string& string_, TextAttribute attrib_)  :
    _tagName (tagName_),
    _string (string_),
    _attrib (attrib_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tagName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (string_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(TextAttribute_IsValid(attrib_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", attrib_, "TextAttribute", "attrib", "TextField");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TextField::~TextField() {
}

inline TextField& TextField::operator = (const TextField& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTagName()) {
            setTagName(rhs.getTagName());
        } else {
            clearTagName();
        }
        if (rhs.hasString()) {
            setString(rhs.getString());
        } else {
            clearString();
        }
        if (rhs.hasAttrib()) {
            setAttrib(rhs.getAttrib());
        } else {
            clearAttrib();
        }
    }
    return *this;
}

inline bool TextField::operator == (const TextField& rhs) const {
    return (((!hasTagName() && !rhs.hasTagName()) || getTagName() == rhs.getTagName()) &&
        ((!hasString() && !rhs.hasString()) || getString() == rhs.getString()) &&
        ((!hasAttrib() && !rhs.hasAttrib()) || getAttrib() == rhs.getAttrib()));
}

inline bool TextField::operator != (const TextField& rhs) const {
    return ! (*this == rhs);
}

inline bool TextField::operator < (const TextField& rhs) const {
    if (hasTagName() || rhs.hasTagName()) {
        if (getTagName() < rhs.getTagName()) return true;
        if (getTagName() > rhs.getTagName()) return false;
    }
    if (hasString() || rhs.hasString()) {
        if (getString() < rhs.getString()) return true;
        if (getString() > rhs.getString()) return false;
    }
    if (hasAttrib() || rhs.hasAttrib()) {
        if ((uint32)getAttrib() < (uint32)rhs.getAttrib()) return true;
        if ((uint32)getAttrib() > (uint32)rhs.getAttrib()) return false;
    }
    return false;
}

inline bool TextField::operator > (const TextField& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TextField::clear() {
    clearTagName();
    clearString();
    clearAttrib();
}

inline void TextField::clearTagName() {
    if (hasTagName()) {
         clear_has_tagName();
        _tagName.clear();
     }
}

inline bool TextField::hasTagName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& TextField::getTagName () const {
    return _tagName;
}

inline ::std::string& TextField::getTagNameMutable () {
    set_has_tagName();
    return _tagName;
}

inline void TextField::setTagName (const ::std::string& tagName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tagName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tagName();
    this->_tagName = tagName_;
}

inline void TextField::setTagName (const char* tagName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tagName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tagName();
    this->_tagName.assign(tagName_);
}

inline void TextField::setTagName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tagName();
    this->_tagName.assign(value, size);
}

inline void TextField::clearString() {
    if (hasString()) {
         clear_has_string();
        _string.clear();
     }
}

inline bool TextField::hasString () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& TextField::getString () const {
    return _string;
}

inline ::std::string& TextField::getStringMutable () {
    set_has_string();
    return _string;
}

inline void TextField::setString (const ::std::string& string_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (string_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_string();
    this->_string = string_;
}

inline void TextField::setString (const char* string_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (string_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_string();
    this->_string.assign(string_);
}

inline void TextField::setString (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_string();
    this->_string.assign(value, size);
}

inline void TextField::clearAttrib() {
    if (hasAttrib()) {
         clear_has_attrib();
        _attrib = ::sds_gui_fi::PopUpService::TextAttribute__NORMAL;
     }
}

inline bool TextField::hasAttrib () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline TextAttribute TextField::getAttrib () const {
    return _attrib;
}

inline void TextField::setAttrib (TextAttribute attrib_) {
    #ifndef NDEBUG
    if (!(TextAttribute_IsValid(attrib_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", attrib_, "TextAttribute", "attrib", "TextField");
    }
    #endif
    set_has_attrib();
    this->_attrib = attrib_;
}

inline void TextField::set_has_tagName () {
    _has_bits_[0] |= 1u << 0;
}

inline void TextField::clear_has_tagName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void TextField::set_has_string () {
    _has_bits_[0] |= 1u << 1;
}

inline void TextField::clear_has_string () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void TextField::set_has_attrib () {
    _has_bits_[0] |= 1u << 2;
}

inline void TextField::clear_has_attrib () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  ScreenIDUpdate::ScreenIDUpdate ()  :
    _screenID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ScreenIDUpdate::ScreenIDUpdate (const ScreenIDUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _screenID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ScreenIDUpdate::ScreenIDUpdate (const ::std::string& screenID_)  :
    _screenID (screenID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (screenID_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ScreenIDUpdate::~ScreenIDUpdate() {
}

inline ScreenIDUpdate& ScreenIDUpdate::operator = (const ScreenIDUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasScreenID()) {
            setScreenID(rhs.getScreenID());
        } else {
            clearScreenID();
        }
    }
    return *this;
}

inline bool ScreenIDUpdate::operator == (const ScreenIDUpdate& rhs) const {
    return (((!hasScreenID() && !rhs.hasScreenID()) || getScreenID() == rhs.getScreenID()));
}

inline bool ScreenIDUpdate::operator != (const ScreenIDUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ScreenIDUpdate::operator < (const ScreenIDUpdate& rhs) const {
    if (hasScreenID() || rhs.hasScreenID()) {
        if (getScreenID() < rhs.getScreenID()) return true;
        if (getScreenID() > rhs.getScreenID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ScreenIDUpdate::clone() {
    return new ScreenIDUpdate(*this);
}

inline bool ScreenIDUpdate::operator > (const ScreenIDUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ScreenIDUpdate::clear() {
    clearScreenID();
}

inline void ScreenIDUpdate::clearScreenID() {
    if (hasScreenID()) {
         clear_has_screenID();
        _screenID.clear();
     }
}

inline bool ScreenIDUpdate::hasScreenID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ScreenIDUpdate::getScreenID () const {
    return _screenID;
}

inline ::std::string& ScreenIDUpdate::getScreenIDMutable () {
    set_has_screenID();
    return _screenID;
}

inline void ScreenIDUpdate::setScreenID (const ::std::string& screenID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (screenID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_screenID();
    this->_screenID = screenID_;
}

inline void ScreenIDUpdate::setScreenID (const char* screenID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (screenID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_screenID();
    this->_screenID.assign(screenID_);
}

inline void ScreenIDUpdate::setScreenID (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_screenID();
    this->_screenID.assign(value, size);
}

inline void ScreenIDUpdate::set_has_screenID () {
    _has_bits_[0] |= 1u << 0;
}

inline void ScreenIDUpdate::clear_has_screenID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ScreenIDRegister::ScreenIDRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ScreenIDRegister::ScreenIDRegister (const ScreenIDRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ScreenIDRegister::~ScreenIDRegister() {
}

inline ScreenIDRegister& ScreenIDRegister::operator = (const ScreenIDRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ScreenIDRegister::operator == (const ScreenIDRegister& ) const {
    return true;
}

inline bool ScreenIDRegister::operator != (const ScreenIDRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ScreenIDRegister::operator < (const ScreenIDRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ScreenIDRegister::clone() {
    return new ScreenIDRegister(*this);
}

inline bool ScreenIDRegister::operator > (const ScreenIDRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ScreenIDRegister::clear() {
}

inline  SdsStatusUpdate::SdsStatusUpdate ()  :
    _sdsStatus (::sds_gui_fi::PopUpService::SpeechInputState__UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SdsStatusUpdate::SdsStatusUpdate (const SdsStatusUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _sdsStatus (::sds_gui_fi::PopUpService::SpeechInputState__UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SdsStatusUpdate::SdsStatusUpdate (SpeechInputState sdsStatus_)  :
    _sdsStatus (sdsStatus_)
{
    #ifndef NDEBUG
    if (!(SpeechInputState_IsValid(sdsStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", sdsStatus_, "SpeechInputState", "sdsStatus", "SdsStatusUpdate");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SdsStatusUpdate::~SdsStatusUpdate() {
}

inline SdsStatusUpdate& SdsStatusUpdate::operator = (const SdsStatusUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSdsStatus()) {
            setSdsStatus(rhs.getSdsStatus());
        } else {
            clearSdsStatus();
        }
    }
    return *this;
}

inline bool SdsStatusUpdate::operator == (const SdsStatusUpdate& rhs) const {
    return (((!hasSdsStatus() && !rhs.hasSdsStatus()) || getSdsStatus() == rhs.getSdsStatus()));
}

inline bool SdsStatusUpdate::operator != (const SdsStatusUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SdsStatusUpdate::operator < (const SdsStatusUpdate& rhs) const {
    if (hasSdsStatus() || rhs.hasSdsStatus()) {
        if ((uint32)getSdsStatus() < (uint32)rhs.getSdsStatus()) return true;
        if ((uint32)getSdsStatus() > (uint32)rhs.getSdsStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SdsStatusUpdate::clone() {
    return new SdsStatusUpdate(*this);
}

inline bool SdsStatusUpdate::operator > (const SdsStatusUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SdsStatusUpdate::clear() {
    clearSdsStatus();
}

inline void SdsStatusUpdate::clearSdsStatus() {
    if (hasSdsStatus()) {
         clear_has_sdsStatus();
        _sdsStatus = ::sds_gui_fi::PopUpService::SpeechInputState__UNKNOWN;
     }
}

inline bool SdsStatusUpdate::hasSdsStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline SpeechInputState SdsStatusUpdate::getSdsStatus () const {
    return _sdsStatus;
}

inline void SdsStatusUpdate::setSdsStatus (SpeechInputState sdsStatus_) {
    #ifndef NDEBUG
    if (!(SpeechInputState_IsValid(sdsStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", sdsStatus_, "SpeechInputState", "sdsStatus", "SdsStatusUpdate");
    }
    #endif
    set_has_sdsStatus();
    this->_sdsStatus = sdsStatus_;
}

inline void SdsStatusUpdate::set_has_sdsStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void SdsStatusUpdate::clear_has_sdsStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SdsStatusRegister::SdsStatusRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SdsStatusRegister::SdsStatusRegister (const SdsStatusRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SdsStatusRegister::~SdsStatusRegister() {
}

inline SdsStatusRegister& SdsStatusRegister::operator = (const SdsStatusRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SdsStatusRegister::operator == (const SdsStatusRegister& ) const {
    return true;
}

inline bool SdsStatusRegister::operator != (const SdsStatusRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SdsStatusRegister::operator < (const SdsStatusRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SdsStatusRegister::clone() {
    return new SdsStatusRegister(*this);
}

inline bool SdsStatusRegister::operator > (const SdsStatusRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SdsStatusRegister::clear() {
}

inline  MicrophoneLevelUpdate::MicrophoneLevelUpdate ()  :
    _microphoneLevel (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MicrophoneLevelUpdate::MicrophoneLevelUpdate (const MicrophoneLevelUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _microphoneLevel (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MicrophoneLevelUpdate::MicrophoneLevelUpdate (uint32 microphoneLevel_)  :
    _microphoneLevel (microphoneLevel_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MicrophoneLevelUpdate::~MicrophoneLevelUpdate() {
}

inline MicrophoneLevelUpdate& MicrophoneLevelUpdate::operator = (const MicrophoneLevelUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMicrophoneLevel()) {
            setMicrophoneLevel(rhs.getMicrophoneLevel());
        } else {
            clearMicrophoneLevel();
        }
    }
    return *this;
}

inline bool MicrophoneLevelUpdate::operator == (const MicrophoneLevelUpdate& rhs) const {
    return (((!hasMicrophoneLevel() && !rhs.hasMicrophoneLevel()) || getMicrophoneLevel() == rhs.getMicrophoneLevel()));
}

inline bool MicrophoneLevelUpdate::operator != (const MicrophoneLevelUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool MicrophoneLevelUpdate::operator < (const MicrophoneLevelUpdate& rhs) const {
    if (hasMicrophoneLevel() || rhs.hasMicrophoneLevel()) {
        if (getMicrophoneLevel() < rhs.getMicrophoneLevel()) return true;
        if (getMicrophoneLevel() > rhs.getMicrophoneLevel()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MicrophoneLevelUpdate::clone() {
    return new MicrophoneLevelUpdate(*this);
}

inline bool MicrophoneLevelUpdate::operator > (const MicrophoneLevelUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MicrophoneLevelUpdate::clear() {
    clearMicrophoneLevel();
}

inline void MicrophoneLevelUpdate::clearMicrophoneLevel() {
    if (hasMicrophoneLevel()) {
         clear_has_microphoneLevel();
        _microphoneLevel = 0u;
     }
}

inline bool MicrophoneLevelUpdate::hasMicrophoneLevel () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 MicrophoneLevelUpdate::getMicrophoneLevel () const {
    return _microphoneLevel;
}

inline void MicrophoneLevelUpdate::setMicrophoneLevel (uint32 microphoneLevel_) {
    set_has_microphoneLevel();
    this->_microphoneLevel = microphoneLevel_;
}

inline void MicrophoneLevelUpdate::set_has_microphoneLevel () {
    _has_bits_[0] |= 1u << 0;
}

inline void MicrophoneLevelUpdate::clear_has_microphoneLevel () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MicrophoneLevelRegister::MicrophoneLevelRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MicrophoneLevelRegister::MicrophoneLevelRegister (const MicrophoneLevelRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MicrophoneLevelRegister::~MicrophoneLevelRegister() {
}

inline MicrophoneLevelRegister& MicrophoneLevelRegister::operator = (const MicrophoneLevelRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool MicrophoneLevelRegister::operator == (const MicrophoneLevelRegister& ) const {
    return true;
}

inline bool MicrophoneLevelRegister::operator != (const MicrophoneLevelRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool MicrophoneLevelRegister::operator < (const MicrophoneLevelRegister& ) const {
    return false;
}

inline ::asf::core::Payload* MicrophoneLevelRegister::clone() {
    return new MicrophoneLevelRegister(*this);
}

inline bool MicrophoneLevelRegister::operator > (const MicrophoneLevelRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MicrophoneLevelRegister::clear() {
}

inline  PopupRequestSignal::PopupRequestSignal ()  :
    _layout (),
    _header (),
    _speechInputState (::sds_gui_fi::PopUpService::SpeechInputState__UNKNOWN),
    _textFields (),
    _pageNumber (0u),
    _numberOfPages (0u),
    _selectableCommandPointerIndex (0u),
    _nextPreviousOption (::sds_gui_fi::PopUpService::NextPreviousOption__SINGLE_PAGE),
    _speakableList (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PopupRequestSignal::PopupRequestSignal (const PopupRequestSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _layout (),
    _header (),
    _speechInputState (::sds_gui_fi::PopUpService::SpeechInputState__UNKNOWN),
    _textFields (),
    _pageNumber (0u),
    _numberOfPages (0u),
    _selectableCommandPointerIndex (0u),
    _nextPreviousOption (::sds_gui_fi::PopUpService::NextPreviousOption__SINGLE_PAGE),
    _speakableList (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PopupRequestSignal::PopupRequestSignal (const ::std::string& layout_, const ::std::string& header_, SpeechInputState speechInputState_, const ::std::vector< TextField >& textFields_, uint32 pageNumber_, uint32 numberOfPages_, uint32 selectableCommandPointerIndex_, NextPreviousOption nextPreviousOption_, bool speakableList_)  :
    _layout (layout_),
    _header (header_),
    _speechInputState (speechInputState_),
    _textFields (textFields_),
    _pageNumber (pageNumber_),
    _numberOfPages (numberOfPages_),
    _selectableCommandPointerIndex (selectableCommandPointerIndex_),
    _nextPreviousOption (nextPreviousOption_),
    _speakableList (speakableList_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (layout_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (header_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(SpeechInputState_IsValid(speechInputState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", speechInputState_, "SpeechInputState", "speechInputState", "PopupRequestSignal");
    }
    #endif
    #ifndef NDEBUG
    if (!(NextPreviousOption_IsValid(nextPreviousOption_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", nextPreviousOption_, "NextPreviousOption", "nextPreviousOption", "PopupRequestSignal");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PopupRequestSignal::~PopupRequestSignal() {
}

inline PopupRequestSignal& PopupRequestSignal::operator = (const PopupRequestSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasLayout()) {
            setLayout(rhs.getLayout());
        } else {
            clearLayout();
        }
        if (rhs.hasHeader()) {
            setHeader(rhs.getHeader());
        } else {
            clearHeader();
        }
        if (rhs.hasSpeechInputState()) {
            setSpeechInputState(rhs.getSpeechInputState());
        } else {
            clearSpeechInputState();
        }
        if (rhs.hasTextFields()) {
            setTextFields(rhs.getTextFields());
        } else {
            clearTextFields();
        }
        if (rhs.hasPageNumber()) {
            setPageNumber(rhs.getPageNumber());
        } else {
            clearPageNumber();
        }
        if (rhs.hasNumberOfPages()) {
            setNumberOfPages(rhs.getNumberOfPages());
        } else {
            clearNumberOfPages();
        }
        if (rhs.hasSelectableCommandPointerIndex()) {
            setSelectableCommandPointerIndex(rhs.getSelectableCommandPointerIndex());
        } else {
            clearSelectableCommandPointerIndex();
        }
        if (rhs.hasNextPreviousOption()) {
            setNextPreviousOption(rhs.getNextPreviousOption());
        } else {
            clearNextPreviousOption();
        }
        if (rhs.hasSpeakableList()) {
            setSpeakableList(rhs.getSpeakableList());
        } else {
            clearSpeakableList();
        }
    }
    return *this;
}

inline bool PopupRequestSignal::operator == (const PopupRequestSignal& rhs) const {
    return (((!hasLayout() && !rhs.hasLayout()) || getLayout() == rhs.getLayout()) &&
        ((!hasHeader() && !rhs.hasHeader()) || getHeader() == rhs.getHeader()) &&
        ((!hasSpeechInputState() && !rhs.hasSpeechInputState()) || getSpeechInputState() == rhs.getSpeechInputState()) &&
        ((!hasTextFields() && !rhs.hasTextFields()) || getTextFields() == rhs.getTextFields()) &&
        ((!hasPageNumber() && !rhs.hasPageNumber()) || getPageNumber() == rhs.getPageNumber()) &&
        ((!hasNumberOfPages() && !rhs.hasNumberOfPages()) || getNumberOfPages() == rhs.getNumberOfPages()) &&
        ((!hasSelectableCommandPointerIndex() && !rhs.hasSelectableCommandPointerIndex()) || getSelectableCommandPointerIndex() == rhs.getSelectableCommandPointerIndex()) &&
        ((!hasNextPreviousOption() && !rhs.hasNextPreviousOption()) || getNextPreviousOption() == rhs.getNextPreviousOption()) &&
        ((!hasSpeakableList() && !rhs.hasSpeakableList()) || getSpeakableList() == rhs.getSpeakableList()));
}

inline bool PopupRequestSignal::operator != (const PopupRequestSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool PopupRequestSignal::operator < (const PopupRequestSignal& rhs) const {
    if (hasLayout() || rhs.hasLayout()) {
        if (getLayout() < rhs.getLayout()) return true;
        if (getLayout() > rhs.getLayout()) return false;
    }
    if (hasHeader() || rhs.hasHeader()) {
        if (getHeader() < rhs.getHeader()) return true;
        if (getHeader() > rhs.getHeader()) return false;
    }
    if (hasSpeechInputState() || rhs.hasSpeechInputState()) {
        if ((uint32)getSpeechInputState() < (uint32)rhs.getSpeechInputState()) return true;
        if ((uint32)getSpeechInputState() > (uint32)rhs.getSpeechInputState()) return false;
    }
    if (hasTextFields() || rhs.hasTextFields()) {
        if (getTextFields() < rhs.getTextFields()) return true;
        if (getTextFields() > rhs.getTextFields()) return false;
    }
    if (hasPageNumber() || rhs.hasPageNumber()) {
        if (getPageNumber() < rhs.getPageNumber()) return true;
        if (getPageNumber() > rhs.getPageNumber()) return false;
    }
    if (hasNumberOfPages() || rhs.hasNumberOfPages()) {
        if (getNumberOfPages() < rhs.getNumberOfPages()) return true;
        if (getNumberOfPages() > rhs.getNumberOfPages()) return false;
    }
    if (hasSelectableCommandPointerIndex() || rhs.hasSelectableCommandPointerIndex()) {
        if (getSelectableCommandPointerIndex() < rhs.getSelectableCommandPointerIndex()) return true;
        if (getSelectableCommandPointerIndex() > rhs.getSelectableCommandPointerIndex()) return false;
    }
    if (hasNextPreviousOption() || rhs.hasNextPreviousOption()) {
        if ((uint32)getNextPreviousOption() < (uint32)rhs.getNextPreviousOption()) return true;
        if ((uint32)getNextPreviousOption() > (uint32)rhs.getNextPreviousOption()) return false;
    }
    if (hasSpeakableList() || rhs.hasSpeakableList()) {
        if (getSpeakableList() < rhs.getSpeakableList()) return true;
        if (getSpeakableList() > rhs.getSpeakableList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PopupRequestSignal::clone() {
    return new PopupRequestSignal(*this);
}

inline bool PopupRequestSignal::operator > (const PopupRequestSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PopupRequestSignal::clear() {
    clearLayout();
    clearHeader();
    clearSpeechInputState();
    clearTextFields();
    clearPageNumber();
    clearNumberOfPages();
    clearSelectableCommandPointerIndex();
    clearNextPreviousOption();
    clearSpeakableList();
}

inline void PopupRequestSignal::clearLayout() {
    if (hasLayout()) {
         clear_has_layout();
        _layout.clear();
     }
}

inline bool PopupRequestSignal::hasLayout () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PopupRequestSignal::getLayout () const {
    return _layout;
}

inline ::std::string& PopupRequestSignal::getLayoutMutable () {
    set_has_layout();
    return _layout;
}

inline void PopupRequestSignal::setLayout (const ::std::string& layout_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (layout_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_layout();
    this->_layout = layout_;
}

inline void PopupRequestSignal::setLayout (const char* layout_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (layout_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_layout();
    this->_layout.assign(layout_);
}

inline void PopupRequestSignal::setLayout (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_layout();
    this->_layout.assign(value, size);
}

inline void PopupRequestSignal::clearHeader() {
    if (hasHeader()) {
         clear_has_header();
        _header.clear();
     }
}

inline bool PopupRequestSignal::hasHeader () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& PopupRequestSignal::getHeader () const {
    return _header;
}

inline ::std::string& PopupRequestSignal::getHeaderMutable () {
    set_has_header();
    return _header;
}

inline void PopupRequestSignal::setHeader (const ::std::string& header_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (header_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_header();
    this->_header = header_;
}

inline void PopupRequestSignal::setHeader (const char* header_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (header_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_header();
    this->_header.assign(header_);
}

inline void PopupRequestSignal::setHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_header();
    this->_header.assign(value, size);
}

inline void PopupRequestSignal::clearSpeechInputState() {
    if (hasSpeechInputState()) {
         clear_has_speechInputState();
        _speechInputState = ::sds_gui_fi::PopUpService::SpeechInputState__UNKNOWN;
     }
}

inline bool PopupRequestSignal::hasSpeechInputState () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline SpeechInputState PopupRequestSignal::getSpeechInputState () const {
    return _speechInputState;
}

inline void PopupRequestSignal::setSpeechInputState (SpeechInputState speechInputState_) {
    #ifndef NDEBUG
    if (!(SpeechInputState_IsValid(speechInputState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", speechInputState_, "SpeechInputState", "speechInputState", "PopupRequestSignal");
    }
    #endif
    set_has_speechInputState();
    this->_speechInputState = speechInputState_;
}

inline void PopupRequestSignal::clearTextFields() {
    if (hasTextFields()) {
         clear_has_textFields();
        _textFields.clear();
     }
}

inline bool PopupRequestSignal::hasTextFields () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< TextField >& PopupRequestSignal::getTextFields () const {
    return _textFields;
}

inline ::std::vector< TextField >& PopupRequestSignal::getTextFieldsMutable () {
    set_has_textFields();
    return _textFields;
}

inline void PopupRequestSignal::setTextFields (const ::std::vector< TextField >& textFields_) {
    set_has_textFields();
    this->_textFields = textFields_;
}

inline void PopupRequestSignal::clearPageNumber() {
    if (hasPageNumber()) {
         clear_has_pageNumber();
        _pageNumber = 0u;
     }
}

inline bool PopupRequestSignal::hasPageNumber () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 PopupRequestSignal::getPageNumber () const {
    return _pageNumber;
}

inline void PopupRequestSignal::setPageNumber (uint32 pageNumber_) {
    set_has_pageNumber();
    this->_pageNumber = pageNumber_;
}

inline void PopupRequestSignal::clearNumberOfPages() {
    if (hasNumberOfPages()) {
         clear_has_numberOfPages();
        _numberOfPages = 0u;
     }
}

inline bool PopupRequestSignal::hasNumberOfPages () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 PopupRequestSignal::getNumberOfPages () const {
    return _numberOfPages;
}

inline void PopupRequestSignal::setNumberOfPages (uint32 numberOfPages_) {
    set_has_numberOfPages();
    this->_numberOfPages = numberOfPages_;
}

inline void PopupRequestSignal::clearSelectableCommandPointerIndex() {
    if (hasSelectableCommandPointerIndex()) {
         clear_has_selectableCommandPointerIndex();
        _selectableCommandPointerIndex = 0u;
     }
}

inline bool PopupRequestSignal::hasSelectableCommandPointerIndex () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint32 PopupRequestSignal::getSelectableCommandPointerIndex () const {
    return _selectableCommandPointerIndex;
}

inline void PopupRequestSignal::setSelectableCommandPointerIndex (uint32 selectableCommandPointerIndex_) {
    set_has_selectableCommandPointerIndex();
    this->_selectableCommandPointerIndex = selectableCommandPointerIndex_;
}

inline void PopupRequestSignal::clearNextPreviousOption() {
    if (hasNextPreviousOption()) {
         clear_has_nextPreviousOption();
        _nextPreviousOption = ::sds_gui_fi::PopUpService::NextPreviousOption__SINGLE_PAGE;
     }
}

inline bool PopupRequestSignal::hasNextPreviousOption () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline NextPreviousOption PopupRequestSignal::getNextPreviousOption () const {
    return _nextPreviousOption;
}

inline void PopupRequestSignal::setNextPreviousOption (NextPreviousOption nextPreviousOption_) {
    #ifndef NDEBUG
    if (!(NextPreviousOption_IsValid(nextPreviousOption_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", nextPreviousOption_, "NextPreviousOption", "nextPreviousOption", "PopupRequestSignal");
    }
    #endif
    set_has_nextPreviousOption();
    this->_nextPreviousOption = nextPreviousOption_;
}

inline void PopupRequestSignal::clearSpeakableList() {
    if (hasSpeakableList()) {
         clear_has_speakableList();
        _speakableList = false;
     }
}

inline bool PopupRequestSignal::hasSpeakableList () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline bool PopupRequestSignal::getSpeakableList () const {
    return _speakableList;
}

inline void PopupRequestSignal::setSpeakableList (bool speakableList_) {
    set_has_speakableList();
    this->_speakableList = speakableList_;
}

inline void PopupRequestSignal::set_has_layout () {
    _has_bits_[0] |= 1u << 0;
}

inline void PopupRequestSignal::clear_has_layout () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PopupRequestSignal::set_has_header () {
    _has_bits_[0] |= 1u << 1;
}

inline void PopupRequestSignal::clear_has_header () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void PopupRequestSignal::set_has_speechInputState () {
    _has_bits_[0] |= 1u << 2;
}

inline void PopupRequestSignal::clear_has_speechInputState () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void PopupRequestSignal::set_has_textFields () {
    _has_bits_[0] |= 1u << 3;
}

inline void PopupRequestSignal::clear_has_textFields () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void PopupRequestSignal::set_has_pageNumber () {
    _has_bits_[0] |= 1u << 4;
}

inline void PopupRequestSignal::clear_has_pageNumber () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void PopupRequestSignal::set_has_numberOfPages () {
    _has_bits_[0] |= 1u << 5;
}

inline void PopupRequestSignal::clear_has_numberOfPages () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void PopupRequestSignal::set_has_selectableCommandPointerIndex () {
    _has_bits_[0] |= 1u << 6;
}

inline void PopupRequestSignal::clear_has_selectableCommandPointerIndex () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void PopupRequestSignal::set_has_nextPreviousOption () {
    _has_bits_[0] |= 1u << 7;
}

inline void PopupRequestSignal::clear_has_nextPreviousOption () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void PopupRequestSignal::set_has_speakableList () {
    _has_bits_[0] |= 1u << 8;
}

inline void PopupRequestSignal::clear_has_speakableList () {
    _has_bits_[0] &= ~ (1u << 8);
}

} // namespace PopUpService
} // namespace sds_gui_fi

#endif // SDS_GUI_FI_POPUPSERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
