/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "sds_fm_fi/SdsFmService.h"
#include "sds_fm_fi/SdsFmServiceDBus.h"
#include "sds_fm_fi/SdsFmServiceJson.h"
#include "sds_fm_fi/SdsFmServiceProxy.h"
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace sds_fm_fi {
namespace SdsFmService {

DEFINE_CLASS_LOGGER("/sds_fm_fi/sds_fm_fi/SdsFmService", SdsFmServiceProxy);

class SdsFmServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    SdsFmServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< SdsFmServiceProxy >& proxyShared = ::boost::static_pointer_cast< SdsFmServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_ProcessingFinished:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProcessingFinishedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProcessingFinished", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ProcessingFinishedSignal> payload = ::boost::static_pointer_cast<ProcessingFinishedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ProcessingFinishedCallbackIF*) _callback)->onProcessingFinishedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_ProcessingInterrupted:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProcessingInterruptedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProcessingInterrupted", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ProcessingInterruptedSignal> payload = ::boost::static_pointer_cast<ProcessingInterruptedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ProcessingInterruptedCallbackIF*) _callback)->onProcessingInterruptedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_storeRDSChannelNames:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StoreRDSChannelNamesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StoreRDSChannelNames", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StoreRDSChannelNamesError> payload = ::boost::static_pointer_cast<StoreRDSChannelNamesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StoreRDSChannelNamesCallbackIF*) _callback)->onStoreRDSChannelNamesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StoreRDSChannelNamesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StoreRDSChannelNames", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StoreRDSChannelNamesResponse> payload = ::boost::static_pointer_cast<StoreRDSChannelNamesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StoreRDSChannelNamesCallbackIF*) _callback)->onStoreRDSChannelNamesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_storeHDChannelNames:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StoreHDChannelNamesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StoreHDChannelNames", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StoreHDChannelNamesError> payload = ::boost::static_pointer_cast<StoreHDChannelNamesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StoreHDChannelNamesCallbackIF*) _callback)->onStoreHDChannelNamesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StoreHDChannelNamesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StoreHDChannelNames", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StoreHDChannelNamesResponse> payload = ::boost::static_pointer_cast<StoreHDChannelNamesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StoreHDChannelNamesCallbackIF*) _callback)->onStoreHDChannelNamesResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_ProcessingFinished: {
                ::boost::shared_ptr< ProcessingFinishedError > payload = ::boost::shared_ptr< ProcessingFinishedError >
                (new ProcessingFinishedError(DBUS_ERROR_NO_SERVER, "The DBus service SdsFmService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ProcessingFinished", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsFmServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsFmServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProcessingFinishedCallbackIF*) _callback)->onProcessingFinishedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ProcessingInterrupted: {
                ::boost::shared_ptr< ProcessingInterruptedError > payload = ::boost::shared_ptr< ProcessingInterruptedError >
                (new ProcessingInterruptedError(DBUS_ERROR_NO_SERVER, "The DBus service SdsFmService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ProcessingInterrupted", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsFmServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsFmServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProcessingInterruptedCallbackIF*) _callback)->onProcessingInterruptedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_storeRDSChannelNames: {
                ::boost::shared_ptr< StoreRDSChannelNamesError > payload = ::boost::shared_ptr< StoreRDSChannelNamesError >
                (new StoreRDSChannelNamesError(DBUS_ERROR_NO_SERVER, "The DBus service SdsFmService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StoreRDSChannelNames", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsFmServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsFmServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StoreRDSChannelNamesCallbackIF*) _callback)->onStoreRDSChannelNamesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_storeHDChannelNames: {
                ::boost::shared_ptr< StoreHDChannelNamesError > payload = ::boost::shared_ptr< StoreHDChannelNamesError >
                (new StoreHDChannelNamesError(DBUS_ERROR_NO_SERVER, "The DBus service SdsFmService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StoreHDChannelNames", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsFmServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsFmServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StoreHDChannelNamesCallbackIF*) _callback)->onStoreHDChannelNamesError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& SdsFmServiceProxyCallback::_logger (SdsFmServiceProxy::_logger);

SdsFmServiceProxy::SdsFmServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "sds_fm_fi.SdsFmService", serviceAvailable, _logger) {
}

SdsFmServiceProxy::~SdsFmServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< SdsFmServiceProxy > SdsFmServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<SdsFmServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< SdsFmServiceProxy > proxyNew(new SdsFmServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t SdsFmServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    SdsFmServiceProxyCallback* callback = new SdsFmServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t SdsFmServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    SdsFmServiceProxyCallback* callback = new SdsFmServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void SdsFmServiceProxy::sendDeregisterAll () const
{
    sendProcessingFinishedDeregisterAll();
    sendProcessingInterruptedDeregisterAll();
}

act_t SdsFmServiceProxy::sendProcessingFinishedRegister(ProcessingFinishedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ProcessingFinished");
    act_t act = addSignalCallback(ID_ProcessingFinished, "ProcessingFinished", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ProcessingFinished", &cb, act);
    return act;
}

bool SdsFmServiceProxy::sendProcessingFinishedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ProcessingFinished", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ProcessingFinished", act, static_cast<int>(rv));
    return rv;
}

void SdsFmServiceProxy::sendProcessingFinishedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ProcessingFinished");
    _dbusProxyDelegate->deregisterSignalCallback("ProcessingFinished", 0, _dbusDaemonProxy.get(), false);
}

act_t SdsFmServiceProxy::sendProcessingInterruptedRegister(ProcessingInterruptedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ProcessingInterrupted");
    act_t act = addSignalCallback(ID_ProcessingInterrupted, "ProcessingInterrupted", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ProcessingInterrupted", &cb, act);
    return act;
}

bool SdsFmServiceProxy::sendProcessingInterruptedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ProcessingInterrupted", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ProcessingInterrupted", act, static_cast<int>(rv));
    return rv;
}

void SdsFmServiceProxy::sendProcessingInterruptedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ProcessingInterrupted");
    _dbusProxyDelegate->deregisterSignalCallback("ProcessingInterrupted", 0, _dbusDaemonProxy.get(), false);
}

act_t SdsFmServiceProxy::sendStoreRDSChannelNamesRequest(StoreRDSChannelNamesCallbackIF& cb, const ::std::vector< FMChannelItem >& channelList) const {
    StoreRDSChannelNamesRequest* payload = new StoreRDSChannelNamesRequest();
    CHECK_ALLOCATION(payload);
    payload->setChannelList(channelList);
    DBUS_MESSAGE_CALL(dbusMessage, "storeRDSChannelNames", StoreRDSChannelNamesRequest, payload, true)
    act_t act = addMethodCallback(ID_storeRDSChannelNames, dbusMessage.getUniqueSerial(), "storeRDSChannelNames", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StoreRDSChannelNames", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SdsFmServiceProxy::sendStoreHDChannelNamesRequest(StoreHDChannelNamesCallbackIF& cb, const ::std::vector< FMChannelItem >& channelList) const {
    StoreHDChannelNamesRequest* payload = new StoreHDChannelNamesRequest();
    CHECK_ALLOCATION(payload);
    payload->setChannelList(channelList);
    DBUS_MESSAGE_CALL(dbusMessage, "storeHDChannelNames", StoreHDChannelNamesRequest, payload, true)
    act_t act = addMethodCallback(ID_storeHDChannelNames, dbusMessage.getUniqueSerial(), "storeHDChannelNames", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StoreHDChannelNames", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace SdsFmService
} // namespace sds_fm_fi
