/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "sds_dab_fi/SdsDabService.h"
#include "sds_dab_fi/SdsDabServiceJson.h"
#include "sds_dab_fi/SdsDabServiceJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "DABChannelItem"

void serializeJson (const ::sds_dab_fi::SdsDabService::DABChannelItem& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDabID()) {
        yajl_gen_string(g, (const unsigned char*)  "DabID" , 5);
        yajl_gen_integer(g, (long long)value.getDabID());
    }
    if (!isSparse || value.hasSecComponentID()) {
        yajl_gen_string(g, (const unsigned char*)  "SecComponentID" , 14);
        yajl_gen_integer(g, (long long)value.getSecComponentID());
    }
    if (!isSparse || value.hasListElementID()) {
        yajl_gen_string(g, (const unsigned char*)  "ListElementID" , 13);
        yajl_gen_integer(g, (long long)value.getListElementID());
    }
    if (!isSparse || value.hasServiceLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "ServiceLabel" , 12);
        const char *s = value.getServiceLabel().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasEnsembleLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "EnsembleLabel" , 13);
        const char *s = value.getEnsembleLabel().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_dab_fi::SdsDabService::DABChannelItem& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StoreDabChannelNamesRequest"

void serializeJson (const ::sds_dab_fi::SdsDabService::StoreDabChannelNamesRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChannelList()) {
        yajl_gen_string(g, (const unsigned char*)  "channelList" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::sds_dab_fi::SdsDabService::DABChannelItem >& o1 = value.getChannelList();
        {
            ::std::vector< ::sds_dab_fi::SdsDabService::DABChannelItem >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_dab_fi::SdsDabService::StoreDabChannelNamesRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace sds_dab_fi {
namespace SdsDabService {

std::ostream& operator<<(std::ostream& o, const ::sds_dab_fi::SdsDabService::DABChannelItem& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SdsDabService
} // namespace sds_dab_fi
using namespace ::asf::stream::json;

namespace sds_dab_fi {
namespace SdsDabService {

std::ostream& operator<<(std::ostream& o, const ::sds_dab_fi::SdsDabService::StoreDabChannelNamesRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SdsDabService
} // namespace sds_dab_fi

