#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SDS_DAB_FI_SDSDABSERVICE_H
#define SDS_DAB_FI_SDSDABSERVICE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "sds_dab_fi.SdsDabService" isn't clear, then there should be a description here.
 */

namespace sds_dab_fi {
namespace SdsDabService {

// method IDs
static const uint16 ID_storeDabChannelNames = 0;

// signal IDs
static const uint16 ID_ProcessingFinished = 1;
static const uint16 ID_ProcessingInterrupted = 2;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class DABChannelItem;

class StoreDabChannelNamesRequest;

// type definitions
/**
 * If the meaning of "storeDabChannelNames" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StoreDabChannelNamesResponse;

/**
 * If the meaning of "StoreDabChannelNamesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StoreDabChannelNamesError;

/**
 * If the meaning of "ProcessingFinished" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ProcessingFinishedSignal;

/**
 * If the meaning of "ProcessingFinishedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProcessingFinishedError;

/**
 * If the meaning of "ProcessingInterrupted" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ProcessingInterruptedSignal;

/**
 * If the meaning of "ProcessingInterruptedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProcessingInterruptedError;


/**
 * If the meaning of "DABChannelItem" isn't clear, then there should be a description here.
 */
class DABChannelItem {
public:

    /**
     * Default constructor
     */
    inline  DABChannelItem ();

    /**
     * Copy constructor
     */
    inline  DABChannelItem (const DABChannelItem &rhs);

    /**
     * All fields constructor
     */
    inline  DABChannelItem (uint32 DabID_, uint8 SecComponentID_, uint16 ListElementID_, const ::std::string& ServiceLabel_, const ::std::string& EnsembleLabel_);

    /**
     * Destructor
     */
    inline  ~DABChannelItem();

    /**
     * Assignment operator
     */
    inline DABChannelItem& operator = (const DABChannelItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DABChannelItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DABChannelItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DABChannelItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DABChannelItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DabID"

    static const int kDabID = 0;

    /**
     * Clears the field "DabID".
     *
     * The field will be set to its default value. The hasDabID()
     * method will return false.
     */
    inline void clearDabID();

    /**
     * Checks whether the field "DabID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDabID()). Otherwise it will return false.
     */
    inline bool hasDabID () const;

    /**
     * Returns the value of the member "DabID".
     *
     * If the meaning of "DabID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DabID"
     */
    inline uint32 getDabID () const;

    /**
     * Sets the value of the member "DabID".
     *
     * If the meaning of "DabID" isn't clear, then there should be a description here.
     *
     * @param DabID The value which will be set
     */
    inline void setDabID (uint32 DabID_);

    // API of field "SecComponentID"

    static const int kSecComponentID = 1;

    /**
     * Clears the field "SecComponentID".
     *
     * The field will be set to its default value. The hasSecComponentID()
     * method will return false.
     */
    inline void clearSecComponentID();

    /**
     * Checks whether the field "SecComponentID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSecComponentID()). Otherwise it will return false.
     */
    inline bool hasSecComponentID () const;

    /**
     * Returns the value of the member "SecComponentID".
     *
     * If the meaning of "SecComponentID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SecComponentID"
     */
    inline uint8 getSecComponentID () const;

    /**
     * Sets the value of the member "SecComponentID".
     *
     * If the meaning of "SecComponentID" isn't clear, then there should be a description here.
     *
     * @param SecComponentID The value which will be set
     */
    inline void setSecComponentID (uint8 SecComponentID_);

    // API of field "ListElementID"

    static const int kListElementID = 2;

    /**
     * Clears the field "ListElementID".
     *
     * The field will be set to its default value. The hasListElementID()
     * method will return false.
     */
    inline void clearListElementID();

    /**
     * Checks whether the field "ListElementID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListElementID()). Otherwise it will return false.
     */
    inline bool hasListElementID () const;

    /**
     * Returns the value of the member "ListElementID".
     *
     * If the meaning of "ListElementID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ListElementID"
     */
    inline uint16 getListElementID () const;

    /**
     * Sets the value of the member "ListElementID".
     *
     * If the meaning of "ListElementID" isn't clear, then there should be a description here.
     *
     * @param ListElementID The value which will be set
     */
    inline void setListElementID (uint16 ListElementID_);

    // API of field "ServiceLabel"

    static const int kServiceLabel = 3;

    /**
     * Clears the field "ServiceLabel".
     *
     * The field will be set to its default value. The hasServiceLabel()
     * method will return false.
     */
    inline void clearServiceLabel();

    /**
     * Checks whether the field "ServiceLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceLabel()). Otherwise it will return false.
     */
    inline bool hasServiceLabel () const;

    /**
     * Returns the value of the member "ServiceLabel".
     *
     * If the meaning of "ServiceLabel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ServiceLabel"
     */
    inline const ::std::string& getServiceLabel () const;

    /**
     * Retrieves the value of the field "ServiceLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ServiceLabel".
     */
    inline ::std::string& getServiceLabelMutable ();

    /**
     * Sets the value of the member "ServiceLabel".
     *
     * If the meaning of "ServiceLabel" isn't clear, then there should be a description here.
     *
     * @param ServiceLabel The value which will be set
     */
    inline void setServiceLabel (const ::std::string& ServiceLabel_);

    /**
     * Sets the value of the member "ServiceLabel".
     *
     * If the meaning of "ServiceLabel" isn't clear, then there should be a description here.
     *
     * @param ServiceLabel The value which will be set
     */
    inline void setServiceLabel (const char* ServiceLabel_);

    /**
     * Sets the value of the member "ServiceLabel".
     *
     * If the meaning of "ServiceLabel" isn't clear, then there should be a description here.
     *
     * @param ServiceLabel The value which will be set
     */
    inline void setServiceLabel (const char* value, size_t size);

    // API of field "EnsembleLabel"

    static const int kEnsembleLabel = 4;

    /**
     * Clears the field "EnsembleLabel".
     *
     * The field will be set to its default value. The hasEnsembleLabel()
     * method will return false.
     */
    inline void clearEnsembleLabel();

    /**
     * Checks whether the field "EnsembleLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnsembleLabel()). Otherwise it will return false.
     */
    inline bool hasEnsembleLabel () const;

    /**
     * Returns the value of the member "EnsembleLabel".
     *
     * If the meaning of "EnsembleLabel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "EnsembleLabel"
     */
    inline const ::std::string& getEnsembleLabel () const;

    /**
     * Retrieves the value of the field "EnsembleLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "EnsembleLabel".
     */
    inline ::std::string& getEnsembleLabelMutable ();

    /**
     * Sets the value of the member "EnsembleLabel".
     *
     * If the meaning of "EnsembleLabel" isn't clear, then there should be a description here.
     *
     * @param EnsembleLabel The value which will be set
     */
    inline void setEnsembleLabel (const ::std::string& EnsembleLabel_);

    /**
     * Sets the value of the member "EnsembleLabel".
     *
     * If the meaning of "EnsembleLabel" isn't clear, then there should be a description here.
     *
     * @param EnsembleLabel The value which will be set
     */
    inline void setEnsembleLabel (const char* EnsembleLabel_);

    /**
     * Sets the value of the member "EnsembleLabel".
     *
     * If the meaning of "EnsembleLabel" isn't clear, then there should be a description here.
     *
     * @param EnsembleLabel The value which will be set
     */
    inline void setEnsembleLabel (const char* value, size_t size);

    static const DABChannelItem &getDefaultInstance();

private:

    inline void set_has_DabID ();

    inline void clear_has_DabID ();

    inline void set_has_SecComponentID ();

    inline void clear_has_SecComponentID ();

    inline void set_has_ListElementID ();

    inline void clear_has_ListElementID ();

    inline void set_has_ServiceLabel ();

    inline void clear_has_ServiceLabel ();

    inline void set_has_EnsembleLabel ();

    inline void clear_has_EnsembleLabel ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint32 _DabID;

    uint8 _SecComponentID;

    uint16 _ListElementID;

    ::std::string _ServiceLabel;

    ::std::string _EnsembleLabel;

};

/**
 * If the meaning of "storeDabChannelNames" isn't clear, then there should be a description here.
 */
class StoreDabChannelNamesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StoreDabChannelNamesRequest ();

    /**
     * Copy constructor
     */
    inline  StoreDabChannelNamesRequest (const StoreDabChannelNamesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StoreDabChannelNamesRequest (const ::std::vector< DABChannelItem >& channelList_);

    /**
     * Destructor
     */
    inline virtual  ~StoreDabChannelNamesRequest();

    /**
     * Assignment operator
     */
    inline StoreDabChannelNamesRequest& operator = (const StoreDabChannelNamesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StoreDabChannelNamesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StoreDabChannelNamesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StoreDabChannelNamesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StoreDabChannelNamesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "channelList"

    static const int kChannelList = 0;

    /**
     * Clears the field "channelList".
     *
     * The field will be set to its default value. The hasChannelList()
     * method will return false.
     */
    inline void clearChannelList();

    /**
     * Checks whether the field "channelList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelList()). Otherwise it will return false.
     */
    inline bool hasChannelList () const;

    /**
     * Returns the value of the member "channelList".
     *
     * If the meaning of "channelList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "channelList"
     */
    inline const ::std::vector< DABChannelItem >& getChannelList () const;

    /**
     * Retrieves the value of the field "channelList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "channelList".
     */
    inline ::std::vector< DABChannelItem >& getChannelListMutable ();

    /**
     * Sets the value of the member "channelList".
     *
     * If the meaning of "channelList" isn't clear, then there should be a description here.
     *
     * @param channelList The value which will be set
     */
    inline void setChannelList (const ::std::vector< DABChannelItem >& channelList_);

    static const StoreDabChannelNamesRequest &getDefaultInstance();

private:

    static const ::std::vector< DABChannelItem >& getDABChannelItemList_DefaultInstance ();

    inline void set_has_channelList ();

    inline void clear_has_channelList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< DABChannelItem > _channelList;

};

inline  DABChannelItem::DABChannelItem ()  :
    _DabID (0u),
    _SecComponentID (0u),
    _ListElementID (0u),
    _ServiceLabel (),
    _EnsembleLabel ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DABChannelItem::DABChannelItem (const DABChannelItem &rhs)  :
    _DabID (0u),
    _SecComponentID (0u),
    _ListElementID (0u),
    _ServiceLabel (),
    _EnsembleLabel ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DABChannelItem::DABChannelItem (uint32 DabID_, uint8 SecComponentID_, uint16 ListElementID_, const ::std::string& ServiceLabel_, const ::std::string& EnsembleLabel_)  :
    _DabID (DabID_),
    _SecComponentID (SecComponentID_),
    _ListElementID (ListElementID_),
    _ServiceLabel (ServiceLabel_),
    _EnsembleLabel (EnsembleLabel_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ServiceLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (EnsembleLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DABChannelItem::~DABChannelItem() {
}

inline DABChannelItem& DABChannelItem::operator = (const DABChannelItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDabID()) {
            setDabID(rhs.getDabID());
        } else {
            clearDabID();
        }
        if (rhs.hasSecComponentID()) {
            setSecComponentID(rhs.getSecComponentID());
        } else {
            clearSecComponentID();
        }
        if (rhs.hasListElementID()) {
            setListElementID(rhs.getListElementID());
        } else {
            clearListElementID();
        }
        if (rhs.hasServiceLabel()) {
            setServiceLabel(rhs.getServiceLabel());
        } else {
            clearServiceLabel();
        }
        if (rhs.hasEnsembleLabel()) {
            setEnsembleLabel(rhs.getEnsembleLabel());
        } else {
            clearEnsembleLabel();
        }
    }
    return *this;
}

inline bool DABChannelItem::operator == (const DABChannelItem& rhs) const {
    return (((!hasDabID() && !rhs.hasDabID()) || getDabID() == rhs.getDabID()) &&
        ((!hasSecComponentID() && !rhs.hasSecComponentID()) || getSecComponentID() == rhs.getSecComponentID()) &&
        ((!hasListElementID() && !rhs.hasListElementID()) || getListElementID() == rhs.getListElementID()) &&
        ((!hasServiceLabel() && !rhs.hasServiceLabel()) || getServiceLabel() == rhs.getServiceLabel()) &&
        ((!hasEnsembleLabel() && !rhs.hasEnsembleLabel()) || getEnsembleLabel() == rhs.getEnsembleLabel()));
}

inline bool DABChannelItem::operator != (const DABChannelItem& rhs) const {
    return ! (*this == rhs);
}

inline bool DABChannelItem::operator < (const DABChannelItem& rhs) const {
    if (hasDabID() || rhs.hasDabID()) {
        if (getDabID() < rhs.getDabID()) return true;
        if (getDabID() > rhs.getDabID()) return false;
    }
    if (hasSecComponentID() || rhs.hasSecComponentID()) {
        if (getSecComponentID() < rhs.getSecComponentID()) return true;
        if (getSecComponentID() > rhs.getSecComponentID()) return false;
    }
    if (hasListElementID() || rhs.hasListElementID()) {
        if (getListElementID() < rhs.getListElementID()) return true;
        if (getListElementID() > rhs.getListElementID()) return false;
    }
    if (hasServiceLabel() || rhs.hasServiceLabel()) {
        if (getServiceLabel() < rhs.getServiceLabel()) return true;
        if (getServiceLabel() > rhs.getServiceLabel()) return false;
    }
    if (hasEnsembleLabel() || rhs.hasEnsembleLabel()) {
        if (getEnsembleLabel() < rhs.getEnsembleLabel()) return true;
        if (getEnsembleLabel() > rhs.getEnsembleLabel()) return false;
    }
    return false;
}

inline bool DABChannelItem::operator > (const DABChannelItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DABChannelItem::clear() {
    clearDabID();
    clearSecComponentID();
    clearListElementID();
    clearServiceLabel();
    clearEnsembleLabel();
}

inline void DABChannelItem::clearDabID() {
    if (hasDabID()) {
         clear_has_DabID();
        _DabID = 0u;
     }
}

inline bool DABChannelItem::hasDabID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 DABChannelItem::getDabID () const {
    return _DabID;
}

inline void DABChannelItem::setDabID (uint32 DabID_) {
    set_has_DabID();
    this->_DabID = DabID_;
}

inline void DABChannelItem::clearSecComponentID() {
    if (hasSecComponentID()) {
         clear_has_SecComponentID();
        _SecComponentID = 0u;
     }
}

inline bool DABChannelItem::hasSecComponentID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 DABChannelItem::getSecComponentID () const {
    return _SecComponentID;
}

inline void DABChannelItem::setSecComponentID (uint8 SecComponentID_) {
    set_has_SecComponentID();
    this->_SecComponentID = SecComponentID_;
}

inline void DABChannelItem::clearListElementID() {
    if (hasListElementID()) {
         clear_has_ListElementID();
        _ListElementID = 0u;
     }
}

inline bool DABChannelItem::hasListElementID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 DABChannelItem::getListElementID () const {
    return _ListElementID;
}

inline void DABChannelItem::setListElementID (uint16 ListElementID_) {
    set_has_ListElementID();
    this->_ListElementID = ListElementID_;
}

inline void DABChannelItem::clearServiceLabel() {
    if (hasServiceLabel()) {
         clear_has_ServiceLabel();
        _ServiceLabel.clear();
     }
}

inline bool DABChannelItem::hasServiceLabel () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& DABChannelItem::getServiceLabel () const {
    return _ServiceLabel;
}

inline ::std::string& DABChannelItem::getServiceLabelMutable () {
    set_has_ServiceLabel();
    return _ServiceLabel;
}

inline void DABChannelItem::setServiceLabel (const ::std::string& ServiceLabel_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ServiceLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ServiceLabel();
    this->_ServiceLabel = ServiceLabel_;
}

inline void DABChannelItem::setServiceLabel (const char* ServiceLabel_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ServiceLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ServiceLabel();
    this->_ServiceLabel.assign(ServiceLabel_);
}

inline void DABChannelItem::setServiceLabel (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ServiceLabel();
    this->_ServiceLabel.assign(value, size);
}

inline void DABChannelItem::clearEnsembleLabel() {
    if (hasEnsembleLabel()) {
         clear_has_EnsembleLabel();
        _EnsembleLabel.clear();
     }
}

inline bool DABChannelItem::hasEnsembleLabel () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& DABChannelItem::getEnsembleLabel () const {
    return _EnsembleLabel;
}

inline ::std::string& DABChannelItem::getEnsembleLabelMutable () {
    set_has_EnsembleLabel();
    return _EnsembleLabel;
}

inline void DABChannelItem::setEnsembleLabel (const ::std::string& EnsembleLabel_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (EnsembleLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_EnsembleLabel();
    this->_EnsembleLabel = EnsembleLabel_;
}

inline void DABChannelItem::setEnsembleLabel (const char* EnsembleLabel_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (EnsembleLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_EnsembleLabel();
    this->_EnsembleLabel.assign(EnsembleLabel_);
}

inline void DABChannelItem::setEnsembleLabel (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_EnsembleLabel();
    this->_EnsembleLabel.assign(value, size);
}

inline void DABChannelItem::set_has_DabID () {
    _has_bits_[0] |= 1u << 0;
}

inline void DABChannelItem::clear_has_DabID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DABChannelItem::set_has_SecComponentID () {
    _has_bits_[0] |= 1u << 1;
}

inline void DABChannelItem::clear_has_SecComponentID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DABChannelItem::set_has_ListElementID () {
    _has_bits_[0] |= 1u << 2;
}

inline void DABChannelItem::clear_has_ListElementID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DABChannelItem::set_has_ServiceLabel () {
    _has_bits_[0] |= 1u << 3;
}

inline void DABChannelItem::clear_has_ServiceLabel () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void DABChannelItem::set_has_EnsembleLabel () {
    _has_bits_[0] |= 1u << 4;
}

inline void DABChannelItem::clear_has_EnsembleLabel () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  StoreDabChannelNamesRequest::StoreDabChannelNamesRequest ()  :
    _channelList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StoreDabChannelNamesRequest::StoreDabChannelNamesRequest (const StoreDabChannelNamesRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _channelList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StoreDabChannelNamesRequest::StoreDabChannelNamesRequest (const ::std::vector< DABChannelItem >& channelList_)  :
    _channelList (channelList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StoreDabChannelNamesRequest::~StoreDabChannelNamesRequest() {
}

inline StoreDabChannelNamesRequest& StoreDabChannelNamesRequest::operator = (const StoreDabChannelNamesRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasChannelList()) {
            setChannelList(rhs.getChannelList());
        } else {
            clearChannelList();
        }
    }
    return *this;
}

inline bool StoreDabChannelNamesRequest::operator == (const StoreDabChannelNamesRequest& rhs) const {
    return (((!hasChannelList() && !rhs.hasChannelList()) || getChannelList() == rhs.getChannelList()));
}

inline bool StoreDabChannelNamesRequest::operator != (const StoreDabChannelNamesRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool StoreDabChannelNamesRequest::operator < (const StoreDabChannelNamesRequest& rhs) const {
    if (hasChannelList() || rhs.hasChannelList()) {
        if (getChannelList() < rhs.getChannelList()) return true;
        if (getChannelList() > rhs.getChannelList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StoreDabChannelNamesRequest::clone() {
    return new StoreDabChannelNamesRequest(*this);
}

inline bool StoreDabChannelNamesRequest::operator > (const StoreDabChannelNamesRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StoreDabChannelNamesRequest::clear() {
    clearChannelList();
}

inline void StoreDabChannelNamesRequest::clearChannelList() {
    if (hasChannelList()) {
         clear_has_channelList();
        _channelList.clear();
     }
}

inline bool StoreDabChannelNamesRequest::hasChannelList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< DABChannelItem >& StoreDabChannelNamesRequest::getChannelList () const {
    return _channelList;
}

inline ::std::vector< DABChannelItem >& StoreDabChannelNamesRequest::getChannelListMutable () {
    set_has_channelList();
    return _channelList;
}

inline void StoreDabChannelNamesRequest::setChannelList (const ::std::vector< DABChannelItem >& channelList_) {
    set_has_channelList();
    this->_channelList = channelList_;
}

inline void StoreDabChannelNamesRequest::set_has_channelList () {
    _has_bits_[0] |= 1u << 0;
}

inline void StoreDabChannelNamesRequest::clear_has_channelList () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace SdsDabService
} // namespace sds_dab_fi

#endif // SDS_DAB_FI_SDSDABSERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
