/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "sds_app_fi/SdsAppService.h"
#include "sds_app_fi/SdsAppServiceDBus.h"
#include "sds_app_fi/SdsAppServiceJson.h"
#include "sds_app_fi/SdsAppServiceStub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace sds_app_fi {
namespace SdsAppService {

DEFINE_CLASS_LOGGER("/sds_app_fi/sds_app_fi/SdsAppService", SdsAppServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 13, "storeAppNames", 0 },
    { 15, "getAppNamesList", 1 },
};


class SdsAppServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    SdsAppServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    SdsAppServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    SdsAppServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "sds_app_fi.SdsAppService"),
          _logger(logger) {}

    virtual ~SdsAppServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void SdsAppServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 2, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'storeAppNames'

            LOG_DEBUG_STUB("process method '%s'", "storeAppNames");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StoreAppNamesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StoreAppNames", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StoreAppNamesRequest > payload = ::boost::static_pointer_cast<StoreAppNamesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsAppServiceStub*>(getStub())->onStoreAppNamesRequest(payload);
            return;
        }
        case 1: {

            // method 'getAppNamesList'

            LOG_DEBUG_STUB("process method '%s'", "getAppNamesList");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetAppNamesListRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetAppNamesList", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetAppNamesListRequest > payload = ::boost::static_pointer_cast<GetAppNamesListRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsAppServiceStub*>(getStub())->onGetAppNamesListRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* SdsAppServiceStubDelegate::introspect() const {
    return     "<interface name=\"sds_app_fi.SdsAppService\">\n"
            "    <method name=\"storeAppNames\">\n"
            "      <arg direction=\"in\" name=\"appList\" type=\"(a(usa(ss))u)\">\n"
            "        <doc>\n"
            "          <line>appList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getAppNamesList\">\n"
            "      <arg direction=\"out\" name=\"appNameList\" type=\"as\">\n"
            "        <doc>\n"
            "          <line>appNameList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void SdsAppServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<SdsAppServiceStub*>(getStub()))->onGetAll (properties);
}

void SdsAppServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void SdsAppServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

SdsAppServiceStub::SdsAppServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SdsAppServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SdsAppServiceStub::SdsAppServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SdsAppServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SdsAppServiceStub::~SdsAppServiceStub() {
    delete _stubDelegate;
}

void  SdsAppServiceStub::sendStoreAppNamesResponse (act_t act) {
    StoreAppNamesResponse* payload = new StoreAppNamesResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "storeAppNames", StoreAppNamesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StoreAppNames", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsAppServiceStub::sendStoreAppNamesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StoreAppNamesError* payload = new StoreAppNamesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "storeAppNames", StoreAppNamesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StoreAppNames", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsAppServiceStub::sendGetAppNamesListResponse (const ::std::vector< ::std::string >& appNameList, act_t act) {
    GetAppNamesListResponse* payload = new GetAppNamesListResponse(appNameList);
    DBUS_MESSAGE_REPLY(dbusMessage, "getAppNamesList", GetAppNamesListResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetAppNamesList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsAppServiceStub::sendGetAppNamesListError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetAppNamesListError* payload = new GetAppNamesListError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getAppNamesList", GetAppNamesListError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetAppNamesList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void SdsAppServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace SdsAppService
} // namespace sds_app_fi
