/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "sds_app_fi/SdsAppService.h"
#include "sds_app_fi/SdsAppServiceDBus.h"
#include "sds_app_fi/SdsAppServiceJson.h"
#include "sds_app_fi/SdsAppServiceProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace sds_app_fi {
namespace SdsAppService {

DEFINE_CLASS_LOGGER("/sds_app_fi/sds_app_fi/SdsAppService", SdsAppServiceProxy);

class SdsAppServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    SdsAppServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< SdsAppServiceProxy >& proxyShared = ::boost::static_pointer_cast< SdsAppServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_storeAppNames:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StoreAppNamesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StoreAppNames", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StoreAppNamesError> payload = ::boost::static_pointer_cast<StoreAppNamesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StoreAppNamesCallbackIF*) _callback)->onStoreAppNamesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StoreAppNamesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StoreAppNames", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StoreAppNamesResponse> payload = ::boost::static_pointer_cast<StoreAppNamesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StoreAppNamesCallbackIF*) _callback)->onStoreAppNamesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getAppNamesList:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetAppNamesListError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetAppNamesList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetAppNamesListError> payload = ::boost::static_pointer_cast<GetAppNamesListError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetAppNamesListCallbackIF*) _callback)->onGetAppNamesListError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetAppNamesListResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetAppNamesList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetAppNamesListResponse> payload = ::boost::static_pointer_cast<GetAppNamesListResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetAppNamesListCallbackIF*) _callback)->onGetAppNamesListResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_storeAppNames: {
                ::boost::shared_ptr< StoreAppNamesError > payload = ::boost::shared_ptr< StoreAppNamesError >
                (new StoreAppNamesError(DBUS_ERROR_NO_SERVER, "The DBus service SdsAppService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StoreAppNames", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsAppServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsAppServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StoreAppNamesCallbackIF*) _callback)->onStoreAppNamesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getAppNamesList: {
                ::boost::shared_ptr< GetAppNamesListError > payload = ::boost::shared_ptr< GetAppNamesListError >
                (new GetAppNamesListError(DBUS_ERROR_NO_SERVER, "The DBus service SdsAppService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetAppNamesList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SdsAppServiceProxy> proxyShared = ::boost::static_pointer_cast<SdsAppServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetAppNamesListCallbackIF*) _callback)->onGetAppNamesListError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& SdsAppServiceProxyCallback::_logger (SdsAppServiceProxy::_logger);

SdsAppServiceProxy::SdsAppServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "sds_app_fi.SdsAppService", serviceAvailable, _logger) {
}

SdsAppServiceProxy::~SdsAppServiceProxy()
{
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< SdsAppServiceProxy > SdsAppServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<SdsAppServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< SdsAppServiceProxy > proxyNew(new SdsAppServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t SdsAppServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    SdsAppServiceProxyCallback* callback = new SdsAppServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t SdsAppServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    SdsAppServiceProxyCallback* callback = new SdsAppServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}



act_t SdsAppServiceProxy::sendStoreAppNamesRequest(StoreAppNamesCallbackIF& cb, const AppList& appList) const {
    StoreAppNamesRequest* payload = new StoreAppNamesRequest();
    CHECK_ALLOCATION(payload);
    payload->setAppList(appList);
    DBUS_MESSAGE_CALL(dbusMessage, "storeAppNames", StoreAppNamesRequest, payload, true)
    act_t act = addMethodCallback(ID_storeAppNames, dbusMessage.getUniqueSerial(), "storeAppNames", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StoreAppNames", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SdsAppServiceProxy::sendGetAppNamesListRequest(GetAppNamesListCallbackIF& cb) const {
    GetAppNamesListRequest* payload = new GetAppNamesListRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "getAppNamesList", GetAppNamesListRequest, payload, true)
    act_t act = addMethodCallback(ID_getAppNamesList, dbusMessage.getUniqueSerial(), "getAppNamesList", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetAppNamesList", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace SdsAppService
} // namespace sds_app_fi
