/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "sds_am_fi/SdsAmService.h"
#include "sds_am_fi/SdsAmServiceDBus.h"
#include "sds_am_fi/SdsAmServiceJson.h"
#include "sds_am_fi/SdsAmServiceStub.h"

#include "asf/dbus/DBusMessage.h"

namespace sds_am_fi {
namespace SdsAmService {

DEFINE_CLASS_LOGGER("/sds_am_fi/sds_am_fi/SdsAmService", SdsAmServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 19, "storeHDChannelNames", 0 },
};


class SdsAmServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    SdsAmServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    SdsAmServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    SdsAmServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "sds_am_fi.SdsAmService"),
          _logger(logger) {}

    virtual ~SdsAmServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void SdsAmServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 1, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'storeHDChannelNames'

            LOG_DEBUG_STUB("process method '%s'", "storeHDChannelNames");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StoreHDChannelNamesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StoreHDChannelNames", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StoreHDChannelNamesRequest > payload = ::boost::static_pointer_cast<StoreHDChannelNamesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SdsAmServiceStub*>(getStub())->onStoreHDChannelNamesRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* SdsAmServiceStubDelegate::introspect() const {
    return     "<interface name=\"sds_am_fi.SdsAmService\">\n"
            "    <method name=\"storeHDChannelNames\">\n"
            "      <arg direction=\"in\" name=\"channelList\" type=\"a(uusu)\">\n"
            "        <doc>\n"
            "          <line>channelList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"ProcessingFinished\"/>\n"
            "    <signal name=\"ProcessingInterrupted\"/>\n"
            "</interface>\n";
}

void SdsAmServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<SdsAmServiceStub*>(getStub()))->onGetAll (properties);
}

void SdsAmServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void SdsAmServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

SdsAmServiceStub::SdsAmServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SdsAmServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SdsAmServiceStub::SdsAmServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SdsAmServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SdsAmServiceStub::~SdsAmServiceStub() {
    delete _stubDelegate;
}

void SdsAmServiceStub::sendProcessingFinishedSignal() {
    if (_stubDelegate->isConnected()) {
        ProcessingFinishedSignal* payload = new ProcessingFinishedSignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ProcessingFinished", ProcessingFinishedSignal, payload)
        LOG_INFO ("-> send%sSignal", "ProcessingFinished");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ProcessingFinished");
    }
}

void SdsAmServiceStub::sendProcessingInterruptedSignal() {
    if (_stubDelegate->isConnected()) {
        ProcessingInterruptedSignal* payload = new ProcessingInterruptedSignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ProcessingInterrupted", ProcessingInterruptedSignal, payload)
        LOG_INFO ("-> send%sSignal", "ProcessingInterrupted");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ProcessingInterrupted");
    }
}

void  SdsAmServiceStub::sendStoreHDChannelNamesResponse (act_t act) {
    StoreHDChannelNamesResponse* payload = new StoreHDChannelNamesResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "storeHDChannelNames", StoreHDChannelNamesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StoreHDChannelNames", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SdsAmServiceStub::sendStoreHDChannelNamesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StoreHDChannelNamesError* payload = new StoreHDChannelNamesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "storeHDChannelNames", StoreHDChannelNamesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StoreHDChannelNames", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void SdsAmServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace SdsAmService
} // namespace sds_am_fi
