/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "sds_am_fi/SdsAmService.h"
#include "sds_am_fi/SdsAmServiceJson.h"
#include "sds_am_fi/SdsAmServiceJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "AMChannelItem"

void serializeJson (const ::sds_am_fi::SdsAmService::AMChannelItem& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasObjectID()) {
        yajl_gen_string(g, (const unsigned char*)  "objectID" , 8);
        yajl_gen_integer(g, (long long)value.getObjectID());
    }
    if (!isSparse || value.hasFrequency()) {
        yajl_gen_string(g, (const unsigned char*)  "frequency" , 9);
        yajl_gen_integer(g, (long long)value.getFrequency());
    }
    if (!isSparse || value.hasStationName()) {
        yajl_gen_string(g, (const unsigned char*)  "stationName" , 11);
        const char *s = value.getStationName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasAudioProgram()) {
        yajl_gen_string(g, (const unsigned char*)  "audioProgram" , 12);
        yajl_gen_integer(g, (long long)value.getAudioProgram());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_am_fi::SdsAmService::AMChannelItem& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StoreHDChannelNamesRequest"

void serializeJson (const ::sds_am_fi::SdsAmService::StoreHDChannelNamesRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChannelList()) {
        yajl_gen_string(g, (const unsigned char*)  "channelList" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::sds_am_fi::SdsAmService::AMChannelItem >& o1 = value.getChannelList();
        {
            ::std::vector< ::sds_am_fi::SdsAmService::AMChannelItem >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sds_am_fi::SdsAmService::StoreHDChannelNamesRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace sds_am_fi {
namespace SdsAmService {

std::ostream& operator<<(std::ostream& o, const ::sds_am_fi::SdsAmService::AMChannelItem& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SdsAmService
} // namespace sds_am_fi
using namespace ::asf::stream::json;

namespace sds_am_fi {
namespace SdsAmService {

std::ostream& operator<<(std::ostream& o, const ::sds_am_fi::SdsAmService::StoreHDChannelNamesRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SdsAmService
} // namespace sds_am_fi

