/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "fcswupdatesrv/FcSwUpdateSrv.h"
#include "fcswupdatesrv/FcSwUpdateSrvConst.h"
#include "fcswupdatesrv/FcSwUpdateSrvDBus.h"
#include "fcswupdatesrv/FcSwUpdateSrvJson.h"
#include "fcswupdatesrv/FcSwUpdateSrvProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace fcswupdatesrv {
namespace FcSwUpdateSrv {

DEFINE_CLASS_LOGGER("/fcswupdatesrv/fcswupdatesrv/FcSwUpdateSrv", FcSwUpdateSrvProxy);

class FcSwUpdateSrvProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    FcSwUpdateSrvProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxyShared = ::boost::static_pointer_cast< FcSwUpdateSrvProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_UpdateState:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateStateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UpdateState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateStateError> payload = ::boost::static_pointer_cast<UpdateStateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UpdateStateCallbackIF*) _callback)->onUpdateStateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateStateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UpdateState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateStateUpdate> payload = ::boost::static_pointer_cast<UpdateStateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UpdateStateCallbackIF*) _callback)->onUpdateStateUpdate(proxyShared, payload);
                        proxyShared->_updateState = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_UpdateSources:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateSourcesError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UpdateSources", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateSourcesError> payload = ::boost::static_pointer_cast<UpdateSourcesError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UpdateSourcesCallbackIF*) _callback)->onUpdateSourcesError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateSourcesUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UpdateSources", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateSourcesUpdate> payload = ::boost::static_pointer_cast<UpdateSourcesUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UpdateSourcesCallbackIF*) _callback)->onUpdateSourcesUpdate(proxyShared, payload);
                        proxyShared->_updateSources = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ReleaseFilter:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReleaseFilterError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ReleaseFilter", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReleaseFilterError> payload = ::boost::static_pointer_cast<ReleaseFilterError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ReleaseFilterCallbackIF*) _callback)->onReleaseFilterError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReleaseFilterUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ReleaseFilter", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReleaseFilterUpdate> payload = ::boost::static_pointer_cast<ReleaseFilterUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ReleaseFilterCallbackIF*) _callback)->onReleaseFilterUpdate(proxyShared, payload);
                        proxyShared->_releaseFilter = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ReleaseDoc:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReleaseDocError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ReleaseDoc", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReleaseDocError> payload = ::boost::static_pointer_cast<ReleaseDocError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ReleaseDocCallbackIF*) _callback)->onReleaseDocError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReleaseDocUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ReleaseDoc", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReleaseDocUpdate> payload = ::boost::static_pointer_cast<ReleaseDocUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ReleaseDocCallbackIF*) _callback)->onReleaseDocUpdate(proxyShared, payload);
                        proxyShared->_releaseDoc = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_PreReleaseDoc:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PreReleaseDocError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PreReleaseDoc", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PreReleaseDocError> payload = ::boost::static_pointer_cast<PreReleaseDocError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PreReleaseDocCallbackIF*) _callback)->onPreReleaseDocError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PreReleaseDocUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PreReleaseDoc", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PreReleaseDocUpdate> payload = ::boost::static_pointer_cast<PreReleaseDocUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PreReleaseDocCallbackIF*) _callback)->onPreReleaseDocUpdate(proxyShared, payload);
                        proxyShared->_preReleaseDoc = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_UpdateProgress:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateProgressError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UpdateProgress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateProgressError> payload = ::boost::static_pointer_cast<UpdateProgressError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UpdateProgressCallbackIF*) _callback)->onUpdateProgressError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateProgressUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UpdateProgress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateProgressUpdate> payload = ::boost::static_pointer_cast<UpdateProgressUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UpdateProgressCallbackIF*) _callback)->onUpdateProgressUpdate(proxyShared, payload);
                        proxyShared->_updateProgress = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_UpdateResult:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateResultError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UpdateResult", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateResultError> payload = ::boost::static_pointer_cast<UpdateResultError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UpdateResultCallbackIF*) _callback)->onUpdateResultError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateResultUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UpdateResult", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateResultUpdate> payload = ::boost::static_pointer_cast<UpdateResultUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UpdateResultCallbackIF*) _callback)->onUpdateResultUpdate(proxyShared, payload);
                        proxyShared->_updateResult = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_UpdateErrors:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateErrorsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UpdateErrors", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateErrorsError> payload = ::boost::static_pointer_cast<UpdateErrorsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UpdateErrorsCallbackIF*) _callback)->onUpdateErrorsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateErrorsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UpdateErrors", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateErrorsUpdate> payload = ::boost::static_pointer_cast<UpdateErrorsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UpdateErrorsCallbackIF*) _callback)->onUpdateErrorsUpdate(proxyShared, payload);
                        proxyShared->_updateErrors = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_CustomerUpdates:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CustomerUpdatesError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CustomerUpdates", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CustomerUpdatesError> payload = ::boost::static_pointer_cast<CustomerUpdatesError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CustomerUpdatesCallbackIF*) _callback)->onCustomerUpdatesError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CustomerUpdatesUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CustomerUpdates", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CustomerUpdatesUpdate> payload = ::boost::static_pointer_cast<CustomerUpdatesUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CustomerUpdatesCallbackIF*) _callback)->onCustomerUpdatesUpdate(proxyShared, payload);
                        proxyShared->_customerUpdates = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_VersionBackDocInfo:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VersionBackDocInfoError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "VersionBackDocInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VersionBackDocInfoError> payload = ::boost::static_pointer_cast<VersionBackDocInfoError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((VersionBackDocInfoCallbackIF*) _callback)->onVersionBackDocInfoError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VersionBackDocInfoUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "VersionBackDocInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VersionBackDocInfoUpdate> payload = ::boost::static_pointer_cast<VersionBackDocInfoUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((VersionBackDocInfoCallbackIF*) _callback)->onVersionBackDocInfoUpdate(proxyShared, payload);
                        proxyShared->_versionBackDocInfo = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_AvailableCustomerUpdates:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AvailableCustomerUpdatesError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AvailableCustomerUpdates", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AvailableCustomerUpdatesError> payload = ::boost::static_pointer_cast<AvailableCustomerUpdatesError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AvailableCustomerUpdatesCallbackIF*) _callback)->onAvailableCustomerUpdatesError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AvailableCustomerUpdatesUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AvailableCustomerUpdates", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AvailableCustomerUpdatesUpdate> payload = ::boost::static_pointer_cast<AvailableCustomerUpdatesUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AvailableCustomerUpdatesCallbackIF*) _callback)->onAvailableCustomerUpdatesUpdate(proxyShared, payload);
                        proxyShared->_availableCustomerUpdates = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_UpdateBgImageInfo:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateBgImageInfoError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UpdateBgImageInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateBgImageInfoError> payload = ::boost::static_pointer_cast<UpdateBgImageInfoError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UpdateBgImageInfoCallbackIF*) _callback)->onUpdateBgImageInfoError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateBgImageInfoUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UpdateBgImageInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateBgImageInfoUpdate> payload = ::boost::static_pointer_cast<UpdateBgImageInfoUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UpdateBgImageInfoCallbackIF*) _callback)->onUpdateBgImageInfoUpdate(proxyShared, payload);
                        proxyShared->_updateBgImageInfo = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_BgLocksState:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BgLocksStateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BgLocksState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BgLocksStateError> payload = ::boost::static_pointer_cast<BgLocksStateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((BgLocksStateCallbackIF*) _callback)->onBgLocksStateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BgLocksStateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BgLocksState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BgLocksStateUpdate> payload = ::boost::static_pointer_cast<BgLocksStateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((BgLocksStateCallbackIF*) _callback)->onBgLocksStateUpdate(proxyShared, payload);
                        proxyShared->_bgLocksState = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_StoreHistoryToStick:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StoreHistoryToStickError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StoreHistoryToStick", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StoreHistoryToStickError> payload = ::boost::static_pointer_cast<StoreHistoryToStickError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StoreHistoryToStickCallbackIF*) _callback)->onStoreHistoryToStickError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StoreHistoryToStickResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StoreHistoryToStick", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StoreHistoryToStickResponse> payload = ::boost::static_pointer_cast<StoreHistoryToStickResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StoreHistoryToStickCallbackIF*) _callback)->onStoreHistoryToStickResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_UpdateEnter:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UpdateEnterError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateEnter", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateEnterError> payload = ::boost::static_pointer_cast<UpdateEnterError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UpdateEnterCallbackIF*) _callback)->onUpdateEnterError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateEnterResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateEnter", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateEnterResponse> payload = ::boost::static_pointer_cast<UpdateEnterResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UpdateEnterCallbackIF*) _callback)->onUpdateEnterResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_UpdateSetReleaseFilter:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UpdateSetReleaseFilterError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateSetReleaseFilter", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateSetReleaseFilterError> payload = ::boost::static_pointer_cast<UpdateSetReleaseFilterError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UpdateSetReleaseFilterCallbackIF*) _callback)->onUpdateSetReleaseFilterError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateSetReleaseFilterResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateSetReleaseFilter", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateSetReleaseFilterResponse> payload = ::boost::static_pointer_cast<UpdateSetReleaseFilterResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UpdateSetReleaseFilterCallbackIF*) _callback)->onUpdateSetReleaseFilterResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_UpdateGetSources:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UpdateGetSourcesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateGetSources", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateGetSourcesError> payload = ::boost::static_pointer_cast<UpdateGetSourcesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UpdateGetSourcesCallbackIF*) _callback)->onUpdateGetSourcesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateGetSourcesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateGetSources", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateGetSourcesResponse> payload = ::boost::static_pointer_cast<UpdateGetSourcesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UpdateGetSourcesCallbackIF*) _callback)->onUpdateGetSourcesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_UpdateSelectSource:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UpdateSelectSourceError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateSelectSource", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateSelectSourceError> payload = ::boost::static_pointer_cast<UpdateSelectSourceError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UpdateSelectSourceCallbackIF*) _callback)->onUpdateSelectSourceError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateSelectSourceResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateSelectSource", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateSelectSourceResponse> payload = ::boost::static_pointer_cast<UpdateSelectSourceResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UpdateSelectSourceCallbackIF*) _callback)->onUpdateSelectSourceResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_UpdateSelectRelease:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UpdateSelectReleaseError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateSelectRelease", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateSelectReleaseError> payload = ::boost::static_pointer_cast<UpdateSelectReleaseError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UpdateSelectReleaseCallbackIF*) _callback)->onUpdateSelectReleaseError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateSelectReleaseResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateSelectRelease", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateSelectReleaseResponse> payload = ::boost::static_pointer_cast<UpdateSelectReleaseResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UpdateSelectReleaseCallbackIF*) _callback)->onUpdateSelectReleaseResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetDeviceStateList:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetDeviceStateListError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetDeviceStateList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetDeviceStateListError> payload = ::boost::static_pointer_cast<GetDeviceStateListError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetDeviceStateListCallbackIF*) _callback)->onGetDeviceStateListError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetDeviceStateListResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetDeviceStateList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetDeviceStateListResponse> payload = ::boost::static_pointer_cast<GetDeviceStateListResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetDeviceStateListCallbackIF*) _callback)->onGetDeviceStateListResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetUpdateOptions:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetUpdateOptionsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetUpdateOptions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetUpdateOptionsError> payload = ::boost::static_pointer_cast<SetUpdateOptionsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetUpdateOptionsCallbackIF*) _callback)->onSetUpdateOptionsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetUpdateOptionsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetUpdateOptions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetUpdateOptionsResponse> payload = ::boost::static_pointer_cast<SetUpdateOptionsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetUpdateOptionsCallbackIF*) _callback)->onSetUpdateOptionsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ModifyReleaseDoc:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ModifyReleaseDocError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ModifyReleaseDoc", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ModifyReleaseDocError> payload = ::boost::static_pointer_cast<ModifyReleaseDocError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ModifyReleaseDocCallbackIF*) _callback)->onModifyReleaseDocError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ModifyReleaseDocResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ModifyReleaseDoc", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ModifyReleaseDocResponse> payload = ::boost::static_pointer_cast<ModifyReleaseDocResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ModifyReleaseDocCallbackIF*) _callback)->onModifyReleaseDocResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetUpdateFile:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetUpdateFileError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetUpdateFile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetUpdateFileError> payload = ::boost::static_pointer_cast<GetUpdateFileError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetUpdateFileCallbackIF*) _callback)->onGetUpdateFileError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetUpdateFileResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetUpdateFile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetUpdateFileResponse> payload = ::boost::static_pointer_cast<GetUpdateFileResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetUpdateFileCallbackIF*) _callback)->onGetUpdateFileResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ApplyDoc:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ApplyDocError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ApplyDoc", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ApplyDocError> payload = ::boost::static_pointer_cast<ApplyDocError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ApplyDocCallbackIF*) _callback)->onApplyDocError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ApplyDocResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ApplyDoc", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ApplyDocResponse> payload = ::boost::static_pointer_cast<ApplyDocResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ApplyDocCallbackIF*) _callback)->onApplyDocResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ApplyLock:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ApplyLockError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ApplyLock", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ApplyLockError> payload = ::boost::static_pointer_cast<ApplyLockError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ApplyLockCallbackIF*) _callback)->onApplyLockError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ApplyLockResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ApplyLock", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ApplyLockResponse> payload = ::boost::static_pointer_cast<ApplyLockResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ApplyLockCallbackIF*) _callback)->onApplyLockResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_UpdateSelectReleaseByFile:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UpdateSelectReleaseByFileError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateSelectReleaseByFile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateSelectReleaseByFileError> payload = ::boost::static_pointer_cast<UpdateSelectReleaseByFileError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UpdateSelectReleaseByFileCallbackIF*) _callback)->onUpdateSelectReleaseByFileError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateSelectReleaseByFileResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateSelectReleaseByFile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateSelectReleaseByFileResponse> payload = ::boost::static_pointer_cast<UpdateSelectReleaseByFileResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UpdateSelectReleaseByFileCallbackIF*) _callback)->onUpdateSelectReleaseByFileResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RetryFailedModules:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RetryFailedModulesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RetryFailedModules", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RetryFailedModulesError> payload = ::boost::static_pointer_cast<RetryFailedModulesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RetryFailedModulesCallbackIF*) _callback)->onRetryFailedModulesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RetryFailedModulesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RetryFailedModules", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RetryFailedModulesResponse> payload = ::boost::static_pointer_cast<RetryFailedModulesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RetryFailedModulesCallbackIF*) _callback)->onRetryFailedModulesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_UpdateEnd:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UpdateEndError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateEnd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateEndError> payload = ::boost::static_pointer_cast<UpdateEndError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UpdateEndCallbackIF*) _callback)->onUpdateEndError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateEndResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateEnd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateEndResponse> payload = ::boost::static_pointer_cast<UpdateEndResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UpdateEndCallbackIF*) _callback)->onUpdateEndResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_UpdateAbort:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UpdateAbortError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateAbort", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateAbortError> payload = ::boost::static_pointer_cast<UpdateAbortError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UpdateAbortCallbackIF*) _callback)->onUpdateAbortError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateAbortResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateAbort", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateAbortResponse> payload = ::boost::static_pointer_cast<UpdateAbortResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UpdateAbortCallbackIF*) _callback)->onUpdateAbortResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_UpdateAbortDevice:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UpdateAbortDeviceError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateAbortDevice", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateAbortDeviceError> payload = ::boost::static_pointer_cast<UpdateAbortDeviceError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UpdateAbortDeviceCallbackIF*) _callback)->onUpdateAbortDeviceError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateAbortDeviceResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateAbortDevice", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateAbortDeviceResponse> payload = ::boost::static_pointer_cast<UpdateAbortDeviceResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UpdateAbortDeviceCallbackIF*) _callback)->onUpdateAbortDeviceResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_HandleError:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), HandleErrorError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "HandleError", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HandleErrorError> payload = ::boost::static_pointer_cast<HandleErrorError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HandleErrorCallbackIF*) _callback)->onHandleErrorError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HandleErrorResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "HandleError", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HandleErrorResponse> payload = ::boost::static_pointer_cast<HandleErrorResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HandleErrorCallbackIF*) _callback)->onHandleErrorResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetUpdateHistory:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetUpdateHistoryError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetUpdateHistory", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetUpdateHistoryError> payload = ::boost::static_pointer_cast<GetUpdateHistoryError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetUpdateHistoryCallbackIF*) _callback)->onGetUpdateHistoryError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetUpdateHistoryResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetUpdateHistory", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetUpdateHistoryResponse> payload = ::boost::static_pointer_cast<GetUpdateHistoryResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetUpdateHistoryCallbackIF*) _callback)->onGetUpdateHistoryResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetUpdateHistoryScoped:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetUpdateHistoryScopedError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetUpdateHistoryScoped", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetUpdateHistoryScopedError> payload = ::boost::static_pointer_cast<GetUpdateHistoryScopedError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetUpdateHistoryScopedCallbackIF*) _callback)->onGetUpdateHistoryScopedError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetUpdateHistoryScopedResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetUpdateHistoryScoped", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetUpdateHistoryScopedResponse> payload = ::boost::static_pointer_cast<GetUpdateHistoryScopedResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetUpdateHistoryScopedCallbackIF*) _callback)->onGetUpdateHistoryScopedResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetUpdateHistoryDetailed:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetUpdateHistoryDetailedError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetUpdateHistoryDetailed", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetUpdateHistoryDetailedError> payload = ::boost::static_pointer_cast<GetUpdateHistoryDetailedError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetUpdateHistoryDetailedCallbackIF*) _callback)->onGetUpdateHistoryDetailedError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetUpdateHistoryDetailedResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetUpdateHistoryDetailed", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetUpdateHistoryDetailedResponse> payload = ::boost::static_pointer_cast<GetUpdateHistoryDetailedResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetUpdateHistoryDetailedCallbackIF*) _callback)->onGetUpdateHistoryDetailedResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_DeleteHistoryRequest:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DeleteHistoryRequestError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DeleteHistoryRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeleteHistoryRequestError> payload = ::boost::static_pointer_cast<DeleteHistoryRequestError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DeleteHistoryRequestCallbackIF*) _callback)->onDeleteHistoryRequestError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeleteHistoryRequestResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DeleteHistoryRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeleteHistoryRequestResponse> payload = ::boost::static_pointer_cast<DeleteHistoryRequestResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DeleteHistoryRequestCallbackIF*) _callback)->onDeleteHistoryRequestResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetTargetState:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetTargetStateError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetTargetState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetTargetStateError> payload = ::boost::static_pointer_cast<GetTargetStateError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetTargetStateCallbackIF*) _callback)->onGetTargetStateError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetTargetStateResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetTargetState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetTargetStateResponse> payload = ::boost::static_pointer_cast<GetTargetStateResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetTargetStateCallbackIF*) _callback)->onGetTargetStateResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetVersionBackDocAck:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetVersionBackDocAckError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetVersionBackDocAck", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetVersionBackDocAckError> payload = ::boost::static_pointer_cast<SetVersionBackDocAckError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetVersionBackDocAckCallbackIF*) _callback)->onSetVersionBackDocAckError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetVersionBackDocAckResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetVersionBackDocAck", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetVersionBackDocAckResponse> payload = ::boost::static_pointer_cast<SetVersionBackDocAckResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetVersionBackDocAckCallbackIF*) _callback)->onSetVersionBackDocAckResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetAllowRecoveryMode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetAllowRecoveryModeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetAllowRecoveryMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetAllowRecoveryModeError> payload = ::boost::static_pointer_cast<SetAllowRecoveryModeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetAllowRecoveryModeCallbackIF*) _callback)->onSetAllowRecoveryModeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetAllowRecoveryModeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetAllowRecoveryMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetAllowRecoveryModeResponse> payload = ::boost::static_pointer_cast<SetAllowRecoveryModeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetAllowRecoveryModeCallbackIF*) _callback)->onSetAllowRecoveryModeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetCacheDirectory:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetCacheDirectoryError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetCacheDirectory", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetCacheDirectoryError> payload = ::boost::static_pointer_cast<GetCacheDirectoryError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetCacheDirectoryCallbackIF*) _callback)->onGetCacheDirectoryError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetCacheDirectoryResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetCacheDirectory", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetCacheDirectoryResponse> payload = ::boost::static_pointer_cast<GetCacheDirectoryResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetCacheDirectoryCallbackIF*) _callback)->onGetCacheDirectoryResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_EnterRecoveryMode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EnterRecoveryModeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EnterRecoveryMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EnterRecoveryModeError> payload = ::boost::static_pointer_cast<EnterRecoveryModeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EnterRecoveryModeCallbackIF*) _callback)->onEnterRecoveryModeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EnterRecoveryModeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EnterRecoveryMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EnterRecoveryModeResponse> payload = ::boost::static_pointer_cast<EnterRecoveryModeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EnterRecoveryModeCallbackIF*) _callback)->onEnterRecoveryModeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_VerifyChecksum:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), VerifyChecksumError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "VerifyChecksum", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VerifyChecksumError> payload = ::boost::static_pointer_cast<VerifyChecksumError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((VerifyChecksumCallbackIF*) _callback)->onVerifyChecksumError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VerifyChecksumResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "VerifyChecksum", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VerifyChecksumResponse> payload = ::boost::static_pointer_cast<VerifyChecksumResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((VerifyChecksumCallbackIF*) _callback)->onVerifyChecksumResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RegisterBgLocks:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RegisterBgLocksError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterBgLocks", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegisterBgLocksError> payload = ::boost::static_pointer_cast<RegisterBgLocksError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RegisterBgLocksCallbackIF*) _callback)->onRegisterBgLocksError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterBgLocksResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterBgLocks", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegisterBgLocksResponse> payload = ::boost::static_pointer_cast<RegisterBgLocksResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RegisterBgLocksCallbackIF*) _callback)->onRegisterBgLocksResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_UpdateState: {
                ::boost::shared_ptr< UpdateStateError > payload = ::boost::shared_ptr< UpdateStateError >
                (new UpdateStateError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UpdateState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UpdateStateCallbackIF*) _callback)->onUpdateStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UpdateSources: {
                ::boost::shared_ptr< UpdateSourcesError > payload = ::boost::shared_ptr< UpdateSourcesError >
                (new UpdateSourcesError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UpdateSources", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UpdateSourcesCallbackIF*) _callback)->onUpdateSourcesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReleaseFilter: {
                ::boost::shared_ptr< ReleaseFilterError > payload = ::boost::shared_ptr< ReleaseFilterError >
                (new ReleaseFilterError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReleaseFilter", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReleaseFilterCallbackIF*) _callback)->onReleaseFilterError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReleaseDoc: {
                ::boost::shared_ptr< ReleaseDocError > payload = ::boost::shared_ptr< ReleaseDocError >
                (new ReleaseDocError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReleaseDoc", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReleaseDocCallbackIF*) _callback)->onReleaseDocError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PreReleaseDoc: {
                ::boost::shared_ptr< PreReleaseDocError > payload = ::boost::shared_ptr< PreReleaseDocError >
                (new PreReleaseDocError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PreReleaseDoc", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PreReleaseDocCallbackIF*) _callback)->onPreReleaseDocError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UpdateProgress: {
                ::boost::shared_ptr< UpdateProgressError > payload = ::boost::shared_ptr< UpdateProgressError >
                (new UpdateProgressError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UpdateProgress", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UpdateProgressCallbackIF*) _callback)->onUpdateProgressError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UpdateResult: {
                ::boost::shared_ptr< UpdateResultError > payload = ::boost::shared_ptr< UpdateResultError >
                (new UpdateResultError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UpdateResult", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UpdateResultCallbackIF*) _callback)->onUpdateResultError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UpdateErrors: {
                ::boost::shared_ptr< UpdateErrorsError > payload = ::boost::shared_ptr< UpdateErrorsError >
                (new UpdateErrorsError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UpdateErrors", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UpdateErrorsCallbackIF*) _callback)->onUpdateErrorsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CustomerUpdates: {
                ::boost::shared_ptr< CustomerUpdatesError > payload = ::boost::shared_ptr< CustomerUpdatesError >
                (new CustomerUpdatesError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CustomerUpdates", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CustomerUpdatesCallbackIF*) _callback)->onCustomerUpdatesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_VersionBackDocInfo: {
                ::boost::shared_ptr< VersionBackDocInfoError > payload = ::boost::shared_ptr< VersionBackDocInfoError >
                (new VersionBackDocInfoError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "VersionBackDocInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((VersionBackDocInfoCallbackIF*) _callback)->onVersionBackDocInfoError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AvailableCustomerUpdates: {
                ::boost::shared_ptr< AvailableCustomerUpdatesError > payload = ::boost::shared_ptr< AvailableCustomerUpdatesError >
                (new AvailableCustomerUpdatesError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AvailableCustomerUpdates", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AvailableCustomerUpdatesCallbackIF*) _callback)->onAvailableCustomerUpdatesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UpdateBgImageInfo: {
                ::boost::shared_ptr< UpdateBgImageInfoError > payload = ::boost::shared_ptr< UpdateBgImageInfoError >
                (new UpdateBgImageInfoError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UpdateBgImageInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UpdateBgImageInfoCallbackIF*) _callback)->onUpdateBgImageInfoError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BgLocksState: {
                ::boost::shared_ptr< BgLocksStateError > payload = ::boost::shared_ptr< BgLocksStateError >
                (new BgLocksStateError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BgLocksState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BgLocksStateCallbackIF*) _callback)->onBgLocksStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StoreHistoryToStick: {
                ::boost::shared_ptr< StoreHistoryToStickError > payload = ::boost::shared_ptr< StoreHistoryToStickError >
                (new StoreHistoryToStickError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StoreHistoryToStick", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StoreHistoryToStickCallbackIF*) _callback)->onStoreHistoryToStickError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UpdateEnter: {
                ::boost::shared_ptr< UpdateEnterError > payload = ::boost::shared_ptr< UpdateEnterError >
                (new UpdateEnterError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UpdateEnter", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UpdateEnterCallbackIF*) _callback)->onUpdateEnterError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UpdateSetReleaseFilter: {
                ::boost::shared_ptr< UpdateSetReleaseFilterError > payload = ::boost::shared_ptr< UpdateSetReleaseFilterError >
                (new UpdateSetReleaseFilterError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UpdateSetReleaseFilter", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UpdateSetReleaseFilterCallbackIF*) _callback)->onUpdateSetReleaseFilterError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UpdateGetSources: {
                ::boost::shared_ptr< UpdateGetSourcesError > payload = ::boost::shared_ptr< UpdateGetSourcesError >
                (new UpdateGetSourcesError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UpdateGetSources", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UpdateGetSourcesCallbackIF*) _callback)->onUpdateGetSourcesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UpdateSelectSource: {
                ::boost::shared_ptr< UpdateSelectSourceError > payload = ::boost::shared_ptr< UpdateSelectSourceError >
                (new UpdateSelectSourceError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UpdateSelectSource", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UpdateSelectSourceCallbackIF*) _callback)->onUpdateSelectSourceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UpdateSelectRelease: {
                ::boost::shared_ptr< UpdateSelectReleaseError > payload = ::boost::shared_ptr< UpdateSelectReleaseError >
                (new UpdateSelectReleaseError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UpdateSelectRelease", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UpdateSelectReleaseCallbackIF*) _callback)->onUpdateSelectReleaseError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetDeviceStateList: {
                ::boost::shared_ptr< GetDeviceStateListError > payload = ::boost::shared_ptr< GetDeviceStateListError >
                (new GetDeviceStateListError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetDeviceStateList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetDeviceStateListCallbackIF*) _callback)->onGetDeviceStateListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetUpdateOptions: {
                ::boost::shared_ptr< SetUpdateOptionsError > payload = ::boost::shared_ptr< SetUpdateOptionsError >
                (new SetUpdateOptionsError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetUpdateOptions", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetUpdateOptionsCallbackIF*) _callback)->onSetUpdateOptionsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ModifyReleaseDoc: {
                ::boost::shared_ptr< ModifyReleaseDocError > payload = ::boost::shared_ptr< ModifyReleaseDocError >
                (new ModifyReleaseDocError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ModifyReleaseDoc", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ModifyReleaseDocCallbackIF*) _callback)->onModifyReleaseDocError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetUpdateFile: {
                ::boost::shared_ptr< GetUpdateFileError > payload = ::boost::shared_ptr< GetUpdateFileError >
                (new GetUpdateFileError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetUpdateFile", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetUpdateFileCallbackIF*) _callback)->onGetUpdateFileError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ApplyDoc: {
                ::boost::shared_ptr< ApplyDocError > payload = ::boost::shared_ptr< ApplyDocError >
                (new ApplyDocError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ApplyDoc", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ApplyDocCallbackIF*) _callback)->onApplyDocError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ApplyLock: {
                ::boost::shared_ptr< ApplyLockError > payload = ::boost::shared_ptr< ApplyLockError >
                (new ApplyLockError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ApplyLock", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ApplyLockCallbackIF*) _callback)->onApplyLockError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UpdateSelectReleaseByFile: {
                ::boost::shared_ptr< UpdateSelectReleaseByFileError > payload = ::boost::shared_ptr< UpdateSelectReleaseByFileError >
                (new UpdateSelectReleaseByFileError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UpdateSelectReleaseByFile", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UpdateSelectReleaseByFileCallbackIF*) _callback)->onUpdateSelectReleaseByFileError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RetryFailedModules: {
                ::boost::shared_ptr< RetryFailedModulesError > payload = ::boost::shared_ptr< RetryFailedModulesError >
                (new RetryFailedModulesError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RetryFailedModules", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RetryFailedModulesCallbackIF*) _callback)->onRetryFailedModulesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UpdateEnd: {
                ::boost::shared_ptr< UpdateEndError > payload = ::boost::shared_ptr< UpdateEndError >
                (new UpdateEndError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UpdateEnd", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UpdateEndCallbackIF*) _callback)->onUpdateEndError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UpdateAbort: {
                ::boost::shared_ptr< UpdateAbortError > payload = ::boost::shared_ptr< UpdateAbortError >
                (new UpdateAbortError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UpdateAbort", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UpdateAbortCallbackIF*) _callback)->onUpdateAbortError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UpdateAbortDevice: {
                ::boost::shared_ptr< UpdateAbortDeviceError > payload = ::boost::shared_ptr< UpdateAbortDeviceError >
                (new UpdateAbortDeviceError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UpdateAbortDevice", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UpdateAbortDeviceCallbackIF*) _callback)->onUpdateAbortDeviceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_HandleError: {
                ::boost::shared_ptr< HandleErrorError > payload = ::boost::shared_ptr< HandleErrorError >
                (new HandleErrorError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "HandleError", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((HandleErrorCallbackIF*) _callback)->onHandleErrorError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetUpdateHistory: {
                ::boost::shared_ptr< GetUpdateHistoryError > payload = ::boost::shared_ptr< GetUpdateHistoryError >
                (new GetUpdateHistoryError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetUpdateHistory", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetUpdateHistoryCallbackIF*) _callback)->onGetUpdateHistoryError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetUpdateHistoryScoped: {
                ::boost::shared_ptr< GetUpdateHistoryScopedError > payload = ::boost::shared_ptr< GetUpdateHistoryScopedError >
                (new GetUpdateHistoryScopedError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetUpdateHistoryScoped", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetUpdateHistoryScopedCallbackIF*) _callback)->onGetUpdateHistoryScopedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetUpdateHistoryDetailed: {
                ::boost::shared_ptr< GetUpdateHistoryDetailedError > payload = ::boost::shared_ptr< GetUpdateHistoryDetailedError >
                (new GetUpdateHistoryDetailedError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetUpdateHistoryDetailed", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetUpdateHistoryDetailedCallbackIF*) _callback)->onGetUpdateHistoryDetailedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DeleteHistoryRequest: {
                ::boost::shared_ptr< DeleteHistoryRequestError > payload = ::boost::shared_ptr< DeleteHistoryRequestError >
                (new DeleteHistoryRequestError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DeleteHistoryRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DeleteHistoryRequestCallbackIF*) _callback)->onDeleteHistoryRequestError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetTargetState: {
                ::boost::shared_ptr< GetTargetStateError > payload = ::boost::shared_ptr< GetTargetStateError >
                (new GetTargetStateError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetTargetState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetTargetStateCallbackIF*) _callback)->onGetTargetStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetVersionBackDocAck: {
                ::boost::shared_ptr< SetVersionBackDocAckError > payload = ::boost::shared_ptr< SetVersionBackDocAckError >
                (new SetVersionBackDocAckError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetVersionBackDocAck", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetVersionBackDocAckCallbackIF*) _callback)->onSetVersionBackDocAckError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetAllowRecoveryMode: {
                ::boost::shared_ptr< SetAllowRecoveryModeError > payload = ::boost::shared_ptr< SetAllowRecoveryModeError >
                (new SetAllowRecoveryModeError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetAllowRecoveryMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetAllowRecoveryModeCallbackIF*) _callback)->onSetAllowRecoveryModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetCacheDirectory: {
                ::boost::shared_ptr< GetCacheDirectoryError > payload = ::boost::shared_ptr< GetCacheDirectoryError >
                (new GetCacheDirectoryError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetCacheDirectory", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetCacheDirectoryCallbackIF*) _callback)->onGetCacheDirectoryError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EnterRecoveryMode: {
                ::boost::shared_ptr< EnterRecoveryModeError > payload = ::boost::shared_ptr< EnterRecoveryModeError >
                (new EnterRecoveryModeError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EnterRecoveryMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EnterRecoveryModeCallbackIF*) _callback)->onEnterRecoveryModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_VerifyChecksum: {
                ::boost::shared_ptr< VerifyChecksumError > payload = ::boost::shared_ptr< VerifyChecksumError >
                (new VerifyChecksumError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "VerifyChecksum", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((VerifyChecksumCallbackIF*) _callback)->onVerifyChecksumError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RegisterBgLocks: {
                ::boost::shared_ptr< RegisterBgLocksError > payload = ::boost::shared_ptr< RegisterBgLocksError >
                (new RegisterBgLocksError(DBUS_ERROR_NO_SERVER, "The DBus service FcSwUpdateSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RegisterBgLocks", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcSwUpdateSrvProxy> proxyShared = ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RegisterBgLocksCallbackIF*) _callback)->onRegisterBgLocksError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& FcSwUpdateSrvProxyCallback::_logger (FcSwUpdateSrvProxy::_logger);

FcSwUpdateSrvProxy::FcSwUpdateSrvProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "fcswupdatesrv.FcSwUpdateSrv", serviceAvailable, _logger) {
}

FcSwUpdateSrvProxy::~FcSwUpdateSrvProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< FcSwUpdateSrvProxy > FcSwUpdateSrvProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<FcSwUpdateSrvProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< FcSwUpdateSrvProxy > proxyNew(new FcSwUpdateSrvProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t FcSwUpdateSrvProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t FcSwUpdateSrvProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void FcSwUpdateSrvProxy::clearAllProperties ()
{
    _updateState = ::asf::core::nullable< UpdateStateUpdate >();
    _updateSources = ::asf::core::nullable< UpdateSourcesUpdate >();
    _releaseFilter = ::asf::core::nullable< ReleaseFilterUpdate >();
    _releaseDoc = ::asf::core::nullable< ReleaseDocUpdate >();
    _preReleaseDoc = ::asf::core::nullable< PreReleaseDocUpdate >();
    _updateProgress = ::asf::core::nullable< UpdateProgressUpdate >();
    _updateResult = ::asf::core::nullable< UpdateResultUpdate >();
    _updateErrors = ::asf::core::nullable< UpdateErrorsUpdate >();
    _customerUpdates = ::asf::core::nullable< CustomerUpdatesUpdate >();
    _versionBackDocInfo = ::asf::core::nullable< VersionBackDocInfoUpdate >();
    _availableCustomerUpdates = ::asf::core::nullable< AvailableCustomerUpdatesUpdate >();
    _updateBgImageInfo = ::asf::core::nullable< UpdateBgImageInfoUpdate >();
    _bgLocksState = ::asf::core::nullable< BgLocksStateUpdate >();
}

void FcSwUpdateSrvProxy::sendDeregisterAll () const
{
    sendUpdateStateDeregisterAll();
    sendUpdateSourcesDeregisterAll();
    sendReleaseFilterDeregisterAll();
    sendReleaseDocDeregisterAll();
    sendPreReleaseDocDeregisterAll();
    sendUpdateProgressDeregisterAll();
    sendUpdateResultDeregisterAll();
    sendUpdateErrorsDeregisterAll();
    sendCustomerUpdatesDeregisterAll();
    sendVersionBackDocInfoDeregisterAll();
    sendAvailableCustomerUpdatesDeregisterAll();
    sendUpdateBgImageInfoDeregisterAll();
    sendBgLocksStateDeregisterAll();
}

act_t FcSwUpdateSrvProxy::sendUpdateStateRegister(UpdateStateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_UpdateState, "UpdateState", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UpdateState", &cb, act);
    return act;
}

bool FcSwUpdateSrvProxy::sendUpdateStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UpdateState", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UpdateState", act, static_cast<int>(rv));
    return rv;
}

act_t FcSwUpdateSrvProxy::sendUpdateStateGet(UpdateStateCallbackIF& cb) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_UpdateState, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "UpdateState", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("UpdateState", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void FcSwUpdateSrvProxy::sendUpdateStateSet(const trUpdState& updateState) {
    UpdateStateSet parameter(updateState);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "UpdateState");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "UpdateState", propertyContent);
}

act_t FcSwUpdateSrvProxy::sendUpdateStateSet(UpdateStateCallbackIF& cb, const trUpdState& updateState) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_UpdateState, &cb);
    UpdateStateSet parameter(updateState);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "UpdateState", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "UpdateState", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const trUpdState& FcSwUpdateSrvProxy::getUpdateState() const {
    return _updateState.get().getUpdateState();
}

bool FcSwUpdateSrvProxy::hasUpdateState() const {
    return _updateState.hasValue();
}

void FcSwUpdateSrvProxy::sendUpdateStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UpdateState");
    _dbusProxyDelegate->deregisterSignalCallback("UpdateState", 0, _dbusDaemonProxy.get(), true);
}

act_t FcSwUpdateSrvProxy::sendUpdateSourcesRegister(UpdateSourcesCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_UpdateSources, "UpdateSources", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UpdateSources", &cb, act);
    return act;
}

bool FcSwUpdateSrvProxy::sendUpdateSourcesDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UpdateSources", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UpdateSources", act, static_cast<int>(rv));
    return rv;
}

act_t FcSwUpdateSrvProxy::sendUpdateSourcesGet(UpdateSourcesCallbackIF& cb) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_UpdateSources, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "UpdateSources", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("UpdateSources", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void FcSwUpdateSrvProxy::sendUpdateSourcesSet(const trUpdSources& updateSources) {
    UpdateSourcesSet parameter(updateSources);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "UpdateSources");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "UpdateSources", propertyContent);
}

act_t FcSwUpdateSrvProxy::sendUpdateSourcesSet(UpdateSourcesCallbackIF& cb, const trUpdSources& updateSources) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_UpdateSources, &cb);
    UpdateSourcesSet parameter(updateSources);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "UpdateSources", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "UpdateSources", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const trUpdSources& FcSwUpdateSrvProxy::getUpdateSources() const {
    return _updateSources.get().getUpdateSources();
}

bool FcSwUpdateSrvProxy::hasUpdateSources() const {
    return _updateSources.hasValue();
}

void FcSwUpdateSrvProxy::sendUpdateSourcesDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UpdateSources");
    _dbusProxyDelegate->deregisterSignalCallback("UpdateSources", 0, _dbusDaemonProxy.get(), true);
}

act_t FcSwUpdateSrvProxy::sendReleaseFilterRegister(ReleaseFilterCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ReleaseFilter, "ReleaseFilter", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ReleaseFilter", &cb, act);
    return act;
}

bool FcSwUpdateSrvProxy::sendReleaseFilterDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ReleaseFilter", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ReleaseFilter", act, static_cast<int>(rv));
    return rv;
}

act_t FcSwUpdateSrvProxy::sendReleaseFilterGet(ReleaseFilterCallbackIF& cb) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_ReleaseFilter, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ReleaseFilter", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ReleaseFilter", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void FcSwUpdateSrvProxy::sendReleaseFilterSet(const trReleaseFilter& releaseFilter) {
    ReleaseFilterSet parameter(releaseFilter);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "ReleaseFilter");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "ReleaseFilter", propertyContent);
}

act_t FcSwUpdateSrvProxy::sendReleaseFilterSet(ReleaseFilterCallbackIF& cb, const trReleaseFilter& releaseFilter) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_ReleaseFilter, &cb);
    ReleaseFilterSet parameter(releaseFilter);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "ReleaseFilter", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "ReleaseFilter", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const trReleaseFilter& FcSwUpdateSrvProxy::getReleaseFilter() const {
    return _releaseFilter.get().getReleaseFilter();
}

bool FcSwUpdateSrvProxy::hasReleaseFilter() const {
    return _releaseFilter.hasValue();
}

void FcSwUpdateSrvProxy::sendReleaseFilterDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ReleaseFilter");
    _dbusProxyDelegate->deregisterSignalCallback("ReleaseFilter", 0, _dbusDaemonProxy.get(), true);
}

act_t FcSwUpdateSrvProxy::sendReleaseDocRegister(ReleaseDocCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ReleaseDoc, "ReleaseDoc", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ReleaseDoc", &cb, act);
    return act;
}

bool FcSwUpdateSrvProxy::sendReleaseDocDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ReleaseDoc", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ReleaseDoc", act, static_cast<int>(rv));
    return rv;
}

act_t FcSwUpdateSrvProxy::sendReleaseDocGet(ReleaseDocCallbackIF& cb) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_ReleaseDoc, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ReleaseDoc", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ReleaseDoc", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void FcSwUpdateSrvProxy::sendReleaseDocSet(const trReleaseDoc& releaseDoc) {
    ReleaseDocSet parameter(releaseDoc);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "ReleaseDoc");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "ReleaseDoc", propertyContent);
}

act_t FcSwUpdateSrvProxy::sendReleaseDocSet(ReleaseDocCallbackIF& cb, const trReleaseDoc& releaseDoc) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_ReleaseDoc, &cb);
    ReleaseDocSet parameter(releaseDoc);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "ReleaseDoc", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "ReleaseDoc", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const trReleaseDoc& FcSwUpdateSrvProxy::getReleaseDoc() const {
    return _releaseDoc.get().getReleaseDoc();
}

bool FcSwUpdateSrvProxy::hasReleaseDoc() const {
    return _releaseDoc.hasValue();
}

void FcSwUpdateSrvProxy::sendReleaseDocDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ReleaseDoc");
    _dbusProxyDelegate->deregisterSignalCallback("ReleaseDoc", 0, _dbusDaemonProxy.get(), true);
}

act_t FcSwUpdateSrvProxy::sendPreReleaseDocRegister(PreReleaseDocCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_PreReleaseDoc, "PreReleaseDoc", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PreReleaseDoc", &cb, act);
    return act;
}

bool FcSwUpdateSrvProxy::sendPreReleaseDocDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PreReleaseDoc", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PreReleaseDoc", act, static_cast<int>(rv));
    return rv;
}

act_t FcSwUpdateSrvProxy::sendPreReleaseDocGet(PreReleaseDocCallbackIF& cb) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_PreReleaseDoc, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PreReleaseDoc", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("PreReleaseDoc", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void FcSwUpdateSrvProxy::sendPreReleaseDocSet(const trPreReleaseDoc& preReleaseDoc) {
    PreReleaseDocSet parameter(preReleaseDoc);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "PreReleaseDoc");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "PreReleaseDoc", propertyContent);
}

act_t FcSwUpdateSrvProxy::sendPreReleaseDocSet(PreReleaseDocCallbackIF& cb, const trPreReleaseDoc& preReleaseDoc) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_PreReleaseDoc, &cb);
    PreReleaseDocSet parameter(preReleaseDoc);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "PreReleaseDoc", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "PreReleaseDoc", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const trPreReleaseDoc& FcSwUpdateSrvProxy::getPreReleaseDoc() const {
    return _preReleaseDoc.get().getPreReleaseDoc();
}

bool FcSwUpdateSrvProxy::hasPreReleaseDoc() const {
    return _preReleaseDoc.hasValue();
}

void FcSwUpdateSrvProxy::sendPreReleaseDocDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PreReleaseDoc");
    _dbusProxyDelegate->deregisterSignalCallback("PreReleaseDoc", 0, _dbusDaemonProxy.get(), true);
}

act_t FcSwUpdateSrvProxy::sendUpdateProgressRegister(UpdateProgressCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_UpdateProgress, "UpdateProgress", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UpdateProgress", &cb, act);
    return act;
}

bool FcSwUpdateSrvProxy::sendUpdateProgressDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UpdateProgress", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UpdateProgress", act, static_cast<int>(rv));
    return rv;
}

act_t FcSwUpdateSrvProxy::sendUpdateProgressGet(UpdateProgressCallbackIF& cb) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_UpdateProgress, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "UpdateProgress", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("UpdateProgress", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void FcSwUpdateSrvProxy::sendUpdateProgressSet(const trUpdProgress& updateProgress) {
    UpdateProgressSet parameter(updateProgress);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "UpdateProgress");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "UpdateProgress", propertyContent);
}

act_t FcSwUpdateSrvProxy::sendUpdateProgressSet(UpdateProgressCallbackIF& cb, const trUpdProgress& updateProgress) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_UpdateProgress, &cb);
    UpdateProgressSet parameter(updateProgress);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "UpdateProgress", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "UpdateProgress", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const trUpdProgress& FcSwUpdateSrvProxy::getUpdateProgress() const {
    return _updateProgress.get().getUpdateProgress();
}

bool FcSwUpdateSrvProxy::hasUpdateProgress() const {
    return _updateProgress.hasValue();
}

void FcSwUpdateSrvProxy::sendUpdateProgressDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UpdateProgress");
    _dbusProxyDelegate->deregisterSignalCallback("UpdateProgress", 0, _dbusDaemonProxy.get(), true);
}

act_t FcSwUpdateSrvProxy::sendUpdateResultRegister(UpdateResultCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_UpdateResult, "UpdateResult", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UpdateResult", &cb, act);
    return act;
}

bool FcSwUpdateSrvProxy::sendUpdateResultDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UpdateResult", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UpdateResult", act, static_cast<int>(rv));
    return rv;
}

act_t FcSwUpdateSrvProxy::sendUpdateResultGet(UpdateResultCallbackIF& cb) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_UpdateResult, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "UpdateResult", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("UpdateResult", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void FcSwUpdateSrvProxy::sendUpdateResultSet(const trResult& updateResult) {
    UpdateResultSet parameter(updateResult);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "UpdateResult");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "UpdateResult", propertyContent);
}

act_t FcSwUpdateSrvProxy::sendUpdateResultSet(UpdateResultCallbackIF& cb, const trResult& updateResult) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_UpdateResult, &cb);
    UpdateResultSet parameter(updateResult);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "UpdateResult", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "UpdateResult", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const trResult& FcSwUpdateSrvProxy::getUpdateResult() const {
    return _updateResult.get().getUpdateResult();
}

bool FcSwUpdateSrvProxy::hasUpdateResult() const {
    return _updateResult.hasValue();
}

void FcSwUpdateSrvProxy::sendUpdateResultDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UpdateResult");
    _dbusProxyDelegate->deregisterSignalCallback("UpdateResult", 0, _dbusDaemonProxy.get(), true);
}

act_t FcSwUpdateSrvProxy::sendUpdateErrorsRegister(UpdateErrorsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_UpdateErrors, "UpdateErrors", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UpdateErrors", &cb, act);
    return act;
}

bool FcSwUpdateSrvProxy::sendUpdateErrorsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UpdateErrors", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UpdateErrors", act, static_cast<int>(rv));
    return rv;
}

act_t FcSwUpdateSrvProxy::sendUpdateErrorsGet(UpdateErrorsCallbackIF& cb) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_UpdateErrors, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "UpdateErrors", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("UpdateErrors", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void FcSwUpdateSrvProxy::sendUpdateErrorsSet(const trErrorIds& updateErrors) {
    UpdateErrorsSet parameter(updateErrors);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "UpdateErrors");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "UpdateErrors", propertyContent);
}

act_t FcSwUpdateSrvProxy::sendUpdateErrorsSet(UpdateErrorsCallbackIF& cb, const trErrorIds& updateErrors) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_UpdateErrors, &cb);
    UpdateErrorsSet parameter(updateErrors);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "UpdateErrors", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "UpdateErrors", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const trErrorIds& FcSwUpdateSrvProxy::getUpdateErrors() const {
    return _updateErrors.get().getUpdateErrors();
}

bool FcSwUpdateSrvProxy::hasUpdateErrors() const {
    return _updateErrors.hasValue();
}

void FcSwUpdateSrvProxy::sendUpdateErrorsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UpdateErrors");
    _dbusProxyDelegate->deregisterSignalCallback("UpdateErrors", 0, _dbusDaemonProxy.get(), true);
}

act_t FcSwUpdateSrvProxy::sendCustomerUpdatesRegister(CustomerUpdatesCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_CustomerUpdates, "CustomerUpdates", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CustomerUpdates", &cb, act);
    return act;
}

bool FcSwUpdateSrvProxy::sendCustomerUpdatesDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CustomerUpdates", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CustomerUpdates", act, static_cast<int>(rv));
    return rv;
}

act_t FcSwUpdateSrvProxy::sendCustomerUpdatesGet(CustomerUpdatesCallbackIF& cb) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_CustomerUpdates, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CustomerUpdates", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("CustomerUpdates", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void FcSwUpdateSrvProxy::sendCustomerUpdatesSet(const trInstalledCustomerUpdates& customerUpdates) {
    CustomerUpdatesSet parameter(customerUpdates);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "CustomerUpdates");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "CustomerUpdates", propertyContent);
}

act_t FcSwUpdateSrvProxy::sendCustomerUpdatesSet(CustomerUpdatesCallbackIF& cb, const trInstalledCustomerUpdates& customerUpdates) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_CustomerUpdates, &cb);
    CustomerUpdatesSet parameter(customerUpdates);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "CustomerUpdates", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "CustomerUpdates", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const trInstalledCustomerUpdates& FcSwUpdateSrvProxy::getCustomerUpdates() const {
    return _customerUpdates.get().getCustomerUpdates();
}

bool FcSwUpdateSrvProxy::hasCustomerUpdates() const {
    return _customerUpdates.hasValue();
}

void FcSwUpdateSrvProxy::sendCustomerUpdatesDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CustomerUpdates");
    _dbusProxyDelegate->deregisterSignalCallback("CustomerUpdates", 0, _dbusDaemonProxy.get(), true);
}

act_t FcSwUpdateSrvProxy::sendVersionBackDocInfoRegister(VersionBackDocInfoCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_VersionBackDocInfo, "VersionBackDocInfo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "VersionBackDocInfo", &cb, act);
    return act;
}

bool FcSwUpdateSrvProxy::sendVersionBackDocInfoDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("VersionBackDocInfo", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "VersionBackDocInfo", act, static_cast<int>(rv));
    return rv;
}

act_t FcSwUpdateSrvProxy::sendVersionBackDocInfoGet(VersionBackDocInfoCallbackIF& cb) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_VersionBackDocInfo, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "VersionBackDocInfo", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("VersionBackDocInfo", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void FcSwUpdateSrvProxy::sendVersionBackDocInfoSet(const trVersionBackDocInfo& versionBackDocInfo) {
    VersionBackDocInfoSet parameter(versionBackDocInfo);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "VersionBackDocInfo");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "VersionBackDocInfo", propertyContent);
}

act_t FcSwUpdateSrvProxy::sendVersionBackDocInfoSet(VersionBackDocInfoCallbackIF& cb, const trVersionBackDocInfo& versionBackDocInfo) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_VersionBackDocInfo, &cb);
    VersionBackDocInfoSet parameter(versionBackDocInfo);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "VersionBackDocInfo", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "VersionBackDocInfo", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const trVersionBackDocInfo& FcSwUpdateSrvProxy::getVersionBackDocInfo() const {
    return _versionBackDocInfo.get().getVersionBackDocInfo();
}

bool FcSwUpdateSrvProxy::hasVersionBackDocInfo() const {
    return _versionBackDocInfo.hasValue();
}

void FcSwUpdateSrvProxy::sendVersionBackDocInfoDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "VersionBackDocInfo");
    _dbusProxyDelegate->deregisterSignalCallback("VersionBackDocInfo", 0, _dbusDaemonProxy.get(), true);
}

act_t FcSwUpdateSrvProxy::sendAvailableCustomerUpdatesRegister(AvailableCustomerUpdatesCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_AvailableCustomerUpdates, "AvailableCustomerUpdates", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AvailableCustomerUpdates", &cb, act);
    return act;
}

bool FcSwUpdateSrvProxy::sendAvailableCustomerUpdatesDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AvailableCustomerUpdates", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AvailableCustomerUpdates", act, static_cast<int>(rv));
    return rv;
}

act_t FcSwUpdateSrvProxy::sendAvailableCustomerUpdatesGet(AvailableCustomerUpdatesCallbackIF& cb) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_AvailableCustomerUpdates, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AvailableCustomerUpdates", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("AvailableCustomerUpdates", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void FcSwUpdateSrvProxy::sendAvailableCustomerUpdatesSet(const trAvailableCustomerUpdates& availableCustomerUpdates) {
    AvailableCustomerUpdatesSet parameter(availableCustomerUpdates);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "AvailableCustomerUpdates");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "AvailableCustomerUpdates", propertyContent);
}

act_t FcSwUpdateSrvProxy::sendAvailableCustomerUpdatesSet(AvailableCustomerUpdatesCallbackIF& cb, const trAvailableCustomerUpdates& availableCustomerUpdates) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_AvailableCustomerUpdates, &cb);
    AvailableCustomerUpdatesSet parameter(availableCustomerUpdates);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "AvailableCustomerUpdates", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "AvailableCustomerUpdates", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const trAvailableCustomerUpdates& FcSwUpdateSrvProxy::getAvailableCustomerUpdates() const {
    return _availableCustomerUpdates.get().getAvailableCustomerUpdates();
}

bool FcSwUpdateSrvProxy::hasAvailableCustomerUpdates() const {
    return _availableCustomerUpdates.hasValue();
}

void FcSwUpdateSrvProxy::sendAvailableCustomerUpdatesDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AvailableCustomerUpdates");
    _dbusProxyDelegate->deregisterSignalCallback("AvailableCustomerUpdates", 0, _dbusDaemonProxy.get(), true);
}

act_t FcSwUpdateSrvProxy::sendUpdateBgImageInfoRegister(UpdateBgImageInfoCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_UpdateBgImageInfo, "UpdateBgImageInfo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UpdateBgImageInfo", &cb, act);
    return act;
}

bool FcSwUpdateSrvProxy::sendUpdateBgImageInfoDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UpdateBgImageInfo", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UpdateBgImageInfo", act, static_cast<int>(rv));
    return rv;
}

act_t FcSwUpdateSrvProxy::sendUpdateBgImageInfoGet(UpdateBgImageInfoCallbackIF& cb) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_UpdateBgImageInfo, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "UpdateBgImageInfo", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("UpdateBgImageInfo", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void FcSwUpdateSrvProxy::sendUpdateBgImageInfoSet(const trBgImageInfo& updateBgImageInfo) {
    UpdateBgImageInfoSet parameter(updateBgImageInfo);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "UpdateBgImageInfo");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "UpdateBgImageInfo", propertyContent);
}

act_t FcSwUpdateSrvProxy::sendUpdateBgImageInfoSet(UpdateBgImageInfoCallbackIF& cb, const trBgImageInfo& updateBgImageInfo) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_UpdateBgImageInfo, &cb);
    UpdateBgImageInfoSet parameter(updateBgImageInfo);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "UpdateBgImageInfo", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "UpdateBgImageInfo", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const trBgImageInfo& FcSwUpdateSrvProxy::getUpdateBgImageInfo() const {
    return _updateBgImageInfo.get().getUpdateBgImageInfo();
}

bool FcSwUpdateSrvProxy::hasUpdateBgImageInfo() const {
    return _updateBgImageInfo.hasValue();
}

void FcSwUpdateSrvProxy::sendUpdateBgImageInfoDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UpdateBgImageInfo");
    _dbusProxyDelegate->deregisterSignalCallback("UpdateBgImageInfo", 0, _dbusDaemonProxy.get(), true);
}

act_t FcSwUpdateSrvProxy::sendBgLocksStateRegister(BgLocksStateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_BgLocksState, "BgLocksState", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BgLocksState", &cb, act);
    return act;
}

bool FcSwUpdateSrvProxy::sendBgLocksStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BgLocksState", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BgLocksState", act, static_cast<int>(rv));
    return rv;
}

act_t FcSwUpdateSrvProxy::sendBgLocksStateGet(BgLocksStateCallbackIF& cb) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_BgLocksState, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "BgLocksState", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("BgLocksState", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void FcSwUpdateSrvProxy::sendBgLocksStateSet(const trBgLocksState& bgLocksState) {
    BgLocksStateSet parameter(bgLocksState);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "BgLocksState");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "BgLocksState", propertyContent);
}

act_t FcSwUpdateSrvProxy::sendBgLocksStateSet(BgLocksStateCallbackIF& cb, const trBgLocksState& bgLocksState) {
    FcSwUpdateSrvProxyCallback* callback = new FcSwUpdateSrvProxyCallback(ID_BgLocksState, &cb);
    BgLocksStateSet parameter(bgLocksState);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "BgLocksState", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "BgLocksState", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const trBgLocksState& FcSwUpdateSrvProxy::getBgLocksState() const {
    return _bgLocksState.get().getBgLocksState();
}

bool FcSwUpdateSrvProxy::hasBgLocksState() const {
    return _bgLocksState.hasValue();
}

void FcSwUpdateSrvProxy::sendBgLocksStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BgLocksState");
    _dbusProxyDelegate->deregisterSignalCallback("BgLocksState", 0, _dbusDaemonProxy.get(), true);
}

act_t FcSwUpdateSrvProxy::sendStoreHistoryToStickRequest(StoreHistoryToStickCallbackIF& cb, bool sinceFactoryReset, bool writeToAllSticks) const {
    StoreHistoryToStickRequest* payload = new StoreHistoryToStickRequest();
    CHECK_ALLOCATION(payload);
    payload->setSinceFactoryReset(sinceFactoryReset);
    payload->setWriteToAllSticks(writeToAllSticks);
    DBUS_MESSAGE_CALL(dbusMessage, "StoreHistoryToStick", StoreHistoryToStickRequest, payload, true)
    act_t act = addMethodCallback(ID_StoreHistoryToStick, dbusMessage.getUniqueSerial(), "StoreHistoryToStick", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StoreHistoryToStick", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendUpdateEnterRequest(UpdateEnterCallbackIF& cb, tenUser enUser) const {
    UpdateEnterRequest* payload = new UpdateEnterRequest();
    CHECK_ALLOCATION(payload);
    payload->setEnUser(enUser);
    DBUS_MESSAGE_CALL(dbusMessage, "UpdateEnter", UpdateEnterRequest, payload, true)
    act_t act = addMethodCallback(ID_UpdateEnter, dbusMessage.getUniqueSerial(), "UpdateEnter", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UpdateEnter", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendUpdateSetReleaseFilterRequest(UpdateSetReleaseFilterCallbackIF& cb, const trReleaseFilter& filter) const {
    UpdateSetReleaseFilterRequest* payload = new UpdateSetReleaseFilterRequest();
    CHECK_ALLOCATION(payload);
    payload->setFilter(filter);
    DBUS_MESSAGE_CALL(dbusMessage, "UpdateSetReleaseFilter", UpdateSetReleaseFilterRequest, payload, true)
    act_t act = addMethodCallback(ID_UpdateSetReleaseFilter, dbusMessage.getUniqueSerial(), "UpdateSetReleaseFilter", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UpdateSetReleaseFilter", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendUpdateGetSourcesRequest(UpdateGetSourcesCallbackIF& cb) const {
    UpdateGetSourcesRequest* payload = new UpdateGetSourcesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "UpdateGetSources", UpdateGetSourcesRequest, payload, true)
    act_t act = addMethodCallback(ID_UpdateGetSources, dbusMessage.getUniqueSerial(), "UpdateGetSources", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UpdateGetSources", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendUpdateSelectSourceRequest(UpdateSelectSourceCallbackIF& cb, uint32 sourceIndex) const {
    UpdateSelectSourceRequest* payload = new UpdateSelectSourceRequest();
    CHECK_ALLOCATION(payload);
    payload->setSourceIndex(sourceIndex);
    DBUS_MESSAGE_CALL(dbusMessage, "UpdateSelectSource", UpdateSelectSourceRequest, payload, true)
    act_t act = addMethodCallback(ID_UpdateSelectSource, dbusMessage.getUniqueSerial(), "UpdateSelectSource", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UpdateSelectSource", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendUpdateSelectReleaseRequest(UpdateSelectReleaseCallbackIF& cb, uint32 releaseIndex) const {
    UpdateSelectReleaseRequest* payload = new UpdateSelectReleaseRequest();
    CHECK_ALLOCATION(payload);
    payload->setReleaseIndex(releaseIndex);
    DBUS_MESSAGE_CALL(dbusMessage, "UpdateSelectRelease", UpdateSelectReleaseRequest, payload, true)
    act_t act = addMethodCallback(ID_UpdateSelectRelease, dbusMessage.getUniqueSerial(), "UpdateSelectRelease", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UpdateSelectRelease", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendGetDeviceStateListRequest(GetDeviceStateListCallbackIF& cb) const {
    GetDeviceStateListRequest* payload = new GetDeviceStateListRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetDeviceStateList", GetDeviceStateListRequest, payload, true)
    act_t act = addMethodCallback(ID_GetDeviceStateList, dbusMessage.getUniqueSerial(), "GetDeviceStateList", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetDeviceStateList", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendSetUpdateOptionsRequest(SetUpdateOptionsCallbackIF& cb, tenUpdOptions enOption) const {
    SetUpdateOptionsRequest* payload = new SetUpdateOptionsRequest();
    CHECK_ALLOCATION(payload);
    payload->setEnOption(enOption);
    DBUS_MESSAGE_CALL(dbusMessage, "SetUpdateOptions", SetUpdateOptionsRequest, payload, true)
    act_t act = addMethodCallback(ID_SetUpdateOptions, dbusMessage.getUniqueSerial(), "SetUpdateOptions", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetUpdateOptions", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendModifyReleaseDocRequest(ModifyReleaseDocCallbackIF& cb, const trModifyAction& enModifyAction) const {
    ModifyReleaseDocRequest* payload = new ModifyReleaseDocRequest();
    CHECK_ALLOCATION(payload);
    payload->setEnModifyAction(enModifyAction);
    DBUS_MESSAGE_CALL(dbusMessage, "ModifyReleaseDoc", ModifyReleaseDocRequest, payload, true)
    act_t act = addMethodCallback(ID_ModifyReleaseDoc, dbusMessage.getUniqueSerial(), "ModifyReleaseDoc", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ModifyReleaseDoc", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendGetUpdateFileRequest(GetUpdateFileCallbackIF& cb) const {
    GetUpdateFileRequest* payload = new GetUpdateFileRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetUpdateFile", GetUpdateFileRequest, payload, true)
    act_t act = addMethodCallback(ID_GetUpdateFile, dbusMessage.getUniqueSerial(), "GetUpdateFile", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetUpdateFile", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendApplyDocRequest(ApplyDocCallbackIF& cb) const {
    ApplyDocRequest* payload = new ApplyDocRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "ApplyDoc", ApplyDocRequest, payload, true)
    act_t act = addMethodCallback(ID_ApplyDoc, dbusMessage.getUniqueSerial(), "ApplyDoc", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ApplyDoc", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendApplyLockRequest(ApplyLockCallbackIF& cb) const {
    ApplyLockRequest* payload = new ApplyLockRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "ApplyLock", ApplyLockRequest, payload, true)
    act_t act = addMethodCallback(ID_ApplyLock, dbusMessage.getUniqueSerial(), "ApplyLock", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ApplyLock", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendUpdateSelectReleaseByFileRequest(UpdateSelectReleaseByFileCallbackIF& cb, const trReleaseAccess& releaseAccess) const {
    UpdateSelectReleaseByFileRequest* payload = new UpdateSelectReleaseByFileRequest();
    CHECK_ALLOCATION(payload);
    payload->setReleaseAccess(releaseAccess);
    DBUS_MESSAGE_CALL(dbusMessage, "UpdateSelectReleaseByFile", UpdateSelectReleaseByFileRequest, payload, true)
    act_t act = addMethodCallback(ID_UpdateSelectReleaseByFile, dbusMessage.getUniqueSerial(), "UpdateSelectReleaseByFile", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UpdateSelectReleaseByFile", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendRetryFailedModulesRequest(RetryFailedModulesCallbackIF& cb) const {
    RetryFailedModulesRequest* payload = new RetryFailedModulesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "RetryFailedModules", RetryFailedModulesRequest, payload, true)
    act_t act = addMethodCallback(ID_RetryFailedModules, dbusMessage.getUniqueSerial(), "RetryFailedModules", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RetryFailedModules", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendUpdateEndRequest(UpdateEndCallbackIF& cb) const {
    UpdateEndRequest* payload = new UpdateEndRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "UpdateEnd", UpdateEndRequest, payload, true)
    act_t act = addMethodCallback(ID_UpdateEnd, dbusMessage.getUniqueSerial(), "UpdateEnd", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UpdateEnd", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendUpdateAbortRequest(UpdateAbortCallbackIF& cb, bool bDeviceOnly) const {
    UpdateAbortRequest* payload = new UpdateAbortRequest();
    CHECK_ALLOCATION(payload);
    payload->setBDeviceOnly(bDeviceOnly);
    DBUS_MESSAGE_CALL(dbusMessage, "UpdateAbort", UpdateAbortRequest, payload, true)
    act_t act = addMethodCallback(ID_UpdateAbort, dbusMessage.getUniqueSerial(), "UpdateAbort", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UpdateAbort", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendUpdateAbortDeviceRequest(UpdateAbortDeviceCallbackIF& cb, const ::std::string& refKey) const {
    UpdateAbortDeviceRequest* payload = new UpdateAbortDeviceRequest();
    CHECK_ALLOCATION(payload);
    payload->setRefKey(refKey);
    DBUS_MESSAGE_CALL(dbusMessage, "UpdateAbortDevice", UpdateAbortDeviceRequest, payload, true)
    act_t act = addMethodCallback(ID_UpdateAbortDevice, dbusMessage.getUniqueSerial(), "UpdateAbortDevice", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UpdateAbortDevice", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendHandleErrorRequest(HandleErrorCallbackIF& cb, tenErrorHandlingMode enMode) const {
    HandleErrorRequest* payload = new HandleErrorRequest();
    CHECK_ALLOCATION(payload);
    payload->setEnMode(enMode);
    DBUS_MESSAGE_CALL(dbusMessage, "HandleError", HandleErrorRequest, payload, true)
    act_t act = addMethodCallback(ID_HandleError, dbusMessage.getUniqueSerial(), "HandleError", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "HandleError", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendGetUpdateHistoryRequest(GetUpdateHistoryCallbackIF& cb) const {
    GetUpdateHistoryRequest* payload = new GetUpdateHistoryRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetUpdateHistory", GetUpdateHistoryRequest, payload, true)
    act_t act = addMethodCallback(ID_GetUpdateHistory, dbusMessage.getUniqueSerial(), "GetUpdateHistory", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetUpdateHistory", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendGetUpdateHistoryScopedRequest(GetUpdateHistoryScopedCallbackIF& cb, tenHistoryScope enScope, uint32 indexStart, uint32 numEntriesMax) const {
    GetUpdateHistoryScopedRequest* payload = new GetUpdateHistoryScopedRequest();
    CHECK_ALLOCATION(payload);
    payload->setEnScope(enScope);
    payload->setIndexStart(indexStart);
    payload->setNumEntriesMax(numEntriesMax);
    DBUS_MESSAGE_CALL(dbusMessage, "GetUpdateHistoryScoped", GetUpdateHistoryScopedRequest, payload, true)
    act_t act = addMethodCallback(ID_GetUpdateHistoryScoped, dbusMessage.getUniqueSerial(), "GetUpdateHistoryScoped", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetUpdateHistoryScoped", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendGetUpdateHistoryDetailedRequest(GetUpdateHistoryDetailedCallbackIF& cb, const trGetUpdateHistoryDetailedRequest& request) const {
    GetUpdateHistoryDetailedRequest* payload = new GetUpdateHistoryDetailedRequest();
    CHECK_ALLOCATION(payload);
    payload->setRequest(request);
    DBUS_MESSAGE_CALL(dbusMessage, "GetUpdateHistoryDetailed", GetUpdateHistoryDetailedRequest, payload, true)
    act_t act = addMethodCallback(ID_GetUpdateHistoryDetailed, dbusMessage.getUniqueSerial(), "GetUpdateHistoryDetailed", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetUpdateHistoryDetailed", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendDeleteHistoryRequestRequest(DeleteHistoryRequestCallbackIF& cb, bool sinceFactoryResetOnly) const {
    DeleteHistoryRequestRequest* payload = new DeleteHistoryRequestRequest();
    CHECK_ALLOCATION(payload);
    payload->setSinceFactoryResetOnly(sinceFactoryResetOnly);
    DBUS_MESSAGE_CALL(dbusMessage, "DeleteHistoryRequest", DeleteHistoryRequestRequest, payload, true)
    act_t act = addMethodCallback(ID_DeleteHistoryRequest, dbusMessage.getUniqueSerial(), "DeleteHistoryRequest", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DeleteHistoryRequest", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendGetTargetStateRequest(GetTargetStateCallbackIF& cb, tenUpdType enUpdateType) const {
    GetTargetStateRequest* payload = new GetTargetStateRequest();
    CHECK_ALLOCATION(payload);
    payload->setEnUpdateType(enUpdateType);
    DBUS_MESSAGE_CALL(dbusMessage, "GetTargetState", GetTargetStateRequest, payload, true)
    act_t act = addMethodCallback(ID_GetTargetState, dbusMessage.getUniqueSerial(), "GetTargetState", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetTargetState", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendSetVersionBackDocAckRequest(SetVersionBackDocAckCallbackIF& cb, uint16 ack) const {
    SetVersionBackDocAckRequest* payload = new SetVersionBackDocAckRequest();
    CHECK_ALLOCATION(payload);
    payload->setAck(ack);
    DBUS_MESSAGE_CALL(dbusMessage, "SetVersionBackDocAck", SetVersionBackDocAckRequest, payload, true)
    act_t act = addMethodCallback(ID_SetVersionBackDocAck, dbusMessage.getUniqueSerial(), "SetVersionBackDocAck", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetVersionBackDocAck", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendSetAllowRecoveryModeRequest(SetAllowRecoveryModeCallbackIF& cb, bool allow) const {
    SetAllowRecoveryModeRequest* payload = new SetAllowRecoveryModeRequest();
    CHECK_ALLOCATION(payload);
    payload->setAllow(allow);
    DBUS_MESSAGE_CALL(dbusMessage, "SetAllowRecoveryMode", SetAllowRecoveryModeRequest, payload, true)
    act_t act = addMethodCallback(ID_SetAllowRecoveryMode, dbusMessage.getUniqueSerial(), "SetAllowRecoveryMode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetAllowRecoveryMode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendGetCacheDirectoryRequest(GetCacheDirectoryCallbackIF& cb, const trGetCacheDirectory& request) const {
    GetCacheDirectoryRequest* payload = new GetCacheDirectoryRequest();
    CHECK_ALLOCATION(payload);
    payload->setRequest(request);
    DBUS_MESSAGE_CALL(dbusMessage, "GetCacheDirectory", GetCacheDirectoryRequest, payload, true)
    act_t act = addMethodCallback(ID_GetCacheDirectory, dbusMessage.getUniqueSerial(), "GetCacheDirectory", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetCacheDirectory", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendEnterRecoveryModeRequest(EnterRecoveryModeCallbackIF& cb) const {
    EnterRecoveryModeRequest* payload = new EnterRecoveryModeRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "EnterRecoveryMode", EnterRecoveryModeRequest, payload, true)
    act_t act = addMethodCallback(ID_EnterRecoveryMode, dbusMessage.getUniqueSerial(), "EnterRecoveryMode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EnterRecoveryMode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendVerifyChecksumRequest(VerifyChecksumCallbackIF& cb, const trVerifyChecksumRequest& verifyRequest) const {
    VerifyChecksumRequest* payload = new VerifyChecksumRequest();
    CHECK_ALLOCATION(payload);
    payload->setVerifyRequest(verifyRequest);
    DBUS_MESSAGE_CALL(dbusMessage, "VerifyChecksum", VerifyChecksumRequest, payload, true)
    act_t act = addMethodCallback(ID_VerifyChecksum, dbusMessage.getUniqueSerial(), "VerifyChecksum", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "VerifyChecksum", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcSwUpdateSrvProxy::sendRegisterBgLocksRequest(RegisterBgLocksCallbackIF& cb, const trBgLocks& locks, tenLockRegisterMode mode) const {
    RegisterBgLocksRequest* payload = new RegisterBgLocksRequest();
    CHECK_ALLOCATION(payload);
    payload->setLocks(locks);
    payload->setMode(mode);
    DBUS_MESSAGE_CALL(dbusMessage, "RegisterBgLocks", RegisterBgLocksRequest, payload, true)
    act_t act = addMethodCallback(ID_RegisterBgLocks, dbusMessage.getUniqueSerial(), "RegisterBgLocks", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RegisterBgLocks", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace FcSwUpdateSrv
} // namespace fcswupdatesrv
