#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef FCSWUPDATELOOPBACKSRV_FCSWUPDATELOOPBACKSRV_H
#define FCSWUPDATELOOPBACKSRV_FCSWUPDATELOOPBACKSRV_H

#include "asf/cms/CmsTypes.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include <cstring>

/**
 * The CourierMessageReceiver service is a bridge between
 * the courier message framework and ASF.
 */

namespace fcswupdateloopbacksrv {
namespace FcSwUpdateLoopBackSrv {

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

static const int RECEIVE_LOOPBACK_MESSAGE__ID = -1236156775;

// forward declarations
class ReceiveLoopbackMessageRequest;

// type definitions
/**
 * Sends a courier message from the client to the service provider
 */
typedef ::asf::cms::CmsTypes::BaseError ReceiveLoopbackMessageError;


/**
 * Sends a courier message from the client to the service provider
 */
class ReceiveLoopbackMessageRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReceiveLoopbackMessageRequest ();

    /**
     * Copy constructor
     */
    inline  ReceiveLoopbackMessageRequest (const ReceiveLoopbackMessageRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReceiveLoopbackMessageRequest (uint64 pMsg_);

    /**
     * Destructor
     */
    inline virtual  ~ReceiveLoopbackMessageRequest();

    /**
     * Assignment operator
     */
    inline ReceiveLoopbackMessageRequest& operator = (const ReceiveLoopbackMessageRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReceiveLoopbackMessageRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReceiveLoopbackMessageRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReceiveLoopbackMessageRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReceiveLoopbackMessageRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pMsg"

    static const int kPMsg = 0;

    /**
     * Clears the field "pMsg".
     *
     * The field will be set to its default value. The hasPMsg()
     * method will return false.
     */
    inline void clearPMsg();

    /**
     * Checks whether the field "pMsg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPMsg()). Otherwise it will return false.
     */
    inline bool hasPMsg () const;

    /**
     * Returns the value of the member "pMsg".
     *
     * If the meaning of "pMsg" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pMsg"
     */
    inline uint64 getPMsg () const;

    /**
     * Sets the value of the member "pMsg".
     *
     * If the meaning of "pMsg" isn't clear, then there should be a description here.
     *
     * @param pMsg The value which will be set
     */
    inline void setPMsg (uint64 pMsg_);

    static const ReceiveLoopbackMessageRequest &getDefaultInstance();

private:

    inline void set_has_pMsg ();

    inline void clear_has_pMsg ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _pMsg;

};

inline  ReceiveLoopbackMessageRequest::ReceiveLoopbackMessageRequest ()  :
    _pMsg (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReceiveLoopbackMessageRequest::ReceiveLoopbackMessageRequest (const ReceiveLoopbackMessageRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _pMsg (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReceiveLoopbackMessageRequest::ReceiveLoopbackMessageRequest (uint64 pMsg_)  :
    _pMsg (pMsg_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReceiveLoopbackMessageRequest::~ReceiveLoopbackMessageRequest() {
}

inline ReceiveLoopbackMessageRequest& ReceiveLoopbackMessageRequest::operator = (const ReceiveLoopbackMessageRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPMsg()) {
            setPMsg(rhs.getPMsg());
        } else {
            clearPMsg();
        }
    }
    return *this;
}

inline bool ReceiveLoopbackMessageRequest::operator == (const ReceiveLoopbackMessageRequest& rhs) const {
    return (((!hasPMsg() && !rhs.hasPMsg()) || getPMsg() == rhs.getPMsg()));
}

inline bool ReceiveLoopbackMessageRequest::operator != (const ReceiveLoopbackMessageRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReceiveLoopbackMessageRequest::operator < (const ReceiveLoopbackMessageRequest& rhs) const {
    if (hasPMsg() || rhs.hasPMsg()) {
        if (getPMsg() < rhs.getPMsg()) return true;
        if (getPMsg() > rhs.getPMsg()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReceiveLoopbackMessageRequest::clone() {
    return new ReceiveLoopbackMessageRequest(*this);
}

inline bool ReceiveLoopbackMessageRequest::operator > (const ReceiveLoopbackMessageRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReceiveLoopbackMessageRequest::clear() {
    clearPMsg();
}

inline void ReceiveLoopbackMessageRequest::clearPMsg() {
    if (hasPMsg()) {
         clear_has_pMsg();
        _pMsg = 0u;
     }
}

inline bool ReceiveLoopbackMessageRequest::hasPMsg () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint64 ReceiveLoopbackMessageRequest::getPMsg () const {
    return _pMsg;
}

inline void ReceiveLoopbackMessageRequest::setPMsg (uint64 pMsg_) {
    set_has_pMsg();
    this->_pMsg = pMsg_;
}

inline void ReceiveLoopbackMessageRequest::set_has_pMsg () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReceiveLoopbackMessageRequest::clear_has_pMsg () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace FcSwUpdateLoopBackSrv
} // namespace fcswupdateloopbacksrv

#endif // FCSWUPDATELOOPBACKSRV_FCSWUPDATELOOPBACKSRV_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
