/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include "fc_dataservices/Server/DataservicesApplication.h"
#include "fc_dataservices/Server/DataservicesComponent.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "DataservicesApplication" isn't clear, then there should be a description here.
 */

namespace fc_dataservices {
namespace Server {

DEFINE_LOGGER_AND_LEVEL (_logger, "/fc_dataservices/Server/DataservicesApplication", Info);

/* static */ const char* DataservicesApplication::ServThread = "ServThread";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool DataservicesApplication_enabledASFSignalHandler = false;

void importDataservicesApplication() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach DataservicesApplication, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSysConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSysConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSysConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSysConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSysConnector_(new ::asf::dbus::DBusConnector(*app, dbusSysConnector));
    app->addStarter(dbusSysConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusConnector_(new ::asf::dbus::DBusConnector(*app, dbusConnector));
    app->addStarter(dbusConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression2;
        {
            __expression2.setApplicationId(207);
        }
        ccaConnector = __expression2;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Thread 'thread1'

    ::asf::core::ComponentContainerSharedPtr Thread1(new ::asf::core::ComponentContainer("thread1", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (Thread1);

        // Component 'DataservicesComponent ServThread'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::fc_dataservices::Server::DataservicesComponent > > servThreadFactory(new ::asf::core::ComponentFactory< ::fc_dataservices::Server::DataservicesComponent >);
        ::asf::core::ComponentDescriptionSharedPtr servThreadDescription(new ::asf::core::ComponentDescription(1, "ServThread", /* immediate = */ true, /* threadBridge = */ false, servThreadFactory));
        Thread1->addComponentDescription(servThreadDescription);

            // Port 'CommPort'

            ::asf::core::ProvidedPort& ServThread_CommPort = servThreadDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.DataServices", "CommPort", false, false));
            (void)ServThread_CommPort; // prevent unused variable warning

            // Port 'ccaFIPort'

            ::asf::core::RequiredPort& ServThread_ccaFIPort = servThreadDescription->addRequiredPort (::asf::core::RequiredPort ("MIDW_EXT_DABTUNER_FI", "ccaFIPort"));
            (void)ServThread_ccaFIPort; // prevent unused variable warning

            // Port 'ConsumerPort'

            ::asf::core::RequiredPort& ServThread_ConsumerPort = servThreadDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.Consumer", "ConsumerPort"));
            (void)ServThread_ConsumerPort; // prevent unused variable warning

            // Port 'LifeCycleConsumerPort'

            ::asf::core::ProvidedPort& ServThread_LifeCycleConsumerPort = servThreadDescription->addProvidedPort (::asf::core::ProvidedPort ("org.genivi.NodeStateManager.LifeCycleConsumer", "LifeCycleConsumerPort", false, false));
            (void)ServThread_LifeCycleConsumerPort; // prevent unused variable warning

    // Expression

    dbusConnector_->exportByName (ServThread_CommPort, ::std::string("/org/bosch/cm/reception/Dataservices"));

    // Expression

    dbusSysConnector_->exportByName (ServThread_LifeCycleConsumerPort, ::std::string("/org/genivi/NodeStateManager/LifeCycleConsumer/DataservicesApplication"));

    // Expression

    ::asf::cca::CcaImportedPort& ccaFiImport = ccaConnector_->importByName (46, 2, 0, 2);
    ccaFiImport.setServiceName("MIDW_EXT_DABTUNER_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (ServThread_ccaFIPort, ccaFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmConsumer = dbusSysConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/Consumer"));
    LcmConsumer.setServiceName("org.genivi.NodeStateManager.Consumer");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (ServThread_ConsumerPort, LcmConsumer);


    LOG_INFO_STATIC("Starting application 'DataservicesApplication' version 1.0.0");

    app->start();
}

int executeDataservicesApplication(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("fc_dataservices.Server", "DataservicesApplication");
    } else {
        ::asf::core::Logger::setupLogging ("fc_dataservices.Server", "DataservicesApplication", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", DataservicesApplication_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("fc_dataservices.Server", "DataservicesApplication", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create DataservicesApplication");

    app->enableExceptionHandler(false);

    importDataservicesApplication();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace Server
} // namespace fc_dataservices

int main(int argc, char* argv[]) {
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::fc_dataservices::Server::executeDataservicesApplication(argc, argv);
}

