/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/SystemAdapterFactoryService.h"
#include "asf/SystemAdapterFactoryServiceJson.h"
#include "asf/SystemAdapterFactoryServiceStub.h"
#include "asf/SystemAdapterFactoryServiceStubConnector.h"
#include "asf/cms/CmsStubDelegate.h"
#include "asf/core/Types.h"
#include "boost/shared_ptr.hpp"
#include <string>

/**
 * If the meaning of "SystemAdapterFactoryService" isn't clear, then there should be a description here.
 */

namespace asf {
namespace SystemAdapterFactoryService {

DEFINE_CLASS_LOGGER("/asf/SystemAdapterFactoryService", SystemAdapterFactoryServiceStub);

SystemAdapterFactoryServiceStub::SystemAdapterFactoryServiceStub(const std::string& portName) :
    Stub(portName),
    _stubConnector(new SystemAdapterFactoryServiceStubConnector()),
    _cmsStubDelegate(new ::asf::cms::CmsStubDelegate( "SystemAdapterFactoryService", this, _stubConnector)) {
        CHECK_ALLOCATION(_stubConnector);
        CHECK_ALLOCATION(_cmsStubDelegate);
}

SystemAdapterFactoryServiceStub::~SystemAdapterFactoryServiceStub() {
    delete _stubConnector;
    delete _cmsStubDelegate;
}

// request registerModule

void SystemAdapterFactoryServiceStub::sendRegisterModuleResponse (const ::std::string& moduleName, uint32 result, act_t act) {
    ::boost::shared_ptr< RegisterModuleResponse > obj(new RegisterModuleResponse(moduleName, result));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "RegisterModule", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendResponse("registerModule", obj, act);
}

// request createSystemAdapter

void SystemAdapterFactoryServiceStub::sendCreateSystemAdapterResponse (uint32 iid, uint32 result, act_t act) {
    ::boost::shared_ptr< CreateSystemAdapterResponse > obj(new CreateSystemAdapterResponse(iid, result));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "CreateSystemAdapter", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendResponse("createSystemAdapter", obj, act);
}

} // namespace SystemAdapterFactoryService
} // namespace asf
