/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ASF_SYSTEMADAPTERFACTORYSERVICEPROXY_H
#define ASF_SYSTEMADAPTERFACTORYSERVICEPROXY_H

#include "asf/SystemAdapterFactoryService.h"
#include "asf/SystemAdapterFactoryServiceJson.h"
#include "asf/SystemAdapterFactoryServiceProxyStreamerCmsBin.h"
#include "asf/SystemAdapterFactoryServiceProxyStreamerJson.h"
#include "asf/cms/CmsProxyDelegate.h"
#include "asf/cms/CmsTypesJson.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "boost/shared_ptr.hpp"
#include <string>
#include <vector>

namespace asf {
namespace SystemAdapterFactoryService {

/**
 * If the meaning of "SystemAdapterFactoryService" isn't clear, then there should be a description here.
 */



class SystemAdapterFactoryServiceProxy;

class RegisterModuleCallbackIF
{
public:

    RegisterModuleCallbackIF() {}

    virtual ~RegisterModuleCallbackIF() {}

    virtual void onRegisterModuleResponse(const ::boost::shared_ptr< SystemAdapterFactoryServiceProxy >& proxy, const ::boost::shared_ptr< RegisterModuleResponse >& response) = 0;

    virtual void onRegisterModuleError(const ::boost::shared_ptr< SystemAdapterFactoryServiceProxy >& proxy, const ::boost::shared_ptr< RegisterModuleError >& error) = 0;
};

class CreateSystemAdapterCallbackIF
{
public:

    CreateSystemAdapterCallbackIF() {}

    virtual ~CreateSystemAdapterCallbackIF() {}

    virtual void onCreateSystemAdapterResponse(const ::boost::shared_ptr< SystemAdapterFactoryServiceProxy >& proxy, const ::boost::shared_ptr< CreateSystemAdapterResponse >& response) = 0;

    virtual void onCreateSystemAdapterError(const ::boost::shared_ptr< SystemAdapterFactoryServiceProxy >& proxy, const ::boost::shared_ptr< CreateSystemAdapterError >& error) = 0;
};

class SystemAdapterFactoryServiceClientBase
:     public CreateSystemAdapterCallbackIF,
    public RegisterModuleCallbackIF
{
public:

    virtual ~SystemAdapterFactoryServiceClientBase() {}


    virtual void onRegisterModuleResponse(const ::boost::shared_ptr< SystemAdapterFactoryServiceProxy >& /*proxy*/, const ::boost::shared_ptr< RegisterModuleResponse >& /*response*/) {
        LOG_FATAL("on%sResponse() is not implemented yet", "RegisterModule");
    }

    virtual void onRegisterModuleError(const ::boost::shared_ptr< SystemAdapterFactoryServiceProxy >& /*proxy*/, const ::boost::shared_ptr< RegisterModuleError >& error) {
        switch(error->getField()) {
        case ::asf::cms::CmsTypes::BaseError::E_SYSTEM_ERROR:
            LOG_FATAL("on%sError (%s) is not implemented yet", "RegisterModule", "E_SYSTEM_ERROR");
            break;
        default:
            break;
        }
    }

    virtual void onCreateSystemAdapterResponse(const ::boost::shared_ptr< SystemAdapterFactoryServiceProxy >& /*proxy*/, const ::boost::shared_ptr< CreateSystemAdapterResponse >& /*response*/) {
        LOG_FATAL("on%sResponse() is not implemented yet", "CreateSystemAdapter");
    }

    virtual void onCreateSystemAdapterError(const ::boost::shared_ptr< SystemAdapterFactoryServiceProxy >& /*proxy*/, const ::boost::shared_ptr< CreateSystemAdapterError >& error) {
        switch(error->getField()) {
        case ::asf::cms::CmsTypes::BaseError::E_SYSTEM_ERROR:
            LOG_FATAL("on%sError (%s) is not implemented yet", "CreateSystemAdapter", "E_SYSTEM_ERROR");
            break;
        default:
            break;
        }
    }

private:

    DECLARE_CLASS_LOGGER();
};

/**
 * SystemAdapterFactoryServiceProxy is the client side representation of
 * the 'SystemAdapterFactoryService' Car Multimedia Service. The interface
 * is specified in the file 'SystemAdapterFactoryService.cms'.
 */
class SystemAdapterFactoryServiceProxy : public ::asf::cms::CmsProxy
{
public:

    /**
     * Create a new instance of SystemAdapterFactoryServiceProxy. The caller
     * has to pass the port name. The port name is defined in the "Car
     * Multimedia Component" model. With the help of the port name it is
     * possible to address the concrete proxy, which is defined in the CMC
     * model description. Additionally it is necessary to pass a reference on
     * a implementation of the ServiceAvailableIF interface.
     */
    static ::boost::shared_ptr< SystemAdapterFactoryServiceProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of SystemAdapterFactoryServiceProxy. The caller
     * has to pass the port name and the address of the service (e.g.
     * cms-json://localhost:12345). It is only possible to use this function
     * if the port is defined in the CMC model as "wired at runtime"-port.
     * Additionally it is necessary to pass a reference on a implementation of
     * the ServiceAvailableIF interface.
     */
    static ::boost::shared_ptr< SystemAdapterFactoryServiceProxy > createProxy(const std::string& portName, const std::string& uriAddress, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of SystemAdapterFactoryServiceProxy. The destructor will
     * send messages for all existing property notifications. Additionally it
     * will call the error callback of all pending method invocations.
     */
    virtual ~SystemAdapterFactoryServiceProxy();

    // Request 'registerModule'

    /**
     * Call the Request 'registerModule'. This method sends a Request message
     * to the  CMS (Car Multimedia Service) server.
     *
     * <b>Documentation of 'registerModule'</b>:
     *
     * If the meaning of "registerModule" isn't clear, then there should be a description here.
     *
     * @param cb This callback will be called when a Response or Error message
     * is received.
     *
     * @param moduleName If the meaning of "moduleName" isn't clear, then there should be a description here.
     *
     * @param iidList If the meaning of "iidList" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRegisterModuleRequest(RegisterModuleCallbackIF& cb, const ::std::string& moduleName, const ::std::vector< uint32 >& iidList);

    // Request 'createSystemAdapter'

    /**
     * Call the Request 'createSystemAdapter'. This method sends a Request
     * message to the  CMS (Car Multimedia Service) server.
     *
     * <b>Documentation of 'createSystemAdapter'</b>:
     *
     * If the meaning of "createSystemAdapter" isn't clear, then there should be a description here.
     *
     * @param cb This callback will be called when a Response or Error message
     * is received.
     *
     * @param iid If the meaning of "iid" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCreateSystemAdapterRequest(CreateSystemAdapterCallbackIF& cb, uint32 iid);

    ::asf::cms::CmsServiceStreamer* getStreamer();

private:

    SystemAdapterFactoryServiceProxy (const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);


    static void registerModuleRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg);

    static void createSystemAdapterRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg);

    SystemAdapterFactoryServiceProxyStreamerJson _streamerJson;

    SystemAdapterFactoryServiceProxyStreamerCmsBin _streamerCmsBin;

    DECLARE_CLASS_LOGGER();
};

} // namespace SystemAdapterFactoryService
} // namespace asf

#endif // ASF_SYSTEMADAPTERFACTORYSERVICEPROXY_H
