/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/SystemAdapterFactoryService.h"
#include "asf/SystemAdapterFactoryServiceProxy.h"
#include "asf/cms/CmsProxyRegistry.h"
#include "asf/core/Types.h"
#include "boost/shared_ptr.hpp"
#include <string>
#include <vector>

namespace asf {
namespace SystemAdapterFactoryService {

DEFINE_CLASS_LOGGER("/asf/SystemAdapterFactoryService", SystemAdapterFactoryServiceProxy);
DEFINE_CLASS_LOGGER("/asf/SystemAdapterFactoryService", SystemAdapterFactoryServiceClientBase);


// static
::boost::shared_ptr< SystemAdapterFactoryServiceProxy > SystemAdapterFactoryServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cms::CmsProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<SystemAdapterFactoryServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    // create new proxy object
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< SystemAdapterFactoryServiceProxy >  proxyNew(new SystemAdapterFactoryServiceProxy(portName,serviceAvailable));
    ::asf::cms::CmsProxyRegistry::getInstance().registerProxy(proxyNew);
    return proxyNew;
}

// static
::boost::shared_ptr< SystemAdapterFactoryServiceProxy > SystemAdapterFactoryServiceProxy::createProxy(const std::string& portName, const std::string& uriAddress, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    // create new proxy object
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< SystemAdapterFactoryServiceProxy >  proxyNew(new SystemAdapterFactoryServiceProxy(portName,serviceAvailable));
    ::asf::cms::CmsProxyRegistry::getInstance().registerProxy(proxyNew, uriAddress);
    return proxyNew;
}

SystemAdapterFactoryServiceProxy::SystemAdapterFactoryServiceProxy (const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    CmsProxy(portName,serviceAvailable, "asf.SystemAdapterFactoryService", _logger) {
    LOG_INFO ("Create proxy=%p, compId=%d, portName='%s'", this, _cmsProxyDelegate.getClientComponentId(), getPortName().c_str());
}

SystemAdapterFactoryServiceProxy::~SystemAdapterFactoryServiceProxy () {
    ::asf::cms::CmsProxyRegistry::getInstance().deregisterProxy(_cmsProxyDelegate.getProxyId());
}

act_t SystemAdapterFactoryServiceProxy::sendRegisterModuleRequest(RegisterModuleCallbackIF& cb, const ::std::string& moduleName, const ::std::vector< uint32 >& iidList) {
    ::boost::shared_ptr< RegisterModuleRequest > para(new RegisterModuleRequest(moduleName, iidList));
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"registerModule",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)registerModuleRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "RegisterModule", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t SystemAdapterFactoryServiceProxy::sendCreateSystemAdapterRequest(CreateSystemAdapterCallbackIF& cb, uint32 iid) {
    ::boost::shared_ptr< CreateSystemAdapterRequest > para(new CreateSystemAdapterRequest(iid));
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"createSystemAdapter",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)createSystemAdapterRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "CreateSystemAdapter", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

::asf::cms::CmsServiceStreamer* SystemAdapterFactoryServiceProxy::getStreamer() {
    ::asf::cms::CmsServiceStreamer* streamer=0;
    switch(_cmsProxyDelegate.getEncoding()) {
        case ::com::bosch::cm::asf::lang::cms::Connectors::Encoding__Json:
            streamer=&_streamerJson;
            break;
        case ::com::bosch::cm::asf::lang::cms::Connectors::Encoding__FastBin:
            streamer=&_streamerCmsBin;
            break;
        default:
            streamer=0;
            break;
    }
    return streamer;
}

// static
void SystemAdapterFactoryServiceProxy::registerModuleRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    RegisterModuleCallbackIF* pcb = static_cast< RegisterModuleCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< SystemAdapterFactoryServiceProxy >& proxyShared = ::boost::static_pointer_cast< SystemAdapterFactoryServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< RegisterModuleResponse > payload = ::boost::static_pointer_cast< RegisterModuleResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterModule", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onRegisterModuleResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< RegisterModuleError > error(new RegisterModuleError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< RegisterModuleError > error = ::boost::static_pointer_cast< RegisterModuleError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterModule", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onRegisterModuleError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void SystemAdapterFactoryServiceProxy::createSystemAdapterRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    CreateSystemAdapterCallbackIF* pcb = static_cast< CreateSystemAdapterCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< SystemAdapterFactoryServiceProxy >& proxyShared = ::boost::static_pointer_cast< SystemAdapterFactoryServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< CreateSystemAdapterResponse > payload = ::boost::static_pointer_cast< CreateSystemAdapterResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CreateSystemAdapter", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onCreateSystemAdapterResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< CreateSystemAdapterError > error(new CreateSystemAdapterError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< CreateSystemAdapterError > error = ::boost::static_pointer_cast< CreateSystemAdapterError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CreateSystemAdapter", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onCreateSystemAdapterError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

} // namespace SystemAdapterFactoryService
} // namespace asf
