/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/SystemAdapterFactoryService.h"
#include "asf/SystemAdapterFactoryServiceJson.h"
#include "asf/SystemAdapterFactoryServiceJsonPrivate.h"
#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstdlib>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


static ParserStatus parserUint32List_ (ParserEvent event, ParserContext *context, void *p1, void *p2);

static ParserStatus parserUint32List_ (ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT    };

    Parser &parser = context->parsers.top();
    State state = (State) parser.state;
    ::std::vector< uint32 > *object = (::std::vector< uint32 >*) parser.object;

    switch (state) {
    case INIT:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint32 t = (uint32) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    object->push_back (t);
                    setState (context, INIT);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        case PARSER_EVENT__END_ARRAY:
            return leaveParser (context);
        default:
            break;
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "RegisterModuleRequest"

void serializeJson (const ::asf::SystemAdapterFactoryService::RegisterModuleRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasModuleName()) {
        yajl_gen_string(g, (const unsigned char*)  "moduleName" , 10);
        const char *s = value.getModuleName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasIidList()) {
        yajl_gen_string(g, (const unsigned char*)  "iidList" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< uint32 >& o1 = value.getIidList();
        {
            ::std::vector< uint32 >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                yajl_gen_integer(g, (long long)(*o0));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::asf::SystemAdapterFactoryService::RegisterModuleRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::asf::SystemAdapterFactoryService::RegisterModuleRequest& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserRegisterModuleRequest", jsonParser__asf__SystemAdapterFactoryService__RegisterModuleRequest, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForRegisterModuleRequest (char *s, size_t length)
{
    static stringEntry entries[] = {
        {7,"IIDLIST", 3},
        {10,"MODULENAME", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 2, value))
        return (int)value;
    else
        return 5;
}

static int processMapKeyForRegisterModuleRequest (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForRegisterModuleRequest(s, length);
    if (i != 5 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__asf__SystemAdapterFactoryService__RegisterModuleRequest(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_MODULENAME,
        KEY_MODULENAME,
        INIT_KEY_IIDLIST,
        KEY_IIDLIST,
        KEY_IIDLIST_WAIT_FOR_RETURN,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_MODULENAME:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForRegisterModuleRequest (context, (char*) p1, (size_t) p2, "moduleName", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_MODULENAME:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::asf::SystemAdapterFactoryService::RegisterModuleRequest*) parser.object)->replaceModuleName(t);
                setState (context, INIT_KEY_IIDLIST);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_IIDLIST:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForRegisterModuleRequest (context, (char*) p1, (size_t) p2, "iidList", 3) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_IIDLIST:
        switch (event) {
        case PARSER_EVENT__START_ARRAY:
            {
                setState (context, KEY_IIDLIST_WAIT_FOR_RETURN);
                callParser (context, "parserUint32List_", parserUint32List_, &((::asf::SystemAdapterFactoryService::RegisterModuleRequest*) parser.object)->getIidListMutable());
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY_IIDLIST_WAIT_FOR_RETURN:
        switch (event) {
        case PARSER_EVENT__RETURN:
            setState (context, INIT_KEY_MODULENAME);
            return PARSER_STATUS__OK;
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_MODULENAME);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_MODULENAME);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "RegisterModuleResponse"

void serializeJson (const ::asf::SystemAdapterFactoryService::RegisterModuleResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasModuleName()) {
        yajl_gen_string(g, (const unsigned char*)  "moduleName" , 10);
        const char *s = value.getModuleName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "result" , 6);
        yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::asf::SystemAdapterFactoryService::RegisterModuleResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::asf::SystemAdapterFactoryService::RegisterModuleResponse& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserRegisterModuleResponse", jsonParser__asf__SystemAdapterFactoryService__RegisterModuleResponse, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForRegisterModuleResponse (char *s, size_t length)
{
    static stringEntry entries[] = {
        {6,"RESULT", 3},
        {10,"MODULENAME", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 2, value))
        return (int)value;
    else
        return 4;
}

static int processMapKeyForRegisterModuleResponse (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForRegisterModuleResponse(s, length);
    if (i != 4 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__asf__SystemAdapterFactoryService__RegisterModuleResponse(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_MODULENAME,
        KEY_MODULENAME,
        INIT_KEY_RESULT,
        KEY_RESULT,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_MODULENAME:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForRegisterModuleResponse (context, (char*) p1, (size_t) p2, "moduleName", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_MODULENAME:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::asf::SystemAdapterFactoryService::RegisterModuleResponse*) parser.object)->replaceModuleName(t);
                setState (context, INIT_KEY_RESULT);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_RESULT:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForRegisterModuleResponse (context, (char*) p1, (size_t) p2, "result", 3) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_RESULT:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint32 t = (uint32) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::asf::SystemAdapterFactoryService::RegisterModuleResponse*) parser.object)->setResult(t);
                    setState (context, INIT_KEY_MODULENAME);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_MODULENAME);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_MODULENAME);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "CreateSystemAdapterRequest"

void serializeJson (const ::asf::SystemAdapterFactoryService::CreateSystemAdapterRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIid()) {
        yajl_gen_string(g, (const unsigned char*)  "iid" , 3);
        yajl_gen_integer(g, (long long)value.getIid());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::asf::SystemAdapterFactoryService::CreateSystemAdapterRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::asf::SystemAdapterFactoryService::CreateSystemAdapterRequest& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserCreateSystemAdapterRequest", jsonParser__asf__SystemAdapterFactoryService__CreateSystemAdapterRequest, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForCreateSystemAdapterRequest (char *s, size_t length)
{
    static stringEntry entries[] = {
        {3,"IID", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 1, value))
        return (int)value;
    else
        return 2;
}

static int processMapKeyForCreateSystemAdapterRequest (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForCreateSystemAdapterRequest(s, length);
    if (i != 2 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__asf__SystemAdapterFactoryService__CreateSystemAdapterRequest(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_IID,
        KEY_IID,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_IID:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForCreateSystemAdapterRequest (context, (char*) p1, (size_t) p2, "iid", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_IID:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint32 t = (uint32) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::asf::SystemAdapterFactoryService::CreateSystemAdapterRequest*) parser.object)->setIid(t);
                    setState (context, INIT_KEY_IID);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_IID);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_IID);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "CreateSystemAdapterResponse"

void serializeJson (const ::asf::SystemAdapterFactoryService::CreateSystemAdapterResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIid()) {
        yajl_gen_string(g, (const unsigned char*)  "iid" , 3);
        yajl_gen_integer(g, (long long)value.getIid());
    }
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "result" , 6);
        yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::asf::SystemAdapterFactoryService::CreateSystemAdapterResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::asf::SystemAdapterFactoryService::CreateSystemAdapterResponse& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserCreateSystemAdapterResponse", jsonParser__asf__SystemAdapterFactoryService__CreateSystemAdapterResponse, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForCreateSystemAdapterResponse (char *s, size_t length)
{
    static stringEntry entries[] = {
        {3,"IID", 1},
        {6,"RESULT", 3},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 2, value))
        return (int)value;
    else
        return 4;
}

static int processMapKeyForCreateSystemAdapterResponse (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForCreateSystemAdapterResponse(s, length);
    if (i != 4 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__asf__SystemAdapterFactoryService__CreateSystemAdapterResponse(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_IID,
        KEY_IID,
        INIT_KEY_RESULT,
        KEY_RESULT,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_IID:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForCreateSystemAdapterResponse (context, (char*) p1, (size_t) p2, "iid", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_IID:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint32 t = (uint32) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::asf::SystemAdapterFactoryService::CreateSystemAdapterResponse*) parser.object)->setIid(t);
                    setState (context, INIT_KEY_RESULT);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_RESULT:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForCreateSystemAdapterResponse (context, (char*) p1, (size_t) p2, "result", 3) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_RESULT:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint32 t = (uint32) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::asf::SystemAdapterFactoryService::CreateSystemAdapterResponse*) parser.object)->setResult(t);
                    setState (context, INIT_KEY_IID);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_IID);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_IID);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

using namespace ::asf::stream::json;

namespace asf {
namespace SystemAdapterFactoryService {

std::ostream& operator<<(std::ostream& o, const ::asf::SystemAdapterFactoryService::RegisterModuleRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SystemAdapterFactoryService
} // namespace asf
using namespace ::asf::stream::json;

namespace asf {
namespace SystemAdapterFactoryService {

std::ostream& operator<<(std::ostream& o, const ::asf::SystemAdapterFactoryService::RegisterModuleResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SystemAdapterFactoryService
} // namespace asf
using namespace ::asf::stream::json;

namespace asf {
namespace SystemAdapterFactoryService {

std::ostream& operator<<(std::ostream& o, const ::asf::SystemAdapterFactoryService::CreateSystemAdapterRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SystemAdapterFactoryService
} // namespace asf
using namespace ::asf::stream::json;

namespace asf {
namespace SystemAdapterFactoryService {

std::ostream& operator<<(std::ostream& o, const ::asf::SystemAdapterFactoryService::CreateSystemAdapterResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SystemAdapterFactoryService
} // namespace asf

