/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1.h"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1DBus.h"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1Json.h"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1Proxy.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace cm {
namespace diagnosis {
namespace dbus {
namespace Diagnosis1 {
namespace SystemSettings1 {

DEFINE_CLASS_LOGGER("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1", SystemSettings1Proxy);

class SystemSettings1ProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    SystemSettings1ProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< SystemSettings1Proxy >& proxyShared = ::boost::static_pointer_cast< SystemSettings1Proxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_PrepareSystemSetting:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), PrepareSystemSettingError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PrepareSystemSetting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PrepareSystemSettingError> payload = ::boost::static_pointer_cast<PrepareSystemSettingError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PrepareSystemSettingCallbackIF*) _callback)->onPrepareSystemSettingError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PrepareSystemSettingResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "PrepareSystemSetting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PrepareSystemSettingResponse> payload = ::boost::static_pointer_cast<PrepareSystemSettingResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PrepareSystemSettingCallbackIF*) _callback)->onPrepareSystemSettingResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ExecuteSystemSetting:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ExecuteSystemSettingError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ExecuteSystemSetting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecuteSystemSettingError> payload = ::boost::static_pointer_cast<ExecuteSystemSettingError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ExecuteSystemSettingCallbackIF*) _callback)->onExecuteSystemSettingError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecuteSystemSettingResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ExecuteSystemSetting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecuteSystemSettingResponse> payload = ::boost::static_pointer_cast<ExecuteSystemSettingResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ExecuteSystemSettingCallbackIF*) _callback)->onExecuteSystemSettingResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_FinalizeSystemSetting:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), FinalizeSystemSettingError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FinalizeSystemSetting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FinalizeSystemSettingError> payload = ::boost::static_pointer_cast<FinalizeSystemSettingError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((FinalizeSystemSettingCallbackIF*) _callback)->onFinalizeSystemSettingError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FinalizeSystemSettingResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "FinalizeSystemSetting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FinalizeSystemSettingResponse> payload = ::boost::static_pointer_cast<FinalizeSystemSettingResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((FinalizeSystemSettingCallbackIF*) _callback)->onFinalizeSystemSettingResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_PrepareSystemSetting: {
                ::boost::shared_ptr< PrepareSystemSettingError > payload = ::boost::shared_ptr< PrepareSystemSettingError >
                (new PrepareSystemSettingError(DBUS_ERROR_NO_SERVER, "The DBus service SystemSettings1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PrepareSystemSetting", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SystemSettings1Proxy> proxyShared = ::boost::static_pointer_cast<SystemSettings1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PrepareSystemSettingCallbackIF*) _callback)->onPrepareSystemSettingError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ExecuteSystemSetting: {
                ::boost::shared_ptr< ExecuteSystemSettingError > payload = ::boost::shared_ptr< ExecuteSystemSettingError >
                (new ExecuteSystemSettingError(DBUS_ERROR_NO_SERVER, "The DBus service SystemSettings1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ExecuteSystemSetting", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SystemSettings1Proxy> proxyShared = ::boost::static_pointer_cast<SystemSettings1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ExecuteSystemSettingCallbackIF*) _callback)->onExecuteSystemSettingError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FinalizeSystemSetting: {
                ::boost::shared_ptr< FinalizeSystemSettingError > payload = ::boost::shared_ptr< FinalizeSystemSettingError >
                (new FinalizeSystemSettingError(DBUS_ERROR_NO_SERVER, "The DBus service SystemSettings1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FinalizeSystemSetting", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SystemSettings1Proxy> proxyShared = ::boost::static_pointer_cast<SystemSettings1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FinalizeSystemSettingCallbackIF*) _callback)->onFinalizeSystemSettingError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& SystemSettings1ProxyCallback::_logger (SystemSettings1Proxy::_logger);

SystemSettings1Proxy::SystemSettings1Proxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", serviceAvailable, _logger) {
}

SystemSettings1Proxy::~SystemSettings1Proxy()
{
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< SystemSettings1Proxy > SystemSettings1Proxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<SystemSettings1Proxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< SystemSettings1Proxy > proxyNew(new SystemSettings1Proxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t SystemSettings1Proxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    SystemSettings1ProxyCallback* callback = new SystemSettings1ProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t SystemSettings1Proxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    SystemSettings1ProxyCallback* callback = new SystemSettings1ProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}



act_t SystemSettings1Proxy::sendPrepareSystemSettingRequest(PrepareSystemSettingCallbackIF& cb, const ::std::string& sysSetID, const ::std::string& sysSetType, const ::std::vector< PrepareSystemSettingRequestExtendedDataStruct >& extendedData, uint32 cookie) const {
    PrepareSystemSettingRequest* payload = new PrepareSystemSettingRequest();
    CHECK_ALLOCATION(payload);
    payload->setSysSetID(sysSetID);
    payload->setSysSetType(sysSetType);
    payload->setExtendedData(extendedData);
    payload->setCookie(cookie);
    DBUS_MESSAGE_CALL(dbusMessage, "PrepareSystemSetting", PrepareSystemSettingRequest, payload, true)
    act_t act = addMethodCallback(ID_PrepareSystemSetting, dbusMessage.getUniqueSerial(), "PrepareSystemSetting", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "PrepareSystemSetting", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SystemSettings1Proxy::sendExecuteSystemSettingRequest(ExecuteSystemSettingCallbackIF& cb, const ::std::string& sysSetID, const ::std::string& sysSetType, const ::std::vector< ExecuteSystemSettingRequestExtendedDataStruct >& extendedData, uint32 cookie) const {
    ExecuteSystemSettingRequest* payload = new ExecuteSystemSettingRequest();
    CHECK_ALLOCATION(payload);
    payload->setSysSetID(sysSetID);
    payload->setSysSetType(sysSetType);
    payload->setExtendedData(extendedData);
    payload->setCookie(cookie);
    DBUS_MESSAGE_CALL(dbusMessage, "ExecuteSystemSetting", ExecuteSystemSettingRequest, payload, true)
    act_t act = addMethodCallback(ID_ExecuteSystemSetting, dbusMessage.getUniqueSerial(), "ExecuteSystemSetting", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ExecuteSystemSetting", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SystemSettings1Proxy::sendFinalizeSystemSettingRequest(FinalizeSystemSettingCallbackIF& cb, const ::std::string& sysSetID, const ::std::string& sysSetType, const ::std::vector< FinalizeSystemSettingRequestExtendedDataStruct >& extendedData, uint32 cookie) const {
    FinalizeSystemSettingRequest* payload = new FinalizeSystemSettingRequest();
    CHECK_ALLOCATION(payload);
    payload->setSysSetID(sysSetID);
    payload->setSysSetType(sysSetType);
    payload->setExtendedData(extendedData);
    payload->setCookie(cookie);
    DBUS_MESSAGE_CALL(dbusMessage, "FinalizeSystemSetting", FinalizeSystemSettingRequest, payload, true)
    act_t act = addMethodCallback(ID_FinalizeSystemSetting, dbusMessage.getUniqueSerial(), "FinalizeSystemSetting", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "FinalizeSystemSetting", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace SystemSettings1
} // namespace Diagnosis1
} // namespace dbus
} // namespace diagnosis
} // namespace cm
} // namespace bosch
} // namespace org
