/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_DIAGNOSIS_DBUS_DIAGNOSIS1_CONTROL1PROXY_H
#define ORG_BOSCH_CM_DIAGNOSIS_DBUS_DIAGNOSIS1_CONTROL1PROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/Control1.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

namespace org {
namespace bosch {
namespace cm {
namespace diagnosis {
namespace dbus {
namespace Diagnosis1 {
namespace Control1 {

class Control1Proxy;

class GetRemoteControlModeCallbackIF {
public:
    virtual ~GetRemoteControlModeCallbackIF() {}

    virtual void onGetRemoteControlModeError(const ::boost::shared_ptr< Control1Proxy >& proxy, const ::boost::shared_ptr< GetRemoteControlModeError >& error) = 0;

    virtual void onGetRemoteControlModeResponse(const ::boost::shared_ptr< Control1Proxy >& proxy, const ::boost::shared_ptr< GetRemoteControlModeResponse >& response) = 0;
};

class RemoteExecuteSystemSettingCallbackIF {
public:
    virtual ~RemoteExecuteSystemSettingCallbackIF() {}

    virtual void onRemoteExecuteSystemSettingError(const ::boost::shared_ptr< Control1Proxy >& proxy, const ::boost::shared_ptr< RemoteExecuteSystemSettingError >& error) = 0;

    virtual void onRemoteExecuteSystemSettingResponse(const ::boost::shared_ptr< Control1Proxy >& proxy, const ::boost::shared_ptr< RemoteExecuteSystemSettingResponse >& response) = 0;
};

class RemoteFinalizeSystemSettingCallbackIF {
public:
    virtual ~RemoteFinalizeSystemSettingCallbackIF() {}

    virtual void onRemoteFinalizeSystemSettingError(const ::boost::shared_ptr< Control1Proxy >& proxy, const ::boost::shared_ptr< RemoteFinalizeSystemSettingError >& error) = 0;

    virtual void onRemoteFinalizeSystemSettingResponse(const ::boost::shared_ptr< Control1Proxy >& proxy, const ::boost::shared_ptr< RemoteFinalizeSystemSettingResponse >& response) = 0;
};

class RemotePrepareSystemSettingCallbackIF {
public:
    virtual ~RemotePrepareSystemSettingCallbackIF() {}

    virtual void onRemotePrepareSystemSettingError(const ::boost::shared_ptr< Control1Proxy >& proxy, const ::boost::shared_ptr< RemotePrepareSystemSettingError >& error) = 0;

    virtual void onRemotePrepareSystemSettingResponse(const ::boost::shared_ptr< Control1Proxy >& proxy, const ::boost::shared_ptr< RemotePrepareSystemSettingResponse >& response) = 0;
};

class SetRemoteControlModeCallbackIF {
public:
    virtual ~SetRemoteControlModeCallbackIF() {}

    virtual void onSetRemoteControlModeError(const ::boost::shared_ptr< Control1Proxy >& proxy, const ::boost::shared_ptr< SetRemoteControlModeError >& error) = 0;

    virtual void onSetRemoteControlModeResponse(const ::boost::shared_ptr< Control1Proxy >& proxy, const ::boost::shared_ptr< SetRemoteControlModeResponse >& response) = 0;
};

class StartSystemSettingCallbackIF {
public:
    virtual ~StartSystemSettingCallbackIF() {}

    virtual void onStartSystemSettingError(const ::boost::shared_ptr< Control1Proxy >& proxy, const ::boost::shared_ptr< StartSystemSettingError >& error) = 0;

    virtual void onStartSystemSettingResponse(const ::boost::shared_ptr< Control1Proxy >& proxy, const ::boost::shared_ptr< StartSystemSettingResponse >& response) = 0;
};


/**
 * Control1Proxy is the client side representation of the D-Bus service
 * interface 'org.bosch.cm.diagnosis.dbus.Diagnosis1.Control1' (specified
 * in file Control1.xml).
 *
 * Parameter passed back
 * Param 1: Type - byte : parameter type
 * Param 2: Type - array of bytes carrying the parameter value. The length depends on parameter type
 */
class Control1Proxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of Control1Proxy.
     */
    static ::boost::shared_ptr< Control1Proxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of Control1Proxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< Control1Proxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of Control1Proxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< Control1Proxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Control1Proxy > proxyNew(new Control1Proxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~Control1Proxy ();




    // Method 'SetRemoteControlMode'

    /**
     * Call the method 'SetRemoteControlMode'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'SetRemoteControlMode'</b>:
     *
     * Asynchronous continuation token provided by the sender in the method call. cookie must not be changed.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param area If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param cookie If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetRemoteControlModeRequest(SetRemoteControlModeCallbackIF& cb, const ::std::string& area, const ::std::string& mode, uint32 cookie) const;

    // Method 'GetRemoteControlMode'

    /**
     * Call the method 'GetRemoteControlMode'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'GetRemoteControlMode'</b>:
     *
     * Asynchronous continuation token provided by the sender in the method call. cookie must not be changed.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param area If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @param cookie If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetRemoteControlModeRequest(GetRemoteControlModeCallbackIF& cb, const ::std::string& area, uint32 cookie) const;

    // Method 'StartSystemSetting'

    /**
     * Call the method 'StartSystemSetting'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'StartSystemSetting'</b>:
     *
     * Asynchronous continuation token provided by the sender in the method call. cookie must not be changed.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param sysSetType If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param extendedData If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @param cookie If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartSystemSettingRequest(StartSystemSettingCallbackIF& cb, const ::std::string& sysSetType, const ::std::vector< StartSystemSettingRequestExtendedDataStruct >& extendedData, uint32 cookie) const;

    // Method 'RemotePrepareSystemSetting'

    /**
     * Call the method 'RemotePrepareSystemSetting'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'RemotePrepareSystemSetting'</b>:
     *
     * Asynchronous continuation token provided by the sender. cookie must not be changed and is sent back in response signal.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param sysSetType If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param extendedData If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @param cookie If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemotePrepareSystemSettingRequest(RemotePrepareSystemSettingCallbackIF& cb, const ::std::string& sysSetType, const ::std::vector< RemotePrepareSystemSettingRequestExtendedDataStruct >& extendedData, uint32 cookie) const;

    // Method 'RemoteExecuteSystemSetting'

    /**
     * Call the method 'RemoteExecuteSystemSetting'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'RemoteExecuteSystemSetting'</b>:
     *
     * Asynchronous continuation token provided by the sender. cookie must not be changed and is sent back in response signal.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param sysSetType If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param extendedData If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @param cookie If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemoteExecuteSystemSettingRequest(RemoteExecuteSystemSettingCallbackIF& cb, const ::std::string& sysSetType, const ::std::vector< RemoteExecuteSystemSettingRequestExtendedDataStruct >& extendedData, uint32 cookie) const;

    // Method 'RemoteFinalizeSystemSetting'

    /**
     * Call the method 'RemoteFinalizeSystemSetting'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'RemoteFinalizeSystemSetting'</b>:
     *
     * Asynchronous continuation token provided by the sender. cookie must not be changed and is sent back in response signal.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param sysSetType If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param extendedData If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @param cookie If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemoteFinalizeSystemSettingRequest(RemoteFinalizeSystemSettingCallbackIF& cb, const ::std::string& sysSetType, const ::std::vector< RemoteFinalizeSystemSettingRequestExtendedDataStruct >& extendedData, uint32 cookie) const;


private:

    Control1Proxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class Control1ProxyCallback;
};

} // namespace Control1
} // namespace Diagnosis1
} // namespace dbus
} // namespace diagnosis
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_DIAGNOSIS_DBUS_DIAGNOSIS1_CONTROL1PROXY_H
