#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_DIAGNOSIS_DBUS_DIAGNOSIS1_CONTROL1_H
#define ORG_BOSCH_CM_DIAGNOSIS_DBUS_DIAGNOSIS1_CONTROL1_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "Control1" isn't clear, then there should be a description here.
 */

namespace org {
namespace bosch {
namespace cm {
namespace diagnosis {
namespace dbus {
namespace Diagnosis1 {
namespace Control1 {

// method IDs
static const uint16 ID_SetRemoteControlMode = 0;
static const uint16 ID_GetRemoteControlMode = 1;
static const uint16 ID_StartSystemSetting = 2;
static const uint16 ID_RemotePrepareSystemSetting = 3;
static const uint16 ID_RemoteExecuteSystemSetting = 4;
static const uint16 ID_RemoteFinalizeSystemSetting = 5;

// signal IDs

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class SetRemoteControlModeRequest;

class SetRemoteControlModeResponse;

class GetRemoteControlModeRequest;

class GetRemoteControlModeResponse;

class StartSystemSettingRequestExtendedDataStruct;

class StartSystemSettingRequest;

class StartSystemSettingResponseExtendedDataStruct;

class StartSystemSettingResponse;

class RemotePrepareSystemSettingRequestExtendedDataStruct;

class RemotePrepareSystemSettingRequest;

class RemotePrepareSystemSettingResponseExtendedDataStruct;

class RemotePrepareSystemSettingResponse;

class RemoteExecuteSystemSettingRequestExtendedDataStruct;

class RemoteExecuteSystemSettingRequest;

class RemoteExecuteSystemSettingResponseExtendedDataStruct;

class RemoteExecuteSystemSettingResponse;

class RemoteFinalizeSystemSettingRequestExtendedDataStruct;

class RemoteFinalizeSystemSettingRequest;

class RemoteFinalizeSystemSettingResponseExtendedDataStruct;

class RemoteFinalizeSystemSettingResponse;

// type definitions
/**
 * If the meaning of "SetRemoteControlModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetRemoteControlModeError;

/**
 * If the meaning of "GetRemoteControlModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetRemoteControlModeError;

/**
 * If the meaning of "StartSystemSettingError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartSystemSettingError;

/**
 * If the meaning of "RemotePrepareSystemSettingError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RemotePrepareSystemSettingError;

/**
 * If the meaning of "RemoteExecuteSystemSettingError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RemoteExecuteSystemSettingError;

/**
 * If the meaning of "RemoteFinalizeSystemSettingError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RemoteFinalizeSystemSettingError;


/**
 * If the meaning of "SetRemoteControlModeRequest" isn't clear, then there should be a description here.
 */
class SetRemoteControlModeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetRemoteControlModeRequest ();

    /**
     * Copy constructor
     */
    inline  SetRemoteControlModeRequest (const SetRemoteControlModeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetRemoteControlModeRequest (const ::std::string& area_, const ::std::string& mode_, uint32 cookie_);

    /**
     * Destructor
     */
    inline virtual  ~SetRemoteControlModeRequest();

    /**
     * Assignment operator
     */
    inline SetRemoteControlModeRequest& operator = (const SetRemoteControlModeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetRemoteControlModeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetRemoteControlModeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetRemoteControlModeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetRemoteControlModeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "area"

    static const int kArea = 0;

    /**
     * Clears the field "area".
     *
     * The field will be set to its default value. The hasArea()
     * method will return false.
     */
    inline void clearArea();

    /**
     * Checks whether the field "area" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArea()). Otherwise it will return false.
     */
    inline bool hasArea () const;

    /**
     * Returns the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @return The value of the field "area"
     */
    inline const ::std::string& getArea () const;

    /**
     * Retrieves the value of the field "area" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "area".
     */
    inline ::std::string& getAreaMutable ();

    /**
     * Sets the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @param area The value which will be set
     */
    inline void setArea (const ::std::string& area_);

    /**
     * Sets the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @param area The value which will be set
     */
    inline void setArea (const char* area_);

    /**
     * Sets the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @param area The value which will be set
     */
    inline void setArea (const char* value, size_t size);

    // API of field "mode"

    static const int kMode = 1;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline const ::std::string& getMode () const;

    /**
     * Retrieves the value of the field "mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mode".
     */
    inline ::std::string& getModeMutable ();

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const ::std::string& mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* value, size_t size);

    // API of field "cookie"

    static const int kCookie = 2;

    /**
     * Clears the field "cookie".
     *
     * The field will be set to its default value. The hasCookie()
     * method will return false.
     */
    inline void clearCookie();

    /**
     * Checks whether the field "cookie" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCookie()). Otherwise it will return false.
     */
    inline bool hasCookie () const;

    /**
     * Returns the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cookie"
     */
    inline uint32 getCookie () const;

    /**
     * Sets the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @param cookie The value which will be set
     */
    inline void setCookie (uint32 cookie_);

    static const SetRemoteControlModeRequest &getDefaultInstance();

private:

    inline void set_has_area ();

    inline void clear_has_area ();

    inline void set_has_mode ();

    inline void clear_has_mode ();

    inline void set_has_cookie ();

    inline void clear_has_cookie ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _area;

    ::std::string _mode;

    uint32 _cookie;

};

/**
 * If the meaning of "SetRemoteControlModeResponse" isn't clear, then there should be a description here.
 */
class SetRemoteControlModeResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetRemoteControlModeResponse ();

    /**
     * Copy constructor
     */
    inline  SetRemoteControlModeResponse (const SetRemoteControlModeResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetRemoteControlModeResponse (const ::std::string& area_, const ::std::string& mode_, uint32 resultCode_, uint32 cookie_);

    /**
     * Destructor
     */
    inline virtual  ~SetRemoteControlModeResponse();

    /**
     * Assignment operator
     */
    inline SetRemoteControlModeResponse& operator = (const SetRemoteControlModeResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetRemoteControlModeResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetRemoteControlModeResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetRemoteControlModeResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetRemoteControlModeResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "area"

    static const int kArea = 0;

    /**
     * Clears the field "area".
     *
     * The field will be set to its default value. The hasArea()
     * method will return false.
     */
    inline void clearArea();

    /**
     * Checks whether the field "area" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArea()). Otherwise it will return false.
     */
    inline bool hasArea () const;

    /**
     * Returns the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @return The value of the field "area"
     */
    inline const ::std::string& getArea () const;

    /**
     * Retrieves the value of the field "area" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "area".
     */
    inline ::std::string& getAreaMutable ();

    /**
     * Sets the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @param area The value which will be set
     */
    inline void setArea (const ::std::string& area_);

    /**
     * Sets the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @param area The value which will be set
     */
    inline void setArea (const char* area_);

    /**
     * Sets the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @param area The value which will be set
     */
    inline void setArea (const char* value, size_t size);

    // API of field "mode"

    static const int kMode = 1;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline const ::std::string& getMode () const;

    /**
     * Retrieves the value of the field "mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mode".
     */
    inline ::std::string& getModeMutable ();

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const ::std::string& mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* value, size_t size);

    // API of field "resultCode"

    static const int kResultCode = 2;

    /**
     * Clears the field "resultCode".
     *
     * The field will be set to its default value. The hasResultCode()
     * method will return false.
     */
    inline void clearResultCode();

    /**
     * Checks whether the field "resultCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResultCode()). Otherwise it will return false.
     */
    inline bool hasResultCode () const;

    /**
     * Returns the value of the member "resultCode".
     *
     * If the meaning of "resultCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "resultCode"
     */
    inline uint32 getResultCode () const;

    /**
     * Sets the value of the member "resultCode".
     *
     * If the meaning of "resultCode" isn't clear, then there should be a description here.
     *
     * @param resultCode The value which will be set
     */
    inline void setResultCode (uint32 resultCode_);

    // API of field "cookie"

    static const int kCookie = 3;

    /**
     * Clears the field "cookie".
     *
     * The field will be set to its default value. The hasCookie()
     * method will return false.
     */
    inline void clearCookie();

    /**
     * Checks whether the field "cookie" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCookie()). Otherwise it will return false.
     */
    inline bool hasCookie () const;

    /**
     * Returns the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cookie"
     */
    inline uint32 getCookie () const;

    /**
     * Sets the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @param cookie The value which will be set
     */
    inline void setCookie (uint32 cookie_);

    static const SetRemoteControlModeResponse &getDefaultInstance();

private:

    inline void set_has_area ();

    inline void clear_has_area ();

    inline void set_has_mode ();

    inline void clear_has_mode ();

    inline void set_has_resultCode ();

    inline void clear_has_resultCode ();

    inline void set_has_cookie ();

    inline void clear_has_cookie ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _area;

    ::std::string _mode;

    uint32 _resultCode;

    uint32 _cookie;

};

/**
 * If the meaning of "GetRemoteControlModeRequest" isn't clear, then there should be a description here.
 */
class GetRemoteControlModeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetRemoteControlModeRequest ();

    /**
     * Copy constructor
     */
    inline  GetRemoteControlModeRequest (const GetRemoteControlModeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetRemoteControlModeRequest (const ::std::string& area_, uint32 cookie_);

    /**
     * Destructor
     */
    inline virtual  ~GetRemoteControlModeRequest();

    /**
     * Assignment operator
     */
    inline GetRemoteControlModeRequest& operator = (const GetRemoteControlModeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetRemoteControlModeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetRemoteControlModeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetRemoteControlModeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetRemoteControlModeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "area"

    static const int kArea = 0;

    /**
     * Clears the field "area".
     *
     * The field will be set to its default value. The hasArea()
     * method will return false.
     */
    inline void clearArea();

    /**
     * Checks whether the field "area" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArea()). Otherwise it will return false.
     */
    inline bool hasArea () const;

    /**
     * Returns the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @return The value of the field "area"
     */
    inline const ::std::string& getArea () const;

    /**
     * Retrieves the value of the field "area" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "area".
     */
    inline ::std::string& getAreaMutable ();

    /**
     * Sets the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @param area The value which will be set
     */
    inline void setArea (const ::std::string& area_);

    /**
     * Sets the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @param area The value which will be set
     */
    inline void setArea (const char* area_);

    /**
     * Sets the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @param area The value which will be set
     */
    inline void setArea (const char* value, size_t size);

    // API of field "cookie"

    static const int kCookie = 1;

    /**
     * Clears the field "cookie".
     *
     * The field will be set to its default value. The hasCookie()
     * method will return false.
     */
    inline void clearCookie();

    /**
     * Checks whether the field "cookie" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCookie()). Otherwise it will return false.
     */
    inline bool hasCookie () const;

    /**
     * Returns the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cookie"
     */
    inline uint32 getCookie () const;

    /**
     * Sets the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @param cookie The value which will be set
     */
    inline void setCookie (uint32 cookie_);

    static const GetRemoteControlModeRequest &getDefaultInstance();

private:

    inline void set_has_area ();

    inline void clear_has_area ();

    inline void set_has_cookie ();

    inline void clear_has_cookie ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _area;

    uint32 _cookie;

};

/**
 * If the meaning of "GetRemoteControlModeResponse" isn't clear, then there should be a description here.
 */
class GetRemoteControlModeResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetRemoteControlModeResponse ();

    /**
     * Copy constructor
     */
    inline  GetRemoteControlModeResponse (const GetRemoteControlModeResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetRemoteControlModeResponse (const ::std::string& area_, const ::std::string& mode_, uint32 cookie_);

    /**
     * Destructor
     */
    inline virtual  ~GetRemoteControlModeResponse();

    /**
     * Assignment operator
     */
    inline GetRemoteControlModeResponse& operator = (const GetRemoteControlModeResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetRemoteControlModeResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetRemoteControlModeResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetRemoteControlModeResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetRemoteControlModeResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "area"

    static const int kArea = 0;

    /**
     * Clears the field "area".
     *
     * The field will be set to its default value. The hasArea()
     * method will return false.
     */
    inline void clearArea();

    /**
     * Checks whether the field "area" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArea()). Otherwise it will return false.
     */
    inline bool hasArea () const;

    /**
     * Returns the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @return The value of the field "area"
     */
    inline const ::std::string& getArea () const;

    /**
     * Retrieves the value of the field "area" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "area".
     */
    inline ::std::string& getAreaMutable ();

    /**
     * Sets the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @param area The value which will be set
     */
    inline void setArea (const ::std::string& area_);

    /**
     * Sets the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @param area The value which will be set
     */
    inline void setArea (const char* area_);

    /**
     * Sets the value of the member "area".
     *
     * If the meaning of "area" isn't clear, then there should be a description here.
     *
     * @param area The value which will be set
     */
    inline void setArea (const char* value, size_t size);

    // API of field "mode"

    static const int kMode = 1;

    /**
     * Clears the field "mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mode"
     */
    inline const ::std::string& getMode () const;

    /**
     * Retrieves the value of the field "mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mode".
     */
    inline ::std::string& getModeMutable ();

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const ::std::string& mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* mode_);

    /**
     * Sets the value of the member "mode".
     *
     * If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param mode The value which will be set
     */
    inline void setMode (const char* value, size_t size);

    // API of field "cookie"

    static const int kCookie = 2;

    /**
     * Clears the field "cookie".
     *
     * The field will be set to its default value. The hasCookie()
     * method will return false.
     */
    inline void clearCookie();

    /**
     * Checks whether the field "cookie" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCookie()). Otherwise it will return false.
     */
    inline bool hasCookie () const;

    /**
     * Returns the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cookie"
     */
    inline uint32 getCookie () const;

    /**
     * Sets the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @param cookie The value which will be set
     */
    inline void setCookie (uint32 cookie_);

    static const GetRemoteControlModeResponse &getDefaultInstance();

private:

    inline void set_has_area ();

    inline void clear_has_area ();

    inline void set_has_mode ();

    inline void clear_has_mode ();

    inline void set_has_cookie ();

    inline void clear_has_cookie ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _area;

    ::std::string _mode;

    uint32 _cookie;

};

/**
 * If the meaning of "StartSystemSettingRequestExtendedDataStruct" isn't clear, then there should be a description here.
 */
class StartSystemSettingRequestExtendedDataStruct {
public:

    /**
     * Default constructor
     */
    inline  StartSystemSettingRequestExtendedDataStruct ();

    /**
     * Copy constructor
     */
    inline  StartSystemSettingRequestExtendedDataStruct (const StartSystemSettingRequestExtendedDataStruct &rhs);

    /**
     * All fields constructor
     */
    inline  StartSystemSettingRequestExtendedDataStruct (uint8 elem1_, const ::std::vector< uint8 >& elem2_);

    /**
     * Destructor
     */
    inline  ~StartSystemSettingRequestExtendedDataStruct();

    /**
     * Assignment operator
     */
    inline StartSystemSettingRequestExtendedDataStruct& operator = (const StartSystemSettingRequestExtendedDataStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartSystemSettingRequestExtendedDataStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartSystemSettingRequestExtendedDataStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartSystemSettingRequestExtendedDataStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartSystemSettingRequestExtendedDataStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline uint8 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (uint8 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::vector< uint8 >& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::vector< uint8 >& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::vector< uint8 >& elem2_);

    static const StartSystemSettingRequestExtendedDataStruct &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _elem1;

    ::std::vector< uint8 > _elem2;

};

/**
 * If the meaning of "StartSystemSettingRequest" isn't clear, then there should be a description here.
 */
class StartSystemSettingRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartSystemSettingRequest ();

    /**
     * Copy constructor
     */
    inline  StartSystemSettingRequest (const StartSystemSettingRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StartSystemSettingRequest (const ::std::string& sysSetType_, const ::std::vector< StartSystemSettingRequestExtendedDataStruct >& extendedData_, uint32 cookie_);

    /**
     * Destructor
     */
    inline virtual  ~StartSystemSettingRequest();

    /**
     * Assignment operator
     */
    inline StartSystemSettingRequest& operator = (const StartSystemSettingRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartSystemSettingRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartSystemSettingRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartSystemSettingRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartSystemSettingRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sysSetType"

    static const int kSysSetType = 0;

    /**
     * Clears the field "sysSetType".
     *
     * The field will be set to its default value. The hasSysSetType()
     * method will return false.
     */
    inline void clearSysSetType();

    /**
     * Checks whether the field "sysSetType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSysSetType()). Otherwise it will return false.
     */
    inline bool hasSysSetType () const;

    /**
     * Returns the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sysSetType"
     */
    inline const ::std::string& getSysSetType () const;

    /**
     * Retrieves the value of the field "sysSetType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sysSetType".
     */
    inline ::std::string& getSysSetTypeMutable ();

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const ::std::string& sysSetType_);

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const char* sysSetType_);

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const char* value, size_t size);

    // API of field "extendedData"

    static const int kExtendedData = 1;

    /**
     * Clears the field "extendedData".
     *
     * The field will be set to its default value. The hasExtendedData()
     * method will return false.
     */
    inline void clearExtendedData();

    /**
     * Checks whether the field "extendedData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setExtendedData()). Otherwise it will return false.
     */
    inline bool hasExtendedData () const;

    /**
     * Returns the value of the member "extendedData".
     *
     * If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "extendedData"
     */
    inline const ::std::vector< StartSystemSettingRequestExtendedDataStruct >& getExtendedData () const;

    /**
     * Retrieves the value of the field "extendedData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "extendedData".
     */
    inline ::std::vector< StartSystemSettingRequestExtendedDataStruct >& getExtendedDataMutable ();

    /**
     * Sets the value of the member "extendedData".
     *
     * If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @param extendedData The value which will be set
     */
    inline void setExtendedData (const ::std::vector< StartSystemSettingRequestExtendedDataStruct >& extendedData_);

    // API of field "cookie"

    static const int kCookie = 2;

    /**
     * Clears the field "cookie".
     *
     * The field will be set to its default value. The hasCookie()
     * method will return false.
     */
    inline void clearCookie();

    /**
     * Checks whether the field "cookie" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCookie()). Otherwise it will return false.
     */
    inline bool hasCookie () const;

    /**
     * Returns the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cookie"
     */
    inline uint32 getCookie () const;

    /**
     * Sets the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @param cookie The value which will be set
     */
    inline void setCookie (uint32 cookie_);

    static const StartSystemSettingRequest &getDefaultInstance();

private:

    static const ::std::vector< StartSystemSettingRequestExtendedDataStruct >& getStartSystemSettingRequestExtendedDataStructList_DefaultInstance ();

    inline void set_has_sysSetType ();

    inline void clear_has_sysSetType ();

    inline void set_has_extendedData ();

    inline void clear_has_extendedData ();

    inline void set_has_cookie ();

    inline void clear_has_cookie ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _sysSetType;

    ::std::vector< StartSystemSettingRequestExtendedDataStruct > _extendedData;

    uint32 _cookie;

};

/**
 * If the meaning of "StartSystemSettingResponseExtendedDataStruct" isn't clear, then there should be a description here.
 */
class StartSystemSettingResponseExtendedDataStruct {
public:

    /**
     * Default constructor
     */
    inline  StartSystemSettingResponseExtendedDataStruct ();

    /**
     * Copy constructor
     */
    inline  StartSystemSettingResponseExtendedDataStruct (const StartSystemSettingResponseExtendedDataStruct &rhs);

    /**
     * All fields constructor
     */
    inline  StartSystemSettingResponseExtendedDataStruct (uint8 elem1_, const ::std::vector< uint8 >& elem2_);

    /**
     * Destructor
     */
    inline  ~StartSystemSettingResponseExtendedDataStruct();

    /**
     * Assignment operator
     */
    inline StartSystemSettingResponseExtendedDataStruct& operator = (const StartSystemSettingResponseExtendedDataStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartSystemSettingResponseExtendedDataStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartSystemSettingResponseExtendedDataStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartSystemSettingResponseExtendedDataStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartSystemSettingResponseExtendedDataStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline uint8 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (uint8 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::vector< uint8 >& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::vector< uint8 >& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::vector< uint8 >& elem2_);

    static const StartSystemSettingResponseExtendedDataStruct &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _elem1;

    ::std::vector< uint8 > _elem2;

};

/**
 * If the meaning of "StartSystemSettingResponse" isn't clear, then there should be a description here.
 */
class StartSystemSettingResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartSystemSettingResponse ();

    /**
     * Copy constructor
     */
    inline  StartSystemSettingResponse (const StartSystemSettingResponse &rhs);

    /**
     * All fields constructor
     */
    inline  StartSystemSettingResponse (const ::std::string& sysSetType_, const ::std::vector< StartSystemSettingResponseExtendedDataStruct >& extendedData_, uint32 resultCode_, uint32 cookie_);

    /**
     * Destructor
     */
    inline virtual  ~StartSystemSettingResponse();

    /**
     * Assignment operator
     */
    inline StartSystemSettingResponse& operator = (const StartSystemSettingResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartSystemSettingResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartSystemSettingResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartSystemSettingResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartSystemSettingResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sysSetType"

    static const int kSysSetType = 0;

    /**
     * Clears the field "sysSetType".
     *
     * The field will be set to its default value. The hasSysSetType()
     * method will return false.
     */
    inline void clearSysSetType();

    /**
     * Checks whether the field "sysSetType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSysSetType()). Otherwise it will return false.
     */
    inline bool hasSysSetType () const;

    /**
     * Returns the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sysSetType"
     */
    inline const ::std::string& getSysSetType () const;

    /**
     * Retrieves the value of the field "sysSetType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sysSetType".
     */
    inline ::std::string& getSysSetTypeMutable ();

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const ::std::string& sysSetType_);

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const char* sysSetType_);

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const char* value, size_t size);

    // API of field "extendedData"

    static const int kExtendedData = 1;

    /**
     * Clears the field "extendedData".
     *
     * The field will be set to its default value. The hasExtendedData()
     * method will return false.
     */
    inline void clearExtendedData();

    /**
     * Checks whether the field "extendedData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setExtendedData()). Otherwise it will return false.
     */
    inline bool hasExtendedData () const;

    /**
     * Returns the value of the member "extendedData".
     *
     * If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "extendedData"
     */
    inline const ::std::vector< StartSystemSettingResponseExtendedDataStruct >& getExtendedData () const;

    /**
     * Retrieves the value of the field "extendedData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "extendedData".
     */
    inline ::std::vector< StartSystemSettingResponseExtendedDataStruct >& getExtendedDataMutable ();

    /**
     * Sets the value of the member "extendedData".
     *
     * If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @param extendedData The value which will be set
     */
    inline void setExtendedData (const ::std::vector< StartSystemSettingResponseExtendedDataStruct >& extendedData_);

    // API of field "resultCode"

    static const int kResultCode = 2;

    /**
     * Clears the field "resultCode".
     *
     * The field will be set to its default value. The hasResultCode()
     * method will return false.
     */
    inline void clearResultCode();

    /**
     * Checks whether the field "resultCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResultCode()). Otherwise it will return false.
     */
    inline bool hasResultCode () const;

    /**
     * Returns the value of the member "resultCode".
     *
     * If the meaning of "resultCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "resultCode"
     */
    inline uint32 getResultCode () const;

    /**
     * Sets the value of the member "resultCode".
     *
     * If the meaning of "resultCode" isn't clear, then there should be a description here.
     *
     * @param resultCode The value which will be set
     */
    inline void setResultCode (uint32 resultCode_);

    // API of field "cookie"

    static const int kCookie = 3;

    /**
     * Clears the field "cookie".
     *
     * The field will be set to its default value. The hasCookie()
     * method will return false.
     */
    inline void clearCookie();

    /**
     * Checks whether the field "cookie" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCookie()). Otherwise it will return false.
     */
    inline bool hasCookie () const;

    /**
     * Returns the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cookie"
     */
    inline uint32 getCookie () const;

    /**
     * Sets the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @param cookie The value which will be set
     */
    inline void setCookie (uint32 cookie_);

    static const StartSystemSettingResponse &getDefaultInstance();

private:

    static const ::std::vector< StartSystemSettingResponseExtendedDataStruct >& getStartSystemSettingResponseExtendedDataStructList_DefaultInstance ();

    inline void set_has_sysSetType ();

    inline void clear_has_sysSetType ();

    inline void set_has_extendedData ();

    inline void clear_has_extendedData ();

    inline void set_has_resultCode ();

    inline void clear_has_resultCode ();

    inline void set_has_cookie ();

    inline void clear_has_cookie ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _sysSetType;

    ::std::vector< StartSystemSettingResponseExtendedDataStruct > _extendedData;

    uint32 _resultCode;

    uint32 _cookie;

};

/**
 * If the meaning of "RemotePrepareSystemSettingRequestExtendedDataStruct" isn't clear, then there should be a description here.
 */
class RemotePrepareSystemSettingRequestExtendedDataStruct {
public:

    /**
     * Default constructor
     */
    inline  RemotePrepareSystemSettingRequestExtendedDataStruct ();

    /**
     * Copy constructor
     */
    inline  RemotePrepareSystemSettingRequestExtendedDataStruct (const RemotePrepareSystemSettingRequestExtendedDataStruct &rhs);

    /**
     * All fields constructor
     */
    inline  RemotePrepareSystemSettingRequestExtendedDataStruct (uint8 elem1_, const ::std::vector< uint8 >& elem2_);

    /**
     * Destructor
     */
    inline  ~RemotePrepareSystemSettingRequestExtendedDataStruct();

    /**
     * Assignment operator
     */
    inline RemotePrepareSystemSettingRequestExtendedDataStruct& operator = (const RemotePrepareSystemSettingRequestExtendedDataStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemotePrepareSystemSettingRequestExtendedDataStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemotePrepareSystemSettingRequestExtendedDataStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemotePrepareSystemSettingRequestExtendedDataStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemotePrepareSystemSettingRequestExtendedDataStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline uint8 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (uint8 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::vector< uint8 >& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::vector< uint8 >& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::vector< uint8 >& elem2_);

    static const RemotePrepareSystemSettingRequestExtendedDataStruct &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _elem1;

    ::std::vector< uint8 > _elem2;

};

/**
 * If the meaning of "RemotePrepareSystemSettingRequest" isn't clear, then there should be a description here.
 */
class RemotePrepareSystemSettingRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemotePrepareSystemSettingRequest ();

    /**
     * Copy constructor
     */
    inline  RemotePrepareSystemSettingRequest (const RemotePrepareSystemSettingRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RemotePrepareSystemSettingRequest (const ::std::string& sysSetType_, const ::std::vector< RemotePrepareSystemSettingRequestExtendedDataStruct >& extendedData_, uint32 cookie_);

    /**
     * Destructor
     */
    inline virtual  ~RemotePrepareSystemSettingRequest();

    /**
     * Assignment operator
     */
    inline RemotePrepareSystemSettingRequest& operator = (const RemotePrepareSystemSettingRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemotePrepareSystemSettingRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemotePrepareSystemSettingRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemotePrepareSystemSettingRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemotePrepareSystemSettingRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sysSetType"

    static const int kSysSetType = 0;

    /**
     * Clears the field "sysSetType".
     *
     * The field will be set to its default value. The hasSysSetType()
     * method will return false.
     */
    inline void clearSysSetType();

    /**
     * Checks whether the field "sysSetType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSysSetType()). Otherwise it will return false.
     */
    inline bool hasSysSetType () const;

    /**
     * Returns the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sysSetType"
     */
    inline const ::std::string& getSysSetType () const;

    /**
     * Retrieves the value of the field "sysSetType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sysSetType".
     */
    inline ::std::string& getSysSetTypeMutable ();

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const ::std::string& sysSetType_);

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const char* sysSetType_);

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const char* value, size_t size);

    // API of field "extendedData"

    static const int kExtendedData = 1;

    /**
     * Clears the field "extendedData".
     *
     * The field will be set to its default value. The hasExtendedData()
     * method will return false.
     */
    inline void clearExtendedData();

    /**
     * Checks whether the field "extendedData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setExtendedData()). Otherwise it will return false.
     */
    inline bool hasExtendedData () const;

    /**
     * Returns the value of the member "extendedData".
     *
     * If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "extendedData"
     */
    inline const ::std::vector< RemotePrepareSystemSettingRequestExtendedDataStruct >& getExtendedData () const;

    /**
     * Retrieves the value of the field "extendedData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "extendedData".
     */
    inline ::std::vector< RemotePrepareSystemSettingRequestExtendedDataStruct >& getExtendedDataMutable ();

    /**
     * Sets the value of the member "extendedData".
     *
     * If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @param extendedData The value which will be set
     */
    inline void setExtendedData (const ::std::vector< RemotePrepareSystemSettingRequestExtendedDataStruct >& extendedData_);

    // API of field "cookie"

    static const int kCookie = 2;

    /**
     * Clears the field "cookie".
     *
     * The field will be set to its default value. The hasCookie()
     * method will return false.
     */
    inline void clearCookie();

    /**
     * Checks whether the field "cookie" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCookie()). Otherwise it will return false.
     */
    inline bool hasCookie () const;

    /**
     * Returns the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cookie"
     */
    inline uint32 getCookie () const;

    /**
     * Sets the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @param cookie The value which will be set
     */
    inline void setCookie (uint32 cookie_);

    static const RemotePrepareSystemSettingRequest &getDefaultInstance();

private:

    static const ::std::vector< RemotePrepareSystemSettingRequestExtendedDataStruct >& getRemotePrepareSystemSettingRequestExtendedDataStructList_DefaultInstance ();

    inline void set_has_sysSetType ();

    inline void clear_has_sysSetType ();

    inline void set_has_extendedData ();

    inline void clear_has_extendedData ();

    inline void set_has_cookie ();

    inline void clear_has_cookie ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _sysSetType;

    ::std::vector< RemotePrepareSystemSettingRequestExtendedDataStruct > _extendedData;

    uint32 _cookie;

};

/**
 * If the meaning of "RemotePrepareSystemSettingResponseExtendedDataStruct" isn't clear, then there should be a description here.
 */
class RemotePrepareSystemSettingResponseExtendedDataStruct {
public:

    /**
     * Default constructor
     */
    inline  RemotePrepareSystemSettingResponseExtendedDataStruct ();

    /**
     * Copy constructor
     */
    inline  RemotePrepareSystemSettingResponseExtendedDataStruct (const RemotePrepareSystemSettingResponseExtendedDataStruct &rhs);

    /**
     * All fields constructor
     */
    inline  RemotePrepareSystemSettingResponseExtendedDataStruct (uint8 elem1_, const ::std::vector< uint8 >& elem2_);

    /**
     * Destructor
     */
    inline  ~RemotePrepareSystemSettingResponseExtendedDataStruct();

    /**
     * Assignment operator
     */
    inline RemotePrepareSystemSettingResponseExtendedDataStruct& operator = (const RemotePrepareSystemSettingResponseExtendedDataStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemotePrepareSystemSettingResponseExtendedDataStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemotePrepareSystemSettingResponseExtendedDataStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemotePrepareSystemSettingResponseExtendedDataStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemotePrepareSystemSettingResponseExtendedDataStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline uint8 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (uint8 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::vector< uint8 >& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::vector< uint8 >& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::vector< uint8 >& elem2_);

    static const RemotePrepareSystemSettingResponseExtendedDataStruct &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _elem1;

    ::std::vector< uint8 > _elem2;

};

/**
 * If the meaning of "RemotePrepareSystemSettingResponse" isn't clear, then there should be a description here.
 */
class RemotePrepareSystemSettingResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemotePrepareSystemSettingResponse ();

    /**
     * Copy constructor
     */
    inline  RemotePrepareSystemSettingResponse (const RemotePrepareSystemSettingResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RemotePrepareSystemSettingResponse (const ::std::string& sysSetType_, const ::std::vector< RemotePrepareSystemSettingResponseExtendedDataStruct >& extendedData_, uint32 resultCode_, uint32 cookie_);

    /**
     * Destructor
     */
    inline virtual  ~RemotePrepareSystemSettingResponse();

    /**
     * Assignment operator
     */
    inline RemotePrepareSystemSettingResponse& operator = (const RemotePrepareSystemSettingResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemotePrepareSystemSettingResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemotePrepareSystemSettingResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemotePrepareSystemSettingResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemotePrepareSystemSettingResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sysSetType"

    static const int kSysSetType = 0;

    /**
     * Clears the field "sysSetType".
     *
     * The field will be set to its default value. The hasSysSetType()
     * method will return false.
     */
    inline void clearSysSetType();

    /**
     * Checks whether the field "sysSetType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSysSetType()). Otherwise it will return false.
     */
    inline bool hasSysSetType () const;

    /**
     * Returns the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sysSetType"
     */
    inline const ::std::string& getSysSetType () const;

    /**
     * Retrieves the value of the field "sysSetType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sysSetType".
     */
    inline ::std::string& getSysSetTypeMutable ();

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const ::std::string& sysSetType_);

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const char* sysSetType_);

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const char* value, size_t size);

    // API of field "extendedData"

    static const int kExtendedData = 1;

    /**
     * Clears the field "extendedData".
     *
     * The field will be set to its default value. The hasExtendedData()
     * method will return false.
     */
    inline void clearExtendedData();

    /**
     * Checks whether the field "extendedData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setExtendedData()). Otherwise it will return false.
     */
    inline bool hasExtendedData () const;

    /**
     * Returns the value of the member "extendedData".
     *
     * If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "extendedData"
     */
    inline const ::std::vector< RemotePrepareSystemSettingResponseExtendedDataStruct >& getExtendedData () const;

    /**
     * Retrieves the value of the field "extendedData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "extendedData".
     */
    inline ::std::vector< RemotePrepareSystemSettingResponseExtendedDataStruct >& getExtendedDataMutable ();

    /**
     * Sets the value of the member "extendedData".
     *
     * If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @param extendedData The value which will be set
     */
    inline void setExtendedData (const ::std::vector< RemotePrepareSystemSettingResponseExtendedDataStruct >& extendedData_);

    // API of field "resultCode"

    static const int kResultCode = 2;

    /**
     * Clears the field "resultCode".
     *
     * The field will be set to its default value. The hasResultCode()
     * method will return false.
     */
    inline void clearResultCode();

    /**
     * Checks whether the field "resultCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResultCode()). Otherwise it will return false.
     */
    inline bool hasResultCode () const;

    /**
     * Returns the value of the member "resultCode".
     *
     * If the meaning of "resultCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "resultCode"
     */
    inline uint32 getResultCode () const;

    /**
     * Sets the value of the member "resultCode".
     *
     * If the meaning of "resultCode" isn't clear, then there should be a description here.
     *
     * @param resultCode The value which will be set
     */
    inline void setResultCode (uint32 resultCode_);

    // API of field "cookie"

    static const int kCookie = 3;

    /**
     * Clears the field "cookie".
     *
     * The field will be set to its default value. The hasCookie()
     * method will return false.
     */
    inline void clearCookie();

    /**
     * Checks whether the field "cookie" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCookie()). Otherwise it will return false.
     */
    inline bool hasCookie () const;

    /**
     * Returns the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cookie"
     */
    inline uint32 getCookie () const;

    /**
     * Sets the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @param cookie The value which will be set
     */
    inline void setCookie (uint32 cookie_);

    static const RemotePrepareSystemSettingResponse &getDefaultInstance();

private:

    static const ::std::vector< RemotePrepareSystemSettingResponseExtendedDataStruct >& getRemotePrepareSystemSettingResponseExtendedDataStructList_DefaultInstance ();

    inline void set_has_sysSetType ();

    inline void clear_has_sysSetType ();

    inline void set_has_extendedData ();

    inline void clear_has_extendedData ();

    inline void set_has_resultCode ();

    inline void clear_has_resultCode ();

    inline void set_has_cookie ();

    inline void clear_has_cookie ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _sysSetType;

    ::std::vector< RemotePrepareSystemSettingResponseExtendedDataStruct > _extendedData;

    uint32 _resultCode;

    uint32 _cookie;

};

/**
 * If the meaning of "RemoteExecuteSystemSettingRequestExtendedDataStruct" isn't clear, then there should be a description here.
 */
class RemoteExecuteSystemSettingRequestExtendedDataStruct {
public:

    /**
     * Default constructor
     */
    inline  RemoteExecuteSystemSettingRequestExtendedDataStruct ();

    /**
     * Copy constructor
     */
    inline  RemoteExecuteSystemSettingRequestExtendedDataStruct (const RemoteExecuteSystemSettingRequestExtendedDataStruct &rhs);

    /**
     * All fields constructor
     */
    inline  RemoteExecuteSystemSettingRequestExtendedDataStruct (uint8 elem1_, const ::std::vector< uint8 >& elem2_);

    /**
     * Destructor
     */
    inline  ~RemoteExecuteSystemSettingRequestExtendedDataStruct();

    /**
     * Assignment operator
     */
    inline RemoteExecuteSystemSettingRequestExtendedDataStruct& operator = (const RemoteExecuteSystemSettingRequestExtendedDataStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoteExecuteSystemSettingRequestExtendedDataStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoteExecuteSystemSettingRequestExtendedDataStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoteExecuteSystemSettingRequestExtendedDataStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoteExecuteSystemSettingRequestExtendedDataStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline uint8 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (uint8 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::vector< uint8 >& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::vector< uint8 >& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::vector< uint8 >& elem2_);

    static const RemoteExecuteSystemSettingRequestExtendedDataStruct &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _elem1;

    ::std::vector< uint8 > _elem2;

};

/**
 * If the meaning of "RemoteExecuteSystemSettingRequest" isn't clear, then there should be a description here.
 */
class RemoteExecuteSystemSettingRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoteExecuteSystemSettingRequest ();

    /**
     * Copy constructor
     */
    inline  RemoteExecuteSystemSettingRequest (const RemoteExecuteSystemSettingRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RemoteExecuteSystemSettingRequest (const ::std::string& sysSetType_, const ::std::vector< RemoteExecuteSystemSettingRequestExtendedDataStruct >& extendedData_, uint32 cookie_);

    /**
     * Destructor
     */
    inline virtual  ~RemoteExecuteSystemSettingRequest();

    /**
     * Assignment operator
     */
    inline RemoteExecuteSystemSettingRequest& operator = (const RemoteExecuteSystemSettingRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoteExecuteSystemSettingRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoteExecuteSystemSettingRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoteExecuteSystemSettingRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoteExecuteSystemSettingRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sysSetType"

    static const int kSysSetType = 0;

    /**
     * Clears the field "sysSetType".
     *
     * The field will be set to its default value. The hasSysSetType()
     * method will return false.
     */
    inline void clearSysSetType();

    /**
     * Checks whether the field "sysSetType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSysSetType()). Otherwise it will return false.
     */
    inline bool hasSysSetType () const;

    /**
     * Returns the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sysSetType"
     */
    inline const ::std::string& getSysSetType () const;

    /**
     * Retrieves the value of the field "sysSetType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sysSetType".
     */
    inline ::std::string& getSysSetTypeMutable ();

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const ::std::string& sysSetType_);

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const char* sysSetType_);

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const char* value, size_t size);

    // API of field "extendedData"

    static const int kExtendedData = 1;

    /**
     * Clears the field "extendedData".
     *
     * The field will be set to its default value. The hasExtendedData()
     * method will return false.
     */
    inline void clearExtendedData();

    /**
     * Checks whether the field "extendedData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setExtendedData()). Otherwise it will return false.
     */
    inline bool hasExtendedData () const;

    /**
     * Returns the value of the member "extendedData".
     *
     * If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "extendedData"
     */
    inline const ::std::vector< RemoteExecuteSystemSettingRequestExtendedDataStruct >& getExtendedData () const;

    /**
     * Retrieves the value of the field "extendedData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "extendedData".
     */
    inline ::std::vector< RemoteExecuteSystemSettingRequestExtendedDataStruct >& getExtendedDataMutable ();

    /**
     * Sets the value of the member "extendedData".
     *
     * If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @param extendedData The value which will be set
     */
    inline void setExtendedData (const ::std::vector< RemoteExecuteSystemSettingRequestExtendedDataStruct >& extendedData_);

    // API of field "cookie"

    static const int kCookie = 2;

    /**
     * Clears the field "cookie".
     *
     * The field will be set to its default value. The hasCookie()
     * method will return false.
     */
    inline void clearCookie();

    /**
     * Checks whether the field "cookie" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCookie()). Otherwise it will return false.
     */
    inline bool hasCookie () const;

    /**
     * Returns the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cookie"
     */
    inline uint32 getCookie () const;

    /**
     * Sets the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @param cookie The value which will be set
     */
    inline void setCookie (uint32 cookie_);

    static const RemoteExecuteSystemSettingRequest &getDefaultInstance();

private:

    static const ::std::vector< RemoteExecuteSystemSettingRequestExtendedDataStruct >& getRemoteExecuteSystemSettingRequestExtendedDataStructList_DefaultInstance ();

    inline void set_has_sysSetType ();

    inline void clear_has_sysSetType ();

    inline void set_has_extendedData ();

    inline void clear_has_extendedData ();

    inline void set_has_cookie ();

    inline void clear_has_cookie ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _sysSetType;

    ::std::vector< RemoteExecuteSystemSettingRequestExtendedDataStruct > _extendedData;

    uint32 _cookie;

};

/**
 * If the meaning of "RemoteExecuteSystemSettingResponseExtendedDataStruct" isn't clear, then there should be a description here.
 */
class RemoteExecuteSystemSettingResponseExtendedDataStruct {
public:

    /**
     * Default constructor
     */
    inline  RemoteExecuteSystemSettingResponseExtendedDataStruct ();

    /**
     * Copy constructor
     */
    inline  RemoteExecuteSystemSettingResponseExtendedDataStruct (const RemoteExecuteSystemSettingResponseExtendedDataStruct &rhs);

    /**
     * All fields constructor
     */
    inline  RemoteExecuteSystemSettingResponseExtendedDataStruct (uint8 elem1_, const ::std::vector< uint8 >& elem2_);

    /**
     * Destructor
     */
    inline  ~RemoteExecuteSystemSettingResponseExtendedDataStruct();

    /**
     * Assignment operator
     */
    inline RemoteExecuteSystemSettingResponseExtendedDataStruct& operator = (const RemoteExecuteSystemSettingResponseExtendedDataStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoteExecuteSystemSettingResponseExtendedDataStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoteExecuteSystemSettingResponseExtendedDataStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoteExecuteSystemSettingResponseExtendedDataStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoteExecuteSystemSettingResponseExtendedDataStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline uint8 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (uint8 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::vector< uint8 >& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::vector< uint8 >& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::vector< uint8 >& elem2_);

    static const RemoteExecuteSystemSettingResponseExtendedDataStruct &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _elem1;

    ::std::vector< uint8 > _elem2;

};

/**
 * If the meaning of "RemoteExecuteSystemSettingResponse" isn't clear, then there should be a description here.
 */
class RemoteExecuteSystemSettingResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoteExecuteSystemSettingResponse ();

    /**
     * Copy constructor
     */
    inline  RemoteExecuteSystemSettingResponse (const RemoteExecuteSystemSettingResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RemoteExecuteSystemSettingResponse (const ::std::string& sysSetType_, const ::std::vector< RemoteExecuteSystemSettingResponseExtendedDataStruct >& extendedData_, uint32 resultCode_, uint32 cookie_);

    /**
     * Destructor
     */
    inline virtual  ~RemoteExecuteSystemSettingResponse();

    /**
     * Assignment operator
     */
    inline RemoteExecuteSystemSettingResponse& operator = (const RemoteExecuteSystemSettingResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoteExecuteSystemSettingResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoteExecuteSystemSettingResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoteExecuteSystemSettingResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoteExecuteSystemSettingResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sysSetType"

    static const int kSysSetType = 0;

    /**
     * Clears the field "sysSetType".
     *
     * The field will be set to its default value. The hasSysSetType()
     * method will return false.
     */
    inline void clearSysSetType();

    /**
     * Checks whether the field "sysSetType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSysSetType()). Otherwise it will return false.
     */
    inline bool hasSysSetType () const;

    /**
     * Returns the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sysSetType"
     */
    inline const ::std::string& getSysSetType () const;

    /**
     * Retrieves the value of the field "sysSetType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sysSetType".
     */
    inline ::std::string& getSysSetTypeMutable ();

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const ::std::string& sysSetType_);

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const char* sysSetType_);

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const char* value, size_t size);

    // API of field "extendedData"

    static const int kExtendedData = 1;

    /**
     * Clears the field "extendedData".
     *
     * The field will be set to its default value. The hasExtendedData()
     * method will return false.
     */
    inline void clearExtendedData();

    /**
     * Checks whether the field "extendedData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setExtendedData()). Otherwise it will return false.
     */
    inline bool hasExtendedData () const;

    /**
     * Returns the value of the member "extendedData".
     *
     * If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "extendedData"
     */
    inline const ::std::vector< RemoteExecuteSystemSettingResponseExtendedDataStruct >& getExtendedData () const;

    /**
     * Retrieves the value of the field "extendedData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "extendedData".
     */
    inline ::std::vector< RemoteExecuteSystemSettingResponseExtendedDataStruct >& getExtendedDataMutable ();

    /**
     * Sets the value of the member "extendedData".
     *
     * If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @param extendedData The value which will be set
     */
    inline void setExtendedData (const ::std::vector< RemoteExecuteSystemSettingResponseExtendedDataStruct >& extendedData_);

    // API of field "resultCode"

    static const int kResultCode = 2;

    /**
     * Clears the field "resultCode".
     *
     * The field will be set to its default value. The hasResultCode()
     * method will return false.
     */
    inline void clearResultCode();

    /**
     * Checks whether the field "resultCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResultCode()). Otherwise it will return false.
     */
    inline bool hasResultCode () const;

    /**
     * Returns the value of the member "resultCode".
     *
     * If the meaning of "resultCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "resultCode"
     */
    inline uint32 getResultCode () const;

    /**
     * Sets the value of the member "resultCode".
     *
     * If the meaning of "resultCode" isn't clear, then there should be a description here.
     *
     * @param resultCode The value which will be set
     */
    inline void setResultCode (uint32 resultCode_);

    // API of field "cookie"

    static const int kCookie = 3;

    /**
     * Clears the field "cookie".
     *
     * The field will be set to its default value. The hasCookie()
     * method will return false.
     */
    inline void clearCookie();

    /**
     * Checks whether the field "cookie" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCookie()). Otherwise it will return false.
     */
    inline bool hasCookie () const;

    /**
     * Returns the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cookie"
     */
    inline uint32 getCookie () const;

    /**
     * Sets the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @param cookie The value which will be set
     */
    inline void setCookie (uint32 cookie_);

    static const RemoteExecuteSystemSettingResponse &getDefaultInstance();

private:

    static const ::std::vector< RemoteExecuteSystemSettingResponseExtendedDataStruct >& getRemoteExecuteSystemSettingResponseExtendedDataStructList_DefaultInstance ();

    inline void set_has_sysSetType ();

    inline void clear_has_sysSetType ();

    inline void set_has_extendedData ();

    inline void clear_has_extendedData ();

    inline void set_has_resultCode ();

    inline void clear_has_resultCode ();

    inline void set_has_cookie ();

    inline void clear_has_cookie ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _sysSetType;

    ::std::vector< RemoteExecuteSystemSettingResponseExtendedDataStruct > _extendedData;

    uint32 _resultCode;

    uint32 _cookie;

};

/**
 * If the meaning of "RemoteFinalizeSystemSettingRequestExtendedDataStruct" isn't clear, then there should be a description here.
 */
class RemoteFinalizeSystemSettingRequestExtendedDataStruct {
public:

    /**
     * Default constructor
     */
    inline  RemoteFinalizeSystemSettingRequestExtendedDataStruct ();

    /**
     * Copy constructor
     */
    inline  RemoteFinalizeSystemSettingRequestExtendedDataStruct (const RemoteFinalizeSystemSettingRequestExtendedDataStruct &rhs);

    /**
     * All fields constructor
     */
    inline  RemoteFinalizeSystemSettingRequestExtendedDataStruct (uint8 elem1_, const ::std::vector< uint8 >& elem2_);

    /**
     * Destructor
     */
    inline  ~RemoteFinalizeSystemSettingRequestExtendedDataStruct();

    /**
     * Assignment operator
     */
    inline RemoteFinalizeSystemSettingRequestExtendedDataStruct& operator = (const RemoteFinalizeSystemSettingRequestExtendedDataStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoteFinalizeSystemSettingRequestExtendedDataStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoteFinalizeSystemSettingRequestExtendedDataStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoteFinalizeSystemSettingRequestExtendedDataStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoteFinalizeSystemSettingRequestExtendedDataStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline uint8 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (uint8 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::vector< uint8 >& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::vector< uint8 >& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::vector< uint8 >& elem2_);

    static const RemoteFinalizeSystemSettingRequestExtendedDataStruct &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _elem1;

    ::std::vector< uint8 > _elem2;

};

/**
 * If the meaning of "RemoteFinalizeSystemSettingRequest" isn't clear, then there should be a description here.
 */
class RemoteFinalizeSystemSettingRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoteFinalizeSystemSettingRequest ();

    /**
     * Copy constructor
     */
    inline  RemoteFinalizeSystemSettingRequest (const RemoteFinalizeSystemSettingRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RemoteFinalizeSystemSettingRequest (const ::std::string& sysSetType_, const ::std::vector< RemoteFinalizeSystemSettingRequestExtendedDataStruct >& extendedData_, uint32 cookie_);

    /**
     * Destructor
     */
    inline virtual  ~RemoteFinalizeSystemSettingRequest();

    /**
     * Assignment operator
     */
    inline RemoteFinalizeSystemSettingRequest& operator = (const RemoteFinalizeSystemSettingRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoteFinalizeSystemSettingRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoteFinalizeSystemSettingRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoteFinalizeSystemSettingRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoteFinalizeSystemSettingRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sysSetType"

    static const int kSysSetType = 0;

    /**
     * Clears the field "sysSetType".
     *
     * The field will be set to its default value. The hasSysSetType()
     * method will return false.
     */
    inline void clearSysSetType();

    /**
     * Checks whether the field "sysSetType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSysSetType()). Otherwise it will return false.
     */
    inline bool hasSysSetType () const;

    /**
     * Returns the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sysSetType"
     */
    inline const ::std::string& getSysSetType () const;

    /**
     * Retrieves the value of the field "sysSetType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sysSetType".
     */
    inline ::std::string& getSysSetTypeMutable ();

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const ::std::string& sysSetType_);

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const char* sysSetType_);

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const char* value, size_t size);

    // API of field "extendedData"

    static const int kExtendedData = 1;

    /**
     * Clears the field "extendedData".
     *
     * The field will be set to its default value. The hasExtendedData()
     * method will return false.
     */
    inline void clearExtendedData();

    /**
     * Checks whether the field "extendedData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setExtendedData()). Otherwise it will return false.
     */
    inline bool hasExtendedData () const;

    /**
     * Returns the value of the member "extendedData".
     *
     * If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "extendedData"
     */
    inline const ::std::vector< RemoteFinalizeSystemSettingRequestExtendedDataStruct >& getExtendedData () const;

    /**
     * Retrieves the value of the field "extendedData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "extendedData".
     */
    inline ::std::vector< RemoteFinalizeSystemSettingRequestExtendedDataStruct >& getExtendedDataMutable ();

    /**
     * Sets the value of the member "extendedData".
     *
     * If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @param extendedData The value which will be set
     */
    inline void setExtendedData (const ::std::vector< RemoteFinalizeSystemSettingRequestExtendedDataStruct >& extendedData_);

    // API of field "cookie"

    static const int kCookie = 2;

    /**
     * Clears the field "cookie".
     *
     * The field will be set to its default value. The hasCookie()
     * method will return false.
     */
    inline void clearCookie();

    /**
     * Checks whether the field "cookie" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCookie()). Otherwise it will return false.
     */
    inline bool hasCookie () const;

    /**
     * Returns the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cookie"
     */
    inline uint32 getCookie () const;

    /**
     * Sets the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @param cookie The value which will be set
     */
    inline void setCookie (uint32 cookie_);

    static const RemoteFinalizeSystemSettingRequest &getDefaultInstance();

private:

    static const ::std::vector< RemoteFinalizeSystemSettingRequestExtendedDataStruct >& getRemoteFinalizeSystemSettingRequestExtendedDataStructList_DefaultInstance ();

    inline void set_has_sysSetType ();

    inline void clear_has_sysSetType ();

    inline void set_has_extendedData ();

    inline void clear_has_extendedData ();

    inline void set_has_cookie ();

    inline void clear_has_cookie ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _sysSetType;

    ::std::vector< RemoteFinalizeSystemSettingRequestExtendedDataStruct > _extendedData;

    uint32 _cookie;

};

/**
 * If the meaning of "RemoteFinalizeSystemSettingResponseExtendedDataStruct" isn't clear, then there should be a description here.
 */
class RemoteFinalizeSystemSettingResponseExtendedDataStruct {
public:

    /**
     * Default constructor
     */
    inline  RemoteFinalizeSystemSettingResponseExtendedDataStruct ();

    /**
     * Copy constructor
     */
    inline  RemoteFinalizeSystemSettingResponseExtendedDataStruct (const RemoteFinalizeSystemSettingResponseExtendedDataStruct &rhs);

    /**
     * All fields constructor
     */
    inline  RemoteFinalizeSystemSettingResponseExtendedDataStruct (uint8 elem1_, const ::std::vector< uint8 >& elem2_);

    /**
     * Destructor
     */
    inline  ~RemoteFinalizeSystemSettingResponseExtendedDataStruct();

    /**
     * Assignment operator
     */
    inline RemoteFinalizeSystemSettingResponseExtendedDataStruct& operator = (const RemoteFinalizeSystemSettingResponseExtendedDataStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoteFinalizeSystemSettingResponseExtendedDataStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoteFinalizeSystemSettingResponseExtendedDataStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoteFinalizeSystemSettingResponseExtendedDataStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoteFinalizeSystemSettingResponseExtendedDataStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline uint8 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (uint8 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::vector< uint8 >& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::vector< uint8 >& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::vector< uint8 >& elem2_);

    static const RemoteFinalizeSystemSettingResponseExtendedDataStruct &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _elem1;

    ::std::vector< uint8 > _elem2;

};

/**
 * If the meaning of "RemoteFinalizeSystemSettingResponse" isn't clear, then there should be a description here.
 */
class RemoteFinalizeSystemSettingResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoteFinalizeSystemSettingResponse ();

    /**
     * Copy constructor
     */
    inline  RemoteFinalizeSystemSettingResponse (const RemoteFinalizeSystemSettingResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RemoteFinalizeSystemSettingResponse (const ::std::string& sysSetType_, const ::std::vector< RemoteFinalizeSystemSettingResponseExtendedDataStruct >& extendedData_, uint32 resultCode_, uint32 cookie_);

    /**
     * Destructor
     */
    inline virtual  ~RemoteFinalizeSystemSettingResponse();

    /**
     * Assignment operator
     */
    inline RemoteFinalizeSystemSettingResponse& operator = (const RemoteFinalizeSystemSettingResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoteFinalizeSystemSettingResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoteFinalizeSystemSettingResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoteFinalizeSystemSettingResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoteFinalizeSystemSettingResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sysSetType"

    static const int kSysSetType = 0;

    /**
     * Clears the field "sysSetType".
     *
     * The field will be set to its default value. The hasSysSetType()
     * method will return false.
     */
    inline void clearSysSetType();

    /**
     * Checks whether the field "sysSetType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSysSetType()). Otherwise it will return false.
     */
    inline bool hasSysSetType () const;

    /**
     * Returns the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sysSetType"
     */
    inline const ::std::string& getSysSetType () const;

    /**
     * Retrieves the value of the field "sysSetType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sysSetType".
     */
    inline ::std::string& getSysSetTypeMutable ();

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const ::std::string& sysSetType_);

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const char* sysSetType_);

    /**
     * Sets the value of the member "sysSetType".
     *
     * If the meaning of "sysSetType" isn't clear, then there should be a description here.
     *
     * @param sysSetType The value which will be set
     */
    inline void setSysSetType (const char* value, size_t size);

    // API of field "extendedData"

    static const int kExtendedData = 1;

    /**
     * Clears the field "extendedData".
     *
     * The field will be set to its default value. The hasExtendedData()
     * method will return false.
     */
    inline void clearExtendedData();

    /**
     * Checks whether the field "extendedData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setExtendedData()). Otherwise it will return false.
     */
    inline bool hasExtendedData () const;

    /**
     * Returns the value of the member "extendedData".
     *
     * If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "extendedData"
     */
    inline const ::std::vector< RemoteFinalizeSystemSettingResponseExtendedDataStruct >& getExtendedData () const;

    /**
     * Retrieves the value of the field "extendedData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "extendedData".
     */
    inline ::std::vector< RemoteFinalizeSystemSettingResponseExtendedDataStruct >& getExtendedDataMutable ();

    /**
     * Sets the value of the member "extendedData".
     *
     * If the meaning of "extendedData" isn't clear, then there should be a description here.
     *
     * @param extendedData The value which will be set
     */
    inline void setExtendedData (const ::std::vector< RemoteFinalizeSystemSettingResponseExtendedDataStruct >& extendedData_);

    // API of field "resultCode"

    static const int kResultCode = 2;

    /**
     * Clears the field "resultCode".
     *
     * The field will be set to its default value. The hasResultCode()
     * method will return false.
     */
    inline void clearResultCode();

    /**
     * Checks whether the field "resultCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResultCode()). Otherwise it will return false.
     */
    inline bool hasResultCode () const;

    /**
     * Returns the value of the member "resultCode".
     *
     * If the meaning of "resultCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "resultCode"
     */
    inline uint32 getResultCode () const;

    /**
     * Sets the value of the member "resultCode".
     *
     * If the meaning of "resultCode" isn't clear, then there should be a description here.
     *
     * @param resultCode The value which will be set
     */
    inline void setResultCode (uint32 resultCode_);

    // API of field "cookie"

    static const int kCookie = 3;

    /**
     * Clears the field "cookie".
     *
     * The field will be set to its default value. The hasCookie()
     * method will return false.
     */
    inline void clearCookie();

    /**
     * Checks whether the field "cookie" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCookie()). Otherwise it will return false.
     */
    inline bool hasCookie () const;

    /**
     * Returns the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cookie"
     */
    inline uint32 getCookie () const;

    /**
     * Sets the value of the member "cookie".
     *
     * If the meaning of "cookie" isn't clear, then there should be a description here.
     *
     * @param cookie The value which will be set
     */
    inline void setCookie (uint32 cookie_);

    static const RemoteFinalizeSystemSettingResponse &getDefaultInstance();

private:

    static const ::std::vector< RemoteFinalizeSystemSettingResponseExtendedDataStruct >& getRemoteFinalizeSystemSettingResponseExtendedDataStructList_DefaultInstance ();

    inline void set_has_sysSetType ();

    inline void clear_has_sysSetType ();

    inline void set_has_extendedData ();

    inline void clear_has_extendedData ();

    inline void set_has_resultCode ();

    inline void clear_has_resultCode ();

    inline void set_has_cookie ();

    inline void clear_has_cookie ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _sysSetType;

    ::std::vector< RemoteFinalizeSystemSettingResponseExtendedDataStruct > _extendedData;

    uint32 _resultCode;

    uint32 _cookie;

};

inline  SetRemoteControlModeRequest::SetRemoteControlModeRequest ()  :
    _area (),
    _mode (),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetRemoteControlModeRequest::SetRemoteControlModeRequest (const SetRemoteControlModeRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _area (),
    _mode (),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetRemoteControlModeRequest::SetRemoteControlModeRequest (const ::std::string& area_, const ::std::string& mode_, uint32 cookie_)  :
    _area (area_),
    _mode (mode_),
    _cookie (cookie_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (area_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetRemoteControlModeRequest::~SetRemoteControlModeRequest() {
}

inline SetRemoteControlModeRequest& SetRemoteControlModeRequest::operator = (const SetRemoteControlModeRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArea()) {
            setArea(rhs.getArea());
        } else {
            clearArea();
        }
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
        if (rhs.hasCookie()) {
            setCookie(rhs.getCookie());
        } else {
            clearCookie();
        }
    }
    return *this;
}

inline bool SetRemoteControlModeRequest::operator == (const SetRemoteControlModeRequest& rhs) const {
    return (((!hasArea() && !rhs.hasArea()) || getArea() == rhs.getArea()) &&
        ((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()) &&
        ((!hasCookie() && !rhs.hasCookie()) || getCookie() == rhs.getCookie()));
}

inline bool SetRemoteControlModeRequest::operator != (const SetRemoteControlModeRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetRemoteControlModeRequest::operator < (const SetRemoteControlModeRequest& rhs) const {
    if (hasArea() || rhs.hasArea()) {
        if (getArea() < rhs.getArea()) return true;
        if (getArea() > rhs.getArea()) return false;
    }
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    if (hasCookie() || rhs.hasCookie()) {
        if (getCookie() < rhs.getCookie()) return true;
        if (getCookie() > rhs.getCookie()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetRemoteControlModeRequest::clone() {
    return new SetRemoteControlModeRequest(*this);
}

inline bool SetRemoteControlModeRequest::operator > (const SetRemoteControlModeRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetRemoteControlModeRequest::clear() {
    clearArea();
    clearMode();
    clearCookie();
}

inline void SetRemoteControlModeRequest::clearArea() {
    if (hasArea()) {
         clear_has_area();
        _area.clear();
     }
}

inline bool SetRemoteControlModeRequest::hasArea () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SetRemoteControlModeRequest::getArea () const {
    return _area;
}

inline ::std::string& SetRemoteControlModeRequest::getAreaMutable () {
    set_has_area();
    return _area;
}

inline void SetRemoteControlModeRequest::setArea (const ::std::string& area_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (area_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_area();
    this->_area = area_;
}

inline void SetRemoteControlModeRequest::setArea (const char* area_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (area_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_area();
    this->_area.assign(area_);
}

inline void SetRemoteControlModeRequest::setArea (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_area();
    this->_area.assign(value, size);
}

inline void SetRemoteControlModeRequest::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode.clear();
     }
}

inline bool SetRemoteControlModeRequest::hasMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SetRemoteControlModeRequest::getMode () const {
    return _mode;
}

inline ::std::string& SetRemoteControlModeRequest::getModeMutable () {
    set_has_mode();
    return _mode;
}

inline void SetRemoteControlModeRequest::setMode (const ::std::string& mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode = mode_;
}

inline void SetRemoteControlModeRequest::setMode (const char* mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(mode_);
}

inline void SetRemoteControlModeRequest::setMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(value, size);
}

inline void SetRemoteControlModeRequest::clearCookie() {
    if (hasCookie()) {
         clear_has_cookie();
        _cookie = 0u;
     }
}

inline bool SetRemoteControlModeRequest::hasCookie () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 SetRemoteControlModeRequest::getCookie () const {
    return _cookie;
}

inline void SetRemoteControlModeRequest::setCookie (uint32 cookie_) {
    set_has_cookie();
    this->_cookie = cookie_;
}

inline void SetRemoteControlModeRequest::set_has_area () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetRemoteControlModeRequest::clear_has_area () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetRemoteControlModeRequest::set_has_mode () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetRemoteControlModeRequest::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SetRemoteControlModeRequest::set_has_cookie () {
    _has_bits_[0] |= 1u << 2;
}

inline void SetRemoteControlModeRequest::clear_has_cookie () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SetRemoteControlModeResponse::SetRemoteControlModeResponse ()  :
    _area (),
    _mode (),
    _resultCode (0u),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetRemoteControlModeResponse::SetRemoteControlModeResponse (const SetRemoteControlModeResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _area (),
    _mode (),
    _resultCode (0u),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetRemoteControlModeResponse::SetRemoteControlModeResponse (const ::std::string& area_, const ::std::string& mode_, uint32 resultCode_, uint32 cookie_)  :
    _area (area_),
    _mode (mode_),
    _resultCode (resultCode_),
    _cookie (cookie_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (area_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetRemoteControlModeResponse::~SetRemoteControlModeResponse() {
}

inline SetRemoteControlModeResponse& SetRemoteControlModeResponse::operator = (const SetRemoteControlModeResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArea()) {
            setArea(rhs.getArea());
        } else {
            clearArea();
        }
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
        if (rhs.hasResultCode()) {
            setResultCode(rhs.getResultCode());
        } else {
            clearResultCode();
        }
        if (rhs.hasCookie()) {
            setCookie(rhs.getCookie());
        } else {
            clearCookie();
        }
    }
    return *this;
}

inline bool SetRemoteControlModeResponse::operator == (const SetRemoteControlModeResponse& rhs) const {
    return (((!hasArea() && !rhs.hasArea()) || getArea() == rhs.getArea()) &&
        ((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()) &&
        ((!hasResultCode() && !rhs.hasResultCode()) || getResultCode() == rhs.getResultCode()) &&
        ((!hasCookie() && !rhs.hasCookie()) || getCookie() == rhs.getCookie()));
}

inline bool SetRemoteControlModeResponse::operator != (const SetRemoteControlModeResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetRemoteControlModeResponse::operator < (const SetRemoteControlModeResponse& rhs) const {
    if (hasArea() || rhs.hasArea()) {
        if (getArea() < rhs.getArea()) return true;
        if (getArea() > rhs.getArea()) return false;
    }
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    if (hasResultCode() || rhs.hasResultCode()) {
        if (getResultCode() < rhs.getResultCode()) return true;
        if (getResultCode() > rhs.getResultCode()) return false;
    }
    if (hasCookie() || rhs.hasCookie()) {
        if (getCookie() < rhs.getCookie()) return true;
        if (getCookie() > rhs.getCookie()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetRemoteControlModeResponse::clone() {
    return new SetRemoteControlModeResponse(*this);
}

inline bool SetRemoteControlModeResponse::operator > (const SetRemoteControlModeResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetRemoteControlModeResponse::clear() {
    clearArea();
    clearMode();
    clearResultCode();
    clearCookie();
}

inline void SetRemoteControlModeResponse::clearArea() {
    if (hasArea()) {
         clear_has_area();
        _area.clear();
     }
}

inline bool SetRemoteControlModeResponse::hasArea () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SetRemoteControlModeResponse::getArea () const {
    return _area;
}

inline ::std::string& SetRemoteControlModeResponse::getAreaMutable () {
    set_has_area();
    return _area;
}

inline void SetRemoteControlModeResponse::setArea (const ::std::string& area_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (area_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_area();
    this->_area = area_;
}

inline void SetRemoteControlModeResponse::setArea (const char* area_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (area_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_area();
    this->_area.assign(area_);
}

inline void SetRemoteControlModeResponse::setArea (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_area();
    this->_area.assign(value, size);
}

inline void SetRemoteControlModeResponse::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode.clear();
     }
}

inline bool SetRemoteControlModeResponse::hasMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SetRemoteControlModeResponse::getMode () const {
    return _mode;
}

inline ::std::string& SetRemoteControlModeResponse::getModeMutable () {
    set_has_mode();
    return _mode;
}

inline void SetRemoteControlModeResponse::setMode (const ::std::string& mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode = mode_;
}

inline void SetRemoteControlModeResponse::setMode (const char* mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(mode_);
}

inline void SetRemoteControlModeResponse::setMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(value, size);
}

inline void SetRemoteControlModeResponse::clearResultCode() {
    if (hasResultCode()) {
         clear_has_resultCode();
        _resultCode = 0u;
     }
}

inline bool SetRemoteControlModeResponse::hasResultCode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 SetRemoteControlModeResponse::getResultCode () const {
    return _resultCode;
}

inline void SetRemoteControlModeResponse::setResultCode (uint32 resultCode_) {
    set_has_resultCode();
    this->_resultCode = resultCode_;
}

inline void SetRemoteControlModeResponse::clearCookie() {
    if (hasCookie()) {
         clear_has_cookie();
        _cookie = 0u;
     }
}

inline bool SetRemoteControlModeResponse::hasCookie () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 SetRemoteControlModeResponse::getCookie () const {
    return _cookie;
}

inline void SetRemoteControlModeResponse::setCookie (uint32 cookie_) {
    set_has_cookie();
    this->_cookie = cookie_;
}

inline void SetRemoteControlModeResponse::set_has_area () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetRemoteControlModeResponse::clear_has_area () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetRemoteControlModeResponse::set_has_mode () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetRemoteControlModeResponse::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SetRemoteControlModeResponse::set_has_resultCode () {
    _has_bits_[0] |= 1u << 2;
}

inline void SetRemoteControlModeResponse::clear_has_resultCode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SetRemoteControlModeResponse::set_has_cookie () {
    _has_bits_[0] |= 1u << 3;
}

inline void SetRemoteControlModeResponse::clear_has_cookie () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  GetRemoteControlModeRequest::GetRemoteControlModeRequest ()  :
    _area (),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetRemoteControlModeRequest::GetRemoteControlModeRequest (const GetRemoteControlModeRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _area (),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetRemoteControlModeRequest::GetRemoteControlModeRequest (const ::std::string& area_, uint32 cookie_)  :
    _area (area_),
    _cookie (cookie_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (area_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetRemoteControlModeRequest::~GetRemoteControlModeRequest() {
}

inline GetRemoteControlModeRequest& GetRemoteControlModeRequest::operator = (const GetRemoteControlModeRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArea()) {
            setArea(rhs.getArea());
        } else {
            clearArea();
        }
        if (rhs.hasCookie()) {
            setCookie(rhs.getCookie());
        } else {
            clearCookie();
        }
    }
    return *this;
}

inline bool GetRemoteControlModeRequest::operator == (const GetRemoteControlModeRequest& rhs) const {
    return (((!hasArea() && !rhs.hasArea()) || getArea() == rhs.getArea()) &&
        ((!hasCookie() && !rhs.hasCookie()) || getCookie() == rhs.getCookie()));
}

inline bool GetRemoteControlModeRequest::operator != (const GetRemoteControlModeRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetRemoteControlModeRequest::operator < (const GetRemoteControlModeRequest& rhs) const {
    if (hasArea() || rhs.hasArea()) {
        if (getArea() < rhs.getArea()) return true;
        if (getArea() > rhs.getArea()) return false;
    }
    if (hasCookie() || rhs.hasCookie()) {
        if (getCookie() < rhs.getCookie()) return true;
        if (getCookie() > rhs.getCookie()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetRemoteControlModeRequest::clone() {
    return new GetRemoteControlModeRequest(*this);
}

inline bool GetRemoteControlModeRequest::operator > (const GetRemoteControlModeRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetRemoteControlModeRequest::clear() {
    clearArea();
    clearCookie();
}

inline void GetRemoteControlModeRequest::clearArea() {
    if (hasArea()) {
         clear_has_area();
        _area.clear();
     }
}

inline bool GetRemoteControlModeRequest::hasArea () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetRemoteControlModeRequest::getArea () const {
    return _area;
}

inline ::std::string& GetRemoteControlModeRequest::getAreaMutable () {
    set_has_area();
    return _area;
}

inline void GetRemoteControlModeRequest::setArea (const ::std::string& area_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (area_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_area();
    this->_area = area_;
}

inline void GetRemoteControlModeRequest::setArea (const char* area_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (area_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_area();
    this->_area.assign(area_);
}

inline void GetRemoteControlModeRequest::setArea (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_area();
    this->_area.assign(value, size);
}

inline void GetRemoteControlModeRequest::clearCookie() {
    if (hasCookie()) {
         clear_has_cookie();
        _cookie = 0u;
     }
}

inline bool GetRemoteControlModeRequest::hasCookie () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 GetRemoteControlModeRequest::getCookie () const {
    return _cookie;
}

inline void GetRemoteControlModeRequest::setCookie (uint32 cookie_) {
    set_has_cookie();
    this->_cookie = cookie_;
}

inline void GetRemoteControlModeRequest::set_has_area () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetRemoteControlModeRequest::clear_has_area () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetRemoteControlModeRequest::set_has_cookie () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetRemoteControlModeRequest::clear_has_cookie () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetRemoteControlModeResponse::GetRemoteControlModeResponse ()  :
    _area (),
    _mode (),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetRemoteControlModeResponse::GetRemoteControlModeResponse (const GetRemoteControlModeResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _area (),
    _mode (),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetRemoteControlModeResponse::GetRemoteControlModeResponse (const ::std::string& area_, const ::std::string& mode_, uint32 cookie_)  :
    _area (area_),
    _mode (mode_),
    _cookie (cookie_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (area_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetRemoteControlModeResponse::~GetRemoteControlModeResponse() {
}

inline GetRemoteControlModeResponse& GetRemoteControlModeResponse::operator = (const GetRemoteControlModeResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArea()) {
            setArea(rhs.getArea());
        } else {
            clearArea();
        }
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
        if (rhs.hasCookie()) {
            setCookie(rhs.getCookie());
        } else {
            clearCookie();
        }
    }
    return *this;
}

inline bool GetRemoteControlModeResponse::operator == (const GetRemoteControlModeResponse& rhs) const {
    return (((!hasArea() && !rhs.hasArea()) || getArea() == rhs.getArea()) &&
        ((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()) &&
        ((!hasCookie() && !rhs.hasCookie()) || getCookie() == rhs.getCookie()));
}

inline bool GetRemoteControlModeResponse::operator != (const GetRemoteControlModeResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetRemoteControlModeResponse::operator < (const GetRemoteControlModeResponse& rhs) const {
    if (hasArea() || rhs.hasArea()) {
        if (getArea() < rhs.getArea()) return true;
        if (getArea() > rhs.getArea()) return false;
    }
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    if (hasCookie() || rhs.hasCookie()) {
        if (getCookie() < rhs.getCookie()) return true;
        if (getCookie() > rhs.getCookie()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetRemoteControlModeResponse::clone() {
    return new GetRemoteControlModeResponse(*this);
}

inline bool GetRemoteControlModeResponse::operator > (const GetRemoteControlModeResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetRemoteControlModeResponse::clear() {
    clearArea();
    clearMode();
    clearCookie();
}

inline void GetRemoteControlModeResponse::clearArea() {
    if (hasArea()) {
         clear_has_area();
        _area.clear();
     }
}

inline bool GetRemoteControlModeResponse::hasArea () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetRemoteControlModeResponse::getArea () const {
    return _area;
}

inline ::std::string& GetRemoteControlModeResponse::getAreaMutable () {
    set_has_area();
    return _area;
}

inline void GetRemoteControlModeResponse::setArea (const ::std::string& area_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (area_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_area();
    this->_area = area_;
}

inline void GetRemoteControlModeResponse::setArea (const char* area_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (area_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_area();
    this->_area.assign(area_);
}

inline void GetRemoteControlModeResponse::setArea (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_area();
    this->_area.assign(value, size);
}

inline void GetRemoteControlModeResponse::clearMode() {
    if (hasMode()) {
         clear_has_mode();
        _mode.clear();
     }
}

inline bool GetRemoteControlModeResponse::hasMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& GetRemoteControlModeResponse::getMode () const {
    return _mode;
}

inline ::std::string& GetRemoteControlModeResponse::getModeMutable () {
    set_has_mode();
    return _mode;
}

inline void GetRemoteControlModeResponse::setMode (const ::std::string& mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode = mode_;
}

inline void GetRemoteControlModeResponse::setMode (const char* mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(mode_);
}

inline void GetRemoteControlModeResponse::setMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_mode();
    this->_mode.assign(value, size);
}

inline void GetRemoteControlModeResponse::clearCookie() {
    if (hasCookie()) {
         clear_has_cookie();
        _cookie = 0u;
     }
}

inline bool GetRemoteControlModeResponse::hasCookie () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 GetRemoteControlModeResponse::getCookie () const {
    return _cookie;
}

inline void GetRemoteControlModeResponse::setCookie (uint32 cookie_) {
    set_has_cookie();
    this->_cookie = cookie_;
}

inline void GetRemoteControlModeResponse::set_has_area () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetRemoteControlModeResponse::clear_has_area () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetRemoteControlModeResponse::set_has_mode () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetRemoteControlModeResponse::clear_has_mode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetRemoteControlModeResponse::set_has_cookie () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetRemoteControlModeResponse::clear_has_cookie () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  StartSystemSettingRequestExtendedDataStruct::StartSystemSettingRequestExtendedDataStruct ()  :
    _elem1 (0u),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartSystemSettingRequestExtendedDataStruct::StartSystemSettingRequestExtendedDataStruct (const StartSystemSettingRequestExtendedDataStruct &rhs)  :
    _elem1 (0u),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartSystemSettingRequestExtendedDataStruct::StartSystemSettingRequestExtendedDataStruct (uint8 elem1_, const ::std::vector< uint8 >& elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartSystemSettingRequestExtendedDataStruct::~StartSystemSettingRequestExtendedDataStruct() {
}

inline StartSystemSettingRequestExtendedDataStruct& StartSystemSettingRequestExtendedDataStruct::operator = (const StartSystemSettingRequestExtendedDataStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool StartSystemSettingRequestExtendedDataStruct::operator == (const StartSystemSettingRequestExtendedDataStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool StartSystemSettingRequestExtendedDataStruct::operator != (const StartSystemSettingRequestExtendedDataStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool StartSystemSettingRequestExtendedDataStruct::operator < (const StartSystemSettingRequestExtendedDataStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool StartSystemSettingRequestExtendedDataStruct::operator > (const StartSystemSettingRequestExtendedDataStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartSystemSettingRequestExtendedDataStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void StartSystemSettingRequestExtendedDataStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0u;
     }
}

inline bool StartSystemSettingRequestExtendedDataStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 StartSystemSettingRequestExtendedDataStruct::getElem1 () const {
    return _elem1;
}

inline void StartSystemSettingRequestExtendedDataStruct::setElem1 (uint8 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void StartSystemSettingRequestExtendedDataStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool StartSystemSettingRequestExtendedDataStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& StartSystemSettingRequestExtendedDataStruct::getElem2 () const {
    return _elem2;
}

inline ::std::vector< uint8 >& StartSystemSettingRequestExtendedDataStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void StartSystemSettingRequestExtendedDataStruct::setElem2 (const ::std::vector< uint8 >& elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void StartSystemSettingRequestExtendedDataStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartSystemSettingRequestExtendedDataStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StartSystemSettingRequestExtendedDataStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void StartSystemSettingRequestExtendedDataStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  StartSystemSettingRequest::StartSystemSettingRequest ()  :
    _sysSetType (),
    _extendedData (),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartSystemSettingRequest::StartSystemSettingRequest (const StartSystemSettingRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _sysSetType (),
    _extendedData (),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartSystemSettingRequest::StartSystemSettingRequest (const ::std::string& sysSetType_, const ::std::vector< StartSystemSettingRequestExtendedDataStruct >& extendedData_, uint32 cookie_)  :
    _sysSetType (sysSetType_),
    _extendedData (extendedData_),
    _cookie (cookie_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartSystemSettingRequest::~StartSystemSettingRequest() {
}

inline StartSystemSettingRequest& StartSystemSettingRequest::operator = (const StartSystemSettingRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSysSetType()) {
            setSysSetType(rhs.getSysSetType());
        } else {
            clearSysSetType();
        }
        if (rhs.hasExtendedData()) {
            setExtendedData(rhs.getExtendedData());
        } else {
            clearExtendedData();
        }
        if (rhs.hasCookie()) {
            setCookie(rhs.getCookie());
        } else {
            clearCookie();
        }
    }
    return *this;
}

inline bool StartSystemSettingRequest::operator == (const StartSystemSettingRequest& rhs) const {
    return (((!hasSysSetType() && !rhs.hasSysSetType()) || getSysSetType() == rhs.getSysSetType()) &&
        ((!hasExtendedData() && !rhs.hasExtendedData()) || getExtendedData() == rhs.getExtendedData()) &&
        ((!hasCookie() && !rhs.hasCookie()) || getCookie() == rhs.getCookie()));
}

inline bool StartSystemSettingRequest::operator != (const StartSystemSettingRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool StartSystemSettingRequest::operator < (const StartSystemSettingRequest& rhs) const {
    if (hasSysSetType() || rhs.hasSysSetType()) {
        if (getSysSetType() < rhs.getSysSetType()) return true;
        if (getSysSetType() > rhs.getSysSetType()) return false;
    }
    if (hasExtendedData() || rhs.hasExtendedData()) {
        if (getExtendedData() < rhs.getExtendedData()) return true;
        if (getExtendedData() > rhs.getExtendedData()) return false;
    }
    if (hasCookie() || rhs.hasCookie()) {
        if (getCookie() < rhs.getCookie()) return true;
        if (getCookie() > rhs.getCookie()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartSystemSettingRequest::clone() {
    return new StartSystemSettingRequest(*this);
}

inline bool StartSystemSettingRequest::operator > (const StartSystemSettingRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartSystemSettingRequest::clear() {
    clearSysSetType();
    clearExtendedData();
    clearCookie();
}

inline void StartSystemSettingRequest::clearSysSetType() {
    if (hasSysSetType()) {
         clear_has_sysSetType();
        _sysSetType.clear();
     }
}

inline bool StartSystemSettingRequest::hasSysSetType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StartSystemSettingRequest::getSysSetType () const {
    return _sysSetType;
}

inline ::std::string& StartSystemSettingRequest::getSysSetTypeMutable () {
    set_has_sysSetType();
    return _sysSetType;
}

inline void StartSystemSettingRequest::setSysSetType (const ::std::string& sysSetType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType = sysSetType_;
}

inline void StartSystemSettingRequest::setSysSetType (const char* sysSetType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType.assign(sysSetType_);
}

inline void StartSystemSettingRequest::setSysSetType (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType.assign(value, size);
}

inline void StartSystemSettingRequest::clearExtendedData() {
    if (hasExtendedData()) {
         clear_has_extendedData();
        _extendedData.clear();
     }
}

inline bool StartSystemSettingRequest::hasExtendedData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< StartSystemSettingRequestExtendedDataStruct >& StartSystemSettingRequest::getExtendedData () const {
    return _extendedData;
}

inline ::std::vector< StartSystemSettingRequestExtendedDataStruct >& StartSystemSettingRequest::getExtendedDataMutable () {
    set_has_extendedData();
    return _extendedData;
}

inline void StartSystemSettingRequest::setExtendedData (const ::std::vector< StartSystemSettingRequestExtendedDataStruct >& extendedData_) {
    set_has_extendedData();
    this->_extendedData = extendedData_;
}

inline void StartSystemSettingRequest::clearCookie() {
    if (hasCookie()) {
         clear_has_cookie();
        _cookie = 0u;
     }
}

inline bool StartSystemSettingRequest::hasCookie () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 StartSystemSettingRequest::getCookie () const {
    return _cookie;
}

inline void StartSystemSettingRequest::setCookie (uint32 cookie_) {
    set_has_cookie();
    this->_cookie = cookie_;
}

inline void StartSystemSettingRequest::set_has_sysSetType () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartSystemSettingRequest::clear_has_sysSetType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StartSystemSettingRequest::set_has_extendedData () {
    _has_bits_[0] |= 1u << 1;
}

inline void StartSystemSettingRequest::clear_has_extendedData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void StartSystemSettingRequest::set_has_cookie () {
    _has_bits_[0] |= 1u << 2;
}

inline void StartSystemSettingRequest::clear_has_cookie () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  StartSystemSettingResponseExtendedDataStruct::StartSystemSettingResponseExtendedDataStruct ()  :
    _elem1 (0u),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartSystemSettingResponseExtendedDataStruct::StartSystemSettingResponseExtendedDataStruct (const StartSystemSettingResponseExtendedDataStruct &rhs)  :
    _elem1 (0u),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartSystemSettingResponseExtendedDataStruct::StartSystemSettingResponseExtendedDataStruct (uint8 elem1_, const ::std::vector< uint8 >& elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartSystemSettingResponseExtendedDataStruct::~StartSystemSettingResponseExtendedDataStruct() {
}

inline StartSystemSettingResponseExtendedDataStruct& StartSystemSettingResponseExtendedDataStruct::operator = (const StartSystemSettingResponseExtendedDataStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool StartSystemSettingResponseExtendedDataStruct::operator == (const StartSystemSettingResponseExtendedDataStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool StartSystemSettingResponseExtendedDataStruct::operator != (const StartSystemSettingResponseExtendedDataStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool StartSystemSettingResponseExtendedDataStruct::operator < (const StartSystemSettingResponseExtendedDataStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool StartSystemSettingResponseExtendedDataStruct::operator > (const StartSystemSettingResponseExtendedDataStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartSystemSettingResponseExtendedDataStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void StartSystemSettingResponseExtendedDataStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0u;
     }
}

inline bool StartSystemSettingResponseExtendedDataStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 StartSystemSettingResponseExtendedDataStruct::getElem1 () const {
    return _elem1;
}

inline void StartSystemSettingResponseExtendedDataStruct::setElem1 (uint8 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void StartSystemSettingResponseExtendedDataStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool StartSystemSettingResponseExtendedDataStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& StartSystemSettingResponseExtendedDataStruct::getElem2 () const {
    return _elem2;
}

inline ::std::vector< uint8 >& StartSystemSettingResponseExtendedDataStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void StartSystemSettingResponseExtendedDataStruct::setElem2 (const ::std::vector< uint8 >& elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void StartSystemSettingResponseExtendedDataStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartSystemSettingResponseExtendedDataStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StartSystemSettingResponseExtendedDataStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void StartSystemSettingResponseExtendedDataStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  StartSystemSettingResponse::StartSystemSettingResponse ()  :
    _sysSetType (),
    _extendedData (),
    _resultCode (0u),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartSystemSettingResponse::StartSystemSettingResponse (const StartSystemSettingResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _sysSetType (),
    _extendedData (),
    _resultCode (0u),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartSystemSettingResponse::StartSystemSettingResponse (const ::std::string& sysSetType_, const ::std::vector< StartSystemSettingResponseExtendedDataStruct >& extendedData_, uint32 resultCode_, uint32 cookie_)  :
    _sysSetType (sysSetType_),
    _extendedData (extendedData_),
    _resultCode (resultCode_),
    _cookie (cookie_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartSystemSettingResponse::~StartSystemSettingResponse() {
}

inline StartSystemSettingResponse& StartSystemSettingResponse::operator = (const StartSystemSettingResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSysSetType()) {
            setSysSetType(rhs.getSysSetType());
        } else {
            clearSysSetType();
        }
        if (rhs.hasExtendedData()) {
            setExtendedData(rhs.getExtendedData());
        } else {
            clearExtendedData();
        }
        if (rhs.hasResultCode()) {
            setResultCode(rhs.getResultCode());
        } else {
            clearResultCode();
        }
        if (rhs.hasCookie()) {
            setCookie(rhs.getCookie());
        } else {
            clearCookie();
        }
    }
    return *this;
}

inline bool StartSystemSettingResponse::operator == (const StartSystemSettingResponse& rhs) const {
    return (((!hasSysSetType() && !rhs.hasSysSetType()) || getSysSetType() == rhs.getSysSetType()) &&
        ((!hasExtendedData() && !rhs.hasExtendedData()) || getExtendedData() == rhs.getExtendedData()) &&
        ((!hasResultCode() && !rhs.hasResultCode()) || getResultCode() == rhs.getResultCode()) &&
        ((!hasCookie() && !rhs.hasCookie()) || getCookie() == rhs.getCookie()));
}

inline bool StartSystemSettingResponse::operator != (const StartSystemSettingResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool StartSystemSettingResponse::operator < (const StartSystemSettingResponse& rhs) const {
    if (hasSysSetType() || rhs.hasSysSetType()) {
        if (getSysSetType() < rhs.getSysSetType()) return true;
        if (getSysSetType() > rhs.getSysSetType()) return false;
    }
    if (hasExtendedData() || rhs.hasExtendedData()) {
        if (getExtendedData() < rhs.getExtendedData()) return true;
        if (getExtendedData() > rhs.getExtendedData()) return false;
    }
    if (hasResultCode() || rhs.hasResultCode()) {
        if (getResultCode() < rhs.getResultCode()) return true;
        if (getResultCode() > rhs.getResultCode()) return false;
    }
    if (hasCookie() || rhs.hasCookie()) {
        if (getCookie() < rhs.getCookie()) return true;
        if (getCookie() > rhs.getCookie()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartSystemSettingResponse::clone() {
    return new StartSystemSettingResponse(*this);
}

inline bool StartSystemSettingResponse::operator > (const StartSystemSettingResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartSystemSettingResponse::clear() {
    clearSysSetType();
    clearExtendedData();
    clearResultCode();
    clearCookie();
}

inline void StartSystemSettingResponse::clearSysSetType() {
    if (hasSysSetType()) {
         clear_has_sysSetType();
        _sysSetType.clear();
     }
}

inline bool StartSystemSettingResponse::hasSysSetType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StartSystemSettingResponse::getSysSetType () const {
    return _sysSetType;
}

inline ::std::string& StartSystemSettingResponse::getSysSetTypeMutable () {
    set_has_sysSetType();
    return _sysSetType;
}

inline void StartSystemSettingResponse::setSysSetType (const ::std::string& sysSetType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType = sysSetType_;
}

inline void StartSystemSettingResponse::setSysSetType (const char* sysSetType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType.assign(sysSetType_);
}

inline void StartSystemSettingResponse::setSysSetType (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType.assign(value, size);
}

inline void StartSystemSettingResponse::clearExtendedData() {
    if (hasExtendedData()) {
         clear_has_extendedData();
        _extendedData.clear();
     }
}

inline bool StartSystemSettingResponse::hasExtendedData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< StartSystemSettingResponseExtendedDataStruct >& StartSystemSettingResponse::getExtendedData () const {
    return _extendedData;
}

inline ::std::vector< StartSystemSettingResponseExtendedDataStruct >& StartSystemSettingResponse::getExtendedDataMutable () {
    set_has_extendedData();
    return _extendedData;
}

inline void StartSystemSettingResponse::setExtendedData (const ::std::vector< StartSystemSettingResponseExtendedDataStruct >& extendedData_) {
    set_has_extendedData();
    this->_extendedData = extendedData_;
}

inline void StartSystemSettingResponse::clearResultCode() {
    if (hasResultCode()) {
         clear_has_resultCode();
        _resultCode = 0u;
     }
}

inline bool StartSystemSettingResponse::hasResultCode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 StartSystemSettingResponse::getResultCode () const {
    return _resultCode;
}

inline void StartSystemSettingResponse::setResultCode (uint32 resultCode_) {
    set_has_resultCode();
    this->_resultCode = resultCode_;
}

inline void StartSystemSettingResponse::clearCookie() {
    if (hasCookie()) {
         clear_has_cookie();
        _cookie = 0u;
     }
}

inline bool StartSystemSettingResponse::hasCookie () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 StartSystemSettingResponse::getCookie () const {
    return _cookie;
}

inline void StartSystemSettingResponse::setCookie (uint32 cookie_) {
    set_has_cookie();
    this->_cookie = cookie_;
}

inline void StartSystemSettingResponse::set_has_sysSetType () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartSystemSettingResponse::clear_has_sysSetType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StartSystemSettingResponse::set_has_extendedData () {
    _has_bits_[0] |= 1u << 1;
}

inline void StartSystemSettingResponse::clear_has_extendedData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void StartSystemSettingResponse::set_has_resultCode () {
    _has_bits_[0] |= 1u << 2;
}

inline void StartSystemSettingResponse::clear_has_resultCode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void StartSystemSettingResponse::set_has_cookie () {
    _has_bits_[0] |= 1u << 3;
}

inline void StartSystemSettingResponse::clear_has_cookie () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  RemotePrepareSystemSettingRequestExtendedDataStruct::RemotePrepareSystemSettingRequestExtendedDataStruct ()  :
    _elem1 (0u),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemotePrepareSystemSettingRequestExtendedDataStruct::RemotePrepareSystemSettingRequestExtendedDataStruct (const RemotePrepareSystemSettingRequestExtendedDataStruct &rhs)  :
    _elem1 (0u),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemotePrepareSystemSettingRequestExtendedDataStruct::RemotePrepareSystemSettingRequestExtendedDataStruct (uint8 elem1_, const ::std::vector< uint8 >& elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemotePrepareSystemSettingRequestExtendedDataStruct::~RemotePrepareSystemSettingRequestExtendedDataStruct() {
}

inline RemotePrepareSystemSettingRequestExtendedDataStruct& RemotePrepareSystemSettingRequestExtendedDataStruct::operator = (const RemotePrepareSystemSettingRequestExtendedDataStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool RemotePrepareSystemSettingRequestExtendedDataStruct::operator == (const RemotePrepareSystemSettingRequestExtendedDataStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool RemotePrepareSystemSettingRequestExtendedDataStruct::operator != (const RemotePrepareSystemSettingRequestExtendedDataStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool RemotePrepareSystemSettingRequestExtendedDataStruct::operator < (const RemotePrepareSystemSettingRequestExtendedDataStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool RemotePrepareSystemSettingRequestExtendedDataStruct::operator > (const RemotePrepareSystemSettingRequestExtendedDataStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemotePrepareSystemSettingRequestExtendedDataStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void RemotePrepareSystemSettingRequestExtendedDataStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0u;
     }
}

inline bool RemotePrepareSystemSettingRequestExtendedDataStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 RemotePrepareSystemSettingRequestExtendedDataStruct::getElem1 () const {
    return _elem1;
}

inline void RemotePrepareSystemSettingRequestExtendedDataStruct::setElem1 (uint8 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void RemotePrepareSystemSettingRequestExtendedDataStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool RemotePrepareSystemSettingRequestExtendedDataStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& RemotePrepareSystemSettingRequestExtendedDataStruct::getElem2 () const {
    return _elem2;
}

inline ::std::vector< uint8 >& RemotePrepareSystemSettingRequestExtendedDataStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void RemotePrepareSystemSettingRequestExtendedDataStruct::setElem2 (const ::std::vector< uint8 >& elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void RemotePrepareSystemSettingRequestExtendedDataStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemotePrepareSystemSettingRequestExtendedDataStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RemotePrepareSystemSettingRequestExtendedDataStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void RemotePrepareSystemSettingRequestExtendedDataStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RemotePrepareSystemSettingRequest::RemotePrepareSystemSettingRequest ()  :
    _sysSetType (),
    _extendedData (),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemotePrepareSystemSettingRequest::RemotePrepareSystemSettingRequest (const RemotePrepareSystemSettingRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _sysSetType (),
    _extendedData (),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemotePrepareSystemSettingRequest::RemotePrepareSystemSettingRequest (const ::std::string& sysSetType_, const ::std::vector< RemotePrepareSystemSettingRequestExtendedDataStruct >& extendedData_, uint32 cookie_)  :
    _sysSetType (sysSetType_),
    _extendedData (extendedData_),
    _cookie (cookie_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemotePrepareSystemSettingRequest::~RemotePrepareSystemSettingRequest() {
}

inline RemotePrepareSystemSettingRequest& RemotePrepareSystemSettingRequest::operator = (const RemotePrepareSystemSettingRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSysSetType()) {
            setSysSetType(rhs.getSysSetType());
        } else {
            clearSysSetType();
        }
        if (rhs.hasExtendedData()) {
            setExtendedData(rhs.getExtendedData());
        } else {
            clearExtendedData();
        }
        if (rhs.hasCookie()) {
            setCookie(rhs.getCookie());
        } else {
            clearCookie();
        }
    }
    return *this;
}

inline bool RemotePrepareSystemSettingRequest::operator == (const RemotePrepareSystemSettingRequest& rhs) const {
    return (((!hasSysSetType() && !rhs.hasSysSetType()) || getSysSetType() == rhs.getSysSetType()) &&
        ((!hasExtendedData() && !rhs.hasExtendedData()) || getExtendedData() == rhs.getExtendedData()) &&
        ((!hasCookie() && !rhs.hasCookie()) || getCookie() == rhs.getCookie()));
}

inline bool RemotePrepareSystemSettingRequest::operator != (const RemotePrepareSystemSettingRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RemotePrepareSystemSettingRequest::operator < (const RemotePrepareSystemSettingRequest& rhs) const {
    if (hasSysSetType() || rhs.hasSysSetType()) {
        if (getSysSetType() < rhs.getSysSetType()) return true;
        if (getSysSetType() > rhs.getSysSetType()) return false;
    }
    if (hasExtendedData() || rhs.hasExtendedData()) {
        if (getExtendedData() < rhs.getExtendedData()) return true;
        if (getExtendedData() > rhs.getExtendedData()) return false;
    }
    if (hasCookie() || rhs.hasCookie()) {
        if (getCookie() < rhs.getCookie()) return true;
        if (getCookie() > rhs.getCookie()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemotePrepareSystemSettingRequest::clone() {
    return new RemotePrepareSystemSettingRequest(*this);
}

inline bool RemotePrepareSystemSettingRequest::operator > (const RemotePrepareSystemSettingRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemotePrepareSystemSettingRequest::clear() {
    clearSysSetType();
    clearExtendedData();
    clearCookie();
}

inline void RemotePrepareSystemSettingRequest::clearSysSetType() {
    if (hasSysSetType()) {
         clear_has_sysSetType();
        _sysSetType.clear();
     }
}

inline bool RemotePrepareSystemSettingRequest::hasSysSetType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RemotePrepareSystemSettingRequest::getSysSetType () const {
    return _sysSetType;
}

inline ::std::string& RemotePrepareSystemSettingRequest::getSysSetTypeMutable () {
    set_has_sysSetType();
    return _sysSetType;
}

inline void RemotePrepareSystemSettingRequest::setSysSetType (const ::std::string& sysSetType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType = sysSetType_;
}

inline void RemotePrepareSystemSettingRequest::setSysSetType (const char* sysSetType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType.assign(sysSetType_);
}

inline void RemotePrepareSystemSettingRequest::setSysSetType (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType.assign(value, size);
}

inline void RemotePrepareSystemSettingRequest::clearExtendedData() {
    if (hasExtendedData()) {
         clear_has_extendedData();
        _extendedData.clear();
     }
}

inline bool RemotePrepareSystemSettingRequest::hasExtendedData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< RemotePrepareSystemSettingRequestExtendedDataStruct >& RemotePrepareSystemSettingRequest::getExtendedData () const {
    return _extendedData;
}

inline ::std::vector< RemotePrepareSystemSettingRequestExtendedDataStruct >& RemotePrepareSystemSettingRequest::getExtendedDataMutable () {
    set_has_extendedData();
    return _extendedData;
}

inline void RemotePrepareSystemSettingRequest::setExtendedData (const ::std::vector< RemotePrepareSystemSettingRequestExtendedDataStruct >& extendedData_) {
    set_has_extendedData();
    this->_extendedData = extendedData_;
}

inline void RemotePrepareSystemSettingRequest::clearCookie() {
    if (hasCookie()) {
         clear_has_cookie();
        _cookie = 0u;
     }
}

inline bool RemotePrepareSystemSettingRequest::hasCookie () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 RemotePrepareSystemSettingRequest::getCookie () const {
    return _cookie;
}

inline void RemotePrepareSystemSettingRequest::setCookie (uint32 cookie_) {
    set_has_cookie();
    this->_cookie = cookie_;
}

inline void RemotePrepareSystemSettingRequest::set_has_sysSetType () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemotePrepareSystemSettingRequest::clear_has_sysSetType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RemotePrepareSystemSettingRequest::set_has_extendedData () {
    _has_bits_[0] |= 1u << 1;
}

inline void RemotePrepareSystemSettingRequest::clear_has_extendedData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RemotePrepareSystemSettingRequest::set_has_cookie () {
    _has_bits_[0] |= 1u << 2;
}

inline void RemotePrepareSystemSettingRequest::clear_has_cookie () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  RemotePrepareSystemSettingResponseExtendedDataStruct::RemotePrepareSystemSettingResponseExtendedDataStruct ()  :
    _elem1 (0u),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemotePrepareSystemSettingResponseExtendedDataStruct::RemotePrepareSystemSettingResponseExtendedDataStruct (const RemotePrepareSystemSettingResponseExtendedDataStruct &rhs)  :
    _elem1 (0u),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemotePrepareSystemSettingResponseExtendedDataStruct::RemotePrepareSystemSettingResponseExtendedDataStruct (uint8 elem1_, const ::std::vector< uint8 >& elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemotePrepareSystemSettingResponseExtendedDataStruct::~RemotePrepareSystemSettingResponseExtendedDataStruct() {
}

inline RemotePrepareSystemSettingResponseExtendedDataStruct& RemotePrepareSystemSettingResponseExtendedDataStruct::operator = (const RemotePrepareSystemSettingResponseExtendedDataStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool RemotePrepareSystemSettingResponseExtendedDataStruct::operator == (const RemotePrepareSystemSettingResponseExtendedDataStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool RemotePrepareSystemSettingResponseExtendedDataStruct::operator != (const RemotePrepareSystemSettingResponseExtendedDataStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool RemotePrepareSystemSettingResponseExtendedDataStruct::operator < (const RemotePrepareSystemSettingResponseExtendedDataStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool RemotePrepareSystemSettingResponseExtendedDataStruct::operator > (const RemotePrepareSystemSettingResponseExtendedDataStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemotePrepareSystemSettingResponseExtendedDataStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void RemotePrepareSystemSettingResponseExtendedDataStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0u;
     }
}

inline bool RemotePrepareSystemSettingResponseExtendedDataStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 RemotePrepareSystemSettingResponseExtendedDataStruct::getElem1 () const {
    return _elem1;
}

inline void RemotePrepareSystemSettingResponseExtendedDataStruct::setElem1 (uint8 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void RemotePrepareSystemSettingResponseExtendedDataStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool RemotePrepareSystemSettingResponseExtendedDataStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& RemotePrepareSystemSettingResponseExtendedDataStruct::getElem2 () const {
    return _elem2;
}

inline ::std::vector< uint8 >& RemotePrepareSystemSettingResponseExtendedDataStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void RemotePrepareSystemSettingResponseExtendedDataStruct::setElem2 (const ::std::vector< uint8 >& elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void RemotePrepareSystemSettingResponseExtendedDataStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemotePrepareSystemSettingResponseExtendedDataStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RemotePrepareSystemSettingResponseExtendedDataStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void RemotePrepareSystemSettingResponseExtendedDataStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RemotePrepareSystemSettingResponse::RemotePrepareSystemSettingResponse ()  :
    _sysSetType (),
    _extendedData (),
    _resultCode (0u),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemotePrepareSystemSettingResponse::RemotePrepareSystemSettingResponse (const RemotePrepareSystemSettingResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _sysSetType (),
    _extendedData (),
    _resultCode (0u),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemotePrepareSystemSettingResponse::RemotePrepareSystemSettingResponse (const ::std::string& sysSetType_, const ::std::vector< RemotePrepareSystemSettingResponseExtendedDataStruct >& extendedData_, uint32 resultCode_, uint32 cookie_)  :
    _sysSetType (sysSetType_),
    _extendedData (extendedData_),
    _resultCode (resultCode_),
    _cookie (cookie_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemotePrepareSystemSettingResponse::~RemotePrepareSystemSettingResponse() {
}

inline RemotePrepareSystemSettingResponse& RemotePrepareSystemSettingResponse::operator = (const RemotePrepareSystemSettingResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSysSetType()) {
            setSysSetType(rhs.getSysSetType());
        } else {
            clearSysSetType();
        }
        if (rhs.hasExtendedData()) {
            setExtendedData(rhs.getExtendedData());
        } else {
            clearExtendedData();
        }
        if (rhs.hasResultCode()) {
            setResultCode(rhs.getResultCode());
        } else {
            clearResultCode();
        }
        if (rhs.hasCookie()) {
            setCookie(rhs.getCookie());
        } else {
            clearCookie();
        }
    }
    return *this;
}

inline bool RemotePrepareSystemSettingResponse::operator == (const RemotePrepareSystemSettingResponse& rhs) const {
    return (((!hasSysSetType() && !rhs.hasSysSetType()) || getSysSetType() == rhs.getSysSetType()) &&
        ((!hasExtendedData() && !rhs.hasExtendedData()) || getExtendedData() == rhs.getExtendedData()) &&
        ((!hasResultCode() && !rhs.hasResultCode()) || getResultCode() == rhs.getResultCode()) &&
        ((!hasCookie() && !rhs.hasCookie()) || getCookie() == rhs.getCookie()));
}

inline bool RemotePrepareSystemSettingResponse::operator != (const RemotePrepareSystemSettingResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RemotePrepareSystemSettingResponse::operator < (const RemotePrepareSystemSettingResponse& rhs) const {
    if (hasSysSetType() || rhs.hasSysSetType()) {
        if (getSysSetType() < rhs.getSysSetType()) return true;
        if (getSysSetType() > rhs.getSysSetType()) return false;
    }
    if (hasExtendedData() || rhs.hasExtendedData()) {
        if (getExtendedData() < rhs.getExtendedData()) return true;
        if (getExtendedData() > rhs.getExtendedData()) return false;
    }
    if (hasResultCode() || rhs.hasResultCode()) {
        if (getResultCode() < rhs.getResultCode()) return true;
        if (getResultCode() > rhs.getResultCode()) return false;
    }
    if (hasCookie() || rhs.hasCookie()) {
        if (getCookie() < rhs.getCookie()) return true;
        if (getCookie() > rhs.getCookie()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemotePrepareSystemSettingResponse::clone() {
    return new RemotePrepareSystemSettingResponse(*this);
}

inline bool RemotePrepareSystemSettingResponse::operator > (const RemotePrepareSystemSettingResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemotePrepareSystemSettingResponse::clear() {
    clearSysSetType();
    clearExtendedData();
    clearResultCode();
    clearCookie();
}

inline void RemotePrepareSystemSettingResponse::clearSysSetType() {
    if (hasSysSetType()) {
         clear_has_sysSetType();
        _sysSetType.clear();
     }
}

inline bool RemotePrepareSystemSettingResponse::hasSysSetType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RemotePrepareSystemSettingResponse::getSysSetType () const {
    return _sysSetType;
}

inline ::std::string& RemotePrepareSystemSettingResponse::getSysSetTypeMutable () {
    set_has_sysSetType();
    return _sysSetType;
}

inline void RemotePrepareSystemSettingResponse::setSysSetType (const ::std::string& sysSetType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType = sysSetType_;
}

inline void RemotePrepareSystemSettingResponse::setSysSetType (const char* sysSetType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType.assign(sysSetType_);
}

inline void RemotePrepareSystemSettingResponse::setSysSetType (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType.assign(value, size);
}

inline void RemotePrepareSystemSettingResponse::clearExtendedData() {
    if (hasExtendedData()) {
         clear_has_extendedData();
        _extendedData.clear();
     }
}

inline bool RemotePrepareSystemSettingResponse::hasExtendedData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< RemotePrepareSystemSettingResponseExtendedDataStruct >& RemotePrepareSystemSettingResponse::getExtendedData () const {
    return _extendedData;
}

inline ::std::vector< RemotePrepareSystemSettingResponseExtendedDataStruct >& RemotePrepareSystemSettingResponse::getExtendedDataMutable () {
    set_has_extendedData();
    return _extendedData;
}

inline void RemotePrepareSystemSettingResponse::setExtendedData (const ::std::vector< RemotePrepareSystemSettingResponseExtendedDataStruct >& extendedData_) {
    set_has_extendedData();
    this->_extendedData = extendedData_;
}

inline void RemotePrepareSystemSettingResponse::clearResultCode() {
    if (hasResultCode()) {
         clear_has_resultCode();
        _resultCode = 0u;
     }
}

inline bool RemotePrepareSystemSettingResponse::hasResultCode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 RemotePrepareSystemSettingResponse::getResultCode () const {
    return _resultCode;
}

inline void RemotePrepareSystemSettingResponse::setResultCode (uint32 resultCode_) {
    set_has_resultCode();
    this->_resultCode = resultCode_;
}

inline void RemotePrepareSystemSettingResponse::clearCookie() {
    if (hasCookie()) {
         clear_has_cookie();
        _cookie = 0u;
     }
}

inline bool RemotePrepareSystemSettingResponse::hasCookie () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 RemotePrepareSystemSettingResponse::getCookie () const {
    return _cookie;
}

inline void RemotePrepareSystemSettingResponse::setCookie (uint32 cookie_) {
    set_has_cookie();
    this->_cookie = cookie_;
}

inline void RemotePrepareSystemSettingResponse::set_has_sysSetType () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemotePrepareSystemSettingResponse::clear_has_sysSetType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RemotePrepareSystemSettingResponse::set_has_extendedData () {
    _has_bits_[0] |= 1u << 1;
}

inline void RemotePrepareSystemSettingResponse::clear_has_extendedData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RemotePrepareSystemSettingResponse::set_has_resultCode () {
    _has_bits_[0] |= 1u << 2;
}

inline void RemotePrepareSystemSettingResponse::clear_has_resultCode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void RemotePrepareSystemSettingResponse::set_has_cookie () {
    _has_bits_[0] |= 1u << 3;
}

inline void RemotePrepareSystemSettingResponse::clear_has_cookie () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  RemoteExecuteSystemSettingRequestExtendedDataStruct::RemoteExecuteSystemSettingRequestExtendedDataStruct ()  :
    _elem1 (0u),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoteExecuteSystemSettingRequestExtendedDataStruct::RemoteExecuteSystemSettingRequestExtendedDataStruct (const RemoteExecuteSystemSettingRequestExtendedDataStruct &rhs)  :
    _elem1 (0u),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoteExecuteSystemSettingRequestExtendedDataStruct::RemoteExecuteSystemSettingRequestExtendedDataStruct (uint8 elem1_, const ::std::vector< uint8 >& elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoteExecuteSystemSettingRequestExtendedDataStruct::~RemoteExecuteSystemSettingRequestExtendedDataStruct() {
}

inline RemoteExecuteSystemSettingRequestExtendedDataStruct& RemoteExecuteSystemSettingRequestExtendedDataStruct::operator = (const RemoteExecuteSystemSettingRequestExtendedDataStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool RemoteExecuteSystemSettingRequestExtendedDataStruct::operator == (const RemoteExecuteSystemSettingRequestExtendedDataStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool RemoteExecuteSystemSettingRequestExtendedDataStruct::operator != (const RemoteExecuteSystemSettingRequestExtendedDataStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoteExecuteSystemSettingRequestExtendedDataStruct::operator < (const RemoteExecuteSystemSettingRequestExtendedDataStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool RemoteExecuteSystemSettingRequestExtendedDataStruct::operator > (const RemoteExecuteSystemSettingRequestExtendedDataStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoteExecuteSystemSettingRequestExtendedDataStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void RemoteExecuteSystemSettingRequestExtendedDataStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0u;
     }
}

inline bool RemoteExecuteSystemSettingRequestExtendedDataStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 RemoteExecuteSystemSettingRequestExtendedDataStruct::getElem1 () const {
    return _elem1;
}

inline void RemoteExecuteSystemSettingRequestExtendedDataStruct::setElem1 (uint8 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void RemoteExecuteSystemSettingRequestExtendedDataStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool RemoteExecuteSystemSettingRequestExtendedDataStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& RemoteExecuteSystemSettingRequestExtendedDataStruct::getElem2 () const {
    return _elem2;
}

inline ::std::vector< uint8 >& RemoteExecuteSystemSettingRequestExtendedDataStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void RemoteExecuteSystemSettingRequestExtendedDataStruct::setElem2 (const ::std::vector< uint8 >& elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void RemoteExecuteSystemSettingRequestExtendedDataStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoteExecuteSystemSettingRequestExtendedDataStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RemoteExecuteSystemSettingRequestExtendedDataStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void RemoteExecuteSystemSettingRequestExtendedDataStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RemoteExecuteSystemSettingRequest::RemoteExecuteSystemSettingRequest ()  :
    _sysSetType (),
    _extendedData (),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoteExecuteSystemSettingRequest::RemoteExecuteSystemSettingRequest (const RemoteExecuteSystemSettingRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _sysSetType (),
    _extendedData (),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoteExecuteSystemSettingRequest::RemoteExecuteSystemSettingRequest (const ::std::string& sysSetType_, const ::std::vector< RemoteExecuteSystemSettingRequestExtendedDataStruct >& extendedData_, uint32 cookie_)  :
    _sysSetType (sysSetType_),
    _extendedData (extendedData_),
    _cookie (cookie_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoteExecuteSystemSettingRequest::~RemoteExecuteSystemSettingRequest() {
}

inline RemoteExecuteSystemSettingRequest& RemoteExecuteSystemSettingRequest::operator = (const RemoteExecuteSystemSettingRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSysSetType()) {
            setSysSetType(rhs.getSysSetType());
        } else {
            clearSysSetType();
        }
        if (rhs.hasExtendedData()) {
            setExtendedData(rhs.getExtendedData());
        } else {
            clearExtendedData();
        }
        if (rhs.hasCookie()) {
            setCookie(rhs.getCookie());
        } else {
            clearCookie();
        }
    }
    return *this;
}

inline bool RemoteExecuteSystemSettingRequest::operator == (const RemoteExecuteSystemSettingRequest& rhs) const {
    return (((!hasSysSetType() && !rhs.hasSysSetType()) || getSysSetType() == rhs.getSysSetType()) &&
        ((!hasExtendedData() && !rhs.hasExtendedData()) || getExtendedData() == rhs.getExtendedData()) &&
        ((!hasCookie() && !rhs.hasCookie()) || getCookie() == rhs.getCookie()));
}

inline bool RemoteExecuteSystemSettingRequest::operator != (const RemoteExecuteSystemSettingRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoteExecuteSystemSettingRequest::operator < (const RemoteExecuteSystemSettingRequest& rhs) const {
    if (hasSysSetType() || rhs.hasSysSetType()) {
        if (getSysSetType() < rhs.getSysSetType()) return true;
        if (getSysSetType() > rhs.getSysSetType()) return false;
    }
    if (hasExtendedData() || rhs.hasExtendedData()) {
        if (getExtendedData() < rhs.getExtendedData()) return true;
        if (getExtendedData() > rhs.getExtendedData()) return false;
    }
    if (hasCookie() || rhs.hasCookie()) {
        if (getCookie() < rhs.getCookie()) return true;
        if (getCookie() > rhs.getCookie()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoteExecuteSystemSettingRequest::clone() {
    return new RemoteExecuteSystemSettingRequest(*this);
}

inline bool RemoteExecuteSystemSettingRequest::operator > (const RemoteExecuteSystemSettingRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoteExecuteSystemSettingRequest::clear() {
    clearSysSetType();
    clearExtendedData();
    clearCookie();
}

inline void RemoteExecuteSystemSettingRequest::clearSysSetType() {
    if (hasSysSetType()) {
         clear_has_sysSetType();
        _sysSetType.clear();
     }
}

inline bool RemoteExecuteSystemSettingRequest::hasSysSetType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RemoteExecuteSystemSettingRequest::getSysSetType () const {
    return _sysSetType;
}

inline ::std::string& RemoteExecuteSystemSettingRequest::getSysSetTypeMutable () {
    set_has_sysSetType();
    return _sysSetType;
}

inline void RemoteExecuteSystemSettingRequest::setSysSetType (const ::std::string& sysSetType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType = sysSetType_;
}

inline void RemoteExecuteSystemSettingRequest::setSysSetType (const char* sysSetType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType.assign(sysSetType_);
}

inline void RemoteExecuteSystemSettingRequest::setSysSetType (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType.assign(value, size);
}

inline void RemoteExecuteSystemSettingRequest::clearExtendedData() {
    if (hasExtendedData()) {
         clear_has_extendedData();
        _extendedData.clear();
     }
}

inline bool RemoteExecuteSystemSettingRequest::hasExtendedData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< RemoteExecuteSystemSettingRequestExtendedDataStruct >& RemoteExecuteSystemSettingRequest::getExtendedData () const {
    return _extendedData;
}

inline ::std::vector< RemoteExecuteSystemSettingRequestExtendedDataStruct >& RemoteExecuteSystemSettingRequest::getExtendedDataMutable () {
    set_has_extendedData();
    return _extendedData;
}

inline void RemoteExecuteSystemSettingRequest::setExtendedData (const ::std::vector< RemoteExecuteSystemSettingRequestExtendedDataStruct >& extendedData_) {
    set_has_extendedData();
    this->_extendedData = extendedData_;
}

inline void RemoteExecuteSystemSettingRequest::clearCookie() {
    if (hasCookie()) {
         clear_has_cookie();
        _cookie = 0u;
     }
}

inline bool RemoteExecuteSystemSettingRequest::hasCookie () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 RemoteExecuteSystemSettingRequest::getCookie () const {
    return _cookie;
}

inline void RemoteExecuteSystemSettingRequest::setCookie (uint32 cookie_) {
    set_has_cookie();
    this->_cookie = cookie_;
}

inline void RemoteExecuteSystemSettingRequest::set_has_sysSetType () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoteExecuteSystemSettingRequest::clear_has_sysSetType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RemoteExecuteSystemSettingRequest::set_has_extendedData () {
    _has_bits_[0] |= 1u << 1;
}

inline void RemoteExecuteSystemSettingRequest::clear_has_extendedData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RemoteExecuteSystemSettingRequest::set_has_cookie () {
    _has_bits_[0] |= 1u << 2;
}

inline void RemoteExecuteSystemSettingRequest::clear_has_cookie () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  RemoteExecuteSystemSettingResponseExtendedDataStruct::RemoteExecuteSystemSettingResponseExtendedDataStruct ()  :
    _elem1 (0u),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoteExecuteSystemSettingResponseExtendedDataStruct::RemoteExecuteSystemSettingResponseExtendedDataStruct (const RemoteExecuteSystemSettingResponseExtendedDataStruct &rhs)  :
    _elem1 (0u),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoteExecuteSystemSettingResponseExtendedDataStruct::RemoteExecuteSystemSettingResponseExtendedDataStruct (uint8 elem1_, const ::std::vector< uint8 >& elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoteExecuteSystemSettingResponseExtendedDataStruct::~RemoteExecuteSystemSettingResponseExtendedDataStruct() {
}

inline RemoteExecuteSystemSettingResponseExtendedDataStruct& RemoteExecuteSystemSettingResponseExtendedDataStruct::operator = (const RemoteExecuteSystemSettingResponseExtendedDataStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool RemoteExecuteSystemSettingResponseExtendedDataStruct::operator == (const RemoteExecuteSystemSettingResponseExtendedDataStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool RemoteExecuteSystemSettingResponseExtendedDataStruct::operator != (const RemoteExecuteSystemSettingResponseExtendedDataStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoteExecuteSystemSettingResponseExtendedDataStruct::operator < (const RemoteExecuteSystemSettingResponseExtendedDataStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool RemoteExecuteSystemSettingResponseExtendedDataStruct::operator > (const RemoteExecuteSystemSettingResponseExtendedDataStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoteExecuteSystemSettingResponseExtendedDataStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void RemoteExecuteSystemSettingResponseExtendedDataStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0u;
     }
}

inline bool RemoteExecuteSystemSettingResponseExtendedDataStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 RemoteExecuteSystemSettingResponseExtendedDataStruct::getElem1 () const {
    return _elem1;
}

inline void RemoteExecuteSystemSettingResponseExtendedDataStruct::setElem1 (uint8 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void RemoteExecuteSystemSettingResponseExtendedDataStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool RemoteExecuteSystemSettingResponseExtendedDataStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& RemoteExecuteSystemSettingResponseExtendedDataStruct::getElem2 () const {
    return _elem2;
}

inline ::std::vector< uint8 >& RemoteExecuteSystemSettingResponseExtendedDataStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void RemoteExecuteSystemSettingResponseExtendedDataStruct::setElem2 (const ::std::vector< uint8 >& elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void RemoteExecuteSystemSettingResponseExtendedDataStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoteExecuteSystemSettingResponseExtendedDataStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RemoteExecuteSystemSettingResponseExtendedDataStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void RemoteExecuteSystemSettingResponseExtendedDataStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RemoteExecuteSystemSettingResponse::RemoteExecuteSystemSettingResponse ()  :
    _sysSetType (),
    _extendedData (),
    _resultCode (0u),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoteExecuteSystemSettingResponse::RemoteExecuteSystemSettingResponse (const RemoteExecuteSystemSettingResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _sysSetType (),
    _extendedData (),
    _resultCode (0u),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoteExecuteSystemSettingResponse::RemoteExecuteSystemSettingResponse (const ::std::string& sysSetType_, const ::std::vector< RemoteExecuteSystemSettingResponseExtendedDataStruct >& extendedData_, uint32 resultCode_, uint32 cookie_)  :
    _sysSetType (sysSetType_),
    _extendedData (extendedData_),
    _resultCode (resultCode_),
    _cookie (cookie_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoteExecuteSystemSettingResponse::~RemoteExecuteSystemSettingResponse() {
}

inline RemoteExecuteSystemSettingResponse& RemoteExecuteSystemSettingResponse::operator = (const RemoteExecuteSystemSettingResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSysSetType()) {
            setSysSetType(rhs.getSysSetType());
        } else {
            clearSysSetType();
        }
        if (rhs.hasExtendedData()) {
            setExtendedData(rhs.getExtendedData());
        } else {
            clearExtendedData();
        }
        if (rhs.hasResultCode()) {
            setResultCode(rhs.getResultCode());
        } else {
            clearResultCode();
        }
        if (rhs.hasCookie()) {
            setCookie(rhs.getCookie());
        } else {
            clearCookie();
        }
    }
    return *this;
}

inline bool RemoteExecuteSystemSettingResponse::operator == (const RemoteExecuteSystemSettingResponse& rhs) const {
    return (((!hasSysSetType() && !rhs.hasSysSetType()) || getSysSetType() == rhs.getSysSetType()) &&
        ((!hasExtendedData() && !rhs.hasExtendedData()) || getExtendedData() == rhs.getExtendedData()) &&
        ((!hasResultCode() && !rhs.hasResultCode()) || getResultCode() == rhs.getResultCode()) &&
        ((!hasCookie() && !rhs.hasCookie()) || getCookie() == rhs.getCookie()));
}

inline bool RemoteExecuteSystemSettingResponse::operator != (const RemoteExecuteSystemSettingResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoteExecuteSystemSettingResponse::operator < (const RemoteExecuteSystemSettingResponse& rhs) const {
    if (hasSysSetType() || rhs.hasSysSetType()) {
        if (getSysSetType() < rhs.getSysSetType()) return true;
        if (getSysSetType() > rhs.getSysSetType()) return false;
    }
    if (hasExtendedData() || rhs.hasExtendedData()) {
        if (getExtendedData() < rhs.getExtendedData()) return true;
        if (getExtendedData() > rhs.getExtendedData()) return false;
    }
    if (hasResultCode() || rhs.hasResultCode()) {
        if (getResultCode() < rhs.getResultCode()) return true;
        if (getResultCode() > rhs.getResultCode()) return false;
    }
    if (hasCookie() || rhs.hasCookie()) {
        if (getCookie() < rhs.getCookie()) return true;
        if (getCookie() > rhs.getCookie()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoteExecuteSystemSettingResponse::clone() {
    return new RemoteExecuteSystemSettingResponse(*this);
}

inline bool RemoteExecuteSystemSettingResponse::operator > (const RemoteExecuteSystemSettingResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoteExecuteSystemSettingResponse::clear() {
    clearSysSetType();
    clearExtendedData();
    clearResultCode();
    clearCookie();
}

inline void RemoteExecuteSystemSettingResponse::clearSysSetType() {
    if (hasSysSetType()) {
         clear_has_sysSetType();
        _sysSetType.clear();
     }
}

inline bool RemoteExecuteSystemSettingResponse::hasSysSetType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RemoteExecuteSystemSettingResponse::getSysSetType () const {
    return _sysSetType;
}

inline ::std::string& RemoteExecuteSystemSettingResponse::getSysSetTypeMutable () {
    set_has_sysSetType();
    return _sysSetType;
}

inline void RemoteExecuteSystemSettingResponse::setSysSetType (const ::std::string& sysSetType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType = sysSetType_;
}

inline void RemoteExecuteSystemSettingResponse::setSysSetType (const char* sysSetType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType.assign(sysSetType_);
}

inline void RemoteExecuteSystemSettingResponse::setSysSetType (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType.assign(value, size);
}

inline void RemoteExecuteSystemSettingResponse::clearExtendedData() {
    if (hasExtendedData()) {
         clear_has_extendedData();
        _extendedData.clear();
     }
}

inline bool RemoteExecuteSystemSettingResponse::hasExtendedData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< RemoteExecuteSystemSettingResponseExtendedDataStruct >& RemoteExecuteSystemSettingResponse::getExtendedData () const {
    return _extendedData;
}

inline ::std::vector< RemoteExecuteSystemSettingResponseExtendedDataStruct >& RemoteExecuteSystemSettingResponse::getExtendedDataMutable () {
    set_has_extendedData();
    return _extendedData;
}

inline void RemoteExecuteSystemSettingResponse::setExtendedData (const ::std::vector< RemoteExecuteSystemSettingResponseExtendedDataStruct >& extendedData_) {
    set_has_extendedData();
    this->_extendedData = extendedData_;
}

inline void RemoteExecuteSystemSettingResponse::clearResultCode() {
    if (hasResultCode()) {
         clear_has_resultCode();
        _resultCode = 0u;
     }
}

inline bool RemoteExecuteSystemSettingResponse::hasResultCode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 RemoteExecuteSystemSettingResponse::getResultCode () const {
    return _resultCode;
}

inline void RemoteExecuteSystemSettingResponse::setResultCode (uint32 resultCode_) {
    set_has_resultCode();
    this->_resultCode = resultCode_;
}

inline void RemoteExecuteSystemSettingResponse::clearCookie() {
    if (hasCookie()) {
         clear_has_cookie();
        _cookie = 0u;
     }
}

inline bool RemoteExecuteSystemSettingResponse::hasCookie () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 RemoteExecuteSystemSettingResponse::getCookie () const {
    return _cookie;
}

inline void RemoteExecuteSystemSettingResponse::setCookie (uint32 cookie_) {
    set_has_cookie();
    this->_cookie = cookie_;
}

inline void RemoteExecuteSystemSettingResponse::set_has_sysSetType () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoteExecuteSystemSettingResponse::clear_has_sysSetType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RemoteExecuteSystemSettingResponse::set_has_extendedData () {
    _has_bits_[0] |= 1u << 1;
}

inline void RemoteExecuteSystemSettingResponse::clear_has_extendedData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RemoteExecuteSystemSettingResponse::set_has_resultCode () {
    _has_bits_[0] |= 1u << 2;
}

inline void RemoteExecuteSystemSettingResponse::clear_has_resultCode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void RemoteExecuteSystemSettingResponse::set_has_cookie () {
    _has_bits_[0] |= 1u << 3;
}

inline void RemoteExecuteSystemSettingResponse::clear_has_cookie () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  RemoteFinalizeSystemSettingRequestExtendedDataStruct::RemoteFinalizeSystemSettingRequestExtendedDataStruct ()  :
    _elem1 (0u),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoteFinalizeSystemSettingRequestExtendedDataStruct::RemoteFinalizeSystemSettingRequestExtendedDataStruct (const RemoteFinalizeSystemSettingRequestExtendedDataStruct &rhs)  :
    _elem1 (0u),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoteFinalizeSystemSettingRequestExtendedDataStruct::RemoteFinalizeSystemSettingRequestExtendedDataStruct (uint8 elem1_, const ::std::vector< uint8 >& elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoteFinalizeSystemSettingRequestExtendedDataStruct::~RemoteFinalizeSystemSettingRequestExtendedDataStruct() {
}

inline RemoteFinalizeSystemSettingRequestExtendedDataStruct& RemoteFinalizeSystemSettingRequestExtendedDataStruct::operator = (const RemoteFinalizeSystemSettingRequestExtendedDataStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool RemoteFinalizeSystemSettingRequestExtendedDataStruct::operator == (const RemoteFinalizeSystemSettingRequestExtendedDataStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool RemoteFinalizeSystemSettingRequestExtendedDataStruct::operator != (const RemoteFinalizeSystemSettingRequestExtendedDataStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoteFinalizeSystemSettingRequestExtendedDataStruct::operator < (const RemoteFinalizeSystemSettingRequestExtendedDataStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool RemoteFinalizeSystemSettingRequestExtendedDataStruct::operator > (const RemoteFinalizeSystemSettingRequestExtendedDataStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoteFinalizeSystemSettingRequestExtendedDataStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void RemoteFinalizeSystemSettingRequestExtendedDataStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0u;
     }
}

inline bool RemoteFinalizeSystemSettingRequestExtendedDataStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 RemoteFinalizeSystemSettingRequestExtendedDataStruct::getElem1 () const {
    return _elem1;
}

inline void RemoteFinalizeSystemSettingRequestExtendedDataStruct::setElem1 (uint8 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void RemoteFinalizeSystemSettingRequestExtendedDataStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool RemoteFinalizeSystemSettingRequestExtendedDataStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& RemoteFinalizeSystemSettingRequestExtendedDataStruct::getElem2 () const {
    return _elem2;
}

inline ::std::vector< uint8 >& RemoteFinalizeSystemSettingRequestExtendedDataStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void RemoteFinalizeSystemSettingRequestExtendedDataStruct::setElem2 (const ::std::vector< uint8 >& elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void RemoteFinalizeSystemSettingRequestExtendedDataStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoteFinalizeSystemSettingRequestExtendedDataStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RemoteFinalizeSystemSettingRequestExtendedDataStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void RemoteFinalizeSystemSettingRequestExtendedDataStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RemoteFinalizeSystemSettingRequest::RemoteFinalizeSystemSettingRequest ()  :
    _sysSetType (),
    _extendedData (),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoteFinalizeSystemSettingRequest::RemoteFinalizeSystemSettingRequest (const RemoteFinalizeSystemSettingRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _sysSetType (),
    _extendedData (),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoteFinalizeSystemSettingRequest::RemoteFinalizeSystemSettingRequest (const ::std::string& sysSetType_, const ::std::vector< RemoteFinalizeSystemSettingRequestExtendedDataStruct >& extendedData_, uint32 cookie_)  :
    _sysSetType (sysSetType_),
    _extendedData (extendedData_),
    _cookie (cookie_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoteFinalizeSystemSettingRequest::~RemoteFinalizeSystemSettingRequest() {
}

inline RemoteFinalizeSystemSettingRequest& RemoteFinalizeSystemSettingRequest::operator = (const RemoteFinalizeSystemSettingRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSysSetType()) {
            setSysSetType(rhs.getSysSetType());
        } else {
            clearSysSetType();
        }
        if (rhs.hasExtendedData()) {
            setExtendedData(rhs.getExtendedData());
        } else {
            clearExtendedData();
        }
        if (rhs.hasCookie()) {
            setCookie(rhs.getCookie());
        } else {
            clearCookie();
        }
    }
    return *this;
}

inline bool RemoteFinalizeSystemSettingRequest::operator == (const RemoteFinalizeSystemSettingRequest& rhs) const {
    return (((!hasSysSetType() && !rhs.hasSysSetType()) || getSysSetType() == rhs.getSysSetType()) &&
        ((!hasExtendedData() && !rhs.hasExtendedData()) || getExtendedData() == rhs.getExtendedData()) &&
        ((!hasCookie() && !rhs.hasCookie()) || getCookie() == rhs.getCookie()));
}

inline bool RemoteFinalizeSystemSettingRequest::operator != (const RemoteFinalizeSystemSettingRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoteFinalizeSystemSettingRequest::operator < (const RemoteFinalizeSystemSettingRequest& rhs) const {
    if (hasSysSetType() || rhs.hasSysSetType()) {
        if (getSysSetType() < rhs.getSysSetType()) return true;
        if (getSysSetType() > rhs.getSysSetType()) return false;
    }
    if (hasExtendedData() || rhs.hasExtendedData()) {
        if (getExtendedData() < rhs.getExtendedData()) return true;
        if (getExtendedData() > rhs.getExtendedData()) return false;
    }
    if (hasCookie() || rhs.hasCookie()) {
        if (getCookie() < rhs.getCookie()) return true;
        if (getCookie() > rhs.getCookie()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoteFinalizeSystemSettingRequest::clone() {
    return new RemoteFinalizeSystemSettingRequest(*this);
}

inline bool RemoteFinalizeSystemSettingRequest::operator > (const RemoteFinalizeSystemSettingRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoteFinalizeSystemSettingRequest::clear() {
    clearSysSetType();
    clearExtendedData();
    clearCookie();
}

inline void RemoteFinalizeSystemSettingRequest::clearSysSetType() {
    if (hasSysSetType()) {
         clear_has_sysSetType();
        _sysSetType.clear();
     }
}

inline bool RemoteFinalizeSystemSettingRequest::hasSysSetType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RemoteFinalizeSystemSettingRequest::getSysSetType () const {
    return _sysSetType;
}

inline ::std::string& RemoteFinalizeSystemSettingRequest::getSysSetTypeMutable () {
    set_has_sysSetType();
    return _sysSetType;
}

inline void RemoteFinalizeSystemSettingRequest::setSysSetType (const ::std::string& sysSetType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType = sysSetType_;
}

inline void RemoteFinalizeSystemSettingRequest::setSysSetType (const char* sysSetType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType.assign(sysSetType_);
}

inline void RemoteFinalizeSystemSettingRequest::setSysSetType (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType.assign(value, size);
}

inline void RemoteFinalizeSystemSettingRequest::clearExtendedData() {
    if (hasExtendedData()) {
         clear_has_extendedData();
        _extendedData.clear();
     }
}

inline bool RemoteFinalizeSystemSettingRequest::hasExtendedData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< RemoteFinalizeSystemSettingRequestExtendedDataStruct >& RemoteFinalizeSystemSettingRequest::getExtendedData () const {
    return _extendedData;
}

inline ::std::vector< RemoteFinalizeSystemSettingRequestExtendedDataStruct >& RemoteFinalizeSystemSettingRequest::getExtendedDataMutable () {
    set_has_extendedData();
    return _extendedData;
}

inline void RemoteFinalizeSystemSettingRequest::setExtendedData (const ::std::vector< RemoteFinalizeSystemSettingRequestExtendedDataStruct >& extendedData_) {
    set_has_extendedData();
    this->_extendedData = extendedData_;
}

inline void RemoteFinalizeSystemSettingRequest::clearCookie() {
    if (hasCookie()) {
         clear_has_cookie();
        _cookie = 0u;
     }
}

inline bool RemoteFinalizeSystemSettingRequest::hasCookie () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 RemoteFinalizeSystemSettingRequest::getCookie () const {
    return _cookie;
}

inline void RemoteFinalizeSystemSettingRequest::setCookie (uint32 cookie_) {
    set_has_cookie();
    this->_cookie = cookie_;
}

inline void RemoteFinalizeSystemSettingRequest::set_has_sysSetType () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoteFinalizeSystemSettingRequest::clear_has_sysSetType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RemoteFinalizeSystemSettingRequest::set_has_extendedData () {
    _has_bits_[0] |= 1u << 1;
}

inline void RemoteFinalizeSystemSettingRequest::clear_has_extendedData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RemoteFinalizeSystemSettingRequest::set_has_cookie () {
    _has_bits_[0] |= 1u << 2;
}

inline void RemoteFinalizeSystemSettingRequest::clear_has_cookie () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  RemoteFinalizeSystemSettingResponseExtendedDataStruct::RemoteFinalizeSystemSettingResponseExtendedDataStruct ()  :
    _elem1 (0u),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoteFinalizeSystemSettingResponseExtendedDataStruct::RemoteFinalizeSystemSettingResponseExtendedDataStruct (const RemoteFinalizeSystemSettingResponseExtendedDataStruct &rhs)  :
    _elem1 (0u),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoteFinalizeSystemSettingResponseExtendedDataStruct::RemoteFinalizeSystemSettingResponseExtendedDataStruct (uint8 elem1_, const ::std::vector< uint8 >& elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoteFinalizeSystemSettingResponseExtendedDataStruct::~RemoteFinalizeSystemSettingResponseExtendedDataStruct() {
}

inline RemoteFinalizeSystemSettingResponseExtendedDataStruct& RemoteFinalizeSystemSettingResponseExtendedDataStruct::operator = (const RemoteFinalizeSystemSettingResponseExtendedDataStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool RemoteFinalizeSystemSettingResponseExtendedDataStruct::operator == (const RemoteFinalizeSystemSettingResponseExtendedDataStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool RemoteFinalizeSystemSettingResponseExtendedDataStruct::operator != (const RemoteFinalizeSystemSettingResponseExtendedDataStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoteFinalizeSystemSettingResponseExtendedDataStruct::operator < (const RemoteFinalizeSystemSettingResponseExtendedDataStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool RemoteFinalizeSystemSettingResponseExtendedDataStruct::operator > (const RemoteFinalizeSystemSettingResponseExtendedDataStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoteFinalizeSystemSettingResponseExtendedDataStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void RemoteFinalizeSystemSettingResponseExtendedDataStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0u;
     }
}

inline bool RemoteFinalizeSystemSettingResponseExtendedDataStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 RemoteFinalizeSystemSettingResponseExtendedDataStruct::getElem1 () const {
    return _elem1;
}

inline void RemoteFinalizeSystemSettingResponseExtendedDataStruct::setElem1 (uint8 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void RemoteFinalizeSystemSettingResponseExtendedDataStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool RemoteFinalizeSystemSettingResponseExtendedDataStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& RemoteFinalizeSystemSettingResponseExtendedDataStruct::getElem2 () const {
    return _elem2;
}

inline ::std::vector< uint8 >& RemoteFinalizeSystemSettingResponseExtendedDataStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void RemoteFinalizeSystemSettingResponseExtendedDataStruct::setElem2 (const ::std::vector< uint8 >& elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void RemoteFinalizeSystemSettingResponseExtendedDataStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoteFinalizeSystemSettingResponseExtendedDataStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RemoteFinalizeSystemSettingResponseExtendedDataStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void RemoteFinalizeSystemSettingResponseExtendedDataStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RemoteFinalizeSystemSettingResponse::RemoteFinalizeSystemSettingResponse ()  :
    _sysSetType (),
    _extendedData (),
    _resultCode (0u),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoteFinalizeSystemSettingResponse::RemoteFinalizeSystemSettingResponse (const RemoteFinalizeSystemSettingResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _sysSetType (),
    _extendedData (),
    _resultCode (0u),
    _cookie (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoteFinalizeSystemSettingResponse::RemoteFinalizeSystemSettingResponse (const ::std::string& sysSetType_, const ::std::vector< RemoteFinalizeSystemSettingResponseExtendedDataStruct >& extendedData_, uint32 resultCode_, uint32 cookie_)  :
    _sysSetType (sysSetType_),
    _extendedData (extendedData_),
    _resultCode (resultCode_),
    _cookie (cookie_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoteFinalizeSystemSettingResponse::~RemoteFinalizeSystemSettingResponse() {
}

inline RemoteFinalizeSystemSettingResponse& RemoteFinalizeSystemSettingResponse::operator = (const RemoteFinalizeSystemSettingResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSysSetType()) {
            setSysSetType(rhs.getSysSetType());
        } else {
            clearSysSetType();
        }
        if (rhs.hasExtendedData()) {
            setExtendedData(rhs.getExtendedData());
        } else {
            clearExtendedData();
        }
        if (rhs.hasResultCode()) {
            setResultCode(rhs.getResultCode());
        } else {
            clearResultCode();
        }
        if (rhs.hasCookie()) {
            setCookie(rhs.getCookie());
        } else {
            clearCookie();
        }
    }
    return *this;
}

inline bool RemoteFinalizeSystemSettingResponse::operator == (const RemoteFinalizeSystemSettingResponse& rhs) const {
    return (((!hasSysSetType() && !rhs.hasSysSetType()) || getSysSetType() == rhs.getSysSetType()) &&
        ((!hasExtendedData() && !rhs.hasExtendedData()) || getExtendedData() == rhs.getExtendedData()) &&
        ((!hasResultCode() && !rhs.hasResultCode()) || getResultCode() == rhs.getResultCode()) &&
        ((!hasCookie() && !rhs.hasCookie()) || getCookie() == rhs.getCookie()));
}

inline bool RemoteFinalizeSystemSettingResponse::operator != (const RemoteFinalizeSystemSettingResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoteFinalizeSystemSettingResponse::operator < (const RemoteFinalizeSystemSettingResponse& rhs) const {
    if (hasSysSetType() || rhs.hasSysSetType()) {
        if (getSysSetType() < rhs.getSysSetType()) return true;
        if (getSysSetType() > rhs.getSysSetType()) return false;
    }
    if (hasExtendedData() || rhs.hasExtendedData()) {
        if (getExtendedData() < rhs.getExtendedData()) return true;
        if (getExtendedData() > rhs.getExtendedData()) return false;
    }
    if (hasResultCode() || rhs.hasResultCode()) {
        if (getResultCode() < rhs.getResultCode()) return true;
        if (getResultCode() > rhs.getResultCode()) return false;
    }
    if (hasCookie() || rhs.hasCookie()) {
        if (getCookie() < rhs.getCookie()) return true;
        if (getCookie() > rhs.getCookie()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoteFinalizeSystemSettingResponse::clone() {
    return new RemoteFinalizeSystemSettingResponse(*this);
}

inline bool RemoteFinalizeSystemSettingResponse::operator > (const RemoteFinalizeSystemSettingResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoteFinalizeSystemSettingResponse::clear() {
    clearSysSetType();
    clearExtendedData();
    clearResultCode();
    clearCookie();
}

inline void RemoteFinalizeSystemSettingResponse::clearSysSetType() {
    if (hasSysSetType()) {
         clear_has_sysSetType();
        _sysSetType.clear();
     }
}

inline bool RemoteFinalizeSystemSettingResponse::hasSysSetType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RemoteFinalizeSystemSettingResponse::getSysSetType () const {
    return _sysSetType;
}

inline ::std::string& RemoteFinalizeSystemSettingResponse::getSysSetTypeMutable () {
    set_has_sysSetType();
    return _sysSetType;
}

inline void RemoteFinalizeSystemSettingResponse::setSysSetType (const ::std::string& sysSetType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType = sysSetType_;
}

inline void RemoteFinalizeSystemSettingResponse::setSysSetType (const char* sysSetType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sysSetType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType.assign(sysSetType_);
}

inline void RemoteFinalizeSystemSettingResponse::setSysSetType (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sysSetType();
    this->_sysSetType.assign(value, size);
}

inline void RemoteFinalizeSystemSettingResponse::clearExtendedData() {
    if (hasExtendedData()) {
         clear_has_extendedData();
        _extendedData.clear();
     }
}

inline bool RemoteFinalizeSystemSettingResponse::hasExtendedData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< RemoteFinalizeSystemSettingResponseExtendedDataStruct >& RemoteFinalizeSystemSettingResponse::getExtendedData () const {
    return _extendedData;
}

inline ::std::vector< RemoteFinalizeSystemSettingResponseExtendedDataStruct >& RemoteFinalizeSystemSettingResponse::getExtendedDataMutable () {
    set_has_extendedData();
    return _extendedData;
}

inline void RemoteFinalizeSystemSettingResponse::setExtendedData (const ::std::vector< RemoteFinalizeSystemSettingResponseExtendedDataStruct >& extendedData_) {
    set_has_extendedData();
    this->_extendedData = extendedData_;
}

inline void RemoteFinalizeSystemSettingResponse::clearResultCode() {
    if (hasResultCode()) {
         clear_has_resultCode();
        _resultCode = 0u;
     }
}

inline bool RemoteFinalizeSystemSettingResponse::hasResultCode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 RemoteFinalizeSystemSettingResponse::getResultCode () const {
    return _resultCode;
}

inline void RemoteFinalizeSystemSettingResponse::setResultCode (uint32 resultCode_) {
    set_has_resultCode();
    this->_resultCode = resultCode_;
}

inline void RemoteFinalizeSystemSettingResponse::clearCookie() {
    if (hasCookie()) {
         clear_has_cookie();
        _cookie = 0u;
     }
}

inline bool RemoteFinalizeSystemSettingResponse::hasCookie () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 RemoteFinalizeSystemSettingResponse::getCookie () const {
    return _cookie;
}

inline void RemoteFinalizeSystemSettingResponse::setCookie (uint32 cookie_) {
    set_has_cookie();
    this->_cookie = cookie_;
}

inline void RemoteFinalizeSystemSettingResponse::set_has_sysSetType () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoteFinalizeSystemSettingResponse::clear_has_sysSetType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RemoteFinalizeSystemSettingResponse::set_has_extendedData () {
    _has_bits_[0] |= 1u << 1;
}

inline void RemoteFinalizeSystemSettingResponse::clear_has_extendedData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RemoteFinalizeSystemSettingResponse::set_has_resultCode () {
    _has_bits_[0] |= 1u << 2;
}

inline void RemoteFinalizeSystemSettingResponse::clear_has_resultCode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void RemoteFinalizeSystemSettingResponse::set_has_cookie () {
    _has_bits_[0] |= 1u << 3;
}

inline void RemoteFinalizeSystemSettingResponse::clear_has_cookie () {
    _has_bits_[0] &= ~ (1u << 3);
}

} // namespace Control1
} // namespace Diagnosis1
} // namespace dbus
} // namespace diagnosis
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_DIAGNOSIS_DBUS_DIAGNOSIS1_CONTROL1_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
