/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/adit/de/ALD/level_status.h"
#include "com/adit/de/ALD/level_statusDBus.h"
#include "com/adit/de/ALD/level_statusJson.h"
#include "com/adit/de/ALD/level_statusStub.h"

#include "asf/dbus/DBusMessage.h"

namespace com {
namespace adit {
namespace de {
namespace ALD {
namespace level_status {

DEFINE_CLASS_LOGGER("/com/adit/de/ALD/level_status", Level_statusStub);


static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 5, "level", 0 },
};

class Level_statusStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    Level_statusStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    Level_statusStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    Level_statusStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "com.adit.de.ALD.level_status"),
          _logger(logger) {}

    virtual ~Level_statusStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void Level_statusStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* Level_statusStubDelegate::introspect() const {
    return     "<interface name=\"com.adit.de.ALD.level_status\">\n"
            "      <signal name=\"NewLevel\">\n"
            "        <arg direction=\"out\" name=\"new_level\" type=\"u\"/>\n"
            "      </signal>\n"
            "      <signal name=\"LevelChangeDone\">\n"
            "        <arg direction=\"out\" name=\"new_level\" type=\"u\"/>\n"
            "      </signal>\n"
            "      <property access=\"read\" name=\"level\" type=\"u\"/>\n"
            "</interface>\n";
}

void Level_statusStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<Level_statusStub*>(getStub()))->onGetAll (properties);
}

void Level_statusStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "level");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void Level_statusStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "level");
            ::boost::shared_ptr< LevelGet > payload(new LevelGet());
            payload->setAct(act);
            static_cast<Level_statusStub*>(getStub())->onLevelGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

Level_statusStub::Level_statusStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new Level_statusStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

Level_statusStub::Level_statusStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new Level_statusStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

Level_statusStub::~Level_statusStub() {
    delete _stubDelegate;
}

void Level_statusStub::sendNewLevelSignal(uint32 new_level) {
    if (_stubDelegate->isConnected()) {
        NewLevelSignal* payload = new NewLevelSignal(new_level);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "NewLevel", NewLevelSignal, payload)
        LOG_INFO ("-> send%sSignal", "NewLevel");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "NewLevel");
    }
}

void Level_statusStub::sendLevelChangeDoneSignal(uint32 new_level) {
    if (_stubDelegate->isConnected()) {
        LevelChangeDoneSignal* payload = new LevelChangeDoneSignal(new_level);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "LevelChangeDone", LevelChangeDoneSignal, payload)
        LOG_INFO ("-> send%sSignal", "LevelChangeDone");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "LevelChangeDone");
    }
}

void Level_statusStub::sendLevelUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LevelUpdate payload(_levelProperty);

        LOG_INFO ("-> send%s", "LevelUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("level", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("com.adit.de.ALD.level_status", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LevelUpdate");
    }
}

void Level_statusStub::onLevelGet(const ::boost::shared_ptr< LevelGet >& level) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LevelGet", level->getAct());
    sendLevelGetUpdate(_levelProperty.getLevel(), level->getAct());
}

void Level_statusStub::sendLevelGetUpdate(uint32 level, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LevelGet payload(level);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LevelGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Level_statusStub::setLevel(uint32 level) {
    if(level!=_levelProperty.getLevel()) {
        _levelProperty.setLevel(level);
        sendLevelUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Level_statusStub::getLevel() const {
    return _levelProperty.getLevel();
}

void Level_statusStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'level'
    {
        ::asf::dbus::DBusVariant variant;
        LevelGet payload(_levelProperty.getLevel());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("level", variant));
    }
}

} // namespace level_status
} // namespace ALD
} // namespace de
} // namespace adit
} // namespace com
