/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_ADIT_DE_ALD_LEVEL_STATUSPROXY_H
#define COM_ADIT_DE_ALD_LEVEL_STATUSPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/adit/de/ALD/level_status.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>

namespace com {
namespace adit {
namespace de {
namespace ALD {
namespace level_status {

class Level_statusProxy;

class LevelCallbackIF {
public:
    virtual ~LevelCallbackIF() {}

    virtual void onLevelError(const ::boost::shared_ptr< Level_statusProxy >& proxy, const ::boost::shared_ptr< LevelError >& error) = 0;

    virtual void onLevelUpdate(const ::boost::shared_ptr< Level_statusProxy >& proxy, const ::boost::shared_ptr< LevelUpdate >& update) = 0;
};

class LevelChangeDoneCallbackIF {
public:
    virtual ~LevelChangeDoneCallbackIF() {}

    virtual void onLevelChangeDoneError(const ::boost::shared_ptr< Level_statusProxy >& proxy, const ::boost::shared_ptr< LevelChangeDoneError >& error) = 0;

    virtual void onLevelChangeDoneSignal(const ::boost::shared_ptr< Level_statusProxy >& proxy, const ::boost::shared_ptr< LevelChangeDoneSignal >& signal) = 0;
};

class NewLevelCallbackIF {
public:
    virtual ~NewLevelCallbackIF() {}

    virtual void onNewLevelError(const ::boost::shared_ptr< Level_statusProxy >& proxy, const ::boost::shared_ptr< NewLevelError >& error) = 0;

    virtual void onNewLevelSignal(const ::boost::shared_ptr< Level_statusProxy >& proxy, const ::boost::shared_ptr< NewLevelSignal >& signal) = 0;
};


/**
 * Level_statusProxy is the client side representation of the D-Bus
 * service interface 'com.adit.de.ALD.level_status' (specified in file
 * AuthorizationLevelDaemon.xml).
 *
 * If the meaning of "com.adit.de.ALD.level_status" isn't clear, then there should be a description here.
 */
class Level_statusProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of Level_statusProxy.
     */
    static ::boost::shared_ptr< Level_statusProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of Level_statusProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< Level_statusProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of Level_statusProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< Level_statusProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Level_statusProxy > proxyNew(new Level_statusProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~Level_statusProxy ();


    // Signal 'NewLevel'

    /**
     * Notify on the signal 'NewLevel'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'NewLevel'</b>:
     *
     * If the meaning of "NewLevel" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNewLevelRegister(NewLevelCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'NewLevel'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'NewLevel'</b>:
     *
     * If the meaning of "NewLevel" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendNewLevelRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNewLevelDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'NewLevel'.
     */
    void sendNewLevelDeregisterAll () const;

    // Signal 'LevelChangeDone'

    /**
     * Notify on the signal 'LevelChangeDone'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'LevelChangeDone'</b>:
     *
     * If the meaning of "LevelChangeDone" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLevelChangeDoneRegister(LevelChangeDoneCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'LevelChangeDone'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'LevelChangeDone'</b>:
     *
     * If the meaning of "LevelChangeDone" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendLevelChangeDoneRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendLevelChangeDoneDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'LevelChangeDone'.
     */
    void sendLevelChangeDoneDeregisterAll () const;


    // Property 'level'

    /**
     * Notify on the property 'level'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'level'</b>:
     *
     * If the meaning of "level" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLevelRegister(LevelCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'level'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'level'</b>:
     *
     * If the meaning of "level" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendLevelRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendLevelDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'level'.
     */
    void sendLevelDeregisterAll() const;

    /**
     * Request the value of the property 'level' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'level'</b>:
     *
     * If the meaning of "level" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLevelGet(LevelCallbackIF& cb);


    /**
     * Returns the current value of the property 'level' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasLevel()
     * returns true.
     *
     * @return the previously received value of the property 'level'.
     */
    uint32 getLevel() const;

    /**
     * Determines whether a status message for the property 'level' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasLevel() const;


    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    Level_statusProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'level'

    ::asf::core::nullable< LevelUpdate > _level;

    DECLARE_CLASS_LOGGER();

    friend class Level_statusProxyCallback;
};

} // namespace level_status
} // namespace ALD
} // namespace de
} // namespace adit
} // namespace com

#endif // COM_ADIT_DE_ALD_LEVEL_STATUSPROXY_H
