/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "boost/shared_ptr.hpp"
#include "com/adit/de/ALD/level_status.h"
#include "com/adit/de/ALD/level_statusDBus.h"
#include "com/adit/de/ALD/level_statusJson.h"
#include "com/adit/de/ALD/level_statusProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace com {
namespace adit {
namespace de {
namespace ALD {
namespace level_status {

DEFINE_CLASS_LOGGER("/com/adit/de/ALD/level_status", Level_statusProxy);

class Level_statusProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    Level_statusProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< Level_statusProxy >& proxyShared = ::boost::static_pointer_cast< Level_statusProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_NewLevel:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NewLevelSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NewLevel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<NewLevelSignal> payload = ::boost::static_pointer_cast<NewLevelSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((NewLevelCallbackIF*) _callback)->onNewLevelSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_LevelChangeDone:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LevelChangeDoneSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LevelChangeDone", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<LevelChangeDoneSignal> payload = ::boost::static_pointer_cast<LevelChangeDoneSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((LevelChangeDoneCallbackIF*) _callback)->onLevelChangeDoneSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_level:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LevelError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Level", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LevelError> payload = ::boost::static_pointer_cast<LevelError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LevelCallbackIF*) _callback)->onLevelError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LevelUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Level", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LevelUpdate> payload = ::boost::static_pointer_cast<LevelUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LevelCallbackIF*) _callback)->onLevelUpdate(proxyShared, payload);
                        proxyShared->_level = *payload.get();
                        return true;
                    }
                }
                break;
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_NewLevel: {
                ::boost::shared_ptr< NewLevelError > payload = ::boost::shared_ptr< NewLevelError >
                (new NewLevelError(DBUS_ERROR_NO_SERVER, "The DBus service Level_status is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NewLevel", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Level_statusProxy> proxyShared = ::boost::static_pointer_cast<Level_statusProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NewLevelCallbackIF*) _callback)->onNewLevelError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LevelChangeDone: {
                ::boost::shared_ptr< LevelChangeDoneError > payload = ::boost::shared_ptr< LevelChangeDoneError >
                (new LevelChangeDoneError(DBUS_ERROR_NO_SERVER, "The DBus service Level_status is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LevelChangeDone", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Level_statusProxy> proxyShared = ::boost::static_pointer_cast<Level_statusProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LevelChangeDoneCallbackIF*) _callback)->onLevelChangeDoneError (proxyShared,payload);
                return true;
            }
            break;
            case ID_level: {
                ::boost::shared_ptr< LevelError > payload = ::boost::shared_ptr< LevelError >
                (new LevelError(DBUS_ERROR_NO_SERVER, "The DBus service Level_status is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Level", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Level_statusProxy> proxyShared = ::boost::static_pointer_cast<Level_statusProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LevelCallbackIF*) _callback)->onLevelError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Level_statusProxyCallback::_logger (Level_statusProxy::_logger);

Level_statusProxy::Level_statusProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "com.adit.de.ALD.level_status", serviceAvailable, _logger) {
}

Level_statusProxy::~Level_statusProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< Level_statusProxy > Level_statusProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<Level_statusProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< Level_statusProxy > proxyNew(new Level_statusProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t Level_statusProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    Level_statusProxyCallback* callback = new Level_statusProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t Level_statusProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    Level_statusProxyCallback* callback = new Level_statusProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Level_statusProxy::clearAllProperties ()
{
    _level = ::asf::core::nullable< LevelUpdate >();
}

void Level_statusProxy::sendDeregisterAll () const
{
    sendLevelDeregisterAll();
    sendNewLevelDeregisterAll();
    sendLevelChangeDoneDeregisterAll();
}

act_t Level_statusProxy::sendNewLevelRegister(NewLevelCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "NewLevel");
    act_t act = addSignalCallback(ID_NewLevel, "NewLevel", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NewLevel", &cb, act);
    return act;
}

bool Level_statusProxy::sendNewLevelDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("NewLevel", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NewLevel", act, static_cast<int>(rv));
    return rv;
}

void Level_statusProxy::sendNewLevelDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NewLevel");
    _dbusProxyDelegate->deregisterSignalCallback("NewLevel", 0, _dbusDaemonProxy.get(), false);
}

act_t Level_statusProxy::sendLevelChangeDoneRegister(LevelChangeDoneCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "LevelChangeDone");
    act_t act = addSignalCallback(ID_LevelChangeDone, "LevelChangeDone", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LevelChangeDone", &cb, act);
    return act;
}

bool Level_statusProxy::sendLevelChangeDoneDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LevelChangeDone", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LevelChangeDone", act, static_cast<int>(rv));
    return rv;
}

void Level_statusProxy::sendLevelChangeDoneDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LevelChangeDone");
    _dbusProxyDelegate->deregisterSignalCallback("LevelChangeDone", 0, _dbusDaemonProxy.get(), false);
}

act_t Level_statusProxy::sendLevelRegister(LevelCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_level, "level", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Level", &cb, act);
    return act;
}

bool Level_statusProxy::sendLevelDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("level", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Level", act, static_cast<int>(rv));
    return rv;
}

act_t Level_statusProxy::sendLevelGet(LevelCallbackIF& cb) {
    Level_statusProxyCallback* callback = new Level_statusProxyCallback(ID_level, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Level", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("level", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint32 Level_statusProxy::getLevel() const {
    return _level.get().getLevel();
}

bool Level_statusProxy::hasLevel() const {
    return _level.hasValue();
}

void Level_statusProxy::sendLevelDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Level");
    _dbusProxyDelegate->deregisterSignalCallback("level", 0, _dbusDaemonProxy.get(), true);
}

} // namespace level_status
} // namespace ALD
} // namespace de
} // namespace adit
} // namespace com
