/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/adit/de/ALD/change_level.h"
#include "com/adit/de/ALD/change_levelDBus.h"
#include "com/adit/de/ALD/change_levelJson.h"
#include "com/adit/de/ALD/change_levelStub.h"
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace com {
namespace adit {
namespace de {
namespace ALD {
namespace change_level {

DEFINE_CLASS_LOGGER("/com/adit/de/ALD/change_level", Change_levelStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 8, "Response", 1 },
    { 9, "Challenge", 0 },
    { 10, "LockDevice", 2 },
};


class Change_levelStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    Change_levelStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    Change_levelStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    Change_levelStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "com.adit.de.ALD.change_level"),
          _logger(logger) {}

    virtual ~Change_levelStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void Change_levelStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 3, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'Challenge'

            LOG_DEBUG_STUB("process method '%s'", "Challenge");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ChallengeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Challenge", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ChallengeRequest > payload = ::boost::static_pointer_cast<ChallengeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Change_levelStub*>(getStub())->onChallengeRequest(payload);
            return;
        }
        case 1: {

            // method 'Response'

            LOG_DEBUG_STUB("process method '%s'", "Response");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ResponseRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Response", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ResponseRequest > payload = ::boost::static_pointer_cast<ResponseRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Change_levelStub*>(getStub())->onResponseRequest(payload);
            return;
        }
        case 2: {

            // method 'LockDevice'

            LOG_DEBUG_STUB("process method '%s'", "LockDevice");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LockDeviceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "LockDevice", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< LockDeviceRequest > payload = ::boost::static_pointer_cast<LockDeviceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Change_levelStub*>(getStub())->onLockDeviceRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* Change_levelStubDelegate::introspect() const {
    return     "<interface name=\"com.adit.de.ALD.change_level\">\n"
            "      <method name=\"Challenge\">\n"
            "        <arg direction=\"in\" name=\"ecu_id\" type=\"ay\"/>\n"
            "        <arg direction=\"out\" name=\"challenge\" type=\"ay\"/>\n"
            "      </method>\n"
            "      <method name=\"Response\">\n"
            "        <arg direction=\"in\" name=\"response\" type=\"ay\"/>\n"
            "        <arg direction=\"out\" name=\"result\" type=\"u\"/>\n"
            "      </method>\n"
            "      <method name=\"LockDevice\">\n"
            "        <arg direction=\"out\" name=\"result\" type=\"u\"/>\n"
            "      </method>\n"
            "</interface>\n";
}

void Change_levelStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<Change_levelStub*>(getStub()))->onGetAll (properties);
}

void Change_levelStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void Change_levelStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

Change_levelStub::Change_levelStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new Change_levelStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

Change_levelStub::Change_levelStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new Change_levelStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

Change_levelStub::~Change_levelStub() {
    delete _stubDelegate;
}

void  Change_levelStub::sendChallengeResponse (const ::std::vector< uint8 >& challenge, act_t act) {
    ChallengeResponse* payload = new ChallengeResponse(challenge);
    DBUS_MESSAGE_REPLY(dbusMessage, "Challenge", ChallengeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Challenge", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Change_levelStub::sendChallengeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ChallengeError* payload = new ChallengeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Challenge", ChallengeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Challenge", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Change_levelStub::sendResponseResponse (uint32 result, act_t act) {
    ResponseResponse* payload = new ResponseResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "Response", ResponseResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Response", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Change_levelStub::sendResponseError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ResponseError* payload = new ResponseError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Response", ResponseError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Response", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Change_levelStub::sendLockDeviceResponse (uint32 result, act_t act) {
    LockDeviceResponse* payload = new LockDeviceResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "LockDevice", LockDeviceResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "LockDevice", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Change_levelStub::sendLockDeviceError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    LockDeviceError* payload = new LockDeviceError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "LockDevice", LockDeviceError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "LockDevice", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void Change_levelStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace change_level
} // namespace ALD
} // namespace de
} // namespace adit
} // namespace com
