/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/genivi/audiomanager/CommandInterface.h"
#include "org/genivi/audiomanager/CommandInterfaceDBus.h"
#include "org/genivi/audiomanager/CommandInterfaceJson.h"
#include "org/genivi/audiomanager/CommandInterfaceStub.h"
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace genivi {
namespace audiomanager {
namespace CommandInterface {

DEFINE_CLASS_LOGGER("/org/genivi/audiomanager/CommandInterface", CommandInterfaceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 7, "Connect", 0 },
    { 9, "SetVolume", 2 },
    { 10, "Disconnect", 1 },
    { 16, "GetListMainSinks", 8 },
    { 16, "SetSinkMuteState", 3 },
    { 17, "SetSystemProperty", 6 },
    { 18, "GetListMainSources", 9 },
    { 18, "GetListSinkClasses", 13 },
    { 20, "GetListSourceClasses", 12 },
    { 20, "GetTimingInformation", 15 },
    { 22, "GetListMainConnections", 7 },
    { 23, "GetListSystemProperties", 14 },
    { 24, "SetMainSinkSoundProperty", 4 },
    { 26, "SetMainSourceSoundProperty", 5 },
    { 30, "GetListMainSinkSoundProperties", 10 },
    { 32, "GetListMainSourceSoundProperties", 11 },
};


class CommandInterfaceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    CommandInterfaceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    CommandInterfaceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    CommandInterfaceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.genivi.audiomanager.CommandInterface"),
          _logger(logger) {}

    virtual ~CommandInterfaceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void CommandInterfaceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 16, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'Connect'

            LOG_DEBUG_STUB("process method '%s'", "Connect");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConnectRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Connect", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ConnectRequest > payload = ::boost::static_pointer_cast<ConnectRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<CommandInterfaceStub*>(getStub())->onConnectRequest(payload);
            return;
        }
        case 1: {

            // method 'Disconnect'

            LOG_DEBUG_STUB("process method '%s'", "Disconnect");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisconnectRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Disconnect", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DisconnectRequest > payload = ::boost::static_pointer_cast<DisconnectRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<CommandInterfaceStub*>(getStub())->onDisconnectRequest(payload);
            return;
        }
        case 2: {

            // method 'SetVolume'

            LOG_DEBUG_STUB("process method '%s'", "SetVolume");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetVolumeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetVolume", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetVolumeRequest > payload = ::boost::static_pointer_cast<SetVolumeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<CommandInterfaceStub*>(getStub())->onSetVolumeRequest(payload);
            return;
        }
        case 3: {

            // method 'SetSinkMuteState'

            LOG_DEBUG_STUB("process method '%s'", "SetSinkMuteState");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetSinkMuteStateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetSinkMuteState", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetSinkMuteStateRequest > payload = ::boost::static_pointer_cast<SetSinkMuteStateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<CommandInterfaceStub*>(getStub())->onSetSinkMuteStateRequest(payload);
            return;
        }
        case 4: {

            // method 'SetMainSinkSoundProperty'

            LOG_DEBUG_STUB("process method '%s'", "SetMainSinkSoundProperty");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetMainSinkSoundPropertyRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetMainSinkSoundProperty", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetMainSinkSoundPropertyRequest > payload = ::boost::static_pointer_cast<SetMainSinkSoundPropertyRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<CommandInterfaceStub*>(getStub())->onSetMainSinkSoundPropertyRequest(payload);
            return;
        }
        case 5: {

            // method 'SetMainSourceSoundProperty'

            LOG_DEBUG_STUB("process method '%s'", "SetMainSourceSoundProperty");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetMainSourceSoundPropertyRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetMainSourceSoundProperty", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetMainSourceSoundPropertyRequest > payload = ::boost::static_pointer_cast<SetMainSourceSoundPropertyRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<CommandInterfaceStub*>(getStub())->onSetMainSourceSoundPropertyRequest(payload);
            return;
        }
        case 6: {

            // method 'SetSystemProperty'

            LOG_DEBUG_STUB("process method '%s'", "SetSystemProperty");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetSystemPropertyRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetSystemProperty", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetSystemPropertyRequest > payload = ::boost::static_pointer_cast<SetSystemPropertyRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<CommandInterfaceStub*>(getStub())->onSetSystemPropertyRequest(payload);
            return;
        }
        case 7: {

            // method 'GetListMainConnections'

            LOG_DEBUG_STUB("process method '%s'", "GetListMainConnections");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetListMainConnectionsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetListMainConnections", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetListMainConnectionsRequest > payload = ::boost::static_pointer_cast<GetListMainConnectionsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<CommandInterfaceStub*>(getStub())->onGetListMainConnectionsRequest(payload);
            return;
        }
        case 8: {

            // method 'GetListMainSinks'

            LOG_DEBUG_STUB("process method '%s'", "GetListMainSinks");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetListMainSinksRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetListMainSinks", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetListMainSinksRequest > payload = ::boost::static_pointer_cast<GetListMainSinksRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<CommandInterfaceStub*>(getStub())->onGetListMainSinksRequest(payload);
            return;
        }
        case 9: {

            // method 'GetListMainSources'

            LOG_DEBUG_STUB("process method '%s'", "GetListMainSources");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetListMainSourcesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetListMainSources", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetListMainSourcesRequest > payload = ::boost::static_pointer_cast<GetListMainSourcesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<CommandInterfaceStub*>(getStub())->onGetListMainSourcesRequest(payload);
            return;
        }
        case 10: {

            // method 'GetListMainSinkSoundProperties'

            LOG_DEBUG_STUB("process method '%s'", "GetListMainSinkSoundProperties");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetListMainSinkSoundPropertiesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetListMainSinkSoundProperties", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetListMainSinkSoundPropertiesRequest > payload = ::boost::static_pointer_cast<GetListMainSinkSoundPropertiesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<CommandInterfaceStub*>(getStub())->onGetListMainSinkSoundPropertiesRequest(payload);
            return;
        }
        case 11: {

            // method 'GetListMainSourceSoundProperties'

            LOG_DEBUG_STUB("process method '%s'", "GetListMainSourceSoundProperties");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetListMainSourceSoundPropertiesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetListMainSourceSoundProperties", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetListMainSourceSoundPropertiesRequest > payload = ::boost::static_pointer_cast<GetListMainSourceSoundPropertiesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<CommandInterfaceStub*>(getStub())->onGetListMainSourceSoundPropertiesRequest(payload);
            return;
        }
        case 12: {

            // method 'GetListSourceClasses'

            LOG_DEBUG_STUB("process method '%s'", "GetListSourceClasses");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetListSourceClassesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetListSourceClasses", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetListSourceClassesRequest > payload = ::boost::static_pointer_cast<GetListSourceClassesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<CommandInterfaceStub*>(getStub())->onGetListSourceClassesRequest(payload);
            return;
        }
        case 13: {

            // method 'GetListSinkClasses'

            LOG_DEBUG_STUB("process method '%s'", "GetListSinkClasses");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetListSinkClassesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetListSinkClasses", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetListSinkClassesRequest > payload = ::boost::static_pointer_cast<GetListSinkClassesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<CommandInterfaceStub*>(getStub())->onGetListSinkClassesRequest(payload);
            return;
        }
        case 14: {

            // method 'GetListSystemProperties'

            LOG_DEBUG_STUB("process method '%s'", "GetListSystemProperties");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetListSystemPropertiesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetListSystemProperties", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetListSystemPropertiesRequest > payload = ::boost::static_pointer_cast<GetListSystemPropertiesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<CommandInterfaceStub*>(getStub())->onGetListSystemPropertiesRequest(payload);
            return;
        }
        case 15: {

            // method 'GetTimingInformation'

            LOG_DEBUG_STUB("process method '%s'", "GetTimingInformation");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetTimingInformationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetTimingInformation", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetTimingInformationRequest > payload = ::boost::static_pointer_cast<GetTimingInformationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<CommandInterfaceStub*>(getStub())->onGetTimingInformationRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* CommandInterfaceStubDelegate::introspect() const {
    return     "<interface name=\"org.genivi.audiomanager.CommandInterface\">\n"
            "      <doc>\n"
            "        <line>structure describing sink class</line>\n"
            "        <line>Param 1: Type - u16int_t : Sink Class ID </line>\n"
            "        <line>Param 2: Type - string : Sink class Name</line>\n"
            "        <line>Param 3: Type - list of am_ClassProperty_s : list of class properties</line>\n"
            "      </doc>\n"
            "      <method name=\"Connect\">\n"
            "        <doc>\n"
            "          <line>In case of successful connection, audio manager issues a connection ID for the current connection made</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"sourceID\" type=\"q\"/>\n"
            "        <arg direction=\"in\" name=\"sinkID\" type=\"q\"/>\n"
            "        <arg direction=\"out\" name=\"result\" type=\"n\"/>\n"
            "        <arg direction=\"out\" name=\"mainConnectionID\" type=\"q\"/>\n"
            "      </method>\n"
            "      <method name=\"Disconnect\">\n"
            "        <doc>\n"
            "          <line>Result of operation. Refer list of error codes.</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"mainConnectionID\" type=\"q\"/>\n"
            "        <arg direction=\"out\" name=\"result\" type=\"n\"/>\n"
            "      </method>\n"
            "      <method name=\"SetVolume\">\n"
            "        <doc>\n"
            "          <line>Result of operation. Refer list of error codes.</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"sinkID\" type=\"q\"/>\n"
            "        <arg direction=\"in\" name=\"Mode\" type=\"q\"/>\n"
            "        <arg direction=\"in\" name=\"value\" type=\"n\"/>\n"
            "        <arg direction=\"out\" name=\"result\" type=\"n\"/>\n"
            "      </method>\n"
            "      <method name=\"SetSinkMuteState\">\n"
            "        <doc>\n"
            "          <line>Result of operation. Refer list of error codes.</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"sinkID\" type=\"q\"/>\n"
            "        <arg direction=\"in\" name=\"muteState\" type=\"n\"/>\n"
            "        <arg direction=\"out\" name=\"result\" type=\"n\"/>\n"
            "      </method>\n"
            "      <method name=\"SetMainSinkSoundProperty\">\n"
            "        <doc>\n"
            "          <line>Result of operation. Refer list of error codes.</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"sinkID\" type=\"q\"/>\n"
            "        <arg direction=\"in\" name=\"soundProperty\" type=\"(nn)\"/>\n"
            "        <arg direction=\"out\" name=\"result\" type=\"n\"/>\n"
            "      </method>\n"
            "      <method name=\"SetMainSourceSoundProperty\">\n"
            "        <doc>\n"
            "          <line>Result of operation. Refer list of error codes.</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"sourceID\" type=\"q\"/>\n"
            "        <arg direction=\"in\" name=\"soundProperty\" type=\"(nn)\"/>\n"
            "        <arg direction=\"out\" name=\"result\" type=\"n\"/>\n"
            "      </method>\n"
            "      <method name=\"SetSystemProperty\">\n"
            "        <doc>\n"
            "          <line>Result of operation. Refer list of error codes.</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"property\" type=\"(nn)\"/>\n"
            "        <arg direction=\"out\" name=\"result\" type=\"n\"/>\n"
            "      </method>\n"
            "      <method name=\"GetListMainConnections\">\n"
            "        <doc>\n"
            "          <line>list of main connections. Refer to am_MainConnectionType_s</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"result\" type=\"n\"/>\n"
            "        <arg direction=\"out\" name=\"listConnections\" type=\"a(qqqnn)\"/>\n"
            "      </method>\n"
            "      <method name=\"GetListMainSinks\">\n"
            "        <doc>\n"
            "          <line>List of actual sinks. Refer to am_SinkType_s</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"result\" type=\"n\"/>\n"
            "        <arg direction=\"out\" name=\"listMainSinks\" type=\"a(qs(nn)nnq)\"/>\n"
            "      </method>\n"
            "      <method name=\"GetListMainSources\">\n"
            "        <doc>\n"
            "          <line>List of actual sources. Refer to am_SourceType_s</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"result\" type=\"n\"/>\n"
            "        <arg direction=\"out\" name=\"listMainSources\" type=\"a(qs(nn)q)\"/>\n"
            "      </method>\n"
            "      <method name=\"GetListMainSinkSoundProperties\">\n"
            "        <doc>\n"
            "          <line>List of sound properties. Refer to am_MainSoundProperty_s</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"sinkID\" type=\"q\"/>\n"
            "        <arg direction=\"out\" name=\"result\" type=\"n\"/>\n"
            "        <arg direction=\"out\" name=\"listSoundProperties\" type=\"a(nn)\"/>\n"
            "      </method>\n"
            "      <method name=\"GetListMainSourceSoundProperties\">\n"
            "        <doc>\n"
            "          <line>List of sound properties. Refer to am_MainSoundProperty_s</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"sourceID\" type=\"q\"/>\n"
            "        <arg direction=\"out\" name=\"result\" type=\"n\"/>\n"
            "        <arg direction=\"out\" name=\"listSourceProperties\" type=\"a(nn)\"/>\n"
            "      </method>\n"
            "      <method name=\"GetListSourceClasses\">\n"
            "        <doc>\n"
            "          <line>List of source classes. Refer am_SourceClass_s</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"result\" type=\"n\"/>\n"
            "        <arg direction=\"out\" name=\"listSourceClasses\" type=\"a(qsa(nn))\"/>\n"
            "      </method>\n"
            "      <method name=\"GetListSinkClasses\">\n"
            "        <doc>\n"
            "          <line>List of Sink Classes. Refer am_SinkClass_s</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"result\" type=\"n\"/>\n"
            "        <arg direction=\"out\" name=\"listSinkClasses\" type=\"a(qsa(nn))\"/>\n"
            "      </method>\n"
            "      <method name=\"GetListSystemProperties\">\n"
            "        <doc>\n"
            "          <line>List of System Properties. Refer am_SystemProperty_s</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"result\" type=\"n\"/>\n"
            "        <arg direction=\"in\" name=\"listSystemProperties\" type=\"a(nn)\"/>\n"
            "      </method>\n"
            "      <method name=\"GetTimingInformation\">\n"
            "        <doc>\n"
            "          <line>Delay in Milliseconds</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"mainConnectionID\" type=\"q\"/>\n"
            "        <arg direction=\"out\" name=\"result\" type=\"n\"/>\n"
            "        <arg direction=\"out\" name=\"delay\" type=\"n\"/>\n"
            "      </method>\n"
            "      <signal name=\"NumberOfMainConnectionsChanged\">\n"
            "        <doc>\n"
            "          <line>Signal to indicate change in the number of main connections</line>\n"
            "        </doc>\n"
            "      </signal>\n"
            "      <signal name=\"SinkAdded\">\n"
            "        <doc>\n"
            "          <line>New Sink type added. Refer am_SinkType_s</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"newSink\" type=\"(qs(nn)nnq)\"/>\n"
            "      </signal>\n"
            "      <signal name=\"SinkRemoved\">\n"
            "        <doc>\n"
            "          <line>Sink ID of the removed sink</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"removedSinkID\" type=\"q\"/>\n"
            "      </signal>\n"
            "      <signal name=\"SourceAdded\">\n"
            "        <doc>\n"
            "          <line>New Source type added. Refer am_SourceType_s</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"newSource\" type=\"(qs(nn)q)\"/>\n"
            "      </signal>\n"
            "      <signal name=\"SourceRemoved\">\n"
            "        <doc>\n"
            "          <line>ID of the removed source</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"removedSourceID\" type=\"q\"/>\n"
            "      </signal>\n"
            "      <signal name=\"NumberOfSinkClassesChanged\">\n"
            "        <doc>\n"
            "          <line>Signal to indicate that Number of Sink Classes is changed</line>\n"
            "        </doc>\n"
            "      </signal>\n"
            "      <signal name=\"NumberOfSourceClassesChanged\">\n"
            "        <doc>\n"
            "          <line>Signal to indicate Number of Source Classes is changed</line>\n"
            "        </doc>\n"
            "      </signal>\n"
            "      <signal name=\"MainConnectionStateChanged\">\n"
            "        <doc>\n"
            "          <line>Current Connection State. Refer am_ConnectionState_e</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"connectionID\" type=\"q\"/>\n"
            "        <arg direction=\"out\" name=\"connectionState\" type=\"n\"/>\n"
            "      </signal>\n"
            "      <signal name=\"MainSinkSoundPropertyChanged\">\n"
            "        <doc>\n"
            "          <line>Sound Property Changed. Refer am_MainSoundProperty_s</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"sinkID\" type=\"q\"/>\n"
            "        <arg direction=\"out\" name=\"SoundProperty\" type=\"(nn)\"/>\n"
            "      </signal>\n"
            "      <signal name=\"MainSourceSoundPropertyChanged\">\n"
            "        <doc>\n"
            "          <line>Sound Property Changed. Refer am_MainSoundProperty_s</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"sourceID\" type=\"q\"/>\n"
            "        <arg direction=\"out\" name=\"SoundProperty\" type=\"(nn)\"/>\n"
            "      </signal>\n"
            "      <signal name=\"SinkAvailabilityChanged\">\n"
            "        <doc>\n"
            "          <line>Current availability. Refer am_Availability_s</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"sinkID\" type=\"q\"/>\n"
            "        <arg direction=\"out\" name=\"availability\" type=\"(nn)\"/>\n"
            "      </signal>\n"
            "      <signal name=\"SourceAvailabilityChanged\">\n"
            "        <doc>\n"
            "          <line>current availability. Refer am_Availability_s</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"sourceID\" type=\"q\"/>\n"
            "        <arg direction=\"out\" name=\"availability\" type=\"(nn)\"/>\n"
            "      </signal>\n"
            "      <signal name=\"VolumeChanged\">\n"
            "        <doc>\n"
            "          <line>Current volume</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"sinkID\" type=\"q\"/>\n"
            "        <arg direction=\"out\" name=\"volume\" type=\"n\"/>\n"
            "      </signal>\n"
            "      <signal name=\"SinkMuteStateChanged\">\n"
            "        <doc>\n"
            "          <line>Current Mute state. Refer am_MuteState_e</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"sinkID\" type=\"q\"/>\n"
            "        <arg direction=\"out\" name=\"muteState\" type=\"n\"/>\n"
            "      </signal>\n"
            "      <signal name=\"SystemPropertyChanged\">\n"
            "        <doc>\n"
            "          <line>Changed System property. Refer am_SystemProperty_s</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"SystemProperty\" type=\"(nn)\"/>\n"
            "      </signal>\n"
            "      <signal name=\"TimingInformationChanged\">\n"
            "        <doc>\n"
            "          <line>changed time (delay) in milli seconds</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"mainConnection\" type=\"q\"/>\n"
            "        <arg direction=\"out\" name=\"time\" type=\"n\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void CommandInterfaceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<CommandInterfaceStub*>(getStub()))->onGetAll (properties);
}

void CommandInterfaceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void CommandInterfaceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

CommandInterfaceStub::CommandInterfaceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new CommandInterfaceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

CommandInterfaceStub::CommandInterfaceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new CommandInterfaceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

CommandInterfaceStub::~CommandInterfaceStub() {
    delete _stubDelegate;
}

void CommandInterfaceStub::sendNumberOfMainConnectionsChangedSignal() {
    if (_stubDelegate->isConnected()) {
        NumberOfMainConnectionsChangedSignal* payload = new NumberOfMainConnectionsChangedSignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "NumberOfMainConnectionsChanged", NumberOfMainConnectionsChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "NumberOfMainConnectionsChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "NumberOfMainConnectionsChanged");
    }
}

void CommandInterfaceStub::sendSinkAddedSignal(const SinkAddedSignalNewSinkStruct& newSink) {
    if (_stubDelegate->isConnected()) {
        SinkAddedSignal* payload = new SinkAddedSignal(newSink);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SinkAdded", SinkAddedSignal, payload)
        LOG_INFO ("-> send%sSignal", "SinkAdded");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SinkAdded");
    }
}

void CommandInterfaceStub::sendSinkRemovedSignal(uint16 removedSinkID) {
    if (_stubDelegate->isConnected()) {
        SinkRemovedSignal* payload = new SinkRemovedSignal(removedSinkID);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SinkRemoved", SinkRemovedSignal, payload)
        LOG_INFO ("-> send%sSignal", "SinkRemoved");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SinkRemoved");
    }
}

void CommandInterfaceStub::sendSourceAddedSignal(const SourceAddedSignalNewSourceStruct& newSource) {
    if (_stubDelegate->isConnected()) {
        SourceAddedSignal* payload = new SourceAddedSignal(newSource);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SourceAdded", SourceAddedSignal, payload)
        LOG_INFO ("-> send%sSignal", "SourceAdded");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SourceAdded");
    }
}

void CommandInterfaceStub::sendSourceRemovedSignal(uint16 removedSourceID) {
    if (_stubDelegate->isConnected()) {
        SourceRemovedSignal* payload = new SourceRemovedSignal(removedSourceID);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SourceRemoved", SourceRemovedSignal, payload)
        LOG_INFO ("-> send%sSignal", "SourceRemoved");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SourceRemoved");
    }
}

void CommandInterfaceStub::sendNumberOfSinkClassesChangedSignal() {
    if (_stubDelegate->isConnected()) {
        NumberOfSinkClassesChangedSignal* payload = new NumberOfSinkClassesChangedSignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "NumberOfSinkClassesChanged", NumberOfSinkClassesChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "NumberOfSinkClassesChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "NumberOfSinkClassesChanged");
    }
}

void CommandInterfaceStub::sendNumberOfSourceClassesChangedSignal() {
    if (_stubDelegate->isConnected()) {
        NumberOfSourceClassesChangedSignal* payload = new NumberOfSourceClassesChangedSignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "NumberOfSourceClassesChanged", NumberOfSourceClassesChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "NumberOfSourceClassesChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "NumberOfSourceClassesChanged");
    }
}

void CommandInterfaceStub::sendMainConnectionStateChangedSignal(uint16 connectionID, int16 connectionState) {
    if (_stubDelegate->isConnected()) {
        MainConnectionStateChangedSignal* payload = new MainConnectionStateChangedSignal(connectionID, connectionState);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "MainConnectionStateChanged", MainConnectionStateChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "MainConnectionStateChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "MainConnectionStateChanged");
    }
}

void CommandInterfaceStub::sendMainSinkSoundPropertyChangedSignal(uint16 sinkID, const MainSinkSoundPropertyChangedSignalSoundPropertyStruct& soundProperty) {
    if (_stubDelegate->isConnected()) {
        MainSinkSoundPropertyChangedSignal* payload = new MainSinkSoundPropertyChangedSignal(sinkID, soundProperty);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "MainSinkSoundPropertyChanged", MainSinkSoundPropertyChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "MainSinkSoundPropertyChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "MainSinkSoundPropertyChanged");
    }
}

void CommandInterfaceStub::sendMainSourceSoundPropertyChangedSignal(uint16 sourceID, const MainSourceSoundPropertyChangedSignalSoundPropertyStruct& soundProperty) {
    if (_stubDelegate->isConnected()) {
        MainSourceSoundPropertyChangedSignal* payload = new MainSourceSoundPropertyChangedSignal(sourceID, soundProperty);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "MainSourceSoundPropertyChanged", MainSourceSoundPropertyChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "MainSourceSoundPropertyChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "MainSourceSoundPropertyChanged");
    }
}

void CommandInterfaceStub::sendSinkAvailabilityChangedSignal(uint16 sinkID, const SinkAvailabilityChangedSignalAvailabilityStruct& availability) {
    if (_stubDelegate->isConnected()) {
        SinkAvailabilityChangedSignal* payload = new SinkAvailabilityChangedSignal(sinkID, availability);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SinkAvailabilityChanged", SinkAvailabilityChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "SinkAvailabilityChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SinkAvailabilityChanged");
    }
}

void CommandInterfaceStub::sendSourceAvailabilityChangedSignal(uint16 sourceID, const SourceAvailabilityChangedSignalAvailabilityStruct& availability) {
    if (_stubDelegate->isConnected()) {
        SourceAvailabilityChangedSignal* payload = new SourceAvailabilityChangedSignal(sourceID, availability);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SourceAvailabilityChanged", SourceAvailabilityChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "SourceAvailabilityChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SourceAvailabilityChanged");
    }
}

void CommandInterfaceStub::sendVolumeChangedSignal(uint16 sinkID, int16 volume) {
    if (_stubDelegate->isConnected()) {
        VolumeChangedSignal* payload = new VolumeChangedSignal(sinkID, volume);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "VolumeChanged", VolumeChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "VolumeChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "VolumeChanged");
    }
}

void CommandInterfaceStub::sendSinkMuteStateChangedSignal(uint16 sinkID, int16 muteState) {
    if (_stubDelegate->isConnected()) {
        SinkMuteStateChangedSignal* payload = new SinkMuteStateChangedSignal(sinkID, muteState);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SinkMuteStateChanged", SinkMuteStateChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "SinkMuteStateChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SinkMuteStateChanged");
    }
}

void CommandInterfaceStub::sendSystemPropertyChangedSignal(const SystemPropertyChangedSignalSystemPropertyStruct& systemProperty) {
    if (_stubDelegate->isConnected()) {
        SystemPropertyChangedSignal* payload = new SystemPropertyChangedSignal(systemProperty);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SystemPropertyChanged", SystemPropertyChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "SystemPropertyChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SystemPropertyChanged");
    }
}

void CommandInterfaceStub::sendTimingInformationChangedSignal(uint16 mainConnection, int16 time) {
    if (_stubDelegate->isConnected()) {
        TimingInformationChangedSignal* payload = new TimingInformationChangedSignal(mainConnection, time);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "TimingInformationChanged", TimingInformationChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "TimingInformationChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "TimingInformationChanged");
    }
}

void  CommandInterfaceStub::sendConnectResponse (int16 result, uint16 mainConnectionID, act_t act) {
    ConnectResponse* payload = new ConnectResponse(result, mainConnectionID);
    DBUS_MESSAGE_REPLY(dbusMessage, "Connect", ConnectResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Connect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendConnectError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ConnectError* payload = new ConnectError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Connect", ConnectError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Connect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendDisconnectResponse (int16 result, act_t act) {
    DisconnectResponse* payload = new DisconnectResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "Disconnect", DisconnectResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Disconnect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendDisconnectError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DisconnectError* payload = new DisconnectError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Disconnect", DisconnectError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Disconnect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendSetVolumeResponse (int16 result, act_t act) {
    SetVolumeResponse* payload = new SetVolumeResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "SetVolume", SetVolumeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetVolume", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendSetVolumeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetVolumeError* payload = new SetVolumeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetVolume", SetVolumeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetVolume", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendSetSinkMuteStateResponse (int16 result, act_t act) {
    SetSinkMuteStateResponse* payload = new SetSinkMuteStateResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "SetSinkMuteState", SetSinkMuteStateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetSinkMuteState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendSetSinkMuteStateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetSinkMuteStateError* payload = new SetSinkMuteStateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetSinkMuteState", SetSinkMuteStateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetSinkMuteState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendSetMainSinkSoundPropertyResponse (int16 result, act_t act) {
    SetMainSinkSoundPropertyResponse* payload = new SetMainSinkSoundPropertyResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "SetMainSinkSoundProperty", SetMainSinkSoundPropertyResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetMainSinkSoundProperty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendSetMainSinkSoundPropertyError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetMainSinkSoundPropertyError* payload = new SetMainSinkSoundPropertyError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetMainSinkSoundProperty", SetMainSinkSoundPropertyError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetMainSinkSoundProperty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendSetMainSourceSoundPropertyResponse (int16 result, act_t act) {
    SetMainSourceSoundPropertyResponse* payload = new SetMainSourceSoundPropertyResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "SetMainSourceSoundProperty", SetMainSourceSoundPropertyResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetMainSourceSoundProperty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendSetMainSourceSoundPropertyError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetMainSourceSoundPropertyError* payload = new SetMainSourceSoundPropertyError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetMainSourceSoundProperty", SetMainSourceSoundPropertyError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetMainSourceSoundProperty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendSetSystemPropertyResponse (int16 result, act_t act) {
    SetSystemPropertyResponse* payload = new SetSystemPropertyResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "SetSystemProperty", SetSystemPropertyResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetSystemProperty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendSetSystemPropertyError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetSystemPropertyError* payload = new SetSystemPropertyError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetSystemProperty", SetSystemPropertyError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetSystemProperty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendGetListMainConnectionsResponse (int16 result, const ::std::vector< GetListMainConnectionsResponseListConnectionsStruct >& listConnections, act_t act) {
    GetListMainConnectionsResponse* payload = new GetListMainConnectionsResponse(result, listConnections);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetListMainConnections", GetListMainConnectionsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetListMainConnections", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendGetListMainConnectionsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetListMainConnectionsError* payload = new GetListMainConnectionsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetListMainConnections", GetListMainConnectionsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetListMainConnections", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendGetListMainSinksResponse (int16 result, const ::std::vector< GetListMainSinksResponseListMainSinksStruct >& listMainSinks, act_t act) {
    GetListMainSinksResponse* payload = new GetListMainSinksResponse(result, listMainSinks);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetListMainSinks", GetListMainSinksResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetListMainSinks", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendGetListMainSinksError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetListMainSinksError* payload = new GetListMainSinksError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetListMainSinks", GetListMainSinksError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetListMainSinks", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendGetListMainSourcesResponse (int16 result, const ::std::vector< GetListMainSourcesResponseListMainSourcesStruct >& listMainSources, act_t act) {
    GetListMainSourcesResponse* payload = new GetListMainSourcesResponse(result, listMainSources);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetListMainSources", GetListMainSourcesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetListMainSources", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendGetListMainSourcesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetListMainSourcesError* payload = new GetListMainSourcesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetListMainSources", GetListMainSourcesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetListMainSources", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendGetListMainSinkSoundPropertiesResponse (int16 result, const ::std::vector< GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct >& listSoundProperties, act_t act) {
    GetListMainSinkSoundPropertiesResponse* payload = new GetListMainSinkSoundPropertiesResponse(result, listSoundProperties);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetListMainSinkSoundProperties", GetListMainSinkSoundPropertiesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetListMainSinkSoundProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendGetListMainSinkSoundPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetListMainSinkSoundPropertiesError* payload = new GetListMainSinkSoundPropertiesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetListMainSinkSoundProperties", GetListMainSinkSoundPropertiesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetListMainSinkSoundProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendGetListMainSourceSoundPropertiesResponse (int16 result, const ::std::vector< GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct >& listSourceProperties, act_t act) {
    GetListMainSourceSoundPropertiesResponse* payload = new GetListMainSourceSoundPropertiesResponse(result, listSourceProperties);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetListMainSourceSoundProperties", GetListMainSourceSoundPropertiesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetListMainSourceSoundProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendGetListMainSourceSoundPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetListMainSourceSoundPropertiesError* payload = new GetListMainSourceSoundPropertiesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetListMainSourceSoundProperties", GetListMainSourceSoundPropertiesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetListMainSourceSoundProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendGetListSourceClassesResponse (int16 result, const ::std::vector< GetListSourceClassesResponseListSourceClassesStruct >& listSourceClasses, act_t act) {
    GetListSourceClassesResponse* payload = new GetListSourceClassesResponse(result, listSourceClasses);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetListSourceClasses", GetListSourceClassesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetListSourceClasses", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendGetListSourceClassesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetListSourceClassesError* payload = new GetListSourceClassesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetListSourceClasses", GetListSourceClassesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetListSourceClasses", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendGetListSinkClassesResponse (int16 result, const ::std::vector< GetListSinkClassesResponseListSinkClassesStruct >& listSinkClasses, act_t act) {
    GetListSinkClassesResponse* payload = new GetListSinkClassesResponse(result, listSinkClasses);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetListSinkClasses", GetListSinkClassesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetListSinkClasses", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendGetListSinkClassesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetListSinkClassesError* payload = new GetListSinkClassesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetListSinkClasses", GetListSinkClassesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetListSinkClasses", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendGetListSystemPropertiesResponse (int16 result, act_t act) {
    GetListSystemPropertiesResponse* payload = new GetListSystemPropertiesResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetListSystemProperties", GetListSystemPropertiesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetListSystemProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendGetListSystemPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetListSystemPropertiesError* payload = new GetListSystemPropertiesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetListSystemProperties", GetListSystemPropertiesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetListSystemProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendGetTimingInformationResponse (int16 result, int16 delay, act_t act) {
    GetTimingInformationResponse* payload = new GetTimingInformationResponse(result, delay);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetTimingInformation", GetTimingInformationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetTimingInformation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  CommandInterfaceStub::sendGetTimingInformationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetTimingInformationError* payload = new GetTimingInformationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetTimingInformation", GetTimingInformationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetTimingInformation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void CommandInterfaceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace CommandInterface
} // namespace audiomanager
} // namespace genivi
} // namespace org
