/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_GENIVI_AUDIOMANAGER_COMMANDINTERFACEPROXY_H
#define ORG_GENIVI_AUDIOMANAGER_COMMANDINTERFACEPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/genivi/audiomanager/CommandInterface.h"
#include <dbus/dbus.h>
#include <vector>

namespace org {
namespace genivi {
namespace audiomanager {
namespace CommandInterface {

class CommandInterfaceProxy;

class ConnectCallbackIF {
public:
    virtual ~ConnectCallbackIF() {}

    virtual void onConnectError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< ConnectError >& error) = 0;

    virtual void onConnectResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< ConnectResponse >& response) = 0;
};

class DisconnectCallbackIF {
public:
    virtual ~DisconnectCallbackIF() {}

    virtual void onDisconnectError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< DisconnectError >& error) = 0;

    virtual void onDisconnectResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< DisconnectResponse >& response) = 0;
};

class GetListMainConnectionsCallbackIF {
public:
    virtual ~GetListMainConnectionsCallbackIF() {}

    virtual void onGetListMainConnectionsError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetListMainConnectionsError >& error) = 0;

    virtual void onGetListMainConnectionsResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetListMainConnectionsResponse >& response) = 0;
};

class GetListMainSinkSoundPropertiesCallbackIF {
public:
    virtual ~GetListMainSinkSoundPropertiesCallbackIF() {}

    virtual void onGetListMainSinkSoundPropertiesError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetListMainSinkSoundPropertiesError >& error) = 0;

    virtual void onGetListMainSinkSoundPropertiesResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetListMainSinkSoundPropertiesResponse >& response) = 0;
};

class GetListMainSinksCallbackIF {
public:
    virtual ~GetListMainSinksCallbackIF() {}

    virtual void onGetListMainSinksError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetListMainSinksError >& error) = 0;

    virtual void onGetListMainSinksResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetListMainSinksResponse >& response) = 0;
};

class GetListMainSourceSoundPropertiesCallbackIF {
public:
    virtual ~GetListMainSourceSoundPropertiesCallbackIF() {}

    virtual void onGetListMainSourceSoundPropertiesError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetListMainSourceSoundPropertiesError >& error) = 0;

    virtual void onGetListMainSourceSoundPropertiesResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetListMainSourceSoundPropertiesResponse >& response) = 0;
};

class GetListMainSourcesCallbackIF {
public:
    virtual ~GetListMainSourcesCallbackIF() {}

    virtual void onGetListMainSourcesError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetListMainSourcesError >& error) = 0;

    virtual void onGetListMainSourcesResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetListMainSourcesResponse >& response) = 0;
};

class GetListSinkClassesCallbackIF {
public:
    virtual ~GetListSinkClassesCallbackIF() {}

    virtual void onGetListSinkClassesError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetListSinkClassesError >& error) = 0;

    virtual void onGetListSinkClassesResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetListSinkClassesResponse >& response) = 0;
};

class GetListSourceClassesCallbackIF {
public:
    virtual ~GetListSourceClassesCallbackIF() {}

    virtual void onGetListSourceClassesError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetListSourceClassesError >& error) = 0;

    virtual void onGetListSourceClassesResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetListSourceClassesResponse >& response) = 0;
};

class GetListSystemPropertiesCallbackIF {
public:
    virtual ~GetListSystemPropertiesCallbackIF() {}

    virtual void onGetListSystemPropertiesError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetListSystemPropertiesError >& error) = 0;

    virtual void onGetListSystemPropertiesResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetListSystemPropertiesResponse >& response) = 0;
};

class GetTimingInformationCallbackIF {
public:
    virtual ~GetTimingInformationCallbackIF() {}

    virtual void onGetTimingInformationError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetTimingInformationError >& error) = 0;

    virtual void onGetTimingInformationResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetTimingInformationResponse >& response) = 0;
};

class MainConnectionStateChangedCallbackIF {
public:
    virtual ~MainConnectionStateChangedCallbackIF() {}

    virtual void onMainConnectionStateChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< MainConnectionStateChangedError >& error) = 0;

    virtual void onMainConnectionStateChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< MainConnectionStateChangedSignal >& signal) = 0;
};

class MainSinkSoundPropertyChangedCallbackIF {
public:
    virtual ~MainSinkSoundPropertyChangedCallbackIF() {}

    virtual void onMainSinkSoundPropertyChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< MainSinkSoundPropertyChangedError >& error) = 0;

    virtual void onMainSinkSoundPropertyChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< MainSinkSoundPropertyChangedSignal >& signal) = 0;
};

class MainSourceSoundPropertyChangedCallbackIF {
public:
    virtual ~MainSourceSoundPropertyChangedCallbackIF() {}

    virtual void onMainSourceSoundPropertyChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< MainSourceSoundPropertyChangedError >& error) = 0;

    virtual void onMainSourceSoundPropertyChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< MainSourceSoundPropertyChangedSignal >& signal) = 0;
};

class NumberOfMainConnectionsChangedCallbackIF {
public:
    virtual ~NumberOfMainConnectionsChangedCallbackIF() {}

    virtual void onNumberOfMainConnectionsChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< NumberOfMainConnectionsChangedError >& error) = 0;

    virtual void onNumberOfMainConnectionsChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< NumberOfMainConnectionsChangedSignal >& signal) = 0;
};

class NumberOfSinkClassesChangedCallbackIF {
public:
    virtual ~NumberOfSinkClassesChangedCallbackIF() {}

    virtual void onNumberOfSinkClassesChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< NumberOfSinkClassesChangedError >& error) = 0;

    virtual void onNumberOfSinkClassesChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< NumberOfSinkClassesChangedSignal >& signal) = 0;
};

class NumberOfSourceClassesChangedCallbackIF {
public:
    virtual ~NumberOfSourceClassesChangedCallbackIF() {}

    virtual void onNumberOfSourceClassesChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< NumberOfSourceClassesChangedError >& error) = 0;

    virtual void onNumberOfSourceClassesChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< NumberOfSourceClassesChangedSignal >& signal) = 0;
};

class SetMainSinkSoundPropertyCallbackIF {
public:
    virtual ~SetMainSinkSoundPropertyCallbackIF() {}

    virtual void onSetMainSinkSoundPropertyError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SetMainSinkSoundPropertyError >& error) = 0;

    virtual void onSetMainSinkSoundPropertyResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SetMainSinkSoundPropertyResponse >& response) = 0;
};

class SetMainSourceSoundPropertyCallbackIF {
public:
    virtual ~SetMainSourceSoundPropertyCallbackIF() {}

    virtual void onSetMainSourceSoundPropertyError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SetMainSourceSoundPropertyError >& error) = 0;

    virtual void onSetMainSourceSoundPropertyResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SetMainSourceSoundPropertyResponse >& response) = 0;
};

class SetSinkMuteStateCallbackIF {
public:
    virtual ~SetSinkMuteStateCallbackIF() {}

    virtual void onSetSinkMuteStateError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SetSinkMuteStateError >& error) = 0;

    virtual void onSetSinkMuteStateResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SetSinkMuteStateResponse >& response) = 0;
};

class SetSystemPropertyCallbackIF {
public:
    virtual ~SetSystemPropertyCallbackIF() {}

    virtual void onSetSystemPropertyError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SetSystemPropertyError >& error) = 0;

    virtual void onSetSystemPropertyResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SetSystemPropertyResponse >& response) = 0;
};

class SetVolumeCallbackIF {
public:
    virtual ~SetVolumeCallbackIF() {}

    virtual void onSetVolumeError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SetVolumeError >& error) = 0;

    virtual void onSetVolumeResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SetVolumeResponse >& response) = 0;
};

class SinkAddedCallbackIF {
public:
    virtual ~SinkAddedCallbackIF() {}

    virtual void onSinkAddedError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SinkAddedError >& error) = 0;

    virtual void onSinkAddedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SinkAddedSignal >& signal) = 0;
};

class SinkAvailabilityChangedCallbackIF {
public:
    virtual ~SinkAvailabilityChangedCallbackIF() {}

    virtual void onSinkAvailabilityChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SinkAvailabilityChangedError >& error) = 0;

    virtual void onSinkAvailabilityChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SinkAvailabilityChangedSignal >& signal) = 0;
};

class SinkMuteStateChangedCallbackIF {
public:
    virtual ~SinkMuteStateChangedCallbackIF() {}

    virtual void onSinkMuteStateChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SinkMuteStateChangedError >& error) = 0;

    virtual void onSinkMuteStateChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SinkMuteStateChangedSignal >& signal) = 0;
};

class SinkRemovedCallbackIF {
public:
    virtual ~SinkRemovedCallbackIF() {}

    virtual void onSinkRemovedError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SinkRemovedError >& error) = 0;

    virtual void onSinkRemovedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SinkRemovedSignal >& signal) = 0;
};

class SourceAddedCallbackIF {
public:
    virtual ~SourceAddedCallbackIF() {}

    virtual void onSourceAddedError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SourceAddedError >& error) = 0;

    virtual void onSourceAddedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SourceAddedSignal >& signal) = 0;
};

class SourceAvailabilityChangedCallbackIF {
public:
    virtual ~SourceAvailabilityChangedCallbackIF() {}

    virtual void onSourceAvailabilityChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SourceAvailabilityChangedError >& error) = 0;

    virtual void onSourceAvailabilityChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SourceAvailabilityChangedSignal >& signal) = 0;
};

class SourceRemovedCallbackIF {
public:
    virtual ~SourceRemovedCallbackIF() {}

    virtual void onSourceRemovedError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SourceRemovedError >& error) = 0;

    virtual void onSourceRemovedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SourceRemovedSignal >& signal) = 0;
};

class SystemPropertyChangedCallbackIF {
public:
    virtual ~SystemPropertyChangedCallbackIF() {}

    virtual void onSystemPropertyChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SystemPropertyChangedError >& error) = 0;

    virtual void onSystemPropertyChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SystemPropertyChangedSignal >& signal) = 0;
};

class TimingInformationChangedCallbackIF {
public:
    virtual ~TimingInformationChangedCallbackIF() {}

    virtual void onTimingInformationChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< TimingInformationChangedError >& error) = 0;

    virtual void onTimingInformationChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< TimingInformationChangedSignal >& signal) = 0;
};

class VolumeChangedCallbackIF {
public:
    virtual ~VolumeChangedCallbackIF() {}

    virtual void onVolumeChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< VolumeChangedError >& error) = 0;

    virtual void onVolumeChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< VolumeChangedSignal >& signal) = 0;
};


/**
 * CommandInterfaceProxy is the client side representation of the D-Bus
 * service interface 'org.genivi.audiomanager.CommandInterface' (specified
 * in file CommandInterfaceIntrospectionData.xml).
 *
 * structure describing sink class
 * Param 1: Type - u16int_t : Sink Class ID
 * Param 2: Type - string : Sink class Name
 * Param 3: Type - list of am_ClassProperty_s : list of class properties
 */
class CommandInterfaceProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of CommandInterfaceProxy.
     */
    static ::boost::shared_ptr< CommandInterfaceProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of CommandInterfaceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< CommandInterfaceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of CommandInterfaceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< CommandInterfaceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< CommandInterfaceProxy > proxyNew(new CommandInterfaceProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~CommandInterfaceProxy ();


    // Signal 'NumberOfMainConnectionsChanged'

    /**
     * Notify on the signal 'NumberOfMainConnectionsChanged'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'NumberOfMainConnectionsChanged'</b>:
     *
     * Signal to indicate change in the number of main connections
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNumberOfMainConnectionsChangedRegister(NumberOfMainConnectionsChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'NumberOfMainConnectionsChanged'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'NumberOfMainConnectionsChanged'</b>:
     *
     * Signal to indicate change in the number of main connections
     *
     * @param act The act which was previously returned by the
     * sendNumberOfMainConnectionsChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNumberOfMainConnectionsChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'NumberOfMainConnectionsChanged'.
     */
    void sendNumberOfMainConnectionsChangedDeregisterAll () const;

    // Signal 'SinkAdded'

    /**
     * Notify on the signal 'SinkAdded'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'SinkAdded'</b>:
     *
     * New Sink type added. Refer am_SinkType_s
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSinkAddedRegister(SinkAddedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SinkAdded'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SinkAdded'</b>:
     *
     * New Sink type added. Refer am_SinkType_s
     *
     * @param act The act which was previously returned by the
     * sendSinkAddedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSinkAddedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SinkAdded'.
     */
    void sendSinkAddedDeregisterAll () const;

    // Signal 'SinkRemoved'

    /**
     * Notify on the signal 'SinkRemoved'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'SinkRemoved'</b>:
     *
     * Sink ID of the removed sink
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSinkRemovedRegister(SinkRemovedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SinkRemoved'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SinkRemoved'</b>:
     *
     * Sink ID of the removed sink
     *
     * @param act The act which was previously returned by the
     * sendSinkRemovedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSinkRemovedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SinkRemoved'.
     */
    void sendSinkRemovedDeregisterAll () const;

    // Signal 'SourceAdded'

    /**
     * Notify on the signal 'SourceAdded'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'SourceAdded'</b>:
     *
     * New Source type added. Refer am_SourceType_s
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSourceAddedRegister(SourceAddedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SourceAdded'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SourceAdded'</b>:
     *
     * New Source type added. Refer am_SourceType_s
     *
     * @param act The act which was previously returned by the
     * sendSourceAddedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSourceAddedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SourceAdded'.
     */
    void sendSourceAddedDeregisterAll () const;

    // Signal 'SourceRemoved'

    /**
     * Notify on the signal 'SourceRemoved'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'SourceRemoved'</b>:
     *
     * ID of the removed source
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSourceRemovedRegister(SourceRemovedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SourceRemoved'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SourceRemoved'</b>:
     *
     * ID of the removed source
     *
     * @param act The act which was previously returned by the
     * sendSourceRemovedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSourceRemovedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SourceRemoved'.
     */
    void sendSourceRemovedDeregisterAll () const;

    // Signal 'NumberOfSinkClassesChanged'

    /**
     * Notify on the signal 'NumberOfSinkClassesChanged'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'NumberOfSinkClassesChanged'</b>:
     *
     * Signal to indicate that Number of Sink Classes is changed
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNumberOfSinkClassesChangedRegister(NumberOfSinkClassesChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'NumberOfSinkClassesChanged'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'NumberOfSinkClassesChanged'</b>:
     *
     * Signal to indicate that Number of Sink Classes is changed
     *
     * @param act The act which was previously returned by the
     * sendNumberOfSinkClassesChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNumberOfSinkClassesChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'NumberOfSinkClassesChanged'.
     */
    void sendNumberOfSinkClassesChangedDeregisterAll () const;

    // Signal 'NumberOfSourceClassesChanged'

    /**
     * Notify on the signal 'NumberOfSourceClassesChanged'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'NumberOfSourceClassesChanged'</b>:
     *
     * Signal to indicate Number of Source Classes is changed
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNumberOfSourceClassesChangedRegister(NumberOfSourceClassesChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'NumberOfSourceClassesChanged'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'NumberOfSourceClassesChanged'</b>:
     *
     * Signal to indicate Number of Source Classes is changed
     *
     * @param act The act which was previously returned by the
     * sendNumberOfSourceClassesChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNumberOfSourceClassesChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'NumberOfSourceClassesChanged'.
     */
    void sendNumberOfSourceClassesChangedDeregisterAll () const;

    // Signal 'MainConnectionStateChanged'

    /**
     * Notify on the signal 'MainConnectionStateChanged'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'MainConnectionStateChanged'</b>:
     *
     * Current Connection State. Refer am_ConnectionState_e
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMainConnectionStateChangedRegister(MainConnectionStateChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'MainConnectionStateChanged'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'MainConnectionStateChanged'</b>:
     *
     * Current Connection State. Refer am_ConnectionState_e
     *
     * @param act The act which was previously returned by the
     * sendMainConnectionStateChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendMainConnectionStateChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'MainConnectionStateChanged'.
     */
    void sendMainConnectionStateChangedDeregisterAll () const;

    // Signal 'MainSinkSoundPropertyChanged'

    /**
     * Notify on the signal 'MainSinkSoundPropertyChanged'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'MainSinkSoundPropertyChanged'</b>:
     *
     * Sound Property Changed. Refer am_MainSoundProperty_s
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMainSinkSoundPropertyChangedRegister(MainSinkSoundPropertyChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'MainSinkSoundPropertyChanged'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'MainSinkSoundPropertyChanged'</b>:
     *
     * Sound Property Changed. Refer am_MainSoundProperty_s
     *
     * @param act The act which was previously returned by the
     * sendMainSinkSoundPropertyChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendMainSinkSoundPropertyChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'MainSinkSoundPropertyChanged'.
     */
    void sendMainSinkSoundPropertyChangedDeregisterAll () const;

    // Signal 'MainSourceSoundPropertyChanged'

    /**
     * Notify on the signal 'MainSourceSoundPropertyChanged'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'MainSourceSoundPropertyChanged'</b>:
     *
     * Sound Property Changed. Refer am_MainSoundProperty_s
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMainSourceSoundPropertyChangedRegister(MainSourceSoundPropertyChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'MainSourceSoundPropertyChanged'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'MainSourceSoundPropertyChanged'</b>:
     *
     * Sound Property Changed. Refer am_MainSoundProperty_s
     *
     * @param act The act which was previously returned by the
     * sendMainSourceSoundPropertyChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendMainSourceSoundPropertyChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'MainSourceSoundPropertyChanged'.
     */
    void sendMainSourceSoundPropertyChangedDeregisterAll () const;

    // Signal 'SinkAvailabilityChanged'

    /**
     * Notify on the signal 'SinkAvailabilityChanged'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'SinkAvailabilityChanged'</b>:
     *
     * Current availability. Refer am_Availability_s
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSinkAvailabilityChangedRegister(SinkAvailabilityChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SinkAvailabilityChanged'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SinkAvailabilityChanged'</b>:
     *
     * Current availability. Refer am_Availability_s
     *
     * @param act The act which was previously returned by the
     * sendSinkAvailabilityChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSinkAvailabilityChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SinkAvailabilityChanged'.
     */
    void sendSinkAvailabilityChangedDeregisterAll () const;

    // Signal 'SourceAvailabilityChanged'

    /**
     * Notify on the signal 'SourceAvailabilityChanged'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'SourceAvailabilityChanged'</b>:
     *
     * current availability. Refer am_Availability_s
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSourceAvailabilityChangedRegister(SourceAvailabilityChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SourceAvailabilityChanged'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SourceAvailabilityChanged'</b>:
     *
     * current availability. Refer am_Availability_s
     *
     * @param act The act which was previously returned by the
     * sendSourceAvailabilityChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSourceAvailabilityChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'SourceAvailabilityChanged'.
     */
    void sendSourceAvailabilityChangedDeregisterAll () const;

    // Signal 'VolumeChanged'

    /**
     * Notify on the signal 'VolumeChanged'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'VolumeChanged'</b>:
     *
     * Current volume
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVolumeChangedRegister(VolumeChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'VolumeChanged'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'VolumeChanged'</b>:
     *
     * Current volume
     *
     * @param act The act which was previously returned by the
     * sendVolumeChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendVolumeChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'VolumeChanged'.
     */
    void sendVolumeChangedDeregisterAll () const;

    // Signal 'SinkMuteStateChanged'

    /**
     * Notify on the signal 'SinkMuteStateChanged'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'SinkMuteStateChanged'</b>:
     *
     * Current Mute state. Refer am_MuteState_e
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSinkMuteStateChangedRegister(SinkMuteStateChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SinkMuteStateChanged'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SinkMuteStateChanged'</b>:
     *
     * Current Mute state. Refer am_MuteState_e
     *
     * @param act The act which was previously returned by the
     * sendSinkMuteStateChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSinkMuteStateChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SinkMuteStateChanged'.
     */
    void sendSinkMuteStateChangedDeregisterAll () const;

    // Signal 'SystemPropertyChanged'

    /**
     * Notify on the signal 'SystemPropertyChanged'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'SystemPropertyChanged'</b>:
     *
     * Changed System property. Refer am_SystemProperty_s
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSystemPropertyChangedRegister(SystemPropertyChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SystemPropertyChanged'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SystemPropertyChanged'</b>:
     *
     * Changed System property. Refer am_SystemProperty_s
     *
     * @param act The act which was previously returned by the
     * sendSystemPropertyChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSystemPropertyChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SystemPropertyChanged'.
     */
    void sendSystemPropertyChangedDeregisterAll () const;

    // Signal 'TimingInformationChanged'

    /**
     * Notify on the signal 'TimingInformationChanged'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'TimingInformationChanged'</b>:
     *
     * changed time (delay) in milli seconds
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTimingInformationChangedRegister(TimingInformationChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'TimingInformationChanged'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'TimingInformationChanged'</b>:
     *
     * changed time (delay) in milli seconds
     *
     * @param act The act which was previously returned by the
     * sendTimingInformationChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendTimingInformationChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'TimingInformationChanged'.
     */
    void sendTimingInformationChangedDeregisterAll () const;



    // Method 'Connect'

    /**
     * Call the method 'Connect'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Connect'</b>:
     *
     * In case of successful connection, audio manager issues a connection ID for the current connection made
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param sourceID If the meaning of "sourceID" isn't clear, then there should be a description here.
     *
     * @param sinkID If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectRequest(ConnectCallbackIF& cb, uint16 sourceID, uint16 sinkID) const;

    // Method 'Disconnect'

    /**
     * Call the method 'Disconnect'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param mainConnectionID If the meaning of "mainConnectionID" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDisconnectRequest(DisconnectCallbackIF& cb, uint16 mainConnectionID) const;

    // Method 'SetVolume'

    /**
     * Call the method 'SetVolume'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'SetVolume'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param sinkID If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @param Mode If the meaning of "Mode" isn't clear, then there should be a description here.
     *
     * @param value If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetVolumeRequest(SetVolumeCallbackIF& cb, uint16 sinkID, uint16 mode, int16 value) const;

    // Method 'SetSinkMuteState'

    /**
     * Call the method 'SetSinkMuteState'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'SetSinkMuteState'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param sinkID If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @param muteState If the meaning of "muteState" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetSinkMuteStateRequest(SetSinkMuteStateCallbackIF& cb, uint16 sinkID, int16 muteState) const;

    // Method 'SetMainSinkSoundProperty'

    /**
     * Call the method 'SetMainSinkSoundProperty'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'SetMainSinkSoundProperty'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param sinkID If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @param soundProperty If the meaning of "soundProperty" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetMainSinkSoundPropertyRequest(SetMainSinkSoundPropertyCallbackIF& cb, uint16 sinkID, const SetMainSinkSoundPropertyRequestSoundPropertyStruct& soundProperty) const;

    // Method 'SetMainSourceSoundProperty'

    /**
     * Call the method 'SetMainSourceSoundProperty'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'SetMainSourceSoundProperty'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param sourceID If the meaning of "sourceID" isn't clear, then there should be a description here.
     *
     * @param soundProperty If the meaning of "soundProperty" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetMainSourceSoundPropertyRequest(SetMainSourceSoundPropertyCallbackIF& cb, uint16 sourceID, const SetMainSourceSoundPropertyRequestSoundPropertyStruct& soundProperty) const;

    // Method 'SetSystemProperty'

    /**
     * Call the method 'SetSystemProperty'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'SetSystemProperty'</b>:
     *
     * Result of operation. Refer list of error codes.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param property If the meaning of "property" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetSystemPropertyRequest(SetSystemPropertyCallbackIF& cb, const SetSystemPropertyRequestPropertyStruct& property) const;

    // Method 'GetListMainConnections'

    /**
     * Call the method 'GetListMainConnections'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'GetListMainConnections'</b>:
     *
     * list of main connections. Refer to am_MainConnectionType_s
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetListMainConnectionsRequest(GetListMainConnectionsCallbackIF& cb) const;

    // Method 'GetListMainSinks'

    /**
     * Call the method 'GetListMainSinks'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetListMainSinks'</b>:
     *
     * List of actual sinks. Refer to am_SinkType_s
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetListMainSinksRequest(GetListMainSinksCallbackIF& cb) const;

    // Method 'GetListMainSources'

    /**
     * Call the method 'GetListMainSources'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'GetListMainSources'</b>:
     *
     * List of actual sources. Refer to am_SourceType_s
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetListMainSourcesRequest(GetListMainSourcesCallbackIF& cb) const;

    // Method 'GetListMainSinkSoundProperties'

    /**
     * Call the method 'GetListMainSinkSoundProperties'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'GetListMainSinkSoundProperties'</b>:
     *
     * List of sound properties. Refer to am_MainSoundProperty_s
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param sinkID If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetListMainSinkSoundPropertiesRequest(GetListMainSinkSoundPropertiesCallbackIF& cb, uint16 sinkID) const;

    // Method 'GetListMainSourceSoundProperties'

    /**
     * Call the method 'GetListMainSourceSoundProperties'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'GetListMainSourceSoundProperties'</b>:
     *
     * List of sound properties. Refer to am_MainSoundProperty_s
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param sourceID If the meaning of "sourceID" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetListMainSourceSoundPropertiesRequest(GetListMainSourceSoundPropertiesCallbackIF& cb, uint16 sourceID) const;

    // Method 'GetListSourceClasses'

    /**
     * Call the method 'GetListSourceClasses'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'GetListSourceClasses'</b>:
     *
     * List of source classes. Refer am_SourceClass_s
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetListSourceClassesRequest(GetListSourceClassesCallbackIF& cb) const;

    // Method 'GetListSinkClasses'

    /**
     * Call the method 'GetListSinkClasses'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'GetListSinkClasses'</b>:
     *
     * List of Sink Classes. Refer am_SinkClass_s
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetListSinkClassesRequest(GetListSinkClassesCallbackIF& cb) const;

    // Method 'GetListSystemProperties'

    /**
     * Call the method 'GetListSystemProperties'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'GetListSystemProperties'</b>:
     *
     * List of System Properties. Refer am_SystemProperty_s
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param listSystemProperties If the meaning of "listSystemProperties" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetListSystemPropertiesRequest(GetListSystemPropertiesCallbackIF& cb, const ::std::vector< GetListSystemPropertiesRequestListSystemPropertiesStruct >& listSystemProperties) const;

    // Method 'GetTimingInformation'

    /**
     * Call the method 'GetTimingInformation'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'GetTimingInformation'</b>:
     *
     * Delay in Milliseconds
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param mainConnectionID If the meaning of "mainConnectionID" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetTimingInformationRequest(GetTimingInformationCallbackIF& cb, uint16 mainConnectionID) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    CommandInterfaceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class CommandInterfaceProxyCallback;
};

} // namespace CommandInterface
} // namespace audiomanager
} // namespace genivi
} // namespace org

#endif // ORG_GENIVI_AUDIOMANAGER_COMMANDINTERFACEPROXY_H
