/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "org/genivi/audiomanager/CommandInterface.h"
#include "org/genivi/audiomanager/CommandInterfaceDBus.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of ConnectRequest

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::ConnectRequest& in, DBusMessageIter* out) {
    uint16 o0 = in.getSourceID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o0));
    uint16 o1 = in.getSinkID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o1));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::ConnectRequest& out) {
    {
        uint16 sourceIDValue;
        uint16 &sourceIDTmpValue = sourceIDValue;
        dbus_message_iter_get_basic(in, &sourceIDTmpValue);
        out.setSourceID(sourceIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 sinkIDValue;
        uint16 &sinkIDTmpValue = sinkIDValue;
        dbus_message_iter_get_basic(in, &sinkIDTmpValue);
        out.setSinkID(sinkIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ConnectResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::ConnectResponse& in, DBusMessageIter* out) {
    int16 o2 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o2));
    uint16 o3 = in.getMainConnectionID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o3));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::ConnectResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 mainConnectionIDValue;
        uint16 &mainConnectionIDTmpValue = mainConnectionIDValue;
        dbus_message_iter_get_basic(in, &mainConnectionIDTmpValue);
        out.setMainConnectionID(mainConnectionIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DisconnectRequest

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::DisconnectRequest& in, DBusMessageIter* out) {
    uint16 o4 = in.getMainConnectionID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o4));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::DisconnectRequest& out) {
    {
        uint16 mainConnectionIDValue;
        uint16 &mainConnectionIDTmpValue = mainConnectionIDValue;
        dbus_message_iter_get_basic(in, &mainConnectionIDTmpValue);
        out.setMainConnectionID(mainConnectionIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DisconnectResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::DisconnectResponse& in, DBusMessageIter* out) {
    int16 o5 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o5));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::DisconnectResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetVolumeRequest

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetVolumeRequest& in, DBusMessageIter* out) {
    uint16 o6 = in.getSinkID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o6));
    uint16 o7 = in.getMode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o7));
    int16 o8 = in.getValue();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o8));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetVolumeRequest& out) {
    {
        uint16 sinkIDValue;
        uint16 &sinkIDTmpValue = sinkIDValue;
        dbus_message_iter_get_basic(in, &sinkIDTmpValue);
        out.setSinkID(sinkIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 ModeValue;
        uint16 &ModeTmpValue = ModeValue;
        dbus_message_iter_get_basic(in, &ModeTmpValue);
        out.setMode(ModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 valueValue;
        int16 &valueTmpValue = valueValue;
        dbus_message_iter_get_basic(in, &valueTmpValue);
        out.setValue(valueValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetVolumeResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetVolumeResponse& in, DBusMessageIter* out) {
    int16 o9 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o9));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetVolumeResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetSinkMuteStateRequest

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetSinkMuteStateRequest& in, DBusMessageIter* out) {
    uint16 o10 = in.getSinkID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o10));
    int16 o11 = in.getMuteState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o11));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetSinkMuteStateRequest& out) {
    {
        uint16 sinkIDValue;
        uint16 &sinkIDTmpValue = sinkIDValue;
        dbus_message_iter_get_basic(in, &sinkIDTmpValue);
        out.setSinkID(sinkIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 muteStateValue;
        int16 &muteStateTmpValue = muteStateValue;
        dbus_message_iter_get_basic(in, &muteStateTmpValue);
        out.setMuteState(muteStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetSinkMuteStateResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetSinkMuteStateResponse& in, DBusMessageIter* out) {
    int16 o12 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o12));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetSinkMuteStateResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetMainSinkSoundPropertyRequest

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetMainSinkSoundPropertyRequest& in, DBusMessageIter* out) {
    uint16 o13 = in.getSinkID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o13));
    {
        DBusMessageIter o14Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o14Struct));
        serializeDBus(in.getSoundProperty(), &o14Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o14Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetMainSinkSoundPropertyRequest& out) {
    {
        uint16 sinkIDValue;
        uint16 &sinkIDTmpValue = sinkIDValue;
        dbus_message_iter_get_basic(in, &sinkIDTmpValue);
        out.setSinkID(sinkIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::genivi::audiomanager::CommandInterface::SetMainSinkSoundPropertyRequestSoundPropertyStruct soundPropertyValue;
        {
            DBusMessageIter o15;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o15);

                    if (!deserializeDBus(&o15, soundPropertyValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setSoundProperty(soundPropertyValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetMainSinkSoundPropertyResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetMainSinkSoundPropertyResponse& in, DBusMessageIter* out) {
    int16 o16 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o16));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetMainSinkSoundPropertyResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetMainSourceSoundPropertyRequest

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetMainSourceSoundPropertyRequest& in, DBusMessageIter* out) {
    uint16 o17 = in.getSourceID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o17));
    {
        DBusMessageIter o18Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o18Struct));
        serializeDBus(in.getSoundProperty(), &o18Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o18Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetMainSourceSoundPropertyRequest& out) {
    {
        uint16 sourceIDValue;
        uint16 &sourceIDTmpValue = sourceIDValue;
        dbus_message_iter_get_basic(in, &sourceIDTmpValue);
        out.setSourceID(sourceIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::genivi::audiomanager::CommandInterface::SetMainSourceSoundPropertyRequestSoundPropertyStruct soundPropertyValue;
        {
            DBusMessageIter o19;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o19);

                    if (!deserializeDBus(&o19, soundPropertyValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setSoundProperty(soundPropertyValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetMainSourceSoundPropertyResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetMainSourceSoundPropertyResponse& in, DBusMessageIter* out) {
    int16 o20 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o20));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetMainSourceSoundPropertyResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetSystemPropertyRequest

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetSystemPropertyRequest& in, DBusMessageIter* out) {
    {
        DBusMessageIter o21Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o21Struct));
        serializeDBus(in.getProperty(), &o21Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o21Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetSystemPropertyRequest& out) {
    {
        ::org::genivi::audiomanager::CommandInterface::SetSystemPropertyRequestPropertyStruct propertyValue;
        {
            DBusMessageIter o22;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o22);

                    if (!deserializeDBus(&o22, propertyValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setProperty(propertyValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetSystemPropertyResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetSystemPropertyResponse& in, DBusMessageIter* out) {
    int16 o23 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o23));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetSystemPropertyResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainConnectionsResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainConnectionsResponse& in, DBusMessageIter* out) {
    int16 o24 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o24));
    DBusMessageIter o25ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(qqqnn)", &o25ArrayIter));
    const ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainConnectionsResponseListConnectionsStruct >* o26 = &in.getListConnections();
    ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainConnectionsResponseListConnectionsStruct >::const_iterator o27 = o26->end();
    for (::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainConnectionsResponseListConnectionsStruct >::const_iterator o28 = o26->begin(); o28 != o27; ++o28) {
        {
            DBusMessageIter o29Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o25ArrayIter, DBUS_TYPE_STRUCT, 0, &o29Struct));
            serializeDBus((*o28), &o29Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o25ArrayIter, &o29Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o25ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainConnectionsResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainConnectionsResponseListConnectionsStruct > listConnectionsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o30ArrayIter;
            dbus_message_iter_recurse (in, &o30ArrayIter);

            if(dbus_message_iter_get_arg_type(&o30ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::genivi::audiomanager::CommandInterface::GetListMainConnectionsResponseListConnectionsStruct o31;
                    {
                        DBusMessageIter o32;
                        char* signature = dbus_message_iter_get_signature(&o30ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o30ArrayIter)) {
                                dbus_message_iter_recurse (&o30ArrayIter, &o32);

                                if (!deserializeDBus(&o32, o31)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    listConnectionsValue.push_back(o31);
                } while (dbus_message_iter_next(&o30ArrayIter));
            }
        }
        out.setListConnections(listConnectionsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSinksResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponse& in, DBusMessageIter* out) {
    int16 o33 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o33));
    DBusMessageIter o34ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(qs(nn)nnq)", &o34ArrayIter));
    const ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponseListMainSinksStruct >* o35 = &in.getListMainSinks();
    ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponseListMainSinksStruct >::const_iterator o36 = o35->end();
    for (::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponseListMainSinksStruct >::const_iterator o37 = o35->begin(); o37 != o36; ++o37) {
        {
            DBusMessageIter o38Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o34ArrayIter, DBUS_TYPE_STRUCT, 0, &o38Struct));
            serializeDBus((*o37), &o38Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o34ArrayIter, &o38Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o34ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponseListMainSinksStruct > listMainSinksValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o39ArrayIter;
            dbus_message_iter_recurse (in, &o39ArrayIter);

            if(dbus_message_iter_get_arg_type(&o39ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponseListMainSinksStruct o40;
                    {
                        DBusMessageIter o41;
                        char* signature = dbus_message_iter_get_signature(&o39ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o39ArrayIter)) {
                                dbus_message_iter_recurse (&o39ArrayIter, &o41);

                                if (!deserializeDBus(&o41, o40)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    listMainSinksValue.push_back(o40);
                } while (dbus_message_iter_next(&o39ArrayIter));
            }
        }
        out.setListMainSinks(listMainSinksValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSourcesResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponse& in, DBusMessageIter* out) {
    int16 o42 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o42));
    DBusMessageIter o43ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(qs(nn)q)", &o43ArrayIter));
    const ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponseListMainSourcesStruct >* o44 = &in.getListMainSources();
    ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponseListMainSourcesStruct >::const_iterator o45 = o44->end();
    for (::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponseListMainSourcesStruct >::const_iterator o46 = o44->begin(); o46 != o45; ++o46) {
        {
            DBusMessageIter o47Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o43ArrayIter, DBUS_TYPE_STRUCT, 0, &o47Struct));
            serializeDBus((*o46), &o47Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o43ArrayIter, &o47Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o43ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponseListMainSourcesStruct > listMainSourcesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o48ArrayIter;
            dbus_message_iter_recurse (in, &o48ArrayIter);

            if(dbus_message_iter_get_arg_type(&o48ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponseListMainSourcesStruct o49;
                    {
                        DBusMessageIter o50;
                        char* signature = dbus_message_iter_get_signature(&o48ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o48ArrayIter)) {
                                dbus_message_iter_recurse (&o48ArrayIter, &o50);

                                if (!deserializeDBus(&o50, o49)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    listMainSourcesValue.push_back(o49);
                } while (dbus_message_iter_next(&o48ArrayIter));
            }
        }
        out.setListMainSources(listMainSourcesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSinkSoundPropertiesRequest

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesRequest& in, DBusMessageIter* out) {
    uint16 o51 = in.getSinkID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o51));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesRequest& out) {
    {
        uint16 sinkIDValue;
        uint16 &sinkIDTmpValue = sinkIDValue;
        dbus_message_iter_get_basic(in, &sinkIDTmpValue);
        out.setSinkID(sinkIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSinkSoundPropertiesResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesResponse& in, DBusMessageIter* out) {
    int16 o52 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o52));
    DBusMessageIter o53ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(nn)", &o53ArrayIter));
    const ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct >* o54 = &in.getListSoundProperties();
    ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct >::const_iterator o55 = o54->end();
    for (::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct >::const_iterator o56 = o54->begin(); o56 != o55; ++o56) {
        {
            DBusMessageIter o57Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o53ArrayIter, DBUS_TYPE_STRUCT, 0, &o57Struct));
            serializeDBus((*o56), &o57Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o53ArrayIter, &o57Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o53ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct > listSoundPropertiesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o58ArrayIter;
            dbus_message_iter_recurse (in, &o58ArrayIter);

            if(dbus_message_iter_get_arg_type(&o58ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct o59;
                    {
                        DBusMessageIter o60;
                        char* signature = dbus_message_iter_get_signature(&o58ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o58ArrayIter)) {
                                dbus_message_iter_recurse (&o58ArrayIter, &o60);

                                if (!deserializeDBus(&o60, o59)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    listSoundPropertiesValue.push_back(o59);
                } while (dbus_message_iter_next(&o58ArrayIter));
            }
        }
        out.setListSoundProperties(listSoundPropertiesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSourceSoundPropertiesRequest

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesRequest& in, DBusMessageIter* out) {
    uint16 o61 = in.getSourceID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o61));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesRequest& out) {
    {
        uint16 sourceIDValue;
        uint16 &sourceIDTmpValue = sourceIDValue;
        dbus_message_iter_get_basic(in, &sourceIDTmpValue);
        out.setSourceID(sourceIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSourceSoundPropertiesResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesResponse& in, DBusMessageIter* out) {
    int16 o62 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o62));
    DBusMessageIter o63ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(nn)", &o63ArrayIter));
    const ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct >* o64 = &in.getListSourceProperties();
    ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct >::const_iterator o65 = o64->end();
    for (::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct >::const_iterator o66 = o64->begin(); o66 != o65; ++o66) {
        {
            DBusMessageIter o67Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o63ArrayIter, DBUS_TYPE_STRUCT, 0, &o67Struct));
            serializeDBus((*o66), &o67Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o63ArrayIter, &o67Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o63ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct > listSourcePropertiesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o68ArrayIter;
            dbus_message_iter_recurse (in, &o68ArrayIter);

            if(dbus_message_iter_get_arg_type(&o68ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct o69;
                    {
                        DBusMessageIter o70;
                        char* signature = dbus_message_iter_get_signature(&o68ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o68ArrayIter)) {
                                dbus_message_iter_recurse (&o68ArrayIter, &o70);

                                if (!deserializeDBus(&o70, o69)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    listSourcePropertiesValue.push_back(o69);
                } while (dbus_message_iter_next(&o68ArrayIter));
            }
        }
        out.setListSourceProperties(listSourcePropertiesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListSourceClassesResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponse& in, DBusMessageIter* out) {
    int16 o71 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o71));
    DBusMessageIter o72ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(qsa(nn))", &o72ArrayIter));
    const ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesStruct >* o73 = &in.getListSourceClasses();
    ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesStruct >::const_iterator o74 = o73->end();
    for (::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesStruct >::const_iterator o75 = o73->begin(); o75 != o74; ++o75) {
        {
            DBusMessageIter o76Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o72ArrayIter, DBUS_TYPE_STRUCT, 0, &o76Struct));
            serializeDBus((*o75), &o76Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o72ArrayIter, &o76Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o72ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesStruct > listSourceClassesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o77ArrayIter;
            dbus_message_iter_recurse (in, &o77ArrayIter);

            if(dbus_message_iter_get_arg_type(&o77ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesStruct o78;
                    {
                        DBusMessageIter o79;
                        char* signature = dbus_message_iter_get_signature(&o77ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o77ArrayIter)) {
                                dbus_message_iter_recurse (&o77ArrayIter, &o79);

                                if (!deserializeDBus(&o79, o78)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    listSourceClassesValue.push_back(o78);
                } while (dbus_message_iter_next(&o77ArrayIter));
            }
        }
        out.setListSourceClasses(listSourceClassesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListSinkClassesResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponse& in, DBusMessageIter* out) {
    int16 o80 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o80));
    DBusMessageIter o81ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(qsa(nn))", &o81ArrayIter));
    const ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesStruct >* o82 = &in.getListSinkClasses();
    ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesStruct >::const_iterator o83 = o82->end();
    for (::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesStruct >::const_iterator o84 = o82->begin(); o84 != o83; ++o84) {
        {
            DBusMessageIter o85Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o81ArrayIter, DBUS_TYPE_STRUCT, 0, &o85Struct));
            serializeDBus((*o84), &o85Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o81ArrayIter, &o85Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o81ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesStruct > listSinkClassesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o86ArrayIter;
            dbus_message_iter_recurse (in, &o86ArrayIter);

            if(dbus_message_iter_get_arg_type(&o86ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesStruct o87;
                    {
                        DBusMessageIter o88;
                        char* signature = dbus_message_iter_get_signature(&o86ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o86ArrayIter)) {
                                dbus_message_iter_recurse (&o86ArrayIter, &o88);

                                if (!deserializeDBus(&o88, o87)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    listSinkClassesValue.push_back(o87);
                } while (dbus_message_iter_next(&o86ArrayIter));
            }
        }
        out.setListSinkClasses(listSinkClassesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListSystemPropertiesRequest

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesRequest& in, DBusMessageIter* out) {
    DBusMessageIter o89ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(nn)", &o89ArrayIter));
    const ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesRequestListSystemPropertiesStruct >* o90 = &in.getListSystemProperties();
    ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesRequestListSystemPropertiesStruct >::const_iterator o91 = o90->end();
    for (::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesRequestListSystemPropertiesStruct >::const_iterator o92 = o90->begin(); o92 != o91; ++o92) {
        {
            DBusMessageIter o93Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o89ArrayIter, DBUS_TYPE_STRUCT, 0, &o93Struct));
            serializeDBus((*o92), &o93Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o89ArrayIter, &o93Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o89ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesRequest& out) {
    {
        ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesRequestListSystemPropertiesStruct > listSystemPropertiesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o94ArrayIter;
            dbus_message_iter_recurse (in, &o94ArrayIter);

            if(dbus_message_iter_get_arg_type(&o94ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesRequestListSystemPropertiesStruct o95;
                    {
                        DBusMessageIter o96;
                        char* signature = dbus_message_iter_get_signature(&o94ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o94ArrayIter)) {
                                dbus_message_iter_recurse (&o94ArrayIter, &o96);

                                if (!deserializeDBus(&o96, o95)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    listSystemPropertiesValue.push_back(o95);
                } while (dbus_message_iter_next(&o94ArrayIter));
            }
        }
        out.setListSystemProperties(listSystemPropertiesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListSystemPropertiesResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesResponse& in, DBusMessageIter* out) {
    int16 o97 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o97));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetTimingInformationRequest

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetTimingInformationRequest& in, DBusMessageIter* out) {
    uint16 o98 = in.getMainConnectionID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o98));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetTimingInformationRequest& out) {
    {
        uint16 mainConnectionIDValue;
        uint16 &mainConnectionIDTmpValue = mainConnectionIDValue;
        dbus_message_iter_get_basic(in, &mainConnectionIDTmpValue);
        out.setMainConnectionID(mainConnectionIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetTimingInformationResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetTimingInformationResponse& in, DBusMessageIter* out) {
    int16 o99 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o99));
    int16 o100 = in.getDelay();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o100));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetTimingInformationResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 delayValue;
        int16 &delayTmpValue = delayValue;
        dbus_message_iter_get_basic(in, &delayTmpValue);
        out.setDelay(delayValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SinkAddedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SinkAddedSignal& in, DBusMessageIter* out) {
    {
        DBusMessageIter o101Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o101Struct));
        serializeDBus(in.getNewSink(), &o101Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o101Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SinkAddedSignal& out) {
    {
        ::org::genivi::audiomanager::CommandInterface::SinkAddedSignalNewSinkStruct newSinkValue;
        {
            DBusMessageIter o102;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o102);

                    if (!deserializeDBus(&o102, newSinkValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setNewSink(newSinkValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SinkRemovedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SinkRemovedSignal& in, DBusMessageIter* out) {
    uint16 o103 = in.getRemovedSinkID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o103));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SinkRemovedSignal& out) {
    {
        uint16 removedSinkIDValue;
        uint16 &removedSinkIDTmpValue = removedSinkIDValue;
        dbus_message_iter_get_basic(in, &removedSinkIDTmpValue);
        out.setRemovedSinkID(removedSinkIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SourceAddedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SourceAddedSignal& in, DBusMessageIter* out) {
    {
        DBusMessageIter o104Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o104Struct));
        serializeDBus(in.getNewSource(), &o104Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o104Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SourceAddedSignal& out) {
    {
        ::org::genivi::audiomanager::CommandInterface::SourceAddedSignalNewSourceStruct newSourceValue;
        {
            DBusMessageIter o105;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o105);

                    if (!deserializeDBus(&o105, newSourceValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setNewSource(newSourceValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SourceRemovedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SourceRemovedSignal& in, DBusMessageIter* out) {
    uint16 o106 = in.getRemovedSourceID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o106));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SourceRemovedSignal& out) {
    {
        uint16 removedSourceIDValue;
        uint16 &removedSourceIDTmpValue = removedSourceIDValue;
        dbus_message_iter_get_basic(in, &removedSourceIDTmpValue);
        out.setRemovedSourceID(removedSourceIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MainConnectionStateChangedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::MainConnectionStateChangedSignal& in, DBusMessageIter* out) {
    uint16 o107 = in.getConnectionID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o107));
    int16 o108 = in.getConnectionState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o108));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::MainConnectionStateChangedSignal& out) {
    {
        uint16 connectionIDValue;
        uint16 &connectionIDTmpValue = connectionIDValue;
        dbus_message_iter_get_basic(in, &connectionIDTmpValue);
        out.setConnectionID(connectionIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 connectionStateValue;
        int16 &connectionStateTmpValue = connectionStateValue;
        dbus_message_iter_get_basic(in, &connectionStateTmpValue);
        out.setConnectionState(connectionStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MainSinkSoundPropertyChangedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::MainSinkSoundPropertyChangedSignal& in, DBusMessageIter* out) {
    uint16 o109 = in.getSinkID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o109));
    {
        DBusMessageIter o110Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o110Struct));
        serializeDBus(in.getSoundProperty(), &o110Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o110Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::MainSinkSoundPropertyChangedSignal& out) {
    {
        uint16 sinkIDValue;
        uint16 &sinkIDTmpValue = sinkIDValue;
        dbus_message_iter_get_basic(in, &sinkIDTmpValue);
        out.setSinkID(sinkIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::genivi::audiomanager::CommandInterface::MainSinkSoundPropertyChangedSignalSoundPropertyStruct SoundPropertyValue;
        {
            DBusMessageIter o111;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o111);

                    if (!deserializeDBus(&o111, SoundPropertyValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setSoundProperty(SoundPropertyValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MainSourceSoundPropertyChangedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::MainSourceSoundPropertyChangedSignal& in, DBusMessageIter* out) {
    uint16 o112 = in.getSourceID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o112));
    {
        DBusMessageIter o113Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o113Struct));
        serializeDBus(in.getSoundProperty(), &o113Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o113Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::MainSourceSoundPropertyChangedSignal& out) {
    {
        uint16 sourceIDValue;
        uint16 &sourceIDTmpValue = sourceIDValue;
        dbus_message_iter_get_basic(in, &sourceIDTmpValue);
        out.setSourceID(sourceIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::genivi::audiomanager::CommandInterface::MainSourceSoundPropertyChangedSignalSoundPropertyStruct SoundPropertyValue;
        {
            DBusMessageIter o114;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o114);

                    if (!deserializeDBus(&o114, SoundPropertyValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setSoundProperty(SoundPropertyValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SinkAvailabilityChangedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SinkAvailabilityChangedSignal& in, DBusMessageIter* out) {
    uint16 o115 = in.getSinkID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o115));
    {
        DBusMessageIter o116Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o116Struct));
        serializeDBus(in.getAvailability(), &o116Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o116Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SinkAvailabilityChangedSignal& out) {
    {
        uint16 sinkIDValue;
        uint16 &sinkIDTmpValue = sinkIDValue;
        dbus_message_iter_get_basic(in, &sinkIDTmpValue);
        out.setSinkID(sinkIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::genivi::audiomanager::CommandInterface::SinkAvailabilityChangedSignalAvailabilityStruct availabilityValue;
        {
            DBusMessageIter o117;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o117);

                    if (!deserializeDBus(&o117, availabilityValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setAvailability(availabilityValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SourceAvailabilityChangedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SourceAvailabilityChangedSignal& in, DBusMessageIter* out) {
    uint16 o118 = in.getSourceID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o118));
    {
        DBusMessageIter o119Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o119Struct));
        serializeDBus(in.getAvailability(), &o119Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o119Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SourceAvailabilityChangedSignal& out) {
    {
        uint16 sourceIDValue;
        uint16 &sourceIDTmpValue = sourceIDValue;
        dbus_message_iter_get_basic(in, &sourceIDTmpValue);
        out.setSourceID(sourceIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::genivi::audiomanager::CommandInterface::SourceAvailabilityChangedSignalAvailabilityStruct availabilityValue;
        {
            DBusMessageIter o120;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o120);

                    if (!deserializeDBus(&o120, availabilityValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setAvailability(availabilityValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of VolumeChangedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::VolumeChangedSignal& in, DBusMessageIter* out) {
    uint16 o121 = in.getSinkID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o121));
    int16 o122 = in.getVolume();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o122));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::VolumeChangedSignal& out) {
    {
        uint16 sinkIDValue;
        uint16 &sinkIDTmpValue = sinkIDValue;
        dbus_message_iter_get_basic(in, &sinkIDTmpValue);
        out.setSinkID(sinkIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 volumeValue;
        int16 &volumeTmpValue = volumeValue;
        dbus_message_iter_get_basic(in, &volumeTmpValue);
        out.setVolume(volumeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SinkMuteStateChangedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SinkMuteStateChangedSignal& in, DBusMessageIter* out) {
    uint16 o123 = in.getSinkID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o123));
    int16 o124 = in.getMuteState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o124));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SinkMuteStateChangedSignal& out) {
    {
        uint16 sinkIDValue;
        uint16 &sinkIDTmpValue = sinkIDValue;
        dbus_message_iter_get_basic(in, &sinkIDTmpValue);
        out.setSinkID(sinkIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 muteStateValue;
        int16 &muteStateTmpValue = muteStateValue;
        dbus_message_iter_get_basic(in, &muteStateTmpValue);
        out.setMuteState(muteStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SystemPropertyChangedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SystemPropertyChangedSignal& in, DBusMessageIter* out) {
    {
        DBusMessageIter o125Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o125Struct));
        serializeDBus(in.getSystemProperty(), &o125Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o125Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SystemPropertyChangedSignal& out) {
    {
        ::org::genivi::audiomanager::CommandInterface::SystemPropertyChangedSignalSystemPropertyStruct SystemPropertyValue;
        {
            DBusMessageIter o126;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o126);

                    if (!deserializeDBus(&o126, SystemPropertyValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setSystemProperty(SystemPropertyValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TimingInformationChangedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::TimingInformationChangedSignal& in, DBusMessageIter* out) {
    uint16 o127 = in.getMainConnection();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o127));
    int16 o128 = in.getTime();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o128));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::TimingInformationChangedSignal& out) {
    {
        uint16 mainConnectionValue;
        uint16 &mainConnectionTmpValue = mainConnectionValue;
        dbus_message_iter_get_basic(in, &mainConnectionTmpValue);
        out.setMainConnection(mainConnectionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 timeValue;
        int16 &timeTmpValue = timeValue;
        dbus_message_iter_get_basic(in, &timeTmpValue);
        out.setTime(timeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetMainSinkSoundPropertyRequestSoundPropertyStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetMainSinkSoundPropertyRequestSoundPropertyStruct& in, DBusMessageIter* out) {
    int16 o129 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o129));
    int16 o130 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o130));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetMainSinkSoundPropertyRequestSoundPropertyStruct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetMainSourceSoundPropertyRequestSoundPropertyStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetMainSourceSoundPropertyRequestSoundPropertyStruct& in, DBusMessageIter* out) {
    int16 o131 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o131));
    int16 o132 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o132));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetMainSourceSoundPropertyRequestSoundPropertyStruct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetSystemPropertyRequestPropertyStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetSystemPropertyRequestPropertyStruct& in, DBusMessageIter* out) {
    int16 o133 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o133));
    int16 o134 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o134));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetSystemPropertyRequestPropertyStruct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainConnectionsResponseListConnectionsStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainConnectionsResponseListConnectionsStruct& in, DBusMessageIter* out) {
    uint16 o135 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o135));
    uint16 o136 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o136));
    uint16 o137 = in.getElem3();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o137));
    int16 o138 = in.getElem4();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o138));
    int16 o139 = in.getElem5();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o139));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainConnectionsResponseListConnectionsStruct& out) {
    {
        uint16 elem1Value;
        uint16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 elem2Value;
        uint16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 elem3Value;
        uint16 &elem3TmpValue = elem3Value;
        dbus_message_iter_get_basic(in, &elem3TmpValue);
        out.setElem3(elem3Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem4Value;
        int16 &elem4TmpValue = elem4Value;
        dbus_message_iter_get_basic(in, &elem4TmpValue);
        out.setElem4(elem4Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem5Value;
        int16 &elem5TmpValue = elem5Value;
        dbus_message_iter_get_basic(in, &elem5TmpValue);
        out.setElem5(elem5Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSinksResponseListMainSinksElem3Struct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponseListMainSinksElem3Struct& in, DBusMessageIter* out) {
    int16 o140 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o140));
    int16 o141 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o141));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponseListMainSinksElem3Struct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSinksResponseListMainSinksStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponseListMainSinksStruct& in, DBusMessageIter* out) {
    uint16 o142 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o142));
    const char* o143 = in.getElem2().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o143));
    {
        DBusMessageIter o144Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o144Struct));
        serializeDBus(in.getElem3(), &o144Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o144Struct));
    }
    int16 o145 = in.getElem4();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o145));
    int16 o146 = in.getElem5();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o146));
    uint16 o147 = in.getElem6();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o147));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponseListMainSinksStruct& out) {
    {
        uint16 elem1Value;
        uint16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string elem2Value;
        ::std::string &elem2TmpValue = elem2Value;
        {
            char* o148 = 0;
            dbus_message_iter_get_basic(in, &o148);
            elem2TmpValue.assign (o148);
        }
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponseListMainSinksElem3Struct elem3Value;
        {
            DBusMessageIter o149;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o149);

                    if (!deserializeDBus(&o149, elem3Value)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setElem3(elem3Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem4Value;
        int16 &elem4TmpValue = elem4Value;
        dbus_message_iter_get_basic(in, &elem4TmpValue);
        out.setElem4(elem4Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem5Value;
        int16 &elem5TmpValue = elem5Value;
        dbus_message_iter_get_basic(in, &elem5TmpValue);
        out.setElem5(elem5Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 elem6Value;
        uint16 &elem6TmpValue = elem6Value;
        dbus_message_iter_get_basic(in, &elem6TmpValue);
        out.setElem6(elem6Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSourcesResponseListMainSourcesElem3Struct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponseListMainSourcesElem3Struct& in, DBusMessageIter* out) {
    int16 o150 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o150));
    int16 o151 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o151));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponseListMainSourcesElem3Struct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSourcesResponseListMainSourcesStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponseListMainSourcesStruct& in, DBusMessageIter* out) {
    uint16 o152 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o152));
    const char* o153 = in.getElem2().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o153));
    {
        DBusMessageIter o154Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o154Struct));
        serializeDBus(in.getElem3(), &o154Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o154Struct));
    }
    uint16 o155 = in.getElem4();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o155));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponseListMainSourcesStruct& out) {
    {
        uint16 elem1Value;
        uint16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string elem2Value;
        ::std::string &elem2TmpValue = elem2Value;
        {
            char* o156 = 0;
            dbus_message_iter_get_basic(in, &o156);
            elem2TmpValue.assign (o156);
        }
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponseListMainSourcesElem3Struct elem3Value;
        {
            DBusMessageIter o157;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o157);

                    if (!deserializeDBus(&o157, elem3Value)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setElem3(elem3Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 elem4Value;
        uint16 &elem4TmpValue = elem4Value;
        dbus_message_iter_get_basic(in, &elem4TmpValue);
        out.setElem4(elem4Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct& in, DBusMessageIter* out) {
    int16 o158 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o158));
    int16 o159 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o159));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct& in, DBusMessageIter* out) {
    int16 o160 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o160));
    int16 o161 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o161));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListSourceClassesResponseListSourceClassesElem3Struct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesElem3Struct& in, DBusMessageIter* out) {
    int16 o162 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o162));
    int16 o163 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o163));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesElem3Struct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListSourceClassesResponseListSourceClassesStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesStruct& in, DBusMessageIter* out) {
    uint16 o164 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o164));
    const char* o165 = in.getElem2().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o165));
    DBusMessageIter o166ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(nn)", &o166ArrayIter));
    const ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesElem3Struct >* o167 = &in.getElem3();
    ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesElem3Struct >::const_iterator o168 = o167->end();
    for (::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesElem3Struct >::const_iterator o169 = o167->begin(); o169 != o168; ++o169) {
        {
            DBusMessageIter o170Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o166ArrayIter, DBUS_TYPE_STRUCT, 0, &o170Struct));
            serializeDBus((*o169), &o170Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o166ArrayIter, &o170Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o166ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesStruct& out) {
    {
        uint16 elem1Value;
        uint16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string elem2Value;
        ::std::string &elem2TmpValue = elem2Value;
        {
            char* o171 = 0;
            dbus_message_iter_get_basic(in, &o171);
            elem2TmpValue.assign (o171);
        }
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesElem3Struct > elem3Value;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o172ArrayIter;
            dbus_message_iter_recurse (in, &o172ArrayIter);

            if(dbus_message_iter_get_arg_type(&o172ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesElem3Struct o173;
                    {
                        DBusMessageIter o174;
                        char* signature = dbus_message_iter_get_signature(&o172ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o172ArrayIter)) {
                                dbus_message_iter_recurse (&o172ArrayIter, &o174);

                                if (!deserializeDBus(&o174, o173)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    elem3Value.push_back(o173);
                } while (dbus_message_iter_next(&o172ArrayIter));
            }
        }
        out.setElem3(elem3Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListSinkClassesResponseListSinkClassesElem3Struct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesElem3Struct& in, DBusMessageIter* out) {
    int16 o175 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o175));
    int16 o176 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o176));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesElem3Struct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListSinkClassesResponseListSinkClassesStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesStruct& in, DBusMessageIter* out) {
    uint16 o177 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o177));
    const char* o178 = in.getElem2().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o178));
    DBusMessageIter o179ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(nn)", &o179ArrayIter));
    const ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesElem3Struct >* o180 = &in.getElem3();
    ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesElem3Struct >::const_iterator o181 = o180->end();
    for (::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesElem3Struct >::const_iterator o182 = o180->begin(); o182 != o181; ++o182) {
        {
            DBusMessageIter o183Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o179ArrayIter, DBUS_TYPE_STRUCT, 0, &o183Struct));
            serializeDBus((*o182), &o183Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o179ArrayIter, &o183Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o179ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesStruct& out) {
    {
        uint16 elem1Value;
        uint16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string elem2Value;
        ::std::string &elem2TmpValue = elem2Value;
        {
            char* o184 = 0;
            dbus_message_iter_get_basic(in, &o184);
            elem2TmpValue.assign (o184);
        }
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesElem3Struct > elem3Value;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o185ArrayIter;
            dbus_message_iter_recurse (in, &o185ArrayIter);

            if(dbus_message_iter_get_arg_type(&o185ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesElem3Struct o186;
                    {
                        DBusMessageIter o187;
                        char* signature = dbus_message_iter_get_signature(&o185ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o185ArrayIter)) {
                                dbus_message_iter_recurse (&o185ArrayIter, &o187);

                                if (!deserializeDBus(&o187, o186)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    elem3Value.push_back(o186);
                } while (dbus_message_iter_next(&o185ArrayIter));
            }
        }
        out.setElem3(elem3Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListSystemPropertiesRequestListSystemPropertiesStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesRequestListSystemPropertiesStruct& in, DBusMessageIter* out) {
    int16 o188 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o188));
    int16 o189 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o189));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesRequestListSystemPropertiesStruct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SinkAddedSignalNewSinkElem3Struct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SinkAddedSignalNewSinkElem3Struct& in, DBusMessageIter* out) {
    int16 o190 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o190));
    int16 o191 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o191));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SinkAddedSignalNewSinkElem3Struct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SinkAddedSignalNewSinkStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SinkAddedSignalNewSinkStruct& in, DBusMessageIter* out) {
    uint16 o192 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o192));
    const char* o193 = in.getElem2().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o193));
    {
        DBusMessageIter o194Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o194Struct));
        serializeDBus(in.getElem3(), &o194Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o194Struct));
    }
    int16 o195 = in.getElem4();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o195));
    int16 o196 = in.getElem5();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o196));
    uint16 o197 = in.getElem6();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o197));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SinkAddedSignalNewSinkStruct& out) {
    {
        uint16 elem1Value;
        uint16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string elem2Value;
        ::std::string &elem2TmpValue = elem2Value;
        {
            char* o198 = 0;
            dbus_message_iter_get_basic(in, &o198);
            elem2TmpValue.assign (o198);
        }
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::genivi::audiomanager::CommandInterface::SinkAddedSignalNewSinkElem3Struct elem3Value;
        {
            DBusMessageIter o199;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o199);

                    if (!deserializeDBus(&o199, elem3Value)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setElem3(elem3Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem4Value;
        int16 &elem4TmpValue = elem4Value;
        dbus_message_iter_get_basic(in, &elem4TmpValue);
        out.setElem4(elem4Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem5Value;
        int16 &elem5TmpValue = elem5Value;
        dbus_message_iter_get_basic(in, &elem5TmpValue);
        out.setElem5(elem5Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 elem6Value;
        uint16 &elem6TmpValue = elem6Value;
        dbus_message_iter_get_basic(in, &elem6TmpValue);
        out.setElem6(elem6Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SourceAddedSignalNewSourceElem3Struct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SourceAddedSignalNewSourceElem3Struct& in, DBusMessageIter* out) {
    int16 o200 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o200));
    int16 o201 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o201));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SourceAddedSignalNewSourceElem3Struct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SourceAddedSignalNewSourceStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SourceAddedSignalNewSourceStruct& in, DBusMessageIter* out) {
    uint16 o202 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o202));
    const char* o203 = in.getElem2().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o203));
    {
        DBusMessageIter o204Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o204Struct));
        serializeDBus(in.getElem3(), &o204Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o204Struct));
    }
    uint16 o205 = in.getElem4();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o205));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SourceAddedSignalNewSourceStruct& out) {
    {
        uint16 elem1Value;
        uint16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string elem2Value;
        ::std::string &elem2TmpValue = elem2Value;
        {
            char* o206 = 0;
            dbus_message_iter_get_basic(in, &o206);
            elem2TmpValue.assign (o206);
        }
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::genivi::audiomanager::CommandInterface::SourceAddedSignalNewSourceElem3Struct elem3Value;
        {
            DBusMessageIter o207;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o207);

                    if (!deserializeDBus(&o207, elem3Value)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setElem3(elem3Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 elem4Value;
        uint16 &elem4TmpValue = elem4Value;
        dbus_message_iter_get_basic(in, &elem4TmpValue);
        out.setElem4(elem4Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MainSinkSoundPropertyChangedSignalSoundPropertyStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::MainSinkSoundPropertyChangedSignalSoundPropertyStruct& in, DBusMessageIter* out) {
    int16 o208 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o208));
    int16 o209 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o209));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::MainSinkSoundPropertyChangedSignalSoundPropertyStruct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MainSourceSoundPropertyChangedSignalSoundPropertyStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::MainSourceSoundPropertyChangedSignalSoundPropertyStruct& in, DBusMessageIter* out) {
    int16 o210 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o210));
    int16 o211 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o211));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::MainSourceSoundPropertyChangedSignalSoundPropertyStruct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SinkAvailabilityChangedSignalAvailabilityStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SinkAvailabilityChangedSignalAvailabilityStruct& in, DBusMessageIter* out) {
    int16 o212 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o212));
    int16 o213 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o213));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SinkAvailabilityChangedSignalAvailabilityStruct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SourceAvailabilityChangedSignalAvailabilityStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SourceAvailabilityChangedSignalAvailabilityStruct& in, DBusMessageIter* out) {
    int16 o214 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o214));
    int16 o215 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o215));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SourceAvailabilityChangedSignalAvailabilityStruct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SystemPropertyChangedSignalSystemPropertyStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SystemPropertyChangedSignalSystemPropertyStruct& in, DBusMessageIter* out) {
    int16 o216 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o216));
    int16 o217 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o217));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SystemPropertyChangedSignalSystemPropertyStruct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

