#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_GENIVI_AUDIOMANAGER_COMMANDINTERFACE_H
#define ORG_GENIVI_AUDIOMANAGER_COMMANDINTERFACE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "CommandInterface" isn't clear, then there should be a description here.
 */

namespace org {
namespace genivi {
namespace audiomanager {
namespace CommandInterface {

// method IDs
static const uint16 ID_Connect = 0;
static const uint16 ID_Disconnect = 1;
static const uint16 ID_SetVolume = 2;
static const uint16 ID_SetSinkMuteState = 3;
static const uint16 ID_SetMainSinkSoundProperty = 4;
static const uint16 ID_SetMainSourceSoundProperty = 5;
static const uint16 ID_SetSystemProperty = 6;
static const uint16 ID_GetListMainConnections = 7;
static const uint16 ID_GetListMainSinks = 8;
static const uint16 ID_GetListMainSources = 9;
static const uint16 ID_GetListMainSinkSoundProperties = 10;
static const uint16 ID_GetListMainSourceSoundProperties = 11;
static const uint16 ID_GetListSourceClasses = 12;
static const uint16 ID_GetListSinkClasses = 13;
static const uint16 ID_GetListSystemProperties = 14;
static const uint16 ID_GetTimingInformation = 15;

// signal IDs
static const uint16 ID_NumberOfMainConnectionsChanged = 16;
static const uint16 ID_SinkAdded = 17;
static const uint16 ID_SinkRemoved = 18;
static const uint16 ID_SourceAdded = 19;
static const uint16 ID_SourceRemoved = 20;
static const uint16 ID_NumberOfSinkClassesChanged = 21;
static const uint16 ID_NumberOfSourceClassesChanged = 22;
static const uint16 ID_MainConnectionStateChanged = 23;
static const uint16 ID_MainSinkSoundPropertyChanged = 24;
static const uint16 ID_MainSourceSoundPropertyChanged = 25;
static const uint16 ID_SinkAvailabilityChanged = 26;
static const uint16 ID_SourceAvailabilityChanged = 27;
static const uint16 ID_VolumeChanged = 28;
static const uint16 ID_SinkMuteStateChanged = 29;
static const uint16 ID_SystemPropertyChanged = 30;
static const uint16 ID_TimingInformationChanged = 31;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 0;

static const int VERSION_MINOR = 1;

static const int VERSION_PATCH = 1;

// forward declarations
class ConnectRequest;

class ConnectResponse;

class DisconnectRequest;

class DisconnectResponse;

class SetVolumeRequest;

class SetVolumeResponse;

class SetSinkMuteStateRequest;

class SetSinkMuteStateResponse;

class SetMainSinkSoundPropertyRequestSoundPropertyStruct;

class SetMainSinkSoundPropertyRequest;

class SetMainSinkSoundPropertyResponse;

class SetMainSourceSoundPropertyRequestSoundPropertyStruct;

class SetMainSourceSoundPropertyRequest;

class SetMainSourceSoundPropertyResponse;

class SetSystemPropertyRequestPropertyStruct;

class SetSystemPropertyRequest;

class SetSystemPropertyResponse;

class GetListMainConnectionsResponseListConnectionsStruct;

class GetListMainConnectionsResponse;

class GetListMainSinksResponseListMainSinksElem3Struct;

class GetListMainSinksResponseListMainSinksStruct;

class GetListMainSinksResponse;

class GetListMainSourcesResponseListMainSourcesElem3Struct;

class GetListMainSourcesResponseListMainSourcesStruct;

class GetListMainSourcesResponse;

class GetListMainSinkSoundPropertiesRequest;

class GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct;

class GetListMainSinkSoundPropertiesResponse;

class GetListMainSourceSoundPropertiesRequest;

class GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct;

class GetListMainSourceSoundPropertiesResponse;

class GetListSourceClassesResponseListSourceClassesElem3Struct;

class GetListSourceClassesResponseListSourceClassesStruct;

class GetListSourceClassesResponse;

class GetListSinkClassesResponseListSinkClassesElem3Struct;

class GetListSinkClassesResponseListSinkClassesStruct;

class GetListSinkClassesResponse;

class GetListSystemPropertiesRequestListSystemPropertiesStruct;

class GetListSystemPropertiesRequest;

class GetListSystemPropertiesResponse;

class GetTimingInformationRequest;

class GetTimingInformationResponse;

class SinkAddedSignalNewSinkElem3Struct;

class SinkAddedSignalNewSinkStruct;

class SinkAddedSignal;

class SinkRemovedSignal;

class SourceAddedSignalNewSourceElem3Struct;

class SourceAddedSignalNewSourceStruct;

class SourceAddedSignal;

class SourceRemovedSignal;

class MainConnectionStateChangedSignal;

class MainSinkSoundPropertyChangedSignalSoundPropertyStruct;

class MainSinkSoundPropertyChangedSignal;

class MainSourceSoundPropertyChangedSignalSoundPropertyStruct;

class MainSourceSoundPropertyChangedSignal;

class SinkAvailabilityChangedSignalAvailabilityStruct;

class SinkAvailabilityChangedSignal;

class SourceAvailabilityChangedSignalAvailabilityStruct;

class SourceAvailabilityChangedSignal;

class VolumeChangedSignal;

class SinkMuteStateChangedSignal;

class SystemPropertyChangedSignalSystemPropertyStruct;

class SystemPropertyChangedSignal;

class TimingInformationChangedSignal;

// type definitions
/**
 * If the meaning of "ConnectError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConnectError;

/**
 * If the meaning of "DisconnectError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DisconnectError;

/**
 * If the meaning of "SetVolumeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetVolumeError;

/**
 * If the meaning of "SetSinkMuteStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetSinkMuteStateError;

/**
 * If the meaning of "SetMainSinkSoundPropertyError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetMainSinkSoundPropertyError;

/**
 * If the meaning of "SetMainSourceSoundPropertyError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetMainSourceSoundPropertyError;

/**
 * If the meaning of "SetSystemPropertyError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetSystemPropertyError;

/**
 * If the meaning of "GetListMainConnectionsRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetListMainConnectionsRequest;

/**
 * If the meaning of "GetListMainConnectionsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetListMainConnectionsError;

/**
 * If the meaning of "GetListMainSinksRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetListMainSinksRequest;

/**
 * If the meaning of "GetListMainSinksError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetListMainSinksError;

/**
 * If the meaning of "GetListMainSourcesRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetListMainSourcesRequest;

/**
 * If the meaning of "GetListMainSourcesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetListMainSourcesError;

/**
 * If the meaning of "GetListMainSinkSoundPropertiesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetListMainSinkSoundPropertiesError;

/**
 * If the meaning of "GetListMainSourceSoundPropertiesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetListMainSourceSoundPropertiesError;

/**
 * If the meaning of "GetListSourceClassesRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetListSourceClassesRequest;

/**
 * If the meaning of "GetListSourceClassesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetListSourceClassesError;

/**
 * If the meaning of "GetListSinkClassesRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetListSinkClassesRequest;

/**
 * If the meaning of "GetListSinkClassesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetListSinkClassesError;

/**
 * If the meaning of "GetListSystemPropertiesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetListSystemPropertiesError;

/**
 * If the meaning of "GetTimingInformationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetTimingInformationError;

/**
 * If the meaning of "NumberOfMainConnectionsChangedSignal" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage NumberOfMainConnectionsChangedSignal;

/**
 * If the meaning of "NumberOfMainConnectionsChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NumberOfMainConnectionsChangedError;

/**
 * If the meaning of "SinkAddedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SinkAddedError;

/**
 * If the meaning of "SinkRemovedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SinkRemovedError;

/**
 * If the meaning of "SourceAddedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SourceAddedError;

/**
 * If the meaning of "SourceRemovedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SourceRemovedError;

/**
 * If the meaning of "NumberOfSinkClassesChangedSignal" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage NumberOfSinkClassesChangedSignal;

/**
 * If the meaning of "NumberOfSinkClassesChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NumberOfSinkClassesChangedError;

/**
 * If the meaning of "NumberOfSourceClassesChangedSignal" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage NumberOfSourceClassesChangedSignal;

/**
 * If the meaning of "NumberOfSourceClassesChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NumberOfSourceClassesChangedError;

/**
 * If the meaning of "MainConnectionStateChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MainConnectionStateChangedError;

/**
 * If the meaning of "MainSinkSoundPropertyChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MainSinkSoundPropertyChangedError;

/**
 * If the meaning of "MainSourceSoundPropertyChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MainSourceSoundPropertyChangedError;

/**
 * If the meaning of "SinkAvailabilityChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SinkAvailabilityChangedError;

/**
 * If the meaning of "SourceAvailabilityChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SourceAvailabilityChangedError;

/**
 * If the meaning of "VolumeChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VolumeChangedError;

/**
 * If the meaning of "SinkMuteStateChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SinkMuteStateChangedError;

/**
 * If the meaning of "SystemPropertyChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SystemPropertyChangedError;

/**
 * If the meaning of "TimingInformationChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TimingInformationChangedError;


/**
 * If the meaning of "ConnectRequest" isn't clear, then there should be a description here.
 */
class ConnectRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectRequest ();

    /**
     * Copy constructor
     */
    inline  ConnectRequest (const ConnectRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectRequest (uint16 sourceID_, uint16 sinkID_);

    /**
     * Destructor
     */
    inline virtual  ~ConnectRequest();

    /**
     * Assignment operator
     */
    inline ConnectRequest& operator = (const ConnectRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sourceID"

    static const int kSourceID = 0;

    /**
     * Clears the field "sourceID".
     *
     * The field will be set to its default value. The hasSourceID()
     * method will return false.
     */
    inline void clearSourceID();

    /**
     * Checks whether the field "sourceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceID()). Otherwise it will return false.
     */
    inline bool hasSourceID () const;

    /**
     * Returns the value of the member "sourceID".
     *
     * If the meaning of "sourceID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourceID"
     */
    inline uint16 getSourceID () const;

    /**
     * Sets the value of the member "sourceID".
     *
     * If the meaning of "sourceID" isn't clear, then there should be a description here.
     *
     * @param sourceID The value which will be set
     */
    inline void setSourceID (uint16 sourceID_);

    // API of field "sinkID"

    static const int kSinkID = 1;

    /**
     * Clears the field "sinkID".
     *
     * The field will be set to its default value. The hasSinkID()
     * method will return false.
     */
    inline void clearSinkID();

    /**
     * Checks whether the field "sinkID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSinkID()). Otherwise it will return false.
     */
    inline bool hasSinkID () const;

    /**
     * Returns the value of the member "sinkID".
     *
     * If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sinkID"
     */
    inline uint16 getSinkID () const;

    /**
     * Sets the value of the member "sinkID".
     *
     * If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @param sinkID The value which will be set
     */
    inline void setSinkID (uint16 sinkID_);

    static const ConnectRequest &getDefaultInstance();

private:

    inline void set_has_sourceID ();

    inline void clear_has_sourceID ();

    inline void set_has_sinkID ();

    inline void clear_has_sinkID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _sourceID;

    uint16 _sinkID;

};

/**
 * If the meaning of "ConnectResponse" isn't clear, then there should be a description here.
 */
class ConnectResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectResponse ();

    /**
     * Copy constructor
     */
    inline  ConnectResponse (const ConnectResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectResponse (int16 result_, uint16 mainConnectionID_);

    /**
     * Destructor
     */
    inline virtual  ~ConnectResponse();

    /**
     * Assignment operator
     */
    inline ConnectResponse& operator = (const ConnectResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline int16 getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (int16 result_);

    // API of field "mainConnectionID"

    static const int kMainConnectionID = 1;

    /**
     * Clears the field "mainConnectionID".
     *
     * The field will be set to its default value. The hasMainConnectionID()
     * method will return false.
     */
    inline void clearMainConnectionID();

    /**
     * Checks whether the field "mainConnectionID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMainConnectionID()). Otherwise it will return false.
     */
    inline bool hasMainConnectionID () const;

    /**
     * Returns the value of the member "mainConnectionID".
     *
     * If the meaning of "mainConnectionID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mainConnectionID"
     */
    inline uint16 getMainConnectionID () const;

    /**
     * Sets the value of the member "mainConnectionID".
     *
     * If the meaning of "mainConnectionID" isn't clear, then there should be a description here.
     *
     * @param mainConnectionID The value which will be set
     */
    inline void setMainConnectionID (uint16 mainConnectionID_);

    static const ConnectResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    inline void set_has_mainConnectionID ();

    inline void clear_has_mainConnectionID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _result;

    uint16 _mainConnectionID;

};

/**
 * If the meaning of "DisconnectRequest" isn't clear, then there should be a description here.
 */
class DisconnectRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisconnectRequest ();

    /**
     * Copy constructor
     */
    inline  DisconnectRequest (const DisconnectRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DisconnectRequest (uint16 mainConnectionID_);

    /**
     * Destructor
     */
    inline virtual  ~DisconnectRequest();

    /**
     * Assignment operator
     */
    inline DisconnectRequest& operator = (const DisconnectRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisconnectRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisconnectRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisconnectRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisconnectRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "mainConnectionID"

    static const int kMainConnectionID = 0;

    /**
     * Clears the field "mainConnectionID".
     *
     * The field will be set to its default value. The hasMainConnectionID()
     * method will return false.
     */
    inline void clearMainConnectionID();

    /**
     * Checks whether the field "mainConnectionID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMainConnectionID()). Otherwise it will return false.
     */
    inline bool hasMainConnectionID () const;

    /**
     * Returns the value of the member "mainConnectionID".
     *
     * If the meaning of "mainConnectionID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mainConnectionID"
     */
    inline uint16 getMainConnectionID () const;

    /**
     * Sets the value of the member "mainConnectionID".
     *
     * If the meaning of "mainConnectionID" isn't clear, then there should be a description here.
     *
     * @param mainConnectionID The value which will be set
     */
    inline void setMainConnectionID (uint16 mainConnectionID_);

    static const DisconnectRequest &getDefaultInstance();

private:

    inline void set_has_mainConnectionID ();

    inline void clear_has_mainConnectionID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _mainConnectionID;

};

/**
 * If the meaning of "DisconnectResponse" isn't clear, then there should be a description here.
 */
class DisconnectResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisconnectResponse ();

    /**
     * Copy constructor
     */
    inline  DisconnectResponse (const DisconnectResponse &rhs);

    /**
     * All fields constructor
     */
    inline  DisconnectResponse (int16 result_);

    /**
     * Destructor
     */
    inline virtual  ~DisconnectResponse();

    /**
     * Assignment operator
     */
    inline DisconnectResponse& operator = (const DisconnectResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisconnectResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisconnectResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisconnectResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisconnectResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline int16 getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (int16 result_);

    static const DisconnectResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int16 _result;

};

/**
 * If the meaning of "SetVolumeRequest" isn't clear, then there should be a description here.
 */
class SetVolumeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetVolumeRequest ();

    /**
     * Copy constructor
     */
    inline  SetVolumeRequest (const SetVolumeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetVolumeRequest (uint16 sinkID_, uint16 Mode_, int16 value_);

    /**
     * Destructor
     */
    inline virtual  ~SetVolumeRequest();

    /**
     * Assignment operator
     */
    inline SetVolumeRequest& operator = (const SetVolumeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetVolumeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetVolumeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetVolumeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetVolumeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sinkID"

    static const int kSinkID = 0;

    /**
     * Clears the field "sinkID".
     *
     * The field will be set to its default value. The hasSinkID()
     * method will return false.
     */
    inline void clearSinkID();

    /**
     * Checks whether the field "sinkID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSinkID()). Otherwise it will return false.
     */
    inline bool hasSinkID () const;

    /**
     * Returns the value of the member "sinkID".
     *
     * If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sinkID"
     */
    inline uint16 getSinkID () const;

    /**
     * Sets the value of the member "sinkID".
     *
     * If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @param sinkID The value which will be set
     */
    inline void setSinkID (uint16 sinkID_);

    // API of field "Mode"

    static const int kMode = 1;

    /**
     * Clears the field "Mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "Mode".
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Mode"
     */
    inline uint16 getMode () const;

    /**
     * Sets the value of the member "Mode".
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     *
     * @param Mode The value which will be set
     */
    inline void setMode (uint16 Mode_);

    // API of field "value"

    static const int kValue = 2;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline int16 getValue () const;

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (int16 value_);

    static const SetVolumeRequest &getDefaultInstance();

private:

    inline void set_has_sinkID ();

    inline void clear_has_sinkID ();

    inline void set_has_Mode ();

    inline void clear_has_Mode ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _sinkID;

    uint16 _Mode;

    int16 _value;

};

/**
 * If the meaning of "SetVolumeResponse" isn't clear, then there should be a description here.
 */
class SetVolumeResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetVolumeResponse ();

    /**
     * Copy constructor
     */
    inline  SetVolumeResponse (const SetVolumeResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetVolumeResponse (int16 result_);

    /**
     * Destructor
     */
    inline virtual  ~SetVolumeResponse();

    /**
     * Assignment operator
     */
    inline SetVolumeResponse& operator = (const SetVolumeResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetVolumeResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetVolumeResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetVolumeResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetVolumeResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline int16 getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (int16 result_);

    static const SetVolumeResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int16 _result;

};

/**
 * If the meaning of "SetSinkMuteStateRequest" isn't clear, then there should be a description here.
 */
class SetSinkMuteStateRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetSinkMuteStateRequest ();

    /**
     * Copy constructor
     */
    inline  SetSinkMuteStateRequest (const SetSinkMuteStateRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetSinkMuteStateRequest (uint16 sinkID_, int16 muteState_);

    /**
     * Destructor
     */
    inline virtual  ~SetSinkMuteStateRequest();

    /**
     * Assignment operator
     */
    inline SetSinkMuteStateRequest& operator = (const SetSinkMuteStateRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetSinkMuteStateRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetSinkMuteStateRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetSinkMuteStateRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetSinkMuteStateRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sinkID"

    static const int kSinkID = 0;

    /**
     * Clears the field "sinkID".
     *
     * The field will be set to its default value. The hasSinkID()
     * method will return false.
     */
    inline void clearSinkID();

    /**
     * Checks whether the field "sinkID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSinkID()). Otherwise it will return false.
     */
    inline bool hasSinkID () const;

    /**
     * Returns the value of the member "sinkID".
     *
     * If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sinkID"
     */
    inline uint16 getSinkID () const;

    /**
     * Sets the value of the member "sinkID".
     *
     * If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @param sinkID The value which will be set
     */
    inline void setSinkID (uint16 sinkID_);

    // API of field "muteState"

    static const int kMuteState = 1;

    /**
     * Clears the field "muteState".
     *
     * The field will be set to its default value. The hasMuteState()
     * method will return false.
     */
    inline void clearMuteState();

    /**
     * Checks whether the field "muteState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMuteState()). Otherwise it will return false.
     */
    inline bool hasMuteState () const;

    /**
     * Returns the value of the member "muteState".
     *
     * If the meaning of "muteState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "muteState"
     */
    inline int16 getMuteState () const;

    /**
     * Sets the value of the member "muteState".
     *
     * If the meaning of "muteState" isn't clear, then there should be a description here.
     *
     * @param muteState The value which will be set
     */
    inline void setMuteState (int16 muteState_);

    static const SetSinkMuteStateRequest &getDefaultInstance();

private:

    inline void set_has_sinkID ();

    inline void clear_has_sinkID ();

    inline void set_has_muteState ();

    inline void clear_has_muteState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _sinkID;

    int16 _muteState;

};

/**
 * If the meaning of "SetSinkMuteStateResponse" isn't clear, then there should be a description here.
 */
class SetSinkMuteStateResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetSinkMuteStateResponse ();

    /**
     * Copy constructor
     */
    inline  SetSinkMuteStateResponse (const SetSinkMuteStateResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetSinkMuteStateResponse (int16 result_);

    /**
     * Destructor
     */
    inline virtual  ~SetSinkMuteStateResponse();

    /**
     * Assignment operator
     */
    inline SetSinkMuteStateResponse& operator = (const SetSinkMuteStateResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetSinkMuteStateResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetSinkMuteStateResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetSinkMuteStateResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetSinkMuteStateResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline int16 getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (int16 result_);

    static const SetSinkMuteStateResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int16 _result;

};

/**
 * If the meaning of "SetMainSinkSoundPropertyRequestSoundPropertyStruct" isn't clear, then there should be a description here.
 */
class SetMainSinkSoundPropertyRequestSoundPropertyStruct {
public:

    /**
     * Default constructor
     */
    inline  SetMainSinkSoundPropertyRequestSoundPropertyStruct ();

    /**
     * Copy constructor
     */
    inline  SetMainSinkSoundPropertyRequestSoundPropertyStruct (const SetMainSinkSoundPropertyRequestSoundPropertyStruct &rhs);

    /**
     * All fields constructor
     */
    inline  SetMainSinkSoundPropertyRequestSoundPropertyStruct (int16 elem1_, int16 elem2_);

    /**
     * Destructor
     */
    inline  ~SetMainSinkSoundPropertyRequestSoundPropertyStruct();

    /**
     * Assignment operator
     */
    inline SetMainSinkSoundPropertyRequestSoundPropertyStruct& operator = (const SetMainSinkSoundPropertyRequestSoundPropertyStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetMainSinkSoundPropertyRequestSoundPropertyStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetMainSinkSoundPropertyRequestSoundPropertyStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetMainSinkSoundPropertyRequestSoundPropertyStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetMainSinkSoundPropertyRequestSoundPropertyStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline int16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (int16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline int16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (int16 elem2_);

    static const SetMainSinkSoundPropertyRequestSoundPropertyStruct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _elem1;

    int16 _elem2;

};

/**
 * If the meaning of "SetMainSinkSoundPropertyRequest" isn't clear, then there should be a description here.
 */
class SetMainSinkSoundPropertyRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetMainSinkSoundPropertyRequest ();

    /**
     * Copy constructor
     */
    inline  SetMainSinkSoundPropertyRequest (const SetMainSinkSoundPropertyRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetMainSinkSoundPropertyRequest (uint16 sinkID_, const SetMainSinkSoundPropertyRequestSoundPropertyStruct& soundProperty_);

    /**
     * Destructor
     */
    inline virtual  ~SetMainSinkSoundPropertyRequest();

    /**
     * Assignment operator
     */
    inline SetMainSinkSoundPropertyRequest& operator = (const SetMainSinkSoundPropertyRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetMainSinkSoundPropertyRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetMainSinkSoundPropertyRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetMainSinkSoundPropertyRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetMainSinkSoundPropertyRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sinkID"

    static const int kSinkID = 0;

    /**
     * Clears the field "sinkID".
     *
     * The field will be set to its default value. The hasSinkID()
     * method will return false.
     */
    inline void clearSinkID();

    /**
     * Checks whether the field "sinkID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSinkID()). Otherwise it will return false.
     */
    inline bool hasSinkID () const;

    /**
     * Returns the value of the member "sinkID".
     *
     * If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sinkID"
     */
    inline uint16 getSinkID () const;

    /**
     * Sets the value of the member "sinkID".
     *
     * If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @param sinkID The value which will be set
     */
    inline void setSinkID (uint16 sinkID_);

    // API of field "soundProperty"

    static const int kSoundProperty = 1;

    /**
     * Clears the field "soundProperty".
     *
     * The field will be set to its default value. The hasSoundProperty()
     * method will return false.
     */
    inline void clearSoundProperty();

    /**
     * Checks whether the field "soundProperty" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundProperty()). Otherwise it will return false.
     */
    inline bool hasSoundProperty () const;

    /**
     * Returns the value of the member "soundProperty".
     *
     * If the meaning of "soundProperty" isn't clear, then there should be a description here.
     *
     * @return The value of the field "soundProperty"
     */
    inline const SetMainSinkSoundPropertyRequestSoundPropertyStruct& getSoundProperty () const;

    /**
     * Retrieves the value of the field "soundProperty" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "soundProperty".
     */
    inline SetMainSinkSoundPropertyRequestSoundPropertyStruct& getSoundPropertyMutable ();

    /**
     * Sets the value of the member "soundProperty".
     *
     * If the meaning of "soundProperty" isn't clear, then there should be a description here.
     *
     * @param soundProperty The value which will be set
     */
    inline void setSoundProperty (const SetMainSinkSoundPropertyRequestSoundPropertyStruct& soundProperty_);

    static const SetMainSinkSoundPropertyRequest &getDefaultInstance();

private:

    inline void set_has_sinkID ();

    inline void clear_has_sinkID ();

    inline void set_has_soundProperty ();

    inline void clear_has_soundProperty ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _sinkID;

    SetMainSinkSoundPropertyRequestSoundPropertyStruct _soundProperty;

};

/**
 * If the meaning of "SetMainSinkSoundPropertyResponse" isn't clear, then there should be a description here.
 */
class SetMainSinkSoundPropertyResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetMainSinkSoundPropertyResponse ();

    /**
     * Copy constructor
     */
    inline  SetMainSinkSoundPropertyResponse (const SetMainSinkSoundPropertyResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetMainSinkSoundPropertyResponse (int16 result_);

    /**
     * Destructor
     */
    inline virtual  ~SetMainSinkSoundPropertyResponse();

    /**
     * Assignment operator
     */
    inline SetMainSinkSoundPropertyResponse& operator = (const SetMainSinkSoundPropertyResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetMainSinkSoundPropertyResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetMainSinkSoundPropertyResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetMainSinkSoundPropertyResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetMainSinkSoundPropertyResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline int16 getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (int16 result_);

    static const SetMainSinkSoundPropertyResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int16 _result;

};

/**
 * If the meaning of "SetMainSourceSoundPropertyRequestSoundPropertyStruct" isn't clear, then there should be a description here.
 */
class SetMainSourceSoundPropertyRequestSoundPropertyStruct {
public:

    /**
     * Default constructor
     */
    inline  SetMainSourceSoundPropertyRequestSoundPropertyStruct ();

    /**
     * Copy constructor
     */
    inline  SetMainSourceSoundPropertyRequestSoundPropertyStruct (const SetMainSourceSoundPropertyRequestSoundPropertyStruct &rhs);

    /**
     * All fields constructor
     */
    inline  SetMainSourceSoundPropertyRequestSoundPropertyStruct (int16 elem1_, int16 elem2_);

    /**
     * Destructor
     */
    inline  ~SetMainSourceSoundPropertyRequestSoundPropertyStruct();

    /**
     * Assignment operator
     */
    inline SetMainSourceSoundPropertyRequestSoundPropertyStruct& operator = (const SetMainSourceSoundPropertyRequestSoundPropertyStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetMainSourceSoundPropertyRequestSoundPropertyStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetMainSourceSoundPropertyRequestSoundPropertyStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetMainSourceSoundPropertyRequestSoundPropertyStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetMainSourceSoundPropertyRequestSoundPropertyStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline int16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (int16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline int16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (int16 elem2_);

    static const SetMainSourceSoundPropertyRequestSoundPropertyStruct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _elem1;

    int16 _elem2;

};

/**
 * If the meaning of "SetMainSourceSoundPropertyRequest" isn't clear, then there should be a description here.
 */
class SetMainSourceSoundPropertyRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetMainSourceSoundPropertyRequest ();

    /**
     * Copy constructor
     */
    inline  SetMainSourceSoundPropertyRequest (const SetMainSourceSoundPropertyRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetMainSourceSoundPropertyRequest (uint16 sourceID_, const SetMainSourceSoundPropertyRequestSoundPropertyStruct& soundProperty_);

    /**
     * Destructor
     */
    inline virtual  ~SetMainSourceSoundPropertyRequest();

    /**
     * Assignment operator
     */
    inline SetMainSourceSoundPropertyRequest& operator = (const SetMainSourceSoundPropertyRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetMainSourceSoundPropertyRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetMainSourceSoundPropertyRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetMainSourceSoundPropertyRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetMainSourceSoundPropertyRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sourceID"

    static const int kSourceID = 0;

    /**
     * Clears the field "sourceID".
     *
     * The field will be set to its default value. The hasSourceID()
     * method will return false.
     */
    inline void clearSourceID();

    /**
     * Checks whether the field "sourceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceID()). Otherwise it will return false.
     */
    inline bool hasSourceID () const;

    /**
     * Returns the value of the member "sourceID".
     *
     * If the meaning of "sourceID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourceID"
     */
    inline uint16 getSourceID () const;

    /**
     * Sets the value of the member "sourceID".
     *
     * If the meaning of "sourceID" isn't clear, then there should be a description here.
     *
     * @param sourceID The value which will be set
     */
    inline void setSourceID (uint16 sourceID_);

    // API of field "soundProperty"

    static const int kSoundProperty = 1;

    /**
     * Clears the field "soundProperty".
     *
     * The field will be set to its default value. The hasSoundProperty()
     * method will return false.
     */
    inline void clearSoundProperty();

    /**
     * Checks whether the field "soundProperty" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundProperty()). Otherwise it will return false.
     */
    inline bool hasSoundProperty () const;

    /**
     * Returns the value of the member "soundProperty".
     *
     * If the meaning of "soundProperty" isn't clear, then there should be a description here.
     *
     * @return The value of the field "soundProperty"
     */
    inline const SetMainSourceSoundPropertyRequestSoundPropertyStruct& getSoundProperty () const;

    /**
     * Retrieves the value of the field "soundProperty" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "soundProperty".
     */
    inline SetMainSourceSoundPropertyRequestSoundPropertyStruct& getSoundPropertyMutable ();

    /**
     * Sets the value of the member "soundProperty".
     *
     * If the meaning of "soundProperty" isn't clear, then there should be a description here.
     *
     * @param soundProperty The value which will be set
     */
    inline void setSoundProperty (const SetMainSourceSoundPropertyRequestSoundPropertyStruct& soundProperty_);

    static const SetMainSourceSoundPropertyRequest &getDefaultInstance();

private:

    inline void set_has_sourceID ();

    inline void clear_has_sourceID ();

    inline void set_has_soundProperty ();

    inline void clear_has_soundProperty ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _sourceID;

    SetMainSourceSoundPropertyRequestSoundPropertyStruct _soundProperty;

};

/**
 * If the meaning of "SetMainSourceSoundPropertyResponse" isn't clear, then there should be a description here.
 */
class SetMainSourceSoundPropertyResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetMainSourceSoundPropertyResponse ();

    /**
     * Copy constructor
     */
    inline  SetMainSourceSoundPropertyResponse (const SetMainSourceSoundPropertyResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetMainSourceSoundPropertyResponse (int16 result_);

    /**
     * Destructor
     */
    inline virtual  ~SetMainSourceSoundPropertyResponse();

    /**
     * Assignment operator
     */
    inline SetMainSourceSoundPropertyResponse& operator = (const SetMainSourceSoundPropertyResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetMainSourceSoundPropertyResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetMainSourceSoundPropertyResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetMainSourceSoundPropertyResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetMainSourceSoundPropertyResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline int16 getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (int16 result_);

    static const SetMainSourceSoundPropertyResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int16 _result;

};

/**
 * If the meaning of "SetSystemPropertyRequestPropertyStruct" isn't clear, then there should be a description here.
 */
class SetSystemPropertyRequestPropertyStruct {
public:

    /**
     * Default constructor
     */
    inline  SetSystemPropertyRequestPropertyStruct ();

    /**
     * Copy constructor
     */
    inline  SetSystemPropertyRequestPropertyStruct (const SetSystemPropertyRequestPropertyStruct &rhs);

    /**
     * All fields constructor
     */
    inline  SetSystemPropertyRequestPropertyStruct (int16 elem1_, int16 elem2_);

    /**
     * Destructor
     */
    inline  ~SetSystemPropertyRequestPropertyStruct();

    /**
     * Assignment operator
     */
    inline SetSystemPropertyRequestPropertyStruct& operator = (const SetSystemPropertyRequestPropertyStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetSystemPropertyRequestPropertyStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetSystemPropertyRequestPropertyStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetSystemPropertyRequestPropertyStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetSystemPropertyRequestPropertyStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline int16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (int16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline int16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (int16 elem2_);

    static const SetSystemPropertyRequestPropertyStruct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _elem1;

    int16 _elem2;

};

/**
 * If the meaning of "SetSystemPropertyRequest" isn't clear, then there should be a description here.
 */
class SetSystemPropertyRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetSystemPropertyRequest ();

    /**
     * Copy constructor
     */
    inline  SetSystemPropertyRequest (const SetSystemPropertyRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetSystemPropertyRequest (const SetSystemPropertyRequestPropertyStruct& property_);

    /**
     * Destructor
     */
    inline virtual  ~SetSystemPropertyRequest();

    /**
     * Assignment operator
     */
    inline SetSystemPropertyRequest& operator = (const SetSystemPropertyRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetSystemPropertyRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetSystemPropertyRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetSystemPropertyRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetSystemPropertyRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "property"

    static const int kProperty = 0;

    /**
     * Clears the field "property".
     *
     * The field will be set to its default value. The hasProperty()
     * method will return false.
     */
    inline void clearProperty();

    /**
     * Checks whether the field "property" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProperty()). Otherwise it will return false.
     */
    inline bool hasProperty () const;

    /**
     * Returns the value of the member "property".
     *
     * If the meaning of "property" isn't clear, then there should be a description here.
     *
     * @return The value of the field "property"
     */
    inline const SetSystemPropertyRequestPropertyStruct& getProperty () const;

    /**
     * Retrieves the value of the field "property" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "property".
     */
    inline SetSystemPropertyRequestPropertyStruct& getPropertyMutable ();

    /**
     * Sets the value of the member "property".
     *
     * If the meaning of "property" isn't clear, then there should be a description here.
     *
     * @param property The value which will be set
     */
    inline void setProperty (const SetSystemPropertyRequestPropertyStruct& property_);

    static const SetSystemPropertyRequest &getDefaultInstance();

private:

    inline void set_has_property ();

    inline void clear_has_property ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SetSystemPropertyRequestPropertyStruct _property;

};

/**
 * If the meaning of "SetSystemPropertyResponse" isn't clear, then there should be a description here.
 */
class SetSystemPropertyResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetSystemPropertyResponse ();

    /**
     * Copy constructor
     */
    inline  SetSystemPropertyResponse (const SetSystemPropertyResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetSystemPropertyResponse (int16 result_);

    /**
     * Destructor
     */
    inline virtual  ~SetSystemPropertyResponse();

    /**
     * Assignment operator
     */
    inline SetSystemPropertyResponse& operator = (const SetSystemPropertyResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetSystemPropertyResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetSystemPropertyResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetSystemPropertyResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetSystemPropertyResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline int16 getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (int16 result_);

    static const SetSystemPropertyResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int16 _result;

};

/**
 * If the meaning of "GetListMainConnectionsResponseListConnectionsStruct" isn't clear, then there should be a description here.
 */
class GetListMainConnectionsResponseListConnectionsStruct {
public:

    /**
     * Default constructor
     */
    inline  GetListMainConnectionsResponseListConnectionsStruct ();

    /**
     * Copy constructor
     */
    inline  GetListMainConnectionsResponseListConnectionsStruct (const GetListMainConnectionsResponseListConnectionsStruct &rhs);

    /**
     * All fields constructor
     */
    inline  GetListMainConnectionsResponseListConnectionsStruct (uint16 elem1_, uint16 elem2_, uint16 elem3_, int16 elem4_, int16 elem5_);

    /**
     * Destructor
     */
    inline  ~GetListMainConnectionsResponseListConnectionsStruct();

    /**
     * Assignment operator
     */
    inline GetListMainConnectionsResponseListConnectionsStruct& operator = (const GetListMainConnectionsResponseListConnectionsStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListMainConnectionsResponseListConnectionsStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListMainConnectionsResponseListConnectionsStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListMainConnectionsResponseListConnectionsStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListMainConnectionsResponseListConnectionsStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline uint16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (uint16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline uint16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (uint16 elem2_);

    // API of field "elem3"

    static const int kElem3 = 2;

    /**
     * Clears the field "elem3".
     *
     * The field will be set to its default value. The hasElem3()
     * method will return false.
     */
    inline void clearElem3();

    /**
     * Checks whether the field "elem3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem3()). Otherwise it will return false.
     */
    inline bool hasElem3 () const;

    /**
     * Returns the value of the member "elem3".
     *
     * If the meaning of "elem3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem3"
     */
    inline uint16 getElem3 () const;

    /**
     * Sets the value of the member "elem3".
     *
     * If the meaning of "elem3" isn't clear, then there should be a description here.
     *
     * @param elem3 The value which will be set
     */
    inline void setElem3 (uint16 elem3_);

    // API of field "elem4"

    static const int kElem4 = 3;

    /**
     * Clears the field "elem4".
     *
     * The field will be set to its default value. The hasElem4()
     * method will return false.
     */
    inline void clearElem4();

    /**
     * Checks whether the field "elem4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem4()). Otherwise it will return false.
     */
    inline bool hasElem4 () const;

    /**
     * Returns the value of the member "elem4".
     *
     * If the meaning of "elem4" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem4"
     */
    inline int16 getElem4 () const;

    /**
     * Sets the value of the member "elem4".
     *
     * If the meaning of "elem4" isn't clear, then there should be a description here.
     *
     * @param elem4 The value which will be set
     */
    inline void setElem4 (int16 elem4_);

    // API of field "elem5"

    static const int kElem5 = 4;

    /**
     * Clears the field "elem5".
     *
     * The field will be set to its default value. The hasElem5()
     * method will return false.
     */
    inline void clearElem5();

    /**
     * Checks whether the field "elem5" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem5()). Otherwise it will return false.
     */
    inline bool hasElem5 () const;

    /**
     * Returns the value of the member "elem5".
     *
     * If the meaning of "elem5" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem5"
     */
    inline int16 getElem5 () const;

    /**
     * Sets the value of the member "elem5".
     *
     * If the meaning of "elem5" isn't clear, then there should be a description here.
     *
     * @param elem5 The value which will be set
     */
    inline void setElem5 (int16 elem5_);

    static const GetListMainConnectionsResponseListConnectionsStruct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    inline void set_has_elem3 ();

    inline void clear_has_elem3 ();

    inline void set_has_elem4 ();

    inline void clear_has_elem4 ();

    inline void set_has_elem5 ();

    inline void clear_has_elem5 ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint16 _elem1;

    uint16 _elem2;

    uint16 _elem3;

    int16 _elem4;

    int16 _elem5;

};

/**
 * If the meaning of "GetListMainConnectionsResponse" isn't clear, then there should be a description here.
 */
class GetListMainConnectionsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetListMainConnectionsResponse ();

    /**
     * Copy constructor
     */
    inline  GetListMainConnectionsResponse (const GetListMainConnectionsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetListMainConnectionsResponse (int16 result_, const ::std::vector< GetListMainConnectionsResponseListConnectionsStruct >& listConnections_);

    /**
     * Destructor
     */
    inline virtual  ~GetListMainConnectionsResponse();

    /**
     * Assignment operator
     */
    inline GetListMainConnectionsResponse& operator = (const GetListMainConnectionsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListMainConnectionsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListMainConnectionsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListMainConnectionsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListMainConnectionsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline int16 getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (int16 result_);

    // API of field "listConnections"

    static const int kListConnections = 1;

    /**
     * Clears the field "listConnections".
     *
     * The field will be set to its default value. The hasListConnections()
     * method will return false.
     */
    inline void clearListConnections();

    /**
     * Checks whether the field "listConnections" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListConnections()). Otherwise it will return false.
     */
    inline bool hasListConnections () const;

    /**
     * Returns the value of the member "listConnections".
     *
     * If the meaning of "listConnections" isn't clear, then there should be a description here.
     *
     * @return The value of the field "listConnections"
     */
    inline const ::std::vector< GetListMainConnectionsResponseListConnectionsStruct >& getListConnections () const;

    /**
     * Retrieves the value of the field "listConnections" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "listConnections".
     */
    inline ::std::vector< GetListMainConnectionsResponseListConnectionsStruct >& getListConnectionsMutable ();

    /**
     * Sets the value of the member "listConnections".
     *
     * If the meaning of "listConnections" isn't clear, then there should be a description here.
     *
     * @param listConnections The value which will be set
     */
    inline void setListConnections (const ::std::vector< GetListMainConnectionsResponseListConnectionsStruct >& listConnections_);

    static const GetListMainConnectionsResponse &getDefaultInstance();

private:

    static const ::std::vector< GetListMainConnectionsResponseListConnectionsStruct >& getGetListMainConnectionsResponseListConnectionsStructList_DefaultInstance ();

    inline void set_has_result ();

    inline void clear_has_result ();

    inline void set_has_listConnections ();

    inline void clear_has_listConnections ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _result;

    ::std::vector< GetListMainConnectionsResponseListConnectionsStruct > _listConnections;

};

/**
 * If the meaning of "GetListMainSinksResponseListMainSinksElem3Struct" isn't clear, then there should be a description here.
 */
class GetListMainSinksResponseListMainSinksElem3Struct {
public:

    /**
     * Default constructor
     */
    inline  GetListMainSinksResponseListMainSinksElem3Struct ();

    /**
     * Copy constructor
     */
    inline  GetListMainSinksResponseListMainSinksElem3Struct (const GetListMainSinksResponseListMainSinksElem3Struct &rhs);

    /**
     * All fields constructor
     */
    inline  GetListMainSinksResponseListMainSinksElem3Struct (int16 elem1_, int16 elem2_);

    /**
     * Destructor
     */
    inline  ~GetListMainSinksResponseListMainSinksElem3Struct();

    /**
     * Assignment operator
     */
    inline GetListMainSinksResponseListMainSinksElem3Struct& operator = (const GetListMainSinksResponseListMainSinksElem3Struct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListMainSinksResponseListMainSinksElem3Struct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListMainSinksResponseListMainSinksElem3Struct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListMainSinksResponseListMainSinksElem3Struct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListMainSinksResponseListMainSinksElem3Struct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline int16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (int16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline int16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (int16 elem2_);

    static const GetListMainSinksResponseListMainSinksElem3Struct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _elem1;

    int16 _elem2;

};

/**
 * If the meaning of "GetListMainSinksResponseListMainSinksStruct" isn't clear, then there should be a description here.
 */
class GetListMainSinksResponseListMainSinksStruct {
public:

    /**
     * Default constructor
     */
    inline  GetListMainSinksResponseListMainSinksStruct ();

    /**
     * Copy constructor
     */
    inline  GetListMainSinksResponseListMainSinksStruct (const GetListMainSinksResponseListMainSinksStruct &rhs);

    /**
     * All fields constructor
     */
    inline  GetListMainSinksResponseListMainSinksStruct (uint16 elem1_, const ::std::string& elem2_, const GetListMainSinksResponseListMainSinksElem3Struct& elem3_, int16 elem4_, int16 elem5_, uint16 elem6_);

    /**
     * Destructor
     */
    inline  ~GetListMainSinksResponseListMainSinksStruct();

    /**
     * Assignment operator
     */
    inline GetListMainSinksResponseListMainSinksStruct& operator = (const GetListMainSinksResponseListMainSinksStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListMainSinksResponseListMainSinksStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListMainSinksResponseListMainSinksStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListMainSinksResponseListMainSinksStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListMainSinksResponseListMainSinksStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline uint16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (uint16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::string& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::string& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::string& elem2_);

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const char* elem2_);

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const char* value, size_t size);

    // API of field "elem3"

    static const int kElem3 = 2;

    /**
     * Clears the field "elem3".
     *
     * The field will be set to its default value. The hasElem3()
     * method will return false.
     */
    inline void clearElem3();

    /**
     * Checks whether the field "elem3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem3()). Otherwise it will return false.
     */
    inline bool hasElem3 () const;

    /**
     * Returns the value of the member "elem3".
     *
     * If the meaning of "elem3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem3"
     */
    inline const GetListMainSinksResponseListMainSinksElem3Struct& getElem3 () const;

    /**
     * Retrieves the value of the field "elem3" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem3".
     */
    inline GetListMainSinksResponseListMainSinksElem3Struct& getElem3Mutable ();

    /**
     * Sets the value of the member "elem3".
     *
     * If the meaning of "elem3" isn't clear, then there should be a description here.
     *
     * @param elem3 The value which will be set
     */
    inline void setElem3 (const GetListMainSinksResponseListMainSinksElem3Struct& elem3_);

    // API of field "elem4"

    static const int kElem4 = 3;

    /**
     * Clears the field "elem4".
     *
     * The field will be set to its default value. The hasElem4()
     * method will return false.
     */
    inline void clearElem4();

    /**
     * Checks whether the field "elem4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem4()). Otherwise it will return false.
     */
    inline bool hasElem4 () const;

    /**
     * Returns the value of the member "elem4".
     *
     * If the meaning of "elem4" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem4"
     */
    inline int16 getElem4 () const;

    /**
     * Sets the value of the member "elem4".
     *
     * If the meaning of "elem4" isn't clear, then there should be a description here.
     *
     * @param elem4 The value which will be set
     */
    inline void setElem4 (int16 elem4_);

    // API of field "elem5"

    static const int kElem5 = 4;

    /**
     * Clears the field "elem5".
     *
     * The field will be set to its default value. The hasElem5()
     * method will return false.
     */
    inline void clearElem5();

    /**
     * Checks whether the field "elem5" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem5()). Otherwise it will return false.
     */
    inline bool hasElem5 () const;

    /**
     * Returns the value of the member "elem5".
     *
     * If the meaning of "elem5" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem5"
     */
    inline int16 getElem5 () const;

    /**
     * Sets the value of the member "elem5".
     *
     * If the meaning of "elem5" isn't clear, then there should be a description here.
     *
     * @param elem5 The value which will be set
     */
    inline void setElem5 (int16 elem5_);

    // API of field "elem6"

    static const int kElem6 = 5;

    /**
     * Clears the field "elem6".
     *
     * The field will be set to its default value. The hasElem6()
     * method will return false.
     */
    inline void clearElem6();

    /**
     * Checks whether the field "elem6" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem6()). Otherwise it will return false.
     */
    inline bool hasElem6 () const;

    /**
     * Returns the value of the member "elem6".
     *
     * If the meaning of "elem6" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem6"
     */
    inline uint16 getElem6 () const;

    /**
     * Sets the value of the member "elem6".
     *
     * If the meaning of "elem6" isn't clear, then there should be a description here.
     *
     * @param elem6 The value which will be set
     */
    inline void setElem6 (uint16 elem6_);

    static const GetListMainSinksResponseListMainSinksStruct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    inline void set_has_elem3 ();

    inline void clear_has_elem3 ();

    inline void set_has_elem4 ();

    inline void clear_has_elem4 ();

    inline void set_has_elem5 ();

    inline void clear_has_elem5 ();

    inline void set_has_elem6 ();

    inline void clear_has_elem6 ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint16 _elem1;

    ::std::string _elem2;

    GetListMainSinksResponseListMainSinksElem3Struct _elem3;

    int16 _elem4;

    int16 _elem5;

    uint16 _elem6;

};

/**
 * If the meaning of "GetListMainSinksResponse" isn't clear, then there should be a description here.
 */
class GetListMainSinksResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetListMainSinksResponse ();

    /**
     * Copy constructor
     */
    inline  GetListMainSinksResponse (const GetListMainSinksResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetListMainSinksResponse (int16 result_, const ::std::vector< GetListMainSinksResponseListMainSinksStruct >& listMainSinks_);

    /**
     * Destructor
     */
    inline virtual  ~GetListMainSinksResponse();

    /**
     * Assignment operator
     */
    inline GetListMainSinksResponse& operator = (const GetListMainSinksResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListMainSinksResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListMainSinksResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListMainSinksResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListMainSinksResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline int16 getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (int16 result_);

    // API of field "listMainSinks"

    static const int kListMainSinks = 1;

    /**
     * Clears the field "listMainSinks".
     *
     * The field will be set to its default value. The hasListMainSinks()
     * method will return false.
     */
    inline void clearListMainSinks();

    /**
     * Checks whether the field "listMainSinks" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListMainSinks()). Otherwise it will return false.
     */
    inline bool hasListMainSinks () const;

    /**
     * Returns the value of the member "listMainSinks".
     *
     * If the meaning of "listMainSinks" isn't clear, then there should be a description here.
     *
     * @return The value of the field "listMainSinks"
     */
    inline const ::std::vector< GetListMainSinksResponseListMainSinksStruct >& getListMainSinks () const;

    /**
     * Retrieves the value of the field "listMainSinks" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "listMainSinks".
     */
    inline ::std::vector< GetListMainSinksResponseListMainSinksStruct >& getListMainSinksMutable ();

    /**
     * Sets the value of the member "listMainSinks".
     *
     * If the meaning of "listMainSinks" isn't clear, then there should be a description here.
     *
     * @param listMainSinks The value which will be set
     */
    inline void setListMainSinks (const ::std::vector< GetListMainSinksResponseListMainSinksStruct >& listMainSinks_);

    static const GetListMainSinksResponse &getDefaultInstance();

private:

    static const ::std::vector< GetListMainSinksResponseListMainSinksStruct >& getGetListMainSinksResponseListMainSinksStructList_DefaultInstance ();

    inline void set_has_result ();

    inline void clear_has_result ();

    inline void set_has_listMainSinks ();

    inline void clear_has_listMainSinks ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _result;

    ::std::vector< GetListMainSinksResponseListMainSinksStruct > _listMainSinks;

};

/**
 * If the meaning of "GetListMainSourcesResponseListMainSourcesElem3Struct" isn't clear, then there should be a description here.
 */
class GetListMainSourcesResponseListMainSourcesElem3Struct {
public:

    /**
     * Default constructor
     */
    inline  GetListMainSourcesResponseListMainSourcesElem3Struct ();

    /**
     * Copy constructor
     */
    inline  GetListMainSourcesResponseListMainSourcesElem3Struct (const GetListMainSourcesResponseListMainSourcesElem3Struct &rhs);

    /**
     * All fields constructor
     */
    inline  GetListMainSourcesResponseListMainSourcesElem3Struct (int16 elem1_, int16 elem2_);

    /**
     * Destructor
     */
    inline  ~GetListMainSourcesResponseListMainSourcesElem3Struct();

    /**
     * Assignment operator
     */
    inline GetListMainSourcesResponseListMainSourcesElem3Struct& operator = (const GetListMainSourcesResponseListMainSourcesElem3Struct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListMainSourcesResponseListMainSourcesElem3Struct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListMainSourcesResponseListMainSourcesElem3Struct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListMainSourcesResponseListMainSourcesElem3Struct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListMainSourcesResponseListMainSourcesElem3Struct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline int16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (int16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline int16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (int16 elem2_);

    static const GetListMainSourcesResponseListMainSourcesElem3Struct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _elem1;

    int16 _elem2;

};

/**
 * If the meaning of "GetListMainSourcesResponseListMainSourcesStruct" isn't clear, then there should be a description here.
 */
class GetListMainSourcesResponseListMainSourcesStruct {
public:

    /**
     * Default constructor
     */
    inline  GetListMainSourcesResponseListMainSourcesStruct ();

    /**
     * Copy constructor
     */
    inline  GetListMainSourcesResponseListMainSourcesStruct (const GetListMainSourcesResponseListMainSourcesStruct &rhs);

    /**
     * All fields constructor
     */
    inline  GetListMainSourcesResponseListMainSourcesStruct (uint16 elem1_, const ::std::string& elem2_, const GetListMainSourcesResponseListMainSourcesElem3Struct& elem3_, uint16 elem4_);

    /**
     * Destructor
     */
    inline  ~GetListMainSourcesResponseListMainSourcesStruct();

    /**
     * Assignment operator
     */
    inline GetListMainSourcesResponseListMainSourcesStruct& operator = (const GetListMainSourcesResponseListMainSourcesStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListMainSourcesResponseListMainSourcesStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListMainSourcesResponseListMainSourcesStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListMainSourcesResponseListMainSourcesStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListMainSourcesResponseListMainSourcesStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline uint16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (uint16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::string& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::string& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::string& elem2_);

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const char* elem2_);

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const char* value, size_t size);

    // API of field "elem3"

    static const int kElem3 = 2;

    /**
     * Clears the field "elem3".
     *
     * The field will be set to its default value. The hasElem3()
     * method will return false.
     */
    inline void clearElem3();

    /**
     * Checks whether the field "elem3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem3()). Otherwise it will return false.
     */
    inline bool hasElem3 () const;

    /**
     * Returns the value of the member "elem3".
     *
     * If the meaning of "elem3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem3"
     */
    inline const GetListMainSourcesResponseListMainSourcesElem3Struct& getElem3 () const;

    /**
     * Retrieves the value of the field "elem3" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem3".
     */
    inline GetListMainSourcesResponseListMainSourcesElem3Struct& getElem3Mutable ();

    /**
     * Sets the value of the member "elem3".
     *
     * If the meaning of "elem3" isn't clear, then there should be a description here.
     *
     * @param elem3 The value which will be set
     */
    inline void setElem3 (const GetListMainSourcesResponseListMainSourcesElem3Struct& elem3_);

    // API of field "elem4"

    static const int kElem4 = 3;

    /**
     * Clears the field "elem4".
     *
     * The field will be set to its default value. The hasElem4()
     * method will return false.
     */
    inline void clearElem4();

    /**
     * Checks whether the field "elem4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem4()). Otherwise it will return false.
     */
    inline bool hasElem4 () const;

    /**
     * Returns the value of the member "elem4".
     *
     * If the meaning of "elem4" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem4"
     */
    inline uint16 getElem4 () const;

    /**
     * Sets the value of the member "elem4".
     *
     * If the meaning of "elem4" isn't clear, then there should be a description here.
     *
     * @param elem4 The value which will be set
     */
    inline void setElem4 (uint16 elem4_);

    static const GetListMainSourcesResponseListMainSourcesStruct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    inline void set_has_elem3 ();

    inline void clear_has_elem3 ();

    inline void set_has_elem4 ();

    inline void clear_has_elem4 ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint16 _elem1;

    ::std::string _elem2;

    GetListMainSourcesResponseListMainSourcesElem3Struct _elem3;

    uint16 _elem4;

};

/**
 * If the meaning of "GetListMainSourcesResponse" isn't clear, then there should be a description here.
 */
class GetListMainSourcesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetListMainSourcesResponse ();

    /**
     * Copy constructor
     */
    inline  GetListMainSourcesResponse (const GetListMainSourcesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetListMainSourcesResponse (int16 result_, const ::std::vector< GetListMainSourcesResponseListMainSourcesStruct >& listMainSources_);

    /**
     * Destructor
     */
    inline virtual  ~GetListMainSourcesResponse();

    /**
     * Assignment operator
     */
    inline GetListMainSourcesResponse& operator = (const GetListMainSourcesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListMainSourcesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListMainSourcesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListMainSourcesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListMainSourcesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline int16 getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (int16 result_);

    // API of field "listMainSources"

    static const int kListMainSources = 1;

    /**
     * Clears the field "listMainSources".
     *
     * The field will be set to its default value. The hasListMainSources()
     * method will return false.
     */
    inline void clearListMainSources();

    /**
     * Checks whether the field "listMainSources" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListMainSources()). Otherwise it will return false.
     */
    inline bool hasListMainSources () const;

    /**
     * Returns the value of the member "listMainSources".
     *
     * If the meaning of "listMainSources" isn't clear, then there should be a description here.
     *
     * @return The value of the field "listMainSources"
     */
    inline const ::std::vector< GetListMainSourcesResponseListMainSourcesStruct >& getListMainSources () const;

    /**
     * Retrieves the value of the field "listMainSources" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "listMainSources".
     */
    inline ::std::vector< GetListMainSourcesResponseListMainSourcesStruct >& getListMainSourcesMutable ();

    /**
     * Sets the value of the member "listMainSources".
     *
     * If the meaning of "listMainSources" isn't clear, then there should be a description here.
     *
     * @param listMainSources The value which will be set
     */
    inline void setListMainSources (const ::std::vector< GetListMainSourcesResponseListMainSourcesStruct >& listMainSources_);

    static const GetListMainSourcesResponse &getDefaultInstance();

private:

    static const ::std::vector< GetListMainSourcesResponseListMainSourcesStruct >& getGetListMainSourcesResponseListMainSourcesStructList_DefaultInstance ();

    inline void set_has_result ();

    inline void clear_has_result ();

    inline void set_has_listMainSources ();

    inline void clear_has_listMainSources ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _result;

    ::std::vector< GetListMainSourcesResponseListMainSourcesStruct > _listMainSources;

};

/**
 * If the meaning of "GetListMainSinkSoundPropertiesRequest" isn't clear, then there should be a description here.
 */
class GetListMainSinkSoundPropertiesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetListMainSinkSoundPropertiesRequest ();

    /**
     * Copy constructor
     */
    inline  GetListMainSinkSoundPropertiesRequest (const GetListMainSinkSoundPropertiesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetListMainSinkSoundPropertiesRequest (uint16 sinkID_);

    /**
     * Destructor
     */
    inline virtual  ~GetListMainSinkSoundPropertiesRequest();

    /**
     * Assignment operator
     */
    inline GetListMainSinkSoundPropertiesRequest& operator = (const GetListMainSinkSoundPropertiesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListMainSinkSoundPropertiesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListMainSinkSoundPropertiesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListMainSinkSoundPropertiesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListMainSinkSoundPropertiesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sinkID"

    static const int kSinkID = 0;

    /**
     * Clears the field "sinkID".
     *
     * The field will be set to its default value. The hasSinkID()
     * method will return false.
     */
    inline void clearSinkID();

    /**
     * Checks whether the field "sinkID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSinkID()). Otherwise it will return false.
     */
    inline bool hasSinkID () const;

    /**
     * Returns the value of the member "sinkID".
     *
     * If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sinkID"
     */
    inline uint16 getSinkID () const;

    /**
     * Sets the value of the member "sinkID".
     *
     * If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @param sinkID The value which will be set
     */
    inline void setSinkID (uint16 sinkID_);

    static const GetListMainSinkSoundPropertiesRequest &getDefaultInstance();

private:

    inline void set_has_sinkID ();

    inline void clear_has_sinkID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _sinkID;

};

/**
 * If the meaning of "GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct" isn't clear, then there should be a description here.
 */
class GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct {
public:

    /**
     * Default constructor
     */
    inline  GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct ();

    /**
     * Copy constructor
     */
    inline  GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct (const GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct &rhs);

    /**
     * All fields constructor
     */
    inline  GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct (int16 elem1_, int16 elem2_);

    /**
     * Destructor
     */
    inline  ~GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct();

    /**
     * Assignment operator
     */
    inline GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct& operator = (const GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline int16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (int16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline int16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (int16 elem2_);

    static const GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _elem1;

    int16 _elem2;

};

/**
 * If the meaning of "GetListMainSinkSoundPropertiesResponse" isn't clear, then there should be a description here.
 */
class GetListMainSinkSoundPropertiesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetListMainSinkSoundPropertiesResponse ();

    /**
     * Copy constructor
     */
    inline  GetListMainSinkSoundPropertiesResponse (const GetListMainSinkSoundPropertiesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetListMainSinkSoundPropertiesResponse (int16 result_, const ::std::vector< GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct >& listSoundProperties_);

    /**
     * Destructor
     */
    inline virtual  ~GetListMainSinkSoundPropertiesResponse();

    /**
     * Assignment operator
     */
    inline GetListMainSinkSoundPropertiesResponse& operator = (const GetListMainSinkSoundPropertiesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListMainSinkSoundPropertiesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListMainSinkSoundPropertiesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListMainSinkSoundPropertiesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListMainSinkSoundPropertiesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline int16 getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (int16 result_);

    // API of field "listSoundProperties"

    static const int kListSoundProperties = 1;

    /**
     * Clears the field "listSoundProperties".
     *
     * The field will be set to its default value. The hasListSoundProperties()
     * method will return false.
     */
    inline void clearListSoundProperties();

    /**
     * Checks whether the field "listSoundProperties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListSoundProperties()). Otherwise it will return false.
     */
    inline bool hasListSoundProperties () const;

    /**
     * Returns the value of the member "listSoundProperties".
     *
     * If the meaning of "listSoundProperties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "listSoundProperties"
     */
    inline const ::std::vector< GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct >& getListSoundProperties () const;

    /**
     * Retrieves the value of the field "listSoundProperties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "listSoundProperties".
     */
    inline ::std::vector< GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct >& getListSoundPropertiesMutable ();

    /**
     * Sets the value of the member "listSoundProperties".
     *
     * If the meaning of "listSoundProperties" isn't clear, then there should be a description here.
     *
     * @param listSoundProperties The value which will be set
     */
    inline void setListSoundProperties (const ::std::vector< GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct >& listSoundProperties_);

    static const GetListMainSinkSoundPropertiesResponse &getDefaultInstance();

private:

    static const ::std::vector< GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct >& getGetListMainSinkSoundPropertiesResponseListSoundPropertiesStructList_DefaultInstance ();

    inline void set_has_result ();

    inline void clear_has_result ();

    inline void set_has_listSoundProperties ();

    inline void clear_has_listSoundProperties ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _result;

    ::std::vector< GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct > _listSoundProperties;

};

/**
 * If the meaning of "GetListMainSourceSoundPropertiesRequest" isn't clear, then there should be a description here.
 */
class GetListMainSourceSoundPropertiesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetListMainSourceSoundPropertiesRequest ();

    /**
     * Copy constructor
     */
    inline  GetListMainSourceSoundPropertiesRequest (const GetListMainSourceSoundPropertiesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetListMainSourceSoundPropertiesRequest (uint16 sourceID_);

    /**
     * Destructor
     */
    inline virtual  ~GetListMainSourceSoundPropertiesRequest();

    /**
     * Assignment operator
     */
    inline GetListMainSourceSoundPropertiesRequest& operator = (const GetListMainSourceSoundPropertiesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListMainSourceSoundPropertiesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListMainSourceSoundPropertiesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListMainSourceSoundPropertiesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListMainSourceSoundPropertiesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sourceID"

    static const int kSourceID = 0;

    /**
     * Clears the field "sourceID".
     *
     * The field will be set to its default value. The hasSourceID()
     * method will return false.
     */
    inline void clearSourceID();

    /**
     * Checks whether the field "sourceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceID()). Otherwise it will return false.
     */
    inline bool hasSourceID () const;

    /**
     * Returns the value of the member "sourceID".
     *
     * If the meaning of "sourceID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourceID"
     */
    inline uint16 getSourceID () const;

    /**
     * Sets the value of the member "sourceID".
     *
     * If the meaning of "sourceID" isn't clear, then there should be a description here.
     *
     * @param sourceID The value which will be set
     */
    inline void setSourceID (uint16 sourceID_);

    static const GetListMainSourceSoundPropertiesRequest &getDefaultInstance();

private:

    inline void set_has_sourceID ();

    inline void clear_has_sourceID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _sourceID;

};

/**
 * If the meaning of "GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct" isn't clear, then there should be a description here.
 */
class GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct {
public:

    /**
     * Default constructor
     */
    inline  GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct ();

    /**
     * Copy constructor
     */
    inline  GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct (const GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct &rhs);

    /**
     * All fields constructor
     */
    inline  GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct (int16 elem1_, int16 elem2_);

    /**
     * Destructor
     */
    inline  ~GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct();

    /**
     * Assignment operator
     */
    inline GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct& operator = (const GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline int16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (int16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline int16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (int16 elem2_);

    static const GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _elem1;

    int16 _elem2;

};

/**
 * If the meaning of "GetListMainSourceSoundPropertiesResponse" isn't clear, then there should be a description here.
 */
class GetListMainSourceSoundPropertiesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetListMainSourceSoundPropertiesResponse ();

    /**
     * Copy constructor
     */
    inline  GetListMainSourceSoundPropertiesResponse (const GetListMainSourceSoundPropertiesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetListMainSourceSoundPropertiesResponse (int16 result_, const ::std::vector< GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct >& listSourceProperties_);

    /**
     * Destructor
     */
    inline virtual  ~GetListMainSourceSoundPropertiesResponse();

    /**
     * Assignment operator
     */
    inline GetListMainSourceSoundPropertiesResponse& operator = (const GetListMainSourceSoundPropertiesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListMainSourceSoundPropertiesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListMainSourceSoundPropertiesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListMainSourceSoundPropertiesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListMainSourceSoundPropertiesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline int16 getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (int16 result_);

    // API of field "listSourceProperties"

    static const int kListSourceProperties = 1;

    /**
     * Clears the field "listSourceProperties".
     *
     * The field will be set to its default value. The hasListSourceProperties()
     * method will return false.
     */
    inline void clearListSourceProperties();

    /**
     * Checks whether the field "listSourceProperties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListSourceProperties()). Otherwise it will return false.
     */
    inline bool hasListSourceProperties () const;

    /**
     * Returns the value of the member "listSourceProperties".
     *
     * If the meaning of "listSourceProperties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "listSourceProperties"
     */
    inline const ::std::vector< GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct >& getListSourceProperties () const;

    /**
     * Retrieves the value of the field "listSourceProperties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "listSourceProperties".
     */
    inline ::std::vector< GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct >& getListSourcePropertiesMutable ();

    /**
     * Sets the value of the member "listSourceProperties".
     *
     * If the meaning of "listSourceProperties" isn't clear, then there should be a description here.
     *
     * @param listSourceProperties The value which will be set
     */
    inline void setListSourceProperties (const ::std::vector< GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct >& listSourceProperties_);

    static const GetListMainSourceSoundPropertiesResponse &getDefaultInstance();

private:

    static const ::std::vector< GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct >& getGetListMainSourceSoundPropertiesResponseListSourcePropertiesStructList_DefaultInstance ();

    inline void set_has_result ();

    inline void clear_has_result ();

    inline void set_has_listSourceProperties ();

    inline void clear_has_listSourceProperties ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _result;

    ::std::vector< GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct > _listSourceProperties;

};

/**
 * If the meaning of "GetListSourceClassesResponseListSourceClassesElem3Struct" isn't clear, then there should be a description here.
 */
class GetListSourceClassesResponseListSourceClassesElem3Struct {
public:

    /**
     * Default constructor
     */
    inline  GetListSourceClassesResponseListSourceClassesElem3Struct ();

    /**
     * Copy constructor
     */
    inline  GetListSourceClassesResponseListSourceClassesElem3Struct (const GetListSourceClassesResponseListSourceClassesElem3Struct &rhs);

    /**
     * All fields constructor
     */
    inline  GetListSourceClassesResponseListSourceClassesElem3Struct (int16 elem1_, int16 elem2_);

    /**
     * Destructor
     */
    inline  ~GetListSourceClassesResponseListSourceClassesElem3Struct();

    /**
     * Assignment operator
     */
    inline GetListSourceClassesResponseListSourceClassesElem3Struct& operator = (const GetListSourceClassesResponseListSourceClassesElem3Struct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListSourceClassesResponseListSourceClassesElem3Struct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListSourceClassesResponseListSourceClassesElem3Struct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListSourceClassesResponseListSourceClassesElem3Struct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListSourceClassesResponseListSourceClassesElem3Struct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline int16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (int16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline int16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (int16 elem2_);

    static const GetListSourceClassesResponseListSourceClassesElem3Struct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _elem1;

    int16 _elem2;

};

/**
 * If the meaning of "GetListSourceClassesResponseListSourceClassesStruct" isn't clear, then there should be a description here.
 */
class GetListSourceClassesResponseListSourceClassesStruct {
public:

    /**
     * Default constructor
     */
    inline  GetListSourceClassesResponseListSourceClassesStruct ();

    /**
     * Copy constructor
     */
    inline  GetListSourceClassesResponseListSourceClassesStruct (const GetListSourceClassesResponseListSourceClassesStruct &rhs);

    /**
     * All fields constructor
     */
    inline  GetListSourceClassesResponseListSourceClassesStruct (uint16 elem1_, const ::std::string& elem2_, const ::std::vector< GetListSourceClassesResponseListSourceClassesElem3Struct >& elem3_);

    /**
     * Destructor
     */
    inline  ~GetListSourceClassesResponseListSourceClassesStruct();

    /**
     * Assignment operator
     */
    inline GetListSourceClassesResponseListSourceClassesStruct& operator = (const GetListSourceClassesResponseListSourceClassesStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListSourceClassesResponseListSourceClassesStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListSourceClassesResponseListSourceClassesStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListSourceClassesResponseListSourceClassesStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListSourceClassesResponseListSourceClassesStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline uint16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (uint16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::string& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::string& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::string& elem2_);

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const char* elem2_);

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const char* value, size_t size);

    // API of field "elem3"

    static const int kElem3 = 2;

    /**
     * Clears the field "elem3".
     *
     * The field will be set to its default value. The hasElem3()
     * method will return false.
     */
    inline void clearElem3();

    /**
     * Checks whether the field "elem3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem3()). Otherwise it will return false.
     */
    inline bool hasElem3 () const;

    /**
     * Returns the value of the member "elem3".
     *
     * If the meaning of "elem3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem3"
     */
    inline const ::std::vector< GetListSourceClassesResponseListSourceClassesElem3Struct >& getElem3 () const;

    /**
     * Retrieves the value of the field "elem3" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem3".
     */
    inline ::std::vector< GetListSourceClassesResponseListSourceClassesElem3Struct >& getElem3Mutable ();

    /**
     * Sets the value of the member "elem3".
     *
     * If the meaning of "elem3" isn't clear, then there should be a description here.
     *
     * @param elem3 The value which will be set
     */
    inline void setElem3 (const ::std::vector< GetListSourceClassesResponseListSourceClassesElem3Struct >& elem3_);

    static const GetListSourceClassesResponseListSourceClassesStruct &getDefaultInstance();

private:

    static const ::std::vector< GetListSourceClassesResponseListSourceClassesElem3Struct >& getGetListSourceClassesResponseListSourceClassesElem3StructList_DefaultInstance ();

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    inline void set_has_elem3 ();

    inline void clear_has_elem3 ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _elem1;

    ::std::string _elem2;

    ::std::vector< GetListSourceClassesResponseListSourceClassesElem3Struct > _elem3;

};

/**
 * If the meaning of "GetListSourceClassesResponse" isn't clear, then there should be a description here.
 */
class GetListSourceClassesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetListSourceClassesResponse ();

    /**
     * Copy constructor
     */
    inline  GetListSourceClassesResponse (const GetListSourceClassesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetListSourceClassesResponse (int16 result_, const ::std::vector< GetListSourceClassesResponseListSourceClassesStruct >& listSourceClasses_);

    /**
     * Destructor
     */
    inline virtual  ~GetListSourceClassesResponse();

    /**
     * Assignment operator
     */
    inline GetListSourceClassesResponse& operator = (const GetListSourceClassesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListSourceClassesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListSourceClassesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListSourceClassesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListSourceClassesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline int16 getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (int16 result_);

    // API of field "listSourceClasses"

    static const int kListSourceClasses = 1;

    /**
     * Clears the field "listSourceClasses".
     *
     * The field will be set to its default value. The hasListSourceClasses()
     * method will return false.
     */
    inline void clearListSourceClasses();

    /**
     * Checks whether the field "listSourceClasses" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListSourceClasses()). Otherwise it will return false.
     */
    inline bool hasListSourceClasses () const;

    /**
     * Returns the value of the member "listSourceClasses".
     *
     * If the meaning of "listSourceClasses" isn't clear, then there should be a description here.
     *
     * @return The value of the field "listSourceClasses"
     */
    inline const ::std::vector< GetListSourceClassesResponseListSourceClassesStruct >& getListSourceClasses () const;

    /**
     * Retrieves the value of the field "listSourceClasses" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "listSourceClasses".
     */
    inline ::std::vector< GetListSourceClassesResponseListSourceClassesStruct >& getListSourceClassesMutable ();

    /**
     * Sets the value of the member "listSourceClasses".
     *
     * If the meaning of "listSourceClasses" isn't clear, then there should be a description here.
     *
     * @param listSourceClasses The value which will be set
     */
    inline void setListSourceClasses (const ::std::vector< GetListSourceClassesResponseListSourceClassesStruct >& listSourceClasses_);

    static const GetListSourceClassesResponse &getDefaultInstance();

private:

    static const ::std::vector< GetListSourceClassesResponseListSourceClassesStruct >& getGetListSourceClassesResponseListSourceClassesStructList_DefaultInstance ();

    inline void set_has_result ();

    inline void clear_has_result ();

    inline void set_has_listSourceClasses ();

    inline void clear_has_listSourceClasses ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _result;

    ::std::vector< GetListSourceClassesResponseListSourceClassesStruct > _listSourceClasses;

};

/**
 * If the meaning of "GetListSinkClassesResponseListSinkClassesElem3Struct" isn't clear, then there should be a description here.
 */
class GetListSinkClassesResponseListSinkClassesElem3Struct {
public:

    /**
     * Default constructor
     */
    inline  GetListSinkClassesResponseListSinkClassesElem3Struct ();

    /**
     * Copy constructor
     */
    inline  GetListSinkClassesResponseListSinkClassesElem3Struct (const GetListSinkClassesResponseListSinkClassesElem3Struct &rhs);

    /**
     * All fields constructor
     */
    inline  GetListSinkClassesResponseListSinkClassesElem3Struct (int16 elem1_, int16 elem2_);

    /**
     * Destructor
     */
    inline  ~GetListSinkClassesResponseListSinkClassesElem3Struct();

    /**
     * Assignment operator
     */
    inline GetListSinkClassesResponseListSinkClassesElem3Struct& operator = (const GetListSinkClassesResponseListSinkClassesElem3Struct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListSinkClassesResponseListSinkClassesElem3Struct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListSinkClassesResponseListSinkClassesElem3Struct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListSinkClassesResponseListSinkClassesElem3Struct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListSinkClassesResponseListSinkClassesElem3Struct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline int16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (int16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline int16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (int16 elem2_);

    static const GetListSinkClassesResponseListSinkClassesElem3Struct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _elem1;

    int16 _elem2;

};

/**
 * If the meaning of "GetListSinkClassesResponseListSinkClassesStruct" isn't clear, then there should be a description here.
 */
class GetListSinkClassesResponseListSinkClassesStruct {
public:

    /**
     * Default constructor
     */
    inline  GetListSinkClassesResponseListSinkClassesStruct ();

    /**
     * Copy constructor
     */
    inline  GetListSinkClassesResponseListSinkClassesStruct (const GetListSinkClassesResponseListSinkClassesStruct &rhs);

    /**
     * All fields constructor
     */
    inline  GetListSinkClassesResponseListSinkClassesStruct (uint16 elem1_, const ::std::string& elem2_, const ::std::vector< GetListSinkClassesResponseListSinkClassesElem3Struct >& elem3_);

    /**
     * Destructor
     */
    inline  ~GetListSinkClassesResponseListSinkClassesStruct();

    /**
     * Assignment operator
     */
    inline GetListSinkClassesResponseListSinkClassesStruct& operator = (const GetListSinkClassesResponseListSinkClassesStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListSinkClassesResponseListSinkClassesStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListSinkClassesResponseListSinkClassesStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListSinkClassesResponseListSinkClassesStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListSinkClassesResponseListSinkClassesStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline uint16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (uint16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::string& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::string& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::string& elem2_);

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const char* elem2_);

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const char* value, size_t size);

    // API of field "elem3"

    static const int kElem3 = 2;

    /**
     * Clears the field "elem3".
     *
     * The field will be set to its default value. The hasElem3()
     * method will return false.
     */
    inline void clearElem3();

    /**
     * Checks whether the field "elem3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem3()). Otherwise it will return false.
     */
    inline bool hasElem3 () const;

    /**
     * Returns the value of the member "elem3".
     *
     * If the meaning of "elem3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem3"
     */
    inline const ::std::vector< GetListSinkClassesResponseListSinkClassesElem3Struct >& getElem3 () const;

    /**
     * Retrieves the value of the field "elem3" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem3".
     */
    inline ::std::vector< GetListSinkClassesResponseListSinkClassesElem3Struct >& getElem3Mutable ();

    /**
     * Sets the value of the member "elem3".
     *
     * If the meaning of "elem3" isn't clear, then there should be a description here.
     *
     * @param elem3 The value which will be set
     */
    inline void setElem3 (const ::std::vector< GetListSinkClassesResponseListSinkClassesElem3Struct >& elem3_);

    static const GetListSinkClassesResponseListSinkClassesStruct &getDefaultInstance();

private:

    static const ::std::vector< GetListSinkClassesResponseListSinkClassesElem3Struct >& getGetListSinkClassesResponseListSinkClassesElem3StructList_DefaultInstance ();

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    inline void set_has_elem3 ();

    inline void clear_has_elem3 ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _elem1;

    ::std::string _elem2;

    ::std::vector< GetListSinkClassesResponseListSinkClassesElem3Struct > _elem3;

};

/**
 * If the meaning of "GetListSinkClassesResponse" isn't clear, then there should be a description here.
 */
class GetListSinkClassesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetListSinkClassesResponse ();

    /**
     * Copy constructor
     */
    inline  GetListSinkClassesResponse (const GetListSinkClassesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetListSinkClassesResponse (int16 result_, const ::std::vector< GetListSinkClassesResponseListSinkClassesStruct >& listSinkClasses_);

    /**
     * Destructor
     */
    inline virtual  ~GetListSinkClassesResponse();

    /**
     * Assignment operator
     */
    inline GetListSinkClassesResponse& operator = (const GetListSinkClassesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListSinkClassesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListSinkClassesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListSinkClassesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListSinkClassesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline int16 getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (int16 result_);

    // API of field "listSinkClasses"

    static const int kListSinkClasses = 1;

    /**
     * Clears the field "listSinkClasses".
     *
     * The field will be set to its default value. The hasListSinkClasses()
     * method will return false.
     */
    inline void clearListSinkClasses();

    /**
     * Checks whether the field "listSinkClasses" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListSinkClasses()). Otherwise it will return false.
     */
    inline bool hasListSinkClasses () const;

    /**
     * Returns the value of the member "listSinkClasses".
     *
     * If the meaning of "listSinkClasses" isn't clear, then there should be a description here.
     *
     * @return The value of the field "listSinkClasses"
     */
    inline const ::std::vector< GetListSinkClassesResponseListSinkClassesStruct >& getListSinkClasses () const;

    /**
     * Retrieves the value of the field "listSinkClasses" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "listSinkClasses".
     */
    inline ::std::vector< GetListSinkClassesResponseListSinkClassesStruct >& getListSinkClassesMutable ();

    /**
     * Sets the value of the member "listSinkClasses".
     *
     * If the meaning of "listSinkClasses" isn't clear, then there should be a description here.
     *
     * @param listSinkClasses The value which will be set
     */
    inline void setListSinkClasses (const ::std::vector< GetListSinkClassesResponseListSinkClassesStruct >& listSinkClasses_);

    static const GetListSinkClassesResponse &getDefaultInstance();

private:

    static const ::std::vector< GetListSinkClassesResponseListSinkClassesStruct >& getGetListSinkClassesResponseListSinkClassesStructList_DefaultInstance ();

    inline void set_has_result ();

    inline void clear_has_result ();

    inline void set_has_listSinkClasses ();

    inline void clear_has_listSinkClasses ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _result;

    ::std::vector< GetListSinkClassesResponseListSinkClassesStruct > _listSinkClasses;

};

/**
 * If the meaning of "GetListSystemPropertiesRequestListSystemPropertiesStruct" isn't clear, then there should be a description here.
 */
class GetListSystemPropertiesRequestListSystemPropertiesStruct {
public:

    /**
     * Default constructor
     */
    inline  GetListSystemPropertiesRequestListSystemPropertiesStruct ();

    /**
     * Copy constructor
     */
    inline  GetListSystemPropertiesRequestListSystemPropertiesStruct (const GetListSystemPropertiesRequestListSystemPropertiesStruct &rhs);

    /**
     * All fields constructor
     */
    inline  GetListSystemPropertiesRequestListSystemPropertiesStruct (int16 elem1_, int16 elem2_);

    /**
     * Destructor
     */
    inline  ~GetListSystemPropertiesRequestListSystemPropertiesStruct();

    /**
     * Assignment operator
     */
    inline GetListSystemPropertiesRequestListSystemPropertiesStruct& operator = (const GetListSystemPropertiesRequestListSystemPropertiesStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListSystemPropertiesRequestListSystemPropertiesStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListSystemPropertiesRequestListSystemPropertiesStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListSystemPropertiesRequestListSystemPropertiesStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListSystemPropertiesRequestListSystemPropertiesStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline int16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (int16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline int16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (int16 elem2_);

    static const GetListSystemPropertiesRequestListSystemPropertiesStruct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _elem1;

    int16 _elem2;

};

/**
 * If the meaning of "GetListSystemPropertiesRequest" isn't clear, then there should be a description here.
 */
class GetListSystemPropertiesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetListSystemPropertiesRequest ();

    /**
     * Copy constructor
     */
    inline  GetListSystemPropertiesRequest (const GetListSystemPropertiesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetListSystemPropertiesRequest (const ::std::vector< GetListSystemPropertiesRequestListSystemPropertiesStruct >& listSystemProperties_);

    /**
     * Destructor
     */
    inline virtual  ~GetListSystemPropertiesRequest();

    /**
     * Assignment operator
     */
    inline GetListSystemPropertiesRequest& operator = (const GetListSystemPropertiesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListSystemPropertiesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListSystemPropertiesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListSystemPropertiesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListSystemPropertiesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "listSystemProperties"

    static const int kListSystemProperties = 0;

    /**
     * Clears the field "listSystemProperties".
     *
     * The field will be set to its default value. The hasListSystemProperties()
     * method will return false.
     */
    inline void clearListSystemProperties();

    /**
     * Checks whether the field "listSystemProperties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListSystemProperties()). Otherwise it will return false.
     */
    inline bool hasListSystemProperties () const;

    /**
     * Returns the value of the member "listSystemProperties".
     *
     * If the meaning of "listSystemProperties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "listSystemProperties"
     */
    inline const ::std::vector< GetListSystemPropertiesRequestListSystemPropertiesStruct >& getListSystemProperties () const;

    /**
     * Retrieves the value of the field "listSystemProperties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "listSystemProperties".
     */
    inline ::std::vector< GetListSystemPropertiesRequestListSystemPropertiesStruct >& getListSystemPropertiesMutable ();

    /**
     * Sets the value of the member "listSystemProperties".
     *
     * If the meaning of "listSystemProperties" isn't clear, then there should be a description here.
     *
     * @param listSystemProperties The value which will be set
     */
    inline void setListSystemProperties (const ::std::vector< GetListSystemPropertiesRequestListSystemPropertiesStruct >& listSystemProperties_);

    static const GetListSystemPropertiesRequest &getDefaultInstance();

private:

    static const ::std::vector< GetListSystemPropertiesRequestListSystemPropertiesStruct >& getGetListSystemPropertiesRequestListSystemPropertiesStructList_DefaultInstance ();

    inline void set_has_listSystemProperties ();

    inline void clear_has_listSystemProperties ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< GetListSystemPropertiesRequestListSystemPropertiesStruct > _listSystemProperties;

};

/**
 * If the meaning of "GetListSystemPropertiesResponse" isn't clear, then there should be a description here.
 */
class GetListSystemPropertiesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetListSystemPropertiesResponse ();

    /**
     * Copy constructor
     */
    inline  GetListSystemPropertiesResponse (const GetListSystemPropertiesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetListSystemPropertiesResponse (int16 result_);

    /**
     * Destructor
     */
    inline virtual  ~GetListSystemPropertiesResponse();

    /**
     * Assignment operator
     */
    inline GetListSystemPropertiesResponse& operator = (const GetListSystemPropertiesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetListSystemPropertiesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetListSystemPropertiesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetListSystemPropertiesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetListSystemPropertiesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline int16 getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (int16 result_);

    static const GetListSystemPropertiesResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int16 _result;

};

/**
 * If the meaning of "GetTimingInformationRequest" isn't clear, then there should be a description here.
 */
class GetTimingInformationRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetTimingInformationRequest ();

    /**
     * Copy constructor
     */
    inline  GetTimingInformationRequest (const GetTimingInformationRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetTimingInformationRequest (uint16 mainConnectionID_);

    /**
     * Destructor
     */
    inline virtual  ~GetTimingInformationRequest();

    /**
     * Assignment operator
     */
    inline GetTimingInformationRequest& operator = (const GetTimingInformationRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTimingInformationRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTimingInformationRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTimingInformationRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTimingInformationRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "mainConnectionID"

    static const int kMainConnectionID = 0;

    /**
     * Clears the field "mainConnectionID".
     *
     * The field will be set to its default value. The hasMainConnectionID()
     * method will return false.
     */
    inline void clearMainConnectionID();

    /**
     * Checks whether the field "mainConnectionID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMainConnectionID()). Otherwise it will return false.
     */
    inline bool hasMainConnectionID () const;

    /**
     * Returns the value of the member "mainConnectionID".
     *
     * If the meaning of "mainConnectionID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mainConnectionID"
     */
    inline uint16 getMainConnectionID () const;

    /**
     * Sets the value of the member "mainConnectionID".
     *
     * If the meaning of "mainConnectionID" isn't clear, then there should be a description here.
     *
     * @param mainConnectionID The value which will be set
     */
    inline void setMainConnectionID (uint16 mainConnectionID_);

    static const GetTimingInformationRequest &getDefaultInstance();

private:

    inline void set_has_mainConnectionID ();

    inline void clear_has_mainConnectionID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _mainConnectionID;

};

/**
 * If the meaning of "GetTimingInformationResponse" isn't clear, then there should be a description here.
 */
class GetTimingInformationResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetTimingInformationResponse ();

    /**
     * Copy constructor
     */
    inline  GetTimingInformationResponse (const GetTimingInformationResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetTimingInformationResponse (int16 result_, int16 delay_);

    /**
     * Destructor
     */
    inline virtual  ~GetTimingInformationResponse();

    /**
     * Assignment operator
     */
    inline GetTimingInformationResponse& operator = (const GetTimingInformationResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTimingInformationResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTimingInformationResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTimingInformationResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTimingInformationResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline int16 getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (int16 result_);

    // API of field "delay"

    static const int kDelay = 1;

    /**
     * Clears the field "delay".
     *
     * The field will be set to its default value. The hasDelay()
     * method will return false.
     */
    inline void clearDelay();

    /**
     * Checks whether the field "delay" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDelay()). Otherwise it will return false.
     */
    inline bool hasDelay () const;

    /**
     * Returns the value of the member "delay".
     *
     * If the meaning of "delay" isn't clear, then there should be a description here.
     *
     * @return The value of the field "delay"
     */
    inline int16 getDelay () const;

    /**
     * Sets the value of the member "delay".
     *
     * If the meaning of "delay" isn't clear, then there should be a description here.
     *
     * @param delay The value which will be set
     */
    inline void setDelay (int16 delay_);

    static const GetTimingInformationResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    inline void set_has_delay ();

    inline void clear_has_delay ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _result;

    int16 _delay;

};

/**
 * If the meaning of "SinkAddedSignalNewSinkElem3Struct" isn't clear, then there should be a description here.
 */
class SinkAddedSignalNewSinkElem3Struct {
public:

    /**
     * Default constructor
     */
    inline  SinkAddedSignalNewSinkElem3Struct ();

    /**
     * Copy constructor
     */
    inline  SinkAddedSignalNewSinkElem3Struct (const SinkAddedSignalNewSinkElem3Struct &rhs);

    /**
     * All fields constructor
     */
    inline  SinkAddedSignalNewSinkElem3Struct (int16 elem1_, int16 elem2_);

    /**
     * Destructor
     */
    inline  ~SinkAddedSignalNewSinkElem3Struct();

    /**
     * Assignment operator
     */
    inline SinkAddedSignalNewSinkElem3Struct& operator = (const SinkAddedSignalNewSinkElem3Struct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SinkAddedSignalNewSinkElem3Struct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SinkAddedSignalNewSinkElem3Struct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SinkAddedSignalNewSinkElem3Struct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SinkAddedSignalNewSinkElem3Struct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline int16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (int16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline int16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (int16 elem2_);

    static const SinkAddedSignalNewSinkElem3Struct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _elem1;

    int16 _elem2;

};

/**
 * If the meaning of "SinkAddedSignalNewSinkStruct" isn't clear, then there should be a description here.
 */
class SinkAddedSignalNewSinkStruct {
public:

    /**
     * Default constructor
     */
    inline  SinkAddedSignalNewSinkStruct ();

    /**
     * Copy constructor
     */
    inline  SinkAddedSignalNewSinkStruct (const SinkAddedSignalNewSinkStruct &rhs);

    /**
     * All fields constructor
     */
    inline  SinkAddedSignalNewSinkStruct (uint16 elem1_, const ::std::string& elem2_, const SinkAddedSignalNewSinkElem3Struct& elem3_, int16 elem4_, int16 elem5_, uint16 elem6_);

    /**
     * Destructor
     */
    inline  ~SinkAddedSignalNewSinkStruct();

    /**
     * Assignment operator
     */
    inline SinkAddedSignalNewSinkStruct& operator = (const SinkAddedSignalNewSinkStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SinkAddedSignalNewSinkStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SinkAddedSignalNewSinkStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SinkAddedSignalNewSinkStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SinkAddedSignalNewSinkStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline uint16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (uint16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::string& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::string& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::string& elem2_);

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const char* elem2_);

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const char* value, size_t size);

    // API of field "elem3"

    static const int kElem3 = 2;

    /**
     * Clears the field "elem3".
     *
     * The field will be set to its default value. The hasElem3()
     * method will return false.
     */
    inline void clearElem3();

    /**
     * Checks whether the field "elem3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem3()). Otherwise it will return false.
     */
    inline bool hasElem3 () const;

    /**
     * Returns the value of the member "elem3".
     *
     * If the meaning of "elem3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem3"
     */
    inline const SinkAddedSignalNewSinkElem3Struct& getElem3 () const;

    /**
     * Retrieves the value of the field "elem3" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem3".
     */
    inline SinkAddedSignalNewSinkElem3Struct& getElem3Mutable ();

    /**
     * Sets the value of the member "elem3".
     *
     * If the meaning of "elem3" isn't clear, then there should be a description here.
     *
     * @param elem3 The value which will be set
     */
    inline void setElem3 (const SinkAddedSignalNewSinkElem3Struct& elem3_);

    // API of field "elem4"

    static const int kElem4 = 3;

    /**
     * Clears the field "elem4".
     *
     * The field will be set to its default value. The hasElem4()
     * method will return false.
     */
    inline void clearElem4();

    /**
     * Checks whether the field "elem4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem4()). Otherwise it will return false.
     */
    inline bool hasElem4 () const;

    /**
     * Returns the value of the member "elem4".
     *
     * If the meaning of "elem4" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem4"
     */
    inline int16 getElem4 () const;

    /**
     * Sets the value of the member "elem4".
     *
     * If the meaning of "elem4" isn't clear, then there should be a description here.
     *
     * @param elem4 The value which will be set
     */
    inline void setElem4 (int16 elem4_);

    // API of field "elem5"

    static const int kElem5 = 4;

    /**
     * Clears the field "elem5".
     *
     * The field will be set to its default value. The hasElem5()
     * method will return false.
     */
    inline void clearElem5();

    /**
     * Checks whether the field "elem5" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem5()). Otherwise it will return false.
     */
    inline bool hasElem5 () const;

    /**
     * Returns the value of the member "elem5".
     *
     * If the meaning of "elem5" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem5"
     */
    inline int16 getElem5 () const;

    /**
     * Sets the value of the member "elem5".
     *
     * If the meaning of "elem5" isn't clear, then there should be a description here.
     *
     * @param elem5 The value which will be set
     */
    inline void setElem5 (int16 elem5_);

    // API of field "elem6"

    static const int kElem6 = 5;

    /**
     * Clears the field "elem6".
     *
     * The field will be set to its default value. The hasElem6()
     * method will return false.
     */
    inline void clearElem6();

    /**
     * Checks whether the field "elem6" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem6()). Otherwise it will return false.
     */
    inline bool hasElem6 () const;

    /**
     * Returns the value of the member "elem6".
     *
     * If the meaning of "elem6" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem6"
     */
    inline uint16 getElem6 () const;

    /**
     * Sets the value of the member "elem6".
     *
     * If the meaning of "elem6" isn't clear, then there should be a description here.
     *
     * @param elem6 The value which will be set
     */
    inline void setElem6 (uint16 elem6_);

    static const SinkAddedSignalNewSinkStruct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    inline void set_has_elem3 ();

    inline void clear_has_elem3 ();

    inline void set_has_elem4 ();

    inline void clear_has_elem4 ();

    inline void set_has_elem5 ();

    inline void clear_has_elem5 ();

    inline void set_has_elem6 ();

    inline void clear_has_elem6 ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint16 _elem1;

    ::std::string _elem2;

    SinkAddedSignalNewSinkElem3Struct _elem3;

    int16 _elem4;

    int16 _elem5;

    uint16 _elem6;

};

/**
 * If the meaning of "SinkAddedSignal" isn't clear, then there should be a description here.
 */
class SinkAddedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SinkAddedSignal ();

    /**
     * Copy constructor
     */
    inline  SinkAddedSignal (const SinkAddedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SinkAddedSignal (const SinkAddedSignalNewSinkStruct& newSink_);

    /**
     * Destructor
     */
    inline virtual  ~SinkAddedSignal();

    /**
     * Assignment operator
     */
    inline SinkAddedSignal& operator = (const SinkAddedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SinkAddedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SinkAddedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SinkAddedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SinkAddedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "newSink"

    static const int kNewSink = 0;

    /**
     * Clears the field "newSink".
     *
     * The field will be set to its default value. The hasNewSink()
     * method will return false.
     */
    inline void clearNewSink();

    /**
     * Checks whether the field "newSink" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNewSink()). Otherwise it will return false.
     */
    inline bool hasNewSink () const;

    /**
     * Returns the value of the member "newSink".
     *
     * If the meaning of "newSink" isn't clear, then there should be a description here.
     *
     * @return The value of the field "newSink"
     */
    inline const SinkAddedSignalNewSinkStruct& getNewSink () const;

    /**
     * Retrieves the value of the field "newSink" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "newSink".
     */
    inline SinkAddedSignalNewSinkStruct& getNewSinkMutable ();

    /**
     * Sets the value of the member "newSink".
     *
     * If the meaning of "newSink" isn't clear, then there should be a description here.
     *
     * @param newSink The value which will be set
     */
    inline void setNewSink (const SinkAddedSignalNewSinkStruct& newSink_);

    static const SinkAddedSignal &getDefaultInstance();

private:

    inline void set_has_newSink ();

    inline void clear_has_newSink ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SinkAddedSignalNewSinkStruct _newSink;

};

/**
 * If the meaning of "SinkRemovedSignal" isn't clear, then there should be a description here.
 */
class SinkRemovedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SinkRemovedSignal ();

    /**
     * Copy constructor
     */
    inline  SinkRemovedSignal (const SinkRemovedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SinkRemovedSignal (uint16 removedSinkID_);

    /**
     * Destructor
     */
    inline virtual  ~SinkRemovedSignal();

    /**
     * Assignment operator
     */
    inline SinkRemovedSignal& operator = (const SinkRemovedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SinkRemovedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SinkRemovedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SinkRemovedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SinkRemovedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "removedSinkID"

    static const int kRemovedSinkID = 0;

    /**
     * Clears the field "removedSinkID".
     *
     * The field will be set to its default value. The hasRemovedSinkID()
     * method will return false.
     */
    inline void clearRemovedSinkID();

    /**
     * Checks whether the field "removedSinkID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRemovedSinkID()). Otherwise it will return false.
     */
    inline bool hasRemovedSinkID () const;

    /**
     * Returns the value of the member "removedSinkID".
     *
     * If the meaning of "removedSinkID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "removedSinkID"
     */
    inline uint16 getRemovedSinkID () const;

    /**
     * Sets the value of the member "removedSinkID".
     *
     * If the meaning of "removedSinkID" isn't clear, then there should be a description here.
     *
     * @param removedSinkID The value which will be set
     */
    inline void setRemovedSinkID (uint16 removedSinkID_);

    static const SinkRemovedSignal &getDefaultInstance();

private:

    inline void set_has_removedSinkID ();

    inline void clear_has_removedSinkID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _removedSinkID;

};

/**
 * If the meaning of "SourceAddedSignalNewSourceElem3Struct" isn't clear, then there should be a description here.
 */
class SourceAddedSignalNewSourceElem3Struct {
public:

    /**
     * Default constructor
     */
    inline  SourceAddedSignalNewSourceElem3Struct ();

    /**
     * Copy constructor
     */
    inline  SourceAddedSignalNewSourceElem3Struct (const SourceAddedSignalNewSourceElem3Struct &rhs);

    /**
     * All fields constructor
     */
    inline  SourceAddedSignalNewSourceElem3Struct (int16 elem1_, int16 elem2_);

    /**
     * Destructor
     */
    inline  ~SourceAddedSignalNewSourceElem3Struct();

    /**
     * Assignment operator
     */
    inline SourceAddedSignalNewSourceElem3Struct& operator = (const SourceAddedSignalNewSourceElem3Struct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceAddedSignalNewSourceElem3Struct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceAddedSignalNewSourceElem3Struct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceAddedSignalNewSourceElem3Struct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceAddedSignalNewSourceElem3Struct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline int16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (int16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline int16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (int16 elem2_);

    static const SourceAddedSignalNewSourceElem3Struct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _elem1;

    int16 _elem2;

};

/**
 * If the meaning of "SourceAddedSignalNewSourceStruct" isn't clear, then there should be a description here.
 */
class SourceAddedSignalNewSourceStruct {
public:

    /**
     * Default constructor
     */
    inline  SourceAddedSignalNewSourceStruct ();

    /**
     * Copy constructor
     */
    inline  SourceAddedSignalNewSourceStruct (const SourceAddedSignalNewSourceStruct &rhs);

    /**
     * All fields constructor
     */
    inline  SourceAddedSignalNewSourceStruct (uint16 elem1_, const ::std::string& elem2_, const SourceAddedSignalNewSourceElem3Struct& elem3_, uint16 elem4_);

    /**
     * Destructor
     */
    inline  ~SourceAddedSignalNewSourceStruct();

    /**
     * Assignment operator
     */
    inline SourceAddedSignalNewSourceStruct& operator = (const SourceAddedSignalNewSourceStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceAddedSignalNewSourceStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceAddedSignalNewSourceStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceAddedSignalNewSourceStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceAddedSignalNewSourceStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline uint16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (uint16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::string& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::string& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::string& elem2_);

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const char* elem2_);

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const char* value, size_t size);

    // API of field "elem3"

    static const int kElem3 = 2;

    /**
     * Clears the field "elem3".
     *
     * The field will be set to its default value. The hasElem3()
     * method will return false.
     */
    inline void clearElem3();

    /**
     * Checks whether the field "elem3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem3()). Otherwise it will return false.
     */
    inline bool hasElem3 () const;

    /**
     * Returns the value of the member "elem3".
     *
     * If the meaning of "elem3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem3"
     */
    inline const SourceAddedSignalNewSourceElem3Struct& getElem3 () const;

    /**
     * Retrieves the value of the field "elem3" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem3".
     */
    inline SourceAddedSignalNewSourceElem3Struct& getElem3Mutable ();

    /**
     * Sets the value of the member "elem3".
     *
     * If the meaning of "elem3" isn't clear, then there should be a description here.
     *
     * @param elem3 The value which will be set
     */
    inline void setElem3 (const SourceAddedSignalNewSourceElem3Struct& elem3_);

    // API of field "elem4"

    static const int kElem4 = 3;

    /**
     * Clears the field "elem4".
     *
     * The field will be set to its default value. The hasElem4()
     * method will return false.
     */
    inline void clearElem4();

    /**
     * Checks whether the field "elem4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem4()). Otherwise it will return false.
     */
    inline bool hasElem4 () const;

    /**
     * Returns the value of the member "elem4".
     *
     * If the meaning of "elem4" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem4"
     */
    inline uint16 getElem4 () const;

    /**
     * Sets the value of the member "elem4".
     *
     * If the meaning of "elem4" isn't clear, then there should be a description here.
     *
     * @param elem4 The value which will be set
     */
    inline void setElem4 (uint16 elem4_);

    static const SourceAddedSignalNewSourceStruct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    inline void set_has_elem3 ();

    inline void clear_has_elem3 ();

    inline void set_has_elem4 ();

    inline void clear_has_elem4 ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint16 _elem1;

    ::std::string _elem2;

    SourceAddedSignalNewSourceElem3Struct _elem3;

    uint16 _elem4;

};

/**
 * If the meaning of "SourceAddedSignal" isn't clear, then there should be a description here.
 */
class SourceAddedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourceAddedSignal ();

    /**
     * Copy constructor
     */
    inline  SourceAddedSignal (const SourceAddedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SourceAddedSignal (const SourceAddedSignalNewSourceStruct& newSource_);

    /**
     * Destructor
     */
    inline virtual  ~SourceAddedSignal();

    /**
     * Assignment operator
     */
    inline SourceAddedSignal& operator = (const SourceAddedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceAddedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceAddedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceAddedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceAddedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "newSource"

    static const int kNewSource = 0;

    /**
     * Clears the field "newSource".
     *
     * The field will be set to its default value. The hasNewSource()
     * method will return false.
     */
    inline void clearNewSource();

    /**
     * Checks whether the field "newSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNewSource()). Otherwise it will return false.
     */
    inline bool hasNewSource () const;

    /**
     * Returns the value of the member "newSource".
     *
     * If the meaning of "newSource" isn't clear, then there should be a description here.
     *
     * @return The value of the field "newSource"
     */
    inline const SourceAddedSignalNewSourceStruct& getNewSource () const;

    /**
     * Retrieves the value of the field "newSource" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "newSource".
     */
    inline SourceAddedSignalNewSourceStruct& getNewSourceMutable ();

    /**
     * Sets the value of the member "newSource".
     *
     * If the meaning of "newSource" isn't clear, then there should be a description here.
     *
     * @param newSource The value which will be set
     */
    inline void setNewSource (const SourceAddedSignalNewSourceStruct& newSource_);

    static const SourceAddedSignal &getDefaultInstance();

private:

    inline void set_has_newSource ();

    inline void clear_has_newSource ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SourceAddedSignalNewSourceStruct _newSource;

};

/**
 * If the meaning of "SourceRemovedSignal" isn't clear, then there should be a description here.
 */
class SourceRemovedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourceRemovedSignal ();

    /**
     * Copy constructor
     */
    inline  SourceRemovedSignal (const SourceRemovedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SourceRemovedSignal (uint16 removedSourceID_);

    /**
     * Destructor
     */
    inline virtual  ~SourceRemovedSignal();

    /**
     * Assignment operator
     */
    inline SourceRemovedSignal& operator = (const SourceRemovedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceRemovedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceRemovedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceRemovedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceRemovedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "removedSourceID"

    static const int kRemovedSourceID = 0;

    /**
     * Clears the field "removedSourceID".
     *
     * The field will be set to its default value. The hasRemovedSourceID()
     * method will return false.
     */
    inline void clearRemovedSourceID();

    /**
     * Checks whether the field "removedSourceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRemovedSourceID()). Otherwise it will return false.
     */
    inline bool hasRemovedSourceID () const;

    /**
     * Returns the value of the member "removedSourceID".
     *
     * If the meaning of "removedSourceID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "removedSourceID"
     */
    inline uint16 getRemovedSourceID () const;

    /**
     * Sets the value of the member "removedSourceID".
     *
     * If the meaning of "removedSourceID" isn't clear, then there should be a description here.
     *
     * @param removedSourceID The value which will be set
     */
    inline void setRemovedSourceID (uint16 removedSourceID_);

    static const SourceRemovedSignal &getDefaultInstance();

private:

    inline void set_has_removedSourceID ();

    inline void clear_has_removedSourceID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _removedSourceID;

};

/**
 * If the meaning of "MainConnectionStateChangedSignal" isn't clear, then there should be a description here.
 */
class MainConnectionStateChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MainConnectionStateChangedSignal ();

    /**
     * Copy constructor
     */
    inline  MainConnectionStateChangedSignal (const MainConnectionStateChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  MainConnectionStateChangedSignal (uint16 connectionID_, int16 connectionState_);

    /**
     * Destructor
     */
    inline virtual  ~MainConnectionStateChangedSignal();

    /**
     * Assignment operator
     */
    inline MainConnectionStateChangedSignal& operator = (const MainConnectionStateChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MainConnectionStateChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MainConnectionStateChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MainConnectionStateChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MainConnectionStateChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "connectionID"

    static const int kConnectionID = 0;

    /**
     * Clears the field "connectionID".
     *
     * The field will be set to its default value. The hasConnectionID()
     * method will return false.
     */
    inline void clearConnectionID();

    /**
     * Checks whether the field "connectionID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectionID()). Otherwise it will return false.
     */
    inline bool hasConnectionID () const;

    /**
     * Returns the value of the member "connectionID".
     *
     * If the meaning of "connectionID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "connectionID"
     */
    inline uint16 getConnectionID () const;

    /**
     * Sets the value of the member "connectionID".
     *
     * If the meaning of "connectionID" isn't clear, then there should be a description here.
     *
     * @param connectionID The value which will be set
     */
    inline void setConnectionID (uint16 connectionID_);

    // API of field "connectionState"

    static const int kConnectionState = 1;

    /**
     * Clears the field "connectionState".
     *
     * The field will be set to its default value. The hasConnectionState()
     * method will return false.
     */
    inline void clearConnectionState();

    /**
     * Checks whether the field "connectionState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectionState()). Otherwise it will return false.
     */
    inline bool hasConnectionState () const;

    /**
     * Returns the value of the member "connectionState".
     *
     * If the meaning of "connectionState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "connectionState"
     */
    inline int16 getConnectionState () const;

    /**
     * Sets the value of the member "connectionState".
     *
     * If the meaning of "connectionState" isn't clear, then there should be a description here.
     *
     * @param connectionState The value which will be set
     */
    inline void setConnectionState (int16 connectionState_);

    static const MainConnectionStateChangedSignal &getDefaultInstance();

private:

    inline void set_has_connectionID ();

    inline void clear_has_connectionID ();

    inline void set_has_connectionState ();

    inline void clear_has_connectionState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _connectionID;

    int16 _connectionState;

};

/**
 * If the meaning of "MainSinkSoundPropertyChangedSignalSoundPropertyStruct" isn't clear, then there should be a description here.
 */
class MainSinkSoundPropertyChangedSignalSoundPropertyStruct {
public:

    /**
     * Default constructor
     */
    inline  MainSinkSoundPropertyChangedSignalSoundPropertyStruct ();

    /**
     * Copy constructor
     */
    inline  MainSinkSoundPropertyChangedSignalSoundPropertyStruct (const MainSinkSoundPropertyChangedSignalSoundPropertyStruct &rhs);

    /**
     * All fields constructor
     */
    inline  MainSinkSoundPropertyChangedSignalSoundPropertyStruct (int16 elem1_, int16 elem2_);

    /**
     * Destructor
     */
    inline  ~MainSinkSoundPropertyChangedSignalSoundPropertyStruct();

    /**
     * Assignment operator
     */
    inline MainSinkSoundPropertyChangedSignalSoundPropertyStruct& operator = (const MainSinkSoundPropertyChangedSignalSoundPropertyStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MainSinkSoundPropertyChangedSignalSoundPropertyStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MainSinkSoundPropertyChangedSignalSoundPropertyStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MainSinkSoundPropertyChangedSignalSoundPropertyStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MainSinkSoundPropertyChangedSignalSoundPropertyStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline int16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (int16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline int16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (int16 elem2_);

    static const MainSinkSoundPropertyChangedSignalSoundPropertyStruct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _elem1;

    int16 _elem2;

};

/**
 * If the meaning of "MainSinkSoundPropertyChangedSignal" isn't clear, then there should be a description here.
 */
class MainSinkSoundPropertyChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MainSinkSoundPropertyChangedSignal ();

    /**
     * Copy constructor
     */
    inline  MainSinkSoundPropertyChangedSignal (const MainSinkSoundPropertyChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  MainSinkSoundPropertyChangedSignal (uint16 sinkID_, const MainSinkSoundPropertyChangedSignalSoundPropertyStruct& SoundProperty_);

    /**
     * Destructor
     */
    inline virtual  ~MainSinkSoundPropertyChangedSignal();

    /**
     * Assignment operator
     */
    inline MainSinkSoundPropertyChangedSignal& operator = (const MainSinkSoundPropertyChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MainSinkSoundPropertyChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MainSinkSoundPropertyChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MainSinkSoundPropertyChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MainSinkSoundPropertyChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sinkID"

    static const int kSinkID = 0;

    /**
     * Clears the field "sinkID".
     *
     * The field will be set to its default value. The hasSinkID()
     * method will return false.
     */
    inline void clearSinkID();

    /**
     * Checks whether the field "sinkID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSinkID()). Otherwise it will return false.
     */
    inline bool hasSinkID () const;

    /**
     * Returns the value of the member "sinkID".
     *
     * If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sinkID"
     */
    inline uint16 getSinkID () const;

    /**
     * Sets the value of the member "sinkID".
     *
     * If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @param sinkID The value which will be set
     */
    inline void setSinkID (uint16 sinkID_);

    // API of field "SoundProperty"

    static const int kSoundProperty = 1;

    /**
     * Clears the field "SoundProperty".
     *
     * The field will be set to its default value. The hasSoundProperty()
     * method will return false.
     */
    inline void clearSoundProperty();

    /**
     * Checks whether the field "SoundProperty" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundProperty()). Otherwise it will return false.
     */
    inline bool hasSoundProperty () const;

    /**
     * Returns the value of the member "SoundProperty".
     *
     * If the meaning of "SoundProperty" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SoundProperty"
     */
    inline const MainSinkSoundPropertyChangedSignalSoundPropertyStruct& getSoundProperty () const;

    /**
     * Retrieves the value of the field "SoundProperty" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SoundProperty".
     */
    inline MainSinkSoundPropertyChangedSignalSoundPropertyStruct& getSoundPropertyMutable ();

    /**
     * Sets the value of the member "SoundProperty".
     *
     * If the meaning of "SoundProperty" isn't clear, then there should be a description here.
     *
     * @param SoundProperty The value which will be set
     */
    inline void setSoundProperty (const MainSinkSoundPropertyChangedSignalSoundPropertyStruct& SoundProperty_);

    static const MainSinkSoundPropertyChangedSignal &getDefaultInstance();

private:

    inline void set_has_sinkID ();

    inline void clear_has_sinkID ();

    inline void set_has_SoundProperty ();

    inline void clear_has_SoundProperty ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _sinkID;

    MainSinkSoundPropertyChangedSignalSoundPropertyStruct _SoundProperty;

};

/**
 * If the meaning of "MainSourceSoundPropertyChangedSignalSoundPropertyStruct" isn't clear, then there should be a description here.
 */
class MainSourceSoundPropertyChangedSignalSoundPropertyStruct {
public:

    /**
     * Default constructor
     */
    inline  MainSourceSoundPropertyChangedSignalSoundPropertyStruct ();

    /**
     * Copy constructor
     */
    inline  MainSourceSoundPropertyChangedSignalSoundPropertyStruct (const MainSourceSoundPropertyChangedSignalSoundPropertyStruct &rhs);

    /**
     * All fields constructor
     */
    inline  MainSourceSoundPropertyChangedSignalSoundPropertyStruct (int16 elem1_, int16 elem2_);

    /**
     * Destructor
     */
    inline  ~MainSourceSoundPropertyChangedSignalSoundPropertyStruct();

    /**
     * Assignment operator
     */
    inline MainSourceSoundPropertyChangedSignalSoundPropertyStruct& operator = (const MainSourceSoundPropertyChangedSignalSoundPropertyStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MainSourceSoundPropertyChangedSignalSoundPropertyStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MainSourceSoundPropertyChangedSignalSoundPropertyStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MainSourceSoundPropertyChangedSignalSoundPropertyStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MainSourceSoundPropertyChangedSignalSoundPropertyStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline int16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (int16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline int16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (int16 elem2_);

    static const MainSourceSoundPropertyChangedSignalSoundPropertyStruct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _elem1;

    int16 _elem2;

};

/**
 * If the meaning of "MainSourceSoundPropertyChangedSignal" isn't clear, then there should be a description here.
 */
class MainSourceSoundPropertyChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MainSourceSoundPropertyChangedSignal ();

    /**
     * Copy constructor
     */
    inline  MainSourceSoundPropertyChangedSignal (const MainSourceSoundPropertyChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  MainSourceSoundPropertyChangedSignal (uint16 sourceID_, const MainSourceSoundPropertyChangedSignalSoundPropertyStruct& SoundProperty_);

    /**
     * Destructor
     */
    inline virtual  ~MainSourceSoundPropertyChangedSignal();

    /**
     * Assignment operator
     */
    inline MainSourceSoundPropertyChangedSignal& operator = (const MainSourceSoundPropertyChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MainSourceSoundPropertyChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MainSourceSoundPropertyChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MainSourceSoundPropertyChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MainSourceSoundPropertyChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sourceID"

    static const int kSourceID = 0;

    /**
     * Clears the field "sourceID".
     *
     * The field will be set to its default value. The hasSourceID()
     * method will return false.
     */
    inline void clearSourceID();

    /**
     * Checks whether the field "sourceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceID()). Otherwise it will return false.
     */
    inline bool hasSourceID () const;

    /**
     * Returns the value of the member "sourceID".
     *
     * If the meaning of "sourceID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourceID"
     */
    inline uint16 getSourceID () const;

    /**
     * Sets the value of the member "sourceID".
     *
     * If the meaning of "sourceID" isn't clear, then there should be a description here.
     *
     * @param sourceID The value which will be set
     */
    inline void setSourceID (uint16 sourceID_);

    // API of field "SoundProperty"

    static const int kSoundProperty = 1;

    /**
     * Clears the field "SoundProperty".
     *
     * The field will be set to its default value. The hasSoundProperty()
     * method will return false.
     */
    inline void clearSoundProperty();

    /**
     * Checks whether the field "SoundProperty" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundProperty()). Otherwise it will return false.
     */
    inline bool hasSoundProperty () const;

    /**
     * Returns the value of the member "SoundProperty".
     *
     * If the meaning of "SoundProperty" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SoundProperty"
     */
    inline const MainSourceSoundPropertyChangedSignalSoundPropertyStruct& getSoundProperty () const;

    /**
     * Retrieves the value of the field "SoundProperty" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SoundProperty".
     */
    inline MainSourceSoundPropertyChangedSignalSoundPropertyStruct& getSoundPropertyMutable ();

    /**
     * Sets the value of the member "SoundProperty".
     *
     * If the meaning of "SoundProperty" isn't clear, then there should be a description here.
     *
     * @param SoundProperty The value which will be set
     */
    inline void setSoundProperty (const MainSourceSoundPropertyChangedSignalSoundPropertyStruct& SoundProperty_);

    static const MainSourceSoundPropertyChangedSignal &getDefaultInstance();

private:

    inline void set_has_sourceID ();

    inline void clear_has_sourceID ();

    inline void set_has_SoundProperty ();

    inline void clear_has_SoundProperty ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _sourceID;

    MainSourceSoundPropertyChangedSignalSoundPropertyStruct _SoundProperty;

};

/**
 * If the meaning of "SinkAvailabilityChangedSignalAvailabilityStruct" isn't clear, then there should be a description here.
 */
class SinkAvailabilityChangedSignalAvailabilityStruct {
public:

    /**
     * Default constructor
     */
    inline  SinkAvailabilityChangedSignalAvailabilityStruct ();

    /**
     * Copy constructor
     */
    inline  SinkAvailabilityChangedSignalAvailabilityStruct (const SinkAvailabilityChangedSignalAvailabilityStruct &rhs);

    /**
     * All fields constructor
     */
    inline  SinkAvailabilityChangedSignalAvailabilityStruct (int16 elem1_, int16 elem2_);

    /**
     * Destructor
     */
    inline  ~SinkAvailabilityChangedSignalAvailabilityStruct();

    /**
     * Assignment operator
     */
    inline SinkAvailabilityChangedSignalAvailabilityStruct& operator = (const SinkAvailabilityChangedSignalAvailabilityStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SinkAvailabilityChangedSignalAvailabilityStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SinkAvailabilityChangedSignalAvailabilityStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SinkAvailabilityChangedSignalAvailabilityStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SinkAvailabilityChangedSignalAvailabilityStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline int16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (int16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline int16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (int16 elem2_);

    static const SinkAvailabilityChangedSignalAvailabilityStruct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _elem1;

    int16 _elem2;

};

/**
 * If the meaning of "SinkAvailabilityChangedSignal" isn't clear, then there should be a description here.
 */
class SinkAvailabilityChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SinkAvailabilityChangedSignal ();

    /**
     * Copy constructor
     */
    inline  SinkAvailabilityChangedSignal (const SinkAvailabilityChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SinkAvailabilityChangedSignal (uint16 sinkID_, const SinkAvailabilityChangedSignalAvailabilityStruct& availability_);

    /**
     * Destructor
     */
    inline virtual  ~SinkAvailabilityChangedSignal();

    /**
     * Assignment operator
     */
    inline SinkAvailabilityChangedSignal& operator = (const SinkAvailabilityChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SinkAvailabilityChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SinkAvailabilityChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SinkAvailabilityChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SinkAvailabilityChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sinkID"

    static const int kSinkID = 0;

    /**
     * Clears the field "sinkID".
     *
     * The field will be set to its default value. The hasSinkID()
     * method will return false.
     */
    inline void clearSinkID();

    /**
     * Checks whether the field "sinkID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSinkID()). Otherwise it will return false.
     */
    inline bool hasSinkID () const;

    /**
     * Returns the value of the member "sinkID".
     *
     * If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sinkID"
     */
    inline uint16 getSinkID () const;

    /**
     * Sets the value of the member "sinkID".
     *
     * If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @param sinkID The value which will be set
     */
    inline void setSinkID (uint16 sinkID_);

    // API of field "availability"

    static const int kAvailability = 1;

    /**
     * Clears the field "availability".
     *
     * The field will be set to its default value. The hasAvailability()
     * method will return false.
     */
    inline void clearAvailability();

    /**
     * Checks whether the field "availability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAvailability()). Otherwise it will return false.
     */
    inline bool hasAvailability () const;

    /**
     * Returns the value of the member "availability".
     *
     * If the meaning of "availability" isn't clear, then there should be a description here.
     *
     * @return The value of the field "availability"
     */
    inline const SinkAvailabilityChangedSignalAvailabilityStruct& getAvailability () const;

    /**
     * Retrieves the value of the field "availability" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "availability".
     */
    inline SinkAvailabilityChangedSignalAvailabilityStruct& getAvailabilityMutable ();

    /**
     * Sets the value of the member "availability".
     *
     * If the meaning of "availability" isn't clear, then there should be a description here.
     *
     * @param availability The value which will be set
     */
    inline void setAvailability (const SinkAvailabilityChangedSignalAvailabilityStruct& availability_);

    static const SinkAvailabilityChangedSignal &getDefaultInstance();

private:

    inline void set_has_sinkID ();

    inline void clear_has_sinkID ();

    inline void set_has_availability ();

    inline void clear_has_availability ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _sinkID;

    SinkAvailabilityChangedSignalAvailabilityStruct _availability;

};

/**
 * If the meaning of "SourceAvailabilityChangedSignalAvailabilityStruct" isn't clear, then there should be a description here.
 */
class SourceAvailabilityChangedSignalAvailabilityStruct {
public:

    /**
     * Default constructor
     */
    inline  SourceAvailabilityChangedSignalAvailabilityStruct ();

    /**
     * Copy constructor
     */
    inline  SourceAvailabilityChangedSignalAvailabilityStruct (const SourceAvailabilityChangedSignalAvailabilityStruct &rhs);

    /**
     * All fields constructor
     */
    inline  SourceAvailabilityChangedSignalAvailabilityStruct (int16 elem1_, int16 elem2_);

    /**
     * Destructor
     */
    inline  ~SourceAvailabilityChangedSignalAvailabilityStruct();

    /**
     * Assignment operator
     */
    inline SourceAvailabilityChangedSignalAvailabilityStruct& operator = (const SourceAvailabilityChangedSignalAvailabilityStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceAvailabilityChangedSignalAvailabilityStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceAvailabilityChangedSignalAvailabilityStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceAvailabilityChangedSignalAvailabilityStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceAvailabilityChangedSignalAvailabilityStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline int16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (int16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline int16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (int16 elem2_);

    static const SourceAvailabilityChangedSignalAvailabilityStruct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _elem1;

    int16 _elem2;

};

/**
 * If the meaning of "SourceAvailabilityChangedSignal" isn't clear, then there should be a description here.
 */
class SourceAvailabilityChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourceAvailabilityChangedSignal ();

    /**
     * Copy constructor
     */
    inline  SourceAvailabilityChangedSignal (const SourceAvailabilityChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SourceAvailabilityChangedSignal (uint16 sourceID_, const SourceAvailabilityChangedSignalAvailabilityStruct& availability_);

    /**
     * Destructor
     */
    inline virtual  ~SourceAvailabilityChangedSignal();

    /**
     * Assignment operator
     */
    inline SourceAvailabilityChangedSignal& operator = (const SourceAvailabilityChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceAvailabilityChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceAvailabilityChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceAvailabilityChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceAvailabilityChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sourceID"

    static const int kSourceID = 0;

    /**
     * Clears the field "sourceID".
     *
     * The field will be set to its default value. The hasSourceID()
     * method will return false.
     */
    inline void clearSourceID();

    /**
     * Checks whether the field "sourceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceID()). Otherwise it will return false.
     */
    inline bool hasSourceID () const;

    /**
     * Returns the value of the member "sourceID".
     *
     * If the meaning of "sourceID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourceID"
     */
    inline uint16 getSourceID () const;

    /**
     * Sets the value of the member "sourceID".
     *
     * If the meaning of "sourceID" isn't clear, then there should be a description here.
     *
     * @param sourceID The value which will be set
     */
    inline void setSourceID (uint16 sourceID_);

    // API of field "availability"

    static const int kAvailability = 1;

    /**
     * Clears the field "availability".
     *
     * The field will be set to its default value. The hasAvailability()
     * method will return false.
     */
    inline void clearAvailability();

    /**
     * Checks whether the field "availability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAvailability()). Otherwise it will return false.
     */
    inline bool hasAvailability () const;

    /**
     * Returns the value of the member "availability".
     *
     * If the meaning of "availability" isn't clear, then there should be a description here.
     *
     * @return The value of the field "availability"
     */
    inline const SourceAvailabilityChangedSignalAvailabilityStruct& getAvailability () const;

    /**
     * Retrieves the value of the field "availability" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "availability".
     */
    inline SourceAvailabilityChangedSignalAvailabilityStruct& getAvailabilityMutable ();

    /**
     * Sets the value of the member "availability".
     *
     * If the meaning of "availability" isn't clear, then there should be a description here.
     *
     * @param availability The value which will be set
     */
    inline void setAvailability (const SourceAvailabilityChangedSignalAvailabilityStruct& availability_);

    static const SourceAvailabilityChangedSignal &getDefaultInstance();

private:

    inline void set_has_sourceID ();

    inline void clear_has_sourceID ();

    inline void set_has_availability ();

    inline void clear_has_availability ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _sourceID;

    SourceAvailabilityChangedSignalAvailabilityStruct _availability;

};

/**
 * If the meaning of "VolumeChangedSignal" isn't clear, then there should be a description here.
 */
class VolumeChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VolumeChangedSignal ();

    /**
     * Copy constructor
     */
    inline  VolumeChangedSignal (const VolumeChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  VolumeChangedSignal (uint16 sinkID_, int16 volume_);

    /**
     * Destructor
     */
    inline virtual  ~VolumeChangedSignal();

    /**
     * Assignment operator
     */
    inline VolumeChangedSignal& operator = (const VolumeChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VolumeChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VolumeChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VolumeChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VolumeChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sinkID"

    static const int kSinkID = 0;

    /**
     * Clears the field "sinkID".
     *
     * The field will be set to its default value. The hasSinkID()
     * method will return false.
     */
    inline void clearSinkID();

    /**
     * Checks whether the field "sinkID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSinkID()). Otherwise it will return false.
     */
    inline bool hasSinkID () const;

    /**
     * Returns the value of the member "sinkID".
     *
     * If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sinkID"
     */
    inline uint16 getSinkID () const;

    /**
     * Sets the value of the member "sinkID".
     *
     * If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @param sinkID The value which will be set
     */
    inline void setSinkID (uint16 sinkID_);

    // API of field "volume"

    static const int kVolume = 1;

    /**
     * Clears the field "volume".
     *
     * The field will be set to its default value. The hasVolume()
     * method will return false.
     */
    inline void clearVolume();

    /**
     * Checks whether the field "volume" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolume()). Otherwise it will return false.
     */
    inline bool hasVolume () const;

    /**
     * Returns the value of the member "volume".
     *
     * If the meaning of "volume" isn't clear, then there should be a description here.
     *
     * @return The value of the field "volume"
     */
    inline int16 getVolume () const;

    /**
     * Sets the value of the member "volume".
     *
     * If the meaning of "volume" isn't clear, then there should be a description here.
     *
     * @param volume The value which will be set
     */
    inline void setVolume (int16 volume_);

    static const VolumeChangedSignal &getDefaultInstance();

private:

    inline void set_has_sinkID ();

    inline void clear_has_sinkID ();

    inline void set_has_volume ();

    inline void clear_has_volume ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _sinkID;

    int16 _volume;

};

/**
 * If the meaning of "SinkMuteStateChangedSignal" isn't clear, then there should be a description here.
 */
class SinkMuteStateChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SinkMuteStateChangedSignal ();

    /**
     * Copy constructor
     */
    inline  SinkMuteStateChangedSignal (const SinkMuteStateChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SinkMuteStateChangedSignal (uint16 sinkID_, int16 muteState_);

    /**
     * Destructor
     */
    inline virtual  ~SinkMuteStateChangedSignal();

    /**
     * Assignment operator
     */
    inline SinkMuteStateChangedSignal& operator = (const SinkMuteStateChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SinkMuteStateChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SinkMuteStateChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SinkMuteStateChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SinkMuteStateChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sinkID"

    static const int kSinkID = 0;

    /**
     * Clears the field "sinkID".
     *
     * The field will be set to its default value. The hasSinkID()
     * method will return false.
     */
    inline void clearSinkID();

    /**
     * Checks whether the field "sinkID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSinkID()). Otherwise it will return false.
     */
    inline bool hasSinkID () const;

    /**
     * Returns the value of the member "sinkID".
     *
     * If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sinkID"
     */
    inline uint16 getSinkID () const;

    /**
     * Sets the value of the member "sinkID".
     *
     * If the meaning of "sinkID" isn't clear, then there should be a description here.
     *
     * @param sinkID The value which will be set
     */
    inline void setSinkID (uint16 sinkID_);

    // API of field "muteState"

    static const int kMuteState = 1;

    /**
     * Clears the field "muteState".
     *
     * The field will be set to its default value. The hasMuteState()
     * method will return false.
     */
    inline void clearMuteState();

    /**
     * Checks whether the field "muteState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMuteState()). Otherwise it will return false.
     */
    inline bool hasMuteState () const;

    /**
     * Returns the value of the member "muteState".
     *
     * If the meaning of "muteState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "muteState"
     */
    inline int16 getMuteState () const;

    /**
     * Sets the value of the member "muteState".
     *
     * If the meaning of "muteState" isn't clear, then there should be a description here.
     *
     * @param muteState The value which will be set
     */
    inline void setMuteState (int16 muteState_);

    static const SinkMuteStateChangedSignal &getDefaultInstance();

private:

    inline void set_has_sinkID ();

    inline void clear_has_sinkID ();

    inline void set_has_muteState ();

    inline void clear_has_muteState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _sinkID;

    int16 _muteState;

};

/**
 * If the meaning of "SystemPropertyChangedSignalSystemPropertyStruct" isn't clear, then there should be a description here.
 */
class SystemPropertyChangedSignalSystemPropertyStruct {
public:

    /**
     * Default constructor
     */
    inline  SystemPropertyChangedSignalSystemPropertyStruct ();

    /**
     * Copy constructor
     */
    inline  SystemPropertyChangedSignalSystemPropertyStruct (const SystemPropertyChangedSignalSystemPropertyStruct &rhs);

    /**
     * All fields constructor
     */
    inline  SystemPropertyChangedSignalSystemPropertyStruct (int16 elem1_, int16 elem2_);

    /**
     * Destructor
     */
    inline  ~SystemPropertyChangedSignalSystemPropertyStruct();

    /**
     * Assignment operator
     */
    inline SystemPropertyChangedSignalSystemPropertyStruct& operator = (const SystemPropertyChangedSignalSystemPropertyStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemPropertyChangedSignalSystemPropertyStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemPropertyChangedSignalSystemPropertyStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemPropertyChangedSignalSystemPropertyStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemPropertyChangedSignalSystemPropertyStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline int16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (int16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline int16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (int16 elem2_);

    static const SystemPropertyChangedSignalSystemPropertyStruct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int16 _elem1;

    int16 _elem2;

};

/**
 * If the meaning of "SystemPropertyChangedSignal" isn't clear, then there should be a description here.
 */
class SystemPropertyChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemPropertyChangedSignal ();

    /**
     * Copy constructor
     */
    inline  SystemPropertyChangedSignal (const SystemPropertyChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SystemPropertyChangedSignal (const SystemPropertyChangedSignalSystemPropertyStruct& SystemProperty_);

    /**
     * Destructor
     */
    inline virtual  ~SystemPropertyChangedSignal();

    /**
     * Assignment operator
     */
    inline SystemPropertyChangedSignal& operator = (const SystemPropertyChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemPropertyChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemPropertyChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemPropertyChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemPropertyChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SystemProperty"

    static const int kSystemProperty = 0;

    /**
     * Clears the field "SystemProperty".
     *
     * The field will be set to its default value. The hasSystemProperty()
     * method will return false.
     */
    inline void clearSystemProperty();

    /**
     * Checks whether the field "SystemProperty" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSystemProperty()). Otherwise it will return false.
     */
    inline bool hasSystemProperty () const;

    /**
     * Returns the value of the member "SystemProperty".
     *
     * If the meaning of "SystemProperty" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SystemProperty"
     */
    inline const SystemPropertyChangedSignalSystemPropertyStruct& getSystemProperty () const;

    /**
     * Retrieves the value of the field "SystemProperty" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SystemProperty".
     */
    inline SystemPropertyChangedSignalSystemPropertyStruct& getSystemPropertyMutable ();

    /**
     * Sets the value of the member "SystemProperty".
     *
     * If the meaning of "SystemProperty" isn't clear, then there should be a description here.
     *
     * @param SystemProperty The value which will be set
     */
    inline void setSystemProperty (const SystemPropertyChangedSignalSystemPropertyStruct& SystemProperty_);

    static const SystemPropertyChangedSignal &getDefaultInstance();

private:

    inline void set_has_SystemProperty ();

    inline void clear_has_SystemProperty ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SystemPropertyChangedSignalSystemPropertyStruct _SystemProperty;

};

/**
 * If the meaning of "TimingInformationChangedSignal" isn't clear, then there should be a description here.
 */
class TimingInformationChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TimingInformationChangedSignal ();

    /**
     * Copy constructor
     */
    inline  TimingInformationChangedSignal (const TimingInformationChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  TimingInformationChangedSignal (uint16 mainConnection_, int16 time_);

    /**
     * Destructor
     */
    inline virtual  ~TimingInformationChangedSignal();

    /**
     * Assignment operator
     */
    inline TimingInformationChangedSignal& operator = (const TimingInformationChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TimingInformationChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TimingInformationChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TimingInformationChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TimingInformationChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "mainConnection"

    static const int kMainConnection = 0;

    /**
     * Clears the field "mainConnection".
     *
     * The field will be set to its default value. The hasMainConnection()
     * method will return false.
     */
    inline void clearMainConnection();

    /**
     * Checks whether the field "mainConnection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMainConnection()). Otherwise it will return false.
     */
    inline bool hasMainConnection () const;

    /**
     * Returns the value of the member "mainConnection".
     *
     * If the meaning of "mainConnection" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mainConnection"
     */
    inline uint16 getMainConnection () const;

    /**
     * Sets the value of the member "mainConnection".
     *
     * If the meaning of "mainConnection" isn't clear, then there should be a description here.
     *
     * @param mainConnection The value which will be set
     */
    inline void setMainConnection (uint16 mainConnection_);

    // API of field "time"

    static const int kTime = 1;

    /**
     * Clears the field "time".
     *
     * The field will be set to its default value. The hasTime()
     * method will return false.
     */
    inline void clearTime();

    /**
     * Checks whether the field "time" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTime()). Otherwise it will return false.
     */
    inline bool hasTime () const;

    /**
     * Returns the value of the member "time".
     *
     * If the meaning of "time" isn't clear, then there should be a description here.
     *
     * @return The value of the field "time"
     */
    inline int16 getTime () const;

    /**
     * Sets the value of the member "time".
     *
     * If the meaning of "time" isn't clear, then there should be a description here.
     *
     * @param time The value which will be set
     */
    inline void setTime (int16 time_);

    static const TimingInformationChangedSignal &getDefaultInstance();

private:

    inline void set_has_mainConnection ();

    inline void clear_has_mainConnection ();

    inline void set_has_time ();

    inline void clear_has_time ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _mainConnection;

    int16 _time;

};

inline  ConnectRequest::ConnectRequest ()  :
    _sourceID (0u),
    _sinkID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConnectRequest::ConnectRequest (const ConnectRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _sourceID (0u),
    _sinkID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConnectRequest::ConnectRequest (uint16 sourceID_, uint16 sinkID_)  :
    _sourceID (sourceID_),
    _sinkID (sinkID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConnectRequest::~ConnectRequest() {
}

inline ConnectRequest& ConnectRequest::operator = (const ConnectRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSourceID()) {
            setSourceID(rhs.getSourceID());
        } else {
            clearSourceID();
        }
        if (rhs.hasSinkID()) {
            setSinkID(rhs.getSinkID());
        } else {
            clearSinkID();
        }
    }
    return *this;
}

inline bool ConnectRequest::operator == (const ConnectRequest& rhs) const {
    return (((!hasSourceID() && !rhs.hasSourceID()) || getSourceID() == rhs.getSourceID()) &&
        ((!hasSinkID() && !rhs.hasSinkID()) || getSinkID() == rhs.getSinkID()));
}

inline bool ConnectRequest::operator != (const ConnectRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ConnectRequest::operator < (const ConnectRequest& rhs) const {
    if (hasSourceID() || rhs.hasSourceID()) {
        if (getSourceID() < rhs.getSourceID()) return true;
        if (getSourceID() > rhs.getSourceID()) return false;
    }
    if (hasSinkID() || rhs.hasSinkID()) {
        if (getSinkID() < rhs.getSinkID()) return true;
        if (getSinkID() > rhs.getSinkID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConnectRequest::clone() {
    return new ConnectRequest(*this);
}

inline bool ConnectRequest::operator > (const ConnectRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConnectRequest::clear() {
    clearSourceID();
    clearSinkID();
}

inline void ConnectRequest::clearSourceID() {
    if (hasSourceID()) {
         clear_has_sourceID();
        _sourceID = 0u;
     }
}

inline bool ConnectRequest::hasSourceID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 ConnectRequest::getSourceID () const {
    return _sourceID;
}

inline void ConnectRequest::setSourceID (uint16 sourceID_) {
    set_has_sourceID();
    this->_sourceID = sourceID_;
}

inline void ConnectRequest::clearSinkID() {
    if (hasSinkID()) {
         clear_has_sinkID();
        _sinkID = 0u;
     }
}

inline bool ConnectRequest::hasSinkID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 ConnectRequest::getSinkID () const {
    return _sinkID;
}

inline void ConnectRequest::setSinkID (uint16 sinkID_) {
    set_has_sinkID();
    this->_sinkID = sinkID_;
}

inline void ConnectRequest::set_has_sourceID () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConnectRequest::clear_has_sourceID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ConnectRequest::set_has_sinkID () {
    _has_bits_[0] |= 1u << 1;
}

inline void ConnectRequest::clear_has_sinkID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ConnectResponse::ConnectResponse ()  :
    _result (0),
    _mainConnectionID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConnectResponse::ConnectResponse (const ConnectResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (0),
    _mainConnectionID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConnectResponse::ConnectResponse (int16 result_, uint16 mainConnectionID_)  :
    _result (result_),
    _mainConnectionID (mainConnectionID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConnectResponse::~ConnectResponse() {
}

inline ConnectResponse& ConnectResponse::operator = (const ConnectResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
        if (rhs.hasMainConnectionID()) {
            setMainConnectionID(rhs.getMainConnectionID());
        } else {
            clearMainConnectionID();
        }
    }
    return *this;
}

inline bool ConnectResponse::operator == (const ConnectResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()) &&
        ((!hasMainConnectionID() && !rhs.hasMainConnectionID()) || getMainConnectionID() == rhs.getMainConnectionID()));
}

inline bool ConnectResponse::operator != (const ConnectResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ConnectResponse::operator < (const ConnectResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if (getResult() < rhs.getResult()) return true;
        if (getResult() > rhs.getResult()) return false;
    }
    if (hasMainConnectionID() || rhs.hasMainConnectionID()) {
        if (getMainConnectionID() < rhs.getMainConnectionID()) return true;
        if (getMainConnectionID() > rhs.getMainConnectionID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConnectResponse::clone() {
    return new ConnectResponse(*this);
}

inline bool ConnectResponse::operator > (const ConnectResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConnectResponse::clear() {
    clearResult();
    clearMainConnectionID();
}

inline void ConnectResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = 0;
     }
}

inline bool ConnectResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 ConnectResponse::getResult () const {
    return _result;
}

inline void ConnectResponse::setResult (int16 result_) {
    set_has_result();
    this->_result = result_;
}

inline void ConnectResponse::clearMainConnectionID() {
    if (hasMainConnectionID()) {
         clear_has_mainConnectionID();
        _mainConnectionID = 0u;
     }
}

inline bool ConnectResponse::hasMainConnectionID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 ConnectResponse::getMainConnectionID () const {
    return _mainConnectionID;
}

inline void ConnectResponse::setMainConnectionID (uint16 mainConnectionID_) {
    set_has_mainConnectionID();
    this->_mainConnectionID = mainConnectionID_;
}

inline void ConnectResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConnectResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ConnectResponse::set_has_mainConnectionID () {
    _has_bits_[0] |= 1u << 1;
}

inline void ConnectResponse::clear_has_mainConnectionID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DisconnectRequest::DisconnectRequest ()  :
    _mainConnectionID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DisconnectRequest::DisconnectRequest (const DisconnectRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _mainConnectionID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DisconnectRequest::DisconnectRequest (uint16 mainConnectionID_)  :
    _mainConnectionID (mainConnectionID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DisconnectRequest::~DisconnectRequest() {
}

inline DisconnectRequest& DisconnectRequest::operator = (const DisconnectRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMainConnectionID()) {
            setMainConnectionID(rhs.getMainConnectionID());
        } else {
            clearMainConnectionID();
        }
    }
    return *this;
}

inline bool DisconnectRequest::operator == (const DisconnectRequest& rhs) const {
    return (((!hasMainConnectionID() && !rhs.hasMainConnectionID()) || getMainConnectionID() == rhs.getMainConnectionID()));
}

inline bool DisconnectRequest::operator != (const DisconnectRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DisconnectRequest::operator < (const DisconnectRequest& rhs) const {
    if (hasMainConnectionID() || rhs.hasMainConnectionID()) {
        if (getMainConnectionID() < rhs.getMainConnectionID()) return true;
        if (getMainConnectionID() > rhs.getMainConnectionID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DisconnectRequest::clone() {
    return new DisconnectRequest(*this);
}

inline bool DisconnectRequest::operator > (const DisconnectRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DisconnectRequest::clear() {
    clearMainConnectionID();
}

inline void DisconnectRequest::clearMainConnectionID() {
    if (hasMainConnectionID()) {
         clear_has_mainConnectionID();
        _mainConnectionID = 0u;
     }
}

inline bool DisconnectRequest::hasMainConnectionID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 DisconnectRequest::getMainConnectionID () const {
    return _mainConnectionID;
}

inline void DisconnectRequest::setMainConnectionID (uint16 mainConnectionID_) {
    set_has_mainConnectionID();
    this->_mainConnectionID = mainConnectionID_;
}

inline void DisconnectRequest::set_has_mainConnectionID () {
    _has_bits_[0] |= 1u << 0;
}

inline void DisconnectRequest::clear_has_mainConnectionID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DisconnectResponse::DisconnectResponse ()  :
    _result (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DisconnectResponse::DisconnectResponse (const DisconnectResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DisconnectResponse::DisconnectResponse (int16 result_)  :
    _result (result_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DisconnectResponse::~DisconnectResponse() {
}

inline DisconnectResponse& DisconnectResponse::operator = (const DisconnectResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool DisconnectResponse::operator == (const DisconnectResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool DisconnectResponse::operator != (const DisconnectResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool DisconnectResponse::operator < (const DisconnectResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if (getResult() < rhs.getResult()) return true;
        if (getResult() > rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DisconnectResponse::clone() {
    return new DisconnectResponse(*this);
}

inline bool DisconnectResponse::operator > (const DisconnectResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DisconnectResponse::clear() {
    clearResult();
}

inline void DisconnectResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = 0;
     }
}

inline bool DisconnectResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 DisconnectResponse::getResult () const {
    return _result;
}

inline void DisconnectResponse::setResult (int16 result_) {
    set_has_result();
    this->_result = result_;
}

inline void DisconnectResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void DisconnectResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetVolumeRequest::SetVolumeRequest ()  :
    _sinkID (0u),
    _Mode (0u),
    _value (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetVolumeRequest::SetVolumeRequest (const SetVolumeRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _sinkID (0u),
    _Mode (0u),
    _value (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetVolumeRequest::SetVolumeRequest (uint16 sinkID_, uint16 Mode_, int16 value_)  :
    _sinkID (sinkID_),
    _Mode (Mode_),
    _value (value_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetVolumeRequest::~SetVolumeRequest() {
}

inline SetVolumeRequest& SetVolumeRequest::operator = (const SetVolumeRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSinkID()) {
            setSinkID(rhs.getSinkID());
        } else {
            clearSinkID();
        }
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool SetVolumeRequest::operator == (const SetVolumeRequest& rhs) const {
    return (((!hasSinkID() && !rhs.hasSinkID()) || getSinkID() == rhs.getSinkID()) &&
        ((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool SetVolumeRequest::operator != (const SetVolumeRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetVolumeRequest::operator < (const SetVolumeRequest& rhs) const {
    if (hasSinkID() || rhs.hasSinkID()) {
        if (getSinkID() < rhs.getSinkID()) return true;
        if (getSinkID() > rhs.getSinkID()) return false;
    }
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetVolumeRequest::clone() {
    return new SetVolumeRequest(*this);
}

inline bool SetVolumeRequest::operator > (const SetVolumeRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetVolumeRequest::clear() {
    clearSinkID();
    clearMode();
    clearValue();
}

inline void SetVolumeRequest::clearSinkID() {
    if (hasSinkID()) {
         clear_has_sinkID();
        _sinkID = 0u;
     }
}

inline bool SetVolumeRequest::hasSinkID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SetVolumeRequest::getSinkID () const {
    return _sinkID;
}

inline void SetVolumeRequest::setSinkID (uint16 sinkID_) {
    set_has_sinkID();
    this->_sinkID = sinkID_;
}

inline void SetVolumeRequest::clearMode() {
    if (hasMode()) {
         clear_has_Mode();
        _Mode = 0u;
     }
}

inline bool SetVolumeRequest::hasMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 SetVolumeRequest::getMode () const {
    return _Mode;
}

inline void SetVolumeRequest::setMode (uint16 Mode_) {
    set_has_Mode();
    this->_Mode = Mode_;
}

inline void SetVolumeRequest::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value = 0;
     }
}

inline bool SetVolumeRequest::hasValue () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int16 SetVolumeRequest::getValue () const {
    return _value;
}

inline void SetVolumeRequest::setValue (int16 value_) {
    set_has_value();
    this->_value = value_;
}

inline void SetVolumeRequest::set_has_sinkID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetVolumeRequest::clear_has_sinkID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetVolumeRequest::set_has_Mode () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetVolumeRequest::clear_has_Mode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SetVolumeRequest::set_has_value () {
    _has_bits_[0] |= 1u << 2;
}

inline void SetVolumeRequest::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SetVolumeResponse::SetVolumeResponse ()  :
    _result (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetVolumeResponse::SetVolumeResponse (const SetVolumeResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetVolumeResponse::SetVolumeResponse (int16 result_)  :
    _result (result_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetVolumeResponse::~SetVolumeResponse() {
}

inline SetVolumeResponse& SetVolumeResponse::operator = (const SetVolumeResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool SetVolumeResponse::operator == (const SetVolumeResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool SetVolumeResponse::operator != (const SetVolumeResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetVolumeResponse::operator < (const SetVolumeResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if (getResult() < rhs.getResult()) return true;
        if (getResult() > rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetVolumeResponse::clone() {
    return new SetVolumeResponse(*this);
}

inline bool SetVolumeResponse::operator > (const SetVolumeResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetVolumeResponse::clear() {
    clearResult();
}

inline void SetVolumeResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = 0;
     }
}

inline bool SetVolumeResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 SetVolumeResponse::getResult () const {
    return _result;
}

inline void SetVolumeResponse::setResult (int16 result_) {
    set_has_result();
    this->_result = result_;
}

inline void SetVolumeResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetVolumeResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetSinkMuteStateRequest::SetSinkMuteStateRequest ()  :
    _sinkID (0u),
    _muteState (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetSinkMuteStateRequest::SetSinkMuteStateRequest (const SetSinkMuteStateRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _sinkID (0u),
    _muteState (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetSinkMuteStateRequest::SetSinkMuteStateRequest (uint16 sinkID_, int16 muteState_)  :
    _sinkID (sinkID_),
    _muteState (muteState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetSinkMuteStateRequest::~SetSinkMuteStateRequest() {
}

inline SetSinkMuteStateRequest& SetSinkMuteStateRequest::operator = (const SetSinkMuteStateRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSinkID()) {
            setSinkID(rhs.getSinkID());
        } else {
            clearSinkID();
        }
        if (rhs.hasMuteState()) {
            setMuteState(rhs.getMuteState());
        } else {
            clearMuteState();
        }
    }
    return *this;
}

inline bool SetSinkMuteStateRequest::operator == (const SetSinkMuteStateRequest& rhs) const {
    return (((!hasSinkID() && !rhs.hasSinkID()) || getSinkID() == rhs.getSinkID()) &&
        ((!hasMuteState() && !rhs.hasMuteState()) || getMuteState() == rhs.getMuteState()));
}

inline bool SetSinkMuteStateRequest::operator != (const SetSinkMuteStateRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetSinkMuteStateRequest::operator < (const SetSinkMuteStateRequest& rhs) const {
    if (hasSinkID() || rhs.hasSinkID()) {
        if (getSinkID() < rhs.getSinkID()) return true;
        if (getSinkID() > rhs.getSinkID()) return false;
    }
    if (hasMuteState() || rhs.hasMuteState()) {
        if (getMuteState() < rhs.getMuteState()) return true;
        if (getMuteState() > rhs.getMuteState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetSinkMuteStateRequest::clone() {
    return new SetSinkMuteStateRequest(*this);
}

inline bool SetSinkMuteStateRequest::operator > (const SetSinkMuteStateRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetSinkMuteStateRequest::clear() {
    clearSinkID();
    clearMuteState();
}

inline void SetSinkMuteStateRequest::clearSinkID() {
    if (hasSinkID()) {
         clear_has_sinkID();
        _sinkID = 0u;
     }
}

inline bool SetSinkMuteStateRequest::hasSinkID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SetSinkMuteStateRequest::getSinkID () const {
    return _sinkID;
}

inline void SetSinkMuteStateRequest::setSinkID (uint16 sinkID_) {
    set_has_sinkID();
    this->_sinkID = sinkID_;
}

inline void SetSinkMuteStateRequest::clearMuteState() {
    if (hasMuteState()) {
         clear_has_muteState();
        _muteState = 0;
     }
}

inline bool SetSinkMuteStateRequest::hasMuteState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 SetSinkMuteStateRequest::getMuteState () const {
    return _muteState;
}

inline void SetSinkMuteStateRequest::setMuteState (int16 muteState_) {
    set_has_muteState();
    this->_muteState = muteState_;
}

inline void SetSinkMuteStateRequest::set_has_sinkID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetSinkMuteStateRequest::clear_has_sinkID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetSinkMuteStateRequest::set_has_muteState () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetSinkMuteStateRequest::clear_has_muteState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetSinkMuteStateResponse::SetSinkMuteStateResponse ()  :
    _result (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetSinkMuteStateResponse::SetSinkMuteStateResponse (const SetSinkMuteStateResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetSinkMuteStateResponse::SetSinkMuteStateResponse (int16 result_)  :
    _result (result_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetSinkMuteStateResponse::~SetSinkMuteStateResponse() {
}

inline SetSinkMuteStateResponse& SetSinkMuteStateResponse::operator = (const SetSinkMuteStateResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool SetSinkMuteStateResponse::operator == (const SetSinkMuteStateResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool SetSinkMuteStateResponse::operator != (const SetSinkMuteStateResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetSinkMuteStateResponse::operator < (const SetSinkMuteStateResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if (getResult() < rhs.getResult()) return true;
        if (getResult() > rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetSinkMuteStateResponse::clone() {
    return new SetSinkMuteStateResponse(*this);
}

inline bool SetSinkMuteStateResponse::operator > (const SetSinkMuteStateResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetSinkMuteStateResponse::clear() {
    clearResult();
}

inline void SetSinkMuteStateResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = 0;
     }
}

inline bool SetSinkMuteStateResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 SetSinkMuteStateResponse::getResult () const {
    return _result;
}

inline void SetSinkMuteStateResponse::setResult (int16 result_) {
    set_has_result();
    this->_result = result_;
}

inline void SetSinkMuteStateResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetSinkMuteStateResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetMainSinkSoundPropertyRequestSoundPropertyStruct::SetMainSinkSoundPropertyRequestSoundPropertyStruct ()  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetMainSinkSoundPropertyRequestSoundPropertyStruct::SetMainSinkSoundPropertyRequestSoundPropertyStruct (const SetMainSinkSoundPropertyRequestSoundPropertyStruct &rhs)  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetMainSinkSoundPropertyRequestSoundPropertyStruct::SetMainSinkSoundPropertyRequestSoundPropertyStruct (int16 elem1_, int16 elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetMainSinkSoundPropertyRequestSoundPropertyStruct::~SetMainSinkSoundPropertyRequestSoundPropertyStruct() {
}

inline SetMainSinkSoundPropertyRequestSoundPropertyStruct& SetMainSinkSoundPropertyRequestSoundPropertyStruct::operator = (const SetMainSinkSoundPropertyRequestSoundPropertyStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool SetMainSinkSoundPropertyRequestSoundPropertyStruct::operator == (const SetMainSinkSoundPropertyRequestSoundPropertyStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool SetMainSinkSoundPropertyRequestSoundPropertyStruct::operator != (const SetMainSinkSoundPropertyRequestSoundPropertyStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool SetMainSinkSoundPropertyRequestSoundPropertyStruct::operator < (const SetMainSinkSoundPropertyRequestSoundPropertyStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool SetMainSinkSoundPropertyRequestSoundPropertyStruct::operator > (const SetMainSinkSoundPropertyRequestSoundPropertyStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetMainSinkSoundPropertyRequestSoundPropertyStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void SetMainSinkSoundPropertyRequestSoundPropertyStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0;
     }
}

inline bool SetMainSinkSoundPropertyRequestSoundPropertyStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 SetMainSinkSoundPropertyRequestSoundPropertyStruct::getElem1 () const {
    return _elem1;
}

inline void SetMainSinkSoundPropertyRequestSoundPropertyStruct::setElem1 (int16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void SetMainSinkSoundPropertyRequestSoundPropertyStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0;
     }
}

inline bool SetMainSinkSoundPropertyRequestSoundPropertyStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 SetMainSinkSoundPropertyRequestSoundPropertyStruct::getElem2 () const {
    return _elem2;
}

inline void SetMainSinkSoundPropertyRequestSoundPropertyStruct::setElem2 (int16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void SetMainSinkSoundPropertyRequestSoundPropertyStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetMainSinkSoundPropertyRequestSoundPropertyStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetMainSinkSoundPropertyRequestSoundPropertyStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetMainSinkSoundPropertyRequestSoundPropertyStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetMainSinkSoundPropertyRequest::SetMainSinkSoundPropertyRequest ()  :
    _sinkID (0u),
    _soundProperty ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetMainSinkSoundPropertyRequest::SetMainSinkSoundPropertyRequest (const SetMainSinkSoundPropertyRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _sinkID (0u),
    _soundProperty ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetMainSinkSoundPropertyRequest::SetMainSinkSoundPropertyRequest (uint16 sinkID_, const SetMainSinkSoundPropertyRequestSoundPropertyStruct& soundProperty_)  :
    _sinkID (sinkID_),
    _soundProperty (soundProperty_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetMainSinkSoundPropertyRequest::~SetMainSinkSoundPropertyRequest() {
}

inline SetMainSinkSoundPropertyRequest& SetMainSinkSoundPropertyRequest::operator = (const SetMainSinkSoundPropertyRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSinkID()) {
            setSinkID(rhs.getSinkID());
        } else {
            clearSinkID();
        }
        if (rhs.hasSoundProperty()) {
            setSoundProperty(rhs.getSoundProperty());
        } else {
            clearSoundProperty();
        }
    }
    return *this;
}

inline bool SetMainSinkSoundPropertyRequest::operator == (const SetMainSinkSoundPropertyRequest& rhs) const {
    return (((!hasSinkID() && !rhs.hasSinkID()) || getSinkID() == rhs.getSinkID()) &&
        ((!hasSoundProperty() && !rhs.hasSoundProperty()) || getSoundProperty() == rhs.getSoundProperty()));
}

inline bool SetMainSinkSoundPropertyRequest::operator != (const SetMainSinkSoundPropertyRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetMainSinkSoundPropertyRequest::operator < (const SetMainSinkSoundPropertyRequest& rhs) const {
    if (hasSinkID() || rhs.hasSinkID()) {
        if (getSinkID() < rhs.getSinkID()) return true;
        if (getSinkID() > rhs.getSinkID()) return false;
    }
    if (hasSoundProperty() || rhs.hasSoundProperty()) {
        if (getSoundProperty() < rhs.getSoundProperty()) return true;
        if (getSoundProperty() > rhs.getSoundProperty()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetMainSinkSoundPropertyRequest::clone() {
    return new SetMainSinkSoundPropertyRequest(*this);
}

inline bool SetMainSinkSoundPropertyRequest::operator > (const SetMainSinkSoundPropertyRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetMainSinkSoundPropertyRequest::clear() {
    clearSinkID();
    clearSoundProperty();
}

inline void SetMainSinkSoundPropertyRequest::clearSinkID() {
    if (hasSinkID()) {
         clear_has_sinkID();
        _sinkID = 0u;
     }
}

inline bool SetMainSinkSoundPropertyRequest::hasSinkID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SetMainSinkSoundPropertyRequest::getSinkID () const {
    return _sinkID;
}

inline void SetMainSinkSoundPropertyRequest::setSinkID (uint16 sinkID_) {
    set_has_sinkID();
    this->_sinkID = sinkID_;
}

inline void SetMainSinkSoundPropertyRequest::clearSoundProperty() {
    if (hasSoundProperty()) {
         clear_has_soundProperty();
        _soundProperty.clear();
     }
}

inline bool SetMainSinkSoundPropertyRequest::hasSoundProperty () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const SetMainSinkSoundPropertyRequestSoundPropertyStruct& SetMainSinkSoundPropertyRequest::getSoundProperty () const {
    return _soundProperty;
}

inline SetMainSinkSoundPropertyRequestSoundPropertyStruct& SetMainSinkSoundPropertyRequest::getSoundPropertyMutable () {
    set_has_soundProperty();
    return _soundProperty;
}

inline void SetMainSinkSoundPropertyRequest::setSoundProperty (const SetMainSinkSoundPropertyRequestSoundPropertyStruct& soundProperty_) {
    set_has_soundProperty();
    this->_soundProperty = soundProperty_;
}

inline void SetMainSinkSoundPropertyRequest::set_has_sinkID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetMainSinkSoundPropertyRequest::clear_has_sinkID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetMainSinkSoundPropertyRequest::set_has_soundProperty () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetMainSinkSoundPropertyRequest::clear_has_soundProperty () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetMainSinkSoundPropertyResponse::SetMainSinkSoundPropertyResponse ()  :
    _result (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetMainSinkSoundPropertyResponse::SetMainSinkSoundPropertyResponse (const SetMainSinkSoundPropertyResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetMainSinkSoundPropertyResponse::SetMainSinkSoundPropertyResponse (int16 result_)  :
    _result (result_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetMainSinkSoundPropertyResponse::~SetMainSinkSoundPropertyResponse() {
}

inline SetMainSinkSoundPropertyResponse& SetMainSinkSoundPropertyResponse::operator = (const SetMainSinkSoundPropertyResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool SetMainSinkSoundPropertyResponse::operator == (const SetMainSinkSoundPropertyResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool SetMainSinkSoundPropertyResponse::operator != (const SetMainSinkSoundPropertyResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetMainSinkSoundPropertyResponse::operator < (const SetMainSinkSoundPropertyResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if (getResult() < rhs.getResult()) return true;
        if (getResult() > rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetMainSinkSoundPropertyResponse::clone() {
    return new SetMainSinkSoundPropertyResponse(*this);
}

inline bool SetMainSinkSoundPropertyResponse::operator > (const SetMainSinkSoundPropertyResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetMainSinkSoundPropertyResponse::clear() {
    clearResult();
}

inline void SetMainSinkSoundPropertyResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = 0;
     }
}

inline bool SetMainSinkSoundPropertyResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 SetMainSinkSoundPropertyResponse::getResult () const {
    return _result;
}

inline void SetMainSinkSoundPropertyResponse::setResult (int16 result_) {
    set_has_result();
    this->_result = result_;
}

inline void SetMainSinkSoundPropertyResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetMainSinkSoundPropertyResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetMainSourceSoundPropertyRequestSoundPropertyStruct::SetMainSourceSoundPropertyRequestSoundPropertyStruct ()  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetMainSourceSoundPropertyRequestSoundPropertyStruct::SetMainSourceSoundPropertyRequestSoundPropertyStruct (const SetMainSourceSoundPropertyRequestSoundPropertyStruct &rhs)  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetMainSourceSoundPropertyRequestSoundPropertyStruct::SetMainSourceSoundPropertyRequestSoundPropertyStruct (int16 elem1_, int16 elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetMainSourceSoundPropertyRequestSoundPropertyStruct::~SetMainSourceSoundPropertyRequestSoundPropertyStruct() {
}

inline SetMainSourceSoundPropertyRequestSoundPropertyStruct& SetMainSourceSoundPropertyRequestSoundPropertyStruct::operator = (const SetMainSourceSoundPropertyRequestSoundPropertyStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool SetMainSourceSoundPropertyRequestSoundPropertyStruct::operator == (const SetMainSourceSoundPropertyRequestSoundPropertyStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool SetMainSourceSoundPropertyRequestSoundPropertyStruct::operator != (const SetMainSourceSoundPropertyRequestSoundPropertyStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool SetMainSourceSoundPropertyRequestSoundPropertyStruct::operator < (const SetMainSourceSoundPropertyRequestSoundPropertyStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool SetMainSourceSoundPropertyRequestSoundPropertyStruct::operator > (const SetMainSourceSoundPropertyRequestSoundPropertyStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetMainSourceSoundPropertyRequestSoundPropertyStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void SetMainSourceSoundPropertyRequestSoundPropertyStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0;
     }
}

inline bool SetMainSourceSoundPropertyRequestSoundPropertyStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 SetMainSourceSoundPropertyRequestSoundPropertyStruct::getElem1 () const {
    return _elem1;
}

inline void SetMainSourceSoundPropertyRequestSoundPropertyStruct::setElem1 (int16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void SetMainSourceSoundPropertyRequestSoundPropertyStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0;
     }
}

inline bool SetMainSourceSoundPropertyRequestSoundPropertyStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 SetMainSourceSoundPropertyRequestSoundPropertyStruct::getElem2 () const {
    return _elem2;
}

inline void SetMainSourceSoundPropertyRequestSoundPropertyStruct::setElem2 (int16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void SetMainSourceSoundPropertyRequestSoundPropertyStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetMainSourceSoundPropertyRequestSoundPropertyStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetMainSourceSoundPropertyRequestSoundPropertyStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetMainSourceSoundPropertyRequestSoundPropertyStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetMainSourceSoundPropertyRequest::SetMainSourceSoundPropertyRequest ()  :
    _sourceID (0u),
    _soundProperty ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetMainSourceSoundPropertyRequest::SetMainSourceSoundPropertyRequest (const SetMainSourceSoundPropertyRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _sourceID (0u),
    _soundProperty ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetMainSourceSoundPropertyRequest::SetMainSourceSoundPropertyRequest (uint16 sourceID_, const SetMainSourceSoundPropertyRequestSoundPropertyStruct& soundProperty_)  :
    _sourceID (sourceID_),
    _soundProperty (soundProperty_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetMainSourceSoundPropertyRequest::~SetMainSourceSoundPropertyRequest() {
}

inline SetMainSourceSoundPropertyRequest& SetMainSourceSoundPropertyRequest::operator = (const SetMainSourceSoundPropertyRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSourceID()) {
            setSourceID(rhs.getSourceID());
        } else {
            clearSourceID();
        }
        if (rhs.hasSoundProperty()) {
            setSoundProperty(rhs.getSoundProperty());
        } else {
            clearSoundProperty();
        }
    }
    return *this;
}

inline bool SetMainSourceSoundPropertyRequest::operator == (const SetMainSourceSoundPropertyRequest& rhs) const {
    return (((!hasSourceID() && !rhs.hasSourceID()) || getSourceID() == rhs.getSourceID()) &&
        ((!hasSoundProperty() && !rhs.hasSoundProperty()) || getSoundProperty() == rhs.getSoundProperty()));
}

inline bool SetMainSourceSoundPropertyRequest::operator != (const SetMainSourceSoundPropertyRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetMainSourceSoundPropertyRequest::operator < (const SetMainSourceSoundPropertyRequest& rhs) const {
    if (hasSourceID() || rhs.hasSourceID()) {
        if (getSourceID() < rhs.getSourceID()) return true;
        if (getSourceID() > rhs.getSourceID()) return false;
    }
    if (hasSoundProperty() || rhs.hasSoundProperty()) {
        if (getSoundProperty() < rhs.getSoundProperty()) return true;
        if (getSoundProperty() > rhs.getSoundProperty()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetMainSourceSoundPropertyRequest::clone() {
    return new SetMainSourceSoundPropertyRequest(*this);
}

inline bool SetMainSourceSoundPropertyRequest::operator > (const SetMainSourceSoundPropertyRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetMainSourceSoundPropertyRequest::clear() {
    clearSourceID();
    clearSoundProperty();
}

inline void SetMainSourceSoundPropertyRequest::clearSourceID() {
    if (hasSourceID()) {
         clear_has_sourceID();
        _sourceID = 0u;
     }
}

inline bool SetMainSourceSoundPropertyRequest::hasSourceID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SetMainSourceSoundPropertyRequest::getSourceID () const {
    return _sourceID;
}

inline void SetMainSourceSoundPropertyRequest::setSourceID (uint16 sourceID_) {
    set_has_sourceID();
    this->_sourceID = sourceID_;
}

inline void SetMainSourceSoundPropertyRequest::clearSoundProperty() {
    if (hasSoundProperty()) {
         clear_has_soundProperty();
        _soundProperty.clear();
     }
}

inline bool SetMainSourceSoundPropertyRequest::hasSoundProperty () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const SetMainSourceSoundPropertyRequestSoundPropertyStruct& SetMainSourceSoundPropertyRequest::getSoundProperty () const {
    return _soundProperty;
}

inline SetMainSourceSoundPropertyRequestSoundPropertyStruct& SetMainSourceSoundPropertyRequest::getSoundPropertyMutable () {
    set_has_soundProperty();
    return _soundProperty;
}

inline void SetMainSourceSoundPropertyRequest::setSoundProperty (const SetMainSourceSoundPropertyRequestSoundPropertyStruct& soundProperty_) {
    set_has_soundProperty();
    this->_soundProperty = soundProperty_;
}

inline void SetMainSourceSoundPropertyRequest::set_has_sourceID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetMainSourceSoundPropertyRequest::clear_has_sourceID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetMainSourceSoundPropertyRequest::set_has_soundProperty () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetMainSourceSoundPropertyRequest::clear_has_soundProperty () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetMainSourceSoundPropertyResponse::SetMainSourceSoundPropertyResponse ()  :
    _result (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetMainSourceSoundPropertyResponse::SetMainSourceSoundPropertyResponse (const SetMainSourceSoundPropertyResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetMainSourceSoundPropertyResponse::SetMainSourceSoundPropertyResponse (int16 result_)  :
    _result (result_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetMainSourceSoundPropertyResponse::~SetMainSourceSoundPropertyResponse() {
}

inline SetMainSourceSoundPropertyResponse& SetMainSourceSoundPropertyResponse::operator = (const SetMainSourceSoundPropertyResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool SetMainSourceSoundPropertyResponse::operator == (const SetMainSourceSoundPropertyResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool SetMainSourceSoundPropertyResponse::operator != (const SetMainSourceSoundPropertyResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetMainSourceSoundPropertyResponse::operator < (const SetMainSourceSoundPropertyResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if (getResult() < rhs.getResult()) return true;
        if (getResult() > rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetMainSourceSoundPropertyResponse::clone() {
    return new SetMainSourceSoundPropertyResponse(*this);
}

inline bool SetMainSourceSoundPropertyResponse::operator > (const SetMainSourceSoundPropertyResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetMainSourceSoundPropertyResponse::clear() {
    clearResult();
}

inline void SetMainSourceSoundPropertyResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = 0;
     }
}

inline bool SetMainSourceSoundPropertyResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 SetMainSourceSoundPropertyResponse::getResult () const {
    return _result;
}

inline void SetMainSourceSoundPropertyResponse::setResult (int16 result_) {
    set_has_result();
    this->_result = result_;
}

inline void SetMainSourceSoundPropertyResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetMainSourceSoundPropertyResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetSystemPropertyRequestPropertyStruct::SetSystemPropertyRequestPropertyStruct ()  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetSystemPropertyRequestPropertyStruct::SetSystemPropertyRequestPropertyStruct (const SetSystemPropertyRequestPropertyStruct &rhs)  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetSystemPropertyRequestPropertyStruct::SetSystemPropertyRequestPropertyStruct (int16 elem1_, int16 elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetSystemPropertyRequestPropertyStruct::~SetSystemPropertyRequestPropertyStruct() {
}

inline SetSystemPropertyRequestPropertyStruct& SetSystemPropertyRequestPropertyStruct::operator = (const SetSystemPropertyRequestPropertyStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool SetSystemPropertyRequestPropertyStruct::operator == (const SetSystemPropertyRequestPropertyStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool SetSystemPropertyRequestPropertyStruct::operator != (const SetSystemPropertyRequestPropertyStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool SetSystemPropertyRequestPropertyStruct::operator < (const SetSystemPropertyRequestPropertyStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool SetSystemPropertyRequestPropertyStruct::operator > (const SetSystemPropertyRequestPropertyStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetSystemPropertyRequestPropertyStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void SetSystemPropertyRequestPropertyStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0;
     }
}

inline bool SetSystemPropertyRequestPropertyStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 SetSystemPropertyRequestPropertyStruct::getElem1 () const {
    return _elem1;
}

inline void SetSystemPropertyRequestPropertyStruct::setElem1 (int16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void SetSystemPropertyRequestPropertyStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0;
     }
}

inline bool SetSystemPropertyRequestPropertyStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 SetSystemPropertyRequestPropertyStruct::getElem2 () const {
    return _elem2;
}

inline void SetSystemPropertyRequestPropertyStruct::setElem2 (int16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void SetSystemPropertyRequestPropertyStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetSystemPropertyRequestPropertyStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetSystemPropertyRequestPropertyStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetSystemPropertyRequestPropertyStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetSystemPropertyRequest::SetSystemPropertyRequest ()  :
    _property ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetSystemPropertyRequest::SetSystemPropertyRequest (const SetSystemPropertyRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _property ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetSystemPropertyRequest::SetSystemPropertyRequest (const SetSystemPropertyRequestPropertyStruct& property_)  :
    _property (property_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetSystemPropertyRequest::~SetSystemPropertyRequest() {
}

inline SetSystemPropertyRequest& SetSystemPropertyRequest::operator = (const SetSystemPropertyRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProperty()) {
            setProperty(rhs.getProperty());
        } else {
            clearProperty();
        }
    }
    return *this;
}

inline bool SetSystemPropertyRequest::operator == (const SetSystemPropertyRequest& rhs) const {
    return (((!hasProperty() && !rhs.hasProperty()) || getProperty() == rhs.getProperty()));
}

inline bool SetSystemPropertyRequest::operator != (const SetSystemPropertyRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetSystemPropertyRequest::operator < (const SetSystemPropertyRequest& rhs) const {
    if (hasProperty() || rhs.hasProperty()) {
        if (getProperty() < rhs.getProperty()) return true;
        if (getProperty() > rhs.getProperty()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetSystemPropertyRequest::clone() {
    return new SetSystemPropertyRequest(*this);
}

inline bool SetSystemPropertyRequest::operator > (const SetSystemPropertyRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetSystemPropertyRequest::clear() {
    clearProperty();
}

inline void SetSystemPropertyRequest::clearProperty() {
    if (hasProperty()) {
         clear_has_property();
        _property.clear();
     }
}

inline bool SetSystemPropertyRequest::hasProperty () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const SetSystemPropertyRequestPropertyStruct& SetSystemPropertyRequest::getProperty () const {
    return _property;
}

inline SetSystemPropertyRequestPropertyStruct& SetSystemPropertyRequest::getPropertyMutable () {
    set_has_property();
    return _property;
}

inline void SetSystemPropertyRequest::setProperty (const SetSystemPropertyRequestPropertyStruct& property_) {
    set_has_property();
    this->_property = property_;
}

inline void SetSystemPropertyRequest::set_has_property () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetSystemPropertyRequest::clear_has_property () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetSystemPropertyResponse::SetSystemPropertyResponse ()  :
    _result (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetSystemPropertyResponse::SetSystemPropertyResponse (const SetSystemPropertyResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetSystemPropertyResponse::SetSystemPropertyResponse (int16 result_)  :
    _result (result_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetSystemPropertyResponse::~SetSystemPropertyResponse() {
}

inline SetSystemPropertyResponse& SetSystemPropertyResponse::operator = (const SetSystemPropertyResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool SetSystemPropertyResponse::operator == (const SetSystemPropertyResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool SetSystemPropertyResponse::operator != (const SetSystemPropertyResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetSystemPropertyResponse::operator < (const SetSystemPropertyResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if (getResult() < rhs.getResult()) return true;
        if (getResult() > rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetSystemPropertyResponse::clone() {
    return new SetSystemPropertyResponse(*this);
}

inline bool SetSystemPropertyResponse::operator > (const SetSystemPropertyResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetSystemPropertyResponse::clear() {
    clearResult();
}

inline void SetSystemPropertyResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = 0;
     }
}

inline bool SetSystemPropertyResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 SetSystemPropertyResponse::getResult () const {
    return _result;
}

inline void SetSystemPropertyResponse::setResult (int16 result_) {
    set_has_result();
    this->_result = result_;
}

inline void SetSystemPropertyResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetSystemPropertyResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetListMainConnectionsResponseListConnectionsStruct::GetListMainConnectionsResponseListConnectionsStruct ()  :
    _elem1 (0u),
    _elem2 (0u),
    _elem3 (0u),
    _elem4 (0),
    _elem5 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListMainConnectionsResponseListConnectionsStruct::GetListMainConnectionsResponseListConnectionsStruct (const GetListMainConnectionsResponseListConnectionsStruct &rhs)  :
    _elem1 (0u),
    _elem2 (0u),
    _elem3 (0u),
    _elem4 (0),
    _elem5 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListMainConnectionsResponseListConnectionsStruct::GetListMainConnectionsResponseListConnectionsStruct (uint16 elem1_, uint16 elem2_, uint16 elem3_, int16 elem4_, int16 elem5_)  :
    _elem1 (elem1_),
    _elem2 (elem2_),
    _elem3 (elem3_),
    _elem4 (elem4_),
    _elem5 (elem5_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListMainConnectionsResponseListConnectionsStruct::~GetListMainConnectionsResponseListConnectionsStruct() {
}

inline GetListMainConnectionsResponseListConnectionsStruct& GetListMainConnectionsResponseListConnectionsStruct::operator = (const GetListMainConnectionsResponseListConnectionsStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
        if (rhs.hasElem3()) {
            setElem3(rhs.getElem3());
        } else {
            clearElem3();
        }
        if (rhs.hasElem4()) {
            setElem4(rhs.getElem4());
        } else {
            clearElem4();
        }
        if (rhs.hasElem5()) {
            setElem5(rhs.getElem5());
        } else {
            clearElem5();
        }
    }
    return *this;
}

inline bool GetListMainConnectionsResponseListConnectionsStruct::operator == (const GetListMainConnectionsResponseListConnectionsStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()) &&
        ((!hasElem3() && !rhs.hasElem3()) || getElem3() == rhs.getElem3()) &&
        ((!hasElem4() && !rhs.hasElem4()) || getElem4() == rhs.getElem4()) &&
        ((!hasElem5() && !rhs.hasElem5()) || getElem5() == rhs.getElem5()));
}

inline bool GetListMainConnectionsResponseListConnectionsStruct::operator != (const GetListMainConnectionsResponseListConnectionsStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListMainConnectionsResponseListConnectionsStruct::operator < (const GetListMainConnectionsResponseListConnectionsStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    if (hasElem3() || rhs.hasElem3()) {
        if (getElem3() < rhs.getElem3()) return true;
        if (getElem3() > rhs.getElem3()) return false;
    }
    if (hasElem4() || rhs.hasElem4()) {
        if (getElem4() < rhs.getElem4()) return true;
        if (getElem4() > rhs.getElem4()) return false;
    }
    if (hasElem5() || rhs.hasElem5()) {
        if (getElem5() < rhs.getElem5()) return true;
        if (getElem5() > rhs.getElem5()) return false;
    }
    return false;
}

inline bool GetListMainConnectionsResponseListConnectionsStruct::operator > (const GetListMainConnectionsResponseListConnectionsStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListMainConnectionsResponseListConnectionsStruct::clear() {
    clearElem1();
    clearElem2();
    clearElem3();
    clearElem4();
    clearElem5();
}

inline void GetListMainConnectionsResponseListConnectionsStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0u;
     }
}

inline bool GetListMainConnectionsResponseListConnectionsStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 GetListMainConnectionsResponseListConnectionsStruct::getElem1 () const {
    return _elem1;
}

inline void GetListMainConnectionsResponseListConnectionsStruct::setElem1 (uint16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void GetListMainConnectionsResponseListConnectionsStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0u;
     }
}

inline bool GetListMainConnectionsResponseListConnectionsStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 GetListMainConnectionsResponseListConnectionsStruct::getElem2 () const {
    return _elem2;
}

inline void GetListMainConnectionsResponseListConnectionsStruct::setElem2 (uint16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void GetListMainConnectionsResponseListConnectionsStruct::clearElem3() {
    if (hasElem3()) {
         clear_has_elem3();
        _elem3 = 0u;
     }
}

inline bool GetListMainConnectionsResponseListConnectionsStruct::hasElem3 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 GetListMainConnectionsResponseListConnectionsStruct::getElem3 () const {
    return _elem3;
}

inline void GetListMainConnectionsResponseListConnectionsStruct::setElem3 (uint16 elem3_) {
    set_has_elem3();
    this->_elem3 = elem3_;
}

inline void GetListMainConnectionsResponseListConnectionsStruct::clearElem4() {
    if (hasElem4()) {
         clear_has_elem4();
        _elem4 = 0;
     }
}

inline bool GetListMainConnectionsResponseListConnectionsStruct::hasElem4 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int16 GetListMainConnectionsResponseListConnectionsStruct::getElem4 () const {
    return _elem4;
}

inline void GetListMainConnectionsResponseListConnectionsStruct::setElem4 (int16 elem4_) {
    set_has_elem4();
    this->_elem4 = elem4_;
}

inline void GetListMainConnectionsResponseListConnectionsStruct::clearElem5() {
    if (hasElem5()) {
         clear_has_elem5();
        _elem5 = 0;
     }
}

inline bool GetListMainConnectionsResponseListConnectionsStruct::hasElem5 () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline int16 GetListMainConnectionsResponseListConnectionsStruct::getElem5 () const {
    return _elem5;
}

inline void GetListMainConnectionsResponseListConnectionsStruct::setElem5 (int16 elem5_) {
    set_has_elem5();
    this->_elem5 = elem5_;
}

inline void GetListMainConnectionsResponseListConnectionsStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListMainConnectionsResponseListConnectionsStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetListMainConnectionsResponseListConnectionsStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetListMainConnectionsResponseListConnectionsStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetListMainConnectionsResponseListConnectionsStruct::set_has_elem3 () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetListMainConnectionsResponseListConnectionsStruct::clear_has_elem3 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetListMainConnectionsResponseListConnectionsStruct::set_has_elem4 () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetListMainConnectionsResponseListConnectionsStruct::clear_has_elem4 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void GetListMainConnectionsResponseListConnectionsStruct::set_has_elem5 () {
    _has_bits_[0] |= 1u << 4;
}

inline void GetListMainConnectionsResponseListConnectionsStruct::clear_has_elem5 () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  GetListMainConnectionsResponse::GetListMainConnectionsResponse ()  :
    _result (0),
    _listConnections ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListMainConnectionsResponse::GetListMainConnectionsResponse (const GetListMainConnectionsResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (0),
    _listConnections ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListMainConnectionsResponse::GetListMainConnectionsResponse (int16 result_, const ::std::vector< GetListMainConnectionsResponseListConnectionsStruct >& listConnections_)  :
    _result (result_),
    _listConnections (listConnections_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListMainConnectionsResponse::~GetListMainConnectionsResponse() {
}

inline GetListMainConnectionsResponse& GetListMainConnectionsResponse::operator = (const GetListMainConnectionsResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
        if (rhs.hasListConnections()) {
            setListConnections(rhs.getListConnections());
        } else {
            clearListConnections();
        }
    }
    return *this;
}

inline bool GetListMainConnectionsResponse::operator == (const GetListMainConnectionsResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()) &&
        ((!hasListConnections() && !rhs.hasListConnections()) || getListConnections() == rhs.getListConnections()));
}

inline bool GetListMainConnectionsResponse::operator != (const GetListMainConnectionsResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListMainConnectionsResponse::operator < (const GetListMainConnectionsResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if (getResult() < rhs.getResult()) return true;
        if (getResult() > rhs.getResult()) return false;
    }
    if (hasListConnections() || rhs.hasListConnections()) {
        if (getListConnections() < rhs.getListConnections()) return true;
        if (getListConnections() > rhs.getListConnections()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetListMainConnectionsResponse::clone() {
    return new GetListMainConnectionsResponse(*this);
}

inline bool GetListMainConnectionsResponse::operator > (const GetListMainConnectionsResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListMainConnectionsResponse::clear() {
    clearResult();
    clearListConnections();
}

inline void GetListMainConnectionsResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = 0;
     }
}

inline bool GetListMainConnectionsResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 GetListMainConnectionsResponse::getResult () const {
    return _result;
}

inline void GetListMainConnectionsResponse::setResult (int16 result_) {
    set_has_result();
    this->_result = result_;
}

inline void GetListMainConnectionsResponse::clearListConnections() {
    if (hasListConnections()) {
         clear_has_listConnections();
        _listConnections.clear();
     }
}

inline bool GetListMainConnectionsResponse::hasListConnections () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< GetListMainConnectionsResponseListConnectionsStruct >& GetListMainConnectionsResponse::getListConnections () const {
    return _listConnections;
}

inline ::std::vector< GetListMainConnectionsResponseListConnectionsStruct >& GetListMainConnectionsResponse::getListConnectionsMutable () {
    set_has_listConnections();
    return _listConnections;
}

inline void GetListMainConnectionsResponse::setListConnections (const ::std::vector< GetListMainConnectionsResponseListConnectionsStruct >& listConnections_) {
    set_has_listConnections();
    this->_listConnections = listConnections_;
}

inline void GetListMainConnectionsResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListMainConnectionsResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetListMainConnectionsResponse::set_has_listConnections () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetListMainConnectionsResponse::clear_has_listConnections () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetListMainSinksResponseListMainSinksElem3Struct::GetListMainSinksResponseListMainSinksElem3Struct ()  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListMainSinksResponseListMainSinksElem3Struct::GetListMainSinksResponseListMainSinksElem3Struct (const GetListMainSinksResponseListMainSinksElem3Struct &rhs)  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListMainSinksResponseListMainSinksElem3Struct::GetListMainSinksResponseListMainSinksElem3Struct (int16 elem1_, int16 elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListMainSinksResponseListMainSinksElem3Struct::~GetListMainSinksResponseListMainSinksElem3Struct() {
}

inline GetListMainSinksResponseListMainSinksElem3Struct& GetListMainSinksResponseListMainSinksElem3Struct::operator = (const GetListMainSinksResponseListMainSinksElem3Struct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool GetListMainSinksResponseListMainSinksElem3Struct::operator == (const GetListMainSinksResponseListMainSinksElem3Struct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool GetListMainSinksResponseListMainSinksElem3Struct::operator != (const GetListMainSinksResponseListMainSinksElem3Struct& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListMainSinksResponseListMainSinksElem3Struct::operator < (const GetListMainSinksResponseListMainSinksElem3Struct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool GetListMainSinksResponseListMainSinksElem3Struct::operator > (const GetListMainSinksResponseListMainSinksElem3Struct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListMainSinksResponseListMainSinksElem3Struct::clear() {
    clearElem1();
    clearElem2();
}

inline void GetListMainSinksResponseListMainSinksElem3Struct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0;
     }
}

inline bool GetListMainSinksResponseListMainSinksElem3Struct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 GetListMainSinksResponseListMainSinksElem3Struct::getElem1 () const {
    return _elem1;
}

inline void GetListMainSinksResponseListMainSinksElem3Struct::setElem1 (int16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void GetListMainSinksResponseListMainSinksElem3Struct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0;
     }
}

inline bool GetListMainSinksResponseListMainSinksElem3Struct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 GetListMainSinksResponseListMainSinksElem3Struct::getElem2 () const {
    return _elem2;
}

inline void GetListMainSinksResponseListMainSinksElem3Struct::setElem2 (int16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void GetListMainSinksResponseListMainSinksElem3Struct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListMainSinksResponseListMainSinksElem3Struct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetListMainSinksResponseListMainSinksElem3Struct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetListMainSinksResponseListMainSinksElem3Struct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetListMainSinksResponseListMainSinksStruct::GetListMainSinksResponseListMainSinksStruct ()  :
    _elem1 (0u),
    _elem2 (),
    _elem3 (),
    _elem4 (0),
    _elem5 (0),
    _elem6 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListMainSinksResponseListMainSinksStruct::GetListMainSinksResponseListMainSinksStruct (const GetListMainSinksResponseListMainSinksStruct &rhs)  :
    _elem1 (0u),
    _elem2 (),
    _elem3 (),
    _elem4 (0),
    _elem5 (0),
    _elem6 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListMainSinksResponseListMainSinksStruct::GetListMainSinksResponseListMainSinksStruct (uint16 elem1_, const ::std::string& elem2_, const GetListMainSinksResponseListMainSinksElem3Struct& elem3_, int16 elem4_, int16 elem5_, uint16 elem6_)  :
    _elem1 (elem1_),
    _elem2 (elem2_),
    _elem3 (elem3_),
    _elem4 (elem4_),
    _elem5 (elem5_),
    _elem6 (elem6_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem2_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListMainSinksResponseListMainSinksStruct::~GetListMainSinksResponseListMainSinksStruct() {
}

inline GetListMainSinksResponseListMainSinksStruct& GetListMainSinksResponseListMainSinksStruct::operator = (const GetListMainSinksResponseListMainSinksStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
        if (rhs.hasElem3()) {
            setElem3(rhs.getElem3());
        } else {
            clearElem3();
        }
        if (rhs.hasElem4()) {
            setElem4(rhs.getElem4());
        } else {
            clearElem4();
        }
        if (rhs.hasElem5()) {
            setElem5(rhs.getElem5());
        } else {
            clearElem5();
        }
        if (rhs.hasElem6()) {
            setElem6(rhs.getElem6());
        } else {
            clearElem6();
        }
    }
    return *this;
}

inline bool GetListMainSinksResponseListMainSinksStruct::operator == (const GetListMainSinksResponseListMainSinksStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()) &&
        ((!hasElem3() && !rhs.hasElem3()) || getElem3() == rhs.getElem3()) &&
        ((!hasElem4() && !rhs.hasElem4()) || getElem4() == rhs.getElem4()) &&
        ((!hasElem5() && !rhs.hasElem5()) || getElem5() == rhs.getElem5()) &&
        ((!hasElem6() && !rhs.hasElem6()) || getElem6() == rhs.getElem6()));
}

inline bool GetListMainSinksResponseListMainSinksStruct::operator != (const GetListMainSinksResponseListMainSinksStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListMainSinksResponseListMainSinksStruct::operator < (const GetListMainSinksResponseListMainSinksStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    if (hasElem3() || rhs.hasElem3()) {
        if (getElem3() < rhs.getElem3()) return true;
        if (getElem3() > rhs.getElem3()) return false;
    }
    if (hasElem4() || rhs.hasElem4()) {
        if (getElem4() < rhs.getElem4()) return true;
        if (getElem4() > rhs.getElem4()) return false;
    }
    if (hasElem5() || rhs.hasElem5()) {
        if (getElem5() < rhs.getElem5()) return true;
        if (getElem5() > rhs.getElem5()) return false;
    }
    if (hasElem6() || rhs.hasElem6()) {
        if (getElem6() < rhs.getElem6()) return true;
        if (getElem6() > rhs.getElem6()) return false;
    }
    return false;
}

inline bool GetListMainSinksResponseListMainSinksStruct::operator > (const GetListMainSinksResponseListMainSinksStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListMainSinksResponseListMainSinksStruct::clear() {
    clearElem1();
    clearElem2();
    clearElem3();
    clearElem4();
    clearElem5();
    clearElem6();
}

inline void GetListMainSinksResponseListMainSinksStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0u;
     }
}

inline bool GetListMainSinksResponseListMainSinksStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 GetListMainSinksResponseListMainSinksStruct::getElem1 () const {
    return _elem1;
}

inline void GetListMainSinksResponseListMainSinksStruct::setElem1 (uint16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void GetListMainSinksResponseListMainSinksStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool GetListMainSinksResponseListMainSinksStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& GetListMainSinksResponseListMainSinksStruct::getElem2 () const {
    return _elem2;
}

inline ::std::string& GetListMainSinksResponseListMainSinksStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void GetListMainSinksResponseListMainSinksStruct::setElem2 (const ::std::string& elem2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void GetListMainSinksResponseListMainSinksStruct::setElem2 (const char* elem2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem2();
    this->_elem2.assign(elem2_);
}

inline void GetListMainSinksResponseListMainSinksStruct::setElem2 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem2();
    this->_elem2.assign(value, size);
}

inline void GetListMainSinksResponseListMainSinksStruct::clearElem3() {
    if (hasElem3()) {
         clear_has_elem3();
        _elem3.clear();
     }
}

inline bool GetListMainSinksResponseListMainSinksStruct::hasElem3 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const GetListMainSinksResponseListMainSinksElem3Struct& GetListMainSinksResponseListMainSinksStruct::getElem3 () const {
    return _elem3;
}

inline GetListMainSinksResponseListMainSinksElem3Struct& GetListMainSinksResponseListMainSinksStruct::getElem3Mutable () {
    set_has_elem3();
    return _elem3;
}

inline void GetListMainSinksResponseListMainSinksStruct::setElem3 (const GetListMainSinksResponseListMainSinksElem3Struct& elem3_) {
    set_has_elem3();
    this->_elem3 = elem3_;
}

inline void GetListMainSinksResponseListMainSinksStruct::clearElem4() {
    if (hasElem4()) {
         clear_has_elem4();
        _elem4 = 0;
     }
}

inline bool GetListMainSinksResponseListMainSinksStruct::hasElem4 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int16 GetListMainSinksResponseListMainSinksStruct::getElem4 () const {
    return _elem4;
}

inline void GetListMainSinksResponseListMainSinksStruct::setElem4 (int16 elem4_) {
    set_has_elem4();
    this->_elem4 = elem4_;
}

inline void GetListMainSinksResponseListMainSinksStruct::clearElem5() {
    if (hasElem5()) {
         clear_has_elem5();
        _elem5 = 0;
     }
}

inline bool GetListMainSinksResponseListMainSinksStruct::hasElem5 () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline int16 GetListMainSinksResponseListMainSinksStruct::getElem5 () const {
    return _elem5;
}

inline void GetListMainSinksResponseListMainSinksStruct::setElem5 (int16 elem5_) {
    set_has_elem5();
    this->_elem5 = elem5_;
}

inline void GetListMainSinksResponseListMainSinksStruct::clearElem6() {
    if (hasElem6()) {
         clear_has_elem6();
        _elem6 = 0u;
     }
}

inline bool GetListMainSinksResponseListMainSinksStruct::hasElem6 () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint16 GetListMainSinksResponseListMainSinksStruct::getElem6 () const {
    return _elem6;
}

inline void GetListMainSinksResponseListMainSinksStruct::setElem6 (uint16 elem6_) {
    set_has_elem6();
    this->_elem6 = elem6_;
}

inline void GetListMainSinksResponseListMainSinksStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListMainSinksResponseListMainSinksStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetListMainSinksResponseListMainSinksStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetListMainSinksResponseListMainSinksStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetListMainSinksResponseListMainSinksStruct::set_has_elem3 () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetListMainSinksResponseListMainSinksStruct::clear_has_elem3 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetListMainSinksResponseListMainSinksStruct::set_has_elem4 () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetListMainSinksResponseListMainSinksStruct::clear_has_elem4 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void GetListMainSinksResponseListMainSinksStruct::set_has_elem5 () {
    _has_bits_[0] |= 1u << 4;
}

inline void GetListMainSinksResponseListMainSinksStruct::clear_has_elem5 () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void GetListMainSinksResponseListMainSinksStruct::set_has_elem6 () {
    _has_bits_[0] |= 1u << 5;
}

inline void GetListMainSinksResponseListMainSinksStruct::clear_has_elem6 () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  GetListMainSinksResponse::GetListMainSinksResponse ()  :
    _result (0),
    _listMainSinks ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListMainSinksResponse::GetListMainSinksResponse (const GetListMainSinksResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (0),
    _listMainSinks ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListMainSinksResponse::GetListMainSinksResponse (int16 result_, const ::std::vector< GetListMainSinksResponseListMainSinksStruct >& listMainSinks_)  :
    _result (result_),
    _listMainSinks (listMainSinks_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListMainSinksResponse::~GetListMainSinksResponse() {
}

inline GetListMainSinksResponse& GetListMainSinksResponse::operator = (const GetListMainSinksResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
        if (rhs.hasListMainSinks()) {
            setListMainSinks(rhs.getListMainSinks());
        } else {
            clearListMainSinks();
        }
    }
    return *this;
}

inline bool GetListMainSinksResponse::operator == (const GetListMainSinksResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()) &&
        ((!hasListMainSinks() && !rhs.hasListMainSinks()) || getListMainSinks() == rhs.getListMainSinks()));
}

inline bool GetListMainSinksResponse::operator != (const GetListMainSinksResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListMainSinksResponse::operator < (const GetListMainSinksResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if (getResult() < rhs.getResult()) return true;
        if (getResult() > rhs.getResult()) return false;
    }
    if (hasListMainSinks() || rhs.hasListMainSinks()) {
        if (getListMainSinks() < rhs.getListMainSinks()) return true;
        if (getListMainSinks() > rhs.getListMainSinks()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetListMainSinksResponse::clone() {
    return new GetListMainSinksResponse(*this);
}

inline bool GetListMainSinksResponse::operator > (const GetListMainSinksResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListMainSinksResponse::clear() {
    clearResult();
    clearListMainSinks();
}

inline void GetListMainSinksResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = 0;
     }
}

inline bool GetListMainSinksResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 GetListMainSinksResponse::getResult () const {
    return _result;
}

inline void GetListMainSinksResponse::setResult (int16 result_) {
    set_has_result();
    this->_result = result_;
}

inline void GetListMainSinksResponse::clearListMainSinks() {
    if (hasListMainSinks()) {
         clear_has_listMainSinks();
        _listMainSinks.clear();
     }
}

inline bool GetListMainSinksResponse::hasListMainSinks () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< GetListMainSinksResponseListMainSinksStruct >& GetListMainSinksResponse::getListMainSinks () const {
    return _listMainSinks;
}

inline ::std::vector< GetListMainSinksResponseListMainSinksStruct >& GetListMainSinksResponse::getListMainSinksMutable () {
    set_has_listMainSinks();
    return _listMainSinks;
}

inline void GetListMainSinksResponse::setListMainSinks (const ::std::vector< GetListMainSinksResponseListMainSinksStruct >& listMainSinks_) {
    set_has_listMainSinks();
    this->_listMainSinks = listMainSinks_;
}

inline void GetListMainSinksResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListMainSinksResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetListMainSinksResponse::set_has_listMainSinks () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetListMainSinksResponse::clear_has_listMainSinks () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetListMainSourcesResponseListMainSourcesElem3Struct::GetListMainSourcesResponseListMainSourcesElem3Struct ()  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListMainSourcesResponseListMainSourcesElem3Struct::GetListMainSourcesResponseListMainSourcesElem3Struct (const GetListMainSourcesResponseListMainSourcesElem3Struct &rhs)  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListMainSourcesResponseListMainSourcesElem3Struct::GetListMainSourcesResponseListMainSourcesElem3Struct (int16 elem1_, int16 elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListMainSourcesResponseListMainSourcesElem3Struct::~GetListMainSourcesResponseListMainSourcesElem3Struct() {
}

inline GetListMainSourcesResponseListMainSourcesElem3Struct& GetListMainSourcesResponseListMainSourcesElem3Struct::operator = (const GetListMainSourcesResponseListMainSourcesElem3Struct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool GetListMainSourcesResponseListMainSourcesElem3Struct::operator == (const GetListMainSourcesResponseListMainSourcesElem3Struct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool GetListMainSourcesResponseListMainSourcesElem3Struct::operator != (const GetListMainSourcesResponseListMainSourcesElem3Struct& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListMainSourcesResponseListMainSourcesElem3Struct::operator < (const GetListMainSourcesResponseListMainSourcesElem3Struct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool GetListMainSourcesResponseListMainSourcesElem3Struct::operator > (const GetListMainSourcesResponseListMainSourcesElem3Struct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListMainSourcesResponseListMainSourcesElem3Struct::clear() {
    clearElem1();
    clearElem2();
}

inline void GetListMainSourcesResponseListMainSourcesElem3Struct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0;
     }
}

inline bool GetListMainSourcesResponseListMainSourcesElem3Struct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 GetListMainSourcesResponseListMainSourcesElem3Struct::getElem1 () const {
    return _elem1;
}

inline void GetListMainSourcesResponseListMainSourcesElem3Struct::setElem1 (int16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void GetListMainSourcesResponseListMainSourcesElem3Struct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0;
     }
}

inline bool GetListMainSourcesResponseListMainSourcesElem3Struct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 GetListMainSourcesResponseListMainSourcesElem3Struct::getElem2 () const {
    return _elem2;
}

inline void GetListMainSourcesResponseListMainSourcesElem3Struct::setElem2 (int16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void GetListMainSourcesResponseListMainSourcesElem3Struct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListMainSourcesResponseListMainSourcesElem3Struct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetListMainSourcesResponseListMainSourcesElem3Struct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetListMainSourcesResponseListMainSourcesElem3Struct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetListMainSourcesResponseListMainSourcesStruct::GetListMainSourcesResponseListMainSourcesStruct ()  :
    _elem1 (0u),
    _elem2 (),
    _elem3 (),
    _elem4 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListMainSourcesResponseListMainSourcesStruct::GetListMainSourcesResponseListMainSourcesStruct (const GetListMainSourcesResponseListMainSourcesStruct &rhs)  :
    _elem1 (0u),
    _elem2 (),
    _elem3 (),
    _elem4 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListMainSourcesResponseListMainSourcesStruct::GetListMainSourcesResponseListMainSourcesStruct (uint16 elem1_, const ::std::string& elem2_, const GetListMainSourcesResponseListMainSourcesElem3Struct& elem3_, uint16 elem4_)  :
    _elem1 (elem1_),
    _elem2 (elem2_),
    _elem3 (elem3_),
    _elem4 (elem4_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem2_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListMainSourcesResponseListMainSourcesStruct::~GetListMainSourcesResponseListMainSourcesStruct() {
}

inline GetListMainSourcesResponseListMainSourcesStruct& GetListMainSourcesResponseListMainSourcesStruct::operator = (const GetListMainSourcesResponseListMainSourcesStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
        if (rhs.hasElem3()) {
            setElem3(rhs.getElem3());
        } else {
            clearElem3();
        }
        if (rhs.hasElem4()) {
            setElem4(rhs.getElem4());
        } else {
            clearElem4();
        }
    }
    return *this;
}

inline bool GetListMainSourcesResponseListMainSourcesStruct::operator == (const GetListMainSourcesResponseListMainSourcesStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()) &&
        ((!hasElem3() && !rhs.hasElem3()) || getElem3() == rhs.getElem3()) &&
        ((!hasElem4() && !rhs.hasElem4()) || getElem4() == rhs.getElem4()));
}

inline bool GetListMainSourcesResponseListMainSourcesStruct::operator != (const GetListMainSourcesResponseListMainSourcesStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListMainSourcesResponseListMainSourcesStruct::operator < (const GetListMainSourcesResponseListMainSourcesStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    if (hasElem3() || rhs.hasElem3()) {
        if (getElem3() < rhs.getElem3()) return true;
        if (getElem3() > rhs.getElem3()) return false;
    }
    if (hasElem4() || rhs.hasElem4()) {
        if (getElem4() < rhs.getElem4()) return true;
        if (getElem4() > rhs.getElem4()) return false;
    }
    return false;
}

inline bool GetListMainSourcesResponseListMainSourcesStruct::operator > (const GetListMainSourcesResponseListMainSourcesStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListMainSourcesResponseListMainSourcesStruct::clear() {
    clearElem1();
    clearElem2();
    clearElem3();
    clearElem4();
}

inline void GetListMainSourcesResponseListMainSourcesStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0u;
     }
}

inline bool GetListMainSourcesResponseListMainSourcesStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 GetListMainSourcesResponseListMainSourcesStruct::getElem1 () const {
    return _elem1;
}

inline void GetListMainSourcesResponseListMainSourcesStruct::setElem1 (uint16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void GetListMainSourcesResponseListMainSourcesStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool GetListMainSourcesResponseListMainSourcesStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& GetListMainSourcesResponseListMainSourcesStruct::getElem2 () const {
    return _elem2;
}

inline ::std::string& GetListMainSourcesResponseListMainSourcesStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void GetListMainSourcesResponseListMainSourcesStruct::setElem2 (const ::std::string& elem2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void GetListMainSourcesResponseListMainSourcesStruct::setElem2 (const char* elem2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem2();
    this->_elem2.assign(elem2_);
}

inline void GetListMainSourcesResponseListMainSourcesStruct::setElem2 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem2();
    this->_elem2.assign(value, size);
}

inline void GetListMainSourcesResponseListMainSourcesStruct::clearElem3() {
    if (hasElem3()) {
         clear_has_elem3();
        _elem3.clear();
     }
}

inline bool GetListMainSourcesResponseListMainSourcesStruct::hasElem3 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const GetListMainSourcesResponseListMainSourcesElem3Struct& GetListMainSourcesResponseListMainSourcesStruct::getElem3 () const {
    return _elem3;
}

inline GetListMainSourcesResponseListMainSourcesElem3Struct& GetListMainSourcesResponseListMainSourcesStruct::getElem3Mutable () {
    set_has_elem3();
    return _elem3;
}

inline void GetListMainSourcesResponseListMainSourcesStruct::setElem3 (const GetListMainSourcesResponseListMainSourcesElem3Struct& elem3_) {
    set_has_elem3();
    this->_elem3 = elem3_;
}

inline void GetListMainSourcesResponseListMainSourcesStruct::clearElem4() {
    if (hasElem4()) {
         clear_has_elem4();
        _elem4 = 0u;
     }
}

inline bool GetListMainSourcesResponseListMainSourcesStruct::hasElem4 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 GetListMainSourcesResponseListMainSourcesStruct::getElem4 () const {
    return _elem4;
}

inline void GetListMainSourcesResponseListMainSourcesStruct::setElem4 (uint16 elem4_) {
    set_has_elem4();
    this->_elem4 = elem4_;
}

inline void GetListMainSourcesResponseListMainSourcesStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListMainSourcesResponseListMainSourcesStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetListMainSourcesResponseListMainSourcesStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetListMainSourcesResponseListMainSourcesStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetListMainSourcesResponseListMainSourcesStruct::set_has_elem3 () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetListMainSourcesResponseListMainSourcesStruct::clear_has_elem3 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetListMainSourcesResponseListMainSourcesStruct::set_has_elem4 () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetListMainSourcesResponseListMainSourcesStruct::clear_has_elem4 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  GetListMainSourcesResponse::GetListMainSourcesResponse ()  :
    _result (0),
    _listMainSources ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListMainSourcesResponse::GetListMainSourcesResponse (const GetListMainSourcesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (0),
    _listMainSources ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListMainSourcesResponse::GetListMainSourcesResponse (int16 result_, const ::std::vector< GetListMainSourcesResponseListMainSourcesStruct >& listMainSources_)  :
    _result (result_),
    _listMainSources (listMainSources_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListMainSourcesResponse::~GetListMainSourcesResponse() {
}

inline GetListMainSourcesResponse& GetListMainSourcesResponse::operator = (const GetListMainSourcesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
        if (rhs.hasListMainSources()) {
            setListMainSources(rhs.getListMainSources());
        } else {
            clearListMainSources();
        }
    }
    return *this;
}

inline bool GetListMainSourcesResponse::operator == (const GetListMainSourcesResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()) &&
        ((!hasListMainSources() && !rhs.hasListMainSources()) || getListMainSources() == rhs.getListMainSources()));
}

inline bool GetListMainSourcesResponse::operator != (const GetListMainSourcesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListMainSourcesResponse::operator < (const GetListMainSourcesResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if (getResult() < rhs.getResult()) return true;
        if (getResult() > rhs.getResult()) return false;
    }
    if (hasListMainSources() || rhs.hasListMainSources()) {
        if (getListMainSources() < rhs.getListMainSources()) return true;
        if (getListMainSources() > rhs.getListMainSources()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetListMainSourcesResponse::clone() {
    return new GetListMainSourcesResponse(*this);
}

inline bool GetListMainSourcesResponse::operator > (const GetListMainSourcesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListMainSourcesResponse::clear() {
    clearResult();
    clearListMainSources();
}

inline void GetListMainSourcesResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = 0;
     }
}

inline bool GetListMainSourcesResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 GetListMainSourcesResponse::getResult () const {
    return _result;
}

inline void GetListMainSourcesResponse::setResult (int16 result_) {
    set_has_result();
    this->_result = result_;
}

inline void GetListMainSourcesResponse::clearListMainSources() {
    if (hasListMainSources()) {
         clear_has_listMainSources();
        _listMainSources.clear();
     }
}

inline bool GetListMainSourcesResponse::hasListMainSources () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< GetListMainSourcesResponseListMainSourcesStruct >& GetListMainSourcesResponse::getListMainSources () const {
    return _listMainSources;
}

inline ::std::vector< GetListMainSourcesResponseListMainSourcesStruct >& GetListMainSourcesResponse::getListMainSourcesMutable () {
    set_has_listMainSources();
    return _listMainSources;
}

inline void GetListMainSourcesResponse::setListMainSources (const ::std::vector< GetListMainSourcesResponseListMainSourcesStruct >& listMainSources_) {
    set_has_listMainSources();
    this->_listMainSources = listMainSources_;
}

inline void GetListMainSourcesResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListMainSourcesResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetListMainSourcesResponse::set_has_listMainSources () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetListMainSourcesResponse::clear_has_listMainSources () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetListMainSinkSoundPropertiesRequest::GetListMainSinkSoundPropertiesRequest ()  :
    _sinkID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListMainSinkSoundPropertiesRequest::GetListMainSinkSoundPropertiesRequest (const GetListMainSinkSoundPropertiesRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _sinkID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListMainSinkSoundPropertiesRequest::GetListMainSinkSoundPropertiesRequest (uint16 sinkID_)  :
    _sinkID (sinkID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListMainSinkSoundPropertiesRequest::~GetListMainSinkSoundPropertiesRequest() {
}

inline GetListMainSinkSoundPropertiesRequest& GetListMainSinkSoundPropertiesRequest::operator = (const GetListMainSinkSoundPropertiesRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSinkID()) {
            setSinkID(rhs.getSinkID());
        } else {
            clearSinkID();
        }
    }
    return *this;
}

inline bool GetListMainSinkSoundPropertiesRequest::operator == (const GetListMainSinkSoundPropertiesRequest& rhs) const {
    return (((!hasSinkID() && !rhs.hasSinkID()) || getSinkID() == rhs.getSinkID()));
}

inline bool GetListMainSinkSoundPropertiesRequest::operator != (const GetListMainSinkSoundPropertiesRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListMainSinkSoundPropertiesRequest::operator < (const GetListMainSinkSoundPropertiesRequest& rhs) const {
    if (hasSinkID() || rhs.hasSinkID()) {
        if (getSinkID() < rhs.getSinkID()) return true;
        if (getSinkID() > rhs.getSinkID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetListMainSinkSoundPropertiesRequest::clone() {
    return new GetListMainSinkSoundPropertiesRequest(*this);
}

inline bool GetListMainSinkSoundPropertiesRequest::operator > (const GetListMainSinkSoundPropertiesRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListMainSinkSoundPropertiesRequest::clear() {
    clearSinkID();
}

inline void GetListMainSinkSoundPropertiesRequest::clearSinkID() {
    if (hasSinkID()) {
         clear_has_sinkID();
        _sinkID = 0u;
     }
}

inline bool GetListMainSinkSoundPropertiesRequest::hasSinkID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 GetListMainSinkSoundPropertiesRequest::getSinkID () const {
    return _sinkID;
}

inline void GetListMainSinkSoundPropertiesRequest::setSinkID (uint16 sinkID_) {
    set_has_sinkID();
    this->_sinkID = sinkID_;
}

inline void GetListMainSinkSoundPropertiesRequest::set_has_sinkID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListMainSinkSoundPropertiesRequest::clear_has_sinkID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct::GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct ()  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct::GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct (const GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct &rhs)  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct::GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct (int16 elem1_, int16 elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct::~GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct() {
}

inline GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct& GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct::operator = (const GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct::operator == (const GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct::operator != (const GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct::operator < (const GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct::operator > (const GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0;
     }
}

inline bool GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct::getElem1 () const {
    return _elem1;
}

inline void GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct::setElem1 (int16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0;
     }
}

inline bool GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct::getElem2 () const {
    return _elem2;
}

inline void GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct::setElem2 (int16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetListMainSinkSoundPropertiesResponse::GetListMainSinkSoundPropertiesResponse ()  :
    _result (0),
    _listSoundProperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListMainSinkSoundPropertiesResponse::GetListMainSinkSoundPropertiesResponse (const GetListMainSinkSoundPropertiesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (0),
    _listSoundProperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListMainSinkSoundPropertiesResponse::GetListMainSinkSoundPropertiesResponse (int16 result_, const ::std::vector< GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct >& listSoundProperties_)  :
    _result (result_),
    _listSoundProperties (listSoundProperties_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListMainSinkSoundPropertiesResponse::~GetListMainSinkSoundPropertiesResponse() {
}

inline GetListMainSinkSoundPropertiesResponse& GetListMainSinkSoundPropertiesResponse::operator = (const GetListMainSinkSoundPropertiesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
        if (rhs.hasListSoundProperties()) {
            setListSoundProperties(rhs.getListSoundProperties());
        } else {
            clearListSoundProperties();
        }
    }
    return *this;
}

inline bool GetListMainSinkSoundPropertiesResponse::operator == (const GetListMainSinkSoundPropertiesResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()) &&
        ((!hasListSoundProperties() && !rhs.hasListSoundProperties()) || getListSoundProperties() == rhs.getListSoundProperties()));
}

inline bool GetListMainSinkSoundPropertiesResponse::operator != (const GetListMainSinkSoundPropertiesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListMainSinkSoundPropertiesResponse::operator < (const GetListMainSinkSoundPropertiesResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if (getResult() < rhs.getResult()) return true;
        if (getResult() > rhs.getResult()) return false;
    }
    if (hasListSoundProperties() || rhs.hasListSoundProperties()) {
        if (getListSoundProperties() < rhs.getListSoundProperties()) return true;
        if (getListSoundProperties() > rhs.getListSoundProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetListMainSinkSoundPropertiesResponse::clone() {
    return new GetListMainSinkSoundPropertiesResponse(*this);
}

inline bool GetListMainSinkSoundPropertiesResponse::operator > (const GetListMainSinkSoundPropertiesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListMainSinkSoundPropertiesResponse::clear() {
    clearResult();
    clearListSoundProperties();
}

inline void GetListMainSinkSoundPropertiesResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = 0;
     }
}

inline bool GetListMainSinkSoundPropertiesResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 GetListMainSinkSoundPropertiesResponse::getResult () const {
    return _result;
}

inline void GetListMainSinkSoundPropertiesResponse::setResult (int16 result_) {
    set_has_result();
    this->_result = result_;
}

inline void GetListMainSinkSoundPropertiesResponse::clearListSoundProperties() {
    if (hasListSoundProperties()) {
         clear_has_listSoundProperties();
        _listSoundProperties.clear();
     }
}

inline bool GetListMainSinkSoundPropertiesResponse::hasListSoundProperties () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct >& GetListMainSinkSoundPropertiesResponse::getListSoundProperties () const {
    return _listSoundProperties;
}

inline ::std::vector< GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct >& GetListMainSinkSoundPropertiesResponse::getListSoundPropertiesMutable () {
    set_has_listSoundProperties();
    return _listSoundProperties;
}

inline void GetListMainSinkSoundPropertiesResponse::setListSoundProperties (const ::std::vector< GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct >& listSoundProperties_) {
    set_has_listSoundProperties();
    this->_listSoundProperties = listSoundProperties_;
}

inline void GetListMainSinkSoundPropertiesResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListMainSinkSoundPropertiesResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetListMainSinkSoundPropertiesResponse::set_has_listSoundProperties () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetListMainSinkSoundPropertiesResponse::clear_has_listSoundProperties () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetListMainSourceSoundPropertiesRequest::GetListMainSourceSoundPropertiesRequest ()  :
    _sourceID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListMainSourceSoundPropertiesRequest::GetListMainSourceSoundPropertiesRequest (const GetListMainSourceSoundPropertiesRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _sourceID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListMainSourceSoundPropertiesRequest::GetListMainSourceSoundPropertiesRequest (uint16 sourceID_)  :
    _sourceID (sourceID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListMainSourceSoundPropertiesRequest::~GetListMainSourceSoundPropertiesRequest() {
}

inline GetListMainSourceSoundPropertiesRequest& GetListMainSourceSoundPropertiesRequest::operator = (const GetListMainSourceSoundPropertiesRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSourceID()) {
            setSourceID(rhs.getSourceID());
        } else {
            clearSourceID();
        }
    }
    return *this;
}

inline bool GetListMainSourceSoundPropertiesRequest::operator == (const GetListMainSourceSoundPropertiesRequest& rhs) const {
    return (((!hasSourceID() && !rhs.hasSourceID()) || getSourceID() == rhs.getSourceID()));
}

inline bool GetListMainSourceSoundPropertiesRequest::operator != (const GetListMainSourceSoundPropertiesRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListMainSourceSoundPropertiesRequest::operator < (const GetListMainSourceSoundPropertiesRequest& rhs) const {
    if (hasSourceID() || rhs.hasSourceID()) {
        if (getSourceID() < rhs.getSourceID()) return true;
        if (getSourceID() > rhs.getSourceID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetListMainSourceSoundPropertiesRequest::clone() {
    return new GetListMainSourceSoundPropertiesRequest(*this);
}

inline bool GetListMainSourceSoundPropertiesRequest::operator > (const GetListMainSourceSoundPropertiesRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListMainSourceSoundPropertiesRequest::clear() {
    clearSourceID();
}

inline void GetListMainSourceSoundPropertiesRequest::clearSourceID() {
    if (hasSourceID()) {
         clear_has_sourceID();
        _sourceID = 0u;
     }
}

inline bool GetListMainSourceSoundPropertiesRequest::hasSourceID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 GetListMainSourceSoundPropertiesRequest::getSourceID () const {
    return _sourceID;
}

inline void GetListMainSourceSoundPropertiesRequest::setSourceID (uint16 sourceID_) {
    set_has_sourceID();
    this->_sourceID = sourceID_;
}

inline void GetListMainSourceSoundPropertiesRequest::set_has_sourceID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListMainSourceSoundPropertiesRequest::clear_has_sourceID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct::GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct ()  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct::GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct (const GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct &rhs)  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct::GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct (int16 elem1_, int16 elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct::~GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct() {
}

inline GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct& GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct::operator = (const GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct::operator == (const GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct::operator != (const GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct::operator < (const GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct::operator > (const GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0;
     }
}

inline bool GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct::getElem1 () const {
    return _elem1;
}

inline void GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct::setElem1 (int16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0;
     }
}

inline bool GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct::getElem2 () const {
    return _elem2;
}

inline void GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct::setElem2 (int16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetListMainSourceSoundPropertiesResponse::GetListMainSourceSoundPropertiesResponse ()  :
    _result (0),
    _listSourceProperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListMainSourceSoundPropertiesResponse::GetListMainSourceSoundPropertiesResponse (const GetListMainSourceSoundPropertiesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (0),
    _listSourceProperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListMainSourceSoundPropertiesResponse::GetListMainSourceSoundPropertiesResponse (int16 result_, const ::std::vector< GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct >& listSourceProperties_)  :
    _result (result_),
    _listSourceProperties (listSourceProperties_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListMainSourceSoundPropertiesResponse::~GetListMainSourceSoundPropertiesResponse() {
}

inline GetListMainSourceSoundPropertiesResponse& GetListMainSourceSoundPropertiesResponse::operator = (const GetListMainSourceSoundPropertiesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
        if (rhs.hasListSourceProperties()) {
            setListSourceProperties(rhs.getListSourceProperties());
        } else {
            clearListSourceProperties();
        }
    }
    return *this;
}

inline bool GetListMainSourceSoundPropertiesResponse::operator == (const GetListMainSourceSoundPropertiesResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()) &&
        ((!hasListSourceProperties() && !rhs.hasListSourceProperties()) || getListSourceProperties() == rhs.getListSourceProperties()));
}

inline bool GetListMainSourceSoundPropertiesResponse::operator != (const GetListMainSourceSoundPropertiesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListMainSourceSoundPropertiesResponse::operator < (const GetListMainSourceSoundPropertiesResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if (getResult() < rhs.getResult()) return true;
        if (getResult() > rhs.getResult()) return false;
    }
    if (hasListSourceProperties() || rhs.hasListSourceProperties()) {
        if (getListSourceProperties() < rhs.getListSourceProperties()) return true;
        if (getListSourceProperties() > rhs.getListSourceProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetListMainSourceSoundPropertiesResponse::clone() {
    return new GetListMainSourceSoundPropertiesResponse(*this);
}

inline bool GetListMainSourceSoundPropertiesResponse::operator > (const GetListMainSourceSoundPropertiesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListMainSourceSoundPropertiesResponse::clear() {
    clearResult();
    clearListSourceProperties();
}

inline void GetListMainSourceSoundPropertiesResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = 0;
     }
}

inline bool GetListMainSourceSoundPropertiesResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 GetListMainSourceSoundPropertiesResponse::getResult () const {
    return _result;
}

inline void GetListMainSourceSoundPropertiesResponse::setResult (int16 result_) {
    set_has_result();
    this->_result = result_;
}

inline void GetListMainSourceSoundPropertiesResponse::clearListSourceProperties() {
    if (hasListSourceProperties()) {
         clear_has_listSourceProperties();
        _listSourceProperties.clear();
     }
}

inline bool GetListMainSourceSoundPropertiesResponse::hasListSourceProperties () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct >& GetListMainSourceSoundPropertiesResponse::getListSourceProperties () const {
    return _listSourceProperties;
}

inline ::std::vector< GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct >& GetListMainSourceSoundPropertiesResponse::getListSourcePropertiesMutable () {
    set_has_listSourceProperties();
    return _listSourceProperties;
}

inline void GetListMainSourceSoundPropertiesResponse::setListSourceProperties (const ::std::vector< GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct >& listSourceProperties_) {
    set_has_listSourceProperties();
    this->_listSourceProperties = listSourceProperties_;
}

inline void GetListMainSourceSoundPropertiesResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListMainSourceSoundPropertiesResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetListMainSourceSoundPropertiesResponse::set_has_listSourceProperties () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetListMainSourceSoundPropertiesResponse::clear_has_listSourceProperties () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetListSourceClassesResponseListSourceClassesElem3Struct::GetListSourceClassesResponseListSourceClassesElem3Struct ()  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListSourceClassesResponseListSourceClassesElem3Struct::GetListSourceClassesResponseListSourceClassesElem3Struct (const GetListSourceClassesResponseListSourceClassesElem3Struct &rhs)  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListSourceClassesResponseListSourceClassesElem3Struct::GetListSourceClassesResponseListSourceClassesElem3Struct (int16 elem1_, int16 elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListSourceClassesResponseListSourceClassesElem3Struct::~GetListSourceClassesResponseListSourceClassesElem3Struct() {
}

inline GetListSourceClassesResponseListSourceClassesElem3Struct& GetListSourceClassesResponseListSourceClassesElem3Struct::operator = (const GetListSourceClassesResponseListSourceClassesElem3Struct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool GetListSourceClassesResponseListSourceClassesElem3Struct::operator == (const GetListSourceClassesResponseListSourceClassesElem3Struct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool GetListSourceClassesResponseListSourceClassesElem3Struct::operator != (const GetListSourceClassesResponseListSourceClassesElem3Struct& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListSourceClassesResponseListSourceClassesElem3Struct::operator < (const GetListSourceClassesResponseListSourceClassesElem3Struct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool GetListSourceClassesResponseListSourceClassesElem3Struct::operator > (const GetListSourceClassesResponseListSourceClassesElem3Struct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListSourceClassesResponseListSourceClassesElem3Struct::clear() {
    clearElem1();
    clearElem2();
}

inline void GetListSourceClassesResponseListSourceClassesElem3Struct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0;
     }
}

inline bool GetListSourceClassesResponseListSourceClassesElem3Struct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 GetListSourceClassesResponseListSourceClassesElem3Struct::getElem1 () const {
    return _elem1;
}

inline void GetListSourceClassesResponseListSourceClassesElem3Struct::setElem1 (int16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void GetListSourceClassesResponseListSourceClassesElem3Struct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0;
     }
}

inline bool GetListSourceClassesResponseListSourceClassesElem3Struct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 GetListSourceClassesResponseListSourceClassesElem3Struct::getElem2 () const {
    return _elem2;
}

inline void GetListSourceClassesResponseListSourceClassesElem3Struct::setElem2 (int16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void GetListSourceClassesResponseListSourceClassesElem3Struct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListSourceClassesResponseListSourceClassesElem3Struct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetListSourceClassesResponseListSourceClassesElem3Struct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetListSourceClassesResponseListSourceClassesElem3Struct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetListSourceClassesResponseListSourceClassesStruct::GetListSourceClassesResponseListSourceClassesStruct ()  :
    _elem1 (0u),
    _elem2 (),
    _elem3 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListSourceClassesResponseListSourceClassesStruct::GetListSourceClassesResponseListSourceClassesStruct (const GetListSourceClassesResponseListSourceClassesStruct &rhs)  :
    _elem1 (0u),
    _elem2 (),
    _elem3 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListSourceClassesResponseListSourceClassesStruct::GetListSourceClassesResponseListSourceClassesStruct (uint16 elem1_, const ::std::string& elem2_, const ::std::vector< GetListSourceClassesResponseListSourceClassesElem3Struct >& elem3_)  :
    _elem1 (elem1_),
    _elem2 (elem2_),
    _elem3 (elem3_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem2_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListSourceClassesResponseListSourceClassesStruct::~GetListSourceClassesResponseListSourceClassesStruct() {
}

inline GetListSourceClassesResponseListSourceClassesStruct& GetListSourceClassesResponseListSourceClassesStruct::operator = (const GetListSourceClassesResponseListSourceClassesStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
        if (rhs.hasElem3()) {
            setElem3(rhs.getElem3());
        } else {
            clearElem3();
        }
    }
    return *this;
}

inline bool GetListSourceClassesResponseListSourceClassesStruct::operator == (const GetListSourceClassesResponseListSourceClassesStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()) &&
        ((!hasElem3() && !rhs.hasElem3()) || getElem3() == rhs.getElem3()));
}

inline bool GetListSourceClassesResponseListSourceClassesStruct::operator != (const GetListSourceClassesResponseListSourceClassesStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListSourceClassesResponseListSourceClassesStruct::operator < (const GetListSourceClassesResponseListSourceClassesStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    if (hasElem3() || rhs.hasElem3()) {
        if (getElem3() < rhs.getElem3()) return true;
        if (getElem3() > rhs.getElem3()) return false;
    }
    return false;
}

inline bool GetListSourceClassesResponseListSourceClassesStruct::operator > (const GetListSourceClassesResponseListSourceClassesStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListSourceClassesResponseListSourceClassesStruct::clear() {
    clearElem1();
    clearElem2();
    clearElem3();
}

inline void GetListSourceClassesResponseListSourceClassesStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0u;
     }
}

inline bool GetListSourceClassesResponseListSourceClassesStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 GetListSourceClassesResponseListSourceClassesStruct::getElem1 () const {
    return _elem1;
}

inline void GetListSourceClassesResponseListSourceClassesStruct::setElem1 (uint16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void GetListSourceClassesResponseListSourceClassesStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool GetListSourceClassesResponseListSourceClassesStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& GetListSourceClassesResponseListSourceClassesStruct::getElem2 () const {
    return _elem2;
}

inline ::std::string& GetListSourceClassesResponseListSourceClassesStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void GetListSourceClassesResponseListSourceClassesStruct::setElem2 (const ::std::string& elem2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void GetListSourceClassesResponseListSourceClassesStruct::setElem2 (const char* elem2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem2();
    this->_elem2.assign(elem2_);
}

inline void GetListSourceClassesResponseListSourceClassesStruct::setElem2 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem2();
    this->_elem2.assign(value, size);
}

inline void GetListSourceClassesResponseListSourceClassesStruct::clearElem3() {
    if (hasElem3()) {
         clear_has_elem3();
        _elem3.clear();
     }
}

inline bool GetListSourceClassesResponseListSourceClassesStruct::hasElem3 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< GetListSourceClassesResponseListSourceClassesElem3Struct >& GetListSourceClassesResponseListSourceClassesStruct::getElem3 () const {
    return _elem3;
}

inline ::std::vector< GetListSourceClassesResponseListSourceClassesElem3Struct >& GetListSourceClassesResponseListSourceClassesStruct::getElem3Mutable () {
    set_has_elem3();
    return _elem3;
}

inline void GetListSourceClassesResponseListSourceClassesStruct::setElem3 (const ::std::vector< GetListSourceClassesResponseListSourceClassesElem3Struct >& elem3_) {
    set_has_elem3();
    this->_elem3 = elem3_;
}

inline void GetListSourceClassesResponseListSourceClassesStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListSourceClassesResponseListSourceClassesStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetListSourceClassesResponseListSourceClassesStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetListSourceClassesResponseListSourceClassesStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetListSourceClassesResponseListSourceClassesStruct::set_has_elem3 () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetListSourceClassesResponseListSourceClassesStruct::clear_has_elem3 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  GetListSourceClassesResponse::GetListSourceClassesResponse ()  :
    _result (0),
    _listSourceClasses ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListSourceClassesResponse::GetListSourceClassesResponse (const GetListSourceClassesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (0),
    _listSourceClasses ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListSourceClassesResponse::GetListSourceClassesResponse (int16 result_, const ::std::vector< GetListSourceClassesResponseListSourceClassesStruct >& listSourceClasses_)  :
    _result (result_),
    _listSourceClasses (listSourceClasses_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListSourceClassesResponse::~GetListSourceClassesResponse() {
}

inline GetListSourceClassesResponse& GetListSourceClassesResponse::operator = (const GetListSourceClassesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
        if (rhs.hasListSourceClasses()) {
            setListSourceClasses(rhs.getListSourceClasses());
        } else {
            clearListSourceClasses();
        }
    }
    return *this;
}

inline bool GetListSourceClassesResponse::operator == (const GetListSourceClassesResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()) &&
        ((!hasListSourceClasses() && !rhs.hasListSourceClasses()) || getListSourceClasses() == rhs.getListSourceClasses()));
}

inline bool GetListSourceClassesResponse::operator != (const GetListSourceClassesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListSourceClassesResponse::operator < (const GetListSourceClassesResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if (getResult() < rhs.getResult()) return true;
        if (getResult() > rhs.getResult()) return false;
    }
    if (hasListSourceClasses() || rhs.hasListSourceClasses()) {
        if (getListSourceClasses() < rhs.getListSourceClasses()) return true;
        if (getListSourceClasses() > rhs.getListSourceClasses()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetListSourceClassesResponse::clone() {
    return new GetListSourceClassesResponse(*this);
}

inline bool GetListSourceClassesResponse::operator > (const GetListSourceClassesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListSourceClassesResponse::clear() {
    clearResult();
    clearListSourceClasses();
}

inline void GetListSourceClassesResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = 0;
     }
}

inline bool GetListSourceClassesResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 GetListSourceClassesResponse::getResult () const {
    return _result;
}

inline void GetListSourceClassesResponse::setResult (int16 result_) {
    set_has_result();
    this->_result = result_;
}

inline void GetListSourceClassesResponse::clearListSourceClasses() {
    if (hasListSourceClasses()) {
         clear_has_listSourceClasses();
        _listSourceClasses.clear();
     }
}

inline bool GetListSourceClassesResponse::hasListSourceClasses () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< GetListSourceClassesResponseListSourceClassesStruct >& GetListSourceClassesResponse::getListSourceClasses () const {
    return _listSourceClasses;
}

inline ::std::vector< GetListSourceClassesResponseListSourceClassesStruct >& GetListSourceClassesResponse::getListSourceClassesMutable () {
    set_has_listSourceClasses();
    return _listSourceClasses;
}

inline void GetListSourceClassesResponse::setListSourceClasses (const ::std::vector< GetListSourceClassesResponseListSourceClassesStruct >& listSourceClasses_) {
    set_has_listSourceClasses();
    this->_listSourceClasses = listSourceClasses_;
}

inline void GetListSourceClassesResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListSourceClassesResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetListSourceClassesResponse::set_has_listSourceClasses () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetListSourceClassesResponse::clear_has_listSourceClasses () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetListSinkClassesResponseListSinkClassesElem3Struct::GetListSinkClassesResponseListSinkClassesElem3Struct ()  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListSinkClassesResponseListSinkClassesElem3Struct::GetListSinkClassesResponseListSinkClassesElem3Struct (const GetListSinkClassesResponseListSinkClassesElem3Struct &rhs)  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListSinkClassesResponseListSinkClassesElem3Struct::GetListSinkClassesResponseListSinkClassesElem3Struct (int16 elem1_, int16 elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListSinkClassesResponseListSinkClassesElem3Struct::~GetListSinkClassesResponseListSinkClassesElem3Struct() {
}

inline GetListSinkClassesResponseListSinkClassesElem3Struct& GetListSinkClassesResponseListSinkClassesElem3Struct::operator = (const GetListSinkClassesResponseListSinkClassesElem3Struct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool GetListSinkClassesResponseListSinkClassesElem3Struct::operator == (const GetListSinkClassesResponseListSinkClassesElem3Struct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool GetListSinkClassesResponseListSinkClassesElem3Struct::operator != (const GetListSinkClassesResponseListSinkClassesElem3Struct& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListSinkClassesResponseListSinkClassesElem3Struct::operator < (const GetListSinkClassesResponseListSinkClassesElem3Struct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool GetListSinkClassesResponseListSinkClassesElem3Struct::operator > (const GetListSinkClassesResponseListSinkClassesElem3Struct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListSinkClassesResponseListSinkClassesElem3Struct::clear() {
    clearElem1();
    clearElem2();
}

inline void GetListSinkClassesResponseListSinkClassesElem3Struct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0;
     }
}

inline bool GetListSinkClassesResponseListSinkClassesElem3Struct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 GetListSinkClassesResponseListSinkClassesElem3Struct::getElem1 () const {
    return _elem1;
}

inline void GetListSinkClassesResponseListSinkClassesElem3Struct::setElem1 (int16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void GetListSinkClassesResponseListSinkClassesElem3Struct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0;
     }
}

inline bool GetListSinkClassesResponseListSinkClassesElem3Struct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 GetListSinkClassesResponseListSinkClassesElem3Struct::getElem2 () const {
    return _elem2;
}

inline void GetListSinkClassesResponseListSinkClassesElem3Struct::setElem2 (int16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void GetListSinkClassesResponseListSinkClassesElem3Struct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListSinkClassesResponseListSinkClassesElem3Struct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetListSinkClassesResponseListSinkClassesElem3Struct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetListSinkClassesResponseListSinkClassesElem3Struct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetListSinkClassesResponseListSinkClassesStruct::GetListSinkClassesResponseListSinkClassesStruct ()  :
    _elem1 (0u),
    _elem2 (),
    _elem3 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListSinkClassesResponseListSinkClassesStruct::GetListSinkClassesResponseListSinkClassesStruct (const GetListSinkClassesResponseListSinkClassesStruct &rhs)  :
    _elem1 (0u),
    _elem2 (),
    _elem3 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListSinkClassesResponseListSinkClassesStruct::GetListSinkClassesResponseListSinkClassesStruct (uint16 elem1_, const ::std::string& elem2_, const ::std::vector< GetListSinkClassesResponseListSinkClassesElem3Struct >& elem3_)  :
    _elem1 (elem1_),
    _elem2 (elem2_),
    _elem3 (elem3_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem2_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListSinkClassesResponseListSinkClassesStruct::~GetListSinkClassesResponseListSinkClassesStruct() {
}

inline GetListSinkClassesResponseListSinkClassesStruct& GetListSinkClassesResponseListSinkClassesStruct::operator = (const GetListSinkClassesResponseListSinkClassesStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
        if (rhs.hasElem3()) {
            setElem3(rhs.getElem3());
        } else {
            clearElem3();
        }
    }
    return *this;
}

inline bool GetListSinkClassesResponseListSinkClassesStruct::operator == (const GetListSinkClassesResponseListSinkClassesStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()) &&
        ((!hasElem3() && !rhs.hasElem3()) || getElem3() == rhs.getElem3()));
}

inline bool GetListSinkClassesResponseListSinkClassesStruct::operator != (const GetListSinkClassesResponseListSinkClassesStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListSinkClassesResponseListSinkClassesStruct::operator < (const GetListSinkClassesResponseListSinkClassesStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    if (hasElem3() || rhs.hasElem3()) {
        if (getElem3() < rhs.getElem3()) return true;
        if (getElem3() > rhs.getElem3()) return false;
    }
    return false;
}

inline bool GetListSinkClassesResponseListSinkClassesStruct::operator > (const GetListSinkClassesResponseListSinkClassesStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListSinkClassesResponseListSinkClassesStruct::clear() {
    clearElem1();
    clearElem2();
    clearElem3();
}

inline void GetListSinkClassesResponseListSinkClassesStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0u;
     }
}

inline bool GetListSinkClassesResponseListSinkClassesStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 GetListSinkClassesResponseListSinkClassesStruct::getElem1 () const {
    return _elem1;
}

inline void GetListSinkClassesResponseListSinkClassesStruct::setElem1 (uint16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void GetListSinkClassesResponseListSinkClassesStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool GetListSinkClassesResponseListSinkClassesStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& GetListSinkClassesResponseListSinkClassesStruct::getElem2 () const {
    return _elem2;
}

inline ::std::string& GetListSinkClassesResponseListSinkClassesStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void GetListSinkClassesResponseListSinkClassesStruct::setElem2 (const ::std::string& elem2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void GetListSinkClassesResponseListSinkClassesStruct::setElem2 (const char* elem2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem2();
    this->_elem2.assign(elem2_);
}

inline void GetListSinkClassesResponseListSinkClassesStruct::setElem2 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem2();
    this->_elem2.assign(value, size);
}

inline void GetListSinkClassesResponseListSinkClassesStruct::clearElem3() {
    if (hasElem3()) {
         clear_has_elem3();
        _elem3.clear();
     }
}

inline bool GetListSinkClassesResponseListSinkClassesStruct::hasElem3 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< GetListSinkClassesResponseListSinkClassesElem3Struct >& GetListSinkClassesResponseListSinkClassesStruct::getElem3 () const {
    return _elem3;
}

inline ::std::vector< GetListSinkClassesResponseListSinkClassesElem3Struct >& GetListSinkClassesResponseListSinkClassesStruct::getElem3Mutable () {
    set_has_elem3();
    return _elem3;
}

inline void GetListSinkClassesResponseListSinkClassesStruct::setElem3 (const ::std::vector< GetListSinkClassesResponseListSinkClassesElem3Struct >& elem3_) {
    set_has_elem3();
    this->_elem3 = elem3_;
}

inline void GetListSinkClassesResponseListSinkClassesStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListSinkClassesResponseListSinkClassesStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetListSinkClassesResponseListSinkClassesStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetListSinkClassesResponseListSinkClassesStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetListSinkClassesResponseListSinkClassesStruct::set_has_elem3 () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetListSinkClassesResponseListSinkClassesStruct::clear_has_elem3 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  GetListSinkClassesResponse::GetListSinkClassesResponse ()  :
    _result (0),
    _listSinkClasses ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListSinkClassesResponse::GetListSinkClassesResponse (const GetListSinkClassesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (0),
    _listSinkClasses ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListSinkClassesResponse::GetListSinkClassesResponse (int16 result_, const ::std::vector< GetListSinkClassesResponseListSinkClassesStruct >& listSinkClasses_)  :
    _result (result_),
    _listSinkClasses (listSinkClasses_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListSinkClassesResponse::~GetListSinkClassesResponse() {
}

inline GetListSinkClassesResponse& GetListSinkClassesResponse::operator = (const GetListSinkClassesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
        if (rhs.hasListSinkClasses()) {
            setListSinkClasses(rhs.getListSinkClasses());
        } else {
            clearListSinkClasses();
        }
    }
    return *this;
}

inline bool GetListSinkClassesResponse::operator == (const GetListSinkClassesResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()) &&
        ((!hasListSinkClasses() && !rhs.hasListSinkClasses()) || getListSinkClasses() == rhs.getListSinkClasses()));
}

inline bool GetListSinkClassesResponse::operator != (const GetListSinkClassesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListSinkClassesResponse::operator < (const GetListSinkClassesResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if (getResult() < rhs.getResult()) return true;
        if (getResult() > rhs.getResult()) return false;
    }
    if (hasListSinkClasses() || rhs.hasListSinkClasses()) {
        if (getListSinkClasses() < rhs.getListSinkClasses()) return true;
        if (getListSinkClasses() > rhs.getListSinkClasses()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetListSinkClassesResponse::clone() {
    return new GetListSinkClassesResponse(*this);
}

inline bool GetListSinkClassesResponse::operator > (const GetListSinkClassesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListSinkClassesResponse::clear() {
    clearResult();
    clearListSinkClasses();
}

inline void GetListSinkClassesResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = 0;
     }
}

inline bool GetListSinkClassesResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 GetListSinkClassesResponse::getResult () const {
    return _result;
}

inline void GetListSinkClassesResponse::setResult (int16 result_) {
    set_has_result();
    this->_result = result_;
}

inline void GetListSinkClassesResponse::clearListSinkClasses() {
    if (hasListSinkClasses()) {
         clear_has_listSinkClasses();
        _listSinkClasses.clear();
     }
}

inline bool GetListSinkClassesResponse::hasListSinkClasses () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< GetListSinkClassesResponseListSinkClassesStruct >& GetListSinkClassesResponse::getListSinkClasses () const {
    return _listSinkClasses;
}

inline ::std::vector< GetListSinkClassesResponseListSinkClassesStruct >& GetListSinkClassesResponse::getListSinkClassesMutable () {
    set_has_listSinkClasses();
    return _listSinkClasses;
}

inline void GetListSinkClassesResponse::setListSinkClasses (const ::std::vector< GetListSinkClassesResponseListSinkClassesStruct >& listSinkClasses_) {
    set_has_listSinkClasses();
    this->_listSinkClasses = listSinkClasses_;
}

inline void GetListSinkClassesResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListSinkClassesResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetListSinkClassesResponse::set_has_listSinkClasses () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetListSinkClassesResponse::clear_has_listSinkClasses () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetListSystemPropertiesRequestListSystemPropertiesStruct::GetListSystemPropertiesRequestListSystemPropertiesStruct ()  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListSystemPropertiesRequestListSystemPropertiesStruct::GetListSystemPropertiesRequestListSystemPropertiesStruct (const GetListSystemPropertiesRequestListSystemPropertiesStruct &rhs)  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListSystemPropertiesRequestListSystemPropertiesStruct::GetListSystemPropertiesRequestListSystemPropertiesStruct (int16 elem1_, int16 elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListSystemPropertiesRequestListSystemPropertiesStruct::~GetListSystemPropertiesRequestListSystemPropertiesStruct() {
}

inline GetListSystemPropertiesRequestListSystemPropertiesStruct& GetListSystemPropertiesRequestListSystemPropertiesStruct::operator = (const GetListSystemPropertiesRequestListSystemPropertiesStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool GetListSystemPropertiesRequestListSystemPropertiesStruct::operator == (const GetListSystemPropertiesRequestListSystemPropertiesStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool GetListSystemPropertiesRequestListSystemPropertiesStruct::operator != (const GetListSystemPropertiesRequestListSystemPropertiesStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListSystemPropertiesRequestListSystemPropertiesStruct::operator < (const GetListSystemPropertiesRequestListSystemPropertiesStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool GetListSystemPropertiesRequestListSystemPropertiesStruct::operator > (const GetListSystemPropertiesRequestListSystemPropertiesStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListSystemPropertiesRequestListSystemPropertiesStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void GetListSystemPropertiesRequestListSystemPropertiesStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0;
     }
}

inline bool GetListSystemPropertiesRequestListSystemPropertiesStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 GetListSystemPropertiesRequestListSystemPropertiesStruct::getElem1 () const {
    return _elem1;
}

inline void GetListSystemPropertiesRequestListSystemPropertiesStruct::setElem1 (int16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void GetListSystemPropertiesRequestListSystemPropertiesStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0;
     }
}

inline bool GetListSystemPropertiesRequestListSystemPropertiesStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 GetListSystemPropertiesRequestListSystemPropertiesStruct::getElem2 () const {
    return _elem2;
}

inline void GetListSystemPropertiesRequestListSystemPropertiesStruct::setElem2 (int16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void GetListSystemPropertiesRequestListSystemPropertiesStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListSystemPropertiesRequestListSystemPropertiesStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetListSystemPropertiesRequestListSystemPropertiesStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetListSystemPropertiesRequestListSystemPropertiesStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetListSystemPropertiesRequest::GetListSystemPropertiesRequest ()  :
    _listSystemProperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListSystemPropertiesRequest::GetListSystemPropertiesRequest (const GetListSystemPropertiesRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _listSystemProperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListSystemPropertiesRequest::GetListSystemPropertiesRequest (const ::std::vector< GetListSystemPropertiesRequestListSystemPropertiesStruct >& listSystemProperties_)  :
    _listSystemProperties (listSystemProperties_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListSystemPropertiesRequest::~GetListSystemPropertiesRequest() {
}

inline GetListSystemPropertiesRequest& GetListSystemPropertiesRequest::operator = (const GetListSystemPropertiesRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListSystemProperties()) {
            setListSystemProperties(rhs.getListSystemProperties());
        } else {
            clearListSystemProperties();
        }
    }
    return *this;
}

inline bool GetListSystemPropertiesRequest::operator == (const GetListSystemPropertiesRequest& rhs) const {
    return (((!hasListSystemProperties() && !rhs.hasListSystemProperties()) || getListSystemProperties() == rhs.getListSystemProperties()));
}

inline bool GetListSystemPropertiesRequest::operator != (const GetListSystemPropertiesRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListSystemPropertiesRequest::operator < (const GetListSystemPropertiesRequest& rhs) const {
    if (hasListSystemProperties() || rhs.hasListSystemProperties()) {
        if (getListSystemProperties() < rhs.getListSystemProperties()) return true;
        if (getListSystemProperties() > rhs.getListSystemProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetListSystemPropertiesRequest::clone() {
    return new GetListSystemPropertiesRequest(*this);
}

inline bool GetListSystemPropertiesRequest::operator > (const GetListSystemPropertiesRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListSystemPropertiesRequest::clear() {
    clearListSystemProperties();
}

inline void GetListSystemPropertiesRequest::clearListSystemProperties() {
    if (hasListSystemProperties()) {
         clear_has_listSystemProperties();
        _listSystemProperties.clear();
     }
}

inline bool GetListSystemPropertiesRequest::hasListSystemProperties () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< GetListSystemPropertiesRequestListSystemPropertiesStruct >& GetListSystemPropertiesRequest::getListSystemProperties () const {
    return _listSystemProperties;
}

inline ::std::vector< GetListSystemPropertiesRequestListSystemPropertiesStruct >& GetListSystemPropertiesRequest::getListSystemPropertiesMutable () {
    set_has_listSystemProperties();
    return _listSystemProperties;
}

inline void GetListSystemPropertiesRequest::setListSystemProperties (const ::std::vector< GetListSystemPropertiesRequestListSystemPropertiesStruct >& listSystemProperties_) {
    set_has_listSystemProperties();
    this->_listSystemProperties = listSystemProperties_;
}

inline void GetListSystemPropertiesRequest::set_has_listSystemProperties () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListSystemPropertiesRequest::clear_has_listSystemProperties () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetListSystemPropertiesResponse::GetListSystemPropertiesResponse ()  :
    _result (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetListSystemPropertiesResponse::GetListSystemPropertiesResponse (const GetListSystemPropertiesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetListSystemPropertiesResponse::GetListSystemPropertiesResponse (int16 result_)  :
    _result (result_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetListSystemPropertiesResponse::~GetListSystemPropertiesResponse() {
}

inline GetListSystemPropertiesResponse& GetListSystemPropertiesResponse::operator = (const GetListSystemPropertiesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool GetListSystemPropertiesResponse::operator == (const GetListSystemPropertiesResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool GetListSystemPropertiesResponse::operator != (const GetListSystemPropertiesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetListSystemPropertiesResponse::operator < (const GetListSystemPropertiesResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if (getResult() < rhs.getResult()) return true;
        if (getResult() > rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetListSystemPropertiesResponse::clone() {
    return new GetListSystemPropertiesResponse(*this);
}

inline bool GetListSystemPropertiesResponse::operator > (const GetListSystemPropertiesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetListSystemPropertiesResponse::clear() {
    clearResult();
}

inline void GetListSystemPropertiesResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = 0;
     }
}

inline bool GetListSystemPropertiesResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 GetListSystemPropertiesResponse::getResult () const {
    return _result;
}

inline void GetListSystemPropertiesResponse::setResult (int16 result_) {
    set_has_result();
    this->_result = result_;
}

inline void GetListSystemPropertiesResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetListSystemPropertiesResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetTimingInformationRequest::GetTimingInformationRequest ()  :
    _mainConnectionID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetTimingInformationRequest::GetTimingInformationRequest (const GetTimingInformationRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _mainConnectionID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetTimingInformationRequest::GetTimingInformationRequest (uint16 mainConnectionID_)  :
    _mainConnectionID (mainConnectionID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetTimingInformationRequest::~GetTimingInformationRequest() {
}

inline GetTimingInformationRequest& GetTimingInformationRequest::operator = (const GetTimingInformationRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMainConnectionID()) {
            setMainConnectionID(rhs.getMainConnectionID());
        } else {
            clearMainConnectionID();
        }
    }
    return *this;
}

inline bool GetTimingInformationRequest::operator == (const GetTimingInformationRequest& rhs) const {
    return (((!hasMainConnectionID() && !rhs.hasMainConnectionID()) || getMainConnectionID() == rhs.getMainConnectionID()));
}

inline bool GetTimingInformationRequest::operator != (const GetTimingInformationRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetTimingInformationRequest::operator < (const GetTimingInformationRequest& rhs) const {
    if (hasMainConnectionID() || rhs.hasMainConnectionID()) {
        if (getMainConnectionID() < rhs.getMainConnectionID()) return true;
        if (getMainConnectionID() > rhs.getMainConnectionID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetTimingInformationRequest::clone() {
    return new GetTimingInformationRequest(*this);
}

inline bool GetTimingInformationRequest::operator > (const GetTimingInformationRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetTimingInformationRequest::clear() {
    clearMainConnectionID();
}

inline void GetTimingInformationRequest::clearMainConnectionID() {
    if (hasMainConnectionID()) {
         clear_has_mainConnectionID();
        _mainConnectionID = 0u;
     }
}

inline bool GetTimingInformationRequest::hasMainConnectionID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 GetTimingInformationRequest::getMainConnectionID () const {
    return _mainConnectionID;
}

inline void GetTimingInformationRequest::setMainConnectionID (uint16 mainConnectionID_) {
    set_has_mainConnectionID();
    this->_mainConnectionID = mainConnectionID_;
}

inline void GetTimingInformationRequest::set_has_mainConnectionID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetTimingInformationRequest::clear_has_mainConnectionID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetTimingInformationResponse::GetTimingInformationResponse ()  :
    _result (0),
    _delay (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetTimingInformationResponse::GetTimingInformationResponse (const GetTimingInformationResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (0),
    _delay (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetTimingInformationResponse::GetTimingInformationResponse (int16 result_, int16 delay_)  :
    _result (result_),
    _delay (delay_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetTimingInformationResponse::~GetTimingInformationResponse() {
}

inline GetTimingInformationResponse& GetTimingInformationResponse::operator = (const GetTimingInformationResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
        if (rhs.hasDelay()) {
            setDelay(rhs.getDelay());
        } else {
            clearDelay();
        }
    }
    return *this;
}

inline bool GetTimingInformationResponse::operator == (const GetTimingInformationResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()) &&
        ((!hasDelay() && !rhs.hasDelay()) || getDelay() == rhs.getDelay()));
}

inline bool GetTimingInformationResponse::operator != (const GetTimingInformationResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetTimingInformationResponse::operator < (const GetTimingInformationResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if (getResult() < rhs.getResult()) return true;
        if (getResult() > rhs.getResult()) return false;
    }
    if (hasDelay() || rhs.hasDelay()) {
        if (getDelay() < rhs.getDelay()) return true;
        if (getDelay() > rhs.getDelay()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetTimingInformationResponse::clone() {
    return new GetTimingInformationResponse(*this);
}

inline bool GetTimingInformationResponse::operator > (const GetTimingInformationResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetTimingInformationResponse::clear() {
    clearResult();
    clearDelay();
}

inline void GetTimingInformationResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = 0;
     }
}

inline bool GetTimingInformationResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 GetTimingInformationResponse::getResult () const {
    return _result;
}

inline void GetTimingInformationResponse::setResult (int16 result_) {
    set_has_result();
    this->_result = result_;
}

inline void GetTimingInformationResponse::clearDelay() {
    if (hasDelay()) {
         clear_has_delay();
        _delay = 0;
     }
}

inline bool GetTimingInformationResponse::hasDelay () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 GetTimingInformationResponse::getDelay () const {
    return _delay;
}

inline void GetTimingInformationResponse::setDelay (int16 delay_) {
    set_has_delay();
    this->_delay = delay_;
}

inline void GetTimingInformationResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetTimingInformationResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetTimingInformationResponse::set_has_delay () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetTimingInformationResponse::clear_has_delay () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SinkAddedSignalNewSinkElem3Struct::SinkAddedSignalNewSinkElem3Struct ()  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SinkAddedSignalNewSinkElem3Struct::SinkAddedSignalNewSinkElem3Struct (const SinkAddedSignalNewSinkElem3Struct &rhs)  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SinkAddedSignalNewSinkElem3Struct::SinkAddedSignalNewSinkElem3Struct (int16 elem1_, int16 elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SinkAddedSignalNewSinkElem3Struct::~SinkAddedSignalNewSinkElem3Struct() {
}

inline SinkAddedSignalNewSinkElem3Struct& SinkAddedSignalNewSinkElem3Struct::operator = (const SinkAddedSignalNewSinkElem3Struct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool SinkAddedSignalNewSinkElem3Struct::operator == (const SinkAddedSignalNewSinkElem3Struct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool SinkAddedSignalNewSinkElem3Struct::operator != (const SinkAddedSignalNewSinkElem3Struct& rhs) const {
    return ! (*this == rhs);
}

inline bool SinkAddedSignalNewSinkElem3Struct::operator < (const SinkAddedSignalNewSinkElem3Struct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool SinkAddedSignalNewSinkElem3Struct::operator > (const SinkAddedSignalNewSinkElem3Struct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SinkAddedSignalNewSinkElem3Struct::clear() {
    clearElem1();
    clearElem2();
}

inline void SinkAddedSignalNewSinkElem3Struct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0;
     }
}

inline bool SinkAddedSignalNewSinkElem3Struct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 SinkAddedSignalNewSinkElem3Struct::getElem1 () const {
    return _elem1;
}

inline void SinkAddedSignalNewSinkElem3Struct::setElem1 (int16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void SinkAddedSignalNewSinkElem3Struct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0;
     }
}

inline bool SinkAddedSignalNewSinkElem3Struct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 SinkAddedSignalNewSinkElem3Struct::getElem2 () const {
    return _elem2;
}

inline void SinkAddedSignalNewSinkElem3Struct::setElem2 (int16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void SinkAddedSignalNewSinkElem3Struct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void SinkAddedSignalNewSinkElem3Struct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SinkAddedSignalNewSinkElem3Struct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void SinkAddedSignalNewSinkElem3Struct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SinkAddedSignalNewSinkStruct::SinkAddedSignalNewSinkStruct ()  :
    _elem1 (0u),
    _elem2 (),
    _elem3 (),
    _elem4 (0),
    _elem5 (0),
    _elem6 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SinkAddedSignalNewSinkStruct::SinkAddedSignalNewSinkStruct (const SinkAddedSignalNewSinkStruct &rhs)  :
    _elem1 (0u),
    _elem2 (),
    _elem3 (),
    _elem4 (0),
    _elem5 (0),
    _elem6 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SinkAddedSignalNewSinkStruct::SinkAddedSignalNewSinkStruct (uint16 elem1_, const ::std::string& elem2_, const SinkAddedSignalNewSinkElem3Struct& elem3_, int16 elem4_, int16 elem5_, uint16 elem6_)  :
    _elem1 (elem1_),
    _elem2 (elem2_),
    _elem3 (elem3_),
    _elem4 (elem4_),
    _elem5 (elem5_),
    _elem6 (elem6_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem2_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SinkAddedSignalNewSinkStruct::~SinkAddedSignalNewSinkStruct() {
}

inline SinkAddedSignalNewSinkStruct& SinkAddedSignalNewSinkStruct::operator = (const SinkAddedSignalNewSinkStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
        if (rhs.hasElem3()) {
            setElem3(rhs.getElem3());
        } else {
            clearElem3();
        }
        if (rhs.hasElem4()) {
            setElem4(rhs.getElem4());
        } else {
            clearElem4();
        }
        if (rhs.hasElem5()) {
            setElem5(rhs.getElem5());
        } else {
            clearElem5();
        }
        if (rhs.hasElem6()) {
            setElem6(rhs.getElem6());
        } else {
            clearElem6();
        }
    }
    return *this;
}

inline bool SinkAddedSignalNewSinkStruct::operator == (const SinkAddedSignalNewSinkStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()) &&
        ((!hasElem3() && !rhs.hasElem3()) || getElem3() == rhs.getElem3()) &&
        ((!hasElem4() && !rhs.hasElem4()) || getElem4() == rhs.getElem4()) &&
        ((!hasElem5() && !rhs.hasElem5()) || getElem5() == rhs.getElem5()) &&
        ((!hasElem6() && !rhs.hasElem6()) || getElem6() == rhs.getElem6()));
}

inline bool SinkAddedSignalNewSinkStruct::operator != (const SinkAddedSignalNewSinkStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool SinkAddedSignalNewSinkStruct::operator < (const SinkAddedSignalNewSinkStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    if (hasElem3() || rhs.hasElem3()) {
        if (getElem3() < rhs.getElem3()) return true;
        if (getElem3() > rhs.getElem3()) return false;
    }
    if (hasElem4() || rhs.hasElem4()) {
        if (getElem4() < rhs.getElem4()) return true;
        if (getElem4() > rhs.getElem4()) return false;
    }
    if (hasElem5() || rhs.hasElem5()) {
        if (getElem5() < rhs.getElem5()) return true;
        if (getElem5() > rhs.getElem5()) return false;
    }
    if (hasElem6() || rhs.hasElem6()) {
        if (getElem6() < rhs.getElem6()) return true;
        if (getElem6() > rhs.getElem6()) return false;
    }
    return false;
}

inline bool SinkAddedSignalNewSinkStruct::operator > (const SinkAddedSignalNewSinkStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SinkAddedSignalNewSinkStruct::clear() {
    clearElem1();
    clearElem2();
    clearElem3();
    clearElem4();
    clearElem5();
    clearElem6();
}

inline void SinkAddedSignalNewSinkStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0u;
     }
}

inline bool SinkAddedSignalNewSinkStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SinkAddedSignalNewSinkStruct::getElem1 () const {
    return _elem1;
}

inline void SinkAddedSignalNewSinkStruct::setElem1 (uint16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void SinkAddedSignalNewSinkStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool SinkAddedSignalNewSinkStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SinkAddedSignalNewSinkStruct::getElem2 () const {
    return _elem2;
}

inline ::std::string& SinkAddedSignalNewSinkStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void SinkAddedSignalNewSinkStruct::setElem2 (const ::std::string& elem2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void SinkAddedSignalNewSinkStruct::setElem2 (const char* elem2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem2();
    this->_elem2.assign(elem2_);
}

inline void SinkAddedSignalNewSinkStruct::setElem2 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem2();
    this->_elem2.assign(value, size);
}

inline void SinkAddedSignalNewSinkStruct::clearElem3() {
    if (hasElem3()) {
         clear_has_elem3();
        _elem3.clear();
     }
}

inline bool SinkAddedSignalNewSinkStruct::hasElem3 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const SinkAddedSignalNewSinkElem3Struct& SinkAddedSignalNewSinkStruct::getElem3 () const {
    return _elem3;
}

inline SinkAddedSignalNewSinkElem3Struct& SinkAddedSignalNewSinkStruct::getElem3Mutable () {
    set_has_elem3();
    return _elem3;
}

inline void SinkAddedSignalNewSinkStruct::setElem3 (const SinkAddedSignalNewSinkElem3Struct& elem3_) {
    set_has_elem3();
    this->_elem3 = elem3_;
}

inline void SinkAddedSignalNewSinkStruct::clearElem4() {
    if (hasElem4()) {
         clear_has_elem4();
        _elem4 = 0;
     }
}

inline bool SinkAddedSignalNewSinkStruct::hasElem4 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int16 SinkAddedSignalNewSinkStruct::getElem4 () const {
    return _elem4;
}

inline void SinkAddedSignalNewSinkStruct::setElem4 (int16 elem4_) {
    set_has_elem4();
    this->_elem4 = elem4_;
}

inline void SinkAddedSignalNewSinkStruct::clearElem5() {
    if (hasElem5()) {
         clear_has_elem5();
        _elem5 = 0;
     }
}

inline bool SinkAddedSignalNewSinkStruct::hasElem5 () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline int16 SinkAddedSignalNewSinkStruct::getElem5 () const {
    return _elem5;
}

inline void SinkAddedSignalNewSinkStruct::setElem5 (int16 elem5_) {
    set_has_elem5();
    this->_elem5 = elem5_;
}

inline void SinkAddedSignalNewSinkStruct::clearElem6() {
    if (hasElem6()) {
         clear_has_elem6();
        _elem6 = 0u;
     }
}

inline bool SinkAddedSignalNewSinkStruct::hasElem6 () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint16 SinkAddedSignalNewSinkStruct::getElem6 () const {
    return _elem6;
}

inline void SinkAddedSignalNewSinkStruct::setElem6 (uint16 elem6_) {
    set_has_elem6();
    this->_elem6 = elem6_;
}

inline void SinkAddedSignalNewSinkStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void SinkAddedSignalNewSinkStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SinkAddedSignalNewSinkStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void SinkAddedSignalNewSinkStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SinkAddedSignalNewSinkStruct::set_has_elem3 () {
    _has_bits_[0] |= 1u << 2;
}

inline void SinkAddedSignalNewSinkStruct::clear_has_elem3 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SinkAddedSignalNewSinkStruct::set_has_elem4 () {
    _has_bits_[0] |= 1u << 3;
}

inline void SinkAddedSignalNewSinkStruct::clear_has_elem4 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void SinkAddedSignalNewSinkStruct::set_has_elem5 () {
    _has_bits_[0] |= 1u << 4;
}

inline void SinkAddedSignalNewSinkStruct::clear_has_elem5 () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void SinkAddedSignalNewSinkStruct::set_has_elem6 () {
    _has_bits_[0] |= 1u << 5;
}

inline void SinkAddedSignalNewSinkStruct::clear_has_elem6 () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  SinkAddedSignal::SinkAddedSignal ()  :
    _newSink ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SinkAddedSignal::SinkAddedSignal (const SinkAddedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _newSink ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SinkAddedSignal::SinkAddedSignal (const SinkAddedSignalNewSinkStruct& newSink_)  :
    _newSink (newSink_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SinkAddedSignal::~SinkAddedSignal() {
}

inline SinkAddedSignal& SinkAddedSignal::operator = (const SinkAddedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNewSink()) {
            setNewSink(rhs.getNewSink());
        } else {
            clearNewSink();
        }
    }
    return *this;
}

inline bool SinkAddedSignal::operator == (const SinkAddedSignal& rhs) const {
    return (((!hasNewSink() && !rhs.hasNewSink()) || getNewSink() == rhs.getNewSink()));
}

inline bool SinkAddedSignal::operator != (const SinkAddedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SinkAddedSignal::operator < (const SinkAddedSignal& rhs) const {
    if (hasNewSink() || rhs.hasNewSink()) {
        if (getNewSink() < rhs.getNewSink()) return true;
        if (getNewSink() > rhs.getNewSink()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SinkAddedSignal::clone() {
    return new SinkAddedSignal(*this);
}

inline bool SinkAddedSignal::operator > (const SinkAddedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SinkAddedSignal::clear() {
    clearNewSink();
}

inline void SinkAddedSignal::clearNewSink() {
    if (hasNewSink()) {
         clear_has_newSink();
        _newSink.clear();
     }
}

inline bool SinkAddedSignal::hasNewSink () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const SinkAddedSignalNewSinkStruct& SinkAddedSignal::getNewSink () const {
    return _newSink;
}

inline SinkAddedSignalNewSinkStruct& SinkAddedSignal::getNewSinkMutable () {
    set_has_newSink();
    return _newSink;
}

inline void SinkAddedSignal::setNewSink (const SinkAddedSignalNewSinkStruct& newSink_) {
    set_has_newSink();
    this->_newSink = newSink_;
}

inline void SinkAddedSignal::set_has_newSink () {
    _has_bits_[0] |= 1u << 0;
}

inline void SinkAddedSignal::clear_has_newSink () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SinkRemovedSignal::SinkRemovedSignal ()  :
    _removedSinkID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SinkRemovedSignal::SinkRemovedSignal (const SinkRemovedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _removedSinkID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SinkRemovedSignal::SinkRemovedSignal (uint16 removedSinkID_)  :
    _removedSinkID (removedSinkID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SinkRemovedSignal::~SinkRemovedSignal() {
}

inline SinkRemovedSignal& SinkRemovedSignal::operator = (const SinkRemovedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRemovedSinkID()) {
            setRemovedSinkID(rhs.getRemovedSinkID());
        } else {
            clearRemovedSinkID();
        }
    }
    return *this;
}

inline bool SinkRemovedSignal::operator == (const SinkRemovedSignal& rhs) const {
    return (((!hasRemovedSinkID() && !rhs.hasRemovedSinkID()) || getRemovedSinkID() == rhs.getRemovedSinkID()));
}

inline bool SinkRemovedSignal::operator != (const SinkRemovedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SinkRemovedSignal::operator < (const SinkRemovedSignal& rhs) const {
    if (hasRemovedSinkID() || rhs.hasRemovedSinkID()) {
        if (getRemovedSinkID() < rhs.getRemovedSinkID()) return true;
        if (getRemovedSinkID() > rhs.getRemovedSinkID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SinkRemovedSignal::clone() {
    return new SinkRemovedSignal(*this);
}

inline bool SinkRemovedSignal::operator > (const SinkRemovedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SinkRemovedSignal::clear() {
    clearRemovedSinkID();
}

inline void SinkRemovedSignal::clearRemovedSinkID() {
    if (hasRemovedSinkID()) {
         clear_has_removedSinkID();
        _removedSinkID = 0u;
     }
}

inline bool SinkRemovedSignal::hasRemovedSinkID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SinkRemovedSignal::getRemovedSinkID () const {
    return _removedSinkID;
}

inline void SinkRemovedSignal::setRemovedSinkID (uint16 removedSinkID_) {
    set_has_removedSinkID();
    this->_removedSinkID = removedSinkID_;
}

inline void SinkRemovedSignal::set_has_removedSinkID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SinkRemovedSignal::clear_has_removedSinkID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SourceAddedSignalNewSourceElem3Struct::SourceAddedSignalNewSourceElem3Struct ()  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SourceAddedSignalNewSourceElem3Struct::SourceAddedSignalNewSourceElem3Struct (const SourceAddedSignalNewSourceElem3Struct &rhs)  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SourceAddedSignalNewSourceElem3Struct::SourceAddedSignalNewSourceElem3Struct (int16 elem1_, int16 elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SourceAddedSignalNewSourceElem3Struct::~SourceAddedSignalNewSourceElem3Struct() {
}

inline SourceAddedSignalNewSourceElem3Struct& SourceAddedSignalNewSourceElem3Struct::operator = (const SourceAddedSignalNewSourceElem3Struct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool SourceAddedSignalNewSourceElem3Struct::operator == (const SourceAddedSignalNewSourceElem3Struct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool SourceAddedSignalNewSourceElem3Struct::operator != (const SourceAddedSignalNewSourceElem3Struct& rhs) const {
    return ! (*this == rhs);
}

inline bool SourceAddedSignalNewSourceElem3Struct::operator < (const SourceAddedSignalNewSourceElem3Struct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool SourceAddedSignalNewSourceElem3Struct::operator > (const SourceAddedSignalNewSourceElem3Struct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SourceAddedSignalNewSourceElem3Struct::clear() {
    clearElem1();
    clearElem2();
}

inline void SourceAddedSignalNewSourceElem3Struct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0;
     }
}

inline bool SourceAddedSignalNewSourceElem3Struct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 SourceAddedSignalNewSourceElem3Struct::getElem1 () const {
    return _elem1;
}

inline void SourceAddedSignalNewSourceElem3Struct::setElem1 (int16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void SourceAddedSignalNewSourceElem3Struct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0;
     }
}

inline bool SourceAddedSignalNewSourceElem3Struct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 SourceAddedSignalNewSourceElem3Struct::getElem2 () const {
    return _elem2;
}

inline void SourceAddedSignalNewSourceElem3Struct::setElem2 (int16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void SourceAddedSignalNewSourceElem3Struct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void SourceAddedSignalNewSourceElem3Struct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SourceAddedSignalNewSourceElem3Struct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void SourceAddedSignalNewSourceElem3Struct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SourceAddedSignalNewSourceStruct::SourceAddedSignalNewSourceStruct ()  :
    _elem1 (0u),
    _elem2 (),
    _elem3 (),
    _elem4 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SourceAddedSignalNewSourceStruct::SourceAddedSignalNewSourceStruct (const SourceAddedSignalNewSourceStruct &rhs)  :
    _elem1 (0u),
    _elem2 (),
    _elem3 (),
    _elem4 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SourceAddedSignalNewSourceStruct::SourceAddedSignalNewSourceStruct (uint16 elem1_, const ::std::string& elem2_, const SourceAddedSignalNewSourceElem3Struct& elem3_, uint16 elem4_)  :
    _elem1 (elem1_),
    _elem2 (elem2_),
    _elem3 (elem3_),
    _elem4 (elem4_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem2_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SourceAddedSignalNewSourceStruct::~SourceAddedSignalNewSourceStruct() {
}

inline SourceAddedSignalNewSourceStruct& SourceAddedSignalNewSourceStruct::operator = (const SourceAddedSignalNewSourceStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
        if (rhs.hasElem3()) {
            setElem3(rhs.getElem3());
        } else {
            clearElem3();
        }
        if (rhs.hasElem4()) {
            setElem4(rhs.getElem4());
        } else {
            clearElem4();
        }
    }
    return *this;
}

inline bool SourceAddedSignalNewSourceStruct::operator == (const SourceAddedSignalNewSourceStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()) &&
        ((!hasElem3() && !rhs.hasElem3()) || getElem3() == rhs.getElem3()) &&
        ((!hasElem4() && !rhs.hasElem4()) || getElem4() == rhs.getElem4()));
}

inline bool SourceAddedSignalNewSourceStruct::operator != (const SourceAddedSignalNewSourceStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool SourceAddedSignalNewSourceStruct::operator < (const SourceAddedSignalNewSourceStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    if (hasElem3() || rhs.hasElem3()) {
        if (getElem3() < rhs.getElem3()) return true;
        if (getElem3() > rhs.getElem3()) return false;
    }
    if (hasElem4() || rhs.hasElem4()) {
        if (getElem4() < rhs.getElem4()) return true;
        if (getElem4() > rhs.getElem4()) return false;
    }
    return false;
}

inline bool SourceAddedSignalNewSourceStruct::operator > (const SourceAddedSignalNewSourceStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SourceAddedSignalNewSourceStruct::clear() {
    clearElem1();
    clearElem2();
    clearElem3();
    clearElem4();
}

inline void SourceAddedSignalNewSourceStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0u;
     }
}

inline bool SourceAddedSignalNewSourceStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SourceAddedSignalNewSourceStruct::getElem1 () const {
    return _elem1;
}

inline void SourceAddedSignalNewSourceStruct::setElem1 (uint16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void SourceAddedSignalNewSourceStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool SourceAddedSignalNewSourceStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SourceAddedSignalNewSourceStruct::getElem2 () const {
    return _elem2;
}

inline ::std::string& SourceAddedSignalNewSourceStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void SourceAddedSignalNewSourceStruct::setElem2 (const ::std::string& elem2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void SourceAddedSignalNewSourceStruct::setElem2 (const char* elem2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem2();
    this->_elem2.assign(elem2_);
}

inline void SourceAddedSignalNewSourceStruct::setElem2 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem2();
    this->_elem2.assign(value, size);
}

inline void SourceAddedSignalNewSourceStruct::clearElem3() {
    if (hasElem3()) {
         clear_has_elem3();
        _elem3.clear();
     }
}

inline bool SourceAddedSignalNewSourceStruct::hasElem3 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const SourceAddedSignalNewSourceElem3Struct& SourceAddedSignalNewSourceStruct::getElem3 () const {
    return _elem3;
}

inline SourceAddedSignalNewSourceElem3Struct& SourceAddedSignalNewSourceStruct::getElem3Mutable () {
    set_has_elem3();
    return _elem3;
}

inline void SourceAddedSignalNewSourceStruct::setElem3 (const SourceAddedSignalNewSourceElem3Struct& elem3_) {
    set_has_elem3();
    this->_elem3 = elem3_;
}

inline void SourceAddedSignalNewSourceStruct::clearElem4() {
    if (hasElem4()) {
         clear_has_elem4();
        _elem4 = 0u;
     }
}

inline bool SourceAddedSignalNewSourceStruct::hasElem4 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 SourceAddedSignalNewSourceStruct::getElem4 () const {
    return _elem4;
}

inline void SourceAddedSignalNewSourceStruct::setElem4 (uint16 elem4_) {
    set_has_elem4();
    this->_elem4 = elem4_;
}

inline void SourceAddedSignalNewSourceStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void SourceAddedSignalNewSourceStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SourceAddedSignalNewSourceStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void SourceAddedSignalNewSourceStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SourceAddedSignalNewSourceStruct::set_has_elem3 () {
    _has_bits_[0] |= 1u << 2;
}

inline void SourceAddedSignalNewSourceStruct::clear_has_elem3 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SourceAddedSignalNewSourceStruct::set_has_elem4 () {
    _has_bits_[0] |= 1u << 3;
}

inline void SourceAddedSignalNewSourceStruct::clear_has_elem4 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  SourceAddedSignal::SourceAddedSignal ()  :
    _newSource ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SourceAddedSignal::SourceAddedSignal (const SourceAddedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _newSource ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SourceAddedSignal::SourceAddedSignal (const SourceAddedSignalNewSourceStruct& newSource_)  :
    _newSource (newSource_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SourceAddedSignal::~SourceAddedSignal() {
}

inline SourceAddedSignal& SourceAddedSignal::operator = (const SourceAddedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNewSource()) {
            setNewSource(rhs.getNewSource());
        } else {
            clearNewSource();
        }
    }
    return *this;
}

inline bool SourceAddedSignal::operator == (const SourceAddedSignal& rhs) const {
    return (((!hasNewSource() && !rhs.hasNewSource()) || getNewSource() == rhs.getNewSource()));
}

inline bool SourceAddedSignal::operator != (const SourceAddedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SourceAddedSignal::operator < (const SourceAddedSignal& rhs) const {
    if (hasNewSource() || rhs.hasNewSource()) {
        if (getNewSource() < rhs.getNewSource()) return true;
        if (getNewSource() > rhs.getNewSource()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SourceAddedSignal::clone() {
    return new SourceAddedSignal(*this);
}

inline bool SourceAddedSignal::operator > (const SourceAddedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SourceAddedSignal::clear() {
    clearNewSource();
}

inline void SourceAddedSignal::clearNewSource() {
    if (hasNewSource()) {
         clear_has_newSource();
        _newSource.clear();
     }
}

inline bool SourceAddedSignal::hasNewSource () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const SourceAddedSignalNewSourceStruct& SourceAddedSignal::getNewSource () const {
    return _newSource;
}

inline SourceAddedSignalNewSourceStruct& SourceAddedSignal::getNewSourceMutable () {
    set_has_newSource();
    return _newSource;
}

inline void SourceAddedSignal::setNewSource (const SourceAddedSignalNewSourceStruct& newSource_) {
    set_has_newSource();
    this->_newSource = newSource_;
}

inline void SourceAddedSignal::set_has_newSource () {
    _has_bits_[0] |= 1u << 0;
}

inline void SourceAddedSignal::clear_has_newSource () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SourceRemovedSignal::SourceRemovedSignal ()  :
    _removedSourceID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SourceRemovedSignal::SourceRemovedSignal (const SourceRemovedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _removedSourceID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SourceRemovedSignal::SourceRemovedSignal (uint16 removedSourceID_)  :
    _removedSourceID (removedSourceID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SourceRemovedSignal::~SourceRemovedSignal() {
}

inline SourceRemovedSignal& SourceRemovedSignal::operator = (const SourceRemovedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRemovedSourceID()) {
            setRemovedSourceID(rhs.getRemovedSourceID());
        } else {
            clearRemovedSourceID();
        }
    }
    return *this;
}

inline bool SourceRemovedSignal::operator == (const SourceRemovedSignal& rhs) const {
    return (((!hasRemovedSourceID() && !rhs.hasRemovedSourceID()) || getRemovedSourceID() == rhs.getRemovedSourceID()));
}

inline bool SourceRemovedSignal::operator != (const SourceRemovedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SourceRemovedSignal::operator < (const SourceRemovedSignal& rhs) const {
    if (hasRemovedSourceID() || rhs.hasRemovedSourceID()) {
        if (getRemovedSourceID() < rhs.getRemovedSourceID()) return true;
        if (getRemovedSourceID() > rhs.getRemovedSourceID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SourceRemovedSignal::clone() {
    return new SourceRemovedSignal(*this);
}

inline bool SourceRemovedSignal::operator > (const SourceRemovedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SourceRemovedSignal::clear() {
    clearRemovedSourceID();
}

inline void SourceRemovedSignal::clearRemovedSourceID() {
    if (hasRemovedSourceID()) {
         clear_has_removedSourceID();
        _removedSourceID = 0u;
     }
}

inline bool SourceRemovedSignal::hasRemovedSourceID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SourceRemovedSignal::getRemovedSourceID () const {
    return _removedSourceID;
}

inline void SourceRemovedSignal::setRemovedSourceID (uint16 removedSourceID_) {
    set_has_removedSourceID();
    this->_removedSourceID = removedSourceID_;
}

inline void SourceRemovedSignal::set_has_removedSourceID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SourceRemovedSignal::clear_has_removedSourceID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MainConnectionStateChangedSignal::MainConnectionStateChangedSignal ()  :
    _connectionID (0u),
    _connectionState (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MainConnectionStateChangedSignal::MainConnectionStateChangedSignal (const MainConnectionStateChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _connectionID (0u),
    _connectionState (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MainConnectionStateChangedSignal::MainConnectionStateChangedSignal (uint16 connectionID_, int16 connectionState_)  :
    _connectionID (connectionID_),
    _connectionState (connectionState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MainConnectionStateChangedSignal::~MainConnectionStateChangedSignal() {
}

inline MainConnectionStateChangedSignal& MainConnectionStateChangedSignal::operator = (const MainConnectionStateChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConnectionID()) {
            setConnectionID(rhs.getConnectionID());
        } else {
            clearConnectionID();
        }
        if (rhs.hasConnectionState()) {
            setConnectionState(rhs.getConnectionState());
        } else {
            clearConnectionState();
        }
    }
    return *this;
}

inline bool MainConnectionStateChangedSignal::operator == (const MainConnectionStateChangedSignal& rhs) const {
    return (((!hasConnectionID() && !rhs.hasConnectionID()) || getConnectionID() == rhs.getConnectionID()) &&
        ((!hasConnectionState() && !rhs.hasConnectionState()) || getConnectionState() == rhs.getConnectionState()));
}

inline bool MainConnectionStateChangedSignal::operator != (const MainConnectionStateChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool MainConnectionStateChangedSignal::operator < (const MainConnectionStateChangedSignal& rhs) const {
    if (hasConnectionID() || rhs.hasConnectionID()) {
        if (getConnectionID() < rhs.getConnectionID()) return true;
        if (getConnectionID() > rhs.getConnectionID()) return false;
    }
    if (hasConnectionState() || rhs.hasConnectionState()) {
        if (getConnectionState() < rhs.getConnectionState()) return true;
        if (getConnectionState() > rhs.getConnectionState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MainConnectionStateChangedSignal::clone() {
    return new MainConnectionStateChangedSignal(*this);
}

inline bool MainConnectionStateChangedSignal::operator > (const MainConnectionStateChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MainConnectionStateChangedSignal::clear() {
    clearConnectionID();
    clearConnectionState();
}

inline void MainConnectionStateChangedSignal::clearConnectionID() {
    if (hasConnectionID()) {
         clear_has_connectionID();
        _connectionID = 0u;
     }
}

inline bool MainConnectionStateChangedSignal::hasConnectionID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 MainConnectionStateChangedSignal::getConnectionID () const {
    return _connectionID;
}

inline void MainConnectionStateChangedSignal::setConnectionID (uint16 connectionID_) {
    set_has_connectionID();
    this->_connectionID = connectionID_;
}

inline void MainConnectionStateChangedSignal::clearConnectionState() {
    if (hasConnectionState()) {
         clear_has_connectionState();
        _connectionState = 0;
     }
}

inline bool MainConnectionStateChangedSignal::hasConnectionState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 MainConnectionStateChangedSignal::getConnectionState () const {
    return _connectionState;
}

inline void MainConnectionStateChangedSignal::setConnectionState (int16 connectionState_) {
    set_has_connectionState();
    this->_connectionState = connectionState_;
}

inline void MainConnectionStateChangedSignal::set_has_connectionID () {
    _has_bits_[0] |= 1u << 0;
}

inline void MainConnectionStateChangedSignal::clear_has_connectionID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void MainConnectionStateChangedSignal::set_has_connectionState () {
    _has_bits_[0] |= 1u << 1;
}

inline void MainConnectionStateChangedSignal::clear_has_connectionState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  MainSinkSoundPropertyChangedSignalSoundPropertyStruct::MainSinkSoundPropertyChangedSignalSoundPropertyStruct ()  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MainSinkSoundPropertyChangedSignalSoundPropertyStruct::MainSinkSoundPropertyChangedSignalSoundPropertyStruct (const MainSinkSoundPropertyChangedSignalSoundPropertyStruct &rhs)  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MainSinkSoundPropertyChangedSignalSoundPropertyStruct::MainSinkSoundPropertyChangedSignalSoundPropertyStruct (int16 elem1_, int16 elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MainSinkSoundPropertyChangedSignalSoundPropertyStruct::~MainSinkSoundPropertyChangedSignalSoundPropertyStruct() {
}

inline MainSinkSoundPropertyChangedSignalSoundPropertyStruct& MainSinkSoundPropertyChangedSignalSoundPropertyStruct::operator = (const MainSinkSoundPropertyChangedSignalSoundPropertyStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool MainSinkSoundPropertyChangedSignalSoundPropertyStruct::operator == (const MainSinkSoundPropertyChangedSignalSoundPropertyStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool MainSinkSoundPropertyChangedSignalSoundPropertyStruct::operator != (const MainSinkSoundPropertyChangedSignalSoundPropertyStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool MainSinkSoundPropertyChangedSignalSoundPropertyStruct::operator < (const MainSinkSoundPropertyChangedSignalSoundPropertyStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool MainSinkSoundPropertyChangedSignalSoundPropertyStruct::operator > (const MainSinkSoundPropertyChangedSignalSoundPropertyStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MainSinkSoundPropertyChangedSignalSoundPropertyStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void MainSinkSoundPropertyChangedSignalSoundPropertyStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0;
     }
}

inline bool MainSinkSoundPropertyChangedSignalSoundPropertyStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 MainSinkSoundPropertyChangedSignalSoundPropertyStruct::getElem1 () const {
    return _elem1;
}

inline void MainSinkSoundPropertyChangedSignalSoundPropertyStruct::setElem1 (int16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void MainSinkSoundPropertyChangedSignalSoundPropertyStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0;
     }
}

inline bool MainSinkSoundPropertyChangedSignalSoundPropertyStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 MainSinkSoundPropertyChangedSignalSoundPropertyStruct::getElem2 () const {
    return _elem2;
}

inline void MainSinkSoundPropertyChangedSignalSoundPropertyStruct::setElem2 (int16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void MainSinkSoundPropertyChangedSignalSoundPropertyStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void MainSinkSoundPropertyChangedSignalSoundPropertyStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void MainSinkSoundPropertyChangedSignalSoundPropertyStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void MainSinkSoundPropertyChangedSignalSoundPropertyStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  MainSinkSoundPropertyChangedSignal::MainSinkSoundPropertyChangedSignal ()  :
    _sinkID (0u),
    _SoundProperty ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MainSinkSoundPropertyChangedSignal::MainSinkSoundPropertyChangedSignal (const MainSinkSoundPropertyChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _sinkID (0u),
    _SoundProperty ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MainSinkSoundPropertyChangedSignal::MainSinkSoundPropertyChangedSignal (uint16 sinkID_, const MainSinkSoundPropertyChangedSignalSoundPropertyStruct& SoundProperty_)  :
    _sinkID (sinkID_),
    _SoundProperty (SoundProperty_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MainSinkSoundPropertyChangedSignal::~MainSinkSoundPropertyChangedSignal() {
}

inline MainSinkSoundPropertyChangedSignal& MainSinkSoundPropertyChangedSignal::operator = (const MainSinkSoundPropertyChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSinkID()) {
            setSinkID(rhs.getSinkID());
        } else {
            clearSinkID();
        }
        if (rhs.hasSoundProperty()) {
            setSoundProperty(rhs.getSoundProperty());
        } else {
            clearSoundProperty();
        }
    }
    return *this;
}

inline bool MainSinkSoundPropertyChangedSignal::operator == (const MainSinkSoundPropertyChangedSignal& rhs) const {
    return (((!hasSinkID() && !rhs.hasSinkID()) || getSinkID() == rhs.getSinkID()) &&
        ((!hasSoundProperty() && !rhs.hasSoundProperty()) || getSoundProperty() == rhs.getSoundProperty()));
}

inline bool MainSinkSoundPropertyChangedSignal::operator != (const MainSinkSoundPropertyChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool MainSinkSoundPropertyChangedSignal::operator < (const MainSinkSoundPropertyChangedSignal& rhs) const {
    if (hasSinkID() || rhs.hasSinkID()) {
        if (getSinkID() < rhs.getSinkID()) return true;
        if (getSinkID() > rhs.getSinkID()) return false;
    }
    if (hasSoundProperty() || rhs.hasSoundProperty()) {
        if (getSoundProperty() < rhs.getSoundProperty()) return true;
        if (getSoundProperty() > rhs.getSoundProperty()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MainSinkSoundPropertyChangedSignal::clone() {
    return new MainSinkSoundPropertyChangedSignal(*this);
}

inline bool MainSinkSoundPropertyChangedSignal::operator > (const MainSinkSoundPropertyChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MainSinkSoundPropertyChangedSignal::clear() {
    clearSinkID();
    clearSoundProperty();
}

inline void MainSinkSoundPropertyChangedSignal::clearSinkID() {
    if (hasSinkID()) {
         clear_has_sinkID();
        _sinkID = 0u;
     }
}

inline bool MainSinkSoundPropertyChangedSignal::hasSinkID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 MainSinkSoundPropertyChangedSignal::getSinkID () const {
    return _sinkID;
}

inline void MainSinkSoundPropertyChangedSignal::setSinkID (uint16 sinkID_) {
    set_has_sinkID();
    this->_sinkID = sinkID_;
}

inline void MainSinkSoundPropertyChangedSignal::clearSoundProperty() {
    if (hasSoundProperty()) {
         clear_has_SoundProperty();
        _SoundProperty.clear();
     }
}

inline bool MainSinkSoundPropertyChangedSignal::hasSoundProperty () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const MainSinkSoundPropertyChangedSignalSoundPropertyStruct& MainSinkSoundPropertyChangedSignal::getSoundProperty () const {
    return _SoundProperty;
}

inline MainSinkSoundPropertyChangedSignalSoundPropertyStruct& MainSinkSoundPropertyChangedSignal::getSoundPropertyMutable () {
    set_has_SoundProperty();
    return _SoundProperty;
}

inline void MainSinkSoundPropertyChangedSignal::setSoundProperty (const MainSinkSoundPropertyChangedSignalSoundPropertyStruct& SoundProperty_) {
    set_has_SoundProperty();
    this->_SoundProperty = SoundProperty_;
}

inline void MainSinkSoundPropertyChangedSignal::set_has_sinkID () {
    _has_bits_[0] |= 1u << 0;
}

inline void MainSinkSoundPropertyChangedSignal::clear_has_sinkID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void MainSinkSoundPropertyChangedSignal::set_has_SoundProperty () {
    _has_bits_[0] |= 1u << 1;
}

inline void MainSinkSoundPropertyChangedSignal::clear_has_SoundProperty () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  MainSourceSoundPropertyChangedSignalSoundPropertyStruct::MainSourceSoundPropertyChangedSignalSoundPropertyStruct ()  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MainSourceSoundPropertyChangedSignalSoundPropertyStruct::MainSourceSoundPropertyChangedSignalSoundPropertyStruct (const MainSourceSoundPropertyChangedSignalSoundPropertyStruct &rhs)  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MainSourceSoundPropertyChangedSignalSoundPropertyStruct::MainSourceSoundPropertyChangedSignalSoundPropertyStruct (int16 elem1_, int16 elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MainSourceSoundPropertyChangedSignalSoundPropertyStruct::~MainSourceSoundPropertyChangedSignalSoundPropertyStruct() {
}

inline MainSourceSoundPropertyChangedSignalSoundPropertyStruct& MainSourceSoundPropertyChangedSignalSoundPropertyStruct::operator = (const MainSourceSoundPropertyChangedSignalSoundPropertyStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool MainSourceSoundPropertyChangedSignalSoundPropertyStruct::operator == (const MainSourceSoundPropertyChangedSignalSoundPropertyStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool MainSourceSoundPropertyChangedSignalSoundPropertyStruct::operator != (const MainSourceSoundPropertyChangedSignalSoundPropertyStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool MainSourceSoundPropertyChangedSignalSoundPropertyStruct::operator < (const MainSourceSoundPropertyChangedSignalSoundPropertyStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool MainSourceSoundPropertyChangedSignalSoundPropertyStruct::operator > (const MainSourceSoundPropertyChangedSignalSoundPropertyStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MainSourceSoundPropertyChangedSignalSoundPropertyStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void MainSourceSoundPropertyChangedSignalSoundPropertyStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0;
     }
}

inline bool MainSourceSoundPropertyChangedSignalSoundPropertyStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 MainSourceSoundPropertyChangedSignalSoundPropertyStruct::getElem1 () const {
    return _elem1;
}

inline void MainSourceSoundPropertyChangedSignalSoundPropertyStruct::setElem1 (int16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void MainSourceSoundPropertyChangedSignalSoundPropertyStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0;
     }
}

inline bool MainSourceSoundPropertyChangedSignalSoundPropertyStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 MainSourceSoundPropertyChangedSignalSoundPropertyStruct::getElem2 () const {
    return _elem2;
}

inline void MainSourceSoundPropertyChangedSignalSoundPropertyStruct::setElem2 (int16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void MainSourceSoundPropertyChangedSignalSoundPropertyStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void MainSourceSoundPropertyChangedSignalSoundPropertyStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void MainSourceSoundPropertyChangedSignalSoundPropertyStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void MainSourceSoundPropertyChangedSignalSoundPropertyStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  MainSourceSoundPropertyChangedSignal::MainSourceSoundPropertyChangedSignal ()  :
    _sourceID (0u),
    _SoundProperty ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MainSourceSoundPropertyChangedSignal::MainSourceSoundPropertyChangedSignal (const MainSourceSoundPropertyChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _sourceID (0u),
    _SoundProperty ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MainSourceSoundPropertyChangedSignal::MainSourceSoundPropertyChangedSignal (uint16 sourceID_, const MainSourceSoundPropertyChangedSignalSoundPropertyStruct& SoundProperty_)  :
    _sourceID (sourceID_),
    _SoundProperty (SoundProperty_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MainSourceSoundPropertyChangedSignal::~MainSourceSoundPropertyChangedSignal() {
}

inline MainSourceSoundPropertyChangedSignal& MainSourceSoundPropertyChangedSignal::operator = (const MainSourceSoundPropertyChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSourceID()) {
            setSourceID(rhs.getSourceID());
        } else {
            clearSourceID();
        }
        if (rhs.hasSoundProperty()) {
            setSoundProperty(rhs.getSoundProperty());
        } else {
            clearSoundProperty();
        }
    }
    return *this;
}

inline bool MainSourceSoundPropertyChangedSignal::operator == (const MainSourceSoundPropertyChangedSignal& rhs) const {
    return (((!hasSourceID() && !rhs.hasSourceID()) || getSourceID() == rhs.getSourceID()) &&
        ((!hasSoundProperty() && !rhs.hasSoundProperty()) || getSoundProperty() == rhs.getSoundProperty()));
}

inline bool MainSourceSoundPropertyChangedSignal::operator != (const MainSourceSoundPropertyChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool MainSourceSoundPropertyChangedSignal::operator < (const MainSourceSoundPropertyChangedSignal& rhs) const {
    if (hasSourceID() || rhs.hasSourceID()) {
        if (getSourceID() < rhs.getSourceID()) return true;
        if (getSourceID() > rhs.getSourceID()) return false;
    }
    if (hasSoundProperty() || rhs.hasSoundProperty()) {
        if (getSoundProperty() < rhs.getSoundProperty()) return true;
        if (getSoundProperty() > rhs.getSoundProperty()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MainSourceSoundPropertyChangedSignal::clone() {
    return new MainSourceSoundPropertyChangedSignal(*this);
}

inline bool MainSourceSoundPropertyChangedSignal::operator > (const MainSourceSoundPropertyChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MainSourceSoundPropertyChangedSignal::clear() {
    clearSourceID();
    clearSoundProperty();
}

inline void MainSourceSoundPropertyChangedSignal::clearSourceID() {
    if (hasSourceID()) {
         clear_has_sourceID();
        _sourceID = 0u;
     }
}

inline bool MainSourceSoundPropertyChangedSignal::hasSourceID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 MainSourceSoundPropertyChangedSignal::getSourceID () const {
    return _sourceID;
}

inline void MainSourceSoundPropertyChangedSignal::setSourceID (uint16 sourceID_) {
    set_has_sourceID();
    this->_sourceID = sourceID_;
}

inline void MainSourceSoundPropertyChangedSignal::clearSoundProperty() {
    if (hasSoundProperty()) {
         clear_has_SoundProperty();
        _SoundProperty.clear();
     }
}

inline bool MainSourceSoundPropertyChangedSignal::hasSoundProperty () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const MainSourceSoundPropertyChangedSignalSoundPropertyStruct& MainSourceSoundPropertyChangedSignal::getSoundProperty () const {
    return _SoundProperty;
}

inline MainSourceSoundPropertyChangedSignalSoundPropertyStruct& MainSourceSoundPropertyChangedSignal::getSoundPropertyMutable () {
    set_has_SoundProperty();
    return _SoundProperty;
}

inline void MainSourceSoundPropertyChangedSignal::setSoundProperty (const MainSourceSoundPropertyChangedSignalSoundPropertyStruct& SoundProperty_) {
    set_has_SoundProperty();
    this->_SoundProperty = SoundProperty_;
}

inline void MainSourceSoundPropertyChangedSignal::set_has_sourceID () {
    _has_bits_[0] |= 1u << 0;
}

inline void MainSourceSoundPropertyChangedSignal::clear_has_sourceID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void MainSourceSoundPropertyChangedSignal::set_has_SoundProperty () {
    _has_bits_[0] |= 1u << 1;
}

inline void MainSourceSoundPropertyChangedSignal::clear_has_SoundProperty () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SinkAvailabilityChangedSignalAvailabilityStruct::SinkAvailabilityChangedSignalAvailabilityStruct ()  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SinkAvailabilityChangedSignalAvailabilityStruct::SinkAvailabilityChangedSignalAvailabilityStruct (const SinkAvailabilityChangedSignalAvailabilityStruct &rhs)  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SinkAvailabilityChangedSignalAvailabilityStruct::SinkAvailabilityChangedSignalAvailabilityStruct (int16 elem1_, int16 elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SinkAvailabilityChangedSignalAvailabilityStruct::~SinkAvailabilityChangedSignalAvailabilityStruct() {
}

inline SinkAvailabilityChangedSignalAvailabilityStruct& SinkAvailabilityChangedSignalAvailabilityStruct::operator = (const SinkAvailabilityChangedSignalAvailabilityStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool SinkAvailabilityChangedSignalAvailabilityStruct::operator == (const SinkAvailabilityChangedSignalAvailabilityStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool SinkAvailabilityChangedSignalAvailabilityStruct::operator != (const SinkAvailabilityChangedSignalAvailabilityStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool SinkAvailabilityChangedSignalAvailabilityStruct::operator < (const SinkAvailabilityChangedSignalAvailabilityStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool SinkAvailabilityChangedSignalAvailabilityStruct::operator > (const SinkAvailabilityChangedSignalAvailabilityStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SinkAvailabilityChangedSignalAvailabilityStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void SinkAvailabilityChangedSignalAvailabilityStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0;
     }
}

inline bool SinkAvailabilityChangedSignalAvailabilityStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 SinkAvailabilityChangedSignalAvailabilityStruct::getElem1 () const {
    return _elem1;
}

inline void SinkAvailabilityChangedSignalAvailabilityStruct::setElem1 (int16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void SinkAvailabilityChangedSignalAvailabilityStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0;
     }
}

inline bool SinkAvailabilityChangedSignalAvailabilityStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 SinkAvailabilityChangedSignalAvailabilityStruct::getElem2 () const {
    return _elem2;
}

inline void SinkAvailabilityChangedSignalAvailabilityStruct::setElem2 (int16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void SinkAvailabilityChangedSignalAvailabilityStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void SinkAvailabilityChangedSignalAvailabilityStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SinkAvailabilityChangedSignalAvailabilityStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void SinkAvailabilityChangedSignalAvailabilityStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SinkAvailabilityChangedSignal::SinkAvailabilityChangedSignal ()  :
    _sinkID (0u),
    _availability ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SinkAvailabilityChangedSignal::SinkAvailabilityChangedSignal (const SinkAvailabilityChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _sinkID (0u),
    _availability ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SinkAvailabilityChangedSignal::SinkAvailabilityChangedSignal (uint16 sinkID_, const SinkAvailabilityChangedSignalAvailabilityStruct& availability_)  :
    _sinkID (sinkID_),
    _availability (availability_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SinkAvailabilityChangedSignal::~SinkAvailabilityChangedSignal() {
}

inline SinkAvailabilityChangedSignal& SinkAvailabilityChangedSignal::operator = (const SinkAvailabilityChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSinkID()) {
            setSinkID(rhs.getSinkID());
        } else {
            clearSinkID();
        }
        if (rhs.hasAvailability()) {
            setAvailability(rhs.getAvailability());
        } else {
            clearAvailability();
        }
    }
    return *this;
}

inline bool SinkAvailabilityChangedSignal::operator == (const SinkAvailabilityChangedSignal& rhs) const {
    return (((!hasSinkID() && !rhs.hasSinkID()) || getSinkID() == rhs.getSinkID()) &&
        ((!hasAvailability() && !rhs.hasAvailability()) || getAvailability() == rhs.getAvailability()));
}

inline bool SinkAvailabilityChangedSignal::operator != (const SinkAvailabilityChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SinkAvailabilityChangedSignal::operator < (const SinkAvailabilityChangedSignal& rhs) const {
    if (hasSinkID() || rhs.hasSinkID()) {
        if (getSinkID() < rhs.getSinkID()) return true;
        if (getSinkID() > rhs.getSinkID()) return false;
    }
    if (hasAvailability() || rhs.hasAvailability()) {
        if (getAvailability() < rhs.getAvailability()) return true;
        if (getAvailability() > rhs.getAvailability()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SinkAvailabilityChangedSignal::clone() {
    return new SinkAvailabilityChangedSignal(*this);
}

inline bool SinkAvailabilityChangedSignal::operator > (const SinkAvailabilityChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SinkAvailabilityChangedSignal::clear() {
    clearSinkID();
    clearAvailability();
}

inline void SinkAvailabilityChangedSignal::clearSinkID() {
    if (hasSinkID()) {
         clear_has_sinkID();
        _sinkID = 0u;
     }
}

inline bool SinkAvailabilityChangedSignal::hasSinkID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SinkAvailabilityChangedSignal::getSinkID () const {
    return _sinkID;
}

inline void SinkAvailabilityChangedSignal::setSinkID (uint16 sinkID_) {
    set_has_sinkID();
    this->_sinkID = sinkID_;
}

inline void SinkAvailabilityChangedSignal::clearAvailability() {
    if (hasAvailability()) {
         clear_has_availability();
        _availability.clear();
     }
}

inline bool SinkAvailabilityChangedSignal::hasAvailability () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const SinkAvailabilityChangedSignalAvailabilityStruct& SinkAvailabilityChangedSignal::getAvailability () const {
    return _availability;
}

inline SinkAvailabilityChangedSignalAvailabilityStruct& SinkAvailabilityChangedSignal::getAvailabilityMutable () {
    set_has_availability();
    return _availability;
}

inline void SinkAvailabilityChangedSignal::setAvailability (const SinkAvailabilityChangedSignalAvailabilityStruct& availability_) {
    set_has_availability();
    this->_availability = availability_;
}

inline void SinkAvailabilityChangedSignal::set_has_sinkID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SinkAvailabilityChangedSignal::clear_has_sinkID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SinkAvailabilityChangedSignal::set_has_availability () {
    _has_bits_[0] |= 1u << 1;
}

inline void SinkAvailabilityChangedSignal::clear_has_availability () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SourceAvailabilityChangedSignalAvailabilityStruct::SourceAvailabilityChangedSignalAvailabilityStruct ()  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SourceAvailabilityChangedSignalAvailabilityStruct::SourceAvailabilityChangedSignalAvailabilityStruct (const SourceAvailabilityChangedSignalAvailabilityStruct &rhs)  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SourceAvailabilityChangedSignalAvailabilityStruct::SourceAvailabilityChangedSignalAvailabilityStruct (int16 elem1_, int16 elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SourceAvailabilityChangedSignalAvailabilityStruct::~SourceAvailabilityChangedSignalAvailabilityStruct() {
}

inline SourceAvailabilityChangedSignalAvailabilityStruct& SourceAvailabilityChangedSignalAvailabilityStruct::operator = (const SourceAvailabilityChangedSignalAvailabilityStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool SourceAvailabilityChangedSignalAvailabilityStruct::operator == (const SourceAvailabilityChangedSignalAvailabilityStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool SourceAvailabilityChangedSignalAvailabilityStruct::operator != (const SourceAvailabilityChangedSignalAvailabilityStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool SourceAvailabilityChangedSignalAvailabilityStruct::operator < (const SourceAvailabilityChangedSignalAvailabilityStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool SourceAvailabilityChangedSignalAvailabilityStruct::operator > (const SourceAvailabilityChangedSignalAvailabilityStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SourceAvailabilityChangedSignalAvailabilityStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void SourceAvailabilityChangedSignalAvailabilityStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0;
     }
}

inline bool SourceAvailabilityChangedSignalAvailabilityStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 SourceAvailabilityChangedSignalAvailabilityStruct::getElem1 () const {
    return _elem1;
}

inline void SourceAvailabilityChangedSignalAvailabilityStruct::setElem1 (int16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void SourceAvailabilityChangedSignalAvailabilityStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0;
     }
}

inline bool SourceAvailabilityChangedSignalAvailabilityStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 SourceAvailabilityChangedSignalAvailabilityStruct::getElem2 () const {
    return _elem2;
}

inline void SourceAvailabilityChangedSignalAvailabilityStruct::setElem2 (int16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void SourceAvailabilityChangedSignalAvailabilityStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void SourceAvailabilityChangedSignalAvailabilityStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SourceAvailabilityChangedSignalAvailabilityStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void SourceAvailabilityChangedSignalAvailabilityStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SourceAvailabilityChangedSignal::SourceAvailabilityChangedSignal ()  :
    _sourceID (0u),
    _availability ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SourceAvailabilityChangedSignal::SourceAvailabilityChangedSignal (const SourceAvailabilityChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _sourceID (0u),
    _availability ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SourceAvailabilityChangedSignal::SourceAvailabilityChangedSignal (uint16 sourceID_, const SourceAvailabilityChangedSignalAvailabilityStruct& availability_)  :
    _sourceID (sourceID_),
    _availability (availability_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SourceAvailabilityChangedSignal::~SourceAvailabilityChangedSignal() {
}

inline SourceAvailabilityChangedSignal& SourceAvailabilityChangedSignal::operator = (const SourceAvailabilityChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSourceID()) {
            setSourceID(rhs.getSourceID());
        } else {
            clearSourceID();
        }
        if (rhs.hasAvailability()) {
            setAvailability(rhs.getAvailability());
        } else {
            clearAvailability();
        }
    }
    return *this;
}

inline bool SourceAvailabilityChangedSignal::operator == (const SourceAvailabilityChangedSignal& rhs) const {
    return (((!hasSourceID() && !rhs.hasSourceID()) || getSourceID() == rhs.getSourceID()) &&
        ((!hasAvailability() && !rhs.hasAvailability()) || getAvailability() == rhs.getAvailability()));
}

inline bool SourceAvailabilityChangedSignal::operator != (const SourceAvailabilityChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SourceAvailabilityChangedSignal::operator < (const SourceAvailabilityChangedSignal& rhs) const {
    if (hasSourceID() || rhs.hasSourceID()) {
        if (getSourceID() < rhs.getSourceID()) return true;
        if (getSourceID() > rhs.getSourceID()) return false;
    }
    if (hasAvailability() || rhs.hasAvailability()) {
        if (getAvailability() < rhs.getAvailability()) return true;
        if (getAvailability() > rhs.getAvailability()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SourceAvailabilityChangedSignal::clone() {
    return new SourceAvailabilityChangedSignal(*this);
}

inline bool SourceAvailabilityChangedSignal::operator > (const SourceAvailabilityChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SourceAvailabilityChangedSignal::clear() {
    clearSourceID();
    clearAvailability();
}

inline void SourceAvailabilityChangedSignal::clearSourceID() {
    if (hasSourceID()) {
         clear_has_sourceID();
        _sourceID = 0u;
     }
}

inline bool SourceAvailabilityChangedSignal::hasSourceID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SourceAvailabilityChangedSignal::getSourceID () const {
    return _sourceID;
}

inline void SourceAvailabilityChangedSignal::setSourceID (uint16 sourceID_) {
    set_has_sourceID();
    this->_sourceID = sourceID_;
}

inline void SourceAvailabilityChangedSignal::clearAvailability() {
    if (hasAvailability()) {
         clear_has_availability();
        _availability.clear();
     }
}

inline bool SourceAvailabilityChangedSignal::hasAvailability () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const SourceAvailabilityChangedSignalAvailabilityStruct& SourceAvailabilityChangedSignal::getAvailability () const {
    return _availability;
}

inline SourceAvailabilityChangedSignalAvailabilityStruct& SourceAvailabilityChangedSignal::getAvailabilityMutable () {
    set_has_availability();
    return _availability;
}

inline void SourceAvailabilityChangedSignal::setAvailability (const SourceAvailabilityChangedSignalAvailabilityStruct& availability_) {
    set_has_availability();
    this->_availability = availability_;
}

inline void SourceAvailabilityChangedSignal::set_has_sourceID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SourceAvailabilityChangedSignal::clear_has_sourceID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SourceAvailabilityChangedSignal::set_has_availability () {
    _has_bits_[0] |= 1u << 1;
}

inline void SourceAvailabilityChangedSignal::clear_has_availability () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  VolumeChangedSignal::VolumeChangedSignal ()  :
    _sinkID (0u),
    _volume (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VolumeChangedSignal::VolumeChangedSignal (const VolumeChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _sinkID (0u),
    _volume (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VolumeChangedSignal::VolumeChangedSignal (uint16 sinkID_, int16 volume_)  :
    _sinkID (sinkID_),
    _volume (volume_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VolumeChangedSignal::~VolumeChangedSignal() {
}

inline VolumeChangedSignal& VolumeChangedSignal::operator = (const VolumeChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSinkID()) {
            setSinkID(rhs.getSinkID());
        } else {
            clearSinkID();
        }
        if (rhs.hasVolume()) {
            setVolume(rhs.getVolume());
        } else {
            clearVolume();
        }
    }
    return *this;
}

inline bool VolumeChangedSignal::operator == (const VolumeChangedSignal& rhs) const {
    return (((!hasSinkID() && !rhs.hasSinkID()) || getSinkID() == rhs.getSinkID()) &&
        ((!hasVolume() && !rhs.hasVolume()) || getVolume() == rhs.getVolume()));
}

inline bool VolumeChangedSignal::operator != (const VolumeChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool VolumeChangedSignal::operator < (const VolumeChangedSignal& rhs) const {
    if (hasSinkID() || rhs.hasSinkID()) {
        if (getSinkID() < rhs.getSinkID()) return true;
        if (getSinkID() > rhs.getSinkID()) return false;
    }
    if (hasVolume() || rhs.hasVolume()) {
        if (getVolume() < rhs.getVolume()) return true;
        if (getVolume() > rhs.getVolume()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VolumeChangedSignal::clone() {
    return new VolumeChangedSignal(*this);
}

inline bool VolumeChangedSignal::operator > (const VolumeChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VolumeChangedSignal::clear() {
    clearSinkID();
    clearVolume();
}

inline void VolumeChangedSignal::clearSinkID() {
    if (hasSinkID()) {
         clear_has_sinkID();
        _sinkID = 0u;
     }
}

inline bool VolumeChangedSignal::hasSinkID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 VolumeChangedSignal::getSinkID () const {
    return _sinkID;
}

inline void VolumeChangedSignal::setSinkID (uint16 sinkID_) {
    set_has_sinkID();
    this->_sinkID = sinkID_;
}

inline void VolumeChangedSignal::clearVolume() {
    if (hasVolume()) {
         clear_has_volume();
        _volume = 0;
     }
}

inline bool VolumeChangedSignal::hasVolume () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 VolumeChangedSignal::getVolume () const {
    return _volume;
}

inline void VolumeChangedSignal::setVolume (int16 volume_) {
    set_has_volume();
    this->_volume = volume_;
}

inline void VolumeChangedSignal::set_has_sinkID () {
    _has_bits_[0] |= 1u << 0;
}

inline void VolumeChangedSignal::clear_has_sinkID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void VolumeChangedSignal::set_has_volume () {
    _has_bits_[0] |= 1u << 1;
}

inline void VolumeChangedSignal::clear_has_volume () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SinkMuteStateChangedSignal::SinkMuteStateChangedSignal ()  :
    _sinkID (0u),
    _muteState (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SinkMuteStateChangedSignal::SinkMuteStateChangedSignal (const SinkMuteStateChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _sinkID (0u),
    _muteState (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SinkMuteStateChangedSignal::SinkMuteStateChangedSignal (uint16 sinkID_, int16 muteState_)  :
    _sinkID (sinkID_),
    _muteState (muteState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SinkMuteStateChangedSignal::~SinkMuteStateChangedSignal() {
}

inline SinkMuteStateChangedSignal& SinkMuteStateChangedSignal::operator = (const SinkMuteStateChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSinkID()) {
            setSinkID(rhs.getSinkID());
        } else {
            clearSinkID();
        }
        if (rhs.hasMuteState()) {
            setMuteState(rhs.getMuteState());
        } else {
            clearMuteState();
        }
    }
    return *this;
}

inline bool SinkMuteStateChangedSignal::operator == (const SinkMuteStateChangedSignal& rhs) const {
    return (((!hasSinkID() && !rhs.hasSinkID()) || getSinkID() == rhs.getSinkID()) &&
        ((!hasMuteState() && !rhs.hasMuteState()) || getMuteState() == rhs.getMuteState()));
}

inline bool SinkMuteStateChangedSignal::operator != (const SinkMuteStateChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SinkMuteStateChangedSignal::operator < (const SinkMuteStateChangedSignal& rhs) const {
    if (hasSinkID() || rhs.hasSinkID()) {
        if (getSinkID() < rhs.getSinkID()) return true;
        if (getSinkID() > rhs.getSinkID()) return false;
    }
    if (hasMuteState() || rhs.hasMuteState()) {
        if (getMuteState() < rhs.getMuteState()) return true;
        if (getMuteState() > rhs.getMuteState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SinkMuteStateChangedSignal::clone() {
    return new SinkMuteStateChangedSignal(*this);
}

inline bool SinkMuteStateChangedSignal::operator > (const SinkMuteStateChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SinkMuteStateChangedSignal::clear() {
    clearSinkID();
    clearMuteState();
}

inline void SinkMuteStateChangedSignal::clearSinkID() {
    if (hasSinkID()) {
         clear_has_sinkID();
        _sinkID = 0u;
     }
}

inline bool SinkMuteStateChangedSignal::hasSinkID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SinkMuteStateChangedSignal::getSinkID () const {
    return _sinkID;
}

inline void SinkMuteStateChangedSignal::setSinkID (uint16 sinkID_) {
    set_has_sinkID();
    this->_sinkID = sinkID_;
}

inline void SinkMuteStateChangedSignal::clearMuteState() {
    if (hasMuteState()) {
         clear_has_muteState();
        _muteState = 0;
     }
}

inline bool SinkMuteStateChangedSignal::hasMuteState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 SinkMuteStateChangedSignal::getMuteState () const {
    return _muteState;
}

inline void SinkMuteStateChangedSignal::setMuteState (int16 muteState_) {
    set_has_muteState();
    this->_muteState = muteState_;
}

inline void SinkMuteStateChangedSignal::set_has_sinkID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SinkMuteStateChangedSignal::clear_has_sinkID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SinkMuteStateChangedSignal::set_has_muteState () {
    _has_bits_[0] |= 1u << 1;
}

inline void SinkMuteStateChangedSignal::clear_has_muteState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SystemPropertyChangedSignalSystemPropertyStruct::SystemPropertyChangedSignalSystemPropertyStruct ()  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SystemPropertyChangedSignalSystemPropertyStruct::SystemPropertyChangedSignalSystemPropertyStruct (const SystemPropertyChangedSignalSystemPropertyStruct &rhs)  :
    _elem1 (0),
    _elem2 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SystemPropertyChangedSignalSystemPropertyStruct::SystemPropertyChangedSignalSystemPropertyStruct (int16 elem1_, int16 elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SystemPropertyChangedSignalSystemPropertyStruct::~SystemPropertyChangedSignalSystemPropertyStruct() {
}

inline SystemPropertyChangedSignalSystemPropertyStruct& SystemPropertyChangedSignalSystemPropertyStruct::operator = (const SystemPropertyChangedSignalSystemPropertyStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool SystemPropertyChangedSignalSystemPropertyStruct::operator == (const SystemPropertyChangedSignalSystemPropertyStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool SystemPropertyChangedSignalSystemPropertyStruct::operator != (const SystemPropertyChangedSignalSystemPropertyStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool SystemPropertyChangedSignalSystemPropertyStruct::operator < (const SystemPropertyChangedSignalSystemPropertyStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool SystemPropertyChangedSignalSystemPropertyStruct::operator > (const SystemPropertyChangedSignalSystemPropertyStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SystemPropertyChangedSignalSystemPropertyStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void SystemPropertyChangedSignalSystemPropertyStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0;
     }
}

inline bool SystemPropertyChangedSignalSystemPropertyStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 SystemPropertyChangedSignalSystemPropertyStruct::getElem1 () const {
    return _elem1;
}

inline void SystemPropertyChangedSignalSystemPropertyStruct::setElem1 (int16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void SystemPropertyChangedSignalSystemPropertyStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0;
     }
}

inline bool SystemPropertyChangedSignalSystemPropertyStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 SystemPropertyChangedSignalSystemPropertyStruct::getElem2 () const {
    return _elem2;
}

inline void SystemPropertyChangedSignalSystemPropertyStruct::setElem2 (int16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void SystemPropertyChangedSignalSystemPropertyStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void SystemPropertyChangedSignalSystemPropertyStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SystemPropertyChangedSignalSystemPropertyStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void SystemPropertyChangedSignalSystemPropertyStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SystemPropertyChangedSignal::SystemPropertyChangedSignal ()  :
    _SystemProperty ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SystemPropertyChangedSignal::SystemPropertyChangedSignal (const SystemPropertyChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _SystemProperty ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SystemPropertyChangedSignal::SystemPropertyChangedSignal (const SystemPropertyChangedSignalSystemPropertyStruct& SystemProperty_)  :
    _SystemProperty (SystemProperty_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SystemPropertyChangedSignal::~SystemPropertyChangedSignal() {
}

inline SystemPropertyChangedSignal& SystemPropertyChangedSignal::operator = (const SystemPropertyChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSystemProperty()) {
            setSystemProperty(rhs.getSystemProperty());
        } else {
            clearSystemProperty();
        }
    }
    return *this;
}

inline bool SystemPropertyChangedSignal::operator == (const SystemPropertyChangedSignal& rhs) const {
    return (((!hasSystemProperty() && !rhs.hasSystemProperty()) || getSystemProperty() == rhs.getSystemProperty()));
}

inline bool SystemPropertyChangedSignal::operator != (const SystemPropertyChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SystemPropertyChangedSignal::operator < (const SystemPropertyChangedSignal& rhs) const {
    if (hasSystemProperty() || rhs.hasSystemProperty()) {
        if (getSystemProperty() < rhs.getSystemProperty()) return true;
        if (getSystemProperty() > rhs.getSystemProperty()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SystemPropertyChangedSignal::clone() {
    return new SystemPropertyChangedSignal(*this);
}

inline bool SystemPropertyChangedSignal::operator > (const SystemPropertyChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SystemPropertyChangedSignal::clear() {
    clearSystemProperty();
}

inline void SystemPropertyChangedSignal::clearSystemProperty() {
    if (hasSystemProperty()) {
         clear_has_SystemProperty();
        _SystemProperty.clear();
     }
}

inline bool SystemPropertyChangedSignal::hasSystemProperty () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const SystemPropertyChangedSignalSystemPropertyStruct& SystemPropertyChangedSignal::getSystemProperty () const {
    return _SystemProperty;
}

inline SystemPropertyChangedSignalSystemPropertyStruct& SystemPropertyChangedSignal::getSystemPropertyMutable () {
    set_has_SystemProperty();
    return _SystemProperty;
}

inline void SystemPropertyChangedSignal::setSystemProperty (const SystemPropertyChangedSignalSystemPropertyStruct& SystemProperty_) {
    set_has_SystemProperty();
    this->_SystemProperty = SystemProperty_;
}

inline void SystemPropertyChangedSignal::set_has_SystemProperty () {
    _has_bits_[0] |= 1u << 0;
}

inline void SystemPropertyChangedSignal::clear_has_SystemProperty () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TimingInformationChangedSignal::TimingInformationChangedSignal ()  :
    _mainConnection (0u),
    _time (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TimingInformationChangedSignal::TimingInformationChangedSignal (const TimingInformationChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _mainConnection (0u),
    _time (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TimingInformationChangedSignal::TimingInformationChangedSignal (uint16 mainConnection_, int16 time_)  :
    _mainConnection (mainConnection_),
    _time (time_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TimingInformationChangedSignal::~TimingInformationChangedSignal() {
}

inline TimingInformationChangedSignal& TimingInformationChangedSignal::operator = (const TimingInformationChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMainConnection()) {
            setMainConnection(rhs.getMainConnection());
        } else {
            clearMainConnection();
        }
        if (rhs.hasTime()) {
            setTime(rhs.getTime());
        } else {
            clearTime();
        }
    }
    return *this;
}

inline bool TimingInformationChangedSignal::operator == (const TimingInformationChangedSignal& rhs) const {
    return (((!hasMainConnection() && !rhs.hasMainConnection()) || getMainConnection() == rhs.getMainConnection()) &&
        ((!hasTime() && !rhs.hasTime()) || getTime() == rhs.getTime()));
}

inline bool TimingInformationChangedSignal::operator != (const TimingInformationChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool TimingInformationChangedSignal::operator < (const TimingInformationChangedSignal& rhs) const {
    if (hasMainConnection() || rhs.hasMainConnection()) {
        if (getMainConnection() < rhs.getMainConnection()) return true;
        if (getMainConnection() > rhs.getMainConnection()) return false;
    }
    if (hasTime() || rhs.hasTime()) {
        if (getTime() < rhs.getTime()) return true;
        if (getTime() > rhs.getTime()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TimingInformationChangedSignal::clone() {
    return new TimingInformationChangedSignal(*this);
}

inline bool TimingInformationChangedSignal::operator > (const TimingInformationChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TimingInformationChangedSignal::clear() {
    clearMainConnection();
    clearTime();
}

inline void TimingInformationChangedSignal::clearMainConnection() {
    if (hasMainConnection()) {
         clear_has_mainConnection();
        _mainConnection = 0u;
     }
}

inline bool TimingInformationChangedSignal::hasMainConnection () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 TimingInformationChangedSignal::getMainConnection () const {
    return _mainConnection;
}

inline void TimingInformationChangedSignal::setMainConnection (uint16 mainConnection_) {
    set_has_mainConnection();
    this->_mainConnection = mainConnection_;
}

inline void TimingInformationChangedSignal::clearTime() {
    if (hasTime()) {
         clear_has_time();
        _time = 0;
     }
}

inline bool TimingInformationChangedSignal::hasTime () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 TimingInformationChangedSignal::getTime () const {
    return _time;
}

inline void TimingInformationChangedSignal::setTime (int16 time_) {
    set_has_time();
    this->_time = time_;
}

inline void TimingInformationChangedSignal::set_has_mainConnection () {
    _has_bits_[0] |= 1u << 0;
}

inline void TimingInformationChangedSignal::clear_has_mainConnection () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void TimingInformationChangedSignal::set_has_time () {
    _has_bits_[0] |= 1u << 1;
}

inline void TimingInformationChangedSignal::clear_has_time () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace CommandInterface
} // namespace audiomanager
} // namespace genivi
} // namespace org

#endif // ORG_GENIVI_AUDIOMANAGER_COMMANDINTERFACE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
