/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/ecnr/service.h"
#include "org/bosch/ecnr/serviceDBus.h"
#include "org/bosch/ecnr/serviceJson.h"
#include "org/bosch/ecnr/serviceProxy.h"
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace ecnr {
namespace service {

DEFINE_CLASS_LOGGER("///org/bosch/ecnr/service", ServiceProxy);

class ServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    ServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< ServiceProxy >& proxyShared = ::boost::static_pointer_cast< ServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_ecnrAsrModeEnable:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrAsrModeEnableSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EcnrAsrModeEnable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<EcnrAsrModeEnableSignal> payload = ::boost::static_pointer_cast<EcnrAsrModeEnableSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((EcnrAsrModeEnableCallbackIF*) _callback)->onEcnrAsrModeEnableSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_ecnrAudioStatus:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrAudioStatusSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EcnrAudioStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<EcnrAudioStatusSignal> payload = ::boost::static_pointer_cast<EcnrAudioStatusSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((EcnrAudioStatusCallbackIF*) _callback)->onEcnrAudioStatusSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_ecnrMicroLevelStatus:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrMicroLevelStatusSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EcnrMicroLevelStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<EcnrMicroLevelStatusSignal> payload = ::boost::static_pointer_cast<EcnrMicroLevelStatusSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((EcnrMicroLevelStatusCallbackIF*) _callback)->onEcnrMicroLevelStatusSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_ecnrMicLvlNtfyInterval:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrMicLvlNtfyIntervalError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EcnrMicLvlNtfyInterval", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrMicLvlNtfyIntervalError> payload = ::boost::static_pointer_cast<EcnrMicLvlNtfyIntervalError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((EcnrMicLvlNtfyIntervalCallbackIF*) _callback)->onEcnrMicLvlNtfyIntervalError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrMicLvlNtfyIntervalUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EcnrMicLvlNtfyInterval", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrMicLvlNtfyIntervalUpdate> payload = ::boost::static_pointer_cast<EcnrMicLvlNtfyIntervalUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((EcnrMicLvlNtfyIntervalCallbackIF*) _callback)->onEcnrMicLvlNtfyIntervalUpdate(proxyShared, payload);
                        proxyShared->_ecnrMicLvlNtfyInterval = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ecnrAsrMode:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrAsrModeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EcnrAsrMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrAsrModeError> payload = ::boost::static_pointer_cast<EcnrAsrModeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((EcnrAsrModeCallbackIF*) _callback)->onEcnrAsrModeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrAsrModeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EcnrAsrMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrAsrModeUpdate> payload = ::boost::static_pointer_cast<EcnrAsrModeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((EcnrAsrModeCallbackIF*) _callback)->onEcnrAsrModeUpdate(proxyShared, payload);
                        proxyShared->_ecnrAsrMode = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ecnrAudioState:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrAudioStateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EcnrAudioState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrAudioStateError> payload = ::boost::static_pointer_cast<EcnrAudioStateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((EcnrAudioStateCallbackIF*) _callback)->onEcnrAudioStateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrAudioStateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EcnrAudioState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrAudioStateUpdate> payload = ::boost::static_pointer_cast<EcnrAudioStateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((EcnrAudioStateCallbackIF*) _callback)->onEcnrAudioStateUpdate(proxyShared, payload);
                        proxyShared->_ecnrAudioState = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ecnrAsrDataType:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrAsrDataTypeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EcnrAsrDataType", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrAsrDataTypeError> payload = ::boost::static_pointer_cast<EcnrAsrDataTypeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((EcnrAsrDataTypeCallbackIF*) _callback)->onEcnrAsrDataTypeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrAsrDataTypeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EcnrAsrDataType", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrAsrDataTypeUpdate> payload = ::boost::static_pointer_cast<EcnrAsrDataTypeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((EcnrAsrDataTypeCallbackIF*) _callback)->onEcnrAsrDataTypeUpdate(proxyShared, payload);
                        proxyShared->_ecnrAsrDataType = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ecnrGetVersion:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrGetVersionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrGetVersion", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrGetVersionError> payload = ::boost::static_pointer_cast<EcnrGetVersionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrGetVersionCallbackIF*) _callback)->onEcnrGetVersionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrGetVersionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrGetVersion", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrGetVersionResponse> payload = ::boost::static_pointer_cast<EcnrGetVersionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrGetVersionCallbackIF*) _callback)->onEcnrGetVersionResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrGetStatusMessage:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrGetStatusMessageError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrGetStatusMessage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrGetStatusMessageError> payload = ::boost::static_pointer_cast<EcnrGetStatusMessageError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrGetStatusMessageCallbackIF*) _callback)->onEcnrGetStatusMessageError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrGetStatusMessageResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrGetStatusMessage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrGetStatusMessageResponse> payload = ::boost::static_pointer_cast<EcnrGetStatusMessageResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrGetStatusMessageCallbackIF*) _callback)->onEcnrGetStatusMessageResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrInitialize:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrInitializeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrInitialize", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrInitializeError> payload = ::boost::static_pointer_cast<EcnrInitializeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrInitializeCallbackIF*) _callback)->onEcnrInitializeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrInitializeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrInitialize", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrInitializeResponse> payload = ::boost::static_pointer_cast<EcnrInitializeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrInitializeCallbackIF*) _callback)->onEcnrInitializeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrInitializeSync:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrInitializeSyncError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrInitializeSync", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrInitializeSyncError> payload = ::boost::static_pointer_cast<EcnrInitializeSyncError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrInitializeSyncCallbackIF*) _callback)->onEcnrInitializeSyncError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrInitializeSyncResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrInitializeSync", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrInitializeSyncResponse> payload = ::boost::static_pointer_cast<EcnrInitializeSyncResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrInitializeSyncCallbackIF*) _callback)->onEcnrInitializeSyncResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrReset:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrResetError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrReset", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrResetError> payload = ::boost::static_pointer_cast<EcnrResetError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrResetCallbackIF*) _callback)->onEcnrResetError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrResetResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrReset", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrResetResponse> payload = ::boost::static_pointer_cast<EcnrResetResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrResetCallbackIF*) _callback)->onEcnrResetResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrDestroy:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrDestroyError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrDestroy", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrDestroyError> payload = ::boost::static_pointer_cast<EcnrDestroyError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrDestroyCallbackIF*) _callback)->onEcnrDestroyError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrDestroyResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrDestroy", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrDestroyResponse> payload = ::boost::static_pointer_cast<EcnrDestroyResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrDestroyCallbackIF*) _callback)->onEcnrDestroyResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrTerminate:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrTerminateError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrTerminate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrTerminateError> payload = ::boost::static_pointer_cast<EcnrTerminateError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrTerminateCallbackIF*) _callback)->onEcnrTerminateError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrTerminateResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrTerminate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrTerminateResponse> payload = ::boost::static_pointer_cast<EcnrTerminateResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrTerminateCallbackIF*) _callback)->onEcnrTerminateResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrSetConfiguration:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetConfigurationError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrSetConfiguration", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrSetConfigurationError> payload = ::boost::static_pointer_cast<EcnrSetConfigurationError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrSetConfigurationCallbackIF*) _callback)->onEcnrSetConfigurationError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetConfigurationResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrSetConfiguration", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrSetConfigurationResponse> payload = ::boost::static_pointer_cast<EcnrSetConfigurationResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrSetConfigurationCallbackIF*) _callback)->onEcnrSetConfigurationResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrSetConfigurationSync:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetConfigurationSyncError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrSetConfigurationSync", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrSetConfigurationSyncError> payload = ::boost::static_pointer_cast<EcnrSetConfigurationSyncError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrSetConfigurationSyncCallbackIF*) _callback)->onEcnrSetConfigurationSyncError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetConfigurationSyncResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrSetConfigurationSync", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrSetConfigurationSyncResponse> payload = ::boost::static_pointer_cast<EcnrSetConfigurationSyncResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrSetConfigurationSyncCallbackIF*) _callback)->onEcnrSetConfigurationSyncResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrGetEcnrConfiguration:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrGetEcnrConfigurationError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrGetEcnrConfiguration", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrGetEcnrConfigurationError> payload = ::boost::static_pointer_cast<EcnrGetEcnrConfigurationError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrGetEcnrConfigurationCallbackIF*) _callback)->onEcnrGetEcnrConfigurationError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrGetEcnrConfigurationResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrGetEcnrConfiguration", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrGetEcnrConfigurationResponse> payload = ::boost::static_pointer_cast<EcnrGetEcnrConfigurationResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrGetEcnrConfigurationCallbackIF*) _callback)->onEcnrGetEcnrConfigurationResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrStartAudio:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrStartAudioError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrStartAudio", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrStartAudioError> payload = ::boost::static_pointer_cast<EcnrStartAudioError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrStartAudioCallbackIF*) _callback)->onEcnrStartAudioError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrStartAudioResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrStartAudio", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrStartAudioResponse> payload = ::boost::static_pointer_cast<EcnrStartAudioResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrStartAudioCallbackIF*) _callback)->onEcnrStartAudioResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrStartAudioExt:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrStartAudioExtError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrStartAudioExt", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrStartAudioExtError> payload = ::boost::static_pointer_cast<EcnrStartAudioExtError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrStartAudioExtCallbackIF*) _callback)->onEcnrStartAudioExtError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrStartAudioExtResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrStartAudioExt", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrStartAudioExtResponse> payload = ::boost::static_pointer_cast<EcnrStartAudioExtResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrStartAudioExtCallbackIF*) _callback)->onEcnrStartAudioExtResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrStopAudio:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrStopAudioError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrStopAudio", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrStopAudioError> payload = ::boost::static_pointer_cast<EcnrStopAudioError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrStopAudioCallbackIF*) _callback)->onEcnrStopAudioError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrStopAudioResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrStopAudio", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrStopAudioResponse> payload = ::boost::static_pointer_cast<EcnrStopAudioResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrStopAudioCallbackIF*) _callback)->onEcnrStopAudioResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrFrameInfo:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrFrameInfoError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrFrameInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrFrameInfoError> payload = ::boost::static_pointer_cast<EcnrFrameInfoError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrFrameInfoCallbackIF*) _callback)->onEcnrFrameInfoError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrFrameInfoResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrFrameInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrFrameInfoResponse> payload = ::boost::static_pointer_cast<EcnrFrameInfoResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrFrameInfoCallbackIF*) _callback)->onEcnrFrameInfoResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrMicClipStats:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrMicClipStatsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrMicClipStats", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrMicClipStatsError> payload = ::boost::static_pointer_cast<EcnrMicClipStatsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrMicClipStatsCallbackIF*) _callback)->onEcnrMicClipStatsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrMicClipStatsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrMicClipStats", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrMicClipStatsResponse> payload = ::boost::static_pointer_cast<EcnrMicClipStatsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrMicClipStatsCallbackIF*) _callback)->onEcnrMicClipStatsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrRefClipStats:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrRefClipStatsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrRefClipStats", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrRefClipStatsError> payload = ::boost::static_pointer_cast<EcnrRefClipStatsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrRefClipStatsCallbackIF*) _callback)->onEcnrRefClipStatsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrRefClipStatsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrRefClipStats", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrRefClipStatsResponse> payload = ::boost::static_pointer_cast<EcnrRefClipStatsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrRefClipStatsCallbackIF*) _callback)->onEcnrRefClipStatsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrRecvClipStats:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrRecvClipStatsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrRecvClipStats", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrRecvClipStatsError> payload = ::boost::static_pointer_cast<EcnrRecvClipStatsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrRecvClipStatsCallbackIF*) _callback)->onEcnrRecvClipStatsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrRecvClipStatsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrRecvClipStats", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrRecvClipStatsResponse> payload = ::boost::static_pointer_cast<EcnrRecvClipStatsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrRecvClipStatsCallbackIF*) _callback)->onEcnrRecvClipStatsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrMicOutClipStats:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrMicOutClipStatsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrMicOutClipStats", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrMicOutClipStatsError> payload = ::boost::static_pointer_cast<EcnrMicOutClipStatsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrMicOutClipStatsCallbackIF*) _callback)->onEcnrMicOutClipStatsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrMicOutClipStatsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrMicOutClipStats", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrMicOutClipStatsResponse> payload = ::boost::static_pointer_cast<EcnrMicOutClipStatsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrMicOutClipStatsCallbackIF*) _callback)->onEcnrMicOutClipStatsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrRecvOutClipStats:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrRecvOutClipStatsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrRecvOutClipStats", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrRecvOutClipStatsError> payload = ::boost::static_pointer_cast<EcnrRecvOutClipStatsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrRecvOutClipStatsCallbackIF*) _callback)->onEcnrRecvOutClipStatsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrRecvOutClipStatsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrRecvOutClipStats", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrRecvOutClipStatsResponse> payload = ::boost::static_pointer_cast<EcnrRecvOutClipStatsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrRecvOutClipStatsCallbackIF*) _callback)->onEcnrRecvOutClipStatsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrSetSendMuteSwitch:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetSendMuteSwitchError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrSetSendMuteSwitch", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrSetSendMuteSwitchError> payload = ::boost::static_pointer_cast<EcnrSetSendMuteSwitchError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrSetSendMuteSwitchCallbackIF*) _callback)->onEcnrSetSendMuteSwitchError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetSendMuteSwitchResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrSetSendMuteSwitch", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrSetSendMuteSwitchResponse> payload = ::boost::static_pointer_cast<EcnrSetSendMuteSwitchResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrSetSendMuteSwitchCallbackIF*) _callback)->onEcnrSetSendMuteSwitchResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrSetSendGainDelta:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetSendGainDeltaError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrSetSendGainDelta", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrSetSendGainDeltaError> payload = ::boost::static_pointer_cast<EcnrSetSendGainDeltaError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrSetSendGainDeltaCallbackIF*) _callback)->onEcnrSetSendGainDeltaError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetSendGainDeltaResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrSetSendGainDelta", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrSetSendGainDeltaResponse> payload = ::boost::static_pointer_cast<EcnrSetSendGainDeltaResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrSetSendGainDeltaCallbackIF*) _callback)->onEcnrSetSendGainDeltaResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrSetMicGain:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetMicGainError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrSetMicGain", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrSetMicGainError> payload = ::boost::static_pointer_cast<EcnrSetMicGainError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrSetMicGainCallbackIF*) _callback)->onEcnrSetMicGainError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetMicGainResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrSetMicGain", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrSetMicGainResponse> payload = ::boost::static_pointer_cast<EcnrSetMicGainResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrSetMicGainCallbackIF*) _callback)->onEcnrSetMicGainResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrSetPassThroughMode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetPassThroughModeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrSetPassThroughMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrSetPassThroughModeError> payload = ::boost::static_pointer_cast<EcnrSetPassThroughModeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrSetPassThroughModeCallbackIF*) _callback)->onEcnrSetPassThroughModeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetPassThroughModeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrSetPassThroughMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrSetPassThroughModeResponse> payload = ::boost::static_pointer_cast<EcnrSetPassThroughModeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrSetPassThroughModeCallbackIF*) _callback)->onEcnrSetPassThroughModeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrSetNRCombFloor:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetNRCombFloorError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrSetNRCombFloor", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrSetNRCombFloorError> payload = ::boost::static_pointer_cast<EcnrSetNRCombFloorError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrSetNRCombFloorCallbackIF*) _callback)->onEcnrSetNRCombFloorError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetNRCombFloorResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrSetNRCombFloor", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrSetNRCombFloorResponse> payload = ::boost::static_pointer_cast<EcnrSetNRCombFloorResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrSetNRCombFloorCallbackIF*) _callback)->onEcnrSetNRCombFloorResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrSetEchoCancellation:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetEchoCancellationError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrSetEchoCancellation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrSetEchoCancellationError> payload = ::boost::static_pointer_cast<EcnrSetEchoCancellationError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrSetEchoCancellationCallbackIF*) _callback)->onEcnrSetEchoCancellationError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetEchoCancellationResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrSetEchoCancellation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrSetEchoCancellationResponse> payload = ::boost::static_pointer_cast<EcnrSetEchoCancellationResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrSetEchoCancellationCallbackIF*) _callback)->onEcnrSetEchoCancellationResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrSetNoiseReduction:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetNoiseReductionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrSetNoiseReduction", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrSetNoiseReductionError> payload = ::boost::static_pointer_cast<EcnrSetNoiseReductionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrSetNoiseReductionCallbackIF*) _callback)->onEcnrSetNoiseReductionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrSetNoiseReductionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrSetNoiseReduction", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrSetNoiseReductionResponse> payload = ::boost::static_pointer_cast<EcnrSetNoiseReductionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrSetNoiseReductionCallbackIF*) _callback)->onEcnrSetNoiseReductionResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrGetEngineParameter:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrGetEngineParameterError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrGetEngineParameter", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrGetEngineParameterError> payload = ::boost::static_pointer_cast<EcnrGetEngineParameterError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrGetEngineParameterCallbackIF*) _callback)->onEcnrGetEngineParameterError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrGetEngineParameterResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrGetEngineParameter", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrGetEngineParameterResponse> payload = ::boost::static_pointer_cast<EcnrGetEngineParameterResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrGetEngineParameterCallbackIF*) _callback)->onEcnrGetEngineParameterResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ecnrStartItcTest:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EcnrStartItcTestError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrStartItcTest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrStartItcTestError> payload = ::boost::static_pointer_cast<EcnrStartItcTestError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrStartItcTestCallbackIF*) _callback)->onEcnrStartItcTestError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrStartItcTestResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EcnrStartItcTest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EcnrStartItcTestResponse> payload = ::boost::static_pointer_cast<EcnrStartItcTestResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EcnrStartItcTestCallbackIF*) _callback)->onEcnrStartItcTestResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_ecnrAsrModeEnable: {
                ::boost::shared_ptr< EcnrAsrModeEnableError > payload = ::boost::shared_ptr< EcnrAsrModeEnableError >
                (new EcnrAsrModeEnableError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrAsrModeEnable", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrAsrModeEnableCallbackIF*) _callback)->onEcnrAsrModeEnableError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrAudioStatus: {
                ::boost::shared_ptr< EcnrAudioStatusError > payload = ::boost::shared_ptr< EcnrAudioStatusError >
                (new EcnrAudioStatusError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrAudioStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrAudioStatusCallbackIF*) _callback)->onEcnrAudioStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrMicroLevelStatus: {
                ::boost::shared_ptr< EcnrMicroLevelStatusError > payload = ::boost::shared_ptr< EcnrMicroLevelStatusError >
                (new EcnrMicroLevelStatusError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrMicroLevelStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrMicroLevelStatusCallbackIF*) _callback)->onEcnrMicroLevelStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrMicLvlNtfyInterval: {
                ::boost::shared_ptr< EcnrMicLvlNtfyIntervalError > payload = ::boost::shared_ptr< EcnrMicLvlNtfyIntervalError >
                (new EcnrMicLvlNtfyIntervalError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrMicLvlNtfyInterval", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrMicLvlNtfyIntervalCallbackIF*) _callback)->onEcnrMicLvlNtfyIntervalError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrAsrMode: {
                ::boost::shared_ptr< EcnrAsrModeError > payload = ::boost::shared_ptr< EcnrAsrModeError >
                (new EcnrAsrModeError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrAsrMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrAsrModeCallbackIF*) _callback)->onEcnrAsrModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrAudioState: {
                ::boost::shared_ptr< EcnrAudioStateError > payload = ::boost::shared_ptr< EcnrAudioStateError >
                (new EcnrAudioStateError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrAudioState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrAudioStateCallbackIF*) _callback)->onEcnrAudioStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrAsrDataType: {
                ::boost::shared_ptr< EcnrAsrDataTypeError > payload = ::boost::shared_ptr< EcnrAsrDataTypeError >
                (new EcnrAsrDataTypeError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrAsrDataType", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrAsrDataTypeCallbackIF*) _callback)->onEcnrAsrDataTypeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrGetVersion: {
                ::boost::shared_ptr< EcnrGetVersionError > payload = ::boost::shared_ptr< EcnrGetVersionError >
                (new EcnrGetVersionError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrGetVersion", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrGetVersionCallbackIF*) _callback)->onEcnrGetVersionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrGetStatusMessage: {
                ::boost::shared_ptr< EcnrGetStatusMessageError > payload = ::boost::shared_ptr< EcnrGetStatusMessageError >
                (new EcnrGetStatusMessageError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrGetStatusMessage", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrGetStatusMessageCallbackIF*) _callback)->onEcnrGetStatusMessageError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrInitialize: {
                ::boost::shared_ptr< EcnrInitializeError > payload = ::boost::shared_ptr< EcnrInitializeError >
                (new EcnrInitializeError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrInitialize", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrInitializeCallbackIF*) _callback)->onEcnrInitializeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrInitializeSync: {
                ::boost::shared_ptr< EcnrInitializeSyncError > payload = ::boost::shared_ptr< EcnrInitializeSyncError >
                (new EcnrInitializeSyncError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrInitializeSync", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrInitializeSyncCallbackIF*) _callback)->onEcnrInitializeSyncError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrReset: {
                ::boost::shared_ptr< EcnrResetError > payload = ::boost::shared_ptr< EcnrResetError >
                (new EcnrResetError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrReset", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrResetCallbackIF*) _callback)->onEcnrResetError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrDestroy: {
                ::boost::shared_ptr< EcnrDestroyError > payload = ::boost::shared_ptr< EcnrDestroyError >
                (new EcnrDestroyError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrDestroy", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrDestroyCallbackIF*) _callback)->onEcnrDestroyError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrTerminate: {
                ::boost::shared_ptr< EcnrTerminateError > payload = ::boost::shared_ptr< EcnrTerminateError >
                (new EcnrTerminateError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrTerminate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrTerminateCallbackIF*) _callback)->onEcnrTerminateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrSetConfiguration: {
                ::boost::shared_ptr< EcnrSetConfigurationError > payload = ::boost::shared_ptr< EcnrSetConfigurationError >
                (new EcnrSetConfigurationError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrSetConfiguration", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrSetConfigurationCallbackIF*) _callback)->onEcnrSetConfigurationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrSetConfigurationSync: {
                ::boost::shared_ptr< EcnrSetConfigurationSyncError > payload = ::boost::shared_ptr< EcnrSetConfigurationSyncError >
                (new EcnrSetConfigurationSyncError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrSetConfigurationSync", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrSetConfigurationSyncCallbackIF*) _callback)->onEcnrSetConfigurationSyncError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrGetEcnrConfiguration: {
                ::boost::shared_ptr< EcnrGetEcnrConfigurationError > payload = ::boost::shared_ptr< EcnrGetEcnrConfigurationError >
                (new EcnrGetEcnrConfigurationError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrGetEcnrConfiguration", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrGetEcnrConfigurationCallbackIF*) _callback)->onEcnrGetEcnrConfigurationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrStartAudio: {
                ::boost::shared_ptr< EcnrStartAudioError > payload = ::boost::shared_ptr< EcnrStartAudioError >
                (new EcnrStartAudioError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrStartAudio", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrStartAudioCallbackIF*) _callback)->onEcnrStartAudioError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrStartAudioExt: {
                ::boost::shared_ptr< EcnrStartAudioExtError > payload = ::boost::shared_ptr< EcnrStartAudioExtError >
                (new EcnrStartAudioExtError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrStartAudioExt", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrStartAudioExtCallbackIF*) _callback)->onEcnrStartAudioExtError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrStopAudio: {
                ::boost::shared_ptr< EcnrStopAudioError > payload = ::boost::shared_ptr< EcnrStopAudioError >
                (new EcnrStopAudioError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrStopAudio", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrStopAudioCallbackIF*) _callback)->onEcnrStopAudioError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrFrameInfo: {
                ::boost::shared_ptr< EcnrFrameInfoError > payload = ::boost::shared_ptr< EcnrFrameInfoError >
                (new EcnrFrameInfoError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrFrameInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrFrameInfoCallbackIF*) _callback)->onEcnrFrameInfoError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrMicClipStats: {
                ::boost::shared_ptr< EcnrMicClipStatsError > payload = ::boost::shared_ptr< EcnrMicClipStatsError >
                (new EcnrMicClipStatsError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrMicClipStats", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrMicClipStatsCallbackIF*) _callback)->onEcnrMicClipStatsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrRefClipStats: {
                ::boost::shared_ptr< EcnrRefClipStatsError > payload = ::boost::shared_ptr< EcnrRefClipStatsError >
                (new EcnrRefClipStatsError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrRefClipStats", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrRefClipStatsCallbackIF*) _callback)->onEcnrRefClipStatsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrRecvClipStats: {
                ::boost::shared_ptr< EcnrRecvClipStatsError > payload = ::boost::shared_ptr< EcnrRecvClipStatsError >
                (new EcnrRecvClipStatsError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrRecvClipStats", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrRecvClipStatsCallbackIF*) _callback)->onEcnrRecvClipStatsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrMicOutClipStats: {
                ::boost::shared_ptr< EcnrMicOutClipStatsError > payload = ::boost::shared_ptr< EcnrMicOutClipStatsError >
                (new EcnrMicOutClipStatsError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrMicOutClipStats", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrMicOutClipStatsCallbackIF*) _callback)->onEcnrMicOutClipStatsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrRecvOutClipStats: {
                ::boost::shared_ptr< EcnrRecvOutClipStatsError > payload = ::boost::shared_ptr< EcnrRecvOutClipStatsError >
                (new EcnrRecvOutClipStatsError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrRecvOutClipStats", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrRecvOutClipStatsCallbackIF*) _callback)->onEcnrRecvOutClipStatsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrSetSendMuteSwitch: {
                ::boost::shared_ptr< EcnrSetSendMuteSwitchError > payload = ::boost::shared_ptr< EcnrSetSendMuteSwitchError >
                (new EcnrSetSendMuteSwitchError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrSetSendMuteSwitch", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrSetSendMuteSwitchCallbackIF*) _callback)->onEcnrSetSendMuteSwitchError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrSetSendGainDelta: {
                ::boost::shared_ptr< EcnrSetSendGainDeltaError > payload = ::boost::shared_ptr< EcnrSetSendGainDeltaError >
                (new EcnrSetSendGainDeltaError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrSetSendGainDelta", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrSetSendGainDeltaCallbackIF*) _callback)->onEcnrSetSendGainDeltaError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrSetMicGain: {
                ::boost::shared_ptr< EcnrSetMicGainError > payload = ::boost::shared_ptr< EcnrSetMicGainError >
                (new EcnrSetMicGainError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrSetMicGain", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrSetMicGainCallbackIF*) _callback)->onEcnrSetMicGainError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrSetPassThroughMode: {
                ::boost::shared_ptr< EcnrSetPassThroughModeError > payload = ::boost::shared_ptr< EcnrSetPassThroughModeError >
                (new EcnrSetPassThroughModeError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrSetPassThroughMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrSetPassThroughModeCallbackIF*) _callback)->onEcnrSetPassThroughModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrSetNRCombFloor: {
                ::boost::shared_ptr< EcnrSetNRCombFloorError > payload = ::boost::shared_ptr< EcnrSetNRCombFloorError >
                (new EcnrSetNRCombFloorError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrSetNRCombFloor", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrSetNRCombFloorCallbackIF*) _callback)->onEcnrSetNRCombFloorError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrSetEchoCancellation: {
                ::boost::shared_ptr< EcnrSetEchoCancellationError > payload = ::boost::shared_ptr< EcnrSetEchoCancellationError >
                (new EcnrSetEchoCancellationError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrSetEchoCancellation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrSetEchoCancellationCallbackIF*) _callback)->onEcnrSetEchoCancellationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrSetNoiseReduction: {
                ::boost::shared_ptr< EcnrSetNoiseReductionError > payload = ::boost::shared_ptr< EcnrSetNoiseReductionError >
                (new EcnrSetNoiseReductionError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrSetNoiseReduction", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrSetNoiseReductionCallbackIF*) _callback)->onEcnrSetNoiseReductionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrGetEngineParameter: {
                ::boost::shared_ptr< EcnrGetEngineParameterError > payload = ::boost::shared_ptr< EcnrGetEngineParameterError >
                (new EcnrGetEngineParameterError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrGetEngineParameter", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrGetEngineParameterCallbackIF*) _callback)->onEcnrGetEngineParameterError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ecnrStartItcTest: {
                ::boost::shared_ptr< EcnrStartItcTestError > payload = ::boost::shared_ptr< EcnrStartItcTestError >
                (new EcnrStartItcTestError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EcnrStartItcTest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EcnrStartItcTestCallbackIF*) _callback)->onEcnrStartItcTestError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& ServiceProxyCallback::_logger (ServiceProxy::_logger);

ServiceProxy::ServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.ecnr.service", serviceAvailable, _logger) {
}

ServiceProxy::~ServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< ServiceProxy > ServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<ServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< ServiceProxy > proxyNew(new ServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t ServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    ServiceProxyCallback* callback = new ServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t ServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    ServiceProxyCallback* callback = new ServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ServiceProxy::clearAllProperties ()
{
    _ecnrMicLvlNtfyInterval = ::asf::core::nullable< EcnrMicLvlNtfyIntervalUpdate >();
    _ecnrAsrMode = ::asf::core::nullable< EcnrAsrModeUpdate >();
    _ecnrAudioState = ::asf::core::nullable< EcnrAudioStateUpdate >();
    _ecnrAsrDataType = ::asf::core::nullable< EcnrAsrDataTypeUpdate >();
}

void ServiceProxy::sendDeregisterAll () const
{
    sendEcnrMicLvlNtfyIntervalDeregisterAll();
    sendEcnrAsrModeDeregisterAll();
    sendEcnrAudioStateDeregisterAll();
    sendEcnrAsrDataTypeDeregisterAll();
    sendEcnrAsrModeEnableDeregisterAll();
    sendEcnrAudioStatusDeregisterAll();
    sendEcnrMicroLevelStatusDeregisterAll();
}

act_t ServiceProxy::sendEcnrAsrModeEnableRegister(EcnrAsrModeEnableCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ecnrAsrModeEnable");
    act_t act = addSignalCallback(ID_ecnrAsrModeEnable, "ecnrAsrModeEnable", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EcnrAsrModeEnable", &cb, act);
    return act;
}

bool ServiceProxy::sendEcnrAsrModeEnableDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ecnrAsrModeEnable", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EcnrAsrModeEnable", act, static_cast<int>(rv));
    return rv;
}

void ServiceProxy::sendEcnrAsrModeEnableDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EcnrAsrModeEnable");
    _dbusProxyDelegate->deregisterSignalCallback("ecnrAsrModeEnable", 0, _dbusDaemonProxy.get(), false);
}

act_t ServiceProxy::sendEcnrAudioStatusRegister(EcnrAudioStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ecnrAudioStatus");
    act_t act = addSignalCallback(ID_ecnrAudioStatus, "ecnrAudioStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EcnrAudioStatus", &cb, act);
    return act;
}

bool ServiceProxy::sendEcnrAudioStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ecnrAudioStatus", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EcnrAudioStatus", act, static_cast<int>(rv));
    return rv;
}

void ServiceProxy::sendEcnrAudioStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EcnrAudioStatus");
    _dbusProxyDelegate->deregisterSignalCallback("ecnrAudioStatus", 0, _dbusDaemonProxy.get(), false);
}

act_t ServiceProxy::sendEcnrMicroLevelStatusRegister(EcnrMicroLevelStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ecnrMicroLevelStatus");
    act_t act = addSignalCallback(ID_ecnrMicroLevelStatus, "ecnrMicroLevelStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EcnrMicroLevelStatus", &cb, act);
    return act;
}

bool ServiceProxy::sendEcnrMicroLevelStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ecnrMicroLevelStatus", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EcnrMicroLevelStatus", act, static_cast<int>(rv));
    return rv;
}

void ServiceProxy::sendEcnrMicroLevelStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EcnrMicroLevelStatus");
    _dbusProxyDelegate->deregisterSignalCallback("ecnrMicroLevelStatus", 0, _dbusDaemonProxy.get(), false);
}

act_t ServiceProxy::sendEcnrMicLvlNtfyIntervalRegister(EcnrMicLvlNtfyIntervalCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ecnrMicLvlNtfyInterval, "ecnrMicLvlNtfyInterval", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EcnrMicLvlNtfyInterval", &cb, act);
    return act;
}

bool ServiceProxy::sendEcnrMicLvlNtfyIntervalDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ecnrMicLvlNtfyInterval", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EcnrMicLvlNtfyInterval", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendEcnrMicLvlNtfyIntervalGet(EcnrMicLvlNtfyIntervalCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ecnrMicLvlNtfyInterval, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "EcnrMicLvlNtfyInterval", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ecnrMicLvlNtfyInterval", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ServiceProxy::sendEcnrMicLvlNtfyIntervalSet(uint32 ecnrMicLvlNtfyInterval) {
    EcnrMicLvlNtfyIntervalSet parameter(ecnrMicLvlNtfyInterval);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "EcnrMicLvlNtfyInterval");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "ecnrMicLvlNtfyInterval", propertyContent);
}

act_t ServiceProxy::sendEcnrMicLvlNtfyIntervalSet(EcnrMicLvlNtfyIntervalCallbackIF& cb, uint32 ecnrMicLvlNtfyInterval) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ecnrMicLvlNtfyInterval, &cb);
    EcnrMicLvlNtfyIntervalSet parameter(ecnrMicLvlNtfyInterval);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "EcnrMicLvlNtfyInterval", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "ecnrMicLvlNtfyInterval", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

uint32 ServiceProxy::getEcnrMicLvlNtfyInterval() const {
    return _ecnrMicLvlNtfyInterval.get().getEcnrMicLvlNtfyInterval();
}

bool ServiceProxy::hasEcnrMicLvlNtfyInterval() const {
    return _ecnrMicLvlNtfyInterval.hasValue();
}

void ServiceProxy::sendEcnrMicLvlNtfyIntervalDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EcnrMicLvlNtfyInterval");
    _dbusProxyDelegate->deregisterSignalCallback("ecnrMicLvlNtfyInterval", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendEcnrAsrModeRegister(EcnrAsrModeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ecnrAsrMode, "ecnrAsrMode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EcnrAsrMode", &cb, act);
    return act;
}

bool ServiceProxy::sendEcnrAsrModeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ecnrAsrMode", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EcnrAsrMode", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendEcnrAsrModeGet(EcnrAsrModeCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ecnrAsrMode, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "EcnrAsrMode", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ecnrAsrMode", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


int32 ServiceProxy::getEcnrAsrMode() const {
    return _ecnrAsrMode.get().getEcnrAsrMode();
}

bool ServiceProxy::hasEcnrAsrMode() const {
    return _ecnrAsrMode.hasValue();
}

void ServiceProxy::sendEcnrAsrModeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EcnrAsrMode");
    _dbusProxyDelegate->deregisterSignalCallback("ecnrAsrMode", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendEcnrAudioStateRegister(EcnrAudioStateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ecnrAudioState, "ecnrAudioState", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EcnrAudioState", &cb, act);
    return act;
}

bool ServiceProxy::sendEcnrAudioStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ecnrAudioState", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EcnrAudioState", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendEcnrAudioStateGet(EcnrAudioStateCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ecnrAudioState, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "EcnrAudioState", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ecnrAudioState", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


int32 ServiceProxy::getEcnrAudioState() const {
    return _ecnrAudioState.get().getEcnrAudioState();
}

bool ServiceProxy::hasEcnrAudioState() const {
    return _ecnrAudioState.hasValue();
}

void ServiceProxy::sendEcnrAudioStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EcnrAudioState");
    _dbusProxyDelegate->deregisterSignalCallback("ecnrAudioState", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendEcnrAsrDataTypeRegister(EcnrAsrDataTypeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ecnrAsrDataType, "ecnrAsrDataType", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EcnrAsrDataType", &cb, act);
    return act;
}

bool ServiceProxy::sendEcnrAsrDataTypeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ecnrAsrDataType", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EcnrAsrDataType", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendEcnrAsrDataTypeGet(EcnrAsrDataTypeCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ecnrAsrDataType, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "EcnrAsrDataType", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ecnrAsrDataType", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< uint8 >& ServiceProxy::getEcnrAsrDataType() const {
    return _ecnrAsrDataType.get().getEcnrAsrDataType();
}

bool ServiceProxy::hasEcnrAsrDataType() const {
    return _ecnrAsrDataType.hasValue();
}

void ServiceProxy::sendEcnrAsrDataTypeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EcnrAsrDataType");
    _dbusProxyDelegate->deregisterSignalCallback("ecnrAsrDataType", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendEcnrGetVersionRequest(EcnrGetVersionCallbackIF& cb) const {
    EcnrGetVersionRequest* payload = new EcnrGetVersionRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrGetVersion", EcnrGetVersionRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrGetVersion, dbusMessage.getUniqueSerial(), "ecnrGetVersion", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrGetVersion", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrGetStatusMessageRequest(EcnrGetStatusMessageCallbackIF& cb, uint8 ecnrAppId) const {
    EcnrGetStatusMessageRequest* payload = new EcnrGetStatusMessageRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrAppId(ecnrAppId);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrGetStatusMessage", EcnrGetStatusMessageRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrGetStatusMessage, dbusMessage.getUniqueSerial(), "ecnrGetStatusMessage", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrGetStatusMessage", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrInitializeRequest(EcnrInitializeCallbackIF& cb, uint8 ecnrAppId, uint32 ecnrConfigurationId) const {
    EcnrInitializeRequest* payload = new EcnrInitializeRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrAppId(ecnrAppId);
    payload->setEcnrConfigurationId(ecnrConfigurationId);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrInitialize", EcnrInitializeRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrInitialize, dbusMessage.getUniqueSerial(), "ecnrInitialize", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrInitialize", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrInitializeSyncRequest(EcnrInitializeSyncCallbackIF& cb, uint8 ecnrAppId, uint32 ecnrConfigurationId) const {
    EcnrInitializeSyncRequest* payload = new EcnrInitializeSyncRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrAppId(ecnrAppId);
    payload->setEcnrConfigurationId(ecnrConfigurationId);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrInitializeSync", EcnrInitializeSyncRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrInitializeSync, dbusMessage.getUniqueSerial(), "ecnrInitializeSync", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrInitializeSync", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrResetRequest(EcnrResetCallbackIF& cb, uint8 ecnrAppId) const {
    EcnrResetRequest* payload = new EcnrResetRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrAppId(ecnrAppId);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrReset", EcnrResetRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrReset, dbusMessage.getUniqueSerial(), "ecnrReset", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrReset", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrDestroyRequest(EcnrDestroyCallbackIF& cb, uint8 ecnrAppId) const {
    EcnrDestroyRequest* payload = new EcnrDestroyRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrAppId(ecnrAppId);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrDestroy", EcnrDestroyRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrDestroy, dbusMessage.getUniqueSerial(), "ecnrDestroy", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrDestroy", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrTerminateRequest(EcnrTerminateCallbackIF& cb, uint8 ecnrAppId) const {
    EcnrTerminateRequest* payload = new EcnrTerminateRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrAppId(ecnrAppId);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrTerminate", EcnrTerminateRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrTerminate, dbusMessage.getUniqueSerial(), "ecnrTerminate", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrTerminate", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrSetConfigurationRequest(EcnrSetConfigurationCallbackIF& cb, uint8 ecnrAppId, uint32 ecnrConfigurationId) const {
    EcnrSetConfigurationRequest* payload = new EcnrSetConfigurationRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrAppId(ecnrAppId);
    payload->setEcnrConfigurationId(ecnrConfigurationId);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrSetConfiguration", EcnrSetConfigurationRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrSetConfiguration, dbusMessage.getUniqueSerial(), "ecnrSetConfiguration", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrSetConfiguration", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrSetConfigurationSyncRequest(EcnrSetConfigurationSyncCallbackIF& cb, uint8 ecnrAppId, uint32 ecnrConfigurationId) const {
    EcnrSetConfigurationSyncRequest* payload = new EcnrSetConfigurationSyncRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrAppId(ecnrAppId);
    payload->setEcnrConfigurationId(ecnrConfigurationId);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrSetConfigurationSync", EcnrSetConfigurationSyncRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrSetConfigurationSync, dbusMessage.getUniqueSerial(), "ecnrSetConfigurationSync", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrSetConfigurationSync", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrGetEcnrConfigurationRequest(EcnrGetEcnrConfigurationCallbackIF& cb) const {
    EcnrGetEcnrConfigurationRequest* payload = new EcnrGetEcnrConfigurationRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrGetEcnrConfiguration", EcnrGetEcnrConfigurationRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrGetEcnrConfiguration, dbusMessage.getUniqueSerial(), "ecnrGetEcnrConfiguration", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrGetEcnrConfiguration", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrStartAudioRequest(EcnrStartAudioCallbackIF& cb, uint8 ecnrAppId) const {
    EcnrStartAudioRequest* payload = new EcnrStartAudioRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrAppId(ecnrAppId);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrStartAudio", EcnrStartAudioRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrStartAudio, dbusMessage.getUniqueSerial(), "ecnrStartAudio", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrStartAudio", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrStartAudioExtRequest(EcnrStartAudioExtCallbackIF& cb, uint8 ecnrAppId, uint8 startMode) const {
    EcnrStartAudioExtRequest* payload = new EcnrStartAudioExtRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrAppId(ecnrAppId);
    payload->setStartMode(startMode);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrStartAudioExt", EcnrStartAudioExtRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrStartAudioExt, dbusMessage.getUniqueSerial(), "ecnrStartAudioExt", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrStartAudioExt", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrStopAudioRequest(EcnrStopAudioCallbackIF& cb, uint8 ecnrAppId) const {
    EcnrStopAudioRequest* payload = new EcnrStopAudioRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrAppId(ecnrAppId);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrStopAudio", EcnrStopAudioRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrStopAudio, dbusMessage.getUniqueSerial(), "ecnrStopAudio", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrStopAudio", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrFrameInfoRequest(EcnrFrameInfoCallbackIF& cb) const {
    EcnrFrameInfoRequest* payload = new EcnrFrameInfoRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrFrameInfo", EcnrFrameInfoRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrFrameInfo, dbusMessage.getUniqueSerial(), "ecnrFrameInfo", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrFrameInfo", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrMicClipStatsRequest(EcnrMicClipStatsCallbackIF& cb, int32 channel) const {
    EcnrMicClipStatsRequest* payload = new EcnrMicClipStatsRequest();
    CHECK_ALLOCATION(payload);
    payload->setChannel(channel);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrMicClipStats", EcnrMicClipStatsRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrMicClipStats, dbusMessage.getUniqueSerial(), "ecnrMicClipStats", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrMicClipStats", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrRefClipStatsRequest(EcnrRefClipStatsCallbackIF& cb) const {
    EcnrRefClipStatsRequest* payload = new EcnrRefClipStatsRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrRefClipStats", EcnrRefClipStatsRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrRefClipStats, dbusMessage.getUniqueSerial(), "ecnrRefClipStats", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrRefClipStats", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrRecvClipStatsRequest(EcnrRecvClipStatsCallbackIF& cb) const {
    EcnrRecvClipStatsRequest* payload = new EcnrRecvClipStatsRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrRecvClipStats", EcnrRecvClipStatsRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrRecvClipStats, dbusMessage.getUniqueSerial(), "ecnrRecvClipStats", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrRecvClipStats", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrMicOutClipStatsRequest(EcnrMicOutClipStatsCallbackIF& cb) const {
    EcnrMicOutClipStatsRequest* payload = new EcnrMicOutClipStatsRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrMicOutClipStats", EcnrMicOutClipStatsRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrMicOutClipStats, dbusMessage.getUniqueSerial(), "ecnrMicOutClipStats", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrMicOutClipStats", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrRecvOutClipStatsRequest(EcnrRecvOutClipStatsCallbackIF& cb) const {
    EcnrRecvOutClipStatsRequest* payload = new EcnrRecvOutClipStatsRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrRecvOutClipStats", EcnrRecvOutClipStatsRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrRecvOutClipStats, dbusMessage.getUniqueSerial(), "ecnrRecvOutClipStats", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrRecvOutClipStats", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrSetSendMuteSwitchRequest(EcnrSetSendMuteSwitchCallbackIF& cb, uint8 ecnrAppId, uint8 ecnrSendMuteSwitch) const {
    EcnrSetSendMuteSwitchRequest* payload = new EcnrSetSendMuteSwitchRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrAppId(ecnrAppId);
    payload->setEcnrSendMuteSwitch(ecnrSendMuteSwitch);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrSetSendMuteSwitch", EcnrSetSendMuteSwitchRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrSetSendMuteSwitch, dbusMessage.getUniqueSerial(), "ecnrSetSendMuteSwitch", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrSetSendMuteSwitch", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrSetSendGainDeltaRequest(EcnrSetSendGainDeltaCallbackIF& cb, uint8 ecnrAppId, int16 ecnrLevel) const {
    EcnrSetSendGainDeltaRequest* payload = new EcnrSetSendGainDeltaRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrAppId(ecnrAppId);
    payload->setEcnrLevel(ecnrLevel);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrSetSendGainDelta", EcnrSetSendGainDeltaRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrSetSendGainDelta, dbusMessage.getUniqueSerial(), "ecnrSetSendGainDelta", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrSetSendGainDelta", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrSetMicGainRequest(EcnrSetMicGainCallbackIF& cb, int32 micGainLevel) const {
    EcnrSetMicGainRequest* payload = new EcnrSetMicGainRequest();
    CHECK_ALLOCATION(payload);
    payload->setMicGainLevel(micGainLevel);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrSetMicGain", EcnrSetMicGainRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrSetMicGain, dbusMessage.getUniqueSerial(), "ecnrSetMicGain", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrSetMicGain", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrSetPassThroughModeRequest(EcnrSetPassThroughModeCallbackIF& cb, uint8 ecnrAppId, uint8 ecnrPassThroughMode) const {
    EcnrSetPassThroughModeRequest* payload = new EcnrSetPassThroughModeRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrAppId(ecnrAppId);
    payload->setEcnrPassThroughMode(ecnrPassThroughMode);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrSetPassThroughMode", EcnrSetPassThroughModeRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrSetPassThroughMode, dbusMessage.getUniqueSerial(), "ecnrSetPassThroughMode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrSetPassThroughMode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrSetNRCombFloorRequest(EcnrSetNRCombFloorCallbackIF& cb, uint8 ecnrAppId, int16 ecnrNRCombFloor) const {
    EcnrSetNRCombFloorRequest* payload = new EcnrSetNRCombFloorRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrAppId(ecnrAppId);
    payload->setEcnrNRCombFloor(ecnrNRCombFloor);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrSetNRCombFloor", EcnrSetNRCombFloorRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrSetNRCombFloor, dbusMessage.getUniqueSerial(), "ecnrSetNRCombFloor", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrSetNRCombFloor", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrSetEchoCancellationRequest(EcnrSetEchoCancellationCallbackIF& cb, uint8 ecnrAppId, uint8 ecnrECState) const {
    EcnrSetEchoCancellationRequest* payload = new EcnrSetEchoCancellationRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrAppId(ecnrAppId);
    payload->setEcnrECState(ecnrECState);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrSetEchoCancellation", EcnrSetEchoCancellationRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrSetEchoCancellation, dbusMessage.getUniqueSerial(), "ecnrSetEchoCancellation", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrSetEchoCancellation", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrSetNoiseReductionRequest(EcnrSetNoiseReductionCallbackIF& cb, uint8 ecnrAppId, uint8 ecnrNRState) const {
    EcnrSetNoiseReductionRequest* payload = new EcnrSetNoiseReductionRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrAppId(ecnrAppId);
    payload->setEcnrNRState(ecnrNRState);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrSetNoiseReduction", EcnrSetNoiseReductionRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrSetNoiseReduction, dbusMessage.getUniqueSerial(), "ecnrSetNoiseReduction", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrSetNoiseReduction", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrGetEngineParameterRequest(EcnrGetEngineParameterCallbackIF& cb, uint32 ecnrParameterId) const {
    EcnrGetEngineParameterRequest* payload = new EcnrGetEngineParameterRequest();
    CHECK_ALLOCATION(payload);
    payload->setEcnrParameterId(ecnrParameterId);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrGetEngineParameter", EcnrGetEngineParameterRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrGetEngineParameter, dbusMessage.getUniqueSerial(), "ecnrGetEngineParameter", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrGetEngineParameter", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendEcnrStartItcTestRequest(EcnrStartItcTestCallbackIF& cb, int32 iTCValue) const {
    EcnrStartItcTestRequest* payload = new EcnrStartItcTestRequest();
    CHECK_ALLOCATION(payload);
    payload->setITCValue(iTCValue);
    DBUS_MESSAGE_CALL(dbusMessage, "ecnrStartItcTest", EcnrStartItcTestRequest, payload, true)
    act_t act = addMethodCallback(ID_ecnrStartItcTest, dbusMessage.getUniqueSerial(), "ecnrStartItcTest", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EcnrStartItcTest", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace service
} // namespace ecnr
} // namespace bosch
} // namespace org
